/*
 * Decompiled with CFR 0.152.
 */
package com.tencent;

import android.os.Environment;
import android.text.TextUtils;
import com.tencent.IMCoreAvInviteCallBack;
import com.tencent.IMCoreGroupEventCallback;
import com.tencent.IMCoreLogMsgCallback;
import com.tencent.IMCoreNotify;
import com.tencent.IMCoreUserConfig;
import com.tencent.IMFunc;
import com.tencent.TIMCallBack;
import com.tencent.TIMLogLevel;
import com.tencent.TIMLogListener;
import com.tencent.TIMManager;
import com.tencent.ar;
import com.tencent.be;
import com.tencent.imcore.Context;
import com.tencent.imcore.FileTranser;
import com.tencent.imcore.ILogMsgCallback;
import com.tencent.imcore.IMCore;
import com.tencent.imcore.IMCoreUser;
import com.tencent.imcore.internalJNI;
import com.tencent.imsdk.IMMsfCoreProxy;
import com.tencent.imsdk.IMMsfUserInfo;
import com.tencent.imsdk.QLog;
import com.tencent.qalsdk.QALSDKManager;
import com.tencent.tesla.soload.SoLoadCore;
import java.io.File;
import java.util.Map;
import tencent.tls.platform.TLSLoginHelper;

public class IMCoreWrapper {
    private static final String tag = "imsdk.IMCoreWrapper";
    private String logPath = "";
    private String logFileName = "imsdk";
    private String picCachePath = "";
    private String videoCachePath = "";
    private String fileCachePath = "";
    private String soLibPath = "";
    private TIMLogLevel logLevel = TIMLogLevel.DEBUG;
    private boolean isLogInited = false;
    private boolean isLogPrintEnabled = true;
    private boolean ready = false;
    static IMCoreWrapper inst = new IMCoreWrapper();

    public boolean isLogInited() {
        return this.isLogInited;
    }

    public void setLogInited() {
        this.isLogInited = true;
    }

    public boolean isLogPrintEnabled() {
        return this.isLogPrintEnabled;
    }

    public void setIsLogPrintEnabled(boolean bl2) {
        this.isLogPrintEnabled = bl2;
    }

    private IMCoreWrapper() {
    }

    public String getGateWayIp() {
        String string = QALSDKManager.getInstance().getGatewayIp();
        if (string != null) {
            return string;
        }
        return "";
    }

    public boolean isReady() {
        return this.ready;
    }

    public void setReady(boolean bl2) {
        this.ready = bl2;
    }

    public static IMCoreWrapper get() {
        return inst;
    }

    public boolean loadLib() {
        return this.loadLib(false);
    }

    public boolean loadLib(boolean bl2) {
        QLog.i(tag, 1, "LoadLibrary|1-Begin|succ");
        try {
            if (TextUtils.isEmpty((CharSequence)this.soLibPath)) {
                System.loadLibrary("_imcore_jni_gyp");
                QLog.i(tag, 1, "LoadLibrary|2-Loading|system load succ");
            } else {
                System.load(this.soLibPath + "lib_imcore_jni_gyp.so");
                QLog.i(tag, 1, "LoadLibrary|2-Loading|system load succ, from [" + this.soLibPath + "]");
            }
        }
        catch (Throwable throwable) {
            QLog.e(tag, 1, "LoadLibrary|2-Loading|system load failed" + IMFunc.getExceptionInfo(throwable));
            long l = SoLoadCore.loadSo((android.content.Context)IMMsfCoreProxy.get().getContext().getApplicationContext(), (String)"_imcore_jni_gyp");
            if ((l & 2L) == 0L && (l & 0x40000L) == 0L) {
                QLog.e(tag, 1, "LoadLibrary|2-Loading|manual load failed, ret = " + l + "|setMode 0");
                TIMManager.getInstance().setMode(0);
                return false;
            }
            QLog.i(tag, 1, "LoadLibrary|2-Loading|manual load succ");
        }
        try {
            internalJNI.new_IGetMsgs();
            internalJNI.new_ISendMsg();
            internalJNI.new_INotify();
            internalJNI.IMCore_get();
            internalJNI.new_Context();
            internalJNI.new_IGroupNotifyCallback();
            internalJNI.new_IEnv();
            internalJNI.new_SdkReportItem();
            QLog.i(tag, 1, "LoadLibrary|3-MethodTest|succ");
        }
        catch (Throwable throwable) {
            QLog.e(tag, 1, IMFunc.getExceptionInfo(throwable));
            QLog.i(tag, 1, "LoadLibrary|3-MethodTest|failed, setMode 0");
            TIMManager.getInstance().setMode(0);
            return false;
        }
        QLog.i(tag, 1, "LoadLibrary|4-End|succ");
        return true;
    }

    public void initPicCachePath(android.content.Context object) {
        try {
            object = object.getPackageName();
        }
        catch (Exception exception) {
            object = "unknown";
        }
        this.picCachePath = Environment.getExternalStorageDirectory().getPath() + "/tencent/imsdkpiccache/" + ((String)object).replace(".", "/") + "/";
        object = new File(this.picCachePath);
        if (!((File)object).exists() && !((File)object).mkdirs()) {
            QLog.d(tag, 1, "create imsdkpiccache folder failed");
        }
    }

    public void initVideoCachePath(android.content.Context object) {
        try {
            object = object.getPackageName();
        }
        catch (Exception exception) {
            object = "unknown";
        }
        this.videoCachePath = Environment.getExternalStorageDirectory().getPath() + "/tencent/imsdkvideocache/" + ((String)object).replace(".", "/") + "/";
        object = new File(this.videoCachePath);
        if (!((File)object).exists()) {
            if (!((File)object).mkdirs()) {
                QLog.d(tag, 1, "create imsdkvideocache folder failed");
                return;
            }
        } else if (((File)object).isDirectory()) {
            if ((object = ((File)object).listFiles()) == null) {
                return;
            }
            for (Object object2 : object) {
                ((File)object2).delete();
            }
        }
    }

    public void initFileCachePath(android.content.Context object) {
        try {
            object = object.getPackageName();
        }
        catch (Exception exception) {
            object = "unknown";
        }
        this.fileCachePath = Environment.getExternalStorageDirectory().getPath() + "/tencent/imsdkfilecache/" + ((String)object).replace(".", "/") + "/";
        object = new File(this.fileCachePath);
        if (!((File)object).exists()) {
            if (!((File)object).mkdirs()) {
                QLog.d(tag, 1, "create imsdkfilecache folder failed");
                return;
            }
        } else if (((File)object).isDirectory()) {
            if ((object = ((File)object).listFiles()) == null) {
                return;
            }
            for (Object object2 : object) {
                ((File)object2).delete();
            }
        }
    }

    public String getLogFileName() {
        return this.logFileName;
    }

    public String getPicCachePath() {
        return this.picCachePath;
    }

    public String getVideoCachePath() {
        return this.videoCachePath;
    }

    public String getLogPath() {
        return this.logPath;
    }

    public boolean getIsLogPrintEnabled() {
        return this.isLogPrintEnabled;
    }

    public String getFileCachePath() {
        return this.fileCachePath;
    }

    public void initLogSettings(boolean bl2, String string) {
        this.isLogPrintEnabled = bl2;
        if (string != null) {
            this.logPath = string;
            if (string.charAt(string.length() - 1) != '/') {
                this.logPath = this.logPath + "/";
            }
        }
    }

    public void setSoLibPath(String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return;
        }
        this.soLibPath = string;
        if (this.soLibPath.charAt(this.soLibPath.length() - 1) != '/') {
            this.soLibPath = this.soLibPath + "/";
        }
    }

    public void setLogLevel(TIMLogLevel tIMLogLevel) {
        this.logLevel = tIMLogLevel;
    }

    public TIMLogLevel getLogLevel() {
        return this.logLevel;
    }

    public void initLogPath(android.content.Context object) {
        try {
            object = object.getPackageName();
        }
        catch (Exception exception) {
            object = "unknown";
        }
        if (TextUtils.isEmpty((CharSequence)this.logPath)) {
            this.logPath = Environment.getExternalStorageDirectory().getPath() + "/tencent/imsdklogs/" + ((String)object).replace(".", "/") + "/";
        }
        if (!((File)(object = new File(this.logPath))).exists() && !((File)object).mkdirs()) {
            QLog.d(tag, 1, "create imsdklogs folder failed");
        }
    }

    public void initLog(android.content.Context object, TIMLogLevel tIMLogLevel, TIMLogListener tIMLogListener) {
        object = null;
        if (tIMLogListener != null) {
            object = new IMCoreLogMsgCallback(tIMLogListener);
        }
        IMCore.get().lOGGERINIT(this.logPath + this.logFileName, this.logLevel.getDescr(), this.isLogPrintEnabled, (ILogMsgCallback)object);
        IMCore.get().lOGGERSETLOGCBLEVEL(tIMLogLevel.getDescr());
        QALSDKManager.getInstance().setOutputLogLevel(this.logLevel.getIntLevel());
        this.setLogInited();
    }

    public void initIMCore(android.content.Context context, String string, TIMCallBack tIMCallBack) {
        QLog.i(tag, 1, "welcome to imsdk, version: " + TIMManager.getInstanceById(string).getVersion());
        this.ready = false;
        try {
            Object object = new Context();
            ((Context)object).setBid(QALSDKManager.getInstance().getQalAppId());
            ((Context)object).setLogPath(this.logPath);
            ((Context)object).setPicCachePath(this.picCachePath);
            ((Context)object).setIsLogPrintEnabled(this.isLogPrintEnabled);
            long l = TIMManager.getInstanceById(string).getServerTimeDiff();
            QLog.i(tag, 1, "servertimediff: " + l);
            ((Context)object).setSvr_time_diff(l);
            IMCore.get().setContext((Context)object);
            object = IMMsfCoreProxy.get().getMsfUserInfo(string);
            if (object == null) {
                QLog.e(tag, 1, "Login|4-InitIMCore|Fail| init failed, user not found:" + string);
                IMMsfCoreProxy.errorOnMainThread(tIMCallBack, 6014, "current user not login. id: " + string);
                return;
            }
            Map map = TLSLoginHelper.getInstance().getSSOTicket(((IMMsfUserInfo)object).getUser().getIdentifier());
            IMCoreUserConfig iMCoreUserConfig = TIMManager.getInstanceById(string).getUserConfig();
            iMCoreUserConfig.setNotifyCallback(new IMCoreNotify(string));
            int n = IMCore.get().initUser(IMMsfCoreProxy.get().getSdkAppId(), ((IMMsfUserInfo)object).getUidType(), String.valueOf(((IMMsfUserInfo)object).getsUerAppId()), ((IMMsfUserInfo)object).getUserId(), String.valueOf(((IMMsfUserInfo)object).getTinyid()), (byte[])map.get("A2"), this.getGateWayIp(), context.getFilesDir().toString(), iMCoreUserConfig.convertTo(string), new be(this, tIMCallBack, string));
            if (n != 0) {
                IMCoreUser iMCoreUser = IMCore.get().getUser(((IMMsfUserInfo)object).getUserId());
                TIMManager.getInstanceById(string).setCoreUser(iMCoreUser);
                object = TIMManager.getInstanceById(string).getCoreUser().getFileTranser();
                ((FileTranser)object).setCachePath(TIMManager.getInstance().getFileCachePath());
                iMCoreUser.setAvInviteCallBack(new IMCoreAvInviteCallBack(string));
                iMCoreUser.setGroupUpdateCallback(new ar(string));
                iMCoreUser.setGroupTipsEventCallback(new IMCoreGroupEventCallback(string));
                return;
            }
            IMMsfCoreProxy.errorOnMainThread(tIMCallBack, 6019, "local database operation failed!");
        }
        catch (Throwable throwable) {
            QLog.e(tag, 1, "Login|4-InitIMCore|Fail|init failed, exception: " + throwable.getLocalizedMessage());
            this.ready = false;
            IMMsfCoreProxy.errorOnMainThread(tIMCallBack, 6018, throwable.getLocalizedMessage());
        }
    }
}

