/*
 * Decompiled with CFR 0.152.
 */
package com.sina.weibo.sdk.utils;

import android.app.Notification;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.res.Resources;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.support.v4.app.NotificationCompat;
import android.text.TextUtils;
import com.sina.weibo.sdk.utils.ResourceManager;
import java.io.File;

public class NotificationHelper {
    private static final int NOTIFICATION_ID = 1;
    private static final String WEIBO = "Weibo";
    private static final String WEIBO_ZH_CN = "\u5fae\u535a";
    private static final String WEIBO_ZH_TW = "\u5fae\u535a";

    public static void showNotification(Context ctx, String notifyContent, String apkFilePath) {
        if (TextUtils.isEmpty((CharSequence)notifyContent)) {
            return;
        }
        NotificationManager mNotifyManager = (NotificationManager)ctx.getSystemService("notification");
        Notification notificaton = NotificationHelper.buildNotification(ctx, notifyContent, apkFilePath);
        mNotifyManager.notify(1, notificaton);
    }

    private static Notification buildNotification(Context ctx, String notifyContent, String apkFilePath) {
        Notification notification = null;
        String tickerText = "";
        String contentTitle = "";
        tickerText = notifyContent;
        contentTitle = ResourceManager.getString(ctx, WEIBO, "\u5fae\u535a", "\u5fae\u535a");
        NotificationCompat.Builder mNotificationBuilder = new NotificationCompat.Builder(ctx);
        mNotificationBuilder.setAutoCancel(true);
        mNotificationBuilder.setWhen(System.currentTimeMillis());
        Drawable drawable = ResourceManager.getDrawable(ctx, "ic_com_sina_weibo_sdk_weibo_logo.png");
        mNotificationBuilder.setLargeIcon(((BitmapDrawable)drawable).getBitmap());
        mNotificationBuilder.setSmallIcon(NotificationHelper.getNotificationIcon(ctx));
        mNotificationBuilder.setContentTitle((CharSequence)contentTitle);
        mNotificationBuilder.setTicker((CharSequence)tickerText);
        mNotificationBuilder.setContentText((CharSequence)tickerText);
        PendingIntent pendingIntent = NotificationHelper.buildInstallApkIntent(ctx, apkFilePath);
        mNotificationBuilder.setContentIntent(pendingIntent);
        notification = mNotificationBuilder.build();
        return notification;
    }

    private static PendingIntent buildInstallApkIntent(Context ctx, String filePath) {
        PendingIntent pendingIntent = null;
        if (!TextUtils.isEmpty((CharSequence)filePath)) {
            Intent intentInstall = new Intent("android.intent.action.VIEW");
            Uri localUri = Uri.fromFile((File)new File(filePath));
            intentInstall.setDataAndType(localUri, "application/vnd.android.package-archive");
            pendingIntent = PendingIntent.getActivity((Context)ctx, (int)0, (Intent)intentInstall, (int)16);
        } else {
            Intent intent = new Intent();
            pendingIntent = PendingIntent.getActivity((Context)ctx, (int)0, (Intent)intent, (int)16);
        }
        return pendingIntent;
    }

    private static int getNotificationIcon(Context ctx) {
        int resId = NotificationHelper.getResourceId(ctx, "com_sina_weibo_sdk_weibo_logo", "drawable");
        return resId > 0 ? resId : 17301659;
    }

    private static int getResourceId(Context ctx, String name, String type) {
        Resources themeResources = null;
        String packageName = ctx.getApplicationContext().getPackageName();
        PackageManager pm = ctx.getPackageManager();
        try {
            themeResources = pm.getResourcesForApplication(packageName);
            return themeResources.getIdentifier(name, type, packageName);
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
            return 0;
        }
    }
}

