/*
 * Decompiled with CFR 0.152.
 */
package com.sina.weibo.sdk.utils;

import android.content.ContentResolver;
import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import android.os.Build;
import android.os.Environment;
import android.os.Handler;
import android.os.Message;
import android.os.StatFs;
import android.provider.Settings;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.view.WindowManager;
import com.sina.weibo.sdk.exception.WeiboException;
import com.sina.weibo.sdk.exception.WeiboHttpException;
import com.sina.weibo.sdk.net.AsyncWeiboRunner;
import com.sina.weibo.sdk.net.WeiboParameters;
import com.sina.weibo.sdk.utils.Base64;
import com.sina.weibo.sdk.utils.LogUtil;
import com.sina.weibo.sdk.utils.Utility;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.security.KeyFactory;
import java.security.PublicKey;
import java.security.spec.X509EncodedKeySpec;
import java.util.concurrent.locks.ReentrantLock;
import javax.crypto.Cipher;
import org.json.JSONException;
import org.json.JSONObject;

public class AidTask {
    private static final String TAG = "AidTask";
    private static final String AID_FILE_NAME = "weibo_sdk_aid";
    private static final int VERSION = 1;
    public static final int WHAT_LOAD_AID_SUC = 1001;
    public static final int WHAT_LOAD_AID_API_ERR = 1002;
    public static final int WHAT_LOAD_AID_IO_ERR = 1003;
    private static AidTask sInstance;
    private Context mContext;
    private String mAppKey;
    private volatile ReentrantLock mTaskLock = new ReentrantLock(true);

    private AidTask(Context context) {
        this.mContext = context.getApplicationContext();
        new Thread(new Runnable(){

            @Override
            public void run() {
                int i = 0;
                while (i < 1) {
                    File f = AidTask.this.getAidInfoFile(i);
                    try {
                        f.delete();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    ++i;
                }
            }
        }).start();
    }

    public static synchronized AidTask getInstance(Context context) {
        if (sInstance == null) {
            sInstance = new AidTask(context);
        }
        return sInstance;
    }

    public void setAppkey(String appKey) {
        this.mAppKey = appKey;
    }

    public void aidTaskInit() {
        this.aidTaskInit(this.mAppKey);
    }

    public void aidTaskInit(String appKey) {
        if (TextUtils.isEmpty((CharSequence)appKey)) {
            return;
        }
        this.mAppKey = appKey;
        new Thread(new Runnable(){

            @Override
            public void run() {
                if (!AidTask.this.mTaskLock.tryLock()) {
                    return;
                }
                String cacheAid = AidTask.this.loadAidFromCache();
                if (!TextUtils.isEmpty((CharSequence)cacheAid)) {
                    AidTask.this.mTaskLock.unlock();
                    return;
                }
                int COUNT = 3;
                int retry = 0;
                while (retry < 3) {
                    try {
                        String response = AidTask.this.loadAidFromNet();
                        AidInfo.parseJson(response);
                        AidTask.this.cacheAidInfo(response);
                        break;
                    }
                    catch (WeiboException e) {
                        LogUtil.e(AidTask.TAG, "AidTaskInit WeiboException Msg : " + e.getMessage());
                        ++retry;
                    }
                }
                AidTask.this.mTaskLock.unlock();
            }
        }).start();
    }

    public ReentrantLock getTaskLock() {
        return this.mTaskLock;
    }

    public AidInfo getAidSync() throws WeiboException {
        if (TextUtils.isEmpty((CharSequence)this.mAppKey)) {
            return null;
        }
        String response = this.loadAidFromNet();
        AidInfo aidInfo = AidInfo.parseJson(response);
        this.cacheAidInfo(response);
        return aidInfo;
    }

    public void getAidAsync(final Handler h) {
        if (TextUtils.isEmpty((CharSequence)this.mAppKey)) {
            return;
        }
        final Message msg = Message.obtain();
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    String response = AidTask.this.loadAidFromNet();
                    AidInfo aidInfo = AidInfo.parseJson(response);
                    AidTask.this.cacheAidInfo(response);
                    msg.what = 1001;
                    msg.obj = aidInfo;
                    if (h != null) {
                        h.sendMessage(msg);
                    }
                    return;
                }
                catch (WeiboException e) {
                    if (e.getCause() instanceof IOException || e instanceof WeiboHttpException) {
                        msg.what = 1003;
                        if (h != null) {
                            h.sendMessage(msg);
                        }
                        return;
                    }
                    msg.what = 1002;
                    if (h != null) {
                        h.sendMessage(msg);
                    }
                    return;
                }
            }
        }).start();
    }

    public synchronized String loadAidFromCache() {
        AidInfo info = this.loadAidInfoFromCache();
        if (info != null) {
            return info.getAid();
        }
        return "";
    }

    public synchronized String loadSubCookieFromCache() {
        AidInfo info = this.loadAidInfoFromCache();
        if (info != null) {
            return info.getSubCookie();
        }
        return "";
    }

    private synchronized AidInfo loadAidInfoFromCache() {
        FileInputStream fis = null;
        try {
            File aidFile = this.getAidInfoFile(1);
            fis = new FileInputStream(aidFile);
            byte[] buffer = new byte[fis.available()];
            fis.read(buffer);
            AidInfo aidInfo = AidInfo.parseJson(new String(buffer));
            return aidInfo;
        }
        catch (Exception exception) {
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException iOException) {}
            }
        }
        return null;
    }

    private File getAidInfoFile(int version) {
        File dir = this.mContext.getFilesDir();
        File aidFile = new File(dir, AID_FILE_NAME + version);
        return aidFile;
    }

    private String loadAidFromNet() throws WeiboException {
        String url = "http://api.weibo.com/oauth2/getaid.json";
        String pkgName = this.mContext.getPackageName();
        String keyHash = Utility.getSign(this.mContext, pkgName);
        String mfp = this.getMfp();
        WeiboParameters params = new WeiboParameters(this.mAppKey);
        params.put("appkey", this.mAppKey);
        params.put("mfp", mfp);
        params.put("packagename", pkgName);
        params.put("key_hash", keyHash);
        try {
            String response = new AsyncWeiboRunner(this.mContext).request("http://api.weibo.com/oauth2/getaid.json", params, "GET");
            LogUtil.d(TAG, "loadAidFromNet response : " + response);
            return response;
        }
        catch (WeiboException e) {
            LogUtil.d(TAG, "loadAidFromNet WeiboException Msg : " + e.getMessage());
            throw e;
        }
    }

    private synchronized void cacheAidInfo(String json) {
        block13: {
            if (TextUtils.isEmpty((CharSequence)json)) {
                return;
            }
            FileOutputStream fos = null;
            try {
                try {
                    File aidFile = this.getAidInfoFile(1);
                    fos = new FileOutputStream(aidFile);
                    fos.write(json.getBytes());
                }
                catch (Exception exception) {
                    if (fos == null) break block13;
                    try {
                        fos.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            finally {
                if (fos != null) {
                    try {
                        fos.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    private String getMfp() {
        String publicKey = "MIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQDHHM0Fi2Z6+QYKXqFUX2Cy6AaWq3cPi+GSn9oeAwQbPZR75JB7Netm0HtBVVbtPhzT7UO2p1JhFUKWqrqoYuAjkgMVPmA0sFrQohns5EE44Y86XQopD4ZO+dE5KjUZFE6vrPO3rWW3np2BqlgKpjnYZri6TJApmIpGcQg9/G/3zQIDAQAB";
        String mfpJson = this.genMfpString();
        String mfpJsonUtf8 = "";
        try {
            mfpJsonUtf8 = new String(mfpJson.getBytes(), "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        LogUtil.d(TAG, "genMfpString() utf-8 string : " + mfpJsonUtf8);
        try {
            String rsaMfp = this.encryptRsa(mfpJsonUtf8, "MIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQDHHM0Fi2Z6+QYKXqFUX2Cy6AaWq3cPi+GSn9oeAwQbPZR75JB7Netm0HtBVVbtPhzT7UO2p1JhFUKWqrqoYuAjkgMVPmA0sFrQohns5EE44Y86XQopD4ZO+dE5KjUZFE6vrPO3rWW3np2BqlgKpjnYZri6TJApmIpGcQg9/G/3zQIDAQAB");
            LogUtil.d(TAG, "encryptRsa() string : " + rsaMfp);
            return rsaMfp;
        }
        catch (Exception e) {
            LogUtil.e(TAG, e.getMessage());
            return "";
        }
    }

    private String genMfpString() {
        JSONObject mfpObj = new JSONObject();
        try {
            String connectType;
            String deviceName;
            String ssid;
            String resolution;
            String sdcard;
            String model;
            String cpu;
            String androidId;
            String serial;
            String iccid;
            String mac;
            String imsi;
            String meid;
            String imei;
            String os = this.getOS();
            if (!TextUtils.isEmpty((CharSequence)os)) {
                mfpObj.put("1", (Object)os);
            }
            if (!TextUtils.isEmpty((CharSequence)(imei = this.getImei()))) {
                mfpObj.put("2", (Object)imei);
            }
            if (!TextUtils.isEmpty((CharSequence)(meid = this.getMeid()))) {
                mfpObj.put("3", (Object)meid);
            }
            if (!TextUtils.isEmpty((CharSequence)(imsi = this.getImsi()))) {
                mfpObj.put("4", (Object)imsi);
            }
            if (!TextUtils.isEmpty((CharSequence)(mac = this.getMac()))) {
                mfpObj.put("5", (Object)mac);
            }
            if (!TextUtils.isEmpty((CharSequence)(iccid = this.getIccid()))) {
                mfpObj.put("6", (Object)iccid);
            }
            if (!TextUtils.isEmpty((CharSequence)(serial = this.getSerialNo()))) {
                mfpObj.put("7", (Object)serial);
            }
            if (!TextUtils.isEmpty((CharSequence)(androidId = this.getAndroidId()))) {
                mfpObj.put("10", (Object)androidId);
            }
            if (!TextUtils.isEmpty((CharSequence)(cpu = this.getCpu()))) {
                mfpObj.put("13", (Object)cpu);
            }
            if (!TextUtils.isEmpty((CharSequence)(model = this.getModel()))) {
                mfpObj.put("14", (Object)model);
            }
            if (!TextUtils.isEmpty((CharSequence)(sdcard = this.getSdSize()))) {
                mfpObj.put("15", (Object)sdcard);
            }
            if (!TextUtils.isEmpty((CharSequence)(resolution = this.getResolution()))) {
                mfpObj.put("16", (Object)resolution);
            }
            if (!TextUtils.isEmpty((CharSequence)(ssid = this.getSsid()))) {
                mfpObj.put("17", (Object)ssid);
            }
            if (!TextUtils.isEmpty((CharSequence)(deviceName = this.getDeviceName()))) {
                mfpObj.put("18", (Object)deviceName);
            }
            if (!TextUtils.isEmpty((CharSequence)(connectType = this.getConnectType()))) {
                mfpObj.put("19", (Object)connectType);
            }
            return mfpObj.toString();
        }
        catch (JSONException jSONException) {
            return "";
        }
    }

    private String encryptRsa(String src, String publicKeyStr) throws Exception {
        Cipher cipher = Cipher.getInstance("RSA/ECB/PKCS1Padding");
        PublicKey publicKey = this.getPublicKey(publicKeyStr);
        cipher.init(1, publicKey);
        ByteArrayOutputStream bos = null;
        byte[] plainText = src.getBytes("UTF-8");
        try {
            byte[] enBytes;
            bos = new ByteArrayOutputStream();
            int len = 0;
            int offset = 0;
            while ((len = this.splite(plainText, offset, 117)) != -1) {
                enBytes = cipher.doFinal(plainText, offset, len);
                bos.write(enBytes);
                LogUtil.d(TAG, "encryptRsa offset = " + offset + "     len = " + len + "     enBytes len = " + enBytes.length);
                offset += len;
            }
            bos.flush();
            enBytes = bos.toByteArray();
            LogUtil.d(TAG, "encryptRsa total enBytes len = " + enBytes.length);
            byte[] base64byte = Base64.encodebyte(enBytes);
            LogUtil.d(TAG, "encryptRsa total base64byte len = " + base64byte.length);
            String VERSION2 = "01";
            String base64string = new String(base64byte, "UTF-8");
            base64string = "01" + base64string;
            LogUtil.d(TAG, "encryptRsa total base64string : " + base64string);
            String string = base64string;
            return string;
        }
        finally {
            if (bos != null) {
                try {
                    bos.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private int splite(byte[] src, int offset, int limit) {
        if (offset >= src.length) {
            return -1;
        }
        int delta = src.length - offset;
        return Math.min(delta, limit);
    }

    private PublicKey getPublicKey(String key) throws Exception {
        byte[] keyBytes = Base64.decode(key.getBytes());
        X509EncodedKeySpec keySpec = new X509EncodedKeySpec(keyBytes);
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        PublicKey publicKey = keyFactory.generatePublic(keySpec);
        return publicKey;
    }

    private String getOS() {
        try {
            return "Android " + Build.VERSION.RELEASE;
        }
        catch (Exception exception) {
            return "";
        }
    }

    private String getImei() {
        try {
            TelephonyManager telePhonyMgr = (TelephonyManager)this.mContext.getSystemService("phone");
            return telePhonyMgr.getDeviceId();
        }
        catch (Exception exception) {
            return "";
        }
    }

    private String getMeid() {
        try {
            TelephonyManager telePhonyMgr = (TelephonyManager)this.mContext.getSystemService("phone");
            return telePhonyMgr.getDeviceId();
        }
        catch (Exception exception) {
            return "";
        }
    }

    private String getImsi() {
        try {
            TelephonyManager telePhonyMgr = (TelephonyManager)this.mContext.getSystemService("phone");
            return telePhonyMgr.getSubscriberId();
        }
        catch (Exception exception) {
            return "";
        }
    }

    private String getMac() {
        WifiManager wifi;
        block3: {
            try {
                wifi = (WifiManager)this.mContext.getSystemService("wifi");
                if (wifi != null) break block3;
                return "";
            }
            catch (Exception exception) {
                return "";
            }
        }
        WifiInfo info = wifi.getConnectionInfo();
        return info != null ? info.getMacAddress() : "";
    }

    private String getIccid() {
        try {
            TelephonyManager telePhonyMgr = (TelephonyManager)this.mContext.getSystemService("phone");
            return telePhonyMgr.getSimSerialNumber();
        }
        catch (Exception exception) {
            return "";
        }
    }

    private String getSerialNo() {
        String serialnum = "";
        try {
            Class<?> c = Class.forName("android.os.SystemProperties");
            Method get = c.getMethod("get", String.class, String.class);
            serialnum = (String)get.invoke(c, "ro.serialno", "unknown");
        }
        catch (Exception exception) {
            // empty catch block
        }
        return serialnum;
    }

    private String getAndroidId() {
        try {
            String androidId = Settings.Secure.getString((ContentResolver)this.mContext.getContentResolver(), (String)"android_id");
            return androidId;
        }
        catch (Exception exception) {
            return "";
        }
    }

    private String getCpu() {
        try {
            return Build.CPU_ABI;
        }
        catch (Exception exception) {
            return "";
        }
    }

    private String getModel() {
        try {
            return Build.MODEL;
        }
        catch (Exception exception) {
            return "";
        }
    }

    private String getSdSize() {
        try {
            File path = Environment.getExternalStorageDirectory();
            StatFs stat = new StatFs(path.getPath());
            long blockSize = stat.getBlockSize();
            long availableBlocks = stat.getBlockCount();
            return Long.toString(availableBlocks * blockSize);
        }
        catch (Exception exception) {
            return "";
        }
    }

    private String getResolution() {
        try {
            DisplayMetrics dm = new DisplayMetrics();
            WindowManager wm = (WindowManager)this.mContext.getSystemService("window");
            wm.getDefaultDisplay().getMetrics(dm);
            return String.valueOf(String.valueOf(dm.widthPixels)) + "*" + String.valueOf(dm.heightPixels);
        }
        catch (Exception exception) {
            return "";
        }
    }

    private String getSsid() {
        try {
            WifiManager wifiManager = (WifiManager)this.mContext.getSystemService("wifi");
            WifiInfo wifiInfo = wifiManager.getConnectionInfo();
            if (wifiInfo != null) {
                return wifiInfo.getSSID();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "";
    }

    private String getDeviceName() {
        try {
            return Build.BRAND;
        }
        catch (Exception exception) {
            return "";
        }
    }

    private String getConnectType() {
        String network = "none";
        try {
            ConnectivityManager connectivity = (ConnectivityManager)this.mContext.getSystemService("connectivity");
            NetworkInfo info = connectivity.getActiveNetworkInfo();
            if (info != null) {
                if (info.getType() == 0) {
                    switch (info.getSubtype()) {
                        case 1: 
                        case 2: 
                        case 4: 
                        case 7: 
                        case 11: {
                            network = "2G";
                            break;
                        }
                        case 3: 
                        case 5: 
                        case 6: 
                        case 8: 
                        case 9: 
                        case 10: 
                        case 12: 
                        case 14: 
                        case 15: {
                            network = "3G";
                            break;
                        }
                        case 13: {
                            network = "4G";
                            break;
                        }
                        default: {
                            network = "none";
                            break;
                        }
                    }
                } else if (info.getType() == 1) {
                    network = "wifi";
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return network;
    }

    public static final class AidInfo {
        private String mAid;
        private String mSubCookie;

        public String getAid() {
            return this.mAid;
        }

        public String getSubCookie() {
            return this.mSubCookie;
        }

        public static AidInfo parseJson(String response) throws WeiboException {
            AidInfo instance = new AidInfo();
            try {
                JSONObject resObj = new JSONObject(response);
                if (resObj.has("error") || resObj.has("error_code")) {
                    LogUtil.d(AidTask.TAG, "loadAidFromNet has error !!!");
                    throw new WeiboException("loadAidFromNet has error !!!");
                }
                instance.mAid = resObj.optString("aid", "");
                instance.mSubCookie = resObj.optString("sub", "");
            }
            catch (JSONException e) {
                LogUtil.d(AidTask.TAG, "loadAidFromNet JSONException Msg : " + e.getMessage());
                throw new WeiboException("loadAidFromNet has error !!!");
            }
            return instance;
        }
    }
}

