/*
 * Decompiled with CFR 0.152.
 */
package com.sina.weibo.sdk.net;

import android.app.IntentService;
import android.content.Intent;
import android.os.Bundle;
import android.os.IBinder;
import android.text.TextUtils;
import com.sina.weibo.sdk.WbAppInstallActivator;
import com.sina.weibo.sdk.exception.WeiboException;
import com.sina.weibo.sdk.net.HttpManager;
import com.sina.weibo.sdk.net.WeiboParameters;
import com.sina.weibo.sdk.utils.LogUtil;
import com.sina.weibo.sdk.utils.NotificationHelper;
import java.io.File;

public class DownloadService
extends IntentService {
    public static final String EXTRA_DOWNLOAD_URL = "download_url";
    public static final String EXTRA_NOTIFICATION_CONTENT = "notification_content";
    private static final String TAG = DownloadService.class.getCanonicalName();
    private static final String APK_SAVE_DIR = WbAppInstallActivator.WB_APK_FILE_DIR;

    public DownloadService() {
        super(TAG);
    }

    public IBinder onBind(Intent intent) {
        return null;
    }

    public void onCreate() {
        super.onCreate();
    }

    public int onStartCommand(Intent intent, int flags, int startId) {
        return super.onStartCommand(intent, flags, startId);
    }

    public void onStart(Intent intent, int startId) {
        super.onStart(intent, startId);
        if (intent == null) {
            return;
        }
    }

    protected void onHandleIntent(Intent intent) {
        Bundle bundle = intent.getExtras();
        if (bundle == null) {
            this.stopSelf();
            return;
        }
        String downLoadUrl = bundle.getString(EXTRA_DOWNLOAD_URL);
        String notificationContent = bundle.getString(EXTRA_NOTIFICATION_CONTENT);
        LogUtil.e(TAG, "onHandleIntent downLoadUrl:" + downLoadUrl + "!!!!!");
        if (TextUtils.isEmpty((CharSequence)downLoadUrl)) {
            LogUtil.e(TAG, "downloadurl is null");
            this.stopSelf();
            return;
        }
        String filePath = "";
        try {
            String redirectUrl = HttpManager.openRedirectUrl4LocationUri(this.getApplicationContext(), downLoadUrl, "GET", new WeiboParameters(""));
            String fileName = DownloadService.generateSaveFileName(redirectUrl);
            if (TextUtils.isEmpty((CharSequence)fileName) || !fileName.endsWith(".apk")) {
                LogUtil.e(TAG, "redirectDownloadUrl is illeagle");
                this.stopSelf();
                return;
            }
            String saveDir = APK_SAVE_DIR;
            filePath = HttpManager.downloadFile(this.getApplicationContext(), redirectUrl, saveDir, fileName);
        }
        catch (WeiboException e) {
            e.printStackTrace();
        }
        if (!TextUtils.isEmpty((CharSequence)filePath)) {
            File downloadFile = new File(filePath);
            if (downloadFile.exists()) {
                LogUtil.e(TAG, "download successed!");
                NotificationHelper.showNotification(this.getApplicationContext(), notificationContent, filePath);
            }
        } else {
            LogUtil.e(TAG, "download failed!");
        }
    }

    private static String generateSaveFileName(String downloadUrl) {
        String fileName = "";
        int index = downloadUrl.lastIndexOf("/");
        if (index != -1) {
            fileName = downloadUrl.substring(index + 1, downloadUrl.length());
        }
        return fileName;
    }
}

