/*
 * Decompiled with CFR 0.152.
 */
package com.sina.weibo.sdk.component.view;

import android.content.Context;
import android.content.Intent;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.StateListDrawable;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ProgressBar;
import android.widget.TextView;
import com.sina.weibo.sdk.auth.WeiboAuthListener;
import com.sina.weibo.sdk.component.WeiboSdkBrowser;
import com.sina.weibo.sdk.component.WidgetRequestParam;
import com.sina.weibo.sdk.exception.WeiboException;
import com.sina.weibo.sdk.net.AsyncWeiboRunner;
import com.sina.weibo.sdk.net.RequestListener;
import com.sina.weibo.sdk.net.WeiboParameters;
import com.sina.weibo.sdk.utils.LogUtil;
import com.sina.weibo.sdk.utils.ResourceManager;
import com.sina.weibo.sdk.utils.Utility;
import org.json.JSONException;
import org.json.JSONObject;

public class AttentionComponentView
extends FrameLayout {
    private static final String TAG = AttentionComponentView.class.getName();
    private static final String ATTENTION_H5 = "http://widget.weibo.com/relationship/followsdk.php";
    private static final String FRIENDSHIPS_SHOW_URL = "https://api.weibo.com/2/friendships/show.json";
    private static final String ALREADY_ATTEND_EN = "Following";
    private static final String ALREADY_ATTEND_ZH_CN = "\u5df2\u5173\u6ce8";
    private static final String ALREADY_ATTEND_ZH_TW = "\u5df2\u95dc\u6ce8";
    private static final String ATTEND_EN = "Follow";
    private static final String ATTEND_ZH_CN = "\u5173\u6ce8";
    private static final String ATTEND_ZH_TW = "\u95dc\u6ce8";
    private RequestParam mAttentionParam;
    private volatile boolean mIsLoadingState = false;
    private FrameLayout flButton;
    private TextView mButton;
    private ProgressBar pbLoading;

    public AttentionComponentView(Context context) {
        super(context);
        this.init(context);
    }

    public AttentionComponentView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context);
    }

    public AttentionComponentView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context);
    }

    private void init(Context context) {
        StateListDrawable relationShipButtonBg = ResourceManager.createStateListDrawable(context, "common_button_white.9.png", "common_button_white_highlighted.9.png");
        this.flButton = new FrameLayout(context);
        this.flButton.setBackgroundDrawable((Drawable)relationShipButtonBg);
        int paddingTop = ResourceManager.dp2px(this.getContext(), 6);
        int paddingRight = ResourceManager.dp2px(this.getContext(), 2);
        int paddingBottom = ResourceManager.dp2px(this.getContext(), 6);
        this.flButton.setPadding(0, paddingTop, paddingRight, paddingBottom);
        this.flButton.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(ResourceManager.dp2px(this.getContext(), 66), -2));
        this.addView((View)this.flButton);
        this.mButton = new TextView(this.getContext());
        this.mButton.setIncludeFontPadding(false);
        this.mButton.setSingleLine(true);
        this.mButton.setTextSize(2, 13.0f);
        FrameLayout.LayoutParams buttonLp = new FrameLayout.LayoutParams(-2, -2);
        buttonLp.gravity = 17;
        this.mButton.setLayoutParams((ViewGroup.LayoutParams)buttonLp);
        this.flButton.addView((View)this.mButton);
        this.pbLoading = new ProgressBar(this.getContext(), null, 16842873);
        this.pbLoading.setVisibility(8);
        FrameLayout.LayoutParams pbLoadingLp = new FrameLayout.LayoutParams(-2, -2);
        pbLoadingLp.gravity = 17;
        this.pbLoading.setLayoutParams((ViewGroup.LayoutParams)pbLoadingLp);
        this.flButton.addView((View)this.pbLoading);
        this.flButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                AttentionComponentView.this.execAttented();
            }
        });
        this.showFollowButton(false);
    }

    public void setAttentionParam(RequestParam param) {
        this.mAttentionParam = param;
        if (param.hasAuthoriz()) {
            this.loadAttentionState(param);
        }
    }

    private void startLoading() {
        this.flButton.setEnabled(false);
        this.mButton.setVisibility(8);
        this.pbLoading.setVisibility(0);
    }

    private void stopLoading() {
        this.flButton.setEnabled(true);
        this.mButton.setVisibility(0);
        this.pbLoading.setVisibility(8);
    }

    private void showFollowButton(boolean attention) {
        this.stopLoading();
        if (attention) {
            this.mButton.setText((CharSequence)ResourceManager.getString(this.getContext(), ALREADY_ATTEND_EN, ALREADY_ATTEND_ZH_CN, ALREADY_ATTEND_ZH_TW));
            this.mButton.setTextColor(-13421773);
            Drawable leftDrawable = ResourceManager.getDrawable(this.getContext(), "timeline_relationship_icon_attention.png");
            this.mButton.setCompoundDrawablesWithIntrinsicBounds(leftDrawable, null, null, null);
            this.flButton.setEnabled(false);
        } else {
            this.mButton.setText((CharSequence)ResourceManager.getString(this.getContext(), ATTEND_EN, ATTEND_ZH_CN, ATTEND_ZH_TW));
            this.mButton.setTextColor(-32256);
            Drawable leftDrawable = ResourceManager.getDrawable(this.getContext(), "timeline_relationship_icon_addattention.png");
            this.mButton.setCompoundDrawablesWithIntrinsicBounds(leftDrawable, null, null, null);
            this.flButton.setEnabled(true);
        }
    }

    private void loadAttentionState(RequestParam req) {
        if (this.mIsLoadingState) {
            return;
        }
        this.mIsLoadingState = true;
        this.startLoading();
        WeiboParameters params = new WeiboParameters(req.mAppKey);
        params.put("access_token", req.mAccessToken);
        params.put("target_id", req.mAttentionUid);
        params.put("target_screen_name", req.mAttentionScreenName);
        this.requestAsync(this.getContext(), FRIENDSHIPS_SHOW_URL, params, "GET", new RequestListener(){

            @Override
            public void onWeiboException(WeiboException e) {
                LogUtil.d(TAG, "error : " + e.getMessage());
                AttentionComponentView.this.mIsLoadingState = false;
            }

            @Override
            public void onComplete(String response) {
                LogUtil.d(TAG, "json : " + response);
                try {
                    JSONObject root = new JSONObject(response);
                    final JSONObject target = root.optJSONObject("target");
                    AttentionComponentView.this.getHandler().post(new Runnable(){

                        @Override
                        public void run() {
                            if (target != null) {
                                AttentionComponentView.this.showFollowButton(target.optBoolean("followed_by", false));
                            }
                            AttentionComponentView.this.mIsLoadingState = false;
                        }
                    });
                }
                catch (JSONException jSONException) {
                    // empty catch block
                }
            }
        });
    }

    private void execAttented() {
        WidgetRequestParam req = new WidgetRequestParam(this.getContext());
        req.setUrl(ATTENTION_H5);
        req.setSpecifyTitle(ResourceManager.getString(this.getContext(), ATTEND_EN, ATTEND_ZH_CN, ATTEND_ZH_TW));
        req.setAppKey(this.mAttentionParam.mAppKey);
        req.setAttentionFuid(this.mAttentionParam.mAttentionUid);
        req.setAuthListener(this.mAttentionParam.mAuthlistener);
        req.setToken(this.mAttentionParam.mAccessToken);
        req.setWidgetRequestCallback(new WidgetRequestParam.WidgetRequestCallback(){

            @Override
            public void onWebViewResult(String url) {
                Bundle b = Utility.parseUri(url);
                String result = b.getString("result");
                if (!TextUtils.isEmpty((CharSequence)result)) {
                    try {
                        long attented = Integer.parseInt(result);
                        if (attented == 1L) {
                            AttentionComponentView.this.showFollowButton(true);
                        } else if (attented == 0L) {
                            AttentionComponentView.this.showFollowButton(false);
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
            }
        });
        Bundle data = req.createRequestParamBundle();
        Intent intent = new Intent(this.getContext(), WeiboSdkBrowser.class);
        intent.putExtras(data);
        this.getContext().startActivity(intent);
    }

    private void requestAsync(Context context, String url, WeiboParameters params, String httpMethod, RequestListener listener) {
        new AsyncWeiboRunner(context.getApplicationContext()).requestAsync(url, params, httpMethod, listener);
    }

    public static class RequestParam {
        private String mAppKey;
        private String mAccessToken;
        private String mAttentionUid;
        private String mAttentionScreenName;
        private WeiboAuthListener mAuthlistener;

        private RequestParam() {
        }

        public static RequestParam createRequestParam(String appKey, String token, String attentionUid, String attentionScreenName, WeiboAuthListener listener) {
            RequestParam param = new RequestParam();
            param.mAppKey = appKey;
            param.mAccessToken = token;
            param.mAttentionUid = attentionUid;
            param.mAttentionScreenName = attentionScreenName;
            param.mAuthlistener = listener;
            return param;
        }

        public static RequestParam createRequestParam(String appKey, String attentionUid, String attentionScreenName, WeiboAuthListener listener) {
            RequestParam param = new RequestParam();
            param.mAppKey = appKey;
            param.mAttentionUid = attentionUid;
            param.mAttentionScreenName = attentionScreenName;
            param.mAuthlistener = listener;
            return param;
        }

        private boolean hasAuthoriz() {
            return !TextUtils.isEmpty((CharSequence)this.mAccessToken);
        }
    }
}

