/*
 * Decompiled with CFR 0.152.
 */
package com.sina.weibo.sdk.component;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.net.http.SslError;
import android.os.Bundle;
import android.text.TextUtils;
import android.view.KeyEvent;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.SslErrorHandler;
import android.webkit.WebChromeClient;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.sina.weibo.sdk.auth.AuthInfo;
import com.sina.weibo.sdk.auth.WeiboAuthListener;
import com.sina.weibo.sdk.component.AuthRequestParam;
import com.sina.weibo.sdk.component.AuthWeiboWebViewClient;
import com.sina.weibo.sdk.component.BrowserLauncher;
import com.sina.weibo.sdk.component.BrowserRequestCallBack;
import com.sina.weibo.sdk.component.BrowserRequestParamBase;
import com.sina.weibo.sdk.component.ShareRequestParam;
import com.sina.weibo.sdk.component.ShareWeiboWebViewClient;
import com.sina.weibo.sdk.component.WeiboCallbackManager;
import com.sina.weibo.sdk.component.WeiboWebViewClient;
import com.sina.weibo.sdk.component.WidgetRequestParam;
import com.sina.weibo.sdk.component.WidgetWeiboWebViewClient;
import com.sina.weibo.sdk.component.view.LoadingBar;
import com.sina.weibo.sdk.exception.WeiboException;
import com.sina.weibo.sdk.net.AsyncWeiboRunner;
import com.sina.weibo.sdk.net.RequestListener;
import com.sina.weibo.sdk.net.WeiboParameters;
import com.sina.weibo.sdk.utils.LogUtil;
import com.sina.weibo.sdk.utils.NetworkHelper;
import com.sina.weibo.sdk.utils.ResourceManager;
import com.sina.weibo.sdk.utils.Utility;

public class WeiboSdkBrowser
extends Activity
implements BrowserRequestCallBack {
    private static final String TAG = WeiboSdkBrowser.class.getName();
    private static final String CANCEL_EN = "Close";
    private static final String CANCEL_ZH_CN = "\u5173\u95ed";
    private static final String CANCEL_ZH_TW = "\u5173\u95ed";
    private static final String EMPTY_PROMPT_BAD_NETWORK_UI_EN = "A network error occurs, please tap the button to reload";
    private static final String EMPTY_PROMPT_BAD_NETWORK_UI_ZH_CN = "\u7f51\u7edc\u51fa\u9519\u5566\uff0c\u8bf7\u70b9\u51fb\u6309\u94ae\u91cd\u65b0\u52a0\u8f7d";
    private static final String EMPTY_PROMPT_BAD_NETWORK_UI_ZH_TW = "\u7db2\u8def\u51fa\u932f\u5566\uff0c\u8acb\u9ede\u64ca\u6309\u9215\u91cd\u65b0\u8f09\u5165";
    private static final String CHANNEL_DATA_ERROR_EN = "channel_data_error";
    private static final String CHANNEL_DATA_ERROR_ZH_CN = "\u91cd\u65b0\u52a0\u8f7d";
    private static final String CHANNEL_DATA_ERROR_ZH_TW = "\u91cd\u65b0\u8f09\u5165";
    private static final String WEIBOBROWSER_NO_TITLE_EN = "No Title";
    private static final String WEIBOBROWSER_NO_TITLE_ZH_CN = "\u65e0\u6807\u9898";
    private static final String WEIBOBROWSER_NO_TITLE_ZH_TW = "\u7121\u6a19\u984c";
    private static final String LOADINFO_EN = "Loading....";
    private static final String LOADINFO_ZH_CN = "\u52a0\u8f7d\u4e2d....";
    private static final String LOADINFO_ZH_TW = "\u8f09\u5165\u4e2d....";
    public static final String BROWSER_CLOSE_SCHEME = "sinaweibo://browser/close";
    public static final String BROWSER_WIDGET_SCHEME = "sinaweibo://browser/datatransfer";
    private String mSpecifyTitle;
    private String mHtmlTitle;
    private boolean isLoading;
    private String mUrl;
    private boolean isErrorPage;
    private TextView mLeftBtn;
    private TextView mTitleText;
    private WebView mWebView;
    private LoadingBar mLoadingBar;
    private LinearLayout mLoadErrorView;
    private Button mLoadErrorRetryBtn;
    private BrowserRequestParamBase mRequestParam;
    private WeiboWebViewClient mWeiboWebViewClient;

    public static void startAuth(Context context, String url, AuthInfo authInfo, WeiboAuthListener listener) {
        AuthRequestParam reqParam = new AuthRequestParam(context);
        reqParam.setLauncher(BrowserLauncher.AUTH);
        reqParam.setUrl(url);
        reqParam.setAuthInfo(authInfo);
        reqParam.setAuthListener(listener);
        Intent intent = new Intent(context, WeiboSdkBrowser.class);
        intent.putExtras(reqParam.createRequestParamBundle());
        context.startActivity(intent);
    }

    public static void startShared(Context context, String url, AuthInfo authInfo, WeiboAuthListener listener) {
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (!this.initDataFromIntent(this.getIntent())) {
            this.finish();
            return;
        }
        this.setContentView();
        this.initWebView();
        if (this.isWeiboShareRequestParam(this.mRequestParam)) {
            this.startShare();
        } else {
            this.openUrl(this.mUrl);
        }
    }

    private boolean initDataFromIntent(Intent data) {
        this.mRequestParam = this.createBrowserRequestParam(data.getExtras());
        if (this.mRequestParam == null) {
            return false;
        }
        this.mUrl = this.mRequestParam.getUrl();
        if (TextUtils.isEmpty((CharSequence)this.mUrl)) {
            return false;
        }
        LogUtil.d(TAG, "LOAD URL : " + this.mUrl);
        this.mSpecifyTitle = this.mRequestParam.getSpecifyTitle();
        return true;
    }

    private void openUrl(String url) {
        this.mWebView.loadUrl(url);
    }

    private void startShare() {
        LogUtil.d(TAG, "Enter startShare()............");
        final ShareRequestParam req = (ShareRequestParam)this.mRequestParam;
        if (req.hasImage()) {
            LogUtil.d(TAG, "loadUrl hasImage............");
            WeiboParameters param = new WeiboParameters(req.getAppKey());
            param = req.buildUploadPicParam(param);
            new AsyncWeiboRunner((Context)this).requestAsync("http://service.weibo.com/share/mobilesdk_uppic.php", param, "POST", new RequestListener(){

                @Override
                public void onWeiboException(WeiboException e) {
                    LogUtil.d(TAG, "post onWeiboException " + e.getMessage());
                    req.sendSdkErrorResponse(WeiboSdkBrowser.this, e.getMessage());
                    WeiboSdkBrowser.this.finish();
                }

                @Override
                public void onComplete(String response) {
                    LogUtil.d(TAG, "post onComplete : " + response);
                    ShareRequestParam.UploadPicResult result = ShareRequestParam.UploadPicResult.parse(response);
                    if (result != null && result.getCode() == 1 && !TextUtils.isEmpty((CharSequence)result.getPicId())) {
                        WeiboSdkBrowser.this.openUrl(req.buildUrl(result.getPicId()));
                    } else {
                        req.sendSdkErrorResponse(WeiboSdkBrowser.this, "upload pic faild");
                        WeiboSdkBrowser.this.finish();
                    }
                }
            });
        } else {
            this.openUrl(this.mUrl);
        }
    }

    @SuppressLint(value={"SetJavaScriptEnabled"})
    private void initWebView() {
        this.mWebView.getSettings().setJavaScriptEnabled(true);
        if (this.isWeiboShareRequestParam(this.mRequestParam)) {
            this.mWebView.getSettings().setUserAgentString(Utility.generateUA((Context)this));
        }
        this.mWebView.getSettings().setSavePassword(false);
        this.mWebView.setWebViewClient((WebViewClient)this.mWeiboWebViewClient);
        this.mWebView.setWebChromeClient((WebChromeClient)new WeiboChromeClient());
        this.mWebView.requestFocus();
        this.mWebView.setScrollBarStyle(0);
    }

    private void setTopNavTitle() {
        this.mTitleText.setText((CharSequence)this.mSpecifyTitle);
        this.mLeftBtn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                WeiboSdkBrowser.this.mRequestParam.execRequest(WeiboSdkBrowser.this, 3);
                WeiboSdkBrowser.this.finish();
            }
        });
    }

    private void updateTitleName() {
        String showTitle = "";
        if (!TextUtils.isEmpty((CharSequence)this.mHtmlTitle)) {
            showTitle = this.mHtmlTitle;
        } else if (!TextUtils.isEmpty((CharSequence)this.mSpecifyTitle)) {
            showTitle = this.mSpecifyTitle;
        }
        this.mTitleText.setText((CharSequence)showTitle);
    }

    private void setContentView() {
        int TITLE_BAR_HEIGHT = 45;
        RelativeLayout contentLy = new RelativeLayout((Context)this);
        contentLy.setLayoutParams(new ViewGroup.LayoutParams(-1, -1));
        contentLy.setBackgroundColor(-1);
        LinearLayout titleBarLy = new LinearLayout((Context)this);
        titleBarLy.setId(1);
        titleBarLy.setOrientation(1);
        titleBarLy.setLayoutParams(new ViewGroup.LayoutParams(-1, -2));
        RelativeLayout titleBar = new RelativeLayout((Context)this);
        titleBar.setLayoutParams(new ViewGroup.LayoutParams(-1, ResourceManager.dp2px((Context)this, 45)));
        titleBar.setBackgroundDrawable(ResourceManager.getNinePatchDrawable((Context)this, "weibosdk_navigationbar_background.9.png"));
        this.mLeftBtn = new TextView((Context)this);
        this.mLeftBtn.setClickable(true);
        this.mLeftBtn.setTextSize(2, 17.0f);
        this.mLeftBtn.setTextColor(ResourceManager.createColorStateList(-32256, 1728020992));
        this.mLeftBtn.setText((CharSequence)ResourceManager.getString((Context)this, CANCEL_EN, "\u5173\u95ed", "\u5173\u95ed"));
        RelativeLayout.LayoutParams leftBtnLp = new RelativeLayout.LayoutParams(-2, -2);
        leftBtnLp.addRule(5);
        leftBtnLp.addRule(15);
        leftBtnLp.leftMargin = ResourceManager.dp2px((Context)this, 10);
        leftBtnLp.rightMargin = ResourceManager.dp2px((Context)this, 10);
        this.mLeftBtn.setLayoutParams((ViewGroup.LayoutParams)leftBtnLp);
        titleBar.addView((View)this.mLeftBtn);
        this.mTitleText = new TextView((Context)this);
        this.mTitleText.setTextSize(2, 18.0f);
        this.mTitleText.setTextColor(-11382190);
        this.mTitleText.setEllipsize(TextUtils.TruncateAt.END);
        this.mTitleText.setSingleLine(true);
        this.mTitleText.setGravity(17);
        this.mTitleText.setMaxWidth(ResourceManager.dp2px((Context)this, 160));
        RelativeLayout.LayoutParams titleTextLy = new RelativeLayout.LayoutParams(-2, -2);
        titleTextLy.addRule(13);
        this.mTitleText.setLayoutParams((ViewGroup.LayoutParams)titleTextLy);
        titleBar.addView((View)this.mTitleText);
        TextView shadowBar = new TextView((Context)this);
        shadowBar.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, ResourceManager.dp2px((Context)this, 2)));
        shadowBar.setBackgroundDrawable(ResourceManager.getNinePatchDrawable((Context)this, "weibosdk_common_shadow_top.9.png"));
        this.mLoadingBar = new LoadingBar((Context)this);
        this.mLoadingBar.setBackgroundColor(0);
        this.mLoadingBar.drawProgress(0);
        LinearLayout.LayoutParams loadingBarLy = new LinearLayout.LayoutParams(-1, ResourceManager.dp2px((Context)this, 3));
        this.mLoadingBar.setLayoutParams((ViewGroup.LayoutParams)loadingBarLy);
        titleBarLy.addView((View)titleBar);
        titleBarLy.addView((View)shadowBar);
        titleBarLy.addView((View)this.mLoadingBar);
        this.mWebView = new WebView((Context)this);
        this.mWebView.setBackgroundColor(-1);
        RelativeLayout.LayoutParams webViewLp = new RelativeLayout.LayoutParams(-1, -1);
        webViewLp.addRule(3, 1);
        this.mWebView.setLayoutParams((ViewGroup.LayoutParams)webViewLp);
        this.mLoadErrorView = new LinearLayout((Context)this);
        this.mLoadErrorView.setVisibility(8);
        this.mLoadErrorView.setOrientation(1);
        this.mLoadErrorView.setGravity(17);
        RelativeLayout.LayoutParams mLoadErrorViewLp = new RelativeLayout.LayoutParams(-1, -1);
        mLoadErrorViewLp.addRule(3, 1);
        this.mLoadErrorView.setLayoutParams((ViewGroup.LayoutParams)mLoadErrorViewLp);
        ImageView loadErrorImg = new ImageView((Context)this);
        loadErrorImg.setImageDrawable(ResourceManager.getDrawable((Context)this, "weibosdk_empty_failed.png"));
        LinearLayout.LayoutParams loadErrorImgLp = new LinearLayout.LayoutParams(-2, -2);
        loadErrorImgLp.rightMargin = loadErrorImgLp.bottomMargin = ResourceManager.dp2px((Context)this, 8);
        loadErrorImgLp.topMargin = loadErrorImgLp.bottomMargin;
        loadErrorImgLp.leftMargin = loadErrorImgLp.bottomMargin;
        loadErrorImg.setLayoutParams((ViewGroup.LayoutParams)loadErrorImgLp);
        this.mLoadErrorView.addView((View)loadErrorImg);
        TextView loadErrorContent = new TextView((Context)this);
        loadErrorContent.setGravity(1);
        loadErrorContent.setTextColor(-4342339);
        loadErrorContent.setTextSize(2, 14.0f);
        loadErrorContent.setText((CharSequence)ResourceManager.getString((Context)this, EMPTY_PROMPT_BAD_NETWORK_UI_EN, EMPTY_PROMPT_BAD_NETWORK_UI_ZH_CN, EMPTY_PROMPT_BAD_NETWORK_UI_ZH_TW));
        LinearLayout.LayoutParams loadErrorContentLp = new LinearLayout.LayoutParams(-2, -2);
        loadErrorContent.setLayoutParams((ViewGroup.LayoutParams)loadErrorContentLp);
        this.mLoadErrorView.addView((View)loadErrorContent);
        this.mLoadErrorRetryBtn = new Button((Context)this);
        this.mLoadErrorRetryBtn.setGravity(17);
        this.mLoadErrorRetryBtn.setTextColor(-8882056);
        this.mLoadErrorRetryBtn.setTextSize(2, 16.0f);
        this.mLoadErrorRetryBtn.setText((CharSequence)ResourceManager.getString((Context)this, CHANNEL_DATA_ERROR_EN, CHANNEL_DATA_ERROR_ZH_CN, CHANNEL_DATA_ERROR_ZH_TW));
        this.mLoadErrorRetryBtn.setBackgroundDrawable((Drawable)ResourceManager.createStateListDrawable((Context)this, "weibosdk_common_button_alpha.9.png", "weibosdk_common_button_alpha_highlighted.9.png"));
        LinearLayout.LayoutParams loadErrorRetryBtnLp = new LinearLayout.LayoutParams(ResourceManager.dp2px((Context)this, 142), ResourceManager.dp2px((Context)this, 46));
        loadErrorRetryBtnLp.topMargin = ResourceManager.dp2px((Context)this, 10);
        this.mLoadErrorRetryBtn.setLayoutParams((ViewGroup.LayoutParams)loadErrorRetryBtnLp);
        this.mLoadErrorRetryBtn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                WeiboSdkBrowser.this.openUrl(WeiboSdkBrowser.this.mUrl);
                WeiboSdkBrowser.this.isErrorPage = false;
            }
        });
        this.mLoadErrorView.addView((View)this.mLoadErrorRetryBtn);
        contentLy.addView((View)titleBarLy);
        contentLy.addView((View)this.mWebView);
        contentLy.addView((View)this.mLoadErrorView);
        this.setContentView((View)contentLy);
        this.setTopNavTitle();
    }

    protected void refreshAllViews() {
        if (this.isLoading) {
            this.setViewLoading();
        } else {
            this.setViewNormal();
        }
    }

    private void setViewNormal() {
        this.updateTitleName();
        this.mLoadingBar.setVisibility(8);
    }

    private void setViewLoading() {
        this.mTitleText.setText((CharSequence)ResourceManager.getString((Context)this, LOADINFO_EN, LOADINFO_ZH_CN, LOADINFO_ZH_TW));
        this.mLoadingBar.setVisibility(0);
    }

    private void handleReceivedError(WebView view, int errorCode, String description, String failingUrl) {
        if (!failingUrl.startsWith("sinaweibo")) {
            this.isErrorPage = true;
            this.promptError();
        }
    }

    private void promptError() {
        this.mLoadErrorView.setVisibility(0);
        this.mWebView.setVisibility(8);
    }

    private void hiddenErrorPrompt() {
        this.mLoadErrorView.setVisibility(8);
        this.mWebView.setVisibility(0);
    }

    private boolean isWeiboCustomScheme(String url) {
        if (TextUtils.isEmpty((CharSequence)url)) {
            return false;
        }
        return "sinaweibo".equalsIgnoreCase(Uri.parse((String)url).getAuthority());
    }

    protected void onResume() {
        super.onResume();
    }

    protected void onDestroy() {
        NetworkHelper.clearCookies((Context)this);
        super.onDestroy();
    }

    public boolean onKeyUp(int keyCode, KeyEvent event) {
        if (keyCode == 4) {
            this.mRequestParam.execRequest(this, 3);
            this.finish();
            return true;
        }
        return super.onKeyUp(keyCode, event);
    }

    private BrowserRequestParamBase createBrowserRequestParam(Bundle data) {
        BrowserRequestParamBase result = null;
        BrowserLauncher launcher = (BrowserLauncher)((Object)data.getSerializable("key_launcher"));
        if (launcher == BrowserLauncher.AUTH) {
            AuthRequestParam authRequestParam = new AuthRequestParam((Context)this);
            authRequestParam.setupRequestParam(data);
            this.installAuthWeiboWebViewClient(authRequestParam);
            result = authRequestParam;
            return result;
        }
        if (launcher == BrowserLauncher.SHARE) {
            ShareRequestParam shareRequestParam = new ShareRequestParam((Context)this);
            shareRequestParam.setupRequestParam(data);
            this.installShareWeiboWebViewClient(shareRequestParam);
            result = shareRequestParam;
        } else if (launcher == BrowserLauncher.WIDGET) {
            WidgetRequestParam widgetRequestParam = new WidgetRequestParam((Context)this);
            widgetRequestParam.setupRequestParam(data);
            this.installWidgetWeiboWebViewClient(widgetRequestParam);
            result = widgetRequestParam;
        }
        return result;
    }

    private boolean isWeiboShareRequestParam(BrowserRequestParamBase reqParam) {
        return reqParam.getLauncher() == BrowserLauncher.SHARE;
    }

    private void installAuthWeiboWebViewClient(AuthRequestParam param) {
        this.mWeiboWebViewClient = new AuthWeiboWebViewClient(this, param);
        this.mWeiboWebViewClient.setBrowserRequestCallBack(this);
    }

    private void installShareWeiboWebViewClient(ShareRequestParam param) {
        ShareWeiboWebViewClient client = new ShareWeiboWebViewClient(this, param);
        client.setBrowserRequestCallBack(this);
        this.mWeiboWebViewClient = client;
    }

    private void installWidgetWeiboWebViewClient(WidgetRequestParam param) {
        WidgetWeiboWebViewClient client = new WidgetWeiboWebViewClient(this, param);
        client.setBrowserRequestCallBack(this);
        this.mWeiboWebViewClient = client;
    }

    @Override
    public void onPageStartedCallBack(WebView view, String url, Bitmap favicon) {
        LogUtil.d(TAG, "onPageStarted URL: " + url);
        this.mUrl = url;
        if (!this.isWeiboCustomScheme(url)) {
            this.mHtmlTitle = "";
        }
    }

    @Override
    public boolean shouldOverrideUrlLoadingCallBack(WebView view, String url) {
        LogUtil.i(TAG, "shouldOverrideUrlLoading URL: " + url);
        return false;
    }

    @Override
    public void onPageFinishedCallBack(WebView view, String url) {
        LogUtil.d(TAG, "onPageFinished URL: " + url);
        if (this.isErrorPage) {
            this.promptError();
        } else {
            this.isErrorPage = false;
            this.hiddenErrorPrompt();
        }
    }

    @Override
    public void onReceivedErrorCallBack(WebView view, int errorCode, String description, String failingUrl) {
        LogUtil.d(TAG, "onReceivedError: errorCode = " + errorCode + ", description = " + description + ", failingUrl = " + failingUrl);
        this.handleReceivedError(view, errorCode, description, failingUrl);
    }

    @Override
    public void onReceivedSslErrorCallBack(WebView view, SslErrorHandler handler, SslError error) {
        LogUtil.d(TAG, "onReceivedSslErrorCallBack.........");
    }

    public static void closeBrowser(Activity act, String authListenerKey, String widgetRequestCallbackKey) {
        WeiboCallbackManager manager = WeiboCallbackManager.getInstance(act.getApplicationContext());
        if (!TextUtils.isEmpty((CharSequence)authListenerKey)) {
            manager.removeWeiboAuthListener(authListenerKey);
            act.finish();
        }
        if (!TextUtils.isEmpty((CharSequence)widgetRequestCallbackKey)) {
            manager.removeWidgetRequestCallback(widgetRequestCallbackKey);
            act.finish();
        }
    }

    private class WeiboChromeClient
    extends WebChromeClient {
        private WeiboChromeClient() {
        }

        public void onProgressChanged(WebView view, int newProgress) {
            WeiboSdkBrowser.this.mLoadingBar.drawProgress(newProgress);
            if (newProgress == 100) {
                WeiboSdkBrowser.this.isLoading = false;
                WeiboSdkBrowser.this.refreshAllViews();
            } else if (!WeiboSdkBrowser.this.isLoading) {
                WeiboSdkBrowser.this.isLoading = true;
                WeiboSdkBrowser.this.refreshAllViews();
            }
        }

        public void onReceivedTitle(WebView view, String title) {
            if (!WeiboSdkBrowser.this.isWeiboCustomScheme(WeiboSdkBrowser.this.mUrl)) {
                WeiboSdkBrowser.this.mHtmlTitle = title;
                WeiboSdkBrowser.this.updateTitleName();
            }
        }
    }
}

