/*
 * Decompiled with CFR 0.152.
 */
package com.sina.weibo.sdk.component;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.text.TextUtils;
import com.sina.weibo.sdk.component.BrowserLauncher;
import java.io.Serializable;

public abstract class BrowserRequestParamBase {
    public static final int EXEC_REQUEST_ACTION_OK = 1;
    public static final int EXEC_REQUEST_ACTION_ERROR = 2;
    public static final int EXEC_REQUEST_ACTION_CANCEL = 3;
    public static final String EXTRA_KEY_LAUNCHER = "key_launcher";
    protected static final String EXTRA_KEY_URL = "key_url";
    protected static final String EXTRA_KEY_SPECIFY_TITLE = "key_specify_title";
    protected Context mContext;
    protected String mUrl;
    protected BrowserLauncher mLaucher;
    protected String mSpecifyTitle;

    public BrowserRequestParamBase(Context context) {
        this.mContext = context.getApplicationContext();
    }

    public void setupRequestParam(Bundle data) {
        this.mUrl = data.getString(EXTRA_KEY_URL);
        this.mLaucher = (BrowserLauncher)((Object)data.getSerializable(EXTRA_KEY_LAUNCHER));
        this.mSpecifyTitle = data.getString(EXTRA_KEY_SPECIFY_TITLE);
        this.onSetupRequestParam(data);
    }

    protected abstract void onSetupRequestParam(Bundle var1);

    public Bundle createRequestParamBundle() {
        Bundle data = new Bundle();
        if (!TextUtils.isEmpty((CharSequence)this.mUrl)) {
            data.putString(EXTRA_KEY_URL, this.mUrl);
        }
        if (this.mLaucher != null) {
            data.putSerializable(EXTRA_KEY_LAUNCHER, (Serializable)((Object)this.mLaucher));
        }
        if (!TextUtils.isEmpty((CharSequence)this.mSpecifyTitle)) {
            data.putString(EXTRA_KEY_SPECIFY_TITLE, this.mSpecifyTitle);
        }
        this.onCreateRequestParamBundle(data);
        return data;
    }

    protected abstract void onCreateRequestParamBundle(Bundle var1);

    public abstract void execRequest(Activity var1, int var2);

    public void setUrl(String url) {
        this.mUrl = url;
    }

    public String getUrl() {
        return this.mUrl;
    }

    public void setLauncher(BrowserLauncher launcher) {
        this.mLaucher = launcher;
    }

    public BrowserLauncher getLauncher() {
        return this.mLaucher;
    }

    public void setSpecifyTitle(String title) {
        this.mSpecifyTitle = title;
    }

    public String getSpecifyTitle() {
        return this.mSpecifyTitle;
    }
}

