/*
 * Decompiled with CFR 0.152.
 */
package com.sina.weibo.sdk.auth.sso;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.text.TextUtils;
import com.sina.weibo.sdk.WbAppInstallActivator;
import com.sina.weibo.sdk.auth.AuthInfo;
import com.sina.weibo.sdk.auth.WeiboAuthListener;
import com.sina.weibo.sdk.component.AuthRequestParam;
import com.sina.weibo.sdk.component.WeiboSdkBrowser;
import com.sina.weibo.sdk.net.WeiboParameters;
import com.sina.weibo.sdk.utils.NetworkHelper;
import com.sina.weibo.sdk.utils.UIUtils;
import com.sina.weibo.sdk.utils.Utility;

class WebAuthHandler {
    private static final String TAG = WebAuthHandler.class.getName();
    private static final String NETWORK_NOT_AVAILABLE_EN = "Network is not available";
    private static final String NETWORK_NOT_AVAILABLE_ZH_CN = "\u65e0\u6cd5\u8fde\u63a5\u5230\u7f51\u7edc\uff0c\u8bf7\u68c0\u67e5\u7f51\u7edc\u914d\u7f6e";
    private static final String NETWORK_NOT_AVAILABLE_ZH_TW = "\u7121\u6cd5\u9023\u63a5\u5230\u7db2\u7edc\uff0c\u8acb\u6aa2\u67e5\u7db2\u7edc\u914d\u7f6e";
    private static final String OAUTH2_BASE_URL = "https://open.weibo.cn/oauth2/authorize?";
    private static final int OBTAIN_AUTH_CODE = 0;
    private static final int OBTAIN_AUTH_TOKEN = 1;
    private Context mContext;
    private AuthInfo mAuthInfo;

    public WebAuthHandler(Context context, AuthInfo authInfo) {
        this.mContext = context;
        this.mAuthInfo = authInfo;
    }

    public AuthInfo getAuthInfo() {
        return this.mAuthInfo;
    }

    public void anthorize(WeiboAuthListener listener) {
        this.authorize(listener, 1);
    }

    public void authorize(WeiboAuthListener listener, int type) {
        this.startDialog(listener, type);
        WbAppInstallActivator.getInstance(this.mContext, this.mAuthInfo.getAppKey()).activateWeiboInstall();
    }

    private void startDialog(WeiboAuthListener listener, int type) {
        if (listener == null) {
            return;
        }
        WeiboParameters requestParams = new WeiboParameters(this.mAuthInfo.getAppKey());
        requestParams.put("client_id", this.mAuthInfo.getAppKey());
        requestParams.put("redirect_uri", this.mAuthInfo.getRedirectUrl());
        requestParams.put("scope", this.mAuthInfo.getScope());
        requestParams.put("response_type", "code");
        requestParams.put("version", "0030105000");
        String aid = Utility.getAid(this.mContext, this.mAuthInfo.getAppKey());
        if (!TextUtils.isEmpty((CharSequence)aid)) {
            requestParams.put("aid", aid);
        }
        if (1 == type) {
            requestParams.put("packagename", this.mAuthInfo.getPackageName());
            requestParams.put("key_hash", this.mAuthInfo.getKeyHash());
        }
        String url = OAUTH2_BASE_URL + requestParams.encodeUrl();
        if (!NetworkHelper.hasInternetPermission(this.mContext)) {
            UIUtils.showAlert(this.mContext, "Error", "Application requires permission to access the Internet");
        } else {
            AuthRequestParam req = new AuthRequestParam(this.mContext);
            req.setAuthInfo(this.mAuthInfo);
            req.setAuthListener(listener);
            req.setUrl(url);
            req.setSpecifyTitle("\u5fae\u535a\u767b\u5f55");
            Bundle data = req.createRequestParamBundle();
            Intent intent = new Intent(this.mContext, WeiboSdkBrowser.class);
            intent.putExtras(data);
            this.mContext.startActivity(intent);
        }
    }
}

