/*
 * Decompiled with CFR 0.152.
 */
package com.sina.weibo.sdk.auth;

import android.os.Bundle;
import android.text.TextUtils;
import org.json.JSONException;
import org.json.JSONObject;

public class Oauth2AccessToken {
    private static final String KEY_UID = "uid";
    private static final String KEY_ACCESS_TOKEN = "access_token";
    private static final String KEY_EXPIRES_IN = "expires_in";
    private static final String KEY_REFRESH_TOKEN = "refresh_token";
    private String mUid = "";
    private String mAccessToken = "";
    private String mRefreshToken = "";
    private long mExpiresTime = 0L;

    public Oauth2AccessToken() {
    }

    @Deprecated
    public Oauth2AccessToken(String responseText) {
        if (responseText != null && responseText.indexOf("{") >= 0) {
            try {
                JSONObject json = new JSONObject(responseText);
                this.setUid(json.optString(KEY_UID));
                this.setToken(json.optString(KEY_ACCESS_TOKEN));
                this.setExpiresIn(json.optString(KEY_EXPIRES_IN));
                this.setRefreshToken(json.optString(KEY_REFRESH_TOKEN));
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
    }

    public Oauth2AccessToken(String accessToken, String expiresIn) {
        this.mAccessToken = accessToken;
        this.mExpiresTime = System.currentTimeMillis();
        if (expiresIn != null) {
            this.mExpiresTime += Long.parseLong(expiresIn) * 1000L;
        }
    }

    public static Oauth2AccessToken parseAccessToken(String responseJsonText) {
        if (!TextUtils.isEmpty((CharSequence)responseJsonText) && responseJsonText.indexOf("{") >= 0) {
            try {
                JSONObject json = new JSONObject(responseJsonText);
                Oauth2AccessToken token = new Oauth2AccessToken();
                token.setUid(json.optString(KEY_UID));
                token.setToken(json.optString(KEY_ACCESS_TOKEN));
                token.setExpiresIn(json.optString(KEY_EXPIRES_IN));
                token.setRefreshToken(json.optString(KEY_REFRESH_TOKEN));
                return token;
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public static Oauth2AccessToken parseAccessToken(Bundle bundle) {
        if (bundle != null) {
            Oauth2AccessToken accessToken = new Oauth2AccessToken();
            accessToken.setUid(Oauth2AccessToken.getString(bundle, KEY_UID, ""));
            accessToken.setToken(Oauth2AccessToken.getString(bundle, KEY_ACCESS_TOKEN, ""));
            accessToken.setExpiresIn(Oauth2AccessToken.getString(bundle, KEY_EXPIRES_IN, ""));
            accessToken.setRefreshToken(Oauth2AccessToken.getString(bundle, KEY_REFRESH_TOKEN, ""));
            return accessToken;
        }
        return null;
    }

    public boolean isSessionValid() {
        return !TextUtils.isEmpty((CharSequence)this.mAccessToken);
    }

    public Bundle toBundle() {
        Bundle bundle = new Bundle();
        bundle.putString(KEY_UID, this.mUid);
        bundle.putString(KEY_ACCESS_TOKEN, this.mAccessToken);
        bundle.putString(KEY_REFRESH_TOKEN, this.mRefreshToken);
        bundle.putString(KEY_EXPIRES_IN, Long.toString(this.mExpiresTime));
        return bundle;
    }

    public String toString() {
        return "uid: " + this.mUid + ", " + KEY_ACCESS_TOKEN + ": " + this.mAccessToken + ", " + KEY_REFRESH_TOKEN + ": " + this.mRefreshToken + ", " + KEY_EXPIRES_IN + ": " + Long.toString(this.mExpiresTime);
    }

    public String getUid() {
        return this.mUid;
    }

    public void setUid(String uid) {
        this.mUid = uid;
    }

    public String getToken() {
        return this.mAccessToken;
    }

    public void setToken(String mToken) {
        this.mAccessToken = mToken;
    }

    public String getRefreshToken() {
        return this.mRefreshToken;
    }

    public void setRefreshToken(String refreshToken) {
        this.mRefreshToken = refreshToken;
    }

    public long getExpiresTime() {
        return this.mExpiresTime;
    }

    public void setExpiresTime(long mExpiresTime) {
        this.mExpiresTime = mExpiresTime;
    }

    public void setExpiresIn(String expiresIn) {
        if (!TextUtils.isEmpty((CharSequence)expiresIn) && !expiresIn.equals("0")) {
            this.setExpiresTime(System.currentTimeMillis() + Long.parseLong(expiresIn) * 1000L);
        }
    }

    private static String getString(Bundle bundle, String key, String defaultValue) {
        if (bundle != null) {
            String value = bundle.getString(key);
            return value != null ? value : defaultValue;
        }
        return defaultValue;
    }
}

