/*
 * Decompiled with CFR 0.152.
 */
package com.sina.weibo.sdk;

import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import android.os.Bundle;
import android.os.Environment;
import android.text.TextUtils;
import android.util.Pair;
import com.sina.weibo.sdk.WeiboAppManager;
import com.sina.weibo.sdk.exception.WeiboException;
import com.sina.weibo.sdk.net.AsyncWeiboRunner;
import com.sina.weibo.sdk.net.DownloadService;
import com.sina.weibo.sdk.net.RequestListener;
import com.sina.weibo.sdk.net.WeiboParameters;
import com.sina.weibo.sdk.utils.LogUtil;
import com.sina.weibo.sdk.utils.MD5;
import com.sina.weibo.sdk.utils.NetworkHelper;
import com.sina.weibo.sdk.utils.NotificationHelper;
import com.sina.weibo.sdk.utils.Utility;
import java.io.File;
import java.util.concurrent.CountDownLatch;
import org.json.JSONException;
import org.json.JSONObject;

public class WbAppInstallActivator {
    private static final String TAG = WbAppInstallActivator.class.getName();
    public static final String WB_APK_FILE_DIR = Environment.getExternalStorageDirectory() + "/Android/org_share_data/";
    private Context mContext;
    private static WbAppInstallActivator mInstance;
    private CountDownLatch mCountDownlatch;
    private NotificationInfo mNotificationInfo;
    private String mAppkey;
    private boolean isFree = true;

    private WbAppInstallActivator(Context ctx, String appkey) {
        this.mContext = ctx.getApplicationContext();
        this.mAppkey = appkey;
    }

    public static synchronized WbAppInstallActivator getInstance(Context ctx, String appkey) {
        if (mInstance == null) {
            mInstance = new WbAppInstallActivator(ctx, appkey);
        }
        return mInstance;
    }

    public void activateWeiboInstall() {
        boolean needActivate;
        WeiboAppManager.WeiboInfo mWeiboInfo = WeiboAppManager.getInstance(this.mContext).getWeiboInfo();
        boolean bl = needActivate = mWeiboInfo == null || !mWeiboInfo.isLegal();
        if (needActivate && this.isFree) {
            this.isFree = false;
            this.mCountDownlatch = new CountDownLatch(1);
            this.loadNotificationInfo();
            final String dir = WB_APK_FILE_DIR;
            new Thread(new Runnable(){

                @Override
                public void run() {
                    Pair pair = WbAppInstallActivator.walkDir(WbAppInstallActivator.this.mContext, dir);
                    try {
                        try {
                            WbAppInstallActivator.this.mCountDownlatch.await();
                            if (WbAppInstallActivator.this.mNotificationInfo != null && WbAppInstallActivator.this.mNotificationInfo.isNotificationInfoValid()) {
                                String url = WbAppInstallActivator.this.mNotificationInfo.downloadUrl;
                                String content = WbAppInstallActivator.this.mNotificationInfo.notificationContent;
                                if (pair != null && pair.second != null && (Integer)pair.first >= WbAppInstallActivator.this.mNotificationInfo.versionCode) {
                                    WbAppInstallActivator.showNotification(WbAppInstallActivator.this.mContext, content, ((File)pair.second).getAbsolutePath());
                                } else if (NetworkHelper.isWifiValid(WbAppInstallActivator.this.mContext) && !TextUtils.isEmpty((CharSequence)url)) {
                                    WbAppInstallActivator.startDownloadService(WbAppInstallActivator.this.mContext, content, url);
                                }
                            }
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                            WbAppInstallActivator.this.isFree = true;
                        }
                    }
                    finally {
                        WbAppInstallActivator.this.isFree = true;
                    }
                }
            }).start();
        }
    }

    private void loadNotificationInfo() {
        String appkey = this.mAppkey;
        WbAppInstallActivator.requestNotificationInfo(this.mContext, appkey, new RequestListener(){

            @Override
            public void onWeiboException(WeiboException e) {
                LogUtil.d(TAG, "requestNotificationInfo WeiboException Msg : " + e.getMessage());
                WbAppInstallActivator.this.mCountDownlatch.countDown();
            }

            @Override
            public void onComplete(String response) {
                WbAppInstallActivator.this.mNotificationInfo = new NotificationInfo(response);
                WbAppInstallActivator.this.mCountDownlatch.countDown();
            }
        });
    }

    private static Pair<Integer, File> walkDir(Context ctx, String dir) {
        if (TextUtils.isEmpty((CharSequence)dir)) {
            return null;
        }
        File dirFile = new File(dir);
        if (!dirFile.exists() || !dirFile.isDirectory()) {
            return null;
        }
        File[] files = dirFile.listFiles();
        if (files == null) {
            return null;
        }
        int newestVersion = 0;
        File weiboApkFile = null;
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            PackageManager packageManager;
            PackageInfo pkgInfo;
            boolean isWeiboApk;
            File file = fileArray[n2];
            String fileName = file.getName();
            if (file.isFile() && fileName.endsWith(".apk") && (isWeiboApk = WbAppInstallActivator.isWeiboApk(pkgInfo = (packageManager = ctx.getPackageManager()).getPackageArchiveInfo(file.getAbsolutePath(), 64))) && pkgInfo.versionCode > newestVersion) {
                newestVersion = pkgInfo.versionCode;
                weiboApkFile = file;
            }
            ++n2;
        }
        return new Pair((Object)newestVersion, weiboApkFile);
    }

    private static boolean isWeiboApk(PackageInfo pkgInfo) {
        return WbAppInstallActivator.checkPackageName(pkgInfo) && WbAppInstallActivator.checkApkSign(pkgInfo);
    }

    private static boolean checkPackageName(PackageInfo pkgInfo) {
        if (pkgInfo == null) {
            return false;
        }
        String pkgName = pkgInfo.packageName;
        return "com.sina.weibo".equals(pkgName) || "com.sina.weibog3".equals(pkgName);
    }

    private static boolean checkApkSign(PackageInfo pkgInfo) {
        if (pkgInfo == null) {
            return false;
        }
        if (pkgInfo.signatures == null) {
            return Build.VERSION.SDK_INT < 11;
        }
        String md5Sign = "";
        int j = 0;
        while (j < pkgInfo.signatures.length) {
            byte[] str = pkgInfo.signatures[j].toByteArray();
            if (str != null) {
                md5Sign = MD5.hexdigest(str);
            }
            ++j;
        }
        return "18da2bf10352443a00a5e046d9fca6bd".equals(md5Sign);
    }

    private static void requestNotificationInfo(Context ctx, String appkey, RequestListener listener) {
        String url = "http://api.weibo.cn/2/client/common_config";
        String pkgName = ctx.getPackageName();
        String keyHash = Utility.getSign(ctx, pkgName);
        WeiboParameters params = new WeiboParameters(appkey);
        params.put("appkey", appkey);
        params.put("packagename", pkgName);
        params.put("key_hash", keyHash);
        new AsyncWeiboRunner(ctx).requestAsync("http://api.weibo.cn/2/client/common_config", params, "GET", listener);
    }

    private static void showNotification(Context ctx, String notifyContent, String apkFilePath) {
        if (TextUtils.isEmpty((CharSequence)notifyContent)) {
            return;
        }
        NotificationHelper.showNotification(ctx, notifyContent, apkFilePath);
    }

    private static void startDownloadService(Context ctx, String notificationContent, String downloadUrl) {
        Intent intent = new Intent(ctx, DownloadService.class);
        Bundle bundle = new Bundle();
        bundle.putString("notification_content", notificationContent);
        bundle.putString("download_url", downloadUrl);
        intent.putExtras(bundle);
        ctx.startService(intent);
    }

    public static class NotificationInfo {
        private String notificationContent;
        private String downloadUrl;
        private int versionCode;

        public String getNotificationContent() {
            return this.notificationContent;
        }

        public void setNotificationContent(String notificationContent) {
            this.notificationContent = notificationContent;
        }

        public String getDownloadUrl() {
            return this.downloadUrl;
        }

        public void setDownloadUrl(String downloadUrl) {
            this.downloadUrl = downloadUrl;
        }

        public int getVersionCode() {
            return this.versionCode;
        }

        public void setVersionCode(int versionCode) {
            this.versionCode = versionCode;
        }

        public NotificationInfo(String jsonStr) {
            try {
                JSONObject resObj = new JSONObject(jsonStr);
                if (resObj.has("error") || resObj.has("error_code")) {
                    LogUtil.d(TAG, "parse NotificationInfo error !!!");
                } else {
                    this.downloadUrl = resObj.optString("sdk_url", "");
                    this.notificationContent = resObj.optString("sdk_push", "");
                    this.versionCode = resObj.optInt("version_code");
                }
            }
            catch (JSONException e) {
                LogUtil.d(TAG, "parse NotificationInfo error: " + e.getMessage());
            }
        }

        public boolean isNotificationInfoValid() {
            return !TextUtils.isEmpty((CharSequence)this.notificationContent);
        }
    }
}

