Code And Talk
=============
[![Build Status](https://travis-ci.org/szabgab/codeandtalk.com.png)](https://travis-ci.org/szabgab/codeandtalk.com)
[![Build status](https://ci.appveyor.com/api/projects/status/3xped6coon603v9k?svg=true)](https://ci.appveyor.com/project/szabgab/codeandtalk-com/)
[![Coverage Status](https://coveralls.io/repos/github/szabgab/codeandtalk.com/badge.svg?branch=main)](https://coveralls.io/github/szabgab/codeandtalk.com?branch=main)

List of tech conferences, podcasts, videos, and people:
==================================================

For more details on CONTRIBUTING visit the respective files:

[Conferences](docs/EVENTS.md)

[Videos](docs/VIDEOS.md)

[Podcasts](docs/PODCASTS.md)

[People](docs/PEOPLE.md)

[Tags](docs/TAGS.md)

SETUP
------
```
virtualenv venv -p python3
source venv/bin/activate
pip install --editable .
```

Running unit tests
------------------
```
$ pytest
```

```
CAT_TEST=test_data/1 ./bin/generate.py
```


Generate web site (and check format)
-----------------------------------
```
$ python3 bin/generate.py
```

The file `generate.log` will contain the log generated by the process.


Development server
-------------------
```
FLASK_APP=cat.app FLASK_DEBUG=1 flask run --host 0.0.0.0 --port 5000
```

Visit http://127.0.0.1:5000/


Site layout
------------
```
/
/p/person-code
/s/source
/t/tag
```

Other sources
------
https://techpoint.ng/2016/09/14/hackjos-2016-2/

Promotion
------------
After watching videos, they might be promoted via various channels.

* Posted to the appropriate subreddit at https://www.reddit.com/
* Posted at HackerNews: https://news.ycombinator.com/
* Marked as "featured" and included in one of the blasters: https://codeandtalk.com/blasters
* Tweeted via https://twitter.com/codeandtalk
* Posted on the Facebook page: https://facebook.com/CodeAndTalk


Some Advice to Conference organizers
--------------------------------------
Just a few random thoughts as I index the videos and the conferences.

* If you record lightning talks, split them up into individual videos. That allows people to watch one short video while at work.
* Include the names of the speakers in the filenames.

* Keep the web site of the previous editions of your event, or at least keep the list of talks and list of people.
* The best would be to have well-defined URLs. Some conferences have subdomains per year: http://2017.someevent.com/ Other have them in subdirectory: http://someevent.com/2017/ Both are good. The best if the main page only redirects to the current event or holds some content, but each event has its own subsite. Make sure every page of the earlier events has a prominent link at the top linking to the home page of the conference (which can then redirect to the current or upcoming event).

* On the speaker page include the Twitter and GitHub IDs of each speaker.

* https://www.sli.do/ Seems like a nice way to collect questions and get the audience vote for them.


Ideas for Conferences and other events
---------------------------------------
* Giving a talk (ok, this is the obvious)
* Improv sessions https://codeandtalk.com/v/agile-india-2016/3-minute-improv-games-to-improve-your-teams-by-wayde-stallmann
* Matching up mentors and mentees https://codeandtalk.com/v/clojure-conj-2016/overcoming-the-challenges-of-mentoring-kim-crayton
  The idea would be to do a much shorter talk and spend a lot more time on matching mentors and mentees.
* Building a startup around conversations and communities
  https://codeandtalk.com/v/agile-india-2016/building-a-startup-around-conversations-and-communities-by-zainab-bawa
* Personal vision exercise: https://codeandtalk.com/v/agile-india-2016/giving-the-enterprise-focus-through-a-compelling-shared-vision-by-susan-gibson

* Mostly after hours:
  * BOF (Birds of Feather) sessions - people can organize meetings based on a specific subject.
  * Dinner with all the attendees
  * Speaker's dinner (can provide a place to socialize)
  * Hackathons - these usually happen on the day(s) before or after the conference, but not during the conference.
      They also seem to be a bit solitary programming.
  * Game night (playing board games, cards) just socializing
* Scavenger hunt (described in AB Testing podcast episode 48-49 https://github.com/szabgab/ab-testing


Process with command line Git client
--------------------------------------
* In the GitHub interface visit the project https://github.com/szabgab/codeandtalk.com and click on the "Fork" button (top right).
It will create a copy in your own user. If you are called ```foobar``` it will be called https://github.com/foobar/codeandtalk.com

* On your command line (Linux terminal or Windows Cmd) type in

`git clone git@github.com:foobar/codeandtalk.com.git`

It will clone (copy) the whole repository from your GitHub homedirectory.

```
cd codeandtalk.com

git remote add upstream https://github.com/szabgab/codeandtalk.com.git
```

Now you can edit the files in the `data` directory and add more files you need.

If you'd like to check if the files work well together type in

`python bin/generate.py`



Instruction on Windows
----------------------
* Install Python 3.x.x from https://www.python.org/downloads/windows/
* While installing, look out for an option to install Python in the path, and select it. Don't worry if you missed it,
  instructions follow for how to install Python in the path afterwards.
* Open the command window (Start/Run PowerShell)
* Type in `python --version` to check if the installation worked as expected. It should say something like "Python 3.5.2"
  If it says `Python` is not recognized as an internal or external command, operable program or batch file"
  then you need to configure the PATH environment variable to include the directory of python.exe
  One way is to enter the following in the command prompt: just replace 'gabor' with your username:
  `set PATH=C:\Users\gabor\AppData\Local\Programs\Python\Python35-32\;%PATH%`
  Then try `python --version` again.

* Type in `pip install jinja2 flask pyquery`  
* cd to the codeandtalk.com/ directory
* Type `python bin/generate.py`   If there is an error in the files, it will complain.
* If everything works fine the web site is generated in the html/ directory.
* Here are the commands to get started on PowerShell:

  ```
  $env:FLASK_APP="cat\\app.py"
  $env:FLASK_DEBUG=1
  flask run --host 0.0.0.0 --port 5000
  ```

* Go to your browser and visit http://127.0.0.1:5000/
  The updated site should be there.
