import { Injectable } from '@angular/core';

export interface Block {
  name: string;
  title: string;
  description?: string;
  url: string;
  componentName: string;
}

export interface BlockList {
  name: string;
  description: string;
  category: string;
  isNew: boolean;
  url: string;
  subBlockList: Block[];
}

@Injectable({
  providedIn: 'root'
})
export class DataService {
  private themeName: string = 'tailwind';
  private categoryIndex: number = 0;

  private readonly signinBlockList: Block[] = [
    { name: 'Sign In', title: 'Simple Sign-In', description: 'In this demo, the sign-in interface offers a simple and intuitive authentication process.', componentName: 'signin-1', url: 'signin-1' },
    { name: 'Sign In', title: 'Sign-In with Visual Background', description: 'In this demo, the split-screen sign-in interface blends visual appeal with usability. One side showcases an image that enhances the overall aesthetic, while the other features a simple, intuitive sign-in form for a smooth authentication experience.', componentName: 'signin-2', url: 'signin-2' },
    { name: 'Sign In', title: 'Sign-In with Feature Highlights', description: 'In this demo, the sign-in form is integrated into a two-part screen layout. One side features a background and highlights key points of the application in a clear, listed format, while the other presents a simple, intuitive sign-in form.', componentName: 'signin-3', url: 'signin-3' }
  ];

  private readonly signoutBlockList: Block[] = [
    { name: 'Sign Out', title: 'Simple Sign-Out', description: 'In this demo, the sign-out interface provides a simple confirmation message upon successful logout.', componentName: 'signout-1', url: 'signout-1' },
    { name: 'Sign Out', title: 'Sign-Out with Visual Background', description: 'In this demo, the split-screen sign-out interface blends visual appeal with usability. One side showcases an image that enhances the overall aesthetic, while the other displays a simple, straightforward confirmation of the sign-out.', componentName: 'signout-2', url: 'signout-2' },
    { name: 'Sign Out', title: 'Sign-Out with Feature Highlights', description: 'In this demo, the sign-out confirmation is integrated into a two-part screen layout. One side features a background that highlights key points of the application in a clear, listed format, while the other displays a simple, straightforward confirmation of the sign-out.', componentName: 'signout-3', url: 'signout-3' }
  ];

  private readonly signupBlockList: Block[] = [
    { name: 'Sign Up', title: 'Simple Sign-Up', description: 'In this demo, the sign-up interface provides a simple yet intuitive registration process.', componentName: 'signup-1', url: 'signup-1' },
    { name: 'Sign Up', title: 'Sign-Up with Visual Background', description: 'In this demo, the split-screen sign-up interface blends visual appeal with usability. One side showcases an image that enhances the overall aesthetic, while the other features a simple, intuitive sign-up form, making the registration process smooth and user-friendly.', componentName: 'signup-2', url: 'signup-2' },
    { name: 'Sign Up', title: 'Sign-Up with Feature Highlights', description: 'In this demo, the sign-up form is integrated into a two-part screen layout. One side features a background that highlights key points of the application in a clear, listed format, while the other presents a simple, intuitive sign-up form.', componentName: 'signup-3', url: 'signup-3' }
  ];

  private readonly signinMobileBlockList: Block[] = [
    { name: 'Mobile - Sign In', title: 'Simple Mobile Sign In', description: 'In this demo, the sign-in with mobile number interface offers a simple and intuitive login process.', componentName: 'signin-mobile-1', url: 'signin-mobile-1' },
    { name: 'Mobile - Sign In', title: 'Mobile Sign In with Visual Background', description: 'In this demo, the split-screen sign-in interface seamlessly blends visual appeal with functional usability. One side showcases an engaging image that enhances the overall aesthetic, while the other features a simple, intuitive form for signing in using a mobile number, making the authentication process quick and easy.', componentName: 'signin-mobile-2', url: 'signin-mobile-2' },
    { name: 'Mobile - Sign In', title: 'Mobile Sign In with Feature Highlights', description: 'In this demo, the sign-in form is integrated into a two-part screen layout. One side features a background that highlights key points of the application in a clear, listed format, while the other presents a simple, intuitive sign-in form with the option to log in using a mobile number.', componentName: 'signin-mobile-3', url: 'signin-mobile-3' }
  ];

  private readonly unlockSessionBlockList: Block[] = [
    { name: 'Unlock Session', title: 'Simple Session Unlock', description: 'In this demo, the unlock session interface provides a simple and secure method to regain access to an expired or locked session.', componentName: 'unlock-session-1', url: 'unlock-session-1' },
    { name: 'Unlock Session', title: 'Session Unlock with Visual Background', description: 'In this demo, the split-screen unlock session interface seamlessly blends visual appeal with functional usability. One side showcases an engaging image that enhances the overall aesthetic, while the other features a simple, intuitive form where users can unlock their session by entering their email address, providing a quick and easy way to regain access.', componentName: 'unlock-session-2', url: 'unlock-session-2' },
    { name: 'Unlock Session', title: 'Session Unlock with Feature Highlights', description: 'In this demo, the unlock session is seamlessly integrated into a two-part screen layout. One side features an inviting background that highlights key points of the application in a clear, listed format, while the other presents a simple, intuitive form where users can unlock their session by entering their email address.', componentName: 'unlock-session-3', url: 'unlock-session-3' }
  ];

  private readonly forgotPasswordBlockList: Block[] = [
    { name: 'Forgot Password', title: 'Simple Password Recovery', description: 'In this demo, the forgot password interface offers a straightforward process for recovering account access.', componentName: 'forgot-password-1', url: 'forgot-password-1' },
    { name: 'Forgot Password', title: 'Password Recovery with Visual Background', description: 'In this demo, the split-screen forgot password interface seamlessly blends visual appeal with usability. One side showcases an image that enhances the overall aesthetic, while the other features a simple, intuitive form where users can reset their password by entering their email address.', componentName: 'forgot-password-2', url: 'forgot-password-2' },
    { name: 'Forgot Password', title: 'Password Recovery with Feature Highlights', description: 'In this demo, the forgot password block is integrated into a two-part screen layout. One side features a background that highlights key points of the application in a clear, listed format, while the other presents a simple, intuitive form where users can reset their password by entering their email address.', componentName: 'forgot-password-3', url: 'forgot-password-3' }
  ];

  private readonly signinOTPBlockList: Block[] = [
    { name: 'OTP - Sign In', title: 'Simple OTP Sign-In', description: 'In this demo, the sign-in with OTP interface provides a quick and secure authentication process using a one-time password.', componentName: 'signin-otp-1', url: 'signin-otp-1' },
    { name: 'OTP - Sign In', title: 'OTP Sign-In with Visual Background', description: 'In this demo, the split-screen sign-in interface seamlessly blends visual appeal with functional usability. One side showcases an image that enhances the overall aesthetic, while the other features a simple, intuitive form for signing in using an OTP, providing a secure and efficient way to authenticate.', componentName: 'signin-otp-2', url: 'signin-otp-2' },
    { name: 'OTP - Sign In', title: 'OTP Sign-In with Feature Highlights', description: 'In this demo, the sign-in form is integrated into a two-part screen layout. One side features a background that highlights key points of the application in a clear, listed format, while the other presents a simple, intuitive sign-in form with the option to log in using an OTP.', componentName: 'signin-otp-3', url: 'signin-otp-3' }
  ];

  private readonly pricingCardBlockList: Block[] = [
    { name: 'Pricing Card', title: 'Simple Pricing Card', description: 'In this demo, the pricing layout features a clean and intuitive design for displaying lifetime membership pricing information. Users can easily toggle between monthly and yearly pricing options using an interactive switch. A prominent CTA button is provided, enabling users to select the plan.', componentName: 'pricing-card-1', url: 'pricing-card-1' },
    { name: 'Pricing Card', title: 'Pricing Card with Benefit Highlights', description: 'In this demo, the pricing layout features a clean and intuitive design for displaying lifetime membership pricing information. Users can easily toggle between monthly and yearly pricing options using an interactive switch. The layout also highlights key membership benefits, helping users understand the value of the plan. A prominent CTA button is provided, enabling users to select the plan.', componentName: 'pricing-card-2', url: 'pricing-card-2' },
    { name: 'Pricing Card', title: 'Two-Tier Pricing Card', description: 'In this demo, the pricing layout features a clean and intuitive design for displaying two distinct business plan options. Users can easily toggle between monthly and yearly pricing options using an interactive switch. A prominent CTA button is provided for each plan, allowing users to select their preferred option.', componentName: 'pricing-card-3', url: 'pricing-card-3' },
    { name: 'Pricing Card', title: 'Two-Tier Pricing Card with Benefit Highlights', description: 'In this demo, the pricing layout features a clean design for displaying two distinct plan options. Users can easily toggle between monthly and yearly pricing options using an interactive switch. The layout highlights the unique benefits of each plan, helping users understand the difference between the options. A prominent CTA button is provided for each plan, allowing users to select their preferred option.', componentName: 'pricing-card-4', url: 'pricing-card-4' },
    { name: 'Pricing Card', title: 'Three-Tier Pricing  Card', description: 'In this demo, the pricing layout design displays three distinct subscription options. Users can toggle between monthly and yearly pricing options using an interactive switch. A CTA button is provided for each plan, allowing users to select their preferred option.', componentName: 'pricing-card-5', url: 'pricing-card-5' },
    { name: 'Pricing Card', title: 'Three-Tier Pricing  Card with Benefit Highlights', description: 'In this demo, the pricing layout has an intuitive design for displaying three distinct subscription options. Users can toggle between monthly and yearly pricing using a switch. The layout highlights the benefits of each plan, helping users understand the differences among them. CTA buttons allow users to select their preferred option.', componentName: 'pricing-card-6', url: 'pricing-card-6' }
  ];

  private readonly planComparisonBlockList: Block[] = [
    { name: 'Plan Comparison', title: 'Plan Comparison by Highlights', description: 'In this demo, the comparison table offers a clean and intuitive design for comparing features across different plans. Users can easily view the key differences among the plans, helping them make an informed decision based on their specific needs. The features are clearly displayed for easy comparison.', componentName: 'plan-comparison-1', url: 'plan-comparison-1' },
    { name: 'Plan Comparison', title: 'Pricing Plan Comparison by Highlights', description: 'In this demo, the comparison table displays three plans side by side, highlighting the differences in features. The first plan is an entry-level option, while the second and third plans offer more advanced features. Each plan includes a CTA button, enabling users to choose the plan that best suits their purpose.', componentName: 'plan-comparison-2', url: 'plan-comparison-2' }
  ];

  private readonly checkoutBlockList: Block[] = [
    { name: 'Checkout', title: 'Simple Checkout', description: 'In this demo, the checkout process collects delivery details, provides multiple payment and shipping options, and displays a clear order summary with tax and discounts. The simple layout guides users through shipping, payment, and order review.', componentName: 'checkout-1', url: 'checkout-1' },
    { name: 'Checkout', title: 'Checkout Using Accordion', description: 'In this demo, the accordion-style checkout process gathers information through collapsible sections, such as delivery details, payment methods, and product summary. The structured layout streamlines the process, breaking it into clear, manageable steps with a clean, user-friendly design.', componentName: 'checkout-2', url: 'checkout-2' },
    { name: 'Checkout', title: 'Checkout Showing Product Details', description: 'In this demo, the two-column checkout layout displays a detailed product list with thumbnail images and an order summary on one side, and sections for billing, shipping, and payment options on the other.', componentName: 'checkout-3', url: 'checkout-3' },
    { name: 'Checkout', title: 'Checkout Using Side Panel', description: 'In this demo, the checkout page is designed within a sidebar panel that displays the order summary along with sections for billing, shipping, and payment options.', componentName: 'checkout-4', url: 'checkout-4' },
    { name: 'Checkout', title: 'Checkout Using Model', description: 'In this demo, the checkout page is designed within a model dialog that displays the order summary along with sections for billing, shipping, and payment options.', componentName: 'checkout-5', url: 'checkout-5' }
  ];

  private readonly gridBlockList: Block[] = [
    { name: 'Grid', title: 'Lead Management Table', description: 'In this demo, you will find a table displaying a list of leads with relevant details across multiple columns. This layout provides a clear, structured view, making it easy to organize, manage, and efficiently track leads for prioritization.', componentName: 'grid-1', url: 'grid-1' },
    { name: 'Grid', title: 'Network Support Ticket Table', description: 'In this demo, you will find a table displaying support tickets for the network team, with relevant details across multiple columns. This layout provides a clear, structured view, enabling easy organizing and efficient tracking of support requests.', componentName: 'grid-2', url: 'grid-2' },
    { name: 'Grid', title: 'Invoice Record Table', description: 'In this demo, you will find a table displaying detailed invoice information across multiple columns. This layout provides a clear, structured view, improving operational efficiency in managing and tracking invoices.', componentName: 'grid-3', url: 'grid-3' },
    { name: 'Grid', title: 'Contact Directory Table', description: 'In this demo, you will find a table displaying a contacts list with essential information across multiple columns. This layout provides a clear, structured view, enhancing workflow efficiency in managing and accessing contact details.', componentName: 'grid-4', url: 'grid-4' },
    { name: 'Grid', title: 'Asset Management Table', description: 'In this demo, you will find a table displaying asset management details across multiple columns. This layout provides a clear, structured view, enhancing process efficiency in tracking and managing assets effectively.', componentName: 'grid-5', url: 'grid-5' },
    { name: 'Grid', title: 'Transaction Record Table', description: 'In this demo, you will find a table displaying detailed transaction information across multiple columns. This layout provides a clear, structured view, enhancing financial efficiency in managing and tracking financial transactions.', componentName: 'grid-6', url: 'grid-6' },
    { name: 'Grid', title: 'Product Sales Table', description: 'In this demo, you will find a table displaying key details of sales transactions across multiple columns. This layout provides a clear, structured view, enhancing sales efficiency in tracking and managing sales data effectively.', componentName: 'grid-7', url: 'grid-7' },
    { name: 'Grid', title: 'Sales Performance Table', description: 'In this demo, you will find a table displaying key performance metrics for sales team members across multiple columns. This layout provides a clear, structured view, enhancing performance efficiency in tracking and evaluating their contributions and performance levels.', componentName: 'grid-8', url: 'grid-8' },
    { name: 'Grid', title: 'Roles and Permissions Table', description: 'In this demo, you will find a table displaying various user roles and their associated permissions across multiple columns. This layout provides a clear, structured view, enhancing administrative efficiency in managing access controls and user rights effectively.', componentName: 'grid-9', url: 'grid-9' },
    { name: 'Grid', title: 'Product Sales Analysis Table', description: 'In this demo, you will find a table displaying detailed sales data for each product across multiple columns. This layout provides a clear, structured view, enhancing analytical efficiency in tracking sales performance and managing inventory.', componentName: 'grid-10', url: 'grid-10' }
  ];

  private readonly navbarBlockList: Block[] = [
    { name: 'Navbar', title: 'Simple Navbar', description: 'In the demo, the navigation bar is showcased, featuring the company logo and name on the left. It includes a search feature for quick content access, an option to add new widgets, menu icons for easy navigation, and a user profile section. On tablet and mobile devices, the layout adjusts to fit the screen, ensuring an optimized viewing experience.', componentName: 'navbar-1', url: 'navbar-1' },
    { name: 'Navbar', title: 'Navbar with Menu and other options', description: 'In this demo, a double navigation bar is exhibited. The top bar prominently displays the company logo and name, along with primary navigation links, an upgrade button, menu icons for easy navigation, and a user profile section. The bottom bar provides secondary navigation links and a search bar for easy access to content. On tablet and mobile devices, the layout adjusts to fit the screen, ensuring an optimized viewing experience.', componentName: 'navbar-2', url: 'navbar-2' },
    { name: 'Navbar', title: 'Navbar with Menu and Dropdown', description: 'In this demo, a double navigation bar is exhibited. The top bar prominently displays the company logo and name, along with menu icons for easy navigation and dropdowns for selecting a location and contact. The bottom bar provides additional navigation options. On tablet and mobile devices, the layout adjusts to fit the screen, ensuring an optimized viewing experience.', componentName: 'navbar-3', url: 'navbar-3' },
    { name: 'Navbar', title: 'Navbar with Menu and Search', description: 'In this demo, a double navigation bar is exhibited. The top bar prominently displays the company logo and name, along with primary navigation links, menu icons for easy navigation, a dropdown, and a user profile section. The bottom bar provides a search bar for easy access to content. On tablet and mobile devices, the layout adjusts to fit the screen, ensuring an optimized viewing experience.', componentName: 'navbar-4', url: 'navbar-4' },
    { name: 'Navbar', title: 'Navbar with Menu and Breadcrumb', description: 'In this demo, a three-tier navigation bar is exhibited. The top bar prominently displays the company logo and name, along with a search option, menu icons for easy navigation, and a user profile section. The middle bar includes breadcrumbs for quick navigation, along with dropdown options for additional selections. The bottom bar provides other navigation links. On tablet and mobile devices, the layout adjusts to fit the screen, ensuring an optimized viewing experience.', componentName: 'navbar-5', url: 'navbar-5' },
    { name: 'Navbar', title: 'Navbar with Multiple Options', description: 'In this demo, a three-tier navigation bar is exhibited. The top bar prominently displays the company logo and name, along with a user profile section and primary menu navigation links. The middle bar includes secondary menu navigation links. The bottom bar provides a search option and call-to-action (CTA) buttons. On tablet and mobile devices, the layout adjusts to fit the screen, ensuring an optimized viewing experience.', componentName: 'navbar-6', url: 'navbar-6' }
  ];

  private readonly sidebarBlockList: Block[] = [
    { name: 'Sidebar', title: 'Simple Sidebar', description: 'In this demo, you will find the organization name displayed at the top of the sidebar, followed by a list of navigation menu items for easy access to key sections of the application. Below that, an accordion-style list presents additional items that can be expanded or collapsed, providing a compact and organized way to manage related content and actions.', componentName: 'sidebar-1', url: 'sidebar-1' },
    { name: 'Sidebar', title: 'Sidebar with Alert Notification', description: 'In this demo, we’ve built upon the previous setup by adding alert notifications that dynamically pop up within the sidebar. These notifications keep users informed of important updates in real time, without disrupting their workflows.', componentName: 'sidebar-2', url: 'sidebar-2' },
    { name: 'Sidebar', title: 'Profile Sidebar', description: 'In this demo, the sidebar is organized with the user profile image, name, and email ID at the top for quick identification. Below this, a list of navigation items provides quick links to important sections of the application. The logout button at the bottom ensures a seamless and secure sign-out process.', componentName: 'sidebar-3', url: 'sidebar-3' },
    { name: 'Sidebar', title: 'Sales and Revenue Sidebar', description: 'In this demo, the sidebar features a user profile with toggle options, followed by a search field for quick access to projects. Below that, several navigation items are organized into two categories. The second category allows users to add options dynamically, providing a customizable and flexible navigation experience.', componentName: 'sidebar-4', url: 'sidebar-4' },
    { name: 'Sidebar', title: 'Sidebar with Multiple Alert Notifications', description: 'In this demo, we’ve built on the previous setup by adding multiple alert notifications that dynamically appear within the sidebar. These notifications keep users informed of all important updates in real time, without interrupting their workflows.', componentName: 'sidebar-5', url: 'sidebar-5' },
    { name: 'Sidebar', title: 'Project Sidebar with Settings', description: 'In this demo, the sidebar displays a user profile with toggle options. Below the profile, the navigation items are grouped into two categories, with the second category allowing users to dynamically add options for a more customizable navigation experience. At the bottom, there are options for settings, as well as help and getting started resources.', componentName: 'sidebar-6', url: 'sidebar-6' },
    { name: 'Sidebar', title: 'Profile Sidebar with Storage and Upgrade Button', description: 'In this demo, the sidebar features a user profile with toggle options, followed by a search field for quick access to projects. Below that, several navigation items are listed, and at the bottom, a progress bar displays storage usage along with an action button for upgrading the account.', componentName: 'sidebar-7', url: 'sidebar-7' },
    { name: 'Sidebar', title: 'User and Contact Sidebar', description: 'In this demo, the sidebar features a user profile with toggle options, followed by grouped navigation items. Below that, a section highlights active users with their profile images and names, providing easy access.', componentName: 'sidebar-8', url: 'sidebar-8' },
    { name: 'Sidebar', title: 'Nested Sidebar', description: 'In this demo, the sidebar is nested, with quick access options on the left and standard navigation items on the right.', componentName: 'sidebar-9', url: 'sidebar-9' },
    { name: 'Sidebar', title: 'Quick Access Sidebar', description: 'In this demo, the sidebar features a minimalistic design with only quick access options.', componentName: 'sidebar-10', url: 'sidebar-10' },
    { name: 'Sidebar', title: 'Right-Aligned Contact Sidebar', description: 'In this demo, the sidebar is positioned on the right side, featuring a list of contacts with relevant customization options. Below that, group conversation options are displayed for convenient access and interaction.', componentName: 'sidebar-11', url: 'sidebar-11' },
    { name: 'Sidebar', title: 'Market Tracker Sidebar', description: 'In this demo, the sidebar is positioned on the right side, showcasing Bitcoin details along with current market values. It also includes a settings option and an option to view more details.', componentName: 'sidebar-12', url: 'sidebar-12' },
    { name: 'Sidebar', title: 'Nested Sidebar with Task Overview', description: 'In this demo, the sidebar is positioned on the right side. Inside the sidebar, the left section features quick access options, while the right section displays a user profile with toggle options. It allows users to create new tasks, view existing tasks, and track completed tasks.', componentName: 'sidebar-13', url: 'sidebar-13' }
  ];

  private readonly returnsBlockList: Block[] = [
    { name: 'Returns', title: 'Return Page for Selecting Products', description: 'This return page allows customers to identify and select the items they wish to return easily. It presents a clear list of purchased items, making it simple for users to choose the correct products for return.', componentName: 'returns-1', url: 'returns-1' },
    { name: 'Returns', title: 'Return Page for Selecting Return Reasons', description: 'This return page provides customers with predefined options to explain why they are returning an item. This helps streamline the return process by categorizing returns and ensuring that each return request is handled appropriately.', componentName: 'returns-2', url: 'returns-2' },
    { name: 'Returns', title: 'Return Page with Pickup Option', description: 'This return page offers customers the convenience of scheduling a pickup for their returned items. This feature lets businesses eliminate the need for customers to visit a return location, making the process more convenient and hassle-free, especially for bulky or hard-to-return items.', componentName: 'returns-3', url: 'returns-3' },
    { name: 'Returns', title: 'Return Page with Refund Option', description: 'This return page allows customers to submit their return request and select whether they prefer a refund or another option. Users can easily specify their refund preference, helping to process their return more quickly and efficiently, with clear details on the amount and method of the refund.', componentName: 'returns-4', url: 'returns-4' },
    { name: 'Returns', title: 'Return Confirmation', description: 'This return confirmation page displays a success message once the return request is processed, reassuring users that their return is being handled.', componentName: 'returns-5', url: 'returns-5' }
  ];

  private readonly cardsBlockList: Block[] = [
    { name: 'Cards', title: 'Simple Card Layout', description: 'In this demo, you will explore a collection of cards designed to capture attention and provide detailed information. Each card features a visually appealing image, complemented by a concise description, a title, and a call-to-action button for further exploration.', componentName: 'cards-1', url: 'cards-1' },
    { name: 'Cards', title: 'Rounded Corner Card with Spacious Design', description: 'In this demo, you will explore a series of informative cards, each focusing on a distinct theme, such as fashion, fitness, and technology. Each card includes an eye-catching image with rounded corners and custom spacing, as well as a concise headline and detailed description.', componentName: 'cards-2', url: 'cards-2' },
    { name: 'Cards', title: 'Rounded Corner Card with Spacious Design and a Button', description: 'In this demo, we present a set of visually engaging cards that seamlessly adjust to different visual styles. Each card features an image with rounded corners and distinct spacing around it, a title, a concise description, and a Get Started call-to-action button to encourage user interaction.', componentName: 'cards-3', url: 'cards-3' },
    { name: 'Cards', title: 'Card Layout with Avatar', description: 'In this demo, we feature a series of personalized cards that spotlight individuals and their areas of expertise. Each card includes a profile picture, the individual’s name and area of expertise, an article title, and content.', componentName: 'cards-4', url: 'cards-4' },
    { name: 'Cards', title: 'Card Layout with Avatar and Edit Button', description: 'In this demo, we show a series of interactive profile cards that spotlight individuals and their areas of expertise. Each card features a profile picture, name, area of expertise, and an Edit button for customization. Accompanying these is an engaging headline and a brief article description, offering insights into different topics.', componentName: 'cards-5', url: 'cards-5' },
    { name: 'Cards', title: 'Benefits Highlight Card with CTA', description: 'In this demo, we present a collection of cards designed to highlight the benefits of different subjects. Each card features a title and description, with the benefits listed to help readers easily grasp the key points. A Get Started Now call-to-action button is also available to encourage further action.', componentName: 'cards-6', url: 'cards-6' },
    { name: 'Cards', title: 'Card Layout with Badges', description: 'In this demo, a collection of cards brings to light different extraordinary places and experiences from around the world. Each card features a stunning image paired with a title, description, and a categorizing badge label at the bottom.', componentName: 'cards-7', url: 'cards-7' },
    { name: 'Cards', title: 'Card Layout with Split Images', description: 'In this demo, the split-image cards showcase captivating visuals on the left, with descriptive content on the right. Each card includes an image, title, and description. A View Details call-to-action button invites further exploration.', componentName: 'cards-8', url: 'cards-8' },
    { name: 'Cards', title: 'Text-Focused Card Layout', description: 'In this demo, each card displays a clear title, a description, and an author section with an avatar. The design is easy to read and helps users connect with the author and their content.', componentName: 'cards-9', url: 'cards-9' },
    { name: 'Cards', title: 'Card Layout with Left-Aligned Image', description: 'In this demo, we showcase a collection of informative cards that highlight technological advancements. Each card layout pairs a striking image on the left with an author section on the right featuring an avatar, title, and description.', componentName: 'cards-10', url: 'cards-10' },
    { name: 'Cards', title: 'User Profile Card Layout', description: 'In this demo, we feature cards that showcase eye-catching images at the top, each with a title and a short summary to provide context. The card ends with an author section, featuring an avatar, name, role, and date.', componentName: 'cards-11', url: 'cards-11' },
    { name: 'Cards', title: 'Cards with User Avatars and Ratings', description: 'In this demo, each card features an icon, title, and brief description. Below this, user avatars and a star rating provide community feedback. This layout offers a quick overview of experiences or services and adds credibility through user input and ratings.', componentName: 'cards-12', url: 'cards-12' },
    { name: 'Cards', title: 'Card Layout with Right-Aligned Images', description: 'In this demo, the card layout features text on the left and an image on the right. It includes a category label, title, and description, with a professional look. This setup is ideal for showcasing corporate or business content.', componentName: 'cards-13', url: 'cards-13' },
    { name: 'Cards', title: 'Card Layout with Link Buttons', description: 'In this demo, each card layout includes a title, description, and a View More button. The simple yet attractive design invites users to explore more content.', componentName: 'cards-14', url: 'cards-14' },
    { name: 'Cards', title: 'Card Layout with CTA Button', description: 'In this demo, the card layout features a title, description, and a call-to-action (CTA) button. The clean and straightforward design emphasizes key information while encouraging further engagement.', componentName: 'cards-15', url: 'cards-15' }
  ];

  private readonly emailBlockList: Block[] = [
    { name: 'Email', title: 'Email Composition', description: 'In this demo, users can easily draft and send emails. They can input the sender email, select recipients, and choose options for CC and BCC, along with adding a subject line. A rich text editor lets users prepare, format, and customize the message body. The interface also includes an option to attach files, which may be relevant depending on the subject. Once the email is ready, users can choose to either send it or discard it using the action buttons.', componentName: 'email-1', url: 'email-1' }
  ];

  private readonly chatBlockList: Block[] = [
    { name: 'Chat', title: 'Simple Chat Layout', description: 'In this demo, you will find a chat layout that offers a real-time messaging experience between users. It includes a message input at the bottom, timestamped messages for context, an indicator showing whether the message has been viewed, and icons for easy navigation and quick actions within the chat.', componentName: 'chat-1', url: 'chat-1' },
    { name: 'Chat', title: 'Chat Layout Using Side Panel', description: 'In this demo, you will find a chat layout within the sidebar, offering a real-time messaging experience that lets you open, view, and engage in conversations at any time without disruption. Additionally, the messages are translated into Spanish for better accessibility.', componentName: 'chat-2', url: 'chat-2' }
  ];

  private readonly paginationBlockList: Block[] = [
    { name: 'Pagination', title: 'Simple Pagination', description: 'In this demo, the pagination includes "Previous" and "Next" buttons, along with numbered page links for easy navigation. The current page is highlighted for clarity, and an ellipsis feature provides quick access to distant pages, simplifying the process of browsing through multiple pages.', componentName: 'pagination-1', url: 'pagination-1' },
    { name: 'Pagination', title: 'Advanced Pagination', description: 'In this demo, the pagination includes "Previous" and "Next" buttons, numbered page links, and a dropdown to select items per page. The current page is highlighted for clarity, and it also displays the current page number out of the total pages, along with the total item count, giving users full control over navigation and view settings.', componentName: 'pagination-2', url: 'pagination-2' },
    { name: 'Pagination', title: 'Advanced Pagination with Rounded Selection', description: 'In this demo, the pagination includes "Previous" and "Next" buttons, numbered page links with a round selection style, and a dropdown to select items per page. The current page is highlighted for clarity, and it also displays the current page number out of the total pages, along with the total item count, giving users full control over navigation and view settings.', componentName: 'pagination-3', url: 'pagination-3' },
    { name: 'Pagination', title: 'Advanced Pagination Using Page Selector', description: 'In this demo, the pagination includes "Previous" and "Next" buttons, a page input field displaying the current page out of the total pages, and a dropdown to set items per page. This input field allows users to jump to specific pages, making it easy to navigate through large sets of data.', componentName: 'pagination-4', url: 'pagination-4' },
    { name: 'Pagination', title: 'Shortened Pagination', description: 'In this demo, the pagination includes "First", "Last", "Previous", and "Next" buttons, with the current page and total pages displayed in the center. This compact design offers shortened pagination, displaying only the essential navigation controls for a streamlined user experience.', componentName: 'pagination-5', url: 'pagination-5' },
    { name: 'Pagination', title: 'Pagination in Header Section', description: 'In this demo, the pagination includes "Previous" and "Next" buttons, items-per-page dropdown, and icons for display options and filtering. Positioned within the header, this compact design enables users to easily navigate, adjust views, and apply filters, providing an efficient and user-friendly interface for managing content.', componentName: 'pagination-6', url: 'pagination-6' }
  ];

  private readonly calendarBlockList: Block[] = [
    { name: 'Calendar', title: 'Calendar for Quick View', description: 'In this demo, the calendar layout is positioned on the right as an overlay panel, displaying a monthly view along with a list of scheduled events. The event list shows upcoming meetings, including titles, time slots, and assigned individuals.', componentName: 'calendar-1', url: 'calendar-1' },
    { name: 'Calendar', title: 'Calendar for Room Booking', description: 'In this demo, the calendar layout offers date selection along with filters for personalized room booking. The filters include an accordion to select categories, a price range slider, and checkboxes for choosing hotel facilities, making it easy to narrow down the options.', componentName: 'calendar-2', url: 'calendar-2' },
    { name: 'Calendar', title: 'Calendar with Holiday List', description: 'In this demo, the calendar layout uses an overlay with an agenda view to display events and holidays in a chronological list. At the bottom, a button allows users to add new entries directly from the panel, offering a seamless way to manage and update the calendar.', componentName: 'calendar-3', url: 'calendar-3' },
    { name: 'Calendar', title: 'Calendar with Meeting List', description: 'In this demo, the calendar layout is positioned on the right as an overlay panel, displaying a monthly view along with a list of scheduled events. The event list shows upcoming meetings, including titles, time slots, and duration.', componentName: 'calendar-4', url: 'calendar-4' },
    { name: 'Calendar', title: 'Calendar with To-Do List', description: 'In this demo, the calendar layout combines a calendar view with a to-do list for easy task management. The to-do list displays tasks with checkboxes and strikethrough for completed items, providing a clear overview of daily tasks. At the bottom, a button allows users to add new to-do items, offering an easy way to expand the list as needed.', componentName: 'calendar-5', url: 'calendar-5' },
    { name: 'Calendar', title: 'Calendar with Timeline View', description: 'In this demo, the calendar layout presents a timeline view, displaying holidays in chronological order. It also includes details about individual leave, such as the date, type, and approval status, providing a comprehensive overview.', componentName: 'calendar-6', url: 'calendar-6' }
  ];

  private readonly listBlockList: Block[] = [
    { name: 'List', title: 'Project Task List', description: 'In this demo, the list view presents key project task details for easy tracking. Each item features a checkbox for selection, a task title, a brief description, and relevant metadata, such as the due date and assigned user. It also highlights new tasks, making them easily identifiable.', componentName: 'list-1', url: 'list-1' },
    { name: 'List', title: 'Inbox Messages List', description: 'In this demo, the list view for inbox messages displays a series of items with read and unread indications. Each item includes a name, title, description, and a timestamp indicating when the message was sent. It also features checkboxes on the left for selection and a star icon to mark important messages.', componentName: 'list-2', url: 'list-2' },
    { name: 'List', title: 'Direct Messages List', description: 'In this demo, the list view displays a series of messages, each featuring a profile image, sender name, and message content. The timestamp is shown next to the sender name. Below each message, users can reply, mark the message as read, and access additional options via a More Options menu.', componentName: 'list-3', url: 'list-3' },
    { name: 'List', title: 'Shopping Cart', description: 'In this demo, the list view displays a series of products, each with a product image, name, and other details. The price is shown next to the product, and any discounts are highlighted with a hint. The action buttons for adding, removing, saving, and sharing the product are also included.', componentName: 'list-4', url: 'list-4' },
    { name: 'List', title: 'Country and Code List', description: 'In this demo, the list view displays country names, each with its flag image and country code. A search bar at the top allows users to easily search, and each entry includes text indicating the country abbreviation.', componentName: 'list-5', url: 'list-5' },
    { name: 'List', title: 'Data Fields List', description: 'In this demo, the list view displays form fields, each with a drag icon on the left for reordering. At the bottom, there is a dynamic option to add a field. The design allows users to reorder the fields easily by dragging them, enabling customization of the data collection process.', componentName: 'list-6', url: 'list-6' },
    { name: 'List', title: 'Short-Form Message List', description: 'In this demo, the list view displays a series of short-form messages, each with a profile image, name, message content, and timestamp. The More options icon next to each entry allows users to access additional options or actions related to the message.', componentName: 'list-7', url: 'list-7' },
    { name: 'List', title: 'Chat Conversation List', description: 'In this demo, the list view displays a chat conversation list with user profile images and their messages. Each entry includes the user name, message content, and timestamp. A notification number beside each entry indicates new messages. The design also includes a search bar at the top, allowing users to find specific people, chats, or keywords quickly.', componentName: 'list-8', url: 'list-8' },
    { name: 'List', title: 'Message List', description: 'In this demo, the list view displays a series of notifications. Each notification includes a title, a brief description, and the time it was received. The design is organized to help users stay informed about important news and events with ease.', componentName: 'list-9', url: 'list-9' },
    { name: 'List', title: 'Task List', description: 'In this demo, the list view displays a series of tasks, each with an icon, description, due date, and an avatar on the right. The task information is well-organized, making it easy to identify and navigate through the list.', componentName: 'list-10', url: 'list-10' },
    { name: 'List', title: 'File Directory List', description: 'In this demo, the list view displays an icon on the left representing file type, followed by the file name on the right. Below each file name, a breadcrumb shows its location within the folder hierarchy. The design is organized for clarity, allowing users to easily track and navigate through the directory.', componentName: 'list-11', url: 'list-11' }
  ];

  private readonly floatingMenuBlockList: Block[] = [
    { name: 'Floating Menu', title: 'Floating Menu Featuring Help Bot', description: 'In this demo, the floating menu features a help bot with a search bar at the top for quick access to help topics, followed by a list of helpful topics with clickable entries. Each entry includes a brief description, allowing users to easily navigate and find relevant assistance.', componentName: 'floating-menu-1', url: 'floating-menu-1' },
    { name: 'Floating Menu', title: 'Floating Menu Featuring Chat Bot', description: 'In this demo, the floating menu features a conversation layout that allows users to interact with a chatbot. At the bottom, users can rate the support they received. The interface is clean and organized, with a straightforward message flow and a rating system designed to encourage feedback and enhance user engagement.', componentName: 'floating-menu-2', url: 'floating-menu-2' },
    { name: 'Floating Menu', title: 'Floating Menu Featuring Form', description: 'In this demo, the floating menu features a form layout that offers users an easy way to reach out for an inquiry. It allows users to quickly fill out their details and submit them for further assistance or follow-up.', componentName: 'floating-menu-3', url: 'floating-menu-3' }
  ];

  private readonly footerBlockList: Block[] = [
    { name: 'Footer', title: 'Footer with Terms & Conditions', description: 'In this demo, the footer is designed to provide quick access to the brand, its key policies, and copyright information. It features the brand logo and name, navigation links to policy pages, and a copyright notice.', componentName: 'footer-1', url: 'footer-1' },
    { name: 'Footer', title: 'Minimal Footer', description: 'In this demo, the footer focuses on simplicity and functionality, offering a clear copyright notice and quick access to social media channels for brand engagement.', componentName: 'footer-2', url: 'footer-2' },
    { name: 'Footer', title: 'Footer with Subscription Option', description: 'In this demo, the footer features the brand logo and name, along with a copyright notice. It also has a prominent newsletter subscription option, enabling users to sign up easily and stay informed.', componentName: 'footer-3', url: 'footer-3' },
    { name: 'Footer', title: 'Footer with Sitemap and Contact Information', description: 'In this demo, the footer includes basic information, as seen in previous blocks, along with a comprehensive sitemap and company contact details, providing users with easy navigation and direct access to important pages.', componentName: 'footer-4', url: 'footer-4' },
    { name: 'Footer', title: 'Footer with Sitemap and Detailed Contact Information', description: 'In this demo, the footer includes basic information, as seen in previous blocks, along with a comprehensive sitemap, company contact details, and a location map, providing users with easy navigation and direct access to important pages.', componentName: 'footer-5', url: 'footer-5' }
  ];

  private readonly searchBlockList: Block[] = [
    { name: 'Search', title: 'Search with Category Highlight', description: 'In this demo, the search box features a prominent search bar at the top for easy access. Based on the entered keyword, results are organized by category, allowing users to quickly navigate through categories and select the most relevant results.', componentName: 'search-1', url: 'search-1' },
    { name: 'Search', title: 'Search with "No Result Found" Status Template', description: 'In this demo, the search features a prominent search bar at the top for easy access. Based on the entered keyword, the results are displayed in a simple list format. If no matches are found, a specially designed "No Results Found" status template is shown, giving users a clear indication that their search yielded no results.', componentName: 'search-2', url: 'search-2' },
    { name: 'Search', title: 'Search with Recent History', description: 'In this demo, the search feature with recent history is designed to enhance the user experience by displaying a list of recently entered keywords or phrases, allowing users to quickly revisit and refine their previous searches. This functionality saves time and helps users easily navigate through past queries, making the search process more efficient.', componentName: 'search-3', url: 'search-3' },
    { name: 'Search', title: 'Search Contacts', description: 'In this demo, the search feature allows users to quickly search contacts by entering contact names. The results are displayed in a simple list format, making it easy for users to view and select the desired contact.', componentName: 'search-4', url: 'search-4' },
    { name: 'Search', title: 'Search with Chip as Filter', description: 'In this demo, the search feature includes a set of chips as filter options, enabling users to instantly refine their results by selecting relevant chips. This streamlined approach allows users to quickly narrow down their search and find the most relevant information.', componentName: 'search-5', url: 'search-5' }
  ];

  private readonly tileViewBlockList: Block[] = [
    { name: 'Tile View', title: 'Ticket Management View', description: 'In this demo, a tile view layout for ticket management is showcased. It enables users to create new tickets easily. It also includes features like a search bar, toggle switch, and filter button for seamless navigation and filtering. Inside the tiles, a checkbox on the left allows for bulk actions, while the main content area displays essential ticket details. At the bottom, action buttons and dropdowns allow users to select categories, assign tickets, set priorities, and more, allowing efficient ticket management.', componentName: 'tile-view-1', url: 'tile-view-1' },
    { name: 'Tile View', title: 'Shopping Cart View', description: 'In this demo, a tile view layout for an e-commerce shopping cart is showcased. A switch at the top enables users to filter for discounted items, while a search bar and category filter on the right provide convenient product navigation. Each product tile includes product details, like the name, image, and availability, and the option to add it to the cart.', componentName: 'tile-view-2', url: 'tile-view-2' },
    { name: 'Tile View', title: 'Transaction View', description: 'In this demo, a tile view layout for financial transactions is showcased, providing a streamlined overview of financial records. The top section includes an option to add transactions, a breadcrumb navigation, a toggle filter, and a date-range selector to refine transaction views. Each transaction entry displays essential details for quick identification and efficient management.', componentName: 'tile-view-3', url: 'tile-view-3' },
    { name: 'Tile View', title: 'Travel Booking View', description: 'In this demo, a tile view layout for a travel-ticket booking view is showcased, offering a clear and user-friendly interface. The top section features the user profile along with notifications, followed by search and filter options to narrow down results. Each tile organizes essential details in a structured layout, making it easy to browse and explore available booking options.', componentName: 'tile-view-4', url: 'tile-view-4' },
    { name: 'Tile View', title: 'Job Search View', description: 'In this demo, a tile view layout for job searching is showcased, offering a user-friendly interface for participation in the job search process. At the top, users can access essential search and filter options, including a central search bar for quick queries. The tiles display job listings with key details such as job title, company name, and location, arranged in a clear and organized format. At the bottom of each tile, an action button allows users to apply for jobs, and one at the bottom of the page lets them load more tiles, ensuring an efficient and intuitive job search experience.', componentName: 'tile-view-5', url: 'tile-view-5' }
  ];

  private readonly blockList: BlockList[] = [
    { name: 'Navigation Bar', description: 'The navigation bar is a user interface element that provides links or buttons to different sections or pages. Typically located at the top of the application, it allows users to easily navigate between sections or pages. The navigation bar may also include menus, icons, or dropdowns, further enhancing the usability and accessibility of the application.', category: 'Layouts', isNew: false, url: 'navigation-bar', subBlockList: this.navbarBlockList },
    { name: 'Sidebar', description: 'In this section, we’ll explore the sidebar and nested sidebar components, which serve purposes such as displaying lists, accordion menus, notifications, and user profiles. They also facilitate seamless profile switching and quick access to application settings and other actions. The nested sidebar supports hierarchical navigation, making it ideal for applications with complex structures. In it, subcategories and options can be easily accessed without cluttering the interface.', category: 'Layouts', isNew: false, url: 'sidebar', subBlockList: this.sidebarBlockList },
    { name: 'Floating Menu', description: 'The floating menu is a flexible UI element that provides quick, on-demand access to key features without interrupting the user workflow. Positioned for easy reach, it offers a compact and intuitive interface, enabling smooth interaction with essential tools and actions to enhance navigation and the overall user experience.', category: 'Layouts', isNew: false, url: 'floating-menu', subBlockList: this.floatingMenuBlockList },
    { name: 'Search', description: 'The search box allows users to enter keywords or phrases to filter and display relevant results from a list. Based on the input, the system dynamically narrows down the options. If no matches are found, a "no records found" message is shown. This enhances the efficiency of finding specific information quickly.', category: 'Layouts', isNew: false, url: 'search', subBlockList: this.searchBlockList },
    { name: 'Grid', description: 'The grid is a powerful and flexible layout system that arranges content in rows and columns, ensuring structure, alignment, and visual clarity. It enables developers to display data in an intuitive tabular format, where each row represents an individual item and columns offer detailed information. With built-in support for sorting, filtering, and efficient content management, this layout adapts seamlessly to various data types, delivering a streamlined, user-friendly experience.', category: 'Layouts', isNew: false, url: 'grid', subBlockList: this.gridBlockList },
    { name: 'List View', description: 'The list view is a display format used in web applications where items such as text, images, or data are organized vertically in one or more columns for easy browsing. Each item is presented as a row, allowing users to view key details at a glance. This format is commonly used for displaying files, products, or records in an organized and accessible way, making it easier for users to find and interact with content.', category: 'Layouts', isNew: false, url: 'list-view', subBlockList: this.listBlockList },
    { name: 'Tile View', description: 'The tile view is a user interface design pattern that displays content in distinct rectangular tiles. Each tile represents an individual item, such as a task, product, or event, and typically includes key information like title, status, and relevant details. This layout allows users to scan and interact easily with multiple items at once, improving organization and accessibility. The tile view enhances visual clarity by providing a structured and engaging way to manage and explore content efficiently.', category: 'Layouts', isNew: false, url: 'tile-view', subBlockList: this.tileViewBlockList },
    { name: 'Calendar', description: 'The calendar provides an organized, user-friendly view of dates, events, and tasks, making it easy to manage schedules. With features like date selection, agenda and to-do lists, timeline views, and customizable filters, users can quickly navigate their calendars and stay on top of important appointments and deadlines. Interactive action buttons for adding events, setting reminders, and marking tasks complete further enhance usability, ensuring a seamless experience for planning and managing daily activities.', category: 'Layouts', isNew: false, url: 'calendar', subBlockList: this.calendarBlockList },
    { name: 'Cards', description: 'The card is a flexible and compact UI element used to present content in a clear and organized way. Typically consisting of a container that holds a combination of text, images, icons, links, and other elements, cards are commonly used to display discrete pieces of content, such as articles, products, or user profiles. They are often interactive, allowing for actions like expanding, clicking, or navigating to other content. Widely used in dashboards, content galleries, and e-commerce sites, cards provide an intuitive and modular way to organize and present information.', category: 'Layouts', isNew: false, url: 'cards', subBlockList: this.cardsBlockList },
    { name: 'Pagination', description: 'Pagination is a design technique used in web applications to break large volumes of content into smaller, more navigable sections. It typically includes navigation features such as page numbers, "Next" and "Previous" buttons, the ability to directly enter a page number via a numeric textbox, and sometimes a page selector or options for adjusting the number of items displayed per page. By presenting content in smaller chunks, pagination enhances the user experience, making it easier to browse and find relevant information without overwhelming users with excessive content at once.', category: 'Layouts', isNew: false, url: 'pagination', subBlockList: this.paginationBlockList },
    { name: 'Footer', description: 'The footer is a section at the bottom of a web application, typically containing elements such as the brand logo and name, copyright notices, privacy policies, a sitemap, contact information, and sometimes social media buttons or additional options. A footer is designed to improve navigation and provide easy access to important information without cluttering the main content of the page.', category: 'Layouts', isNew: false, url: 'footer', subBlockList: this.footerBlockList },
    { name: 'Sign In', description: 'A sign-in process allows users to enter their credentials, typically an email address and password, to access an application. It often includes additional options to remember login details for future convenience, provides a way to recover forgotten passwords, and offers the ability to sign up. Additionally, third-party sign-in options, such as Google and Microsoft, provide greater flexibility and facilitate new user registration, ensuring a smooth onboarding experience.', category: 'Authentication', isNew: false, url: 'signin', subBlockList: this.signinBlockList },
    { name: 'Sign Up', description: 'Signing up is the process by which users create a new account to access an application. It typically involves providing personal information, such as a name and email address, and setting a password. Users may also be required to agree to terms of service and privacy policies to ensure compliance. To make the process more convenient, many platforms offer alternate sign-up options through social media accounts like Google, Facebook, or Microsoft, allowing users to register quickly without having to fill out detailed forms. The sign-up process is essential for enabling access to personalized content and features, while also ensuring the security and privacy of user data.', category: 'Authentication', isNew: false, url: 'signup', subBlockList: this.signupBlockList },
    { name: 'Sign In - Mobile', description: 'This block allows users to log into an application using their mobile number instead of a traditional username or email. Users begin by selecting their country code from a dropdown menu and then enter their mobile number into an input field. They select the Continue button to submit the form and initiate the login process.', category: 'Authentication', isNew: false, url: 'mobile-signin', subBlockList: this.signinMobileBlockList },
    { name: 'Sign In - OTP', description: 'OTP (one-time password) is a secure authentication method that allows users to log into an application by entering a temporary code sent to their registered mobile phone number. The OTP is sent via SMS. Once the user receives the OTP, they enter it into the input field, and a Continue button submits the form, completing the login process. This method ensures a high level of security by verifying the user’s identity through a unique, time-sensitive code, offering a safe authentication experience.', category: 'Authentication', isNew: false, url: 'otp-signin', subBlockList: this.signinOTPBlockList },
    { name: 'Forgot Password', description: 'The forgot password process allows users to recover access to their account if they have forgotten their login credentials. Users are prompted to enter their registered email address, and a secure, time-sensitive link is sent to their inbox. Clicking the link directs users to a page where they can create a new password, ensuring that only the rightful account holder can regain access. The process is designed with clear guidance to make resetting credentials simple and straightforward.', category: 'Authentication', isNew: false, url: 'forgot-password', subBlockList: this.forgotPasswordBlockList },
    { name: 'Sign Out', description: 'The sign-out process allows users to end their session in an app securely. Upon logging out, users receive immediate confirmation of the successful sign-out, reassuring them that the process was successful.', category: 'Authentication', isNew: false, url: 'signout', subBlockList: this.signoutBlockList },
    { name: 'Unlock Session', description: 'The unlock session process allows users to regain access to their account if their session has been locked or expired. To begin, users are prompted to enter their registered email address, and a secure, time-sensitive link is sent to their inbox. Clicking the link directs users to a page where they can verify their identity and resume their session, ensuring a secure and seamless user experience.', category: 'Authentication', isNew: false, url: 'unlock-session', subBlockList: this.unlockSessionBlockList },
    { name: 'Pricing Card', description: 'Pricing cards are visual elements that present subscription plans or pricing tiers in a clear, comparative layout. They allow users to evaluate key features, benefits, and costs of each option. Typically featuring toggle switches and prominent call-to-action buttons, pricing cards offer a simple, user-friendly interface to guide users toward the option best for their needs.', category: 'E-commerce', isNew: false, url: 'pricing-card', subBlockList: this.pricingCardBlockList },
    { name: 'Plan and Price Comparison', description: 'A pricing plan comparison table offers a clean, user-friendly layout that allows users to evaluate different options. Users can quickly compare key features and pricing, helping them select the plan that best meets their needs. Benefits are clearly displayed side by side for easy comparison, while prominent call-to-action (CTA) buttons guide users to make their choice, ensuring a smooth and efficient experience.', category: 'E-commerce', isNew: false, url: 'plan-and-price-comparison', subBlockList: this.planComparisonBlockList },
    { name: 'Checkout Page', description: 'The checkout page is the final step in the online shopping process, where customers complete their purchase. It typically includes fields for entering customer details, billing information, shipping address, and payment options. The page provides a clear and concise order summary, displaying items, quantities, and pricing to confirm the purchase. With a user-friendly and intuitive design, the checkout page guides customers through the necessary steps to complete their order, ensuring a smooth and secure transaction.', category: 'E-commerce', isNew: false, url: 'checkout-page', subBlockList: this.checkoutBlockList },
    { name: 'Product Return Page', description: 'A product return page provides a process for returning items purchased online. Customers can select the products they wish to return, choose a return reason, and if applicable, opt for a pickup service. A return page with a refund option is available, and once the return is initiated, users receive a confirmation message, ensuring a smooth and transparent experience.', category: 'E-commerce', isNew: false, url: 'product-return-page', subBlockList: this.returnsBlockList },
    { name: 'Email', description: 'E-mail (electronic mail) allows users to send and receive messages over the internet. It includes features like recipient addresses, carbon copy, subject lines, message bodies, and file attachments. Widely used for both personal and professional communication, e-mail supports file sharing, organization, and formatting. It can be accessed through desktop clients, web services, or mobile apps.', category: 'Communication', isNew: false, url: 'email', subBlockList: this.emailBlockList },
    { name: 'Chat', description: 'Messaging platforms are crucial for real-time communication, offering a quick and interactive way to send and receive messages. Modern chat layouts include features like message input, timestamps, and real-time notifications to enhance user experience. These systems can be designed as simple interfaces or more complex side-panel integrations, allowing seamless multitasking. Accessibility features, such as language translation, further improve usability for diverse users.', category: 'Communication', isNew: false, url: 'chat', subBlockList: this.chatBlockList }
  ];

  constructor() { }

  public getBlockList(): BlockList[] {
    return this.blockList;
  }

  public getThemeName(): string {
    return this.themeName;
  }

  public setThemeName(newThemeName: string): void {
    this.themeName = newThemeName;
  }

  public getSelectedCategoryIndex(): number {
    return this.categoryIndex;
  }

  public setSelectedCategoryIndex(newCategoryIndex: number): void {
    this.categoryIndex = newCategoryIndex;
  }
}
