# Essential UI Kit for Angular

The Essential UI Kit for Angular provides a collection of thoughtfully designed, responsive, and modular user interface blocks that streamline development, enabling the quick creation of high-quality applications. Fully compatible with Tailwind CSS and Bootstrap 5.3, our pre-built blocks offer seamless integration and exceptional performance for dashboards, e-commerce apps, and dynamic web applications.

## Table of Contents
- [Key Features](#key-features)
- [System Requirements](#system-requirements)
- [Supported Angular Versions](#supported-angular-versions)
- [Supported Browsers](#supported-browsers)
- [Supported CSS Frameworks](#supported-css-frameworks)
- [Online Demo](#online-demo)
- [Requesting Blocks & Reporting Bugs](#requesting-blocks--reporting-bugs)
- [License](#license)
- [About Syncfusion](#about-syncfusion)

## Key Features
- Beautifully crafted and visually appealing blocks
- Pre-configured with customizable themes for consistent styling
- Effortless and rapid integration for Angular application development
- Developer-friendly
- Fully customizable and easy to extend
- Optimized for mobile, tablet, and desktop views
- Suitable for both web applications and website designs

## System Requirements
Refer to the [Angular system requirements documentation](https://angular.io/guide/setup-local) to learn more about the development environments.

## Supported Angular Versions
The blocks are compatible with any active version of Angular, as they are primarily developed using HTML, CSS, and TypeScript. Additionally, for using Syncfusion Angular components, the compatible versions of Angular and Syncfusion Angular components are detailed in this [link](https://ej2.syncfusion.com/angular/documentation/system-requirement#angular-supported-versions) for your reference.

## Supported Browsers
The supported browsers are:
- Google Chrome
- Microsoft Edge
- Safari
- Mozilla Firefox

## Supported CSS Frameworks
The blocks are built using the following CSS frameworks:
1. Tailwind (Light and Dark Modes)
2. Bootstrap 5.3 (Light and Dark Modes)

## Online Demo
To view the designed blocks, please visit our online demo using the link [here](https://ej2.syncfusion.com/angular/essential-ui-kit/#/blocks).

## Requesting Blocks & Reporting Bugs
If you'd like to request a new block or report a bug with existing blocks, you can either raise a request directly on GitHub or submit it through our [feedback portal](https://www.syncfusion.com/feedback/angular).

## License
The blocks in the Angular application are built using HTML, CSS, TypeScript, and Syncfusion Angular Components. The blocks code is free to use, but licensing for the Syncfusion Angular Components part is alone required to ensure smooth browsing and viewing of the blocks. For more details about Syncfusion Angular Components licensing, please refer [here](https://ej2.syncfusion.com/angular/documentation/licensing/overview).

## About Syncfusion
Founded in 2001 and headquartered in Research Triangle Park, N.C., Syncfusion has more than 20,000 customers and more than 1 million users, including large financial institutions, Fortune 500 companies, and global IT consultancies.

Today we provide 1,000+ controls and frameworks for web ([ASP.NET Core](https://www.syncfusion.com/aspnet-core-ui-controls), [ASP.NET MVC](https://www.syncfusion.com/aspnet-mvc-ui-controls), [ASP.NET WebForms](https://www.syncfusion.com/jquery/aspnet-web-forms-ui-controls), [JavaScript](https://www.syncfusion.com/javascript-ui-controls), [Angular](https://www.syncfusion.com/angular-ui-components), [React](https://www.syncfusion.com/react-ui-components), [Vue](https://www.syncfusion.com/vue-ui-components), and [Blazor](https://www.syncfusion.com/blazor-components)), mobile ([Xamarin](https://www.syncfusion.com/xamarin-ui-controls), [Flutter](https://www.syncfusion.com/flutter-widgets), [UWP](https://www.syncfusion.com/uwp-ui-controls), and [JavaScript](https://www.syncfusion.com/javascript-ui-controls)), and desktop development ([WinForms](https://www.syncfusion.com/winforms-ui-controls), [WPF](https://www.syncfusion.com/products/wpf-ui-controls), and [UWP](https://www.syncfusion.com/uwp-ui-controls)). We provide ready-to deploy enterprise software for dashboards, reports, data integration, and big data processing. Many customers have saved millions in licensing fees by deploying our software.
