## AI Infra Repositories

A curated list of open source repositories for AI Engineers

If you want to contribute to this list, please make a Pull request



## Contents
- [AI Gateway](#ai-gateway)
- [AI Workload Manager](#ai-workload-manager)
- [Copilot Development](#copilot-development)
- [Dataset Engineering](#dataset-engineering)
- [Evaluation](#evaluation)
- [Fine Tuning](#fine-tuning)
- [Function Calling](#function-calling)
- [Graph RAG](#graph-rag)
- [Guardrails](#guardrails)
- [Local Model Inference](#local-model-inference)
- [LLM Agent Framework](#llm-agent-framework)
- [Model Serving](#model-serving)
- [Observability](#observability)
- [Pre Training](#pre-training)
- [Prompt Engineering](#prompt-engineering)
- [RAG Framework](#rag-framework)
- [Structured Extraction](#structured-extraction)
- [Structured Generation](#structured-generation)
- [Vector DB](#vector-db)
- [Voice Agent](#voice-agent)



## AI Gateway

| Name (site) | Github |
|------------|------------|
| [Kong](https://konghq.com/products/kong-ai-gateway) | <a href=https://github.com/Kong/kong><img src="https://img.shields.io/github/stars/Kong/kong?style=social" width=100/></a> |
| [Litellm](https://docs.litellm.ai/docs/) | <a href=https://github.com/BerriAI/litellm><img src="https://img.shields.io/github/stars/BerriAI/litellm?style=social" width=100/></a> |
| [Portkey](https://portkey.ai/) | <a href=https://github.com/Portkey-AI/gateway><img src="https://img.shields.io/github/stars/Portkey-AI/gateway?style=social" width=100/></a> |
| [RouteLLM](https://lmsys.org/projects/) | <a href=https://github.com/lm-sys/RouteLLM><img src="https://img.shields.io/github/stars/lm-sys/RouteLLM?style=social" width=100/></a> |
| [GPTRouter](https://gpt-router.writesonic.com/) | <a href=https://github.com/Writesonic/GPTRouter><img src="https://img.shields.io/github/stars/Writesonic/GPTRouter?style=social" width=100/></a> |
| [tensorzero](https://www.tensorzero.com/) | <a href=https://github.com/tensorzero/tensorzero><img src="https://img.shields.io/github/stars/tensorzero/tensorzero?style=social" width=100/></a> |
| [missing studio](https://www.missing.studio/) | <a href=https://github.com/missingstudio/gateway><img src="https://img.shields.io/github/stars/missingstudio/gateway?style=social" width=100/></a> |

## AI Workload Manager

| Name (site) | Github |
|------------|------------|
| [Ray](https://www.ray.io/) | <a href=https://github.com/ray-project/ray><img src="https://img.shields.io/github/stars/ray-project/ray?style=social" width=100/></a> |
| [higgsfield](https://higgsfield.ai/) | <a href=https://github.com/higgsfield-ai/higgsfield><img src="https://img.shields.io/github/stars/higgsfield-ai/higgsfield?style=social" width=100/></a> |
| [Dstack](https://dstack.ai/) | <a href=https://github.com/dstackai/dstack><img src="https://img.shields.io/github/stars/dstackai/dstack?style=social" width=100/></a> |


## Copilot Development

| Name (site) | Github |
|------------|------------|
| [copilotkit](https://www.copilotkit.ai/) | <a href=https://github.com/CopilotKit/CopilotKit><img src="https://img.shields.io/github/stars/CopilotKit/CopilotKit?style=social" width=100/></a> |
| [OpenCopilot](https://opencopilot.so/) | <a href=https://github.com/openchatai/OpenCopilot><img src="https://img.shields.io/github/stars/openchatai/OpenCopilot?style=social" width=100/></a> |


## Dataset Engineering

| Name (site) | Github |
|------------|------------|
| [label studio](https://labelstud.io/) | <a href=https://github.com/HumanSignal/label-studio><img src="https://img.shields.io/github/stars/HumanSignal/label-studio?style=social" width=100/></a> |
| [CleanLab](https://cleanlab.ai/) | <a href=https://github.com/cleanlab/cleanlab><img src="https://img.shields.io/github/stars/cleanlab/cleanlab?style=social" width=100/></a> |
| [Snorkel](https://www.snorkel.org/) | <a href=https://github.com/snorkel-team/snorkel><img src="https://img.shields.io/github/stars/snorkel-team/snorkel?style=social" width=100/></a> |
| [Lilac](https://www.lilacml.com/) | <a href=https://github.com/lilacai/lilac><img src="https://img.shields.io/github/stars/lilacai/lilac?style=social" width=100/></a> |
| [litdata](https://github.com/Lightning-AI/litdata) | <a href=https://github.com/Lightning-AI/litdata><img src="https://img.shields.io/github/stars/Lightning-AI/litdata?style=social" width=100/></a> |


## Evaluation

| Name (site) | Github |
|------------|------------|
| [Eval](https://openai.com/) | <a href=https://github.com/openai/evals><img src="https://img.shields.io/github/stars/openai/evals?style=social" width=100/></a> |
| [RAGAS](https://docs.ragas.io/en/stable/) | <a href=https://github.com/explodinggradients/ragas><img src="https://img.shields.io/github/stars/explodinggradients/ragas?style=social" width=100/></a> |
| [Giskard](https://www.giskard.ai/) | <a href=https://github.com/Giskard-AI/giskard><img src="https://img.shields.io/github/stars/Giskard-AI/giskard?style=social" width=100/></a> |
| [promptfoo](https://www.promptfoo.dev/) | <a href=https://github.com/promptfoo/promptfoo><img src="https://img.shields.io/github/stars/promptfoo/promptfoo?style=social" width=100/></a> |
| [arize ai](https://phoenix.arize.com/) | <a href=https://github.com/Arize-ai/phoenix><img src="https://img.shields.io/github/stars/Arize-ai/phoenix?style=social" width=100/></a> |
| [uptrain](https://uptrain.ai/) | <a href=https://github.com/uptrain-ai/uptrain><img src="https://img.shields.io/github/stars/uptrain-ai/uptrain?style=social" width=100/></a> |
| [trulens](https://www.trulens.org/) | <a href=https://github.com/truera/trulens><img src="https://img.shields.io/github/stars/truera/trulens?style=social" width=100/></a> |
| [tonic-validate](https://docs.tonic.ai/validate) | <a href=https://github.com/TonicAI/tonic_validate><img src="https://img.shields.io/github/stars/TonicAI/tonic_validate?style=social" width=100/></a> |
| [LangEvals](https://github.com/langwatch/langevals) | <a href=https://github.com/langwatch/langevals><img src="https://img.shields.io/github/stars/langwatch/langevals?style=social" width=100/></a> |
| [Poyro](https://github.com/poyro/poyro) | <a href=https://github.com/poyro/poyro><img src="https://img.shields.io/github/stars/poyro/poyro?style=social" width=100/></a> |

## Fine Tuning

| Name (site) | Github |
|------------|------------|
| [Unsloth](https://unsloth.ai/) | <a href=https://github.com/unslothai/unsloth><img src="https://img.shields.io/github/stars/unslothai/unsloth?style=social" width=100/></a> |
| [ludwig](https://ludwig.ai/latest/) | <a href=https://github.com/ludwig-ai/ludwig><img src="https://img.shields.io/github/stars/ludwig-ai/ludwig?style=social" width=100/></a> |
| [NeMo/Nvidia](https://docs.nvidia.com/nemo-framework/user-guide/latest/overview.html) | <a href=https://github.com/NVIDIA/NeMo><img src="https://img.shields.io/github/stars/NVIDIA/NeMo?style=social" width=100/></a> |
| [LMFlow](https://optimalscale.github.io/LMFlow/) | <a href=https://github.com/OptimalScale/LMFlow><img src="https://img.shields.io/github/stars/OptimalScale/LMFlow?style=social" width=100/></a> |
| [litgpt](https://optimalscale.github.io/LMFlow/) | <a href=https://github.com/Lightning-AI/litgpt><img src="https://img.shields.io/github/stars/Lightning-AI/litgpt?style=social" width=100/></a> |
| [Axolotl](https://github.com/axolotl-ai-cloud/axolotl) | <a href=https://github.com/OpenAccess-AI-Collective/axolotl><img src="https://img.shields.io/github/stars/OpenAccess-AI-Collective/axolotl?style=social" width=100/></a> |
| [xTuring](https://xturing.stochastic.ai/) | <a href=https://github.com/stochasticai/xTuring><img src="https://img.shields.io/github/stars/stochasticai/xTuring?style=social" width=100/></a> |


## Function Calling

| Name (site) | Github |
|------------|------------|
| [Gorilla](https://gorilla.cs.berkeley.edu/) | <a href=https://github.com/ShishirPatil/gorilla><img src="https://img.shields.io/github/stars/ShishirPatil/gorilla?style=social" width=100/></a> |
| [Tiger](https://docs.upsonic.co/tiger/welcome) | <a href=https://github.com/Upsonic/Tiger><img src="https://img.shields.io/github/stars/Upsonic/Tiger?style=social" width=100/></a> |
| [NPI AI](https://www.npi.ai/) | <a href=https://github.com/npi-ai/npi><img src="https://img.shields.io/github/stars/npi-ai/npi?style=social" width=100/></a> |
| [empower](https://www.empower.dev/) | <a href=https://github.com/empower-ai/empower-functions><img src="https://img.shields.io/github/stars/empower-ai/empower-functions?style=social" width=100/></a> |
| [Composio](https://docs.composio.dev/introduction/intro/overview) | <a href=https://github.com/ComposioDev/composio><img src="https://img.shields.io/github/stars/ComposioDev/composio?style=social" width=100/></a> |
| [gorilla](https://gorilla.cs.berkeley.edu/) | <a href=https://github.com/ShishirPatil/gorilla><img src="https://img.shields.io/github/stars/ShishirPatil/gorilla?style=social" width=100/></a> |


## Graph RAG

| Name (site) | Github |
|------------|------------|
| [graphRAG ](https://microsoft.github.io/graphrag/) | <a href=https://github.com/microsoft/graphrag><img src="https://img.shields.io/github/stars/microsoft/graphrag?style=social" width=100/></a> |
| [cognee](https://www.cognee.ai/) | <a href=https://github.com/topoteretes/cognee><img src="https://img.shields.io/github/stars/topoteretes/cognee?style=social" width=100/></a> |
| [FalkorDB](https://www.falkordb.com/) | <a href=https://github.com/FalkorDB/FalkorDB><img src="https://img.shields.io/github/stars/FalkorDB/FalkorDB?style=social" width=100/></a> |
| [llm-graph-builder](https://neo4j.com/labs/genai-ecosystem/llm-graph-builder/) | <a href=https://github.com/neo4j-labs/llm-graph-builder><img src="https://img.shields.io/github/stars/neo4j-labs/llm-graph-builder?style=social" width=100/></a> |
| [tidb](https://tidb.ai/) | <a href=https://github.com/pingcap/tidb.ai><img src="https://img.shields.io/github/stars/pingcap/tidb.ai?style=social" width=100/></a> |


## Guardrails

| Name (site) | Github |
|------------|------------|
| [NeMo-Guardrails](https://github.com/NVIDIA/NeMo-Guardrails) | <a href=https://github.com/NVIDIA/NeMo-Guardrails><img src="https://img.shields.io/github/stars/NVIDIA/NeMo-Guardrails?style=social" width=100/></a> |
| [Guardrails](https://www.guardrailsai.com/) | <a href=https://github.com/guardrails-ai/guardrails><img src="https://img.shields.io/github/stars/guardrails-ai/guardrails?style=social" width=100/></a> |


## Local Model Inference

| Name (site) | Github |
|------------|------------|
| [llama cpp](https://github.com/ggerganov/llama.cpp) | <a href=https://github.com/ggerganov/llama.cpp><img src="https://img.shields.io/github/stars/ggerganov/llama.cpp?style=social" width=100/></a> |
| [whisper cpp](https://github.com/ggerganov/whisper.cpp) | <a href=https://github.com/ggerganov/whisper.cpp><img src="https://img.shields.io/github/stars/ggerganov/whisper.cpp?style=social" width=100/></a> |
| [ollama](https://ollama.com/) | <a href=https://github.com/ollama/ollama><img src="https://img.shields.io/github/stars/ollama/ollama?style=social" width=100/></a> |
| [gpt4all](https://www.nomic.ai/gpt4all) | <a href=https://github.com/nomic-ai/gpt4all><img src="https://img.shields.io/github/stars/nomic-ai/gpt4all?style=social" width=100/></a> |
| [private-gpt](https://privategpt.dev/) | <a href=https://github.com/zylon-ai/private-gpt><img src="https://img.shields.io/github/stars/zylon-ai/private-gpt?style=social" width=100/></a> |
| [open-interpreter](https://www.openinterpreter.com/) | <a href=https://github.com/OpenInterpreter/open-interpreter><img src="https://img.shields.io/github/stars/OpenInterpreter/open-interpreter?style=social" width=100/></a> |
| [LocalAI](https://localai.io/) | <a href=https://github.com/mudler/LocalAI><img src="https://img.shields.io/github/stars/mudler/LocalAI?style=social" width=100/></a> |
| [jan](https://jan.ai/) | <a href=https://github.com/janhq/jan><img src="https://img.shields.io/github/stars/janhq/jan?style=social" width=100/></a> |
| [dalai](https://cocktailpeanut.github.io/dalai/#/) | <a href=https://github.com/cocktailpeanut/dalai><img src="https://img.shields.io/github/stars/cocktailpeanut/dalai?style=social" width=100/></a> |


## LLM Agent Framework

| Name (site) | Github |
|------------|------------|
| [AutoGPT](https://agpt.co/) | <a href=https://github.com/Significant-Gravitas/AutoGPT><img src="https://img.shields.io/github/stars/Significant-Gravitas/AutoGPT?style=social" width=100/></a> |
| [MetaGPT](https://www.deepwisdom.ai/) | <a href=https://github.com/geekan/MetaGPT><img src="https://img.shields.io/github/stars/geekan/MetaGPT?style=social" width=100/></a> |
| [AgentGPT](https://www.reworkd.ai/) | <a href=https://github.com/reworkd/AgentGPT><img src="https://img.shields.io/github/stars/reworkd/AgentGPT?style=social" width=100/></a> |
| [Autogen](https://microsoft.github.io/autogen/) | <a href=https://github.com/microsoft/autogen><img src="https://img.shields.io/github/stars/microsoft/autogen?style=social" width=100/></a> |
| [BabyAGI](https://github.com/yoheinakajima/babyagi) | <a href=https://github.com/yoheinakajima/babyagi><img src="https://img.shields.io/github/stars/yoheinakajima/babyagi?style=social" width=100/></a> |
| [CrewAI](https://www.crewai.com/) | <a href=https://github.com/joaomdmoura/crewAI><img src="https://img.shields.io/github/stars/joaomdmoura/crewAI?style=social" width=100/></a> |
| [SuperAGI](https://superagi.com/) | <a href=https://github.com/TransformerOptimus/SuperAGI><img src="https://img.shields.io/github/stars/TransformerOptimus/SuperAGI?style=social" width=100/></a> |
| [TaskingAI](https://www.tasking.ai/) | <a href=https://github.com/TaskingAI/TaskingAI><img src="https://img.shields.io/github/stars/TaskingAI/TaskingAI?style=social" width=100/></a> |
| [LaVague](https://www.lavague.ai/) | <a href=https://github.com/lavague-ai/LaVague><img src="https://img.shields.io/github/stars/lavague-ai/LaVague?style=social" width=100/></a> |
| [superagent](https://docs.superagent.sh/overview/overview/introduction) | <a href=https://github.com/superagent-ai/superagent><img src="https://img.shields.io/github/stars/superagent-ai/superagent?style=social" width=100/></a> |
| [Rivet AI](https://rivet.ironcladapp.com/) | <a href=https://github.com/Ironclad/rivet><img src="https://img.shields.io/github/stars/Ironclad/rivet?style=social" width=100/></a> |
| [AGiXT](https://josh-xt.github.io/AGiXT/) | <a href=https://github.com/Josh-XT/AGiXT><img src="https://img.shields.io/github/stars/Josh-XT/AGiXT?style=social" width=100/></a> |
| [cheshirecat](https://cheshirecat.ai/) | <a href=https://github.com/cheshire-cat-ai/core><img src="https://img.shields.io/github/stars/cheshire-cat-ai/core?style=social" width=100/></a> |
| [langroid](https://langroid.github.io/langroid/) | <a href=https://github.com/langroid/langroid><img src="https://img.shields.io/github/stars/langroid/langroid?style=social" width=100/></a> |
| [Griptape](https://www.griptape.ai/) | <a href=https://github.com/griptape-ai/griptape><img src="https://img.shields.io/github/stars/griptape-ai/griptape?style=social" width=100/></a> |
| [Mirascope](https://www.mirascope.io/) | <a href=https://github.com/Mirascope/mirascope><img src="https://img.shields.io/github/stars/Mirascope/mirascope?style=social" width=100/></a> |
| [Julep](https://www.julep.ai/) | <a href=https://github.com/julep-ai/julep><img src="https://img.shields.io/github/stars/julep-ai/julep?style=social" width=100/></a> |
| [ControlFlow](https://controlflow.ai/welcome) | <a href=https://github.com/PrefectHQ/ControlFlow><img src="https://img.shields.io/github/stars/PrefectHQ/ControlFlow?style=social" width=100/></a> |
| [Dify](https://dify.ai/) | <a href=https://github.com/langgenius/dify><img src="https://img.shields.io/github/stars/langgenius/dify?style=social" width=100/></a> |
| [Flowise](https://flowiseai.com/) | <a href=https://github.com/FlowiseAI/Flowise><img src="https://img.shields.io/github/stars/FlowiseAI/Flowise?style=social" width=100/></a> |
| [langflow](https://www.langflow.org/) | <a href=https://github.com/langflow-ai/langflow><img src="https://img.shields.io/github/stars/langflow-ai/langflow?style=social" width=100/></a> |
| [Haystack](https://haystack.deepset.ai/) | <a href=https://github.com/deepset-ai/haystack><img src="https://img.shields.io/github/stars/deepset-ai/haystack?style=social" width=100/></a> |
| [MemGPT](https://memgpt.readme.io/docs/index) | <a href=https://github.com/cpacker/MemGPT><img src="https://img.shields.io/github/stars/cpacker/MemGPT?style=social" width=100/></a> |
| [phidata](https://docs.phidata.com/introduction) | <a href=https://github.com/phidatahq/phidata><img src="https://img.shields.io/github/stars/phidatahq/phidata?style=social" width=100/></a> |
| [PromptFlow](https://microsoft.github.io/promptflow/) | <a href=https://github.com/microsoft/promptflow><img src="https://img.shields.io/github/stars/microsoft/promptflow?style=social" width=100/></a> |
| [chainlit](https://chainlit.io/) | <a href=https://github.com/Chainlit/chainlit><img src="https://img.shields.io/github/stars/Chainlit/chainlit?style=social" width=100/></a> |
| [ragapp](https://github.com/ragapp/ragapp) | <a href=https://github.com/ragapp/ragapp><img src="https://img.shields.io/github/stars/ragapp/ragapp?style=social" width=100/></a> |
| [burr](https://github.com/dagworks-inc/burr) | <a href=https://github.com/dagworks-inc/burr><img src="https://img.shields.io/github/stars/dagworks-inc/burr?style=social" width=100/></a> |


## Model Serving

| Name (site) | Github |
|------------|------------|
| [vLLM](https://vllm.ai/) | <a href=https://github.com/vllm-project/vllm><img src="https://img.shields.io/github/stars/vllm-project/vllm?style=social" width=100/></a> |
| [TensorRT-LLM](https://nvidia.github.io/TensorRT-LLM/) | <a href=https://github.com/NVIDIA/TensorRT-LLM><img src="https://img.shields.io/github/stars/NVIDIA/TensorRT-LLM?style=social" width=100/></a> |
| [bentoml](https://bentoml.com/) | <a href=https://github.com/bentoml/bentoml><img src="https://img.shields.io/github/stars/bentoml/bentoml?style=social" width=100/></a> |
| [lightllm](https://github.com/ModelTC/lightllm) | <a href=https://github.com/ModelTC/lightllm><img src="https://img.shields.io/github/stars/ModelTC/lightllm?style=social" width=100/></a> |
| [openfoundry](https://www.openfoundry.ai/) | <a href=https://github.com/openfoundry-ai/model_manager><img src="https://img.shields.io/github/stars/openfoundry-ai/model_manager?style=social" width=100/></a> |
| [LitServe](https://lightning.ai/docs/litserve/home) | <a href=https://github.com/Lightning-AI/LitServe><img src="https://img.shields.io/github/stars/lightning-ai/litserve?style=social" width=100/></a> |
| [truss](https://truss.baseten.co/) | <a href=https://github.com/basetenlabs/truss><img src="https://img.shields.io/github/stars/basetenlabs/truss?style=social" width=100/></a> |


## Observability

| Name (site) | Github |
|------------|------------|
| [pezzo](https://pezzo.ai/) | <a href=https://github.com/pezzolabs/pezzo><img src="https://img.shields.io/github/stars/pezzolabs/pezzo?style=social" width=100/></a> |
| [helicone](https://www.helicone.ai/) | <a href=https://github.com/Helicone/helicone><img src="https://img.shields.io/github/stars/Helicone/helicone?style=social" width=100/></a> |
| [Portkey](https://portkey.ai/) | <a href=https://github.com/Portkey-AI/gateway><img src="https://img.shields.io/github/stars/Portkey-AI/gateway?style=social" width=100/></a> |
| [Langfuse](https://langfuse.com/) | <a href=https://github.com/langfuse/langfuse><img src="https://img.shields.io/github/stars/langfuse/langfuse?style=social" width=100/></a> |
| [langtrace](https://www.langtrace.ai/) | <a href=https://github.com/Scale3-Labs/langtrace><img src="https://img.shields.io/github/stars/Scale3-Labs/langtrace?style=social" width=100/></a> |
| [traceloop](https://www.traceloop.com/) | <a href=https://github.com/traceloop/openllmetry><img src="https://img.shields.io/github/stars/traceloop/openllmetry?style=social" width=100/></a> |
| [trulens](https://www.trulens.org/) | <a href=https://github.com/truera/trulens><img src="https://img.shields.io/github/stars/truera/trulens?style=social" width=100/></a> |
| [log10](https://www.log10.io/) | <a href=https://github.com/log10-io/log10><img src="https://img.shields.io/github/stars/log10-io/log10?style=social" width=100/></a> |
| [LangWatch](https://github.com/langwatch/langwatch) | <a href=https://github.com/langwatch/langwatch><img src="https://img.shields.io/github/stars/langwatch/langwatch?style=social" width=100/></a> |
| [burr](https://github.com/dagworks-inc/burr) | <a href=https://github.com/dagworks-inc/burr><img src="https://img.shields.io/github/stars/dagworks-inc/burr?style=social" width=100/></a> |
| [hamilton](https://github.com/dagworks-inc/hamilton) | <a href=https://github.com/dagworks-inc/hamilton><img src="https://img.shields.io/github/stars/dagworks-inc/hamilton?style=social" width=100/></a> |


## Pre Training

| Name (site) | Github |
|------------|------------|
| [Colossal AI](https://colossalai.org/) | <a href=https://github.com/hpcaitech/ColossalAI><img src="https://img.shields.io/github/stars/hpcaitech/ColossalAI?style=social" width=100/></a> |
| [FastChat](https://lmsys.org/projects/) | <a href=https://github.com/lm-sys/FastChat><img src="https://img.shields.io/github/stars/lm-sys/FastChat?style=social" width=100/></a> |
| [pytorch-lightning](https://lightning.ai/) | <a href=https://github.com/Lightning-AI/pytorch-lightning><img src="https://img.shields.io/github/stars/Lightning-AI/pytorch-lightning?style=social" width=100/></a> |
| [llm c](https://github.com/karpathy/llm.c) | <a href=https://github.com/karpathy/llm.c><img src="https://img.shields.io/github/stars/karpathy/llm.c?style=social" width=100/></a> |
| [miniGPT](https://github.com/karpathy/minGPT) | <a href=https://github.com/karpathy/minGPT><img src="https://img.shields.io/github/stars/karpathy/minGPT?style=social" width=100/></a> |



## Prompt Engineering

| Name (site) | Github |
|------------|------------|
| [DSPy](https://dspy-docs.vercel.app/) | <a href=https://github.com/stanfordnlp/dspy><img src="https://img.shields.io/github/stars/stanfordnlp/dspy?style=social" width=100/></a> |
| [Langfuse](https://langfuse.com/) | <a href=https://github.com/langfuse/langfuse><img src="https://img.shields.io/github/stars/langfuse/langfuse?style=social" width=100/></a> |
| [hamilton](https://github.com/dagworks-inc/hamilton) | <a href=https://github.com/dagworks-inc/hamilton><img src="https://img.shields.io/github/stars/dagworks-inc/hamilton?style=social" width=100/></a> |


## RAG Framework

| Name (site) | Github |
|------------|------------|
| [Langchain](https://www.langchain.com/) | <a href=https://github.com/langchain-ai/langchain><img src="https://img.shields.io/github/stars/langchain-ai/langchain?style=social" width=100/></a> |
| [LlamaIndex](https://www.llamaindex.ai/) | <a href=https://github.com/run-llama/llama_index><img src="https://img.shields.io/github/stars/run-llama/llama_index?style=social" width=100/></a> |
| [FastGPT](https://fastgpt.in/) | <a href=https://github.com/labring/FastGPT><img src="https://img.shields.io/github/stars/labring/FastGPT?style=social" width=100/></a> |
| [ragflow](https://ragflow.io/) | <a href=https://github.com/infiniflow/ragflow><img src="https://img.shields.io/github/stars/infiniflow/ragflow?style=social" width=100/></a> |
| [vanna](https://vanna.ai/) | <a href=https://github.com/vanna-ai/vanna><img src="https://img.shields.io/github/stars/vanna-ai/vanna?style=social" width=100/></a> |
| [FlagEmbedding](https://github.com/FlagOpen/FlagEmbedding) | <a href=https://github.com/FlagOpen/FlagEmbedding><img src="https://img.shields.io/github/stars/FlagOpen/FlagEmbedding?style=social" width=100/></a> |
| [llmware](https://llmware-ai.github.io/llmware/) | <a href=https://github.com/llmware-ai/llmware><img src="https://img.shields.io/github/stars/llmware-ai/llmware?style=social" width=100/></a> |
| [llm-app](https://pathway.com/) | <a href=https://github.com/pathwaycom/llm-app><img src="https://img.shields.io/github/stars/pathwaycom/llm-app?style=social" width=100/></a> |
| [Cognita](https://cognita.truefoundry.com/) | <a href=https://github.com/truefoundry/cognita><img src="https://img.shields.io/github/stars/truefoundry/cognita?style=social" width=100/></a> |
| [casibase](https://casibase.org/) | <a href=https://github.com/casibase/casibase><img src="https://img.shields.io/github/stars/casibase/casibase?style=social" width=100/></a> |
| [SciPhi](https://r2r-docs.sciphi.ai/introduction) | <a href=https://github.com/SciPhi-AI/R2R><img src="https://img.shields.io/github/stars/SciPhi-AI/R2R?style=social" width=100/></a> |
| [trieve](https://trieve.ai/) | <a href=https://github.com/devflowinc/trieve><img src="https://img.shields.io/github/stars/devflowinc/trieve?style=social" width=100/></a> |
| [autollm](https://github.com/safevideo/autollm) | <a href=https://github.com/safevideo/autollm><img src="https://img.shields.io/github/stars/safevideo/autollm?style=social" width=100/></a> |
| [canopy](https://www.pinecone.io/blog/canopy-rag-framework/) | <a href=https://github.com/pinecone-io/canopy><img src="https://img.shields.io/github/stars/pinecone-io/canopy?style=social" width=100/></a> |
| [NeumAI](https://www.neum.ai/) | <a href=https://github.com/NeumTry/NeumAI><img src="https://img.shields.io/github/stars/NeumTry/NeumAI?style=social" width=100/></a> |
| [WrenAI](https://www.getwren.ai/) | <a href=https://github.com/Canner/WrenAI><img src="https://img.shields.io/github/stars/Canner/WrenAI?style=social" width=100/></a> |
| [ragna](https://ragna.chat/en/stable/) | <a href=https://github.com/Quansight/ragna><img src="https://img.shields.io/github/stars/Quansight/ragna?style=social" width=100/></a> |
| [Dify](https://dify.ai/) | <a href=https://github.com/langgenius/dify><img src="https://img.shields.io/github/stars/langgenius/dify?style=social" width=100/></a> |
| [Flowise](https://flowiseai.com/) | <a href=https://github.com/FlowiseAI/Flowise><img src="https://img.shields.io/github/stars/FlowiseAI/Flowise?style=social" width=100/></a> |
| [langflow](https://www.langflow.org/) | <a href=https://github.com/langflow-ai/langflow><img src="https://img.shields.io/github/stars/langflow-ai/langflow?style=social" width=100/></a> |
| [Haystack](https://haystack.deepset.ai/) | <a href=https://github.com/deepset-ai/haystack><img src="https://img.shields.io/github/stars/deepset-ai/haystack?style=social" width=100/></a> |
| [MemGPT](https://memgpt.readme.io/docs/index) | <a href=https://github.com/cpacker/MemGPT><img src="https://img.shields.io/github/stars/cpacker/MemGPT?style=social" width=100/></a> |
| [phidata](https://docs.phidata.com/introduction) | <a href=https://github.com/phidatahq/phidata><img src="https://img.shields.io/github/stars/phidatahq/phidata?style=social" width=100/></a> |
| [PromptFlow](https://microsoft.github.io/promptflow/) | <a href=https://github.com/microsoft/promptflow><img src="https://img.shields.io/github/stars/microsoft/promptflow?style=social" width=100/></a> |
| [chainlit](https://chainlit.io/) | <a href=https://github.com/Chainlit/chainlit><img src="https://img.shields.io/github/stars/Chainlit/chainlit?style=social" width=100/></a> |
| [ragapp](https://github.com/ragapp/ragapp) | <a href=https://github.com/ragapp/ragapp><img src="https://img.shields.io/github/stars/ragapp/ragapp?style=social" width=100/></a> |
| [hamilton](https://github.com/dagworks-inc/hamilton) | <a href=https://github.com/dagworks-inc/hamilton><img src="https://img.shields.io/github/stars/dagworks-inc/hamilton?style=social" width=100/></a> |
| [RagBuilder](https://github.com/KruxAI/ragbuilder) | <a href=https://github.com/KruxAI/ragbuilder><img src="https://img.shields.io/github/stars/kruxai/ragbuilder?style=social" width=100/></a> |

## Security

| Name (site) | Github |
|------------|------------|
| [Armur](https://armur.ai/) | <a href=https://github.com/Armur-Ai/Auto-Pentest-GPT-AI><img src="https://img.shields.io/github/stars/Armur-Ai/Auto-Pentest-GPT-AI?style=social" width=100/></a> |


## Structured Extraction

| Name (site) | Github |
|------------|------------|
| [Unstructured](https://unstructured.io/) | <a href=https://github.com/Unstructured-IO/unstructured><img src="https://img.shields.io/github/stars/Unstructured-IO/unstructured?style=social" width=100/></a> |
| [omniparse](https://docs.cognitivelab.in/) | <a href=https://github.com/adithya-s-k/omniparse><img src="https://img.shields.io/github/stars/adithya-s-k/omniparse?style=social" width=100/></a> |
| [unstract](https://unstract.com/) | <a href=https://github.com/Zipstack/unstract><img src="https://img.shields.io/github/stars/Zipstack/unstract?style=social" width=100/></a> |
| [indexify](https://getindexify.ai/) | <a href=https://github.com/tensorlakeai/indexify><img src="https://img.shields.io/github/stars/tensorlakeai/indexify?style=social" width=100/></a> |
| [firecrawl](https://www.firecrawl.dev/) | <a href=https://github.com/mendableai/firecrawl><img src="https://img.shields.io/github/stars/mendableai/firecrawl?style=social" width=100/></a> |
| [Scrapegraph-ai](https://scrapegraphai.com/) | <a href=https://github.com/ScrapeGraphAI/Scrapegraph-ai><img src="https://img.shields.io/github/stars/ScrapeGraphAI/Scrapegraph-ai?style=social" width=100/></a> |
| [extractous](https://github.com/yobix-ai/extractous) | <a href=[https://github.com/ScrapeGraphAI/Scrapegraph-ai](https://github.com/yobix-ai/extractous)><img src="https://img.shields.io/github/stars/yobix-ai/extractous?style=social" width=100/></a> |


## Structured Generation

| Name (site) | Github |
|------------|------------|
| [guidance](https://github.com/guidance-ai/guidance) | <a href=https://github.com/guidance-ai/guidance><img src="https://img.shields.io/github/stars/guidance-ai/guidance?style=social" width=100/></a> |
| [outlines](https://outlines-dev.github.io/outlines/) | <a href=https://github.com/outlines-dev/outlines><img src="https://img.shields.io/github/stars/outlines-dev/outlines?style=social" width=100/></a> |
| [instructor](https://useinstructor.com/) | <a href=https://github.com/jxnl/instructor><img src="https://img.shields.io/github/stars/jxnl/instructor?style=social" width=100/></a> |
| [jsonformer](https://github.com/1rgs/jsonformer) | <a href=https://github.com/1rgs/jsonformer><img src="https://img.shields.io/github/stars/1rgs/jsonformer?style=social" width=100/></a> |
| [sglang](https://github.com/sgl-project/sglang) | <a href=https://github.com/sgl-project/sglang><img src="https://img.shields.io/github/stars/sgl-project/sglang?style=social" width=100/></a> |


## Vector DB

| Name (site) | Github |
|------------|------------|
| [milvus](https://milvus.io/) | <a href=https://github.com/milvus-io/milvus><img src="https://img.shields.io/github/stars/milvus-io/milvus?style=social" width=100/></a> |
| [Qdrant](https://qdrant.tech/) | <a href=https://github.com/qdrant/qdrant><img src="https://img.shields.io/github/stars/qdrant/qdrant?style=social" width=100/></a> |
| [Chroma](https://www.trychroma.com/) | <a href=https://github.com/chroma-core/chroma><img src="https://img.shields.io/github/stars/chroma-core/chroma?style=social" width=100/></a> |
| [Weaviate](https://weaviate.io/) | <a href=https://github.com/weaviate/weaviate><img src="https://img.shields.io/github/stars/weaviate/weaviate?style=social" width=100/></a> |
| [pgvector](https://www.postgresql.org/about/news/pgvector-070-released-2852/) | <a href=https://github.com/pgvector/pgvector><img src="https://img.shields.io/github/stars/pgvector/pgvector?style=social" width=100/></a> |
| [deeplake](https://www.activeloop.ai/) | <a href=https://github.com/activeloopai/deeplake><img src="https://img.shields.io/github/stars/activeloopai/deeplake?style=social" width=100/></a> |
| [txtai](https://neuml.github.io/txtai/) | <a href=https://github.com/neuml/txtai><img src="https://img.shields.io/github/stars/neuml/txtai?style=social" width=100/></a> |
| [marqo](https://www.marqo.ai/) | <a href=https://github.com/marqo-ai/marqo><img src="https://img.shields.io/github/stars/marqo-ai/marqo?style=social" width=100/></a> |
| [lancedb](https://lancedb.com/) | <a href=https://github.com/lancedb/lancedb><img src="https://img.shields.io/github/stars/lancedb/lancedb?style=social" width=100/></a> |
| [nucliaDB](https://docs.nuclia.dev/docs/) | <a href=https://github.com/nuclia/nucliadb><img src="https://img.shields.io/github/stars/nuclia/nucliadb?style=social" width=100/></a> |
| [oasysdb](https://docs.oasysdb.com/) | <a href=https://github.com/oasysai/oasysdb><img src="https://img.shields.io/github/stars/oasysai/oasysdb?style=social" width=100/></a> |
| [lantern](https://lantern.dev/) | <a href=https://github.com/lanterndata/lantern><img src="https://img.shields.io/github/stars/lanterndata/lantern?style=social" width=100/></a> |
| [vespa](https://vespa.ai/) | <a href=https://github.com/vespa-engine/vespa><img src="https://img.shields.io/github/stars/vespa-engine/vespa?style=social" width=100/></a> |

## Voice Agent

| Name (site) | Github |
|------------|------------|
| [vocode](https://www.vocode.dev/) | <a href=https://github.com/vocodedev/vocode-python><img src="https://img.shields.io/github/stars/vocodedev/vocode-python?style=social" width=100/></a> |
| [bolna](https://www.bolna.dev/) | <a href=https://github.com/bolna-ai/bolna><img src="https://img.shields.io/github/stars/bolna-ai/bolna?style=social" width=100/></a> |

