/*
    * WinDBG Anti-RootKit extension
    * Copyright  2013-2018  Vyacheslav Rusakoff
    * 
    * This program is free software: you can redistribute it and/or modify
    * it under the terms of the GNU General Public License as published by
    * the Free Software Foundation, either version 3 of the License, or
    * (at your option) any later version.
    * 
    * This program is distributed in the hope that it will be useful,
    * but WITHOUT ANY WARRANTY; without even the implied warranty of
    * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    * GNU General Public License for more details.
    * 
    * You should have received a copy of the GNU General Public License
    * along with this program.  If not, see <http://www.gnu.org/licenses/>.

    * This work is licensed under the terms of the GNU GPL, version 3.  See
    * the COPYING file in the top-level directory.
*/

#include <engextcpp.hpp>

#include <string>
#include "sdt_w32p.hpp"
#include "./ddk.h"

namespace wa {

//////////////////////////////////////////////////////////////////////////
std::string get_service_table_routine_name_internal(const size_t index,
                                                    const size_t max_count,
                                                    const char** service_table);
std::string get_service_table_prefix_name(const ServiceTableType type);
//////////////////////////////////////////////////////////////////////////

//////////////////////////////////////////////////////////////////////////
// x86
//////////////////////////////////////////////////////////////////////////

//////////////////////////////////////////////////////////////////////////
// Windows XP SP3 _KiServiceTable
//////////////////////////////////////////////////////////////////////////
static const char* KiServiceTable_XpSp3_x86[] = {
    "NtAcceptConnectPort",
    "NtAccessCheck",
    "NtAccessCheckAndAuditAlarm",
    "NtAccessCheckByType",
    "NtAccessCheckByTypeAndAuditAlarm",
    "NtAccessCheckByTypeResultList",
    "NtAccessCheckByTypeResultListAndAuditAlarm",
    "NtAccessCheckByTypeResultListAndAuditAlarmByHandle",
    "NtAddAtom",
    "NtAddBootEntry",
    "NtAdjustGroupsToken",
    "NtAdjustPrivilegesToken",
    "NtAlertResumeThread",
    "NtAlertThread",
    "NtAllocateLocallyUniqueId",
    "NtAllocateUserPhysicalPages",
    "NtAllocateUuids",
    "NtAllocateVirtualMemory",
    "NtAreMappedFilesTheSame",
    "NtAssignProcessToJobObject",
    "NtCallbackReturn",
    "NtModifyBootEntry",
    "NtCancelIoFile",
    "NtCancelTimer",
    "NtClearEvent",
    "NtClose",
    "NtCloseObjectAuditAlarm",
    "NtCompactKeys",
    "NtCompareTokens",
    "NtCompleteConnectPort",
    "NtCompressKey",
    "NtConnectPort",
    "NtContinue",
    "NtCreateDebugObject",
    "NtCreateDirectoryObject",
    "NtCreateEvent",
    "NtCreateEventPair",
    "NtCreateFile",
    "NtCreateIoCompletion",
    "NtCreateJobObject",
    "NtCreateJobSet",
    "NtCreateKey",
    "NtCreateMailslotFile",
    "NtCreateMutant",
    "NtCreateNamedPipeFile",
    "NtCreatePagingFile",
    "NtCreatePort",
    "NtCreateProcess",
    "NtCreateProcessEx",
    "NtCreateProfile",
    "NtCreateSection",
    "NtCreateSemaphore",
    "NtCreateSymbolicLinkObject",
    "NtCreateThread",
    "NtCreateTimer",
    "NtCreateToken",
    "NtCreateWaitablePort",
    "NtDebugActiveProcess",
    "NtDebugContinue",
    "NtDelayExecution",
    "NtDeleteAtom",
    "NtModifyBootEntry",
    "NtDeleteFile",
    "NtDeleteKey",
    "NtDeleteObjectAuditAlarm",
    "NtDeleteValueKey",
    "NtDeviceIoControlFile",
    "NtDisplayString",
    "NtDuplicateObject",
    "NtDuplicateToken",
    "NtAddBootEntry",
    "NtEnumerateKey",
    "NtEnumerateSystemEnvironmentValuesEx",
    "NtEnumerateValueKey",
    "NtExtendSection",
    "NtFilterToken",
    "NtFindAtom",
    "NtFlushBuffersFile",
    "NtFlushInstructionCache",
    "NtFlushKey",
    "NtFlushVirtualMemory",
    "NtFlushWriteBuffer",
    "NtFreeUserPhysicalPages",
    "NtFreeVirtualMemory",
    "NtFsControlFile",
    "NtGetContextThread",
    "NtGetDevicePowerState",
    "NtGetPlugPlayEvent",
    "NtGetWriteWatch",
    "NtImpersonateAnonymousToken",
    "NtImpersonateClientOfPort",
    "NtImpersonateThread",
    "NtInitializeRegistry",
    "NtInitiatePowerAction",
    "NtIsProcessInJob",
    "NtIsSystemResumeAutomatic",
    "NtListenPort",
    "NtLoadDriver",
    "NtLoadKey",
    "NtLoadKey2",
    "NtLockFile",
    "NtLockProductActivationKeys",
    "NtLockRegistryKey",
    "NtLockVirtualMemory",
    "NtMakePermanentObject",
    "NtMakeTemporaryObject",
    "NtMapUserPhysicalPages",
    "NtMapUserPhysicalPagesScatter",
    "NtMapViewOfSection",
    "NtModifyBootEntry",
    "NtNotifyChangeDirectoryFile",
    "NtNotifyChangeKey",
    "NtNotifyChangeMultipleKeys",
    "NtOpenDirectoryObject",
    "NtOpenEvent",
    "NtOpenEventPair",
    "NtOpenFile",
    "NtOpenIoCompletion",
    "NtOpenJobObject",
    "NtOpenKey",
    "NtOpenMutant",
    "NtOpenObjectAuditAlarm",
    "NtOpenProcess",
    "NtOpenProcessToken",
    "NtOpenProcessTokenEx",
    "NtOpenSection",
    "NtOpenSemaphore",
    "NtOpenSymbolicLinkObject",
    "NtOpenthread",
    "NtOpenThreadToken",
    "NtOpenThreadTokenEx",
    "NtOpenTimer",
    "NtPlugPlayControl",
    "NtPowerInformation",
    "NtPrivilegeCheck",
    "NtPrivilegeObjectAuditAlarm",
    "NtPrivilegedServiceAuditAlarm",
    "NtProtectVirtualMemory",
    "NtPulseEvent",
    "NtQueryAttributesFile",
    "NtAddBootEntry",
    "NtAddBootEntry",
    "NtQueryDebugFilterState",
    "NtQueryDefaultLocale",
    "NtQueryDefaultUILanguage",
    "NtQueryDirectoryFile",
    "NtQueryDirectoryObject",
    "NtQueryEaFile",
    "NtQueryEvent",
    "NtQueryFullAttributesFile",
    "NtQueryInformationAtom",
    "NtQueryInformationFile",
    "NtQueryInformationJobObject",
    "NtQueryInformationPort",
    "NtQueryInformationProcess",
    "NtQueryInformationThread",
    "NtQueryInformationToken",
    "NtQueryInstallUILanguage",
    "NtQueryIntervalProfile",
    "NtQueryIoCompletion",
    "NtQueryKey",
    "NtQueryMultipleValueKey",
    "NtQueryMutant",
    "NtQueryObject",
    "NtQueryOpenSubKeys",
    "NtQueryPerformanceCounter",
    "NtQueryQuotaInformationFile",
    "NtQuerySection",
    "NtQuerySecurityObject",
    "NtQuerySemaphore",
    "NtQuerySymbolicLinkObject",
    "NtQuerySystemEnvironmentValue",
    "NtSetSystemEnvironmentValueEx",
    "NtQuerySystemInformation",
    "NtQuerySystemTime",
    "NtQueryTimer",
    "NtQueryTimerResolution",
    "NtQueryValueKey",
    "NtQueryVirtualMemory",
    "NtQueryVolumeInformationFile",
    "NtQueueApcThread",
    "NtRaiseException",
    "NtRaiseHardError",
    "NtReadFile",
    "NtReadFileScatter",
    "NtReadRequestData",
    "NtReadVirtualMemory",
    "NtRegisterThreadTerminatePort",
    "NtReleaseMutant",
    "NtReleaseSemaphore",
    "NtRemoveIoCompletion",
    "NtRemoveProcessDebug",
    "NtRenameKey",
    "NtReplaceKey",
    "NtReplyPort",
    "NtReplyWaitReceivePort",
    "NtReplyWaitReceivePortEx",
    "NtReplyWaitReplyPort",
    "NtRequestDeviceWakeup",
    "NtRequestPort",
    "NtRequestWaitReplyPort",
    "NtRequestWakeupLatency",
    "NtResetEvent",
    "NtResetWriteWatch",
    "NtRestoreKey",
    "NtResumeProcess",
    "NtResumeThread",
    "NtSaveKey",
    "NtSaveKeyEx",
    "NtSaveMergedKeys",
    "NtSecureConnectPort",
    "NtAddBootEntry",
    "NtAddBootEntry",
    "NtSetContextThread",
    "NtSetDebugFilterState",
    "NtSetDefaultHardErrorPort",
    "NtSetDefaultLocale",
    "NtSetDefaultUILanguage",
    "NtSetEaFile",
    "NtSetEvent",
    "NtSetEventBoostPriority",
    "NtSetHighEventPair",
    "NtSetHighWaitLowEventPair",
    "NtSetInformationDebugObject",
    "NtSetInformationFile",
    "NtSetInformationJobObject",
    "NtSetInformationKey",
    "NtSetInformationObject",
    "NtSetInformationProcess",
    "NtSetInformationThread",
    "NtSetInformationToken",
    "NtSetIntervalProfile",
    "NtSetIoCompletion",
    "NtSetLdtEntries",
    "NtSetLowEventPair",
    "NtSetLowWaitHighEventPair",
    "NtSetQuotaInformationFile",
    "NtSetSecurityObject",
    "NtSetSystemEnvironmentValue",
    "NtSetSystemEnvironmentValueEx",
    "NtSetSystemInformation",
    "NtSetSystemPowerState",
    "NtSetSystemTime",
    "NtSetThreadExecutionState",
    "NtSetTimer",
    "NtSetTimerResolution",
    "NtSetUuidSeed",
    "NtSetValueKey",
    "NtSetVolumeInformationFile",
    "NtShutdownSystem",
    "NtSignalAndWaitForSingleObject",
    "NtStartProfile",
    "NtStopProfile",
    "NtSuspendProcess",
    "NtSuspendThread",
    "NtSystemDebugControl",
    "NtTerminateJobObject",
    "NtTerminateProcess",
    "NtTerminateThread",
    "NtTestAlert",
    "NtTraceEvent",
    "NtTranslateFilePath",
    "NtUnloadDriver",
    "NtUnloadKey",
    "NtUnloadKeyEx",
    "NtUnlockFile",
    "NtUnlockVirtualMemory",
    "NtUnmapViewOfSection",
    "NtVdmControl",
    "NtWaitForDebugEvent",
    "NtWaitForMultipleObjects",
    "NtWaitForSingleObject",
    "NtWaitHighEventPair",
    "NtWaitLowEventPair",
    "NtWriteFile",
    "NtWriteFileGather",
    "NtWriteRequestData",
    "NtWriteVirtualMemory",
    "NtYieldExecution",
    "NtCreateKeyedEvent",
    "NtOpenKeyedEvent",
    "NtReleaseKeyedEvent",
    "NtWaitForKeyedEvent",
    "NtQueryPortInformationProcess"
};

//////////////////////////////////////////////////////////////////////////
// Windows 2003 SP2 _KiServiceTable
//////////////////////////////////////////////////////////////////////////
static const char* KiServiceTable_W2k3Sp2_x86[] = {
    "NtAcceptConnectPort",
    "NtAccessCheck",
    "NtAccessCheckAndAuditAlarm",
    "NtAccessCheckByType",
    "NtAccessCheckByTypeAndAuditAlarm",
    "NtAccessCheckByTypeResultList",
    "NtAccessCheckByTypeResultListAndAuditAlarm",
    "NtAccessCheckByTypeResultListAndAuditAlarmByHandle",
    "NtAddAtom",
    "NtQueryDriverEntryOrder",
    "NtQueryDriverEntryOrder",
    "NtAdjustGroupsToken",
    "NtAdjustPrivilegesToken",
    "NtAlertResumeThread",
    "NtAlertThread",
    "NtAllocateLocallyUniqueId",
    "NtAllocateUserPhysicalPages",
    "NtAllocateUuids",
    "NtAllocateVirtualMemory",
    "NtApphelpCacheControl",
    "NtAreMappedFilesTheSame",
    "NtAssignProcessToJobObject",
    "NtCallbackReturn",
    "NtModifyBootEntry",
    "NtCancelIoFile",
    "NtCancelTimer",
    "NtClearEvent",
    "NtClose",
    "NtCloseObjectAuditAlarm",
    "NtCompactKeys",
    "NtCompareTokens",
    "NtCompleteConnectPort",
    "NtCompressKey",
    "NtConnectPort",
    "NtContinue",
    "NtCreateDebugObject",
    "NtCreateDirectoryObject",
    "NtCreateEvent",
    "NtCreateEventPair",
    "NtCreateFile",
    "NtCreateIoCompletion",
    "NtCreateJobObject",
    "NtCreateJobSet",
    "NtCreateKey",
    "NtCreateMailslotFile",
    "NtCreateMutant",
    "NtCreateNamedPipeFile",
    "NtCreatePagingFile",
    "NtCreatePort",
    "NtCreateProcess",
    "NtCreateProcessEx",
    "NtCreateProfile",
    "NtCreateSection",
    "NtCreateSemaphore",
    "NtCreateSymbolicLinkObject",
    "NtCreateThread",
    "NtCreateTimer",
    "NtCreateToken",
    "NtCreateWaitablePort",
    "NtDebugActiveProcess",
    "NtDebugContinue",
    "NtDelayExecution",
    "NtDeleteAtom",
    "NtModifyBootEntry",
    "NtModifyBootEntry",
    "NtDeleteFile",
    "NtDeleteKey",
    "NtDeleteObjectAuditAlarm",
    "NtDeleteValueKey",
    "NtDeviceIoControlFile",
    "NtDisplayString",
    "NtDuplicateObject",
    "NtDuplicateToken",
    "NtQueryDriverEntryOrder",
    "NtQueryDriverEntryOrder",
    "NtEnumerateKey",
    "NtEnumerateSystemEnvironmentValuesEx",
    "NtEnumerateValueKey",
    "NtExtendSection",
    "NtFilterToken",
    "NtFindAtom",
    "NtFlushBuffersFile",
    "NtFlushInstructionCache",
    "NtFlushKey",
    "NtFlushVirtualMemory",
    "NtFlushWriteBuffer",
    "NtFreeUserPhysicalPages",
    "NtFreeVirtualMemory",
    "NtFsControlFile",
    "NtGetContextThread",
    "NtGetDevicePowerState",
    "NtGetPlugPlayEvent",
    "NtGetWriteWatch",
    "NtImpersonateAnonymousToken",
    "NtImpersonateClientOfPort",
    "NtImpersonateThread",
    "NtInitializeRegistry",
    "NtInitiatePowerAction",
    "NtIsProcessInJob",
    "NtIsSystemResumeAutomatic",
    "NtListenPort",
    "NtLoadDriver",
    "NtLoadKey",
    "NtLoadKey2",
    "NtLoadKeyEx",
    "NtLockFile",
    "NtLockProductActivationKeys",
    "NtLockRegistryKey",
    "NtLockVirtualMemory",
    "NtMakePermanentObject",
    "NtMakeTemporaryObject",
    "NtMapUserPhysicalPages",
    "NtMapUserPhysicalPagesScatter",
    "NtMapViewOfSection",
    "NtModifyBootEntry",
    "NtModifyBootEntry",
    "NtNotifyChangeDirectoryFile",
    "NtNotifyChangeKey",
    "NtNotifyChangeMultipleKeys",
    "NtOpenDirectoryObject",
    "NtOpenEvent",
    "NtOpenEventPair",
    "NtOpenFile",
    "NtOpenIoCompletion",
    "NtOpenJobObject",
    "NtOpenKey",
    "NtOpenMutant",
    "NtOpenObjectAuditAlarm",
    "NtOpenProcess",
    "NtOpenProcessToken",
    "NtOpenProcessTokenEx",
    "NtOpenSection",
    "NtOpenSemaphore",
    "NtOpenSymbolicLinkObject",
    "NtOpenThread",
    "NtOpenThreadToken",
    "NtOpenThreadTokenEx",
    "NtOpenTimer",
    "NtPlugPlayControl",
    "NtPowerInformation",
    "NtPrivilegeCheck",
    "NtPrivilegeObjectAuditAlarm",
    "NtPrivilegedServiceAuditAlarm",
    "NtProtectVirtualMemory",
    "NtPulseEvent",
    "NtQueryAttributesFile",
    "NtQueryDriverEntryOrder",
    "NtQueryDriverEntryOrder",
    "NtQueryDebugFilterState",
    "NtQueryDefaultLocale",
    "NtQueryDefaultUILanguage",
    "NtQueryDirectoryFile",
    "NtQueryDirectoryObject",
    "NtQueryDriverEntryOrder",
    "NtQueryEaFile",
    "NtQueryEvent",
    "NtQueryFullAttributesFile",
    "NtQueryInformationAtom",
    "NtQueryInformationFile",
    "NtQueryInformationJobObject",
    "NtQueryInformationPort",
    "NtQueryInformationProcess",
    "NtQueryInformationThread",
    "NtQueryInformationToken",
    "NtQueryInstallUILanguage",
    "NtQueryIntervalProfile",
    "NtQueryIoCompletion",
    "NtQueryKey",
    "NtQueryMultipleValueKey",
    "NtQueryMutant",
    "NtQueryObject",
    "NtQueryOpenSubKeys",
    "NtQueryOpenSubKeysEx",
    "NtQueryPerformanceCounter",
    "NtQueryQuotaInformationFile",
    "NtQuerySection",
    "NtQuerySecurityObject",
    "NtQuerySemaphore",
    "NtQuerySymbolicLinkObject",
    "NtQuerySystemEnvironmentValue",
    "NtQuerySystemEnvironmentValueEx",
    "NtQuerySystemInformation",
    "NtQuerySystemTime",
    "NtQueryTimer",
    "NtQueryTimerResolution",
    "NtQueryValueKey",
    "NtQueryVirtualMemory",
    "NtQueryVolumeInformationFile",
    "NtQueueApcThread",
    "NtRaiseException",
    "NtRaiseHardError",
    "NtReadFile",
    "NtReadFileScatter",
    "NtReadRequestData",
    "NtReadVirtualMemory",
    "NtRegisterThreadTerminatePort",
    "NtReleaseMutant",
    "NtReleaseSemaphore",
    "NtRemoveIoCompletion",
    "NtRemoveProcessDebug",
    "NtRenameKey",
    "NtReplaceKey",
    "NtReplyPort",
    "NtReplyWaitReceivePort",
    "NtReplyWaitReceivePortEx",
    "NtReplyWaitReplyPort",
    "NtModifyBootEntry",
    "NtRequestPort",
    "NtRequestWaitReplyPort",
    "NtRequestWakeupLatency",
    "NtResetEvent",
    "NtResetWriteWatch",
    "NtRestoreKey",
    "NtResumeProcess",
    "NtResumeThread",
    "NtSaveKey",
    "NtSaveKeyEx",
    "NtSaveMergedKeys",
    "NtSecureConnectPort",
    "NtQueryDriverEntryOrder",
    "NtQueryDriverEntryOrder",
    "NtSetContextThread",
    "NtSetDebugFilterState",
    "NtSetDefaultHardErrorPort",
    "NtSetDefaultLocale",
    "NtSetDefaultUILanguage",
    "NtQueryDriverEntryOrder",
    "NtSetEaFile",
    "NtSetEvent",
    "NtSetEventBoostPriority",
    "NtSetHighEventPair",
    "NtSetHighWaitLowEventPair",
    "NtSetInformationDebugObject",
    "NtSetInformationFile",
    "NtSetInformationJobObject",
    "NtSetInformationKey",
    "NtSetInformationObject",
    "NtSetInformationProcess",
    "NtSetInformationThread",
    "NtSetInformationToken",
    "NtSetIntervalProfile",
    "NtSetIoCompletion",
    "NtSetLdtEntries",
    "NtSetLowEventPair",
    "NtSetLowWaitHighEventPair",
    "NtSetQuotaInformationFile",
    "NtSetSecurityObject",
    "NtSetSystemEnvironmentValue",
    "NtQuerySystemEnvironmentValueEx",
    "NtSetSystemInformation",
    "NtSetSystemPowerState",
    "NtSetSystemTime",
    "NtSetThreadExecutionState",
    "NtSetTimer",
    "NtSetTimerResolution",
    "NtSetUuidSeed",
    "NtSetValueKey",
    "NtSetVolumeInformationFile",
    "NtShutdownSystem",
    "NtSignalAndWaitForSingleObject",
    "NtStartProfile",
    "NtStopProfile",
    "NtSuspendProcess",
    "NtSuspendThread",
    "NtSystemDebugControl",
    "NtTerminateJobObject",
    "NtTerminateProcess",
    "NtTerminateThread",
    "NtTestAlert",
    "NtTraceEvent",
    "NtTranslateFilePath",
    "NtUnloadDriver",
    "NtUnloadKey",
    "NtUnloadKey2",
    "NtUnloadKeyEx",
    "NtUnlockFile",
    "NtUnlockVirtualMemory",
    "NtUnmapViewOfSection",
    "NtVdmControl",
    "NtWaitForDebugEvent",
    "NtWaitForMultipleObjects",
    "NtWaitForSingleObject",
    "NtWaitHighEventPair",
    "NtWaitLowEventPair",
    "NtWriteFile",
    "NtWriteFileGather",
    "NtWriteRequestData",
    "NtWriteVirtualMemory",
    "NtYieldExecution",
    "NtCreateKeyedEvent",
    "NtOpenKeyedEvent",
    "NtReleaseKeyedEvent",
    "NtWaitForKeyedEvent",
    "NtQueryPortInformationProcess",
    "NtGetCurrentProcessorNumber",
    "NtWaitForMultipleObjects32"
};

//////////////////////////////////////////////////////////////////////////
// Windows Vista SP0 _KiServiceTable
//////////////////////////////////////////////////////////////////////////
static const char* KiServiceTable_VistaSp0_x86[] = {
    "NtAcceptConnectPort",
    "NtAccessCheck",
    "NtAccessCheckAndAuditAlarm",
    "NtAccessCheckByType",
    "NtAccessCheckByTypeAndAuditAlarm",
    "NtAccessCheckByTypeResultList",
    "NtAccessCheckByTypeResultListAndAuditAlarm",
    "NtAccessCheckByTypeResultListAndAuditAlarmByHandle",
    "NtAddAtom",
    "NtAddBootEntry",
    "NtAddDriverEntry",
    "NtAdjustGroupsToken",
    "NtAdjustPrivilegesToken",
    "NtAlertResumeThread",
    "NtAlertThread",
    "NtAllocateLocallyUniqueId",
    "NtAllocateUserPhysicalPages",
    "NtAllocateUuids",
    "NtAllocateVirtualMemory",
    "NtAlpcAcceptConnectPort",
    "NtAlpcCancelMessage",
    "NtAlpcConnectPort",
    "NtAlpcCreatePort",
    "NtAlpcCreatePortSection",
    "NtAlpcCreateResourceReserve",
    "NtAlpcCreateSectionView",
    "NtAlpcCreateSecurityContext",
    "NtAlpcDeletePortSection",
    "NtAlpcDeleteResourceReserve",
    "NtAlpcDeleteSectionView",
    "NtAlpcDeleteSecurityContext",
    "NtAlpcDisconnectPort",
    "NtAlpcImpersonateClientOfPort",
    "NtAlpcOpenSenderProcess",
    "NtAlpcOpenSenderThread",
    "NtAlpcQueryInformation",
    "NtAlpcQueryInformationMessage",
    "NtAlpcRevokeSecurityContext",
    "NtAlpcSendWaitReceivePort",
    "NtAlpcSetInformation",
    "NtApphelpCacheControl",
    "NtAreMappedFilesTheSame",
    "NtAssignProcessToJobObject",
    "NtCallbackReturn",
    "NtClearAllSavepointsTransaction",
    "NtCancelIoFile",
    "NtCancelTimer",
    "NtClearEvent",
    "NtClose",
    "NtCloseObjectAuditAlarm",
    "NtCompactKeys",
    "NtCompareTokens",
    "NtCompleteConnectPort",
    "NtCompressKey",
    "NtConnectPort",
    "NtContinue",
    "NtCreateDebugObject",
    "NtCreateDirectoryObject",
    "NtCreateEvent",
    "NtCreateEventPair",
    "NtCreateFile",
    "NtCreateIoCompletion",
    "NtCreateJobObject",
    "NtCreateJobSet",
    "NtCreateKey",
    "NtCreateKeyTransacted",
    "NtCreateMailslotFile",
    "NtCreateMutant",
    "NtCreateNamedPipeFile",
    "NtCreatePrivateNamespace",
    "NtCreatePagingFile",
    "NtCreatePort",
    "NtCreateProcess",
    "NtCreateProcessEx",
    "NtCreateProfile",
    "NtCreateSection",
    "NtCreateSemaphore",
    "NtCreateSymbolicLinkObject",
    "NtCreateThread",
    "NtCreateTimer",
    "NtCreateToken",
    "NtCreateTransaction",
    "NtOpenTransaction",
    "NtQueryInformationTransaction",
    "NtQueryInformationTransactionManager",
    "NtPrePrepareEnlistment",
    "NtPrepareEnlistment",
    "NtCommitEnlistment",
    "NtReadOnlyEnlistment",
    "NtRollbackComplete",
    "NtRollbackEnlistment",
    "NtCommitTransaction",
    "NtRollbackTransaction",
    "NtPrePrepareComplete",
    "NtPrepareComplete",
    "NtCommitComplete",
    "NtSinglePhaseReject",
    "NtSetInformationTransaction",
    "NtSetInformationTransactionManager",
    "NtSetInformationResourceManager",
    "NtCreateTransactionManager",
    "NtOpenTransactionManager",
    "NtRollforwardTransactionManager",
    "NtRecoverEnlistment",
    "NtRecoverResourceManager",
    "NtRecoverTransactionManager",
    "NtCreateResourceManager",
    "NtOpenResourceManager",
    "NtGetNotificationResourceManager",
    "NtQueryInformationResourceManager",
    "NtCreateEnlistment",
    "NtOpenEnlistment",
    "NtSetInformationEnlistment",
    "NtQueryInformationEnlistment",
    "NtStartTm",
    "NtCreateWaitablePort",
    "NtDebugActiveProcess",
    "NtDebugContinue",
    "NtDelayExecution",
    "NtDeleteAtom",
    "NtDeleteBootEntry",
    "NtDeleteDriverEntry",
    "NtDeleteFile",
    "NtDeleteKey",
    "NtDeletePrivateNamespace",
    "NtDeleteObjectAuditAlarm",
    "NtDeleteValueKey",
    "NtDeviceIoControlFile",
    "NtDisplayString",
    "NtDuplicateObject",
    "NtDuplicateToken",
    "NtEnumerateBootEntries",
    "NtEnumerateDriverEntries",
    "NtEnumerateKey",
    "NtEnumerateSystemEnvironmentValuesEx",
    "NtEnumerateTransactionObject",
    "NtEnumerateValueKey",
    "NtExtendSection",
    "NtFilterToken",
    "NtFindAtom",
    "NtFlushBuffersFile",
    "NtFlushInstructionCache",
    "NtFlushKey",
    "NtFlushProcessWriteBuffers",
    "NtFlushVirtualMemory",
    "NtFlushWriteBuffer",
    "NtFreeUserPhysicalPages",
    "NtFreeVirtualMemory",
    "NtFreezeRegistry",
    "NtFreezeTransactions",
    "NtFsControlFile",
    "NtGetContextThread",
    "NtGetDevicePowerState",
    "NtGetNlsSectionPtr",
    "NtGetPlugPlayEvent",
    "NtGetWriteWatch",
    "NtImpersonateAnonymousToken",
    "NtImpersonateClientOfPort",
    "NtImpersonateThread",
    "NtInitializeNlsFiles",
    "NtInitializeRegistry",
    "NtInitiatePowerAction",
    "NtIsProcessInJob",
    "NtIsSystemResumeAutomatic",
    "NtListenPort",
    "NtLoadDriver",
    "NtLoadKey",
    "NtLoadKey2",
    "NtLoadKeyEx",
    "NtLockFile",
    "NtLockProductActivationKeys",
    "NtLockRegistryKey",
    "NtLockVirtualMemory",
    "NtMakePermanentObject",
    "NtMakeTemporaryObject",
    "NtMapUserPhysicalPages",
    "NtMapUserPhysicalPagesScatter",
    "NtMapViewOfSection",
    "NtModifyBootEntry",
    "NtModifyDriverEntry",
    "NtNotifyChangeDirectoryFile",
    "NtNotifyChangeKey",
    "NtNotifyChangeMultipleKeys",
    "NtOpenDirectoryObject",
    "NtOpenEvent",
    "NtOpenEventPair",
    "NtOpenFile",
    "NtOpenIoCompletion",
    "NtOpenJobObject",
    "NtOpenKey",
    "NtOpenKeyTransacted",
    "NtOpenMutant",
    "NtOpenPrivateNamespace",
    "NtOpenObjectAuditAlarm",
    "NtOpenProcess",
    "NtOpenProcessToken",
    "NtOpenProcessTokenEx",
    "NtOpenSection",
    "NtOpenSemaphore",
    "NtOpenSession",
    "NtOpenSymbolicLinkObject",
    "NtOpenThread",
    "NtOpenThreadToken",
    "NtOpenThreadTokenEx",
    "NtOpenTimer",
    "NtPlugPlayControl",
    "NtPowerInformation",
    "NtPrivilegeCheck",
    "NtPrivilegeObjectAuditAlarm",
    "NtPrivilegedServiceAuditAlarm",
    "NtProtectVirtualMemory",
    "NtPulseEvent",
    "NtQueryAttributesFile",
    "NtQueryBootEntryOrder",
    "NtQueryBootOptions",
    "NtQueryDebugFilterState",
    "NtQueryDefaultLocale",
    "NtQueryDefaultUILanguage",
    "NtQueryDirectoryFile",
    "NtQueryDirectoryObject",
    "NtQueryDriverEntryOrder",
    "NtQueryEaFile",
    "NtQueryEvent",
    "NtQueryFullAttributesFile",
    "NtQueryInformationAtom",
    "NtQueryInformationFile",
    "NtQueryInformationJobObject",
    "NtQueryInformationPort",
    "NtQueryInformationProcess",
    "NtQueryInformationThread",
    "NtQueryInformationToken",
    "NtQueryInstallUILanguage",
    "NtQueryIntervalProfile",
    "NtQueryIoCompletion",
    "NtQueryKey",
    "NtQueryMultipleValueKey",
    "NtQueryMutant",
    "NtQueryObject",
    "NtQueryOpenSubKeys",
    "NtQueryOpenSubKeysEx",
    "NtQueryPerformanceCounter",
    "NtQueryQuotaInformationFile",
    "NtQuerySection",
    "NtQuerySecurityObject",
    "NtQuerySemaphore",
    "NtQuerySymbolicLinkObject",
    "NtQuerySystemEnvironmentValue",
    "NtQuerySystemEnvironmentValueEx",
    "NtQuerySystemInformation",
    "NtQuerySystemTime",
    "NtQueryTimer",
    "NtQueryTimerResolution",
    "NtQueryValueKey",
    "NtQueryVirtualMemory",
    "NtQueryVolumeInformationFile",
    "NtQueueApcThread",
    "NtRaiseException",
    "NtRaiseHardError",
    "NtReadFile",
    "NtReadFileScatter",
    "NtReadRequestData",
    "NtReadVirtualMemory",
    "NtRegisterThreadTerminatePort",
    "NtReleaseMutant",
    "NtReleaseSemaphore",
    "NtRemoveIoCompletion",
    "NtRemoveProcessDebug",
    "NtRenameKey",
    "NtReplaceKey",
    "NtReplyPort",
    "NtReplyWaitReceivePort",
    "NtReplyWaitReceivePortEx",
    "NtReplyWaitReplyPort",
    "NtClearAllSavepointsTransaction",
    "NtRequestPort",
    "NtRequestWaitReplyPort",
    "NtRequestWakeupLatency",
    "NtResetEvent",
    "NtResetWriteWatch",
    "NtRestoreKey",
    "NtResumeProcess",
    "NtResumeThread",
    "NtSaveKey",
    "NtSaveKeyEx",
    "NtSaveMergedKeys",
    "NtSavepointComplete",
    "NtClearAllSavepointsTransaction",
    "NtSavepointComplete",
    "TmSavepointTransaction",
    "NtSavepointComplete",
    "NtSecureConnectPort",
    "NtSetBootEntryOrder",
    "NtSetBootOptions",
    "NtSetContextThread",
    "NtSetDebugFilterState",
    "NtSetDefaultHardErrorPort",
    "NtSetDefaultLocale",
    "NtSetDefaultUILanguage",
    "NtSetDriverEntryOrder",
    "NtSetEaFile",
    "NtSetEvent",
    "NtSetEventBoostPriority",
    "NtSetHighEventPair",
    "NtSetHighWaitLowEventPair",
    "NtSetInformationDebugObject",
    "NtSetInformationFile",
    "NtSetInformationJobObject",
    "NtSetInformationKey",
    "NtSetInformationObject",
    "NtSetInformationProcess",
    "NtSetInformationThread",
    "NtSetInformationToken",
    "NtSetIntervalProfile",
    "NtSetIoCompletion",
    "NtSetLdtEntries",
    "NtSetLowEventPair",
    "NtSetLowWaitHighEventPair",
    "NtSetQuotaInformationFile",
    "NtSetSecurityObject",
    "NtSetSystemEnvironmentValue",
    "NtSetSystemEnvironmentValueEx",
    "NtSetSystemInformation",
    "NtSetSystemPowerState",
    "NtSetSystemTime",
    "NtSetThreadExecutionState",
    "NtSetTimer",
    "NtSetTimerResolution",
    "NtSetUuidSeed",
    "NtSetValueKey",
    "NtSetVolumeInformationFile",
    "NtShutdownSystem",
    "NtSignalAndWaitForSingleObject",
    "NtStartProfile",
    "NtStopProfile",
    "NtSuspendProcess",
    "NtSuspendThread",
    "NtSystemDebugControl",
    "NtTerminateJobObject",
    "NtTerminateProcess",
    "NtTerminateThread",
    "NtTestAlert",
    "NtThawRegistry",
    "NtThawTransactions",
    "NtTraceEvent",
    "NtTraceControl",
    "NtTranslateFilePath",
    "NtUnloadDriver",
    "NtUnloadKey",
    "NtUnloadKey2",
    "NtUnloadKeyEx",
    "NtUnlockFile",
    "NtUnlockVirtualMemory",
    "NtUnmapViewOfSection",
    "NtVdmControl",
    "NtWaitForDebugEvent",
    "NtWaitForMultipleObjects",
    "NtWaitForSingleObject",
    "NtWaitHighEventPair",
    "NtWaitLowEventPair",
    "NtWriteFile",
    "NtWriteFileGather",
    "NtWriteRequestData",
    "NtWriteVirtualMemory",
    "NtYieldExecution",
    "NtCreateKeyedEvent",
    "NtOpenKeyedEvent",
    "NtReleaseKeyedEvent",
    "NtWaitForKeyedEvent",
    "NtQueryPortInformationProcess",
    "NtGetCurrentProcessorNumber",
    "NtWaitForMultipleObjects32",
    "NtGetNextProcess",
    "NtGetNextThread",
    "NtCancelIoFileEx",
    "NtCancelSynchronousIoFile",
    "NtRemoveIoCompletionEx",
    "NtRegisterProtocolAddressInformation",
    "NtPullTransaction",
    "NtMarshallTransaction",
    "NtPropagationComplete",
    "CcTestControl",
    "NtCreateWorkerFactory",
    "NtReleaseWorkerFactoryWorker",
    "NtWaitForWorkViaWorkerFactory",
    "NtSetInformationWorkerFactory",
    "NtQueryInformationWorkerFactory",
    "NtWorkerFactoryWorkerReady",
    "NtShutdownWorkerFactory",
    "NtCreateThreadEx",
    "NtCreateUserProcess",
    "NtQueryLicenseValue",
    "NtMapCMFModule",
    "TmSavepointTransaction",
    "NtIsUILanguageComitted",
    "NtFlushInstallUILanguage",
    "NtGetMUIRegistryInfo",
    "NtAcquireCMFViewOwnership",
    "NtReleaseCMFViewOwnership"
};

//////////////////////////////////////////////////////////////////////////
// Windows Vista SP1 _KiServiceTable
//////////////////////////////////////////////////////////////////////////
static const char* KiServiceTable_VistaSp1_x86[] = {
    "NtAcceptConnectPort",
    "NtAccessCheck",
    "NtAccessCheckAndAuditAlarm",
    "NtAccessCheckByType",
    "NtAccessCheckByTypeAndAuditAlarm",
    "NtAccessCheckByTypeResultList",
    "NtAccessCheckByTypeResultListAndAuditAlarm",
    "NtAccessCheckByTypeResultListAndAuditAlarmByHandle",
    "NtAddAtom",
    "NtAddBootEntry",
    "NtAddDriverEntry",
    "NtAdjustGroupsToken",
    "NtAdjustPrivilegesToken",
    "NtAlertResumeThread",
    "NtAlertThread",
    "NtAllocateLocallyUniqueId",
    "NtAllocateUserPhysicalPages",
    "NtAllocateUuids",
    "NtAllocateVirtualMemory",
    "NtAlpcAcceptConnectPort",
    "NtAlpcCancelMessage",
    "NtAlpcConnectPort",
    "NtAlpcCreatePort",
    "NtAlpcCreatePortSection",
    "NtAlpcCreateResourceReserve",
    "NtAlpcCreateSectionView",
    "NtAlpcCreateSecurityContext",
    "NtAlpcDeletePortSection",
    "NtAlpcDeleteResourceReserve",
    "NtAlpcDeleteSectionView",
    "NtAlpcDeleteSecurityContext",
    "NtAlpcDisconnectPort",
    "NtAlpcImpersonateClientOfPort",
    "NtAlpcOpenSenderProcess",
    "NtAlpcOpenSenderThread",
    "NtAlpcQueryInformation",
    "NtAlpcQueryInformationMessage",
    "NtAlpcRevokeSecurityContext",
    "NtAlpcSendWaitReceivePort",
    "NtAlpcSetInformation",
    "NtApphelpCacheControl",
    "NtAreMappedFilesTheSame",
    "NtAssignProcessToJobObject",
    "NtCallbackReturn",
    "xHalLoadMicrocode",
    "NtCancelIoFile",
    "NtCancelTimer",
    "NtClearEvent",
    "NtClose",
    "NtCloseObjectAuditAlarm",
    "NtCompactKeys",
    "NtCompareTokens",
    "NtCompleteConnectPort",
    "NtCompressKey",
    "NtConnectPort",
    "NtContinue",
    "NtCreateDebugObject",
    "NtCreateDirectoryObject",
    "NtCreateEvent",
    "NtCreateEventPair",
    "NtCreateFile",
    "NtCreateIoCompletion",
    "NtCreateJobObject",
    "NtCreateJobSet",
    "NtCreateKey",
    "NtCreateKeyTransacted",
    "NtCreateMailslotFile",
    "NtCreateMutant",
    "NtCreateNamedPipeFile",
    "NtCreatePrivateNamespace",
    "NtCreatePagingFile",
    "NtCreatePort",
    "NtCreateProcess",
    "NtCreateProcessEx",
    "NtCreateProfile",
    "NtCreateSection",
    "NtCreateSemaphore",
    "NtCreateSymbolicLinkObject",
    "NtCreateThread",
    "NtCreateTimer",
    "NtCreateToken",
    "NtCreateTransaction",
    "NtOpenTransaction",
    "NtQueryInformationTransaction",
    "NtQueryInformationTransactionManager",
    "NtPrePrepareEnlistment",
    "NtPrepareEnlistment",
    "NtCommitEnlistment",
    "NtReadOnlyEnlistment",
    "NtRollbackComplete",
    "NtRollbackEnlistment",
    "NtCommitTransaction",
    "NtRollbackTransaction",
    "NtPrePrepareComplete",
    "NtPrepareComplete",
    "NtCommitComplete",
    "NtSinglePhaseReject",
    "NtSetInformationTransaction",
    "NtSetInformationTransactionManager",
    "NtSetInformationResourceManager",
    "NtCreateTransactionManager",
    "NtOpenTransactionManager",
    "NtRenameTransactionManager",
    "NtRollforwardTransactionManager",
    "NtRecoverEnlistment",
    "NtRecoverResourceManager",
    "NtRecoverTransactionManager",
    "NtCreateResourceManager",
    "NtOpenResourceManager",
    "NtGetNotificationResourceManager",
    "NtQueryInformationResourceManager",
    "NtCreateEnlistment",
    "NtOpenEnlistment",
    "NtSetInformationEnlistment",
    "NtQueryInformationEnlistment",
    "NtCreateWaitablePort",
    "NtDebugActiveProcess",
    "NtDebugContinue",
    "NtDelayExecution",
    "NtDeleteAtom",
    "NtDeleteBootEntry",
    "NtDeleteDriverEntry",
    "NtDeleteFile",
    "NtDeleteKey",
    "NtDeletePrivateNamespace",
    "NtDeleteObjectAuditAlarm",
    "NtDeleteValueKey",
    "NtDeviceIoControlFile",
    "NtDisplayString",
    "NtDuplicateObject",
    "NtDuplicateToken",
    "NtEnumerateBootEntries",
    "NtEnumerateDriverEntries",
    "NtEnumerateKey",
    "NtEnumerateSystemEnvironmentValuesEx",
    "NtEnumerateTransactionObject",
    "NtEnumerateValueKey",
    "NtExtendSection",
    "NtFilterToken",
    "NtFindAtom",
    "NtFlushBuffersFile",
    "NtFlushInstructionCache",
    "NtFlushKey",
    "NtFlushProcessWriteBuffers",
    "NtFlushVirtualMemory",
    "NtFlushWriteBuffer",
    "NtFreeUserPhysicalPages",
    "NtFreeVirtualMemory",
    "NtFreezeRegistry",
    "NtFreezeTransactions",
    "NtFsControlFile",
    "NtGetContextThread",
    "NtGetDevicePowerState",
    "NtGetNlsSectionPtr",
    "NtGetPlugPlayEvent",
    "NtGetWriteWatch",
    "NtImpersonateAnonymousToken",
    "NtImpersonateClientOfPort",
    "NtImpersonateThread",
    "NtInitializeNlsFiles",
    "NtInitializeRegistry",
    "NtInitiatePowerAction",
    "NtIsProcessInJob",
    "NtIsSystemResumeAutomatic",
    "NtListenPort",
    "NtLoadDriver",
    "NtLoadKey",
    "NtLoadKey2",
    "NtLoadKeyEx",
    "NtLockFile",
    "NtLockProductActivationKeys",
    "NtLockRegistryKey",
    "NtLockVirtualMemory",
    "NtMakePermanentObject",
    "NtMakeTemporaryObject",
    "NtMapUserPhysicalPages",
    "NtMapUserPhysicalPagesScatter",
    "NtMapViewOfSection",
    "NtModifyBootEntry",
    "NtModifyDriverEntry",
    "NtNotifyChangeDirectoryFile",
    "NtNotifyChangeKey",
    "NtNotifyChangeMultipleKeys",
    "NtOpenDirectoryObject",
    "NtOpenEvent",
    "NtOpenEventPair",
    "NtOpenFile",
    "NtOpenIoCompletion",
    "NtOpenJobObject",
    "NtOpenKey",
    "NtOpenKeyTransacted",
    "NtOpenMutant",
    "NtOpenPrivateNamespace",
    "NtOpenObjectAuditAlarm",
    "NtOpenProcess",
    "NtOpenProcessToken",
    "NtOpenProcessTokenEx",
    "NtOpenSection",
    "NtOpenSemaphore",
    "NtOpenSession",
    "NtOpenSymbolicLinkObject",
    "NtOpenThread",
    "NtOpenThreadToken",
    "NtOpenThreadTokenEx",
    "NtOpenTimer",
    "NtPlugPlayControl",
    "NtPowerInformation",
    "NtPrivilegeCheck",
    "NtPrivilegeObjectAuditAlarm",
    "NtPrivilegedServiceAuditAlarm",
    "NtProtectVirtualMemory",
    "NtPulseEvent",
    "NtQueryAttributesFile",
    "NtQueryBootEntryOrder",
    "NtQueryBootOptions",
    "NtQueryDebugFilterState",
    "NtQueryDefaultLocale",
    "NtQueryDefaultUILanguage",
    "NtQueryDirectoryFile",
    "NtQueryDirectoryObject",
    "NtQueryDriverEntryOrder",
    "NtQueryEaFile",
    "NtQueryEvent",
    "NtQueryFullAttributesFile",
    "NtQueryInformationAtom",
    "NtQueryInformationFile",
    "NtQueryInformationJobObject",
    "NtQueryInformationPort",
    "NtQueryInformationProcess",
    "NtQueryInformationThread",
    "NtQueryInformationToken",
    "NtQueryInstallUILanguage",
    "NtQueryIntervalProfile",
    "NtQueryIoCompletion",
    "NtQueryKey",
    "NtQueryMultipleValueKey",
    "NtQueryMutant",
    "NtQueryObject",
    "NtQueryOpenSubKeys",
    "NtQueryOpenSubKeysEx",
    "NtQueryPerformanceCounter",
    "NtQueryQuotaInformationFile",
    "NtQuerySection",
    "NtQuerySecurityObject",
    "NtQuerySemaphore",
    "NtQuerySymbolicLinkObject",
    "NtQuerySystemEnvironmentValue",
    "NtQuerySystemEnvironmentValueEx",
    "NtQuerySystemInformation",
    "NtQuerySystemTime",
    "NtQueryTimer",
    "NtQueryTimerResolution",
    "NtQueryValueKey",
    "NtQueryVirtualMemory",
    "NtQueryVolumeInformationFile",
    "NtQueueApcThread",
    "NtRaiseException",
    "NtRaiseHardError",
    "NtReadFile",
    "NtReadFileScatter",
    "NtReadRequestData",
    "NtReadVirtualMemory",
    "NtRegisterThreadTerminatePort",
    "NtReleaseMutant",
    "NtReleaseSemaphore",
    "NtRemoveIoCompletion",
    "NtRemoveProcessDebug",
    "NtRenameKey",
    "NtReplaceKey",
    "NtReplacePartitionUnit",
    "NtReplyPort",
    "NtReplyWaitReceivePort",
    "NtReplyWaitReceivePortEx",
    "NtReplyWaitReplyPort",
    "xHalLoadMicrocode",
    "NtRequestPort",
    "NtRequestWaitReplyPort",
    "NtRequestWakeupLatency",
    "NtResetEvent",
    "NtResetWriteWatch",
    "NtRestoreKey",
    "NtResumeProcess",
    "NtResumeThread",
    "NtSaveKey",
    "NtSaveKeyEx",
    "NtSaveMergedKeys",
    "NtSecureConnectPort",
    "NtSetBootEntryOrder",
    "NtSetBootOptions",
    "NtSetContextThread",
    "NtSetDebugFilterState",
    "NtSetDefaultHardErrorPort",
    "NtSetDefaultLocale",
    "NtSetDefaultUILanguage",
    "NtSetDriverEntryOrder",
    "NtSetEaFile",
    "NtSetEvent",
    "NtSetEventBoostPriority",
    "NtSetHighEventPair",
    "NtSetHighWaitLowEventPair",
    "NtSetInformationDebugObject",
    "NtSetInformationFile",
    "NtSetInformationJobObject",
    "NtSetInformationKey",
    "NtSetInformationObject",
    "NtSetInformationProcess",
    "NtSetInformationThread",
    "NtSetInformationToken",
    "NtSetIntervalProfile",
    "NtSetIoCompletion",
    "NtSetLdtEntries",
    "NtSetLowEventPair",
    "NtSetLowWaitHighEventPair",
    "NtSetQuotaInformationFile",
    "NtSetSecurityObject",
    "NtSetSystemEnvironmentValue",
    "NtSetSystemEnvironmentValueEx",
    "NtSetSystemInformation",
    "NtSetSystemPowerState",
    "NtSetSystemTime",
    "NtSetThreadExecutionState",
    "NtSetTimer",
    "NtSetTimerResolution",
    "NtSetUuidSeed",
    "NtSetValueKey",
    "NtSetVolumeInformationFile",
    "NtShutdownSystem",
    "NtSignalAndWaitForSingleObject",
    "NtStartProfile",
    "NtStopProfile",
    "NtSuspendProcess",
    "NtSuspendThread",
    "NtSystemDebugControl",
    "NtTerminateJobObject",
    "NtTerminateProcess",
    "NtTerminateThread",
    "NtTestAlert",
    "NtThawRegistry",
    "NtThawTransactions",
    "NtTraceEvent",
    "NtTraceControl",
    "NtTranslateFilePath",
    "NtUnloadDriver",
    "NtUnloadKey",
    "NtUnloadKey2",
    "NtUnloadKeyEx",
    "NtUnlockFile",
    "NtUnlockVirtualMemory",
    "NtUnmapViewOfSection",
    "NtVdmControl",
    "NtWaitForDebugEvent",
    "NtWaitForMultipleObjects",
    "NtWaitForSingleObject",
    "NtWaitHighEventPair",
    "NtWaitLowEventPair",
    "NtWriteFile",
    "NtWriteFileGather",
    "NtWriteRequestData",
    "NtWriteVirtualMemory",
    "NtYieldExecution",
    "NtCreateKeyedEvent",
    "NtOpenKeyedEvent",
    "NtReleaseKeyedEvent",
    "NtWaitForKeyedEvent",
    "NtQueryPortInformationProcess",
    "NtGetCurrentProcessorNumber",
    "NtWaitForMultipleObjects32",
    "NtGetNextProcess",
    "NtGetNextThread",
    "NtCancelIoFileEx",
    "NtCancelSynchronousIoFile",
    "NtRemoveIoCompletionEx",
    "NtRegisterProtocolAddressInformation",
    "NtPropagationComplete",
    "NtPropagationFailed",
    "NtCreateWorkerFactory",
    "NtReleaseWorkerFactoryWorker",
    "NtWaitForWorkViaWorkerFactory",
    "NtSetInformationWorkerFactory",
    "NtQueryInformationWorkerFactory",
    "NtWorkerFactoryWorkerReady",
    "NtShutdownWorkerFactory",
    "NtCreateThreadEx",
    "NtCreateUserProcess",
    "NtQueryLicenseValue",
    "NtMapCMFModule",
    "NtIsUILanguageComitted",
    "NtFlushInstallUILanguage",
    "NtGetMUIRegistryInfo",
    "NtAcquireCMFViewOwnership",
    "NtReleaseCMFViewOwnership"
};

//////////////////////////////////////////////////////////////////////////
// Windows Vista SP2 _KiServiceTable
//////////////////////////////////////////////////////////////////////////
static const char* KiServiceTable_VistaSp2_x86[] = {
    "NtAcceptConnectPort",
    "NtAccessCheck",
    "NtAccessCheckAndAuditAlarm",
    "NtAccessCheckByType",
    "NtAccessCheckByTypeAndAuditAlarm",
    "NtAccessCheckByTypeResultList",
    "NtAccessCheckByTypeResultListAndAuditAlarm",
    "NtAccessCheckByTypeResultListAndAuditAlarmByHandle",
    "NtAddAtom",
    "NtAddBootEntry",
    "NtAddDriverEntry",
    "NtAdjustGroupsToken",
    "NtAdjustPrivilegesToken",
    "NtAlertResumeThread",
    "NtAlertThread",
    "NtAllocateLocallyUniqueId",
    "NtAllocateUserPhysicalPages",
    "NtAllocateUuids",
    "NtAllocateVirtualMemory",
    "NtAlpcAcceptConnectPort",
    "NtAlpcCancelMessage",
    "NtAlpcConnectPort",
    "NtAlpcCreatePort",
    "NtAlpcCreatePortSection",
    "NtAlpcCreateResourceReserve",
    "NtAlpcCreateSectionView",
    "NtAlpcCreateSecurityContext",
    "NtAlpcDeletePortSection",
    "NtAlpcDeleteResourceReserve",
    "NtAlpcDeleteSectionView",
    "NtAlpcDeleteSecurityContext",
    "NtAlpcDisconnectPort",
    "NtAlpcImpersonateClientOfPort",
    "NtAlpcOpenSenderProcess",
    "NtAlpcOpenSenderThread",
    "NtAlpcQueryInformation",
    "NtAlpcQueryInformationMessage",
    "NtAlpcRevokeSecurityContext",
    "NtAlpcSendWaitReceivePort",
    "NtAlpcSetInformation",
    "NtApphelpCacheControl",
    "NtAreMappedFilesTheSame",
    "NtAssignProcessToJobObject",
    "NtCallbackReturn",
    "xHalLoadMicrocode",
    "NtCancelIoFile",
    "NtCancelTimer",
    "NtClearEvent",
    "NtClose",
    "NtCloseObjectAuditAlarm",
    "NtCompactKeys",
    "NtCompareTokens",
    "NtCompleteConnectPort",
    "NtCompressKey",
    "NtConnectPort",
    "NtContinue",
    "NtCreateDebugObject",
    "NtCreateDirectoryObject",
    "NtCreateEvent",
    "NtCreateEventPair",
    "NtCreateFile",
    "NtCreateIoCompletion",
    "NtCreateJobObject",
    "NtCreateJobSet",
    "NtCreateKey",
    "NtCreateKeyTransacted",
    "NtCreateMailslotFile",
    "NtCreateMutant",
    "NtCreateNamedPipeFile",
    "NtCreatePrivateNamespace",
    "NtCreatePagingFile",
    "NtCreatePort",
    "NtCreateProcess",
    "NtCreateProcessEx",
    "NtCreateProfile",
    "NtCreateSection",
    "NtCreateSemaphore",
    "NtCreateSymbolicLinkObject",
    "NtCreateThread",
    "NtCreateTimer",
    "NtCreateToken",
    "NtCreateTransaction",
    "NtOpenTransaction",
    "NtQueryInformationTransaction",
    "NtQueryInformationTransactionManager",
    "NtPrePrepareEnlistment",
    "NtPrepareEnlistment",
    "NtCommitEnlistment",
    "NtReadOnlyEnlistment",
    "NtRollbackComplete",
    "NtRollbackEnlistment",
    "NtCommitTransaction",
    "NtRollbackTransaction",
    "NtPrePrepareComplete",
    "NtPrepareComplete",
    "NtCommitComplete",
    "NtSinglePhaseReject",
    "NtSetInformationTransaction",
    "NtSetInformationTransactionManager",
    "NtSetInformationResourceManager",
    "NtCreateTransactionManager",
    "NtOpenTransactionManager",
    "NtRenameTransactionManager",
    "NtRollforwardTransactionManager",
    "NtRecoverEnlistment",
    "NtRecoverResourceManager",
    "NtRecoverTransactionManager",
    "NtCreateResourceManager",
    "NtOpenResourceManager",
    "NtGetNotificationResourceManager",
    "NtQueryInformationResourceManager",
    "NtCreateEnlistment",
    "NtOpenEnlistment",
    "NtSetInformationEnlistment",
    "NtQueryInformationEnlistment",
    "NtCreateWaitablePort",
    "NtDebugActiveProcess",
    "NtDebugContinue",
    "NtDelayExecution",
    "NtDeleteAtom",
    "NtDeleteBootEntry",
    "NtDeleteDriverEntry",
    "NtDeleteFile",
    "NtDeleteKey",
    "NtDeletePrivateNamespace",
    "NtDeleteObjectAuditAlarm",
    "NtDeleteValueKey",
    "NtDeviceIoControlFile",
    "NtDisplayString",
    "NtDuplicateObject",
    "NtDuplicateToken",
    "NtEnumerateBootEntries",
    "NtEnumerateDriverEntries",
    "NtEnumerateKey",
    "NtEnumerateSystemEnvironmentValuesEx",
    "NtEnumerateTransactionObject",
    "NtEnumerateValueKey",
    "NtExtendSection",
    "NtFilterToken",
    "NtFindAtom",
    "NtFlushBuffersFile",
    "NtFlushInstructionCache",
    "NtFlushKey",
    "NtFlushProcessWriteBuffers",
    "NtFlushVirtualMemory",
    "NtFlushWriteBuffer",
    "NtFreeUserPhysicalPages",
    "NtFreeVirtualMemory",
    "NtFreezeRegistry",
    "NtFreezeTransactions",
    "NtFsControlFile",
    "NtGetContextThread",
    "NtGetDevicePowerState",
    "NtGetNlsSectionPtr",
    "NtGetPlugPlayEvent",
    "NtGetWriteWatch",
    "NtImpersonateAnonymousToken",
    "NtImpersonateClientOfPort",
    "NtImpersonateThread",
    "NtInitializeNlsFiles",
    "NtInitializeRegistry",
    "NtInitiatePowerAction",
    "NtIsProcessInJob",
    "NtIsSystemResumeAutomatic",
    "NtListenPort",
    "NtLoadDriver",
    "NtLoadKey",
    "NtLoadKey2",
    "NtLoadKeyEx",
    "NtLockFile",
    "NtLockProductActivationKeys",
    "NtLockRegistryKey",
    "NtLockVirtualMemory",
    "NtMakePermanentObject",
    "NtMakeTemporaryObject",
    "NtMapUserPhysicalPages",
    "NtMapUserPhysicalPagesScatter",
    "NtMapViewOfSection",
    "NtModifyBootEntry",
    "NtModifyDriverEntry",
    "NtNotifyChangeDirectoryFile",
    "NtNotifyChangeKey",
    "NtNotifyChangeMultipleKeys",
    "NtOpenDirectoryObject",
    "NtOpenEvent",
    "NtOpenEventPair",
    "NtOpenFile",
    "NtOpenIoCompletion",
    "NtOpenJobObject",
    "NtOpenKey",
    "NtOpenKeyTransacted",
    "NtOpenMutant",
    "NtOpenPrivateNamespace",
    "NtOpenObjectAuditAlarm",
    "NtOpenProcess",
    "NtOpenProcessToken",
    "NtOpenProcessTokenEx",
    "NtOpenSection",
    "NtOpenSemaphore",
    "NtOpenSession",
    "NtOpenSymbolicLinkObject",
    "NtOpenThread",
    "NtOpenThreadToken",
    "NtOpenThreadTokenEx",
    "NtOpenTimer",
    "NtPlugPlayControl",
    "NtPowerInformation",
    "NtPrivilegeCheck",
    "NtPrivilegeObjectAuditAlarm",
    "NtPrivilegedServiceAuditAlarm",
    "NtProtectVirtualMemory",
    "NtPulseEvent",
    "NtQueryAttributesFile",
    "NtQueryBootEntryOrder",
    "NtQueryBootOptions",
    "NtQueryDebugFilterState",
    "NtQueryDefaultLocale",
    "NtQueryDefaultUILanguage",
    "NtQueryDirectoryFile",
    "NtQueryDirectoryObject",
    "NtQueryDriverEntryOrder",
    "NtQueryEaFile",
    "NtQueryEvent",
    "NtQueryFullAttributesFile",
    "NtQueryInformationAtom",
    "NtQueryInformationFile",
    "NtQueryInformationJobObject",
    "NtQueryInformationPort",
    "NtQueryInformationProcess",
    "NtQueryInformationThread",
    "NtQueryInformationToken",
    "NtQueryInstallUILanguage",
    "NtQueryIntervalProfile",
    "NtQueryIoCompletion",
    "NtQueryKey",
    "NtQueryMultipleValueKey",
    "NtQueryMutant",
    "NtQueryObject",
    "NtQueryOpenSubKeys",
    "NtQueryOpenSubKeysEx",
    "NtQueryPerformanceCounter",
    "NtQueryQuotaInformationFile",
    "NtQuerySection",
    "NtQuerySecurityObject",
    "NtQuerySemaphore",
    "NtQuerySymbolicLinkObject",
    "NtQuerySystemEnvironmentValue",
    "NtQuerySystemEnvironmentValueEx",
    "NtQuerySystemInformation",
    "NtQuerySystemTime",
    "NtQueryTimer",
    "NtQueryTimerResolution",
    "NtQueryValueKey",
    "NtQueryVirtualMemory",
    "NtQueryVolumeInformationFile",
    "NtQueueApcThread",
    "NtRaiseException",
    "NtRaiseHardError",
    "NtReadFile",
    "NtReadFileScatter",
    "NtReadRequestData",
    "NtReadVirtualMemory",
    "NtRegisterThreadTerminatePort",
    "NtReleaseMutant",
    "NtReleaseSemaphore",
    "NtRemoveIoCompletion",
    "NtRemoveProcessDebug",
    "NtRenameKey",
    "NtReplaceKey",
    "NtReplacePartitionUnit",
    "NtReplyPort",
    "NtReplyWaitReceivePort",
    "NtReplyWaitReceivePortEx",
    "NtReplyWaitReplyPort",
    "xHalLoadMicrocode",
    "NtRequestPort",
    "NtRequestWaitReplyPort",
    "NtRequestWakeupLatency",
    "NtResetEvent",
    "NtResetWriteWatch",
    "NtRestoreKey",
    "NtResumeProcess",
    "NtResumeThread",
    "NtSaveKey",
    "NtSaveKeyEx",
    "NtSaveMergedKeys",
    "NtSecureConnectPort",
    "NtSetBootEntryOrder",
    "NtSetBootOptions",
    "NtSetContextThread",
    "NtSetDebugFilterState",
    "NtSetDefaultHardErrorPort",
    "NtSetDefaultLocale",
    "NtSetDefaultUILanguage",
    "NtSetDriverEntryOrder",
    "NtSetEaFile",
    "NtSetEvent",
    "NtSetEventBoostPriority",
    "NtSetHighEventPair",
    "NtSetHighWaitLowEventPair",
    "NtSetInformationDebugObject",
    "NtSetInformationFile",
    "NtSetInformationJobObject",
    "NtSetInformationKey",
    "NtSetInformationObject",
    "NtSetInformationProcess",
    "NtSetInformationThread",
    "NtSetInformationToken",
    "NtSetIntervalProfile",
    "NtSetIoCompletion",
    "NtSetLdtEntries",
    "NtSetLowEventPair",
    "NtSetLowWaitHighEventPair",
    "NtSetQuotaInformationFile",
    "NtSetSecurityObject",
    "NtSetSystemEnvironmentValue",
    "NtSetSystemEnvironmentValueEx",
    "NtSetSystemInformation",
    "NtSetSystemPowerState",
    "NtSetSystemTime",
    "NtSetThreadExecutionState",
    "NtSetTimer",
    "NtSetTimerResolution",
    "NtSetUuidSeed",
    "NtSetValueKey",
    "NtSetVolumeInformationFile",
    "NtShutdownSystem",
    "NtSignalAndWaitForSingleObject",
    "NtStartProfile",
    "NtStopProfile",
    "NtSuspendProcess",
    "NtSuspendThread",
    "NtSystemDebugControl",
    "NtTerminateJobObject",
    "NtTerminateProcess",
    "NtTerminateThread",
    "NtTestAlert",
    "NtThawRegistry",
    "NtThawTransactions",
    "NtTraceEvent",
    "NtTraceControl",
    "NtTranslateFilePath",
    "NtUnloadDriver",
    "NtUnloadKey",
    "NtUnloadKey2",
    "NtUnloadKeyEx",
    "NtUnlockFile",
    "NtUnlockVirtualMemory",
    "NtUnmapViewOfSection",
    "NtVdmControl",
    "NtWaitForDebugEvent",
    "NtWaitForMultipleObjects",
    "NtWaitForSingleObject",
    "NtWaitHighEventPair",
    "NtWaitLowEventPair",
    "NtWriteFile",
    "NtWriteFileGather",
    "NtWriteRequestData",
    "NtWriteVirtualMemory",
    "NtYieldExecution",
    "NtCreateKeyedEvent",
    "NtOpenKeyedEvent",
    "NtReleaseKeyedEvent",
    "NtWaitForKeyedEvent",
    "NtQueryPortInformationProcess",
    "NtGetCurrentProcessorNumber",
    "NtWaitForMultipleObjects32",
    "NtGetNextProcess",
    "NtGetNextThread",
    "NtCancelIoFileEx",
    "NtCancelSynchronousIoFile",
    "NtRemoveIoCompletionEx",
    "NtRegisterProtocolAddressInformation",
    "NtPropagationComplete",
    "NtPropagationFailed",
    "NtCreateWorkerFactory",
    "NtReleaseWorkerFactoryWorker",
    "NtWaitForWorkViaWorkerFactory",
    "NtSetInformationWorkerFactory",
    "NtQueryInformationWorkerFactory",
    "NtWorkerFactoryWorkerReady",
    "NtShutdownWorkerFactory",
    "NtCreateThreadEx",
    "NtCreateUserProcess",
    "NtQueryLicenseValue",
    "NtMapCMFModule",
    "NtIsUILanguageComitted",
    "NtFlushInstallUILanguage",
    "NtGetMUIRegistryInfo",
    "NtAcquireCMFViewOwnership",
    "NtReleaseCMFViewOwnership"
};

//////////////////////////////////////////////////////////////////////////
// Windows 7 SP0 _KiServiceTable
//////////////////////////////////////////////////////////////////////////
static const char* KiServiceTable_Win7Sp0_x86[] = {
    "NtAcceptConnectPort",
    "NtAccessCheck",
    "NtAccessCheckAndAuditAlarm",
    "NtAccessCheckByType",
    "NtAccessCheckByTypeAndAuditAlarm",
    "NtAccessCheckByTypeResultList",
    "NtAccessCheckByTypeResultListAndAuditAlarm",
    "NtAccessCheckByTypeResultListAndAuditAlarmByHandle",
    "NtAddAtom",
    "NtAddBootEntry",
    "NtAddDriverEntry",
    "NtAdjustGroupsToken",
    "NtAdjustPrivilegesToken",
    "NtAlertResumeThread",
    "NtAlertThread",
    "NtAllocateLocallyUniqueId",
    "NtAllocateReserveObject",
    "NtAllocateUserPhysicalPages",
    "NtAllocateUuids",
    "NtAllocateVirtualMemory",
    "NtAlpcAcceptConnectPort",
    "NtAlpcCancelMessage",
    "NtAlpcConnectPort",
    "NtAlpcCreatePort",
    "NtAlpcCreatePortSection",
    "NtAlpcCreateResourceReserve",
    "NtAlpcCreateSectionView",
    "NtAlpcCreateSecurityContext",
    "NtAlpcDeletePortSection",
    "NtAlpcDeleteResourceReserve",
    "NtAlpcDeleteSectionView",
    "NtAlpcDeleteSecurityContext",
    "NtAlpcDisconnectPort",
    "NtAlpcImpersonateClientOfPort",
    "NtAlpcOpenSenderProcess",
    "NtAlpcOpenSenderThread",
    "NtAlpcQueryInformation",
    "NtAlpcQueryInformationMessage",
    "NtAlpcRevokeSecurityContext",
    "NtAlpcSendWaitReceivePort",
    "NtAlpcSetInformation",
    "NtApphelpCacheControl",
    "NtAreMappedFilesTheSame",
    "NtAssignProcessToJobObject",
    "NtCallbackReturn",
    "NtCancelIoFile",
    "NtCancelIoFileEx",
    "NtCancelSynchronousIoFile",
    "NtCancelTimer",
    "NtClearEvent",
    "NtClose",
    "NtCloseObjectAuditAlarm",
    "NtCommitComplete",
    "NtCommitEnlistment",
    "NtCommitTransaction",
    "NtCompactKeys",
    "NtCompareTokens",
    "NtCompleteConnectPort",
    "NtCompressKey",
    "NtConnectPort",
    "NtContinue",
    "NtCreateDebugObject",
    "NtCreateDirectoryObject",
    "NtCreateEnlistment",
    "NtCreateEvent",
    "NtCreateEventPair",
    "NtCreateFile",
    "NtCreateIoCompletion",
    "NtCreateJobObject",
    "NtCreateJobSet",
    "NtCreateKey",
    "NtCreateKeyedEvent",
    "NtCreateKeyTransacted",
    "NtCreateMailslotFile",
    "NtCreateMutant",
    "NtCreateNamedPipeFile",
    "NtCreatePagingFile",
    "NtCreatePort",
    "NtCreatePrivateNamespace",
    "NtCreateProcess",
    "NtCreateProcessEx",
    "NtCreateProfile",
    "NtCreateProfileEx",
    "NtCreateResourceManager",
    "NtCreateSection",
    "NtCreateSemaphore",
    "NtCreateSymbolicLinkObject",
    "NtCreateThread",
    "NtCreateThreadEx",
    "NtCreateTimer",
    "NtCreateToken",
    "NtCreateTransaction",
    "NtCreateTransactionManager",
    "NtCreateUserProcess",
    "NtCreateWaitablePort",
    "NtCreateWorkerFactory",
    "NtDebugActiveProcess",
    "NtDebugContinue",
    "NtDelayExecution",
    "NtDeleteAtom",
    "NtDeleteBootEntry",
    "NtDeleteDriverEntry",
    "NtDeleteFile",
    "NtDeleteKey",
    "NtDeleteObjectAuditAlarm",
    "NtDeletePrivateNamespace",
    "NtDeleteValueKey",
    "NtDeviceIoControlFile",
    "NtDisableLastKnownGood",
    "NtDisplayString",
    "NtDrawText",
    "NtDuplicateObject",
    "NtDuplicateToken",
    "NtEnableLastKnownGood",
    "NtEnumerateBootEntries",
    "NtEnumerateDriverEntries",
    "NtEnumerateKey",
    "NtEnumerateSystemEnvironmentValuesEx",
    "NtEnumerateTransactionObject",
    "NtEnumerateValueKey",
    "NtExtendSection",
    "NtFilterToken",
    "NtFindAtom",
    "NtFlushBuffersFile",
    "NtFlushInstallUILanguage",
    "NtFlushInstructionCache",
    "NtFlushKey",
    "NtFlushProcessWriteBuffers",
    "NtFlushVirtualMemory",
    "NtFlushWriteBuffer",
    "NtFreeUserPhysicalPages",
    "NtFreeVirtualMemory",
    "NtFreezeRegistry",
    "NtFreezeTransactions",
    "NtFsControlFile",
    "NtGetContextThread",
    "NtGetCurrentProcessorNumber",
    "NtGetDevicePowerState",
    "NtGetMUIRegistryInfo",
    "NtGetNextProcess",
    "NtGetNextThread",
    "NtGetNlsSectionPtr",
    "NtGetNotificationResourceManager",
    "NtGetPlugPlayEvent",
    "NtGetWriteWatch",
    "NtImpersonateAnonymousToken",
    "NtImpersonateClientOfPort",
    "NtImpersonateThread",
    "NtInitializeNlsFiles",
    "NtInitializeRegistry",
    "NtInitiatePowerAction",
    "NtIsProcessInJob",
    "NtIsSystemResumeAutomatic",
    "NtIsUILanguageComitted",
    "NtListenPort",
    "NtLoadDriver",
    "NtLoadKey",
    "NtLoadKey2",
    "NtLoadKeyEx",
    "NtLockFile",
    "NtLockProductActivationKeys",
    "NtLockRegistryKey",
    "NtLockVirtualMemory",
    "NtMakePermanentObject",
    "NtMakeTemporaryObject",
    "NtMapCMFModule",
    "NtMapUserPhysicalPages",
    "NtMapUserPhysicalPagesScatter",
    "NtMapViewOfSection",
    "NtModifyBootEntry",
    "NtModifyDriverEntry",
    "NtNotifyChangeDirectoryFile",
    "NtNotifyChangeKey",
    "NtNotifyChangeMultipleKeys",
    "NtNotifyChangeSession",
    "NtOpenDirectoryObject",
    "NtOpenEnlistment",
    "NtOpenEvent",
    "NtOpenEventPair",
    "NtOpenFile",
    "NtOpenIoCompletion",
    "NtOpenJobObject",
    "NtOpenKey",
    "NtOpenKeyEx",
    "NtOpenKeyedEvent",
    "NtOpenKeyTransacted",
    "NtOpenKeyTransactedEx",
    "NtOpenMutant",
    "NtOpenObjectAuditAlarm",
    "NtOpenPrivateNamespace",
    "NtOpenProcess",
    "NtOpenProcessToken",
    "NtOpenProcessTokenEx",
    "NtOpenResourceManager",
    "NtOpenSection",
    "NtOpenSemaphore",
    "NtOpenSession",
    "NtOpenSymbolicLinkObject",
    "NtOpenThread",
    "NtOpenThreadToken",
    "NtOpenThreadTokenEx",
    "NtOpenTimer",
    "NtOpenTransaction",
    "NtOpenTransactionManager",
    "NtPlugPlayControl",
    "NtPowerInformation",
    "NtPrepareComplete",
    "NtPrepareEnlistment",
    "NtPrePrepareComplete",
    "NtPrePrepareEnlistment",
    "NtPrivilegeCheck",
    "NtPrivilegedServiceAuditAlarm",
    "NtPrivilegeObjectAuditAlarm",
    "NtPropagationComplete",
    "NtPropagationFailed",
    "NtProtectVirtualMemory",
    "NtPulseEvent",
    "NtQueryAttributesFile",
    "NtQueryBootEntryOrder",
    "NtQueryBootOptions",
    "NtQueryDebugFilterState",
    "NtQueryDefaultLocale",
    "NtQueryDefaultUILanguage",
    "NtQueryDirectoryFile",
    "NtQueryDirectoryObject",
    "NtQueryDriverEntryOrder",
    "NtQueryEaFile",
    "NtQueryEvent",
    "NtQueryFullAttributesFile",
    "NtQueryInformationAtom",
    "NtQueryInformationEnlistment",
    "NtQueryInformationFile",
    "NtQueryInformationJobObject",
    "NtQueryInformationPort",
    "NtQueryInformationProcess",
    "NtQueryInformationResourceManager",
    "NtQueryInformationThread",
    "NtQueryInformationToken",
    "NtQueryInformationTransaction",
    "NtQueryInformationTransactionManager",
    "NtQueryInformationWorkerFactory",
    "NtQueryInstallUILanguage",
    "NtQueryIntervalProfile",
    "NtQueryIoCompletion",
    "NtQueryKey",
    "NtQueryLicenseValue",
    "NtQueryMultipleValueKey",
    "NtQueryMutant",
    "NtQueryObject",
    "NtQueryOpenSubKeys",
    "NtQueryOpenSubKeysEx",
    "NtQueryPerformanceCounter",
    "NtQueryPortInformationProcess",
    "NtQueryQuotaInformationFile",
    "NtQuerySection",
    "NtQuerySecurityAttributesToken",
    "NtQuerySecurityObject",
    "NtQuerySemaphore",
    "NtQuerySymbolicLinkObject",
    "NtQuerySystemEnvironmentValue",
    "NtQuerySystemEnvironmentValueEx",
    "NtQuerySystemInformation",
    "NtQuerySystemInformationEx",
    "NtQuerySystemTime",
    "NtQueryTimer",
    "NtQueryTimerResolution",
    "NtQueryValueKey",
    "NtQueryVirtualMemory",
    "NtQueryVolumeInformationFile",
    "NtQueueApcThread",
    "NtQueueApcThreadEx",
    "NtRaiseException",
    "NtRaiseHardError",
    "NtReadFile",
    "NtReadFileScatter",
    "NtReadOnlyEnlistment",
    "NtReadRequestData",
    "NtReadVirtualMemory",
    "NtRecoverEnlistment",
    "NtRecoverResourceManager",
    "NtRecoverTransactionManager",
    "NtRegisterProtocolAddressInformation",
    "NtRegisterThreadTerminatePort",
    "NtReleaseKeyedEvent",
    "NtReleaseMutant",
    "NtReleaseSemaphore",
    "NtReleaseWorkerFactoryWorker",
    "NtRemoveIoCompletion",
    "NtRemoveIoCompletionEx",
    "NtRemoveProcessDebug",
    "NtRenameKey",
    "NtRenameTransactionManager",
    "NtReplaceKey",
    "NtReplacePartitionUnit",
    "NtReplyPort",
    "NtReplyWaitReceivePort",
    "NtReplyWaitReceivePortEx",
    "NtReplyWaitReplyPort",
    "NtRequestPort",
    "NtRequestWaitReplyPort",
    "NtResetEvent",
    "NtResetWriteWatch",
    "NtRestoreKey",
    "NtResumeProcess",
    "NtResumeThread",
    "NtRollbackComplete",
    "NtRollbackEnlistment",
    "NtRollbackTransaction",
    "NtRollforwardTransactionManager",
    "NtSaveKey",
    "NtSaveKeyEx",
    "NtSaveMergedKeys",
    "NtSecureConnectPort",
    "NtSerializeBoot",
    "NtSetBootEntryOrder",
    "NtSetBootOptions",
    "NtSetContextThread",
    "NtSetDebugFilterState",
    "NtSetDefaultHardErrorPort",
    "NtSetDefaultLocale",
    "NtSetDefaultUILanguage",
    "NtSetDriverEntryOrder",
    "NtSetEaFile",
    "NtSetEvent",
    "NtSetEventBoostPriority",
    "NtSetHighEventPair",
    "NtSetHighWaitLowEventPair",
    "NtSetInformationDebugObject",
    "NtSetInformationEnlistment",
    "NtSetInformationFile",
    "NtSetInformationJobObject",
    "NtSetInformationKey",
    "NtSetInformationObject",
    "NtSetInformationProcess",
    "NtSetInformationResourceManager",
    "NtSetInformationThread",
    "NtSetInformationToken",
    "NtSetInformationTransaction",
    "NtSetInformationTransactionManager",
    "NtSetInformationWorkerFactory",
    "NtSetIntervalProfile",
    "NtSetIoCompletion",
    "NtSetIoCompletionEx",
    "NtSetLdtEntries",
    "NtSetLowEventPair",
    "NtSetLowWaitHighEventPair",
    "NtSetQuotaInformationFile",
    "NtSetSecurityObject",
    "NtSetSystemEnvironmentValue",
    "NtSetSystemEnvironmentValueEx",
    "NtSetSystemInformation",
    "NtSetSystemPowerState",
    "NtSetSystemTime",
    "NtSetThreadExecutionState",
    "NtSetTimer",
    "NtSetTimerEx",
    "NtSetTimerResolution",
    "NtSetUuidSeed",
    "NtSetValueKey",
    "NtSetVolumeInformationFile",
    "NtShutdownSystem",
    "NtShutdownWorkerFactory",
    "NtSignalAndWaitForSingleObject",
    "NtSinglePhaseReject",
    "NtStartProfile",
    "NtStopProfile",
    "NtSuspendProcess",
    "NtSuspendThread",
    "NtSystemDebugControl",
    "NtTerminateJobObject",
    "NtTerminateProcess",
    "NtTerminateThread",
    "NtTestAlert",
    "NtThawRegistry",
    "NtThawTransactions",
    "NtTraceControl",
    "NtTraceEvent",
    "NtTranslateFilePath",
    "NtUmsThreadYield",
    "NtUnloadDriver",
    "NtUnloadKey",
    "NtUnloadKey2",
    "NtUnloadKeyEx",
    "NtUnlockFile",
    "NtUnlockVirtualMemory",
    "NtUnmapViewOfSection",
    "NtVdmControl",
    "NtWaitForDebugEvent",
    "NtWaitForKeyedEvent",
    "NtWaitForMultipleObjects",
    "NtWaitForMultipleObjects32",
    "NtWaitForSingleObject",
    "NtWaitForWorkViaWorkerFactory",
    "NtWaitHighEventPair",
    "NtWaitLowEventPair",
    "NtWorkerFactoryWorkerReady",
    "NtWriteFile",
    "NtWriteFileGather",
    "NtWriteRequestData",
    "NtWriteVirtualMemory",
    "NtYieldExecution"
};

//////////////////////////////////////////////////////////////////////////
// Windows 7 SP1 _KiServiceTable
//////////////////////////////////////////////////////////////////////////
static const char* KiServiceTable_Win7Sp1_x86[] = {
    "NtAcceptConnectPort",
    "NtAccessCheck",
    "NtAccessCheckAndAuditAlarm",
    "NtAccessCheckByType",
    "NtAccessCheckByTypeAndAuditAlarm",
    "NtAccessCheckByTypeResultList",
    "NtAccessCheckByTypeResultListAndAuditAlarm",
    "NtAccessCheckByTypeResultListAndAuditAlarmByHandle",
    "NtAddAtom",
    "NtAddBootEntry",
    "NtAddDriverEntry",
    "NtAdjustGroupsToken",
    "NtAdjustPrivilegesToken",
    "NtAlertResumeThread",
    "NtAlertThread",
    "NtAllocateLocallyUniqueId",
    "NtAllocateReserveObject",
    "NtAllocateUserPhysicalPages",
    "NtAllocateUuids",
    "NtAllocateVirtualMemory",
    "NtAlpcAcceptConnectPort",
    "NtAlpcCancelMessage",
    "NtAlpcConnectPort",
    "NtAlpcCreatePort",
    "NtAlpcCreatePortSection",
    "NtAlpcCreateResourceReserve",
    "NtAlpcCreateSectionView",
    "NtAlpcCreateSecurityContext",
    "NtAlpcDeletePortSection",
    "NtAlpcDeleteResourceReserve",
    "NtAlpcDeleteSectionView",
    "NtAlpcDeleteSecurityContext",
    "NtAlpcDisconnectPort",
    "NtAlpcImpersonateClientOfPort",
    "NtAlpcOpenSenderProcess",
    "NtAlpcOpenSenderThread",
    "NtAlpcQueryInformation",
    "NtAlpcQueryInformationMessage",
    "NtAlpcRevokeSecurityContext",
    "NtAlpcSendWaitReceivePort",
    "NtAlpcSetInformation",
    "NtApphelpCacheControl",
    "NtAreMappedFilesTheSame",
    "NtAssignProcessToJobObject",
    "NtCallbackReturn",
    "NtCancelIoFile",
    "NtCancelIoFileEx",
    "NtCancelSynchronousIoFile",
    "NtCancelTimer",
    "NtClearEvent",
    "NtClose",
    "NtCloseObjectAuditAlarm",
    "NtCommitComplete",
    "NtCommitEnlistment",
    "NtCommitTransaction",
    "NtCompactKeys",
    "NtCompareTokens",
    "NtCompleteConnectPort",
    "NtCompressKey",
    "NtConnectPort",
    "NtContinue",
    "NtCreateDebugObject",
    "NtCreateDirectoryObject",
    "NtCreateEnlistment",
    "NtCreateEvent",
    "NtCreateEventPair",
    "NtCreateFile",
    "NtCreateIoCompletion",
    "NtCreateJobObject",
    "NtCreateJobSet",
    "NtCreateKey",
    "NtCreateKeyedEvent",
    "NtCreateKeyTransacted",
    "NtCreateMailslotFile",
    "NtCreateMutant",
    "NtCreateNamedPipeFile",
    "NtCreatePagingFile",
    "NtCreatePort",
    "NtCreatePrivateNamespace",
    "NtCreateProcess",
    "NtCreateProcessEx",
    "NtCreateProfile",
    "NtCreateProfileEx",
    "NtCreateResourceManager",
    "NtCreateSection",
    "NtCreateSemaphore",
    "NtCreateSymbolicLinkObject",
    "NtCreateThread",
    "NtCreateThreadEx",
    "NtCreateTimer",
    "NtCreateToken",
    "NtCreateTransaction",
    "NtCreateTransactionManager",
    "NtCreateUserProcess",
    "NtCreateWaitablePort",
    "NtCreateWorkerFactory",
    "NtDebugActiveProcess",
    "NtDebugContinue",
    "NtDelayExecution",
    "NtDeleteAtom",
    "NtDeleteBootEntry",
    "NtDeleteDriverEntry",
    "NtDeleteFile",
    "NtDeleteKey",
    "NtDeleteObjectAuditAlarm",
    "NtDeletePrivateNamespace",
    "NtDeleteValueKey",
    "NtDeviceIoControlFile",
    "NtDisableLastKnownGood",
    "NtDisplayString",
    "NtDrawText",
    "NtDuplicateObject",
    "NtDuplicateToken",
    "NtEnableLastKnownGood",
    "NtEnumerateBootEntries",
    "NtEnumerateDriverEntries",
    "NtEnumerateKey",
    "NtEnumerateSystemEnvironmentValuesEx",
    "NtEnumerateTransactionObject",
    "NtEnumerateValueKey",
    "NtExtendSection",
    "NtFilterToken",
    "NtFindAtom",
    "NtFlushBuffersFile",
    "NtFlushInstallUILanguage",
    "NtFlushInstructionCache",
    "NtFlushKey",
    "NtFlushProcessWriteBuffers",
    "NtFlushVirtualMemory",
    "NtFlushWriteBuffer",
    "NtFreeUserPhysicalPages",
    "NtFreeVirtualMemory",
    "NtFreezeRegistry",
    "NtFreezeTransactions",
    "NtFsControlFile",
    "NtGetContextThread",
    "NtGetCurrentProcessorNumber",
    "NtGetDevicePowerState",
    "NtGetMUIRegistryInfo",
    "NtGetNextProcess",
    "NtGetNextThread",
    "NtGetNlsSectionPtr",
    "NtGetNotificationResourceManager",
    "NtGetPlugPlayEvent",
    "NtGetWriteWatch",
    "NtImpersonateAnonymousToken",
    "NtImpersonateClientOfPort",
    "NtImpersonateThread",
    "NtInitializeNlsFiles",
    "NtInitializeRegistry",
    "NtInitiatePowerAction",
    "NtIsProcessInJob",
    "NtIsSystemResumeAutomatic",
    "NtIsUILanguageComitted",
    "NtListenPort",
    "NtLoadDriver",
    "NtLoadKey",
    "NtLoadKey2",
    "NtLoadKeyEx",
    "NtLockFile",
    "NtLockProductActivationKeys",
    "NtLockRegistryKey",
    "NtLockVirtualMemory",
    "NtMakePermanentObject",
    "NtMakeTemporaryObject",
    "NtMapCMFModule",
    "NtMapUserPhysicalPages",
    "NtMapUserPhysicalPagesScatter",
    "NtMapViewOfSection",
    "NtModifyBootEntry",
    "NtModifyDriverEntry",
    "NtNotifyChangeDirectoryFile",
    "NtNotifyChangeKey",
    "NtNotifyChangeMultipleKeys",
    "NtNotifyChangeSession",
    "NtOpenDirectoryObject",
    "NtOpenEnlistment",
    "NtOpenEvent",
    "NtOpenEventPair",
    "NtOpenFile",
    "NtOpenIoCompletion",
    "NtOpenJobObject",
    "NtOpenKey",
    "NtOpenKeyEx",
    "NtOpenKeyedEvent",
    "NtOpenKeyTransacted",
    "NtOpenKeyTransactedEx",
    "NtOpenMutant",
    "NtOpenObjectAuditAlarm",
    "NtOpenPrivateNamespace",
    "NtOpenProcess",
    "NtOpenProcessToken",
    "NtOpenProcessTokenEx",
    "NtOpenResourceManager",
    "NtOpenSection",
    "NtOpenSemaphore",
    "NtOpenSession",
    "NtOpenSymbolicLinkObject",
    "NtOpenThread",
    "NtOpenThreadToken",
    "NtOpenThreadTokenEx",
    "NtOpenTimer",
    "NtOpenTransaction",
    "NtOpenTransactionManager",
    "NtPlugPlayControl",
    "NtPowerInformation",
    "NtPrepareComplete",
    "NtPrepareEnlistment",
    "NtPrePrepareComplete",
    "NtPrePrepareEnlistment",
    "NtPrivilegeCheck",
    "NtPrivilegedServiceAuditAlarm",
    "NtPrivilegeObjectAuditAlarm",
    "NtPropagationComplete",
    "NtPropagationFailed",
    "NtProtectVirtualMemory",
    "NtPulseEvent",
    "NtQueryAttributesFile",
    "NtQueryBootEntryOrder",
    "NtQueryBootOptions",
    "NtQueryDebugFilterState",
    "NtQueryDefaultLocale",
    "NtQueryDefaultUILanguage",
    "NtQueryDirectoryFile",
    "NtQueryDirectoryObject",
    "NtQueryDriverEntryOrder",
    "NtQueryEaFile",
    "NtQueryEvent",
    "NtQueryFullAttributesFile",
    "NtQueryInformationAtom",
    "NtQueryInformationEnlistment",
    "NtQueryInformationFile",
    "NtQueryInformationJobObject",
    "NtQueryInformationPort",
    "NtQueryInformationProcess",
    "NtQueryInformationResourceManager",
    "NtQueryInformationThread",
    "NtQueryInformationToken",
    "NtQueryInformationTransaction",
    "NtQueryInformationTransactionManager",
    "NtQueryInformationWorkerFactory",
    "NtQueryInstallUILanguage",
    "NtQueryIntervalProfile",
    "NtQueryIoCompletion",
    "NtQueryKey",
    "NtQueryLicenseValue",
    "NtQueryMultipleValueKey",
    "NtQueryMutant",
    "NtQueryObject",
    "NtQueryOpenSubKeys",
    "NtQueryOpenSubKeysEx",
    "NtQueryPerformanceCounter",
    "NtQueryPortInformationProcess",
    "NtQueryQuotaInformationFile",
    "NtQuerySection",
    "NtQuerySecurityAttributesToken",
    "NtQuerySecurityObject",
    "NtQuerySemaphore",
    "NtQuerySymbolicLinkObject",
    "NtQuerySystemEnvironmentValue",
    "NtQuerySystemEnvironmentValueEx",
    "NtQuerySystemInformation",
    "NtQuerySystemInformationEx",
    "NtQuerySystemTime",
    "NtQueryTimer",
    "NtQueryTimerResolution",
    "NtQueryValueKey",
    "NtQueryVirtualMemory",
    "NtQueryVolumeInformationFile",
    "NtQueueApcThread",
    "NtQueueApcThreadEx",
    "NtRaiseException",
    "NtRaiseHardError",
    "NtReadFile",
    "NtReadFileScatter",
    "NtReadOnlyEnlistment",
    "NtReadRequestData",
    "NtReadVirtualMemory",
    "NtRecoverEnlistment",
    "NtRecoverResourceManager",
    "NtRecoverTransactionManager",
    "NtRegisterProtocolAddressInformation",
    "NtRegisterThreadTerminatePort",
    "NtReleaseKeyedEvent",
    "NtReleaseMutant",
    "NtReleaseSemaphore",
    "NtReleaseWorkerFactoryWorker",
    "NtRemoveIoCompletion",
    "NtRemoveIoCompletionEx",
    "NtRemoveProcessDebug",
    "NtRenameKey",
    "NtRenameTransactionManager",
    "NtReplaceKey",
    "NtReplacePartitionUnit",
    "NtReplyPort",
    "NtReplyWaitReceivePort",
    "NtReplyWaitReceivePortEx",
    "NtReplyWaitReplyPort",
    "NtRequestPort",
    "NtRequestWaitReplyPort",
    "NtResetEvent",
    "NtResetWriteWatch",
    "NtRestoreKey",
    "NtResumeProcess",
    "NtResumeThread",
    "NtRollbackComplete",
    "NtRollbackEnlistment",
    "NtRollbackTransaction",
    "NtRollforwardTransactionManager",
    "NtSaveKey",
    "NtSaveKeyEx",
    "NtSaveMergedKeys",
    "NtSecureConnectPort",
    "NtSerializeBoot",
    "NtSetBootEntryOrder",
    "NtSetBootOptions",
    "NtSetContextThread",
    "NtSetDebugFilterState",
    "NtSetDefaultHardErrorPort",
    "NtSetDefaultLocale",
    "NtSetDefaultUILanguage",
    "NtSetDriverEntryOrder",
    "NtSetEaFile",
    "NtSetEvent",
    "NtSetEventBoostPriority",
    "NtSetHighEventPair",
    "NtSetHighWaitLowEventPair",
    "NtSetInformationDebugObject",
    "NtSetInformationEnlistment",
    "NtSetInformationFile",
    "NtSetInformationJobObject",
    "NtSetInformationKey",
    "NtSetInformationObject",
    "NtSetInformationProcess",
    "NtSetInformationResourceManager",
    "NtSetInformationThread",
    "NtSetInformationToken",
    "NtSetInformationTransaction",
    "NtSetInformationTransactionManager",
    "NtSetInformationWorkerFactory",
    "NtSetIntervalProfile",
    "NtSetIoCompletion",
    "NtSetIoCompletionEx",
    "NtSetLdtEntries",
    "NtSetLowEventPair",
    "NtSetLowWaitHighEventPair",
    "NtSetQuotaInformationFile",
    "NtSetSecurityObject",
    "NtSetSystemEnvironmentValue",
    "NtSetSystemEnvironmentValueEx",
    "NtSetSystemInformation",
    "NtSetSystemPowerState",
    "NtSetSystemTime",
    "NtSetThreadExecutionState",
    "NtSetTimer",
    "NtSetTimerEx",
    "NtSetTimerResolution",
    "NtSetUuidSeed",
    "NtSetValueKey",
    "NtSetVolumeInformationFile",
    "NtShutdownSystem",
    "NtShutdownWorkerFactory",
    "NtSignalAndWaitForSingleObject",
    "NtSinglePhaseReject",
    "NtStartProfile",
    "NtStopProfile",
    "NtSuspendProcess",
    "NtSuspendThread",
    "NtSystemDebugControl",
    "NtTerminateJobObject",
    "NtTerminateProcess",
    "NtTerminateThread",
    "NtTestAlert",
    "NtThawRegistry",
    "NtThawTransactions",
    "NtTraceControl",
    "NtTraceEvent",
    "NtTranslateFilePath",
    "NtUmsThreadYield",
    "NtUnloadDriver",
    "NtUnloadKey",
    "NtUnloadKey2",
    "NtUnloadKeyEx",
    "NtUnlockFile",
    "NtUnlockVirtualMemory",
    "NtUnmapViewOfSection",
    "NtVdmControl",
    "NtWaitForDebugEvent",
    "NtWaitForKeyedEvent",
    "NtWaitForMultipleObjects",
    "NtWaitForMultipleObjects32",
    "NtWaitForSingleObject",
    "NtWaitForWorkViaWorkerFactory",
    "NtWaitHighEventPair",
    "NtWaitLowEventPair",
    "NtWorkerFactoryWorkerReady",
    "NtWriteFile",
    "NtWriteFileGather",
    "NtWriteRequestData",
    "NtWriteVirtualMemory",
    "NtYieldExecution"
};

//////////////////////////////////////////////////////////////////////////
// Windows 8 SP0 _KiServiceTable
//////////////////////////////////////////////////////////////////////////
static const char* KiServiceTable_Win8Sp0_x86[] = {
    "NtWorkerFactoryWorkerReady",
    "NtYieldExecution",
    "NtWriteVirtualMemory",
    "NtWriteRequestData",
    "NtWriteFileGather",
    "NtWriteFile",
    "NtWaitLowEventPair",
    "NtWaitHighEventPair",
    "NtWaitForWorkViaWorkerFactory",
    "NtWaitForWnfNotifications",
    "NtWaitForSingleObject",
    "NtWaitForMultipleObjects32",
    "NtWaitForMultipleObjects",
    "NtWaitForKeyedEvent",
    "NtWaitForDebugEvent",
    "NtWaitForAlertByThreadId",
    "NtVdmControl",
    "NtUnsubscribeWnfStateChange",
    "NtUpdateWnfStateData",
    "NtUnmapViewOfSection",
    "NtUnmapViewOfSectionEx",
    "NtUnlockVirtualMemory",
    "NtUnlockFile",
    "NtUnloadKeyEx",
    "NtUnloadKey2",
    "NtUnloadKey",
    "NtUnloadDriver",
    "NtUmsThreadYield",
    "NtTranslateFilePath",
    "NtTraceEvent",
    "NtTraceControl",
    "NtThawTransactions",
    "NtThawRegistry",
    "NtTestAlert",
    "NtTerminateThread",
    "NtTerminateProcess",
    "NtTerminateJobObject",
    "NtSystemDebugControl",
    "NtSuspendThread",
    "NtSuspendProcess",
    "NtSubscribeWnfStateChange",
    "NtStopProfile",
    "NtStartProfile",
    "NtSinglePhaseReject",
    "NtSignalAndWaitForSingleObject",
    "NtShutdownWorkerFactory",
    "NtShutdownSystem",
    "NtSetVolumeInformationFile",
    "NtSetValueKey",
    "NtSetUuidSeed",
    "NtSetTimerResolution",
    "NtSetTimerEx",
    "NtSetTimer",
    "NtSetThreadExecutionState",
    "NtSetSystemTime",
    "NtSetSystemPowerState",
    "NtSetSystemInformation",
    "NtSetSystemEnvironmentValueEx",
    "NtSetSystemEnvironmentValue",
    "NtSetSecurityObject",
    "NtSetQuotaInformationFile",
    "NtSetLowWaitHighEventPair",
    "NtSetLowEventPair",
    "NtSetLdtEntries",
    "NtSetIRTimer",
    "NtSetIoCompletionEx",
    "NtSetIoCompletion",
    "NtSetIntervalProfile",
    "NtSetInformationWorkerFactory",
    "NtSetInformationTransactionManager",
    "NtSetInformationTransaction",
    "NtSetInformationToken",
    "NtSetInformationThread",
    "NtSetInformationResourceManager",
    "NtSetInformationProcess",
    "NtSetInformationObject",
    "NtSetInformationKey",
    "NtSetInformationJobObject",
    "NtSetInformationFile",
    "NtSetInformationEnlistment",
    "NtSetInformationDebugObject",
    "NtSetHighWaitLowEventPair",
    "NtSetHighEventPair",
    "NtSetEventBoostPriority",
    "NtSetEvent",
    "NtSetEaFile",
    "NtSetDriverEntryOrder",
    "NtSetDefaultUILanguage",
    "NtSetDefaultLocale",
    "NtSetDefaultHardErrorPort",
    "NtSetDebugFilterState",
    "NtSetContextThread",
    "NtSetCachedSigningLevel",
    "NtSetBootOptions",
    "NtSetBootEntryOrder",
    "NtSerializeBoot",
    "NtSecureConnectPort",
    "NtSaveMergedKeys",
    "NtSaveKeyEx",
    "NtSaveKey",
    "NtRollforwardTransactionManager",
    "NtRollbackTransaction",
    "NtRollbackEnlistment",
    "NtRollbackComplete",
    "NtResumeThread",
    "NtResumeProcess",
    "NtRestoreKey",
    "NtResetWriteWatch",
    "NtResetEvent",
    "NtRequestWaitReplyPort",
    "NtRequestPort",
    "NtReplyWaitReplyPort",
    "NtReplyWaitReceivePortEx",
    "NtReplyWaitReceivePort",
    "NtReplyPort",
    "NtReplacePartitionUnit",
    "NtReplaceKey",
    "NtRenameTransactionManager",
    "NtRenameKey",
    "NtRemoveProcessDebug",
    "NtRemoveIoCompletionEx",
    "NtRemoveIoCompletion",
    "NtReleaseWorkerFactoryWorker",
    "NtReleaseSemaphore",
    "NtReleaseMutant",
    "NtReleaseKeyedEvent",
    "NtRegisterThreadTerminatePort",
    "NtRegisterProtocolAddressInformation",
    "NtRecoverTransactionManager",
    "NtRecoverResourceManager",
    "NtRecoverEnlistment",
    "NtReadVirtualMemory",
    "NtReadRequestData",
    "NtReadOnlyEnlistment",
    "NtReadFileScatter",
    "NtReadFile",
    "NtRaiseHardError",
    "NtRaiseException",
    "NtQueueApcThreadEx",
    "NtQueueApcThread",
    "NtQueryWnfStateData",
    "NtQueryWnfStateNameInformation",
    "NtQueryVolumeInformationFile",
    "NtQueryVirtualMemory",
    "NtQueryValueKey",
    "NtQueryTimerResolution",
    "NtQueryTimer",
    "NtQuerySystemTime",
    "NtQuerySystemInformationEx",
    "NtQuerySystemInformation",
    "NtQuerySystemEnvironmentValueEx",
    "NtQuerySystemEnvironmentValue",
    "NtQuerySymbolicLinkObject",
    "NtQuerySemaphore",
    "NtQuerySecurityObject",
    "NtQuerySecurityAttributesToken",
    "NtQuerySection",
    "NtQueryQuotaInformationFile",
    "NtQueryPortInformationProcess",
    "NtQueryPerformanceCounter",
    "NtQueryOpenSubKeysEx",
    "NtQueryOpenSubKeys",
    "NtQueryObject",
    "NtQueryMutant",
    "NtQueryMultipleValueKey",
    "NtQueryLicenseValue",
    "NtQueryKey",
    "NtQueryIoCompletion",
    "NtQueryIntervalProfile",
    "NtQueryInstallUILanguage",
    "NtQueryInformationWorkerFactory",
    "NtQueryInformationTransactionManager",
    "NtQueryInformationTransaction",
    "NtQueryInformationToken",
    "NtQueryInformationThread",
    "NtQueryInformationResourceManager",
    "NtQueryInformationProcess",
    "NtQueryInformationPort",
    "NtQueryInformationJobObject",
    "NtQueryInformationFile",
    "NtQueryInformationEnlistment",
    "NtQueryInformationAtom",
    "NtQueryFullAttributesFile",
    "NtQueryEvent",
    "NtQueryEaFile",
    "NtQueryDriverEntryOrder",
    "NtQueryDirectoryObject",
    "NtQueryDirectoryFile",
    "NtQueryDefaultUILanguage",
    "NtQueryDefaultLocale",
    "NtQueryDebugFilterState",
    "NtQueryBootOptions",
    "NtQueryBootEntryOrder",
    "NtQueryAttributesFile",
    "NtPulseEvent",
    "NtProtectVirtualMemory",
    "NtPropagationFailed",
    "NtPropagationComplete",
    "NtPrivilegeObjectAuditAlarm",
    "NtPrivilegedServiceAuditAlarm",
    "NtPrivilegeCheck",
    "NtSetInformationVirtualMemory",
    "NtPrePrepareEnlistment",
    "NtPrePrepareComplete",
    "NtPrepareEnlistment",
    "NtPrepareComplete",
    "NtPowerInformation",
    "NtPlugPlayControl",
    "NtOpenTransactionManager",
    "NtOpenTransaction",
    "NtOpenTimer",
    "NtOpenThreadTokenEx",
    "NtOpenThreadToken",
    "NtOpenThread",
    "NtOpenSymbolicLinkObject",
    "NtOpenSession",
    "NtOpenSemaphore",
    "NtOpenSection",
    "NtOpenResourceManager",
    "NtOpenProcessTokenEx",
    "NtOpenProcessToken",
    "NtOpenProcess",
    "NtOpenPrivateNamespace",
    "NtOpenObjectAuditAlarm",
    "NtOpenMutant",
    "NtOpenKeyTransactedEx",
    "NtOpenKeyTransacted",
    "NtOpenKeyEx",
    "NtOpenKeyedEvent",
    "NtOpenKey",
    "NtOpenJobObject",
    "NtOpenIoCompletion",
    "NtOpenFile",
    "NtOpenEventPair",
    "NtOpenEvent",
    "NtOpenEnlistment",
    "NtOpenDirectoryObject",
    "NtNotifyChangeSession",
    "NtNotifyChangeMultipleKeys",
    "NtNotifyChangeKey",
    "NtNotifyChangeDirectoryFile",
    "NtModifyDriverEntry",
    "NtModifyBootEntry",
    "NtMapViewOfSection",
    "NtMapUserPhysicalPagesScatter",
    "NtMapUserPhysicalPages",
    "NtMapCMFModule",
    "NtMakeTemporaryObject",
    "NtMakePermanentObject",
    "NtLockVirtualMemory",
    "NtLockRegistryKey",
    "NtLockProductActivationKeys",
    "NtLockFile",
    "NtLoadKeyEx",
    "NtLoadKey2",
    "NtLoadKey",
    "NtLoadDriver",
    "NtListenPort",
    "NtIsUILanguageComitted",
    "NtIsSystemResumeAutomatic",
    "NtIsProcessInJob",
    "NtInitiatePowerAction",
    "NtInitializeRegistry",
    "NtInitializeNlsFiles",
    "NtImpersonateThread",
    "NtImpersonateClientOfPort",
    "NtImpersonateAnonymousToken",
    "NtGetWriteWatch",
    "NtGetNotificationResourceManager",
    "NtGetNlsSectionPtr",
    "NtGetNextThread",
    "NtGetNextProcess",
    "NtGetMUIRegistryInfo",
    "NtGetDevicePowerState",
    "NtGetCurrentProcessorNumber",
    "NtGetContextThread",
    "NtGetCachedSigningLevel",
    "NtFsControlFile",
    "NtFreezeTransactions",
    "NtFreezeRegistry",
    "NtFreeVirtualMemory",
    "NtFreeUserPhysicalPages",
    "NtFlushWriteBuffer",
    "NtFlushVirtualMemory",
    "NtFlushProcessWriteBuffers",
    "NtFlushKey",
    "FsRtlSyncVolumes",
    "NtFlushInstallUILanguage",
    "NtFlushBuffersFile",
    "NtFlushBuffersFileEx",
    "NtFindAtom",
    "NtFilterToken",
    "NtFilterTokenEx",
    "NtFilterBootOption",
    "NtExtendSection",
    "NtEnumerateValueKey",
    "NtEnumerateTransactionObject",
    "NtEnumerateSystemEnvironmentValuesEx",
    "NtEnumerateKey",
    "NtEnumerateDriverEntries",
    "NtEnumerateBootEntries",
    "NtEnableLastKnownGood",
    "NtDuplicateToken",
    "NtDuplicateObject",
    "NtDrawText",
    "NtDisplayString",
    "NtDisableLastKnownGood",
    "NtDeviceIoControlFile",
    "NtDeleteWnfStateName",
    "NtDeleteWnfStateData",
    "NtDeleteValueKey",
    "NtDeletePrivateNamespace",
    "NtDeleteObjectAuditAlarm",
    "NtDeleteKey",
    "NtDeleteFile",
    "NtDeleteDriverEntry",
    "NtDeleteBootEntry",
    "NtDeleteAtom",
    "NtDelayExecution",
    "NtDebugContinue",
    "NtDebugActiveProcess",
    "NtCreateWorkerFactory",
    "NtCreateWnfStateName",
    "NtCreateWaitCompletionPacket",
    "NtCreateWaitablePort",
    "NtCreateUserProcess",
    "NtCreateTransactionManager",
    "NtCreateTransaction",
    "NtCreateToken",
    "NtCreateLowBoxToken",
    "NtCreateTokenEx",
    "NtCreateTimer",
    "NtCreateThreadEx",
    "NtCreateThread",
    "NtCreateSymbolicLinkObject",
    "NtCreateSemaphore",
    "NtCreateSection",
    "NtCreateResourceManager",
    "NtCreateProfileEx",
    "NtCreateProfile",
    "NtCreateProcessEx",
    "NtCreateProcess",
    "NtCreatePrivateNamespace",
    "NtCreatePort",
    "NtCreatePagingFile",
    "NtCreateNamedPipeFile",
    "NtCreateMutant",
    "NtCreateMailslotFile",
    "NtCreateKeyTransacted",
    "NtCreateKeyedEvent",
    "NtCreateKey",
    "NtCreateJobSet",
    "NtCreateJobObject",
    "NtCreateIRTimer",
    "NtCreateIoCompletion",
    "NtCreateFile",
    "NtCreateEventPair",
    "NtCreateEvent",
    "NtCreateEnlistment",
    "NtCreateDirectoryObjectEx",
    "NtCreateDirectoryObject",
    "NtCreateDebugObject",
    "NtContinue",
    "NtConnectPort",
    "NtCompressKey",
    "NtCompleteConnectPort",
    "NtCompareTokens",
    "NtCompactKeys",
    "NtCommitTransaction",
    "NtCommitEnlistment",
    "NtCommitComplete",
    "NtCloseObjectAuditAlarm",
    "NtClose",
    "NtClearEvent",
    "NtCancelWaitCompletionPacket",
    "NtCancelTimer",
    "NtCancelSynchronousIoFile",
    "NtCancelIoFileEx",
    "NtCancelIoFile",
    "NtCallbackReturn",
    "NtAssociateWaitCompletionPacket",
    "NtAssignProcessToJobObject",
    "NtAreMappedFilesTheSame",
    "NtApphelpCacheControl",
    "NtAlpcSetInformation",
    "NtAlpcSendWaitReceivePort",
    "NtAlpcRevokeSecurityContext",
    "NtAlpcQueryInformationMessage",
    "NtAlpcQueryInformation",
    "NtAlpcOpenSenderThread",
    "NtAlpcOpenSenderProcess",
    "NtAlpcImpersonateClientOfPort",
    "NtAlpcDisconnectPort",
    "NtAlpcDeleteSecurityContext",
    "NtAlpcDeleteSectionView",
    "NtAlpcDeleteResourceReserve",
    "NtAlpcDeletePortSection",
    "NtAlpcCreateSecurityContext",
    "NtAlpcCreateSectionView",
    "NtAlpcCreateResourceReserve",
    "NtAlpcCreatePortSection",
    "NtAlpcCreatePort",
    "NtAlpcConnectPort",
    "NtAlpcConnectPortEx",
    "NtAlpcCancelMessage",
    "NtAlpcAcceptConnectPort",
    "NtAllocateVirtualMemory",
    "NtAllocateUuids",
    "NtAllocateUserPhysicalPages",
    "NtAllocateReserveObject",
    "NtAllocateLocallyUniqueId",
    "NtAlertThreadByThreadId",
    "NtAlertThread",
    "NtAlertResumeThread",
    "NtAdjustPrivilegesToken",
    "NtAdjustGroupsToken",
    "NtAdjustTokenClaimsAndDeviceGroups",
    "NtAddDriverEntry",
    "NtAddBootEntry",
    "NtAddAtom",
    "NtAddAtomEx",
    "NtAccessCheckByTypeResultListAndAuditAlarmByHandle",
    "NtAccessCheckByTypeResultListAndAuditAlarm",
    "NtAccessCheckByTypeResultList",
    "NtAccessCheckByTypeAndAuditAlarm",
    "NtAccessCheckByType",
    "NtAccessCheckAndAuditAlarm",
    "NtAccessCheck",
    "NtAcceptConnectPort"
};

//////////////////////////////////////////////////////////////////////////
// Windows 8 SP1 _KiServiceTable
//////////////////////////////////////////////////////////////////////////
static const char* KiServiceTable_Win8Sp1_x86[] = {
    "NtWorkerFactoryWorkerReady",
    "NtAcceptConnectPort",
    "NtYieldExecution",
    "NtWriteVirtualMemory",
    "NtWriteRequestData",
    "NtWriteFileGather",
    "NtWriteFile",
    "NtSetHighEventPair",
    "NtSetHighEventPair",
    "NtWaitForWorkViaWorkerFactory",
    "NtWaitForSingleObject",
    "NtWaitForMultipleObjects32",
    "NtWaitForMultipleObjects",
    "NtWaitForKeyedEvent",
    "NtWaitForDebugEvent",
    "NtWaitForAlertByThreadId",
    "NtVdmControl",
    "NtUnsubscribeWnfStateChange",
    "NtUpdateWnfStateData",
    "NtUnmapViewOfSection",
    "NtUnmapViewOfSectionEx",
    "NtUnlockVirtualMemory",
    "NtUnlockFile",
    "NtUnloadKeyEx",
    "NtUnloadKey2",
    "NtUnloadKey",
    "NtUnloadDriver",
    "NtUmsThreadYield",
    "NtTranslateFilePath",
    "NtTraceEvent",
    "NtTraceControl",
    "NtThawTransactions",
    "NtThawRegistry",
    "NtTestAlert",
    "NtTerminateThread",
    "NtTerminateProcess",
    "NtTerminateJobObject",
    "NtSystemDebugControl",
    "NtSuspendThread",
    "NtSuspendProcess",
    "NtSubscribeWnfStateChange",
    "NtStopProfile",
    "NtStartProfile",
    "NtSinglePhaseReject",
    "NtSignalAndWaitForSingleObject",
    "NtShutdownWorkerFactory",
    "NtShutdownSystem",
    "NtSetWnfProcessNotificationEvent",
    "NtSetVolumeInformationFile",
    "NtSetValueKey",
    "NtSetUuidSeed",
    "NtSetTimerResolution",
    "NtSetTimerEx",
    "NtSetTimer",
    "NtSetThreadExecutionState",
    "NtSetSystemTime",
    "NtSetSystemPowerState",
    "NtSetSystemInformation",
    "NtSetSystemEnvironmentValueEx",
    "NtSetSystemEnvironmentValue",
    "NtSetSecurityObject",
    "NtSetQuotaInformationFile",
    "NtSetHighEventPair",
    "NtSetHighEventPair",
    "NtSetLdtEntries",
    "NtSetIRTimer",
    "NtSetTimer2",
    "NtCancelTimer2",
    "NtSetIoCompletionEx",
    "NtSetIoCompletion",
    "NtSetIntervalProfile",
    "NtSetInformationWorkerFactory",
    "NtSetInformationTransactionManager",
    "NtSetInformationTransaction",
    "NtSetInformationToken",
    "NtSetInformationThread",
    "NtSetInformationResourceManager",
    "NtSetInformationProcess",
    "NtSetInformationObject",
    "NtSetInformationKey",
    "NtSetInformationJobObject",
    "NtSetInformationFile",
    "NtSetInformationEnlistment",
    "NtSetInformationDebugObject",
    "NtSetHighEventPair",
    "NtSetHighEventPair",
    "NtSetEventBoostPriority",
    "NtSetEvent",
    "NtSetEaFile",
    "NtSetDriverEntryOrder",
    "NtSetDefaultUILanguage",
    "NtSetDefaultLocale",
    "NtSetDefaultHardErrorPort",
    "NtSetDebugFilterState",
    "NtSetContextThread",
    "NtSetCachedSigningLevel",
    "NtSetBootOptions",
    "NtSetBootEntryOrder",
    "NtSerializeBoot",
    "NtSecureConnectPort",
    "NtSaveMergedKeys",
    "NtSaveKeyEx",
    "NtSaveKey",
    "NtRollforwardTransactionManager",
    "NtRollbackTransaction",
    "NtRollbackEnlistment",
    "NtRollbackComplete",
    "NtResumeThread",
    "NtResumeProcess",
    "NtRestoreKey",
    "NtResetWriteWatch",
    "NtResetEvent",
    "NtRequestWaitReplyPort",
    "NtRequestPort",
    "NtReplyWaitReplyPort",
    "NtReplyWaitReceivePortEx",
    "NtReplyWaitReceivePort",
    "NtReplyPort",
    "NtReplacePartitionUnit",
    "NtReplaceKey",
    "NtRenameTransactionManager",
    "NtRenameKey",
    "NtRemoveProcessDebug",
    "NtRemoveIoCompletionEx",
    "NtRemoveIoCompletion",
    "NtReleaseWorkerFactoryWorker",
    "NtReleaseSemaphore",
    "NtReleaseMutant",
    "NtReleaseKeyedEvent",
    "NtRegisterThreadTerminatePort",
    "NtRegisterProtocolAddressInformation",
    "NtRecoverTransactionManager",
    "NtRecoverResourceManager",
    "NtRecoverEnlistment",
    "NtReadVirtualMemory",
    "NtReadRequestData",
    "NtReadOnlyEnlistment",
    "NtReadFileScatter",
    "NtReadFile",
    "NtRaiseHardError",
    "NtRaiseException",
    "NtQueueApcThreadEx",
    "NtQueueApcThread",
    "NtQueryWnfStateData",
    "NtQueryWnfStateNameInformation",
    "NtQueryVolumeInformationFile",
    "NtQueryVirtualMemory",
    "NtQueryValueKey",
    "NtQueryTimerResolution",
    "NtQueryTimer",
    "NtQuerySystemTime",
    "NtQuerySystemInformationEx",
    "NtQuerySystemInformation",
    "NtQuerySystemEnvironmentValueEx",
    "NtQuerySystemEnvironmentValue",
    "NtQuerySymbolicLinkObject",
    "NtQuerySemaphore",
    "NtQuerySecurityObject",
    "NtQuerySecurityAttributesToken",
    "NtQuerySection",
    "NtQueryQuotaInformationFile",
    "NtQueryPortInformationProcess",
    "NtQueryPerformanceCounter",
    "NtQueryOpenSubKeysEx",
    "NtQueryOpenSubKeys",
    "NtQueryObject",
    "NtQueryMutant",
    "NtQueryMultipleValueKey",
    "NtQueryLicenseValue",
    "NtQueryKey",
    "NtQueryIoCompletion",
    "NtQueryIntervalProfile",
    "NtQueryInstallUILanguage",
    "NtQueryInformationWorkerFactory",
    "NtQueryInformationTransactionManager",
    "NtQueryInformationTransaction",
    "NtQueryInformationToken",
    "NtQueryInformationThread",
    "NtQueryInformationResourceManager",
    "NtQueryInformationProcess",
    "NtQueryInformationPort",
    "NtQueryInformationJobObject",
    "NtQueryInformationFile",
    "NtQueryInformationEnlistment",
    "NtQueryInformationAtom",
    "NtQueryFullAttributesFile",
    "NtQueryEvent",
    "NtQueryEaFile",
    "NtQueryDriverEntryOrder",
    "NtQueryDirectoryObject",
    "NtQueryDirectoryFile",
    "NtQueryDefaultUILanguage",
    "NtQueryDefaultLocale",
    "NtQueryDebugFilterState",
    "NtQueryBootOptions",
    "NtQueryBootEntryOrder",
    "NtQueryAttributesFile",
    "NtPulseEvent",
    "NtProtectVirtualMemory",
    "NtPropagationFailed",
    "NtPropagationComplete",
    "NtPrivilegeObjectAuditAlarm",
    "NtPrivilegedServiceAuditAlarm",
    "NtPrivilegeCheck",
    "NtSetInformationVirtualMemory",
    "NtPrePrepareEnlistment",
    "NtPrePrepareComplete",
    "NtPrepareEnlistment",
    "NtPrepareComplete",
    "NtPowerInformation",
    "NtPlugPlayControl",
    "NtOpenTransactionManager",
    "NtOpenTransaction",
    "NtOpenTimer",
    "NtOpenThreadTokenEx",
    "NtOpenThreadToken",
    "NtOpenThread",
    "NtOpenSymbolicLinkObject",
    "NtOpenSession",
    "NtOpenSemaphore",
    "NtOpenSection",
    "NtOpenResourceManager",
    "NtOpenProcessTokenEx",
    "NtOpenProcessToken",
    "NtOpenProcess",
    "NtOpenPrivateNamespace",
    "NtOpenObjectAuditAlarm",
    "NtOpenMutant",
    "NtOpenKeyTransactedEx",
    "NtOpenKeyTransacted",
    "NtOpenKeyEx",
    "NtOpenKeyedEvent",
    "NtOpenKey",
    "NtOpenJobObject",
    "NtOpenIoCompletion",
    "NtOpenFile",
    "NtCreateEventPair",
    "NtOpenEvent",
    "NtOpenEnlistment",
    "NtOpenDirectoryObject",
    "NtNotifyChangeSession",
    "NtNotifyChangeMultipleKeys",
    "NtNotifyChangeKey",
    "NtNotifyChangeDirectoryFile",
    "NtModifyDriverEntry",
    "NtModifyBootEntry",
    "NtMapViewOfSection",
    "NtMapUserPhysicalPagesScatter",
    "NtMapUserPhysicalPages",
    "NtMapCMFModule",
    "NtMakeTemporaryObject",
    "NtMakePermanentObject",
    "NtLockVirtualMemory",
    "NtLockRegistryKey",
    "NtLockProductActivationKeys",
    "NtLockFile",
    "NtLoadKeyEx",
    "NtLoadKey2",
    "NtLoadKey",
    "NtLoadDriver",
    "NtListenPort",
    "NtIsUILanguageComitted",
    "NtIsSystemResumeAutomatic",
    "NtIsProcessInJob",
    "NtInitiatePowerAction",
    "NtInitializeRegistry",
    "NtInitializeNlsFiles",
    "NtImpersonateThread",
    "NtImpersonateClientOfPort",
    "NtImpersonateAnonymousToken",
    "NtGetWriteWatch",
    "NtGetNotificationResourceManager",
    "NtGetNlsSectionPtr",
    "NtGetNextThread",
    "NtGetNextProcess",
    "NtGetMUIRegistryInfo",
    "NtGetDevicePowerState",
    "NtGetCurrentProcessorNumber",
    "NtGetContextThread",
    "NtGetCompleteWnfStateSubscription",
    "NtGetCachedSigningLevel",
    "NtFsControlFile",
    "NtFreezeTransactions",
    "NtFreezeRegistry",
    "NtFreeVirtualMemory",
    "NtFreeUserPhysicalPages",
    "NtFlushWriteBuffer",
    "NtFlushVirtualMemory",
    "NtFlushProcessWriteBuffers",
    "NtFlushKey",
    "FsRtlSyncVolumes",
    "NtFlushInstallUILanguage",
    "NtFlushBuffersFile",
    "NtFlushBuffersFileEx",
    "NtFindAtom",
    "NtFilterToken",
    "NtFilterTokenEx",
    "NtFilterBootOption",
    "NtExtendSection",
    "NtEnumerateValueKey",
    "NtEnumerateTransactionObject",
    "NtEnumerateSystemEnvironmentValuesEx",
    "NtEnumerateKey",
    "NtEnumerateDriverEntries",
    "NtEnumerateBootEntries",
    "NtEnableLastKnownGood",
    "NtDuplicateToken",
    "NtDuplicateObject",
    "NtDrawText",
    "NtDisplayString",
    "NtDisableLastKnownGood",
    "NtDeviceIoControlFile",
    "NtDeleteWnfStateName",
    "NtDeleteWnfStateData",
    "NtDeleteValueKey",
    "NtDeletePrivateNamespace",
    "NtDeleteObjectAuditAlarm",
    "NtDeleteKey",
    "NtDeleteFile",
    "NtDeleteDriverEntry",
    "NtDeleteBootEntry",
    "NtDeleteAtom",
    "NtDelayExecution",
    "NtDebugContinue",
    "NtDebugActiveProcess",
    "NtCreateWorkerFactory",
    "NtCreateWnfStateName",
    "NtCreateWaitCompletionPacket",
    "NtCreateWaitablePort",
    "NtCreateUserProcess",
    "NtCreateTransactionManager",
    "NtCreateTransaction",
    "NtCreateToken",
    "NtCreateLowBoxToken",
    "NtCreateTokenEx",
    "NtCreateTimer",
    "NtCreateThreadEx",
    "NtCreateThread",
    "NtCreateSymbolicLinkObject",
    "NtCreateSemaphore",
    "NtCreateSection",
    "NtCreateResourceManager",
    "NtCreateProfileEx",
    "NtCreateProfile",
    "NtCreateProcessEx",
    "NtCreateProcess",
    "NtCreatePrivateNamespace",
    "NtCreatePort",
    "NtCreatePagingFile",
    "NtCreateNamedPipeFile",
    "NtCreateMutant",
    "NtCreateMailslotFile",
    "NtCreateKeyTransacted",
    "NtCreateKeyedEvent",
    "NtCreateKey",
    "NtCreateJobSet",
    "NtCreateJobObject",
    "NtCreateIRTimer",
    "NtCreateTimer2",
    "NtCreateIoCompletion",
    "NtCreateFile",
    "NtCreateEventPair",
    "NtCreateEvent",
    "NtCreateEnlistment",
    "NtCreateDirectoryObjectEx",
    "NtCreateDirectoryObject",
    "NtCreateDebugObject",
    "NtContinue",
    "NtConnectPort",
    "NtCompressKey",
    "NtCompleteConnectPort",
    "NtCompareTokens",
    "NtCompactKeys",
    "NtCommitTransaction",
    "NtCommitEnlistment",
    "NtCommitComplete",
    "NtCloseObjectAuditAlarm",
    "NtClose",
    "NtClearEvent",
    "NtCancelWaitCompletionPacket",
    "NtCancelTimer",
    "NtCancelSynchronousIoFile",
    "NtCancelIoFileEx",
    "NtCancelIoFile",
    "NtCallbackReturn",
    "NtAssociateWaitCompletionPacket",
    "NtAssignProcessToJobObject",
    "NtAreMappedFilesTheSame",
    "NtApphelpCacheControl",
    "NtAlpcSetInformation",
    "NtAlpcSendWaitReceivePort",
    "NtAlpcRevokeSecurityContext",
    "NtAlpcQueryInformationMessage",
    "NtAlpcQueryInformation",
    "NtAlpcOpenSenderThread",
    "NtAlpcOpenSenderProcess",
    "NtAlpcImpersonateClientOfPort",
    "NtAlpcDisconnectPort",
    "NtAlpcDeleteSecurityContext",
    "NtAlpcDeleteSectionView",
    "NtAlpcDeleteResourceReserve",
    "NtAlpcDeletePortSection",
    "NtAlpcCreateSecurityContext",
    "NtAlpcCreateSectionView",
    "NtAlpcCreateResourceReserve",
    "NtAlpcCreatePortSection",
    "NtAlpcCreatePort",
    "NtAlpcConnectPort",
    "NtAlpcConnectPortEx",
    "NtAlpcCancelMessage",
    "NtAlpcAcceptConnectPort",
    "NtAllocateVirtualMemory",
    "NtAllocateUuids",
    "NtAllocateUserPhysicalPages",
    "NtAllocateReserveObject",
    "NtAllocateLocallyUniqueId",
    "NtAlertThreadByThreadId",
    "NtAlertThread",
    "NtAlertResumeThread",
    "NtAdjustPrivilegesToken",
    "NtAdjustGroupsToken",
    "NtAdjustTokenClaimsAndDeviceGroups",
    "NtAddDriverEntry",
    "NtAddBootEntry",
    "NtAddAtom",
    "NtAddAtomEx",
    "NtAccessCheckByTypeResultListAndAuditAlarmByHandle",
    "NtAccessCheckByTypeResultListAndAuditAlarm",
    "NtAccessCheckByTypeResultList",
    "NtAccessCheckByTypeAndAuditAlarm",
    "NtAccessCheckByType",
    "NtAccessCheckAndAuditAlarm",
    "NtAccessCheck"
};

//////////////////////////////////////////////////////////////////////////
// Windows 10 SP0 _KiServiceTable
//////////////////////////////////////////////////////////////////////////
static const char* KiServiceTable_Win10Th1_x86[] = {
    "NtAccessCheck",
    "NtWorkerFactoryWorkerReady",
    "NtAcceptConnectPort",
    "NtYieldExecution",
    "NtWriteVirtualMemory",
    "NtWriteRequestData",
    "NtWriteFileGather",
    "NtWriteFile",
    "NtSetHighEventPair",
    "NtSetHighEventPair",
    "NtWaitForWorkViaWorkerFactory",
    "NtWaitForSingleObject",
    "NtWaitForMultipleObjects32",
    "NtWaitForMultipleObjects",
    "NtWaitForKeyedEvent",
    "NtWaitForDebugEvent",
    "NtWaitForAlertByThreadId",
    "NtVdmControl",
    "NtUnsubscribeWnfStateChange",
    "NtUpdateWnfStateData",
    "NtUnmapViewOfSection",
    "NtUnmapViewOfSectionEx",
    "NtUnlockVirtualMemory",
    "NtUnlockFile",
    "NtUnloadKeyEx",
    "NtUnloadKey2",
    "NtUnloadKey",
    "NtUnloadDriver",
    "NtUmsThreadYield",
    "NtTranslateFilePath",
    "NtTraceEvent",
    "NtTraceControl",
    "NtThawTransactions",
    "NtThawRegistry",
    "NtTestAlert",
    "NtTerminateThread",
    "NtTerminateProcess",
    "NtTerminateJobObject",
    "NtSystemDebugControl",
    "NtSuspendThread",
    "NtSuspendProcess",
    "NtSubscribeWnfStateChange",
    "NtStopProfile",
    "NtStartProfile",
    "NtSinglePhaseReject",
    "NtSignalAndWaitForSingleObject",
    "NtShutdownWorkerFactory",
    "NtShutdownSystem",
    "NtSetWnfProcessNotificationEvent",
    "NtSetVolumeInformationFile",
    "NtSetValueKey",
    "NtSetUuidSeed",
    "NtSetTimerResolution",
    "NtSetTimerEx",
    "NtSetTimer",
    "NtSetThreadExecutionState",
    "NtSetSystemTime",
    "NtSetSystemPowerState",
    "NtSetSystemInformation",
    "NtSetSystemEnvironmentValueEx",
    "NtSetSystemEnvironmentValue",
    "NtSetSecurityObject",
    "NtSetQuotaInformationFile",
    "NtSetHighEventPair",
    "NtSetHighEventPair",
    "NtSetLdtEntries",
    "NtSetIRTimer",
    "NtSetTimer2",
    "NtCancelTimer2",
    "NtSetIoCompletionEx",
    "NtSetIoCompletion",
    "NtSetIntervalProfile",
    "NtSetInformationWorkerFactory",
    "NtSetInformationTransactionManager",
    "NtSetInformationTransaction",
    "NtSetInformationToken",
    "NtSetInformationThread",
    "NtSetInformationResourceManager",
    "NtSetInformationProcess",
    "NtSetInformationObject",
    "NtSetInformationKey",
    "NtSetInformationJobObject",
    "NtSetInformationFile",
    "NtSetInformationEnlistment",
    "NtSetInformationDebugObject",
    "NtSetHighEventPair",
    "NtSetHighEventPair",
    "NtSetEventBoostPriority",
    "NtSetEvent",
    "NtSetEaFile",
    "NtSetDriverEntryOrder",
    "NtSetDefaultUILanguage",
    "NtSetDefaultLocale",
    "NtSetDefaultHardErrorPort",
    "NtSetDebugFilterState",
    "NtSetContextThread",
    "NtSetCachedSigningLevel",
    "NtSetBootOptions",
    "NtSetBootEntryOrder",
    "NtSerializeBoot",
    "NtSecureConnectPort",
    "NtSaveMergedKeys",
    "NtSaveKeyEx",
    "NtSaveKey",
    "NtRollforwardTransactionManager",
    "NtRollbackTransaction",
    "NtRollbackEnlistment",
    "NtRollbackComplete",
    "NtRevertContainerImpersonation",
    "NtResumeThread",
    "NtResumeProcess",
    "NtRestoreKey",
    "NtResetWriteWatch",
    "NtResetEvent",
    "NtRequestWaitReplyPort",
    "NtRequestPort",
    "NtReplyWaitReplyPort",
    "NtReplyWaitReceivePortEx",
    "NtReplyWaitReceivePort",
    "NtReplyPort",
    "NtReplacePartitionUnit",
    "NtReplaceKey",
    "NtRenameTransactionManager",
    "NtRenameKey",
    "NtRemoveProcessDebug",
    "NtRemoveIoCompletionEx",
    "NtRemoveIoCompletion",
    "NtReleaseWorkerFactoryWorker",
    "NtReleaseSemaphore",
    "NtReleaseMutant",
    "NtReleaseKeyedEvent",
    "NtRegisterThreadTerminatePort",
    "NtRegisterProtocolAddressInformation",
    "NtRecoverTransactionManager",
    "NtRecoverResourceManager",
    "NtRecoverEnlistment",
    "NtReadVirtualMemory",
    "NtReadRequestData",
    "NtReadOnlyEnlistment",
    "NtReadFileScatter",
    "NtReadFile",
    "NtRaiseHardError",
    "NtRaiseException",
    "NtQueueApcThreadEx",
    "NtQueueApcThread",
    "NtQueryWnfStateData",
    "NtQueryWnfStateNameInformation",
    "NtQueryVolumeInformationFile",
    "NtQueryVirtualMemory",
    "NtQueryValueKey",
    "NtQueryTimerResolution",
    "NtQueryTimer",
    "NtQuerySystemTime",
    "NtQuerySystemInformationEx",
    "NtQuerySystemInformation",
    "NtQuerySystemEnvironmentValueEx",
    "NtQuerySystemEnvironmentValue",
    "NtQuerySymbolicLinkObject",
    "NtQuerySemaphore",
    "NtQuerySecurityObject",
    "NtQuerySecurityAttributesToken",
    "NtQuerySection",
    "NtQueryQuotaInformationFile",
    "NtQueryPortInformationProcess",
    "NtQueryPerformanceCounter",
    "NtQueryOpenSubKeysEx",
    "NtQueryOpenSubKeys",
    "NtQueryObject",
    "NtQueryMutant",
    "NtQueryMultipleValueKey",
    "NtQueryLicenseValue",
    "NtQueryKey",
    "NtQueryIoCompletion",
    "NtQueryIntervalProfile",
    "NtQueryInstallUILanguage",
    "NtQueryInformationWorkerFactory",
    "NtQueryInformationTransactionManager",
    "NtQueryInformationTransaction",
    "NtQueryInformationToken",
    "NtQueryInformationThread",
    "NtQueryInformationResourceManager",
    "NtQueryInformationProcess",
    "NtQueryInformationPort",
    "NtQueryInformationJobObject",
    "NtQueryInformationFile",
    "NtQueryInformationEnlistment",
    "NtQueryInformationAtom",
    "NtQueryFullAttributesFile",
    "NtQueryEvent",
    "NtQueryEaFile",
    "NtQueryDriverEntryOrder",
    "NtQueryDirectoryObject",
    "NtQueryDirectoryFile",
    "NtQueryDefaultUILanguage",
    "NtQueryDefaultLocale",
    "NtQueryDebugFilterState",
    "NtQueryBootOptions",
    "NtQueryBootEntryOrder",
    "NtQueryAttributesFile",
    "NtPulseEvent",
    "NtProtectVirtualMemory",
    "NtPropagationFailed",
    "NtPropagationComplete",
    "NtPrivilegeObjectAuditAlarm",
    "NtPrivilegedServiceAuditAlarm",
    "NtPrivilegeCheck",
    "NtSetInformationVirtualMemory",
    "NtPrePrepareEnlistment",
    "NtPrePrepareComplete",
    "NtPrepareEnlistment",
    "NtPrepareComplete",
    "NtPowerInformation",
    "NtPlugPlayControl",
    "NtOpenTransactionManager",
    "NtOpenTransaction",
    "NtOpenTimer",
    "NtOpenThreadTokenEx",
    "NtOpenThreadToken",
    "NtOpenThread",
    "NtOpenSymbolicLinkObject",
    "NtOpenSession",
    "NtOpenSemaphore",
    "NtOpenSection",
    "NtOpenResourceManager",
    "NtCreateJobSet",
    "NtOpenProcessTokenEx",
    "NtOpenProcessToken",
    "NtOpenProcess",
    "NtOpenPrivateNamespace",
    "NtOpenObjectAuditAlarm",
    "NtOpenMutant",
    "NtOpenKeyTransactedEx",
    "NtOpenKeyTransacted",
    "NtOpenKeyEx",
    "NtOpenKeyedEvent",
    "NtOpenKey",
    "NtOpenJobObject",
    "NtOpenIoCompletion",
    "NtOpenFile",
    "NtCreateEventPair",
    "NtOpenEvent",
    "NtOpenEnlistment",
    "NtOpenDirectoryObject",
    "NtNotifyChangeSession",
    "NtNotifyChangeMultipleKeys",
    "NtNotifyChangeKey",
    "NtNotifyChangeDirectoryFile",
    "NtCreatePartition",
    "NtModifyDriverEntry",
    "NtModifyBootEntry",
    "NtMapViewOfSection",
    "NtMapUserPhysicalPagesScatter",
    "NtMapUserPhysicalPages",
    "NtMapCMFModule",
    "NtMakeTemporaryObject",
    "NtMakePermanentObject",
    "NtLockVirtualMemory",
    "NtLockRegistryKey",
    "NtLockProductActivationKeys",
    "NtLockFile",
    "NtLoadKeyEx",
    "NtLoadKey2",
    "NtLoadKey",
    "NtLoadDriver",
    "NtListenPort",
    "NtIsUILanguageComitted",
    "NtIsSystemResumeAutomatic",
    "NtIsProcessInJob",
    "NtInitiatePowerAction",
    "NtInitializeRegistry",
    "NtInitializeNlsFiles",
    "NtImpersonateThread",
    "NtImpersonateClientOfPort",
    "NtImpersonateAnonymousToken",
    "NtGetWriteWatch",
    "NtGetNotificationResourceManager",
    "NtGetNlsSectionPtr",
    "NtGetNextThread",
    "NtGetNextProcess",
    "NtGetMUIRegistryInfo",
    "NtGetDevicePowerState",
    "NtGetCurrentProcessorNumberEx",
    "NtGetCurrentProcessorNumber",
    "NtGetContextThread",
    "NtGetCompleteWnfStateSubscription",
    "NtGetCachedSigningLevel",
    "NtFsControlFile",
    "NtFreezeTransactions",
    "NtFreezeRegistry",
    "NtFreeVirtualMemory",
    "NtFreeUserPhysicalPages",
    "NtFlushWriteBuffer",
    "NtFlushVirtualMemory",
    "NtFlushProcessWriteBuffers",
    "NtFlushKey",
    "FsRtlSyncVolumes",
    "NtFlushInstallUILanguage",
    "NtFlushBuffersFile",
    "NtFlushBuffersFileEx",
    "NtFindAtom",
    "NtFilterToken",
    "NtFilterTokenEx",
    "NtFilterBootOption",
    "NtExtendSection",
    "NtEnumerateValueKey",
    "NtEnumerateTransactionObject",
    "NtEnumerateSystemEnvironmentValuesEx",
    "NtEnumerateKey",
    "NtEnumerateDriverEntries",
    "NtEnumerateBootEntries",
    "NtEnableLastKnownGood",
    "NtDuplicateToken",
    "NtDuplicateObject",
    "NtDrawText",
    "NtDisplayString",
    "NtDisableLastKnownGood",
    "NtDeviceIoControlFile",
    "NtDeleteWnfStateName",
    "NtDeleteWnfStateData",
    "NtDeleteValueKey",
    "NtDeletePrivateNamespace",
    "NtDeleteObjectAuditAlarm",
    "NtDeleteKey",
    "NtDeleteFile",
    "NtDeleteDriverEntry",
    "NtDeleteBootEntry",
    "NtDeleteAtom",
    "NtDelayExecution",
    "NtDebugContinue",
    "NtDebugActiveProcess",
    "NtCreatePartition",
    "NtCreateWorkerFactory",
    "NtCreateWnfStateName",
    "NtCreateWaitCompletionPacket",
    "NtCreateWaitablePort",
    "NtCreateUserProcess",
    "NtCreateTransactionManager",
    "NtCreateTransaction",
    "NtCreateToken",
    "NtCreateLowBoxToken",
    "NtCreateTokenEx",
    "NtCreateTimer",
    "NtCreateThreadEx",
    "NtCreateThread",
    "NtCreateSymbolicLinkObject",
    "NtCreateSemaphore",
    "NtCreateSection",
    "NtCreateResourceManager",
    "NtCreateProfileEx",
    "NtCreateProfile",
    "NtCreateProcessEx",
    "NtCreateProcess",
    "NtCreatePrivateNamespace",
    "NtCreatePort",
    "NtCreatePagingFile",
    "NtCreateNamedPipeFile",
    "NtCreateMutant",
    "NtCreateMailslotFile",
    "NtCreateKeyTransacted",
    "NtCreateKeyedEvent",
    "NtCreateKey",
    "NtCreateJobSet",
    "NtCreateJobObject",
    "NtCreateIRTimer",
    "NtCreateTimer2",
    "NtCreateIoCompletion",
    "NtCreateFile",
    "NtCreateEventPair",
    "NtCreateEvent",
    "NtCreateEnlistment",
    "NtCreateDirectoryObjectEx",
    "NtCreateDirectoryObject",
    "NtCreateDebugObject",
    "NtContinue",
    "NtConnectPort",
    "NtCompressKey",
    "NtCompleteConnectPort",
    "NtCompareTokens",
    "NtCompareObjects",
    "NtCompactKeys",
    "NtCommitTransaction",
    "NtCommitEnlistment",
    "NtCommitComplete",
    "NtCloseObjectAuditAlarm",
    "NtClose",
    "NtClearEvent",
    "NtCancelWaitCompletionPacket",
    "NtCancelTimer",
    "NtCancelSynchronousIoFile",
    "NtCancelIoFileEx",
    "NtCancelIoFile",
    "NtCallbackReturn",
    "NtAssociateWaitCompletionPacket",
    "NtAssignProcessToJobObject",
    "NtAreMappedFilesTheSame",
    "NtApphelpCacheControl",
    "NtAlpcSetInformation",
    "NtAlpcSendWaitReceivePort",
    "NtAlpcRevokeSecurityContext",
    "NtAlpcQueryInformationMessage",
    "NtAlpcQueryInformation",
    "NtAlpcOpenSenderThread",
    "NtAlpcOpenSenderProcess",
    "NtAlpcImpersonateClientOfPort",
    "NtAlpcImpersonateClientContainerOfPort",
    "NtAlpcDisconnectPort",
    "NtAlpcDeleteSecurityContext",
    "NtAlpcDeleteSectionView",
    "NtAlpcDeleteResourceReserve",
    "NtAlpcDeletePortSection",
    "NtAlpcCreateSecurityContext",
    "NtAlpcCreateSectionView",
    "NtAlpcCreateResourceReserve",
    "NtAlpcCreatePortSection",
    "NtAlpcCreatePort",
    "NtAlpcConnectPort",
    "NtAlpcConnectPortEx",
    "NtAlpcCancelMessage",
    "NtAlpcAcceptConnectPort",
    "NtAllocateVirtualMemory",
    "NtAllocateUuids",
    "NtAllocateUserPhysicalPages",
    "NtAllocateReserveObject",
    "NtAllocateLocallyUniqueId",
    "NtAlertThreadByThreadId",
    "NtAlertThread",
    "NtAlertResumeThread",
    "NtAdjustPrivilegesToken",
    "NtAdjustGroupsToken",
    "NtAdjustTokenClaimsAndDeviceGroups",
    "NtAddDriverEntry",
    "NtAddBootEntry",
    "NtAddAtom",
    "NtAddAtomEx",
    "NtAccessCheckByTypeResultListAndAuditAlarmByHandle",
    "NtAccessCheckByTypeResultListAndAuditAlarm",
    "NtAccessCheckByTypeResultList",
    "NtAccessCheckByTypeAndAuditAlarm",
    "NtAccessCheckByType",
    "NtAccessCheckAndAuditAlarm",
    "NtSetInformationSymbolicLink"
};

//////////////////////////////////////////////////////////////////////////
// Windows 10 TH2 _KiServiceTable
//////////////////////////////////////////////////////////////////////////
static const char* KiServiceTable_Win10Th2_x86[] = {
    "NtAccessCheck",
    "NtWorkerFactoryWorkerReady",
    "NtAcceptConnectPort",
    "NtYieldExecution",
    "NtWriteVirtualMemory",
    "NtWriteRequestData",
    "NtWriteFileGather",
    "NtWriteFile",
    "NtSetHighEventPair",
    "NtSetHighEventPair",
    "NtWaitForWorkViaWorkerFactory",
    "NtWaitForSingleObject",
    "NtWaitForMultipleObjects32",
    "NtWaitForMultipleObjects",
    "NtWaitForKeyedEvent",
    "NtWaitForDebugEvent",
    "NtWaitForAlertByThreadId",
    "NtVdmControl",
    "NtUnsubscribeWnfStateChange",
    "NtUpdateWnfStateData",
    "NtUnmapViewOfSection",
    "NtUnmapViewOfSectionEx",
    "NtUnlockVirtualMemory",
    "NtUnlockFile",
    "NtUnloadKeyEx",
    "NtUnloadKey2",
    "NtUnloadKey",
    "NtUnloadDriver",
    "NtUmsThreadYield",
    "NtTranslateFilePath",
    "NtTraceEvent",
    "NtTraceControl",
    "NtThawTransactions",
    "NtThawRegistry",
    "NtTestAlert",
    "NtTerminateThread",
    "NtTerminateProcess",
    "NtTerminateJobObject",
    "NtSystemDebugControl",
    "NtSuspendThread",
    "NtSuspendProcess",
    "NtSubscribeWnfStateChange",
    "NtStopProfile",
    "NtStartProfile",
    "NtSinglePhaseReject",
    "NtSignalAndWaitForSingleObject",
    "NtShutdownWorkerFactory",
    "NtShutdownSystem",
    "NtSetWnfProcessNotificationEvent",
    "NtSetVolumeInformationFile",
    "NtSetValueKey",
    "NtSetUuidSeed",
    "NtSetTimerResolution",
    "NtSetTimerEx",
    "NtSetTimer",
    "NtSetThreadExecutionState",
    "NtSetSystemTime",
    "NtSetSystemPowerState",
    "NtSetSystemInformation",
    "NtSetSystemEnvironmentValueEx",
    "NtSetSystemEnvironmentValue",
    "NtSetSecurityObject",
    "NtSetQuotaInformationFile",
    "NtSetHighEventPair",
    "NtSetHighEventPair",
    "NtSetLdtEntries",
    "NtSetIRTimer",
    "NtSetTimer2",
    "NtCancelTimer2",
    "NtSetIoCompletionEx",
    "NtSetIoCompletion",
    "NtSetIntervalProfile",
    "NtSetInformationWorkerFactory",
    "NtSetInformationTransactionManager",
    "NtSetInformationTransaction",
    "NtSetInformationToken",
    "NtSetInformationThread",
    "NtSetInformationResourceManager",
    "NtSetInformationProcess",
    "NtSetInformationObject",
    "NtSetInformationKey",
    "NtSetInformationJobObject",
    "NtSetInformationFile",
    "NtSetInformationEnlistment",
    "NtSetInformationDebugObject",
    "NtSetHighEventPair",
    "NtSetHighEventPair",
    "NtSetEventBoostPriority",
    "NtSetEvent",
    "NtSetEaFile",
    "NtSetDriverEntryOrder",
    "NtSetDefaultUILanguage",
    "NtSetDefaultLocale",
    "NtSetDefaultHardErrorPort",
    "NtSetDebugFilterState",
    "NtSetContextThread",
    "NtSetCachedSigningLevel",
    "NtSetBootOptions",
    "NtSetBootEntryOrder",
    "NtSerializeBoot",
    "NtSecureConnectPort",
    "NtSaveMergedKeys",
    "NtSaveKeyEx",
    "NtSaveKey",
    "NtRollforwardTransactionManager",
    "NtRollbackTransaction",
    "NtRollbackEnlistment",
    "NtRollbackComplete",
    "NtRevertContainerImpersonation",
    "NtResumeThread",
    "NtResumeProcess",
    "NtRestoreKey",
    "NtResetWriteWatch",
    "NtResetEvent",
    "NtRequestWaitReplyPort",
    "NtRequestPort",
    "NtReplyWaitReplyPort",
    "NtReplyWaitReceivePortEx",
    "NtReplyWaitReceivePort",
    "NtReplyPort",
    "NtReplacePartitionUnit",
    "NtReplaceKey",
    "NtRenameTransactionManager",
    "NtRenameKey",
    "NtRemoveProcessDebug",
    "NtRemoveIoCompletionEx",
    "NtRemoveIoCompletion",
    "NtReleaseWorkerFactoryWorker",
    "NtReleaseSemaphore",
    "NtReleaseMutant",
    "NtReleaseKeyedEvent",
    "NtRegisterThreadTerminatePort",
    "NtRegisterProtocolAddressInformation",
    "NtRecoverTransactionManager",
    "NtRecoverResourceManager",
    "NtRecoverEnlistment",
    "NtReadVirtualMemory",
    "NtReadRequestData",
    "NtReadOnlyEnlistment",
    "NtReadFileScatter",
    "NtReadFile",
    "NtRaiseHardError",
    "NtRaiseException",
    "NtQueueApcThreadEx",
    "NtQueueApcThread",
    "NtQueryWnfStateData",
    "NtQueryWnfStateNameInformation",
    "NtQueryVolumeInformationFile",
    "NtQueryVirtualMemory",
    "NtQueryValueKey",
    "NtQueryTimerResolution",
    "NtQueryTimer",
    "NtQuerySystemTime",
    "NtQuerySystemInformationEx",
    "NtQuerySystemInformation",
    "NtQuerySystemEnvironmentValueEx",
    "NtQuerySystemEnvironmentValue",
    "NtQuerySymbolicLinkObject",
    "NtQuerySemaphore",
    "NtQuerySecurityObject",
    "NtQuerySecurityAttributesToken",
    "NtQuerySection",
    "NtQueryQuotaInformationFile",
    "NtQueryPortInformationProcess",
    "NtQueryPerformanceCounter",
    "NtQueryOpenSubKeysEx",
    "NtQueryOpenSubKeys",
    "NtQueryObject",
    "NtQueryMutant",
    "NtQueryMultipleValueKey",
    "NtQueryLicenseValue",
    "NtQueryKey",
    "NtQueryIoCompletion",
    "NtQueryIntervalProfile",
    "NtQueryInstallUILanguage",
    "NtQueryInformationWorkerFactory",
    "NtQueryInformationTransactionManager",
    "NtQueryInformationTransaction",
    "NtQueryInformationToken",
    "NtQueryInformationThread",
    "NtQueryInformationResourceManager",
    "NtQueryInformationProcess",
    "NtQueryInformationPort",
    "NtQueryInformationJobObject",
    "NtQueryInformationFile",
    "NtQueryInformationEnlistment",
    "NtQueryInformationAtom",
    "NtQueryFullAttributesFile",
    "NtQueryEvent",
    "NtQueryEaFile",
    "NtQueryDriverEntryOrder",
    "NtQueryDirectoryObject",
    "NtQueryDirectoryFile",
    "NtQueryDefaultUILanguage",
    "NtQueryDefaultLocale",
    "NtQueryDebugFilterState",
    "NtQueryBootOptions",
    "NtQueryBootEntryOrder",
    "NtQueryAttributesFile",
    "NtPulseEvent",
    "NtProtectVirtualMemory",
    "NtPropagationFailed",
    "NtPropagationComplete",
    "NtPrivilegeObjectAuditAlarm",
    "NtPrivilegedServiceAuditAlarm",
    "NtPrivilegeCheck",
    "NtSetInformationVirtualMemory",
    "NtPrePrepareEnlistment",
    "NtPrePrepareComplete",
    "NtPrepareEnlistment",
    "NtPrepareComplete",
    "NtPowerInformation",
    "NtPlugPlayControl",
    "NtOpenTransactionManager",
    "NtOpenTransaction",
    "NtOpenTimer",
    "NtOpenThreadTokenEx",
    "NtOpenThreadToken",
    "NtOpenThread",
    "NtOpenSymbolicLinkObject",
    "NtOpenSession",
    "NtOpenSemaphore",
    "NtOpenSection",
    "NtOpenResourceManager",
    "NtCreateJobSet",
    "NtOpenProcessTokenEx",
    "NtOpenProcessToken",
    "NtOpenProcess",
    "NtOpenPrivateNamespace",
    "NtOpenObjectAuditAlarm",
    "NtOpenMutant",
    "NtOpenKeyTransactedEx",
    "NtOpenKeyTransacted",
    "NtOpenKeyEx",
    "NtOpenKeyedEvent",
    "NtOpenKey",
    "NtOpenJobObject",
    "NtOpenIoCompletion",
    "NtOpenFile",
    "NtCreateEventPair",
    "NtOpenEvent",
    "NtOpenEnlistment",
    "NtOpenDirectoryObject",
    "NtNotifyChangeSession",
    "NtNotifyChangeMultipleKeys",
    "NtNotifyChangeKey",
    "NtNotifyChangeDirectoryFile",
    "NtManagePartition",
    "NtModifyDriverEntry",
    "NtModifyBootEntry",
    "NtMapViewOfSection",
    "NtMapUserPhysicalPagesScatter",
    "NtMapUserPhysicalPages",
    "NtMapCMFModule",
    "NtMakeTemporaryObject",
    "NtMakePermanentObject",
    "NtLockVirtualMemory",
    "NtLockRegistryKey",
    "NtLockProductActivationKeys",
    "NtLockFile",
    "NtLoadKeyEx",
    "NtLoadKey2",
    "NtLoadKey",
    "NtLoadEnclaveData",
    "NtLoadDriver",
    "NtListenPort",
    "NtIsUILanguageComitted",
    "NtIsSystemResumeAutomatic",
    "NtIsProcessInJob",
    "NtInitiatePowerAction",
    "NtInitializeRegistry",
    "NtInitializeNlsFiles",
    "NtInitializeEnclave",
    "NtImpersonateThread",
    "NtImpersonateClientOfPort",
    "NtImpersonateAnonymousToken",
    "NtGetWriteWatch",
    "NtGetNotificationResourceManager",
    "NtGetNlsSectionPtr",
    "NtGetNextThread",
    "NtGetNextProcess",
    "NtGetMUIRegistryInfo",
    "NtGetDevicePowerState",
    "NtGetCurrentProcessorNumberEx",
    "NtGetCurrentProcessorNumber",
    "NtGetContextThread",
    "NtGetCompleteWnfStateSubscription",
    "NtGetCachedSigningLevel",
    "NtFsControlFile",
    "NtFreezeTransactions",
    "NtFreezeRegistry",
    "NtFreeVirtualMemory",
    "NtFreeUserPhysicalPages",
    "NtFlushWriteBuffer",
    "NtFlushVirtualMemory",
    "NtFlushProcessWriteBuffers",
    "NtFlushKey",
    "FsRtlSyncVolumes",
    "NtFlushInstallUILanguage",
    "NtFlushBuffersFile",
    "NtFlushBuffersFileEx",
    "NtFindAtom",
    "NtFilterToken",
    "NtFilterTokenEx",
    "NtFilterBootOption",
    "NtExtendSection",
    "NtEnumerateValueKey",
    "NtEnumerateTransactionObject",
    "NtEnumerateSystemEnvironmentValuesEx",
    "NtEnumerateKey",
    "NtEnumerateDriverEntries",
    "NtEnumerateBootEntries",
    "NtEnableLastKnownGood",
    "NtDuplicateToken",
    "NtDuplicateObject",
    "NtDrawText",
    "NtDisplayString",
    "NtDisableLastKnownGood",
    "NtDeviceIoControlFile",
    "NtDeleteWnfStateName",
    "NtDeleteWnfStateData",
    "NtDeleteValueKey",
    "NtDeletePrivateNamespace",
    "NtDeleteObjectAuditAlarm",
    "NtDeleteKey",
    "NtDeleteFile",
    "NtDeleteDriverEntry",
    "NtDeleteBootEntry",
    "NtDeleteAtom",
    "NtDelayExecution",
    "NtDebugContinue",
    "NtDebugActiveProcess",
    "NtCreatePartition",
    "NtCreateWorkerFactory",
    "NtCreateWnfStateName",
    "NtCreateWaitCompletionPacket",
    "NtCreateWaitablePort",
    "NtCreateUserProcess",
    "NtCreateTransactionManager",
    "NtCreateTransaction",
    "NtCreateToken",
    "NtCreateLowBoxToken",
    "NtCreateTokenEx",
    "NtCreateTimer",
    "NtCreateThreadEx",
    "NtCreateThread",
    "NtCreateSymbolicLinkObject",
    "NtCreateSemaphore",
    "NtCreateSection",
    "NtCreateResourceManager",
    "NtCreateProfileEx",
    "NtCreateProfile",
    "NtCreateProcessEx",
    "NtCreateProcess",
    "NtCreatePrivateNamespace",
    "NtCreatePort",
    "NtCreatePagingFile",
    "NtCreateNamedPipeFile",
    "NtCreateMutant",
    "NtCreateMailslotFile",
    "NtCreateKeyTransacted",
    "NtCreateKeyedEvent",
    "NtCreateKey",
    "NtCreateJobSet",
    "NtCreateJobObject",
    "NtCreateIRTimer",
    "NtCreateTimer2",
    "NtCreateIoCompletion",
    "NtCreateFile",
    "NtCreateEventPair",
    "NtCreateEvent",
    "NtCreateEnlistment",
    "NtCreateEnclave",
    "NtCreateDirectoryObjectEx",
    "NtCreateDirectoryObject",
    "NtCreateDebugObject",
    "NtContinue",
    "NtConnectPort",
    "NtCompressKey",
    "NtCompleteConnectPort",
    "NtCompareTokens",
    "NtCompareObjects",
    "NtCompactKeys",
    "NtCommitTransaction",
    "NtCommitEnlistment",
    "NtCommitComplete",
    "NtCloseObjectAuditAlarm",
    "NtClose",
    "NtClearEvent",
    "NtCancelWaitCompletionPacket",
    "NtCancelTimer",
    "NtCancelSynchronousIoFile",
    "NtCancelIoFileEx",
    "NtCancelIoFile",
    "NtCallbackReturn",
    "NtAssociateWaitCompletionPacket",
    "NtAssignProcessToJobObject",
    "NtAreMappedFilesTheSame",
    "NtApphelpCacheControl",
    "NtAlpcSetInformation",
    "NtAlpcSendWaitReceivePort",
    "NtAlpcRevokeSecurityContext",
    "NtAlpcQueryInformationMessage",
    "NtAlpcQueryInformation",
    "NtAlpcOpenSenderThread",
    "NtAlpcOpenSenderProcess",
    "NtAlpcImpersonateClientOfPort",
    "NtAlpcImpersonateClientContainerOfPort",
    "NtAlpcDisconnectPort",
    "NtAlpcDeleteSecurityContext",
    "NtAlpcDeleteSectionView",
    "NtAlpcDeleteResourceReserve",
    "NtAlpcDeletePortSection",
    "NtAlpcCreateSecurityContext",
    "NtAlpcCreateSectionView",
    "NtAlpcCreateResourceReserve",
    "NtAlpcCreatePortSection",
    "NtAlpcCreatePort",
    "NtAlpcConnectPort",
    "NtAlpcConnectPortEx",
    "NtAlpcCancelMessage",
    "NtAlpcAcceptConnectPort",
    "NtAllocateVirtualMemory",
    "NtAllocateUuids",
    "NtAllocateUserPhysicalPages",
    "NtAllocateReserveObject",
    "NtAllocateLocallyUniqueId",
    "NtAlertThreadByThreadId",
    "NtAlertThread",
    "NtAlertResumeThread",
    "NtAdjustPrivilegesToken",
    "NtAdjustGroupsToken",
    "NtAdjustTokenClaimsAndDeviceGroups",
    "NtAddDriverEntry",
    "NtAddBootEntry",
    "NtAddAtom",
    "NtAddAtomEx",
    "NtAccessCheckByTypeResultListAndAuditAlarmByHandle",
    "NtAccessCheckByTypeResultListAndAuditAlarm",
    "NtAccessCheckByTypeResultList",
    "NtAccessCheckByTypeAndAuditAlarm",
    "NtAccessCheckByType",
    "NtAccessCheckAndAuditAlarm",
    "NtSetInformationSymbolicLink"
};

//////////////////////////////////////////////////////////////////////////
// Windows 10 RS1 _KiServiceTable
//////////////////////////////////////////////////////////////////////////
static const char* KiServiceTable_Win10Rs1_x86[] = {
    "NtAccessCheck",
    "NtWorkerFactoryWorkerReady",
    "NtAcceptConnectPort",
    "NtYieldExecution",
    "NtWriteVirtualMemory",
    "NtWriteRequestData",
    "NtWriteFileGather",
    "NtWriteFile",
    "NtSetHighEventPair",
    "NtSetHighEventPair",
    "NtWaitForWorkViaWorkerFactory",
    "NtWaitForSingleObject",
    "NtWaitForMultipleObjects32",
    "NtWaitForMultipleObjects",
    "NtWaitForKeyedEvent",
    "NtWaitForDebugEvent",
    "NtWaitForAlertByThreadId",
    "NtVdmControl",
    "NtUnsubscribeWnfStateChange",
    "NtUpdateWnfStateData",
    "NtUnmapViewOfSection",
    "NtUnmapViewOfSectionEx",
    "NtUnlockVirtualMemory",
    "NtUnlockFile",
    "NtUnloadKeyEx",
    "NtUnloadKey2",
    "NtUnloadKey",
    "NtUnloadDriver",
    "NtUmsThreadYield",
    "NtTranslateFilePath",
    "NtTraceEvent",
    "NtTraceControl",
    "NtThawTransactions",
    "NtThawRegistry",
    "NtTestAlert",
    "NtTerminateThread",
    "NtTerminateProcess",
    "NtTerminateJobObject",
    "NtSystemDebugControl",
    "NtSuspendThread",
    "NtSuspendProcess",
    "NtSubscribeWnfStateChange",
    "NtStopProfile",
    "NtStartProfile",
    "NtSinglePhaseReject",
    "NtSignalAndWaitForSingleObject",
    "NtShutdownWorkerFactory",
    "NtShutdownSystem",
    "NtSetWnfProcessNotificationEvent",
    "NtSetVolumeInformationFile",
    "NtSetValueKey",
    "NtSetUuidSeed",
    "NtSetTimerResolution",
    "NtSetTimerEx",
    "NtSetTimer",
    "NtSetThreadExecutionState",
    "NtSetSystemTime",
    "NtSetSystemPowerState",
    "NtSetSystemInformation",
    "NtSetSystemEnvironmentValueEx",
    "NtSetSystemEnvironmentValue",
    "NtSetSecurityObject",
    "NtSetQuotaInformationFile",
    "NtSetHighEventPair",
    "NtSetHighEventPair",
    "NtSetLdtEntries",
    "NtSetIRTimer",
    "NtSetTimer2",
    "NtCancelTimer2",
    "NtSetIoCompletionEx",
    "NtSetIoCompletion",
    "NtSetIntervalProfile",
    "NtSetInformationWorkerFactory",
    "NtSetInformationTransactionManager",
    "NtSetInformationTransaction",
    "NtSetInformationToken",
    "NtSetInformationThread",
    "NtSetInformationResourceManager",
    "NtSetInformationProcess",
    "NtSetInformationObject",
    "NtSetInformationKey",
    "NtSetInformationJobObject",
    "NtSetInformationFile",
    "NtSetInformationEnlistment",
    "NtSetInformationDebugObject",
    "NtSetHighEventPair",
    "NtSetHighEventPair",
    "NtSetEventBoostPriority",
    "NtSetEvent",
    "NtSetEaFile",
    "NtSetDriverEntryOrder",
    "NtSetDefaultUILanguage",
    "NtSetDefaultLocale",
    "NtSetDefaultHardErrorPort",
    "NtSetDebugFilterState",
    "NtSetContextThread",
    "NtSetCachedSigningLevel2",
    "NtSetCachedSigningLevel",
    "NtSetBootOptions",
    "NtSetBootEntryOrder",
    "NtSerializeBoot",
    "NtSecureConnectPort",
    "NtSaveMergedKeys",
    "NtSaveKeyEx",
    "NtSaveKey",
    "NtRollforwardTransactionManager",
    "NtRollbackTransaction",
    "NtRollbackEnlistment",
    "NtRollbackComplete",
    "NtRevertContainerImpersonation",
    "NtResumeThread",
    "NtResumeProcess",
    "NtRestoreKey",
    "NtResetWriteWatch",
    "NtResetEvent",
    "NtRequestWaitReplyPort",
    "NtRequestPort",
    "NtReplyWaitReplyPort",
    "NtReplyWaitReceivePortEx",
    "NtReplyWaitReceivePort",
    "NtReplyPort",
    "NtReplacePartitionUnit",
    "NtReplaceKey",
    "NtRenameTransactionManager",
    "NtRenameKey",
    "NtRemoveProcessDebug",
    "NtRemoveIoCompletionEx",
    "NtRemoveIoCompletion",
    "NtReleaseWorkerFactoryWorker",
    "NtReleaseSemaphore",
    "NtReleaseMutant",
    "NtReleaseKeyedEvent",
    "NtRegisterThreadTerminatePort",
    "NtRegisterProtocolAddressInformation",
    "NtRecoverTransactionManager",
    "NtRecoverResourceManager",
    "NtRecoverEnlistment",
    "NtReadVirtualMemory",
    "NtReadRequestData",
    "NtReadOnlyEnlistment",
    "NtReadFileScatter",
    "NtReadFile",
    "NtRaiseHardError",
    "NtRaiseException",
    "NtQueueApcThreadEx",
    "NtQueueApcThread",
    "NtQueryWnfStateData",
    "NtQueryWnfStateNameInformation",
    "NtQueryVolumeInformationFile",
    "NtQueryVirtualMemory",
    "NtQueryValueKey",
    "NtQueryTimerResolution",
    "NtQueryTimer",
    "NtQuerySystemTime",
    "NtQuerySystemInformationEx",
    "NtQuerySystemInformation",
    "NtQuerySystemEnvironmentValueEx",
    "NtQuerySystemEnvironmentValue",
    "NtQuerySymbolicLinkObject",
    "NtQuerySemaphore",
    "NtQuerySecurityPolicy",
    "NtQuerySecurityObject",
    "NtQuerySecurityAttributesToken",
    "NtQuerySection",
    "NtQueryQuotaInformationFile",
    "NtQueryPortInformationProcess",
    "NtQueryPerformanceCounter",
    "NtQueryOpenSubKeysEx",
    "NtQueryOpenSubKeys",
    "NtQueryObject",
    "NtQueryMutant",
    "NtQueryMultipleValueKey",
    "NtQueryLicenseValue",
    "NtQueryKey",
    "NtQueryIoCompletion",
    "NtQueryIntervalProfile",
    "NtQueryInstallUILanguage",
    "NtQueryInformationWorkerFactory",
    "NtQueryInformationTransactionManager",
    "NtQueryInformationTransaction",
    "NtQueryInformationToken",
    "NtQueryInformationThread",
    "NtQueryInformationResourceManager",
    "NtQueryInformationProcess",
    "NtQueryInformationPort",
    "NtQueryInformationJobObject",
    "NtQueryInformationFile",
    "NtQueryInformationEnlistment",
    "NtQueryInformationAtom",
    "NtQueryFullAttributesFile",
    "NtQueryEvent",
    "NtQueryEaFile",
    "NtQueryDriverEntryOrder",
    "NtQueryDirectoryObject",
    "NtQueryDirectoryFile",
    "NtQueryDefaultUILanguage",
    "NtQueryDefaultLocale",
    "NtQueryDebugFilterState",
    "NtQueryBootOptions",
    "NtQueryBootEntryOrder",
    "NtQueryAttributesFile",
    "NtPulseEvent",
    "NtProtectVirtualMemory",
    "NtPropagationFailed",
    "NtPropagationComplete",
    "NtPrivilegeObjectAuditAlarm",
    "NtPrivilegedServiceAuditAlarm",
    "NtPrivilegeCheck",
    "NtSetInformationVirtualMemory",
    "NtPrePrepareEnlistment",
    "NtPrePrepareComplete",
    "NtPrepareEnlistment",
    "NtPrepareComplete",
    "NtPowerInformation",
    "NtPlugPlayControl",
    "NtOpenTransactionManager",
    "NtOpenTransaction",
    "NtOpenTimer",
    "NtOpenThreadTokenEx",
    "NtOpenThreadToken",
    "NtOpenThread",
    "NtOpenSymbolicLinkObject",
    "NtOpenSession",
    "NtOpenSemaphore",
    "NtOpenSection",
    "NtOpenResourceManager",
    "NtCreateJobSet",
    "NtOpenProcessTokenEx",
    "NtOpenProcessToken",
    "NtOpenProcess",
    "NtOpenPrivateNamespace",
    "NtOpenObjectAuditAlarm",
    "NtOpenMutant",
    "NtOpenKeyTransactedEx",
    "NtOpenKeyTransacted",
    "NtOpenKeyEx",
    "NtOpenKeyedEvent",
    "NtOpenKey",
    "NtOpenJobObject",
    "NtOpenIoCompletion",
    "NtOpenFile",
    "NtCreateEventPair",
    "NtOpenEvent",
    "NtOpenEnlistment",
    "NtOpenDirectoryObject",
    "NtNotifyChangeSession",
    "NtNotifyChangeMultipleKeys",
    "NtNotifyChangeKey",
    "NtNotifyChangeDirectoryFile",
    "NtManagePartition",
    "NtModifyDriverEntry",
    "NtModifyBootEntry",
    "NtMapViewOfSection",
    "NtMapUserPhysicalPagesScatter",
    "NtMapUserPhysicalPages",
    "NtMapCMFModule",
    "NtMakeTemporaryObject",
    "NtMakePermanentObject",
    "NtLockVirtualMemory",
    "NtLockRegistryKey",
    "NtLockProductActivationKeys",
    "NtLockFile",
    "NtLoadKeyEx",
    "NtLoadKey2",
    "NtLoadKey",
    "NtLoadEnclaveData",
    "NtLoadDriver",
    "NtListenPort",
    "NtIsUILanguageComitted",
    "NtIsSystemResumeAutomatic",
    "NtIsProcessInJob",
    "NtInitiatePowerAction",
    "NtInitializeRegistry",
    "NtInitializeNlsFiles",
    "NtInitializeEnclave",
    "NtImpersonateThread",
    "NtImpersonateClientOfPort",
    "NtImpersonateAnonymousToken",
    "NtGetWriteWatch",
    "NtGetNotificationResourceManager",
    "NtGetNlsSectionPtr",
    "NtGetNextThread",
    "NtGetNextProcess",
    "NtGetMUIRegistryInfo",
    "NtGetDevicePowerState",
    "NtGetCurrentProcessorNumberEx",
    "NtGetCurrentProcessorNumber",
    "NtGetContextThread",
    "NtGetCompleteWnfStateSubscription",
    "NtGetCachedSigningLevel",
    "NtFsControlFile",
    "NtFreezeTransactions",
    "NtFreezeRegistry",
    "NtFreeVirtualMemory",
    "NtFreeUserPhysicalPages",
    "NtFlushWriteBuffer",
    "NtFlushVirtualMemory",
    "NtFlushProcessWriteBuffers",
    "NtFlushKey",
    "FsRtlSyncVolumes",
    "NtFlushInstallUILanguage",
    "NtFlushBuffersFile",
    "NtFlushBuffersFileEx",
    "NtFindAtom",
    "NtFilterToken",
    "NtFilterTokenEx",
    "NtFilterBootOption",
    "NtExtendSection",
    "NtEnumerateValueKey",
    "NtEnumerateTransactionObject",
    "NtEnumerateSystemEnvironmentValuesEx",
    "NtEnumerateKey",
    "NtEnumerateDriverEntries",
    "NtEnumerateBootEntries",
    "NtEnableLastKnownGood",
    "NtDuplicateToken",
    "NtDuplicateObject",
    "NtDrawText",
    "NtDisplayString",
    "NtDisableLastKnownGood",
    "NtDeviceIoControlFile",
    "NtDeleteWnfStateName",
    "NtDeleteWnfStateData",
    "NtDeleteValueKey",
    "NtDeletePrivateNamespace",
    "NtDeleteObjectAuditAlarm",
    "NtDeleteKey",
    "NtDeleteFile",
    "NtDeleteDriverEntry",
    "NtDeleteBootEntry",
    "NtDeleteAtom",
    "NtDelayExecution",
    "NtDebugContinue",
    "NtDebugActiveProcess",
    "NtCreatePartition",
    "NtCreateWorkerFactory",
    "NtCreateWnfStateName",
    "NtCreateWaitCompletionPacket",
    "NtCreateWaitablePort",
    "NtCreateUserProcess",
    "NtCreateTransactionManager",
    "NtCreateTransaction",
    "NtCreateToken",
    "NtCreateLowBoxToken",
    "NtCreateTokenEx",
    "NtCreateTimer",
    "NtCreateThreadEx",
    "NtCreateThread",
    "NtCreateSymbolicLinkObject",
    "NtCreateSemaphore",
    "NtCreateSection",
    "NtCreateResourceManager",
    "NtCreateProfileEx",
    "NtCreateProfile",
    "NtCreateProcessEx",
    "NtCreateProcess",
    "NtCreatePrivateNamespace",
    "NtCreatePort",
    "NtCreatePagingFile",
    "NtCreateNamedPipeFile",
    "NtCreateMutant",
    "NtCreateMailslotFile",
    "NtCreateKeyTransacted",
    "NtCreateKeyedEvent",
    "NtCreateKey",
    "NtCreateJobSet",
    "NtCreateJobObject",
    "NtCreateIRTimer",
    "NtCreateTimer2",
    "NtCreateIoCompletion",
    "NtCreateFile",
    "NtCreateEventPair",
    "NtCreateEvent",
    "NtCreateEnlistment",
    "NtCreateEnclave",
    "NtCreateDirectoryObjectEx",
    "NtCreateDirectoryObject",
    "NtCreateDebugObject",
    "NtContinue",
    "NtConnectPort",
    "NtCompressKey",
    "NtCompleteConnectPort",
    "NtCompareTokens",
    "NtCompareObjects",
    "NtCompactKeys",
    "NtCommitTransaction",
    "NtCommitEnlistment",
    "NtCommitComplete",
    "NtCloseObjectAuditAlarm",
    "NtClose",
    "NtClearEvent",
    "NtCancelWaitCompletionPacket",
    "NtCancelTimer",
    "NtCancelSynchronousIoFile",
    "NtCancelIoFileEx",
    "NtCancelIoFile",
    "NtCallbackReturn",
    "NtAssociateWaitCompletionPacket",
    "NtAssignProcessToJobObject",
    "NtAreMappedFilesTheSame",
    "NtApphelpCacheControl",
    "NtAlpcSetInformation",
    "NtAlpcSendWaitReceivePort",
    "NtAlpcRevokeSecurityContext",
    "NtAlpcQueryInformationMessage",
    "NtAlpcQueryInformation",
    "NtAlpcOpenSenderThread",
    "NtAlpcOpenSenderProcess",
    "NtAlpcImpersonateClientOfPort",
    "NtAlpcImpersonateClientContainerOfPort",
    "NtAlpcDisconnectPort",
    "NtAlpcDeleteSecurityContext",
    "NtAlpcDeleteSectionView",
    "NtAlpcDeleteResourceReserve",
    "NtAlpcDeletePortSection",
    "NtAlpcCreateSecurityContext",
    "NtAlpcCreateSectionView",
    "NtAlpcCreateResourceReserve",
    "NtAlpcCreatePortSection",
    "NtAlpcCreatePort",
    "NtAlpcConnectPort",
    "NtAlpcConnectPortEx",
    "NtAlpcCancelMessage",
    "NtAlpcAcceptConnectPort",
    "NtAllocateVirtualMemory",
    "NtAllocateUuids",
    "NtAllocateUserPhysicalPages",
    "NtAllocateReserveObject",
    "NtAllocateLocallyUniqueId",
    "NtAlertThreadByThreadId",
    "NtAlertThread",
    "NtAlertResumeThread",
    "NtAdjustPrivilegesToken",
    "NtAdjustGroupsToken",
    "NtAdjustTokenClaimsAndDeviceGroups",
    "NtAddDriverEntry",
    "NtAddBootEntry",
    "NtAddAtom",
    "NtAddAtomEx",
    "NtAccessCheckByTypeResultListAndAuditAlarmByHandle",
    "NtAccessCheckByTypeResultListAndAuditAlarm",
    "NtAccessCheckByTypeResultList",
    "NtAccessCheckByTypeAndAuditAlarm",
    "NtAccessCheckByType",
    "NtAccessCheckAndAuditAlarm",
    "NtSetInformationSymbolicLink",
    "NtCreateRegistryTransaction",
    "NtOpenRegistryTransaction",
    "NtCommitRegistryTransaction",
    "NtRollbackRegistryTransaction"
};

//////////////////////////////////////////////////////////////////////////
// Windows 10 RS2 _KiServiceTable
//////////////////////////////////////////////////////////////////////////
static const char* KiServiceTable_Win10Rs2_x86[] = {
    "NtAccessCheck",
    "NtWorkerFactoryWorkerReady",
    "NtAcceptConnectPort",
    "NtYieldExecution",
    "NtWriteVirtualMemory",
    "NtWriteRequestData",
    "NtWriteFileGather",
    "NtWriteFile",
    "NtSetHighEventPair",
    "NtSetHighEventPair",
    "NtWaitForWorkViaWorkerFactory",
    "NtWaitForSingleObject",
    "NtWaitForMultipleObjects32",
    "NtWaitForMultipleObjects",
    "NtWaitForKeyedEvent",
    "NtWaitForDebugEvent",
    "NtWaitForAlertByThreadId",
    "NtVdmControl",
    "NtUnsubscribeWnfStateChange",
    "NtUpdateWnfStateData",
    "NtUnmapViewOfSection",
    "NtUnmapViewOfSectionEx",
    "NtUnlockVirtualMemory",
    "NtUnlockFile",
    "NtUnloadKeyEx",
    "NtUnloadKey2",
    "NtUnloadKey",
    "NtUnloadDriver",
    "NtUmsThreadYield",
    "NtTranslateFilePath",
    "NtTraceEvent",
    "NtTraceControl",
    "NtThawTransactions",
    "NtThawRegistry",
    "NtTestAlert",
    "NtTerminateThread",
    "NtTerminateProcess",
    "NtTerminateJobObject",
    "NtSystemDebugControl",
    "NtSuspendThread",
    "NtSuspendProcess",
    "NtSubscribeWnfStateChange",
    "NtStopProfile",
    "NtStartProfile",
    "NtSinglePhaseReject",
    "NtSignalAndWaitForSingleObject",
    "NtShutdownWorkerFactory",
    "NtShutdownSystem",
    "NtSetWnfProcessNotificationEvent",
    "NtSetVolumeInformationFile",
    "NtSetValueKey",
    "NtSetUuidSeed",
    "NtSetTimerResolution",
    "NtSetTimerEx",
    "NtSetTimer",
    "NtSetThreadExecutionState",
    "NtSetSystemTime",
    "NtSetSystemPowerState",
    "NtSetSystemInformation",
    "NtSetSystemEnvironmentValueEx",
    "NtSetSystemEnvironmentValue",
    "NtSetSecurityObject",
    "NtSetQuotaInformationFile",
    "NtSetHighEventPair",
    "NtSetHighEventPair",
    "NtSetLdtEntries",
    "NtSetIRTimer",
    "NtSetTimer2",
    "NtCancelTimer2",
    "NtSetIoCompletionEx",
    "NtSetIoCompletion",
    "NtSetIntervalProfile",
    "NtSetInformationWorkerFactory",
    "NtSetInformationTransactionManager",
    "NtSetInformationTransaction",
    "NtSetInformationToken",
    "NtSetInformationThread",
    "NtSetInformationResourceManager",
    "NtSetInformationProcess",
    "NtSetInformationObject",
    "NtSetInformationKey",
    "NtSetInformationJobObject",
    "NtSetInformationFile",
    "NtSetInformationEnlistment",
    "NtSetInformationDebugObject",
    "NtSetHighEventPair",
    "NtSetHighEventPair",
    "NtSetEventBoostPriority",
    "NtSetEvent",
    "NtSetEaFile",
    "NtSetDriverEntryOrder",
    "NtSetDefaultUILanguage",
    "NtSetDefaultLocale",
    "NtSetDefaultHardErrorPort",
    "NtSetDebugFilterState",
    "NtSetContextThread",
    "NtSetCachedSigningLevel2",
    "NtSetCachedSigningLevel",
    "NtSetBootOptions",
    "NtSetBootEntryOrder",
    "NtSerializeBoot",
    "NtSecureConnectPort",
    "NtSaveMergedKeys",
    "NtSaveKeyEx",
    "NtSaveKey",
    "NtRollforwardTransactionManager",
    "NtRollbackTransaction",
    "NtRollbackEnlistment",
    "NtRollbackComplete",
    "NtRevertContainerImpersonation",
    "NtResumeThread",
    "NtResumeProcess",
    "NtRestoreKey",
    "NtResetWriteWatch",
    "NtResetEvent",
    "NtRequestWaitReplyPort",
    "NtRequestPort",
    "NtReplyWaitReplyPort",
    "NtReplyWaitReceivePortEx",
    "NtReplyWaitReceivePort",
    "NtReplyPort",
    "NtReplacePartitionUnit",
    "NtReplaceKey",
    "NtRenameTransactionManager",
    "NtRenameKey",
    "NtRemoveProcessDebug",
    "NtRemoveIoCompletionEx",
    "NtRemoveIoCompletion",
    "NtReleaseWorkerFactoryWorker",
    "NtReleaseSemaphore",
    "NtReleaseMutant",
    "NtReleaseKeyedEvent",
    "NtRegisterThreadTerminatePort",
    "NtRegisterProtocolAddressInformation",
    "NtRecoverTransactionManager",
    "NtRecoverResourceManager",
    "NtRecoverEnlistment",
    "NtReadVirtualMemory",
    "NtReadRequestData",
    "NtReadOnlyEnlistment",
    "NtReadFileScatter",
    "NtReadFile",
    "NtRaiseHardError",
    "NtRaiseException",
    "NtQueueApcThreadEx",
    "NtQueueApcThread",
    "NtQueryAuxiliaryCounterFrequency",
    "NtQueryWnfStateData",
    "NtQueryWnfStateNameInformation",
    "NtQueryVolumeInformationFile",
    "NtQueryVirtualMemory",
    "NtQueryValueKey",
    "NtQueryTimerResolution",
    "NtQueryTimer",
    "NtQuerySystemTime",
    "NtQuerySystemInformationEx",
    "NtQuerySystemInformation",
    "NtQuerySystemEnvironmentValueEx",
    "NtQuerySystemEnvironmentValue",
    "NtQuerySymbolicLinkObject",
    "NtQuerySemaphore",
    "NtQuerySecurityPolicy",
    "NtQuerySecurityObject",
    "NtQuerySecurityAttributesToken",
    "NtQuerySection",
    "NtQueryQuotaInformationFile",
    "NtQueryPortInformationProcess",
    "NtQueryPerformanceCounter",
    "NtQueryOpenSubKeysEx",
    "NtQueryOpenSubKeys",
    "NtQueryObject",
    "NtQueryMutant",
    "NtQueryMultipleValueKey",
    "NtQueryLicenseValue",
    "NtQueryKey",
    "NtQueryIoCompletion",
    "NtQueryIntervalProfile",
    "NtQueryInstallUILanguage",
    "NtQueryInformationWorkerFactory",
    "NtQueryInformationTransactionManager",
    "NtQueryInformationTransaction",
    "NtQueryInformationToken",
    "NtQueryInformationThread",
    "NtQueryInformationResourceManager",
    "NtQueryInformationProcess",
    "NtQueryInformationPort",
    "NtQueryInformationJobObject",
    "NtQueryInformationFile",
    "NtQueryInformationEnlistment",
    "NtQueryInformationByName",
    "NtQueryInformationAtom",
    "NtQueryFullAttributesFile",
    "NtQueryEvent",
    "NtQueryEaFile",
    "NtQueryDriverEntryOrder",
    "NtQueryDirectoryObject",
    "NtQueryDirectoryFile",
    "NtQueryDefaultUILanguage",
    "NtQueryDefaultLocale",
    "NtQueryDebugFilterState",
    "NtQueryBootOptions",
    "NtQueryBootEntryOrder",
    "NtQueryAttributesFile",
    "NtPulseEvent",
    "NtProtectVirtualMemory",
    "NtPropagationFailed",
    "NtPropagationComplete",
    "NtPrivilegeObjectAuditAlarm",
    "NtPrivilegedServiceAuditAlarm",
    "NtPrivilegeCheck",
    "NtSetInformationVirtualMemory",
    "NtPrePrepareEnlistment",
    "NtPrePrepareComplete",
    "NtPrepareEnlistment",
    "NtPrepareComplete",
    "NtPowerInformation",
    "NtPlugPlayControl",
    "NtOpenTransactionManager",
    "NtOpenTransaction",
    "NtOpenTimer",
    "NtOpenThreadTokenEx",
    "NtOpenThreadToken",
    "NtOpenThread",
    "NtOpenSymbolicLinkObject",
    "NtOpenSession",
    "NtOpenSemaphore",
    "NtOpenSection",
    "NtOpenResourceManager",
    "NtOpenPartition",
    "NtOpenProcessTokenEx",
    "NtOpenProcessToken",
    "NtOpenProcess",
    "NtOpenPrivateNamespace",
    "NtOpenObjectAuditAlarm",
    "NtOpenMutant",
    "NtOpenKeyTransactedEx",
    "NtOpenKeyTransacted",
    "NtOpenKeyEx",
    "NtOpenKeyedEvent",
    "NtOpenKey",
    "NtOpenJobObject",
    "NtOpenIoCompletion",
    "NtOpenFile",
    "NtCreateEventPair",
    "NtOpenEvent",
    "NtOpenEnlistment",
    "NtOpenDirectoryObject",
    "NtNotifyChangeSession",
    "NtNotifyChangeMultipleKeys",
    "NtNotifyChangeKey",
    "NtNotifyChangeDirectoryFile",
    "NtManagePartition",
    "NtModifyDriverEntry",
    "NtModifyBootEntry",
    "NtMapViewOfSection",
    "NtMapUserPhysicalPagesScatter",
    "NtMapUserPhysicalPages",
    "NtMapCMFModule",
    "NtMakeTemporaryObject",
    "NtMakePermanentObject",
    "NtLockVirtualMemory",
    "NtLockRegistryKey",
    "NtLockProductActivationKeys",
    "NtLockFile",
    "NtLoadKeyEx",
    "NtLoadKey2",
    "NtLoadKey",
    "NtLoadHotPatch",
    "NtLoadEnclaveData",
    "NtLoadDriver",
    "NtListenPort",
    "NtIsUILanguageComitted",
    "NtIsSystemResumeAutomatic",
    "NtIsProcessInJob",
    "NtInitiatePowerAction",
    "NtInitializeRegistry",
    "NtInitializeNlsFiles",
    "NtInitializeEnclave",
    "NtImpersonateThread",
    "NtImpersonateClientOfPort",
    "NtImpersonateAnonymousToken",
    "NtGetWriteWatch",
    "NtGetNotificationResourceManager",
    "NtGetNlsSectionPtr",
    "NtGetNextThread",
    "NtGetNextProcess",
    "NtGetMUIRegistryInfo",
    "NtGetDevicePowerState",
    "NtGetCurrentProcessorNumberEx",
    "NtGetCurrentProcessorNumber",
    "NtGetContextThread",
    "NtGetCompleteWnfStateSubscription",
    "NtGetCachedSigningLevel",
    "NtFsControlFile",
    "NtFreezeTransactions",
    "NtFreezeRegistry",
    "NtFreeVirtualMemory",
    "NtFreeUserPhysicalPages",
    "NtFlushWriteBuffer",
    "NtFlushVirtualMemory",
    "NtFlushProcessWriteBuffers",
    "NtFlushKey",
    "FsRtlSyncVolumes",
    "NtFlushInstallUILanguage",
    "NtFlushBuffersFile",
    "NtFlushBuffersFileEx",
    "NtFindAtom",
    "NtFilterToken",
    "NtFilterTokenEx",
    "NtFilterBootOption",
    "NtExtendSection",
    "NtEnumerateValueKey",
    "NtEnumerateTransactionObject",
    "NtEnumerateSystemEnvironmentValuesEx",
    "NtEnumerateKey",
    "NtEnumerateDriverEntries",
    "NtEnumerateBootEntries",
    "NtEnableLastKnownGood",
    "NtDuplicateToken",
    "NtDuplicateObject",
    "NtDrawText",
    "NtDisplayString",
    "NtDisableLastKnownGood",
    "NtDeviceIoControlFile",
    "NtDeleteWnfStateName",
    "NtDeleteWnfStateData",
    "NtDeleteValueKey",
    "NtDeletePrivateNamespace",
    "NtDeleteObjectAuditAlarm",
    "NtDeleteKey",
    "NtDeleteFile",
    "NtDeleteDriverEntry",
    "NtDeleteBootEntry",
    "NtDeleteAtom",
    "NtDelayExecution",
    "NtDebugContinue",
    "NtDebugActiveProcess",
    "NtCreatePartition",
    "NtCreateWorkerFactory",
    "NtCreateWnfStateName",
    "NtCreateWaitCompletionPacket",
    "NtCreateWaitablePort",
    "NtCreateUserProcess",
    "NtCreateTransactionManager",
    "NtCreateTransaction",
    "NtCreateToken",
    "NtCreateLowBoxToken",
    "NtCreateTokenEx",
    "NtCreateTimer",
    "NtCreateThreadEx",
    "NtCreateThread",
    "NtCreateSymbolicLinkObject",
    "NtCreateSemaphore",
    "NtCreateSection",
    "NtCreateResourceManager",
    "NtCreateProfileEx",
    "NtCreateProfile",
    "NtCreateProcessEx",
    "NtCreateProcess",
    "NtCreatePrivateNamespace",
    "NtCreatePort",
    "NtCreatePagingFile",
    "NtCreateNamedPipeFile",
    "NtCreateMutant",
    "NtCreateMailslotFile",
    "NtCreateKeyTransacted",
    "NtCreateKeyedEvent",
    "NtCreateKey",
    "NtCreateJobSet",
    "NtCreateJobObject",
    "NtCreateIRTimer",
    "NtCreateTimer2",
    "NtCreateIoCompletion",
    "NtCreateFile",
    "NtCreateEventPair",
    "NtCreateEvent",
    "NtCreateEnlistment",
    "NtCreateEnclave",
    "NtCreateDirectoryObjectEx",
    "NtCreateDirectoryObject",
    "NtCreateDebugObject",
    "NtConvertBetweenAuxiliaryCounterAndPerformanceCounter",
    "NtContinue",
    "NtConnectPort",
    "NtCompressKey",
    "NtCompleteConnectPort",
    "NtCompareTokens",
    "NtCompareSigningLevels",
    "NtCompareObjects",
    "NtCompactKeys",
    "NtCommitTransaction",
    "NtCommitEnlistment",
    "NtCommitComplete",
    "NtCloseObjectAuditAlarm",
    "NtClose",
    "NtClearEvent",
    "NtCancelWaitCompletionPacket",
    "NtCancelTimer",
    "NtCancelSynchronousIoFile",
    "NtCancelIoFileEx",
    "NtCancelIoFile",
    "NtCallbackReturn",
    "NtAssociateWaitCompletionPacket",
    "NtAssignProcessToJobObject",
    "NtAreMappedFilesTheSame",
    "NtApphelpCacheControl",
    "NtAlpcSetInformation",
    "NtAlpcSendWaitReceivePort",
    "NtAlpcRevokeSecurityContext",
    "NtAlpcQueryInformationMessage",
    "NtAlpcQueryInformation",
    "NtAlpcOpenSenderThread",
    "NtAlpcOpenSenderProcess",
    "NtAlpcImpersonateClientOfPort",
    "NtAlpcImpersonateClientContainerOfPort",
    "NtAlpcDisconnectPort",
    "NtAlpcDeleteSecurityContext",
    "NtAlpcDeleteSectionView",
    "NtAlpcDeleteResourceReserve",
    "NtAlpcDeletePortSection",
    "NtAlpcCreateSecurityContext",
    "NtAlpcCreateSectionView",
    "NtAlpcCreateResourceReserve",
    "NtAlpcCreatePortSection",
    "NtAlpcCreatePort",
    "NtAlpcConnectPort",
    "NtAlpcConnectPortEx",
    "NtAlpcCancelMessage",
    "NtAlpcAcceptConnectPort",
    "NtAllocateVirtualMemory",
    "NtAllocateUuids",
    "NtAllocateUserPhysicalPages",
    "NtAllocateReserveObject",
    "NtAllocateLocallyUniqueId",
    "NtAlertThreadByThreadId",
    "NtAlertThread",
    "NtAlertResumeThread",
    "NtAdjustPrivilegesToken",
    "NtAdjustGroupsToken",
    "NtAdjustTokenClaimsAndDeviceGroups",
    "NtAddDriverEntry",
    "NtAddBootEntry",
    "NtAddAtom",
    "NtAddAtomEx",
    "NtAcquireProcessActivityReference",
    "NtAccessCheckByTypeResultListAndAuditAlarmByHandle",
    "NtAccessCheckByTypeResultListAndAuditAlarm",
    "NtAccessCheckByTypeResultList",
    "NtAccessCheckByTypeAndAuditAlarm",
    "NtAccessCheckByType",
    "NtAccessCheckAndAuditAlarm",
    "NtSetInformationSymbolicLink",
    "NtCreateRegistryTransaction",
    "NtOpenRegistryTransaction",
    "NtCommitRegistryTransaction",
    "NtRollbackRegistryTransaction"
};

//////////////////////////////////////////////////////////////////////////
// Windows 10 RS3 _KiServiceTable
//////////////////////////////////////////////////////////////////////////
static const char* KiServiceTable_Win10Rs3_x86[] = {
    "NtAccessCheck",
    "NtWorkerFactoryWorkerReady",
    "NtAcceptConnectPort",
    "NtYieldExecution",
    "NtWriteVirtualMemory",
    "NtWriteRequestData",
    "NtWriteFileGather",
    "NtWriteFile",
    "NtSetHighEventPair",
    "NtSetHighEventPair",
    "NtWaitForWorkViaWorkerFactory",
    "NtWaitForSingleObject",
    "NtWaitForMultipleObjects32",
    "NtWaitForMultipleObjects",
    "NtWaitForKeyedEvent",
    "NtWaitForDebugEvent",
    "NtWaitForAlertByThreadId",
    "NtVdmControl",
    "NtUnsubscribeWnfStateChange",
    "NtUpdateWnfStateData",
    "NtUnmapViewOfSection",
    "NtUnmapViewOfSectionEx",
    "NtUnlockVirtualMemory",
    "NtUnlockFile",
    "NtUnloadKeyEx",
    "NtUnloadKey2",
    "NtUnloadKey",
    "NtUnloadDriver",
    "NtUmsThreadYield",
    "NtTranslateFilePath",
    "NtTraceEvent",
    "NtTraceControl",
    "NtThawTransactions",
    "NtThawRegistry",
    "NtTestAlert",
    "NtTerminateThread",
    "NtTerminateProcess",
    "NtTerminateJobObject",
    "NtTerminateEnclave",
    "NtSystemDebugControl",
    "NtSuspendThread",
    "NtSuspendProcess",
    "NtSubscribeWnfStateChange",
    "NtStopProfile",
    "NtStartProfile",
    "NtSinglePhaseReject",
    "NtSignalAndWaitForSingleObject",
    "NtShutdownWorkerFactory",
    "NtShutdownSystem",
    "NtSetWnfProcessNotificationEvent",
    "NtSetVolumeInformationFile",
    "NtSetValueKey",
    "NtSetUuidSeed",
    "NtSetTimerResolution",
    "NtSetTimerEx",
    "NtSetTimer",
    "NtSetThreadExecutionState",
    "NtSetSystemTime",
    "NtSetSystemPowerState",
    "NtSetSystemInformation",
    "NtSetSystemEnvironmentValueEx",
    "NtSetSystemEnvironmentValue",
    "NtSetSecurityObject",
    "NtSetQuotaInformationFile",
    "NtSetHighEventPair",
    "NtSetHighEventPair",
    "NtSetLdtEntries",
    "NtSetIRTimer",
    "NtSetTimer2",
    "NtCancelTimer2",
    "NtSetIoCompletionEx",
    "NtSetIoCompletion",
    "NtSetIntervalProfile",
    "NtSetInformationWorkerFactory",
    "NtSetInformationTransactionManager",
    "NtSetInformationTransaction",
    "NtSetInformationToken",
    "NtSetInformationThread",
    "NtSetInformationResourceManager",
    "NtSetInformationProcess",
    "NtSetInformationObject",
    "NtSetInformationKey",
    "NtSetInformationJobObject",
    "NtSetInformationFile",
    "NtSetInformationEnlistment",
    "NtSetInformationDebugObject",
    "NtSetHighEventPair",
    "NtSetHighEventPair",
    "NtSetEventBoostPriority",
    "NtSetEvent",
    "NtSetEaFile",
    "NtSetDriverEntryOrder",
    "NtSetDefaultUILanguage",
    "NtSetDefaultLocale",
    "NtSetDefaultHardErrorPort",
    "NtSetDebugFilterState",
    "NtSetContextThread",
    "NtSetCachedSigningLevel2",
    "NtSetCachedSigningLevel",
    "NtSetBootOptions",
    "NtSetBootEntryOrder",
    "NtSerializeBoot",
    "NtSecureConnectPort",
    "NtSaveMergedKeys",
    "NtSaveKeyEx",
    "NtSaveKey",
    "NtRollforwardTransactionManager",
    "NtRollbackTransaction",
    "NtRollbackEnlistment",
    "NtRollbackComplete",
    "NtRevertContainerImpersonation",
    "NtResumeThread",
    "NtResumeProcess",
    "NtRestoreKey",
    "NtResetWriteWatch",
    "NtResetEvent",
    "NtRequestWaitReplyPort",
    "NtRequestPort",
    "NtReplyWaitReplyPort",
    "NtReplyWaitReceivePortEx",
    "NtReplyWaitReceivePort",
    "NtReplyPort",
    "NtReplacePartitionUnit",
    "NtReplaceKey",
    "NtRenameTransactionManager",
    "NtRenameKey",
    "NtRemoveProcessDebug",
    "NtRemoveIoCompletionEx",
    "NtRemoveIoCompletion",
    "NtReleaseWorkerFactoryWorker",
    "NtReleaseSemaphore",
    "NtReleaseMutant",
    "NtReleaseKeyedEvent",
    "NtRegisterThreadTerminatePort",
    "NtRegisterProtocolAddressInformation",
    "NtRecoverTransactionManager",
    "NtRecoverResourceManager",
    "NtRecoverEnlistment",
    "NtReadVirtualMemory",
    "NtReadRequestData",
    "NtReadOnlyEnlistment",
    "NtReadFileScatter",
    "NtReadFile",
    "NtRaiseHardError",
    "NtRaiseException",
    "NtQueueApcThreadEx",
    "NtQueueApcThread",
    "NtQueryAuxiliaryCounterFrequency",
    "NtQueryWnfStateData",
    "NtQueryWnfStateNameInformation",
    "NtQueryVolumeInformationFile",
    "NtQueryVirtualMemory",
    "NtQueryValueKey",
    "NtQueryTimerResolution",
    "NtQueryTimer",
    "NtQuerySystemTime",
    "NtQuerySystemInformationEx",
    "NtQuerySystemInformation",
    "NtQuerySystemEnvironmentValueEx",
    "NtQuerySystemEnvironmentValue",
    "NtQuerySymbolicLinkObject",
    "NtQuerySemaphore",
    "NtQuerySecurityPolicy",
    "NtQuerySecurityObject",
    "NtQuerySecurityAttributesToken",
    "NtQuerySection",
    "NtQueryQuotaInformationFile",
    "NtQueryPortInformationProcess",
    "NtQueryPerformanceCounter",
    "NtQueryOpenSubKeysEx",
    "NtQueryOpenSubKeys",
    "NtQueryObject",
    "NtQueryMutant",
    "NtQueryMultipleValueKey",
    "NtQueryLicenseValue",
    "NtQueryKey",
    "NtQueryIoCompletion",
    "NtQueryIntervalProfile",
    "NtQueryInstallUILanguage",
    "NtQueryInformationWorkerFactory",
    "NtQueryInformationTransactionManager",
    "NtQueryInformationTransaction",
    "NtQueryInformationToken",
    "NtQueryInformationThread",
    "NtQueryInformationResourceManager",
    "NtQueryInformationProcess",
    "NtQueryInformationPort",
    "NtQueryInformationJobObject",
    "NtQueryInformationFile",
    "NtQueryInformationEnlistment",
    "NtQueryInformationByName",
    "NtQueryInformationAtom",
    "NtQueryFullAttributesFile",
    "NtQueryEvent",
    "NtQueryEaFile",
    "NtQueryDriverEntryOrder",
    "NtQueryDirectoryObject",
    "NtQueryDirectoryFile",
    "NtQueryDirectoryFileEx",
    "NtQueryDefaultUILanguage",
    "NtQueryDefaultLocale",
    "NtQueryDebugFilterState",
    "NtQueryBootOptions",
    "NtQueryBootEntryOrder",
    "NtQueryAttributesFile",
    "NtPulseEvent",
    "NtProtectVirtualMemory",
    "NtPropagationFailed",
    "NtPropagationComplete",
    "NtPrivilegeObjectAuditAlarm",
    "NtPrivilegedServiceAuditAlarm",
    "NtPrivilegeCheck",
    "NtSetInformationVirtualMemory",
    "NtPrePrepareEnlistment",
    "NtPrePrepareComplete",
    "NtPrepareEnlistment",
    "NtPrepareComplete",
    "NtPowerInformation",
    "NtPlugPlayControl",
    "NtOpenTransactionManager",
    "NtOpenTransaction",
    "NtOpenTimer",
    "NtOpenThreadTokenEx",
    "NtOpenThreadToken",
    "NtOpenThread",
    "NtOpenSymbolicLinkObject",
    "NtOpenSession",
    "NtOpenSemaphore",
    "NtOpenSection",
    "NtOpenResourceManager",
    "NtOpenPartition",
    "NtOpenProcessTokenEx",
    "NtOpenProcessToken",
    "NtOpenProcess",
    "NtOpenPrivateNamespace",
    "NtOpenObjectAuditAlarm",
    "NtOpenMutant",
    "NtOpenKeyTransactedEx",
    "NtOpenKeyTransacted",
    "NtOpenKeyEx",
    "NtOpenKeyedEvent",
    "NtOpenKey",
    "NtOpenJobObject",
    "NtOpenIoCompletion",
    "NtOpenFile",
    "NtCreateEventPair",
    "NtOpenEvent",
    "NtOpenEnlistment",
    "NtOpenDirectoryObject",
    "NtNotifyChangeSession",
    "NtNotifyChangeMultipleKeys",
    "NtNotifyChangeKey",
    "NtNotifyChangeDirectoryFile",
    "NtNotifyChangeDirectoryFileEx",
    "NtManagePartition",
    "NtModifyDriverEntry",
    "NtModifyBootEntry",
    "NtMapViewOfSection",
    "NtMapUserPhysicalPagesScatter",
    "NtMapUserPhysicalPages",
    "NtMapCMFModule",
    "NtMakeTemporaryObject",
    "NtMakePermanentObject",
    "NtLockVirtualMemory",
    "NtLockRegistryKey",
    "NtLockProductActivationKeys",
    "NtLockFile",
    "NtLoadKeyEx",
    "NtLoadKey2",
    "NtLoadKey",
    "NtLoadHotPatch",
    "NtLoadEnclaveData",
    "NtLoadDriver",
    "NtListenPort",
    "NtIsUILanguageComitted",
    "NtIsSystemResumeAutomatic",
    "NtIsProcessInJob",
    "NtInitiatePowerAction",
    "NtInitializeRegistry",
    "NtInitializeNlsFiles",
    "NtInitializeEnclave",
    "NtImpersonateThread",
    "NtImpersonateClientOfPort",
    "NtImpersonateAnonymousToken",
    "NtGetWriteWatch",
    "NtGetNotificationResourceManager",
    "NtGetNlsSectionPtr",
    "NtGetNextThread",
    "NtGetNextProcess",
    "NtGetMUIRegistryInfo",
    "NtGetDevicePowerState",
    "NtGetCurrentProcessorNumberEx",
    "NtGetCurrentProcessorNumber",
    "NtGetContextThread",
    "NtGetCompleteWnfStateSubscription",
    "NtGetCachedSigningLevel",
    "NtFsControlFile",
    "NtFreezeTransactions",
    "NtFreezeRegistry",
    "NtFreeVirtualMemory",
    "NtFreeUserPhysicalPages",
    "NtFlushWriteBuffer",
    "NtFlushVirtualMemory",
    "NtFlushProcessWriteBuffers",
    "NtFlushKey",
    "FsRtlSyncVolumes",
    "NtFlushInstallUILanguage",
    "NtFlushBuffersFile",
    "NtFlushBuffersFileEx",
    "NtFindAtom",
    "NtFilterToken",
    "NtFilterTokenEx",
    "NtFilterBootOption",
    "NtExtendSection",
    "NtEnumerateValueKey",
    "NtEnumerateTransactionObject",
    "NtEnumerateSystemEnvironmentValuesEx",
    "NtEnumerateKey",
    "NtEnumerateDriverEntries",
    "NtEnumerateBootEntries",
    "NtEnableLastKnownGood",
    "NtDuplicateToken",
    "NtDuplicateObject",
    "NtDrawText",
    "NtDisplayString",
    "NtDisableLastKnownGood",
    "NtDeviceIoControlFile",
    "NtDeleteWnfStateName",
    "NtDeleteWnfStateData",
    "NtDeleteValueKey",
    "NtDeletePrivateNamespace",
    "NtDeleteObjectAuditAlarm",
    "NtDeleteKey",
    "NtDeleteFile",
    "NtDeleteDriverEntry",
    "NtDeleteBootEntry",
    "NtDeleteAtom",
    "NtDelayExecution",
    "NtDebugContinue",
    "NtDebugActiveProcess",
    "NtCreatePartition",
    "NtCreateWorkerFactory",
    "NtCreateWnfStateName",
    "NtCreateWaitCompletionPacket",
    "NtCreateWaitablePort",
    "NtCreateUserProcess",
    "NtCreateTransactionManager",
    "NtCreateTransaction",
    "NtCreateToken",
    "NtCreateLowBoxToken",
    "NtCreateTokenEx",
    "NtCreateTimer",
    "NtCreateThreadEx",
    "NtCreateThread",
    "NtCreateSymbolicLinkObject",
    "NtCreateSemaphore",
    "NtCreateSection",
    "NtCreateResourceManager",
    "NtCreateProfileEx",
    "NtCreateProfile",
    "NtCreateProcessEx",
    "NtCreateProcess",
    "NtCreatePrivateNamespace",
    "NtCreatePort",
    "NtCreatePagingFile",
    "NtCreateNamedPipeFile",
    "NtCreateMutant",
    "NtCreateMailslotFile",
    "NtCreateKeyTransacted",
    "NtCreateKeyedEvent",
    "NtCreateKey",
    "NtCreateJobSet",
    "NtCreateJobObject",
    "NtCreateIRTimer",
    "NtCreateTimer2",
    "NtCreateIoCompletion",
    "NtCreateFile",
    "NtCreateEventPair",
    "NtCreateEvent",
    "NtCreateEnlistment",
    "NtCreateEnclave",
    "NtCreateDirectoryObjectEx",
    "NtCreateDirectoryObject",
    "NtCreateDebugObject",
    "NtConvertBetweenAuxiliaryCounterAndPerformanceCounter",
    "NtContinue",
    "NtConnectPort",
    "NtCompressKey",
    "NtCompleteConnectPort",
    "NtCompareTokens",
    "NtCompareSigningLevels",
    "NtCompareObjects",
    "NtCompactKeys",
    "NtCommitTransaction",
    "NtCommitEnlistment",
    "NtCommitComplete",
    "NtCloseObjectAuditAlarm",
    "NtClose",
    "NtClearEvent",
    "NtCancelWaitCompletionPacket",
    "NtCancelTimer",
    "NtCancelSynchronousIoFile",
    "NtCancelIoFileEx",
    "NtCancelIoFile",
    "NtCallEnclave",
    "NtCallbackReturn",
    "NtAssociateWaitCompletionPacket",
    "NtAssignProcessToJobObject",
    "NtAreMappedFilesTheSame",
    "NtApphelpCacheControl",
    "NtAlpcSetInformation",
    "NtAlpcSendWaitReceivePort",
    "NtAlpcRevokeSecurityContext",
    "NtAlpcQueryInformationMessage",
    "NtAlpcQueryInformation",
    "NtAlpcOpenSenderThread",
    "NtAlpcOpenSenderProcess",
    "NtAlpcImpersonateClientOfPort",
    "NtAlpcImpersonateClientContainerOfPort",
    "NtAlpcDisconnectPort",
    "NtAlpcDeleteSecurityContext",
    "NtAlpcDeleteSectionView",
    "NtAlpcDeleteResourceReserve",
    "NtAlpcDeletePortSection",
    "NtAlpcCreateSecurityContext",
    "NtAlpcCreateSectionView",
    "NtAlpcCreateResourceReserve",
    "NtAlpcCreatePortSection",
    "NtAlpcCreatePort",
    "NtAlpcConnectPort",
    "NtAlpcConnectPortEx",
    "NtAlpcCancelMessage",
    "NtAlpcAcceptConnectPort",
    "NtAllocateVirtualMemory",
    "NtAllocateUuids",
    "NtAllocateUserPhysicalPages",
    "NtAllocateReserveObject",
    "NtAllocateLocallyUniqueId",
    "NtAlertThreadByThreadId",
    "NtAlertThread",
    "NtAlertResumeThread",
    "NtAdjustPrivilegesToken",
    "NtAdjustGroupsToken",
    "NtAdjustTokenClaimsAndDeviceGroups",
    "NtAddDriverEntry",
    "NtAddBootEntry",
    "NtAddAtom",
    "NtAddAtomEx",
    "NtAcquireProcessActivityReference",
    "NtAccessCheckByTypeResultListAndAuditAlarmByHandle",
    "NtAccessCheckByTypeResultListAndAuditAlarm",
    "NtAccessCheckByTypeResultList",
    "NtAccessCheckByTypeAndAuditAlarm",
    "NtAccessCheckByType",
    "NtAccessCheckAndAuditAlarm",
    "NtSetInformationSymbolicLink",
    "NtCreateRegistryTransaction",
    "NtOpenRegistryTransaction",
    "NtCommitRegistryTransaction",
    "NtRollbackRegistryTransaction"
};

//////////////////////////////////////////////////////////////////////////
// x64
//////////////////////////////////////////////////////////////////////////

//////////////////////////////////////////////////////////////////////////
// Windows 2003 SP2 _KiServiceTable
//////////////////////////////////////////////////////////////////////////
static const char* KiServiceTable_W2k3Sp2_x64[] = {
    "NtMapUserPhysicalPagesScatter",
    "NtWaitForSingleObject",
    "NtCallbackReturn",
    "NtReadFile",
    "NtDeviceIoControlFile",
    "NtWriteFile",
    "NtRemoveIoCompletion",
    "NtReleaseSemaphore",
    "NtReplyWaitReceivePort",
    "NtReplyPort",
    "NtSetInformationThread",
    "NtSetEvent",
    "NtClose",
    "NtQueryObject",
    "NtQueryInformationFile",
    "NtOpenKey",
    "NtEnumerateValueKey",
    "NtFindAtom",
    "NtQueryDefaultLocale",
    "NtQueryKey",
    "NtQueryValueKey",
    "NtAllocateVirtualMemory",
    "NtQueryInformationProcess",
    "NtWaitForMultipleObjects32",
    "NtWriteFileGather",
    "NtSetInformationProcess",
    "NtCreateKey",
    "NtFreeVirtualMemory",
    "NtImpersonateClientOfPort",
    "NtReleaseMutant",
    "NtQueryInformationToken",
    "NtRequestWaitReplyPort",
    "NtQueryVirtualMemory",
    "NtOpenThreadToken",
    "NtQueryInformationThread",
    "NtOpenProcess",
    "NtSetInformationFile",
    "NtMapViewOfSection",
    "NtAccessCheckAndAuditAlarm",
    "NtUnmapViewOfSection",
    "NtReplyWaitReceivePortEx",
    "NtTerminateProcess",
    "NtSetEventBoostPriority",
    "NtReadFileScatter",
    "NtOpenThreadTokenEx",
    "NtOpenProcessTokenEx",
    "NtQueryPerformanceCounter",
    "NtEnumerateKey",
    "NtOpenFile",
    "NtDelayExecution",
    "NtQueryDirectoryFile",
    "NtQuerySystemInformation",
    "NtOpenSection",
    "NtQueryTimer",
    "NtFsControlFile",
    "NtWriteVirtualMemory",
    "NtCloseObjectAuditAlarm",
    "NtDuplicateObject",
    "NtQueryAttributesFile",
    "NtClearEvent",
    "NtReadVirtualMemory",
    "NtOpenEvent",
    "NtAdjustPrivilegesToken",
    "NtDuplicateToken",
    "NtContinue",
    "NtQueryDefaultUILanguage",
    "NtQueueApcThread",
    "NtYieldExecution",
    "NtAddAtom",
    "NtCreateEvent",
    "NtQueryVolumeInformationFile",
    "NtCreateSection",
    "NtFlushBuffersFile",
    "NtApphelpCacheControl",
    "NtCreateProcessEx",
    "NtCreateThread",
    "NtIsProcessInJob",
    "NtProtectVirtualMemory",
    "NtQuerySection",
    "NtResumeThread",
    "NtTerminateThread",
    "NtReadRequestData",
    "NtCreateFile",
    "NtQueryEvent",
    "NtWriteRequestData",
    "NtOpenDirectoryObject",
    "NtAccessCheckByTypeAndAuditAlarm",
    "NtQuerySystemTime",
    "NtWaitForMultipleObjects",
    "NtSetInformationObject",
    "NtCancelIoFile",
    "NtTraceEvent",
    "NtPowerInformation",
    "NtSetValueKey",
    "NtCancelTimer",
    "NtSetTimer",
    "NtAcceptConnectPort",
    "NtAccessCheck",
    "NtAccessCheckByType",
    "NtAccessCheckByTypeResultList",
    "NtAccessCheckByTypeResultListAndAuditAlarm",
    "NtAccessCheckByTypeResultListAndAuditAlarmByHandle",
    "NtQueryBootOptions",
    "NtQueryBootOptions",
    "NtAdjustGroupsToken",
    "NtAlertResumeThread",
    "NtAlertThread",
    "NtAllocateLocallyUniqueId",
    "NtAllocateUserPhysicalPages",
    "NtAllocateUuids",
    "NtAreMappedFilesTheSame",
    "NtAssignProcessToJobObject",
    "NtQueryBootOptions",
    "NtCompactKeys",
    "NtCompareTokens",
    "NtCompleteConnectPort",
    "NtCompressKey",
    "NtConnectPort",
    "NtCreateDebugObject",
    "NtCreateDirectoryObject",
    "NtCreateEventPair",
    "NtCreateIoCompletion",
    "NtCreateJobObject",
    "NtCreateJobSet",
    "NtCreateKeyedEvent",
    "NtCreateMailslotFile",
    "NtCreateMutant",
    "NtCreateNamedPipeFile",
    "NtCreatePagingFile",
    "NtCreatePort",
    "NtCreateProcess",
    "NtCreateProfile",
    "NtCreateSemaphore",
    "NtCreateSymbolicLinkObject",
    "NtCreateTimer",
    "NtCreateToken",
    "NtCreateWaitablePort",
    "NtDebugActiveProcess",
    "NtDebugContinue",
    "NtDeleteAtom",
    "NtQueryBootOptions",
    "NtQueryBootOptions",
    "NtDeleteFile",
    "NtDeleteKey",
    "NtDeleteObjectAuditAlarm",
    "NtDeleteValueKey",
    "NtDisplayString",
    "NtQueryBootOptions",
    "NtQueryBootOptions",
    "NtQueryBootOptions",
    "NtExtendSection",
    "NtFilterToken",
    "NtFlushInstructionCache",
    "NtFlushKey",
    "NtFlushVirtualMemory",
    "NtFlushWriteBuffer",
    "NtFreeUserPhysicalPages",
    "NtGetContextThread",
    "NtGetCurrentProcessorNumber",
    "NtGetDevicePowerState",
    "NtGetPlugPlayEvent",
    "NtGetWriteWatch",
    "NtImpersonateAnonymousToken",
    "NtImpersonateThread",
    "NtInitializeRegistry",
    "NtInitiatePowerAction",
    "NtIsSystemResumeAutomatic",
    "NtListenPort",
    "NtLoadDriver",
    "NtLoadKey",
    "NtLoadKey2",
    "NtLoadKeyEx",
    "NtLockFile",
    "NtLockProductActivationKeys",
    "NtLockRegistryKey",
    "NtLockVirtualMemory",
    "NtMakePermanentObject",
    "NtMakeTemporaryObject",
    "NtMapUserPhysicalPages",
    "NtQueryBootOptions",
    "NtQueryBootOptions",
    "NtNotifyChangeDirectoryFile",
    "NtNotifyChangeKey",
    "NtNotifyChangeMultipleKeys",
    "NtOpenEventPair",
    "NtOpenIoCompletion",
    "NtOpenJobObject",
    "NtOpenKeyedEvent",
    "NtOpenMutant",
    "NtOpenObjectAuditAlarm",
    "NtOpenProcessToken",
    "NtOpenSemaphore",
    "NtOpenSymbolicLinkObject",
    "NtOpenThread",
    "NtOpenTimer",
    "NtPlugPlayControl",
    "NtPrivilegeCheck",
    "NtPrivilegeObjectAuditAlarm",
    "NtPrivilegedServiceAuditAlarm",
    "NtPulseEvent",
    "NtQueryBootOptions",
    "NtQueryBootOptions",
    "NtQueryDebugFilterState",
    "NtQueryDirectoryObject",
    "NtQueryBootOptions",
    "NtQueryEaFile",
    "NtQueryFullAttributesFile",
    "NtQueryInformationAtom",
    "NtQueryInformationJobObject",
    "NtQueryInformationPort",
    "NtQueryInstallUILanguage",
    "NtQueryIntervalProfile",
    "NtQueryIoCompletion",
    "NtQueryMultipleValueKey",
    "NtQueryMutant",
    "NtQueryOpenSubKeys",
    "NtQueryOpenSubKeysEx",
    "ShimExceptionHandler",
    "NtQueryQuotaInformationFile",
    "NtQuerySecurityObject",
    "NtQuerySemaphore",
    "NtQuerySymbolicLinkObject",
    "NtQuerySystemEnvironmentValue",
    "NtQueryBootOptions",
    "NtQueryTimerResolution",
    "NtRaiseException",
    "NtRaiseHardError",
    "NtRegisterThreadTerminatePort",
    "NtReleaseKeyedEvent",
    "NtRemoveProcessDebug",
    "NtRenameKey",
    "NtReplaceKey",
    "NtReplyWaitReplyPort",
    "NtQueryBootOptions",
    "NtRequestPort",
    "NtRequestWakeupLatency",
    "NtResetEvent",
    "NtResetWriteWatch",
    "NtRestoreKey",
    "NtResumeProcess",
    "NtSaveKey",
    "NtSaveKeyEx",
    "NtSaveMergedKeys",
    "NtSecureConnectPort",
    "NtQueryBootOptions",
    "NtQueryBootOptions",
    "NtSetContextThread",
    "NtSetDebugFilterState",
    "NtSetDefaultHardErrorPort",
    "NtSetDefaultLocale",
    "NtSetDefaultUILanguage",
    "NtQueryBootOptions",
    "NtSetEaFile",
    "NtSetHighEventPair",
    "NtSetHighWaitLowEventPair",
    "NtSetInformationDebugObject",
    "NtSetInformationJobObject",
    "NtSetInformationKey",
    "NtSetInformationToken",
    "NtSetIntervalProfile",
    "NtSetIoCompletion",
    "xKdSetupPciDeviceForDebugging",
    "NtSetLowEventPair",
    "NtSetLowWaitHighEventPair",
    "NtSetQuotaInformationFile",
    "NtSetSecurityObject",
    "NtSetSystemEnvironmentValue",
    "NtQueryBootOptions",
    "NtSetSystemInformation",
    "NtSetSystemPowerState",
    "NtSetSystemTime",
    "NtSetThreadExecutionState",
    "NtSetTimerResolution",
    "NtSetUuidSeed",
    "NtSetVolumeInformationFile",
    "NtShutdownSystem",
    "NtSignalAndWaitForSingleObject",
    "NtStartProfile",
    "NtStopProfile",
    "NtSuspendProcess",
    "NtSuspendThread",
    "NtSystemDebugControl",
    "NtTerminateJobObject",
    "NtTestAlert",
    "NtQueryBootOptions",
    "NtUnloadDriver",
    "NtUnloadKey",
    "NtUnloadKey2",
    "NtUnloadKeyEx",
    "NtUnlockFile",
    "NtUnlockVirtualMemory",
    "NtVdmControl",
    "NtWaitForDebugEvent",
    "NtWaitForKeyedEvent",
    "NtWaitHighEventPair",
    "NtWaitLowEventPair"
};

//////////////////////////////////////////////////////////////////////////
// Windows Vista SP0 _KiServiceTable
//////////////////////////////////////////////////////////////////////////
static const char* KiServiceTable_VistaSp0_x64[] = {
    "NtMapUserPhysicalPagesScatter",
    "NtWaitForSingleObject",
    "NtCallbackReturn",
    "NtReadFile",
    "NtDeviceIoControlFile",
    "NtWriteFile",
    "NtRemoveIoCompletion",
    "NtReleaseSemaphore",
    "NtReplyWaitReceivePort",
    "NtReplyPort",
    "NtSetInformationThread",
    "NtSetEvent",
    "NtClose",
    "NtQueryObject",
    "NtQueryInformationFile",
    "NtOpenKey",
    "NtEnumerateValueKey",
    "NtFindAtom",
    "NtQueryDefaultLocale",
    "NtQueryKey",
    "NtQueryValueKey",
    "NtAllocateVirtualMemory",
    "NtQueryInformationProcess",
    "NtWaitForMultipleObjects32",
    "NtWriteFileGather",
    "NtSetInformationProcess",
    "NtCreateKey",
    "NtFreeVirtualMemory",
    "NtImpersonateClientOfPort",
    "NtReleaseMutant",
    "NtQueryInformationToken",
    "NtRequestWaitReplyPort",
    "NtQueryVirtualMemory",
    "NtOpenThreadToken",
    "NtQueryInformationThread",
    "NtOpenProcess",
    "NtSetInformationFile",
    "NtMapViewOfSection",
    "NtAccessCheckAndAuditAlarm",
    "NtUnmapViewOfSection",
    "NtReplyWaitReceivePortEx",
    "NtTerminateProcess",
    "NtSetEventBoostPriority",
    "NtReadFileScatter",
    "NtOpenThreadTokenEx",
    "NtOpenProcessTokenEx",
    "NtQueryPerformanceCounter",
    "NtEnumerateKey",
    "NtOpenFile",
    "NtDelayExecution",
    "NtQueryDirectoryFile",
    "NtQuerySystemInformation",
    "NtOpenSection",
    "NtQueryTimer",
    "NtFsControlFile",
    "NtWriteVirtualMemory",
    "NtCloseObjectAuditAlarm",
    "NtDuplicateObject",
    "NtQueryAttributesFile",
    "NtClearEvent",
    "NtReadVirtualMemory",
    "NtOpenEvent",
    "NtAdjustPrivilegesToken",
    "NtDuplicateToken",
    "NtContinue",
    "NtQueryDefaultUILanguage",
    "NtQueueApcThread",
    "NtYieldExecution",
    "NtAddAtom",
    "NtCreateEvent",
    "NtQueryVolumeInformationFile",
    "NtCreateSection",
    "NtFlushBuffersFile",
    "NtApphelpCacheControl",
    "NtCreateProcessEx",
    "NtCreateThread",
    "NtIsProcessInJob",
    "NtProtectVirtualMemory",
    "NtQuerySection",
    "NtResumeThread",
    "NtTerminateThread",
    "NtReadRequestData",
    "NtCreateFile",
    "NtQueryEvent",
    "NtWriteRequestData",
    "NtOpenDirectoryObject",
    "NtAccessCheckByTypeAndAuditAlarm",
    "NtQuerySystemTime",
    "NtWaitForMultipleObjects",
    "NtSetInformationObject",
    "NtCancelIoFile",
    "NtTraceEvent",
    "NtPowerInformation",
    "NtSetValueKey",
    "NtCancelTimer",
    "NtSetTimer",
    "NtAcceptConnectPort",
    "NtAccessCheck",
    "NtAccessCheckByType",
    "NtAccessCheckByTypeResultList",
    "NtAccessCheckByTypeResultListAndAuditAlarm",
    "NtAccessCheckByTypeResultListAndAuditAlarmByHandle",
    "NtAcquireCMFViewOwnership",
    "NtAddBootEntry",
    "NtAddDriverEntry",
    "NtAdjustGroupsToken",
    "NtAlertResumeThread",
    "NtAlertThread",
    "NtAllocateLocallyUniqueId",
    "NtAllocateUserPhysicalPages",
    "NtAllocateUuids",
    "NtAlpcAcceptConnectPort",
    "NtAlpcCancelMessage",
    "NtAlpcConnectPort",
    "NtAlpcCreatePort",
    "NtAlpcCreatePortSection",
    "NtAlpcCreateResourceReserve",
    "NtAlpcCreateSectionView",
    "NtAlpcCreateSecurityContext",
    "NtAlpcDeletePortSection",
    "NtAlpcDeleteResourceReserve",
    "NtAlpcDeleteSectionView",
    "NtAlpcDeleteSecurityContext",
    "NtAlpcDisconnectPort",
    "NtAlpcImpersonateClientOfPort",
    "NtAlpcOpenSenderProcess",
    "NtAlpcOpenSenderThread",
    "NtAlpcQueryInformation",
    "NtAlpcQueryInformationMessage",
    "NtAlpcRevokeSecurityContext",
    "NtAlpcSendWaitReceivePort",
    "NtAlpcSetInformation",
    "NtAreMappedFilesTheSame",
    "NtAssignProcessToJobObject",
    "NtSavepointTransaction",
    "NtCancelIoFileEx",
    "NtCancelSynchronousIoFile",
    "NtSavepointTransaction",
    "NtSavepointTransaction",
    "NtCommitComplete",
    "NtCommitEnlistment",
    "NtCommitTransaction",
    "NtCompactKeys",
    "NtCompareTokens",
    "NtCompleteConnectPort",
    "NtCompressKey",
    "NtConnectPort",
    "NtCreateDebugObject",
    "NtCreateDirectoryObject",
    "NtCreateEnlistment",
    "NtCreateEventPair",
    "NtCreateIoCompletion",
    "NtCreateJobObject",
    "NtCreateJobSet",
    "NtCreateKeyTransacted",
    "NtCreateKeyedEvent",
    "NtCreateMailslotFile",
    "NtCreateMutant",
    "NtCreateNamedPipeFile",
    "NtCreatePagingFile",
    "NtCreatePort",
    "NtCreatePrivateNamespace",
    "NtCreateProcess",
    "NtCreateProfile",
    "NtCreateResourceManager",
    "NtCreateSemaphore",
    "NtCreateSymbolicLinkObject",
    "NtCreateThreadEx",
    "NtCreateTimer",
    "NtCreateToken",
    "NtCreateTransaction",
    "NtCreateTransactionManager",
    "NtCreateUserProcess",
    "NtCreateWaitablePort",
    "NtCreateWorkerFactory",
    "NtDebugActiveProcess",
    "NtDebugContinue",
    "NtDeleteAtom",
    "NtDeleteBootEntry",
    "NtDeleteDriverEntry",
    "NtDeleteFile",
    "NtDeleteKey",
    "NtDeleteObjectAuditAlarm",
    "NtDeletePrivateNamespace",
    "NtDeleteValueKey",
    "NtDisplayString",
    "NtEnumerateBootEntries",
    "NtEnumerateDriverEntries",
    "NtEnumerateSystemEnvironmentValuesEx",
    "NtEnumerateTransactionObject",
    "NtExtendSection",
    "NtFilterToken",
    "NtFlushInstallUILanguage",
    "NtFlushInstructionCache",
    "NtFlushKey",
    "NtFlushProcessWriteBuffers",
    "NtFlushVirtualMemory",
    "NtFlushWriteBuffer",
    "NtFreeUserPhysicalPages",
    "NtFreezeRegistry",
    "NtFreezeTransactions",
    "NtGetContextThread",
    "NtGetCurrentProcessorNumber",
    "NtGetDevicePowerState",
    "NtGetMUIRegistryInfo",
    "NtGetNextProcess",
    "NtGetNextThread",
    "NtGetNlsSectionPtr",
    "NtGetNotificationResourceManager",
    "NtGetPlugPlayEvent",
    "NtGetWriteWatch",
    "NtImpersonateAnonymousToken",
    "NtImpersonateThread",
    "NtInitializeNlsFiles",
    "NtInitializeRegistry",
    "NtInitiatePowerAction",
    "NtIsSystemResumeAutomatic",
    "NtIsUILanguageComitted",
    "NtSavepointTransaction",
    "NtListenPort",
    "NtLoadDriver",
    "NtLoadKey",
    "NtLoadKey2",
    "NtLoadKeyEx",
    "NtLockFile",
    "NtLockProductActivationKeys",
    "NtLockRegistryKey",
    "NtLockVirtualMemory",
    "NtMakePermanentObject",
    "NtMakeTemporaryObject",
    "NtMapCMFModule",
    "NtMapUserPhysicalPages",
    "xKdSetupPciDeviceForDebugging",
    "NtModifyBootEntry",
    "NtModifyDriverEntry",
    "NtNotifyChangeDirectoryFile",
    "NtNotifyChangeKey",
    "NtNotifyChangeMultipleKeys",
    "NtOpenEnlistment",
    "NtOpenEventPair",
    "NtOpenIoCompletion",
    "NtOpenJobObject",
    "NtOpenKeyTransacted",
    "NtOpenKeyedEvent",
    "NtOpenMutant",
    "NtOpenObjectAuditAlarm",
    "NtOpenPrivateNamespace",
    "NtOpenProcessToken",
    "NtOpenResourceManager",
    "NtOpenSemaphore",
    "NtOpenSession",
    "NtOpenSymbolicLinkObject",
    "NtOpenThread",
    "NtOpenTimer",
    "NtOpenTransaction",
    "NtOpenTransactionManager",
    "NtPlugPlayControl",
    "NtPrePrepareComplete",
    "NtPrePrepareEnlistment",
    "NtPrepareComplete",
    "NtPrepareEnlistment",
    "NtPrivilegeCheck",
    "NtPrivilegeObjectAuditAlarm",
    "NtPrivilegedServiceAuditAlarm",
    "xKdSetupPciDeviceForDebugging",
    "xKdSetupPciDeviceForDebugging",
    "xKdSetupPciDeviceForDebugging",
    "NtPulseEvent",
    "NtQueryBootEntryOrder",
    "NtQueryBootOptions",
    "NtQueryDebugFilterState",
    "NtQueryDirectoryObject",
    "NtQueryDriverEntryOrder",
    "NtQueryEaFile",
    "NtQueryFullAttributesFile",
    "NtQueryInformationAtom",
    "NtQueryInformationEnlistment",
    "NtQueryInformationJobObject",
    "NtQueryInformationPort",
    "NtQueryInformationResourceManager",
    "NtQueryInformationTransaction",
    "NtQueryInformationTransactionManager",
    "NtQueryInformationWorkerFactory",
    "NtQueryInstallUILanguage",
    "NtQueryIntervalProfile",
    "NtQueryIoCompletion",
    "NtQueryLicenseValue",
    "NtQueryMultipleValueKey",
    "NtQueryMutant",
    "NtQueryOpenSubKeys",
    "NtQueryOpenSubKeysEx",
    "NtQueryPortInformationProcess",
    "NtQueryQuotaInformationFile",
    "NtQuerySecurityObject",
    "NtQuerySemaphore",
    "NtQuerySymbolicLinkObject",
    "NtQuerySystemEnvironmentValue",
    "NtQuerySystemEnvironmentValueEx",
    "NtQueryTimerResolution",
    "NtRaiseException",
    "NtRaiseHardError",
    "NtReadOnlyEnlistment",
    "NtRecoverEnlistment",
    "NtRecoverResourceManager",
    "NtRecoverTransactionManager",
    "KeRestoreFloatingPointState",
    "NtRegisterThreadTerminatePort",
    "NtReleaseCMFViewOwnership",
    "NtReleaseKeyedEvent",
    "NtReleaseWorkerFactoryWorker",
    "NtRemoveIoCompletionEx",
    "NtRemoveProcessDebug",
    "NtRenameKey",
    "NtReplaceKey",
    "NtReplyWaitReplyPort",
    "NtSavepointTransaction",
    "NtRequestPort",
    "NtRequestWakeupLatency",
    "NtResetEvent",
    "NtResetWriteWatch",
    "NtRestoreKey",
    "NtResumeProcess",
    "NtRollbackComplete",
    "NtRollbackEnlistment",
    "NtSavepointTransaction",
    "NtRollbackTransaction",
    "NtRollforwardTransactionManager",
    "NtSaveKey",
    "NtSaveKeyEx",
    "NtSaveMergedKeys",
    "NtSavepointTransaction",
    "NtSavepointTransaction",
    "NtSecureConnectPort",
    "NtSetBootEntryOrder",
    "NtSetBootOptions",
    "NtSetContextThread",
    "NtSetDebugFilterState",
    "NtSetDefaultHardErrorPort",
    "NtSetDefaultLocale",
    "NtSetDefaultUILanguage",
    "NtSetDriverEntryOrder",
    "NtSetEaFile",
    "NtSetHighEventPair",
    "NtSetHighWaitLowEventPair",
    "NtSetInformationDebugObject",
    "NtSetInformationEnlistment",
    "NtSetInformationJobObject",
    "NtSetInformationKey",
    "NtSetInformationResourceManager",
    "NtSetInformationToken",
    "NtSetInformationTransaction",
    "NtSetInformationTransactionManager",
    "NtSetInformationWorkerFactory",
    "NtSetIntervalProfile",
    "NtSetIoCompletion",
    "xKdSetupPciDeviceForDebugging",
    "NtSetLowEventPair",
    "NtSetLowWaitHighEventPair",
    "NtSetQuotaInformationFile",
    "NtSetSecurityObject",
    "NtSetSystemEnvironmentValue",
    "NtSetSystemEnvironmentValueEx",
    "NtSetSystemInformation",
    "NtSetSystemPowerState",
    "NtSetSystemTime",
    "NtSetThreadExecutionState",
    "NtSetTimerResolution",
    "NtSetUuidSeed",
    "NtSetVolumeInformationFile",
    "NtShutdownSystem",
    "NtShutdownWorkerFactory",
    "NtSignalAndWaitForSingleObject",
    "NtSinglePhaseReject",
    "NtStartProfile",
    "xHalGetInterruptTranslator",
    "NtStopProfile",
    "NtSuspendProcess",
    "NtSuspendThread",
    "NtSystemDebugControl",
    "NtTerminateJobObject",
    "NtTestAlert",
    "NtThawRegistry",
    "NtThawTransactions",
    "NtTraceControl",
    "NtTranslateFilePath",
    "NtUnloadDriver",
    "NtUnloadKey",
    "NtUnloadKey2",
    "NtUnloadKeyEx",
    "NtUnlockFile",
    "NtUnlockVirtualMemory",
    "NtVdmControl",
    "NtWaitForDebugEvent",
    "NtWaitForKeyedEvent",
    "NtWaitForWorkViaWorkerFactory",
    "NtWaitHighEventPair",
    "NtWaitLowEventPair",
    "NtWorkerFactoryWorkerReady"
};

//////////////////////////////////////////////////////////////////////////
// Windows Vista SP1 _KiServiceTable
//////////////////////////////////////////////////////////////////////////
static const char* KiServiceTable_VistaSp1_x64[] = {
    "NtMapUserPhysicalPagesScatter",
    "NtWaitForSingleObject",
    "NtCallbackReturn",
    "NtReadFile",
    "NtDeviceIoControlFile",
    "NtWriteFile",
    "NtRemoveIoCompletion",
    "NtReleaseSemaphore",
    "NtReplyWaitReceivePort",
    "NtReplyPort",
    "NtSetInformationThread",
    "NtSetEvent",
    "NtClose",
    "NtQueryObject",
    "NtQueryInformationFile",
    "NtOpenKey",
    "NtEnumerateValueKey",
    "NtFindAtom",
    "NtQueryDefaultLocale",
    "NtQueryKey",
    "NtQueryValueKey",
    "NtAllocateVirtualMemory",
    "NtQueryInformationProcess",
    "NtWaitForMultipleObjects32",
    "NtWriteFileGather",
    "NtSetInformationProcess",
    "NtCreateKey",
    "NtFreeVirtualMemory",
    "NtImpersonateClientOfPort",
    "NtReleaseMutant",
    "NtQueryInformationToken",
    "NtRequestWaitReplyPort",
    "NtQueryVirtualMemory",
    "NtOpenThreadToken",
    "NtQueryInformationThread",
    "NtOpenProcess",
    "NtSetInformationFile",
    "NtMapViewOfSection",
    "NtAccessCheckAndAuditAlarm",
    "NtUnmapViewOfSection",
    "NtReplyWaitReceivePortEx",
    "NtTerminateProcess",
    "NtSetEventBoostPriority",
    "NtReadFileScatter",
    "NtOpenThreadTokenEx",
    "NtOpenProcessTokenEx",
    "NtQueryPerformanceCounter",
    "NtEnumerateKey",
    "NtOpenFile",
    "NtDelayExecution",
    "NtQueryDirectoryFile",
    "NtQuerySystemInformation",
    "NtOpenSection",
    "NtQueryTimer",
    "NtFsControlFile",
    "NtWriteVirtualMemory",
    "NtCloseObjectAuditAlarm",
    "NtDuplicateObject",
    "NtQueryAttributesFile",
    "NtClearEvent",
    "NtReadVirtualMemory",
    "NtOpenEvent",
    "NtAdjustPrivilegesToken",
    "NtDuplicateToken",
    "NtContinue",
    "NtQueryDefaultUILanguage",
    "NtQueueApcThread",
    "NtYieldExecution",
    "NtAddAtom",
    "NtCreateEvent",
    "NtQueryVolumeInformationFile",
    "NtCreateSection",
    "NtFlushBuffersFile",
    "NtApphelpCacheControl",
    "NtCreateProcessEx",
    "NtCreateThread",
    "NtIsProcessInJob",
    "NtProtectVirtualMemory",
    "NtQuerySection",
    "NtResumeThread",
    "NtTerminateThread",
    "NtReadRequestData",
    "NtCreateFile",
    "NtQueryEvent",
    "NtWriteRequestData",
    "NtOpenDirectoryObject",
    "NtAccessCheckByTypeAndAuditAlarm",
    "NtQuerySystemTime",
    "NtWaitForMultipleObjects",
    "NtSetInformationObject",
    "NtCancelIoFile",
    "NtTraceEvent",
    "NtPowerInformation",
    "NtSetValueKey",
    "NtCancelTimer",
    "NtSetTimer",
    "NtAcceptConnectPort",
    "NtAccessCheck",
    "NtAccessCheckByType",
    "NtAccessCheckByTypeResultList",
    "NtAccessCheckByTypeResultListAndAuditAlarm",
    "NtAccessCheckByTypeResultListAndAuditAlarmByHandle",
    "NtAcquireCMFViewOwnership",
    "NtAddBootEntry",
    "NtAddDriverEntry",
    "NtAdjustGroupsToken",
    "NtAlertResumeThread",
    "NtAlertThread",
    "NtAllocateLocallyUniqueId",
    "NtAllocateUserPhysicalPages",
    "NtAllocateUuids",
    "NtAlpcAcceptConnectPort",
    "NtAlpcCancelMessage",
    "NtAlpcConnectPort",
    "NtAlpcCreatePort",
    "NtAlpcCreatePortSection",
    "NtAlpcCreateResourceReserve",
    "NtAlpcCreateSectionView",
    "NtAlpcCreateSecurityContext",
    "NtAlpcDeletePortSection",
    "NtAlpcDeleteResourceReserve",
    "NtAlpcDeleteSectionView",
    "NtAlpcDeleteSecurityContext",
    "NtAlpcDisconnectPort",
    "NtAlpcImpersonateClientOfPort",
    "NtAlpcOpenSenderProcess",
    "NtAlpcOpenSenderThread",
    "NtAlpcQueryInformation",
    "NtAlpcQueryInformationMessage",
    "NtAlpcRevokeSecurityContext",
    "NtAlpcSendWaitReceivePort",
    "NtAlpcSetInformation",
    "NtAreMappedFilesTheSame",
    "NtAssignProcessToJobObject",
    "xHalPostMicrocodeUpdate",
    "NtCancelIoFileEx",
    "NtCancelSynchronousIoFile",
    "NtCommitComplete",
    "NtCommitEnlistment",
    "NtCommitTransaction",
    "NtCompactKeys",
    "NtCompareTokens",
    "ArbPreprocessEntry",
    "NtCompressKey",
    "NtConnectPort",
    "NtCreateDebugObject",
    "NtCreateDirectoryObject",
    "NtCreateEnlistment",
    "NtCreateEventPair",
    "NtCreateIoCompletion",
    "NtCreateJobObject",
    "NtCreateJobSet",
    "NtCreateKeyTransacted",
    "NtCreateKeyedEvent",
    "NtCreateMailslotFile",
    "NtCreateMutant",
    "NtCreateNamedPipeFile",
    "NtCreatePagingFile",
    "NtCreatePort",
    "NtCreatePrivateNamespace",
    "NtCreateProcess",
    "NtCreateProfile",
    "NtCreateResourceManager",
    "NtCreateSemaphore",
    "NtCreateSymbolicLinkObject",
    "NtCreateThreadEx",
    "NtCreateTimer",
    "NtCreateToken",
    "NtCreateTransaction",
    "NtCreateTransactionManager",
    "NtCreateUserProcess",
    "NtCreateWaitablePort",
    "NtCreateWorkerFactory",
    "NtDebugActiveProcess",
    "NtDebugContinue",
    "NtDeleteAtom",
    "NtDeleteBootEntry",
    "NtDeleteDriverEntry",
    "NtDeleteFile",
    "NtDeleteKey",
    "NtDeleteObjectAuditAlarm",
    "NtDeletePrivateNamespace",
    "NtDeleteValueKey",
    "NtDisplayString",
    "NtEnumerateBootEntries",
    "NtEnumerateDriverEntries",
    "NtEnumerateSystemEnvironmentValuesEx",
    "NtEnumerateTransactionObject",
    "NtExtendSection",
    "NtFilterToken",
    "NtFlushInstallUILanguage",
    "NtFlushInstructionCache",
    "NtFlushKey",
    "NtFlushProcessWriteBuffers",
    "NtFlushVirtualMemory",
    "NtFlushWriteBuffer",
    "NtFreeUserPhysicalPages",
    "NtFreezeRegistry",
    "NtFreezeTransactions",
    "NtGetContextThread",
    "NtGetCurrentProcessorNumber",
    "NtGetDevicePowerState",
    "NtGetMUIRegistryInfo",
    "NtGetNextProcess",
    "NtGetNextThread",
    "NtGetNlsSectionPtr",
    "NtGetNotificationResourceManager",
    "NtGetPlugPlayEvent",
    "NtGetWriteWatch",
    "NtImpersonateAnonymousToken",
    "NtImpersonateThread",
    "NtInitializeNlsFiles",
    "NtInitializeRegistry",
    "NtInitiatePowerAction",
    "NtIsSystemResumeAutomatic",
    "NtIsUILanguageComitted",
    "NtListenPort",
    "NtLoadDriver",
    "NtLoadKey",
    "NtLoadKey2",
    "NtLoadKeyEx",
    "NtLockFile",
    "NtLockProductActivationKeys",
    "NtLockRegistryKey",
    "NtLockVirtualMemory",
    "NtMakePermanentObject",
    "NtMakeTemporaryObject",
    "NtMapCMFModule",
    "NtMapUserPhysicalPages",
    "NtModifyBootEntry",
    "NtModifyDriverEntry",
    "NtNotifyChangeDirectoryFile",
    "NtNotifyChangeKey",
    "NtNotifyChangeMultipleKeys",
    "NtOpenEnlistment",
    "NtOpenEventPair",
    "NtOpenIoCompletion",
    "NtOpenJobObject",
    "NtOpenKeyTransacted",
    "NtOpenKeyedEvent",
    "NtOpenMutant",
    "NtOpenObjectAuditAlarm",
    "NtOpenPrivateNamespace",
    "NtOpenProcessToken",
    "NtOpenResourceManager",
    "NtOpenSemaphore",
    "NtOpenSession",
    "NtOpenSymbolicLinkObject",
    "NtOpenThread",
    "NtOpenTimer",
    "NtOpenTransaction",
    "NtOpenTransactionManager",
    "NtPlugPlayControl",
    "NtPrePrepareComplete",
    "NtPrePrepareEnlistment",
    "NtPrepareComplete",
    "NtPrepareEnlistment",
    "NtPrivilegeCheck",
    "NtPrivilegeObjectAuditAlarm",
    "NtPrivilegedServiceAuditAlarm",
    "NtPropagationComplete",
    "NtPropagationFailed",
    "NtPulseEvent",
    "NtQueryBootEntryOrder",
    "NtQueryBootOptions",
    "NtQueryDebugFilterState",
    "NtQueryDirectoryObject",
    "NtQueryDriverEntryOrder",
    "NtQueryEaFile",
    "NtQueryFullAttributesFile",
    "NtQueryInformationAtom",
    "NtQueryInformationEnlistment",
    "NtQueryInformationJobObject",
    "NtQueryInformationPort",
    "NtQueryInformationResourceManager",
    "NtQueryInformationTransaction",
    "NtQueryInformationTransactionManager",
    "NtQueryInformationWorkerFactory",
    "NtQueryInstallUILanguage",
    "NtQueryIntervalProfile",
    "NtQueryIoCompletion",
    "NtQueryLicenseValue",
    "NtQueryMultipleValueKey",
    "NtQueryMutant",
    "NtQueryOpenSubKeys",
    "NtQueryOpenSubKeysEx",
    "NtQueryPortInformationProcess",
    "NtQueryQuotaInformationFile",
    "NtQuerySecurityObject",
    "NtQuerySemaphore",
    "NtQuerySymbolicLinkObject",
    "NtQuerySystemEnvironmentValue",
    "NtQuerySystemEnvironmentValueEx",
    "NtQueryTimerResolution",
    "NtRaiseException",
    "NtRaiseHardError",
    "NtReadOnlyEnlistment",
    "NtRecoverEnlistment",
    "NtRecoverResourceManager",
    "NtRecoverTransactionManager",
    "NtRegisterProtocolAddressInformation",
    "NtRegisterThreadTerminatePort",
    "NtReleaseCMFViewOwnership",
    "NtReleaseKeyedEvent",
    "NtReleaseWorkerFactoryWorker",
    "NtRemoveIoCompletionEx",
    "NtRemoveProcessDebug",
    "NtRenameKey",
    "NtRenameTransactionManager",
    "NtReplaceKey",
    "NtReplacePartitionUnit",
    "NtReplyWaitReplyPort",
    "xHalPostMicrocodeUpdate",
    "NtRequestPort",
    "NtRequestWakeupLatency",
    "NtResetEvent",
    "NtResetWriteWatch",
    "NtRestoreKey",
    "NtResumeProcess",
    "NtRollbackComplete",
    "NtRollbackEnlistment",
    "NtRollbackTransaction",
    "NtRollforwardTransactionManager",
    "NtSaveKey",
    "NtSaveKeyEx",
    "NtSaveMergedKeys",
    "NtSecureConnectPort",
    "NtSetBootEntryOrder",
    "NtSetBootOptions",
    "NtSetContextThread",
    "NtSetDebugFilterState",
    "NtSetDefaultHardErrorPort",
    "NtSetDefaultLocale",
    "NtSetDefaultUILanguage",
    "NtSetDriverEntryOrder",
    "NtSetEaFile",
    "NtSetHighEventPair",
    "NtSetHighWaitLowEventPair",
    "NtSetInformationDebugObject",
    "NtSetInformationEnlistment",
    "NtSetInformationJobObject",
    "NtSetInformationKey",
    "NtSetInformationResourceManager",
    "NtSetInformationToken",
    "NtSetInformationTransaction",
    "NtSetInformationTransactionManager",
    "NtSetInformationWorkerFactory",
    "NtSetIntervalProfile",
    "NtSetIoCompletion",
    "xKdSetupPciDeviceForDebugging",
    "NtSetLowEventPair",
    "NtSetLowWaitHighEventPair",
    "NtSetQuotaInformationFile",
    "NtSetSecurityObject",
    "NtSetSystemEnvironmentValue",
    "NtSetSystemEnvironmentValueEx",
    "NtSetSystemInformation",
    "NtSetSystemPowerState",
    "NtSetSystemTime",
    "NtSetThreadExecutionState",
    "NtSetTimerResolution",
    "NtSetUuidSeed",
    "NtSetVolumeInformationFile",
    "NtShutdownSystem",
    "NtShutdownWorkerFactory",
    "NtSignalAndWaitForSingleObject",
    "NtSinglePhaseReject",
    "NtStartProfile",
    "NtStopProfile",
    "NtSuspendProcess",
    "NtSuspendThread",
    "NtSystemDebugControl",
    "NtTerminateJobObject",
    "NtTestAlert",
    "NtThawRegistry",
    "NtThawTransactions",
    "NtTraceControl",
    "NtTranslateFilePath",
    "NtUnloadDriver",
    "NtUnloadKey",
    "NtUnloadKey2",
    "NtUnloadKeyEx",
    "NtUnlockFile",
    "NtUnlockVirtualMemory",
    "NtVdmControl",
    "NtWaitForDebugEvent",
    "NtWaitForKeyedEvent",
    "NtWaitForWorkViaWorkerFactory",
    "NtWaitHighEventPair",
    "NtWaitLowEventPair",
    "NtWorkerFactoryWorkerReady"
};

//////////////////////////////////////////////////////////////////////////
// Windows Vista SP2 _KiServiceTable
//////////////////////////////////////////////////////////////////////////
static const char* KiServiceTable_VistaSp2_x64[] = {
    "NtMapUserPhysicalPagesScatter",
    "NtWaitForSingleObject",
    "NtCallbackReturn",
    "NtReadFile",
    "NtDeviceIoControlFile",
    "NtWriteFile",
    "NtRemoveIoCompletion",
    "NtReleaseSemaphore",
    "NtReplyWaitReceivePort",
    "NtReplyPort",
    "NtSetInformationThread",
    "NtSetEvent",
    "NtClose",
    "NtQueryObject",
    "NtQueryInformationFile",
    "NtOpenKey",
    "NtEnumerateValueKey",
    "NtFindAtom",
    "NtQueryDefaultLocale",
    "NtQueryKey",
    "NtQueryValueKey",
    "NtAllocateVirtualMemory",
    "NtQueryInformationProcess",
    "NtWaitForMultipleObjects32",
    "NtWriteFileGather",
    "NtSetInformationProcess",
    "NtCreateKey",
    "NtFreeVirtualMemory",
    "NtImpersonateClientOfPort",
    "NtReleaseMutant",
    "NtQueryInformationToken",
    "NtRequestWaitReplyPort",
    "NtQueryVirtualMemory",
    "NtOpenThreadToken",
    "NtQueryInformationThread",
    "NtOpenProcess",
    "NtSetInformationFile",
    "NtMapViewOfSection",
    "NtAccessCheckAndAuditAlarm",
    "NtUnmapViewOfSection",
    "NtReplyWaitReceivePortEx",
    "NtTerminateProcess",
    "NtSetEventBoostPriority",
    "NtReadFileScatter",
    "NtOpenThreadTokenEx",
    "NtOpenProcessTokenEx",
    "NtQueryPerformanceCounter",
    "NtEnumerateKey",
    "NtOpenFile",
    "NtDelayExecution",
    "NtQueryDirectoryFile",
    "NtQuerySystemInformation",
    "NtOpenSection",
    "NtQueryTimer",
    "NtFsControlFile",
    "NtWriteVirtualMemory",
    "NtCloseObjectAuditAlarm",
    "NtDuplicateObject",
    "NtQueryAttributesFile",
    "NtClearEvent",
    "NtReadVirtualMemory",
    "NtOpenEvent",
    "NtAdjustPrivilegesToken",
    "NtDuplicateToken",
    "NtContinue",
    "NtQueryDefaultUILanguage",
    "NtQueueApcThread",
    "NtYieldExecution",
    "NtAddAtom",
    "NtCreateEvent",
    "NtQueryVolumeInformationFile",
    "NtCreateSection",
    "NtFlushBuffersFile",
    "NtApphelpCacheControl",
    "NtCreateProcessEx",
    "NtCreateThread",
    "NtIsProcessInJob",
    "NtProtectVirtualMemory",
    "NtQuerySection",
    "NtResumeThread",
    "NtTerminateThread",
    "NtReadRequestData",
    "NtCreateFile",
    "NtQueryEvent",
    "NtWriteRequestData",
    "NtOpenDirectoryObject",
    "NtAccessCheckByTypeAndAuditAlarm",
    "NtQuerySystemTime",
    "NtWaitForMultipleObjects",
    "NtSetInformationObject",
    "NtCancelIoFile",
    "NtTraceEvent",
    "NtPowerInformation",
    "NtSetValueKey",
    "NtCancelTimer",
    "NtSetTimer",
    "NtAcceptConnectPort",
    "NtAccessCheck",
    "NtAccessCheckByType",
    "NtAccessCheckByTypeResultList",
    "NtAccessCheckByTypeResultListAndAuditAlarm",
    "NtAccessCheckByTypeResultListAndAuditAlarmByHandle",
    "NtAcquireCMFViewOwnership",
    "NtAddBootEntry",
    "NtAddDriverEntry",
    "NtAdjustGroupsToken",
    "NtAlertResumeThread",
    "NtAlertThread",
    "NtAllocateLocallyUniqueId",
    "NtAllocateUserPhysicalPages",
    "NtAllocateUuids",
    "NtAlpcAcceptConnectPort",
    "NtAlpcCancelMessage",
    "NtAlpcConnectPort",
    "NtAlpcCreatePort",
    "NtAlpcCreatePortSection",
    "NtAlpcCreateResourceReserve",
    "NtAlpcCreateSectionView",
    "NtAlpcCreateSecurityContext",
    "NtAlpcDeletePortSection",
    "NtAlpcDeleteResourceReserve",
    "NtAlpcDeleteSectionView",
    "NtAlpcDeleteSecurityContext",
    "NtAlpcDisconnectPort",
    "NtAlpcImpersonateClientOfPort",
    "NtAlpcOpenSenderProcess",
    "NtAlpcOpenSenderThread",
    "NtAlpcQueryInformation",
    "NtAlpcQueryInformationMessage",
    "NtAlpcRevokeSecurityContext",
    "NtAlpcSendWaitReceivePort",
    "NtAlpcSetInformation",
    "NtAreMappedFilesTheSame",
    "NtAssignProcessToJobObject",
    "xHalUnloadMicrocode",
    "NtCancelIoFileEx",
    "NtCancelSynchronousIoFile",
    "NtCommitComplete",
    "NtCommitEnlistment",
    "NtCommitTransaction",
    "NtCompactKeys",
    "NtCompareTokens",
    "NtCompleteConnectPort",
    "NtCompressKey",
    "NtConnectPort",
    "NtCreateDebugObject",
    "NtCreateDirectoryObject",
    "NtCreateEnlistment",
    "NtCreateEventPair",
    "NtCreateIoCompletion",
    "NtCreateJobObject",
    "NtCreateJobSet",
    "NtCreateKeyTransacted",
    "NtCreateKeyedEvent",
    "NtCreateMailslotFile",
    "NtCreateMutant",
    "NtCreateNamedPipeFile",
    "NtCreatePagingFile",
    "NtCreatePort",
    "NtCreatePrivateNamespace",
    "NtCreateProcess",
    "NtCreateProfile",
    "NtCreateResourceManager",
    "NtCreateSemaphore",
    "NtCreateSymbolicLinkObject",
    "NtCreateThreadEx",
    "NtCreateTimer",
    "NtCreateToken",
    "NtCreateTransaction",
    "NtCreateTransactionManager",
    "NtCreateUserProcess",
    "NtCreateWaitablePort",
    "NtCreateWorkerFactory",
    "NtDebugActiveProcess",
    "NtDebugContinue",
    "NtDeleteAtom",
    "NtDeleteBootEntry",
    "NtDeleteDriverEntry",
    "NtDeleteFile",
    "NtDeleteKey",
    "NtDeleteObjectAuditAlarm",
    "NtDeletePrivateNamespace",
    "NtDeleteValueKey",
    "NtDisplayString",
    "NtEnumerateBootEntries",
    "NtEnumerateDriverEntries",
    "NtEnumerateSystemEnvironmentValuesEx",
    "NtEnumerateTransactionObject",
    "NtExtendSection",
    "NtFilterToken",
    "NtFlushInstallUILanguage",
    "NtFlushInstructionCache",
    "NtFlushKey",
    "NtFlushProcessWriteBuffers",
    "NtFlushVirtualMemory",
    "NtFlushWriteBuffer",
    "NtFreeUserPhysicalPages",
    "NtFreezeRegistry",
    "NtFreezeTransactions",
    "NtGetContextThread",
    "NtGetCurrentProcessorNumber",
    "NtGetDevicePowerState",
    "NtGetMUIRegistryInfo",
    "NtGetNextProcess",
    "NtGetNextThread",
    "NtGetNlsSectionPtr",
    "NtGetNotificationResourceManager",
    "NtGetPlugPlayEvent",
    "NtGetWriteWatch",
    "NtImpersonateAnonymousToken",
    "NtImpersonateThread",
    "NtInitializeNlsFiles",
    "NtInitializeRegistry",
    "NtInitiatePowerAction",
    "NtIsSystemResumeAutomatic",
    "NtIsUILanguageComitted",
    "NtListenPort",
    "NtLoadDriver",
    "NtLoadKey",
    "NtLoadKey2",
    "NtLoadKeyEx",
    "NtLockFile",
    "NtLockProductActivationKeys",
    "NtLockRegistryKey",
    "NtLockVirtualMemory",
    "NtMakePermanentObject",
    "NtMakeTemporaryObject",
    "NtMapCMFModule",
    "NtMapUserPhysicalPages",
    "NtModifyBootEntry",
    "NtModifyDriverEntry",
    "NtNotifyChangeDirectoryFile",
    "NtNotifyChangeKey",
    "NtNotifyChangeMultipleKeys",
    "NtOpenEnlistment",
    "NtOpenEventPair",
    "NtOpenIoCompletion",
    "NtOpenJobObject",
    "NtOpenKeyTransacted",
    "NtOpenKeyedEvent",
    "NtOpenMutant",
    "NtOpenObjectAuditAlarm",
    "NtOpenPrivateNamespace",
    "NtOpenProcessToken",
    "NtOpenResourceManager",
    "NtOpenSemaphore",
    "NtOpenSession",
    "NtOpenSymbolicLinkObject",
    "NtOpenThread",
    "NtOpenTimer",
    "NtOpenTransaction",
    "NtOpenTransactionManager",
    "NtPlugPlayControl",
    "NtPrePrepareComplete",
    "NtPrePrepareEnlistment",
    "NtPrepareComplete",
    "NtPrepareEnlistment",
    "NtPrivilegeCheck",
    "NtPrivilegeObjectAuditAlarm",
    "NtPrivilegedServiceAuditAlarm",
    "NtPropagationComplete",
    "NtPropagationFailed",
    "NtPulseEvent",
    "NtQueryBootEntryOrder",
    "NtQueryBootOptions",
    "NtQueryDebugFilterState",
    "NtQueryDirectoryObject",
    "NtQueryDriverEntryOrder",
    "NtQueryEaFile",
    "NtQueryFullAttributesFile",
    "NtQueryInformationAtom",
    "NtQueryInformationEnlistment",
    "NtQueryInformationJobObject",
    "NtQueryInformationPort",
    "NtQueryInformationResourceManager",
    "NtQueryInformationTransaction",
    "NtQueryInformationTransactionManager",
    "NtQueryInformationWorkerFactory",
    "NtQueryInstallUILanguage",
    "NtQueryIntervalProfile",
    "NtQueryIoCompletion",
    "NtQueryLicenseValue",
    "NtQueryMultipleValueKey",
    "NtQueryMutant",
    "NtQueryOpenSubKeys",
    "NtQueryOpenSubKeysEx",
    "NtQueryPortInformationProcess",
    "NtQueryQuotaInformationFile",
    "NtQuerySecurityObject",
    "NtQuerySemaphore",
    "NtQuerySymbolicLinkObject",
    "NtQuerySystemEnvironmentValue",
    "NtQuerySystemEnvironmentValueEx",
    "NtQueryTimerResolution",
    "NtRaiseException",
    "NtRaiseHardError",
    "NtReadOnlyEnlistment",
    "NtRecoverEnlistment",
    "NtRecoverResourceManager",
    "NtRecoverTransactionManager",
    "NtRegisterProtocolAddressInformation",
    "NtRegisterThreadTerminatePort",
    "NtReleaseCMFViewOwnership",
    "NtReleaseKeyedEvent",
    "NtReleaseWorkerFactoryWorker",
    "NtRemoveIoCompletionEx",
    "NtRemoveProcessDebug",
    "NtRenameKey",
    "NtRenameTransactionManager",
    "NtReplaceKey",
    "NtReplacePartitionUnit",
    "NtReplyWaitReplyPort",
    "xHalUnloadMicrocode",
    "NtRequestPort",
    "NtRequestWakeupLatency",
    "NtResetEvent",
    "NtResetWriteWatch",
    "NtRestoreKey",
    "NtResumeProcess",
    "NtRollbackComplete",
    "NtRollbackEnlistment",
    "NtRollbackTransaction",
    "NtRollforwardTransactionManager",
    "NtSaveKey",
    "NtSaveKeyEx",
    "NtSaveMergedKeys",
    "NtSecureConnectPort",
    "NtSetBootEntryOrder",
    "NtSetBootOptions",
    "NtSetContextThread",
    "NtSetDebugFilterState",
    "NtSetDefaultHardErrorPort",
    "NtSetDefaultLocale",
    "NtSetDefaultUILanguage",
    "NtSetDriverEntryOrder",
    "NtSetEaFile",
    "NtSetHighEventPair",
    "NtSetHighWaitLowEventPair",
    "NtSetInformationDebugObject",
    "NtSetInformationEnlistment",
    "NtSetInformationJobObject",
    "NtSetInformationKey",
    "NtSetInformationResourceManager",
    "NtSetInformationToken",
    "NtSetInformationTransaction",
    "NtSetInformationTransactionManager",
    "NtSetInformationWorkerFactory",
    "NtSetIntervalProfile",
    "NtSetIoCompletion",
    "PspSetProcessIoHandlers",
    "NtSetLowEventPair",
    "NtSetLowWaitHighEventPair",
    "NtSetQuotaInformationFile",
    "NtSetSecurityObject",
    "NtSetSystemEnvironmentValue",
    "NtSetSystemEnvironmentValueEx",
    "NtSetSystemInformation",
    "NtSetSystemPowerState",
    "NtSetSystemTime",
    "NtSetThreadExecutionState",
    "NtSetTimerResolution",
    "NtSetUuidSeed",
    "NtSetVolumeInformationFile",
    "NtShutdownSystem",
    "NtShutdownWorkerFactory",
    "NtSignalAndWaitForSingleObject",
    "NtSinglePhaseReject",
    "NtStartProfile",
    "NtStopProfile",
    "NtSuspendProcess",
    "NtSuspendThread",
    "NtSystemDebugControl",
    "NtTerminateJobObject",
    "NtTestAlert",
    "NtThawRegistry",
    "NtThawTransactions",
    "NtTraceControl",
    "NtTranslateFilePath",
    "NtUnloadDriver",
    "NtUnloadKey",
    "NtUnloadKey2",
    "NtUnloadKeyEx",
    "NtUnlockFile",
    "NtUnlockVirtualMemory",
    "NtVdmControl",
    "NtWaitForDebugEvent",
    "NtWaitForKeyedEvent",
    "NtWaitForWorkViaWorkerFactory",
    "NtWaitHighEventPair",
    "NtWaitLowEventPair",
    "NtWorkerFactoryWorkerReady"
};

//////////////////////////////////////////////////////////////////////////
// Windows 7 SP0 _KiServiceTable
//////////////////////////////////////////////////////////////////////////
static const char* KiServiceTable_Win7Sp0_x64[] = {
    "NtMapUserPhysicalPagesScatter",
    "NtWaitForSingleObject",
    "NtCallbackReturn",
    "NtReadFile",
    "NtDeviceIoControlFile",
    "NtWriteFile",
    "NtRemoveIoCompletion",
    "NtReleaseSemaphore",
    "NtReplyWaitReceivePort",
    "NtReplyPort",
    "NtSetInformationThread",
    "NtSetEvent",
    "NtClose",
    "NtQueryObject",
    "NtQueryInformationFile",
    "NtOpenKey",
    "NtEnumerateValueKey",
    "NtFindAtom",
    "NtQueryDefaultLocale",
    "NtQueryKey",
    "NtQueryValueKey",
    "NtAllocateVirtualMemory",
    "NtQueryInformationProcess",
    "NtWaitForMultipleObjects32",
    "NtWriteFileGather",
    "NtSetInformationProcess",
    "NtCreateKey",
    "NtFreeVirtualMemory",
    "NtImpersonateClientOfPort",
    "NtReleaseMutant",
    "NtQueryInformationToken",
    "NtRequestWaitReplyPort",
    "NtQueryVirtualMemory",
    "NtOpenThreadToken",
    "NtQueryInformationThread",
    "NtOpenProcess",
    "NtSetInformationFile",
    "NtMapViewOfSection",
    "NtAccessCheckAndAuditAlarm",
    "NtUnmapViewOfSection",
    "NtReplyWaitReceivePortEx",
    "NtTerminateProcess",
    "NtSetEventBoostPriority",
    "NtReadFileScatter",
    "NtOpenThreadTokenEx",
    "NtOpenProcessTokenEx",
    "NtQueryPerformanceCounter",
    "NtEnumerateKey",
    "NtOpenFile",
    "NtDelayExecution",
    "NtQueryDirectoryFile",
    "NtQuerySystemInformation",
    "NtOpenSection",
    "NtQueryTimer",
    "NtFsControlFile",
    "NtWriteVirtualMemory",
    "NtCloseObjectAuditAlarm",
    "NtDuplicateObject",
    "NtQueryAttributesFile",
    "NtClearEvent",
    "NtReadVirtualMemory",
    "NtOpenEvent",
    "NtAdjustPrivilegesToken",
    "NtDuplicateToken",
    "NtContinue",
    "NtQueryDefaultUILanguage",
    "NtQueueApcThread",
    "NtYieldExecution",
    "NtAddAtom",
    "NtCreateEvent",
    "NtQueryVolumeInformationFile",
    "NtCreateSection",
    "NtFlushBuffersFile",
    "NtApphelpCacheControl",
    "NtCreateProcessEx",
    "NtCreateThread",
    "NtIsProcessInJob",
    "NtProtectVirtualMemory",
    "NtQuerySection",
    "NtResumeThread",
    "NtTerminateThread",
    "NtReadRequestData",
    "NtCreateFile",
    "NtQueryEvent",
    "NtWriteRequestData",
    "NtOpenDirectoryObject",
    "NtAccessCheckByTypeAndAuditAlarm",
    "NtQuerySystemTime",
    "NtWaitForMultipleObjects",
    "NtSetInformationObject",
    "NtCancelIoFile",
    "NtTraceEvent",
    "NtPowerInformation",
    "NtSetValueKey",
    "NtCancelTimer",
    "NtSetTimer",
    "NtAcceptConnectPort",
    "NtAccessCheck",
    "NtAccessCheckByType",
    "NtAccessCheckByTypeResultList",
    "NtAccessCheckByTypeResultListAndAuditAlarm",
    "NtAccessCheckByTypeResultListAndAuditAlarmByHandle",
    "NtAddBootEntry",
    "NtAddDriverEntry",
    "NtAdjustGroupsToken",
    "NtAlertResumeThread",
    "NtAlertThread",
    "NtAllocateLocallyUniqueId",
    "NtAllocateReserveObject",
    "NtAllocateUserPhysicalPages",
    "NtAllocateUuids",
    "NtAlpcAcceptConnectPort",
    "NtAlpcCancelMessage",
    "NtAlpcConnectPort",
    "NtAlpcCreatePort",
    "NtAlpcCreatePortSection",
    "NtAlpcCreateResourceReserve",
    "NtAlpcCreateSectionView",
    "NtAlpcCreateSecurityContext",
    "NtAlpcDeletePortSection",
    "NtAlpcDeleteResourceReserve",
    "NtAlpcDeleteSectionView",
    "NtAlpcDeleteSecurityContext",
    "NtAlpcDisconnectPort",
    "NtAlpcImpersonateClientOfPort",
    "NtAlpcOpenSenderProcess",
    "NtAlpcOpenSenderThread",
    "NtAlpcQueryInformation",
    "NtAlpcQueryInformationMessage",
    "NtAlpcRevokeSecurityContext",
    "NtAlpcSendWaitReceivePort",
    "NtAlpcSetInformation",
    "NtAreMappedFilesTheSame",
    "NtAssignProcessToJobObject",
    "NtCancelIoFileEx",
    "NtCancelSynchronousIoFile",
    "NtCommitComplete",
    "NtCommitEnlistment",
    "NtCommitTransaction",
    "NtCompactKeys",
    "NtCompareTokens",
    "NtCompleteConnectPort",
    "NtCompressKey",
    "NtConnectPort",
    "NtCreateDebugObject",
    "NtCreateDirectoryObject",
    "NtCreateEnlistment",
    "NtCreateEventPair",
    "NtCreateIoCompletion",
    "NtCreateJobObject",
    "NtCreateJobSet",
    "NtCreateKeyTransacted",
    "NtCreateKeyedEvent",
    "NtCreateMailslotFile",
    "NtCreateMutant",
    "NtCreateNamedPipeFile",
    "NtCreatePagingFile",
    "NtCreatePort",
    "NtCreatePrivateNamespace",
    "NtCreateProcess",
    "NtCreateProfile",
    "NtCreateProfileEx",
    "NtCreateResourceManager",
    "NtCreateSemaphore",
    "NtCreateSymbolicLinkObject",
    "NtCreateThreadEx",
    "NtCreateTimer",
    "NtCreateToken",
    "NtCreateTransaction",
    "NtCreateTransactionManager",
    "NtCreateUserProcess",
    "NtCreateWaitablePort",
    "NtCreateWorkerFactory",
    "NtDebugActiveProcess",
    "NtDebugContinue",
    "NtDeleteAtom",
    "NtDeleteBootEntry",
    "NtDeleteDriverEntry",
    "NtDeleteFile",
    "NtDeleteKey",
    "NtDeleteObjectAuditAlarm",
    "NtDeletePrivateNamespace",
    "NtDeleteValueKey",
    "NtDisableLastKnownGood",
    "NtDisplayString",
    "NtDrawText",
    "NtEnableLastKnownGood",
    "NtEnumerateBootEntries",
    "NtEnumerateDriverEntries",
    "NtEnumerateSystemEnvironmentValuesEx",
    "NtEnumerateTransactionObject",
    "NtExtendSection",
    "NtFilterToken",
    "NtFlushInstallUILanguage",
    "NtFlushInstructionCache",
    "NtFlushKey",
    "NtFlushProcessWriteBuffers",
    "NtFlushVirtualMemory",
    "NtFlushWriteBuffer",
    "NtFreeUserPhysicalPages",
    "NtFreezeRegistry",
    "NtFreezeTransactions",
    "NtGetContextThread",
    "NtGetCurrentProcessorNumber",
    "NtGetDevicePowerState",
    "NtGetMUIRegistryInfo",
    "NtGetNextProcess",
    "NtGetNextThread",
    "NtGetNlsSectionPtr",
    "NtGetNotificationResourceManager",
    "NtGetPlugPlayEvent",
    "NtGetWriteWatch",
    "NtImpersonateAnonymousToken",
    "NtImpersonateThread",
    "NtInitializeNlsFiles",
    "NtInitializeRegistry",
    "NtInitiatePowerAction",
    "NtIsSystemResumeAutomatic",
    "NtIsUILanguageComitted",
    "NtListenPort",
    "NtLoadDriver",
    "NtLoadKey",
    "NtLoadKey2",
    "NtLoadKeyEx",
    "NtLockFile",
    "NtLockProductActivationKeys",
    "NtLockRegistryKey",
    "NtLockVirtualMemory",
    "NtMakePermanentObject",
    "NtMakeTemporaryObject",
    "NtMapCMFModule",
    "NtMapUserPhysicalPages",
    "NtModifyBootEntry",
    "NtModifyDriverEntry",
    "NtNotifyChangeDirectoryFile",
    "NtNotifyChangeKey",
    "NtNotifyChangeMultipleKeys",
    "NtNotifyChangeSession",
    "NtOpenEnlistment",
    "NtOpenEventPair",
    "NtOpenIoCompletion",
    "NtOpenJobObject",
    "NtOpenKeyEx",
    "NtOpenKeyTransacted",
    "NtOpenKeyTransactedEx",
    "NtOpenKeyedEvent",
    "NtOpenMutant",
    "NtOpenObjectAuditAlarm",
    "NtOpenPrivateNamespace",
    "NtOpenProcessToken",
    "NtOpenResourceManager",
    "NtOpenSemaphore",
    "NtOpenSession",
    "NtOpenSymbolicLinkObject",
    "NtOpenThread",
    "NtOpenTimer",
    "NtOpenTransaction",
    "NtOpenTransactionManager",
    "NtPlugPlayControl",
    "NtPrePrepareComplete",
    "NtPrePrepareEnlistment",
    "NtPrepareComplete",
    "NtPrepareEnlistment",
    "NtPrivilegeCheck",
    "NtPrivilegeObjectAuditAlarm",
    "NtPrivilegedServiceAuditAlarm",
    "NtPropagationComplete",
    "NtPropagationFailed",
    "NtPulseEvent",
    "NtQueryBootEntryOrder",
    "NtQueryBootOptions",
    "NtQueryDebugFilterState",
    "NtQueryDirectoryObject",
    "NtQueryDriverEntryOrder",
    "NtQueryEaFile",
    "NtQueryFullAttributesFile",
    "NtQueryInformationAtom",
    "NtQueryInformationEnlistment",
    "NtQueryInformationJobObject",
    "NtQueryInformationPort",
    "NtQueryInformationResourceManager",
    "NtQueryInformationTransaction",
    "NtQueryInformationTransactionManager",
    "NtQueryInformationWorkerFactory",
    "NtQueryInstallUILanguage",
    "NtQueryIntervalProfile",
    "NtQueryIoCompletion",
    "NtQueryLicenseValue",
    "NtQueryMultipleValueKey",
    "NtQueryMutant",
    "NtQueryOpenSubKeys",
    "NtQueryOpenSubKeysEx",
    "NtQueryPortInformationProcess",
    "NtQueryQuotaInformationFile",
    "NtQuerySecurityAttributesToken",
    "NtQuerySecurityObject",
    "NtQuerySemaphore",
    "NtQuerySymbolicLinkObject",
    "NtQuerySystemEnvironmentValue",
    "NtQuerySystemEnvironmentValueEx",
    "NtQuerySystemInformationEx",
    "NtQueryTimerResolution",
    "NtQueueApcThreadEx",
    "NtRaiseException",
    "NtRaiseHardError",
    "NtReadOnlyEnlistment",
    "NtRecoverEnlistment",
    "NtRecoverResourceManager",
    "NtRecoverTransactionManager",
    "NtRegisterProtocolAddressInformation",
    "NtRegisterThreadTerminatePort",
    "NtReleaseKeyedEvent",
    "NtReleaseWorkerFactoryWorker",
    "NtRemoveIoCompletionEx",
    "NtRemoveProcessDebug",
    "NtRenameKey",
    "NtRenameTransactionManager",
    "NtReplaceKey",
    "NtReplacePartitionUnit",
    "NtReplyWaitReplyPort",
    "NtRequestPort",
    "NtResetEvent",
    "NtResetWriteWatch",
    "NtRestoreKey",
    "NtResumeProcess",
    "NtRollbackComplete",
    "NtRollbackEnlistment",
    "NtRollbackTransaction",
    "NtRollforwardTransactionManager",
    "NtSaveKey",
    "NtSaveKeyEx",
    "NtSaveMergedKeys",
    "NtSecureConnectPort",
    "NtSerializeBoot",
    "NtSetBootEntryOrder",
    "NtSetBootOptions",
    "NtSetContextThread",
    "NtSetDebugFilterState",
    "NtSetDefaultHardErrorPort",
    "NtSetDefaultLocale",
    "NtSetDefaultUILanguage",
    "NtSetDriverEntryOrder",
    "NtSetEaFile",
    "NtSetHighEventPair",
    "NtSetHighWaitLowEventPair",
    "NtSetInformationDebugObject",
    "NtSetInformationEnlistment",
    "NtSetInformationJobObject",
    "NtSetInformationKey",
    "NtSetInformationResourceManager",
    "NtSetInformationToken",
    "NtSetInformationTransaction",
    "NtSetInformationTransactionManager",
    "NtSetInformationWorkerFactory",
    "NtSetIntervalProfile",
    "NtSetIoCompletion",
    "NtSetIoCompletionEx",
    "PspQueryDescriptorThread",
    "NtSetLowEventPair",
    "NtSetLowWaitHighEventPair",
    "NtSetQuotaInformationFile",
    "NtSetSecurityObject",
    "NtSetSystemEnvironmentValue",
    "NtSetSystemEnvironmentValueEx",
    "NtSetSystemInformation",
    "NtSetSystemPowerState",
    "NtSetSystemTime",
    "NtSetThreadExecutionState",
    "NtSetTimerEx",
    "NtSetTimerResolution",
    "NtSetUuidSeed",
    "NtSetVolumeInformationFile",
    "NtShutdownSystem",
    "NtShutdownWorkerFactory",
    "NtSignalAndWaitForSingleObject",
    "NtSinglePhaseReject",
    "NtStartProfile",
    "NtStopProfile",
    "NtSuspendProcess",
    "NtSuspendThread",
    "NtSystemDebugControl",
    "NtTerminateJobObject",
    "NtTestAlert",
    "NtThawRegistry",
    "NtThawTransactions",
    "NtTraceControl",
    "NtTranslateFilePath",
    "NtUmsThreadYield",
    "NtUnloadDriver",
    "NtUnloadKey",
    "NtUnloadKey2",
    "NtUnloadKeyEx",
    "NtUnlockFile",
    "NtUnlockVirtualMemory",
    "NtVdmControl",
    "NtWaitForDebugEvent",
    "NtWaitForKeyedEvent",
    "NtWaitForWorkViaWorkerFactory",
    "NtWaitHighEventPair",
    "NtWaitLowEventPair",
    "NtWorkerFactoryWorkerReady"
};

//////////////////////////////////////////////////////////////////////////
// Windows 7 SP1 _KiServiceTable
//////////////////////////////////////////////////////////////////////////
static const char* KiServiceTable_Win7Sp1_x64[] = {
    "NtMapUserPhysicalPagesScatter",
    "NtWaitForSingleObject",
    "NtCallbackReturn",
    "NtReadFile",
    "NtDeviceIoControlFile",
    "NtWriteFile",
    "NtRemoveIoCompletion",
    "NtReleaseSemaphore",
    "NtReplyWaitReceivePort",
    "NtReplyPort",
    "NtSetInformationThread",
    "NtSetEvent",
    "NtClose",
    "NtQueryObject",
    "NtQueryInformationFile",
    "NtOpenKey",
    "NtEnumerateValueKey",
    "NtFindAtom",
    "NtQueryDefaultLocale",
    "NtQueryKey",
    "NtQueryValueKey",
    "NtAllocateVirtualMemory",
    "NtQueryInformationProcess",
    "NtWaitForMultipleObjects32",
    "NtWriteFileGather",
    "NtSetInformationProcess",
    "NtCreateKey",
    "NtFreeVirtualMemory",
    "NtImpersonateClientOfPort",
    "NtReleaseMutant",
    "NtQueryInformationToken",
    "NtRequestWaitReplyPort",
    "NtQueryVirtualMemory",
    "NtOpenThreadToken",
    "NtQueryInformationThread",
    "NtOpenProcess",
    "NtSetInformationFile",
    "NtMapViewOfSection",
    "NtAccessCheckAndAuditAlarm",
    "NtUnmapViewOfSection",
    "NtReplyWaitReceivePortEx",
    "NtTerminateProcess",
    "NtSetEventBoostPriority",
    "NtReadFileScatter",
    "NtOpenThreadTokenEx",
    "NtOpenProcessTokenEx",
    "NtQueryPerformanceCounter",
    "NtEnumerateKey",
    "NtOpenFile",
    "NtDelayExecution",
    "NtQueryDirectoryFile",
    "NtQuerySystemInformation",
    "NtOpenSection",
    "NtQueryTimer",
    "NtFsControlFile",
    "NtWriteVirtualMemory",
    "NtCloseObjectAuditAlarm",
    "NtDuplicateObject",
    "NtQueryAttributesFile",
    "NtClearEvent",
    "NtReadVirtualMemory",
    "NtOpenEvent",
    "NtAdjustPrivilegesToken",
    "NtDuplicateToken",
    "NtContinue",
    "NtQueryDefaultUILanguage",
    "NtQueueApcThread",
    "NtYieldExecution",
    "NtAddAtom",
    "NtCreateEvent",
    "NtQueryVolumeInformationFile",
    "NtCreateSection",
    "NtFlushBuffersFile",
    "NtApphelpCacheControl",
    "NtCreateProcessEx",
    "NtCreateThread",
    "NtIsProcessInJob",
    "NtProtectVirtualMemory",
    "NtQuerySection",
    "NtResumeThread",
    "NtTerminateThread",
    "NtReadRequestData",
    "NtCreateFile",
    "NtQueryEvent",
    "NtWriteRequestData",
    "NtOpenDirectoryObject",
    "NtAccessCheckByTypeAndAuditAlarm",
    "NtQuerySystemTime",
    "NtWaitForMultipleObjects",
    "NtSetInformationObject",
    "NtCancelIoFile",
    "NtTraceEvent",
    "NtPowerInformation",
    "NtSetValueKey",
    "NtCancelTimer",
    "NtSetTimer",
    "NtAcceptConnectPort",
    "NtAccessCheck",
    "NtAccessCheckByType",
    "NtAccessCheckByTypeResultList",
    "NtAccessCheckByTypeResultListAndAuditAlarm",
    "NtAccessCheckByTypeResultListAndAuditAlarmByHandle",
    "NtAddBootEntry",
    "NtAddDriverEntry",
    "NtAdjustGroupsToken",
    "NtAlertResumeThread",
    "NtAlertThread",
    "NtAllocateLocallyUniqueId",
    "NtAllocateReserveObject",
    "NtAllocateUserPhysicalPages",
    "NtAllocateUuids",
    "NtAlpcAcceptConnectPort",
    "NtAlpcCancelMessage",
    "NtAlpcConnectPort",
    "NtAlpcCreatePort",
    "NtAlpcCreatePortSection",
    "NtAlpcCreateResourceReserve",
    "NtAlpcCreateSectionView",
    "NtAlpcCreateSecurityContext",
    "NtAlpcDeletePortSection",
    "NtAlpcDeleteResourceReserve",
    "NtAlpcDeleteSectionView",
    "NtAlpcDeleteSecurityContext",
    "NtAlpcDisconnectPort",
    "NtAlpcImpersonateClientOfPort",
    "NtAlpcOpenSenderProcess",
    "NtAlpcOpenSenderThread",
    "NtAlpcQueryInformation",
    "NtAlpcQueryInformationMessage",
    "NtAlpcRevokeSecurityContext",
    "NtAlpcSendWaitReceivePort",
    "NtAlpcSetInformation",
    "NtAreMappedFilesTheSame",
    "NtAssignProcessToJobObject",
    "NtCancelIoFileEx",
    "NtCancelSynchronousIoFile",
    "NtCommitComplete",
    "NtCommitEnlistment",
    "NtCommitTransaction",
    "NtCompactKeys",
    "NtCompareTokens",
    "TmpOpenTransactionManager",
    "NtCompressKey",
    "NtConnectPort",
    "NtCreateDebugObject",
    "NtCreateDirectoryObject",
    "NtCreateEnlistment",
    "NtCreateEventPair",
    "NtCreateIoCompletion",
    "NtCreateJobObject",
    "NtCreateJobSet",
    "NtCreateKeyTransacted",
    "NtCreateKeyedEvent",
    "NtCreateMailslotFile",
    "NtCreateMutant",
    "NtCreateNamedPipeFile",
    "NtCreatePagingFile",
    "NtCreatePort",
    "NtCreatePrivateNamespace",
    "NtCreateProcess",
    "NtCreateProfile",
    "NtCreateProfileEx",
    "NtCreateResourceManager",
    "NtCreateSemaphore",
    "NtCreateSymbolicLinkObject",
    "NtCreateThreadEx",
    "NtCreateTimer",
    "NtCreateToken",
    "NtCreateTransaction",
    "NtCreateTransactionManager",
    "NtCreateUserProcess",
    "NtCreateWaitablePort",
    "NtCreateWorkerFactory",
    "NtDebugActiveProcess",
    "NtDebugContinue",
    "NtDeleteAtom",
    "NtDeleteBootEntry",
    "NtDeleteDriverEntry",
    "NtDeleteFile",
    "NtDeleteKey",
    "NtDeleteObjectAuditAlarm",
    "NtDeletePrivateNamespace",
    "NtDeleteValueKey",
    "NtDisableLastKnownGood",
    "NtDisplayString",
    "NtDrawText",
    "NtEnableLastKnownGood",
    "NtEnumerateBootEntries",
    "NtEnumerateDriverEntries",
    "NtEnumerateSystemEnvironmentValuesEx",
    "NtEnumerateTransactionObject",
    "NtExtendSection",
    "NtFilterToken",
    "NtFlushInstallUILanguage",
    "NtFlushInstructionCache",
    "NtFlushKey",
    "NtFlushProcessWriteBuffers",
    "NtFlushVirtualMemory",
    "NtFlushWriteBuffer",
    "NtFreeUserPhysicalPages",
    "NtFreezeRegistry",
    "NtFreezeTransactions",
    "NtGetContextThread",
    "NtGetCurrentProcessorNumber",
    "NtGetDevicePowerState",
    "NtGetMUIRegistryInfo",
    "NtGetNextProcess",
    "NtGetNextThread",
    "NtGetNlsSectionPtr",
    "NtGetNotificationResourceManager",
    "NtGetPlugPlayEvent",
    "NtGetWriteWatch",
    "NtImpersonateAnonymousToken",
    "NtImpersonateThread",
    "NtInitializeNlsFiles",
    "NtInitializeRegistry",
    "NtInitiatePowerAction",
    "NtIsSystemResumeAutomatic",
    "NtIsUILanguageComitted",
    "NtListenPort",
    "NtLoadDriver",
    "NtLoadKey",
    "NtLoadKey2",
    "NtLoadKeyEx",
    "NtLockFile",
    "NtLockProductActivationKeys",
    "NtLockRegistryKey",
    "NtLockVirtualMemory",
    "NtMakePermanentObject",
    "NtMakeTemporaryObject",
    "NtMapCMFModule",
    "NtMapUserPhysicalPages",
    "NtModifyBootEntry",
    "NtModifyDriverEntry",
    "NtNotifyChangeDirectoryFile",
    "NtNotifyChangeKey",
    "NtNotifyChangeMultipleKeys",
    "NtNotifyChangeSession",
    "NtOpenEnlistment",
    "NtOpenEventPair",
    "NtOpenIoCompletion",
    "NtOpenJobObject",
    "NtOpenKeyEx",
    "NtOpenKeyTransacted",
    "NtOpenKeyTransactedEx",
    "NtOpenKeyedEvent",
    "NtOpenMutant",
    "NtOpenObjectAuditAlarm",
    "NtOpenPrivateNamespace",
    "NtOpenProcessToken",
    "NtOpenResourceManager",
    "NtOpenSemaphore",
    "NtOpenSession",
    "NtOpenSymbolicLinkObject",
    "NtOpenThread",
    "NtOpenTimer",
    "NtOpenTransaction",
    "NtOpenTransactionManager",
    "NtPlugPlayControl",
    "NtPrePrepareComplete",
    "NtPrePrepareEnlistment",
    "NtPrepareComplete",
    "NtPrepareEnlistment",
    "NtPrivilegeCheck",
    "NtPrivilegeObjectAuditAlarm",
    "NtPrivilegedServiceAuditAlarm",
    "NtPropagationComplete",
    "NtPropagationFailed",
    "NtPulseEvent",
    "NtQueryBootEntryOrder",
    "NtQueryBootOptions",
    "NtQueryDebugFilterState",
    "NtQueryDirectoryObject",
    "NtQueryDriverEntryOrder",
    "NtQueryEaFile",
    "NtQueryFullAttributesFile",
    "NtQueryInformationAtom",
    "NtQueryInformationEnlistment",
    "NtQueryInformationJobObject",
    "NtQueryInformationPort",
    "NtQueryInformationResourceManager",
    "NtQueryInformationTransaction",
    "NtQueryInformationTransactionManager",
    "NtQueryInformationWorkerFactory",
    "NtQueryInstallUILanguage",
    "NtQueryIntervalProfile",
    "NtQueryIoCompletion",
    "NtQueryLicenseValue",
    "NtQueryMultipleValueKey",
    "NtQueryMutant",
    "NtQueryOpenSubKeys",
    "NtQueryOpenSubKeysEx",
    "NtQueryPortInformationProcess",
    "NtQueryQuotaInformationFile",
    "NtQuerySecurityAttributesToken",
    "NtQuerySecurityObject",
    "NtQuerySemaphore",
    "NtQuerySymbolicLinkObject",
    "NtQuerySystemEnvironmentValue",
    "NtQuerySystemEnvironmentValueEx",
    "NtQuerySystemInformationEx",
    "NtQueryTimerResolution",
    "NtQueueApcThreadEx",
    "NtRaiseException",
    "NtRaiseHardError",
    "NtReadOnlyEnlistment",
    "NtRecoverEnlistment",
    "NtRecoverResourceManager",
    "NtRecoverTransactionManager",
    "NtRegisterProtocolAddressInformation",
    "NtRegisterThreadTerminatePort",
    "NtReleaseKeyedEvent",
    "NtReleaseWorkerFactoryWorker",
    "NtRemoveIoCompletionEx",
    "NtRemoveProcessDebug",
    "NtRenameKey",
    "NtRenameTransactionManager",
    "NtReplaceKey",
    "NtReplacePartitionUnit",
    "NtReplyWaitReplyPort",
    "NtRequestPort",
    "NtResetEvent",
    "NtResetWriteWatch",
    "NtRestoreKey",
    "NtResumeProcess",
    "NtRollbackComplete",
    "NtRollbackEnlistment",
    "NtRollbackTransaction",
    "NtRollforwardTransactionManager",
    "NtSaveKey",
    "NtSaveKeyEx",
    "NtSaveMergedKeys",
    "NtSecureConnectPort",
    "NtSerializeBoot",
    "NtSetBootEntryOrder",
    "NtSetBootOptions",
    "NtSetContextThread",
    "NtSetDebugFilterState",
    "NtSetDefaultHardErrorPort",
    "NtSetDefaultLocale",
    "NtSetDefaultUILanguage",
    "NtSetDriverEntryOrder",
    "NtSetEaFile",
    "NtSetHighEventPair",
    "NtSetHighWaitLowEventPair",
    "NtSetInformationDebugObject",
    "NtSetInformationEnlistment",
    "NtSetInformationJobObject",
    "NtSetInformationKey",
    "NtSetInformationResourceManager",
    "NtSetInformationToken",
    "NtSetInformationTransaction",
    "NtSetInformationTransactionManager",
    "NtSetInformationWorkerFactory",
    "NtSetIntervalProfile",
    "NtSetIoCompletion",
    "NtSetIoCompletionEx",
    "xHalAllocateMapRegisters",
    "NtSetLowEventPair",
    "NtSetLowWaitHighEventPair",
    "NtSetQuotaInformationFile",
    "NtSetSecurityObject",
    "NtSetSystemEnvironmentValue",
    "NtSetSystemEnvironmentValueEx",
    "NtSetSystemInformation",
    "NtSetSystemPowerState",
    "NtSetSystemTime",
    "NtSetThreadExecutionState",
    "NtSetTimerEx",
    "NtSetTimerResolution",
    "NtSetUuidSeed",
    "NtSetVolumeInformationFile",
    "NtShutdownSystem",
    "NtShutdownWorkerFactory",
    "NtSignalAndWaitForSingleObject",
    "NtSinglePhaseReject",
    "NtStartProfile",
    "NtStopProfile",
    "NtSuspendProcess",
    "NtSuspendThread",
    "NtSystemDebugControl",
    "NtTerminateJobObject",
    "NtTestAlert",
    "NtThawRegistry",
    "NtThawTransactions",
    "NtTraceControl",
    "NtTranslateFilePath",
    "NtUmsThreadYield",
    "NtUnloadDriver",
    "NtUnloadKey",
    "NtUnloadKey2",
    "NtUnloadKeyEx",
    "NtUnlockFile",
    "NtUnlockVirtualMemory",
    "NtVdmControl",
    "NtWaitForDebugEvent",
    "NtWaitForKeyedEvent",
    "NtWaitForWorkViaWorkerFactory",
    "NtWaitHighEventPair",
    "NtWaitLowEventPair",
    "NtWorkerFactoryWorkerReady"
};

//////////////////////////////////////////////////////////////////////////
// Windows 8 SP0 _KiServiceTable
//////////////////////////////////////////////////////////////////////////
static const char* KiServiceTable_Win8Sp0_x64[] = {
    "NtWorkerFactoryWorkerReady",
    "NtMapUserPhysicalPagesScatter",
    "NtWaitForSingleObject",
    "NtCallbackReturn",
    "NtReadFile",
    "NtDeviceIoControlFile",
    "NtWriteFile",
    "NtRemoveIoCompletion",
    "NtReleaseSemaphore",
    "NtReplyWaitReceivePort",
    "NtReplyPort",
    "NtSetInformationThread",
    "NtSetEvent",
    "NtClose",
    "NtQueryObject",
    "NtQueryInformationFile",
    "NtOpenKey",
    "NtEnumerateValueKey",
    "NtFindAtom",
    "NtQueryDefaultLocale",
    "NtQueryKey",
    "NtQueryValueKey",
    "NtAllocateVirtualMemory",
    "NtQueryInformationProcess",
    "NtWaitForMultipleObjects32",
    "NtWriteFileGather",
    "NtSetInformationProcess",
    "NtCreateKey",
    "NtFreeVirtualMemory",
    "NtImpersonateClientOfPort",
    "NtReleaseMutant",
    "NtQueryInformationToken",
    "NtRequestWaitReplyPort",
    "NtQueryVirtualMemory",
    "NtOpenThreadToken",
    "NtQueryInformationThread",
    "NtOpenProcess",
    "NtSetInformationFile",
    "NtMapViewOfSection",
    "NtAccessCheckAndAuditAlarm",
    "NtUnmapViewOfSection",
    "NtReplyWaitReceivePortEx",
    "NtTerminateProcess",
    "NtSetEventBoostPriority",
    "NtReadFileScatter",
    "NtOpenThreadTokenEx",
    "NtOpenProcessTokenEx",
    "NtQueryPerformanceCounter",
    "NtEnumerateKey",
    "NtOpenFile",
    "NtDelayExecution",
    "NtQueryDirectoryFile",
    "NtQuerySystemInformation",
    "NtOpenSection",
    "NtQueryTimer",
    "NtFsControlFile",
    "NtWriteVirtualMemory",
    "NtCloseObjectAuditAlarm",
    "NtDuplicateObject",
    "NtQueryAttributesFile",
    "NtClearEvent",
    "NtReadVirtualMemory",
    "NtOpenEvent",
    "NtAdjustPrivilegesToken",
    "NtDuplicateToken",
    "NtContinue",
    "NtQueryDefaultUILanguage",
    "NtQueueApcThread",
    "NtYieldExecution",
    "NtAddAtom",
    "NtCreateEvent",
    "NtQueryVolumeInformationFile",
    "NtCreateSection",
    "NtFlushBuffersFile",
    "NtApphelpCacheControl",
    "NtCreateProcessEx",
    "NtCreateThread",
    "NtIsProcessInJob",
    "NtProtectVirtualMemory",
    "NtQuerySection",
    "NtResumeThread",
    "NtTerminateThread",
    "NtReadRequestData",
    "NtCreateFile",
    "NtQueryEvent",
    "NtWriteRequestData",
    "NtOpenDirectoryObject",
    "NtAccessCheckByTypeAndAuditAlarm",
    "NtQuerySystemTime",
    "NtWaitForMultipleObjects",
    "NtSetInformationObject",
    "NtCancelIoFile",
    "NtTraceEvent",
    "NtPowerInformation",
    "NtSetValueKey",
    "NtCancelTimer",
    "NtSetTimer",
    "NtAcceptConnectPort",
    "NtAccessCheck",
    "NtAccessCheckByType",
    "NtAccessCheckByTypeResultList",
    "NtAccessCheckByTypeResultListAndAuditAlarm",
    "NtAccessCheckByTypeResultListAndAuditAlarmByHandle",
    "NtAddAtomEx",
    "NtAddBootEntry",
    "NtAddDriverEntry",
    "NtAdjustGroupsToken",
    "NtAdjustTokenClaimsAndDeviceGroups",
    "NtAlertResumeThread",
    "NtAlertThread",
    "NtAlertThreadByThreadId",
    "NtAllocateLocallyUniqueId",
    "NtAllocateReserveObject",
    "NtAllocateUserPhysicalPages",
    "NtAllocateUuids",
    "NtAlpcAcceptConnectPort",
    "NtAlpcCancelMessage",
    "NtAlpcConnectPort",
    "NtAlpcConnectPortEx",
    "NtAlpcCreatePort",
    "NtAlpcCreatePortSection",
    "NtAlpcCreateResourceReserve",
    "NtAlpcCreateSectionView",
    "NtAlpcCreateSecurityContext",
    "NtAlpcDeletePortSection",
    "NtAlpcDeleteResourceReserve",
    "NtAlpcDeleteSectionView",
    "NtAlpcDeleteSecurityContext",
    "NtAlpcDisconnectPort",
    "NtAlpcImpersonateClientOfPort",
    "NtAlpcOpenSenderProcess",
    "NtAlpcOpenSenderThread",
    "NtAlpcQueryInformation",
    "NtAlpcQueryInformationMessage",
    "NtAlpcRevokeSecurityContext",
    "NtAlpcSendWaitReceivePort",
    "NtAlpcSetInformation",
    "NtAreMappedFilesTheSame",
    "NtAssignProcessToJobObject",
    "NtAssociateWaitCompletionPacket",
    "NtCancelIoFileEx",
    "NtCancelSynchronousIoFile",
    "NtCancelWaitCompletionPacket",
    "NtCommitComplete",
    "NtCommitEnlistment",
    "NtCommitTransaction",
    "NtCompactKeys",
    "NtCompareTokens",
    "ArbPreprocessEntry",
    "NtCompressKey",
    "NtConnectPort",
    "NtCreateDebugObject",
    "NtCreateDirectoryObject",
    "NtCreateDirectoryObjectEx",
    "NtCreateEnlistment",
    "NtCreateEventPair",
    "NtCreateIRTimer",
    "NtCreateIoCompletion",
    "NtCreateJobObject",
    "ArbAddReserved",
    "NtCreateKeyTransacted",
    "NtCreateKeyedEvent",
    "NtCreateLowBoxToken",
    "NtCreateMailslotFile",
    "NtCreateMutant",
    "NtCreateNamedPipeFile",
    "NtCreatePagingFile",
    "NtCreatePort",
    "NtCreatePrivateNamespace",
    "NtCreateProcess",
    "NtCreateProfile",
    "NtCreateProfileEx",
    "NtCreateResourceManager",
    "NtCreateSemaphore",
    "NtCreateSymbolicLinkObject",
    "NtCreateThreadEx",
    "NtCreateTimer",
    "NtCreateToken",
    "NtCreateTokenEx",
    "NtCreateTransaction",
    "NtCreateTransactionManager",
    "NtCreateUserProcess",
    "NtCreateWaitCompletionPacket",
    "NtCreateWaitablePort",
    "NtCreateWnfStateName",
    "NtCreateWorkerFactory",
    "NtDebugActiveProcess",
    "NtDebugContinue",
    "NtDeleteAtom",
    "NtDeleteBootEntry",
    "NtDeleteDriverEntry",
    "NtDeleteFile",
    "NtDeleteKey",
    "NtDeleteObjectAuditAlarm",
    "NtDeletePrivateNamespace",
    "NtDeleteValueKey",
    "NtDeleteWnfStateData",
    "NtDeleteWnfStateName",
    "NtDisableLastKnownGood",
    "NtDisplayString",
    "NtDrawText",
    "NtEnableLastKnownGood",
    "NtEnumerateBootEntries",
    "NtEnumerateDriverEntries",
    "NtEnumerateSystemEnvironmentValuesEx",
    "NtEnumerateTransactionObject",
    "NtExtendSection",
    "NtFilterBootOption",
    "NtFilterToken",
    "NtAdjustTokenClaimsAndDeviceGroups",
    "NtFlushBuffersFileEx",
    "NtFlushInstallUILanguage",
    "ArbPreprocessEntry",
    "NtFlushKey",
    "NtFlushProcessWriteBuffers",
    "NtFlushVirtualMemory",
    "NtFlushWriteBuffer",
    "NtFreeUserPhysicalPages",
    "NtFreezeRegistry",
    "NtFreezeTransactions",
    "NtGetCachedSigningLevel",
    "NtGetContextThread",
    "NtGetCurrentProcessorNumber",
    "NtGetDevicePowerState",
    "NtGetMUIRegistryInfo",
    "NtGetNextProcess",
    "NtGetNextThread",
    "NtGetNlsSectionPtr",
    "NtGetNotificationResourceManager",
    "NtGetWriteWatch",
    "NtImpersonateAnonymousToken",
    "NtImpersonateThread",
    "NtInitializeNlsFiles",
    "NtInitializeRegistry",
    "NtInitiatePowerAction",
    "NtIsSystemResumeAutomatic",
    "NtIsUILanguageComitted",
    "NtListenPort",
    "NtLoadDriver",
    "NtLoadKey",
    "NtLoadKey2",
    "NtLoadKeyEx",
    "NtLockFile",
    "NtLockProductActivationKeys",
    "NtLockRegistryKey",
    "NtLockVirtualMemory",
    "NtMakePermanentObject",
    "NtMakeTemporaryObject",
    "NtMapCMFModule",
    "NtMapUserPhysicalPages",
    "NtModifyBootEntry",
    "NtModifyDriverEntry",
    "NtNotifyChangeDirectoryFile",
    "NtNotifyChangeKey",
    "NtNotifyChangeMultipleKeys",
    "NtNotifyChangeSession",
    "NtOpenEnlistment",
    "NtOpenEventPair",
    "NtOpenIoCompletion",
    "NtOpenJobObject",
    "NtOpenKeyEx",
    "NtOpenKeyTransacted",
    "NtOpenKeyTransactedEx",
    "NtOpenKeyedEvent",
    "NtOpenMutant",
    "NtOpenObjectAuditAlarm",
    "NtOpenPrivateNamespace",
    "NtOpenProcessToken",
    "NtOpenResourceManager",
    "NtOpenSemaphore",
    "NtOpenSession",
    "NtOpenSymbolicLinkObject",
    "NtOpenThread",
    "NtOpenTimer",
    "NtOpenTransaction",
    "NtOpenTransactionManager",
    "NtPlugPlayControl",
    "NtPrePrepareComplete",
    "NtPrePrepareEnlistment",
    "NtPrepareComplete",
    "NtPrepareEnlistment",
    "NtPrivilegeCheck",
    "NtPrivilegeObjectAuditAlarm",
    "NtPrivilegedServiceAuditAlarm",
    "NtPropagationComplete",
    "NtPropagationFailed",
    "NtPulseEvent",
    "NtQueryBootEntryOrder",
    "NtQueryBootOptions",
    "NtQueryDebugFilterState",
    "NtQueryDirectoryObject",
    "NtQueryDriverEntryOrder",
    "NtQueryEaFile",
    "NtQueryFullAttributesFile",
    "NtQueryInformationAtom",
    "NtQueryInformationEnlistment",
    "NtQueryInformationJobObject",
    "NtQueryInformationPort",
    "NtQueryInformationResourceManager",
    "NtQueryInformationTransaction",
    "NtQueryInformationTransactionManager",
    "NtQueryInformationWorkerFactory",
    "NtQueryInstallUILanguage",
    "NtQueryIntervalProfile",
    "NtQueryIoCompletion",
    "NtQueryLicenseValue",
    "NtQueryMultipleValueKey",
    "NtQueryMutant",
    "NtQueryOpenSubKeys",
    "NtQueryOpenSubKeysEx",
    "NtQueryPortInformationProcess",
    "NtQueryQuotaInformationFile",
    "NtQuerySecurityAttributesToken",
    "NtQuerySecurityObject",
    "NtQuerySemaphore",
    "NtQuerySymbolicLinkObject",
    "NtQuerySystemEnvironmentValue",
    "NtQuerySystemEnvironmentValueEx",
    "NtQuerySystemInformationEx",
    "NtQueryTimerResolution",
    "NtQueryWnfStateData",
    "NtQueryWnfStateNameInformation",
    "NtQueueApcThreadEx",
    "NtRaiseException",
    "NtRaiseHardError",
    "NtReadOnlyEnlistment",
    "NtRecoverEnlistment",
    "NtRecoverResourceManager",
    "NtRecoverTransactionManager",
    "NtRegisterProtocolAddressInformation",
    "NtRegisterThreadTerminatePort",
    "NtReleaseKeyedEvent",
    "NtReleaseWorkerFactoryWorker",
    "NtRemoveIoCompletionEx",
    "NtRemoveProcessDebug",
    "NtRenameKey",
    "NtRenameTransactionManager",
    "NtReplaceKey",
    "NtReplacePartitionUnit",
    "NtReplyWaitReplyPort",
    "NtRequestPort",
    "NtResetEvent",
    "NtResetWriteWatch",
    "NtRestoreKey",
    "NtResumeProcess",
    "NtRollbackComplete",
    "NtRollbackEnlistment",
    "NtRollbackTransaction",
    "NtRollforwardTransactionManager",
    "NtSaveKey",
    "NtSaveKeyEx",
    "NtSaveMergedKeys",
    "NtSecureConnectPort",
    "NtSerializeBoot",
    "NtSetBootEntryOrder",
    "NtSetBootOptions",
    "NtSetCachedSigningLevel",
    "NtSetContextThread",
    "NtSetDebugFilterState",
    "NtSetDefaultHardErrorPort",
    "NtSetDefaultLocale",
    "NtSetDefaultUILanguage",
    "NtSetDriverEntryOrder",
    "NtSetEaFile",
    "NtSetHighEventPair",
    "NtSetHighWaitLowEventPair",
    "NtSetIRTimer",
    "NtSetInformationDebugObject",
    "NtSetInformationEnlistment",
    "NtSetInformationJobObject",
    "NtSetInformationKey",
    "NtSetInformationResourceManager",
    "NtSetInformationToken",
    "NtSetInformationTransaction",
    "NtSetInformationTransactionManager",
    "NtSetInformationVirtualMemory",
    "NtSetInformationWorkerFactory",
    "NtSetIntervalProfile",
    "NtSetIoCompletion",
    "NtSetIoCompletionEx",
    "CcTestControl",
    "NtSetLowEventPair",
    "NtSetLowWaitHighEventPair",
    "NtSetQuotaInformationFile",
    "NtSetSecurityObject",
    "NtSetSystemEnvironmentValue",
    "NtSetSystemEnvironmentValueEx",
    "NtSetSystemInformation",
    "NtSetSystemPowerState",
    "NtSetSystemTime",
    "NtSetThreadExecutionState",
    "NtSetTimerEx",
    "NtSetTimerResolution",
    "NtSetUuidSeed",
    "NtSetVolumeInformationFile",
    "NtShutdownSystem",
    "NtShutdownWorkerFactory",
    "NtSignalAndWaitForSingleObject",
    "NtSinglePhaseReject",
    "NtStartProfile",
    "NtStopProfile",
    "NtSubscribeWnfStateChange",
    "NtSuspendProcess",
    "NtSuspendThread",
    "NtSystemDebugControl",
    "NtTerminateJobObject",
    "NtTestAlert",
    "NtThawRegistry",
    "NtThawTransactions",
    "NtTraceControl",
    "NtTranslateFilePath",
    "NtUmsThreadYield",
    "NtUnloadDriver",
    "NtUnloadKey",
    "NtUnloadKey2",
    "NtUnloadKeyEx",
    "NtUnlockFile",
    "NtUnlockVirtualMemory",
    "NtUnmapViewOfSectionEx",
    "NtUnsubscribeWnfStateChange",
    "NtUpdateWnfStateData",
    "NtAdjustTokenClaimsAndDeviceGroups",
    "NtWaitForAlertByThreadId",
    "NtWaitForDebugEvent",
    "NtWaitForKeyedEvent",
    "NtWaitForWnfNotifications",
    "NtWaitForWorkViaWorkerFactory",
    "NtWaitHighEventPair",
    "NtWaitLowEventPair"
};

//////////////////////////////////////////////////////////////////////////
// Windows 8 SP1 _KiServiceTable
//////////////////////////////////////////////////////////////////////////
static const char* KiServiceTable_Win8Sp1_x64[] = {
    "NtWorkerFactoryWorkerReady",
    "NtAcceptConnectPort",
    "NtMapUserPhysicalPagesScatter",
    "NtWaitForSingleObject",
    "NtCallbackReturn",
    "NtReadFile",
    "NtDeviceIoControlFile",
    "NtWriteFile",
    "NtRemoveIoCompletion",
    "NtReleaseSemaphore",
    "NtReplyWaitReceivePort",
    "NtReplyPort",
    "NtSetInformationThread",
    "NtSetEvent",
    "NtClose",
    "NtQueryObject",
    "NtQueryInformationFile",
    "NtOpenKey",
    "NtEnumerateValueKey",
    "NtFindAtom",
    "NtQueryDefaultLocale",
    "NtQueryKey",
    "NtQueryValueKey",
    "NtAllocateVirtualMemory",
    "NtQueryInformationProcess",
    "NtWaitForMultipleObjects32",
    "NtWriteFileGather",
    "NtSetInformationProcess",
    "NtCreateKey",
    "NtFreeVirtualMemory",
    "NtImpersonateClientOfPort",
    "NtReleaseMutant",
    "NtQueryInformationToken",
    "NtRequestWaitReplyPort",
    "NtQueryVirtualMemory",
    "NtOpenThreadToken",
    "NtQueryInformationThread",
    "NtOpenProcess",
    "NtSetInformationFile",
    "NtMapViewOfSection",
    "NtAccessCheckAndAuditAlarm",
    "NtUnmapViewOfSection",
    "NtReplyWaitReceivePortEx",
    "NtTerminateProcess",
    "NtSetEventBoostPriority",
    "NtReadFileScatter",
    "NtOpenThreadTokenEx",
    "NtOpenProcessTokenEx",
    "NtQueryPerformanceCounter",
    "NtEnumerateKey",
    "NtOpenFile",
    "NtDelayExecution",
    "NtQueryDirectoryFile",
    "NtQuerySystemInformation",
    "NtOpenSection",
    "NtQueryTimer",
    "NtFsControlFile",
    "NtWriteVirtualMemory",
    "NtCloseObjectAuditAlarm",
    "NtDuplicateObject",
    "NtQueryAttributesFile",
    "NtClearEvent",
    "NtReadVirtualMemory",
    "NtOpenEvent",
    "NtAdjustPrivilegesToken",
    "NtDuplicateToken",
    "NtContinue",
    "NtQueryDefaultUILanguage",
    "NtQueueApcThread",
    "NtYieldExecution",
    "NtAddAtom",
    "NtCreateEvent",
    "NtQueryVolumeInformationFile",
    "NtCreateSection",
    "NtFlushBuffersFile",
    "NtApphelpCacheControl",
    "NtCreateProcessEx",
    "NtCreateThread",
    "NtIsProcessInJob",
    "NtProtectVirtualMemory",
    "NtQuerySection",
    "NtResumeThread",
    "NtTerminateThread",
    "NtReadRequestData",
    "NtCreateFile",
    "NtQueryEvent",
    "NtWriteRequestData",
    "NtOpenDirectoryObject",
    "NtAccessCheckByTypeAndAuditAlarm",
    "NtQuerySystemTime",
    "NtWaitForMultipleObjects",
    "NtSetInformationObject",
    "NtCancelIoFile",
    "NtTraceEvent",
    "NtPowerInformation",
    "NtSetValueKey",
    "NtCancelTimer",
    "NtSetTimer",
    "NtAccessCheck",
    "NtAccessCheckByType",
    "NtAccessCheckByTypeResultList",
    "NtAccessCheckByTypeResultListAndAuditAlarm",
    "NtAccessCheckByTypeResultListAndAuditAlarmByHandle",
    "NtAddAtomEx",
    "NtAddBootEntry",
    "NtAddDriverEntry",
    "NtAdjustGroupsToken",
    "NtAdjustTokenClaimsAndDeviceGroups",
    "NtAlertResumeThread",
    "NtAlertThread",
    "NtAlertThreadByThreadId",
    "NtAllocateLocallyUniqueId",
    "NtAllocateReserveObject",
    "NtAllocateUserPhysicalPages",
    "NtAllocateUuids",
    "NtAlpcAcceptConnectPort",
    "NtAlpcCancelMessage",
    "NtAlpcConnectPort",
    "NtAlpcConnectPortEx",
    "NtAlpcCreatePort",
    "NtAlpcCreatePortSection",
    "NtAlpcCreateResourceReserve",
    "NtAlpcCreateSectionView",
    "NtAlpcCreateSecurityContext",
    "NtAlpcDeletePortSection",
    "NtAlpcDeleteResourceReserve",
    "NtAlpcDeleteSectionView",
    "NtAlpcDeleteSecurityContext",
    "NtAlpcDisconnectPort",
    "NtAlpcImpersonateClientOfPort",
    "NtAlpcOpenSenderProcess",
    "NtAlpcOpenSenderThread",
    "NtAlpcQueryInformation",
    "NtAlpcQueryInformationMessage",
    "NtAlpcRevokeSecurityContext",
    "NtAlpcSendWaitReceivePort",
    "NtAlpcSetInformation",
    "NtAreMappedFilesTheSame",
    "NtAssignProcessToJobObject",
    "NtAssociateWaitCompletionPacket",
    "NtCancelIoFileEx",
    "NtCancelSynchronousIoFile",
    "NtCancelTimer2",
    "NtCancelWaitCompletionPacket",
    "NtCommitComplete",
    "NtCommitEnlistment",
    "NtCommitTransaction",
    "NtCompactKeys",
    "NtCompareTokens",
    "ArbPreprocessEntry",
    "NtCompressKey",
    "NtConnectPort",
    "NtCreateDebugObject",
    "NtCreateDirectoryObject",
    "NtCreateDirectoryObjectEx",
    "NtCreateEnlistment",
    "NtAdjustTokenClaimsAndDeviceGroups",
    "NtCreateIRTimer",
    "NtCreateIoCompletion",
    "NtCreateJobObject",
    "ArbAddReserved",
    "NtCreateKeyTransacted",
    "NtCreateKeyedEvent",
    "NtCreateLowBoxToken",
    "NtCreateMailslotFile",
    "NtCreateMutant",
    "NtCreateNamedPipeFile",
    "NtCreatePagingFile",
    "NtCreatePort",
    "NtCreatePrivateNamespace",
    "NtCreateProcess",
    "NtCreateProfile",
    "NtCreateProfileEx",
    "NtCreateResourceManager",
    "NtCreateSemaphore",
    "NtCreateSymbolicLinkObject",
    "NtCreateThreadEx",
    "NtCreateTimer",
    "NtCreateTimer2",
    "NtCreateToken",
    "NtCreateTokenEx",
    "NtCreateTransaction",
    "NtCreateTransactionManager",
    "NtCreateUserProcess",
    "NtCreateWaitCompletionPacket",
    "NtCreateWaitablePort",
    "NtCreateWnfStateName",
    "NtCreateWorkerFactory",
    "NtDebugActiveProcess",
    "NtDebugContinue",
    "NtDeleteAtom",
    "NtDeleteBootEntry",
    "NtDeleteDriverEntry",
    "NtDeleteFile",
    "NtDeleteKey",
    "NtDeleteObjectAuditAlarm",
    "NtDeletePrivateNamespace",
    "NtDeleteValueKey",
    "NtDeleteWnfStateData",
    "NtDeleteWnfStateName",
    "NtDisableLastKnownGood",
    "NtDisplayString",
    "NtDrawText",
    "NtEnableLastKnownGood",
    "NtEnumerateBootEntries",
    "NtEnumerateDriverEntries",
    "NtEnumerateSystemEnvironmentValuesEx",
    "NtEnumerateTransactionObject",
    "NtExtendSection",
    "NtFilterBootOption",
    "NtFilterToken",
    "NtAdjustTokenClaimsAndDeviceGroups",
    "NtFlushBuffersFileEx",
    "NtFlushInstallUILanguage",
    "ArbPreprocessEntry",
    "NtFlushKey",
    "NtFlushProcessWriteBuffers",
    "NtFlushVirtualMemory",
    "NtFlushWriteBuffer",
    "NtFreeUserPhysicalPages",
    "NtFreezeRegistry",
    "NtFreezeTransactions",
    "NtGetCachedSigningLevel",
    "NtGetCompleteWnfStateSubscription",
    "NtGetContextThread",
    "NtGetCurrentProcessorNumber",
    "NtGetDevicePowerState",
    "NtGetMUIRegistryInfo",
    "NtGetNextProcess",
    "NtGetNextThread",
    "NtGetNlsSectionPtr",
    "NtGetNotificationResourceManager",
    "NtGetWriteWatch",
    "NtImpersonateAnonymousToken",
    "NtImpersonateThread",
    "NtInitializeNlsFiles",
    "NtInitializeRegistry",
    "NtInitiatePowerAction",
    "NtIsSystemResumeAutomatic",
    "NtIsUILanguageComitted",
    "NtListenPort",
    "NtLoadDriver",
    "NtLoadKey",
    "NtLoadKey2",
    "NtLoadKeyEx",
    "NtLockFile",
    "NtLockProductActivationKeys",
    "NtLockRegistryKey",
    "NtLockVirtualMemory",
    "NtMakePermanentObject",
    "NtMakeTemporaryObject",
    "NtMapCMFModule",
    "NtMapUserPhysicalPages",
    "NtModifyBootEntry",
    "NtModifyDriverEntry",
    "NtNotifyChangeDirectoryFile",
    "NtNotifyChangeKey",
    "NtNotifyChangeMultipleKeys",
    "NtNotifyChangeSession",
    "NtOpenEnlistment",
    "NtAdjustTokenClaimsAndDeviceGroups",
    "NtOpenIoCompletion",
    "NtOpenJobObject",
    "NtOpenKeyEx",
    "NtOpenKeyTransacted",
    "NtOpenKeyTransactedEx",
    "NtOpenKeyedEvent",
    "NtOpenMutant",
    "NtOpenObjectAuditAlarm",
    "NtOpenPrivateNamespace",
    "NtOpenProcessToken",
    "NtOpenResourceManager",
    "NtOpenSemaphore",
    "NtOpenSession",
    "NtOpenSymbolicLinkObject",
    "NtOpenThread",
    "NtOpenTimer",
    "NtOpenTransaction",
    "NtOpenTransactionManager",
    "NtPlugPlayControl",
    "NtPrePrepareComplete",
    "NtPrePrepareEnlistment",
    "NtPrepareComplete",
    "NtPrepareEnlistment",
    "NtPrivilegeCheck",
    "NtPrivilegeObjectAuditAlarm",
    "NtPrivilegedServiceAuditAlarm",
    "NtPropagationComplete",
    "NtPropagationFailed",
    "NtPulseEvent",
    "NtQueryBootEntryOrder",
    "NtQueryBootOptions",
    "NtQueryDebugFilterState",
    "NtQueryDirectoryObject",
    "NtQueryDriverEntryOrder",
    "NtQueryEaFile",
    "NtQueryFullAttributesFile",
    "NtQueryInformationAtom",
    "NtQueryInformationEnlistment",
    "NtQueryInformationJobObject",
    "NtQueryInformationPort",
    "NtQueryInformationResourceManager",
    "NtQueryInformationTransaction",
    "NtQueryInformationTransactionManager",
    "NtQueryInformationWorkerFactory",
    "NtQueryInstallUILanguage",
    "NtQueryIntervalProfile",
    "NtQueryIoCompletion",
    "NtQueryLicenseValue",
    "NtQueryMultipleValueKey",
    "NtQueryMutant",
    "NtQueryOpenSubKeys",
    "NtQueryOpenSubKeysEx",
    "NtQueryPortInformationProcess",
    "NtQueryQuotaInformationFile",
    "NtQuerySecurityAttributesToken",
    "NtQuerySecurityObject",
    "NtQuerySemaphore",
    "NtQuerySymbolicLinkObject",
    "NtQuerySystemEnvironmentValue",
    "NtQuerySystemEnvironmentValueEx",
    "NtQuerySystemInformationEx",
    "NtQueryTimerResolution",
    "NtQueryWnfStateData",
    "NtQueryWnfStateNameInformation",
    "NtQueueApcThreadEx",
    "NtRaiseException",
    "NtRaiseHardError",
    "NtReadOnlyEnlistment",
    "NtRecoverEnlistment",
    "NtRecoverResourceManager",
    "NtRecoverTransactionManager",
    "NtRegisterProtocolAddressInformation",
    "NtRegisterThreadTerminatePort",
    "NtReleaseKeyedEvent",
    "NtReleaseWorkerFactoryWorker",
    "NtRemoveIoCompletionEx",
    "NtRemoveProcessDebug",
    "NtRenameKey",
    "NtRenameTransactionManager",
    "NtReplaceKey",
    "NtReplacePartitionUnit",
    "NtReplyWaitReplyPort",
    "NtRequestPort",
    "NtResetEvent",
    "NtResetWriteWatch",
    "NtRestoreKey",
    "NtResumeProcess",
    "NtRollbackComplete",
    "NtRollbackEnlistment",
    "NtRollbackTransaction",
    "NtRollforwardTransactionManager",
    "NtSaveKey",
    "NtSaveKeyEx",
    "NtSaveMergedKeys",
    "NtSecureConnectPort",
    "NtSerializeBoot",
    "NtSetBootEntryOrder",
    "NtSetBootOptions",
    "NtSetCachedSigningLevel",
    "NtSetContextThread",
    "NtSetDebugFilterState",
    "NtSetDefaultHardErrorPort",
    "NtSetDefaultLocale",
    "NtSetDefaultUILanguage",
    "NtSetDriverEntryOrder",
    "NtSetEaFile",
    "NtAdjustTokenClaimsAndDeviceGroups",
    "NtAdjustTokenClaimsAndDeviceGroups",
    "NtSetIRTimer",
    "NtSetInformationDebugObject",
    "NtSetInformationEnlistment",
    "NtSetInformationJobObject",
    "NtSetInformationKey",
    "NtSetInformationResourceManager",
    "NtSetInformationToken",
    "NtSetInformationTransaction",
    "NtSetInformationTransactionManager",
    "NtSetInformationVirtualMemory",
    "NtSetInformationWorkerFactory",
    "NtSetIntervalProfile",
    "NtSetIoCompletion",
    "NtSetIoCompletionEx",
    "CcTestControl",
    "NtAdjustTokenClaimsAndDeviceGroups",
    "NtAdjustTokenClaimsAndDeviceGroups",
    "NtSetQuotaInformationFile",
    "NtSetSecurityObject",
    "NtSetSystemEnvironmentValue",
    "NtSetSystemEnvironmentValueEx",
    "NtSetSystemInformation",
    "NtSetSystemPowerState",
    "NtSetSystemTime",
    "NtSetThreadExecutionState",
    "NtSetTimer2",
    "NtSetTimerEx",
    "NtSetTimerResolution",
    "NtSetUuidSeed",
    "NtSetVolumeInformationFile",
    "NtSetWnfProcessNotificationEvent",
    "NtShutdownSystem",
    "NtShutdownWorkerFactory",
    "NtSignalAndWaitForSingleObject",
    "NtSinglePhaseReject",
    "NtStartProfile",
    "NtStopProfile",
    "NtSubscribeWnfStateChange",
    "NtSuspendProcess",
    "NtSuspendThread",
    "NtSystemDebugControl",
    "NtTerminateJobObject",
    "NtTestAlert",
    "NtThawRegistry",
    "NtThawTransactions",
    "NtTraceControl",
    "NtTranslateFilePath",
    "NtUmsThreadYield",
    "NtUnloadDriver",
    "NtUnloadKey",
    "NtUnloadKey2",
    "NtUnloadKeyEx",
    "NtUnlockFile",
    "NtUnlockVirtualMemory",
    "NtUnmapViewOfSectionEx",
    "NtUnsubscribeWnfStateChange",
    "NtUpdateWnfStateData",
    "NtAdjustTokenClaimsAndDeviceGroups",
    "NtWaitForAlertByThreadId",
    "NtWaitForDebugEvent",
    "NtWaitForKeyedEvent",
    "NtWaitForWorkViaWorkerFactory",
    "NtAdjustTokenClaimsAndDeviceGroups",
    "NtAdjustTokenClaimsAndDeviceGroups"
};

//////////////////////////////////////////////////////////////////////////
// Windows 10 SP0 _KiServiceTable
//////////////////////////////////////////////////////////////////////////
static const char* KiServiceTable_Win10Th1_x64[] = {
    "NtAccessCheck",
    "NtWorkerFactoryWorkerReady",
    "NtAcceptConnectPort",
    "NtMapUserPhysicalPagesScatter",
    "NtWaitForSingleObject",
    "NtCallbackReturn",
    "NtReadFile",
    "NtDeviceIoControlFile",
    "NtWriteFile",
    "NtRemoveIoCompletion",
    "NtReleaseSemaphore",
    "NtReplyWaitReceivePort",
    "NtReplyPort",
    "NtSetInformationThread",
    "NtSetEvent",
    "NtClose",
    "NtQueryObject",
    "NtQueryInformationFile",
    "NtOpenKey",
    "NtEnumerateValueKey",
    "NtFindAtom",
    "NtQueryDefaultLocale",
    "NtQueryKey",
    "NtQueryValueKey",
    "NtAllocateVirtualMemory",
    "NtQueryInformationProcess",
    "NtWaitForMultipleObjects32",
    "NtWriteFileGather",
    "NtSetInformationProcess",
    "NtCreateKey",
    "NtFreeVirtualMemory",
    "NtImpersonateClientOfPort",
    "NtReleaseMutant",
    "NtQueryInformationToken",
    "NtRequestWaitReplyPort",
    "NtQueryVirtualMemory",
    "NtOpenThreadToken",
    "NtQueryInformationThread",
    "NtOpenProcess",
    "NtSetInformationFile",
    "NtMapViewOfSection",
    "NtAccessCheckAndAuditAlarm",
    "NtUnmapViewOfSection",
    "NtReplyWaitReceivePortEx",
    "NtTerminateProcess",
    "NtSetEventBoostPriority",
    "NtReadFileScatter",
    "NtOpenThreadTokenEx",
    "NtOpenProcessTokenEx",
    "NtQueryPerformanceCounter",
    "NtEnumerateKey",
    "NtOpenFile",
    "NtDelayExecution",
    "NtQueryDirectoryFile",
    "NtQuerySystemInformation",
    "NtOpenSection",
    "NtQueryTimer",
    "NtFsControlFile",
    "NtWriteVirtualMemory",
    "NtCloseObjectAuditAlarm",
    "NtDuplicateObject",
    "NtQueryAttributesFile",
    "NtClearEvent",
    "NtReadVirtualMemory",
    "NtOpenEvent",
    "NtAdjustPrivilegesToken",
    "NtDuplicateToken",
    "NtContinue",
    "NtQueryDefaultUILanguage",
    "NtQueueApcThread",
    "NtYieldExecution",
    "NtAddAtom",
    "NtCreateEvent",
    "NtQueryVolumeInformationFile",
    "NtCreateSection",
    "NtFlushBuffersFile",
    "NtApphelpCacheControl",
    "NtCreateProcessEx",
    "NtCreateThread",
    "NtIsProcessInJob",
    "NtProtectVirtualMemory",
    "NtQuerySection",
    "NtResumeThread",
    "NtTerminateThread",
    "NtReadRequestData",
    "NtCreateFile",
    "NtQueryEvent",
    "NtWriteRequestData",
    "NtOpenDirectoryObject",
    "NtAccessCheckByTypeAndAuditAlarm",
    "NtQuerySystemTime",
    "NtWaitForMultipleObjects",
    "NtSetInformationObject",
    "NtCancelIoFile",
    "NtTraceEvent",
    "NtPowerInformation",
    "NtSetValueKey",
    "NtCancelTimer",
    "NtSetTimer",
    "NtAccessCheckByType",
    "NtAccessCheckByTypeResultList",
    "NtAccessCheckByTypeResultListAndAuditAlarm",
    "NtAccessCheckByTypeResultListAndAuditAlarmByHandle",
    "NtAddAtomEx",
    "NtAddBootEntry",
    "NtAddDriverEntry",
    "NtAdjustGroupsToken",
    "NtAdjustTokenClaimsAndDeviceGroups",
    "NtAlertResumeThread",
    "NtAlertThread",
    "NtAlertThreadByThreadId",
    "NtAllocateLocallyUniqueId",
    "NtAllocateReserveObject",
    "NtAllocateUserPhysicalPages",
    "NtAllocateUuids",
    "NtAlpcAcceptConnectPort",
    "NtAlpcCancelMessage",
    "NtAlpcConnectPort",
    "NtAlpcConnectPortEx",
    "NtAlpcCreatePort",
    "NtAlpcCreatePortSection",
    "NtAlpcCreateResourceReserve",
    "NtAlpcCreateSectionView",
    "NtAlpcCreateSecurityContext",
    "NtAlpcDeletePortSection",
    "NtAlpcDeleteResourceReserve",
    "NtAlpcDeleteSectionView",
    "NtAlpcDeleteSecurityContext",
    "NtAlpcDisconnectPort",
    "NtAlpcImpersonateClientContainerOfPort",
    "NtAlpcImpersonateClientOfPort",
    "NtAlpcOpenSenderProcess",
    "NtAlpcOpenSenderThread",
    "NtAlpcQueryInformation",
    "NtAlpcQueryInformationMessage",
    "NtAlpcRevokeSecurityContext",
    "NtAlpcSendWaitReceivePort",
    "NtAlpcSetInformation",
    "NtAreMappedFilesTheSame",
    "NtAssignProcessToJobObject",
    "NtAssociateWaitCompletionPacket",
    "NtCancelIoFileEx",
    "NtCancelSynchronousIoFile",
    "NtCancelTimer2",
    "NtCancelWaitCompletionPacket",
    "NtCommitComplete",
    "NtCommitEnlistment",
    "NtCommitTransaction",
    "NtCompactKeys",
    "NtCompareObjects",
    "NtCompareTokens",
    "ArbPreprocessEntry",
    "NtCompressKey",
    "NtConnectPort",
    "NtCreateDebugObject",
    "NtCreateDirectoryObject",
    "NtCreateDirectoryObjectEx",
    "NtCreateEnlistment",
    "NtAdjustTokenClaimsAndDeviceGroups",
    "NtCreateIRTimer",
    "NtCreateIoCompletion",
    "NtCreateJobObject",
    "ArbAddReserved",
    "NtCreateKeyTransacted",
    "NtCreateKeyedEvent",
    "NtCreateLowBoxToken",
    "NtCreateMailslotFile",
    "NtCreateMutant",
    "NtCreateNamedPipeFile",
    "NtCreatePagingFile",
    "NtCreatePartition",
    "NtCreatePort",
    "NtCreatePrivateNamespace",
    "NtCreateProcess",
    "NtCreateProfile",
    "NtCreateProfileEx",
    "NtCreateResourceManager",
    "NtCreateSemaphore",
    "NtCreateSymbolicLinkObject",
    "NtCreateThreadEx",
    "NtCreateTimer",
    "NtCreateTimer2",
    "NtCreateToken",
    "NtCreateTokenEx",
    "NtCreateTransaction",
    "NtCreateTransactionManager",
    "NtCreateUserProcess",
    "NtCreateWaitCompletionPacket",
    "NtCreateWaitablePort",
    "NtCreateWnfStateName",
    "NtCreateWorkerFactory",
    "NtDebugActiveProcess",
    "NtDebugContinue",
    "NtDeleteAtom",
    "NtDeleteBootEntry",
    "NtDeleteDriverEntry",
    "NtDeleteFile",
    "NtDeleteKey",
    "NtDeleteObjectAuditAlarm",
    "NtDeletePrivateNamespace",
    "NtDeleteValueKey",
    "NtDeleteWnfStateData",
    "NtDeleteWnfStateName",
    "NtDisableLastKnownGood",
    "NtDisplayString",
    "NtDrawText",
    "NtEnableLastKnownGood",
    "NtEnumerateBootEntries",
    "NtEnumerateDriverEntries",
    "NtEnumerateSystemEnvironmentValuesEx",
    "NtEnumerateTransactionObject",
    "NtExtendSection",
    "NtFilterBootOption",
    "NtFilterToken",
    "NtAdjustTokenClaimsAndDeviceGroups",
    "NtFlushBuffersFileEx",
    "NtFlushInstallUILanguage",
    "ArbPreprocessEntry",
    "NtFlushKey",
    "NtFlushProcessWriteBuffers",
    "NtFlushVirtualMemory",
    "NtFlushWriteBuffer",
    "NtFreeUserPhysicalPages",
    "NtFreezeRegistry",
    "NtFreezeTransactions",
    "NtGetCachedSigningLevel",
    "NtGetCompleteWnfStateSubscription",
    "NtGetContextThread",
    "NtGetCurrentProcessorNumber",
    "NtGetCurrentProcessorNumberEx",
    "NtGetDevicePowerState",
    "NtGetMUIRegistryInfo",
    "NtGetNextProcess",
    "NtGetNextThread",
    "NtGetNlsSectionPtr",
    "NtGetNotificationResourceManager",
    "NtGetWriteWatch",
    "NtImpersonateAnonymousToken",
    "NtImpersonateThread",
    "NtInitializeNlsFiles",
    "NtInitializeRegistry",
    "NtInitiatePowerAction",
    "NtIsSystemResumeAutomatic",
    "NtIsUILanguageComitted",
    "NtListenPort",
    "NtLoadDriver",
    "NtLoadKey",
    "NtLoadKey2",
    "NtLoadKeyEx",
    "NtLockFile",
    "NtLockProductActivationKeys",
    "NtLockRegistryKey",
    "NtLockVirtualMemory",
    "NtMakePermanentObject",
    "NtMakeTemporaryObject",
    "NtManagePartition",
    "NtMapCMFModule",
    "NtMapUserPhysicalPages",
    "NtModifyBootEntry",
    "NtModifyDriverEntry",
    "NtNotifyChangeDirectoryFile",
    "NtNotifyChangeKey",
    "NtNotifyChangeMultipleKeys",
    "NtNotifyChangeSession",
    "NtOpenEnlistment",
    "NtAdjustTokenClaimsAndDeviceGroups",
    "NtOpenIoCompletion",
    "NtOpenJobObject",
    "NtOpenKeyEx",
    "NtOpenKeyTransacted",
    "NtOpenKeyTransactedEx",
    "NtOpenKeyedEvent",
    "NtOpenMutant",
    "NtOpenObjectAuditAlarm",
    "NtOpenPartition",
    "NtOpenPrivateNamespace",
    "NtOpenProcessToken",
    "NtOpenResourceManager",
    "NtOpenSemaphore",
    "NtOpenSession",
    "NtOpenSymbolicLinkObject",
    "NtOpenThread",
    "NtOpenTimer",
    "NtOpenTransaction",
    "NtOpenTransactionManager",
    "NtPlugPlayControl",
    "NtPrePrepareComplete",
    "NtPrePrepareEnlistment",
    "NtPrepareComplete",
    "NtPrepareEnlistment",
    "NtPrivilegeCheck",
    "NtPrivilegeObjectAuditAlarm",
    "NtPrivilegedServiceAuditAlarm",
    "NtPropagationComplete",
    "NtPropagationFailed",
    "NtPulseEvent",
    "NtQueryBootEntryOrder",
    "NtQueryBootOptions",
    "NtQueryDebugFilterState",
    "NtQueryDirectoryObject",
    "NtQueryDriverEntryOrder",
    "NtQueryEaFile",
    "NtQueryFullAttributesFile",
    "NtQueryInformationAtom",
    "NtQueryInformationEnlistment",
    "NtQueryInformationJobObject",
    "NtQueryInformationPort",
    "NtQueryInformationResourceManager",
    "NtQueryInformationTransaction",
    "NtQueryInformationTransactionManager",
    "NtQueryInformationWorkerFactory",
    "NtQueryInstallUILanguage",
    "NtQueryIntervalProfile",
    "NtQueryIoCompletion",
    "NtQueryLicenseValue",
    "NtQueryMultipleValueKey",
    "NtQueryMutant",
    "NtQueryOpenSubKeys",
    "NtQueryOpenSubKeysEx",
    "NtQueryPortInformationProcess",
    "NtQueryQuotaInformationFile",
    "NtQuerySecurityAttributesToken",
    "NtQuerySecurityObject",
    "NtQuerySemaphore",
    "NtQuerySymbolicLinkObject",
    "NtQuerySystemEnvironmentValue",
    "NtQuerySystemEnvironmentValueEx",
    "NtQuerySystemInformationEx",
    "NtQueryTimerResolution",
    "NtQueryWnfStateData",
    "NtQueryWnfStateNameInformation",
    "NtQueueApcThreadEx",
    "NtRaiseException",
    "NtRaiseHardError",
    "NtReadOnlyEnlistment",
    "NtRecoverEnlistment",
    "NtRecoverResourceManager",
    "NtRecoverTransactionManager",
    "NtRegisterProtocolAddressInformation",
    "NtRegisterThreadTerminatePort",
    "NtReleaseKeyedEvent",
    "NtReleaseWorkerFactoryWorker",
    "NtRemoveIoCompletionEx",
    "NtRemoveProcessDebug",
    "NtRenameKey",
    "NtRenameTransactionManager",
    "NtReplaceKey",
    "NtReplacePartitionUnit",
    "NtReplyWaitReplyPort",
    "NtRequestPort",
    "NtResetEvent",
    "NtResetWriteWatch",
    "NtRestoreKey",
    "NtResumeProcess",
    "NtRevertContainerImpersonation",
    "NtRollbackComplete",
    "NtRollbackEnlistment",
    "NtRollbackTransaction",
    "NtRollforwardTransactionManager",
    "NtSaveKey",
    "NtSaveKeyEx",
    "NtSaveMergedKeys",
    "NtSecureConnectPort",
    "NtSerializeBoot",
    "NtSetBootEntryOrder",
    "NtSetBootOptions",
    "NtSetCachedSigningLevel",
    "NtSetContextThread",
    "NtSetDebugFilterState",
    "NtSetDefaultHardErrorPort",
    "NtSetDefaultLocale",
    "NtSetDefaultUILanguage",
    "NtSetDriverEntryOrder",
    "NtSetEaFile",
    "NtAdjustTokenClaimsAndDeviceGroups",
    "NtAdjustTokenClaimsAndDeviceGroups",
    "NtSetIRTimer",
    "NtSetInformationDebugObject",
    "NtSetInformationEnlistment",
    "NtSetInformationJobObject",
    "NtSetInformationKey",
    "NtSetInformationResourceManager",
    "NtSetInformationSymbolicLink",
    "NtSetInformationToken",
    "NtSetInformationTransaction",
    "NtSetInformationTransactionManager",
    "NtSetInformationVirtualMemory",
    "NtSetInformationWorkerFactory",
    "NtSetIntervalProfile",
    "NtSetIoCompletion",
    "NtSetIoCompletionEx",
    "CcTestControl",
    "NtAdjustTokenClaimsAndDeviceGroups",
    "NtAdjustTokenClaimsAndDeviceGroups",
    "NtSetQuotaInformationFile",
    "NtSetSecurityObject",
    "NtSetSystemEnvironmentValue",
    "NtSetSystemEnvironmentValueEx",
    "NtSetSystemInformation",
    "NtSetSystemPowerState",
    "NtSetSystemTime",
    "NtSetThreadExecutionState",
    "NtSetTimer2",
    "NtSetTimerEx",
    "NtSetTimerResolution",
    "NtSetUuidSeed",
    "NtSetVolumeInformationFile",
    "NtSetWnfProcessNotificationEvent",
    "NtShutdownSystem",
    "NtShutdownWorkerFactory",
    "NtSignalAndWaitForSingleObject",
    "NtSinglePhaseReject",
    "NtStartProfile",
    "NtStopProfile",
    "NtSubscribeWnfStateChange",
    "NtSuspendProcess",
    "NtSuspendThread",
    "NtSystemDebugControl",
    "NtTerminateJobObject",
    "NtTestAlert",
    "NtThawRegistry",
    "NtThawTransactions",
    "NtTraceControl",
    "NtTranslateFilePath",
    "NtUmsThreadYield",
    "NtUnloadDriver",
    "NtUnloadKey",
    "NtUnloadKey2",
    "NtUnloadKeyEx",
    "NtUnlockFile",
    "NtUnlockVirtualMemory",
    "NtUnmapViewOfSectionEx",
    "NtUnsubscribeWnfStateChange",
    "NtUpdateWnfStateData",
    "NtAdjustTokenClaimsAndDeviceGroups",
    "NtWaitForAlertByThreadId",
    "NtWaitForDebugEvent",
    "NtWaitForKeyedEvent",
    "NtWaitForWorkViaWorkerFactory",
    "NtAdjustTokenClaimsAndDeviceGroups",
    "NtAdjustTokenClaimsAndDeviceGroups"
};

//////////////////////////////////////////////////////////////////////////
// Windows 10 TH2 _KiServiceTable
//////////////////////////////////////////////////////////////////////////
static const char* KiServiceTable_Win10Th2_x64[] = {
    "NtAccessCheck",
    "NtWorkerFactoryWorkerReady",
    "NtAcceptConnectPort",
    "NtMapUserPhysicalPagesScatter",
    "NtWaitForSingleObject",
    "NtCallbackReturn",
    "NtReadFile",
    "NtDeviceIoControlFile",
    "NtWriteFile",
    "NtRemoveIoCompletion",
    "NtReleaseSemaphore",
    "NtReplyWaitReceivePort",
    "NtReplyPort",
    "NtSetInformationThread",
    "NtSetEvent",
    "NtClose",
    "NtQueryObject",
    "NtQueryInformationFile",
    "NtOpenKey",
    "NtEnumerateValueKey",
    "NtFindAtom",
    "NtQueryDefaultLocale",
    "NtQueryKey",
    "NtQueryValueKey",
    "NtAllocateVirtualMemory",
    "NtQueryInformationProcess",
    "NtWaitForMultipleObjects32",
    "NtWriteFileGather",
    "NtSetInformationProcess",
    "NtCreateKey",
    "NtFreeVirtualMemory",
    "NtImpersonateClientOfPort",
    "NtReleaseMutant",
    "NtQueryInformationToken",
    "NtRequestWaitReplyPort",
    "NtQueryVirtualMemory",
    "NtOpenThreadToken",
    "NtQueryInformationThread",
    "NtOpenProcess",
    "NtSetInformationFile",
    "NtMapViewOfSection",
    "NtAccessCheckAndAuditAlarm",
    "NtUnmapViewOfSection",
    "NtReplyWaitReceivePortEx",
    "NtTerminateProcess",
    "NtSetEventBoostPriority",
    "NtReadFileScatter",
    "NtOpenThreadTokenEx",
    "NtOpenProcessTokenEx",
    "NtQueryPerformanceCounter",
    "NtEnumerateKey",
    "NtOpenFile",
    "NtDelayExecution",
    "NtQueryDirectoryFile",
    "NtQuerySystemInformation",
    "NtOpenSection",
    "NtQueryTimer",
    "NtFsControlFile",
    "NtWriteVirtualMemory",
    "NtCloseObjectAuditAlarm",
    "NtDuplicateObject",
    "NtQueryAttributesFile",
    "NtClearEvent",
    "NtReadVirtualMemory",
    "NtOpenEvent",
    "NtAdjustPrivilegesToken",
    "NtDuplicateToken",
    "NtContinue",
    "NtQueryDefaultUILanguage",
    "NtQueueApcThread",
    "NtYieldExecution",
    "NtAddAtom",
    "NtCreateEvent",
    "NtQueryVolumeInformationFile",
    "NtCreateSection",
    "NtFlushBuffersFile",
    "NtApphelpCacheControl",
    "NtCreateProcessEx",
    "NtCreateThread",
    "NtIsProcessInJob",
    "NtProtectVirtualMemory",
    "NtQuerySection",
    "NtResumeThread",
    "NtTerminateThread",
    "NtReadRequestData",
    "NtCreateFile",
    "NtQueryEvent",
    "NtWriteRequestData",
    "NtOpenDirectoryObject",
    "NtAccessCheckByTypeAndAuditAlarm",
    "NtQuerySystemTime",
    "NtWaitForMultipleObjects",
    "NtSetInformationObject",
    "NtCancelIoFile",
    "NtTraceEvent",
    "NtPowerInformation",
    "NtSetValueKey",
    "NtCancelTimer",
    "NtSetTimer",
    "NtAccessCheckByType",
    "NtAccessCheckByTypeResultList",
    "NtAccessCheckByTypeResultListAndAuditAlarm",
    "NtAccessCheckByTypeResultListAndAuditAlarmByHandle",
    "NtAddAtomEx",
    "NtAddBootEntry",
    "NtAddDriverEntry",
    "NtAdjustGroupsToken",
    "NtAdjustTokenClaimsAndDeviceGroups",
    "NtAlertResumeThread",
    "NtAlertThread",
    "NtAlertThreadByThreadId",
    "NtAllocateLocallyUniqueId",
    "NtAllocateReserveObject",
    "NtAllocateUserPhysicalPages",
    "NtAllocateUuids",
    "NtAlpcAcceptConnectPort",
    "NtAlpcCancelMessage",
    "NtAlpcConnectPort",
    "NtAlpcConnectPortEx",
    "NtAlpcCreatePort",
    "NtAlpcCreatePortSection",
    "NtAlpcCreateResourceReserve",
    "NtAlpcCreateSectionView",
    "NtAlpcCreateSecurityContext",
    "NtAlpcDeletePortSection",
    "NtAlpcDeleteResourceReserve",
    "NtAlpcDeleteSectionView",
    "NtAlpcDeleteSecurityContext",
    "NtAlpcDisconnectPort",
    "NtAlpcImpersonateClientContainerOfPort",
    "NtAlpcImpersonateClientOfPort",
    "NtAlpcOpenSenderProcess",
    "NtAlpcOpenSenderThread",
    "NtAlpcQueryInformation",
    "NtAlpcQueryInformationMessage",
    "NtAlpcRevokeSecurityContext",
    "NtAlpcSendWaitReceivePort",
    "NtAlpcSetInformation",
    "NtAreMappedFilesTheSame",
    "NtAssignProcessToJobObject",
    "NtAssociateWaitCompletionPacket",
    "NtCancelIoFileEx",
    "NtCancelSynchronousIoFile",
    "NtCancelTimer2",
    "NtCancelWaitCompletionPacket",
    "NtCommitComplete",
    "NtCommitEnlistment",
    "NtCommitTransaction",
    "NtCompactKeys",
    "NtCompareObjects",
    "NtCompareTokens",
    "ArbPreprocessEntry",
    "NtCompressKey",
    "NtConnectPort",
    "NtCreateDebugObject",
    "NtCreateDirectoryObject",
    "NtCreateDirectoryObjectEx",
    "NtCreateEnclave",
    "NtCreateEnlistment",
    "NtAdjustTokenClaimsAndDeviceGroups",
    "NtCreateIRTimer",
    "NtCreateIoCompletion",
    "NtCreateJobObject",
    "ArbAddReserved",
    "NtCreateKeyTransacted",
    "NtCreateKeyedEvent",
    "NtCreateLowBoxToken",
    "NtCreateMailslotFile",
    "NtCreateMutant",
    "NtCreateNamedPipeFile",
    "NtCreatePagingFile",
    "NtCreatePartition",
    "NtCreatePort",
    "NtCreatePrivateNamespace",
    "NtCreateProcess",
    "NtCreateProfile",
    "NtCreateProfileEx",
    "NtCreateResourceManager",
    "NtCreateSemaphore",
    "NtCreateSymbolicLinkObject",
    "NtCreateThreadEx",
    "NtCreateTimer",
    "NtCreateTimer2",
    "NtCreateToken",
    "NtCreateTokenEx",
    "NtCreateTransaction",
    "NtCreateTransactionManager",
    "NtCreateUserProcess",
    "NtCreateWaitCompletionPacket",
    "NtCreateWaitablePort",
    "NtCreateWnfStateName",
    "NtCreateWorkerFactory",
    "NtDebugActiveProcess",
    "NtDebugContinue",
    "NtDeleteAtom",
    "NtDeleteBootEntry",
    "NtDeleteDriverEntry",
    "NtDeleteFile",
    "NtDeleteKey",
    "NtDeleteObjectAuditAlarm",
    "NtDeletePrivateNamespace",
    "NtDeleteValueKey",
    "NtDeleteWnfStateData",
    "NtDeleteWnfStateName",
    "NtDisableLastKnownGood",
    "NtDisplayString",
    "NtDrawText",
    "NtEnableLastKnownGood",
    "NtEnumerateBootEntries",
    "NtEnumerateDriverEntries",
    "NtEnumerateSystemEnvironmentValuesEx",
    "NtEnumerateTransactionObject",
    "NtExtendSection",
    "NtFilterBootOption",
    "NtFilterToken",
    "NtAdjustTokenClaimsAndDeviceGroups",
    "NtFlushBuffersFileEx",
    "NtFlushInstallUILanguage",
    "ArbPreprocessEntry",
    "NtFlushKey",
    "NtFlushProcessWriteBuffers",
    "NtFlushVirtualMemory",
    "NtFlushWriteBuffer",
    "NtFreeUserPhysicalPages",
    "NtFreezeRegistry",
    "NtFreezeTransactions",
    "NtGetCachedSigningLevel",
    "NtGetCompleteWnfStateSubscription",
    "NtGetContextThread",
    "NtGetCurrentProcessorNumber",
    "NtGetCurrentProcessorNumberEx",
    "NtGetDevicePowerState",
    "NtGetMUIRegistryInfo",
    "NtGetNextProcess",
    "NtGetNextThread",
    "NtGetNlsSectionPtr",
    "NtGetNotificationResourceManager",
    "NtGetWriteWatch",
    "NtImpersonateAnonymousToken",
    "NtImpersonateThread",
    "NtInitializeEnclave",
    "NtInitializeNlsFiles",
    "NtInitializeRegistry",
    "NtInitiatePowerAction",
    "NtIsSystemResumeAutomatic",
    "NtIsUILanguageComitted",
    "NtListenPort",
    "NtLoadDriver",
    "NtLoadEnclaveData",
    "NtLoadKey",
    "NtLoadKey2",
    "NtLoadKeyEx",
    "NtLockFile",
    "NtLockProductActivationKeys",
    "NtLockRegistryKey",
    "NtLockVirtualMemory",
    "NtMakePermanentObject",
    "NtMakeTemporaryObject",
    "NtManagePartition",
    "NtMapCMFModule",
    "NtMapUserPhysicalPages",
    "NtModifyBootEntry",
    "NtModifyDriverEntry",
    "NtNotifyChangeDirectoryFile",
    "NtNotifyChangeKey",
    "NtNotifyChangeMultipleKeys",
    "NtNotifyChangeSession",
    "NtOpenEnlistment",
    "NtAdjustTokenClaimsAndDeviceGroups",
    "NtOpenIoCompletion",
    "NtOpenJobObject",
    "NtOpenKeyEx",
    "NtOpenKeyTransacted",
    "NtOpenKeyTransactedEx",
    "NtOpenKeyedEvent",
    "NtOpenMutant",
    "NtOpenObjectAuditAlarm",
    "NtOpenPartition",
    "NtOpenPrivateNamespace",
    "NtOpenProcessToken",
    "NtOpenResourceManager",
    "NtOpenSemaphore",
    "NtOpenSession",
    "NtOpenSymbolicLinkObject",
    "NtOpenThread",
    "NtOpenTimer",
    "NtOpenTransaction",
    "NtOpenTransactionManager",
    "NtPlugPlayControl",
    "NtPrePrepareComplete",
    "NtPrePrepareEnlistment",
    "NtPrepareComplete",
    "NtPrepareEnlistment",
    "NtPrivilegeCheck",
    "NtPrivilegeObjectAuditAlarm",
    "NtPrivilegedServiceAuditAlarm",
    "NtPropagationComplete",
    "NtPropagationFailed",
    "NtPulseEvent",
    "NtQueryBootEntryOrder",
    "NtQueryBootOptions",
    "NtQueryDebugFilterState",
    "NtQueryDirectoryObject",
    "NtQueryDriverEntryOrder",
    "NtQueryEaFile",
    "NtQueryFullAttributesFile",
    "NtQueryInformationAtom",
    "NtQueryInformationEnlistment",
    "NtQueryInformationJobObject",
    "NtQueryInformationPort",
    "NtQueryInformationResourceManager",
    "NtQueryInformationTransaction",
    "NtQueryInformationTransactionManager",
    "NtQueryInformationWorkerFactory",
    "NtQueryInstallUILanguage",
    "NtQueryIntervalProfile",
    "NtQueryIoCompletion",
    "NtQueryLicenseValue",
    "NtQueryMultipleValueKey",
    "NtQueryMutant",
    "NtQueryOpenSubKeys",
    "NtQueryOpenSubKeysEx",
    "NtQueryPortInformationProcess",
    "NtQueryQuotaInformationFile",
    "NtQuerySecurityAttributesToken",
    "NtQuerySecurityObject",
    "NtQuerySemaphore",
    "NtQuerySymbolicLinkObject",
    "NtQuerySystemEnvironmentValue",
    "NtQuerySystemEnvironmentValueEx",
    "NtQuerySystemInformationEx",
    "NtQueryTimerResolution",
    "NtQueryWnfStateData",
    "NtQueryWnfStateNameInformation",
    "NtQueueApcThreadEx",
    "NtRaiseException",
    "NtRaiseHardError",
    "NtReadOnlyEnlistment",
    "NtRecoverEnlistment",
    "NtRecoverResourceManager",
    "NtRecoverTransactionManager",
    "NtRegisterProtocolAddressInformation",
    "NtRegisterThreadTerminatePort",
    "NtReleaseKeyedEvent",
    "NtReleaseWorkerFactoryWorker",
    "NtRemoveIoCompletionEx",
    "NtRemoveProcessDebug",
    "NtRenameKey",
    "NtRenameTransactionManager",
    "NtReplaceKey",
    "NtReplacePartitionUnit",
    "NtReplyWaitReplyPort",
    "NtRequestPort",
    "NtResetEvent",
    "NtResetWriteWatch",
    "NtRestoreKey",
    "NtResumeProcess",
    "NtRevertContainerImpersonation",
    "NtRollbackComplete",
    "NtRollbackEnlistment",
    "NtRollbackTransaction",
    "NtRollforwardTransactionManager",
    "NtSaveKey",
    "NtSaveKeyEx",
    "NtSaveMergedKeys",
    "NtSecureConnectPort",
    "NtSerializeBoot",
    "NtSetBootEntryOrder",
    "NtSetBootOptions",
    "NtSetCachedSigningLevel",
    "NtSetContextThread",
    "NtSetDebugFilterState",
    "NtSetDefaultHardErrorPort",
    "NtSetDefaultLocale",
    "NtSetDefaultUILanguage",
    "NtSetDriverEntryOrder",
    "NtSetEaFile",
    "NtAdjustTokenClaimsAndDeviceGroups",
    "NtAdjustTokenClaimsAndDeviceGroups",
    "NtSetIRTimer",
    "NtSetInformationDebugObject",
    "NtSetInformationEnlistment",
    "NtSetInformationJobObject",
    "NtSetInformationKey",
    "NtSetInformationResourceManager",
    "NtSetInformationSymbolicLink",
    "NtSetInformationToken",
    "NtSetInformationTransaction",
    "NtSetInformationTransactionManager",
    "NtSetInformationVirtualMemory",
    "NtSetInformationWorkerFactory",
    "NtSetIntervalProfile",
    "NtSetIoCompletion",
    "NtSetIoCompletionEx",
    "BvgaSetVirtualFrameBuffer",
    "NtAdjustTokenClaimsAndDeviceGroups",
    "NtAdjustTokenClaimsAndDeviceGroups",
    "NtSetQuotaInformationFile",
    "NtSetSecurityObject",
    "NtSetSystemEnvironmentValue",
    "NtSetSystemEnvironmentValueEx",
    "NtSetSystemInformation",
    "NtSetSystemPowerState",
    "NtSetSystemTime",
    "NtSetThreadExecutionState",
    "NtSetTimer2",
    "NtSetTimerEx",
    "NtSetTimerResolution",
    "NtSetUuidSeed",
    "NtSetVolumeInformationFile",
    "NtSetWnfProcessNotificationEvent",
    "NtShutdownSystem",
    "NtShutdownWorkerFactory",
    "NtSignalAndWaitForSingleObject",
    "NtSinglePhaseReject",
    "NtStartProfile",
    "NtStopProfile",
    "NtSubscribeWnfStateChange",
    "NtSuspendProcess",
    "NtSuspendThread",
    "NtSystemDebugControl",
    "NtTerminateJobObject",
    "NtTestAlert",
    "NtThawRegistry",
    "NtThawTransactions",
    "NtTraceControl",
    "NtTranslateFilePath",
    "NtUmsThreadYield",
    "NtUnloadDriver",
    "NtUnloadKey",
    "NtUnloadKey2",
    "NtUnloadKeyEx",
    "NtUnlockFile",
    "NtUnlockVirtualMemory",
    "NtUnmapViewOfSectionEx",
    "NtUnsubscribeWnfStateChange",
    "NtUpdateWnfStateData",
    "NtAdjustTokenClaimsAndDeviceGroups",
    "NtWaitForAlertByThreadId",
    "NtWaitForDebugEvent",
    "NtWaitForKeyedEvent",
    "NtWaitForWorkViaWorkerFactory",
    "NtAdjustTokenClaimsAndDeviceGroups",
    "NtAdjustTokenClaimsAndDeviceGroups"
};

//////////////////////////////////////////////////////////////////////////
// Windows 10 RS1 _KiServiceTable
//////////////////////////////////////////////////////////////////////////
static const char* KiServiceTable_Win10Rs1_x64[] = {
    "NtAccessCheck",
    "NtWorkerFactoryWorkerReady",
    "NtAcceptConnectPort",
    "NtMapUserPhysicalPagesScatter",
    "NtWaitForSingleObject",
    "NtCallbackReturn",
    "NtReadFile",
    "NtDeviceIoControlFile",
    "NtWriteFile",
    "NtRemoveIoCompletion",
    "NtReleaseSemaphore",
    "NtReplyWaitReceivePort",
    "NtReplyPort",
    "NtSetInformationThread",
    "NtSetEvent",
    "NtClose",
    "NtQueryObject",
    "NtQueryInformationFile",
    "NtOpenKey",
    "NtEnumerateValueKey",
    "NtFindAtom",
    "NtQueryDefaultLocale",
    "NtQueryKey",
    "NtQueryValueKey",
    "NtAllocateVirtualMemory",
    "NtQueryInformationProcess",
    "NtWaitForMultipleObjects32",
    "NtWriteFileGather",
    "NtSetInformationProcess",
    "NtCreateKey",
    "NtFreeVirtualMemory",
    "NtImpersonateClientOfPort",
    "NtReleaseMutant",
    "NtQueryInformationToken",
    "NtRequestWaitReplyPort",
    "NtQueryVirtualMemory",
    "NtOpenThreadToken",
    "NtQueryInformationThread",
    "NtOpenProcess",
    "NtSetInformationFile",
    "NtMapViewOfSection",
    "NtAccessCheckAndAuditAlarm",
    "NtUnmapViewOfSection",
    "NtReplyWaitReceivePortEx",
    "NtTerminateProcess",
    "NtSetEventBoostPriority",
    "NtReadFileScatter",
    "NtOpenThreadTokenEx",
    "NtOpenProcessTokenEx",
    "NtQueryPerformanceCounter",
    "NtEnumerateKey",
    "NtOpenFile",
    "NtDelayExecution",
    "NtQueryDirectoryFile",
    "NtQuerySystemInformation",
    "NtOpenSection",
    "NtQueryTimer",
    "NtFsControlFile",
    "NtWriteVirtualMemory",
    "NtCloseObjectAuditAlarm",
    "NtDuplicateObject",
    "NtQueryAttributesFile",
    "NtClearEvent",
    "NtReadVirtualMemory",
    "NtOpenEvent",
    "NtAdjustPrivilegesToken",
    "NtDuplicateToken",
    "NtContinue",
    "NtQueryDefaultUILanguage",
    "NtQueueApcThread",
    "NtYieldExecution",
    "NtAddAtom",
    "NtCreateEvent",
    "NtQueryVolumeInformationFile",
    "NtCreateSection",
    "NtFlushBuffersFile",
    "NtApphelpCacheControl",
    "NtCreateProcessEx",
    "NtCreateThread",
    "NtIsProcessInJob",
    "NtProtectVirtualMemory",
    "NtQuerySection",
    "NtResumeThread",
    "NtTerminateThread",
    "NtReadRequestData",
    "NtCreateFile",
    "NtQueryEvent",
    "NtWriteRequestData",
    "NtOpenDirectoryObject",
    "NtAccessCheckByTypeAndAuditAlarm",
    "NtQuerySystemTime",
    "NtWaitForMultipleObjects",
    "NtSetInformationObject",
    "NtCancelIoFile",
    "NtTraceEvent",
    "NtPowerInformation",
    "NtSetValueKey",
    "NtCancelTimer",
    "NtSetTimer",
    "NtAccessCheckByType",
    "NtAccessCheckByTypeResultList",
    "NtAccessCheckByTypeResultListAndAuditAlarm",
    "NtAccessCheckByTypeResultListAndAuditAlarmByHandle",
    "NtAddAtomEx",
    "NtAddBootEntry",
    "NtAddDriverEntry",
    "NtAdjustGroupsToken",
    "NtAdjustTokenClaimsAndDeviceGroups",
    "NtAlertResumeThread",
    "NtAlertThread",
    "NtAlertThreadByThreadId",
    "NtAllocateLocallyUniqueId",
    "NtAllocateReserveObject",
    "NtAllocateUserPhysicalPages",
    "NtAllocateUuids",
    "NtAlpcAcceptConnectPort",
    "NtAlpcCancelMessage",
    "NtAlpcConnectPort",
    "NtAlpcConnectPortEx",
    "NtAlpcCreatePort",
    "NtAlpcCreatePortSection",
    "NtAlpcCreateResourceReserve",
    "NtAlpcCreateSectionView",
    "NtAlpcCreateSecurityContext",
    "NtAlpcDeletePortSection",
    "NtAlpcDeleteResourceReserve",
    "NtAlpcDeleteSectionView",
    "NtAlpcDeleteSecurityContext",
    "NtAlpcDisconnectPort",
    "NtAlpcImpersonateClientContainerOfPort",
    "NtAlpcImpersonateClientOfPort",
    "NtAlpcOpenSenderProcess",
    "NtAlpcOpenSenderThread",
    "NtAlpcQueryInformation",
    "NtAlpcQueryInformationMessage",
    "NtAlpcRevokeSecurityContext",
    "NtAlpcSendWaitReceivePort",
    "NtAlpcSetInformation",
    "NtAreMappedFilesTheSame",
    "NtAssignProcessToJobObject",
    "NtAssociateWaitCompletionPacket",
    "NtCancelIoFileEx",
    "NtCancelSynchronousIoFile",
    "NtCancelTimer2",
    "NtCancelWaitCompletionPacket",
    "NtCommitComplete",
    "NtCommitEnlistment",
    "NtCommitRegistryTransaction",
    "NtCommitTransaction",
    "NtCompactKeys",
    "NtCompareObjects",
    "NtCompareTokens",
    "ArbPreprocessEntry",
    "NtCompressKey",
    "NtConnectPort",
    "NtCreateDebugObject",
    "NtCreateDirectoryObject",
    "NtCreateDirectoryObjectEx",
    "NtCreateEnclave",
    "NtCreateEnlistment",
    "NtAdjustTokenClaimsAndDeviceGroups",
    "NtCreateIRTimer",
    "NtCreateIoCompletion",
    "NtCreateJobObject",
    "ArbAddReserved",
    "NtCreateKeyTransacted",
    "NtCreateKeyedEvent",
    "NtCreateLowBoxToken",
    "NtCreateMailslotFile",
    "NtCreateMutant",
    "NtCreateNamedPipeFile",
    "NtCreatePagingFile",
    "NtCreatePartition",
    "NtCreatePort",
    "NtCreatePrivateNamespace",
    "NtCreateProcess",
    "NtCreateProfile",
    "NtCreateProfileEx",
    "NtCreateRegistryTransaction",
    "NtCreateResourceManager",
    "NtCreateSemaphore",
    "NtCreateSymbolicLinkObject",
    "NtCreateThreadEx",
    "NtCreateTimer",
    "NtCreateTimer2",
    "NtCreateToken",
    "NtCreateTokenEx",
    "NtCreateTransaction",
    "NtCreateTransactionManager",
    "NtCreateUserProcess",
    "NtCreateWaitCompletionPacket",
    "NtCreateWaitablePort",
    "NtCreateWnfStateName",
    "NtCreateWorkerFactory",
    "NtDebugActiveProcess",
    "NtDebugContinue",
    "NtDeleteAtom",
    "NtDeleteBootEntry",
    "NtDeleteDriverEntry",
    "NtDeleteFile",
    "NtDeleteKey",
    "NtDeleteObjectAuditAlarm",
    "NtDeletePrivateNamespace",
    "NtDeleteValueKey",
    "NtDeleteWnfStateData",
    "NtDeleteWnfStateName",
    "NtDisableLastKnownGood",
    "NtDisplayString",
    "NtDrawText",
    "NtEnableLastKnownGood",
    "NtEnumerateBootEntries",
    "NtEnumerateDriverEntries",
    "NtEnumerateSystemEnvironmentValuesEx",
    "NtEnumerateTransactionObject",
    "NtExtendSection",
    "NtFilterBootOption",
    "NtFilterToken",
    "NtAdjustTokenClaimsAndDeviceGroups",
    "NtFlushBuffersFileEx",
    "NtFlushInstallUILanguage",
    "ArbPreprocessEntry",
    "NtFlushKey",
    "NtFlushProcessWriteBuffers",
    "NtFlushVirtualMemory",
    "NtFlushWriteBuffer",
    "NtFreeUserPhysicalPages",
    "NtFreezeRegistry",
    "NtFreezeTransactions",
    "NtGetCachedSigningLevel",
    "NtGetCompleteWnfStateSubscription",
    "NtGetContextThread",
    "NtGetCurrentProcessorNumber",
    "NtGetCurrentProcessorNumberEx",
    "NtGetDevicePowerState",
    "NtGetMUIRegistryInfo",
    "NtGetNextProcess",
    "NtGetNextThread",
    "NtGetNlsSectionPtr",
    "NtGetNotificationResourceManager",
    "NtGetWriteWatch",
    "NtImpersonateAnonymousToken",
    "NtImpersonateThread",
    "NtInitializeEnclave",
    "NtInitializeNlsFiles",
    "NtInitializeRegistry",
    "NtInitiatePowerAction",
    "NtIsSystemResumeAutomatic",
    "NtIsUILanguageComitted",
    "NtListenPort",
    "NtLoadDriver",
    "NtLoadEnclaveData",
    "NtLoadKey",
    "NtLoadKey2",
    "NtLoadKeyEx",
    "NtLockFile",
    "NtLockProductActivationKeys",
    "NtLockRegistryKey",
    "NtLockVirtualMemory",
    "NtMakePermanentObject",
    "NtMakeTemporaryObject",
    "NtManagePartition",
    "NtMapCMFModule",
    "NtMapUserPhysicalPages",
    "NtModifyBootEntry",
    "NtModifyDriverEntry",
    "NtNotifyChangeDirectoryFile",
    "NtNotifyChangeKey",
    "NtNotifyChangeMultipleKeys",
    "NtNotifyChangeSession",
    "NtOpenEnlistment",
    "NtAdjustTokenClaimsAndDeviceGroups",
    "NtOpenIoCompletion",
    "NtOpenJobObject",
    "NtOpenKeyEx",
    "NtOpenKeyTransacted",
    "NtOpenKeyTransactedEx",
    "NtOpenKeyedEvent",
    "NtOpenMutant",
    "NtOpenObjectAuditAlarm",
    "NtOpenPartition",
    "NtOpenPrivateNamespace",
    "NtOpenProcessToken",
    "NtOpenRegistryTransaction",
    "NtOpenResourceManager",
    "NtOpenSemaphore",
    "NtOpenSession",
    "NtOpenSymbolicLinkObject",
    "NtOpenThread",
    "NtOpenTimer",
    "NtOpenTransaction",
    "NtOpenTransactionManager",
    "NtPlugPlayControl",
    "NtPrePrepareComplete",
    "NtPrePrepareEnlistment",
    "NtPrepareComplete",
    "NtPrepareEnlistment",
    "NtPrivilegeCheck",
    "NtPrivilegeObjectAuditAlarm",
    "NtPrivilegedServiceAuditAlarm",
    "NtPropagationComplete",
    "NtPropagationFailed",
    "NtPulseEvent",
    "NtQueryBootEntryOrder",
    "NtQueryBootOptions",
    "NtQueryDebugFilterState",
    "NtQueryDirectoryObject",
    "NtQueryDriverEntryOrder",
    "NtQueryEaFile",
    "NtQueryFullAttributesFile",
    "NtQueryInformationAtom",
    "NtQueryInformationEnlistment",
    "NtQueryInformationJobObject",
    "NtQueryInformationPort",
    "NtQueryInformationResourceManager",
    "NtQueryInformationTransaction",
    "NtQueryInformationTransactionManager",
    "NtQueryInformationWorkerFactory",
    "NtQueryInstallUILanguage",
    "NtQueryIntervalProfile",
    "NtQueryIoCompletion",
    "NtQueryLicenseValue",
    "NtQueryMultipleValueKey",
    "NtQueryMutant",
    "NtQueryOpenSubKeys",
    "NtQueryOpenSubKeysEx",
    "CmpForceInvalidatePreCallback",
    "NtQueryQuotaInformationFile",
    "NtQuerySecurityAttributesToken",
    "NtQuerySecurityObject",
    "NtQuerySecurityPolicy",
    "NtQuerySemaphore",
    "NtQuerySymbolicLinkObject",
    "NtQuerySystemEnvironmentValue",
    "NtQuerySystemEnvironmentValueEx",
    "NtQuerySystemInformationEx",
    "NtQueryTimerResolution",
    "NtQueryWnfStateData",
    "NtQueryWnfStateNameInformation",
    "NtQueueApcThreadEx",
    "NtRaiseException",
    "NtRaiseHardError",
    "NtReadOnlyEnlistment",
    "NtRecoverEnlistment",
    "NtRecoverResourceManager",
    "NtRecoverTransactionManager",
    "NtRegisterProtocolAddressInformation",
    "NtRegisterThreadTerminatePort",
    "NtReleaseKeyedEvent",
    "NtReleaseWorkerFactoryWorker",
    "NtRemoveIoCompletionEx",
    "NtRemoveProcessDebug",
    "NtRenameKey",
    "NtRenameTransactionManager",
    "NtReplaceKey",
    "NtReplacePartitionUnit",
    "NtReplyWaitReplyPort",
    "NtRequestPort",
    "NtResetEvent",
    "NtResetWriteWatch",
    "NtRestoreKey",
    "NtResumeProcess",
    "NtRevertContainerImpersonation",
    "NtRollbackComplete",
    "NtRollbackEnlistment",
    "NtRollbackRegistryTransaction",
    "NtRollbackTransaction",
    "NtRollforwardTransactionManager",
    "NtSaveKey",
    "NtSaveKeyEx",
    "NtSaveMergedKeys",
    "NtSecureConnectPort",
    "NtSerializeBoot",
    "NtSetBootEntryOrder",
    "NtSetBootOptions",
    "NtSetCachedSigningLevel",
    "NtSetCachedSigningLevel2",
    "NtSetContextThread",
    "NtSetDebugFilterState",
    "NtSetDefaultHardErrorPort",
    "NtSetDefaultLocale",
    "NtSetDefaultUILanguage",
    "NtSetDriverEntryOrder",
    "NtSetEaFile",
    "NtAdjustTokenClaimsAndDeviceGroups",
    "NtAdjustTokenClaimsAndDeviceGroups",
    "NtSetIRTimer",
    "NtSetInformationDebugObject",
    "NtSetInformationEnlistment",
    "NtSetInformationJobObject",
    "NtSetInformationKey",
    "NtSetInformationResourceManager",
    "NtSetInformationSymbolicLink",
    "NtSetInformationToken",
    "NtSetInformationTransaction",
    "NtSetInformationTransactionManager",
    "NtSetInformationVirtualMemory",
    "NtSetInformationWorkerFactory",
    "NtSetIntervalProfile",
    "NtSetIoCompletion",
    "NtSetIoCompletionEx",
    "BvgaSetVirtualFrameBuffer",
    "NtAdjustTokenClaimsAndDeviceGroups",
    "NtAdjustTokenClaimsAndDeviceGroups",
    "NtSetQuotaInformationFile",
    "NtSetSecurityObject",
    "NtSetSystemEnvironmentValue",
    "NtSetSystemEnvironmentValueEx",
    "NtSetSystemInformation",
    "NtSetSystemPowerState",
    "NtSetSystemTime",
    "NtSetThreadExecutionState",
    "NtSetTimer2",
    "NtSetTimerEx",
    "NtSetTimerResolution",
    "NtSetUuidSeed",
    "NtSetVolumeInformationFile",
    "NtSetWnfProcessNotificationEvent",
    "NtShutdownSystem",
    "NtShutdownWorkerFactory",
    "NtSignalAndWaitForSingleObject",
    "NtSinglePhaseReject",
    "NtStartProfile",
    "NtStopProfile",
    "NtSubscribeWnfStateChange",
    "NtSuspendProcess",
    "NtSuspendThread",
    "NtSystemDebugControl",
    "NtTerminateJobObject",
    "NtTestAlert",
    "NtThawRegistry",
    "NtThawTransactions",
    "NtTraceControl",
    "NtTranslateFilePath",
    "NtUmsThreadYield",
    "NtUnloadDriver",
    "NtUnloadKey",
    "NtUnloadKey2",
    "NtUnloadKeyEx",
    "NtUnlockFile",
    "NtUnlockVirtualMemory",
    "NtUnmapViewOfSectionEx",
    "NtUnsubscribeWnfStateChange",
    "NtUpdateWnfStateData",
    "NtAdjustTokenClaimsAndDeviceGroups",
    "NtWaitForAlertByThreadId",
    "NtWaitForDebugEvent",
    "NtWaitForKeyedEvent",
    "NtWaitForWorkViaWorkerFactory",
    "NtAdjustTokenClaimsAndDeviceGroups",
    "NtAdjustTokenClaimsAndDeviceGroups"
};

//////////////////////////////////////////////////////////////////////////
// Windows 10 RS2 _KiServiceTable
//////////////////////////////////////////////////////////////////////////
static const char* KiServiceTable_Win10Rs2_x64[] = {
    "NtAccessCheck",
    "NtWorkerFactoryWorkerReady",
    "NtAcceptConnectPort",
    "NtMapUserPhysicalPagesScatter",
    "NtWaitForSingleObject",
    "NtCallbackReturn",
    "NtReadFile",
    "NtDeviceIoControlFile",
    "NtWriteFile",
    "NtRemoveIoCompletion",
    "NtReleaseSemaphore",
    "NtReplyWaitReceivePort",
    "NtReplyPort",
    "NtSetInformationThread",
    "NtSetEvent",
    "NtClose",
    "NtQueryObject",
    "NtQueryInformationFile",
    "NtOpenKey",
    "NtEnumerateValueKey",
    "NtFindAtom",
    "NtQueryDefaultLocale",
    "NtQueryKey",
    "NtQueryValueKey",
    "NtAllocateVirtualMemory",
    "NtQueryInformationProcess",
    "NtWaitForMultipleObjects32",
    "NtWriteFileGather",
    "NtSetInformationProcess",
    "NtCreateKey",
    "NtFreeVirtualMemory",
    "NtImpersonateClientOfPort",
    "NtReleaseMutant",
    "NtQueryInformationToken",
    "NtRequestWaitReplyPort",
    "NtQueryVirtualMemory",
    "NtOpenThreadToken",
    "NtQueryInformationThread",
    "NtOpenProcess",
    "NtSetInformationFile",
    "NtMapViewOfSection",
    "NtAccessCheckAndAuditAlarm",
    "NtUnmapViewOfSection",
    "NtReplyWaitReceivePortEx",
    "NtTerminateProcess",
    "NtSetEventBoostPriority",
    "NtReadFileScatter",
    "NtOpenThreadTokenEx",
    "NtOpenProcessTokenEx",
    "NtQueryPerformanceCounter",
    "NtEnumerateKey",
    "NtOpenFile",
    "NtDelayExecution",
    "NtQueryDirectoryFile",
    "NtQuerySystemInformation",
    "NtOpenSection",
    "NtQueryTimer",
    "NtFsControlFile",
    "NtWriteVirtualMemory",
    "NtCloseObjectAuditAlarm",
    "NtDuplicateObject",
    "NtQueryAttributesFile",
    "NtClearEvent",
    "NtReadVirtualMemory",
    "NtOpenEvent",
    "NtAdjustPrivilegesToken",
    "NtDuplicateToken",
    "NtContinue",
    "NtQueryDefaultUILanguage",
    "NtQueueApcThread",
    "NtYieldExecution",
    "NtAddAtom",
    "NtCreateEvent",
    "NtQueryVolumeInformationFile",
    "NtCreateSection",
    "NtFlushBuffersFile",
    "NtApphelpCacheControl",
    "NtCreateProcessEx",
    "NtCreateThread",
    "NtIsProcessInJob",
    "NtProtectVirtualMemory",
    "NtQuerySection",
    "NtResumeThread",
    "NtTerminateThread",
    "NtReadRequestData",
    "NtCreateFile",
    "NtQueryEvent",
    "NtWriteRequestData",
    "NtOpenDirectoryObject",
    "NtAccessCheckByTypeAndAuditAlarm",
    "NtQuerySystemTime",
    "NtWaitForMultipleObjects",
    "NtSetInformationObject",
    "NtCancelIoFile",
    "NtTraceEvent",
    "NtPowerInformation",
    "NtSetValueKey",
    "NtCancelTimer",
    "NtSetTimer",
    "NtAccessCheckByType",
    "NtAccessCheckByTypeResultList",
    "NtAccessCheckByTypeResultListAndAuditAlarm",
    "NtAccessCheckByTypeResultListAndAuditAlarmByHandle",
    "NtAcquireProcessActivityReference",
    "NtAddAtomEx",
    "NtAddBootEntry",
    "NtAddDriverEntry",
    "NtAdjustGroupsToken",
    "NtAdjustTokenClaimsAndDeviceGroups",
    "NtAlertResumeThread",
    "NtAlertThread",
    "NtAlertThreadByThreadId",
    "NtAllocateLocallyUniqueId",
    "NtAllocateReserveObject",
    "NtAllocateUserPhysicalPages",
    "NtAllocateUuids",
    "NtAlpcAcceptConnectPort",
    "NtAlpcCancelMessage",
    "NtAlpcConnectPort",
    "NtAlpcConnectPortEx",
    "NtAlpcCreatePort",
    "NtAlpcCreatePortSection",
    "NtAlpcCreateResourceReserve",
    "NtAlpcCreateSectionView",
    "NtAlpcCreateSecurityContext",
    "NtAlpcDeletePortSection",
    "NtAlpcDeleteResourceReserve",
    "NtAlpcDeleteSectionView",
    "NtAlpcDeleteSecurityContext",
    "NtAlpcDisconnectPort",
    "NtAlpcImpersonateClientContainerOfPort",
    "NtAlpcImpersonateClientOfPort",
    "NtAlpcOpenSenderProcess",
    "NtAlpcOpenSenderThread",
    "NtAlpcQueryInformation",
    "NtAlpcQueryInformationMessage",
    "NtAlpcRevokeSecurityContext",
    "NtAlpcSendWaitReceivePort",
    "NtAlpcSetInformation",
    "NtAreMappedFilesTheSame",
    "NtAssignProcessToJobObject",
    "NtAssociateWaitCompletionPacket",
    "NtCancelIoFileEx",
    "NtCancelSynchronousIoFile",
    "NtCancelTimer2",
    "NtCancelWaitCompletionPacket",
    "NtCommitComplete",
    "NtCommitEnlistment",
    "NtCommitRegistryTransaction",
    "NtCommitTransaction",
    "NtCompactKeys",
    "NtCompareObjects",
    "NtCompareSigningLevels",
    "NtCompareTokens",
    "ArbPreprocessEntry",
    "NtCompressKey",
    "NtConnectPort",
    "NtConvertBetweenAuxiliaryCounterAndPerformanceCounter",
    "NtCreateDebugObject",
    "NtCreateDirectoryObject",
    "NtCreateDirectoryObjectEx",
    "NtCreateEnclave",
    "NtCreateEnlistment",
    "NtAdjustTokenClaimsAndDeviceGroups",
    "NtCreateIRTimer",
    "NtCreateIoCompletion",
    "NtCreateJobObject",
    "ArbAddReserved",
    "NtCreateKeyTransacted",
    "NtCreateKeyedEvent",
    "NtCreateLowBoxToken",
    "NtCreateMailslotFile",
    "NtCreateMutant",
    "NtCreateNamedPipeFile",
    "NtCreatePagingFile",
    "NtCreatePartition",
    "NtCreatePort",
    "NtCreatePrivateNamespace",
    "NtCreateProcess",
    "NtCreateProfile",
    "NtCreateProfileEx",
    "NtCreateRegistryTransaction",
    "NtCreateResourceManager",
    "NtCreateSemaphore",
    "NtCreateSymbolicLinkObject",
    "NtCreateThreadEx",
    "NtCreateTimer",
    "NtCreateTimer2",
    "NtCreateToken",
    "NtCreateTokenEx",
    "NtCreateTransaction",
    "NtCreateTransactionManager",
    "NtCreateUserProcess",
    "NtCreateWaitCompletionPacket",
    "NtCreateWaitablePort",
    "NtCreateWnfStateName",
    "NtCreateWorkerFactory",
    "NtDebugActiveProcess",
    "NtDebugContinue",
    "NtDeleteAtom",
    "NtDeleteBootEntry",
    "NtDeleteDriverEntry",
    "NtDeleteFile",
    "NtDeleteKey",
    "NtDeleteObjectAuditAlarm",
    "NtDeletePrivateNamespace",
    "NtDeleteValueKey",
    "NtDeleteWnfStateData",
    "NtDeleteWnfStateName",
    "NtDisableLastKnownGood",
    "NtDisplayString",
    "NtDrawText",
    "NtEnableLastKnownGood",
    "NtEnumerateBootEntries",
    "NtEnumerateDriverEntries",
    "NtEnumerateSystemEnvironmentValuesEx",
    "NtEnumerateTransactionObject",
    "NtExtendSection",
    "NtFilterBootOption",
    "NtFilterToken",
    "NtAdjustTokenClaimsAndDeviceGroups",
    "NtFlushBuffersFileEx",
    "NtFlushInstallUILanguage",
    "ArbPreprocessEntry",
    "NtFlushKey",
    "NtFlushProcessWriteBuffers",
    "NtFlushVirtualMemory",
    "NtFlushWriteBuffer",
    "NtFreeUserPhysicalPages",
    "NtFreezeRegistry",
    "NtFreezeTransactions",
    "NtGetCachedSigningLevel",
    "NtGetCompleteWnfStateSubscription",
    "NtGetContextThread",
    "NtGetCurrentProcessorNumber",
    "NtGetCurrentProcessorNumberEx",
    "NtGetDevicePowerState",
    "NtGetMUIRegistryInfo",
    "NtGetNextProcess",
    "NtGetNextThread",
    "NtGetNlsSectionPtr",
    "NtGetNotificationResourceManager",
    "NtGetWriteWatch",
    "NtImpersonateAnonymousToken",
    "NtImpersonateThread",
    "NtInitializeEnclave",
    "NtInitializeNlsFiles",
    "NtInitializeRegistry",
    "NtInitiatePowerAction",
    "NtIsSystemResumeAutomatic",
    "NtIsUILanguageComitted",
    "NtListenPort",
    "NtLoadDriver",
    "NtLoadEnclaveData",
    "NtLoadHotPatch",
    "NtLoadKey",
    "NtLoadKey2",
    "NtLoadKeyEx",
    "NtLockFile",
    "NtLockProductActivationKeys",
    "NtLockRegistryKey",
    "NtLockVirtualMemory",
    "NtMakePermanentObject",
    "NtMakeTemporaryObject",
    "NtManagePartition",
    "NtMapCMFModule",
    "NtMapUserPhysicalPages",
    "NtModifyBootEntry",
    "NtModifyDriverEntry",
    "NtNotifyChangeDirectoryFile",
    "NtNotifyChangeKey",
    "NtNotifyChangeMultipleKeys",
    "NtNotifyChangeSession",
    "NtOpenEnlistment",
    "NtAdjustTokenClaimsAndDeviceGroups",
    "NtOpenIoCompletion",
    "NtOpenJobObject",
    "NtOpenKeyEx",
    "NtOpenKeyTransacted",
    "NtOpenKeyTransactedEx",
    "NtOpenKeyedEvent",
    "NtOpenMutant",
    "NtOpenObjectAuditAlarm",
    "NtOpenPartition",
    "NtOpenPrivateNamespace",
    "NtOpenProcessToken",
    "NtOpenRegistryTransaction",
    "NtOpenResourceManager",
    "NtOpenSemaphore",
    "NtOpenSession",
    "NtOpenSymbolicLinkObject",
    "NtOpenThread",
    "NtOpenTimer",
    "NtOpenTransaction",
    "NtOpenTransactionManager",
    "NtPlugPlayControl",
    "NtPrePrepareComplete",
    "NtPrePrepareEnlistment",
    "NtPrepareComplete",
    "NtPrepareEnlistment",
    "NtPrivilegeCheck",
    "NtPrivilegeObjectAuditAlarm",
    "NtPrivilegedServiceAuditAlarm",
    "NtPropagationComplete",
    "NtPropagationFailed",
    "NtPulseEvent",
    "NtQueryAuxiliaryCounterFrequency",
    "NtQueryBootEntryOrder",
    "NtQueryBootOptions",
    "NtQueryDebugFilterState",
    "NtQueryDirectoryObject",
    "NtQueryDriverEntryOrder",
    "NtQueryEaFile",
    "NtQueryFullAttributesFile",
    "NtQueryInformationAtom",
    "NtQueryInformationByName",
    "NtQueryInformationEnlistment",
    "NtQueryInformationJobObject",
    "NtQueryInformationPort",
    "NtQueryInformationResourceManager",
    "NtQueryInformationTransaction",
    "NtQueryInformationTransactionManager",
    "NtQueryInformationWorkerFactory",
    "NtQueryInstallUILanguage",
    "NtQueryIntervalProfile",
    "NtQueryIoCompletion",
    "NtQueryLicenseValue",
    "NtQueryMultipleValueKey",
    "NtQueryMutant",
    "NtQueryOpenSubKeys",
    "NtQueryOpenSubKeysEx",
    "CmpForceInvalidatePreCallback",
    "NtQueryQuotaInformationFile",
    "NtQuerySecurityAttributesToken",
    "NtQuerySecurityObject",
    "NtQuerySecurityPolicy",
    "NtQuerySemaphore",
    "NtQuerySymbolicLinkObject",
    "NtQuerySystemEnvironmentValue",
    "NtQuerySystemEnvironmentValueEx",
    "NtQuerySystemInformationEx",
    "NtQueryTimerResolution",
    "NtQueryWnfStateData",
    "NtQueryWnfStateNameInformation",
    "NtQueueApcThreadEx",
    "NtRaiseException",
    "NtRaiseHardError",
    "NtReadOnlyEnlistment",
    "NtRecoverEnlistment",
    "NtRecoverResourceManager",
    "NtRecoverTransactionManager",
    "NtRegisterProtocolAddressInformation",
    "NtRegisterThreadTerminatePort",
    "NtReleaseKeyedEvent",
    "NtReleaseWorkerFactoryWorker",
    "NtRemoveIoCompletionEx",
    "NtRemoveProcessDebug",
    "NtRenameKey",
    "NtRenameTransactionManager",
    "NtReplaceKey",
    "NtReplacePartitionUnit",
    "NtReplyWaitReplyPort",
    "NtRequestPort",
    "NtResetEvent",
    "NtResetWriteWatch",
    "NtRestoreKey",
    "NtResumeProcess",
    "NtRevertContainerImpersonation",
    "NtRollbackComplete",
    "NtRollbackEnlistment",
    "NtRollbackRegistryTransaction",
    "NtRollbackTransaction",
    "NtRollforwardTransactionManager",
    "NtSaveKey",
    "NtSaveKeyEx",
    "NtSaveMergedKeys",
    "NtSecureConnectPort",
    "NtSerializeBoot",
    "NtSetBootEntryOrder",
    "NtSetBootOptions",
    "NtSetCachedSigningLevel",
    "NtSetCachedSigningLevel2",
    "NtSetContextThread",
    "NtSetDebugFilterState",
    "NtSetDefaultHardErrorPort",
    "NtSetDefaultLocale",
    "NtSetDefaultUILanguage",
    "NtSetDriverEntryOrder",
    "NtSetEaFile",
    "NtAdjustTokenClaimsAndDeviceGroups",
    "NtAdjustTokenClaimsAndDeviceGroups",
    "NtSetIRTimer",
    "NtSetInformationDebugObject",
    "NtSetInformationEnlistment",
    "NtSetInformationJobObject",
    "NtSetInformationKey",
    "NtSetInformationResourceManager",
    "NtSetInformationSymbolicLink",
    "NtSetInformationToken",
    "NtSetInformationTransaction",
    "NtSetInformationTransactionManager",
    "NtSetInformationVirtualMemory",
    "NtSetInformationWorkerFactory",
    "NtSetIntervalProfile",
    "NtSetIoCompletion",
    "NtSetIoCompletionEx",
    "BvgaSetVirtualFrameBuffer",
    "NtAdjustTokenClaimsAndDeviceGroups",
    "NtAdjustTokenClaimsAndDeviceGroups",
    "NtSetQuotaInformationFile",
    "NtSetSecurityObject",
    "NtSetSystemEnvironmentValue",
    "NtSetSystemEnvironmentValueEx",
    "NtSetSystemInformation",
    "NtSetSystemPowerState",
    "NtSetSystemTime",
    "NtSetThreadExecutionState",
    "NtSetTimer2",
    "NtSetTimerEx",
    "NtSetTimerResolution",
    "NtSetUuidSeed",
    "NtSetVolumeInformationFile",
    "NtSetWnfProcessNotificationEvent",
    "NtShutdownSystem",
    "NtShutdownWorkerFactory",
    "NtSignalAndWaitForSingleObject",
    "NtSinglePhaseReject",
    "NtStartProfile",
    "NtStopProfile",
    "NtSubscribeWnfStateChange",
    "NtSuspendProcess",
    "NtSuspendThread",
    "NtSystemDebugControl",
    "NtTerminateJobObject",
    "NtTestAlert",
    "NtThawRegistry",
    "NtThawTransactions",
    "NtTraceControl",
    "NtTranslateFilePath",
    "NtUmsThreadYield",
    "NtUnloadDriver",
    "NtUnloadKey",
    "NtUnloadKey2",
    "NtUnloadKeyEx",
    "NtUnlockFile",
    "NtUnlockVirtualMemory",
    "NtUnmapViewOfSectionEx",
    "NtUnsubscribeWnfStateChange",
    "NtUpdateWnfStateData",
    "NtAdjustTokenClaimsAndDeviceGroups",
    "NtWaitForAlertByThreadId",
    "NtWaitForDebugEvent",
    "NtWaitForKeyedEvent",
    "NtWaitForWorkViaWorkerFactory",
    "NtAdjustTokenClaimsAndDeviceGroups",
    "NtAdjustTokenClaimsAndDeviceGroups"
};

//////////////////////////////////////////////////////////////////////////
// Windows 10 RS3 _KiServiceTable
//////////////////////////////////////////////////////////////////////////
static const char* KiServiceTable_Win10Rs3_x64[] = {
    "NtAccessCheck",
    "NtWorkerFactoryWorkerReady",
    "NtAcceptConnectPort",
    "NtMapUserPhysicalPagesScatter",
    "NtWaitForSingleObject",
    "NtCallbackReturn",
    "NtReadFile",
    "NtDeviceIoControlFile",
    "NtWriteFile",
    "NtRemoveIoCompletion",
    "NtReleaseSemaphore",
    "NtReplyWaitReceivePort",
    "NtReplyPort",
    "NtSetInformationThread",
    "NtSetEvent",
    "NtClose",
    "NtQueryObject",
    "NtQueryInformationFile",
    "NtOpenKey",
    "NtEnumerateValueKey",
    "NtFindAtom",
    "NtQueryDefaultLocale",
    "NtQueryKey",
    "NtQueryValueKey",
    "NtAllocateVirtualMemory",
    "NtQueryInformationProcess",
    "NtWaitForMultipleObjects32",
    "NtWriteFileGather",
    "NtSetInformationProcess",
    "NtCreateKey",
    "NtFreeVirtualMemory",
    "NtImpersonateClientOfPort",
    "NtReleaseMutant",
    "NtQueryInformationToken",
    "NtRequestWaitReplyPort",
    "NtQueryVirtualMemory",
    "NtOpenThreadToken",
    "NtQueryInformationThread",
    "NtOpenProcess",
    "NtSetInformationFile",
    "NtMapViewOfSection",
    "NtAccessCheckAndAuditAlarm",
    "NtUnmapViewOfSection",
    "NtReplyWaitReceivePortEx",
    "NtTerminateProcess",
    "NtSetEventBoostPriority",
    "NtReadFileScatter",
    "NtOpenThreadTokenEx",
    "NtOpenProcessTokenEx",
    "NtQueryPerformanceCounter",
    "NtEnumerateKey",
    "NtOpenFile",
    "NtDelayExecution",
    "NtQueryDirectoryFile",
    "NtQuerySystemInformation",
    "NtOpenSection",
    "NtQueryTimer",
    "NtFsControlFile",
    "NtWriteVirtualMemory",
    "NtCloseObjectAuditAlarm",
    "NtDuplicateObject",
    "NtQueryAttributesFile",
    "NtClearEvent",
    "NtReadVirtualMemory",
    "NtOpenEvent",
    "NtAdjustPrivilegesToken",
    "NtDuplicateToken",
    "NtContinue",
    "NtQueryDefaultUILanguage",
    "NtQueueApcThread",
    "NtYieldExecution",
    "NtAddAtom",
    "NtCreateEvent",
    "NtQueryVolumeInformationFile",
    "NtCreateSection",
    "NtFlushBuffersFile",
    "NtApphelpCacheControl",
    "NtCreateProcessEx",
    "NtCreateThread",
    "NtIsProcessInJob",
    "NtProtectVirtualMemory",
    "NtQuerySection",
    "NtResumeThread",
    "NtTerminateThread",
    "NtReadRequestData",
    "NtCreateFile",
    "NtQueryEvent",
    "NtWriteRequestData",
    "NtOpenDirectoryObject",
    "NtAccessCheckByTypeAndAuditAlarm",
    "NtQuerySystemTime",
    "NtWaitForMultipleObjects",
    "NtSetInformationObject",
    "NtCancelIoFile",
    "NtTraceEvent",
    "NtPowerInformation",
    "NtSetValueKey",
    "NtCancelTimer",
    "NtSetTimer",
    "NtAccessCheckByType",
    "NtAccessCheckByTypeResultList",
    "NtAccessCheckByTypeResultListAndAuditAlarm",
    "NtAccessCheckByTypeResultListAndAuditAlarmByHandle",
    "NtAcquireProcessActivityReference",
    "NtAddAtomEx",
    "NtAddBootEntry",
    "NtAddDriverEntry",
    "NtAdjustGroupsToken",
    "NT_DISK::GetPnpProperty",
    "NtAlertResumeThread",
    "NtAlertThread",
    "NtAlertThreadByThreadId",
    "NtAllocateLocallyUniqueId",
    "NtAllocateReserveObject",
    "NtAllocateUserPhysicalPages",
    "NtAllocateUuids",
    "NtAlpcAcceptConnectPort",
    "NtAlpcCancelMessage",
    "NtAlpcConnectPort",
    "NtAlpcConnectPortEx",
    "NtAlpcCreatePort",
    "NtAlpcCreatePortSection",
    "NtAlpcCreateResourceReserve",
    "NtAlpcCreateSectionView",
    "NtAlpcCreateSecurityContext",
    "NtAlpcDeletePortSection",
    "NtAlpcDeleteResourceReserve",
    "NtAlpcDeleteSectionView",
    "NtAlpcDeleteSecurityContext",
    "NtAlpcDisconnectPort",
    "NtAlpcImpersonateClientContainerOfPort",
    "NtAlpcImpersonateClientOfPort",
    "NtAlpcOpenSenderProcess",
    "NtAlpcOpenSenderThread",
    "NtAlpcQueryInformation",
    "NtAlpcQueryInformationMessage",
    "NtAlpcRevokeSecurityContext",
    "NtAlpcSendWaitReceivePort",
    "NtAlpcSetInformation",
    "NtAreMappedFilesTheSame",
    "NtAssignProcessToJobObject",
    "NtAssociateWaitCompletionPacket",
    "NtCallEnclave",
    "NtCancelIoFileEx",
    "NtCancelSynchronousIoFile",
    "NtCancelTimer2",
    "NtCancelWaitCompletionPacket",
    "NtCommitComplete",
    "NtCommitEnlistment",
    "NtCommitRegistryTransaction",
    "NtCommitTransaction",
    "NtCompactKeys",
    "NtCompareObjects",
    "NtCompareSigningLevels",
    "NtCompareTokens",
    "ArbPreprocessEntry",
    "NtCompressKey",
    "NtConnectPort",
    "NtConvertBetweenAuxiliaryCounterAndPerformanceCounter",
    "NtCreateDebugObject",
    "NtCreateDirectoryObject",
    "NtCreateDirectoryObjectEx",
    "NtCreateEnclave",
    "NtCreateEnlistment",
    "NT_DISK::GetPnpProperty",
    "NtCreateIRTimer",
    "NtCreateIoCompletion",
    "NtCreateJobObject",
    "ArbAddReserved",
    "NtCreateKeyTransacted",
    "NtCreateKeyedEvent",
    "NtCreateLowBoxToken",
    "NtCreateMailslotFile",
    "NtCreateMutant",
    "NtCreateNamedPipeFile",
    "NtCreatePagingFile",
    "NtCreatePartition",
    "NtCreatePort",
    "NtCreatePrivateNamespace",
    "NtCreateProcess",
    "NtCreateProfile",
    "NtCreateProfileEx",
    "NtCreateRegistryTransaction",
    "NtCreateResourceManager",
    "NtCreateSemaphore",
    "NtCreateSymbolicLinkObject",
    "NtCreateThreadEx",
    "NtCreateTimer",
    "NtCreateTimer2",
    "NtCreateToken",
    "NtCreateTokenEx",
    "NtCreateTransaction",
    "NtCreateTransactionManager",
    "NtCreateUserProcess",
    "NtCreateWaitCompletionPacket",
    "NtCreateWaitablePort",
    "NtCreateWnfStateName",
    "NtCreateWorkerFactory",
    "NtDebugActiveProcess",
    "NtDebugContinue",
    "NtDeleteAtom",
    "NtDeleteBootEntry",
    "NtDeleteDriverEntry",
    "NtDeleteFile",
    "NtDeleteKey",
    "NtDeleteObjectAuditAlarm",
    "NtDeletePrivateNamespace",
    "NtDeleteValueKey",
    "NtDeleteWnfStateData",
    "NtDeleteWnfStateName",
    "NtDisableLastKnownGood",
    "NtDisplayString",
    "NtDrawText",
    "NtEnableLastKnownGood",
    "NtEnumerateBootEntries",
    "NtEnumerateDriverEntries",
    "NtEnumerateSystemEnvironmentValuesEx",
    "NtEnumerateTransactionObject",
    "NtExtendSection",
    "NtFilterBootOption",
    "NtFilterToken",
    "NT_DISK::GetPnpProperty",
    "NtFlushBuffersFileEx",
    "NtFlushInstallUILanguage",
    "ArbPreprocessEntry",
    "NtFlushKey",
    "NtFlushProcessWriteBuffers",
    "NtFlushVirtualMemory",
    "NtFlushWriteBuffer",
    "NtFreeUserPhysicalPages",
    "NtFreezeRegistry",
    "NtFreezeTransactions",
    "NtGetCachedSigningLevel",
    "NtGetCompleteWnfStateSubscription",
    "NtGetContextThread",
    "NtGetCurrentProcessorNumber",
    "NtGetCurrentProcessorNumberEx",
    "NtGetDevicePowerState",
    "NtGetMUIRegistryInfo",
    "NtGetNextProcess",
    "NtGetNextThread",
    "NtGetNlsSectionPtr",
    "NtGetNotificationResourceManager",
    "NtGetWriteWatch",
    "NtImpersonateAnonymousToken",
    "NtImpersonateThread",
    "NtInitializeEnclave",
    "NtInitializeNlsFiles",
    "NtInitializeRegistry",
    "NtInitiatePowerAction",
    "NtIsSystemResumeAutomatic",
    "NtIsUILanguageComitted",
    "NtListenPort",
    "NtLoadDriver",
    "NtLoadEnclaveData",
    "NtLoadHotPatch",
    "NtLoadKey",
    "NtLoadKey2",
    "NtLoadKeyEx",
    "NtLockFile",
    "NtLockProductActivationKeys",
    "NtLockRegistryKey",
    "NtLockVirtualMemory",
    "NtMakePermanentObject",
    "NtMakeTemporaryObject",
    "NtManagePartition",
    "NtMapCMFModule",
    "NtMapUserPhysicalPages",
    "NtModifyBootEntry",
    "NtModifyDriverEntry",
    "NtNotifyChangeDirectoryFile",
    "NtNotifyChangeDirectoryFileEx",
    "NtNotifyChangeKey",
    "NtNotifyChangeMultipleKeys",
    "NtNotifyChangeSession",
    "NtOpenEnlistment",
    "NT_DISK::GetPnpProperty",
    "NtOpenIoCompletion",
    "NtOpenJobObject",
    "NtOpenKeyEx",
    "NtOpenKeyTransacted",
    "NtOpenKeyTransactedEx",
    "NtOpenKeyedEvent",
    "NtOpenMutant",
    "NtOpenObjectAuditAlarm",
    "NtOpenPartition",
    "NtOpenPrivateNamespace",
    "NtOpenProcessToken",
    "NtOpenRegistryTransaction",
    "NtOpenResourceManager",
    "NtOpenSemaphore",
    "NtOpenSession",
    "NtOpenSymbolicLinkObject",
    "NtOpenThread",
    "NtOpenTimer",
    "NtOpenTransaction",
    "NtOpenTransactionManager",
    "NtPlugPlayControl",
    "NtPrePrepareComplete",
    "NtPrePrepareEnlistment",
    "NtPrepareComplete",
    "NtPrepareEnlistment",
    "NtPrivilegeCheck",
    "NtPrivilegeObjectAuditAlarm",
    "NtPrivilegedServiceAuditAlarm",
    "NtPropagationComplete",
    "NtPropagationFailed",
    "NtPulseEvent",
    "NtQueryAuxiliaryCounterFrequency",
    "NtQueryBootEntryOrder",
    "NtQueryBootOptions",
    "NtQueryDebugFilterState",
    "NtQueryDirectoryFileEx",
    "NtQueryDirectoryObject",
    "NtQueryDriverEntryOrder",
    "NtQueryEaFile",
    "NtQueryFullAttributesFile",
    "NtQueryInformationAtom",
    "NtQueryInformationByName",
    "NtQueryInformationEnlistment",
    "NtQueryInformationJobObject",
    "NtQueryInformationPort",
    "NtQueryInformationResourceManager",
    "NtQueryInformationTransaction",
    "NtQueryInformationTransactionManager",
    "NtQueryInformationWorkerFactory",
    "NtQueryInstallUILanguage",
    "NtQueryIntervalProfile",
    "NtQueryIoCompletion",
    "NtQueryLicenseValue",
    "NtQueryMultipleValueKey",
    "NtQueryMutant",
    "NtQueryOpenSubKeys",
    "NtQueryOpenSubKeysEx",
    "CmpForceInvalidatePreCallback",
    "NtQueryQuotaInformationFile",
    "NtQuerySecurityAttributesToken",
    "NtQuerySecurityObject",
    "NtQuerySecurityPolicy",
    "NtQuerySemaphore",
    "NtQuerySymbolicLinkObject",
    "NtQuerySystemEnvironmentValue",
    "NtQuerySystemEnvironmentValueEx",
    "NtQuerySystemInformationEx",
    "NtQueryTimerResolution",
    "NtQueryWnfStateData",
    "NtQueryWnfStateNameInformation",
    "NtQueueApcThreadEx",
    "NtRaiseException",
    "NtRaiseHardError",
    "NtReadOnlyEnlistment",
    "NtRecoverEnlistment",
    "NtRecoverResourceManager",
    "NtRecoverTransactionManager",
    "NtRegisterProtocolAddressInformation",
    "NtRegisterThreadTerminatePort",
    "NtReleaseKeyedEvent",
    "NtReleaseWorkerFactoryWorker",
    "NtRemoveIoCompletionEx",
    "NtRemoveProcessDebug",
    "NtRenameKey",
    "NtRenameTransactionManager",
    "NtReplaceKey",
    "NtReplacePartitionUnit",
    "NtReplyWaitReplyPort",
    "NtRequestPort",
    "NtResetEvent",
    "NtResetWriteWatch",
    "NtRestoreKey",
    "NtResumeProcess",
    "NtRevertContainerImpersonation",
    "NtRollbackComplete",
    "NtRollbackEnlistment",
    "NtRollbackRegistryTransaction",
    "NtRollbackTransaction",
    "NtRollforwardTransactionManager",
    "NtSaveKey",
    "NtSaveKeyEx",
    "NtSaveMergedKeys",
    "NtSecureConnectPort",
    "NtSerializeBoot",
    "NtSetBootEntryOrder",
    "NtSetBootOptions",
    "NtSetCachedSigningLevel",
    "NtSetCachedSigningLevel2",
    "NtSetContextThread",
    "NtSetDebugFilterState",
    "NtSetDefaultHardErrorPort",
    "NtSetDefaultLocale",
    "NtSetDefaultUILanguage",
    "NtSetDriverEntryOrder",
    "NtSetEaFile",
    "NT_DISK::GetPnpProperty",
    "NT_DISK::GetPnpProperty",
    "NtSetIRTimer",
    "NtSetInformationDebugObject",
    "NtSetInformationEnlistment",
    "NtSetInformationJobObject",
    "NtSetInformationKey",
    "NtSetInformationResourceManager",
    "NtSetInformationSymbolicLink",
    "NtSetInformationToken",
    "NtSetInformationTransaction",
    "NtSetInformationTransactionManager",
    "NtSetInformationVirtualMemory",
    "NtSetInformationWorkerFactory",
    "NtSetIntervalProfile",
    "NtSetIoCompletion",
    "NtSetIoCompletionEx",
    "BvgaSetVirtualFrameBuffer",
    "NT_DISK::GetPnpProperty",
    "NT_DISK::GetPnpProperty",
    "NtSetQuotaInformationFile",
    "NtSetSecurityObject",
    "NtSetSystemEnvironmentValue",
    "NtSetSystemEnvironmentValueEx",
    "NtSetSystemInformation",
    "NtSetSystemPowerState",
    "NtSetSystemTime",
    "NtSetThreadExecutionState",
    "NtSetTimer2",
    "NtSetTimerEx",
    "NtSetTimerResolution",
    "NtSetUuidSeed",
    "NtSetVolumeInformationFile",
    "NtSetWnfProcessNotificationEvent",
    "NtShutdownSystem",
    "NtShutdownWorkerFactory",
    "NtSignalAndWaitForSingleObject",
    "NtSinglePhaseReject",
    "NtStartProfile",
    "NtStopProfile",
    "NtSubscribeWnfStateChange",
    "NtSuspendProcess",
    "NtSuspendThread",
    "NtSystemDebugControl",
    "NtTerminateEnclave",
    "NtTerminateJobObject",
    "NtTestAlert",
    "NtThawRegistry",
    "NtThawTransactions",
    "NtTraceControl",
    "NtTranslateFilePath",
    "NtUmsThreadYield",
    "NtUnloadDriver",
    "NtUnloadKey",
    "NtUnloadKey2",
    "NtUnloadKeyEx",
    "NtUnlockFile",
    "NtUnlockVirtualMemory",
    "NtUnmapViewOfSectionEx",
    "NtUnsubscribeWnfStateChange",
    "NtUpdateWnfStateData",
    "NT_DISK::GetPnpProperty",
    "NtWaitForAlertByThreadId",
    "NtWaitForDebugEvent",
    "NtWaitForKeyedEvent",
    "NtWaitForWorkViaWorkerFactory",
    "NT_DISK::GetPnpProperty",
    "NT_DISK::GetPnpProperty"
};

//////////////////////////////////////////////////////////////////////////
// x86
//////////////////////////////////////////////////////////////////////////

//////////////////////////////////////////////////////////////////////////
// Windows XP SP3 _W32pServiceTable
//////////////////////////////////////////////////////////////////////////
static const char* W32pServiceTable_XpSp3_x86[] = {
    "NtGdiAbortDoc",
    "NtGdiAbortPath",
    "NtGdiAddFontResourceW",
    "NtGdiAddRemoteFontToDC",
    "NtGdiAddFontMemResourceEx",
    "NtGdiRemoveMergeFont",
    "NtGdiAddRemoteMMInstanceToDC",
    "NtGdiAlphaBlend",
    "NtGdiAngleArc",
    "NtGdiAnyLinkedFonts",
    "NtGdiFontIsLinked",
    "NtGdiArcInternal",
    "NtGdiBeginPath",
    "NtGdiBitBlt",
    "NtGdiCancelDC",
    "NtGdiCheckBitmapBits",
    "NtGdiCloseFigure",
    "NtGdiClearBitmapAttributes",
    "NtGdiClearBrushAttributes",
    "NtGdiColorCorrectPalette",
    "NtGdiCombineRgn",
    "NtGdiCombineTransform",
    "NtGdiComputeXformCoefficients",
    "NtGdiConsoleTextOut",
    "NtGdiConvertMetafileRect",
    "NtGdiCreateBitmap",
    "NtGdiCreateClientObj",
    "NtGdiCreateColorSpace",
    "NtGdiCreateColorTransform",
    "NtGdiCreateCompatibleBitmap",
    "NtGdiCreateCompatibleDC",
    "NtGdiCreateDIBBrush",
    "NtGdiCreateDIBitmapInternal",
    "NtGdiCreateDIBSection",
    "NtGdiCreateEllipticRgn",
    "NtGdiCreateHalftonePalette",
    "NtGdiCreateHatchBrushInternal",
    "NtGdiCreateMetafileDC",
    "NtGdiCreatePaletteInternal",
    "NtGdiCreatePatternBrushInternal",
    "NtGdiCreatePen",
    "NtGdiCreateRectRgn",
    "NtGdiCreateRoundRectRgn",
    "NtGdiCreateServerMetaFile",
    "NtGdiCreateSolidBrush",
    "NtGdiD3dContextCreate",
    "NtGdiD3dContextDestroy",
    "NtGdiD3dContextDestroyAll",
    "NtGdiD3dValidateTextureStageState",
    "NtGdiD3dDrawPrimitives2",
    "NtGdiDdGetDriverState",
    "NtGdiDdAddAttachedSurface",
    "NtGdiDdAlphaBlt",
    "NtGdiDdAttachSurface",
    "NtGdiDdBeginMoCompFrame",
    "NtGdiDdBlt",
    "NtGdiDdCanCreateSurface",
    "NtGdiDdCanCreateD3DBuffer",
    "NtGdiDdColorControl",
    "NtGdiDdCreateDirectDrawObject",
    "NtGdiDdCreateSurface",
    "NtGdiDdCreateD3DBuffer",
    "NtGdiDdCreateMoComp",
    "NtGdiDdCreateSurfaceObject",
    "NtGdiDdDeleteDirectDrawObject",
    "NtGdiDdDeleteSurfaceObject",
    "NtGdiDdDestroyMoComp",
    "NtGdiDdDestroySurface",
    "NtGdiDdDestroyD3DBuffer",
    "NtGdiDdEndMoCompFrame",
    "NtGdiDdFlip",
    "NtGdiDdFlipToGDISurface",
    "NtGdiDdGetAvailDriverMemory",
    "NtGdiDdGetBltStatus",
    "NtGdiDdGetDC",
    "NtGdiDdGetDriverInfo",
    "NtGdiDdGetDxHandle",
    "NtGdiDdGetFlipStatus",
    "NtGdiDdGetInternalMoCompInfo",
    "NtGdiDdGetMoCompBuffInfo",
    "NtGdiDdGetMoCompGuids",
    "NtGdiDdGetMoCompFormats",
    "NtGdiDdGetScanLine",
    "NtGdiDdLock",
    "NtGdiDdLockD3D",
    "NtGdiDdQueryDirectDrawObject",
    "NtGdiDdQueryMoCompStatus",
    "NtGdiDdReenableDirectDrawObject",
    "NtGdiDdReleaseDC",
    "NtGdiDdRenderMoComp",
    "NtGdiDdResetVisrgn",
    "NtGdiDdSetColorKey",
    "NtGdiDdSetExclusiveMode",
    "NtGdiDdSetGammaRamp",
    "NtGdiDdCreateSurfaceEx",
    "NtGdiDdSetOverlayPosition",
    "NtGdiDdUnattachSurface",
    "NtGdiDdUnlock",
    "NtGdiDdUnlockD3D",
    "NtGdiDdUpdateOverlay",
    "NtGdiDdWaitForVerticalBlank",
    "NtGdiDvpCanCreateVideoPort",
    "NtGdiDvpColorControl",
    "NtGdiDvpCreateVideoPort",
    "NtGdiDvpDestroyVideoPort",
    "NtGdiDvpFlipVideoPort",
    "NtGdiDvpGetVideoPortBandwidth",
    "NtGdiDvpGetVideoPortField",
    "NtGdiDvpGetVideoPortFlipStatus",
    "NtGdiDvpGetVideoPortInputFormats",
    "NtGdiDvpGetVideoPortLine",
    "NtGdiDvpGetVideoPortOutputFormats",
    "NtGdiDvpGetVideoPortConnectInfo",
    "NtGdiDvpGetVideoSignalStatus",
    "NtGdiDvpUpdateVideoPort",
    "NtGdiDvpWaitForVideoPortSync",
    "NtGdiDvpAcquireNotification",
    "NtGdiDvpReleaseNotification",
    "NtGdiDxgGenericThunk",
    "NtGdiDeleteClientObj",
    "NtGdiDeleteColorSpace",
    "NtGdiDeleteColorTransform",
    "NtGdiDeleteObjectApp",
    "NtGdiDescribePixelFormat",
    "NtGdiGetPerBandInfo",
    "NtGdiDoBanding",
    "NtGdiDoPalette",
    "NtGdiDrawEscape",
    "NtGdiEllipse",
    "NtGdiEnableEudc",
    "NtGdiEndDoc",
    "NtGdiEndPage",
    "NtGdiEndPath",
    "NtGdiEnumFontChunk",
    "NtGdiEnumFontClose",
    "NtGdiEnumFontOpen",
    "NtGdiEnumObjects",
    "NtGdiEqualRgn",
    "NtGdiEudcLoadUnloadLink",
    "NtGdiExcludeClipRect",
    "NtGdiExtCreatePen",
    "NtGdiExtCreateRegion",
    "NtGdiExtEscape",
    "NtGdiExtFloodFill",
    "NtGdiExtGetObjectW",
    "NtGdiExtSelectClipRgn",
    "NtGdiExtTextOutW",
    "NtGdiFillPath",
    "NtGdiFillRgn",
    "NtGdiFlattenPath",
    "NtGdiFlushUserBatch",
    "NtGdiFlush",
    "NtGdiForceUFIMapping",
    "NtGdiFrameRgn",
    "NtGdiFullscreenControl",
    "NtGdiGetAndSetDCDword",
    "NtGdiGetAppClipBox",
    "NtGdiGetBitmapBits",
    "NtGdiGetBitmapDimension",
    "NtGdiGetBoundsRect",
    "NtGdiGetCharABCWidthsW",
    "NtGdiGetCharacterPlacementW",
    "NtGdiGetCharSet",
    "NtGdiGetCharWidthW",
    "NtGdiGetCharWidthInfo",
    "NtGdiGetColorAdjustment",
    "NtGdiGetColorSpaceforBitmap",
    "NtGdiGetDCDword",
    "NtGdiGetDCforBitmap",
    "NtGdiGetDCObject",
    "NtGdiGetDCPoint",
    "NtGdiGetDeviceCaps",
    "NtGdiGetDeviceGammaRamp",
    "NtGdiGetDeviceCapsAll",
    "NtGdiGetDIBitsInternal",
    "NtGdiGetETM",
    "NtGdiGetEudcTimeStampEx",
    "NtGdiGetFontData",
    "NtGdiGetFontResourceInfoInternalW",
    "NtGdiGetGlyphIndicesW",
    "NtGdiGetGlyphIndicesWInternal",
    "NtGdiGetGlyphOutline",
    "NtGdiGetKerningPairs",
    "NtGdiGetLinkedUFIs",
    "NtGdiGetMiterLimit",
    "NtGdiGetMonitorID",
    "NtGdiGetNearestColor",
    "NtGdiGetNearestPaletteIndex",
    "NtGdiGetObjectBitmapHandle",
    "NtGdiGetOutlineTextMetricsInternalW",
    "NtGdiGetPath",
    "NtGdiGetPixel",
    "NtGdiGetRandomRgn",
    "NtGdiGetRasterizerCaps",
    "NtGdiGetRealizationInfo",
    "NtGdiGetRegionData",
    "NtGdiGetRgnBox",
    "NtGdiGetServerMetaFileBits",
    "NtGdiGetSpoolMessage",
    "NtGdiGetStats",
    "NtGdiGetStockObject",
    "NtGdiGetStringBitmapW",
    "NtGdiGetSystemPaletteUse",
    "NtGdiGetTextCharsetInfo",
    "NtGdiGetTextExtent",
    "NtGdiGetTextExtentExW",
    "NtGdiGetTextFaceW",
    "NtGdiGetTextMetricsW",
    "NtGdiGetTransform",
    "NtGdiGetUFI",
    "NtGdiGetEmbUFI",
    "NtGdiGetUFIPathname",
    "NtGdiGetEmbedFonts",
    "NtGdiChangeGhostFont",
    "NtGdiAddEmbFontToDC",
    "NtGdiGetFontUnicodeRanges",
    "NtGdiGetWidthTable",
    "NtGdiGradientFill",
    "NtGdiHfontCreate",
    "NtGdiIcmBrushInfo",
    "NtGdiInit",
    "NtGdiInitSpool",
    "NtGdiIntersectClipRect",
    "NtGdiInvertRgn",
    "NtGdiLineTo",
    "NtGdiMakeFontDir",
    "NtGdiMakeInfoDC",
    "NtGdiMaskBlt",
    "NtGdiModifyWorldTransform",
    "NtGdiMonoBitmap",
    "NtGdiMoveTo",
    "NtGdiOffsetClipRgn",
    "NtGdiOffsetRgn",
    "NtGdiOpenDCW",
    "NtGdiPatBlt",
    "NtGdiPolyPatBlt",
    "NtGdiPathToRegion",
    "NtGdiPlgBlt",
    "NtGdiPolyDraw",
    "NtGdiPolyPolyDraw",
    "NtGdiPolyTextOutW",
    "NtGdiPtInRegion",
    "NtGdiPtVisible",
    "NtGdiQueryFonts",
    "NtGdiQueryFontAssocInfo",
    "NtGdiRectangle",
    "NtGdiRectInRegion",
    "NtGdiRectVisible",
    "NtGdiRemoveFontResourceW",
    "NtGdiRemoveFontMemResourceEx",
    "NtGdiResetDC",
    "NtGdiResizePalette",
    "NtGdiRestoreDC",
    "NtGdiRoundRect",
    "NtGdiSaveDC",
    "NtGdiScaleViewportExtEx",
    "NtGdiScaleWindowExtEx",
    "NtGdiSelectBitmap",
    "NtGdiSelectBrush",
    "NtGdiSelectClipPath",
    "NtGdiSelectFont",
    "NtGdiSelectPen",
    "NtGdiSetBitmapAttributes",
    "NtGdiSetBitmapBits",
    "NtGdiSetBitmapDimension",
    "NtGdiSetBoundsRect",
    "NtGdiSetBrushAttributes",
    "NtGdiSetBrushOrg",
    "NtGdiSetColorAdjustment",
    "NtGdiSetColorSpace",
    "NtGdiSetDeviceGammaRamp",
    "NtGdiSetDIBitsToDeviceInternal",
    "NtGdiSetFontEnumeration",
    "NtGdiSetFontXform",
    "NtGdiSetIcmMode",
    "NtGdiSetLinkedUFIs",
    "NtGdiSetMagicColors",
    "NtGdiSetMetaRgn",
    "NtGdiSetMiterLimit",
    "NtGdiGetDeviceWidth",
    "NtGdiMirrorWindowOrg",
    "NtGdiSetLayout",
    "NtGdiSetPixel",
    "NtGdiSetPixelFormat",
    "NtGdiSetRectRgn",
    "NtGdiSetSystemPaletteUse",
    "NtGdiSetTextJustification",
    "NtGdiSetupPublicCFONT",
    "NtGdiSetVirtualResolution",
    "NtGdiSetSizeDevice",
    "NtGdiStartDoc",
    "NtGdiStartPage",
    "NtGdiStretchBlt",
    "NtGdiStretchDIBitsInternal",
    "NtGdiStrokeAndFillPath",
    "NtGdiStrokePath",
    "NtGdiSwapBuffers",
    "NtGdiTransformPoints",
    "NtGdiTransparentBlt",
    "NtGdiUnloadPrinterDriver",
    "NtGdiUMPDEngFreeUserMem",
    "NtGdiUnrealizeObject",
    "NtGdiUpdateColors",
    "NtGdiWidenPath",
    "NtUserActivateKeyboardLayout",
    "NtUserAlterWindowStyle",
    "NtUserAssociateInputContext",
    "NtUserAttachThreadInput",
    "NtUserBeginPaint",
    "NtUserBitBltSysBmp",
    "NtUserBlockInput",
    "NtUserBuildHimcList",
    "NtUserBuildHwndList",
    "NtUserBuildNameList",
    "NtUserBuildPropList",
    "NtUserCallHwnd",
    "NtUserCallHwndLock",
    "NtUserCallHwndOpt",
    "NtUserCallHwndParam",
    "NtUserCallHwndParamLock",
    "NtUserCallMsgFilter",
    "NtUserCallNextHookEx",
    "NtUserCallNoParam",
    "NtUserCallOneParam",
    "NtUserCallTwoParam",
    "NtUserChangeClipboardChain",
    "NtUserChangeDisplaySettings",
    "NtUserCheckImeHotKey",
    "NtUserCheckMenuItem",
    "NtUserChildWindowFromPointEx",
    "NtUserClipCursor",
    "NtUserCloseClipboard",
    "NtUserCloseDesktop",
    "NtUserCloseWindowStation",
    "NtUserConsoleControl",
    "NtUserConvertMemHandle",
    "NtUserCopyAcceleratorTable",
    "NtUserCountClipboardFormats",
    "NtUserCreateAcceleratorTable",
    "NtUserCreateCaret",
    "NtUserCreateDesktop",
    "NtUserCreateInputContext",
    "NtUserCreateLocalMemHandle",
    "NtUserCreateWindowEx",
    "NtUserCreateWindowStation",
    "NtUserDdeGetQualityOfService",
    "NtUserDdeInitialize",
    "NtUserDdeSetQualityOfService",
    "NtUserDeferWindowPos",
    "NtUserDefSetText",
    "NtUserDeleteMenu",
    "NtUserDestroyAcceleratorTable",
    "NtUserDestroyCursor",
    "NtUserDestroyInputContext",
    "NtUserDestroyMenu",
    "NtUserDestroyWindow",
    "NtUserDisableThreadIme",
    "NtUserDispatchMessage",
    "NtUserDragDetect",
    "NtUserDragObject",
    "NtUserDrawAnimatedRects",
    "NtUserDrawCaption",
    "NtUserDrawCaptionTemp",
    "NtUserDrawIconEx",
    "NtUserDrawMenuBarTemp",
    "NtUserEmptyClipboard",
    "NtUserEnableMenuItem",
    "NtUserEnableScrollBar",
    "NtUserEndDeferWindowPosEx",
    "NtUserEndMenu",
    "NtUserEndPaint",
    "NtUserEnumDisplayDevices",
    "NtUserEnumDisplayMonitors",
    "NtUserEnumDisplaySettings",
    "NtUserEvent",
    "NtUserExcludeUpdateRgn",
    "NtUserFillWindow",
    "NtUserFindExistingCursorIcon",
    "NtUserFindWindowEx",
    "NtUserFlashWindowEx",
    "NtUserGetAltTabInfo",
    "NtUserGetAncestor",
    "NtUserGetAppImeLevel",
    "NtUserGetAsyncKeyState",
    "NtUserGetAtomName",
    "NtUserGetCaretBlinkTime",
    "NtUserGetCaretPos",
    "NtUserGetClassInfo",
    "NtUserGetClassName",
    "NtUserGetClipboardData",
    "NtUserGetClipboardFormatName",
    "NtUserGetClipboardOwner",
    "NtUserGetClipboardSequenceNumber",
    "NtUserGetClipboardViewer",
    "NtUserGetClipCursor",
    "NtUserGetComboBoxInfo",
    "NtUserGetControlBrush",
    "NtUserGetControlColor",
    "NtUserGetCPD",
    "NtUserGetCursorFrameInfo",
    "NtUserGetCursorInfo",
    "NtUserGetDC",
    "NtUserGetDCEx",
    "NtUserGetDoubleClickTime",
    "NtUserGetForegroundWindow",
    "NtUserGetGuiResources",
    "NtUserGetGUIThreadInfo",
    "NtUserGetIconInfo",
    "NtUserGetIconSize",
    "NtUserGetImeHotKey",
    "NtUserGetImeInfoEx",
    "NtUserGetInternalWindowPos",
    "NtUserGetKeyboardLayoutList",
    "NtUserGetKeyboardLayoutName",
    "NtUserGetKeyboardState",
    "NtUserGetKeyNameText",
    "NtUserGetKeyState",
    "NtUserGetListBoxInfo",
    "NtUserGetMenuBarInfo",
    "NtUserGetMenuIndex",
    "NtUserGetMenuItemRect",
    "NtUserGetMessage",
    "NtUserGetMouseMovePointsEx",
    "NtUserGetObjectInformation",
    "NtUserGetOpenClipboardWindow",
    "NtUserGetPriorityClipboardFormat",
    "NtUserGetProcessWindowStation",
    "NtUserGetRawInputBuffer",
    "NtUserGetRawInputData",
    "NtUserGetRawInputDeviceInfo",
    "NtUserGetRawInputDeviceList",
    "NtUserGetRegisteredRawInputDevices",
    "NtUserGetScrollBarInfo",
    "NtUserGetSystemMenu",
    "NtUserGetThreadDesktop",
    "NtUserGetThreadState",
    "NtUserGetTitleBarInfo",
    "NtUserGetUpdateRect",
    "NtUserGetUpdateRgn",
    "NtUserGetWindowDC",
    "NtUserGetWindowPlacement",
    "NtUserGetWOWClass",
    "NtUserHardErrorControl",
    "NtUserHideCaret",
    "NtUserHiliteMenuItem",
    "NtUserImpersonateDdeClientWindow",
    "NtUserInitialize",
    "NtUserInitializeClientPfnArrays",
    "NtUserInitTask",
    "NtUserInternalGetWindowText",
    "NtUserInvalidateRect",
    "NtUserInvalidateRgn",
    "NtUserIsClipboardFormatAvailable",
    "NtUserKillTimer",
    "NtUserLoadKeyboardLayoutEx",
    "NtUserLockWindowStation",
    "NtUserLockWindowUpdate",
    "NtUserLockWorkStation",
    "NtUserMapVirtualKeyEx",
    "NtUserMenuItemFromPoint",
    "NtUserMessageCall",
    "NtUserMinMaximize",
    "NtUserMNDragLeave",
    "NtUserMNDragOver",
    "NtUserModifyUserStartupInfoFlags",
    "NtUserMoveWindow",
    "NtUserNotifyIMEStatus",
    "NtUserNotifyProcessCreate",
    "NtUserNotifyWinEvent",
    "NtUserOpenClipboard",
    "NtUserOpenDesktop",
    "NtUserOpenInputDesktop",
    "NtUserOpenWindowStation",
    "NtUserPaintDesktop",
    "NtUserPeekMessage",
    "NtUserPostMessage",
    "NtUserPostThreadMessage",
    "NtUserPrintWindow",
    "NtUserProcessConnect",
    "NtUserQueryInformationThread",
    "NtUserQueryInputContext",
    "NtUserQuerySendMessage",
    "NtUserQueryUserCounters",
    "NtUserQueryWindow",
    "NtUserRealChildWindowFromPoint",
    "NtUserRealInternalGetMessage",
    "NtUserRealWaitMessageEx",
    "NtUserRedrawWindow",
    "NtUserRegisterClassExWOW",
    "NtUserRegisterUserApiHook",
    "NtUserRegisterHotKey",
    "NtUserRegisterRawInputDevices",
    "NtUserRegisterTasklist",
    "NtUserRegisterWindowMessage",
    "NtUserRemoveMenu",
    "NtUserRemoveProp",
    "NtUserResolveDesktop",
    "NtUserResolveDesktopForWOW",
    "NtUserSBGetParms",
    "NtUserScrollDC",
    "NtUserScrollWindowEx",
    "NtUserSelectPalette",
    "NtUserSendInput",
    "NtUserSetActiveWindow",
    "NtUserSetAppImeLevel",
    "NtUserSetCapture",
    "NtUserSetClassLong",
    "NtUserSetClassWord",
    "NtUserSetClipboardData",
    "NtUserSetClipboardViewer",
    "NtUserSetConsoleReserveKeys",
    "NtUserSetCursor",
    "NtUserSetCursorContents",
    "NtUserSetCursorIconData",
    "NtUserSetDbgTag",
    "NtUserSetFocus",
    "NtUserSetImeHotKey",
    "NtUserSetImeInfoEx",
    "NtUserSetImeOwnerWindow",
    "NtUserSetInformationProcess",
    "NtUserSetInformationThread",
    "NtUserSetInternalWindowPos",
    "NtUserSetKeyboardState",
    "NtUserSetLogonNotifyWindow",
    "NtUserSetMenu",
    "NtUserSetMenuContextHelpId",
    "NtUserSetMenuDefaultItem",
    "NtUserSetMenuFlagRtoL",
    "NtUserSetObjectInformation",
    "NtUserSetParent",
    "NtUserSetProcessWindowStation",
    "NtUserSetProp",
    "NtUserSetRipFlags",
    "NtUserSetScrollInfo",
    "NtUserSetShellWindowEx",
    "NtUserSetSysColors",
    "NtUserSetSystemCursor",
    "NtUserSetSystemMenu",
    "NtUserSetSystemTimer",
    "NtUserSetThreadDesktop",
    "NtUserSetThreadLayoutHandles",
    "NtUserSetThreadState",
    "NtUserSetTimer",
    "NtUserSetWindowFNID",
    "NtUserSetWindowLong",
    "NtUserSetWindowPlacement",
    "NtUserSetWindowPos",
    "NtUserSetWindowRgn",
    "NtUserSetWindowsHookAW",
    "NtUserSetWindowsHookEx",
    "NtUserSetWindowStationUser",
    "NtUserSetWindowWord",
    "NtUserSetWinEventHook",
    "NtUserShowCaret",
    "NtUserShowScrollBar",
    "NtUserShowWindow",
    "NtUserShowWindowAsync",
    "NtUserSoundSentry",
    "NtUserSwitchDesktop",
    "NtUserSystemParametersInfo",
    "NtUserTestForInteractiveUser",
    "NtUserThunkedMenuInfo",
    "NtUserThunkedMenuItemInfo",
    "NtUserToUnicodeEx",
    "NtUserTrackMouseEvent",
    "NtUserTrackPopupMenuEx",
    "NtUserCalcMenuBar",
    "NtUserPaintMenuBar",
    "NtUserTranslateAccelerator",
    "NtUserTranslateMessage",
    "NtUserUnhookWindowsHookEx",
    "NtUserUnhookWinEvent",
    "NtUserUnloadKeyboardLayout",
    "NtUserUnlockWindowStation",
    "NtUserUnregisterClass",
    "NtUserUnregisterUserApiHook",
    "NtUserUnregisterHotKey",
    "NtUserUpdateInputContext",
    "NtUserUpdateInstance",
    "NtUserUpdateLayeredWindow",
    "NtUserGetLayeredWindowAttributes",
    "NtUserSetLayeredWindowAttributes",
    "NtUserUpdatePerUserSystemParameters",
    "NtUserUserHandleGrantAccess",
    "NtUserValidateHandleSecure",
    "NtUserValidateRect",
    "NtUserValidateTimerCallback",
    "NtUserVkKeyScanEx",
    "NtUserWaitForInputIdle",
    "NtUserWaitForMsgAndEvent",
    "NtUserWaitMessage",
    "NtUserWin32PoolAllocationStats",
    "NtUserWindowFromPoint",
    "NtUserYieldTask",
    "NtUserRemoteConnect",
    "NtUserRemoteRedrawRectangle",
    "NtUserRemoteRedrawScreen",
    "NtUserRemoteStopScreenUpdates",
    "NtUserCtxDisplayIOCtl",
    "NtGdiEngAssociateSurface",
    "NtGdiEngCreateBitmap",
    "NtGdiEngCreateDeviceSurface",
    "NtGdiEngCreateDeviceBitmap",
    "NtGdiEngCreatePalette",
    "NtGdiEngComputeGlyphSet",
    "NtGdiEngCopyBits",
    "NtGdiEngDeletePalette",
    "NtGdiEngDeleteSurface",
    "NtGdiEngEraseSurface",
    "NtGdiEngUnlockSurface",
    "NtGdiEngLockSurface",
    "NtGdiEngBitBlt",
    "NtGdiEngStretchBlt",
    "NtGdiEngPlgBlt",
    "NtGdiEngMarkBandingSurface",
    "NtGdiEngStrokePath",
    "NtGdiEngFillPath",
    "NtGdiEngStrokeAndFillPath",
    "NtGdiEngPaint",
    "NtGdiEngLineTo",
    "NtGdiEngAlphaBlend",
    "NtGdiEngGradientFill",
    "NtGdiEngTransparentBlt",
    "NtGdiEngTextOut",
    "NtGdiEngStretchBltROP",
    "NtGdiXLATEOBJ_cGetPalette",
    "NtGdiXLATEOBJ_iXlate",
    "NtGdiXLATEOBJ_hGetColorTransform",
    "NtGdiCLIPOBJ_bEnum",
    "NtGdiCLIPOBJ_cEnumStart",
    "NtGdiCLIPOBJ_ppoGetPath",
    "NtGdiEngDeletePath",
    "NtGdiEngCreateClip",
    "NtGdiEngDeleteClip",
    "NtGdiBRUSHOBJ_ulGetBrushColor",
    "NtGdiBRUSHOBJ_pvAllocRbrush",
    "NtGdiBRUSHOBJ_pvGetRbrush",
    "NtGdiBRUSHOBJ_hGetColorTransform",
    "NtGdiXFORMOBJ_bApplyXform",
    "NtGdiXFORMOBJ_iGetXform",
    "NtGdiFONTOBJ_vGetInfo",
    "NtGdiFONTOBJ_pxoGetXform",
    "NtGdiFONTOBJ_cGetGlyphs",
    "NtGdiFONTOBJ_pifi",
    "NtGdiFONTOBJ_pfdg",
    "NtGdiFONTOBJ_pQueryGlyphAttrs",
    "NtGdiFONTOBJ_pvTrueTypeFontFile",
    "NtGdiFONTOBJ_cGetAllGlyphHandles",
    "NtGdiSTROBJ_bEnum",
    "NtGdiSTROBJ_bEnumPositionsOnly",
    "NtGdiSTROBJ_bGetAdvanceWidths",
    "NtGdiSTROBJ_vEnumStart",
    "NtGdiSTROBJ_dwGetCodePage",
    "NtGdiPATHOBJ_vGetBounds",
    "NtGdiPATHOBJ_bEnum",
    "NtGdiPATHOBJ_vEnumStart",
    "NtGdiPATHOBJ_vEnumStartClipLines",
    "NtGdiPATHOBJ_bEnumClipLines",
    "NtGdiGetDhpdev",
    "NtGdiEngCheckAbort",
    "NtGdiHT_Get8BPPFormatPalette",
    "NtGdiHT_Get8BPPMaskPalette",
    "NtGdiUpdateTransform",
    "NtGdiSetPUMPDOBJ",
    "NtGdiBRUSHOBJ_DeleteRbrush",
    "NtGdiUMPDEngFreeUserMem",
    "NtGdiDrawStream"
};

//////////////////////////////////////////////////////////////////////////
// Windows 2003 SP2 _W32pServiceTable
//////////////////////////////////////////////////////////////////////////
static const char* W32pServiceTable_W2k3Sp2_x86[] = {
    "NtGdiAbortDoc",
    "NtGdiAbortPath",
    "NtGdiAddFontResourceW",
    "NtGdiAddRemoteFontToDC",
    "NtGdiAddFontMemResourceEx",
    "NtGdiRemoveMergeFont",
    "NtGdiAddRemoteMMInstanceToDC",
    "NtGdiAlphaBlend",
    "NtGdiAngleArc",
    "NtGdiAnyLinkedFonts",
    "NtGdiFontIsLinked",
    "NtGdiArcInternal",
    "NtGdiBeginPath",
    "NtGdiBitBlt",
    "NtGdiCancelDC",
    "NtGdiCheckBitmapBits",
    "NtGdiCloseFigure",
    "NtGdiClearBitmapAttributes",
    "NtGdiClearBrushAttributes",
    "NtGdiColorCorrectPalette",
    "NtGdiCombineRgn",
    "NtGdiCombineTransform",
    "NtGdiComputeXformCoefficients",
    "NtGdiConsoleTextOut",
    "NtGdiConvertMetafileRect",
    "NtGdiCreateBitmap",
    "NtGdiCreateClientObj",
    "NtGdiCreateColorSpace",
    "NtGdiCreateColorTransform",
    "NtGdiCreateCompatibleBitmap",
    "NtGdiCreateCompatibleDC",
    "NtGdiCreateDIBBrush",
    "NtGdiCreateDIBitmapInternal",
    "NtGdiCreateDIBSection",
    "NtGdiCreateEllipticRgn",
    "NtGdiCreateHalftonePalette",
    "NtGdiCreateHatchBrushInternal",
    "NtGdiCreateMetafileDC",
    "NtGdiCreatePaletteInternal",
    "NtGdiCreatePatternBrushInternal",
    "NtGdiCreatePen",
    "NtGdiCreateRectRgn",
    "NtGdiCreateRoundRectRgn",
    "NtGdiCreateServerMetaFile",
    "NtGdiCreateSolidBrush",
    "NtGdiD3dContextCreate",
    "NtGdiD3dContextDestroy",
    "NtGdiD3dContextDestroyAll",
    "NtGdiD3dValidateTextureStageState",
    "NtGdiD3dDrawPrimitives2",
    "NtGdiDdGetDriverState",
    "NtGdiDdAddAttachedSurface",
    "NtGdiDdAlphaBlt",
    "NtGdiDdAttachSurface",
    "NtGdiDdBeginMoCompFrame",
    "NtGdiDdBlt",
    "NtGdiDdCanCreateSurface",
    "NtGdiDdCanCreateD3DBuffer",
    "NtGdiDdColorControl",
    "NtGdiDdCreateDirectDrawObject",
    "NtGdiDdCreateSurface",
    "NtGdiDdCreateD3DBuffer",
    "NtGdiDdCreateMoComp",
    "NtGdiDdCreateSurfaceObject",
    "NtGdiDdDeleteDirectDrawObject",
    "NtGdiDdDeleteSurfaceObject",
    "NtGdiDdDestroyMoComp",
    "NtGdiDdDestroySurface",
    "NtGdiDdDestroyD3DBuffer",
    "NtGdiDdEndMoCompFrame",
    "NtGdiDdFlip",
    "NtGdiDdFlipToGDISurface",
    "NtGdiDdGetAvailDriverMemory",
    "NtGdiDdGetBltStatus",
    "NtGdiDdGetDC",
    "NtGdiDdGetDriverInfo",
    "NtGdiDdGetDxHandle",
    "NtGdiDdGetFlipStatus",
    "NtGdiDdGetInternalMoCompInfo",
    "NtGdiDdGetMoCompBuffInfo",
    "NtGdiDdGetMoCompGuids",
    "NtGdiDdGetMoCompFormats",
    "NtGdiDdGetScanLine",
    "NtGdiDdLock",
    "NtGdiDdLockD3D",
    "NtGdiDdQueryDirectDrawObject",
    "NtGdiDdQueryMoCompStatus",
    "NtGdiDdReenableDirectDrawObject",
    "NtGdiDdReleaseDC",
    "NtGdiDdRenderMoComp",
    "NtGdiDdResetVisrgn",
    "NtGdiDdSetColorKey",
    "NtGdiDdSetExclusiveMode",
    "NtGdiDdSetGammaRamp",
    "NtGdiDdCreateSurfaceEx",
    "NtGdiDdSetOverlayPosition",
    "NtGdiDdUnattachSurface",
    "NtGdiDdUnlock",
    "NtGdiDdUnlockD3D",
    "NtGdiDdUpdateOverlay",
    "NtGdiDdWaitForVerticalBlank",
    "NtGdiDvpCanCreateVideoPort",
    "NtGdiDvpColorControl",
    "NtGdiDvpCreateVideoPort",
    "NtGdiDvpDestroyVideoPort",
    "NtGdiDvpFlipVideoPort",
    "NtGdiDvpGetVideoPortBandwidth",
    "NtGdiDvpGetVideoPortField",
    "NtGdiDvpGetVideoPortFlipStatus",
    "NtGdiDvpGetVideoPortInputFormats",
    "NtGdiDvpGetVideoPortLine",
    "NtGdiDvpGetVideoPortOutputFormats",
    "NtGdiDvpGetVideoPortConnectInfo",
    "NtGdiDvpGetVideoSignalStatus",
    "NtGdiDvpUpdateVideoPort",
    "NtGdiDvpWaitForVideoPortSync",
    "NtGdiDvpAcquireNotification",
    "NtGdiDvpReleaseNotification",
    "NtGdiDxgGenericThunk",
    "NtGdiDeleteClientObj",
    "NtGdiDeleteColorSpace",
    "NtGdiDeleteColorTransform",
    "NtGdiDeleteObjectApp",
    "NtGdiDescribePixelFormat",
    "NtGdiGetPerBandInfo",
    "NtGdiDoBanding",
    "NtGdiDoPalette",
    "NtGdiDrawEscape",
    "NtGdiEllipse",
    "NtGdiEnableEudc",
    "NtGdiEndDoc",
    "NtGdiEndPage",
    "NtGdiEndPath",
    "NtGdiEnumFontChunk",
    "NtGdiEnumFontClose",
    "NtGdiEnumFontOpen",
    "NtGdiEnumObjects",
    "NtGdiEqualRgn",
    "NtGdiEudcLoadUnloadLink",
    "NtGdiExcludeClipRect",
    "NtGdiExtCreatePen",
    "NtGdiExtCreateRegion",
    "NtGdiExtEscape",
    "NtGdiExtFloodFill",
    "NtGdiExtGetObjectW",
    "NtGdiExtSelectClipRgn",
    "NtGdiExtTextOutW",
    "NtGdiFillPath",
    "NtGdiFillRgn",
    "NtGdiFlattenPath",
    "NtGdiFlush",
    "NtGdiForceUFIMapping",
    "NtGdiFrameRgn",
    "NtGdiFullscreenControl",
    "NtGdiGetAndSetDCDword",
    "NtGdiGetAppClipBox",
    "NtGdiGetBitmapBits",
    "NtGdiGetBitmapDimension",
    "NtGdiGetBoundsRect",
    "NtGdiGetCharABCWidthsW",
    "NtGdiGetCharacterPlacementW",
    "NtGdiGetCharSet",
    "NtGdiGetCharWidthW",
    "NtGdiGetCharWidthInfo",
    "NtGdiGetColorAdjustment",
    "NtGdiGetColorSpaceforBitmap",
    "NtGdiGetDCDword",
    "NtGdiGetDCforBitmap",
    "NtGdiGetDCObject",
    "NtGdiGetDCPoint",
    "NtGdiGetDeviceCaps",
    "NtGdiGetDeviceGammaRamp",
    "NtGdiGetDeviceCapsAll",
    "NtGdiGetDIBitsInternal",
    "NtGdiGetETM",
    "NtGdiGetEudcTimeStampEx",
    "NtGdiGetFontData",
    "NtGdiGetFontResourceInfoInternalW",
    "NtGdiGetGlyphIndicesW",
    "NtGdiGetGlyphIndicesWInternal",
    "NtGdiGetGlyphOutline",
    "NtGdiGetKerningPairs",
    "NtGdiGetLinkedUFIs",
    "NtGdiGetMiterLimit",
    "NtGdiGetMonitorID",
    "NtGdiGetNearestColor",
    "NtGdiGetNearestPaletteIndex",
    "NtGdiGetObjectBitmapHandle",
    "NtGdiGetOutlineTextMetricsInternalW",
    "NtGdiGetPath",
    "NtGdiGetPixel",
    "NtGdiGetRandomRgn",
    "NtGdiGetRasterizerCaps",
    "NtGdiGetRealizationInfo",
    "NtGdiGetRegionData",
    "NtGdiGetRgnBox",
    "NtGdiGetServerMetaFileBits",
    "NtGdiGetSpoolMessage",
    "NtGdiGetStats",
    "NtGdiGetStockObject",
    "NtGdiGetStringBitmapW",
    "NtGdiGetSystemPaletteUse",
    "NtGdiGetTextCharsetInfo",
    "NtGdiGetTextExtent",
    "NtGdiGetTextExtentExW",
    "NtGdiGetTextFaceW",
    "NtGdiGetTextMetricsW",
    "NtGdiGetTransform",
    "NtGdiGetUFI",
    "NtGdiGetEmbUFI",
    "NtGdiGetUFIPathname",
    "NtGdiGetEmbedFonts",
    "NtGdiChangeGhostFont",
    "NtGdiAddEmbFontToDC",
    "NtGdiGetFontUnicodeRanges",
    "NtGdiGetWidthTable",
    "NtGdiGradientFill",
    "NtGdiHfontCreate",
    "NtGdiIcmBrushInfo",
    "NtGdiInit",
    "NtGdiInitSpool",
    "NtGdiIntersectClipRect",
    "NtGdiInvertRgn",
    "NtGdiLineTo",
    "NtGdiMakeFontDir",
    "NtGdiMakeInfoDC",
    "NtGdiMaskBlt",
    "NtGdiModifyWorldTransform",
    "NtGdiMonoBitmap",
    "NtGdiMoveTo",
    "NtGdiOffsetClipRgn",
    "NtGdiOffsetRgn",
    "NtGdiOpenDCW",
    "NtGdiPatBlt",
    "NtGdiPolyPatBlt",
    "NtGdiPathToRegion",
    "NtGdiPlgBlt",
    "NtGdiPolyDraw",
    "NtGdiPolyPolyDraw",
    "NtGdiPolyTextOutW",
    "NtGdiPtInRegion",
    "NtGdiPtVisible",
    "NtGdiQueryFonts",
    "NtGdiQueryFontAssocInfo",
    "NtGdiRectangle",
    "NtGdiRectInRegion",
    "NtGdiRectVisible",
    "NtGdiRemoveFontResourceW",
    "NtGdiRemoveFontMemResourceEx",
    "NtGdiResetDC",
    "NtGdiResizePalette",
    "NtGdiRestoreDC",
    "NtGdiRoundRect",
    "NtGdiSaveDC",
    "NtGdiScaleViewportExtEx",
    "NtGdiScaleWindowExtEx",
    "GreSelectBitmap",
    "NtGdiSelectBrush",
    "NtGdiSelectClipPath",
    "NtGdiSelectFont",
    "NtGdiSelectPen",
    "NtGdiSetBitmapAttributes",
    "NtGdiSetBitmapBits",
    "NtGdiSetBitmapDimension",
    "NtGdiSetBoundsRect",
    "NtGdiSetBrushAttributes",
    "NtGdiSetBrushOrg",
    "NtGdiSetColorAdjustment",
    "NtGdiSetColorSpace",
    "NtGdiSetDeviceGammaRamp",
    "NtGdiSetDIBitsToDeviceInternal",
    "NtGdiSetFontEnumeration",
    "NtGdiSetFontXform",
    "NtGdiSetIcmMode",
    "NtGdiSetLinkedUFIs",
    "NtGdiSetMagicColors",
    "NtGdiSetMetaRgn",
    "NtGdiSetMiterLimit",
    "NtGdiGetDeviceWidth",
    "NtGdiMirrorWindowOrg",
    "NtGdiSetLayout",
    "NtGdiSetPixel",
    "NtGdiSetPixelFormat",
    "NtGdiSetRectRgn",
    "NtGdiSetSystemPaletteUse",
    "NtGdiSetTextJustification",
    "NtGdiSetupPublicCFONT",
    "NtGdiSetVirtualResolution",
    "NtGdiSetSizeDevice",
    "NtGdiStartDoc",
    "NtGdiStartPage",
    "NtGdiStretchBlt",
    "NtGdiStretchDIBitsInternal",
    "NtGdiStrokeAndFillPath",
    "NtGdiStrokePath",
    "NtGdiSwapBuffers",
    "NtGdiTransformPoints",
    "NtGdiTransparentBlt",
    "NtGdiUnloadPrinterDriver",
    "NtGdiUnmapMemFont",
    "NtGdiUnrealizeObject",
    "NtGdiUpdateColors",
    "NtGdiWidenPath",
    "NtUserActivateKeyboardLayout",
    "NtUserAlterWindowStyle",
    "NtUserAssociateInputContext",
    "NtUserAttachThreadInput",
    "NtUserBeginPaint",
    "NtUserBitBltSysBmp",
    "NtUserBlockInput",
    "NtUserBuildHimcList",
    "NtUserBuildHwndList",
    "NtUserBuildNameList",
    "NtUserBuildPropList",
    "NtUserCallHwnd",
    "NtUserCallHwndLock",
    "NtUserCallHwndOpt",
    "NtUserCallHwndParam",
    "NtUserCallHwndParamLock",
    "NtUserCallMsgFilter",
    "NtUserCallNextHookEx",
    "NtUserCallNoParam",
    "NtUserCallOneParam",
    "NtUserCallTwoParam",
    "NtUserChangeClipboardChain",
    "NtUserChangeDisplaySettings",
    "NtUserCheckImeHotKey",
    "NtUserCheckMenuItem",
    "NtUserChildWindowFromPointEx",
    "NtUserClipCursor",
    "NtUserCloseClipboard",
    "NtUserCloseDesktop",
    "NtUserCloseWindowStation",
    "NtUserConsoleControl",
    "NtUserConvertMemHandle",
    "NtUserCopyAcceleratorTable",
    "NtUserCountClipboardFormats",
    "NtUserCreateAcceleratorTable",
    "NtUserCreateCaret",
    "NtUserCreateDesktop",
    "NtUserCreateInputContext",
    "NtUserCreateLocalMemHandle",
    "NtUserCreateWindowEx",
    "NtUserCreateWindowStation",
    "NtUserDdeGetQualityOfService",
    "NtUserDdeInitialize",
    "NtUserDdeSetQualityOfService",
    "NtUserDeferWindowPos",
    "NtUserDefSetText",
    "NtUserDeleteMenu",
    "NtUserDestroyAcceleratorTable",
    "NtUserDestroyCursor",
    "NtUserDestroyInputContext",
    "NtUserDestroyMenu",
    "NtUserDestroyWindow",
    "NtUserDisableThreadIme",
    "NtUserDispatchMessage",
    "NtUserDragDetect",
    "NtUserDragObject",
    "NtUserDrawAnimatedRects",
    "NtUserDrawCaption",
    "NtUserDrawCaptionTemp",
    "NtUserDrawIconEx",
    "NtUserDrawMenuBarTemp",
    "NtUserEmptyClipboard",
    "NtUserEnableMenuItem",
    "NtUserEnableScrollBar",
    "NtUserEndDeferWindowPosEx",
    "NtUserEndMenu",
    "NtUserEndPaint",
    "NtUserEnumDisplayDevices",
    "NtUserEnumDisplayMonitors",
    "NtUserEnumDisplaySettings",
    "NtUserEvent",
    "NtUserExcludeUpdateRgn",
    "NtUserFillWindow",
    "NtUserFindExistingCursorIcon",
    "NtUserFindWindowEx",
    "NtUserFlashWindowEx",
    "NtUserGetAltTabInfo",
    "NtUserGetAncestor",
    "NtUserGetAppImeLevel",
    "NtUserGetAsyncKeyState",
    "NtUserGetAtomName",
    "NtUserGetCaretBlinkTime",
    "NtUserGetCaretPos",
    "NtUserGetClassInfoEx",
    "NtUserGetClassName",
    "NtUserGetClipboardData",
    "NtUserGetClipboardFormatName",
    "NtUserGetClipboardOwner",
    "NtUserGetClipboardSequenceNumber",
    "NtUserGetClipboardViewer",
    "NtUserGetClipCursor",
    "NtUserGetComboBoxInfo",
    "NtUserGetControlBrush",
    "NtUserGetControlColor",
    "NtUserGetCPD",
    "NtUserGetCursorFrameInfo",
    "NtUserGetCursorInfo",
    "NtUserGetDC",
    "NtUserGetDCEx",
    "NtUserGetDoubleClickTime",
    "NtUserGetForegroundWindow",
    "NtUserGetGuiResources",
    "NtUserGetGUIThreadInfo",
    "NtUserGetIconInfo",
    "NtUserGetIconSize",
    "NtUserGetImeHotKey",
    "NtUserGetImeInfoEx",
    "NtUserGetInternalWindowPos",
    "NtUserGetKeyboardLayoutList",
    "NtUserGetKeyboardLayoutName",
    "NtUserGetKeyboardState",
    "NtUserGetKeyNameText",
    "NtUserGetKeyState",
    "NtUserGetListBoxInfo",
    "NtUserGetMenuBarInfo",
    "NtUserGetMenuIndex",
    "NtUserGetMenuItemRect",
    "NtUserGetMessage",
    "NtUserGetMouseMovePointsEx",
    "NtUserGetObjectInformation",
    "NtUserGetOpenClipboardWindow",
    "NtUserGetPriorityClipboardFormat",
    "NtUserGetProcessWindowStation",
    "NtUserGetRawInputBuffer",
    "NtUserGetRawInputData",
    "NtUserGetRawInputDeviceInfo",
    "NtUserGetRawInputDeviceList",
    "NtUserGetRegisteredRawInputDevices",
    "NtUserGetScrollBarInfo",
    "NtUserGetSystemMenu",
    "NtUserGetThreadDesktop",
    "NtUserGetThreadState",
    "NtUserGetTitleBarInfo",
    "NtUserGetUpdateRect",
    "NtUserGetUpdateRgn",
    "NtUserGetWindowDC",
    "NtUserGetWindowPlacement",
    "NtUserGetWOWClass",
    "NtUserHardErrorControl",
    "NtUserHideCaret",
    "NtUserHiliteMenuItem",
    "NtUserImpersonateDdeClientWindow",
    "NtUserInitialize",
    "NtUserInitializeClientPfnArrays",
    "NtUserInitTask",
    "NtUserInternalGetWindowText",
    "NtUserInvalidateRect",
    "NtUserInvalidateRgn",
    "NtUserIsClipboardFormatAvailable",
    "NtUserKillTimer",
    "NtUserLoadKeyboardLayoutEx",
    "NtUserLockWindowStation",
    "NtUserLockWindowUpdate",
    "NtUserLockWorkStation",
    "NtUserMapVirtualKeyEx",
    "NtUserMenuItemFromPoint",
    "NtUserMessageCall",
    "NtUserMinMaximize",
    "NtUserMNDragLeave",
    "NtUserMNDragOver",
    "NtUserModifyUserStartupInfoFlags",
    "NtUserMoveWindow",
    "NtUserNotifyIMEStatus",
    "NtUserNotifyProcessCreate",
    "NtUserNotifyWinEvent",
    "NtUserOpenClipboard",
    "NtUserOpenDesktop",
    "NtUserOpenInputDesktop",
    "NtUserOpenWindowStation",
    "NtUserPaintDesktop",
    "NtUserPeekMessage",
    "NtUserPostMessage",
    "NtUserPostThreadMessage",
    "NtUserPrintWindow",
    "NtUserProcessConnect",
    "NtUserQueryInformationThread",
    "NtUserQueryInputContext",
    "NtUserQuerySendMessage",
    "NtUserQueryWindow",
    "NtUserRealChildWindowFromPoint",
    "NtUserRealInternalGetMessage",
    "NtUserRealWaitMessageEx",
    "NtUserRedrawWindow",
    "NtUserRegisterClassExWOW",
    "NtUserRegisterUserApiHook",
    "NtUserRegisterHotKey",
    "NtUserRegisterRawInputDevices",
    "NtUserRegisterTasklist",
    "NtUserRegisterWindowMessage",
    "NtUserRemoveMenu",
    "NtUserRemoveProp",
    "NtUserResolveDesktop",
    "NtUserResolveDesktopForWOW",
    "NtUserSBGetParms",
    "NtUserScrollDC",
    "NtUserScrollWindowEx",
    "NtUserSelectPalette",
    "NtUserSendInput",
    "NtUserSetActiveWindow",
    "NtUserSetAppImeLevel",
    "NtUserSetCapture",
    "NtUserSetClassLong",
    "NtUserSetClassWord",
    "NtUserSetClipboardData",
    "NtUserSetClipboardViewer",
    "NtUserSetConsoleReserveKeys",
    "NtUserSetCursor",
    "NtUserSetCursorContents",
    "NtUserSetCursorIconData",
    "NtUserSetFocus",
    "NtUserSetImeHotKey",
    "NtUserSetImeInfoEx",
    "NtUserSetImeOwnerWindow",
    "NtUserSetInformationProcess",
    "NtUserSetInformationThread",
    "NtUserSetInternalWindowPos",
    "NtUserSetKeyboardState",
    "NtUserSetLogonNotifyWindow",
    "NtUserSetMenu",
    "NtUserSetMenuContextHelpId",
    "NtUserSetMenuDefaultItem",
    "NtUserSetMenuFlagRtoL",
    "NtUserSetObjectInformation",
    "NtUserSetParent",
    "NtUserSetProcessWindowStation",
    "NtUserSetProp",
    "NtUserSetScrollInfo",
    "NtUserSetShellWindowEx",
    "NtUserSetSysColors",
    "NtUserSetSystemCursor",
    "NtUserSetSystemMenu",
    "NtUserSetSystemTimer",
    "NtUserSetThreadDesktop",
    "NtUserSetThreadLayoutHandles",
    "NtUserSetThreadState",
    "NtUserSetTimer",
    "NtUserSetWindowFNID",
    "NtUserSetWindowLong",
    "NtUserSetWindowPlacement",
    "NtUserSetWindowPos",
    "NtUserSetWindowRgn",
    "NtUserSetWindowsHookAW",
    "NtUserSetWindowsHookEx",
    "NtUserSetWindowStationUser",
    "NtUserSetWindowWord",
    "NtUserSetWinEventHook",
    "NtUserShowCaret",
    "NtUserShowScrollBar",
    "NtUserShowWindow",
    "NtUserShowWindowAsync",
    "NtUserSoundSentry",
    "NtUserSwitchDesktop",
    "NtUserSystemParametersInfo",
    "NtUserTestForInteractiveUser",
    "NtUserThunkedMenuInfo",
    "NtUserThunkedMenuItemInfo",
    "NtUserToUnicodeEx",
    "NtUserTrackMouseEvent",
    "NtUserTrackPopupMenuEx",
    "NtUserCalcMenuBar",
    "NtUserPaintMenuBar",
    "NtUserTranslateAccelerator",
    "NtUserTranslateMessage",
    "NtUserUnhookWindowsHookEx",
    "NtUserUnhookWinEvent",
    "NtUserUnloadKeyboardLayout",
    "NtUserUnlockWindowStation",
    "NtUserUnregisterClass",
    "NtUserUnregisterUserApiHook",
    "NtUserUnregisterHotKey",
    "NtUserUpdateInputContext",
    "NtUserUpdateInstance",
    "NtUserUpdateLayeredWindow",
    "NtUserGetLayeredWindowAttributes",
    "NtUserSetLayeredWindowAttributes",
    "NtUserUpdatePerUserSystemParameters",
    "NtUserUserHandleGrantAccess",
    "NtUserValidateHandleSecure",
    "NtUserValidateRect",
    "NtUserValidateTimerCallback",
    "NtUserVkKeyScanEx",
    "NtUserWaitForInputIdle",
    "NtUserWaitForMsgAndEvent",
    "NtUserWaitMessage",
    "NtUserWin32PoolAllocationStats",
    "NtUserWindowFromPoint",
    "NtUserYieldTask",
    "NtUserRemoteConnect",
    "NtUserRemoteRedrawRectangle",
    "NtUserRemoteRedrawScreen",
    "NtUserRemoteStopScreenUpdates",
    "NtUserCtxDisplayIOCtl",
    "NtGdiEngAssociateSurface",
    "NtGdiEngCreateBitmap",
    "NtGdiEngCreateDeviceSurface",
    "NtGdiEngCreateDeviceBitmap",
    "NtGdiEngCreatePalette",
    "NtGdiEngComputeGlyphSet",
    "NtGdiEngCopyBits",
    "NtGdiEngDeletePalette",
    "NtGdiEngDeleteSurface",
    "NtGdiEngEraseSurface",
    "NtGdiEngUnlockSurface",
    "NtGdiEngLockSurface",
    "NtGdiEngBitBlt",
    "NtGdiEngStretchBlt",
    "NtGdiEngPlgBlt",
    "NtGdiEngMarkBandingSurface",
    "NtGdiEngStrokePath",
    "NtGdiEngFillPath",
    "NtGdiEngStrokeAndFillPath",
    "NtGdiEngPaint",
    "NtGdiEngLineTo",
    "NtGdiEngAlphaBlend",
    "NtGdiEngGradientFill",
    "NtGdiEngTransparentBlt",
    "NtGdiEngTextOut",
    "NtGdiEngStretchBltROP",
    "NtGdiXLATEOBJ_cGetPalette",
    "NtGdiXLATEOBJ_iXlate",
    "NtGdiXLATEOBJ_hGetColorTransform",
    "NtGdiCLIPOBJ_bEnum",
    "NtGdiCLIPOBJ_cEnumStart",
    "NtGdiCLIPOBJ_ppoGetPath",
    "NtGdiEngDeletePath",
    "NtGdiEngCreateClip",
    "NtGdiEngDeleteClip",
    "NtGdiBRUSHOBJ_ulGetBrushColor",
    "NtGdiBRUSHOBJ_pvAllocRbrush",
    "NtGdiBRUSHOBJ_pvGetRbrush",
    "NtGdiBRUSHOBJ_hGetColorTransform",
    "NtGdiXFORMOBJ_bApplyXform",
    "NtGdiXFORMOBJ_iGetXform",
    "NtGdiFONTOBJ_vGetInfo",
    "NtGdiFONTOBJ_pxoGetXform",
    "NtGdiFONTOBJ_cGetGlyphs",
    "NtGdiFONTOBJ_pifi",
    "NtGdiFONTOBJ_pfdg",
    "NtGdiFONTOBJ_pQueryGlyphAttrs",
    "NtGdiFONTOBJ_pvTrueTypeFontFile",
    "NtGdiFONTOBJ_cGetAllGlyphHandles",
    "NtGdiSTROBJ_bEnum",
    "NtGdiSTROBJ_bEnumPositionsOnly",
    "NtGdiSTROBJ_bGetAdvanceWidths",
    "NtGdiSTROBJ_vEnumStart",
    "NtGdiSTROBJ_dwGetCodePage",
    "NtGdiPATHOBJ_vGetBounds",
    "NtGdiPATHOBJ_bEnum",
    "NtGdiPATHOBJ_vEnumStart",
    "NtGdiPATHOBJ_vEnumStartClipLines",
    "NtGdiPATHOBJ_bEnumClipLines",
    "NtGdiGetDhpdev",
    "NtGdiEngCheckAbort",
    "NtGdiHT_Get8BPPFormatPalette",
    "NtGdiHT_Get8BPPMaskPalette",
    "NtGdiUpdateTransform",
    "NtGdiSetPUMPDOBJ",
    "NtGdiBRUSHOBJ_DeleteRbrush",
    "NtGdiUnmapMemFont",
    "NtGdiDrawStream",
    "NtGdiMakeObjectXferable",
    "DxEngGetRedirectionBitmap"
};

//////////////////////////////////////////////////////////////////////////
// Windows Vista SP0 _W32pServiceTable
//////////////////////////////////////////////////////////////////////////
static const char* W32pServiceTable_VistaSp0_x86[] = {
    "NtGdiAbortDoc",
    "NtGdiAbortPath",
    "NtGdiAddFontResourceW",
    "NtGdiAddRemoteFontToDC",
    "NtGdiAddFontMemResourceEx",
    "NtGdiRemoveMergeFont",
    "NtGdiAddRemoteMMInstanceToDC",
    "NtGdiAlphaBlend",
    "NtGdiAngleArc",
    "NtGdiAnyLinkedFonts",
    "NtGdiFontIsLinked",
    "NtGdiArcInternal",
    "NtGdiBeginPath",
    "NtGdiBitBlt",
    "NtGdiCancelDC",
    "NtGdiCheckBitmapBits",
    "NtGdiCloseFigure",
    "NtGdiClearBitmapAttributes",
    "NtGdiClearBrushAttributes",
    "NtGdiColorCorrectPalette",
    "NtGdiCombineRgn",
    "NtGdiCombineTransform",
    "NtGdiComputeXformCoefficients",
    "NtGdiConfigureOPMProtectedOutput",
    "NtGdiConsoleTextOut",
    "NtGdiConvertMetafileRect",
    "NtGdiCreateBitmap",
    "NtGdiCreateClientObj",
    "NtGdiCreateColorSpace",
    "NtGdiCreateColorTransform",
    "NtGdiCreateCompatibleBitmap",
    "NtGdiCreateCompatibleDC",
    "NtGdiCreateDIBBrush",
    "NtGdiCreateDIBitmapInternal",
    "NtGdiCreateDIBSection",
    "NtGdiCreateEllipticRgn",
    "NtGdiCreateHalftonePalette",
    "NtGdiCreateHatchBrushInternal",
    "NtGdiCreateMetafileDC",
    "NtGdiCreateOPMProtectedOutputs",
    "NtGdiCreatePaletteInternal",
    "NtGdiCreatePatternBrushInternal",
    "NtGdiCreatePen",
    "NtGdiCreateRectRgn",
    "NtGdiCreateRoundRectRgn",
    "NtGdiCreateServerMetaFile",
    "NtGdiCreateSolidBrush",
    "NtGdiD3dContextCreate",
    "NtGdiD3dContextDestroy",
    "NtGdiD3dContextDestroyAll",
    "NtGdiD3dValidateTextureStageState",
    "NtGdiD3dDrawPrimitives2",
    "NtGdiDdGetDriverState",
    "NtGdiDdAddAttachedSurface",
    "NtGdiDdAlphaBlt",
    "NtGdiDdAttachSurface",
    "NtGdiDdBeginMoCompFrame",
    "NtGdiDdBlt",
    "NtGdiDdCanCreateSurface",
    "NtGdiDdCanCreateD3DBuffer",
    "NtGdiDdColorControl",
    "NtGdiDdCreateDirectDrawObject",
    "NtGdiDdCreateSurface",
    "NtGdiDdCreateD3DBuffer",
    "NtGdiDdCreateMoComp",
    "NtGdiDdCreateSurfaceObject",
    "NtGdiDdDeleteDirectDrawObject",
    "NtGdiDdDeleteSurfaceObject",
    "NtGdiDdDestroyMoComp",
    "NtGdiDdDestroySurface",
    "NtGdiDdDestroyD3DBuffer",
    "NtGdiDdEndMoCompFrame",
    "NtGdiDdFlip",
    "NtGdiDdFlipToGDISurface",
    "NtGdiDdGetAvailDriverMemory",
    "NtGdiDdGetBltStatus",
    "NtGdiDdGetDC",
    "NtGdiDdGetDriverInfo",
    "NtGdiDdGetDxHandle",
    "NtGdiDdGetFlipStatus",
    "NtGdiDdGetInternalMoCompInfo",
    "NtGdiDdGetMoCompBuffInfo",
    "NtGdiDdGetMoCompGuids",
    "NtGdiDdGetMoCompFormats",
    "NtGdiDdGetScanLine",
    "NtGdiDdLock",
    "NtGdiDdLockD3D",
    "NtGdiDdQueryDirectDrawObject",
    "NtGdiDdQueryMoCompStatus",
    "NtGdiDdReenableDirectDrawObject",
    "NtGdiDdReleaseDC",
    "NtGdiDdRenderMoComp",
    "NtGdiDdResetVisrgn",
    "NtGdiDdSetColorKey",
    "NtGdiDdSetExclusiveMode",
    "NtGdiDdSetGammaRamp",
    "NtGdiDdCreateSurfaceEx",
    "NtGdiDdSetOverlayPosition",
    "NtGdiDdUnattachSurface",
    "NtGdiDdUnlock",
    "NtGdiDdUnlockD3D",
    "NtGdiDdUpdateOverlay",
    "NtGdiDdWaitForVerticalBlank",
    "NtGdiDvpCanCreateVideoPort",
    "NtGdiDvpColorControl",
    "NtGdiDvpCreateVideoPort",
    "NtGdiDvpDestroyVideoPort",
    "NtGdiDvpFlipVideoPort",
    "NtGdiDvpGetVideoPortBandwidth",
    "NtGdiDvpGetVideoPortField",
    "NtGdiDvpGetVideoPortFlipStatus",
    "NtGdiDvpGetVideoPortInputFormats",
    "NtGdiDvpGetVideoPortLine",
    "NtGdiDvpGetVideoPortOutputFormats",
    "NtGdiDvpGetVideoPortConnectInfo",
    "NtGdiDvpGetVideoSignalStatus",
    "NtGdiDvpUpdateVideoPort",
    "NtGdiDvpWaitForVideoPortSync",
    "NtGdiDvpAcquireNotification",
    "NtGdiDvpReleaseNotification",
    "NtGdiDxgGenericThunk",
    "NtGdiDeleteClientObj",
    "NtGdiDeleteColorSpace",
    "NtGdiDeleteColorTransform",
    "NtGdiDeleteObjectApp",
    "NtGdiDescribePixelFormat",
    "NtGdiDestroyOPMProtectedOutput",
    "NtGdiGetPerBandInfo",
    "NtGdiDoBanding",
    "NtGdiDoPalette",
    "NtGdiDrawEscape",
    "NtGdiEllipse",
    "NtGdiEnableEudc",
    "NtGdiEndDoc",
    "NtGdiEndPage",
    "NtGdiEndPath",
    "NtGdiEnumFontChunk",
    "NtGdiEnumFontClose",
    "NtGdiEnumFontOpen",
    "NtGdiEnumObjects",
    "NtGdiEqualRgn",
    "NtGdiEudcLoadUnloadLink",
    "NtGdiExcludeClipRect",
    "NtGdiExtCreatePen",
    "NtGdiExtCreateRegion",
    "NtGdiExtEscape",
    "NtGdiExtFloodFill",
    "NtGdiExtGetObjectW",
    "NtGdiExtSelectClipRgn",
    "NtGdiExtTextOutW",
    "NtGdiFillPath",
    "NtGdiFillRgn",
    "NtGdiFlattenPath",
    "NtGdiFlush",
    "NtGdiForceUFIMapping",
    "NtGdiFrameRgn",
    "NtGdiFullscreenControl",
    "NtGdiGetAndSetDCDword",
    "NtGdiGetAppClipBox",
    "NtGdiGetBitmapBits",
    "NtGdiGetBitmapDimension",
    "NtGdiGetBoundsRect",
    "NtGdiGetCertificate",
    "NtGdiGetCertificateSize",
    "NtGdiGetCharABCWidthsW",
    "NtGdiGetCharacterPlacementW",
    "NtGdiGetCharSet",
    "NtGdiGetCharWidthW",
    "NtGdiGetCharWidthInfo",
    "NtGdiGetColorAdjustment",
    "NtGdiGetColorSpaceforBitmap",
    "NtGdiGetCOPPCompatibleOPMInformation",
    "NtGdiGetDCDword",
    "NtGdiGetDCforBitmap",
    "NtGdiGetDCObject",
    "NtGdiGetDCPoint",
    "NtGdiGetDeviceCaps",
    "NtGdiGetDeviceGammaRamp",
    "NtGdiGetDeviceCapsAll",
    "NtGdiGetDIBitsInternal",
    "NtGdiGetETM",
    "NtGdiGetEudcTimeStampEx",
    "NtGdiGetFontData",
    "NtGdiGetFontResourceInfoInternalW",
    "NtGdiGetGlyphIndicesW",
    "NtGdiGetGlyphIndicesWInternal",
    "NtGdiGetGlyphOutline",
    "NtGdiGetOPMInformation",
    "NtGdiGetKerningPairs",
    "NtGdiGetLinkedUFIs",
    "NtGdiGetMiterLimit",
    "NtGdiGetMonitorID",
    "NtGdiGetNearestColor",
    "NtGdiGetNearestPaletteIndex",
    "NtGdiGetObjectBitmapHandle",
    "NtGdiGetOPMRandomNumber",
    "NtGdiGetOutlineTextMetricsInternalW",
    "NtGdiGetPath",
    "NtGdiGetPixel",
    "NtGdiGetRandomRgn",
    "NtGdiGetRasterizerCaps",
    "NtGdiGetRealizationInfo",
    "NtGdiGetRegionData",
    "NtGdiGetRgnBox",
    "NtGdiGetServerMetaFileBits",
    "NtGdiGetSpoolMessage",
    "NtGdiGetStats",
    "NtGdiGetStockObject",
    "NtGdiGetStringBitmapW",
    "NtGdiGetSuggestedOPMProtectedOutputArraySize",
    "NtGdiGetSystemPaletteUse",
    "NtGdiGetTextCharsetInfo",
    "NtGdiGetTextExtent",
    "NtGdiGetTextExtentExW",
    "NtGdiGetTextFaceW",
    "NtGdiGetTextMetricsW",
    "NtGdiGetTransform",
    "NtGdiGetUFI",
    "NtGdiGetEmbUFI",
    "NtGdiGetUFIPathname",
    "NtGdiGetEmbedFonts",
    "NtGdiChangeGhostFont",
    "NtGdiAddEmbFontToDC",
    "NtGdiGetFontUnicodeRanges",
    "NtGdiGetWidthTable",
    "NtGdiGradientFill",
    "NtGdiHfontCreate",
    "NtGdiIcmBrushInfo",
    "SURFACE::bUnMap",
    "NtGdiInitSpool",
    "NtGdiIntersectClipRect",
    "NtGdiInvertRgn",
    "NtGdiLineTo",
    "NtGdiMakeFontDir",
    "NtGdiMakeInfoDC",
    "NtGdiMaskBlt",
    "NtGdiModifyWorldTransform",
    "NtGdiMonoBitmap",
    "NtGdiMoveTo",
    "NtGdiOffsetClipRgn",
    "NtGdiOffsetRgn",
    "NtGdiOpenDCW",
    "NtGdiPatBlt",
    "NtGdiPolyPatBlt",
    "NtGdiPathToRegion",
    "NtGdiPlgBlt",
    "NtGdiPolyDraw",
    "NtGdiPolyPolyDraw",
    "NtGdiPolyTextOutW",
    "NtGdiPtInRegion",
    "NtGdiPtVisible",
    "NtGdiQueryFonts",
    "NtGdiQueryFontAssocInfo",
    "NtGdiRectangle",
    "NtGdiRectInRegion",
    "NtGdiRectVisible",
    "NtGdiRemoveFontResourceW",
    "NtGdiRemoveFontMemResourceEx",
    "NtGdiResetDC",
    "NtGdiResizePalette",
    "NtGdiRestoreDC",
    "NtGdiRoundRect",
    "NtGdiSaveDC",
    "NtGdiScaleViewportExtEx",
    "NtGdiScaleWindowExtEx",
    "GreSelectBitmap",
    "NtGdiSelectBrush",
    "NtGdiSelectClipPath",
    "NtGdiSelectFont",
    "NtGdiSelectPen",
    "NtGdiSetBitmapAttributes",
    "NtGdiSetBitmapBits",
    "NtGdiSetBitmapDimension",
    "NtGdiSetBoundsRect",
    "NtGdiSetBrushAttributes",
    "NtGdiSetBrushOrg",
    "NtGdiSetColorAdjustment",
    "NtGdiSetColorSpace",
    "NtGdiSetDeviceGammaRamp",
    "NtGdiSetDIBitsToDeviceInternal",
    "NtGdiSetFontEnumeration",
    "NtGdiSetFontXform",
    "NtGdiSetIcmMode",
    "NtGdiSetLinkedUFIs",
    "NtGdiSetMagicColors",
    "NtGdiSetMetaRgn",
    "NtGdiSetMiterLimit",
    "NtGdiGetDeviceWidth",
    "NtGdiMirrorWindowOrg",
    "NtGdiSetLayout",
    "NtGdiSetOPMSigningKeyAndSequenceNumbers",
    "NtGdiSetPixel",
    "NtGdiSetPixelFormat",
    "NtGdiSetRectRgn",
    "NtGdiSetSystemPaletteUse",
    "NtGdiSetTextJustification",
    "NtGdiSetupPublicCFONT",
    "NtGdiSetVirtualResolution",
    "NtGdiSetSizeDevice",
    "NtGdiStartDoc",
    "NtGdiStartPage",
    "NtGdiStretchBlt",
    "NtGdiStretchDIBitsInternal",
    "NtGdiStrokeAndFillPath",
    "NtGdiStrokePath",
    "NtGdiSwapBuffers",
    "NtGdiTransformPoints",
    "NtGdiTransparentBlt",
    "DxgStubEnableDirectDrawRedirection",
    "NtGdiUnmapMemFont",
    "NtGdiUnrealizeObject",
    "NtGdiUpdateColors",
    "NtGdiWidenPath",
    "NtUserActivateKeyboardLayout",
    "NtUserAddClipboardFormatListener",
    "NtUserAlterWindowStyle",
    "NtUserAssociateInputContext",
    "NtUserAttachThreadInput",
    "NtUserBeginPaint",
    "NtUserBitBltSysBmp",
    "NtUserBlockInput",
    "NtUserBuildHimcList",
    "NtUserBuildHwndList",
    "NtUserBuildNameList",
    "NtUserBuildPropList",
    "NtUserCallHwnd",
    "NtUserCallHwndLock",
    "NtUserCallHwndOpt",
    "NtUserCallHwndParam",
    "NtUserCallHwndParamLock",
    "NtUserCallMsgFilter",
    "NtUserCallNextHookEx",
    "NtUserCallNoParam",
    "NtUserCallOneParam",
    "NtUserCallTwoParam",
    "NtUserChangeClipboardChain",
    "NtUserChangeDisplaySettings",
    "NtUserCheckAccessForIntegrityLevel",
    "NtUserCheckDesktopByThreadId",
    "NtUserCheckWindowThreadDesktop",
    "NtUserCheckImeHotKey",
    "NtUserCheckMenuItem",
    "NtUserChildWindowFromPointEx",
    "NtUserClipCursor",
    "NtUserCloseClipboard",
    "NtUserCloseDesktop",
    "NtUserCloseWindowStation",
    "NtUserConsoleControl",
    "NtUserConvertMemHandle",
    "NtUserCopyAcceleratorTable",
    "NtUserCountClipboardFormats",
    "NtUserCreateAcceleratorTable",
    "NtUserCreateCaret",
    "NtUserCreateDesktopEx",
    "NtUserCreateInputContext",
    "NtUserCreateLocalMemHandle",
    "NtUserCreateWindowEx",
    "NtUserCreateWindowStation",
    "NtUserDdeInitialize",
    "NtUserDeferWindowPos",
    "NtUserDefSetText",
    "NtUserDeleteMenu",
    "NtUserDestroyAcceleratorTable",
    "NtUserDestroyCursor",
    "NtUserDestroyInputContext",
    "NtUserDestroyMenu",
    "NtUserDestroyWindow",
    "NtUserDisableThreadIme",
    "NtUserDispatchMessage",
    "NtUserDoSoundConnect",
    "NtUserDoSoundDisconnect",
    "NtUserDragDetect",
    "NtUserDragObject",
    "NtUserDrawAnimatedRects",
    "NtUserDrawCaption",
    "NtUserDrawCaptionTemp",
    "NtUserDrawIconEx",
    "NtUserDrawMenuBarTemp",
    "NtUserEmptyClipboard",
    "NtUserEnableMenuItem",
    "NtUserEnableScrollBar",
    "NtUserEndDeferWindowPosEx",
    "NtUserEndMenu",
    "NtUserEndPaint",
    "NtUserEnumDisplayDevices",
    "NtUserEnumDisplayMonitors",
    "NtUserEnumDisplaySettings",
    "NtUserEvent",
    "NtUserExcludeUpdateRgn",
    "NtUserFillWindow",
    "NtUserFindExistingCursorIcon",
    "NtUserFindWindowEx",
    "NtUserFlashWindowEx",
    "NtUserFrostCrashedWindow",
    "NtUserGetAltTabInfo",
    "NtUserGetAncestor",
    "NtUserGetAppImeLevel",
    "NtUserGetAsyncKeyState",
    "NtUserGetAtomName",
    "NtUserGetCaretBlinkTime",
    "NtUserGetCaretPos",
    "NtUserGetClassInfoEx",
    "NtUserGetClassName",
    "NtUserGetClipboardData",
    "NtUserGetClipboardFormatName",
    "NtUserGetClipboardOwner",
    "NtUserGetClipboardSequenceNumber",
    "NtUserGetClipboardViewer",
    "NtUserGetClipCursor",
    "NtUserGetComboBoxInfo",
    "NtUserGetControlBrush",
    "NtUserGetControlColor",
    "NtUserGetCPD",
    "NtUserGetCursorFrameInfo",
    "NtUserGetCursorInfo",
    "NtUserGetDC",
    "NtUserGetDCEx",
    "NtUserGetDoubleClickTime",
    "NtUserGetForegroundWindow",
    "NtUserGetGuiResources",
    "NtUserGetGUIThreadInfo",
    "NtUserGetIconInfo",
    "NtUserGetIconSize",
    "NtUserGetImeHotKey",
    "NtUserGetImeInfoEx",
    "NtUserGetInternalWindowPos",
    "NtUserGetKeyboardLayoutList",
    "NtUserGetKeyboardLayoutName",
    "NtUserGetKeyboardState",
    "NtUserGetKeyNameText",
    "NtUserGetKeyState",
    "NtUserGetListBoxInfo",
    "NtUserGetMenuBarInfo",
    "NtUserGetMenuIndex",
    "NtUserGetMenuItemRect",
    "NtUserGetMessage",
    "NtUserGetMouseMovePointsEx",
    "NtUserGetObjectInformation",
    "NtUserGetOpenClipboardWindow",
    "NtUserGetPriorityClipboardFormat",
    "NtUserGetProcessWindowStation",
    "NtUserGetRawInputBuffer",
    "NtUserGetRawInputData",
    "NtUserGetRawInputDeviceInfo",
    "NtUserGetRawInputDeviceList",
    "NtUserGetRegisteredRawInputDevices",
    "NtUserGetScrollBarInfo",
    "NtUserGetSystemMenu",
    "NtUserGetThreadDesktop",
    "NtUserGetThreadState",
    "NtUserGetTitleBarInfo",
    "NtUserGetUpdatedClipboardFormats",
    "NtUserGetUpdateRect",
    "NtUserGetUpdateRgn",
    "NtUserGetWindowDC",
    "NtUserGetWindowPlacement",
    "NtUserGetWOWClass",
    "NtUserGhostWindowFromHungWindow",
    "NtUserHardErrorControl",
    "NtUserHideCaret",
    "NtUserHiliteMenuItem",
    "NtUserHungWindowFromGhostWindow",
    "NtUserImpersonateDdeClientWindow",
    "NtUserInitialize",
    "NtUserInitializeClientPfnArrays",
    "NtUserInitTask",
    "NtUserInternalGetWindowText",
    "NtUserInternalGetWindowIcon",
    "NtUserInvalidateRect",
    "NtUserInvalidateRgn",
    "NtUserIsClipboardFormatAvailable",
    "NtUserKillTimer",
    "NtUserLoadKeyboardLayoutEx",
    "NtUserLockWindowStation",
    "NtUserLockWindowUpdate",
    "NtUserLockWorkStation",
    "NtUserLogicalToPhysicalPoint",
    "NtUserMapVirtualKeyEx",
    "NtUserMenuItemFromPoint",
    "NtUserMessageCall",
    "NtUserMinMaximize",
    "NtUserMNDragLeave",
    "NtUserMNDragOver",
    "NtUserModifyUserStartupInfoFlags",
    "NtUserMoveWindow",
    "NtUserNotifyIMEStatus",
    "NtUserNotifyProcessCreate",
    "NtUserNotifyWinEvent",
    "NtUserOpenClipboard",
    "NtUserOpenDesktop",
    "NtUserOpenInputDesktop",
    "NtUserOpenThreadDesktop",
    "NtUserOpenWindowStation",
    "NtUserPaintDesktop",
    "NtUserPaintMonitor",
    "NtUserPeekMessage",
    "NtUserPhysicalToLogicalPoint",
    "NtUserPostMessage",
    "NtUserPostThreadMessage",
    "NtUserPrintWindow",
    "NtUserProcessConnect",
    "NtUserQueryInformationThread",
    "NtUserQueryInputContext",
    "NtUserQuerySendMessage",
    "NtUserQueryWindow",
    "NtUserRealChildWindowFromPoint",
    "NtUserRealInternalGetMessage",
    "NtUserRealWaitMessageEx",
    "NtUserRedrawWindow",
    "NtUserRegisterClassExWOW",
    "NtUserRegisterErrorReportingDialog",
    "NtUserRegisterUserApiHook",
    "NtUserRegisterHotKey",
    "NtUserRegisterRawInputDevices",
    "NtUserRegisterTasklist",
    "NtUserRegisterWindowMessage",
    "NtUserRemoveClipboardFormatListener",
    "NtUserRemoveMenu",
    "NtUserRemoveProp",
    "NtUserResolveDesktop",
    "NtUserResolveDesktopForWOW",
    "NtUserSBGetParms",
    "NtUserScrollDC",
    "NtUserScrollWindowEx",
    "NtUserSelectPalette",
    "NtUserSendInput",
    "NtUserSetActiveWindow",
    "NtUserSetAppImeLevel",
    "NtUserSetCapture",
    "NtUserSetClassLong",
    "NtUserSetClassWord",
    "NtUserSetClipboardData",
    "NtUserSetClipboardViewer",
    "NtUserSetConsoleReserveKeys",
    "NtUserSetCursor",
    "NtUserSetCursorContents",
    "NtUserSetCursorIconData",
    "NtUserSetFocus",
    "NtUserSetImeHotKey",
    "NtUserSetImeInfoEx",
    "NtUserSetImeOwnerWindow",
    "NtUserSetInformationProcess",
    "NtUserSetInformationThread",
    "NtUserSetInternalWindowPos",
    "NtUserSetKeyboardState",
    "NtUserSetMenu",
    "NtUserSetMenuContextHelpId",
    "NtUserSetMenuDefaultItem",
    "NtUserSetMenuFlagRtoL",
    "NtUserSetObjectInformation",
    "NtUserSetParent",
    "NtUserSetProcessWindowStation",
    "NtUserGetProp",
    "NtUserSetProp",
    "NtUserSetScrollInfo",
    "NtUserSetShellWindowEx",
    "NtUserSetSysColors",
    "NtUserSetSystemCursor",
    "NtUserSetSystemMenu",
    "NtUserSetSystemTimer",
    "NtUserSetThreadDesktop",
    "NtUserSetThreadLayoutHandles",
    "NtUserSetThreadState",
    "NtUserSetTimer",
    "NtUserSetProcessDPIAware",
    "NtUserSetWindowFNID",
    "NtUserSetWindowLong",
    "NtUserSetWindowPlacement",
    "NtUserSetWindowPos",
    "NtUserSetWindowRgn",
    "NtUserGetWindowRgnEx",
    "NtUserSetWindowRgnEx",
    "NtUserSetWindowsHookAW",
    "NtUserSetWindowsHookEx",
    "NtUserSetWindowStationUser",
    "NtUserSetWindowWord",
    "NtUserSetWinEventHook",
    "NtUserShowCaret",
    "NtUserShowScrollBar",
    "NtUserShowWindow",
    "NtUserShowWindowAsync",
    "NtUserSoundSentry",
    "NtUserSwitchDesktop",
    "NtUserSystemParametersInfo",
    "NtUserTestForInteractiveUser",
    "NtUserThunkedMenuInfo",
    "NtUserThunkedMenuItemInfo",
    "NtUserToUnicodeEx",
    "NtUserTrackMouseEvent",
    "NtUserTrackPopupMenuEx",
    "NtUserCalcMenuBar",
    "NtUserPaintMenuBar",
    "NtUserTranslateAccelerator",
    "NtUserTranslateMessage",
    "NtUserUnhookWindowsHookEx",
    "NtUserUnhookWinEvent",
    "NtUserUnloadKeyboardLayout",
    "NtUserUnlockWindowStation",
    "NtUserUnregisterClass",
    "NtUserUnregisterUserApiHook",
    "NtUserUnregisterHotKey",
    "NtUserUpdateInputContext",
    "NtUserUpdateInstance",
    "NtUserUpdateLayeredWindow",
    "NtUserGetLayeredWindowAttributes",
    "NtUserSetLayeredWindowAttributes",
    "NtUserUpdatePerUserSystemParameters",
    "NtUserUserHandleGrantAccess",
    "NtUserValidateHandleSecure",
    "NtUserValidateRect",
    "NtUserValidateTimerCallback",
    "NtUserVkKeyScanEx",
    "NtUserWaitForInputIdle",
    "NtUserWaitForMsgAndEvent",
    "NtUserWaitMessage",
    "DxgStubCreateSurfaceObject",
    "NtUserWindowFromPhysicalPoint",
    "NtUserWindowFromPoint",
    "NtUserYieldTask",
    "NtUserRemoteConnect",
    "NtUserRemoteRedrawRectangle",
    "NtUserRemoteRedrawScreen",
    "NtUserRemoteStopScreenUpdates",
    "NtUserCtxDisplayIOCtl",
    "NtUserRegisterSessionPort",
    "NtUserUnregisterSessionPort",
    "NtUserUpdateWindowTransform",
    "NtUserDwmStartRedirection",
    "NtUserDwmStopRedirection",
    "NtUserDwmHintDxUpdate",
    "NtUserDwmGetDxRgn",
    "NtUserGetWindowMinimizeRect",
    "NtGdiEngAssociateSurface",
    "NtGdiEngCreateBitmap",
    "NtGdiEngCreateDeviceSurface",
    "NtGdiEngCreateDeviceBitmap",
    "NtGdiEngCreatePalette",
    "NtGdiEngComputeGlyphSet",
    "NtGdiEngCopyBits",
    "NtGdiEngDeletePalette",
    "NtGdiEngDeleteSurface",
    "NtGdiEngEraseSurface",
    "NtGdiEngUnlockSurface",
    "NtGdiEngLockSurface",
    "NtGdiEngBitBlt",
    "NtGdiEngStretchBlt",
    "NtGdiEngPlgBlt",
    "NtGdiEngMarkBandingSurface",
    "NtGdiEngStrokePath",
    "NtGdiEngFillPath",
    "NtGdiEngStrokeAndFillPath",
    "NtGdiEngPaint",
    "NtGdiEngLineTo",
    "NtGdiEngAlphaBlend",
    "NtGdiEngGradientFill",
    "NtGdiEngTransparentBlt",
    "NtGdiEngTextOut",
    "NtGdiEngStretchBltROP",
    "NtGdiXLATEOBJ_cGetPalette",
    "NtGdiXLATEOBJ_iXlate",
    "NtGdiXLATEOBJ_hGetColorTransform",
    "NtGdiCLIPOBJ_bEnum",
    "NtGdiCLIPOBJ_cEnumStart",
    "NtGdiCLIPOBJ_ppoGetPath",
    "NtGdiEngDeletePath",
    "NtGdiEngCreateClip",
    "NtGdiEngDeleteClip",
    "NtGdiBRUSHOBJ_ulGetBrushColor",
    "NtGdiBRUSHOBJ_pvAllocRbrush",
    "NtGdiBRUSHOBJ_pvGetRbrush",
    "NtGdiBRUSHOBJ_hGetColorTransform",
    "NtGdiXFORMOBJ_bApplyXform",
    "NtGdiXFORMOBJ_iGetXform",
    "NtGdiFONTOBJ_vGetInfo",
    "NtGdiFONTOBJ_pxoGetXform",
    "NtGdiFONTOBJ_cGetGlyphs",
    "NtGdiFONTOBJ_pifi",
    "NtGdiFONTOBJ_pfdg",
    "NtGdiFONTOBJ_pQueryGlyphAttrs",
    "NtGdiFONTOBJ_pvTrueTypeFontFile",
    "NtGdiFONTOBJ_cGetAllGlyphHandles",
    "NtGdiSTROBJ_bEnum",
    "NtGdiSTROBJ_bEnumPositionsOnly",
    "NtGdiSTROBJ_bGetAdvanceWidths",
    "NtGdiSTROBJ_vEnumStart",
    "NtGdiSTROBJ_dwGetCodePage",
    "NtGdiPATHOBJ_vGetBounds",
    "NtGdiPATHOBJ_bEnum",
    "NtGdiPATHOBJ_vEnumStart",
    "NtGdiPATHOBJ_vEnumStartClipLines",
    "NtGdiPATHOBJ_bEnumClipLines",
    "NtGdiGetDhpdev",
    "NtGdiEngCheckAbort",
    "NtGdiHT_Get8BPPFormatPalette",
    "NtGdiHT_Get8BPPMaskPalette",
    "NtGdiUpdateTransform",
    "NtGdiSetPUMPDOBJ",
    "NtGdiBRUSHOBJ_DeleteRbrush",
    "NtGdiUnmapMemFont",
    "NtGdiDrawStream",
    "NtGdiDwmGetDirtyRgn",
    "NtGdiDwmGetSurfaceData",
    "NtGdiDdDDICreateAllocation",
    "NtGdiDdDDIQueryResourceInfo",
    "NtGdiDdDDIOpenResource",
    "NtGdiDdDDIDestroyAllocation",
    "NtGdiDdDDISetAllocationPriority",
    "NtGdiDdDDIQueryAllocationResidency",
    "NtGdiDdDDICreateDevice",
    "NtGdiDdDDIDestroyDevice",
    "NtGdiDdDDICreateContext",
    "NtGdiDdDDIDestroyContext",
    "NtGdiDdDDICreateSynchronizationObject",
    "NtGdiDdDDIDestroySynchronizationObject",
    "NtGdiDdDDIWaitForSynchronizationObject",
    "NtGdiDdDDISignalSynchronizationObject",
    "NtGdiDdDDIGetRuntimeData",
    "NtGdiDdDDIQueryAdapterInfo",
    "NtGdiDdDDILock",
    "NtGdiDdDDIUnlock",
    "NtGdiDdDDIGetDisplayModeList",
    "NtGdiDdDDISetDisplayMode",
    "NtGdiDdDDIGetMultisampleMethodList",
    "NtGdiDdDDIPresent",
    "NtGdiDdDDIRender",
    "NtGdiDdDDIOpenAdapterFromDeviceName",
    "NtGdiDdDDIOpenAdapterFromHdc",
    "NtGdiDdDDICloseAdapter",
    "NtGdiDdDDIGetSharedPrimaryHandle",
    "NtGdiDdDDIEscape",
    "NtGdiDdDDIQueryStatistics",
    "NtGdiDdDDISetVidPnSourceOwner",
    "NtGdiDdDDIGetPresentHistory",
    "NtGdiDdDDICreateOverlay",
    "NtGdiDdDDIUpdateOverlay",
    "NtGdiDdDDIFlipOverlay",
    "NtGdiDdDDIDestroyOverlay",
    "NtGdiDdDDIWaitForVerticalBlankEvent",
    "NtGdiDdDDISetGammaRamp",
    "NtGdiDdDDIGetDeviceState",
    "NtGdiDdDDICreateDCFromMemory",
    "NtGdiDdDDIDestroyDCFromMemory",
    "NtGdiDdDDISetContextSchedulingPriority",
    "NtGdiDdDDIGetContextSchedulingPriority",
    "NtGdiDdDDISetProcessSchedulingPriorityClass",
    "NtGdiDdDDIGetProcessSchedulingPriorityClass",
    "NtGdiDdDDIReleaseProcessVidPnSourceOwners",
    "NtGdiDdDDIGetScanLine",
    "NtGdiDdDDISetQueuedLimit",
    "NtGdiDdDDIPollDisplayChildren",
    "NtGdiDdDDIInvalidateActiveVidPn",
    "NtGdiDdDDICheckOcclusion",
    "NtGdiDdDDIWaitForIdle",
    "NtGdiDdDDICheckMonitorPowerState",
    "NtGdiDdDDICheckExclusiveOwnership",
    "NtGdiDdDDISetDisplayPrivateDriverFormat",
    "NtGdiDdDDISharedPrimaryLockNotification",
    "NtGdiDdDDISharedPrimaryUnLockNotification",
    "DxgStubEnableDirectDrawRedirection",
    "DxgStubDeleteDirectDrawObject",
    "NtGdiGetNumberOfPhysicalMonitors",
    "NtGdiGetPhysicalMonitors",
    "NtGdiGetPhysicalMonitorDescription",
    "DestroyPhysicalMonitor",
    "NtGdiDDCCIGetVCPFeature",
    "NtGdiDDCCISetVCPFeature",
    "NtGdiDDCCISaveCurrentSettings",
    "NtGdiDDCCIGetCapabilitiesStringLength",
    "NtGdiDDCCIGetCapabilitiesString",
    "NtGdiDDCCIGetTimingReport",
    "NtUserSetMirrorRendering",
    "NtUserShowSystemCursor"
};

//////////////////////////////////////////////////////////////////////////
// Windows Vista SP1 _W32pServiceTable
//////////////////////////////////////////////////////////////////////////
static const char* W32pServiceTable_VistaSp1_x86[] = {
    "NtGdiAbortDoc",
    "NtGdiAbortPath",
    "NtGdiAddFontResourceW",
    "NtGdiAddRemoteFontToDC",
    "NtGdiAddFontMemResourceEx",
    "NtGdiRemoveMergeFont",
    "NtGdiAddRemoteMMInstanceToDC",
    "NtGdiAlphaBlend",
    "NtGdiAngleArc",
    "NtGdiAnyLinkedFonts",
    "NtGdiFontIsLinked",
    "NtGdiArcInternal",
    "NtGdiBeginPath",
    "NtGdiBitBlt",
    "NtGdiCancelDC",
    "NtGdiCheckBitmapBits",
    "NtGdiCloseFigure",
    "NtGdiClearBitmapAttributes",
    "NtGdiClearBrushAttributes",
    "NtGdiColorCorrectPalette",
    "NtGdiCombineRgn",
    "NtGdiCombineTransform",
    "NtGdiComputeXformCoefficients",
    "NtGdiConfigureOPMProtectedOutput",
    "NtGdiConsoleTextOut",
    "NtGdiConvertMetafileRect",
    "NtGdiCreateBitmap",
    "NtGdiCreateClientObj",
    "NtGdiCreateColorSpace",
    "NtGdiCreateColorTransform",
    "NtGdiCreateCompatibleBitmap",
    "NtGdiCreateCompatibleDC",
    "NtGdiCreateDIBBrush",
    "NtGdiCreateDIBitmapInternal",
    "NtGdiCreateDIBSection",
    "NtGdiCreateEllipticRgn",
    "NtGdiCreateHalftonePalette",
    "NtGdiCreateHatchBrushInternal",
    "NtGdiCreateMetafileDC",
    "NtGdiCreateOPMProtectedOutputs",
    "NtGdiCreatePaletteInternal",
    "NtGdiCreatePatternBrushInternal",
    "NtGdiCreatePen",
    "NtGdiCreateRectRgn",
    "NtGdiCreateRoundRectRgn",
    "NtGdiCreateServerMetaFile",
    "NtGdiCreateSolidBrush",
    "NtGdiD3dContextCreate",
    "NtGdiD3dContextDestroy",
    "NtGdiD3dContextDestroyAll",
    "NtGdiD3dValidateTextureStageState",
    "NtGdiD3dDrawPrimitives2",
    "NtGdiDdGetDriverState",
    "NtGdiDdAddAttachedSurface",
    "NtGdiDdAlphaBlt",
    "NtGdiDdAttachSurface",
    "NtGdiDdBeginMoCompFrame",
    "NtGdiDdBlt",
    "NtGdiDdCanCreateSurface",
    "NtGdiDdCanCreateD3DBuffer",
    "NtGdiDdColorControl",
    "NtGdiDdCreateDirectDrawObject",
    "NtGdiDdCreateSurface",
    "NtGdiDdCreateD3DBuffer",
    "NtGdiDdCreateMoComp",
    "NtGdiDdCreateSurfaceObject",
    "NtGdiDdDeleteDirectDrawObject",
    "NtGdiDdDeleteSurfaceObject",
    "NtGdiDdDestroyMoComp",
    "NtGdiDdDestroySurface",
    "NtGdiDdDestroyD3DBuffer",
    "NtGdiDdEndMoCompFrame",
    "NtGdiDdFlip",
    "NtGdiDdFlipToGDISurface",
    "NtGdiDdGetAvailDriverMemory",
    "NtGdiDdGetBltStatus",
    "NtGdiDdGetDC",
    "NtGdiDdGetDriverInfo",
    "NtGdiDdGetDxHandle",
    "NtGdiDdGetFlipStatus",
    "NtGdiDdGetInternalMoCompInfo",
    "NtGdiDdGetMoCompBuffInfo",
    "NtGdiDdGetMoCompGuids",
    "NtGdiDdGetMoCompFormats",
    "NtGdiDdGetScanLine",
    "NtGdiDdLock",
    "NtGdiDdLockD3D",
    "NtGdiDdQueryDirectDrawObject",
    "NtGdiDdQueryMoCompStatus",
    "NtGdiDdReenableDirectDrawObject",
    "NtGdiDdReleaseDC",
    "NtGdiDdRenderMoComp",
    "NtGdiDdResetVisrgn",
    "NtGdiDdSetColorKey",
    "NtGdiDdSetExclusiveMode",
    "NtGdiDdSetGammaRamp",
    "NtGdiDdCreateSurfaceEx",
    "NtGdiDdSetOverlayPosition",
    "NtGdiDdUnattachSurface",
    "NtGdiDdUnlock",
    "NtGdiDdUnlockD3D",
    "NtGdiDdUpdateOverlay",
    "NtGdiDdWaitForVerticalBlank",
    "NtGdiDvpCanCreateVideoPort",
    "NtGdiDvpColorControl",
    "NtGdiDvpCreateVideoPort",
    "NtGdiDvpDestroyVideoPort",
    "NtGdiDvpFlipVideoPort",
    "NtGdiDvpGetVideoPortBandwidth",
    "NtGdiDvpGetVideoPortField",
    "NtGdiDvpGetVideoPortFlipStatus",
    "NtGdiDvpGetVideoPortInputFormats",
    "NtGdiDvpGetVideoPortLine",
    "NtGdiDvpGetVideoPortOutputFormats",
    "NtGdiDvpGetVideoPortConnectInfo",
    "NtGdiDvpGetVideoSignalStatus",
    "NtGdiDvpUpdateVideoPort",
    "NtGdiDvpWaitForVideoPortSync",
    "NtGdiDvpAcquireNotification",
    "NtGdiDvpReleaseNotification",
    "NtGdiDxgGenericThunk",
    "NtGdiDeleteClientObj",
    "NtGdiDeleteColorSpace",
    "NtGdiDeleteColorTransform",
    "NtGdiDeleteObjectApp",
    "NtGdiDescribePixelFormat",
    "NtGdiDestroyOPMProtectedOutput",
    "NtGdiGetPerBandInfo",
    "NtGdiDoBanding",
    "NtGdiDoPalette",
    "NtGdiDrawEscape",
    "NtGdiEllipse",
    "NtGdiEnableEudc",
    "NtGdiEndDoc",
    "NtGdiEndPage",
    "NtGdiEndPath",
    "NtGdiEnumFontChunk",
    "NtGdiEnumFontClose",
    "NtGdiEnumFontOpen",
    "NtGdiEnumObjects",
    "NtGdiEqualRgn",
    "NtGdiEudcLoadUnloadLink",
    "NtGdiExcludeClipRect",
    "NtGdiExtCreatePen",
    "NtGdiExtCreateRegion",
    "NtGdiExtEscape",
    "NtGdiExtFloodFill",
    "NtGdiExtGetObjectW",
    "NtGdiExtSelectClipRgn",
    "NtGdiExtTextOutW",
    "NtGdiFillPath",
    "NtGdiFillRgn",
    "NtGdiFlattenPath",
    "NtGdiFlush",
    "NtGdiForceUFIMapping",
    "NtGdiFrameRgn",
    "NtGdiFullscreenControl",
    "NtGdiGetAndSetDCDword",
    "NtGdiGetAppClipBox",
    "NtGdiGetBitmapBits",
    "NtGdiGetBitmapDimension",
    "NtGdiGetBoundsRect",
    "NtGdiGetCertificate",
    "NtGdiGetCertificateSize",
    "NtGdiGetCharABCWidthsW",
    "NtGdiGetCharacterPlacementW",
    "NtGdiGetCharSet",
    "NtGdiGetCharWidthW",
    "NtGdiGetCharWidthInfo",
    "NtGdiGetColorAdjustment",
    "NtGdiGetColorSpaceforBitmap",
    "NtGdiGetCOPPCompatibleOPMInformation",
    "NtGdiGetDCDword",
    "NtGdiGetDCforBitmap",
    "NtGdiGetDCObject",
    "NtGdiGetDCPoint",
    "NtGdiGetDeviceCaps",
    "NtGdiGetDeviceGammaRamp",
    "NtGdiGetDeviceCapsAll",
    "NtGdiGetDIBitsInternal",
    "NtGdiGetETM",
    "NtGdiGetEudcTimeStampEx",
    "NtGdiGetFontData",
    "NtGdiGetFontResourceInfoInternalW",
    "NtGdiGetGlyphIndicesW",
    "NtGdiGetGlyphIndicesWInternal",
    "NtGdiGetGlyphOutline",
    "NtGdiGetOPMInformation",
    "NtGdiGetKerningPairs",
    "NtGdiGetLinkedUFIs",
    "NtGdiGetMiterLimit",
    "NtGdiGetMonitorID",
    "NtGdiGetNearestColor",
    "NtGdiGetNearestPaletteIndex",
    "NtGdiGetObjectBitmapHandle",
    "NtGdiGetOPMRandomNumber",
    "NtGdiGetOutlineTextMetricsInternalW",
    "NtGdiGetPath",
    "NtGdiGetPixel",
    "NtGdiGetRandomRgn",
    "NtGdiGetRasterizerCaps",
    "NtGdiGetRealizationInfo",
    "NtGdiGetRegionData",
    "NtGdiGetRgnBox",
    "NtGdiGetServerMetaFileBits",
    "NtGdiGetSpoolMessage",
    "NtGdiGetStats",
    "NtGdiGetStockObject",
    "NtGdiGetStringBitmapW",
    "NtGdiGetSuggestedOPMProtectedOutputArraySize",
    "NtGdiGetSystemPaletteUse",
    "NtGdiGetTextCharsetInfo",
    "NtGdiGetTextExtent",
    "NtGdiGetTextExtentExW",
    "NtGdiGetTextFaceW",
    "NtGdiGetTextMetricsW",
    "NtGdiGetTransform",
    "NtGdiGetUFI",
    "NtGdiGetEmbUFI",
    "NtGdiGetUFIPathname",
    "NtGdiGetEmbedFonts",
    "NtGdiChangeGhostFont",
    "NtGdiAddEmbFontToDC",
    "NtGdiGetFontUnicodeRanges",
    "NtGdiGetWidthTable",
    "NtGdiGradientFill",
    "NtGdiHfontCreate",
    "NtGdiIcmBrushInfo",
    "SURFACE::bUnMap",
    "NtGdiInitSpool",
    "NtGdiIntersectClipRect",
    "NtGdiInvertRgn",
    "NtGdiLineTo",
    "NtGdiMakeFontDir",
    "NtGdiMakeInfoDC",
    "NtGdiMaskBlt",
    "NtGdiModifyWorldTransform",
    "NtGdiMonoBitmap",
    "NtGdiMoveTo",
    "NtGdiOffsetClipRgn",
    "NtGdiOffsetRgn",
    "NtGdiOpenDCW",
    "NtGdiPatBlt",
    "NtGdiPolyPatBlt",
    "NtGdiPathToRegion",
    "NtGdiPlgBlt",
    "NtGdiPolyDraw",
    "NtGdiPolyPolyDraw",
    "NtGdiPolyTextOutW",
    "NtGdiPtInRegion",
    "NtGdiPtVisible",
    "NtGdiQueryFonts",
    "NtGdiQueryFontAssocInfo",
    "NtGdiRectangle",
    "NtGdiRectInRegion",
    "NtGdiRectVisible",
    "NtGdiRemoveFontResourceW",
    "NtGdiRemoveFontMemResourceEx",
    "NtGdiResetDC",
    "NtGdiResizePalette",
    "NtGdiRestoreDC",
    "NtGdiRoundRect",
    "NtGdiSaveDC",
    "NtGdiScaleViewportExtEx",
    "NtGdiScaleWindowExtEx",
    "GreSelectBitmap",
    "NtGdiSelectBrush",
    "NtGdiSelectClipPath",
    "NtGdiSelectFont",
    "NtGdiSelectPen",
    "NtGdiSetBitmapAttributes",
    "NtGdiSetBitmapBits",
    "NtGdiSetBitmapDimension",
    "NtGdiSetBoundsRect",
    "NtGdiSetBrushAttributes",
    "NtGdiSetBrushOrg",
    "NtGdiSetColorAdjustment",
    "NtGdiSetColorSpace",
    "NtGdiSetDeviceGammaRamp",
    "NtGdiSetDIBitsToDeviceInternal",
    "NtGdiSetFontEnumeration",
    "NtGdiSetFontXform",
    "NtGdiSetIcmMode",
    "NtGdiSetLinkedUFIs",
    "NtGdiSetMagicColors",
    "NtGdiSetMetaRgn",
    "NtGdiSetMiterLimit",
    "NtGdiGetDeviceWidth",
    "NtGdiMirrorWindowOrg",
    "NtGdiSetLayout",
    "NtGdiSetOPMSigningKeyAndSequenceNumbers",
    "NtGdiSetPixel",
    "NtGdiSetPixelFormat",
    "NtGdiSetRectRgn",
    "NtGdiSetSystemPaletteUse",
    "NtGdiSetTextJustification",
    "NtGdiSetupPublicCFONT",
    "NtGdiSetVirtualResolution",
    "NtGdiSetSizeDevice",
    "NtGdiStartDoc",
    "NtGdiStartPage",
    "NtGdiStretchBlt",
    "NtGdiStretchDIBitsInternal",
    "NtGdiStrokeAndFillPath",
    "NtGdiStrokePath",
    "NtGdiSwapBuffers",
    "NtGdiTransformPoints",
    "NtGdiTransparentBlt",
    "DxgStubEnableDirectDrawRedirection",
    "NtGdiUnmapMemFont",
    "NtGdiUnrealizeObject",
    "NtGdiUpdateColors",
    "NtGdiWidenPath",
    "NtUserActivateKeyboardLayout",
    "NtUserAddClipboardFormatListener",
    "NtUserAlterWindowStyle",
    "NtUserAssociateInputContext",
    "NtUserAttachThreadInput",
    "NtUserBeginPaint",
    "NtUserBitBltSysBmp",
    "NtUserBlockInput",
    "NtUserBuildHimcList",
    "NtUserBuildHwndList",
    "NtUserBuildNameList",
    "NtUserBuildPropList",
    "NtUserCallHwnd",
    "NtUserCallHwndLock",
    "NtUserCallHwndOpt",
    "NtUserCallHwndParam",
    "NtUserCallHwndParamLock",
    "NtUserCallMsgFilter",
    "NtUserCallNextHookEx",
    "NtUserCallNoParam",
    "NtUserCallOneParam",
    "NtUserCallTwoParam",
    "NtUserChangeClipboardChain",
    "NtUserChangeDisplaySettings",
    "NtUserCheckAccessForIntegrityLevel",
    "NtUserCheckDesktopByThreadId",
    "NtUserCheckWindowThreadDesktop",
    "NtUserCheckImeHotKey",
    "NtUserCheckMenuItem",
    "NtUserChildWindowFromPointEx",
    "NtUserClipCursor",
    "NtUserCloseClipboard",
    "NtUserCloseDesktop",
    "NtUserCloseWindowStation",
    "NtUserConsoleControl",
    "NtUserConvertMemHandle",
    "NtUserCopyAcceleratorTable",
    "NtUserCountClipboardFormats",
    "NtUserCreateAcceleratorTable",
    "NtUserCreateCaret",
    "NtUserCreateDesktopEx",
    "NtUserCreateInputContext",
    "NtUserCreateLocalMemHandle",
    "NtUserCreateWindowEx",
    "NtUserCreateWindowStation",
    "NtUserDdeInitialize",
    "NtUserDeferWindowPos",
    "NtUserDefSetText",
    "NtUserDeleteMenu",
    "NtUserDestroyAcceleratorTable",
    "NtUserDestroyCursor",
    "NtUserDestroyInputContext",
    "NtUserDestroyMenu",
    "NtUserDestroyWindow",
    "NtUserDisableThreadIme",
    "NtUserDispatchMessage",
    "NtUserDoSoundConnect",
    "NtUserDoSoundDisconnect",
    "NtUserDragDetect",
    "NtUserDragObject",
    "NtUserDrawAnimatedRects",
    "NtUserDrawCaption",
    "NtUserDrawCaptionTemp",
    "NtUserDrawIconEx",
    "NtUserDrawMenuBarTemp",
    "NtUserEmptyClipboard",
    "NtUserEnableMenuItem",
    "NtUserEnableScrollBar",
    "NtUserEndDeferWindowPosEx",
    "NtUserEndMenu",
    "NtUserEndPaint",
    "NtUserEnumDisplayDevices",
    "NtUserEnumDisplayMonitors",
    "NtUserEnumDisplaySettings",
    "NtUserEvent",
    "NtUserExcludeUpdateRgn",
    "NtUserFillWindow",
    "NtUserFindExistingCursorIcon",
    "NtUserFindWindowEx",
    "NtUserFlashWindowEx",
    "NtUserFrostCrashedWindow",
    "NtUserGetAltTabInfo",
    "NtUserGetAncestor",
    "NtUserGetAppImeLevel",
    "NtUserGetAsyncKeyState",
    "NtUserGetAtomName",
    "NtUserGetCaretBlinkTime",
    "NtUserGetCaretPos",
    "NtUserGetClassInfoEx",
    "NtUserGetClassName",
    "NtUserGetClipboardData",
    "NtUserGetClipboardFormatName",
    "NtUserGetClipboardOwner",
    "NtUserGetClipboardSequenceNumber",
    "NtUserGetClipboardViewer",
    "NtUserGetClipCursor",
    "NtUserGetComboBoxInfo",
    "NtUserGetControlBrush",
    "NtUserGetControlColor",
    "NtUserGetCPD",
    "NtUserGetCursorFrameInfo",
    "NtUserGetCursorInfo",
    "NtUserGetDC",
    "NtUserGetDCEx",
    "NtUserGetDoubleClickTime",
    "NtUserGetForegroundWindow",
    "NtUserGetGuiResources",
    "NtUserGetGUIThreadInfo",
    "NtUserGetIconInfo",
    "NtUserGetIconSize",
    "NtUserGetImeHotKey",
    "NtUserGetImeInfoEx",
    "NtUserGetInternalWindowPos",
    "NtUserGetKeyboardLayoutList",
    "NtUserGetKeyboardLayoutName",
    "NtUserGetKeyboardState",
    "NtUserGetKeyNameText",
    "NtUserGetKeyState",
    "NtUserGetListBoxInfo",
    "NtUserGetMenuBarInfo",
    "NtUserGetMenuIndex",
    "NtUserGetMenuItemRect",
    "NtUserGetMessage",
    "NtUserGetMouseMovePointsEx",
    "NtUserGetObjectInformation",
    "NtUserGetOpenClipboardWindow",
    "NtUserGetPriorityClipboardFormat",
    "NtUserGetProcessWindowStation",
    "NtUserGetRawInputBuffer",
    "NtUserGetRawInputData",
    "NtUserGetRawInputDeviceInfo",
    "NtUserGetRawInputDeviceList",
    "NtUserGetRegisteredRawInputDevices",
    "NtUserGetScrollBarInfo",
    "NtUserGetSystemMenu",
    "NtUserGetThreadDesktop",
    "NtUserGetThreadState",
    "NtUserGetTitleBarInfo",
    "NtUserGetUpdatedClipboardFormats",
    "NtUserGetUpdateRect",
    "NtUserGetUpdateRgn",
    "NtUserGetWindowDC",
    "NtUserGetWindowPlacement",
    "NtUserGetWOWClass",
    "NtUserGhostWindowFromHungWindow",
    "NtUserHardErrorControl",
    "NtUserHideCaret",
    "NtUserHiliteMenuItem",
    "NtUserHungWindowFromGhostWindow",
    "NtUserImpersonateDdeClientWindow",
    "NtUserInitialize",
    "NtUserInitializeClientPfnArrays",
    "NtUserInitTask",
    "NtUserInternalGetWindowText",
    "NtUserInternalGetWindowIcon",
    "NtUserInvalidateRect",
    "NtUserInvalidateRgn",
    "NtUserIsClipboardFormatAvailable",
    "NtUserKillTimer",
    "NtUserLoadKeyboardLayoutEx",
    "NtUserLockWindowStation",
    "NtUserLockWindowUpdate",
    "NtUserLockWorkStation",
    "NtUserLogicalToPhysicalPoint",
    "NtUserMapVirtualKeyEx",
    "NtUserMenuItemFromPoint",
    "NtUserMessageCall",
    "NtUserMinMaximize",
    "NtUserMNDragLeave",
    "NtUserMNDragOver",
    "NtUserModifyUserStartupInfoFlags",
    "NtUserMoveWindow",
    "NtUserNotifyIMEStatus",
    "NtUserNotifyProcessCreate",
    "NtUserNotifyWinEvent",
    "NtUserOpenClipboard",
    "NtUserOpenDesktop",
    "NtUserOpenInputDesktop",
    "NtUserOpenThreadDesktop",
    "NtUserOpenWindowStation",
    "NtUserPaintDesktop",
    "NtUserPaintMonitor",
    "NtUserPeekMessage",
    "NtUserPhysicalToLogicalPoint",
    "NtUserPostMessage",
    "NtUserPostThreadMessage",
    "NtUserPrintWindow",
    "NtUserProcessConnect",
    "NtUserQueryInformationThread",
    "NtUserQueryInputContext",
    "NtUserQuerySendMessage",
    "NtUserQueryWindow",
    "NtUserRealChildWindowFromPoint",
    "NtUserRealInternalGetMessage",
    "NtUserRealWaitMessageEx",
    "NtUserRedrawWindow",
    "NtUserRegisterClassExWOW",
    "NtUserRegisterErrorReportingDialog",
    "NtUserRegisterUserApiHook",
    "NtUserRegisterHotKey",
    "NtUserRegisterRawInputDevices",
    "NtUserRegisterTasklist",
    "NtUserRegisterWindowMessage",
    "NtUserRemoveClipboardFormatListener",
    "NtUserRemoveMenu",
    "NtUserRemoveProp",
    "NtUserResolveDesktop",
    "NtUserResolveDesktopForWOW",
    "NtUserSBGetParms",
    "NtUserScrollDC",
    "NtUserScrollWindowEx",
    "NtUserSelectPalette",
    "NtUserSendInput",
    "NtUserSetActiveWindow",
    "NtUserSetAppImeLevel",
    "NtUserSetCapture",
    "NtUserSetClassLong",
    "NtUserSetClassWord",
    "NtUserSetClipboardData",
    "NtUserSetClipboardViewer",
    "NtUserSetConsoleReserveKeys",
    "NtUserSetCursor",
    "NtUserSetCursorContents",
    "NtUserSetCursorIconData",
    "NtUserSetFocus",
    "NtUserSetImeHotKey",
    "NtUserSetImeInfoEx",
    "NtUserSetImeOwnerWindow",
    "NtUserSetInformationProcess",
    "NtUserSetInformationThread",
    "NtUserSetInternalWindowPos",
    "NtUserSetKeyboardState",
    "NtUserSetMenu",
    "NtUserSetMenuContextHelpId",
    "NtUserSetMenuDefaultItem",
    "NtUserSetMenuFlagRtoL",
    "NtUserSetObjectInformation",
    "NtUserSetParent",
    "NtUserSetProcessWindowStation",
    "NtUserGetProp",
    "NtUserSetProp",
    "NtUserSetScrollInfo",
    "NtUserSetShellWindowEx",
    "NtUserSetSysColors",
    "NtUserSetSystemCursor",
    "NtUserSetSystemMenu",
    "NtUserSetSystemTimer",
    "NtUserSetThreadDesktop",
    "NtUserSetThreadLayoutHandles",
    "NtUserSetThreadState",
    "NtUserSetTimer",
    "NtUserSetProcessDPIAware",
    "NtUserSetWindowFNID",
    "NtUserSetWindowLong",
    "NtUserSetWindowPlacement",
    "NtUserSetWindowPos",
    "NtUserSetWindowRgn",
    "NtUserGetWindowRgnEx",
    "NtUserSetWindowRgnEx",
    "NtUserSetWindowsHookAW",
    "NtUserSetWindowsHookEx",
    "NtUserSetWindowStationUser",
    "NtUserSetWindowWord",
    "NtUserSetWinEventHook",
    "NtUserShowCaret",
    "NtUserShowScrollBar",
    "NtUserShowWindow",
    "NtUserShowWindowAsync",
    "NtUserSoundSentry",
    "NtUserSwitchDesktop",
    "NtUserSystemParametersInfo",
    "NtUserTestForInteractiveUser",
    "NtUserThunkedMenuInfo",
    "NtUserThunkedMenuItemInfo",
    "NtUserToUnicodeEx",
    "NtUserTrackMouseEvent",
    "NtUserTrackPopupMenuEx",
    "NtUserCalcMenuBar",
    "NtUserPaintMenuBar",
    "NtUserTranslateAccelerator",
    "NtUserTranslateMessage",
    "NtUserUnhookWindowsHookEx",
    "NtUserUnhookWinEvent",
    "NtUserUnloadKeyboardLayout",
    "NtUserUnlockWindowStation",
    "NtUserUnregisterClass",
    "NtUserUnregisterUserApiHook",
    "NtUserUnregisterHotKey",
    "NtUserUpdateInputContext",
    "NtUserUpdateInstance",
    "NtUserUpdateLayeredWindow",
    "NtUserGetLayeredWindowAttributes",
    "NtUserSetLayeredWindowAttributes",
    "NtUserUpdatePerUserSystemParameters",
    "NtUserUserHandleGrantAccess",
    "NtUserValidateHandleSecure",
    "NtUserValidateRect",
    "NtUserValidateTimerCallback",
    "NtUserVkKeyScanEx",
    "NtUserWaitForInputIdle",
    "NtUserWaitForMsgAndEvent",
    "NtUserWaitMessage",
    "DxgStubCreateSurfaceObject",
    "NtUserWindowFromPhysicalPoint",
    "NtUserWindowFromPoint",
    "NtUserYieldTask",
    "NtUserRemoteConnect",
    "NtUserRemoteRedrawRectangle",
    "NtUserRemoteRedrawScreen",
    "NtUserRemoteStopScreenUpdates",
    "NtUserCtxDisplayIOCtl",
    "NtUserRegisterSessionPort",
    "NtUserUnregisterSessionPort",
    "NtUserUpdateWindowTransform",
    "NtUserDwmStartRedirection",
    "NtUserDwmStopRedirection",
    "NtUserDwmHintDxUpdate",
    "NtUserDwmGetDxRgn",
    "NtUserGetWindowMinimizeRect",
    "NtGdiEngAssociateSurface",
    "NtGdiEngCreateBitmap",
    "NtGdiEngCreateDeviceSurface",
    "NtGdiEngCreateDeviceBitmap",
    "NtGdiEngCreatePalette",
    "NtGdiEngComputeGlyphSet",
    "NtGdiEngCopyBits",
    "NtGdiEngDeletePalette",
    "NtGdiEngDeleteSurface",
    "NtGdiEngEraseSurface",
    "NtGdiEngUnlockSurface",
    "NtGdiEngLockSurface",
    "NtGdiEngBitBlt",
    "NtGdiEngStretchBlt",
    "NtGdiEngPlgBlt",
    "NtGdiEngMarkBandingSurface",
    "NtGdiEngStrokePath",
    "NtGdiEngFillPath",
    "NtGdiEngStrokeAndFillPath",
    "NtGdiEngPaint",
    "NtGdiEngLineTo",
    "NtGdiEngAlphaBlend",
    "NtGdiEngGradientFill",
    "NtGdiEngTransparentBlt",
    "NtGdiEngTextOut",
    "NtGdiEngStretchBltROP",
    "NtGdiXLATEOBJ_cGetPalette",
    "NtGdiXLATEOBJ_iXlate",
    "NtGdiXLATEOBJ_hGetColorTransform",
    "NtGdiCLIPOBJ_bEnum",
    "NtGdiCLIPOBJ_cEnumStart",
    "NtGdiCLIPOBJ_ppoGetPath",
    "NtGdiEngDeletePath",
    "NtGdiEngCreateClip",
    "NtGdiEngDeleteClip",
    "NtGdiBRUSHOBJ_ulGetBrushColor",
    "NtGdiBRUSHOBJ_pvAllocRbrush",
    "NtGdiBRUSHOBJ_pvGetRbrush",
    "NtGdiBRUSHOBJ_hGetColorTransform",
    "NtGdiXFORMOBJ_bApplyXform",
    "NtGdiXFORMOBJ_iGetXform",
    "NtGdiFONTOBJ_vGetInfo",
    "NtGdiFONTOBJ_pxoGetXform",
    "NtGdiFONTOBJ_cGetGlyphs",
    "NtGdiFONTOBJ_pifi",
    "NtGdiFONTOBJ_pfdg",
    "NtGdiFONTOBJ_pQueryGlyphAttrs",
    "NtGdiFONTOBJ_pvTrueTypeFontFile",
    "NtGdiFONTOBJ_cGetAllGlyphHandles",
    "NtGdiSTROBJ_bEnum",
    "NtGdiSTROBJ_bEnumPositionsOnly",
    "NtGdiSTROBJ_bGetAdvanceWidths",
    "NtGdiSTROBJ_vEnumStart",
    "NtGdiSTROBJ_dwGetCodePage",
    "NtGdiPATHOBJ_vGetBounds",
    "NtGdiPATHOBJ_bEnum",
    "NtGdiPATHOBJ_vEnumStart",
    "NtGdiPATHOBJ_vEnumStartClipLines",
    "NtGdiPATHOBJ_bEnumClipLines",
    "NtGdiGetDhpdev",
    "NtGdiEngCheckAbort",
    "NtGdiHT_Get8BPPFormatPalette",
    "NtGdiHT_Get8BPPMaskPalette",
    "NtGdiUpdateTransform",
    "NtGdiSetPUMPDOBJ",
    "NtGdiBRUSHOBJ_DeleteRbrush",
    "NtGdiUnmapMemFont",
    "NtGdiDrawStream",
    "NtGdiDwmGetDirtyRgn",
    "NtGdiDwmGetSurfaceData",
    "NtGdiDdDDICreateAllocation",
    "NtGdiDdDDIQueryResourceInfo",
    "NtGdiDdDDIOpenResource",
    "NtGdiDdDDIDestroyAllocation",
    "NtGdiDdDDISetAllocationPriority",
    "NtGdiDdDDIQueryAllocationResidency",
    "NtGdiDdDDICreateDevice",
    "NtGdiDdDDIDestroyDevice",
    "NtGdiDdDDICreateContext",
    "NtGdiDdDDIDestroyContext",
    "NtGdiDdDDICreateSynchronizationObject",
    "NtGdiDdDDIDestroySynchronizationObject",
    "NtGdiDdDDIWaitForSynchronizationObject",
    "NtGdiDdDDISignalSynchronizationObject",
    "NtGdiDdDDIGetRuntimeData",
    "NtGdiDdDDIQueryAdapterInfo",
    "NtGdiDdDDILock",
    "NtGdiDdDDIUnlock",
    "NtGdiDdDDIGetDisplayModeList",
    "NtGdiDdDDISetDisplayMode",
    "NtGdiDdDDIGetMultisampleMethodList",
    "NtGdiDdDDIPresent",
    "NtGdiDdDDIRender",
    "NtGdiDdDDIOpenAdapterFromDeviceName",
    "NtGdiDdDDIOpenAdapterFromHdc",
    "NtGdiDdDDICloseAdapter",
    "NtGdiDdDDIGetSharedPrimaryHandle",
    "NtGdiDdDDIEscape",
    "NtGdiDdDDIQueryStatistics",
    "NtGdiDdDDISetVidPnSourceOwner",
    "NtGdiDdDDIGetPresentHistory",
    "NtGdiDdDDICreateOverlay",
    "NtGdiDdDDIUpdateOverlay",
    "NtGdiDdDDIFlipOverlay",
    "NtGdiDdDDIDestroyOverlay",
    "NtGdiDdDDIWaitForVerticalBlankEvent",
    "NtGdiDdDDISetGammaRamp",
    "NtGdiDdDDIGetDeviceState",
    "NtGdiDdDDICreateDCFromMemory",
    "NtGdiDdDDIDestroyDCFromMemory",
    "NtGdiDdDDISetContextSchedulingPriority",
    "NtGdiDdDDIGetContextSchedulingPriority",
    "NtGdiDdDDISetProcessSchedulingPriorityClass",
    "NtGdiDdDDIGetProcessSchedulingPriorityClass",
    "NtGdiDdDDIReleaseProcessVidPnSourceOwners",
    "NtGdiDdDDIGetScanLine",
    "NtGdiDdDDISetQueuedLimit",
    "NtGdiDdDDIPollDisplayChildren",
    "NtGdiDdDDIInvalidateActiveVidPn",
    "NtGdiDdDDICheckOcclusion",
    "NtGdiDdDDIWaitForIdle",
    "NtGdiDdDDICheckMonitorPowerState",
    "NtGdiDdDDICheckExclusiveOwnership",
    "NtGdiDdDDISetDisplayPrivateDriverFormat",
    "NtGdiDdDDISharedPrimaryLockNotification",
    "NtGdiDdDDISharedPrimaryUnLockNotification",
    "DxgStubEnableDirectDrawRedirection",
    "DxgStubDeleteDirectDrawObject",
    "NtGdiGetNumberOfPhysicalMonitors",
    "NtGdiGetPhysicalMonitors",
    "NtGdiGetPhysicalMonitorDescription",
    "DestroyPhysicalMonitor",
    "NtGdiDDCCIGetVCPFeature",
    "NtGdiDDCCISetVCPFeature",
    "NtGdiDDCCISaveCurrentSettings",
    "NtGdiDDCCIGetCapabilitiesStringLength",
    "NtGdiDDCCIGetCapabilitiesString",
    "NtGdiDDCCIGetTimingReport",
    "NtUserSetMirrorRendering",
    "NtUserShowSystemCursor"
};

//////////////////////////////////////////////////////////////////////////
// Windows Vista SP2 _W32pServiceTable
//////////////////////////////////////////////////////////////////////////
static const char* W32pServiceTable_VistaSp2_x86[] = {
    "NtGdiAbortDoc",
    "NtGdiAbortPath",
    "NtGdiAddFontResourceW",
    "NtGdiAddRemoteFontToDC",
    "NtGdiAddFontMemResourceEx",
    "NtGdiRemoveMergeFont",
    "NtGdiAddRemoteMMInstanceToDC",
    "NtGdiAlphaBlend",
    "NtGdiAngleArc",
    "NtGdiAnyLinkedFonts",
    "NtGdiFontIsLinked",
    "NtGdiArcInternal",
    "NtGdiBeginPath",
    "NtGdiBitBlt",
    "NtGdiCancelDC",
    "NtGdiCheckBitmapBits",
    "NtGdiCloseFigure",
    "NtGdiClearBitmapAttributes",
    "NtGdiClearBrushAttributes",
    "NtGdiColorCorrectPalette",
    "NtGdiCombineRgn",
    "NtGdiCombineTransform",
    "NtGdiComputeXformCoefficients",
    "NtGdiConfigureOPMProtectedOutput",
    "NtGdiConsoleTextOut",
    "NtGdiConvertMetafileRect",
    "NtGdiCreateBitmap",
    "NtGdiCreateClientObj",
    "NtGdiCreateColorSpace",
    "NtGdiCreateColorTransform",
    "NtGdiCreateCompatibleBitmap",
    "NtGdiCreateCompatibleDC",
    "NtGdiCreateDIBBrush",
    "NtGdiCreateDIBitmapInternal",
    "NtGdiCreateDIBSection",
    "NtGdiCreateEllipticRgn",
    "NtGdiCreateHalftonePalette",
    "NtGdiCreateHatchBrushInternal",
    "NtGdiCreateMetafileDC",
    "NtGdiCreateOPMProtectedOutputs",
    "NtGdiCreatePaletteInternal",
    "NtGdiCreatePatternBrushInternal",
    "NtGdiCreatePen",
    "NtGdiCreateRectRgn",
    "NtGdiCreateRoundRectRgn",
    "NtGdiCreateServerMetaFile",
    "NtGdiCreateSolidBrush",
    "NtGdiD3dContextCreate",
    "NtGdiD3dContextDestroy",
    "NtGdiD3dContextDestroyAll",
    "NtGdiD3dValidateTextureStageState",
    "NtGdiD3dDrawPrimitives2",
    "NtGdiDdGetDriverState",
    "NtGdiDdAddAttachedSurface",
    "NtGdiDdAlphaBlt",
    "NtGdiDdAttachSurface",
    "NtGdiDdBeginMoCompFrame",
    "NtGdiDdBlt",
    "NtGdiDdCanCreateSurface",
    "NtGdiDdCanCreateD3DBuffer",
    "NtGdiDdColorControl",
    "NtGdiDdCreateDirectDrawObject",
    "NtGdiDdCreateSurface",
    "NtGdiDdCreateD3DBuffer",
    "NtGdiDdCreateMoComp",
    "NtGdiDdCreateSurfaceObject",
    "NtGdiDdDeleteDirectDrawObject",
    "NtGdiDdDeleteSurfaceObject",
    "NtGdiDdDestroyMoComp",
    "NtGdiDdDestroySurface",
    "NtGdiDdDestroyD3DBuffer",
    "NtGdiDdEndMoCompFrame",
    "NtGdiDdFlip",
    "NtGdiDdFlipToGDISurface",
    "NtGdiDdGetAvailDriverMemory",
    "NtGdiDdGetBltStatus",
    "NtGdiDdGetDC",
    "NtGdiDdGetDriverInfo",
    "NtGdiDdGetDxHandle",
    "NtGdiDdGetFlipStatus",
    "NtGdiDdGetInternalMoCompInfo",
    "NtGdiDdGetMoCompBuffInfo",
    "NtGdiDdGetMoCompGuids",
    "NtGdiDdGetMoCompFormats",
    "NtGdiDdGetScanLine",
    "NtGdiDdLock",
    "NtGdiDdLockD3D",
    "NtGdiDdQueryDirectDrawObject",
    "NtGdiDdQueryMoCompStatus",
    "NtGdiDdReenableDirectDrawObject",
    "NtGdiDdReleaseDC",
    "NtGdiDdRenderMoComp",
    "NtGdiDdResetVisrgn",
    "NtGdiDdSetColorKey",
    "NtGdiDdSetExclusiveMode",
    "NtGdiDdSetGammaRamp",
    "NtGdiDdCreateSurfaceEx",
    "NtGdiDdSetOverlayPosition",
    "NtGdiDdUnattachSurface",
    "NtGdiDdUnlock",
    "NtGdiDdUnlockD3D",
    "NtGdiDdUpdateOverlay",
    "NtGdiDdWaitForVerticalBlank",
    "NtGdiDvpCanCreateVideoPort",
    "NtGdiDvpColorControl",
    "NtGdiDvpCreateVideoPort",
    "NtGdiDvpDestroyVideoPort",
    "NtGdiDvpFlipVideoPort",
    "NtGdiDvpGetVideoPortBandwidth",
    "NtGdiDvpGetVideoPortField",
    "NtGdiDvpGetVideoPortFlipStatus",
    "NtGdiDvpGetVideoPortInputFormats",
    "NtGdiDvpGetVideoPortLine",
    "NtGdiDvpGetVideoPortOutputFormats",
    "NtGdiDvpGetVideoPortConnectInfo",
    "NtGdiDvpGetVideoSignalStatus",
    "NtGdiDvpUpdateVideoPort",
    "NtGdiDvpWaitForVideoPortSync",
    "NtGdiDvpAcquireNotification",
    "NtGdiDvpReleaseNotification",
    "NtGdiDxgGenericThunk",
    "NtGdiDeleteClientObj",
    "NtGdiDeleteColorSpace",
    "NtGdiDeleteColorTransform",
    "NtGdiDeleteObjectApp",
    "NtGdiDescribePixelFormat",
    "NtGdiDestroyOPMProtectedOutput",
    "NtGdiGetPerBandInfo",
    "NtGdiDoBanding",
    "NtGdiDoPalette",
    "NtGdiDrawEscape",
    "NtGdiEllipse",
    "NtGdiEnableEudc",
    "NtGdiEndDoc",
    "NtGdiEndPage",
    "NtGdiEndPath",
    "NtGdiEnumFontChunk",
    "NtGdiEnumFontClose",
    "NtGdiEnumFontOpen",
    "NtGdiEnumObjects",
    "NtGdiEqualRgn",
    "NtGdiEudcLoadUnloadLink",
    "NtGdiExcludeClipRect",
    "NtGdiExtCreatePen",
    "NtGdiExtCreateRegion",
    "NtGdiExtEscape",
    "NtGdiExtFloodFill",
    "NtGdiExtGetObjectW",
    "NtGdiExtSelectClipRgn",
    "NtGdiExtTextOutW",
    "NtGdiFillPath",
    "NtGdiFillRgn",
    "NtGdiFlattenPath",
    "NtGdiFlush",
    "NtGdiForceUFIMapping",
    "NtGdiFrameRgn",
    "NtGdiFullscreenControl",
    "NtGdiGetAndSetDCDword",
    "NtGdiGetAppClipBox",
    "NtGdiGetBitmapBits",
    "NtGdiGetBitmapDimension",
    "NtGdiGetBoundsRect",
    "NtGdiGetCertificate",
    "NtGdiGetCertificateSize",
    "NtGdiGetCharABCWidthsW",
    "NtGdiGetCharacterPlacementW",
    "NtGdiGetCharSet",
    "NtGdiGetCharWidthW",
    "NtGdiGetCharWidthInfo",
    "NtGdiGetColorAdjustment",
    "NtGdiGetColorSpaceforBitmap",
    "NtGdiGetCOPPCompatibleOPMInformation",
    "NtGdiGetDCDword",
    "NtGdiGetDCforBitmap",
    "NtGdiGetDCObject",
    "NtGdiGetDCPoint",
    "NtGdiGetDeviceCaps",
    "NtGdiGetDeviceGammaRamp",
    "NtGdiGetDeviceCapsAll",
    "NtGdiGetDIBitsInternal",
    "NtGdiGetETM",
    "NtGdiGetEudcTimeStampEx",
    "NtGdiGetFontData",
    "NtGdiGetFontResourceInfoInternalW",
    "NtGdiGetGlyphIndicesW",
    "NtGdiGetGlyphIndicesWInternal",
    "NtGdiGetGlyphOutline",
    "NtGdiGetOPMInformation",
    "NtGdiGetKerningPairs",
    "NtGdiGetLinkedUFIs",
    "NtGdiGetMiterLimit",
    "NtGdiGetMonitorID",
    "NtGdiGetNearestColor",
    "NtGdiGetNearestPaletteIndex",
    "NtGdiGetObjectBitmapHandle",
    "NtGdiGetOPMRandomNumber",
    "NtGdiGetOutlineTextMetricsInternalW",
    "NtGdiGetPath",
    "NtGdiGetPixel",
    "NtGdiGetRandomRgn",
    "NtGdiGetRasterizerCaps",
    "NtGdiGetRealizationInfo",
    "NtGdiGetRegionData",
    "NtGdiGetRgnBox",
    "NtGdiGetServerMetaFileBits",
    "NtGdiGetSpoolMessage",
    "NtGdiGetStats",
    "NtGdiGetStockObject",
    "NtGdiGetStringBitmapW",
    "NtGdiGetSuggestedOPMProtectedOutputArraySize",
    "NtGdiGetSystemPaletteUse",
    "NtGdiGetTextCharsetInfo",
    "NtGdiGetTextExtent",
    "NtGdiGetTextExtentExW",
    "NtGdiGetTextFaceW",
    "NtGdiGetTextMetricsW",
    "NtGdiGetTransform",
    "NtGdiGetUFI",
    "NtGdiGetEmbUFI",
    "NtGdiGetUFIPathname",
    "NtGdiGetEmbedFonts",
    "NtGdiChangeGhostFont",
    "NtGdiAddEmbFontToDC",
    "NtGdiGetFontUnicodeRanges",
    "NtGdiGetWidthTable",
    "NtGdiGradientFill",
    "NtGdiHfontCreate",
    "NtGdiIcmBrushInfo",
    "bInitRedirDev",
    "NtGdiInitSpool",
    "NtGdiIntersectClipRect",
    "NtGdiInvertRgn",
    "NtGdiLineTo",
    "NtGdiMakeFontDir",
    "NtGdiMakeInfoDC",
    "NtGdiMaskBlt",
    "NtGdiModifyWorldTransform",
    "NtGdiMonoBitmap",
    "NtGdiMoveTo",
    "NtGdiOffsetClipRgn",
    "NtGdiOffsetRgn",
    "NtGdiOpenDCW",
    "NtGdiPatBlt",
    "NtGdiPolyPatBlt",
    "NtGdiPathToRegion",
    "NtGdiPlgBlt",
    "NtGdiPolyDraw",
    "NtGdiPolyPolyDraw",
    "NtGdiPolyTextOutW",
    "NtGdiPtInRegion",
    "NtGdiPtVisible",
    "NtGdiQueryFonts",
    "NtGdiQueryFontAssocInfo",
    "NtGdiRectangle",
    "NtGdiRectInRegion",
    "NtGdiRectVisible",
    "NtGdiRemoveFontResourceW",
    "NtGdiRemoveFontMemResourceEx",
    "NtGdiResetDC",
    "NtGdiResizePalette",
    "NtGdiRestoreDC",
    "NtGdiRoundRect",
    "NtGdiSaveDC",
    "NtGdiScaleViewportExtEx",
    "NtGdiScaleWindowExtEx",
    "GreSelectBitmap",
    "NtGdiSelectBrush",
    "NtGdiSelectClipPath",
    "NtGdiSelectFont",
    "NtGdiSelectPen",
    "NtGdiSetBitmapAttributes",
    "NtGdiSetBitmapBits",
    "NtGdiSetBitmapDimension",
    "NtGdiSetBoundsRect",
    "NtGdiSetBrushAttributes",
    "NtGdiSetBrushOrg",
    "NtGdiSetColorAdjustment",
    "NtGdiSetColorSpace",
    "NtGdiSetDeviceGammaRamp",
    "NtGdiSetDIBitsToDeviceInternal",
    "NtGdiSetFontEnumeration",
    "NtGdiSetFontXform",
    "NtGdiSetIcmMode",
    "NtGdiSetLinkedUFIs",
    "NtGdiSetMagicColors",
    "NtGdiSetMetaRgn",
    "NtGdiSetMiterLimit",
    "NtGdiGetDeviceWidth",
    "NtGdiMirrorWindowOrg",
    "NtGdiSetLayout",
    "NtGdiSetOPMSigningKeyAndSequenceNumbers",
    "NtGdiSetPixel",
    "NtGdiSetPixelFormat",
    "NtGdiSetRectRgn",
    "NtGdiSetSystemPaletteUse",
    "NtGdiSetTextJustification",
    "NtGdiSetupPublicCFONT",
    "NtGdiSetVirtualResolution",
    "NtGdiSetSizeDevice",
    "NtGdiStartDoc",
    "NtGdiStartPage",
    "NtGdiStretchBlt",
    "NtGdiStretchDIBitsInternal",
    "NtGdiStrokeAndFillPath",
    "NtGdiStrokePath",
    "NtGdiSwapBuffers",
    "NtGdiTransformPoints",
    "NtGdiTransparentBlt",
    "DxgStubDvpDestroyVideoPort",
    "NtGdiUMPDEngFreeUserMem",
    "NtGdiUnrealizeObject",
    "NtGdiUpdateColors",
    "NtGdiWidenPath",
    "NtUserActivateKeyboardLayout",
    "NtUserAddClipboardFormatListener",
    "NtUserAlterWindowStyle",
    "NtUserAssociateInputContext",
    "NtUserAttachThreadInput",
    "NtUserBeginPaint",
    "NtUserBitBltSysBmp",
    "NtUserBlockInput",
    "NtUserBuildHimcList",
    "NtUserBuildHwndList",
    "NtUserBuildNameList",
    "NtUserBuildPropList",
    "NtUserCallHwnd",
    "NtUserCallHwndLock",
    "NtUserCallHwndOpt",
    "NtUserCallHwndParam",
    "NtUserCallHwndParamLock",
    "NtUserCallMsgFilter",
    "NtUserCallNextHookEx",
    "NtUserCallNoParam",
    "NtUserCallOneParam",
    "NtUserCallTwoParam",
    "NtUserChangeClipboardChain",
    "NtUserChangeDisplaySettings",
    "NtUserCheckAccessForIntegrityLevel",
    "NtUserCheckDesktopByThreadId",
    "NtUserCheckWindowThreadDesktop",
    "NtUserCheckImeHotKey",
    "NtUserCheckMenuItem",
    "NtUserChildWindowFromPointEx",
    "NtUserClipCursor",
    "NtUserCloseClipboard",
    "NtUserCloseDesktop",
    "NtUserCloseWindowStation",
    "NtUserConsoleControl",
    "NtUserConvertMemHandle",
    "NtUserCopyAcceleratorTable",
    "NtUserCountClipboardFormats",
    "NtUserCreateAcceleratorTable",
    "NtUserCreateCaret",
    "NtUserCreateDesktopEx",
    "NtUserCreateInputContext",
    "NtUserCreateLocalMemHandle",
    "NtUserCreateWindowEx",
    "NtUserCreateWindowStation",
    "NtUserDdeInitialize",
    "NtUserDeferWindowPos",
    "NtUserDefSetText",
    "NtUserDeleteMenu",
    "NtUserDestroyAcceleratorTable",
    "NtUserDestroyCursor",
    "NtUserDestroyInputContext",
    "NtUserDestroyMenu",
    "NtUserDestroyWindow",
    "NtUserDisableThreadIme",
    "NtUserDispatchMessage",
    "NtUserDoSoundConnect",
    "NtUserDoSoundDisconnect",
    "NtUserDragDetect",
    "NtUserDragObject",
    "NtUserDrawAnimatedRects",
    "NtUserDrawCaption",
    "NtUserDrawCaptionTemp",
    "NtUserDrawIconEx",
    "NtUserDrawMenuBarTemp",
    "NtUserEmptyClipboard",
    "NtUserEnableMenuItem",
    "NtUserEnableScrollBar",
    "NtUserEndDeferWindowPosEx",
    "NtUserEndMenu",
    "NtUserEndPaint",
    "NtUserEnumDisplayDevices",
    "NtUserEnumDisplayMonitors",
    "NtUserEnumDisplaySettings",
    "NtUserEvent",
    "NtUserExcludeUpdateRgn",
    "NtUserFillWindow",
    "NtUserFindExistingCursorIcon",
    "NtUserFindWindowEx",
    "NtUserFlashWindowEx",
    "NtUserFrostCrashedWindow",
    "NtUserGetAltTabInfo",
    "NtUserGetAncestor",
    "NtUserGetAppImeLevel",
    "NtUserGetAsyncKeyState",
    "NtUserGetAtomName",
    "NtUserGetCaretBlinkTime",
    "NtUserGetCaretPos",
    "NtUserGetClassInfoEx",
    "NtUserGetClassName",
    "NtUserGetClipboardData",
    "NtUserGetClipboardFormatName",
    "NtUserGetClipboardOwner",
    "NtUserGetClipboardSequenceNumber",
    "NtUserGetClipboardViewer",
    "NtUserGetClipCursor",
    "NtUserGetComboBoxInfo",
    "NtUserGetControlBrush",
    "NtUserGetControlColor",
    "NtUserGetCPD",
    "NtUserGetCursorFrameInfo",
    "NtUserGetCursorInfo",
    "NtUserGetDC",
    "NtUserGetDCEx",
    "NtUserGetDoubleClickTime",
    "NtUserGetForegroundWindow",
    "NtUserGetGuiResources",
    "NtUserGetGUIThreadInfo",
    "NtUserGetIconInfo",
    "NtUserGetIconSize",
    "NtUserGetImeHotKey",
    "NtUserGetImeInfoEx",
    "NtUserGetInternalWindowPos",
    "NtUserGetKeyboardLayoutList",
    "NtUserGetKeyboardLayoutName",
    "NtUserGetKeyboardState",
    "NtUserGetKeyNameText",
    "NtUserGetKeyState",
    "NtUserGetListBoxInfo",
    "NtUserGetMenuBarInfo",
    "NtUserGetMenuIndex",
    "NtUserGetMenuItemRect",
    "NtUserGetMessage",
    "NtUserGetMouseMovePointsEx",
    "NtUserGetObjectInformation",
    "NtUserGetOpenClipboardWindow",
    "NtUserGetPriorityClipboardFormat",
    "NtUserGetProcessWindowStation",
    "NtUserGetRawInputBuffer",
    "NtUserGetRawInputData",
    "NtUserGetRawInputDeviceInfo",
    "NtUserGetRawInputDeviceList",
    "NtUserGetRegisteredRawInputDevices",
    "NtUserGetScrollBarInfo",
    "NtUserGetSystemMenu",
    "NtUserGetThreadDesktop",
    "NtUserGetThreadState",
    "NtUserGetTitleBarInfo",
    "NtUserGetUpdatedClipboardFormats",
    "NtUserGetUpdateRect",
    "NtUserGetUpdateRgn",
    "NtUserGetWindowDC",
    "NtUserGetWindowPlacement",
    "NtUserGetWOWClass",
    "NtUserGhostWindowFromHungWindow",
    "NtUserHardErrorControl",
    "NtUserHideCaret",
    "NtUserHiliteMenuItem",
    "NtUserHungWindowFromGhostWindow",
    "NtUserImpersonateDdeClientWindow",
    "NtUserInitialize",
    "NtUserInitializeClientPfnArrays",
    "NtUserInitTask",
    "NtUserInternalGetWindowText",
    "NtUserInternalGetWindowIcon",
    "NtUserInvalidateRect",
    "NtUserInvalidateRgn",
    "NtUserIsClipboardFormatAvailable",
    "NtUserKillTimer",
    "NtUserLoadKeyboardLayoutEx",
    "NtUserLockWindowStation",
    "NtUserLockWindowUpdate",
    "NtUserLockWorkStation",
    "NtUserLogicalToPhysicalPoint",
    "NtUserMapVirtualKeyEx",
    "NtUserMenuItemFromPoint",
    "NtUserMessageCall",
    "NtUserMinMaximize",
    "NtUserMNDragLeave",
    "NtUserMNDragOver",
    "NtUserModifyUserStartupInfoFlags",
    "NtUserMoveWindow",
    "NtUserNotifyIMEStatus",
    "NtUserNotifyProcessCreate",
    "NtUserNotifyWinEvent",
    "NtUserOpenClipboard",
    "NtUserOpenDesktop",
    "NtUserOpenInputDesktop",
    "NtUserOpenThreadDesktop",
    "NtUserOpenWindowStation",
    "NtUserPaintDesktop",
    "NtUserPaintMonitor",
    "NtUserPeekMessage",
    "NtUserPhysicalToLogicalPoint",
    "NtUserPostMessage",
    "NtUserPostThreadMessage",
    "NtUserPrintWindow",
    "NtUserProcessConnect",
    "NtUserQueryInformationThread",
    "NtUserQueryInputContext",
    "NtUserQuerySendMessage",
    "NtUserQueryWindow",
    "NtUserRealChildWindowFromPoint",
    "NtUserRealInternalGetMessage",
    "NtUserRealWaitMessageEx",
    "NtUserRedrawWindow",
    "NtUserRegisterClassExWOW",
    "NtUserRegisterErrorReportingDialog",
    "NtUserRegisterUserApiHook",
    "NtUserRegisterHotKey",
    "NtUserRegisterRawInputDevices",
    "NtUserRegisterTasklist",
    "NtUserRegisterWindowMessage",
    "NtUserRemoveClipboardFormatListener",
    "NtUserRemoveMenu",
    "NtUserRemoveProp",
    "NtUserResolveDesktop",
    "NtUserResolveDesktopForWOW",
    "NtUserSBGetParms",
    "NtUserScrollDC",
    "NtUserScrollWindowEx",
    "NtUserSelectPalette",
    "NtUserSendInput",
    "NtUserSetActiveWindow",
    "NtUserSetAppImeLevel",
    "NtUserSetCapture",
    "NtUserSetClassLong",
    "NtUserSetClassWord",
    "NtUserSetClipboardData",
    "NtUserSetClipboardViewer",
    "NtUserSetConsoleReserveKeys",
    "NtUserSetCursor",
    "NtUserSetCursorContents",
    "NtUserSetCursorIconData",
    "NtUserSetFocus",
    "NtUserSetImeHotKey",
    "NtUserSetImeInfoEx",
    "NtUserSetImeOwnerWindow",
    "NtUserSetInformationProcess",
    "NtUserSetInformationThread",
    "NtUserSetInternalWindowPos",
    "NtUserSetKeyboardState",
    "NtUserSetMenu",
    "NtUserSetMenuContextHelpId",
    "NtUserSetMenuDefaultItem",
    "NtUserSetMenuFlagRtoL",
    "NtUserSetObjectInformation",
    "NtUserSetParent",
    "NtUserSetProcessWindowStation",
    "NtUserGetProp",
    "NtUserSetProp",
    "NtUserSetScrollInfo",
    "NtUserSetShellWindowEx",
    "NtUserSetSysColors",
    "NtUserSetSystemCursor",
    "NtUserSetSystemMenu",
    "NtUserSetSystemTimer",
    "NtUserSetThreadDesktop",
    "NtUserSetThreadLayoutHandles",
    "NtUserSetThreadState",
    "NtUserSetTimer",
    "NtUserSetProcessDPIAware",
    "NtUserSetWindowFNID",
    "NtUserSetWindowLong",
    "NtUserSetWindowPlacement",
    "NtUserSetWindowPos",
    "NtUserSetWindowRgn",
    "NtUserGetWindowRgnEx",
    "NtUserSetWindowRgnEx",
    "NtUserSetWindowsHookAW",
    "NtUserSetWindowsHookEx",
    "NtUserSetWindowStationUser",
    "NtUserSetWindowWord",
    "NtUserSetWinEventHook",
    "NtUserShowCaret",
    "NtUserShowScrollBar",
    "NtUserShowWindow",
    "NtUserShowWindowAsync",
    "NtUserSoundSentry",
    "NtUserSwitchDesktop",
    "NtUserSystemParametersInfo",
    "NtUserTestForInteractiveUser",
    "NtUserThunkedMenuInfo",
    "NtUserThunkedMenuItemInfo",
    "NtUserToUnicodeEx",
    "NtUserTrackMouseEvent",
    "NtUserTrackPopupMenuEx",
    "NtUserCalcMenuBar",
    "NtUserPaintMenuBar",
    "NtUserTranslateAccelerator",
    "NtUserTranslateMessage",
    "NtUserUnhookWindowsHookEx",
    "NtUserUnhookWinEvent",
    "NtUserUnloadKeyboardLayout",
    "NtUserUnlockWindowStation",
    "NtUserUnregisterClass",
    "NtUserUnregisterUserApiHook",
    "NtUserUnregisterHotKey",
    "NtUserUpdateInputContext",
    "NtUserUpdateInstance",
    "NtUserUpdateLayeredWindow",
    "NtUserGetLayeredWindowAttributes",
    "NtUserSetLayeredWindowAttributes",
    "NtUserUpdatePerUserSystemParameters",
    "NtUserUserHandleGrantAccess",
    "NtUserValidateHandleSecure",
    "NtUserValidateRect",
    "NtUserValidateTimerCallback",
    "NtUserVkKeyScanEx",
    "NtUserWaitForInputIdle",
    "NtUserWaitForMsgAndEvent",
    "NtUserWaitMessage",
    "DxgStubGenericThunk",
    "NtUserWindowFromPhysicalPoint",
    "NtUserWindowFromPoint",
    "NtUserYieldTask",
    "NtUserRemoteConnect",
    "NtUserRemoteRedrawRectangle",
    "NtUserRemoteRedrawScreen",
    "NtUserRemoteStopScreenUpdates",
    "NtUserCtxDisplayIOCtl",
    "NtUserRegisterSessionPort",
    "NtUserUnregisterSessionPort",
    "NtUserUpdateWindowTransform",
    "NtUserDwmStartRedirection",
    "NtUserDwmStopRedirection",
    "NtUserDwmHintDxUpdate",
    "NtUserDwmGetDxRgn",
    "NtUserGetWindowMinimizeRect",
    "NtGdiEngAssociateSurface",
    "NtGdiEngCreateBitmap",
    "NtGdiEngCreateDeviceSurface",
    "NtGdiEngCreateDeviceBitmap",
    "NtGdiEngCreatePalette",
    "NtGdiEngComputeGlyphSet",
    "NtGdiEngCopyBits",
    "NtGdiEngDeletePalette",
    "NtGdiEngDeleteSurface",
    "NtGdiEngEraseSurface",
    "NtGdiEngUnlockSurface",
    "NtGdiEngLockSurface",
    "NtGdiEngBitBlt",
    "NtGdiEngStretchBlt",
    "NtGdiEngPlgBlt",
    "NtGdiEngMarkBandingSurface",
    "NtGdiEngStrokePath",
    "NtGdiEngFillPath",
    "NtGdiEngStrokeAndFillPath",
    "NtGdiEngPaint",
    "NtGdiEngLineTo",
    "NtGdiEngAlphaBlend",
    "NtGdiEngGradientFill",
    "NtGdiEngTransparentBlt",
    "NtGdiEngTextOut",
    "NtGdiEngStretchBltROP",
    "NtGdiXLATEOBJ_cGetPalette",
    "NtGdiXLATEOBJ_iXlate",
    "NtGdiXLATEOBJ_hGetColorTransform",
    "NtGdiCLIPOBJ_bEnum",
    "NtGdiCLIPOBJ_cEnumStart",
    "NtGdiCLIPOBJ_ppoGetPath",
    "NtGdiEngDeletePath",
    "NtGdiEngCreateClip",
    "NtGdiEngDeleteClip",
    "NtGdiBRUSHOBJ_ulGetBrushColor",
    "NtGdiBRUSHOBJ_pvAllocRbrush",
    "NtGdiBRUSHOBJ_pvGetRbrush",
    "NtGdiBRUSHOBJ_hGetColorTransform",
    "NtGdiXFORMOBJ_bApplyXform",
    "NtGdiXFORMOBJ_iGetXform",
    "NtGdiFONTOBJ_vGetInfo",
    "NtGdiFONTOBJ_pxoGetXform",
    "NtGdiFONTOBJ_cGetGlyphs",
    "NtGdiFONTOBJ_pifi",
    "NtGdiFONTOBJ_pfdg",
    "NtGdiFONTOBJ_pQueryGlyphAttrs",
    "NtGdiFONTOBJ_pvTrueTypeFontFile",
    "NtGdiFONTOBJ_cGetAllGlyphHandles",
    "NtGdiSTROBJ_bEnum",
    "NtGdiSTROBJ_bEnumPositionsOnly",
    "NtGdiSTROBJ_bGetAdvanceWidths",
    "NtGdiSTROBJ_vEnumStart",
    "NtGdiSTROBJ_dwGetCodePage",
    "NtGdiPATHOBJ_vGetBounds",
    "NtGdiPATHOBJ_bEnum",
    "NtGdiPATHOBJ_vEnumStart",
    "NtGdiPATHOBJ_vEnumStartClipLines",
    "NtGdiPATHOBJ_bEnumClipLines",
    "NtGdiGetDhpdev",
    "NtGdiEngCheckAbort",
    "NtGdiHT_Get8BPPFormatPalette",
    "NtGdiHT_Get8BPPMaskPalette",
    "NtGdiUpdateTransform",
    "NtGdiSetPUMPDOBJ",
    "NtGdiBRUSHOBJ_DeleteRbrush",
    "NtGdiUMPDEngFreeUserMem",
    "NtGdiDrawStream",
    "NtGdiDwmGetDirtyRgn",
    "NtGdiDwmGetSurfaceData",
    "NtGdiDdDDICreateAllocation",
    "NtGdiDdDDIQueryResourceInfo",
    "NtGdiDdDDIOpenResource",
    "NtGdiDdDDIDestroyAllocation",
    "NtGdiDdDDISetAllocationPriority",
    "NtGdiDdDDIQueryAllocationResidency",
    "NtGdiDdDDICreateDevice",
    "NtGdiDdDDIDestroyDevice",
    "NtGdiDdDDICreateContext",
    "NtGdiDdDDIDestroyContext",
    "NtGdiDdDDICreateSynchronizationObject",
    "NtGdiDdDDIDestroySynchronizationObject",
    "NtGdiDdDDIWaitForSynchronizationObject",
    "NtGdiDdDDISignalSynchronizationObject",
    "NtGdiDdDDIGetRuntimeData",
    "NtGdiDdDDIQueryAdapterInfo",
    "NtGdiDdDDILock",
    "NtGdiDdDDIUnlock",
    "NtGdiDdDDIGetDisplayModeList",
    "NtGdiDdDDISetDisplayMode",
    "NtGdiDdDDIGetMultisampleMethodList",
    "NtGdiDdDDIPresent",
    "NtGdiDdDDIRender",
    "NtGdiDdDDIOpenAdapterFromDeviceName",
    "NtGdiDdDDIOpenAdapterFromHdc",
    "NtGdiDdDDICloseAdapter",
    "NtGdiDdDDIGetSharedPrimaryHandle",
    "NtGdiDdDDIEscape",
    "NtGdiDdDDIQueryStatistics",
    "NtGdiDdDDISetVidPnSourceOwner",
    "NtGdiDdDDIGetPresentHistory",
    "NtGdiDdDDICreateOverlay",
    "NtGdiDdDDIUpdateOverlay",
    "NtGdiDdDDIFlipOverlay",
    "NtGdiDdDDIDestroyOverlay",
    "NtGdiDdDDIWaitForVerticalBlankEvent",
    "NtGdiDdDDISetGammaRamp",
    "NtGdiDdDDIGetDeviceState",
    "NtGdiDdDDICreateDCFromMemory",
    "NtGdiDdDDIDestroyDCFromMemory",
    "NtGdiDdDDISetContextSchedulingPriority",
    "NtGdiDdDDIGetContextSchedulingPriority",
    "NtGdiDdDDISetProcessSchedulingPriorityClass",
    "NtGdiDdDDIGetProcessSchedulingPriorityClass",
    "NtGdiDdDDIReleaseProcessVidPnSourceOwners",
    "NtGdiDdDDIGetScanLine",
    "NtGdiDdDDISetQueuedLimit",
    "NtGdiDdDDIPollDisplayChildren",
    "NtGdiDdDDIInvalidateActiveVidPn",
    "NtGdiDdDDICheckOcclusion",
    "NtGdiDdDDIWaitForIdle",
    "NtGdiDdDDICheckMonitorPowerState",
    "NtGdiDdDDICheckExclusiveOwnership",
    "NtGdiDdDDISetDisplayPrivateDriverFormat",
    "NtGdiDdDDISharedPrimaryLockNotification",
    "NtGdiDdDDISharedPrimaryUnLockNotification",
    "DxgStubDvpDestroyVideoPort",
    "DxgStubSwitchToGDI",
    "NtGdiGetNumberOfPhysicalMonitors",
    "NtGdiGetPhysicalMonitors",
    "NtGdiGetPhysicalMonitorDescription",
    "NtGdiDestroyPhysicalMonitor",
    "NtGdiDDCCIGetVCPFeature",
    "NtGdiDDCCISetVCPFeature",
    "NtGdiDDCCISaveCurrentSettings",
    "NtGdiDDCCIGetCapabilitiesStringLength",
    "NtGdiDDCCIGetCapabilitiesString",
    "NtGdiDDCCIGetTimingReport",
    "NtUserSetMirrorRendering",
    "NtUserShowSystemCursor"
};

//////////////////////////////////////////////////////////////////////////
// Windows 7 SP0 _W32pServiceTable
//////////////////////////////////////////////////////////////////////////
static const char* W32pServiceTable_Win7Sp0_x86[] = {
    "NtGdiAbortDoc",
    "NtGdiAbortPath",
    "NtGdiAddFontResourceW",
    "NtGdiAddRemoteFontToDC",
    "NtGdiAddFontMemResourceEx",
    "NtGdiRemoveMergeFont",
    "NtGdiAddRemoteMMInstanceToDC",
    "NtGdiAlphaBlend",
    "NtGdiAngleArc",
    "NtGdiAnyLinkedFonts",
    "NtGdiFontIsLinked",
    "NtGdiArcInternal",
    "NtGdiBeginGdiRendering",
    "NtGdiBeginPath",
    "NtGdiBitBlt",
    "NtGdiCancelDC",
    "NtGdiCheckBitmapBits",
    "NtGdiCloseFigure",
    "NtGdiClearBitmapAttributes",
    "NtGdiClearBrushAttributes",
    "NtGdiColorCorrectPalette",
    "NtGdiCombineRgn",
    "NtGdiCombineTransform",
    "NtGdiComputeXformCoefficients",
    "NtGdiConfigureOPMProtectedOutput",
    "NtGdiConvertMetafileRect",
    "NtGdiCreateBitmap",
    "NtGdiCreateBitmapFromDxSurface",
    "NtGdiCreateClientObj",
    "NtGdiCreateColorSpace",
    "NtGdiCreateColorTransform",
    "NtGdiCreateCompatibleBitmap",
    "NtGdiCreateCompatibleDC",
    "NtGdiCreateDIBBrush",
    "NtGdiCreateDIBitmapInternal",
    "NtGdiCreateDIBSection",
    "NtGdiCreateEllipticRgn",
    "NtGdiCreateHalftonePalette",
    "NtGdiCreateHatchBrushInternal",
    "NtGdiCreateMetafileDC",
    "NtGdiCreateOPMProtectedOutputs",
    "NtGdiCreatePaletteInternal",
    "NtGdiCreatePatternBrushInternal",
    "NtGdiCreatePen",
    "NtGdiCreateRectRgn",
    "NtGdiCreateRoundRectRgn",
    "NtGdiCreateServerMetaFile",
    "NtGdiCreateSolidBrush",
    "NtGdiD3dContextCreate",
    "NtGdiD3dContextDestroy",
    "NtGdiD3dContextDestroyAll",
    "NtGdiD3dValidateTextureStageState",
    "NtGdiD3dDrawPrimitives2",
    "NtGdiDdGetDriverState",
    "NtGdiDdAddAttachedSurface",
    "NtGdiDdAlphaBlt",
    "NtGdiDdAttachSurface",
    "NtGdiDdBeginMoCompFrame",
    "NtGdiDdBlt",
    "NtGdiDdCanCreateSurface",
    "NtGdiDdCanCreateD3DBuffer",
    "NtGdiDdColorControl",
    "NtGdiDdCreateDirectDrawObject",
    "NtGdiDdCreateSurface",
    "NtGdiDdCreateD3DBuffer",
    "NtGdiDdCreateMoComp",
    "NtGdiDdCreateSurfaceObject",
    "NtGdiDdDeleteDirectDrawObject",
    "NtGdiDdDeleteSurfaceObject",
    "NtGdiDdDestroyMoComp",
    "NtGdiDdDestroySurface",
    "NtGdiDdDestroyD3DBuffer",
    "NtGdiDdEndMoCompFrame",
    "NtGdiDdFlip",
    "NtGdiDdFlipToGDISurface",
    "NtGdiDdGetAvailDriverMemory",
    "NtGdiDdGetBltStatus",
    "NtGdiDdGetDC",
    "NtGdiDdGetDriverInfo",
    "NtGdiDdGetDxHandle",
    "NtGdiDdGetFlipStatus",
    "NtGdiDdGetInternalMoCompInfo",
    "NtGdiDdGetMoCompBuffInfo",
    "NtGdiDdGetMoCompGuids",
    "NtGdiDdGetMoCompFormats",
    "NtGdiDdGetScanLine",
    "NtGdiDdLock",
    "NtGdiDdLockD3D",
    "NtGdiDdQueryDirectDrawObject",
    "NtGdiDdQueryMoCompStatus",
    "NtGdiDdReenableDirectDrawObject",
    "NtGdiDdReleaseDC",
    "NtGdiDdRenderMoComp",
    "NtGdiDdResetVisrgn",
    "NtGdiDdSetColorKey",
    "NtGdiDdSetExclusiveMode",
    "NtGdiDdSetGammaRamp",
    "NtGdiDdCreateSurfaceEx",
    "NtGdiDdSetOverlayPosition",
    "NtGdiDdUnattachSurface",
    "NtGdiDdUnlock",
    "NtGdiDdUnlockD3D",
    "NtGdiDdUpdateOverlay",
    "NtGdiDdWaitForVerticalBlank",
    "NtGdiDvpCanCreateVideoPort",
    "NtGdiDvpColorControl",
    "NtGdiDvpCreateVideoPort",
    "NtGdiDvpDestroyVideoPort",
    "NtGdiDvpFlipVideoPort",
    "NtGdiDvpGetVideoPortBandwidth",
    "NtGdiDvpGetVideoPortField",
    "NtGdiDvpGetVideoPortFlipStatus",
    "NtGdiDvpGetVideoPortInputFormats",
    "NtGdiDvpGetVideoPortLine",
    "NtGdiDvpGetVideoPortOutputFormats",
    "NtGdiDvpGetVideoPortConnectInfo",
    "NtGdiDvpGetVideoSignalStatus",
    "NtGdiDvpUpdateVideoPort",
    "NtGdiDvpWaitForVideoPortSync",
    "NtGdiDvpAcquireNotification",
    "NtGdiDvpReleaseNotification",
    "NtGdiDxgGenericThunk",
    "NtGdiDeleteClientObj",
    "NtGdiDeleteColorSpace",
    "NtGdiDeleteColorTransform",
    "NtGdiDeleteObjectApp",
    "NtGdiDescribePixelFormat",
    "NtGdiDestroyOPMProtectedOutput",
    "NtGdiGetPerBandInfo",
    "NtGdiDoBanding",
    "NtGdiDoPalette",
    "NtGdiDrawEscape",
    "NtGdiEllipse",
    "NtGdiEnableEudc",
    "NtGdiEndDoc",
    "NtGdiEndGdiRendering",
    "NtGdiEndPage",
    "NtGdiEndPath",
    "NtGdiEnumFonts",
    "NtGdiEnumObjects",
    "NtGdiEqualRgn",
    "NtGdiEudcLoadUnloadLink",
    "NtGdiExcludeClipRect",
    "NtGdiExtCreatePen",
    "NtGdiExtCreateRegion",
    "NtGdiExtEscape",
    "NtGdiExtFloodFill",
    "NtGdiExtGetObjectW",
    "NtGdiExtSelectClipRgn",
    "NtGdiExtTextOutW",
    "NtGdiFillPath",
    "NtGdiFillRgn",
    "NtGdiFlattenPath",
    "NtGdiFlush",
    "NtGdiForceUFIMapping",
    "NtGdiFrameRgn",
    "NtGdiFullscreenControl",
    "NtGdiGetAndSetDCDword",
    "NtGdiGetAppClipBox",
    "NtGdiGetBitmapBits",
    "NtGdiGetBitmapDimension",
    "NtGdiGetBoundsRect",
    "NtGdiGetCertificate",
    "NtGdiGetCertificateSize",
    "NtGdiGetCharABCWidthsW",
    "NtGdiGetCharacterPlacementW",
    "NtGdiGetCharSet",
    "NtGdiGetCharWidthW",
    "NtGdiGetCharWidthInfo",
    "NtGdiGetColorAdjustment",
    "NtGdiGetColorSpaceforBitmap",
    "NtGdiGetCOPPCompatibleOPMInformation",
    "NtGdiGetDCDword",
    "NtGdiGetDCforBitmap",
    "NtGdiGetDCObject",
    "NtGdiGetDCPoint",
    "NtGdiGetDeviceCaps",
    "NtGdiGetDeviceGammaRamp",
    "NtGdiGetDeviceCapsAll",
    "NtGdiGetDIBitsInternal",
    "NtGdiGetETM",
    "NtGdiGetEudcTimeStampEx",
    "NtGdiGetFontData",
    "NtGdiGetFontFileData",
    "NtGdiGetFontFileInfo",
    "NtGdiGetFontResourceInfoInternalW",
    "NtGdiGetGlyphIndicesW",
    "NtGdiGetGlyphIndicesWInternal",
    "NtGdiGetGlyphOutline",
    "NtGdiGetOPMInformation",
    "NtGdiGetKerningPairs",
    "NtGdiGetLinkedUFIs",
    "NtGdiGetMiterLimit",
    "NtGdiGetMonitorID",
    "NtGdiGetNearestColor",
    "NtGdiGetNearestPaletteIndex",
    "NtGdiGetObjectBitmapHandle",
    "NtGdiGetOPMRandomNumber",
    "NtGdiGetOutlineTextMetricsInternalW",
    "NtGdiGetPath",
    "NtGdiGetPixel",
    "NtGdiGetRandomRgn",
    "NtGdiGetRasterizerCaps",
    "NtGdiGetRealizationInfo",
    "NtGdiGetRegionData",
    "NtGdiGetRgnBox",
    "NtGdiGetServerMetaFileBits",
    "UMPDDrvCreateDeviceBitmap",
    "NtGdiGetStats",
    "NtGdiGetStockObject",
    "NtGdiGetStringBitmapW",
    "NtGdiGetSuggestedOPMProtectedOutputArraySize",
    "NtGdiGetSystemPaletteUse",
    "NtGdiGetTextCharsetInfo",
    "NtGdiGetTextExtent",
    "NtGdiGetTextExtentExW",
    "NtGdiGetTextFaceW",
    "NtGdiGetTextMetricsW",
    "NtGdiGetTransform",
    "NtGdiGetUFI",
    "NtGdiGetEmbUFI",
    "NtGdiGetUFIPathname",
    "NtGdiGetEmbedFonts",
    "NtGdiChangeGhostFont",
    "NtGdiAddEmbFontToDC",
    "NtGdiGetFontUnicodeRanges",
    "NtGdiGetWidthTable",
    "NtGdiGradientFill",
    "NtGdiHfontCreate",
    "NtGdiIcmBrushInfo",
    "IsIMMEnabledSystem",
    "NtGdiInitSpool",
    "NtGdiIntersectClipRect",
    "NtGdiInvertRgn",
    "NtGdiLineTo",
    "NtGdiMakeFontDir",
    "NtGdiMakeInfoDC",
    "NtGdiMaskBlt",
    "NtGdiModifyWorldTransform",
    "NtGdiMonoBitmap",
    "NtGdiMoveTo",
    "NtGdiOffsetClipRgn",
    "NtGdiOffsetRgn",
    "NtGdiOpenDCW",
    "NtGdiPatBlt",
    "NtGdiPolyPatBlt",
    "NtGdiPathToRegion",
    "NtGdiPlgBlt",
    "NtGdiPolyDraw",
    "NtGdiPolyPolyDraw",
    "NtGdiPolyTextOutW",
    "NtGdiPtInRegion",
    "NtGdiPtVisible",
    "NtGdiQueryFonts",
    "NtGdiQueryFontAssocInfo",
    "NtGdiRectangle",
    "NtGdiRectInRegion",
    "NtGdiRectVisible",
    "NtGdiRemoveFontResourceW",
    "NtGdiRemoveFontMemResourceEx",
    "NtGdiResetDC",
    "NtGdiResizePalette",
    "NtGdiRestoreDC",
    "NtGdiRoundRect",
    "NtGdiSaveDC",
    "NtGdiScaleViewportExtEx",
    "NtGdiScaleWindowExtEx",
    "NtGdiSelectBitmap",
    "NtGdiSelectBrush",
    "NtGdiSelectClipPath",
    "NtGdiSelectFont",
    "NtGdiSelectPen",
    "NtGdiSetBitmapAttributes",
    "NtGdiSetBitmapBits",
    "NtGdiSetBitmapDimension",
    "NtGdiSetBoundsRect",
    "NtGdiSetBrushAttributes",
    "NtGdiSetBrushOrg",
    "NtGdiSetColorAdjustment",
    "NtGdiSetColorSpace",
    "NtGdiSetDeviceGammaRamp",
    "NtGdiSetDIBitsToDeviceInternal",
    "NtGdiSetFontEnumeration",
    "NtGdiSetFontXform",
    "NtGdiSetIcmMode",
    "NtGdiSetLinkedUFIs",
    "NtGdiSetMagicColors",
    "NtGdiSetMetaRgn",
    "NtGdiSetMiterLimit",
    "NtGdiGetDeviceWidth",
    "NtGdiMirrorWindowOrg",
    "NtGdiSetLayout",
    "NtGdiSetOPMSigningKeyAndSequenceNumbers",
    "NtGdiSetPixel",
    "NtGdiSetPixelFormat",
    "NtGdiSetRectRgn",
    "NtGdiSetSystemPaletteUse",
    "NtGdiSetTextJustification",
    "NtGdiSetVirtualResolution",
    "NtGdiSetSizeDevice",
    "NtGdiStartDoc",
    "NtGdiStartPage",
    "NtGdiStretchBlt",
    "NtGdiStretchDIBitsInternal",
    "NtGdiStrokeAndFillPath",
    "NtGdiStrokePath",
    "NtGdiSwapBuffers",
    "NtGdiTransformPoints",
    "NtGdiTransparentBlt",
    "DxgStubGetInternalMoCompInfo",
    "NtGdiUMPDEngFreeUserMem",
    "NtGdiUnrealizeObject",
    "NtGdiUpdateColors",
    "NtGdiWidenPath",
    "NtUserActivateKeyboardLayout",
    "NtUserAddClipboardFormatListener",
    "NtUserAlterWindowStyle",
    "NtUserAssociateInputContext",
    "NtUserAttachThreadInput",
    "NtUserBeginPaint",
    "NtUserBitBltSysBmp",
    "NtUserBlockInput",
    "NtUserBuildHimcList",
    "NtUserBuildHwndList",
    "NtUserBuildNameList",
    "NtUserBuildPropList",
    "NtUserCallHwnd",
    "NtUserCallHwndLock",
    "NtUserCallHwndOpt",
    "NtUserCallHwndParam",
    "NtUserCallHwndParamLock",
    "NtUserCallMsgFilter",
    "NtUserCallNextHookEx",
    "NtUserCallNoParam",
    "NtUserCallOneParam",
    "NtUserCallTwoParam",
    "NtUserChangeClipboardChain",
    "NtUserChangeDisplaySettings",
    "NtUserGetDisplayConfigBufferSizes",
    "NtUserSetDisplayConfig",
    "NtUserQueryDisplayConfig",
    "NtUserDisplayConfigGetDeviceInfo",
    "NtUserDisplayConfigSetDeviceInfo",
    "NtUserCheckAccessForIntegrityLevel",
    "NtUserCheckDesktopByThreadId",
    "NtUserCheckWindowThreadDesktop",
    "NtUserCheckMenuItem",
    "NtUserChildWindowFromPointEx",
    "NtUserClipCursor",
    "NtUserCloseClipboard",
    "NtUserCloseDesktop",
    "NtUserCloseWindowStation",
    "NtUserConsoleControl",
    "NtUserConvertMemHandle",
    "NtUserCopyAcceleratorTable",
    "NtUserCountClipboardFormats",
    "NtUserCreateAcceleratorTable",
    "NtUserCreateCaret",
    "NtUserCreateDesktopEx",
    "NtUserCreateInputContext",
    "NtUserCreateLocalMemHandle",
    "NtUserCreateWindowEx",
    "NtUserCreateWindowStation",
    "NtUserDdeInitialize",
    "NtUserDeferWindowPos",
    "NtUserDefSetText",
    "NtUserDeleteMenu",
    "NtUserDestroyAcceleratorTable",
    "NtUserDestroyCursor",
    "NtUserDestroyInputContext",
    "NtUserDestroyMenu",
    "NtUserDestroyWindow",
    "NtUserDisableThreadIme",
    "NtUserDispatchMessage",
    "NtUserDoSoundConnect",
    "NtUserDoSoundDisconnect",
    "NtUserDragDetect",
    "NtUserDragObject",
    "NtUserDrawAnimatedRects",
    "NtUserDrawCaption",
    "NtUserDrawCaptionTemp",
    "NtUserDrawIconEx",
    "NtUserDrawMenuBarTemp",
    "NtUserEmptyClipboard",
    "NtUserEnableMenuItem",
    "NtUserEnableScrollBar",
    "NtUserEndDeferWindowPosEx",
    "NtUserEndMenu",
    "NtUserEndPaint",
    "NtUserEnumDisplayDevices",
    "NtUserEnumDisplayMonitors",
    "NtUserEnumDisplaySettings",
    "NtUserEvent",
    "NtUserExcludeUpdateRgn",
    "NtUserFillWindow",
    "NtUserFindExistingCursorIcon",
    "NtUserFindWindowEx",
    "NtUserFlashWindowEx",
    "NtUserFrostCrashedWindow",
    "NtUserGetAltTabInfo",
    "NtUserGetAncestor",
    "NtUserGetAppImeLevel",
    "NtUserGetAsyncKeyState",
    "NtUserGetAtomName",
    "NtUserGetCaretBlinkTime",
    "NtUserGetCaretPos",
    "NtUserGetClassInfoEx",
    "NtUserGetClassName",
    "NtUserGetClipboardData",
    "NtUserGetClipboardFormatName",
    "NtUserGetClipboardOwner",
    "NtUserGetClipboardSequenceNumber",
    "NtUserGetClipboardViewer",
    "NtUserGetClipCursor",
    "NtUserGetComboBoxInfo",
    "NtUserGetControlBrush",
    "NtUserGetControlColor",
    "NtUserGetCPD",
    "NtUserGetCursorFrameInfo",
    "NtUserGetCursorInfo",
    "NtUserGetDC",
    "NtUserGetDCEx",
    "NtUserGetDoubleClickTime",
    "NtUserGetForegroundWindow",
    "NtUserGetGuiResources",
    "NtUserGetGUIThreadInfo",
    "NtUserGetIconInfo",
    "NtUserGetIconSize",
    "NtUserGetImeHotKey",
    "NtUserGetImeInfoEx",
    "NtUserGetInputLocaleInfo",
    "NtUserGetInternalWindowPos",
    "NtUserGetKeyboardLayoutList",
    "NtUserGetKeyboardLayoutName",
    "NtUserGetKeyboardState",
    "NtUserGetKeyNameText",
    "NtUserGetKeyState",
    "NtUserGetListBoxInfo",
    "NtUserGetMenuBarInfo",
    "NtUserGetMenuIndex",
    "NtUserGetMenuItemRect",
    "NtUserGetMessage",
    "NtUserGetMouseMovePointsEx",
    "NtUserGetObjectInformation",
    "NtUserGetOpenClipboardWindow",
    "NtUserGetPriorityClipboardFormat",
    "NtUserGetProcessWindowStation",
    "NtUserGetRawInputBuffer",
    "NtUserGetRawInputData",
    "NtUserGetRawInputDeviceInfo",
    "NtUserGetRawInputDeviceList",
    "NtUserGetRegisteredRawInputDevices",
    "NtUserGetScrollBarInfo",
    "NtUserGetSystemMenu",
    "NtUserGetThreadDesktop",
    "NtUserGetThreadState",
    "NtUserGetTitleBarInfo",
    "NtUserGetTopLevelWindow",
    "NtUserGetUpdatedClipboardFormats",
    "NtUserGetUpdateRect",
    "NtUserGetUpdateRgn",
    "NtUserGetWindowCompositionInfo",
    "NtUserGetWindowCompositionAttribute",
    "NtUserGetWindowDC",
    "NtUserGetWindowDisplayAffinity",
    "NtUserGetWindowPlacement",
    "NtUserGetWOWClass",
    "NtUserGhostWindowFromHungWindow",
    "NtUserHardErrorControl",
    "NtUserHideCaret",
    "NtUserHiliteMenuItem",
    "NtUserHungWindowFromGhostWindow",
    "NtUserImpersonateDdeClientWindow",
    "NtUserInitialize",
    "NtUserInitializeClientPfnArrays",
    "NtUserInitTask",
    "NtUserInternalGetWindowText",
    "NtUserInternalGetWindowIcon",
    "NtUserInvalidateRect",
    "NtUserInvalidateRgn",
    "NtUserIsClipboardFormatAvailable",
    "NtUserIsTopLevelWindow",
    "NtUserKillTimer",
    "NtUserLoadKeyboardLayoutEx",
    "NtUserLockWindowStation",
    "NtUserLockWindowUpdate",
    "NtUserLockWorkStation",
    "NtUserLogicalToPhysicalPoint",
    "NtUserMapVirtualKeyEx",
    "NtUserMenuItemFromPoint",
    "NtUserMessageCall",
    "NtUserMinMaximize",
    "NtUserMNDragLeave",
    "NtUserMNDragOver",
    "NtUserModifyUserStartupInfoFlags",
    "NtUserMoveWindow",
    "NtUserNotifyIMEStatus",
    "NtUserNotifyProcessCreate",
    "NtUserNotifyWinEvent",
    "NtUserOpenClipboard",
    "NtUserOpenDesktop",
    "NtUserOpenInputDesktop",
    "NtUserOpenThreadDesktop",
    "NtUserOpenWindowStation",
    "NtUserPaintDesktop",
    "NtUserPaintMonitor",
    "NtUserPeekMessage",
    "NtUserPhysicalToLogicalPoint",
    "NtUserPostMessage",
    "NtUserPostThreadMessage",
    "NtUserPrintWindow",
    "NtUserProcessConnect",
    "NtUserQueryInformationThread",
    "NtUserQueryInputContext",
    "NtUserQuerySendMessage",
    "NtUserQueryWindow",
    "NtUserRealChildWindowFromPoint",
    "NtUserRealInternalGetMessage",
    "NtUserRealWaitMessageEx",
    "NtUserRedrawWindow",
    "NtUserRegisterClassExWOW",
    "NtUserRegisterErrorReportingDialog",
    "NtUserRegisterUserApiHook",
    "NtUserRegisterHotKey",
    "NtUserRegisterRawInputDevices",
    "NtUserRegisterServicesProcess",
    "NtUserRegisterTasklist",
    "NtUserRegisterWindowMessage",
    "NtUserRemoveClipboardFormatListener",
    "NtUserRemoveMenu",
    "NtUserRemoveProp",
    "NtUserResolveDesktopForWOW",
    "NtUserSBGetParms",
    "NtUserScrollDC",
    "NtUserScrollWindowEx",
    "NtUserSelectPalette",
    "NtUserSendInput",
    "NtUserSetActiveWindow",
    "NtUserSetAppImeLevel",
    "NtUserSetCapture",
    "NtUserSetChildWindowNoActivate",
    "NtUserSetClassLong",
    "NtUserSetClassWord",
    "NtUserSetClipboardData",
    "NtUserSetClipboardViewer",
    "NtUserSetCursor",
    "NtUserSetCursorContents",
    "NtUserSetCursorIconData",
    "NtUserSetFocus",
    "NtUserSetImeHotKey",
    "NtUserSetImeInfoEx",
    "NtUserSetImeOwnerWindow",
    "NtUserSetInformationThread",
    "NtUserSetInternalWindowPos",
    "NtUserSetKeyboardState",
    "NtUserSetMenu",
    "NtUserSetMenuContextHelpId",
    "NtUserSetMenuDefaultItem",
    "NtUserSetMenuFlagRtoL",
    "NtUserSetObjectInformation",
    "NtUserSetParent",
    "NtUserSetProcessWindowStation",
    "NtUserGetProp",
    "NtUserSetProp",
    "NtUserSetScrollInfo",
    "NtUserSetShellWindowEx",
    "NtUserSetSysColors",
    "NtUserSetSystemCursor",
    "NtUserSetSystemMenu",
    "NtUserSetSystemTimer",
    "NtUserSetThreadDesktop",
    "NtUserSetThreadLayoutHandles",
    "NtUserSetThreadState",
    "NtUserSetTimer",
    "NtUserSetProcessDPIAware",
    "NtUserSetWindowCompositionAttribute",
    "NtUserSetWindowDisplayAffinity",
    "NtUserSetWindowFNID",
    "NtUserSetWindowLong",
    "NtUserSetWindowPlacement",
    "NtUserSetWindowPos",
    "NtUserSetWindowRgn",
    "NtUserGetWindowRgnEx",
    "NtUserSetWindowRgnEx",
    "NtUserSetWindowsHookAW",
    "NtUserSetWindowsHookEx",
    "NtUserSetWindowStationUser",
    "NtUserSetWindowWord",
    "NtUserSetWinEventHook",
    "NtUserShowCaret",
    "NtUserShowScrollBar",
    "NtUserShowWindow",
    "NtUserShowWindowAsync",
    "NtUserSoundSentry",
    "NtUserSwitchDesktop",
    "NtUserSystemParametersInfo",
    "NtUserTestForInteractiveUser",
    "NtUserThunkedMenuInfo",
    "NtUserThunkedMenuItemInfo",
    "NtUserToUnicodeEx",
    "NtUserTrackMouseEvent",
    "NtUserTrackPopupMenuEx",
    "NtUserCalculatePopupWindowPosition",
    "NtUserCalcMenuBar",
    "NtUserPaintMenuBar",
    "NtUserTranslateAccelerator",
    "NtUserTranslateMessage",
    "NtUserUnhookWindowsHookEx",
    "NtUserUnhookWinEvent",
    "NtUserUnloadKeyboardLayout",
    "NtUserUnlockWindowStation",
    "NtUserUnregisterClass",
    "NtUserUnregisterUserApiHook",
    "NtUserUnregisterHotKey",
    "NtUserUpdateInputContext",
    "NtUserUpdateInstance",
    "NtUserUpdateLayeredWindow",
    "NtUserGetLayeredWindowAttributes",
    "NtUserSetLayeredWindowAttributes",
    "NtUserUpdatePerUserSystemParameters",
    "NtUserUserHandleGrantAccess",
    "NtUserValidateHandleSecure",
    "NtUserValidateRect",
    "NtUserValidateTimerCallback",
    "NtUserVkKeyScanEx",
    "NtUserWaitForInputIdle",
    "NtUserWaitForMsgAndEvent",
    "NtUserWaitMessage",
    "NtUserWindowFromPhysicalPoint",
    "NtUserWindowFromPoint",
    "NtUserYieldTask",
    "NtUserRemoteConnect",
    "NtUserRemoteRedrawRectangle",
    "NtUserRemoteRedrawScreen",
    "NtUserRemoteStopScreenUpdates",
    "NtUserCtxDisplayIOCtl",
    "NtUserRegisterSessionPort",
    "NtUserUnregisterSessionPort",
    "NtUserUpdateWindowTransform",
    "NtUserDwmStartRedirection",
    "NtUserDwmStopRedirection",
    "NtUserGetWindowMinimizeRect",
    "NtUserSfmDxBindSwapChain",
    "NtUserSfmDxOpenSwapChain",
    "NtUserSfmDxReleaseSwapChain",
    "NtUserSfmDxSetSwapChainBindingStatus",
    "NtUserSfmDxQuerySwapChainBindingStatus",
    "NtUserSfmDxReportPendingBindingsToDwm",
    "NtUserSfmDxGetSwapChainStats",
    "NtUserSfmDxSetSwapChainStats",
    "NtUserSfmGetLogicalSurfaceBinding",
    "NtUserSfmDestroyLogicalSurfaceBinding",
    "NtUserModifyWindowTouchCapability",
    "NtUserIsTouchWindow",
    "NtUserSendTouchInput",
    "NtUserEndTouchOperation",
    "NtUserGetTouchInputInfo",
    "NtUserChangeWindowMessageFilterEx",
    "NtUserInjectGesture",
    "NtUserGetGestureInfo",
    "NtUserGetGestureExtArgs",
    "NtUserManageGestureHandlerWindow",
    "NtUserSetGestureConfig",
    "NtUserGetGestureConfig",
    "NtGdiEngAssociateSurface",
    "NtGdiEngCreateBitmap",
    "NtGdiEngCreateDeviceSurface",
    "NtGdiEngCreateDeviceBitmap",
    "NtGdiEngCreatePalette",
    "NtGdiEngComputeGlyphSet",
    "NtGdiEngCopyBits",
    "NtGdiEngDeletePalette",
    "NtGdiEngDeleteSurface",
    "NtGdiEngEraseSurface",
    "NtGdiEngUnlockSurface",
    "NtGdiEngLockSurface",
    "NtGdiEngBitBlt",
    "NtGdiEngStretchBlt",
    "NtGdiEngPlgBlt",
    "NtGdiEngMarkBandingSurface",
    "NtGdiEngStrokePath",
    "NtGdiEngFillPath",
    "NtGdiEngStrokeAndFillPath",
    "NtGdiEngPaint",
    "NtGdiEngLineTo",
    "NtGdiEngAlphaBlend",
    "NtGdiEngGradientFill",
    "NtGdiEngTransparentBlt",
    "NtGdiEngTextOut",
    "NtGdiEngStretchBltROP",
    "NtGdiXLATEOBJ_cGetPalette",
    "NtGdiXLATEOBJ_iXlate",
    "NtGdiXLATEOBJ_hGetColorTransform",
    "NtGdiCLIPOBJ_bEnum",
    "NtGdiCLIPOBJ_cEnumStart",
    "NtGdiCLIPOBJ_ppoGetPath",
    "NtGdiEngDeletePath",
    "NtGdiEngCreateClip",
    "NtGdiEngDeleteClip",
    "NtGdiBRUSHOBJ_ulGetBrushColor",
    "NtGdiBRUSHOBJ_pvAllocRbrush",
    "NtGdiBRUSHOBJ_pvGetRbrush",
    "NtGdiBRUSHOBJ_hGetColorTransform",
    "NtGdiXFORMOBJ_bApplyXform",
    "NtGdiXFORMOBJ_iGetXform",
    "NtGdiFONTOBJ_vGetInfo",
    "NtGdiFONTOBJ_pxoGetXform",
    "NtGdiFONTOBJ_cGetGlyphs",
    "NtGdiFONTOBJ_pifi",
    "NtGdiFONTOBJ_pfdg",
    "NtGdiFONTOBJ_pQueryGlyphAttrs",
    "NtGdiFONTOBJ_pvTrueTypeFontFile",
    "NtGdiFONTOBJ_cGetAllGlyphHandles",
    "NtGdiSTROBJ_bEnum",
    "NtGdiSTROBJ_bEnumPositionsOnly",
    "NtGdiSTROBJ_bGetAdvanceWidths",
    "NtGdiSTROBJ_vEnumStart",
    "NtGdiSTROBJ_dwGetCodePage",
    "NtGdiPATHOBJ_vGetBounds",
    "NtGdiPATHOBJ_bEnum",
    "NtGdiPATHOBJ_vEnumStart",
    "NtGdiPATHOBJ_vEnumStartClipLines",
    "NtGdiPATHOBJ_bEnumClipLines",
    "NtGdiGetDhpdev",
    "NtGdiEngCheckAbort",
    "NtGdiHT_Get8BPPFormatPalette",
    "NtGdiHT_Get8BPPMaskPalette",
    "NtGdiUpdateTransform",
    "NtGdiSetPUMPDOBJ",
    "NtGdiBRUSHOBJ_DeleteRbrush",
    "NtGdiUMPDEngFreeUserMem",
    "NtGdiDrawStream",
    "NtGdiSfmGetNotificationTokens",
    "NtGdiHLSurfGetInformation",
    "NtGdiHLSurfSetInformation",
    "NtGdiDdDDICreateAllocation",
    "NtGdiDdDDIQueryResourceInfo",
    "NtGdiDdDDIOpenResource",
    "NtGdiDdDDIDestroyAllocation",
    "NtGdiDdDDISetAllocationPriority",
    "NtGdiDdDDIQueryAllocationResidency",
    "NtGdiDdDDICreateDevice",
    "NtGdiDdDDIDestroyDevice",
    "NtGdiDdDDICreateContext",
    "NtGdiDdDDIDestroyContext",
    "NtGdiDdDDICreateSynchronizationObject",
    "NtGdiDdDDIOpenSynchronizationObject",
    "NtGdiDdDDIDestroySynchronizationObject",
    "NtGdiDdDDIWaitForSynchronizationObject",
    "NtGdiDdDDISignalSynchronizationObject",
    "NtGdiDdDDIGetRuntimeData",
    "NtGdiDdDDIQueryAdapterInfo",
    "NtGdiDdDDILock",
    "NtGdiDdDDIUnlock",
    "NtGdiDdDDIGetDisplayModeList",
    "NtGdiDdDDISetDisplayMode",
    "NtGdiDdDDIGetMultisampleMethodList",
    "NtGdiDdDDIPresent",
    "NtGdiDdDDIRender",
    "NtGdiDdDDIOpenAdapterFromDeviceName",
    "NtGdiDdDDIOpenAdapterFromHdc",
    "NtGdiDdDDICloseAdapter",
    "NtGdiDdDDIGetSharedPrimaryHandle",
    "NtGdiDdDDIEscape",
    "NtGdiDdDDIQueryStatistics",
    "NtGdiDdDDISetVidPnSourceOwner",
    "NtGdiDdDDIGetPresentHistory",
    "NtGdiDdDDIGetPresentQueueEvent",
    "NtGdiDdDDICreateOverlay",
    "NtGdiDdDDIUpdateOverlay",
    "NtGdiDdDDIFlipOverlay",
    "NtGdiDdDDIDestroyOverlay",
    "NtGdiDdDDIWaitForVerticalBlankEvent",
    "NtGdiDdDDISetGammaRamp",
    "NtGdiDdDDIGetDeviceState",
    "NtGdiDdDDICreateDCFromMemory",
    "NtGdiDdDDIDestroyDCFromMemory",
    "NtGdiDdDDISetContextSchedulingPriority",
    "NtGdiDdDDIGetContextSchedulingPriority",
    "NtGdiDdDDISetProcessSchedulingPriorityClass",
    "NtGdiDdDDIGetProcessSchedulingPriorityClass",
    "NtGdiDdDDIReleaseProcessVidPnSourceOwners",
    "NtGdiDdDDIGetScanLine",
    "NtGdiDdDDISetQueuedLimit",
    "NtGdiDdDDIPollDisplayChildren",
    "NtGdiDdDDIInvalidateActiveVidPn",
    "NtGdiDdDDICheckOcclusion",
    "NtGdiDdDDIWaitForIdle",
    "NtGdiDdDDICheckMonitorPowerState",
    "NtGdiDdDDICheckExclusiveOwnership",
    "NtGdiDdDDISetDisplayPrivateDriverFormat",
    "NtGdiDdDDISharedPrimaryLockNotification",
    "NtGdiDdDDISharedPrimaryUnLockNotification",
    "NtGdiDdDDICreateKeyedMutex",
    "NtGdiDdDDIOpenKeyedMutex",
    "NtGdiDdDDIDestroyKeyedMutex",
    "NtGdiDdDDIAcquireKeyedMutex",
    "NtGdiDdDDIReleaseKeyedMutex",
    "NtGdiDdDDIConfigureSharedResource",
    "NtGdiDdDDIGetOverlayState",
    "NtGdiDdDDICheckVidPnExclusiveOwnership",
    "NtGdiDdDDICheckSharedResourceAccess",
    "DxgStubGetInternalMoCompInfo",
    "DxgStubUnlockDirectDrawSurface",
    "NtGdiGetNumberOfPhysicalMonitors",
    "NtGdiGetPhysicalMonitors",
    "NtGdiGetPhysicalMonitorDescription",
    "DestroyPhysicalMonitor",
    "NtGdiDDCCIGetVCPFeature",
    "NtGdiDDCCISetVCPFeature",
    "NtGdiDDCCISaveCurrentSettings",
    "NtGdiDDCCIGetCapabilitiesStringLength",
    "NtGdiDDCCIGetCapabilitiesString",
    "NtGdiDDCCIGetTimingReport",
    "NtGdiDdCreateFullscreenSprite",
    "NtGdiDdNotifyFullscreenSpriteUpdate",
    "NtGdiDdDestroyFullscreenSprite",
    "DxEngVisRgnUniq",
    "NtUserSetMirrorRendering",
    "NtUserShowSystemCursor",
    "NtUserMagControl",
    "NtUserMagSetContextInformation",
    "NtUserMagGetContextInformation",
    "NtUserHwndQueryRedirectionInfo",
    "NtUserHwndSetRedirectionInfo"
};

//////////////////////////////////////////////////////////////////////////
// Windows 7 SP1 _W32pServiceTable
//////////////////////////////////////////////////////////////////////////
static const char* W32pServiceTable_Win7Sp1_x86[] = {
    "NtGdiAbortDoc",
    "NtGdiAbortPath",
    "NtGdiAddFontResourceW",
    "NtGdiAddRemoteFontToDC",
    "NtGdiAddFontMemResourceEx",
    "NtGdiRemoveMergeFont",
    "NtGdiAddRemoteMMInstanceToDC",
    "NtGdiAlphaBlend",
    "NtGdiAngleArc",
    "NtGdiAnyLinkedFonts",
    "NtGdiFontIsLinked",
    "NtGdiArcInternal",
    "NtGdiBeginGdiRendering",
    "NtGdiBeginPath",
    "NtGdiBitBlt",
    "NtGdiCancelDC",
    "NtGdiCheckBitmapBits",
    "NtGdiCloseFigure",
    "NtGdiClearBitmapAttributes",
    "DxgStubColorControl",
    "NtGdiColorCorrectPalette",
    "NtGdiCombineRgn",
    "NtGdiCombineTransform",
    "NtGdiComputeXformCoefficients",
    "NtGdiConfigureOPMProtectedOutput",
    "NtGdiConvertMetafileRect",
    "NtGdiCreateBitmap",
    "NtGdiCreateBitmapFromDxSurface",
    "NtGdiCreateClientObj",
    "NtGdiCreateColorSpace",
    "NtGdiCreateColorTransform",
    "NtGdiCreateCompatibleBitmap",
    "NtGdiCreateCompatibleDC",
    "NtGdiCreateDIBBrush",
    "NtGdiCreateDIBitmapInternal",
    "NtGdiCreateDIBSection",
    "NtGdiCreateEllipticRgn",
    "NtGdiCreateHalftonePalette",
    "NtGdiCreateHatchBrushInternal",
    "NtGdiCreateMetafileDC",
    "NtGdiCreateOPMProtectedOutputs",
    "NtGdiCreatePaletteInternal",
    "NtGdiCreatePatternBrushInternal",
    "NtGdiCreatePen",
    "NtGdiCreateRectRgn",
    "NtGdiCreateRoundRectRgn",
    "NtGdiCreateServerMetaFile",
    "NtGdiCreateSolidBrush",
    "NtGdiD3dContextCreate",
    "NtGdiD3dContextDestroy",
    "NtGdiD3dContextDestroyAll",
    "NtGdiD3dValidateTextureStageState",
    "NtGdiD3dDrawPrimitives2",
    "NtGdiDdGetDriverState",
    "NtGdiDdAddAttachedSurface",
    "NtGdiDdAlphaBlt",
    "NtGdiDdAttachSurface",
    "NtGdiDdBeginMoCompFrame",
    "NtGdiDdBlt",
    "NtGdiDdCanCreateSurface",
    "NtGdiDdCanCreateD3DBuffer",
    "NtGdiDdColorControl",
    "NtGdiDdCreateDirectDrawObject",
    "NtGdiDdCreateSurface",
    "NtGdiDdCreateD3DBuffer",
    "NtGdiDdCreateMoComp",
    "NtGdiDdCreateSurfaceObject",
    "NtGdiDdDeleteDirectDrawObject",
    "NtGdiDdDeleteSurfaceObject",
    "NtGdiDdDestroyMoComp",
    "NtGdiDdDestroySurface",
    "NtGdiDdDestroyD3DBuffer",
    "NtGdiDdEndMoCompFrame",
    "NtGdiDdFlip",
    "NtGdiDdFlipToGDISurface",
    "NtGdiDdGetAvailDriverMemory",
    "NtGdiDdGetBltStatus",
    "NtGdiDdGetDC",
    "NtGdiDdGetDriverInfo",
    "NtGdiDdGetDxHandle",
    "NtGdiDdGetFlipStatus",
    "NtGdiDdGetInternalMoCompInfo",
    "NtGdiDdGetMoCompBuffInfo",
    "NtGdiDdGetMoCompGuids",
    "NtGdiDdGetMoCompFormats",
    "NtGdiDdGetScanLine",
    "NtGdiDdLock",
    "NtGdiDdLockD3D",
    "NtGdiDdQueryDirectDrawObject",
    "NtGdiDdQueryMoCompStatus",
    "NtGdiDdReenableDirectDrawObject",
    "NtGdiDdReleaseDC",
    "NtGdiDdRenderMoComp",
    "NtGdiDdResetVisrgn",
    "NtGdiDdSetColorKey",
    "NtGdiDdSetExclusiveMode",
    "NtGdiDdSetGammaRamp",
    "NtGdiDdCreateSurfaceEx",
    "NtGdiDdSetOverlayPosition",
    "NtGdiDdUnattachSurface",
    "NtGdiDdUnlock",
    "NtGdiDdUnlockD3D",
    "NtGdiDdUpdateOverlay",
    "NtGdiDdWaitForVerticalBlank",
    "NtGdiDvpCanCreateVideoPort",
    "NtGdiDvpColorControl",
    "NtGdiDvpCreateVideoPort",
    "NtGdiDvpDestroyVideoPort",
    "NtGdiDvpFlipVideoPort",
    "NtGdiDvpGetVideoPortBandwidth",
    "NtGdiDvpGetVideoPortField",
    "NtGdiDvpGetVideoPortFlipStatus",
    "NtGdiDvpGetVideoPortInputFormats",
    "NtGdiDvpGetVideoPortLine",
    "NtGdiDvpGetVideoPortOutputFormats",
    "NtGdiDvpGetVideoPortConnectInfo",
    "NtGdiDvpGetVideoSignalStatus",
    "NtGdiDvpUpdateVideoPort",
    "NtGdiDvpWaitForVideoPortSync",
    "NtGdiDvpAcquireNotification",
    "NtGdiDvpReleaseNotification",
    "NtGdiDxgGenericThunk",
    "NtGdiDeleteClientObj",
    "NtGdiDeleteColorSpace",
    "NtGdiDeleteColorTransform",
    "NtGdiDeleteObjectApp",
    "NtGdiDescribePixelFormat",
    "NtGdiDestroyOPMProtectedOutput",
    "NtGdiGetPerBandInfo",
    "NtGdiDoBanding",
    "NtGdiDoPalette",
    "NtGdiDrawEscape",
    "NtGdiEllipse",
    "NtGdiEnableEudc",
    "NtGdiEndDoc",
    "NtGdiEndGdiRendering",
    "NtGdiEndPage",
    "NtGdiEndPath",
    "NtGdiEnumFonts",
    "NtGdiEnumObjects",
    "NtGdiEqualRgn",
    "NtGdiEudcLoadUnloadLink",
    "NtGdiExcludeClipRect",
    "NtGdiExtCreatePen",
    "NtGdiExtCreateRegion",
    "NtGdiExtEscape",
    "NtGdiExtFloodFill",
    "NtGdiExtGetObjectW",
    "NtGdiExtSelectClipRgn",
    "NtGdiExtTextOutW",
    "NtGdiFillPath",
    "NtGdiFillRgn",
    "NtGdiFlattenPath",
    "NtGdiFlush",
    "NtGdiForceUFIMapping",
    "NtGdiFrameRgn",
    "NtGdiFullscreenControl",
    "NtGdiGetAndSetDCDword",
    "NtGdiGetAppClipBox",
    "NtGdiGetBitmapBits",
    "NtGdiGetBitmapDimension",
    "NtGdiGetBoundsRect",
    "NtGdiGetCertificate",
    "NtGdiGetCertificateSize",
    "NtGdiGetCharABCWidthsW",
    "NtGdiGetCharacterPlacementW",
    "NtGdiGetCharSet",
    "NtGdiGetCharWidthW",
    "NtGdiGetCharWidthInfo",
    "NtGdiGetColorAdjustment",
    "NtGdiGetColorSpaceforBitmap",
    "NtGdiGetCOPPCompatibleOPMInformation",
    "NtGdiGetDCDword",
    "NtGdiGetDCforBitmap",
    "NtGdiGetDCObject",
    "NtGdiGetDCPoint",
    "NtGdiGetDeviceCaps",
    "NtGdiGetDeviceGammaRamp",
    "NtGdiGetDeviceCapsAll",
    "NtGdiGetDIBitsInternal",
    "NtGdiGetETM",
    "NtGdiGetEudcTimeStampEx",
    "NtGdiGetFontData",
    "NtGdiGetFontFileData",
    "NtGdiGetFontFileInfo",
    "NtGdiGetFontResourceInfoInternalW",
    "NtGdiGetGlyphIndicesW",
    "NtGdiGetGlyphIndicesWInternal",
    "NtGdiGetGlyphOutline",
    "NtGdiGetOPMInformation",
    "NtGdiGetKerningPairs",
    "NtGdiGetLinkedUFIs",
    "NtGdiGetMiterLimit",
    "NtGdiGetMonitorID",
    "NtGdiGetNearestColor",
    "NtGdiGetNearestPaletteIndex",
    "NtGdiGetObjectBitmapHandle",
    "NtGdiGetOPMRandomNumber",
    "NtGdiGetOutlineTextMetricsInternalW",
    "NtGdiGetPath",
    "NtGdiGetPixel",
    "NtGdiGetRandomRgn",
    "NtGdiGetRasterizerCaps",
    "NtGdiGetRealizationInfo",
    "NtGdiGetRegionData",
    "NtGdiGetRgnBox",
    "NtGdiGetServerMetaFileBits",
    "DxgStubDvpFlipVideoPort",
    "NtGdiGetStats",
    "NtGdiGetStockObject",
    "NtGdiGetStringBitmapW",
    "NtGdiGetSuggestedOPMProtectedOutputArraySize",
    "NtGdiGetSystemPaletteUse",
    "NtGdiGetTextCharsetInfo",
    "NtGdiGetTextExtent",
    "NtGdiGetTextExtentExW",
    "NtGdiGetTextFaceW",
    "NtGdiGetTextMetricsW",
    "NtGdiGetTransform",
    "NtGdiGetUFI",
    "NtGdiGetEmbUFI",
    "NtGdiGetUFIPathname",
    "NtGdiGetEmbedFonts",
    "NtGdiChangeGhostFont",
    "NtGdiAddEmbFontToDC",
    "NtGdiGetFontUnicodeRanges",
    "NtGdiGetWidthTable",
    "NtGdiGradientFill",
    "NtGdiHfontCreate",
    "NtGdiIcmBrushInfo",
    "IsIMMEnabledSystem",
    "NtGdiInitSpool",
    "NtGdiIntersectClipRect",
    "NtGdiInvertRgn",
    "NtGdiLineTo",
    "NtGdiMakeFontDir",
    "NtGdiMakeInfoDC",
    "NtGdiMaskBlt",
    "NtGdiModifyWorldTransform",
    "NtGdiMonoBitmap",
    "NtGdiMoveTo",
    "NtGdiOffsetClipRgn",
    "NtGdiOffsetRgn",
    "NtGdiOpenDCW",
    "NtGdiPatBlt",
    "NtGdiPolyPatBlt",
    "NtGdiPathToRegion",
    "NtGdiPlgBlt",
    "NtGdiPolyDraw",
    "NtGdiPolyPolyDraw",
    "NtGdiPolyTextOutW",
    "NtGdiPtInRegion",
    "NtGdiPtVisible",
    "NtGdiQueryFonts",
    "NtGdiQueryFontAssocInfo",
    "NtGdiRectangle",
    "NtGdiRectInRegion",
    "NtGdiRectVisible",
    "NtGdiRemoveFontResourceW",
    "NtGdiRemoveFontMemResourceEx",
    "NtGdiResetDC",
    "NtGdiResizePalette",
    "NtGdiRestoreDC",
    "NtGdiRoundRect",
    "NtGdiSaveDC",
    "NtGdiScaleViewportExtEx",
    "NtGdiScaleWindowExtEx",
    "NtGdiSelectBitmap",
    "NtGdiSelectBrush",
    "NtGdiSelectClipPath",
    "NtGdiSelectFont",
    "NtGdiSelectPen",
    "NtGdiSetBitmapAttributes",
    "NtGdiSetBitmapBits",
    "NtGdiSetBitmapDimension",
    "NtGdiSetBoundsRect",
    "DxgStubColorControl",
    "NtGdiSetBrushOrg",
    "NtGdiSetColorAdjustment",
    "NtGdiSetColorSpace",
    "NtGdiSetDeviceGammaRamp",
    "NtGdiSetDIBitsToDeviceInternal",
    "NtGdiSetFontEnumeration",
    "NtGdiSetFontXform",
    "NtGdiSetIcmMode",
    "NtGdiSetLinkedUFIs",
    "NtGdiSetMagicColors",
    "NtGdiSetMetaRgn",
    "NtGdiSetMiterLimit",
    "NtGdiGetDeviceWidth",
    "NtGdiMirrorWindowOrg",
    "NtGdiSetLayout",
    "NtGdiSetOPMSigningKeyAndSequenceNumbers",
    "NtGdiSetPixel",
    "NtGdiSetPixelFormat",
    "NtGdiSetRectRgn",
    "NtGdiSetSystemPaletteUse",
    "NtGdiSetTextJustification",
    "NtGdiSetVirtualResolution",
    "NtGdiSetSizeDevice",
    "NtGdiStartDoc",
    "NtGdiStartPage",
    "NtGdiStretchBlt",
    "NtGdiStretchDIBitsInternal",
    "NtGdiStrokeAndFillPath",
    "NtGdiStrokePath",
    "NtGdiSwapBuffers",
    "NtGdiTransformPoints",
    "NtGdiTransparentBlt",
    "DxgStubColorControl",
    "NtGdiUnmapMemFont",
    "NtGdiUnrealizeObject",
    "NtGdiUpdateColors",
    "NtGdiWidenPath",
    "NtUserActivateKeyboardLayout",
    "NtUserAddClipboardFormatListener",
    "NtUserAlterWindowStyle",
    "NtUserAssociateInputContext",
    "NtUserAttachThreadInput",
    "NtUserBeginPaint",
    "NtUserBitBltSysBmp",
    "NtUserBlockInput",
    "NtUserBuildHimcList",
    "NtUserBuildHwndList",
    "NtUserBuildNameList",
    "NtUserBuildPropList",
    "NtUserCallHwnd",
    "NtUserCallHwndLock",
    "NtUserCallHwndOpt",
    "NtUserCallHwndParam",
    "NtUserCallHwndParamLock",
    "NtUserCallMsgFilter",
    "NtUserCallNextHookEx",
    "NtUserCallNoParam",
    "NtUserCallOneParam",
    "NtUserCallTwoParam",
    "NtUserChangeClipboardChain",
    "NtUserChangeDisplaySettings",
    "NtUserGetDisplayConfigBufferSizes",
    "NtUserSetDisplayConfig",
    "NtUserQueryDisplayConfig",
    "NtUserDisplayConfigGetDeviceInfo",
    "NtUserDisplayConfigSetDeviceInfo",
    "NtUserCheckAccessForIntegrityLevel",
    "NtUserCheckDesktopByThreadId",
    "NtUserCheckWindowThreadDesktop",
    "NtUserCheckMenuItem",
    "NtUserChildWindowFromPointEx",
    "NtUserClipCursor",
    "NtUserCloseClipboard",
    "NtUserCloseDesktop",
    "NtUserCloseWindowStation",
    "NtUserConsoleControl",
    "NtUserConvertMemHandle",
    "NtUserCopyAcceleratorTable",
    "NtUserCountClipboardFormats",
    "NtUserCreateAcceleratorTable",
    "NtUserCreateCaret",
    "NtUserCreateDesktopEx",
    "NtUserCreateInputContext",
    "NtUserCreateLocalMemHandle",
    "NtUserCreateWindowEx",
    "NtUserCreateWindowStation",
    "NtUserDdeInitialize",
    "NtUserDeferWindowPos",
    "NtUserDefSetText",
    "NtUserDeleteMenu",
    "NtUserDestroyAcceleratorTable",
    "NtUserDestroyCursor",
    "NtUserDestroyInputContext",
    "NtUserDestroyMenu",
    "NtUserDestroyWindow",
    "NtUserDisableThreadIme",
    "NtUserDispatchMessage",
    "NtUserDoSoundConnect",
    "NtUserDoSoundDisconnect",
    "NtUserDragDetect",
    "NtUserDragObject",
    "NtUserDrawAnimatedRects",
    "NtUserDrawCaption",
    "NtUserDrawCaptionTemp",
    "NtUserDrawIconEx",
    "NtUserDrawMenuBarTemp",
    "NtUserEmptyClipboard",
    "NtUserEnableMenuItem",
    "NtUserEnableScrollBar",
    "NtUserEndDeferWindowPosEx",
    "NtUserEndMenu",
    "NtUserEndPaint",
    "NtUserEnumDisplayDevices",
    "NtUserEnumDisplayMonitors",
    "NtUserEnumDisplaySettings",
    "NtUserEvent",
    "NtUserExcludeUpdateRgn",
    "NtUserFillWindow",
    "NtUserFindExistingCursorIcon",
    "NtUserFindWindowEx",
    "NtUserFlashWindowEx",
    "NtUserFrostCrashedWindow",
    "NtUserGetAltTabInfo",
    "NtUserGetAncestor",
    "NtUserGetAppImeLevel",
    "NtUserGetAsyncKeyState",
    "NtUserGetAtomName",
    "NtUserGetCaretBlinkTime",
    "NtUserGetCaretPos",
    "NtUserGetClassInfoEx",
    "NtUserGetClassName",
    "NtUserGetClipboardData",
    "NtUserGetClipboardFormatName",
    "NtUserGetClipboardOwner",
    "NtUserGetClipboardSequenceNumber",
    "NtUserGetClipboardViewer",
    "NtUserGetClipCursor",
    "NtUserGetComboBoxInfo",
    "NtUserGetControlBrush",
    "NtUserGetControlColor",
    "NtUserGetCPD",
    "NtUserGetCursorFrameInfo",
    "NtUserGetCursorInfo",
    "NtUserGetDC",
    "NtUserGetDCEx",
    "NtUserGetDoubleClickTime",
    "NtUserGetForegroundWindow",
    "NtUserGetGuiResources",
    "NtUserGetGUIThreadInfo",
    "NtUserGetIconInfo",
    "NtUserGetIconSize",
    "NtUserGetImeHotKey",
    "NtUserGetImeInfoEx",
    "NtUserGetInputLocaleInfo",
    "NtUserGetInternalWindowPos",
    "NtUserGetKeyboardLayoutList",
    "NtUserGetKeyboardLayoutName",
    "NtUserGetKeyboardState",
    "NtUserGetKeyNameText",
    "NtUserGetKeyState",
    "NtUserGetListBoxInfo",
    "NtUserGetMenuBarInfo",
    "NtUserGetMenuIndex",
    "NtUserGetMenuItemRect",
    "NtUserGetMessage",
    "NtUserGetMouseMovePointsEx",
    "NtUserGetObjectInformation",
    "NtUserGetOpenClipboardWindow",
    "NtUserGetPriorityClipboardFormat",
    "NtUserGetProcessWindowStation",
    "NtUserGetRawInputBuffer",
    "NtUserGetRawInputData",
    "NtUserGetRawInputDeviceInfo",
    "NtUserGetRawInputDeviceList",
    "NtUserGetRegisteredRawInputDevices",
    "NtUserGetScrollBarInfo",
    "NtUserGetSystemMenu",
    "NtUserGetThreadDesktop",
    "NtUserGetThreadState",
    "NtUserGetTitleBarInfo",
    "NtUserGetTopLevelWindow",
    "NtUserGetUpdatedClipboardFormats",
    "NtUserGetUpdateRect",
    "NtUserGetUpdateRgn",
    "NtUserGetWindowCompositionInfo",
    "NtUserGetWindowCompositionAttribute",
    "NtUserGetWindowDC",
    "NtUserGetWindowDisplayAffinity",
    "NtUserGetWindowPlacement",
    "NtUserGetWOWClass",
    "NtUserGhostWindowFromHungWindow",
    "NtUserHardErrorControl",
    "NtUserHideCaret",
    "NtUserHiliteMenuItem",
    "NtUserHungWindowFromGhostWindow",
    "NtUserImpersonateDdeClientWindow",
    "NtUserInitialize",
    "NtUserInitializeClientPfnArrays",
    "NtUserInitTask",
    "NtUserInternalGetWindowText",
    "NtUserInternalGetWindowIcon",
    "NtUserInvalidateRect",
    "NtUserInvalidateRgn",
    "NtUserIsClipboardFormatAvailable",
    "NtUserIsTopLevelWindow",
    "NtUserKillTimer",
    "NtUserLoadKeyboardLayoutEx",
    "NtUserLockWindowStation",
    "NtUserLockWindowUpdate",
    "NtUserLockWorkStation",
    "NtUserLogicalToPhysicalPoint",
    "NtUserMapVirtualKeyEx",
    "NtUserMenuItemFromPoint",
    "NtUserMessageCall",
    "NtUserMinMaximize",
    "NtUserMNDragLeave",
    "NtUserMNDragOver",
    "NtUserModifyUserStartupInfoFlags",
    "NtUserMoveWindow",
    "NtUserNotifyIMEStatus",
    "NtUserNotifyProcessCreate",
    "NtUserNotifyWinEvent",
    "NtUserOpenClipboard",
    "NtUserOpenDesktop",
    "NtUserOpenInputDesktop",
    "NtUserOpenThreadDesktop",
    "NtUserOpenWindowStation",
    "NtUserPaintDesktop",
    "NtUserPaintMonitor",
    "NtUserPeekMessage",
    "NtUserPhysicalToLogicalPoint",
    "NtUserPostMessage",
    "NtUserPostThreadMessage",
    "NtUserPrintWindow",
    "NtUserProcessConnect",
    "NtUserQueryInformationThread",
    "NtUserQueryInputContext",
    "NtUserQuerySendMessage",
    "NtUserQueryWindow",
    "NtUserRealChildWindowFromPoint",
    "NtUserRealInternalGetMessage",
    "NtUserRealWaitMessageEx",
    "NtUserRedrawWindow",
    "NtUserRegisterClassExWOW",
    "NtUserRegisterErrorReportingDialog",
    "NtUserRegisterUserApiHook",
    "NtUserRegisterHotKey",
    "NtUserRegisterRawInputDevices",
    "NtUserRegisterServicesProcess",
    "NtUserRegisterTasklist",
    "NtUserRegisterWindowMessage",
    "NtUserRemoveClipboardFormatListener",
    "NtUserRemoveMenu",
    "NtUserRemoveProp",
    "NtUserResolveDesktopForWOW",
    "NtUserSBGetParms",
    "NtUserScrollDC",
    "NtUserScrollWindowEx",
    "NtUserSelectPalette",
    "NtUserSendInput",
    "NtUserSetActiveWindow",
    "NtUserSetAppImeLevel",
    "NtUserSetCapture",
    "NtUserSetChildWindowNoActivate",
    "NtUserSetClassLong",
    "NtUserSetClassWord",
    "NtUserSetClipboardData",
    "NtUserSetClipboardViewer",
    "NtUserSetCursor",
    "NtUserSetCursorContents",
    "NtUserSetCursorIconData",
    "NtUserSetFocus",
    "NtUserSetImeHotKey",
    "NtUserSetImeInfoEx",
    "NtUserSetImeOwnerWindow",
    "NtUserSetInformationThread",
    "NtUserSetInternalWindowPos",
    "NtUserSetKeyboardState",
    "NtUserSetMenu",
    "NtUserSetMenuContextHelpId",
    "NtUserSetMenuDefaultItem",
    "NtUserSetMenuFlagRtoL",
    "NtUserSetObjectInformation",
    "NtUserSetParent",
    "NtUserSetProcessWindowStation",
    "NtUserGetProp",
    "NtUserSetProp",
    "NtUserSetScrollInfo",
    "NtUserSetShellWindowEx",
    "NtUserSetSysColors",
    "NtUserSetSystemCursor",
    "NtUserSetSystemMenu",
    "NtUserSetSystemTimer",
    "NtUserSetThreadDesktop",
    "NtUserSetThreadLayoutHandles",
    "NtUserSetThreadState",
    "NtUserSetTimer",
    "NtUserSetProcessDPIAware",
    "NtUserSetWindowCompositionAttribute",
    "NtUserSetWindowDisplayAffinity",
    "NtUserSetWindowFNID",
    "NtUserSetWindowLong",
    "NtUserSetWindowPlacement",
    "NtUserSetWindowPos",
    "NtUserSetWindowRgn",
    "NtUserGetWindowRgnEx",
    "NtUserSetWindowRgnEx",
    "NtUserSetWindowsHookAW",
    "NtUserSetWindowsHookEx",
    "NtUserSetWindowStationUser",
    "NtUserSetWindowWord",
    "NtUserSetWinEventHook",
    "NtUserShowCaret",
    "NtUserShowScrollBar",
    "NtUserShowWindow",
    "NtUserShowWindowAsync",
    "NtUserSoundSentry",
    "NtUserSwitchDesktop",
    "NtUserSystemParametersInfo",
    "NtUserTestForInteractiveUser",
    "NtUserThunkedMenuInfo",
    "NtUserThunkedMenuItemInfo",
    "NtUserToUnicodeEx",
    "NtUserTrackMouseEvent",
    "NtUserTrackPopupMenuEx",
    "NtUserCalculatePopupWindowPosition",
    "NtUserCalcMenuBar",
    "NtUserPaintMenuBar",
    "NtUserTranslateAccelerator",
    "NtUserTranslateMessage",
    "NtUserUnhookWindowsHookEx",
    "NtUserUnhookWinEvent",
    "NtUserUnloadKeyboardLayout",
    "NtUserUnlockWindowStation",
    "NtUserUnregisterClass",
    "NtUserUnregisterUserApiHook",
    "NtUserUnregisterHotKey",
    "NtUserUpdateInputContext",
    "NtUserUpdateInstance",
    "NtUserUpdateLayeredWindow",
    "NtUserGetLayeredWindowAttributes",
    "NtUserSetLayeredWindowAttributes",
    "NtUserUpdatePerUserSystemParameters",
    "NtUserUserHandleGrantAccess",
    "NtUserValidateHandleSecure",
    "NtUserValidateRect",
    "NtUserValidateTimerCallback",
    "NtUserVkKeyScanEx",
    "NtUserWaitForInputIdle",
    "NtUserWaitForMsgAndEvent",
    "NtUserWaitMessage",
    "NtUserWindowFromPhysicalPoint",
    "NtUserWindowFromPoint",
    "NtUserYieldTask",
    "NtUserRemoteConnect",
    "NtUserRemoteRedrawRectangle",
    "NtUserRemoteRedrawScreen",
    "NtUserRemoteStopScreenUpdates",
    "NtUserCtxDisplayIOCtl",
    "NtUserRegisterSessionPort",
    "NtUserUnregisterSessionPort",
    "NtUserUpdateWindowTransform",
    "NtUserDwmStartRedirection",
    "NtUserDwmStopRedirection",
    "NtUserGetWindowMinimizeRect",
    "NtUserSfmDxBindSwapChain",
    "NtUserSfmDxOpenSwapChain",
    "NtUserSfmDxReleaseSwapChain",
    "NtUserSfmDxSetSwapChainBindingStatus",
    "NtUserSfmDxQuerySwapChainBindingStatus",
    "NtUserSfmDxReportPendingBindingsToDwm",
    "NtUserSfmDxGetSwapChainStats",
    "NtUserSfmDxSetSwapChainStats",
    "NtUserSfmGetLogicalSurfaceBinding",
    "NtUserSfmDestroyLogicalSurfaceBinding",
    "NtUserModifyWindowTouchCapability",
    "NtUserIsTouchWindow",
    "NtUserSendTouchInput",
    "NtUserEndTouchOperation",
    "NtUserGetTouchInputInfo",
    "NtUserChangeWindowMessageFilterEx",
    "NtUserInjectGesture",
    "NtUserGetGestureInfo",
    "NtUserGetGestureExtArgs",
    "NtUserManageGestureHandlerWindow",
    "NtUserSetGestureConfig",
    "NtUserGetGestureConfig",
    "NtGdiEngAssociateSurface",
    "NtGdiEngCreateBitmap",
    "NtGdiEngCreateDeviceSurface",
    "NtGdiEngCreateDeviceBitmap",
    "NtGdiEngCreatePalette",
    "NtGdiEngComputeGlyphSet",
    "NtGdiEngCopyBits",
    "NtGdiEngDeletePalette",
    "NtGdiEngDeleteSurface",
    "NtGdiEngEraseSurface",
    "NtGdiEngUnlockSurface",
    "NtGdiEngLockSurface",
    "NtGdiEngBitBlt",
    "NtGdiEngStretchBlt",
    "NtGdiEngPlgBlt",
    "NtGdiEngMarkBandingSurface",
    "NtGdiEngStrokePath",
    "NtGdiEngFillPath",
    "NtGdiEngStrokeAndFillPath",
    "NtGdiEngPaint",
    "NtGdiEngLineTo",
    "NtGdiEngAlphaBlend",
    "NtGdiEngGradientFill",
    "NtGdiEngTransparentBlt",
    "NtGdiEngTextOut",
    "NtGdiEngStretchBltROP",
    "NtGdiXLATEOBJ_cGetPalette",
    "NtGdiXLATEOBJ_iXlate",
    "NtGdiXLATEOBJ_hGetColorTransform",
    "NtGdiCLIPOBJ_bEnum",
    "NtGdiCLIPOBJ_cEnumStart",
    "NtGdiCLIPOBJ_ppoGetPath",
    "NtGdiEngDeletePath",
    "NtGdiEngCreateClip",
    "NtGdiEngDeleteClip",
    "NtGdiBRUSHOBJ_ulGetBrushColor",
    "NtGdiBRUSHOBJ_pvAllocRbrush",
    "NtGdiBRUSHOBJ_pvGetRbrush",
    "NtGdiBRUSHOBJ_hGetColorTransform",
    "NtGdiXFORMOBJ_bApplyXform",
    "NtGdiXFORMOBJ_iGetXform",
    "NtGdiFONTOBJ_vGetInfo",
    "NtGdiFONTOBJ_pxoGetXform",
    "NtGdiFONTOBJ_cGetGlyphs",
    "NtGdiFONTOBJ_pifi",
    "NtGdiFONTOBJ_pfdg",
    "NtGdiFONTOBJ_pQueryGlyphAttrs",
    "NtGdiFONTOBJ_pvTrueTypeFontFile",
    "NtGdiFONTOBJ_cGetAllGlyphHandles",
    "NtGdiSTROBJ_bEnum",
    "NtGdiSTROBJ_bEnumPositionsOnly",
    "NtGdiSTROBJ_bGetAdvanceWidths",
    "NtGdiSTROBJ_vEnumStart",
    "NtGdiSTROBJ_dwGetCodePage",
    "NtGdiPATHOBJ_vGetBounds",
    "NtGdiPATHOBJ_bEnum",
    "NtGdiPATHOBJ_vEnumStart",
    "NtGdiPATHOBJ_vEnumStartClipLines",
    "NtGdiPATHOBJ_bEnumClipLines",
    "NtGdiGetDhpdev",
    "NtGdiEngCheckAbort",
    "NtGdiHT_Get8BPPFormatPalette",
    "NtGdiHT_Get8BPPMaskPalette",
    "NtGdiUpdateTransform",
    "NtGdiSetPUMPDOBJ",
    "NtGdiBRUSHOBJ_DeleteRbrush",
    "NtGdiUnmapMemFont",
    "NtGdiDrawStream",
    "NtGdiSfmGetNotificationTokens",
    "NtGdiHLSurfGetInformation",
    "NtGdiHLSurfSetInformation",
    "NtGdiDdDDICreateAllocation",
    "NtGdiDdDDIQueryResourceInfo",
    "NtGdiDdDDIOpenResource",
    "NtGdiDdDDIDestroyAllocation",
    "NtGdiDdDDISetAllocationPriority",
    "NtGdiDdDDIQueryAllocationResidency",
    "NtGdiDdDDICreateDevice",
    "NtGdiDdDDIDestroyDevice",
    "NtGdiDdDDICreateContext",
    "NtGdiDdDDIDestroyContext",
    "NtGdiDdDDICreateSynchronizationObject",
    "NtGdiDdDDIOpenSynchronizationObject",
    "NtGdiDdDDIDestroySynchronizationObject",
    "NtGdiDdDDIWaitForSynchronizationObject",
    "NtGdiDdDDISignalSynchronizationObject",
    "NtGdiDdDDIGetRuntimeData",
    "NtGdiDdDDIQueryAdapterInfo",
    "NtGdiDdDDILock",
    "NtGdiDdDDIUnlock",
    "NtGdiDdDDIGetDisplayModeList",
    "NtGdiDdDDISetDisplayMode",
    "NtGdiDdDDIGetMultisampleMethodList",
    "NtGdiDdDDIPresent",
    "NtGdiDdDDIRender",
    "NtGdiDdDDIOpenAdapterFromDeviceName",
    "NtGdiDdDDIOpenAdapterFromHdc",
    "NtGdiDdDDICloseAdapter",
    "NtGdiDdDDIGetSharedPrimaryHandle",
    "NtGdiDdDDIEscape",
    "NtGdiDdDDIQueryStatistics",
    "NtGdiDdDDISetVidPnSourceOwner",
    "NtGdiDdDDIGetPresentHistory",
    "NtGdiDdDDIGetPresentQueueEvent",
    "NtGdiDdDDICreateOverlay",
    "NtGdiDdDDIUpdateOverlay",
    "NtGdiDdDDIFlipOverlay",
    "NtGdiDdDDIDestroyOverlay",
    "NtGdiDdDDIWaitForVerticalBlankEvent",
    "NtGdiDdDDISetGammaRamp",
    "NtGdiDdDDIGetDeviceState",
    "NtGdiDdDDICreateDCFromMemory",
    "NtGdiDdDDIDestroyDCFromMemory",
    "NtGdiDdDDISetContextSchedulingPriority",
    "NtGdiDdDDIGetContextSchedulingPriority",
    "NtGdiDdDDISetProcessSchedulingPriorityClass",
    "NtGdiDdDDIGetProcessSchedulingPriorityClass",
    "NtGdiDdDDIReleaseProcessVidPnSourceOwners",
    "NtGdiDdDDIGetScanLine",
    "NtGdiDdDDISetQueuedLimit",
    "NtGdiDdDDIPollDisplayChildren",
    "NtGdiDdDDIInvalidateActiveVidPn",
    "NtGdiDdDDICheckOcclusion",
    "NtGdiDdDDIWaitForIdle",
    "NtGdiDdDDICheckMonitorPowerState",
    "NtGdiDdDDICheckExclusiveOwnership",
    "NtGdiDdDDISetDisplayPrivateDriverFormat",
    "NtGdiDdDDISharedPrimaryLockNotification",
    "NtGdiDdDDISharedPrimaryUnLockNotification",
    "NtGdiDdDDICreateKeyedMutex",
    "NtGdiDdDDIOpenKeyedMutex",
    "NtGdiDdDDIDestroyKeyedMutex",
    "NtGdiDdDDIAcquireKeyedMutex",
    "NtGdiDdDDIReleaseKeyedMutex",
    "NtGdiDdDDIConfigureSharedResource",
    "NtGdiDdDDIGetOverlayState",
    "NtGdiDdDDICheckVidPnExclusiveOwnership",
    "NtGdiDdDDICheckSharedResourceAccess",
    "DxgStubColorControl",
    "DxgStubValidateTextureStageState",
    "NtGdiGetNumberOfPhysicalMonitors",
    "NtGdiGetPhysicalMonitors",
    "NtGdiGetPhysicalMonitorDescription",
    "NtGdiDestroyPhysicalMonitor",
    "NtGdiDDCCIGetVCPFeature",
    "NtGdiDDCCISetVCPFeature",
    "NtGdiDDCCISaveCurrentSettings",
    "NtGdiDDCCIGetCapabilitiesStringLength",
    "NtGdiDDCCIGetCapabilitiesString",
    "NtGdiDDCCIGetTimingReport",
    "NtGdiDdCreateFullscreenSprite",
    "NtGdiDdNotifyFullscreenSpriteUpdate",
    "NtGdiDdDestroyFullscreenSprite",
    "DxEngVisRgnUniq",
    "NtUserSetMirrorRendering",
    "NtUserShowSystemCursor",
    "NtUserMagControl",
    "NtUserMagSetContextInformation",
    "NtUserMagGetContextInformation",
    "NtUserHwndQueryRedirectionInfo",
    "NtUserHwndSetRedirectionInfo"
};

//////////////////////////////////////////////////////////////////////////
// Windows 8 SP0 _W32pServiceTable
//////////////////////////////////////////////////////////////////////////
static const char* W32pServiceTable_Win8Sp0_x86[] = {
    "NtUserYieldTask",
    "NtGdiWidenPath",
    "NtGdiUpdateColors",
    "NtGdiUnrealizeObject",
    "NtGdiUnmapMemFont",
    "UMPDDrvQuerySpoolType",
    "NtGdiTransparentBlt",
    "NtGdiTransformPoints",
    "NtGdiSwapBuffers",
    "NtGdiStrokePath",
    "NtGdiStrokeAndFillPath",
    "NtGdiStretchDIBitsInternal",
    "NtGdiStretchBlt",
    "NtGdiStartPage",
    "NtGdiStartDoc",
    "NtGdiSetSizeDevice",
    "NtGdiSetVirtualResolution",
    "NtGdiSetTextJustification",
    "NtGdiSetSystemPaletteUse",
    "NtGdiSetRectRgn",
    "NtGdiSetPixelFormat",
    "NtGdiSetPixel",
    "NtGdiSetOPMSigningKeyAndSequenceNumbers",
    "NtGdiSetLayout",
    "NtGdiMirrorWindowOrg",
    "NtGdiGetDeviceWidth",
    "NtGdiSetMiterLimit",
    "NtGdiSetMetaRgn",
    "NtGdiSetMagicColors",
    "NtGdiSetLinkedUFIs",
    "NtGdiSetIcmMode",
    "NtGdiSetFontXform",
    "NtGdiSetFontEnumeration",
    "NtGdiSetDIBitsToDeviceInternal",
    "NtGdiSetDeviceGammaRamp",
    "NtGdiSetColorSpace",
    "NtGdiSetColorAdjustment",
    "NtGdiSetBrushOrg",
    "NtGdiSetBrushAttributes",
    "NtGdiSetBoundsRect",
    "NtGdiSetBitmapDimension",
    "NtGdiSetBitmapBits",
    "NtGdiSetBitmapAttributes",
    "NtGdiSelectPen",
    "NtGdiSelectFont",
    "NtGdiSelectClipPath",
    "NtGdiSelectBrush",
    "NtGdiSelectBitmap",
    "NtGdiScaleWindowExtEx",
    "NtGdiScaleViewportExtEx",
    "NtGdiSaveDC",
    "NtGdiRoundRect",
    "NtGdiRestoreDC",
    "NtGdiResizePalette",
    "NtGdiResetDC",
    "NtGdiRemoveFontMemResourceEx",
    "NtGdiRemoveFontResourceW",
    "NtGdiRectVisible",
    "NtGdiRectInRegion",
    "NtGdiRectangle",
    "NtGdiQueryFontAssocInfo",
    "NtGdiQueryFonts",
    "NtGdiPtVisible",
    "NtGdiPtInRegion",
    "NtGdiPolyTextOutW",
    "NtGdiPolyPolyDraw",
    "NtGdiPolyDraw",
    "NtGdiPlgBlt",
    "NtGdiPathToRegion",
    "NtGdiPolyPatBlt",
    "NtGdiPatBlt",
    "NtGdiOpenDCW",
    "NtGdiOffsetRgn",
    "NtGdiOffsetClipRgn",
    "NtGdiMoveTo",
    "NtGdiMonoBitmap",
    "NtGdiModifyWorldTransform",
    "NtGdiMaskBlt",
    "NtGdiMakeInfoDC",
    "NtGdiMakeFontDir",
    "NtGdiLineTo",
    "NtGdiInvertRgn",
    "NtGdiIntersectClipRect",
    "NtGdiInitSpool",
    "CFlipToken::GetModel",
    "NtGdiIcmBrushInfo",
    "NtGdiHfontCreate",
    "NtGdiGradientFill",
    "NtGdiGetWidthTable",
    "NtGdiGetFontUnicodeRanges",
    "NtGdiAddEmbFontToDC",
    "NtGdiChangeGhostFont",
    "NtGdiGetEmbedFonts",
    "NtGdiGetUFIPathname",
    "NtGdiGetEmbUFI",
    "NtGdiGetUFI",
    "NtGdiGetTransform",
    "NtGdiGetTextMetricsW",
    "NtGdiGetTextFaceW",
    "NtGdiGetTextExtentExW",
    "NtGdiGetTextExtent",
    "NtGdiGetTextCharsetInfo",
    "NtGdiGetSystemPaletteUse",
    "NtGdiGetSuggestedOPMProtectedOutputArraySize",
    "NtGdiGetStringBitmapW",
    "NtGdiGetStockObject",
    "NtGdiGetStats",
    "UMPDDrvCreateDeviceBitmap",
    "NtGdiGetServerMetaFileBits",
    "NtGdiGetRgnBox",
    "NtGdiGetRegionData",
    "NtGdiGetRealizationInfo",
    "NtGdiGetRasterizerCaps",
    "NtGdiGetRandomRgn",
    "NtGdiGetPixel",
    "NtGdiGetPath",
    "NtGdiGetOutlineTextMetricsInternalW",
    "NtGdiGetOPMRandomNumber",
    "NtGdiGetObjectBitmapHandle",
    "NtGdiGetNearestPaletteIndex",
    "NtGdiGetNearestColor",
    "NtGdiGetMonitorID",
    "NtGdiGetMiterLimit",
    "NtGdiGetLinkedUFIs",
    "NtGdiGetKerningPairs",
    "NtGdiGetOPMInformation",
    "NtGdiGetGlyphOutline",
    "NtGdiGetGlyphIndicesWInternal",
    "NtGdiGetGlyphIndicesW",
    "NtGdiGetFontResourceInfoInternalW",
    "NtGdiGetFontFileInfo",
    "NtGdiGetFontFileData",
    "NtGdiGetFontData",
    "NtGdiGetEudcTimeStampEx",
    "NtGdiGetETM",
    "NtGdiGetDIBitsInternal",
    "NtGdiGetDeviceCapsAll",
    "NtGdiGetDeviceGammaRamp",
    "NtGdiGetDeviceCaps",
    "NtGdiGetDCPoint",
    "NtGdiGetDCObject",
    "NtGdiGetDCforBitmap",
    "NtGdiGetDCDword",
    "NtGdiGetCOPPCompatibleOPMInformation",
    "NtGdiGetColorSpaceforBitmap",
    "NtGdiGetColorAdjustment",
    "NtGdiGetCharWidthInfo",
    "NtGdiGetCharWidthW",
    "NtGdiGetCharSet",
    "NtGdiGetCharacterPlacementW",
    "NtGdiGetCharABCWidthsW",
    "NtGdiGetCertificateSize",
    "NtGdiGetCertificate",
    "NtGdiGetBoundsRect",
    "NtGdiGetBitmapDimension",
    "NtGdiGetBitmapBits",
    "NtGdiGetAppClipBox",
    "NtGdiGetAndSetDCDword",
    "NtGdiFullscreenControl",
    "NtGdiFrameRgn",
    "NtGdiForceUFIMapping",
    "NtGdiFlush",
    "NtGdiFlattenPath",
    "NtGdiFillRgn",
    "NtGdiFillPath",
    "NtGdiExtTextOutW",
    "NtGdiExtSelectClipRgn",
    "NtGdiExtGetObjectW",
    "NtGdiExtFloodFill",
    "NtGdiExtEscape",
    "NtGdiExtCreateRegion",
    "NtGdiExtCreatePen",
    "NtGdiExcludeClipRect",
    "NtGdiEudcLoadUnloadLink",
    "NtGdiEqualRgn",
    "NtGdiEnumObjects",
    "NtGdiEnumFonts",
    "NtGdiEndPath",
    "NtGdiEndPage",
    "NtGdiEndGdiRendering",
    "NtGdiEndDoc",
    "NtGdiEnableEudc",
    "NtGdiEllipse",
    "NtGdiDrawEscape",
    "NtGdiDoPalette",
    "NtGdiDoBanding",
    "NtGdiGetPerBandInfo",
    "NtGdiDestroyOPMProtectedOutput",
    "NtGdiDescribePixelFormat",
    "NtGdiDeleteObjectApp",
    "NtGdiDeleteColorTransform",
    "NtGdiDeleteColorSpace",
    "NtGdiDeleteClientObj",
    "NtGdiDdCreateSurfaceObject",
    "NtGdiDdAttachSurface",
    "EngAllocPrivateUserMem",
    "NtGdiDdAttachSurface",
    "NtGdiD3dContextCreate",
    "NtGdiDdAttachSurface",
    "NtGdiDdAttachSurface",
    "NtGdiDdAttachSurface",
    "NtGdiDdAttachSurface",
    "NtGdiDdAttachSurface",
    "NtGdiDdAttachSurface",
    "NtGdiDdAttachSurface",
    "NtGdiDdAttachSurface",
    "NtGdiD3dContextCreate",
    "NtGdiDdAttachSurface",
    "NtGdiDdAttachSurface",
    "NtGdiDdAttachSurface",
    "NtGdiDdAttachSurface",
    "NtGdiDdAttachSurface",
    "EngAllocPrivateUserMem",
    "NtGdiDdAttachSurface",
    "NtGdiDdAttachSurface",
    "NtGdiDdUnattachSurface",
    "EngAllocPrivateUserMem",
    "EngAllocPrivateUserMem",
    "EngAllocPrivateUserMem",
    "NtGdiDdAttachSurface",
    "NtGdiDdAttachSurface",
    "NtGdiDdAttachSurface",
    "NtGdiDdAttachSurface",
    "EngLockDirectDrawSurface",
    "NtGdiDdAttachSurface",
    "NtGdiDdAttachSurface",
    "NtGdiDdQueryDirectDrawObject",
    "NtGdiDdAttachSurface",
    "EngAllocPrivateUserMem",
    "NtGdiDdAttachSurface",
    "NtGdiDdAttachSurface",
    "NtGdiDdAttachSurface",
    "NtGdiDdAttachSurface",
    "NtGdiDdAttachSurface",
    "NtGdiDdAttachSurface",
    "EngAllocPrivateUserMem",
    "NtGdiDdAttachSurface",
    "NtGdiDdAttachSurface",
    "NtGdiDdAttachSurface",
    "NtGdiDdAttachSurface",
    "NtGdiDdAttachSurface",
    "HeapVidMemAllocAligned",
    "NtGdiDdAttachSurface",
    "EngLockDirectDrawSurface",
    "NtGdiDdAttachSurface",
    "NtGdiDdAttachSurface",
    "EngLockDirectDrawSurface",
    "EngLockDirectDrawSurface",
    "NtGdiDdCreateSurfaceObject",
    "NtGdiDdAttachSurface",
    "NtGdiDdCreateD3DBuffer",
    "NtGdiDdCreateD3DBuffer",
    "EngLockDirectDrawSurface",
    "NtGdiDdAttachSurface",
    "NtGdiDdAttachSurface",
    "NtGdiDdAttachSurface",
    "EngAllocPrivateUserMem",
    "NtGdiDdAttachSurface",
    "NtGdiDdAttachSurface",
    "EngAllocPrivateUserMem",
    "EngAllocPrivateUserMem",
    "EngLockDirectDrawSurface",
    "NtGdiD3dDrawPrimitives2",
    "EngLockDirectDrawSurface",
    "EngLockDirectDrawSurface",
    "EngLockDirectDrawSurface",
    "NtGdiD3dContextCreate",
    "NtGdiCreateSolidBrush",
    "NtGdiCreateServerMetaFile",
    "NtGdiCreateRoundRectRgn",
    "NtGdiCreateRectRgn",
    "NtGdiCreatePen",
    "NtGdiCreatePatternBrushInternal",
    "NtGdiCreatePaletteInternal",
    "NtGdiCreateOPMProtectedOutputs",
    "NtGdiCreateMetafileDC",
    "NtGdiCreateHatchBrushInternal",
    "NtGdiCreateHalftonePalette",
    "NtGdiCreateEllipticRgn",
    "NtGdiCreateSessionMappedDIBSection",
    "NtGdiCreateDIBSection",
    "NtGdiCreateDIBitmapInternal",
    "NtGdiCreateDIBBrush",
    "NtGdiCreateCompatibleDC",
    "NtGdiCreateCompatibleBitmap",
    "NtGdiCreateColorTransform",
    "NtGdiCreateColorSpace",
    "NtGdiCreateClientObj",
    "NtGdiCreateBitmapFromDxSurface2",
    "NtGdiCreateBitmapFromDxSurface",
    "NtGdiCreateBitmap",
    "NtGdiConvertMetafileRect",
    "NtGdiConfigureOPMProtectedOutput",
    "NtGdiComputeXformCoefficients",
    "NtGdiCombineTransform",
    "NtGdiCombineRgn",
    "NtGdiColorCorrectPalette",
    "NtGdiClearBrushAttributes",
    "NtGdiClearBitmapAttributes",
    "NtGdiCloseFigure",
    "NtGdiCheckBitmapBits",
    "NtGdiCancelDC",
    "NtGdiBitBlt",
    "NtGdiBeginPath",
    "NtGdiBeginGdiRendering",
    "NtGdiArcInternal",
    "NtGdiFontIsLinked",
    "NtGdiAnyLinkedFonts",
    "NtGdiAngleArc",
    "NtGdiAlphaBlend",
    "NtGdiAddRemoteMMInstanceToDC",
    "NtGdiRemoveMergeFont",
    "NtGdiAddFontMemResourceEx",
    "NtGdiAddRemoteFontToDC",
    "NtGdiAddFontResourceW",
    "NtGdiAbortPath",
    "NtGdiAbortDoc",
    "NtUserDefSetText",
    "NtUserDeferWindowPosAndBand",
    "NtUserDdeInitialize",
    "NtUserCanBrokerForceForeground",
    "NtUserCreateWindowStation",
    "NtUserCreateWindowEx",
    "NtUserCreateLocalMemHandle",
    "NtUserCreateInputContext",
    "NtUserCreateDesktopEx",
    "NtUserCreateCaret",
    "NtUserCreateAcceleratorTable",
    "NtUserCountClipboardFormats",
    "NtUserCopyAcceleratorTable",
    "NtUserConvertMemHandle",
    "NtUserConsoleControl",
    "NtUserCloseWindowStation",
    "NtUserCloseDesktop",
    "NtUserCloseClipboard",
    "NtUserClipCursor",
    "NtUserChildWindowFromPointEx",
    "NtUserCheckMenuItem",
    "NtUserCheckWindowThreadDesktop",
    "NtUserDwmValidateWindow",
    "NtUserCheckAccessForIntegrityLevel",
    "NtUserDisplayConfigSetDeviceInfo",
    "NtUserDisplayConfigGetDeviceInfo",
    "NtUserQueryDisplayConfig",
    "NtUserSetDisplayConfig",
    "NtUserGetDisplayConfigBufferSizes",
    "NtUserChangeDisplaySettings",
    "NtUserChangeClipboardChain",
    "NtUserCallTwoParam",
    "NtUserCallOneParam",
    "NtUserCallNoParam",
    "NtUserCallNextHookEx",
    "NtUserCallMsgFilter",
    "NtUserCallHwndParamLock",
    "NtUserCallHwndParam",
    "NtUserCallHwndOpt",
    "NtUserCallHwndLock",
    "NtUserCallHwnd",
    "NtUserBuildPropList",
    "NtUserBuildNameList",
    "NtUserBuildHwndList",
    "NtUserBuildHimcList",
    "NtUserBlockInput",
    "NtUserBitBltSysBmp",
    "NtUserBeginPaint",
    "NtUserAttachThreadInput",
    "NtUserAssociateInputContext",
    "NtUserAlterWindowStyle",
    "NtUserAddClipboardFormatListener",
    "NtUserActivateKeyboardLayout",
    "NtUserDelegateCapturePointers",
    "NtUserDelegateInput",
    "NtUserDispatchMessage",
    "NtUserDisableProcessWindowFiltering",
    "NtUserDisableThreadIme",
    "NtUserDestroyWindow",
    "NtUserDestroyMenu",
    "NtUserDestroyInputContext",
    "NtUserDestroyCursor",
    "NtUserDestroyAcceleratorTable",
    "NtUserDeleteMenu",
    "NtUserDoSoundDisconnect",
    "NtUserDoSoundConnect",
    "NtUserGhostWindowFromHungWindow",
    "NtUserGetWOWClass",
    "NtUserGetWindowPlacement",
    "NtUserGetWindowDisplayAffinity",
    "NtUserGetWindowDC",
    "NtUserGetWindowCompositionAttribute",
    "NtUserGetWindowCompositionInfo",
    "NtUserGetWindowBand",
    "NtUserGetUpdateRgn",
    "NtUserGetUpdateRect",
    "NtUserGetUpdatedClipboardFormats",
    "NtUserGetTopLevelWindow",
    "NtUserGetTitleBarInfo",
    "NtUserGetThreadState",
    "NtUserGetThreadDesktop",
    "NtUserGetSystemMenu",
    "NtUserGetScrollBarInfo",
    "NtUserGetRegisteredRawInputDevices",
    "NtUserGetRawInputDeviceList",
    "NtUserGetRawInputDeviceInfo",
    "NtUserGetRawInputData",
    "NtUserGetRawInputBuffer",
    "NtUserGetProcessWindowStation",
    "NtUserGetPriorityClipboardFormat",
    "NtUserGetOpenClipboardWindow",
    "NtUserGetObjectInformation",
    "NtUserGetMouseMovePointsEx",
    "NtUserGetMessage",
    "NtUserGetMenuItemRect",
    "NtUserGetMenuIndex",
    "NtUserGetMenuBarInfo",
    "NtUserGetListBoxInfo",
    "NtUserGetKeyState",
    "NtUserGetKeyNameText",
    "NtUserGetKeyboardState",
    "NtUserGetKeyboardLayoutName",
    "NtUserGetKeyboardLayoutList",
    "NtUserGetInternalWindowPos",
    "NtUserGetInputLocaleInfo",
    "NtUserGetImeInfoEx",
    "NtUserGetImeHotKey",
    "NtUserGetIconSize",
    "NtUserGetIconInfo",
    "NtUserGetGUIThreadInfo",
    "NtUserGetGuiResources",
    "NtUserGetGlobalIMEStatus",
    "NtUserGetForegroundWindow",
    "NtUserGetDoubleClickTime",
    "NtUserGetDesktopID",
    "NtUserGetDCEx",
    "NtUserGetDC",
    "NtUserGetCursorInfo",
    "NtUserGetCursorFrameInfo",
    "NtUserGetCurrentInputMessageSource",
    "NtUserGetCIMSSM",
    "NtUserGetCPD",
    "NtUserGetControlColor",
    "NtUserGetControlBrush",
    "NtUserGetComboBoxInfo",
    "NtUserGetClipCursor",
    "NtUserGetClipboardViewer",
    "NtUserGetClipboardSequenceNumber",
    "NtUserGetClipboardOwner",
    "NtUserGetClipboardFormatName",
    "NtUserGetClipboardData",
    "NtUserGetClassName",
    "NtUserGetClassInfoEx",
    "NtUserGetCaretPos",
    "NtUserGetCaretBlinkTime",
    "NtUserGetAtomName",
    "NtUserGetAsyncKeyState",
    "NtUserGetAppImeLevel",
    "NtUserGetAncestor",
    "NtUserGetAltTabInfo",
    "NtUserFrostCrashedWindow",
    "NtUserFlashWindowEx",
    "NtUserFindWindowEx",
    "NtUserFindExistingCursorIcon",
    "NtUserFillWindow",
    "NtUserExcludeUpdateRgn",
    "NtUserEvent",
    "NtUserEnumDisplaySettings",
    "NtUserEnumDisplayMonitors",
    "NtUserEnumDisplayDevices",
    "NtUserEndPaint",
    "NtUserEndMenu",
    "NtUserEndDeferWindowPosEx",
    "NtUserEnableScrollBar",
    "NtUserEnableMenuItem",
    "NtUserEmptyClipboard",
    "NtUserDrawMenuBarTemp",
    "NtUserDrawIconEx",
    "NtUserDrawCaptionTemp",
    "NtUserDrawCaption",
    "NtUserDrawAnimatedRects",
    "NtUserDragObject",
    "NtUserDragDetect",
    "NtUserHandleDelegatedInput",
    "NtUserRealChildWindowFromPoint",
    "NtUserQueryWindow",
    "NtUserQuerySendMessage",
    "NtUserQueryInputContext",
    "NtUserQueryInformationThread",
    "NtUserQueryBSDRWindow",
    "NtUserProcessConnect",
    "NtUserPrintWindow",
    "NtUserPostThreadMessage",
    "NtUserPostMessage",
    "NtUserPhysicalToLogicalPoint",
    "NtUserPeekMessage",
    "NtUserPaintMonitor",
    "NtUserPaintDesktop",
    "NtUserOpenWindowStation",
    "NtUserOpenThreadDesktop",
    "NtUserOpenInputDesktop",
    "NtUserOpenDesktop",
    "NtUserOpenClipboard",
    "NtUserNotifyWinEvent",
    "NtUserNotifyProcessCreate",
    "NtUserNotifyIMEStatus",
    "NtUserMoveWindow",
    "NtUserModifyUserStartupInfoFlags",
    "NtUserMNDragOver",
    "NtUserMNDragLeave",
    "NtUserMinMaximize",
    "NtUserMessageCall",
    "NtUserMenuItemFromPoint",
    "NtUserMapVirtualKeyEx",
    "NtUserLayoutCompleted",
    "NtUserLogicalToPhysicalPoint",
    "NtUserLockWorkStation",
    "NtUserLockWindowUpdate",
    "NtUserLockWindowStation",
    "NtUserLoadKeyboardLayoutEx",
    "NtUserKillTimer",
    "NtUserIsTopLevelWindow",
    "NtUserIsClipboardFormatAvailable",
    "NtUserInvalidateRgn",
    "NtUserInvalidateRect",
    "NtUserInternalGetWindowIcon",
    "NtUserInternalGetWindowText",
    "NtUserInitTask",
    "NtUserInitializeClientPfnArrays",
    "NtUserInitialize",
    "NtUserImpersonateDdeClientWindow",
    "NtUserHungWindowFromGhostWindow",
    "NtUserHiliteMenuItem",
    "NtUserHideCaret",
    "NtUserHardErrorControl",
    "NtUserRealInternalGetMessage",
    "NtUserRealWaitMessageEx",
    "NtUserTranslateMessage",
    "NtUserTranslateAccelerator",
    "NtUserPaintMenuBar",
    "NtUserCalcMenuBar",
    "NtUserCalculatePopupWindowPosition",
    "NtUserTrackPopupMenuEx",
    "NtUserTrackMouseEvent",
    "NtUserToUnicodeEx",
    "NtUserThunkedMenuItemInfo",
    "NtUserThunkedMenuInfo",
    "NtUserTestForInteractiveUser",
    "NtUserSendEventMessage",
    "NtUserSystemParametersInfo",
    "NtUserSwitchDesktop",
    "NtUserSoundSentry",
    "NtUserShutdownReasonDestroy",
    "NtUserShutdownBlockReasonQuery",
    "NtUserShutdownBlockReasonCreate",
    "NtUserShowWindowAsync",
    "NtUserShowWindow",
    "NtUserShowScrollBar",
    "NtUserShowCaret",
    "NtUserSetWinEventHook",
    "NtUserSetWindowWord",
    "NtUserSetWindowStationUser",
    "NtUserSetWindowsHookEx",
    "NtUserSetWindowsHookAW",
    "NtUserSetWindowRgnEx",
    "NtUserGetWindowRgnEx",
    "NtUserSetWindowRgn",
    "NtUserSetWindowPos",
    "NtUserSetWindowPlacement",
    "NtUserSetWindowLong",
    "NtUserSetWindowFNID",
    "NtUserSetWindowDisplayAffinity",
    "NtUserSetWindowCompositionTransition",
    "NtUserUpdateDefaultDesktopThumbnail",
    "NtUserSetWindowCompositionAttribute",
    "NtUserSetWindowBand",
    "NtUserSetProcessUIAccessZorder",
    "NtUserSetProcessDPIAware",
    "NtUserSetTimer",
    "NtUserSetThreadState",
    "NtUserSetThreadLayoutHandles",
    "NtUserSetThreadDesktop",
    "NtUserSetThreadInputBlocked",
    "NtUserSetSystemTimer",
    "NtUserSetSystemMenu",
    "NtUserSetSystemCursor",
    "NtUserSetSysColors",
    "NtUserSetShellWindowEx",
    "NtUserSetImmersiveBackgroundWindow",
    "NtUserSetScrollInfo",
    "NtUserSetProp",
    "NtUserGetProp",
    "NtUserSetProcessWindowStation",
    "NtUserSetParent",
    "NtUserSetObjectInformation",
    "NtUserSetMenuFlagRtoL",
    "NtUserSetMenuDefaultItem",
    "NtUserSetMenuContextHelpId",
    "NtUserSetMenu",
    "NtUserSetKeyboardState",
    "NtUserSetInternalWindowPos",
    "NtUserSetInformationThread",
    "NtUserSetImeOwnerWindow",
    "NtUserSetImeInfoEx",
    "NtUserSetImeHotKey",
    "NtUserSetFocus",
    "NtUserSetCursorIconData",
    "NtUserSetCursorContents",
    "NtUserSetCursor",
    "NtUserSetClipboardViewer",
    "NtUserSetClipboardData",
    "NtUserSetClassWord",
    "NtUserSetClassLong",
    "NtUserSetChildWindowNoActivate",
    "NtUserSetCapture",
    "NtUserSetAppImeLevel",
    "NtUserSetActiveWindow",
    "NtUserSendInput",
    "NtUserSelectPalette",
    "NtUserScrollWindowEx",
    "NtUserScrollDC",
    "NtUserSBGetParms",
    "NtUserResolveDesktopForWOW",
    "NtUserRemoveProp",
    "NtUserRemoveMenu",
    "NtUserRemoveClipboardFormatListener",
    "NtUserRegisterWindowMessage",
    "NtUserRegisterTasklist",
    "NtUserRegisterServicesProcess",
    "NtUserRegisterRawInputDevices",
    "NtUserRegisterHotKey",
    "NtUserRegisterUserApiHook",
    "NtUserRegisterErrorReportingDialog",
    "NtUserRegisterClassExWOW",
    "NtUserRegisterBSDRWindow",
    "NtUserRedrawWindow",
    "NtUserUndelegateInput",
    "NtUserGetWindowMinimizeRect",
    "NtUserDwmStopRedirection",
    "NtUserDwmStartRedirection",
    "NtUserDwmGetRemoteSessionOcclusionEvent",
    "NtUserDwmGetRemoteSessionOcclusionState",
    "NtUserUpdateWindowTransform",
    "NtUserCheckProcessSession",
    "NtUserUnregisterSessionPort",
    "NtUserRegisterSessionPort",
    "NtUserCtxDisplayIOCtl",
    "NtUserRemoteStopScreenUpdates",
    "NtUserRemoteRedrawScreen",
    "NtUserRemoteRedrawRectangle",
    "NtUserRemoteConnect",
    "NtUserWaitAvailableMessageEx",
    "NtUserWindowFromPoint",
    "NtUserWindowFromPhysicalPoint",
    "NtUserWaitMessage",
    "NtUserWaitForMsgAndEvent",
    "NtUserWaitForInputIdle",
    "NtUserVkKeyScanEx",
    "NtUserValidateTimerCallback",
    "NtUserValidateRect",
    "NtUserValidateHandleSecure",
    "NtUserUserHandleGrantAccess",
    "NtUserUpdatePerUserSystemParameters",
    "NtUserSetLayeredWindowAttributes",
    "NtUserGetLayeredWindowAttributes",
    "NtUserUpdateLayeredWindow",
    "NtUserUpdateInstance",
    "NtUserUpdateInputContext",
    "NtUserUnregisterHotKey",
    "NtUserUnregisterUserApiHook",
    "NtUserUnregisterClass",
    "NtUserUnlockWindowStation",
    "NtUserUnloadKeyboardLayout",
    "NtUserUnhookWinEvent",
    "NtUserUnhookWindowsHookEx",
    "NtUserGetTouchInputInfo",
    "NtUserIsTouchWindow",
    "NtUserModifyWindowTouchCapability",
    "NtGdiEngStretchBltROP",
    "NtGdiEngTextOut",
    "NtGdiEngTransparentBlt",
    "NtGdiEngGradientFill",
    "NtGdiEngAlphaBlend",
    "NtGdiEngLineTo",
    "NtGdiEngPaint",
    "NtGdiEngStrokeAndFillPath",
    "NtGdiEngFillPath",
    "NtGdiEngStrokePath",
    "NtGdiEngMarkBandingSurface",
    "NtGdiEngPlgBlt",
    "NtGdiEngStretchBlt",
    "NtGdiEngBitBlt",
    "NtGdiEngLockSurface",
    "NtGdiEngUnlockSurface",
    "NtGdiEngEraseSurface",
    "NtGdiEngDeleteSurface",
    "NtGdiEngDeletePalette",
    "NtGdiEngCopyBits",
    "NtGdiEngComputeGlyphSet",
    "NtGdiEngCreatePalette",
    "NtGdiEngCreateDeviceBitmap",
    "NtGdiEngCreateDeviceSurface",
    "NtGdiEngCreateBitmap",
    "NtGdiEngAssociateSurface",
    "NtUserSetWindowFeedbackSetting",
    "NtUserRegisterEdgy",
    "NtUserGetWindowFeedbackSetting",
    "NtUserHidePointerContactVisualization",
    "NtUserGetTouchValidationStatus",
    "NtUserInitializeTouchInjection",
    "NtUserInjectTouchInput",
    "NtUserRegisterTouchHitTestingWindow",
    "NtUserSetDisplayMapping",
    "NtUserSetCalibrationData",
    "NtUserGetRawPointerDeviceData",
    "NtUserGetPointerDeviceCursors",
    "NtUserGetPointerDeviceRects",
    "NtUserRegisterPointerDeviceNotifications",
    "NtUserGetPointerDeviceProperties",
    "NtUserGetPointerDevice",
    "NtUserGetPointerDevices",
    "NtUserPromotePointer",
    "NtUserDiscardPointerFrameMessages",
    "NtUserRegisterPointerInputTarget",
    "NtUserGetPointerInfoList",
    "NtUserGetPointerCursorId",
    "NtUserGetPointerType",
    "NtUserGetGestureConfig",
    "NtUserSetGestureConfig",
    "NtUserGetGestureExtArgs",
    "NtUserGetGestureInfo",
    "NtUserInjectGesture",
    "NtUserChangeWindowMessageFilterEx",
    "NtGdiXLATEOBJ_hGetColorTransform",
    "NtGdiXLATEOBJ_iXlate",
    "NtGdiXLATEOBJ_cGetPalette",
    "NtGdiEngDeleteClip",
    "NtGdiEngCreateClip",
    "NtGdiEngDeletePath",
    "NtGdiCLIPOBJ_ppoGetPath",
    "NtGdiCLIPOBJ_cEnumStart",
    "NtGdiCLIPOBJ_bEnum",
    "NtGdiBRUSHOBJ_hGetColorTransform",
    "NtGdiBRUSHOBJ_pvGetRbrush",
    "NtGdiBRUSHOBJ_pvAllocRbrush",
    "NtGdiBRUSHOBJ_ulGetBrushColor",
    "NtGdiXFORMOBJ_iGetXform",
    "NtGdiXFORMOBJ_bApplyXform",
    "NtGdiFONTOBJ_pQueryGlyphAttrs",
    "NtGdiFONTOBJ_pfdg",
    "NtGdiFONTOBJ_pifi",
    "NtGdiFONTOBJ_cGetGlyphs",
    "NtGdiFONTOBJ_pxoGetXform",
    "NtGdiFONTOBJ_vGetInfo",
    "NtGdiFONTOBJ_cGetAllGlyphHandles",
    "NtGdiFONTOBJ_pvTrueTypeFontFile",
    "NtGdiSTROBJ_dwGetCodePage",
    "NtGdiSTROBJ_vEnumStart",
    "NtGdiSTROBJ_bGetAdvanceWidths",
    "NtGdiSTROBJ_bEnumPositionsOnly",
    "NtGdiSTROBJ_bEnum",
    "NtGdiPATHOBJ_bEnumClipLines",
    "NtGdiPATHOBJ_vEnumStartClipLines",
    "NtGdiPATHOBJ_vEnumStart",
    "NtGdiPATHOBJ_bEnum",
    "NtGdiPATHOBJ_vGetBounds",
    "NtGdiEngCheckAbort",
    "NtGdiGetDhpdev",
    "NtGdiHT_Get8BPPMaskPalette",
    "NtGdiHT_Get8BPPFormatPalette",
    "NtGdiUpdateTransform",
    "NtGdiUMPDEngFreeUserMem",
    "NtGdiBRUSHOBJ_DeleteRbrush",
    "NtGdiSetPUMPDOBJ",
    "NtGdiSetUMPDSandboxState",
    "NtGdiDrawStream",
    "NtGdiHLSurfSetInformation",
    "NtGdiHLSurfGetInformation",
    "NtGdiDwmCreatedBitmapRemotingOutput",
    "NtGdiDdDDIGetScanLine",
    "NtGdiDdDDIReleaseProcessVidPnSourceOwners",
    "NtGdiDdDDIGetProcessSchedulingPriorityClass",
    "NtGdiDdDDISetProcessSchedulingPriorityClass",
    "NtGdiDdDDIGetContextSchedulingPriority",
    "NtGdiDdDDISetContextSchedulingPriority",
    "NtGdiDdDDIDestroyDCFromMemory",
    "NtGdiDdDDICreateDCFromMemory",
    "NtGdiDdDDIGetDeviceState",
    "NtGdiDdDDISetGammaRamp",
    "NtGdiDdDDIWaitForVerticalBlankEvent",
    "NtGdiDdDDIDestroyOverlay",
    "NtGdiDdDDIFlipOverlay",
    "NtGdiDdDDIUpdateOverlay",
    "NtGdiDdDDICreateOverlay",
    "NtGdiDdDDIGetPresentQueueEvent",
    "NtGdiDdDDIGetPresentHistory",
    "NtGdiDdDDISetVidPnSourceOwner1",
    "NtGdiDdDDISetVidPnSourceOwner",
    "NtGdiDdDDIQueryStatistics",
    "NtGdiDdDDIEscape",
    "NtGdiDdDDIGetSharedPrimaryHandle",
    "NtGdiDdDDICloseAdapter",
    "NtGdiDdDDIOpenAdapterFromLuid",
    "NtGdiDdDDIEnumAdapters",
    "NtGdiDdDDIOpenAdapterFromHdc",
    "NtGdiDdDDIOpenAdapterFromDeviceName",
    "NtGdiDdDDIRender",
    "NtGdiDdDDIPresent",
    "NtGdiDdDDIGetMultisampleMethodList",
    "NtGdiDdDDISetDisplayMode",
    "NtGdiDdDDIGetDisplayModeList",
    "NtGdiDdDDIUnlock",
    "NtGdiDdDDILock",
    "NtGdiDdDDIQueryAdapterInfo",
    "NtGdiDdDDIGetRuntimeData",
    "NtGdiDdDDISignalSynchronizationObject",
    "NtGdiDdDDIWaitForSynchronizationObject",
    "NtGdiDdDDIDestroySynchronizationObject",
    "NtGdiDdDDIOpenSynchronizationObject",
    "NtGdiDdDDICreateSynchronizationObject",
    "NtGdiDdDDIDestroyContext",
    "NtGdiDdDDICreateContext",
    "NtGdiDdDDIDestroyDevice",
    "NtGdiDdDDICreateDevice",
    "NtGdiDdDDIQueryAllocationResidency",
    "NtGdiDdDDISetAllocationPriority",
    "NtGdiDdDDIDestroyAllocation",
    "NtGdiDdDDIOpenResourceFromNtHandle",
    "NtGdiDdDDIOpenSyncObjectFromNtHandle",
    "NtGdiDdDDIOpenResource",
    "NtGdiDdDDIOpenNtHandleFromName",
    "NtGdiDdDDIShareObjects",
    "NtGdiDdDDIQueryResourceInfoFromNtHandle",
    "NtGdiDdDDIQueryResourceInfo",
    "NtGdiDdDDICreateAllocation",
    "NtGdiDdDDIOutputDuplReleaseFrame",
    "NtGdiDdDDIQueryRemoteVidPnSourceFromGdiDisplayName",
    "NtGdiDdDDIOutputDuplPresent",
    "NtGdiDdDDIReleaseKeyedMutex2",
    "NtGdiDdDDIAcquireKeyedMutex2",
    "NtGdiDdDDIOpenKeyedMutex2",
    "NtGdiDdDDICreateKeyedMutex2",
    "NtGdiDdDDIOutputDuplGetPointerShapeData",
    "NtGdiDdDDIOutputDuplGetMetaData",
    "NtGdiDdDDIOutputDuplGetFrameInfo",
    "NtGdiDdDDIDestroyOutputDupl",
    "NtGdiDdDDICreateOutputDupl",
    "NtGdiDdDDIReclaimAllocations",
    "NtGdiDdDDIOfferAllocations",
    "NtGdiDdDDICheckSharedResourceAccess",
    "NtGdiDdDDICheckVidPnExclusiveOwnership",
    "NtGdiDdDDIGetOverlayState",
    "NtGdiDdDDIConfigureSharedResource",
    "NtGdiDdDDIReleaseKeyedMutex",
    "NtGdiDdDDIAcquireKeyedMutex",
    "NtGdiDdDDIDestroyKeyedMutex",
    "NtGdiDdDDIOpenKeyedMutex",
    "NtGdiDdDDICreateKeyedMutex",
    "NtGdiDdDDISharedPrimaryUnLockNotification",
    "NtGdiDdDDISharedPrimaryLockNotification",
    "NtGdiDdDDISetDisplayPrivateDriverFormat",
    "NtGdiDdDDICheckExclusiveOwnership",
    "NtGdiDdDDICheckMonitorPowerState",
    "NtGdiDdDDIWaitForIdle",
    "NtGdiDdDDICheckOcclusion",
    "NtGdiDdDDIInvalidateActiveVidPn",
    "NtGdiDdDDIPollDisplayChildren",
    "NtGdiDdDDISetQueuedLimit",
    "NtGdiDdDDIPinDirectFlipResources",
    "NtGdiDdDDIUnpinDirectFlipResources",
    "NtGdiDdDDIWaitForVerticalBlankEvent2",
    "NtGdiDdDDISetContextInProcessSchedulingPriority",
    "NtGdiDdDDIGetContextInProcessSchedulingPriority",
    "NtGdiDdDDIGetSharedResourceAdapterLuid",
    "NtGdiDdDDISetStereoEnabled",
    "NtGdiMakeObjectUnXferable",
    "NtGdiMakeObjectXferable",
    "NtGdiDestroyPhysicalMonitor",
    "NtGdiGetPhysicalMonitorDescription",
    "NtGdiGetPhysicalMonitors",
    "NtGdiGetNumberOfPhysicalMonitors",
    "NtGdiDDCCIGetTimingReport",
    "NtGdiDDCCIGetCapabilitiesString",
    "NtGdiDDCCIGetCapabilitiesStringLength",
    "NtGdiDDCCISaveCurrentSettings",
    "NtGdiDDCCISetVCPFeature",
    "NtGdiDDCCIGetVCPFeature",
    "NtGdiDdQueryVisRgnUniqueness",
    "NtGdiDdDestroyFullscreenSprite",
    "NtGdiDdNotifyFullscreenSpriteUpdate",
    "NtGdiDdCreateFullscreenSprite",
    "NtUserShowSystemCursor",
    "NtUserSetMirrorRendering",
    "NtUserMagGetContextInformation",
    "NtUserMagSetContextInformation",
    "NtUserMagControl",
    "NtUserSlicerControl",
    "NtUserHwndSetRedirectionInfo",
    "NtUserHwndQueryRedirectionInfo",
    "NtCreateCompositionSurfaceHandle",
    "NtValidateCompositionSurfaceHandle",
    "NtBindCompositionSurface",
    "NtUnBindCompositionSurface",
    "NtQueryCompositionSurfaceBinding",
    "CFlipExBuffer::RemoveRealization",
    "NtQueryCompositionSurfaceStatistics",
    "NtOpenCompositionSurfaceSectionInfo",
    "NtOpenCompositionSurfaceSwapChainHandleInfo",
    "NtQueryCompositionSurfaceRenderingRealization",
    "NtOpenCompositionSurfaceDirtyRegion",
    "NtSetCompositionSurfaceOutOfFrameDirectFlipNotification",
    "NtSetCompositionSurfaceStatistics",
    "NtTokenManagerOpenEvent",
    "NtTokenManagerThread",
    "NtTokenManagerGetOutOfFrameDirectFlipSurfaceUpdates",
    "NtDCompositionBeginFrame",
    "NtDCompositionConfirmFrame",
    "NtDCompositionRetireFrame",
    "NtDCompositionDiscardFrame",
    "NtDCompositionGetFrameSurfaceUpdates",
    "NtDCompositionGetFrameLegacyTokens",
    "NtDCompositionDestroyConnectionContext",
    "NtDCompositionGetConnectionContextBatch",
    "NtDCompositionGetFrameStatistics",
    "NtDCompositionGetDeletedResources",
    "NtDCompositionSetResourceDeletedNotificationTag",
    "NtDCompositionCreateConnectionContext",
    "NtDCompositionDestroyChannel",
    "NtDCompositionReleaseAllResources",
    "NtDCompositionSubmitDWMBatch",
    "NtDCompositionCommitChannel",
    "NtDCompositionWaitForChannel",
    "NtDCompositionSetChannelCommitCompletionEvent",
    "NtDCompositionTelemetryTouchInteractionBegin",
    "NtDCompositionTelemetryTouchInteractionUpdate",
    "NtDCompositionTelemetryTouchInteractionEnd",
    "NtDCompositionCurrentBatchId",
    "NtDCompositionReleaseResource",
    "NtDCompositionRemoveCrossDeviceVisualChild",
    "NtDCompositionRemoveVisualChild",
    "NtDCompositionAddCrossDeviceVisualChild",
    "NtDCompositionAddVisualChild",
    "NtDCompositionReplaceVisualChildren",
    "NtDCompositionSetResourceAnimationProperty",
    "NtDCompositionSetResourceReferenceArrayProperty",
    "NtDCompositionSetResourceReferenceProperty",
    "NtDCompositionSetResourceBufferProperty",
    "NtDCompositionSetResourceIntegerProperty",
    "NtDCompositionSetResourceFloatProperty",
    "NtDCompositionCreateResource",
    "NtDCompositionCreateDwmChannel",
    "NtDCompositionCreateChannel",
    "NtDCompositionSynchronize",
    "NtDCompositionDwmSyncFlush",
    "NtDCompositionValidateAndReferenceSystemVisualForHwndTarget",
    "NtDCompositionSignalGpuFence",
    "NtDCompositionGetChannels",
    "NtDCompositionConnectPipe",
    "NtUserDestroyDCompositionHwndTarget",
    "NtUserCreateDCompositionHwndTarget",
    "NtUserWaitForRedirectionStartComplete",
    "NtUserSignalRedirectionStartComplete",
    "NtUserSetActiveProcess",
    "NtUserGetDisplayAutoRotationPreferencesByProcessId",
    "NtUserGetDisplayAutoRotationPreferences",
    "NtUserSetDisplayAutoRotationPreferences",
    "NtUserSetAutoRotation",
    "NtUserGetAutoRotationState",
    "NtUserAutoRotateScreen",
    "NtUserSetSensorPresence",
    "NtUserAcquireIAMKey",
    "NtUserSetFallbackForeground",
    "NtUserSetBrokeredForeground",
    "NtUserDisableImmersiveOwner",
    "NtUserEnableIAMAccess",
    "NtUserGetProcessUIContextInformation",
    "NtUserSetProcessRestrictionExemption",
    "NtUserEnableMouseInPointer",
    "NtUserIsMouseInPointerEnabled",
    "NtUserPromoteMouseInPointer",
    "NtUserAutoPromoteMouseInPointer",
    "NtUserEnableMouseInputForCursorSuppression",
    "NtUserIsMouseInputEnabled",
    "NtUserInternalClipCursor",
    "NtUserCheckProcessForClipboardAccess",
    "NtUserGetClipboardAccessToken",
    "NtUserGetQueueEventStatus"
};

//////////////////////////////////////////////////////////////////////////
// Windows 8 SP1 _W32pServiceTable
//////////////////////////////////////////////////////////////////////////
static const char* W32pServiceTable_Win8Sp1_x86[] = {
    "NtUserYieldTask",
    "NtUserSetSensorPresence",
    "NtGdiWidenPath",
    "NtGdiUpdateColors",
    "NtGdiUnrealizeObject",
    "NtGdiUnmapMemFont",
    "UMPDDrvQuerySpoolType",
    "NtGdiTransparentBlt",
    "NtGdiTransformPoints",
    "NtGdiSwapBuffers",
    "NtGdiStrokePath",
    "NtGdiStrokeAndFillPath",
    "NtGdiStretchDIBitsInternal",
    "NtGdiStretchBlt",
    "NtGdiStartPage",
    "NtGdiStartDoc",
    "NtGdiSetSizeDevice",
    "NtGdiSetVirtualResolution",
    "NtGdiSetTextJustification",
    "NtGdiSetSystemPaletteUse",
    "NtGdiSetRectRgn",
    "NtGdiSetPixelFormat",
    "NtGdiSetPixel",
    "NtGdiSetOPMSigningKeyAndSequenceNumbers",
    "NtGdiSetLayout",
    "NtGdiMirrorWindowOrg",
    "NtGdiGetDeviceWidth",
    "NtGdiSetMiterLimit",
    "NtGdiSetMetaRgn",
    "NtGdiSetMagicColors",
    "NtGdiSetLinkedUFIs",
    "NtGdiSetIcmMode",
    "NtGdiSetFontXform",
    "NtGdiSetFontEnumeration",
    "NtGdiSetDIBitsToDeviceInternal",
    "NtGdiSetDeviceGammaRamp",
    "NtGdiSetColorSpace",
    "NtGdiSetColorAdjustment",
    "NtGdiSetBrushOrg",
    "UMPDDrvQuerySpoolType",
    "NtGdiSetBoundsRect",
    "NtGdiSetBitmapDimension",
    "NtGdiSetBitmapBits",
    "NtGdiSetBitmapAttributes",
    "NtGdiSelectPen",
    "NtGdiSelectFont",
    "NtGdiSelectClipPath",
    "NtGdiSelectBrush",
    "NtGdiSelectBitmap",
    "NtGdiScaleWindowExtEx",
    "NtGdiScaleViewportExtEx",
    "NtGdiSaveDC",
    "NtGdiRoundRect",
    "NtGdiRestoreDC",
    "NtGdiResizePalette",
    "NtGdiResetDC",
    "NtGdiRemoveFontMemResourceEx",
    "NtGdiRemoveFontResourceW",
    "NtGdiRectVisible",
    "NtGdiRectInRegion",
    "NtGdiRectangle",
    "NtGdiQueryFontAssocInfo",
    "NtGdiQueryFonts",
    "NtGdiPtVisible",
    "NtGdiPtInRegion",
    "NtGdiPolyTextOutW",
    "NtGdiPolyPolyDraw",
    "NtGdiPolyDraw",
    "NtGdiPlgBlt",
    "NtGdiPathToRegion",
    "NtGdiPolyPatBlt",
    "NtGdiPatBlt",
    "NtGdiOpenDCW",
    "NtGdiOffsetRgn",
    "NtGdiOffsetClipRgn",
    "NtGdiMoveTo",
    "NtGdiMonoBitmap",
    "NtGdiModifyWorldTransform",
    "NtGdiMaskBlt",
    "NtGdiMakeInfoDC",
    "NtGdiMakeFontDir",
    "NtGdiLineTo",
    "NtGdiInvertRgn",
    "NtGdiIntersectClipRect",
    "NtGdiInitSpool",
    "CDiscardInputQueue::AddRef",
    "NtGdiIcmBrushInfo",
    "NtGdiHfontCreate",
    "NtGdiGradientFill",
    "NtGdiGetWidthTable",
    "NtGdiGetFontUnicodeRanges",
    "NtGdiAddEmbFontToDC",
    "NtGdiChangeGhostFont",
    "NtGdiGetEmbedFonts",
    "NtGdiGetUFIPathname",
    "NtGdiGetEmbUFI",
    "NtGdiGetUFI",
    "NtGdiGetTransform",
    "NtGdiGetTextMetricsW",
    "NtGdiGetTextFaceW",
    "NtGdiGetTextExtentExW",
    "NtGdiGetTextExtent",
    "NtGdiGetTextCharsetInfo",
    "NtGdiGetSystemPaletteUse",
    "NtGdiGetSuggestedOPMProtectedOutputArraySize",
    "NtGdiGetStringBitmapW",
    "NtGdiGetStockObject",
    "NtGdiGetStats",
    "UMPDDrvCreateDeviceBitmap",
    "NtGdiGetServerMetaFileBits",
    "NtGdiGetRgnBox",
    "NtGdiGetRegionData",
    "NtGdiGetRealizationInfo",
    "NtGdiGetRasterizerCaps",
    "NtGdiGetRandomRgn",
    "NtGdiGetPixel",
    "NtGdiGetPath",
    "NtGdiGetOutlineTextMetricsInternalW",
    "NtGdiGetOPMRandomNumber",
    "NtGdiGetObjectBitmapHandle",
    "NtGdiGetNearestPaletteIndex",
    "NtGdiGetNearestColor",
    "NtGdiGetMonitorID",
    "NtGdiGetMiterLimit",
    "NtGdiGetLinkedUFIs",
    "NtGdiGetKerningPairs",
    "NtGdiGetOPMInformation",
    "NtGdiGetGlyphOutline",
    "NtGdiGetGlyphIndicesWInternal",
    "NtGdiGetGlyphIndicesW",
    "NtGdiGetFontResourceInfoInternalW",
    "NtGdiGetFontFileInfo",
    "NtGdiGetFontFileData",
    "NtGdiGetFontData",
    "NtGdiGetEudcTimeStampEx",
    "NtGdiGetETM",
    "NtGdiGetDIBitsInternal",
    "NtGdiGetDeviceCapsAll",
    "NtGdiGetDeviceGammaRamp",
    "NtGdiGetDeviceCaps",
    "NtGdiGetDCPoint",
    "NtGdiGetDCObject",
    "NtGdiGetDCforBitmap",
    "NtGdiGetDCDword",
    "NtGdiGetCurrentDpiInfo",
    "NtGdiGetCOPPCompatibleOPMInformation",
    "NtGdiGetColorSpaceforBitmap",
    "NtGdiGetColorAdjustment",
    "NtGdiGetCharWidthInfo",
    "NtGdiGetCharWidthW",
    "NtGdiGetCharSet",
    "NtGdiGetCharacterPlacementW",
    "NtGdiGetCharABCWidthsW",
    "NtGdiGetCertificateSize",
    "NtGdiGetCertificate",
    "NtGdiGetBoundsRect",
    "NtGdiGetBitmapDimension",
    "NtGdiGetBitmapBits",
    "NtGdiGetAppClipBox",
    "NtGdiGetAndSetDCDword",
    "NtGdiFullscreenControl",
    "NtGdiFrameRgn",
    "NtGdiForceUFIMapping",
    "NtGdiFlush",
    "NtGdiFlattenPath",
    "NtGdiFillRgn",
    "NtGdiFillPath",
    "NtGdiExtTextOutW",
    "NtGdiExtSelectClipRgn",
    "NtGdiExtGetObjectW",
    "NtGdiExtFloodFill",
    "NtGdiExtEscape",
    "NtGdiExtCreateRegion",
    "NtGdiExtCreatePen",
    "NtGdiExcludeClipRect",
    "NtGdiEudcLoadUnloadLink",
    "NtGdiEqualRgn",
    "NtGdiEnumObjects",
    "NtGdiEnumFonts",
    "NtGdiEndPath",
    "NtGdiEndPage",
    "NtGdiEndGdiRendering",
    "NtGdiEndDoc",
    "NtGdiEnableEudc",
    "NtGdiEllipse",
    "NtGdiDrawEscape",
    "NtGdiDoPalette",
    "NtGdiDoBanding",
    "NtGdiGetPerBandInfo",
    "NtGdiDestroyOPMProtectedOutput",
    "NtGdiDescribePixelFormat",
    "NtGdiDeleteObjectApp",
    "NtGdiDeleteColorTransform",
    "NtGdiDeleteColorSpace",
    "NtGdiDeleteClientObj",
    "NtGdiDdCreateSurfaceObject",
    "NtGdiDdAttachSurface",
    "EngAllocPrivateUserMem",
    "NtGdiDdAttachSurface",
    "NtGdiD3dContextCreate",
    "NtGdiDdAttachSurface",
    "NtGdiDdAttachSurface",
    "NtGdiDdAttachSurface",
    "NtGdiDdAttachSurface",
    "NtGdiDdAttachSurface",
    "NtGdiDdAttachSurface",
    "NtGdiDdAttachSurface",
    "NtGdiDdAttachSurface",
    "NtGdiD3dContextCreate",
    "NtGdiDdAttachSurface",
    "NtGdiDdAttachSurface",
    "NtGdiDdAttachSurface",
    "NtGdiDdAttachSurface",
    "NtGdiDdAttachSurface",
    "EngAllocPrivateUserMem",
    "NtGdiDdAttachSurface",
    "NtGdiDdAttachSurface",
    "NtGdiDdUnattachSurface",
    "EngAllocPrivateUserMem",
    "EngAllocPrivateUserMem",
    "EngAllocPrivateUserMem",
    "NtGdiDdAttachSurface",
    "NtGdiDdAttachSurface",
    "NtGdiDdAttachSurface",
    "NtGdiDdAttachSurface",
    "EngLockDirectDrawSurface",
    "NtGdiDdAttachSurface",
    "NtGdiDdAttachSurface",
    "NtGdiDdQueryDirectDrawObject",
    "NtGdiDdAttachSurface",
    "EngAllocPrivateUserMem",
    "NtGdiDdAttachSurface",
    "NtGdiDdAttachSurface",
    "NtGdiDdAttachSurface",
    "NtGdiDdAttachSurface",
    "NtGdiDdAttachSurface",
    "NtGdiDdAttachSurface",
    "EngAllocPrivateUserMem",
    "NtGdiDdAttachSurface",
    "NtGdiDdAttachSurface",
    "NtGdiDdAttachSurface",
    "NtGdiDdAttachSurface",
    "NtGdiDdAttachSurface",
    "HeapVidMemAllocAligned",
    "NtGdiDdAttachSurface",
    "EngLockDirectDrawSurface",
    "NtGdiDdAttachSurface",
    "NtGdiDdAttachSurface",
    "EngLockDirectDrawSurface",
    "EngLockDirectDrawSurface",
    "NtGdiDdCreateSurfaceObject",
    "NtGdiDdAttachSurface",
    "NtGdiDdCreateD3DBuffer",
    "NtGdiDdCreateD3DBuffer",
    "EngLockDirectDrawSurface",
    "NtGdiDdAttachSurface",
    "NtGdiDdAttachSurface",
    "NtGdiDdAttachSurface",
    "EngAllocPrivateUserMem",
    "NtGdiDdAttachSurface",
    "NtGdiDdAttachSurface",
    "EngAllocPrivateUserMem",
    "EngAllocPrivateUserMem",
    "EngLockDirectDrawSurface",
    "NtGdiD3dDrawPrimitives2",
    "EngLockDirectDrawSurface",
    "EngLockDirectDrawSurface",
    "EngLockDirectDrawSurface",
    "NtGdiD3dContextCreate",
    "NtGdiCreateSolidBrush",
    "NtGdiCreateServerMetaFile",
    "NtGdiCreateRoundRectRgn",
    "NtGdiCreateRectRgn",
    "NtGdiCreatePen",
    "NtGdiCreatePatternBrushInternal",
    "NtGdiCreatePaletteInternal",
    "NtGdiCreateOPMProtectedOutputs",
    "NtGdiCreateMetafileDC",
    "NtGdiCreateHatchBrushInternal",
    "NtGdiCreateHalftonePalette",
    "NtGdiCreateEllipticRgn",
    "NtGdiCreateSessionMappedDIBSection",
    "NtGdiCreateDIBSection",
    "NtGdiCreateDIBitmapInternal",
    "NtGdiCreateDIBBrush",
    "NtGdiCreateCompatibleDC",
    "NtGdiCreateCompatibleBitmap",
    "NtGdiCreateColorTransform",
    "NtGdiCreateColorSpace",
    "NtGdiCreateClientObj",
    "NtGdiCreateBitmapFromDxSurface2",
    "NtGdiCreateBitmapFromDxSurface",
    "NtGdiCreateBitmap",
    "NtGdiConvertMetafileRect",
    "NtGdiConfigureOPMProtectedOutput",
    "NtGdiComputeXformCoefficients",
    "NtGdiCombineTransform",
    "NtGdiCombineRgn",
    "NtGdiColorCorrectPalette",
    "UMPDDrvQuerySpoolType",
    "NtGdiClearBitmapAttributes",
    "NtGdiCloseFigure",
    "NtGdiCheckBitmapBits",
    "NtGdiCancelDC",
    "NtGdiBitBlt",
    "NtGdiBeginPath",
    "NtGdiBeginGdiRendering",
    "NtGdiArcInternal",
    "NtGdiFontIsLinked",
    "NtGdiAnyLinkedFonts",
    "NtGdiAngleArc",
    "NtGdiAlphaBlend",
    "NtGdiAddRemoteMMInstanceToDC",
    "NtGdiRemoveMergeFont",
    "NtGdiAddFontMemResourceEx",
    "NtGdiAddRemoteFontToDC",
    "NtGdiAddFontResourceW",
    "NtGdiAbortPath",
    "NtGdiAbortDoc",
    "NtUserDefSetText",
    "NtUserDeferWindowPosAndBand",
    "NtUserDdeInitialize",
    "NtUserCanBrokerForceForeground",
    "NtUserCreateWindowStation",
    "NtUserCreateWindowEx",
    "NtUserCreateLocalMemHandle",
    "NtUserCreateInputContext",
    "NtUserCreateDesktopEx",
    "NtUserCreateCaret",
    "NtUserCreateAcceleratorTable",
    "NtUserCountClipboardFormats",
    "NtUserCopyAcceleratorTable",
    "NtUserConvertMemHandle",
    "NtUserConsoleControl",
    "NtUserCloseWindowStation",
    "NtUserCloseDesktop",
    "NtUserCloseClipboard",
    "NtUserClipCursor",
    "NtUserChildWindowFromPointEx",
    "NtUserCheckMenuItem",
    "NtUserCheckWindowThreadDesktop",
    "NtUserDwmValidateWindow",
    "NtUserCheckAccessForIntegrityLevel",
    "NtUserDisplayConfigSetDeviceInfo",
    "NtUserDisplayConfigGetDeviceInfo",
    "NtUserQueryDisplayConfig",
    "NtUserSetDisplayConfig",
    "NtUserGetDisplayConfigBufferSizes",
    "NtUserChangeDisplaySettings",
    "NtUserChangeClipboardChain",
    "NtUserCallTwoParam",
    "NtUserCallOneParam",
    "NtUserCallNoParam",
    "NtUserCallNextHookEx",
    "NtUserCallMsgFilter",
    "NtUserCallHwndParamLock",
    "NtUserCallHwndParam",
    "NtUserCallHwndOpt",
    "NtUserCallHwndLock",
    "NtUserCallHwnd",
    "NtUserBuildPropList",
    "NtUserBuildNameList",
    "NtUserBuildHwndList",
    "NtUserBuildHimcList",
    "NtUserBlockInput",
    "NtUserBitBltSysBmp",
    "NtUserBeginPaint",
    "NtUserAttachThreadInput",
    "NtUserAssociateInputContext",
    "NtUserAlterWindowStyle",
    "NtUserAddClipboardFormatListener",
    "NtUserActivateKeyboardLayout",
    "NtUserDelegateCapturePointers",
    "NtUserDelegateInput",
    "NtUserDispatchMessage",
    "NtUserDisableProcessWindowFiltering",
    "NtUserDisableThreadIme",
    "NtUserDestroyWindow",
    "NtUserDestroyMenu",
    "NtUserDestroyInputContext",
    "NtUserDestroyCursor",
    "NtUserDestroyAcceleratorTable",
    "NtUserDeleteMenu",
    "NtUserDoSoundDisconnect",
    "NtUserDoSoundConnect",
    "NtUserGhostWindowFromHungWindow",
    "NtUserGetWOWClass",
    "NtUserGetWindowPlacement",
    "NtUserGetWindowDisplayAffinity",
    "NtUserGetWindowDC",
    "NtUserGetWindowCompositionAttribute",
    "NtUserGetWindowCompositionInfo",
    "NtUserGetWindowBand",
    "NtUserGetUpdateRgn",
    "NtUserGetUpdateRect",
    "NtUserGetUpdatedClipboardFormats",
    "NtUserGetTopLevelWindow",
    "NtUserGetTitleBarInfo",
    "NtUserGetThreadState",
    "NtUserGetThreadDesktop",
    "NtUserGetSystemMenu",
    "NtUserGetScrollBarInfo",
    "NtUserGetRegisteredRawInputDevices",
    "NtUserGetRawInputDeviceList",
    "NtUserGetRawInputDeviceInfo",
    "NtUserGetRawInputData",
    "NtUserGetRawInputBuffer",
    "NtUserGetProcessWindowStation",
    "NtUserGetPriorityClipboardFormat",
    "NtUserGetOpenClipboardWindow",
    "NtUserGetObjectInformation",
    "NtUserGetMouseMovePointsEx",
    "NtUserGetMessage",
    "NtUserGetMenuItemRect",
    "NtUserGetMenuIndex",
    "NtUserGetMenuBarInfo",
    "NtUserGetListBoxInfo",
    "NtUserGetKeyState",
    "NtUserGetKeyNameText",
    "NtUserGetKeyboardState",
    "NtUserGetKeyboardLayoutName",
    "NtUserGetKeyboardLayoutList",
    "NtUserGetInternalWindowPos",
    "NtUserGetInputLocaleInfo",
    "NtUserGetImeInfoEx",
    "NtUserGetImeHotKey",
    "NtUserGetIconSize",
    "NtUserGetIconInfo",
    "NtUserGetGUIThreadInfo",
    "NtUserGetGuiResources",
    "NtUserGetForegroundWindow",
    "NtUserGetDoubleClickTime",
    "NtUserGetDesktopID",
    "NtUserGetDCEx",
    "NtUserGetDC",
    "NtUserGetCursorInfo",
    "NtUserGetCursorFrameInfo",
    "NtUserGetCurrentInputMessageSource",
    "NtUserGetCIMSSM",
    "NtUserGetCPD",
    "NtUserGetControlColor",
    "NtUserGetControlBrush",
    "NtUserGetComboBoxInfo",
    "NtUserGetClipCursor",
    "NtUserGetClipboardViewer",
    "NtUserGetClipboardSequenceNumber",
    "NtUserGetClipboardOwner",
    "NtUserGetClipboardFormatName",
    "NtUserGetClipboardData",
    "NtUserGetClassName",
    "NtUserGetClassInfoEx",
    "NtUserGetCaretPos",
    "NtUserGetCaretBlinkTime",
    "NtUserGetAtomName",
    "NtUserGetAsyncKeyState",
    "NtUserGetAppImeLevel",
    "NtUserGetAncestor",
    "NtUserGetAltTabInfo",
    "NtUserFrostCrashedWindow",
    "NtUserFlashWindowEx",
    "NtUserFindWindowEx",
    "NtUserFindExistingCursorIcon",
    "NtUserFillWindow",
    "NtUserExcludeUpdateRgn",
    "NtUserEvent",
    "NtUserEnumDisplaySettings",
    "NtUserEnumDisplayMonitors",
    "NtUserEnumDisplayDevices",
    "NtUserEndPaint",
    "NtUserEndMenu",
    "NtUserEndDeferWindowPosEx",
    "NtUserEnableScrollBar",
    "NtUserEnableMenuItem",
    "NtUserEmptyClipboard",
    "NtUserDrawMenuBarTemp",
    "NtUserDrawIconEx",
    "NtUserDrawCaptionTemp",
    "NtUserDrawCaption",
    "NtUserDrawAnimatedRects",
    "NtUserDragObject",
    "NtUserDragDetect",
    "NtUserHandleDelegatedInput",
    "NtUserRealChildWindowFromPoint",
    "NtUserQueryWindow",
    "NtUserQuerySendMessage",
    "NtUserQueryInputContext",
    "NtUserQueryInformationThread",
    "NtUserQueryBSDRWindow",
    "NtUserPerMonitorDPIPhysicalToLogicalPoint",
    "NtUserProcessConnect",
    "NtUserPrintWindow",
    "NtUserPostThreadMessage",
    "NtUserPostMessage",
    "NtUserPhysicalToLogicalPoint",
    "NtUserPeekMessage",
    "NtUserPaintMonitor",
    "NtUserPaintDesktop",
    "NtUserOpenWindowStation",
    "NtUserOpenThreadDesktop",
    "NtUserOpenInputDesktop",
    "NtUserOpenDesktop",
    "NtUserOpenClipboard",
    "NtUserNotifyWinEvent",
    "NtUserNotifyProcessCreate",
    "NtUserNotifyIMEStatus",
    "NtUserMoveWindow",
    "NtUserModifyUserStartupInfoFlags",
    "NtUserMNDragOver",
    "NtUserMNDragLeave",
    "NtUserMinMaximize",
    "NtUserMessageCall",
    "NtUserMenuItemFromPoint",
    "NtUserMapVirtualKeyEx",
    "NtUserLayoutCompleted",
    "NtUserLogicalToPerMonitorDPIPhysicalPoint",
    "NtUserLogicalToPhysicalPoint",
    "NtUserLockWorkStation",
    "NtUserLockWindowUpdate",
    "NtUserLockWindowStation",
    "NtUserLoadKeyboardLayoutEx",
    "NtUserKillTimer",
    "NtUserIsTopLevelWindow",
    "NtUserIsClipboardFormatAvailable",
    "NtUserInvalidateRgn",
    "NtUserInvalidateRect",
    "NtUserInternalGetWindowIcon",
    "NtUserInternalGetWindowText",
    "NtUserInitTask",
    "NtUserInitializeClientPfnArrays",
    "NtUserInitialize",
    "NtUserImpersonateDdeClientWindow",
    "NtUserHungWindowFromGhostWindow",
    "NtUserHiliteMenuItem",
    "NtUserHideCaret",
    "NtUserHardErrorControl",
    "NtUserRealInternalGetMessage",
    "NtUserRealWaitMessageEx",
    "NtUserTranslateMessage",
    "NtUserTranslateAccelerator",
    "NtUserPaintMenuBar",
    "NtUserCalcMenuBar",
    "NtUserCalculatePopupWindowPosition",
    "NtUserTrackPopupMenuEx",
    "NtUserTrackMouseEvent",
    "NtUserToUnicodeEx",
    "NtUserThunkedMenuItemInfo",
    "NtUserThunkedMenuInfo",
    "NtUserTestForInteractiveUser",
    "NtUserSendEventMessage",
    "NtUserSystemParametersInfo",
    "NtUserSwitchDesktop",
    "NtUserSoundSentry",
    "NtUserShutdownReasonDestroy",
    "NtUserShutdownBlockReasonQuery",
    "NtUserShutdownBlockReasonCreate",
    "NtUserShowWindowAsync",
    "NtUserShowWindow",
    "NtUserShowScrollBar",
    "NtUserShowCaret",
    "NtUserSetWinEventHook",
    "NtUserSetWindowWord",
    "NtUserSetWindowStationUser",
    "NtUserSetWindowsHookEx",
    "NtUserSetWindowsHookAW",
    "NtUserSetWindowRgnEx",
    "NtUserGetWindowRgnEx",
    "NtUserSetWindowRgn",
    "NtUserSetWindowPos",
    "NtUserSetWindowPlacement",
    "NtUserSetWindowLong",
    "NtUserSetWindowFNID",
    "NtUserSetWindowDisplayAffinity",
    "NtUserSetWindowCompositionTransition",
    "NtUserUpdateDefaultDesktopThumbnail",
    "NtUserSetWindowCompositionAttribute",
    "NtUserSetWindowBand",
    "NtUserSetProcessUIAccessZorder",
    "NtUserSetProcessDpiAwareness",
    "NtUserSetTimer",
    "NtUserSetThreadState",
    "NtUserSetThreadLayoutHandles",
    "NtUserSetThreadDesktop",
    "NtUserSetThreadInputBlocked",
    "NtUserSetSystemTimer",
    "NtUserSetSystemMenu",
    "NtUserSetSystemCursor",
    "NtUserSetSysColors",
    "NtUserSetShellWindowEx",
    "NtUserSetImmersiveBackgroundWindow",
    "NtUserSetScrollInfo",
    "NtUserSetProp",
    "NtUserGetProp",
    "NtUserSetProcessWindowStation",
    "NtUserSetParent",
    "NtUserSetObjectInformation",
    "NtUserSetMenuFlagRtoL",
    "NtUserSetMenuDefaultItem",
    "NtUserSetMenuContextHelpId",
    "NtUserSetMenu",
    "NtUserSetKeyboardState",
    "NtUserSetInternalWindowPos",
    "NtUserSetInformationThread",
    "NtUserSetImeOwnerWindow",
    "NtUserSetImeInfoEx",
    "NtUserSetImeHotKey",
    "NtUserSetFocus",
    "NtUserSetCursorIconData",
    "NtUserSetCursorContents",
    "NtUserSetCursor",
    "NtUserSetClipboardViewer",
    "NtUserSetClipboardData",
    "NtUserSetClassWord",
    "NtUserSetClassLong",
    "NtUserSetChildWindowNoActivate",
    "NtUserSetCapture",
    "NtUserSetAppImeLevel",
    "NtUserSetActiveWindow",
    "NtUserSendInput",
    "NtUserSelectPalette",
    "NtUserScrollWindowEx",
    "NtUserScrollDC",
    "NtUserSBGetParms",
    "NtUserResolveDesktopForWOW",
    "NtUserRemoveProp",
    "NtUserRemoveMenu",
    "NtUserRemoveClipboardFormatListener",
    "NtUserRegisterWindowMessage",
    "NtUserRegisterTasklist",
    "NtUserRegisterServicesProcess",
    "NtUserRegisterRawInputDevices",
    "NtUserRegisterHotKey",
    "NtUserRegisterUserApiHook",
    "NtUserRegisterErrorReportingDialog",
    "NtUserRegisterClassExWOW",
    "NtUserRegisterBSDRWindow",
    "NtUserRedrawWindow",
    "NtUserUndelegateInput",
    "NtUserGetWindowMinimizeRect",
    "NtUserDwmStopRedirection",
    "NtUserDwmStartRedirection",
    "NtUserDwmGetRemoteSessionOcclusionEvent",
    "NtUserDwmGetRemoteSessionOcclusionState",
    "KbdNlsFuncTypeDummy",
    "NtUserCheckProcessSession",
    "NtUserUnregisterSessionPort",
    "NtUserRegisterSessionPort",
    "NtUserCtxDisplayIOCtl",
    "NtUserRemoteStopScreenUpdates",
    "NtUserRemoteRedrawScreen",
    "NtUserRemoteRedrawRectangle",
    "NtUserRemoteConnect",
    "NtUserWaitAvailableMessageEx",
    "NtUserWindowFromPhysicalPoint",
    "NtUserWindowFromPhysicalPoint",
    "NtUserWaitMessage",
    "NtUserWaitForMsgAndEvent",
    "NtUserWaitForInputIdle",
    "NtUserVkKeyScanEx",
    "NtUserValidateTimerCallback",
    "NtUserValidateRect",
    "NtUserValidateHandleSecure",
    "NtUserUserHandleGrantAccess",
    "NtUserUpdatePerUserSystemParameters",
    "NtUserSetLayeredWindowAttributes",
    "NtUserGetLayeredWindowAttributes",
    "NtUserUpdateLayeredWindow",
    "NtUserUpdateInstance",
    "NtUserUpdateInputContext",
    "NtUserUnregisterHotKey",
    "NtUserUnregisterUserApiHook",
    "NtUserUnregisterClass",
    "NtUserUnlockWindowStation",
    "NtUserUnloadKeyboardLayout",
    "NtUserUnhookWinEvent",
    "NtUserUnhookWindowsHookEx",
    "NtUserGetTouchInputInfo",
    "NtUserIsTouchWindow",
    "NtUserModifyWindowTouchCapability",
    "NtGdiEngStretchBltROP",
    "NtGdiEngTextOut",
    "NtGdiEngTransparentBlt",
    "NtGdiEngGradientFill",
    "NtGdiEngAlphaBlend",
    "NtGdiEngLineTo",
    "NtGdiEngPaint",
    "NtGdiEngStrokeAndFillPath",
    "NtGdiEngFillPath",
    "NtGdiEngStrokePath",
    "NtGdiEngMarkBandingSurface",
    "NtGdiEngPlgBlt",
    "NtGdiEngStretchBlt",
    "NtGdiEngBitBlt",
    "NtGdiEngLockSurface",
    "NtGdiEngUnlockSurface",
    "NtGdiEngEraseSurface",
    "NtGdiEngDeleteSurface",
    "NtGdiEngDeletePalette",
    "NtGdiEngCopyBits",
    "NtGdiEngComputeGlyphSet",
    "NtGdiEngCreatePalette",
    "NtGdiEngCreateDeviceBitmap",
    "NtGdiEngCreateDeviceSurface",
    "NtGdiEngCreateBitmap",
    "NtGdiEngAssociateSurface",
    "NtUserSetWindowFeedbackSetting",
    "NtUserRegisterEdgy",
    "NtUserGetWindowFeedbackSetting",
    "NtUserHidePointerContactVisualization",
    "NtUserGetTouchValidationStatus",
    "NtUserInitializeTouchInjection",
    "NtUserInjectTouchInput",
    "NtUserRegisterTouchHitTestingWindow",
    "NtUserSetDisplayMapping",
    "NtUserSetCalibrationData",
    "NtUserGetPhysicalDeviceRect",
    "NtUserRegisterTouchPadCapable",
    "NtUserGetRawPointerDeviceData",
    "NtUserGetPointerDeviceCursors",
    "NtUserGetPointerDeviceRects",
    "NtUserRegisterPointerDeviceNotifications",
    "NtUserGetPointerDeviceProperties",
    "NtUserGetPointerDevice",
    "NtUserGetPointerDevices",
    "NtUserEnableTouchPad",
    "NtUserGetPrecisionTouchPadConfiguration",
    "NtUserSetPrecisionTouchPadConfiguration",
    "NtUserPromotePointer",
    "NtUserDiscardPointerFrameMessages",
    "NtUserRegisterPointerInputTarget",
    "NtUserGetPointerInputTransform",
    "NtUserGetPointerInfoList",
    "NtUserGetPointerCursorId",
    "NtUserGetPointerType",
    "NtUserGetGestureConfig",
    "NtUserSetGestureConfig",
    "NtUserGetGestureExtArgs",
    "NtUserGetGestureInfo",
    "NtUserInjectGesture",
    "NtUserChangeWindowMessageFilterEx",
    "NtGdiXLATEOBJ_hGetColorTransform",
    "NtGdiXLATEOBJ_iXlate",
    "NtGdiXLATEOBJ_cGetPalette",
    "NtGdiEngDeleteClip",
    "NtGdiEngCreateClip",
    "NtGdiEngDeletePath",
    "NtGdiCLIPOBJ_ppoGetPath",
    "NtGdiCLIPOBJ_cEnumStart",
    "NtGdiCLIPOBJ_bEnum",
    "NtGdiBRUSHOBJ_hGetColorTransform",
    "NtGdiBRUSHOBJ_pvGetRbrush",
    "NtGdiBRUSHOBJ_pvAllocRbrush",
    "NtGdiBRUSHOBJ_ulGetBrushColor",
    "NtGdiXFORMOBJ_iGetXform",
    "NtGdiXFORMOBJ_bApplyXform",
    "NtGdiFONTOBJ_pQueryGlyphAttrs",
    "NtGdiFONTOBJ_pfdg",
    "NtGdiFONTOBJ_pifi",
    "NtGdiFONTOBJ_cGetGlyphs",
    "NtGdiFONTOBJ_pxoGetXform",
    "NtGdiFONTOBJ_vGetInfo",
    "NtGdiFONTOBJ_cGetAllGlyphHandles",
    "NtGdiFONTOBJ_pvTrueTypeFontFile",
    "NtGdiSTROBJ_dwGetCodePage",
    "NtGdiSTROBJ_vEnumStart",
    "NtGdiSTROBJ_bGetAdvanceWidths",
    "NtGdiSTROBJ_bEnumPositionsOnly",
    "NtGdiSTROBJ_bEnum",
    "NtGdiPATHOBJ_bEnumClipLines",
    "NtGdiPATHOBJ_vEnumStartClipLines",
    "NtGdiPATHOBJ_vEnumStart",
    "NtGdiPATHOBJ_bEnum",
    "NtGdiPATHOBJ_vGetBounds",
    "NtGdiEngCheckAbort",
    "NtGdiGetDhpdev",
    "NtGdiHT_Get8BPPMaskPalette",
    "NtGdiHT_Get8BPPFormatPalette",
    "NtGdiUpdateTransform",
    "NtGdiUMPDEngFreeUserMem",
    "NtGdiBRUSHOBJ_DeleteRbrush",
    "NtGdiSetPUMPDOBJ",
    "NtGdiSetUMPDSandboxState",
    "NtGdiDrawStream",
    "NtGdiHLSurfSetInformation",
    "NtGdiHLSurfGetInformation",
    "NtGdiDwmCreatedBitmapRemotingOutput",
    "NtGdiDdDDIGetScanLine",
    "NtGdiDdDDIReleaseProcessVidPnSourceOwners",
    "NtGdiDdDDIGetProcessSchedulingPriorityClass",
    "NtGdiDdDDISetProcessSchedulingPriorityClass",
    "NtGdiDdDDIGetContextSchedulingPriority",
    "NtGdiDdDDISetContextSchedulingPriority",
    "NtGdiDdDDIDestroyDCFromMemory",
    "NtGdiDdDDICreateDCFromMemory",
    "NtGdiDdDDIGetDeviceState",
    "NtGdiDdDDISetGammaRamp",
    "NtGdiDdDDIWaitForVerticalBlankEvent",
    "NtGdiDdDDIDestroyOverlay",
    "NtGdiDdDDIFlipOverlay",
    "NtGdiDdDDIUpdateOverlay",
    "NtGdiDdDDICreateOverlay",
    "NtGdiDdDDIGetPresentQueueEvent",
    "NtGdiDdDDIGetPresentHistory",
    "NtGdiDdDDISetVidPnSourceOwner1",
    "NtGdiDdDDISetVidPnSourceOwner",
    "NtGdiDdDDIQueryStatistics",
    "NtGdiDdDDIEscape",
    "NtGdiDdDDIGetSharedPrimaryHandle",
    "NtGdiDdDDICloseAdapter",
    "NtGdiDdDDIOpenAdapterFromLuid",
    "NtGdiDdDDIEnumAdapters",
    "NtGdiDdDDIOpenAdapterFromHdc",
    "NtGdiDdDDIOpenAdapterFromDeviceName",
    "NtGdiDdDDIRender",
    "NtGdiDdDDIPresent",
    "NtGdiDdDDIGetMultisampleMethodList",
    "NtGdiDdDDISetDisplayMode",
    "NtGdiDdDDIGetDisplayModeList",
    "NtGdiDdDDIUnlock",
    "NtGdiDdDDILock",
    "NtGdiDdDDIQueryAdapterInfo",
    "NtGdiDdDDIGetRuntimeData",
    "NtGdiDdDDISignalSynchronizationObject",
    "NtGdiDdDDIWaitForSynchronizationObject",
    "NtGdiDdDDIDestroySynchronizationObject",
    "NtGdiDdDDIOpenSynchronizationObject",
    "NtGdiDdDDICreateSynchronizationObject",
    "NtGdiDdDDIDestroyContext",
    "NtGdiDdDDICreateContext",
    "NtGdiDdDDIDestroyDevice",
    "NtGdiDdDDICreateDevice",
    "NtGdiDdDDIQueryAllocationResidency",
    "NtGdiDdDDISetAllocationPriority",
    "NtGdiDdDDIDestroyAllocation",
    "NtGdiDdDDIOpenResourceFromNtHandle",
    "NtGdiDdDDIOpenSyncObjectFromNtHandle",
    "NtGdiDdDDIOpenResource",
    "NtGdiDdDDIOpenNtHandleFromName",
    "NtGdiDdDDIShareObjects",
    "NtGdiDdDDIQueryResourceInfoFromNtHandle",
    "NtGdiDdDDIQueryResourceInfo",
    "NtGdiDdDDICreateAllocation",
    "NtGdiDdDDIOutputDuplReleaseFrame",
    "NtGdiDdDDIQueryRemoteVidPnSourceFromGdiDisplayName",
    "NtGdiDdDDIOutputDuplPresent",
    "NtGdiDdDDIReleaseKeyedMutex2",
    "NtGdiDdDDIAcquireKeyedMutex2",
    "NtGdiDdDDIOpenKeyedMutex2",
    "NtGdiDdDDICreateKeyedMutex2",
    "NtGdiDdDDIOutputDuplGetPointerShapeData",
    "NtGdiDdDDIOutputDuplGetMetaData",
    "NtGdiDdDDIOutputDuplGetFrameInfo",
    "NtGdiDdDDIDestroyOutputDupl",
    "NtGdiDdDDICreateOutputDupl",
    "NtGdiDdDDIReclaimAllocations",
    "NtGdiDdDDIOfferAllocations",
    "NtGdiDdDDICheckSharedResourceAccess",
    "NtGdiDdDDICheckVidPnExclusiveOwnership",
    "NtGdiDdDDIGetOverlayState",
    "NtGdiDdDDIConfigureSharedResource",
    "NtGdiDdDDIReleaseKeyedMutex",
    "NtGdiDdDDIAcquireKeyedMutex",
    "NtGdiDdDDIDestroyKeyedMutex",
    "NtGdiDdDDIOpenKeyedMutex",
    "NtGdiDdDDICreateKeyedMutex",
    "NtGdiDdDDISharedPrimaryUnLockNotification",
    "NtGdiDdDDISharedPrimaryLockNotification",
    "NtGdiDdDDISetDisplayPrivateDriverFormat",
    "NtGdiDdDDICheckExclusiveOwnership",
    "NtGdiDdDDICheckMonitorPowerState",
    "NtGdiDdDDIWaitForIdle",
    "NtGdiDdDDICheckOcclusion",
    "NtGdiDdDDIInvalidateActiveVidPn",
    "NtGdiDdDDIPollDisplayChildren",
    "NtGdiDdDDISetQueuedLimit",
    "NtGdiDdDDIPinDirectFlipResources",
    "NtGdiDdDDIUnpinDirectFlipResources",
    "NtGdiDdDDIWaitForVerticalBlankEvent2",
    "NtGdiDdDDISetContextInProcessSchedulingPriority",
    "NtGdiDdDDIGetContextInProcessSchedulingPriority",
    "NtGdiDdDDIGetSharedResourceAdapterLuid",
    "NtGdiDdDDISetStereoEnabled",
    "NtGdiDdDDIPresentMultiPlaneOverlay",
    "NtGdiDdDDICheckMultiPlaneOverlaySupport",
    "NtGdiDdDDIGetCachedHybridQueryValue",
    "NtGdiDdDDICacheHybridQueryValue",
    "NtGdiDdDDINetDispGetNextChunkInfo",
    "NtGdiDdDDINetDispQueryMiracastDisplayDeviceSupport",
    "NtGdiDdDDINetDispStartMiracastDisplayDevice",
    "NtGdiDdDDINetDispStopMiracastDisplayDevice",
    "NtGdiDdDDINetDispQueryMiracastDisplayDeviceStatus",
    "NtGdiMakeObjectUnXferable",
    "NtGdiMakeObjectXferable",
    "NtGdiDestroyPhysicalMonitor",
    "NtGdiGetPhysicalMonitorDescription",
    "NtGdiGetPhysicalMonitors",
    "NtGdiGetNumberOfPhysicalMonitors",
    "NtGdiDDCCIGetTimingReport",
    "NtGdiDDCCIGetCapabilitiesString",
    "NtGdiDDCCIGetCapabilitiesStringLength",
    "NtGdiDDCCISaveCurrentSettings",
    "NtGdiDDCCISetVCPFeature",
    "NtGdiDDCCIGetVCPFeature",
    "NtGdiDdQueryVisRgnUniqueness",
    "NtGdiDdDestroyFullscreenSprite",
    "NtGdiDdNotifyFullscreenSpriteUpdate",
    "NtGdiDdCreateFullscreenSprite",
    "NtUserShowSystemCursor",
    "NtUserSetMirrorRendering",
    "NtUserMagGetContextInformation",
    "NtUserMagSetContextInformation",
    "NtUserMagControl",
    "NtUserSlicerControl",
    "NtUserHwndSetRedirectionInfo",
    "NtUserHwndQueryRedirectionInfo",
    "NtCreateCompositionSurfaceHandle",
    "NtValidateCompositionSurfaceHandle",
    "NtBindCompositionSurface",
    "NtUnBindCompositionSurface",
    "NtQueryCompositionSurfaceBinding",
    "CFlipExBuffer::RemoveRealization",
    "NtQueryCompositionSurfaceStatistics",
    "NtOpenCompositionSurfaceSectionInfo",
    "NtOpenCompositionSurfaceSwapChainHandleInfo",
    "NtQueryCompositionSurfaceRenderingRealization",
    "NtOpenCompositionSurfaceDirtyRegion",
    "NtSetCompositionSurfaceOutOfFrameDirectFlipNotification",
    "NtSetCompositionSurfaceStatistics",
    "NtSetCompositionSurfaceBufferCompositionMode",
    "NtSetCompositionSurfaceIndependentFlipInfo",
    "NtCreateCompositionInputSink",
    "NtDuplicateCompositionInputSink",
    "NtQueryCompositionInputSink",
    "NtQueryCompositionInputSinkLuid",
    "NtUpdateInputSinkTransforms",
    "NtCompositionInputThread",
    "NtTokenManagerOpenSection",
    "NtTokenManagerOpenEvent",
    "NtTokenManagerThread",
    "NtTokenManagerGetOutOfFrameDirectFlipSurfaceUpdates",
    "NtTokenManagerDeleteOutstandingDirectFlipTokens",
    "NtTokenManagerCreateCompositionTokenHandle",
    "NtDCompositionBeginFrame",
    "NtDCompositionConfirmFrame",
    "NtDCompositionRetireFrame",
    "NtDCompositionDiscardFrame",
    "NtDCompositionGetFrameSurfaceUpdates",
    "NtDCompositionGetFrameLegacyTokens",
    "NtDCompositionDestroyConnection",
    "NtDCompositionGetConnectionBatch",
    "NtDCompositionGetFrameStatistics",
    "NtDCompositionGetDeletedResources",
    "NtDCompositionSetResourceDeletedNotificationTag",
    "NtDCompositionCreateConnection",
    "NtDCompositionDestroyChannel",
    "NtDCompositionReleaseAllResources",
    "NtDCompositionSubmitDWMBatch",
    "NtDCompositionCommitChannel",
    "NtDCompositionWaitForChannel",
    "NtDCompositionSetChannelCommitCompletionEvent",
    "NtDCompositionTelemetryTouchInteractionBegin",
    "NtDCompositionTelemetryTouchInteractionUpdate",
    "NtDCompositionTelemetryTouchInteractionEnd",
    "NtDCompositionTelemetrySetApplicationId",
    "NtDCompositionTelemetryAnimationScenarioBegin",
    "NtDCompositionTelemetryAnimationScenarioReference",
    "NtDCompositionTelemetryAnimationScenarioUnreference",
    "NtDCompositionCurrentBatchId",
    "NtDCompositionReleaseResource",
    "NtDCompositionRemoveCrossDeviceVisualChild",
    "NtDCompositionRemoveVisualChild",
    "NtDCompositionAddCrossDeviceVisualChild",
    "NtDCompositionAddVisualChild",
    "NtDCompositionReplaceVisualChildren",
    "NtDCompositionSetResourceAnimationProperty",
    "NtDCompositionSetResourceReferenceArrayProperty",
    "NtDCompositionSetResourceReferenceProperty",
    "NtDCompositionSetResourceBufferProperty",
    "NtDCompositionSetResourceIntegerProperty",
    "NtDCompositionSetResourceFloatProperty",
    "NtDCompositionSetResourceHandleProperty",
    "NtDCompositionCreateResource",
    "NtDCompositionOpenSharedResource",
    "NtDCompositionOpenSharedResourceHandle",
    "NtDCompositionCreateDwmChannel",
    "NtDCompositionCreateChannel",
    "NtDCompositionSynchronize",
    "NtDCompositionDwmSyncFlush",
    "NtDCompositionReferenceSharedResourceOnDwmChannel",
    "NtDCompositionSignalGpuFence",
    "NtDCompositionCreateAndBindSharedSection",
    "NtDCompositionSetDebugCounter",
    "NtDCompositionGetChannels",
    "NtDCompositionConnectPipe",
    "NtDCompositionRegisterThumbnailVisual",
    "NtDCompositionDuplicateHandleToProcess",
    "NtUserDestroyDCompositionHwndTarget",
    "NtUserCreateDCompositionHwndTarget",
    "NtUserWaitForRedirectionStartComplete",
    "NtUserSignalRedirectionStartComplete",
    "NtUserSetActiveProcess",
    "NtUserGetDisplayAutoRotationPreferencesByProcessId",
    "NtUserGetDisplayAutoRotationPreferences",
    "NtUserSetDisplayAutoRotationPreferences",
    "NtUserSetAutoRotation",
    "NtUserGetAutoRotationState",
    "NtUserAutoRotateScreen",
    "NtUserAcquireIAMKey",
    "NtUserSetActivationFilter",
    "NtUserSetFallbackForeground",
    "NtUserSetBrokeredForeground",
    "NtUserDisableImmersiveOwner",
    "NtUserClearForeground",
    "NtUserEnableIAMAccess",
    "NtUserGetProcessUIContextInformation",
    "NtUserSetProcessRestrictionExemption",
    "NtUserEnableMouseInPointer",
    "NtUserIsMouseInPointerEnabled",
    "NtUserPromoteMouseInPointer",
    "NtUserAutoPromoteMouseInPointer",
    "NtUserEnableMouseInputForCursorSuppression",
    "NtUserIsMouseInputEnabled",
    "NtUserInternalClipCursor",
    "NtUserCheckProcessForClipboardAccess",
    "NtUserGetClipboardAccessToken",
    "NtUserGetQueueEventStatus",
    "NtUserCompositionInputSinkLuidFromPoint",
    "NtUserUpdateWindowInputSinkHints",
    "NtUserTransformPoint",
    "NtUserTransformRect",
    "NtUserGetHimetricScaleFactorFromPixelLocation",
    "NtUserGetProcessDpiAwareness",
    "NtUserGetDpiForMonitor",
    "NtUserReportInertia",
    "NtUserLinkDpiCursor",
    "NtUserGetCursorDims",
    "NtUserGetOwnerTransformedMonitorRect"
};

//////////////////////////////////////////////////////////////////////////
// Windows 10 SP0 _W32pServiceTable
//////////////////////////////////////////////////////////////////////////
static const char* W32pServiceTable_Win10Th1_x86[] = {
    "NtUserGetOwnerTransformedMonitorRect",
    "NtUserYieldTask",
    "NtUserSetSensorPresence",
    "NtGdiWidenPath",
    "NtGdiUpdateColors",
    "NtGdiUnrealizeObject",
    "NtGdiUnmapMemFont",
    "NtGdiUnloadPrinterDriver",
    "NtGdiTransparentBlt",
    "NtGdiTransformPoints",
    "NtGdiSwapBuffers",
    "NtGdiStrokePath",
    "NtGdiStrokeAndFillPath",
    "NtGdiStretchDIBitsInternal",
    "NtGdiStretchBlt",
    "NtGdiStartPage",
    "NtGdiStartDoc",
    "NtGdiSetSizeDevice",
    "NtGdiSetVirtualResolution",
    "NtGdiSetTextJustification",
    "NtGdiSetSystemPaletteUse",
    "NtGdiSetRectRgn",
    "NtGdiSetPixelFormat",
    "NtGdiSetPixel",
    "NtGdiSetOPMSigningKeyAndSequenceNumbers",
    "NtGdiSetLayout",
    "NtGdiMirrorWindowOrg",
    "NtGdiGetDeviceWidth",
    "NtGdiSetMiterLimit",
    "NtGdiSetMetaRgn",
    "NtGdiSetMagicColors",
    "NtGdiSetLinkedUFIs",
    "NtGdiSetIcmMode",
    "NtGdiSetFontXform",
    "NtGdiSetFontEnumeration",
    "NtGdiSetDIBitsToDeviceInternal",
    "NtGdiSetDeviceGammaRamp",
    "NtGdiSetColorSpace",
    "NtGdiSetColorAdjustment",
    "NtGdiSetBrushOrg",
    "NtGdiSetBrushAttributes",
    "NtGdiSetBoundsRect",
    "NtGdiSetBitmapDimension",
    "NtGdiSetBitmapBits",
    "NtGdiSetBitmapAttributes",
    "NtGdiSelectPen",
    "NtGdiSelectFont",
    "NtGdiSelectClipPath",
    "NtGdiSelectBrush",
    "NtGdiSelectBitmap",
    "NtGdiScaleWindowExtEx",
    "NtGdiScaleViewportExtEx",
    "NtGdiSaveDC",
    "NtGdiRoundRect",
    "NtGdiRestoreDC",
    "NtGdiResizePalette",
    "NtGdiResetDC",
    "NtGdiRemoveFontMemResourceEx",
    "NtGdiRemoveFontResourceW",
    "NtGdiRectVisible",
    "NtGdiRectInRegion",
    "NtGdiRectangle",
    "NtGdiQueryFontAssocInfo",
    "NtGdiQueryFonts",
    "NtGdiPtVisible",
    "NtGdiPtInRegion",
    "NtGdiPolyTextOutW",
    "NtGdiPolyPolyDraw",
    "NtGdiPolyDraw",
    "NtGdiPlgBlt",
    "NtGdiPathToRegion",
    "NtGdiPolyPatBlt",
    "NtGdiPatBlt",
    "NtGdiOpenDCW",
    "NtGdiOffsetRgn",
    "NtGdiOffsetClipRgn",
    "NtGdiMoveTo",
    "NtGdiMonoBitmap",
    "NtGdiModifyWorldTransform",
    "NtGdiMaskBlt",
    "NtGdiMakeInfoDC",
    "NtGdiMakeFontDir",
    "NtGdiLineTo",
    "NtGdiInvertRgn",
    "NtGdiIntersectClipRect",
    "NtGdiInitSpool",
    "NtGdiInit",
    "NtGdiIcmBrushInfo",
    "NtGdiHfontCreate",
    "NtGdiGradientFill",
    "NtGdiGetWidthTable",
    "NtGdiGetFontUnicodeRanges",
    "NtGdiAddEmbFontToDC",
    "NtGdiChangeGhostFont",
    "NtGdiGetEmbedFonts",
    "NtGdiGetUFIPathname",
    "NtGdiGetEmbUFI",
    "NtGdiGetUFI",
    "NtGdiGetTransform",
    "NtGdiGetTextMetricsW",
    "NtGdiGetTextFaceW",
    "NtGdiGetTextExtentExW",
    "NtGdiGetTextExtent",
    "NtGdiGetTextCharsetInfo",
    "NtGdiGetSystemPaletteUse",
    "NtGdiGetSuggestedOPMProtectedOutputArraySize",
    "NtGdiGetStringBitmapW",
    "NtGdiGetStockObject",
    "NtGdiGetStats",
    "NtGdiGetSpoolMessage",
    "NtGdiGetServerMetaFileBits",
    "NtGdiGetRgnBox",
    "NtGdiGetRegionData",
    "NtGdiGetRealizationInfo",
    "NtGdiGetRasterizerCaps",
    "NtGdiGetRandomRgn",
    "NtGdiGetPixel",
    "NtGdiGetPath",
    "NtGdiGetOutlineTextMetricsInternalW",
    "NtGdiGetOPMRandomNumber",
    "NtGdiGetObjectBitmapHandle",
    "NtGdiGetNearestPaletteIndex",
    "NtGdiGetNearestColor",
    "NtGdiGetMonitorID",
    "NtGdiGetMiterLimit",
    "NtGdiGetLinkedUFIs",
    "NtGdiGetKerningPairs",
    "NtGdiGetOPMInformation",
    "NtGdiGetGlyphOutline",
    "NtGdiGetGlyphIndicesWInternal",
    "NtGdiGetGlyphIndicesW",
    "NtGdiGetFontResourceInfoInternalW",
    "NtGdiGetFontFileInfo",
    "NtGdiGetFontFileData",
    "NtGdiGetFontData",
    "NtGdiGetEudcTimeStampEx",
    "NtGdiGetETM",
    "NtGdiGetDIBitsInternal",
    "NtGdiGetDeviceCapsAll",
    "NtGdiGetDeviceGammaRamp",
    "NtGdiGetDeviceCaps",
    "NtGdiGetDCPoint",
    "NtGdiGetDCObject",
    "NtGdiGetDCforBitmap",
    "NtGdiGetDCDword",
    "NtGdiGetCurrentDpiInfo",
    "NtGdiGetCOPPCompatibleOPMInformation",
    "NtGdiGetColorSpaceforBitmap",
    "NtGdiGetColorAdjustment",
    "NtGdiGetCharWidthInfo",
    "NtGdiGetCharWidthW",
    "NtGdiGetCharSet",
    "NtGdiGetCharacterPlacementW",
    "NtGdiGetCharABCWidthsW",
    "NtGdiGetCertificateSize",
    "NtGdiGetCertificate",
    "NtGdiGetBoundsRect",
    "NtGdiGetBitmapDimension",
    "NtGdiGetBitmapBits",
    "NtGdiGetAppClipBox",
    "NtGdiGetAndSetDCDword",
    "NtGdiFullscreenControl",
    "NtGdiFrameRgn",
    "NtGdiForceUFIMapping",
    "NtGdiFlush",
    "NtGdiFlattenPath",
    "NtGdiFillRgn",
    "NtGdiFillPath",
    "NtGdiExtTextOutW",
    "NtGdiExtSelectClipRgn",
    "NtGdiExtGetObjectW",
    "NtGdiExtFloodFill",
    "NtGdiExtEscape",
    "NtGdiExtCreateRegion",
    "NtGdiExtCreatePen",
    "NtGdiExcludeClipRect",
    "NtGdiEudcLoadUnloadLink",
    "NtGdiEqualRgn",
    "NtGdiEnumObjects",
    "NtGdiEnumFonts",
    "NtGdiEndPath",
    "NtGdiEndPage",
    "NtGdiEndGdiRendering",
    "NtGdiEndDoc",
    "NtGdiEnableEudc",
    "NtGdiEllipse",
    "NtGdiDrawEscape",
    "NtGdiDoPalette",
    "NtGdiDoBanding",
    "NtGdiGetPerBandInfo",
    "NtGdiDestroyOPMProtectedOutput",
    "NtGdiDescribePixelFormat",
    "NtGdiDeleteObjectApp",
    "NtGdiDeleteColorTransform",
    "NtGdiDeleteColorSpace",
    "NtGdiDeleteClientObj",
    "NtGdiDxgGenericThunk",
    "NtGdiDvpReleaseNotification",
    "NtGdiDvpAcquireNotification",
    "NtGdiDvpWaitForVideoPortSync",
    "NtGdiDvpUpdateVideoPort",
    "NtGdiDvpGetVideoSignalStatus",
    "NtGdiDvpGetVideoPortConnectInfo",
    "NtGdiDvpGetVideoPortOutputFormats",
    "NtGdiDvpGetVideoPortLine",
    "NtGdiDvpGetVideoPortInputFormats",
    "NtGdiDvpGetVideoPortFlipStatus",
    "NtGdiDvpGetVideoPortField",
    "NtGdiDvpGetVideoPortBandwidth",
    "NtGdiDvpFlipVideoPort",
    "NtGdiDvpDestroyVideoPort",
    "NtGdiDvpCreateVideoPort",
    "NtGdiDvpColorControl",
    "NtGdiDvpCanCreateVideoPort",
    "NtGdiDdWaitForVerticalBlank",
    "NtGdiDdUpdateOverlay",
    "NtGdiDdUnlockD3D",
    "NtGdiDdUnlock",
    "NtGdiDdUnattachSurface",
    "NtGdiDdSetOverlayPosition",
    "NtGdiDdCreateSurfaceEx",
    "NtGdiDdSetGammaRamp",
    "NtGdiDdSetExclusiveMode",
    "NtGdiDdSetColorKey",
    "NtGdiDdResetVisrgn",
    "NtGdiDdRenderMoComp",
    "NtGdiDdReleaseDC",
    "NtGdiDdReenableDirectDrawObject",
    "NtGdiDdQueryMoCompStatus",
    "NtGdiDdQueryDirectDrawObject",
    "NtGdiDdLockD3D",
    "NtGdiDdLock",
    "NtGdiDdGetScanLine",
    "NtGdiDdGetMoCompFormats",
    "NtGdiDdGetMoCompGuids",
    "NtGdiDdGetMoCompBuffInfo",
    "NtGdiDdGetInternalMoCompInfo",
    "NtGdiDdGetFlipStatus",
    "NtGdiDdGetDxHandle",
    "NtGdiDdGetDriverInfo",
    "NtGdiDdGetDC",
    "NtGdiDdGetBltStatus",
    "NtGdiDdGetAvailDriverMemory",
    "NtGdiDdFlipToGDISurface",
    "NtGdiDdFlip",
    "NtGdiDdEndMoCompFrame",
    "NtGdiDdDestroyD3DBuffer",
    "NtGdiDdDestroySurface",
    "NtGdiDdDestroyMoComp",
    "NtGdiDdDeleteSurfaceObject",
    "NtGdiDdDeleteDirectDrawObject",
    "NtGdiDdCreateSurfaceObject",
    "NtGdiDdCreateMoComp",
    "NtGdiDdCreateD3DBuffer",
    "NtGdiDdCreateSurface",
    "NtGdiDdCreateDirectDrawObject",
    "NtGdiDdColorControl",
    "NtGdiDdCanCreateD3DBuffer",
    "NtGdiDdCanCreateSurface",
    "NtGdiDdBlt",
    "NtGdiDdBeginMoCompFrame",
    "NtGdiDdAttachSurface",
    "NtGdiDdAlphaBlt",
    "NtGdiDdAddAttachedSurface",
    "NtGdiDdGetDriverState",
    "NtGdiD3dDrawPrimitives2",
    "NtGdiD3dValidateTextureStageState",
    "NtGdiD3dContextDestroyAll",
    "NtGdiD3dContextDestroy",
    "NtGdiD3dContextCreate",
    "NtGdiCreateSolidBrush",
    "NtGdiCreateServerMetaFile",
    "NtGdiCreateRoundRectRgn",
    "NtGdiCreateRectRgn",
    "NtGdiCreatePen",
    "NtGdiCreatePatternBrushInternal",
    "NtGdiCreatePaletteInternal",
    "NtGdiCreateOPMProtectedOutputs",
    "NtGdiCreateMetafileDC",
    "NtGdiCreateHatchBrushInternal",
    "NtGdiCreateHalftonePalette",
    "NtGdiCreateEllipticRgn",
    "NtGdiCreateSessionMappedDIBSection",
    "NtGdiCreateDIBSection",
    "NtGdiCreateDIBitmapInternal",
    "NtGdiCreateDIBBrush",
    "NtGdiCreateCompatibleDC",
    "NtGdiCreateCompatibleBitmap",
    "NtGdiCreateColorTransform",
    "NtGdiCreateColorSpace",
    "NtGdiCreateClientObj",
    "NtGdiCreateBitmapFromDxSurface2",
    "NtGdiCreateBitmapFromDxSurface",
    "NtGdiCreateBitmap",
    "NtGdiConvertMetafileRect",
    "NtGdiConfigureOPMProtectedOutput",
    "NtGdiComputeXformCoefficients",
    "NtGdiCombineTransform",
    "NtGdiCombineRgn",
    "NtGdiColorCorrectPalette",
    "NtGdiClearBrushAttributes",
    "NtGdiClearBitmapAttributes",
    "NtGdiCloseFigure",
    "NtGdiCheckBitmapBits",
    "NtGdiCancelDC",
    "NtGdiBitBlt",
    "NtGdiBeginPath",
    "NtGdiBeginGdiRendering",
    "NtGdiArcInternal",
    "NtGdiFontIsLinked",
    "NtGdiAnyLinkedFonts",
    "NtGdiAngleArc",
    "NtGdiAlphaBlend",
    "NtGdiAddRemoteMMInstanceToDC",
    "NtGdiRemoveMergeFont",
    "NtGdiAddFontMemResourceEx",
    "NtGdiAddRemoteFontToDC",
    "NtGdiAddFontResourceW",
    "NtGdiAbortPath",
    "NtGdiAbortDoc",
    "NtUserDefSetText",
    "NtUserDeferWindowPosAndBand",
    "NtUserDdeInitialize",
    "NtUserCanBrokerForceForeground",
    "NtUserCreateWindowStation",
    "NtUserCreateWindowEx",
    "NtUserCreateLocalMemHandle",
    "NtUserCreateInputContext",
    "NtUserCreateDesktopEx",
    "NtUserCreateCaret",
    "NtUserCreateAcceleratorTable",
    "NtUserCountClipboardFormats",
    "NtUserCopyAcceleratorTable",
    "NtUserConvertMemHandle",
    "NtUserConsoleControl",
    "NtUserCloseWindowStation",
    "NtUserCloseDesktop",
    "NtUserCloseClipboard",
    "NtUserClipCursor",
    "NtUserChildWindowFromPointEx",
    "NtUserCheckMenuItem",
    "NtUserCheckWindowThreadDesktop",
    "NtUserDwmValidateWindow",
    "NtUserCheckAccessForIntegrityLevel",
    "NtUserDisplayConfigSetDeviceInfo",
    "NtUserDisplayConfigGetDeviceInfo",
    "NtUserQueryDisplayConfig",
    "NtUserSetDisplayConfig",
    "NtUserGetDisplayConfigBufferSizes",
    "NtUserChangeDisplaySettings",
    "NtUserChangeClipboardChain",
    "NtUserCallTwoParam",
    "NtUserCallOneParam",
    "NtUserCallNoParam",
    "NtUserCallNextHookEx",
    "NtUserCallMsgFilter",
    "NtUserCallHwndParamLock",
    "NtUserCallHwndParam",
    "NtUserCallHwndOpt",
    "NtUserCallHwndLock",
    "NtUserCallHwnd",
    "NtUserBuildPropList",
    "NtUserBuildNameList",
    "NtUserBuildHwndList",
    "NtUserBuildHimcList",
    "NtUserBlockInput",
    "NtUserBitBltSysBmp",
    "NtUserBeginPaint",
    "NtUserAttachThreadInput",
    "NtUserAssociateInputContext",
    "NtUserAlterWindowStyle",
    "NtUserAddClipboardFormatListener",
    "NtUserActivateKeyboardLayout",
    "NtUserDelegateCapturePointers",
    "NtUserDelegateInput",
    "NtUserDispatchMessage",
    "NtUserDisableProcessWindowFiltering",
    "NtUserDisableThreadIme",
    "NtUserDestroyWindow",
    "NtUserDestroyMenu",
    "NtUserDestroyInputContext",
    "NtUserDestroyCursor",
    "NtUserDestroyAcceleratorTable",
    "NtUserDeleteMenu",
    "NtUserDoSoundDisconnect",
    "NtUserDoSoundConnect",
    "NtUserGhostWindowFromHungWindow",
    "NtUserGetWOWClass",
    "NtUserGetWindowPlacement",
    "NtUserGetWindowDisplayAffinity",
    "NtUserGetWindowDC",
    "NtUserGetWindowCompositionAttribute",
    "NtUserGetWindowCompositionInfo",
    "NtUserGetWindowBand",
    "NtUserGetUpdateRgn",
    "NtUserGetUpdateRect",
    "NtUserGetUpdatedClipboardFormats",
    "NtUserGetTopLevelWindow",
    "NtUserGetTitleBarInfo",
    "NtUserGetThreadState",
    "NtUserGetThreadDesktop",
    "NtUserGetSystemMenu",
    "NtUserGetScrollBarInfo",
    "NtUserGetRegisteredRawInputDevices",
    "NtUserGetRawInputDeviceList",
    "NtUserGetRawInputDeviceInfo",
    "NtUserGetRawInputData",
    "NtUserGetRawInputBuffer",
    "NtUserGetProcessWindowStation",
    "NtUserGetPriorityClipboardFormat",
    "NtUserGetOpenClipboardWindow",
    "NtUserGetObjectInformation",
    "NtUserGetMouseMovePointsEx",
    "NtUserGetMessage",
    "NtUserGetMenuItemRect",
    "NtUserGetMenuIndex",
    "NtUserGetMenuBarInfo",
    "NtUserGetListBoxInfo",
    "NtUserGetKeyState",
    "NtUserGetKeyNameText",
    "NtUserGetKeyboardState",
    "NtUserGetKeyboardLayoutName",
    "NtUserGetKeyboardLayoutList",
    "NtUserGetInternalWindowPos",
    "NtUserGetInputLocaleInfo",
    "NtUserGetImeInfoEx",
    "NtUserGetImeHotKey",
    "NtUserGetIconSize",
    "NtUserGetIconInfo",
    "NtUserGetGUIThreadInfo",
    "NtUserGetGuiResources",
    "NtUserGetForegroundWindow",
    "NtUserGetDpiSystemMetrics",
    "NtUserGetDoubleClickTime",
    "NtUserGetDesktopID",
    "NtUserGetDCEx",
    "NtUserGetDC",
    "NtUserGetCursorInfo",
    "NtUserGetCursorFrameInfo",
    "NtUserGetCurrentInputMessageSource",
    "NtUserGetCIMSSM",
    "NtUserGetCPD",
    "NtUserGetControlColor",
    "NtUserGetControlBrush",
    "NtUserGetComboBoxInfo",
    "NtUserGetClipCursor",
    "NtUserGetClipboardViewer",
    "NtUserGetClipboardSequenceNumber",
    "NtUserGetClipboardOwner",
    "NtUserGetClipboardFormatName",
    "NtUserGetClipboardData",
    "NtUserGetClassName",
    "NtUserGetClassInfoEx",
    "NtUserGetCaretPos",
    "NtUserGetCaretBlinkTime",
    "NtUserGetAtomName",
    "NtUserGetAsyncKeyState",
    "NtUserGetAppImeLevel",
    "NtUserGetAncestor",
    "NtUserGetAltTabInfo",
    "NtUserFrostCrashedWindow",
    "NtUserFlashWindowEx",
    "NtUserFindWindowEx",
    "NtUserFindExistingCursorIcon",
    "NtUserFillWindow",
    "NtUserExcludeUpdateRgn",
    "NtUserEvent",
    "NtUserEnumDisplaySettings",
    "NtUserEnumDisplayMonitors",
    "NtUserEnumDisplayDevices",
    "NtUserEndPaint",
    "NtUserEndMenu",
    "NtUserEndDeferWindowPosEx",
    "NtUserEnableScrollBar",
    "NtUserEnableMenuItem",
    "NtUserEmptyClipboard",
    "NtUserDrawMenuBarTemp",
    "NtUserDrawIconEx",
    "NtUserDrawCaptionTemp",
    "NtUserDrawCaption",
    "NtUserDrawAnimatedRects",
    "NtUserDragObject",
    "NtUserDragDetect",
    "NtUserHandleDelegatedInput",
    "NtUserRealChildWindowFromPoint",
    "NtUserQueryWindow",
    "NtUserQuerySendMessage",
    "NtUserQueryInputContext",
    "NtUserQueryInformationThread",
    "NtUserQueryBSDRWindow",
    "NtUserPerMonitorDPIPhysicalToLogicalPoint",
    "NtUserProcessConnect",
    "NtUserPrintWindow",
    "NtUserPostThreadMessage",
    "NtUserPostMessage",
    "NtUserPhysicalToLogicalPoint",
    "NtUserPeekMessage",
    "NtUserPaintMonitor",
    "NtUserPaintDesktop",
    "NtUserOpenWindowStation",
    "NtUserOpenThreadDesktop",
    "NtUserOpenInputDesktop",
    "NtUserOpenDesktop",
    "NtUserOpenClipboard",
    "NtUserNotifyWinEvent",
    "NtUserNotifyProcessCreate",
    "NtUserNotifyIMEStatus",
    "NtUserMoveWindow",
    "NtUserModifyUserStartupInfoFlags",
    "NtUserMNDragOver",
    "NtUserMNDragLeave",
    "NtUserMinMaximize",
    "NtUserMessageCall",
    "NtUserMenuItemFromPoint",
    "NtUserMapVirtualKeyEx",
    "NtUserLayoutCompleted",
    "NtUserLogicalToPerMonitorDPIPhysicalPoint",
    "NtUserLogicalToPhysicalPoint",
    "NtUserLockWorkStation",
    "NtUserLockWindowUpdate",
    "NtUserLockWindowStation",
    "NtUserLoadKeyboardLayoutEx",
    "NtUserKillTimer",
    "NtUserIsTopLevelWindow",
    "NtUserIsClipboardFormatAvailable",
    "NtUserInvalidateRgn",
    "NtUserInvalidateRect",
    "NtUserInternalGetWindowIcon",
    "NtUserInternalGetWindowText",
    "NtUserInitTask",
    "NtUserInitializeClientPfnArrays",
    "NtUserInitialize",
    "NtUserImpersonateDdeClientWindow",
    "NtUserHungWindowFromGhostWindow",
    "NtUserHiliteMenuItem",
    "NtUserHideCaret",
    "NtUserHardErrorControl",
    "NtUserRealInternalGetMessage",
    "NtUserRealWaitMessageEx",
    "NtUserReleaseDwmHitTestWaiters",
    "NtUserTranslateMessage",
    "NtUserTranslateAccelerator",
    "NtUserPaintMenuBar",
    "NtUserCalcMenuBar",
    "NtUserCalculatePopupWindowPosition",
    "NtUserTrackPopupMenuEx",
    "NtUserTrackMouseEvent",
    "NtUserToUnicodeEx",
    "NtUserThunkedMenuItemInfo",
    "NtUserThunkedMenuInfo",
    "NtUserTestForInteractiveUser",
    "NtUserSendEventMessage",
    "NtUserSystemParametersInfo",
    "NtUserSwitchDesktop",
    "NtUserSoundSentry",
    "NtUserShutdownReasonDestroy",
    "NtUserShutdownBlockReasonQuery",
    "NtUserShutdownBlockReasonCreate",
    "NtUserShowWindowAsync",
    "NtUserShowWindow",
    "NtUserShowScrollBar",
    "NtUserShowCaret",
    "NtUserSetWinEventHook",
    "NtUserSetWindowWord",
    "NtUserSetWindowStationUser",
    "NtUserSetWindowsHookEx",
    "NtUserSetWindowsHookAW",
    "NtUserSetWindowRgnEx",
    "NtUserGetWindowRgnEx",
    "NtUserSetWindowRgn",
    "NtUserSetWindowPos",
    "NtUserSetWindowPlacement",
    "NtUserSetWindowLong",
    "NtUserSetWindowFNID",
    "NtUserSetWindowDisplayAffinity",
    "NtUserSetWindowCompositionTransition",
    "NtUserUpdateDefaultDesktopThumbnail",
    "NtUserSetWindowCompositionAttribute",
    "NtUserSetWindowBand",
    "NtUserSetProcessUIAccessZorder",
    "NtUserSetProcessDpiAwareness",
    "NtUserEnableChildWindowDpiMessage",
    "NtUserIsChildWindowDpiMessageEnabled",
    "NtUserIsWindowBroadcastingDpiToChildren",
    "NtUserSetTimer",
    "NtUserSetThreadState",
    "NtUserSetThreadLayoutHandles",
    "NtUserSetThreadDesktop",
    "NtUserSetThreadInputBlocked",
    "NtUserSetSystemTimer",
    "NtUserSetSystemMenu",
    "NtUserSetSystemCursor",
    "NtUserSetSysColors",
    "NtUserSetShellWindowEx",
    "NtUserSetImmersiveBackgroundWindow",
    "NtUserSetScrollInfo",
    "NtUserSetProp",
    "NtUserGetProp",
    "NtUserSetProcessWindowStation",
    "NtUserSetParent",
    "NtUserSetObjectInformation",
    "NtUserSetMenuFlagRtoL",
    "NtUserSetMenuDefaultItem",
    "NtUserSetMenuContextHelpId",
    "NtUserSetMenu",
    "NtUserSetKeyboardState",
    "NtUserSetInternalWindowPos",
    "NtUserSetInformationThread",
    "NtUserSetImeOwnerWindow",
    "NtUserSetImeInfoEx",
    "NtUserSetImeHotKey",
    "NtUserSetFocus",
    "NtUserSetCursorIconData",
    "NtUserSetCursorContents",
    "NtUserSetCursor",
    "NtUserSetClipboardViewer",
    "NtUserSetClipboardData",
    "NtUserSetClassWord",
    "NtUserSetClassLong",
    "NtUserSetChildWindowNoActivate",
    "NtUserSetCapture",
    "NtUserSetAppImeLevel",
    "NtUserSetActiveWindow",
    "NtUserSendInput",
    "NtUserSelectPalette",
    "NtUserScrollWindowEx",
    "NtUserScrollDC",
    "NtUserSBGetParms",
    "NtUserResolveDesktopForWOW",
    "NtUserRemoveProp",
    "NtUserRemoveMenu",
    "NtUserRemoveClipboardFormatListener",
    "NtUserRegisterWindowMessage",
    "NtUserRegisterTasklist",
    "NtUserRegisterServicesProcess",
    "NtUserRegisterRawInputDevices",
    "NtUserRegisterHotKey",
    "NtUserRegisterDManipHook",
    "NtUserGetDManipHookInitFunction",
    "NtUserRegisterManipulationThread",
    "NtUserSetManipulationInputTarget",
    "NtUserRegisterUserApiHook",
    "NtUserRegisterErrorReportingDialog",
    "NtUserRegisterClassExWOW",
    "NtUserRegisterBSDRWindow",
    "NtUserRedrawWindow",
    "NtUserUndelegateInput",
    "NtUserGetWindowMinimizeRect",
    "NtUserDwmGetRemoteSessionOcclusionEvent",
    "NtUserDwmGetRemoteSessionOcclusionState",
    "NtUserDwmKernelShutdown",
    "NtUserDwmKernelStartup",
    "NtUserUpdateWindowTransform",
    "NtUserCheckProcessSession",
    "NtUserUnregisterSessionPort",
    "NtUserRegisterSessionPort",
    "NtUserCtxDisplayIOCtl",
    "NtUserRemoteStopScreenUpdates",
    "NtUserRemoteRedrawScreen",
    "NtUserRemoteRedrawRectangle",
    "NtUserRemoteConnect",
    "NtUserWaitAvailableMessageEx",
    "NtUserWindowFromPoint",
    "NtUserWindowFromPhysicalPoint",
    "NtUserWaitMessage",
    "NtUserWaitForMsgAndEvent",
    "NtUserWaitForInputIdle",
    "NtUserVkKeyScanEx",
    "NtUserValidateTimerCallback",
    "NtUserValidateRect",
    "NtUserValidateHandleSecure",
    "NtUserUserHandleGrantAccess",
    "NtUserUpdatePerUserSystemParameters",
    "NtUserSetLayeredWindowAttributes",
    "NtUserGetLayeredWindowAttributes",
    "NtUserUpdateLayeredWindow",
    "NtUserUpdateInstance",
    "NtUserUpdateInputContext",
    "NtUserUnregisterHotKey",
    "NtUserUnregisterUserApiHook",
    "NtUserUnregisterClass",
    "NtUserUnlockWindowStation",
    "NtUserUnloadKeyboardLayout",
    "NtUserUnhookWinEvent",
    "NtUserUnhookWindowsHookEx",
    "NtUserGetTouchInputInfo",
    "NtUserIsTouchWindow",
    "NtUserModifyWindowTouchCapability",
    "NtGdiEngStretchBltROP",
    "NtGdiEngTextOut",
    "NtGdiEngTransparentBlt",
    "NtGdiEngGradientFill",
    "NtGdiEngAlphaBlend",
    "NtGdiEngLineTo",
    "NtGdiEngPaint",
    "NtGdiEngStrokeAndFillPath",
    "NtGdiEngFillPath",
    "NtGdiEngStrokePath",
    "NtGdiEngMarkBandingSurface",
    "NtGdiEngPlgBlt",
    "NtGdiEngStretchBlt",
    "NtGdiEngBitBlt",
    "NtGdiEngLockSurface",
    "NtGdiEngUnlockSurface",
    "NtGdiEngEraseSurface",
    "NtGdiEngDeleteSurface",
    "NtGdiEngDeletePalette",
    "NtGdiEngCopyBits",
    "NtGdiEngComputeGlyphSet",
    "NtGdiEngCreatePalette",
    "NtGdiEngCreateDeviceBitmap",
    "NtGdiEngCreateDeviceSurface",
    "NtGdiEngCreateBitmap",
    "NtGdiEngAssociateSurface",
    "NtUserSetWindowFeedbackSetting",
    "NtUserRegisterEdgy",
    "NtUserRegisterShellPTPListener",
    "NtUserGetWindowFeedbackSetting",
    "NtUserHidePointerContactVisualization",
    "NtUserGetTouchValidationStatus",
    "NtUserInitializeTouchInjection",
    "NtUserInjectTouchInput",
    "NtUserRegisterTouchHitTestingWindow",
    "NtUserSetDisplayMapping",
    "NtUserSetCalibrationData",
    "NtUserGetPhysicalDeviceRect",
    "NtUserRegisterTouchPadCapable",
    "NtUserGetRawPointerDeviceData",
    "NtUserGetPointerDeviceCursors",
    "NtUserGetPointerDeviceRects",
    "NtUserRegisterPointerDeviceNotifications",
    "NtUserGetPointerDeviceProperties",
    "NtUserGetPointerDevice",
    "NtUserGetPointerDevices",
    "NtUserEnableTouchPad",
    "NtUserGetPrecisionTouchPadConfiguration",
    "NtUserSetPrecisionTouchPadConfiguration",
    "NtUserPromotePointer",
    "NtUserDiscardPointerFrameMessages",
    "NtUserRegisterPointerInputTarget",
    "NtUserGetPointerFrameArrivalTimes",
    "NtUserGetPointerInputTransform",
    "NtUserGetPointerInfoList",
    "NtUserGetPointerCursorId",
    "NtUserGetPointerType",
    "NtUserGetGestureConfig",
    "NtUserSetGestureConfig",
    "NtUserGetGestureExtArgs",
    "NtUserGetGestureInfo",
    "NtUserInjectGesture",
    "NtUserChangeWindowMessageFilterEx",
    "NtGdiXLATEOBJ_hGetColorTransform",
    "NtGdiXLATEOBJ_iXlate",
    "NtGdiXLATEOBJ_cGetPalette",
    "NtGdiEngDeleteClip",
    "NtGdiEngCreateClip",
    "NtGdiEngDeletePath",
    "NtGdiCLIPOBJ_ppoGetPath",
    "NtGdiCLIPOBJ_cEnumStart",
    "NtGdiCLIPOBJ_bEnum",
    "NtGdiBRUSHOBJ_hGetColorTransform",
    "NtGdiBRUSHOBJ_pvGetRbrush",
    "NtGdiBRUSHOBJ_pvAllocRbrush",
    "NtGdiBRUSHOBJ_ulGetBrushColor",
    "NtGdiXFORMOBJ_iGetXform",
    "NtGdiXFORMOBJ_bApplyXform",
    "NtGdiFONTOBJ_pQueryGlyphAttrs",
    "NtGdiFONTOBJ_pfdg",
    "NtGdiFONTOBJ_pifi",
    "NtGdiFONTOBJ_cGetGlyphs",
    "NtGdiFONTOBJ_pxoGetXform",
    "NtGdiFONTOBJ_vGetInfo",
    "NtGdiFONTOBJ_cGetAllGlyphHandles",
    "NtGdiFONTOBJ_pvTrueTypeFontFile",
    "NtGdiSTROBJ_dwGetCodePage",
    "NtGdiSTROBJ_vEnumStart",
    "NtGdiSTROBJ_bGetAdvanceWidths",
    "NtGdiSTROBJ_bEnumPositionsOnly",
    "NtGdiSTROBJ_bEnum",
    "NtGdiPATHOBJ_bEnumClipLines",
    "NtGdiPATHOBJ_vEnumStartClipLines",
    "NtGdiPATHOBJ_vEnumStart",
    "NtGdiPATHOBJ_bEnum",
    "NtGdiPATHOBJ_vGetBounds",
    "NtGdiEngCheckAbort",
    "NtGdiGetDhpdev",
    "NtGdiHT_Get8BPPMaskPalette",
    "NtGdiHT_Get8BPPFormatPalette",
    "NtGdiUpdateTransform",
    "NtGdiUMPDEngFreeUserMem",
    "NtGdiBRUSHOBJ_DeleteRbrush",
    "NtGdiSetPUMPDOBJ",
    "NtGdiSetUMPDSandboxState",
    "NtGdiDrawStream",
    "NtGdiHLSurfSetInformation",
    "NtGdiHLSurfGetInformation",
    "NtGdiDwmCreatedBitmapRemotingOutput",
    "NtGdiDdDDIGetScanLine",
    "NtGdiDdDDIReleaseProcessVidPnSourceOwners",
    "NtGdiDdDDIGetProcessSchedulingPriorityClass",
    "NtGdiDdDDISetProcessSchedulingPriorityClass",
    "NtGdiDdDDIGetContextSchedulingPriority",
    "NtGdiDdDDISetContextSchedulingPriority",
    "NtGdiDdDDIDestroyDCFromMemory",
    "NtGdiDdDDICreateDCFromMemory",
    "NtGdiDdDDIGetDeviceState",
    "NtGdiDdDDISetGammaRamp",
    "NtGdiDdDDIWaitForVerticalBlankEvent",
    "NtGdiDdDDIDestroyOverlay",
    "NtGdiDdDDIFlipOverlay",
    "NtGdiDdDDIUpdateOverlay",
    "NtGdiDdDDICreateOverlay",
    "NtGdiDdDDIGetPresentQueueEvent",
    "NtGdiDdDDIGetPresentHistory",
    "NtGdiDdDDISetVidPnSourceOwner1",
    "NtGdiDdDDISetVidPnSourceOwner",
    "NtGdiDdDDIQueryStatistics",
    "NtGdiDdDDIEscape",
    "NtGdiDdDDIGetSharedPrimaryHandle",
    "NtGdiDdDDICloseAdapter",
    "NtGdiDdDDIOpenAdapterFromLuid",
    "NtGdiDdDDIEnumAdapters",
    "NtGdiDdDDIEnumAdapters2",
    "NtGdiDdDDIOpenAdapterFromHdc",
    "NtGdiDdDDIOpenAdapterFromDeviceName",
    "NtGdiDdDDIRender",
    "NtGdiDdDDIPresent",
    "NtGdiDdDDIGetMultisampleMethodList",
    "NtGdiDdDDISetDisplayMode",
    "NtGdiDdDDIGetDisplayModeList",
    "NtGdiDdDDIUnlock",
    "NtGdiDdDDILock",
    "NtGdiDdDDIQueryAdapterInfo",
    "NtGdiDdDDIGetRuntimeData",
    "NtGdiDdDDISignalSynchronizationObject",
    "NtGdiDdDDIWaitForSynchronizationObject",
    "NtGdiDdDDIDestroySynchronizationObject",
    "NtGdiDdDDIOpenSynchronizationObject",
    "NtGdiDdDDICreateSynchronizationObject",
    "NtGdiDdDDIDestroyContext",
    "NtGdiDdDDICreateContext",
    "NtGdiDdDDIDestroyDevice",
    "NtGdiDdDDICreateDevice",
    "NtGdiDdDDIQueryAllocationResidency",
    "NtGdiDdDDISetAllocationPriority",
    "NtGdiDdDDIDestroyAllocation",
    "NtGdiDdDDIDestroyAllocation2",
    "NtGdiDdDDIOpenResourceFromNtHandle",
    "NtGdiDdDDIOpenSyncObjectFromNtHandle",
    "NtGdiDdDDIOpenSyncObjectFromNtHandle2",
    "NtGdiDdDDIOpenResource",
    "NtGdiDdDDIOpenNtHandleFromName",
    "NtGdiDdDDIOpenSyncObjectNtHandleFromName",
    "NtGdiDdDDIShareObjects",
    "NtGdiDdDDIQueryResourceInfoFromNtHandle",
    "NtGdiDdDDIQueryResourceInfo",
    "NtGdiDdDDICreateAllocation",
    "NtGdiDdDDIOutputDuplReleaseFrame",
    "NtGdiDdDDIQueryRemoteVidPnSourceFromGdiDisplayName",
    "NtGdiDdDDIOutputDuplPresent",
    "NtGdiDdDDIReleaseKeyedMutex2",
    "NtGdiDdDDIAcquireKeyedMutex2",
    "NtGdiDdDDIOpenKeyedMutex2",
    "NtGdiDdDDICreateKeyedMutex2",
    "NtGdiDdDDIOutputDuplGetPointerShapeData",
    "NtGdiDdDDIOutputDuplGetMetaData",
    "NtGdiDdDDIOutputDuplGetFrameInfo",
    "NtGdiDdDDIDestroyOutputDupl",
    "NtGdiDdDDICreateOutputDupl",
    "NtGdiDdDDIReclaimAllocations",
    "NtGdiDdDDIOfferAllocations",
    "NtGdiDdDDICheckSharedResourceAccess",
    "NtGdiDdDDICheckVidPnExclusiveOwnership",
    "NtGdiDdDDIGetOverlayState",
    "NtGdiDdDDIConfigureSharedResource",
    "NtGdiDdDDIReleaseKeyedMutex",
    "NtGdiDdDDIAcquireKeyedMutex",
    "NtGdiDdDDIDestroyKeyedMutex",
    "NtGdiDdDDIOpenKeyedMutex",
    "NtGdiDdDDICreateKeyedMutex",
    "NtGdiDdDDISharedPrimaryUnLockNotification",
    "NtGdiDdDDISharedPrimaryLockNotification",
    "NtGdiDdDDISetDisplayPrivateDriverFormat",
    "NtGdiDdDDICheckExclusiveOwnership",
    "NtGdiDdDDICheckMonitorPowerState",
    "NtGdiDdDDIWaitForIdle",
    "NtGdiDdDDICheckOcclusion",
    "NtGdiDdDDIInvalidateActiveVidPn",
    "NtGdiDdDDIPollDisplayChildren",
    "NtGdiDdDDISetQueuedLimit",
    "NtGdiDdDDIPinDirectFlipResources",
    "NtGdiDdDDIUnpinDirectFlipResources",
    "NtGdiDdDDIWaitForVerticalBlankEvent2",
    "NtGdiDdDDIGetDWMVerticalBlankEvent",
    "NtGdiDdDDISetSyncRefreshCountWaitTarget",
    "NtGdiDdDDISetContextInProcessSchedulingPriority",
    "NtGdiDdDDIGetContextInProcessSchedulingPriority",
    "NtGdiDdDDIGetSharedResourceAdapterLuid",
    "NtGdiDdDDISetStereoEnabled",
    "NtGdiDdDDIPresentMultiPlaneOverlay",
    "NtGdiDdDDICheckMultiPlaneOverlaySupport",
    "NtGdiDdDDIMakeResident",
    "NtGdiDdDDIEvict",
    "NtGdiDdDDIWaitForSynchronizationObjectFromCpu",
    "NtGdiDdDDISignalSynchronizationObjectFromCpu",
    "NtGdiDdDDIWaitForSynchronizationObjectFromGpu",
    "NtGdiDdDDISignalSynchronizationObjectFromGpu",
    "NtGdiDdDDISignalSynchronizationObjectFromGpu2",
    "NtGdiDdDDICreatePagingQueue",
    "NtGdiDdDDIDestroyPagingQueue",
    "NtGdiDdDDILock2",
    "NtGdiDdDDIUnlock2",
    "NtGdiDdDDIInvalidateCache",
    "NtGdiDdDDIGetResourcePresentPrivateDriverData",
    "NtGdiDdDDIMapGpuVirtualAddress",
    "NtGdiDdDDIReserveGpuVirtualAddress",
    "NtGdiDdDDIFreeGpuVirtualAddress",
    "NtGdiDdDDIUpdateGpuVirtualAddress",
    "NtGdiDdDDICreateContextVirtual",
    "NtGdiDdDDISubmitCommand",
    "NtGdiDdDDIGetCachedHybridQueryValue",
    "NtGdiDdDDICacheHybridQueryValue",
    "NtGdiDdDDINetDispGetNextChunkInfo",
    "NtGdiDdDDINetDispQueryMiracastDisplayDeviceSupport",
    "NtGdiDdDDINetDispStartMiracastDisplayDevice",
    "NtGdiDdDDINetDispStartMiracastDisplayDeviceEx",
    "NtGdiDdDDINetDispStopMiracastDisplayDevice",
    "NtGdiDdDDINetDispQueryMiracastDisplayDeviceStatus",
    "NtGdiDdDDINetDispStopSessions",
    "NtGdiDdDDIQueryVideoMemoryInfo",
    "NtGdiDdDDIChangeVideoMemoryReservation",
    "NtGdiDdDDICreateSwapChain",
    "NtGdiDdDDIOpenSwapChain",
    "NtGdiDdDDIGetSetSwapChainMetadata",
    "NtGdiDdDDIAcquireSwapChain",
    "NtGdiDdDDIReleaseSwapChain",
    "NtGdiDdDDIAbandonSwapChain",
    "NtGdiDdDDISetDodIndirectSwapchain",
    "NtGdiDdDDICheckMultiPlaneOverlaySupport2",
    "NtGdiDdDDIPresentMultiPlaneOverlay2",
    "NtGdiDdDDIReclaimAllocations2",
    "NtGdiDdDDISetStablePowerState",
    "NtGdiDdDDIQueryClockCalibration",
    "NtGdiDdDDIQueryVidPnExclusiveOwnership",
    "NtGdiDdDDIAdjustFullscreenGamma",
    "NtGdiDdDDISetVidPnSourceHwProtection",
    "NtGdiDdDDIMarkDeviceAsError",
    "NtGdiMakeObjectUnXferable",
    "NtGdiMakeObjectXferable",
    "NtGdiDestroyPhysicalMonitor",
    "NtGdiGetPhysicalMonitorDescription",
    "NtGdiGetPhysicalMonitors",
    "NtGdiGetNumberOfPhysicalMonitors",
    "NtGdiDDCCIGetTimingReport",
    "NtGdiDDCCIGetCapabilitiesString",
    "NtGdiDDCCIGetCapabilitiesStringLength",
    "NtGdiDDCCISaveCurrentSettings",
    "NtGdiDDCCISetVCPFeature",
    "NtGdiDDCCIGetVCPFeature",
    "NtGdiDdQueryVisRgnUniqueness",
    "NtGdiDdDestroyFullscreenSprite",
    "NtGdiDdNotifyFullscreenSpriteUpdate",
    "NtGdiDdCreateFullscreenSprite",
    "NtUserShowSystemCursor",
    "NtUserSetMirrorRendering",
    "NtUserMagGetContextInformation",
    "NtUserMagSetContextInformation",
    "NtUserMagControl",
    "NtUserSlicerControl",
    "NtUserHwndSetRedirectionInfo",
    "NtUserHwndQueryRedirectionInfo",
    "NtCreateCompositionSurfaceHandle",
    "NtValidateCompositionSurfaceHandle",
    "NtBindCompositionSurface",
    "NtUnBindCompositionSurface",
    "NtQueryCompositionSurfaceBinding",
    "NtNotifyPresentToCompositionSurface",
    "NtQueryCompositionSurfaceStatistics",
    "NtOpenCompositionSurfaceSectionInfo",
    "NtOpenCompositionSurfaceSwapChainHandleInfo",
    "NtQueryCompositionSurfaceRenderingRealization",
    "NtOpenCompositionSurfaceDirtyRegion",
    "NtSetCompositionSurfaceOutOfFrameDirectFlipNotification",
    "NtSetCompositionSurfaceStatistics",
    "NtSetCompositionSurfaceBufferCompositionMode",
    "NtSetCompositionSurfaceIndependentFlipInfo",
    "NtDesktopCaptureBits",
    "NtDCompositionEnableMMCSS",
    "NtVisualCaptureBits",
    "NtDCompositionEnableDDASupport",
    "NtCreateCompositionInputSink",
    "NtCreateImplicitCompositionInputSink",
    "NtDuplicateCompositionInputSink",
    "NtQueryCompositionInputSink",
    "NtQueryCompositionInputSinkLuid",
    "NtQueryCompositionInputSinkViewId",
    "NtUpdateInputSinkTransforms",
    "NtCompositionInputThread",
    "NtQueryCompositionInputQueueAndTransform",
    "NtQueryCompositionInputIsImplicit",
    "NtTokenManagerOpenSectionAndEvents",
    "NtTokenManagerThread",
    "NtTokenManagerGetOutOfFrameDirectFlipSurfaceUpdates",
    "NtTokenManagerDeleteOutstandingDirectFlipTokens",
    "NtTokenManagerCreateCompositionTokenHandle",
    "NtTokenManagerGetAnalogExclusiveTokenEvent",
    "NtTokenManagerGetAnalogExclusiveSurfaceUpdates",
    "NtTokenManagerConfirmOutstandingAnalogToken",
    "NtSetCompositionSurfaceAnalogExclusive",
    "NtDCompositionBeginFrame",
    "NtDCompositionConfirmFrame",
    "NtDCompositionRetireFrame",
    "NtDCompositionDiscardFrame",
    "NtDCompositionGetFrameSurfaceUpdates",
    "NtDCompositionGetFrameLegacyTokens",
    "NtDCompositionDestroyConnection",
    "NtDCompositionGetConnectionBatch",
    "NtDCompositionGetFrameStatistics",
    "NtDCompositionGetDeletedResources",
    "NtDCompositionSetResourceDeletedNotificationTag",
    "NtDCompositionCreateConnection",
    "NtDCompositionDestroyChannel",
    "NtDCompositionReleaseAllResources",
    "NtDCompositionSubmitDWMBatch",
    "NtDCompositionCommitChannel",
    "NtDCompositionWaitForChannel",
    "NtDCompositionSetChannelCommitCompletionEvent",
    "NtDCompositionTelemetryTouchInteractionBegin",
    "NtDCompositionTelemetryTouchInteractionUpdate",
    "NtDCompositionTelemetryTouchInteractionEnd",
    "NtDCompositionTelemetrySetApplicationId",
    "NtDCompositionTelemetryAnimationScenarioBegin",
    "NtDCompositionTelemetryAnimationScenarioReference",
    "NtDCompositionTelemetryAnimationScenarioUnreference",
    "NtDCompositionCurrentBatchId",
    "NtDCompositionReleaseResource",
    "NtDCompositionRemoveCrossDeviceVisualChild",
    "NtDCompositionRemoveVisualChild",
    "NtDCompositionAddCrossDeviceVisualChild",
    "NtDCompositionAddVisualChild",
    "NtDCompositionReplaceVisualChildren",
    "NtDCompositionSetResourceAnimationProperty",
    "NtDCompositionSetResourceReferenceArrayProperty",
    "NtDCompositionSetResourceReferenceProperty",
    "NtDCompositionSetResourceBufferProperty",
    "NtDCompositionSetResourceIntegerProperty",
    "NtDCompositionSetResourceFloatProperty",
    "NtDCompositionSetResourceHandleProperty",
    "NtDCompositionCreateResource",
    "NtDCompositionOpenSharedResource",
    "NtDCompositionOpenSharedResourceHandle",
    "NtDCompositionCreateDwmChannel",
    "NtDCompositionCreateChannel",
    "NtDCompositionSynchronize",
    "NtDCompositionReferenceSharedResourceOnDwmChannel",
    "NtDCompositionSignalGpuFence",
    "NtDCompositionCreateAndBindSharedSection",
    "NtDCompositionSetDebugCounter",
    "NtDCompositionGetChannels",
    "NtDCompositionConnectPipe",
    "NtDCompositionRegisterThumbnailVisual",
    "NtDCompositionRegisterVirtualDesktopVisual",
    "NtDCompositionDuplicateHandleToProcess",
    "NtDCompositionSetVisualInputSink",
    "NtDCompositionGetAnimationTime",
    "NtDCompositionUpdatePointerCapture",
    "NtDCompositionCapturePointer",
    "NtDCompositionSetChannelCallbackId",
    "NtDCompositionSetResourceCallbackId",
    "NtDCompositionDuplicateSwapchainHandleToDwm",
    "NtUserDestroyDCompositionHwndTarget",
    "NtUserCreateDCompositionHwndTarget",
    "NtUserWaitForRedirectionStartComplete",
    "NtUserSignalRedirectionStartComplete",
    "NtUserSetActiveProcessForMonitor",
    "NtUserGetDisplayAutoRotationPreferencesByProcessId",
    "NtUserGetDisplayAutoRotationPreferences",
    "NtUserSetDisplayAutoRotationPreferences",
    "NtUserSetAutoRotation",
    "NtUserGetAutoRotationState",
    "NtUserAutoRotateScreen",
    "NtUserAcquireIAMKey",
    "NtUserSetActivationFilter",
    "NtUserSetFallbackForeground",
    "NtUserSetBrokeredForeground",
    "NtUserDisableImmersiveOwner",
    "NtUserClearForeground",
    "NtUserEnableIAMAccess",
    "NtUserGetProcessUIContextInformation",
    "NtUserSetProcessRestrictionExemption",
    "NtUserSetWindowArrangement",
    "NtUserSetWindowShowState",
    "NtUserEnableMouseInPointer",
    "NtUserIsMouseInPointerEnabled",
    "NtUserPromoteMouseInPointer",
    "NtUserAutoPromoteMouseInPointer",
    "NtUserEnableMouseInputForCursorSuppression",
    "NtUserIsMouseInputEnabled",
    "NtUserInternalClipCursor",
    "NtUserCheckProcessForClipboardAccess",
    "NtUserGetClipboardAccessToken",
    "NtUserGetQueueEventStatus",
    "NtUserCompositionInputSinkLuidFromPoint",
    "NtUserUpdateWindowInputSinkHints",
    "NtUserTransformPoint",
    "NtUserTransformRect",
    "NtUserGetHimetricScaleFactorFromPixelLocation",
    "NtUserGetProcessDpiAwareness",
    "NtUserGetDpiForMonitor",
    "NtUserReportInertia",
    "NtUserLinkDpiCursor",
    "NtUserGetCursorDims",
    "NtUserInitializeInputDeviceInjection",
    "NtUserInitializePointerDeviceInjection",
    "NtUserSetFeatureReportResponse",
    "NtUserInjectDeviceInput",
    "NtUserInjectMouseInput",
    "NtUserInjectKeyboardInput",
    "NtUserInjectPointerInput",
    "NtRIMAddInputObserver",
    "NtRIMRemoveInputObserver",
    "NtRIMUpdateInputObserverRegistration",
    "NtRIMObserveNextInput",
    "NtRIMGetDevicePreparsedDataLockfree",
    "NtUserSetCoreWindow",
    "NtUserSetCoreWindowPartner",
    "NtUserNavigateFocus",
    "NtHWCursorUpdatePointer"
};

//////////////////////////////////////////////////////////////////////////
// Windows 10 TH2 _W32pServiceTable
//////////////////////////////////////////////////////////////////////////
static const char* W32pServiceTable_Win10Th2_x86[] = {
    "NtUserGetOwnerTransformedMonitorRect",
    "NtUserYieldTask",
    "NtUserSetSensorPresence",
    "NtGdiWidenPath",
    "NtGdiUpdateColors",
    "NtGdiUnrealizeObject",
    "NtGdiUnmapMemFont",
    "NtGdiUnloadPrinterDriver",
    "NtGdiTransparentBlt",
    "NtGdiTransformPoints",
    "NtGdiSwapBuffers",
    "NtGdiStrokePath",
    "NtGdiStrokeAndFillPath",
    "NtGdiStretchDIBitsInternal",
    "NtGdiStretchBlt",
    "NtGdiStartPage",
    "NtGdiStartDoc",
    "NtGdiSetSizeDevice",
    "NtGdiSetVirtualResolution",
    "NtGdiSetTextJustification",
    "NtGdiSetSystemPaletteUse",
    "NtGdiSetRectRgn",
    "NtGdiSetPixelFormat",
    "NtGdiSetPixel",
    "NtGdiSetOPMSigningKeyAndSequenceNumbers",
    "NtGdiSetLayout",
    "NtGdiMirrorWindowOrg",
    "NtGdiGetDeviceWidth",
    "NtGdiSetMiterLimit",
    "NtGdiSetMetaRgn",
    "NtGdiSetMagicColors",
    "NtGdiSetLinkedUFIs",
    "NtGdiSetIcmMode",
    "NtGdiSetFontXform",
    "NtGdiSetFontEnumeration",
    "NtGdiSetDIBitsToDeviceInternal",
    "NtGdiSetDeviceGammaRamp",
    "NtGdiSetColorSpace",
    "NtGdiSetColorAdjustment",
    "NtGdiSetBrushOrg",
    "NtGdiSetBrushAttributes",
    "NtGdiSetBoundsRect",
    "NtGdiSetBitmapDimension",
    "NtGdiSetBitmapBits",
    "NtGdiSetBitmapAttributes",
    "NtGdiSelectPen",
    "NtGdiSelectFont",
    "NtGdiSelectClipPath",
    "NtGdiSelectBrush",
    "NtGdiSelectBitmap",
    "NtGdiScaleWindowExtEx",
    "NtGdiScaleViewportExtEx",
    "NtGdiSaveDC",
    "NtGdiRoundRect",
    "NtGdiRestoreDC",
    "NtGdiResizePalette",
    "NtGdiResetDC",
    "NtGdiRemoveFontMemResourceEx",
    "NtGdiRemoveFontResourceW",
    "NtGdiRectVisible",
    "NtGdiRectInRegion",
    "NtGdiRectangle",
    "NtGdiQueryFontAssocInfo",
    "NtGdiQueryFonts",
    "NtGdiPtVisible",
    "NtGdiPtInRegion",
    "NtGdiPolyTextOutW",
    "NtGdiPolyPolyDraw",
    "NtGdiPolyDraw",
    "NtGdiPlgBlt",
    "NtGdiPathToRegion",
    "NtGdiPolyPatBlt",
    "NtGdiPatBlt",
    "NtGdiOpenDCW",
    "NtGdiOffsetRgn",
    "NtGdiOffsetClipRgn",
    "NtGdiMoveTo",
    "NtGdiMonoBitmap",
    "NtGdiModifyWorldTransform",
    "NtGdiMaskBlt",
    "NtGdiMakeInfoDC",
    "NtGdiMakeFontDir",
    "NtGdiLineTo",
    "NtGdiInvertRgn",
    "NtGdiIntersectClipRect",
    "NtGdiInitSpool",
    "NtGdiInit",
    "NtGdiIcmBrushInfo",
    "NtGdiHfontCreate",
    "NtGdiGradientFill",
    "NtGdiGetWidthTable",
    "NtGdiGetFontUnicodeRanges",
    "NtGdiAddEmbFontToDC",
    "NtGdiChangeGhostFont",
    "NtGdiGetEmbedFonts",
    "NtGdiGetUFIPathname",
    "NtGdiGetEmbUFI",
    "NtGdiGetUFI",
    "NtGdiGetTransform",
    "NtGdiGetTextMetricsW",
    "NtGdiGetTextFaceW",
    "NtGdiGetTextExtentExW",
    "NtGdiGetTextExtent",
    "NtGdiGetTextCharsetInfo",
    "NtGdiGetSystemPaletteUse",
    "NtGdiGetSuggestedOPMProtectedOutputArraySize",
    "NtGdiGetStringBitmapW",
    "NtGdiGetStockObject",
    "NtGdiGetStats",
    "NtGdiGetSpoolMessage",
    "NtGdiGetServerMetaFileBits",
    "NtGdiGetRgnBox",
    "NtGdiGetRegionData",
    "NtGdiGetRealizationInfo",
    "NtGdiGetRasterizerCaps",
    "NtGdiGetRandomRgn",
    "NtGdiGetPixel",
    "NtGdiGetPath",
    "NtGdiGetOutlineTextMetricsInternalW",
    "NtGdiGetOPMRandomNumber",
    "NtGdiGetObjectBitmapHandle",
    "NtGdiGetNearestPaletteIndex",
    "NtGdiGetNearestColor",
    "NtGdiGetMonitorID",
    "NtGdiGetMiterLimit",
    "NtGdiGetLinkedUFIs",
    "NtGdiGetKerningPairs",
    "NtGdiGetOPMInformation",
    "NtGdiGetGlyphOutline",
    "NtGdiGetGlyphIndicesWInternal",
    "NtGdiGetGlyphIndicesW",
    "NtGdiGetFontResourceInfoInternalW",
    "NtGdiGetFontFileInfo",
    "NtGdiGetFontFileData",
    "NtGdiGetFontData",
    "NtGdiGetEudcTimeStampEx",
    "NtGdiGetETM",
    "NtGdiGetDIBitsInternal",
    "NtGdiGetDeviceCapsAll",
    "NtGdiGetDeviceGammaRamp",
    "NtGdiGetDeviceCaps",
    "NtGdiGetDCPoint",
    "NtGdiGetDCObject",
    "NtGdiGetDCforBitmap",
    "NtGdiGetDCDword",
    "NtGdiGetCurrentDpiInfo",
    "NtGdiGetCOPPCompatibleOPMInformation",
    "NtGdiGetColorSpaceforBitmap",
    "NtGdiGetColorAdjustment",
    "NtGdiGetCharWidthInfo",
    "NtGdiGetCharWidthW",
    "NtGdiGetCharSet",
    "NtGdiGetCharacterPlacementW",
    "NtGdiGetCharABCWidthsW",
    "NtGdiGetCertificateSize",
    "NtGdiGetCertificate",
    "NtGdiGetCertificateSizeByHandle",
    "NtGdiGetCertificateByHandle",
    "NtGdiGetBoundsRect",
    "NtGdiGetBitmapDimension",
    "NtGdiGetBitmapBits",
    "NtGdiGetAppClipBox",
    "NtGdiGetAndSetDCDword",
    "NtGdiFullscreenControl",
    "NtGdiFrameRgn",
    "NtGdiForceUFIMapping",
    "NtGdiFlush",
    "NtGdiFlattenPath",
    "NtGdiFillRgn",
    "NtGdiFillPath",
    "NtGdiExtTextOutW",
    "NtGdiExtSelectClipRgn",
    "NtGdiExtGetObjectW",
    "NtGdiExtFloodFill",
    "NtGdiExtEscape",
    "NtGdiExtCreateRegion",
    "NtGdiExtCreatePen",
    "NtGdiExcludeClipRect",
    "NtGdiEudcLoadUnloadLink",
    "NtGdiEqualRgn",
    "NtGdiEnumObjects",
    "NtGdiEnumFonts",
    "NtGdiEndPath",
    "NtGdiEndPage",
    "NtGdiEndGdiRendering",
    "NtGdiEndDoc",
    "NtGdiEnableEudc",
    "NtGdiEllipse",
    "NtGdiDrawEscape",
    "NtGdiDoPalette",
    "NtGdiDoBanding",
    "NtGdiGetPerBandInfo",
    "NtGdiDestroyOPMProtectedOutput",
    "NtGdiDescribePixelFormat",
    "NtGdiDeleteObjectApp",
    "NtGdiDeleteColorTransform",
    "NtGdiDeleteColorSpace",
    "NtGdiDeleteClientObj",
    "NtGdiDxgGenericThunk",
    "NtGdiDvpReleaseNotification",
    "NtGdiDvpAcquireNotification",
    "NtGdiDvpWaitForVideoPortSync",
    "NtGdiDvpUpdateVideoPort",
    "NtGdiDvpGetVideoSignalStatus",
    "NtGdiDvpGetVideoPortConnectInfo",
    "NtGdiDvpGetVideoPortOutputFormats",
    "NtGdiDvpGetVideoPortLine",
    "NtGdiDvpGetVideoPortInputFormats",
    "NtGdiDvpGetVideoPortFlipStatus",
    "NtGdiDvpGetVideoPortField",
    "NtGdiDvpGetVideoPortBandwidth",
    "NtGdiDvpFlipVideoPort",
    "NtGdiDvpDestroyVideoPort",
    "NtGdiDvpCreateVideoPort",
    "NtGdiDvpColorControl",
    "NtGdiDvpCanCreateVideoPort",
    "NtGdiDdWaitForVerticalBlank",
    "NtGdiDdUpdateOverlay",
    "NtGdiDdUnlockD3D",
    "NtGdiDdUnlock",
    "NtGdiDdUnattachSurface",
    "NtGdiDdSetOverlayPosition",
    "NtGdiDdCreateSurfaceEx",
    "NtGdiDdSetGammaRamp",
    "NtGdiDdSetExclusiveMode",
    "NtGdiDdSetColorKey",
    "NtGdiDdResetVisrgn",
    "NtGdiDdRenderMoComp",
    "NtGdiDdReleaseDC",
    "NtGdiDdReenableDirectDrawObject",
    "NtGdiDdQueryMoCompStatus",
    "NtGdiDdQueryDirectDrawObject",
    "NtGdiDdLockD3D",
    "NtGdiDdLock",
    "NtGdiDdGetScanLine",
    "NtGdiDdGetMoCompFormats",
    "NtGdiDdGetMoCompGuids",
    "NtGdiDdGetMoCompBuffInfo",
    "NtGdiDdGetInternalMoCompInfo",
    "NtGdiDdGetFlipStatus",
    "NtGdiDdGetDxHandle",
    "NtGdiDdGetDriverInfo",
    "NtGdiDdGetDC",
    "NtGdiDdGetBltStatus",
    "NtGdiDdGetAvailDriverMemory",
    "NtGdiDdFlipToGDISurface",
    "NtGdiDdFlip",
    "NtGdiDdEndMoCompFrame",
    "NtGdiDdDestroyD3DBuffer",
    "NtGdiDdDestroySurface",
    "NtGdiDdDestroyMoComp",
    "NtGdiDdDeleteSurfaceObject",
    "NtGdiDdDeleteDirectDrawObject",
    "NtGdiDdCreateSurfaceObject",
    "NtGdiDdCreateMoComp",
    "NtGdiDdCreateD3DBuffer",
    "NtGdiDdCreateSurface",
    "NtGdiDdCreateDirectDrawObject",
    "NtGdiDdColorControl",
    "NtGdiDdCanCreateD3DBuffer",
    "NtGdiDdCanCreateSurface",
    "NtGdiDdBlt",
    "NtGdiDdBeginMoCompFrame",
    "NtGdiDdAttachSurface",
    "NtGdiDdAlphaBlt",
    "NtGdiDdAddAttachedSurface",
    "NtGdiDdGetDriverState",
    "NtGdiD3dDrawPrimitives2",
    "NtGdiD3dValidateTextureStageState",
    "NtGdiD3dContextDestroyAll",
    "NtGdiD3dContextDestroy",
    "NtGdiD3dContextCreate",
    "NtGdiCreateSolidBrush",
    "NtGdiCreateServerMetaFile",
    "NtGdiCreateRoundRectRgn",
    "NtGdiCreateRectRgn",
    "NtGdiCreatePen",
    "NtGdiCreatePatternBrushInternal",
    "NtGdiCreatePaletteInternal",
    "NtGdiCreateOPMProtectedOutputs",
    "NtGdiCreateMetafileDC",
    "NtGdiCreateHatchBrushInternal",
    "NtGdiCreateHalftonePalette",
    "NtGdiCreateEllipticRgn",
    "NtGdiCreateSessionMappedDIBSection",
    "NtGdiCreateDIBSection",
    "NtGdiCreateDIBitmapInternal",
    "NtGdiCreateDIBBrush",
    "NtGdiCreateCompatibleDC",
    "NtGdiCreateCompatibleBitmap",
    "NtGdiCreateColorTransform",
    "NtGdiCreateColorSpace",
    "NtGdiCreateClientObj",
    "NtGdiCreateBitmapFromDxSurface2",
    "NtGdiCreateBitmapFromDxSurface",
    "NtGdiCreateBitmap",
    "NtGdiConvertMetafileRect",
    "NtGdiConfigureOPMProtectedOutput",
    "NtGdiComputeXformCoefficients",
    "NtGdiCombineTransform",
    "NtGdiCombineRgn",
    "NtGdiColorCorrectPalette",
    "NtGdiClearBrushAttributes",
    "NtGdiClearBitmapAttributes",
    "NtGdiCloseFigure",
    "NtGdiCheckBitmapBits",
    "NtGdiCancelDC",
    "NtGdiBitBlt",
    "NtGdiBeginPath",
    "NtGdiBeginGdiRendering",
    "NtGdiArcInternal",
    "NtGdiFontIsLinked",
    "NtGdiAnyLinkedFonts",
    "NtGdiAngleArc",
    "NtGdiAlphaBlend",
    "NtGdiAddRemoteMMInstanceToDC",
    "NtGdiRemoveMergeFont",
    "NtGdiAddFontMemResourceEx",
    "NtGdiAddRemoteFontToDC",
    "NtGdiAddFontResourceW",
    "NtGdiAbortPath",
    "NtGdiAbortDoc",
    "NtUserDefSetText",
    "NtUserDeferWindowPosAndBand",
    "NtUserDdeInitialize",
    "NtUserCanBrokerForceForeground",
    "NtUserCreateWindowStation",
    "NtUserCreateWindowEx",
    "NtUserCreateLocalMemHandle",
    "NtUserCreateInputContext",
    "NtUserCreateDesktopEx",
    "NtUserCreateCaret",
    "NtUserCreateAcceleratorTable",
    "NtUserCountClipboardFormats",
    "NtUserCopyAcceleratorTable",
    "NtUserConvertMemHandle",
    "NtUserConsoleControl",
    "NtUserCloseWindowStation",
    "NtUserCloseDesktop",
    "NtUserCloseClipboard",
    "NtUserClipCursor",
    "NtUserChildWindowFromPointEx",
    "NtUserCheckMenuItem",
    "NtUserCheckWindowThreadDesktop",
    "NtUserDwmValidateWindow",
    "NtUserCheckAccessForIntegrityLevel",
    "NtUserDisplayConfigSetDeviceInfo",
    "NtUserDisplayConfigGetDeviceInfo",
    "NtUserQueryDisplayConfig",
    "NtUserSetDisplayConfig",
    "NtUserGetDisplayConfigBufferSizes",
    "NtUserChangeDisplaySettings",
    "NtUserChangeClipboardChain",
    "NtUserCallTwoParam",
    "NtUserCallOneParam",
    "NtUserCallNoParam",
    "NtUserCallNextHookEx",
    "NtUserCallMsgFilter",
    "NtUserCallHwndParamLock",
    "NtUserCallHwndParam",
    "NtUserCallHwndOpt",
    "NtUserCallHwndLock",
    "NtUserCallHwnd",
    "NtUserBuildPropList",
    "NtUserBuildNameList",
    "NtUserBuildHwndList",
    "NtUserBuildHimcList",
    "NtUserBlockInput",
    "NtUserBitBltSysBmp",
    "NtUserBeginPaint",
    "NtUserAttachThreadInput",
    "NtUserAssociateInputContext",
    "NtUserAlterWindowStyle",
    "NtUserAddClipboardFormatListener",
    "NtUserActivateKeyboardLayout",
    "NtUserDelegateCapturePointers",
    "NtUserDelegateInput",
    "NtUserDispatchMessage",
    "NtUserDisableProcessWindowFiltering",
    "NtUserDisableThreadIme",
    "NtUserDestroyWindow",
    "NtUserDestroyMenu",
    "NtUserDestroyInputContext",
    "NtUserDestroyCursor",
    "NtUserDestroyAcceleratorTable",
    "NtUserDeleteMenu",
    "NtUserDoSoundDisconnect",
    "NtUserDoSoundConnect",
    "NtUserGhostWindowFromHungWindow",
    "NtUserGetWOWClass",
    "NtUserGetWindowPlacement",
    "NtUserGetWindowDisplayAffinity",
    "NtUserGetWindowDC",
    "NtUserGetWindowCompositionAttribute",
    "NtUserGetWindowCompositionInfo",
    "NtUserGetWindowBand",
    "NtUserGetUpdateRgn",
    "NtUserGetUpdateRect",
    "NtUserGetUpdatedClipboardFormats",
    "NtUserGetTopLevelWindow",
    "NtUserGetTitleBarInfo",
    "NtUserGetThreadState",
    "NtUserGetThreadDesktop",
    "NtUserGetSystemMenu",
    "NtUserGetScrollBarInfo",
    "NtUserGetRegisteredRawInputDevices",
    "NtUserGetRawInputDeviceList",
    "NtUserGetRawInputDeviceInfo",
    "NtUserGetRawInputData",
    "NtUserGetRawInputBuffer",
    "NtUserGetProcessWindowStation",
    "NtUserGetPriorityClipboardFormat",
    "NtUserGetOpenClipboardWindow",
    "NtUserGetObjectInformation",
    "NtUserGetMouseMovePointsEx",
    "NtUserGetMessage",
    "NtUserGetMenuItemRect",
    "NtUserGetMenuIndex",
    "NtUserGetMenuBarInfo",
    "NtUserGetListBoxInfo",
    "NtUserGetKeyState",
    "NtUserGetKeyNameText",
    "NtUserGetKeyboardState",
    "NtUserGetKeyboardLayoutName",
    "NtUserGetKeyboardLayoutList",
    "NtUserGetInternalWindowPos",
    "NtUserGetInputLocaleInfo",
    "NtUserGetImeInfoEx",
    "NtUserGetImeHotKey",
    "NtUserGetIconSize",
    "NtUserGetIconInfo",
    "NtUserGetGUIThreadInfo",
    "NtUserGetGuiResources",
    "NtUserGetForegroundWindow",
    "NtUserGetDpiSystemMetrics",
    "NtUserGetDoubleClickTime",
    "NtUserGetDesktopID",
    "NtUserGetDCEx",
    "NtUserGetDC",
    "NtUserGetCursorInfo",
    "NtUserGetCursorFrameInfo",
    "NtUserGetCurrentInputMessageSource",
    "NtUserGetCIMSSM",
    "NtUserGetCPD",
    "NtUserGetControlColor",
    "NtUserGetControlBrush",
    "NtUserGetComboBoxInfo",
    "NtUserGetClipCursor",
    "NtUserGetClipboardViewer",
    "NtUserGetClipboardSequenceNumber",
    "NtUserGetClipboardOwner",
    "NtUserGetClipboardFormatName",
    "NtUserGetClipboardData",
    "NtUserGetClassName",
    "NtUserGetClassInfoEx",
    "NtUserGetCaretPos",
    "NtUserGetCaretBlinkTime",
    "NtUserGetAtomName",
    "NtUserGetAsyncKeyState",
    "NtUserGetAppImeLevel",
    "NtUserGetAncestor",
    "NtUserGetAltTabInfo",
    "NtUserFrostCrashedWindow",
    "NtUserFlashWindowEx",
    "NtUserFindWindowEx",
    "NtUserFindExistingCursorIcon",
    "NtUserFillWindow",
    "NtUserExcludeUpdateRgn",
    "NtUserEvent",
    "NtUserEnumDisplaySettings",
    "NtUserEnumDisplayMonitors",
    "NtUserEnumDisplayDevices",
    "NtUserEndPaint",
    "NtUserEndMenu",
    "NtUserEndDeferWindowPosEx",
    "NtUserEnableScrollBar",
    "NtUserEnableMenuItem",
    "NtUserEmptyClipboard",
    "NtUserDrawMenuBarTemp",
    "NtUserDrawIconEx",
    "NtUserDrawCaptionTemp",
    "NtUserDrawCaption",
    "NtUserDrawAnimatedRects",
    "NtUserDragObject",
    "NtUserDragDetect",
    "NtUserHandleDelegatedInput",
    "NtUserRealChildWindowFromPoint",
    "NtUserQueryWindow",
    "NtUserQuerySendMessage",
    "NtUserQueryInputContext",
    "NtUserQueryInformationThread",
    "NtUserQueryBSDRWindow",
    "NtUserPerMonitorDPIPhysicalToLogicalPoint",
    "NtUserProcessConnect",
    "NtUserPrintWindow",
    "NtUserPostThreadMessage",
    "NtUserPostMessage",
    "NtUserPhysicalToLogicalPoint",
    "NtUserPeekMessage",
    "NtUserPaintMonitor",
    "NtUserPaintDesktop",
    "NtUserOpenWindowStation",
    "NtUserOpenThreadDesktop",
    "NtUserOpenInputDesktop",
    "NtUserOpenDesktop",
    "NtUserOpenClipboard",
    "NtUserNotifyWinEvent",
    "NtUserNotifyProcessCreate",
    "NtUserNotifyIMEStatus",
    "NtUserMoveWindow",
    "NtUserModifyUserStartupInfoFlags",
    "NtUserMNDragOver",
    "NtUserMNDragLeave",
    "NtUserMinMaximize",
    "NtUserMessageCall",
    "NtUserMenuItemFromPoint",
    "NtUserMapVirtualKeyEx",
    "NtUserLayoutCompleted",
    "NtUserLogicalToPerMonitorDPIPhysicalPoint",
    "NtUserLogicalToPhysicalPoint",
    "NtUserLockWorkStation",
    "NtUserLockWindowUpdate",
    "NtUserLockWindowStation",
    "NtUserLoadKeyboardLayoutEx",
    "NtUserKillTimer",
    "NtUserIsTopLevelWindow",
    "NtUserIsClipboardFormatAvailable",
    "NtUserInvalidateRgn",
    "NtUserInvalidateRect",
    "NtUserInternalGetWindowIcon",
    "NtUserInternalGetWindowText",
    "NtUserInitTask",
    "NtUserInitializeClientPfnArrays",
    "NtUserInitialize",
    "NtUserImpersonateDdeClientWindow",
    "NtUserHungWindowFromGhostWindow",
    "NtUserHiliteMenuItem",
    "NtUserHideCaret",
    "NtUserHardErrorControl",
    "NtUserRealInternalGetMessage",
    "NtUserRealWaitMessageEx",
    "NtUserReleaseDwmHitTestWaiters",
    "NtUserTranslateMessage",
    "NtUserTranslateAccelerator",
    "NtUserPaintMenuBar",
    "NtUserCalcMenuBar",
    "NtUserCalculatePopupWindowPosition",
    "NtUserTrackPopupMenuEx",
    "NtUserTrackMouseEvent",
    "NtUserToUnicodeEx",
    "NtUserThunkedMenuItemInfo",
    "NtUserThunkedMenuInfo",
    "NtUserTestForInteractiveUser",
    "NtUserSendEventMessage",
    "NtUserSystemParametersInfo",
    "NtUserSwitchDesktop",
    "NtUserSoundSentry",
    "NtUserShutdownReasonDestroy",
    "NtUserShutdownBlockReasonQuery",
    "NtUserShutdownBlockReasonCreate",
    "NtUserShowWindowAsync",
    "NtUserShowWindow",
    "NtUserShowScrollBar",
    "NtUserShowCaret",
    "NtUserSetWinEventHook",
    "NtUserSetWindowWord",
    "NtUserSetWindowStationUser",
    "NtUserSetWindowsHookEx",
    "NtUserSetWindowsHookAW",
    "NtUserSetWindowRgnEx",
    "NtUserGetWindowRgnEx",
    "NtUserSetWindowRgn",
    "NtUserSetWindowPos",
    "NtUserSetWindowPlacement",
    "NtUserSetWindowLong",
    "NtUserSetWindowFNID",
    "NtUserSetWindowDisplayAffinity",
    "NtUserSetWindowCompositionTransition",
    "NtUserUpdateDefaultDesktopThumbnail",
    "NtUserSetWindowCompositionAttribute",
    "NtUserSetWindowBand",
    "NtUserSetProcessUIAccessZorder",
    "NtUserSetProcessDpiAwareness",
    "NtUserEnableChildWindowDpiMessage",
    "NtUserIsChildWindowDpiMessageEnabled",
    "NtUserIsWindowBroadcastingDpiToChildren",
    "NtUserSetTimer",
    "NtUserSetThreadState",
    "NtUserSetThreadLayoutHandles",
    "NtUserSetThreadDesktop",
    "NtUserSetThreadInputBlocked",
    "NtUserSetSystemTimer",
    "NtUserSetSystemMenu",
    "NtUserSetSystemCursor",
    "NtUserSetSysColors",
    "NtUserSetShellWindowEx",
    "NtUserSetScrollInfo",
    "NtUserSetProp",
    "NtUserGetProp",
    "NtUserSetProcessWindowStation",
    "NtUserSetParent",
    "NtUserSetObjectInformation",
    "NtUserSetMenuFlagRtoL",
    "NtUserSetMenuDefaultItem",
    "NtUserSetMenuContextHelpId",
    "NtUserSetMenu",
    "NtUserSetKeyboardState",
    "NtUserSetInternalWindowPos",
    "NtUserSetInformationThread",
    "NtUserSetImeOwnerWindow",
    "NtUserSetImeInfoEx",
    "NtUserSetImeHotKey",
    "NtUserSetFocus",
    "NtUserSetCursorIconData",
    "NtUserSetCursorContents",
    "NtUserSetCursor",
    "NtUserSetClipboardViewer",
    "NtUserSetClipboardData",
    "NtUserSetClassWord",
    "NtUserSetClassLong",
    "NtUserSetChildWindowNoActivate",
    "NtUserSetCapture",
    "NtUserSetAppImeLevel",
    "NtUserSetActiveWindow",
    "NtUserSendInput",
    "NtUserSelectPalette",
    "NtUserScrollWindowEx",
    "NtUserScrollDC",
    "NtUserSBGetParms",
    "NtUserResolveDesktopForWOW",
    "NtUserRemoveProp",
    "NtUserRemoveMenu",
    "NtUserRemoveClipboardFormatListener",
    "NtUserRegisterWindowMessage",
    "NtUserRegisterTasklist",
    "NtUserRegisterServicesProcess",
    "NtUserRegisterRawInputDevices",
    "NtUserRegisterHotKey",
    "NtUserRegisterDManipHook",
    "NtUserGetDManipHookInitFunction",
    "NtUserRegisterManipulationThread",
    "NtUserSetManipulationInputTarget",
    "NtUserRegisterUserApiHook",
    "NtUserRegisterErrorReportingDialog",
    "NtUserRegisterClassExWOW",
    "NtUserRegisterBSDRWindow",
    "NtUserRedrawWindow",
    "NtUserUndelegateInput",
    "NtUserGetWindowMinimizeRect",
    "NtUserDwmGetRemoteSessionOcclusionEvent",
    "NtUserDwmGetRemoteSessionOcclusionState",
    "NtUserDwmKernelShutdown",
    "NtUserDwmKernelStartup",
    "NtUserUpdateWindowTransform",
    "NtUserCheckProcessSession",
    "NtUserUnregisterSessionPort",
    "NtUserRegisterSessionPort",
    "NtUserCtxDisplayIOCtl",
    "NtUserRemoteStopScreenUpdates",
    "NtUserRemoteRedrawScreen",
    "NtUserRemoteRedrawRectangle",
    "NtUserRemoteConnect",
    "NtUserWaitAvailableMessageEx",
    "NtUserWindowFromPoint",
    "NtUserWindowFromPhysicalPoint",
    "NtUserWaitMessage",
    "NtUserWaitForMsgAndEvent",
    "NtUserWaitForInputIdle",
    "NtUserVkKeyScanEx",
    "NtUserValidateTimerCallback",
    "NtUserValidateRect",
    "NtUserValidateHandleSecure",
    "NtUserUserHandleGrantAccess",
    "NtUserUpdatePerUserSystemParameters",
    "NtUserSetLayeredWindowAttributes",
    "NtUserGetLayeredWindowAttributes",
    "NtUserUpdateLayeredWindow",
    "NtUserUpdateInstance",
    "NtUserUpdateInputContext",
    "NtUserUnregisterHotKey",
    "NtUserUnregisterUserApiHook",
    "NtUserUnregisterClass",
    "NtUserUnlockWindowStation",
    "NtUserUnloadKeyboardLayout",
    "NtUserUnhookWinEvent",
    "NtUserUnhookWindowsHookEx",
    "NtUserGetTouchInputInfo",
    "NtUserIsTouchWindow",
    "NtUserModifyWindowTouchCapability",
    "NtGdiEngStretchBltROP",
    "NtGdiEngTextOut",
    "NtGdiEngTransparentBlt",
    "NtGdiEngGradientFill",
    "NtGdiEngAlphaBlend",
    "NtGdiEngLineTo",
    "NtGdiEngPaint",
    "NtGdiEngStrokeAndFillPath",
    "NtGdiEngFillPath",
    "NtGdiEngStrokePath",
    "NtGdiEngMarkBandingSurface",
    "NtGdiEngPlgBlt",
    "NtGdiEngStretchBlt",
    "NtGdiEngBitBlt",
    "NtGdiEngLockSurface",
    "NtGdiEngUnlockSurface",
    "NtGdiEngEraseSurface",
    "NtGdiEngDeleteSurface",
    "NtGdiEngDeletePalette",
    "NtGdiEngCopyBits",
    "NtGdiEngComputeGlyphSet",
    "NtGdiEngCreatePalette",
    "NtGdiEngCreateDeviceBitmap",
    "NtGdiEngCreateDeviceSurface",
    "NtGdiEngCreateBitmap",
    "NtGdiEngAssociateSurface",
    "NtUserSetWindowFeedbackSetting",
    "NtUserRegisterEdgy",
    "NtUserRegisterShellPTPListener",
    "NtUserGetWindowFeedbackSetting",
    "NtUserHidePointerContactVisualization",
    "NtUserGetTouchValidationStatus",
    "NtUserInitializeTouchInjection",
    "NtUserInjectTouchInput",
    "NtUserRegisterTouchHitTestingWindow",
    "NtUserSetDisplayMapping",
    "NtUserSetCalibrationData",
    "NtUserGetPhysicalDeviceRect",
    "NtUserRegisterTouchPadCapable",
    "NtUserGetRawPointerDeviceData",
    "NtUserGetPointerDeviceCursors",
    "NtUserGetPointerDeviceRects",
    "NtUserRegisterPointerDeviceNotifications",
    "NtUserGetPointerDeviceProperties",
    "NtUserGetPointerDevice",
    "NtUserGetPointerDevices",
    "NtUserEnableTouchPad",
    "NtUserGetPrecisionTouchPadConfiguration",
    "NtUserSetPrecisionTouchPadConfiguration",
    "NtUserPromotePointer",
    "NtUserDiscardPointerFrameMessages",
    "NtUserRegisterPointerInputTarget",
    "NtUserGetPointerFrameArrivalTimes",
    "NtUserGetPointerInputTransform",
    "NtUserGetPointerInfoList",
    "NtUserGetPointerCursorId",
    "NtUserGetPointerType",
    "NtUserGetGestureConfig",
    "NtUserSetGestureConfig",
    "NtUserGetGestureExtArgs",
    "NtUserGetGestureInfo",
    "NtUserInjectGesture",
    "NtUserChangeWindowMessageFilterEx",
    "NtGdiXLATEOBJ_hGetColorTransform",
    "NtGdiXLATEOBJ_iXlate",
    "NtGdiXLATEOBJ_cGetPalette",
    "NtGdiEngDeleteClip",
    "NtGdiEngCreateClip",
    "NtGdiEngDeletePath",
    "NtGdiCLIPOBJ_ppoGetPath",
    "NtGdiCLIPOBJ_cEnumStart",
    "NtGdiCLIPOBJ_bEnum",
    "NtGdiBRUSHOBJ_hGetColorTransform",
    "NtGdiBRUSHOBJ_pvGetRbrush",
    "NtGdiBRUSHOBJ_pvAllocRbrush",
    "NtGdiBRUSHOBJ_ulGetBrushColor",
    "NtGdiXFORMOBJ_iGetXform",
    "NtGdiXFORMOBJ_bApplyXform",
    "NtGdiFONTOBJ_pQueryGlyphAttrs",
    "NtGdiFONTOBJ_pfdg",
    "NtGdiFONTOBJ_pifi",
    "NtGdiFONTOBJ_cGetGlyphs",
    "NtGdiFONTOBJ_pxoGetXform",
    "NtGdiFONTOBJ_vGetInfo",
    "NtGdiFONTOBJ_cGetAllGlyphHandles",
    "NtGdiFONTOBJ_pvTrueTypeFontFile",
    "NtGdiSTROBJ_dwGetCodePage",
    "NtGdiSTROBJ_vEnumStart",
    "NtGdiSTROBJ_bGetAdvanceWidths",
    "NtGdiSTROBJ_bEnumPositionsOnly",
    "NtGdiSTROBJ_bEnum",
    "NtGdiPATHOBJ_bEnumClipLines",
    "NtGdiPATHOBJ_vEnumStartClipLines",
    "NtGdiPATHOBJ_vEnumStart",
    "NtGdiPATHOBJ_bEnum",
    "NtGdiPATHOBJ_vGetBounds",
    "NtGdiEngCheckAbort",
    "NtGdiGetDhpdev",
    "NtGdiHT_Get8BPPMaskPalette",
    "NtGdiHT_Get8BPPFormatPalette",
    "NtGdiUpdateTransform",
    "NtGdiUMPDEngFreeUserMem",
    "NtGdiBRUSHOBJ_DeleteRbrush",
    "NtGdiSetPUMPDOBJ",
    "NtGdiSetUMPDSandboxState",
    "NtGdiDrawStream",
    "NtGdiHLSurfSetInformation",
    "NtGdiHLSurfGetInformation",
    "NtGdiDwmCreatedBitmapRemotingOutput",
    "NtGdiDdDDIGetScanLine",
    "NtGdiDdDDIReleaseProcessVidPnSourceOwners",
    "NtGdiDdDDIGetProcessSchedulingPriorityClass",
    "NtGdiDdDDISetProcessSchedulingPriorityClass",
    "NtGdiDdDDIGetContextSchedulingPriority",
    "NtGdiDdDDISetContextSchedulingPriority",
    "NtGdiDdDDIDestroyDCFromMemory",
    "NtGdiDdDDICreateDCFromMemory",
    "NtGdiDdDDIGetDeviceState",
    "NtGdiDdDDISetGammaRamp",
    "NtGdiDdDDIWaitForVerticalBlankEvent",
    "NtGdiDdDDIDestroyOverlay",
    "NtGdiDdDDIFlipOverlay",
    "NtGdiDdDDIUpdateOverlay",
    "NtGdiDdDDICreateOverlay",
    "NtGdiDdDDIGetPresentQueueEvent",
    "NtGdiDdDDIGetPresentHistory",
    "NtGdiDdDDISetVidPnSourceOwner1",
    "NtGdiDdDDISetVidPnSourceOwner",
    "NtGdiDdDDIQueryStatistics",
    "NtGdiDdDDIEscape",
    "NtGdiDdDDIGetSharedPrimaryHandle",
    "NtGdiDdDDICloseAdapter",
    "NtGdiDdDDIOpenAdapterFromLuid",
    "NtGdiDdDDIEnumAdapters",
    "NtGdiDdDDIEnumAdapters2",
    "NtGdiDdDDIOpenAdapterFromHdc",
    "NtGdiDdDDIOpenAdapterFromDeviceName",
    "NtGdiDdDDIRender",
    "NtGdiDdDDIPresent",
    "NtGdiDdDDIGetMultisampleMethodList",
    "NtGdiDdDDISetDisplayMode",
    "NtGdiDdDDIGetDisplayModeList",
    "NtGdiDdDDIUnlock",
    "NtGdiDdDDILock",
    "NtGdiDdDDIQueryAdapterInfo",
    "NtGdiDdDDIGetRuntimeData",
    "NtGdiDdDDISignalSynchronizationObject",
    "NtGdiDdDDIWaitForSynchronizationObject",
    "NtGdiDdDDIDestroySynchronizationObject",
    "NtGdiDdDDIOpenSynchronizationObject",
    "NtGdiDdDDICreateSynchronizationObject",
    "NtGdiDdDDIDestroyContext",
    "NtGdiDdDDICreateContext",
    "NtGdiDdDDIDestroyDevice",
    "NtGdiDdDDICreateDevice",
    "NtGdiDdDDIQueryAllocationResidency",
    "NtGdiDdDDISetAllocationPriority",
    "NtGdiDdDDIDestroyAllocation",
    "NtGdiDdDDIDestroyAllocation2",
    "NtGdiDdDDIOpenResourceFromNtHandle",
    "NtGdiDdDDIOpenSyncObjectFromNtHandle",
    "NtGdiDdDDIOpenSyncObjectFromNtHandle2",
    "NtGdiDdDDIOpenResource",
    "NtGdiDdDDIOpenNtHandleFromName",
    "NtGdiDdDDIOpenSyncObjectNtHandleFromName",
    "NtGdiDdDDIShareObjects",
    "NtGdiDdDDIQueryResourceInfoFromNtHandle",
    "NtGdiDdDDIQueryResourceInfo",
    "NtGdiDdDDICreateAllocation",
    "NtGdiDdDDIOutputDuplReleaseFrame",
    "NtGdiDdDDIQueryRemoteVidPnSourceFromGdiDisplayName",
    "NtGdiDdDDIOutputDuplPresent",
    "NtGdiDdDDIReleaseKeyedMutex2",
    "NtGdiDdDDIAcquireKeyedMutex2",
    "NtGdiDdDDIOpenKeyedMutex2",
    "NtGdiDdDDICreateKeyedMutex2",
    "NtGdiDdDDIOutputDuplGetPointerShapeData",
    "NtGdiDdDDIOutputDuplGetMetaData",
    "NtGdiDdDDIOutputDuplGetFrameInfo",
    "NtGdiDdDDIDestroyOutputDupl",
    "NtGdiDdDDICreateOutputDupl",
    "NtGdiDdDDIReclaimAllocations",
    "NtGdiDdDDIOfferAllocations",
    "NtGdiDdDDICheckSharedResourceAccess",
    "NtGdiDdDDICheckVidPnExclusiveOwnership",
    "NtGdiDdDDIGetOverlayState",
    "NtGdiDdDDIConfigureSharedResource",
    "NtGdiDdDDIReleaseKeyedMutex",
    "NtGdiDdDDIAcquireKeyedMutex",
    "NtGdiDdDDIDestroyKeyedMutex",
    "NtGdiDdDDIOpenKeyedMutex",
    "NtGdiDdDDICreateKeyedMutex",
    "NtGdiDdDDISharedPrimaryUnLockNotification",
    "NtGdiDdDDISharedPrimaryLockNotification",
    "NtGdiDdDDISetDisplayPrivateDriverFormat",
    "NtGdiDdDDICheckExclusiveOwnership",
    "NtGdiDdDDICheckMonitorPowerState",
    "NtGdiDdDDIWaitForIdle",
    "NtGdiDdDDICheckOcclusion",
    "NtGdiDdDDIInvalidateActiveVidPn",
    "NtGdiDdDDIPollDisplayChildren",
    "NtGdiDdDDISetQueuedLimit",
    "NtGdiDdDDIPinDirectFlipResources",
    "NtGdiDdDDIUnpinDirectFlipResources",
    "NtGdiDdDDIWaitForVerticalBlankEvent2",
    "NtGdiDdDDIGetDWMVerticalBlankEvent",
    "NtGdiDdDDISetSyncRefreshCountWaitTarget",
    "NtGdiDdDDISetContextInProcessSchedulingPriority",
    "NtGdiDdDDIGetContextInProcessSchedulingPriority",
    "NtGdiDdDDIGetSharedResourceAdapterLuid",
    "NtGdiDdDDISetStereoEnabled",
    "NtGdiDdDDIPresentMultiPlaneOverlay",
    "NtGdiDdDDICheckMultiPlaneOverlaySupport",
    "NtGdiDdDDIMakeResident",
    "NtGdiDdDDIEvict",
    "NtGdiDdDDIWaitForSynchronizationObjectFromCpu",
    "NtGdiDdDDISignalSynchronizationObjectFromCpu",
    "NtGdiDdDDIWaitForSynchronizationObjectFromGpu",
    "NtGdiDdDDISignalSynchronizationObjectFromGpu",
    "NtGdiDdDDISignalSynchronizationObjectFromGpu2",
    "NtGdiDdDDICreatePagingQueue",
    "NtGdiDdDDIDestroyPagingQueue",
    "NtGdiDdDDILock2",
    "NtGdiDdDDIUnlock2",
    "NtGdiDdDDIInvalidateCache",
    "NtGdiDdDDIGetResourcePresentPrivateDriverData",
    "NtGdiDdDDIMapGpuVirtualAddress",
    "NtGdiDdDDIReserveGpuVirtualAddress",
    "NtGdiDdDDIFreeGpuVirtualAddress",
    "NtGdiDdDDIUpdateGpuVirtualAddress",
    "NtGdiDdDDICreateContextVirtual",
    "NtGdiDdDDISubmitCommand",
    "NtGdiDdDDIGetCachedHybridQueryValue",
    "NtGdiDdDDICacheHybridQueryValue",
    "NtGdiDdDDINetDispGetNextChunkInfo",
    "NtGdiDdDDINetDispQueryMiracastDisplayDeviceSupport",
    "NtGdiDdDDINetDispStartMiracastDisplayDevice",
    "NtGdiDdDDINetDispStopMiracastDisplayDevice",
    "NtGdiDdDDINetDispQueryMiracastDisplayDeviceStatus",
    "NtGdiDdDDINetDispStopSessions",
    "NtGdiDdDDIQueryVideoMemoryInfo",
    "NtGdiDdDDIChangeVideoMemoryReservation",
    "NtGdiDdDDICreateSwapChain",
    "NtGdiDdDDIOpenSwapChain",
    "NtGdiDdDDIGetSetSwapChainMetadata",
    "NtGdiDdDDIAcquireSwapChain",
    "NtGdiDdDDIReleaseSwapChain",
    "NtGdiDdDDIAbandonSwapChain",
    "NtGdiDdDDISetDodIndirectSwapchain",
    "NtGdiDdDDICheckMultiPlaneOverlaySupport2",
    "NtGdiDdDDIPresentMultiPlaneOverlay2",
    "NtGdiDdDDIReclaimAllocations2",
    "NtGdiDdDDISetStablePowerState",
    "NtGdiDdDDIQueryClockCalibration",
    "NtGdiDdDDIQueryVidPnExclusiveOwnership",
    "NtGdiDdDDIAdjustFullscreenGamma",
    "NtGdiDdDDISetVidPnSourceHwProtection",
    "NtGdiDdDDIMarkDeviceAsError",
    "NtGdiDdDDIFlushHeapTransitions",
    "NtGdiDdDDISetHwProtectionTeardownRecovery",
    "NtGdiMakeObjectUnXferable",
    "NtGdiMakeObjectXferable",
    "NtGdiDestroyPhysicalMonitor",
    "NtGdiGetPhysicalMonitorDescription",
    "NtGdiGetPhysicalMonitors",
    "NtGdiGetNumberOfPhysicalMonitors",
    "NtGdiDDCCIGetTimingReport",
    "NtGdiDDCCIGetCapabilitiesString",
    "NtGdiDDCCIGetCapabilitiesStringLength",
    "NtGdiDDCCISaveCurrentSettings",
    "NtGdiDDCCISetVCPFeature",
    "NtGdiDDCCIGetVCPFeature",
    "NtGdiDdQueryVisRgnUniqueness",
    "NtGdiDdDestroyFullscreenSprite",
    "NtGdiDdNotifyFullscreenSpriteUpdate",
    "NtGdiDdCreateFullscreenSprite",
    "NtUserShowSystemCursor",
    "NtUserSetMirrorRendering",
    "NtUserMagGetContextInformation",
    "NtUserMagSetContextInformation",
    "NtUserMagControl",
    "NtUserSlicerControl",
    "NtUserHwndSetRedirectionInfo",
    "NtUserHwndQueryRedirectionInfo",
    "NtCreateCompositionSurfaceHandle",
    "NtValidateCompositionSurfaceHandle",
    "NtBindCompositionSurface",
    "NtUnBindCompositionSurface",
    "NtQueryCompositionSurfaceBinding",
    "NtNotifyPresentToCompositionSurface",
    "NtQueryCompositionSurfaceStatistics",
    "NtOpenCompositionSurfaceSectionInfo",
    "NtOpenCompositionSurfaceSwapChainHandleInfo",
    "NtQueryCompositionSurfaceRenderingRealization",
    "NtOpenCompositionSurfaceDirtyRegion",
    "NtSetCompositionSurfaceOutOfFrameDirectFlipNotification",
    "NtSetCompositionSurfaceStatistics",
    "NtSetCompositionSurfaceBufferCompositionModeAndOrientation",
    "NtSetCompositionSurfaceIndependentFlipInfo",
    "NtDesktopCaptureBits",
    "NtDCompositionEnableMMCSS",
    "NtVisualCaptureBits",
    "NtDCompositionEnableDDASupport",
    "NtCreateCompositionInputSink",
    "NtCreateImplicitCompositionInputSink",
    "NtDuplicateCompositionInputSink",
    "NtQueryCompositionInputSink",
    "NtQueryCompositionInputSinkLuid",
    "NtQueryCompositionInputSinkViewId",
    "NtUpdateInputSinkTransforms",
    "NtCompositionInputThread",
    "NtQueryCompositionInputQueueAndTransform",
    "NtQueryCompositionInputIsImplicit",
    "NtCompositionSetDropTarget",
    "NtTokenManagerOpenSectionAndEvents",
    "NtTokenManagerThread",
    "NtTokenManagerGetOutOfFrameDirectFlipSurfaceUpdates",
    "NtTokenManagerDeleteOutstandingDirectFlipTokens",
    "NtTokenManagerCreateCompositionTokenHandle",
    "NtTokenManagerGetAnalogExclusiveTokenEvent",
    "NtTokenManagerGetAnalogExclusiveSurfaceUpdates",
    "NtTokenManagerConfirmOutstandingAnalogToken",
    "NtSetCompositionSurfaceAnalogExclusive",
    "NtDCompositionBeginFrame",
    "NtDCompositionConfirmFrame",
    "NtDCompositionRetireFrame",
    "NtDCompositionDiscardFrame",
    "NtDCompositionGetFrameSurfaceUpdates",
    "NtDCompositionGetFrameLegacyTokens",
    "NtDCompositionDestroyConnection",
    "NtDCompositionGetConnectionBatch",
    "NtDCompositionGetFrameStatistics",
    "NtDCompositionGetDeletedResources",
    "NtDCompositionSetResourceDeletedNotificationTag",
    "NtDCompositionCreateConnection",
    "NtDCompositionDestroyChannel",
    "NtDCompositionReleaseAllResources",
    "NtDCompositionSubmitDWMBatch",
    "NtDCompositionCommitChannel",
    "NtDCompositionWaitForChannel",
    "NtDCompositionSetChannelCommitCompletionEvent",
    "NtDCompositionTelemetryTouchInteractionBegin",
    "NtDCompositionTelemetryTouchInteractionUpdate",
    "NtDCompositionTelemetryTouchInteractionEnd",
    "NtDCompositionTelemetrySetApplicationId",
    "NtDCompositionTelemetryAnimationScenarioBegin",
    "NtDCompositionTelemetryAnimationScenarioReference",
    "NtDCompositionTelemetryAnimationScenarioUnreference",
    "NtDCompositionCurrentBatchId",
    "NtDCompositionReleaseResource",
    "NtDCompositionRemoveCrossDeviceVisualChild",
    "NtDCompositionRemoveVisualChild",
    "NtDCompositionAddCrossDeviceVisualChild",
    "NtDCompositionAddVisualChild",
    "NtDCompositionReplaceVisualChildren",
    "NtDCompositionSetResourceAnimationProperty",
    "NtDCompositionSetResourceReferenceArrayProperty",
    "NtDCompositionSetResourceReferenceProperty",
    "NtDCompositionSetResourceBufferProperty",
    "NtDCompositionSetResourceIntegerProperty",
    "NtDCompositionSetResourceFloatProperty",
    "NtDCompositionSetResourceHandleProperty",
    "NtDCompositionCreateResource",
    "NtDCompositionOpenSharedResource",
    "NtDCompositionOpenSharedResourceHandle",
    "NtDCompositionCreateDwmChannel",
    "NtDCompositionCreateChannel",
    "NtDCompositionSynchronize",
    "NtDCompositionReferenceSharedResourceOnDwmChannel",
    "NtDCompositionCreateAndBindSharedSection",
    "NtDCompositionSetDebugCounter",
    "NtDCompositionGetChannels",
    "NtDCompositionConnectPipe",
    "NtDCompositionRegisterThumbnailVisual",
    "NtDCompositionRegisterVirtualDesktopVisual",
    "NtDCompositionDuplicateHandleToProcess",
    "NtDCompositionSetVisualInputSink",
    "NtDCompositionGetAnimationTime",
    "NtDCompositionUpdatePointerCapture",
    "NtDCompositionCapturePointer",
    "NtDCompositionSetChannelCallbackId",
    "NtDCompositionSetResourceCallbackId",
    "NtDCompositionDuplicateSwapchainHandleToDwm",
    "NtDCompositionAttachMouseWheelToHwnd",
    "NtUserDestroyDCompositionHwndTarget",
    "NtUserCreateDCompositionHwndTarget",
    "NtUserWaitForRedirectionStartComplete",
    "NtUserSignalRedirectionStartComplete",
    "NtUserSetActiveProcessForMonitor",
    "NtUserGetDisplayAutoRotationPreferencesByProcessId",
    "NtUserGetDisplayAutoRotationPreferences",
    "NtUserSetDisplayAutoRotationPreferences",
    "NtUserSetAutoRotation",
    "NtUserGetAutoRotationState",
    "NtUserAutoRotateScreen",
    "NtUserAcquireIAMKey",
    "NtUserSetActivationFilter",
    "NtUserSetFallbackForeground",
    "NtUserSetBrokeredForeground",
    "NtUserDisableImmersiveOwner",
    "NtUserClearForeground",
    "NtUserEnableIAMAccess",
    "NtUserGetProcessUIContextInformation",
    "NtUserSetProcessRestrictionExemption",
    "NtUserSetWindowArrangement",
    "NtUserSetWindowShowState",
    "NtUserUpdateWindowTrackingInfo",
    "NtUserEnableMouseInPointer",
    "NtUserIsMouseInPointerEnabled",
    "NtUserPromoteMouseInPointer",
    "NtUserAutoPromoteMouseInPointer",
    "NtUserEnableMouseInputForCursorSuppression",
    "NtUserIsMouseInputEnabled",
    "NtUserInternalClipCursor",
    "NtUserCheckProcessForClipboardAccess",
    "NtUserGetClipboardAccessToken",
    "NtUserGetQueueEventStatus",
    "NtUserCompositionInputSinkLuidFromPoint",
    "NtUserUpdateWindowInputSinkHints",
    "NtUserTransformPoint",
    "NtUserTransformRect",
    "NtUserGetHimetricScaleFactorFromPixelLocation",
    "NtUserGetProcessDpiAwareness",
    "NtUserGetDpiForMonitor",
    "NtUserReportInertia",
    "NtUserLinkDpiCursor",
    "NtUserGetCursorDims",
    "NtUserInitializeInputDeviceInjection",
    "NtUserInitializePointerDeviceInjection",
    "NtUserRemoveInjectionDevice",
    "NtUserSetFeatureReportResponse",
    "NtUserInjectDeviceInput",
    "NtUserInjectMouseInput",
    "NtUserInjectKeyboardInput",
    "NtUserInjectPointerInput",
    "NtRIMAddInputObserver",
    "NtRIMRemoveInputObserver",
    "NtRIMUpdateInputObserverRegistration",
    "NtRIMObserveNextInput",
    "NtRIMGetDevicePreparsedDataLockfree",
    "NtUserSetCoreWindow",
    "NtUserSetCoreWindowPartner",
    "NtUserNavigateFocus",
    "NtHWCursorUpdatePointer"
};

//////////////////////////////////////////////////////////////////////////
// Windows 10 RS1 _W32pServiceTable
//////////////////////////////////////////////////////////////////////////
static const char* W32pServiceTable_Win10Rs1_x86[] = {
    "NtUserGetOwnerTransformedMonitorRect",
    "NtUserYieldTask",
    "NtUserSetSensorPresence",
    "NtGdiWidenPath",
    "NtGdiUpdateColors",
    "NtGdiUnrealizeObject",
    "NtGdiUnmapMemFont",
    "NtGdiUnloadPrinterDriver",
    "NtGdiTransparentBlt",
    "NtGdiTransformPoints",
    "NtGdiSwapBuffers",
    "NtGdiStrokePath",
    "NtGdiStrokeAndFillPath",
    "NtGdiStretchDIBitsInternal",
    "NtGdiStretchBlt",
    "NtGdiStartPage",
    "NtGdiStartDoc",
    "NtGdiSetSizeDevice",
    "NtGdiSetVirtualResolution",
    "NtGdiSetTextJustification",
    "NtGdiSetSystemPaletteUse",
    "NtGdiSetRectRgn",
    "NtGdiSetPixelFormat",
    "NtGdiSetPixel",
    "NtGdiSetOPMSigningKeyAndSequenceNumbers",
    "NtGdiSetLayout",
    "NtGdiMirrorWindowOrg",
    "NtGdiGetDeviceWidth",
    "NtGdiSetMiterLimit",
    "NtGdiSetMetaRgn",
    "NtGdiSetMagicColors",
    "NtGdiSetLinkedUFIs",
    "NtGdiSetIcmMode",
    "NtGdiSetFontXform",
    "NtGdiSetFontEnumeration",
    "NtGdiSetDIBitsToDeviceInternal",
    "NtGdiSetDeviceGammaRamp",
    "NtGdiSetColorSpace",
    "NtGdiSetColorAdjustment",
    "NtGdiSetBrushOrg",
    "NtGdiSetBrushAttributes",
    "NtGdiSetBoundsRect",
    "NtGdiSetBitmapDimension",
    "NtGdiSetBitmapBits",
    "NtGdiSetBitmapAttributes",
    "NtGdiSelectPen",
    "NtGdiSelectFont",
    "NtGdiSelectClipPath",
    "NtGdiSelectBrush",
    "NtGdiSelectBitmap",
    "NtGdiScaleWindowExtEx",
    "NtGdiScaleViewportExtEx",
    "NtGdiSaveDC",
    "NtGdiRoundRect",
    "NtGdiRestoreDC",
    "NtGdiResizePalette",
    "NtGdiResetDC",
    "NtGdiRemoveFontMemResourceEx",
    "NtGdiRemoveFontResourceW",
    "NtGdiRectVisible",
    "NtGdiRectInRegion",
    "NtGdiRectangle",
    "NtGdiQueryFontAssocInfo",
    "NtGdiQueryFonts",
    "NtGdiPtVisible",
    "NtGdiPtInRegion",
    "NtGdiPolyTextOutW",
    "NtGdiPolyPolyDraw",
    "NtGdiPolyDraw",
    "NtGdiPlgBlt",
    "NtGdiPathToRegion",
    "NtGdiPolyPatBlt",
    "NtGdiPatBlt",
    "NtGdiOpenDCW",
    "NtGdiOffsetRgn",
    "NtGdiOffsetClipRgn",
    "NtGdiMoveTo",
    "NtGdiMonoBitmap",
    "NtGdiModifyWorldTransform",
    "NtGdiMaskBlt",
    "NtGdiMakeInfoDC",
    "NtGdiMakeFontDir",
    "NtGdiLineTo",
    "NtGdiInvertRgn",
    "NtGdiIntersectClipRect",
    "NtGdiInitSpool",
    "NtGdiInit",
    "NtGdiIcmBrushInfo",
    "NtGdiHfontCreate",
    "NtGdiGradientFill",
    "NtGdiGetWidthTable",
    "NtGdiGetFontUnicodeRanges",
    "NtGdiAddEmbFontToDC",
    "NtGdiChangeGhostFont",
    "NtGdiGetEmbedFonts",
    "NtGdiGetUFIPathname",
    "NtGdiGetEmbUFI",
    "NtGdiGetUFI",
    "NtGdiGetTransform",
    "NtGdiGetTextMetricsW",
    "NtGdiGetTextFaceW",
    "NtGdiGetTextExtentExW",
    "NtGdiGetTextExtent",
    "NtGdiGetTextCharsetInfo",
    "NtGdiGetSystemPaletteUse",
    "NtGdiGetSuggestedOPMProtectedOutputArraySize",
    "NtGdiGetStringBitmapW",
    "NtGdiGetStats",
    "NtGdiGetSpoolMessage",
    "NtGdiGetServerMetaFileBits",
    "NtGdiGetRgnBox",
    "NtGdiGetRegionData",
    "NtGdiGetRealizationInfo",
    "NtGdiGetRasterizerCaps",
    "NtGdiGetRandomRgn",
    "NtGdiGetPixel",
    "NtGdiGetPath",
    "NtGdiGetOutlineTextMetricsInternalW",
    "NtGdiGetOPMRandomNumber",
    "NtGdiGetObjectBitmapHandle",
    "NtGdiGetNearestPaletteIndex",
    "NtGdiGetNearestColor",
    "NtGdiGetMonitorID",
    "NtGdiGetMiterLimit",
    "NtGdiGetLinkedUFIs",
    "NtGdiGetKerningPairs",
    "NtGdiGetOPMInformation",
    "NtGdiGetGlyphOutline",
    "NtGdiGetGlyphIndicesWInternal",
    "NtGdiGetGlyphIndicesW",
    "NtGdiGetFontResourceInfoInternalW",
    "NtGdiGetFontFileInfo",
    "NtGdiGetFontFileData",
    "NtGdiGetFontData",
    "NtGdiGetEudcTimeStampEx",
    "NtGdiGetETM",
    "NtGdiGetEntry",
    "NtGdiGetDIBitsInternal",
    "NtGdiGetDeviceCapsAll",
    "NtGdiGetDeviceGammaRamp",
    "NtGdiGetDeviceCaps",
    "NtGdiGetDCPoint",
    "NtGdiGetDCObject",
    "NtGdiGetDCforBitmap",
    "NtGdiGetDCDword",
    "NtGdiGetCurrentDpiInfo",
    "NtGdiGetCOPPCompatibleOPMInformation",
    "NtGdiGetColorSpaceforBitmap",
    "NtGdiGetColorAdjustment",
    "NtGdiGetCharWidthInfo",
    "NtGdiGetCharWidthW",
    "NtGdiGetCharSet",
    "NtGdiGetCharacterPlacementW",
    "NtGdiGetCharABCWidthsW",
    "NtGdiGetCertificateSize",
    "NtGdiGetCertificate",
    "NtGdiGetCertificateSizeByHandle",
    "NtGdiGetCertificateByHandle",
    "NtGdiGetBoundsRect",
    "NtGdiGetBitmapDimension",
    "NtGdiGetBitmapBits",
    "NtGdiGetAppClipBox",
    "NtGdiGetAndSetDCDword",
    "NtGdiFullscreenControl",
    "NtGdiFrameRgn",
    "NtGdiForceUFIMapping",
    "NtGdiFlush",
    "NtGdiFlattenPath",
    "NtGdiFillRgn",
    "NtGdiFillPath",
    "NtGdiExtTextOutW",
    "NtGdiExtSelectClipRgn",
    "NtGdiExtGetObjectW",
    "NtGdiExtFloodFill",
    "NtGdiExtEscape",
    "NtGdiExtCreateRegion",
    "NtGdiExtCreatePen",
    "NtGdiExcludeClipRect",
    "NtGdiEudcLoadUnloadLink",
    "NtGdiEqualRgn",
    "NtGdiEnumObjects",
    "NtGdiEnumFonts",
    "NtGdiEndPath",
    "NtGdiEndPage",
    "NtGdiEndGdiRendering",
    "NtGdiEndDoc",
    "NtGdiEnableEudc",
    "NtGdiEllipse",
    "NtGdiDrawEscape",
    "NtGdiDoPalette",
    "NtGdiDoBanding",
    "NtGdiGetPerBandInfo",
    "NtGdiDestroyOPMProtectedOutput",
    "NtGdiDescribePixelFormat",
    "NtGdiDeleteObjectApp",
    "NtGdiDeleteColorTransform",
    "NtGdiDeleteColorSpace",
    "NtGdiDeleteClientObj",
    "NtGdiDxgGenericThunk",
    "NtGdiDvpReleaseNotification",
    "NtGdiDvpAcquireNotification",
    "NtGdiDvpWaitForVideoPortSync",
    "NtGdiDvpUpdateVideoPort",
    "NtGdiDvpGetVideoSignalStatus",
    "NtGdiDvpGetVideoPortConnectInfo",
    "NtGdiDvpGetVideoPortOutputFormats",
    "NtGdiDvpGetVideoPortLine",
    "NtGdiDvpGetVideoPortInputFormats",
    "NtGdiDvpGetVideoPortFlipStatus",
    "NtGdiDvpGetVideoPortField",
    "NtGdiDvpGetVideoPortBandwidth",
    "NtGdiDvpFlipVideoPort",
    "NtGdiDvpDestroyVideoPort",
    "NtGdiDvpCreateVideoPort",
    "NtGdiDvpColorControl",
    "NtGdiDvpCanCreateVideoPort",
    "NtGdiDdWaitForVerticalBlank",
    "NtGdiDdUpdateOverlay",
    "NtGdiDdUnlockD3D",
    "NtGdiDdUnlock",
    "NtGdiDdUnattachSurface",
    "NtGdiDdSetOverlayPosition",
    "NtGdiDdCreateSurfaceEx",
    "NtGdiDdSetGammaRamp",
    "NtGdiDdSetExclusiveMode",
    "NtGdiDdSetColorKey",
    "NtGdiDdResetVisrgn",
    "NtGdiDdRenderMoComp",
    "NtGdiDdReleaseDC",
    "NtGdiDdReenableDirectDrawObject",
    "NtGdiDdQueryMoCompStatus",
    "NtGdiDdQueryDirectDrawObject",
    "NtGdiDdLockD3D",
    "NtGdiDdLock",
    "NtGdiDdGetScanLine",
    "NtGdiDdGetMoCompFormats",
    "NtGdiDdGetMoCompGuids",
    "NtGdiDdGetMoCompBuffInfo",
    "NtGdiDdGetInternalMoCompInfo",
    "NtGdiDdGetFlipStatus",
    "NtGdiDdGetDxHandle",
    "NtGdiDdGetDriverInfo",
    "NtGdiDdGetDC",
    "NtGdiDdGetBltStatus",
    "NtGdiDdGetAvailDriverMemory",
    "NtGdiDdFlipToGDISurface",
    "NtGdiDdFlip",
    "NtGdiDdEndMoCompFrame",
    "NtGdiDdDestroyD3DBuffer",
    "NtGdiDdDestroySurface",
    "NtGdiDdDestroyMoComp",
    "NtGdiDdDeleteSurfaceObject",
    "NtGdiDdDeleteDirectDrawObject",
    "NtGdiDdCreateSurfaceObject",
    "NtGdiDdCreateMoComp",
    "NtGdiDdCreateD3DBuffer",
    "NtGdiDdCreateSurface",
    "NtGdiDdCreateDirectDrawObject",
    "NtGdiDdColorControl",
    "NtGdiDdCanCreateD3DBuffer",
    "NtGdiDdCanCreateSurface",
    "NtGdiDdBlt",
    "NtGdiDdBeginMoCompFrame",
    "NtGdiDdAttachSurface",
    "NtGdiDdAlphaBlt",
    "NtGdiDdAddAttachedSurface",
    "NtGdiDdGetDriverState",
    "NtGdiD3dDrawPrimitives2",
    "NtGdiD3dValidateTextureStageState",
    "NtGdiD3dContextDestroyAll",
    "NtGdiD3dContextDestroy",
    "NtGdiD3dContextCreate",
    "NtGdiCreateSolidBrush",
    "NtGdiCreateServerMetaFile",
    "NtGdiCreateRoundRectRgn",
    "NtGdiCreateRectRgn",
    "NtGdiCreatePen",
    "NtGdiCreatePatternBrushInternal",
    "NtGdiCreatePaletteInternal",
    "NtGdiCreateOPMProtectedOutputs",
    "NtGdiCreateOPMProtectedOutput",
    "NtGdiCreateMetafileDC",
    "NtGdiCreateHatchBrushInternal",
    "NtGdiCreateHalftonePalette",
    "NtGdiCreateEllipticRgn",
    "NtGdiCreateSessionMappedDIBSection",
    "NtGdiCreateDIBSection",
    "NtGdiCreateDIBitmapInternal",
    "NtGdiCreateDIBBrush",
    "NtGdiCreateCompatibleDC",
    "NtGdiCreateCompatibleBitmap",
    "NtGdiCreateColorTransform",
    "NtGdiCreateColorSpace",
    "NtGdiCreateClientObj",
    "NtGdiCreateBitmapFromDxSurface2",
    "NtGdiCreateBitmapFromDxSurface",
    "NtGdiCreateBitmap",
    "NtGdiConvertMetafileRect",
    "NtGdiConfigureOPMProtectedOutput",
    "NtGdiComputeXformCoefficients",
    "NtGdiCombineTransform",
    "NtGdiCombineRgn",
    "NtGdiColorCorrectPalette",
    "NtGdiClearBrushAttributes",
    "NtGdiClearBitmapAttributes",
    "NtGdiCloseFigure",
    "NtGdiCheckBitmapBits",
    "NtGdiCancelDC",
    "NtGdiBitBlt",
    "NtGdiBeginPath",
    "NtGdiBeginGdiRendering",
    "NtGdiArcInternal",
    "NtGdiFontIsLinked",
    "NtGdiAnyLinkedFonts",
    "NtGdiAngleArc",
    "NtGdiAlphaBlend",
    "NtGdiAddRemoteMMInstanceToDC",
    "NtGdiRemoveMergeFont",
    "NtGdiAddFontMemResourceEx",
    "NtGdiAddRemoteFontToDC",
    "NtGdiAddFontResourceW",
    "NtGdiAbortPath",
    "NtGdiAbortDoc",
    "NtUserDefSetText",
    "NtUserDeferWindowPosAndBand",
    "NtUserDdeInitialize",
    "NtUserCanBrokerForceForeground",
    "NtUserCreateWindowStation",
    "NtUserCreateWindowEx",
    "NtUserCreateLocalMemHandle",
    "NtUserCreateInputContext",
    "NtUserCreateDesktopEx",
    "NtUserCreateCaret",
    "NtUserCreateAcceleratorTable",
    "NtUserCountClipboardFormats",
    "NtUserCopyAcceleratorTable",
    "NtUserConvertMemHandle",
    "NtUserConsoleControl",
    "NtUserCloseWindowStation",
    "NtUserCloseDesktop",
    "NtUserCloseClipboard",
    "NtUserClipCursor",
    "NtUserChildWindowFromPointEx",
    "NtUserCheckMenuItem",
    "NtUserCheckWindowThreadDesktop",
    "NtUserDwmValidateWindow",
    "NtUserCheckAccessForIntegrityLevel",
    "NtUserDisplayConfigSetDeviceInfo",
    "NtUserDisplayConfigGetDeviceInfo",
    "NtUserQueryDisplayConfig",
    "NtUserSetDisplayConfig",
    "NtUserGetDisplayConfigBufferSizes",
    "NtUserChangeDisplaySettings",
    "NtUserChangeClipboardChain",
    "NtUserCallTwoParam",
    "NtUserCallOneParam",
    "NtUserCallNoParam",
    "NtUserCallNextHookEx",
    "NtUserCallMsgFilter",
    "NtUserCallHwndParamLock",
    "NtUserCallHwndParam",
    "NtUserCallHwndOpt",
    "NtUserCallHwndLock",
    "NtUserCallHwnd",
    "NtUserBroadcastThemeChangeEvent",
    "NtUserBuildPropList",
    "NtUserBuildNameList",
    "NtUserBuildHwndList",
    "NtUserBuildHimcList",
    "NtUserBlockInput",
    "NtUserBitBltSysBmp",
    "NtUserBeginPaint",
    "NtUserAttachThreadInput",
    "NtUserAssociateInputContext",
    "NtUserAlterWindowStyle",
    "NtUserAddClipboardFormatListener",
    "NtUserActivateKeyboardLayout",
    "NtUserDelegateCapturePointers",
    "NtUserDelegateInput",
    "NtUserDispatchMessage",
    "NtUserDisableProcessWindowFiltering",
    "NtUserDisableThreadIme",
    "NtUserDestroyWindow",
    "NtUserDestroyMenu",
    "NtUserDestroyInputContext",
    "NtUserDestroyCursor",
    "NtUserDestroyAcceleratorTable",
    "NtUserDeleteMenu",
    "NtUserDoSoundDisconnect",
    "NtUserDoSoundConnect",
    "NtUserGhostWindowFromHungWindow",
    "NtUserGetWOWClass",
    "NtUserGetWindowPlacement",
    "NtUserGetWindowDisplayAffinity",
    "NtUserGetWindowDC",
    "NtUserGetWindowCompositionAttribute",
    "NtUserGetWindowCompositionInfo",
    "NtUserGetWindowBand",
    "NtUserGetUpdateRgn",
    "NtUserGetUpdateRect",
    "NtUserGetUpdatedClipboardFormats",
    "NtUserGetTopLevelWindow",
    "NtUserGetTitleBarInfo",
    "NtUserGetThreadState",
    "NtUserGetThreadDesktop",
    "NtUserGetSystemMenu",
    "NtUserGetScrollBarInfo",
    "NtUserGetRegisteredRawInputDevices",
    "NtUserGetRawInputDeviceList",
    "NtUserGetRawInputDeviceInfo",
    "NtUserGetRawInputData",
    "NtUserGetRawInputBuffer",
    "NtUserGetProcessDpiAwarenessContext",
    "NtUserGetProcessWindowStation",
    "NtUserGetPriorityClipboardFormat",
    "NtUserGetOpenClipboardWindow",
    "NtUserGetObjectInformation",
    "NtUserGetMouseMovePointsEx",
    "NtUserGetMessage",
    "NtUserGetMenuItemRect",
    "NtUserGetMenuIndex",
    "NtUserGetMenuBarInfo",
    "NtUserGetListBoxInfo",
    "NtUserGetKeyState",
    "NtUserGetKeyNameText",
    "NtUserGetKeyboardState",
    "NtUserGetKeyboardLayoutName",
    "NtUserGetKeyboardLayoutList",
    "NtUserGetInternalWindowPos",
    "NtUserGetInputLocaleInfo",
    "NtUserGetImeInfoEx",
    "NtUserGetImeHotKey",
    "NtUserGetIconSize",
    "NtUserGetIconInfo",
    "NtUserGetGUIThreadInfo",
    "NtUserGetGuiResources",
    "NtUserGetForegroundWindow",
    "NtUserGetDoubleClickTime",
    "NtUserGetDesktopID",
    "NtUserGetDCEx",
    "NtUserGetDC",
    "NtUserGetCursorInfo",
    "NtUserGetCursorFrameInfo",
    "NtUserGetCurrentInputMessageSource",
    "NtUserGetCIMSSM",
    "NtUserGetCPD",
    "NtUserGetControlColor",
    "NtUserGetControlBrush",
    "NtUserGetComboBoxInfo",
    "NtUserGetClipCursor",
    "NtUserGetClipboardViewer",
    "NtUserGetClipboardSequenceNumber",
    "NtUserGetClipboardOwner",
    "NtUserGetClipboardFormatName",
    "NtUserGetClipboardData",
    "NtUserGetClassName",
    "NtUserGetClassInfoEx",
    "NtUserGetCaretPos",
    "NtUserGetCaretBlinkTime",
    "NtUserGetAtomName",
    "NtUserGetAsyncKeyState",
    "NtUserGetAppImeLevel",
    "NtUserGetAncestor",
    "NtUserGetAltTabInfo",
    "NtUserFrostCrashedWindow",
    "NtUserFlashWindowEx",
    "NtUserFindWindowEx",
    "NtUserFindExistingCursorIcon",
    "NtUserFillWindow",
    "NtUserExcludeUpdateRgn",
    "NtUserEvent",
    "NtUserEnumDisplaySettings",
    "NtUserEnumDisplayMonitors",
    "NtUserEnumDisplayDevices",
    "NtUserEndPaint",
    "NtUserEndMenu",
    "NtUserEndDeferWindowPosEx",
    "NtUserEnableScrollBar",
    "NtUserEnableMenuItem",
    "NtUserEmptyClipboard",
    "NtUserDrawMenuBarTemp",
    "NtUserDrawIconEx",
    "NtUserDrawCaptionTemp",
    "NtUserDrawCaption",
    "NtUserDrawAnimatedRects",
    "NtUserDragObject",
    "NtUserDragDetect",
    "NtUserHandleDelegatedInput",
    "NtUserInheritWindowMonitor",
    "NtUserRealChildWindowFromPoint",
    "NtUserQueryWindow",
    "NtUserQuerySendMessage",
    "NtUserQueryInputContext",
    "NtUserQueryInformationThread",
    "NtUserQueryBSDRWindow",
    "NtUserPerMonitorDPIPhysicalToLogicalPoint",
    "NtUserProcessConnect",
    "NtUserPrintWindow",
    "NtUserPostThreadMessage",
    "NtUserPostMessage",
    "NtUserPhysicalToLogicalPoint",
    "NtUserPeekMessage",
    "NtUserPaintMonitor",
    "NtUserPaintDesktop",
    "NtUserOpenWindowStation",
    "NtUserOpenThreadDesktop",
    "NtUserOpenInputDesktop",
    "NtUserOpenDesktop",
    "NtUserOpenClipboard",
    "NtUserNotifyWinEvent",
    "NtUserNotifyProcessCreate",
    "NtUserNotifyIMEStatus",
    "NtUserMoveWindow",
    "NtUserModifyUserStartupInfoFlags",
    "NtUserMNDragOver",
    "NtUserMNDragLeave",
    "NtUserMinMaximize",
    "NtUserMessageCall",
    "NtUserMenuItemFromPoint",
    "NtUserMapVirtualKeyEx",
    "NtUserLayoutCompleted",
    "NtUserLogicalToPerMonitorDPIPhysicalPoint",
    "NtUserLogicalToPhysicalPoint",
    "NtUserLockWorkStation",
    "NtUserLockWindowUpdate",
    "NtUserLockWindowStation",
    "NtUserLoadKeyboardLayoutEx",
    "NtUserKillTimer",
    "NtUserIsTopLevelWindow",
    "NtUserIsClipboardFormatAvailable",
    "NtUserInvalidateRgn",
    "NtUserInvalidateRect",
    "NtUserInternalGetWindowIcon",
    "NtUserInternalGetWindowText",
    "NtUserInitTask",
    "NtUserInitializeClientPfnArrays",
    "NtUserInitialize",
    "NtUserImpersonateDdeClientWindow",
    "NtUserHungWindowFromGhostWindow",
    "NtUserHiliteMenuItem",
    "NtUserHideCaret",
    "NtUserHardErrorControl",
    "NtUserRealInternalGetMessage",
    "NtUserRealWaitMessageEx",
    "NtUserReleaseDwmHitTestWaiters",
    "NtUserTranslateMessage",
    "NtUserTranslateAccelerator",
    "NtUserPaintMenuBar",
    "NtUserCalcMenuBar",
    "NtUserCalculatePopupWindowPosition",
    "NtUserTrackPopupMenuEx",
    "NtUserTrackMouseEvent",
    "NtUserToUnicodeEx",
    "NtUserThunkedMenuItemInfo",
    "NtUserThunkedMenuInfo",
    "NtUserTestForInteractiveUser",
    "NtUserSendEventMessage",
    "NtUserSystemParametersInfo",
    "NtUserSystemParametersInfoForDpi",
    "NtUserSwitchDesktop",
    "NtUserSoundSentry",
    "NtUserShutdownReasonDestroy",
    "NtUserShutdownBlockReasonQuery",
    "NtUserShutdownBlockReasonCreate",
    "NtUserShowWindowAsync",
    "NtUserShowWindow",
    "NtUserShowScrollBar",
    "NtUserShowCaret",
    "NtUserSetWinEventHook",
    "NtUserSetWindowWord",
    "NtUserSetWindowStationUser",
    "NtUserSetWindowsHookEx",
    "NtUserSetWindowsHookAW",
    "NtUserSetWindowRgnEx",
    "NtUserGetWindowRgnEx",
    "NtUserSetWindowRgn",
    "NtUserSetWindowPos",
    "NtUserSetWindowPlacement",
    "NtUserSetWindowLong",
    "NtUserSetWindowFNID",
    "NtUserSetWindowDisplayAffinity",
    "NtUserSetWindowCompositionTransition",
    "NtUserUpdateDefaultDesktopThumbnail",
    "NtUserSetWindowCompositionAttribute",
    "NtUserSetWindowBand",
    "NtUserSetProcessUIAccessZorder",
    "NtUserSetProcessDpiAwarenessContext",
    "NtUserEnableChildWindowDpiMessage",
    "NtUserIsChildWindowDpiMessageEnabled",
    "NtUserEnableNonClientDpiScaling",
    "NtUserIsNonClientDpiScalingEnabled",
    "NtUserIsWindowBroadcastingDpiToChildren",
    "NtUserSetTimer",
    "NtUserSetThreadState",
    "NtUserSetThreadLayoutHandles",
    "NtUserSetThreadDesktop",
    "NtUserSetThreadInputBlocked",
    "NtUserSetSystemTimer",
    "NtUserSetSystemMenu",
    "NtUserSetSystemCursor",
    "NtUserSetSysColors",
    "NtUserSetShellWindowEx",
    "NtUserSetScrollInfo",
    "NtUserSetProp",
    "NtUserGetProp",
    "NtUserSetProcessWindowStation",
    "NtUserSetParent",
    "NtUserSetObjectInformation",
    "NtUserSetMenuFlagRtoL",
    "NtUserSetMenuDefaultItem",
    "NtUserSetMenuContextHelpId",
    "NtUserSetMenu",
    "NtUserSetKeyboardState",
    "NtUserSetInternalWindowPos",
    "NtUserSetInformationThread",
    "NtUserSetImeOwnerWindow",
    "NtUserSetImeInfoEx",
    "NtUserSetImeHotKey",
    "NtUserSetFocus",
    "NtUserSetCursorIconData",
    "NtUserSetCursorContents",
    "NtUserSetCursor",
    "NtUserSetClipboardViewer",
    "NtUserSetClipboardData",
    "NtUserSetClassWord",
    "NtUserSetClassLong",
    "NtUserSetChildWindowNoActivate",
    "NtUserSetCapture",
    "NtUserSetAppImeLevel",
    "NtUserSetActiveWindow",
    "NtUserSendInput",
    "NtUserSelectPalette",
    "NtUserScrollWindowEx",
    "NtUserScrollDC",
    "NtUserSBGetParms",
    "NtUserResolveDesktopForWOW",
    "NtUserRemoveProp",
    "NtUserRemoveMenu",
    "NtUserRemoveClipboardFormatListener",
    "NtUserRegisterWindowMessage",
    "NtUserRegisterTasklist",
    "NtUserRegisterServicesProcess",
    "NtUserRegisterRawInputDevices",
    "NtUserRegisterHotKey",
    "NtUserRegisterDManipHook",
    "NtUserGetDManipHookInitFunction",
    "NtUserRegisterManipulationThread",
    "NtUserSetManipulationInputTarget",
    "NtUserRegisterUserApiHook",
    "NtUserRegisterErrorReportingDialog",
    "NtUserRegisterClassExWOW",
    "NtUserRegisterBSDRWindow",
    "NtUserRedrawWindow",
    "NtUserUndelegateInput",
    "NtUserGetWindowMinimizeRect",
    "NtUserDwmGetRemoteSessionOcclusionEvent",
    "NtUserDwmGetRemoteSessionOcclusionState",
    "NtUserDwmKernelShutdown",
    "NtUserDwmKernelStartup",
    "NtUserUpdateWindowTransform",
    "NtUserCheckProcessSession",
    "NtUserUnregisterSessionPort",
    "NtUserRegisterSessionPort",
    "NtUserCtxDisplayIOCtl",
    "NtUserRemoteStopScreenUpdates",
    "NtUserRemoteRedrawScreen",
    "NtUserRemoteRedrawRectangle",
    "NtUserRemoteConnect",
    "NtUserWaitAvailableMessageEx",
    "NtUserWindowFromPoint",
    "NtUserWindowFromPhysicalPoint",
    "NtUserWaitMessage",
    "NtUserWaitForMsgAndEvent",
    "NtUserWaitForInputIdle",
    "NtUserVkKeyScanEx",
    "NtUserValidateTimerCallback",
    "NtUserValidateRect",
    "NtUserValidateHandleSecure",
    "NtUserUserHandleGrantAccess",
    "NtUserUpdatePerUserSystemParameters",
    "NtUserSetLayeredWindowAttributes",
    "NtUserGetLayeredWindowAttributes",
    "NtUserUpdateLayeredWindow",
    "NtUserUpdateInstance",
    "NtUserUpdateInputContext",
    "NtUserUnregisterHotKey",
    "NtUserUnregisterUserApiHook",
    "NtUserUnregisterClass",
    "NtUserUnlockWindowStation",
    "NtUserUnloadKeyboardLayout",
    "NtUserUnhookWinEvent",
    "NtUserUnhookWindowsHookEx",
    "NtUserGetTouchInputInfo",
    "NtUserIsTouchWindow",
    "NtUserModifyWindowTouchCapability",
    "NtGdiEngStretchBltROP",
    "NtGdiEngTextOut",
    "NtGdiEngTransparentBlt",
    "NtGdiEngGradientFill",
    "NtGdiEngAlphaBlend",
    "NtGdiEngLineTo",
    "NtGdiEngPaint",
    "NtGdiEngStrokeAndFillPath",
    "NtGdiEngFillPath",
    "NtGdiEngStrokePath",
    "NtGdiEngMarkBandingSurface",
    "NtGdiEngPlgBlt",
    "NtGdiEngStretchBlt",
    "NtGdiEngBitBlt",
    "NtGdiEngLockSurface",
    "NtGdiEngUnlockSurface",
    "NtGdiEngEraseSurface",
    "NtGdiEngDeleteSurface",
    "NtGdiEngDeletePalette",
    "NtGdiEngCopyBits",
    "NtGdiEngComputeGlyphSet",
    "NtGdiEngCreatePalette",
    "NtGdiEngCreateDeviceBitmap",
    "NtGdiEngCreateDeviceSurface",
    "NtGdiEngCreateBitmap",
    "NtGdiEngAssociateSurface",
    "NtUserSetWindowFeedbackSetting",
    "NtUserRegisterEdgy",
    "NtUserRegisterShellPTPListener",
    "NtUserGetWindowFeedbackSetting",
    "NtUserHidePointerContactVisualization",
    "NtUserGetTouchValidationStatus",
    "NtUserInitializeTouchInjection",
    "NtUserInjectTouchInput",
    "NtUserRegisterTouchHitTestingWindow",
    "NtUserSetDisplayMapping",
    "NtUserSetCalibrationData",
    "NtUserGetPhysicalDeviceRect",
    "NtUserRegisterTouchPadCapable",
    "NtUserGetRawPointerDeviceData",
    "NtUserGetPointerDeviceCursors",
    "NtUserGetPointerDeviceRects",
    "NtUserRegisterPointerDeviceNotifications",
    "NtUserGetPointerDeviceProperties",
    "NtUserGetPointerDevice",
    "NtUserGetPointerDevices",
    "NtUserEnableTouchPad",
    "NtUserGetPrecisionTouchPadConfiguration",
    "NtUserSetPrecisionTouchPadConfiguration",
    "NtUserPromotePointer",
    "NtUserDiscardPointerFrameMessages",
    "NtUserRegisterPointerInputTarget",
    "NtUserGetPointerFrameArrivalTimes",
    "NtUserGetPointerInputTransform",
    "NtUserGetPointerInfoList",
    "NtUserGetPointerCursorId",
    "NtUserGetPointerType",
    "NtUserGetGestureConfig",
    "NtUserSetGestureConfig",
    "NtUserGetGestureExtArgs",
    "NtUserGetGestureInfo",
    "NtUserInjectGesture",
    "NtUserChangeWindowMessageFilterEx",
    "NtGdiXLATEOBJ_hGetColorTransform",
    "NtGdiXLATEOBJ_iXlate",
    "NtGdiXLATEOBJ_cGetPalette",
    "NtGdiEngDeleteClip",
    "NtGdiEngCreateClip",
    "NtGdiEngDeletePath",
    "NtGdiCLIPOBJ_ppoGetPath",
    "NtGdiCLIPOBJ_cEnumStart",
    "NtGdiCLIPOBJ_bEnum",
    "NtGdiBRUSHOBJ_hGetColorTransform",
    "NtGdiBRUSHOBJ_pvGetRbrush",
    "NtGdiBRUSHOBJ_pvAllocRbrush",
    "NtGdiBRUSHOBJ_ulGetBrushColor",
    "NtGdiXFORMOBJ_iGetXform",
    "NtGdiXFORMOBJ_bApplyXform",
    "NtGdiFONTOBJ_pQueryGlyphAttrs",
    "NtGdiFONTOBJ_pfdg",
    "NtGdiFONTOBJ_pifi",
    "NtGdiFONTOBJ_cGetGlyphs",
    "NtGdiFONTOBJ_pxoGetXform",
    "NtGdiFONTOBJ_vGetInfo",
    "NtGdiFONTOBJ_cGetAllGlyphHandles",
    "NtGdiFONTOBJ_pvTrueTypeFontFile",
    "NtGdiSTROBJ_dwGetCodePage",
    "NtGdiSTROBJ_vEnumStart",
    "NtGdiSTROBJ_bGetAdvanceWidths",
    "NtGdiSTROBJ_bEnumPositionsOnly",
    "NtGdiSTROBJ_bEnum",
    "NtGdiPATHOBJ_bEnumClipLines",
    "NtGdiPATHOBJ_vEnumStartClipLines",
    "NtGdiPATHOBJ_vEnumStart",
    "NtGdiPATHOBJ_bEnum",
    "NtGdiPATHOBJ_vGetBounds",
    "NtGdiEngCheckAbort",
    "NtGdiGetDhpdev",
    "NtGdiHT_Get8BPPMaskPalette",
    "NtGdiHT_Get8BPPFormatPalette",
    "NtGdiUpdateTransform",
    "NtGdiUMPDEngFreeUserMem",
    "NtGdiBRUSHOBJ_DeleteRbrush",
    "NtGdiSetPUMPDOBJ",
    "NtGdiSetUMPDSandboxState",
    "NtGdiDrawStream",
    "NtGdiHLSurfSetInformation",
    "NtGdiHLSurfGetInformation",
    "NtGdiDwmCreatedBitmapRemotingOutput",
    "NtGdiDdDDIGetScanLine",
    "NtGdiDdDDIReleaseProcessVidPnSourceOwners",
    "NtGdiDdDDIGetProcessSchedulingPriorityClass",
    "NtGdiDdDDISetProcessSchedulingPriorityClass",
    "NtGdiDdDDIGetContextSchedulingPriority",
    "NtGdiDdDDISetContextSchedulingPriority",
    "NtGdiDdDDIDestroyDCFromMemory",
    "NtGdiDdDDICreateDCFromMemory",
    "NtGdiDdDDIGetDeviceState",
    "NtGdiDdDDISetGammaRamp",
    "NtGdiDdDDIWaitForVerticalBlankEvent",
    "NtGdiDdDDIDestroyOverlay",
    "NtGdiDdDDIFlipOverlay",
    "NtGdiDdDDIUpdateOverlay",
    "NtGdiDdDDICreateOverlay",
    "NtGdiDdDDIGetPresentQueueEvent",
    "NtGdiDdDDIGetPresentHistory",
    "NtGdiDdDDISetVidPnSourceOwner1",
    "NtGdiDdDDISetVidPnSourceOwner",
    "NtGdiDdDDIQueryStatistics",
    "NtGdiDdDDIEscape",
    "NtGdiDdDDIGetSharedPrimaryHandle",
    "NtGdiDdDDICloseAdapter",
    "NtGdiDdDDIOpenAdapterFromLuid",
    "NtGdiDdDDIEnumAdapters",
    "NtGdiDdDDIEnumAdapters2",
    "NtGdiDdDDIOpenAdapterFromHdc",
    "NtGdiDdDDIOpenAdapterFromDeviceName",
    "NtGdiDdDDIRender",
    "NtGdiDdDDIPresent",
    "NtGdiDdDDIGetMultisampleMethodList",
    "NtGdiDdDDISetDisplayMode",
    "NtGdiDdDDIGetDisplayModeList",
    "NtGdiDdDDIUnlock",
    "NtGdiDdDDILock",
    "NtGdiDdDDIQueryAdapterInfo",
    "NtGdiDdDDIGetRuntimeData",
    "NtGdiDdDDISignalSynchronizationObject",
    "NtGdiDdDDIWaitForSynchronizationObject",
    "NtGdiDdDDIDestroySynchronizationObject",
    "NtGdiDdDDIOpenSynchronizationObject",
    "NtGdiDdDDICreateSynchronizationObject",
    "NtGdiDdDDIDestroyContext",
    "NtGdiDdDDICreateContext",
    "NtGdiDdDDIDestroyDevice",
    "NtGdiDdDDICreateDevice",
    "NtGdiDdDDIQueryAllocationResidency",
    "NtGdiDdDDISetAllocationPriority",
    "NtGdiDdDDIDestroyAllocation",
    "NtGdiDdDDIDestroyAllocation2",
    "NtGdiDdDDIOpenResourceFromNtHandle",
    "NtGdiDdDDIOpenSyncObjectFromNtHandle",
    "NtGdiDdDDIOpenSyncObjectFromNtHandle2",
    "NtGdiDdDDIOpenResource",
    "NtGdiDdDDIOpenNtHandleFromName",
    "NtGdiDdDDIOpenSyncObjectNtHandleFromName",
    "NtGdiDdDDIShareObjects",
    "NtGdiDdDDIQueryResourceInfoFromNtHandle",
    "NtGdiDdDDIQueryResourceInfo",
    "NtGdiDdDDICreateAllocation",
    "NtGdiDdDDIOutputDuplReleaseFrame",
    "NtGdiDdDDIQueryRemoteVidPnSourceFromGdiDisplayName",
    "NtGdiDdDDIOutputDuplPresent",
    "NtGdiDdDDIReleaseKeyedMutex2",
    "NtGdiDdDDIAcquireKeyedMutex2",
    "NtGdiDdDDIOpenKeyedMutex2",
    "NtGdiDdDDICreateKeyedMutex2",
    "NtGdiDdDDIOutputDuplGetPointerShapeData",
    "NtGdiDdDDIOutputDuplGetMetaData",
    "NtGdiDdDDIOutputDuplGetFrameInfo",
    "NtGdiDdDDIDestroyOutputDupl",
    "NtGdiDdDDICreateOutputDupl",
    "NtGdiDdDDIReclaimAllocations",
    "NtGdiDdDDIOfferAllocations",
    "NtGdiDdDDICheckSharedResourceAccess",
    "NtGdiDdDDICheckVidPnExclusiveOwnership",
    "NtGdiDdDDIGetOverlayState",
    "NtGdiDdDDIConfigureSharedResource",
    "NtGdiDdDDIReleaseKeyedMutex",
    "NtGdiDdDDIAcquireKeyedMutex",
    "NtGdiDdDDIDestroyKeyedMutex",
    "NtGdiDdDDIOpenKeyedMutex",
    "NtGdiDdDDICreateKeyedMutex",
    "NtGdiDdDDISharedPrimaryUnLockNotification",
    "NtGdiDdDDISharedPrimaryLockNotification",
    "NtGdiDdDDISetDisplayPrivateDriverFormat",
    "NtGdiDdDDICheckExclusiveOwnership",
    "NtGdiDdDDICheckMonitorPowerState",
    "NtGdiDdDDIWaitForIdle",
    "NtGdiDdDDICheckOcclusion",
    "NtGdiDdDDIInvalidateActiveVidPn",
    "NtGdiDdDDIPollDisplayChildren",
    "NtGdiDdDDISetQueuedLimit",
    "NtGdiDdDDIPinDirectFlipResources",
    "NtGdiDdDDIUnpinDirectFlipResources",
    "NtGdiDdDDIWaitForVerticalBlankEvent2",
    "NtGdiDdDDIGetDWMVerticalBlankEvent",
    "NtGdiDdDDISetSyncRefreshCountWaitTarget",
    "NtGdiDdDDISetContextInProcessSchedulingPriority",
    "NtGdiDdDDIGetContextInProcessSchedulingPriority",
    "NtGdiDdDDIGetSharedResourceAdapterLuid",
    "NtGdiDdDDISetStereoEnabled",
    "NtGdiDdDDIPresentMultiPlaneOverlay",
    "NtGdiDdDDICheckMultiPlaneOverlaySupport",
    "NtGdiDdDDIMakeResident",
    "NtGdiDdDDIEvict",
    "NtGdiDdDDIUpdateAllocationProperty",
    "NtGdiDdDDIWaitForSynchronizationObjectFromCpu",
    "NtGdiDdDDISignalSynchronizationObjectFromCpu",
    "NtGdiDdDDIWaitForSynchronizationObjectFromGpu",
    "NtGdiDdDDISignalSynchronizationObjectFromGpu",
    "NtGdiDdDDISignalSynchronizationObjectFromGpu2",
    "NtGdiDdDDICreatePagingQueue",
    "NtGdiDdDDIDestroyPagingQueue",
    "NtGdiDdDDILock2",
    "NtGdiDdDDIUnlock2",
    "NtGdiDdDDIInvalidateCache",
    "NtGdiDdDDIGetResourcePresentPrivateDriverData",
    "NtGdiDdDDIMapGpuVirtualAddress",
    "NtGdiDdDDIReserveGpuVirtualAddress",
    "NtGdiDdDDIFreeGpuVirtualAddress",
    "NtGdiDdDDIUpdateGpuVirtualAddress",
    "NtGdiDdDDICreateContextVirtual",
    "NtGdiDdDDISubmitCommand",
    "NtGdiDdDDIGetCachedHybridQueryValue",
    "NtGdiDdDDICacheHybridQueryValue",
    "NtGdiDdDDINetDispGetNextChunkInfo",
    "NtGdiDdDDINetDispQueryMiracastDisplayDeviceSupport",
    "NtGdiDdDDINetDispStartMiracastDisplayDevice",
    "NtGdiDdDDINetDispStopMiracastDisplayDevice",
    "NtGdiDdDDINetDispQueryMiracastDisplayDeviceStatus",
    "NtGdiDdDDINetDispStopSessions",
    "NtGdiDdDDIQueryVideoMemoryInfo",
    "NtGdiDdDDIChangeVideoMemoryReservation",
    "NtGdiDdDDICreateSwapChain",
    "NtGdiDdDDIOpenSwapChain",
    "NtGdiDdDDIGetSetSwapChainMetadata",
    "NtGdiDdDDIAcquireSwapChain",
    "NtGdiDdDDIReleaseSwapChain",
    "NtGdiDdDDIAbandonSwapChain",
    "NtGdiDdDDISetDodIndirectSwapchain",
    "NtGdiDdDDICheckMultiPlaneOverlaySupport2",
    "NtGdiDdDDIPresentMultiPlaneOverlay2",
    "NtGdiDdDDIReclaimAllocations2",
    "NtGdiDdDDISetStablePowerState",
    "NtGdiDdDDIQueryClockCalibration",
    "NtGdiDdDDIQueryVidPnExclusiveOwnership",
    "NtGdiDdDDIAdjustFullscreenGamma",
    "NtGdiDdDDISetVidPnSourceHwProtection",
    "NtGdiDdDDIMarkDeviceAsError",
    "NtGdiDdDDIFlushHeapTransitions",
    "NtGdiDdDDISetHwProtectionTeardownRecovery",
    "NtGdiDdDDIQueryProcessOfferInfo",
    "NtGdiDdDDITrimProcessCommitment",
    "NtGdiDdDDICheckMultiPlaneOverlaySupport3",
    "NtGdiDdDDIPresentMultiPlaneOverlay3",
    "NtGdiDdDDISetFSEBlock",
    "NtGdiDdDDIQueryFSEBlock",
    "NtGdiMakeObjectUnXferable",
    "NtGdiMakeObjectXferable",
    "NtGdiDestroyPhysicalMonitor",
    "NtGdiGetPhysicalMonitorDescription",
    "NtGdiGetPhysicalMonitors",
    "NtGdiGetNumberOfPhysicalMonitors",
    "NtGdiDDCCIGetTimingReport",
    "NtGdiDDCCIGetCapabilitiesString",
    "NtGdiDDCCIGetCapabilitiesStringLength",
    "NtGdiDDCCISaveCurrentSettings",
    "NtGdiDDCCISetVCPFeature",
    "NtGdiDDCCIGetVCPFeature",
    "NtGdiDdQueryVisRgnUniqueness",
    "NtGdiDdDestroyFullscreenSprite",
    "NtGdiDdNotifyFullscreenSpriteUpdate",
    "NtGdiDdCreateFullscreenSprite",
    "NtGdiGetProcessSessionFonts",
    "NtGdiGetPublicFontTableChangeCookie",
    "NtUserShowSystemCursor",
    "NtUserSetMirrorRendering",
    "NtUserMagGetContextInformation",
    "NtUserMagSetContextInformation",
    "NtUserMagControl",
    "NtUserSlicerControl",
    "NtUserHwndSetRedirectionInfo",
    "NtUserHwndQueryRedirectionInfo",
    "NtCreateCompositionSurfaceHandle",
    "NtValidateCompositionSurfaceHandle",
    "NtBindCompositionSurface",
    "NtUnBindCompositionSurface",
    "NtQueryCompositionSurfaceBinding",
    "NtNotifyPresentToCompositionSurface",
    "NtQueryCompositionSurfaceStatistics",
    "NtOpenCompositionSurfaceSectionInfo",
    "NtOpenCompositionSurfaceSwapChainHandleInfo",
    "NtQueryCompositionSurfaceRenderingRealization",
    "NtOpenCompositionSurfaceDirtyRegion",
    "NtQueryCompositionSurfaceHDRMetaData",
    "NtSetCompositionSurfaceHDRMetaData",
    "NtSetCompositionSurfaceDirectFlipState",
    "NtSetCompositionSurfaceStatistics",
    "NtSetCompositionSurfaceBufferCompositionModeAndOrientation",
    "NtSetCompositionSurfaceIndependentFlipInfo",
    "NtDesktopCaptureBits",
    "NtDCompositionEnableMMCSS",
    "NtVisualCaptureBits",
    "NtDCompositionEnableDDASupport",
    "NtCreateCompositionInputSink",
    "NtCreateImplicitCompositionInputSink",
    "NtDuplicateCompositionInputSink",
    "NtQueryCompositionInputSink",
    "NtQueryCompositionInputSinkLuid",
    "NtQueryCompositionInputSinkViewId",
    "NtUpdateInputSinkTransforms",
    "NtCompositionInputThread",
    "NtQueryCompositionInputQueueAndTransform",
    "NtQueryCompositionInputIsImplicit",
    "NtCompositionSetDropTarget",
    "NtTokenManagerOpenSectionAndEvents",
    "NtTokenManagerThread",
    "NtTokenManagerCreateCompositionTokenHandle",
    "NtTokenManagerGetAnalogExclusiveTokenEvent",
    "NtTokenManagerGetAnalogExclusiveSurfaceUpdates",
    "NtTokenManagerConfirmOutstandingAnalogToken",
    "NtSetCompositionSurfaceAnalogExclusive",
    "NtDCompositionBeginFrame",
    "NtDCompositionConfirmFrame",
    "NtDCompositionRetireFrame",
    "NtDCompositionDiscardFrame",
    "NtDCompositionGetFrameSurfaceUpdates",
    "NtDCompositionGetFrameLegacyTokens",
    "NtDCompositionDestroyConnection",
    "NtDCompositionGetConnectionBatch",
    "NtDCompositionGetFrameStatistics",
    "NtDCompositionGetDeletedResources",
    "NtDCompositionCreateConnection",
    "NtDCompositionDestroyChannel",
    "NtDCompositionReleaseAllResources",
    "NtDCompositionSubmitDWMBatch",
    "NtDCompositionProcessChannelBatchBuffer",
    "NtDCompositionCommitChannel",
    "NtDCompositionWaitForChannel",
    "NtDCompositionSetChannelCommitCompletionEvent",
    "NtDCompositionTelemetryTouchInteractionBegin",
    "NtDCompositionTelemetryTouchInteractionUpdate",
    "NtDCompositionTelemetryTouchInteractionEnd",
    "NtDCompositionTelemetrySetApplicationId",
    "NtDCompositionTelemetryAnimationScenarioBegin",
    "NtDCompositionTelemetryAnimationScenarioReference",
    "NtDCompositionTelemetryAnimationScenarioUnreference",
    "NtDCompositionCurrentBatchId",
    "NtDCompositionRemoveCrossDeviceVisualChild",
    "NtDCompositionAddCrossDeviceVisualChild",
    "NtDCompositionCreateDwmChannel",
    "NtDCompositionCreateChannel",
    "NtDCompositionSynchronize",
    "NtDCompositionReferenceSharedResourceOnDwmChannel",
    "NtDCompositionCreateAndBindSharedSection",
    "NtDCompositionSetDebugCounter",
    "NtDCompositionGetChannels",
    "NtDCompositionConnectPipe",
    "NtDCompositionRegisterThumbnailVisual",
    "NtDCompositionRegisterVirtualDesktopVisual",
    "NtDCompositionDuplicateHandleToProcess",
    "NtDCompositionUpdatePointerCapture",
    "NtDCompositionSetChannelCallbackId",
    "NtDCompositionDuplicateSwapchainHandleToDwm",
    "NtUserDestroyDCompositionHwndTarget",
    "NtUserCreateDCompositionHwndTarget",
    "NtUserWaitForRedirectionStartComplete",
    "NtUserSignalRedirectionStartComplete",
    "NtUserSetActiveProcessForMonitor",
    "NtUserGetDisplayAutoRotationPreferencesByProcessId",
    "NtUserGetDisplayAutoRotationPreferences",
    "NtUserSetDisplayAutoRotationPreferences",
    "NtUserSetAutoRotation",
    "NtUserGetAutoRotationState",
    "NtUserAutoRotateScreen",
    "NtUserAcquireIAMKey",
    "NtUserSetActivationFilter",
    "NtUserSetFallbackForeground",
    "NtUserSetBrokeredForeground",
    "NtUserDisableImmersiveOwner",
    "NtUserClearForeground",
    "NtUserEnableIAMAccess",
    "NtUserGetProcessUIContextInformation",
    "NtUserSetProcessRestrictionExemption",
    "NtUserSetWindowArrangement",
    "NtUserSetWindowShowState",
    "NtUserUpdateWindowTrackingInfo",
    "NtUserEnableMouseInPointer",
    "NtUserIsMouseInPointerEnabled",
    "NtUserPromoteMouseInPointer",
    "NtUserAutoPromoteMouseInPointer",
    "NtUserEnableMouseInputForCursorSuppression",
    "NtUserIsMouseInputEnabled",
    "NtUserInternalClipCursor",
    "NtUserCheckProcessForClipboardAccess",
    "NtUserGetClipboardAccessToken",
    "NtUserGetQueueStatusReadonly",
    "NtUserCompositionInputSinkLuidFromPoint",
    "NtUserUpdateWindowInputSinkHints",
    "NtUserTransformPoint",
    "NtUserTransformRect",
    "NtUserGetHimetricScaleFactorFromPixelLocation",
    "NtUserGetDpiForMonitor",
    "NtUserReportInertia",
    "NtUserLinkDpiCursor",
    "NtUserGetCursorDims",
    "NtUserInitializeInputDeviceInjection",
    "NtUserInitializePointerDeviceInjection",
    "NtUserRemoveInjectionDevice",
    "NtUserSetFeatureReportResponse",
    "NtUserInjectDeviceInput",
    "NtUserInjectMouseInput",
    "NtUserInjectKeyboardInput",
    "NtUserInjectPointerInput",
    "NtRIMAddInputObserver",
    "NtRIMRemoveInputObserver",
    "NtRIMUpdateInputObserverRegistration",
    "NtRIMObserveNextInput",
    "NtRIMGetDevicePreparsedDataLockfree",
    "NtUserSetCoreWindow",
    "NtUserSetCoreWindowPartner",
    "NtUserNavigateFocus",
    "NtHWCursorUpdatePointer",
    "NtUserAcquireInteractiveControlBackgroundAccess",
    "NtUserGetInteractiveControlInfo",
    "NtUserGetInteractiveControlDeviceInfo",
    "NtUserSendInteractiveControlHapticsReport",
    "NtUserSetInteractiveControlFocus",
    "NtUserInteractiveControlQueryUsage",
    "NtUserSetInteractiveCtrlRotationAngle",
    "NtUserSetProcessInteractionFlags"
};

//////////////////////////////////////////////////////////////////////////
// Windows 10 RS1 _W32pServiceTableFilter
//////////////////////////////////////////////////////////////////////////
static const char* W32pServiceTableFilter_Win10Rs1_x86[] = {
    "_stub_UserGetOwnerTransformedMonitorRect",
    "_stub_UserYieldTask",
    "_stub_UserSetSensorPresence",
    "_stub_GdiWidenPath",
    "_stub_GdiUpdateColors",
    "_stub_GdiUnrealizeObject",
    "_stub_GdiUnmapMemFont",
    "_stub_GdiUnloadPrinterDriver",
    "_stub_GdiTransparentBlt",
    "NtGdiTransformPoints",
    "_stub_GdiSwapBuffers",
    "_stub_GdiStrokePath",
    "_stub_GdiStrokeAndFillPath",
    "NtGdiStretchDIBitsInternal",
    "NtGdiStretchBlt",
    "_stub_GdiStartPage",
    "_stub_GdiStartDoc",
    "_stub_GdiSetSizeDevice",
    "_stub_GdiSetVirtualResolution",
    "_stub_GdiSetTextJustification",
    "_stub_GdiSetSystemPaletteUse",
    "_stub_GdiSetRectRgn",
    "_stub_GdiSetPixelFormat",
    "NtGdiSetPixel",
    "NtGdiSetOPMSigningKeyAndSequenceNumbers",
    "NtGdiSetLayout",
    "_stub_GdiMirrorWindowOrg",
    "_stub_GdiGetDeviceWidth",
    "_stub_GdiSetMiterLimit",
    "NtGdiSetMetaRgn",
    "_stub_GdiSetMagicColors",
    "_stub_GdiSetLinkedUFIs",
    "NtGdiSetIcmMode",
    "_stub_GdiSetFontXform",
    "_stub_GdiSetFontEnumeration",
    "NtGdiSetDIBitsToDeviceInternal",
    "_stub_GdiSetDeviceGammaRamp",
    "_stub_GdiSetColorSpace",
    "_stub_GdiSetColorAdjustment",
    "_stub_GdiSetBrushOrg",
    "_stub_GdiSetBrushAttributes",
    "NtGdiSetBoundsRect",
    "_stub_GdiSetBitmapDimension",
    "NtGdiSetBitmapBits",
    "_stub_GdiSetBitmapAttributes",
    "_stub_GdiSelectPen",
    "NtGdiSelectFont",
    "_stub_GdiSelectClipPath",
    "_stub_GdiSelectBrush",
    "NtGdiSelectBitmap",
    "_stub_GdiScaleWindowExtEx",
    "_stub_GdiScaleViewportExtEx",
    "NtGdiSaveDC",
    "NtGdiRoundRect",
    "NtGdiRestoreDC",
    "_stub_GdiResizePalette",
    "_stub_GdiResetDC",
    "_stub_GdiRemoveFontMemResourceEx",
    "_stub_GdiRemoveFontResourceW",
    "NtGdiRectVisible",
    "NtGdiRectInRegion",
    "NtGdiRectangle",
    "NtGdiQueryFontAssocInfo",
    "_stub_GdiQueryFonts",
    "_stub_GdiPtVisible",
    "_stub_GdiPtInRegion",
    "_stub_GdiPolyTextOutW",
    "NtGdiPolyPolyDraw",
    "_stub_GdiPolyDraw",
    "_stub_GdiPlgBlt",
    "_stub_GdiPathToRegion",
    "NtGdiPolyPatBlt",
    "NtGdiPatBlt",
    "NtGdiOpenDCW",
    "NtGdiOffsetRgn",
    "_stub_GdiOffsetClipRgn",
    "_stub_GdiMoveTo",
    "_stub_GdiMonoBitmap",
    "NtGdiModifyWorldTransform",
    "_stub_GdiMaskBlt",
    "_stub_GdiMakeInfoDC",
    "_stub_GdiMakeFontDir",
    "NtGdiLineTo",
    "_stub_GdiInvertRgn",
    "NtGdiIntersectClipRect",
    "_stub_GdiInitSpool",
    "NtGdiInit",
    "_stub_GdiIcmBrushInfo",
    "NtGdiHfontCreate",
    "NtGdiGradientFill",
    "NtGdiGetWidthTable",
    "_stub_GdiGetFontUnicodeRanges",
    "_stub_GdiAddEmbFontToDC",
    "_stub_GdiChangeGhostFont",
    "_stub_GdiGetEmbedFonts",
    "_stub_GdiGetUFIPathname",
    "_stub_GdiGetEmbUFI",
    "_stub_GdiGetUFI",
    "NtGdiGetTransform",
    "NtGdiGetTextMetricsW",
    "NtGdiGetTextFaceW",
    "NtGdiGetTextExtentExW",
    "_stub_GdiGetTextExtent",
    "NtGdiGetTextCharsetInfo",
    "_stub_GdiGetSystemPaletteUse",
    "NtGdiGetSuggestedOPMProtectedOutputArraySize",
    "_stub_GdiGetStringBitmapW",
    "_stub_GdiGetStats",
    "_stub_GdiGetSpoolMessage",
    "_stub_GdiGetServerMetaFileBits",
    "_stub_GdiGetRgnBox",
    "NtGdiGetRegionData",
    "NtGdiGetRealizationInfo",
    "_stub_GdiGetRasterizerCaps",
    "NtGdiGetRandomRgn",
    "NtGdiGetPixel",
    "_stub_GdiGetPath",
    "NtGdiGetOutlineTextMetricsInternalW",
    "NtGdiGetOPMRandomNumber",
    "_stub_GdiGetObjectBitmapHandle",
    "_stub_GdiGetNearestPaletteIndex",
    "_stub_GdiGetNearestColor",
    "_stub_GdiGetMonitorID",
    "_stub_GdiGetMiterLimit",
    "_stub_GdiGetLinkedUFIs",
    "_stub_GdiGetKerningPairs",
    "NtGdiGetOPMInformation",
    "_stub_GdiGetGlyphOutline",
    "_stub_GdiGetGlyphIndicesWInternal",
    "NtGdiGetGlyphIndicesW",
    "_stub_GdiGetFontResourceInfoInternalW",
    "_stub_GdiGetFontFileInfo",
    "_stub_GdiGetFontFileData",
    "NtGdiGetFontData",
    "_stub_GdiGetEudcTimeStampEx",
    "_stub_GdiGetETM",
    "NtGdiGetEntry",
    "NtGdiGetDIBitsInternal",
    "_stub_GdiGetDeviceCapsAll",
    "_stub_GdiGetDeviceGammaRamp",
    "NtGdiGetDeviceCaps",
    "NtGdiGetDCPoint",
    "NtGdiGetDCObject",
    "NtGdiGetDCforBitmap",
    "NtGdiGetDCDword",
    "NtGdiGetCurrentDpiInfo",
    "_stub_GdiGetCOPPCompatibleOPMInformation",
    "_stub_GdiGetColorSpaceforBitmap",
    "_stub_GdiGetColorAdjustment",
    "_stub_GdiGetCharWidthInfo",
    "NtGdiGetCharWidthW",
    "NtGdiGetCharSet",
    "_stub_GdiGetCharacterPlacementW",
    "NtGdiGetCharABCWidthsW",
    "_stub_GdiGetCertificateSize",
    "_stub_GdiGetCertificate",
    "NtGdiGetCertificateSizeByHandle",
    "NtGdiGetCertificateByHandle",
    "NtGdiGetBoundsRect",
    "_stub_GdiGetBitmapDimension",
    "NtGdiGetBitmapBits",
    "NtGdiGetAppClipBox",
    "NtGdiGetAndSetDCDword",
    "_stub_GdiFullscreenControl",
    "NtGdiFrameRgn",
    "_stub_GdiForceUFIMapping",
    "NtGdiFlush",
    "_stub_GdiFlattenPath",
    "NtGdiFillRgn",
    "_stub_GdiFillPath",
    "NtGdiExtTextOutW",
    "NtGdiExtSelectClipRgn",
    "NtGdiExtGetObjectW",
    "_stub_GdiExtFloodFill",
    "_stub_GdiExtEscape",
    "NtGdiExtCreateRegion",
    "NtGdiExtCreatePen",
    "NtGdiExcludeClipRect",
    "_stub_GdiEudcLoadUnloadLink",
    "_stub_GdiEqualRgn",
    "_stub_GdiEnumObjects",
    "NtGdiEnumFonts",
    "_stub_GdiEndPath",
    "_stub_GdiEndPage",
    "NtGdiEndGdiRendering",
    "_stub_GdiEndDoc",
    "_stub_GdiEnableEudc",
    "_stub_GdiEllipse",
    "_stub_GdiDrawEscape",
    "NtGdiDoPalette",
    "_stub_GdiDoBanding",
    "_stub_GdiGetPerBandInfo",
    "NtGdiDestroyOPMProtectedOutput",
    "_stub_GdiDescribePixelFormat",
    "NtGdiDeleteObjectApp",
    "_stub_GdiDeleteColorTransform",
    "_stub_GdiDeleteColorSpace",
    "NtGdiDeleteClientObj",
    "_stub_GdiDxgGenericThunk",
    "_stub_GdiDvpReleaseNotification",
    "_stub_GdiDvpAcquireNotification",
    "_stub_GdiDvpWaitForVideoPortSync",
    "_stub_GdiDvpUpdateVideoPort",
    "_stub_GdiDvpGetVideoSignalStatus",
    "_stub_GdiDvpGetVideoPortConnectInfo",
    "_stub_GdiDvpGetVideoPortOutputFormats",
    "_stub_GdiDvpGetVideoPortLine",
    "_stub_GdiDvpGetVideoPortInputFormats",
    "_stub_GdiDvpGetVideoPortFlipStatus",
    "_stub_GdiDvpGetVideoPortField",
    "_stub_GdiDvpGetVideoPortBandwidth",
    "_stub_GdiDvpFlipVideoPort",
    "_stub_GdiDvpDestroyVideoPort",
    "_stub_GdiDvpCreateVideoPort",
    "_stub_GdiDvpColorControl",
    "_stub_GdiDvpCanCreateVideoPort",
    "_stub_GdiDdWaitForVerticalBlank",
    "_stub_GdiDdUpdateOverlay",
    "_stub_GdiDdUnlockD3D",
    "_stub_GdiDdUnlock",
    "_stub_GdiDdUnattachSurface",
    "_stub_GdiDdSetOverlayPosition",
    "_stub_GdiDdCreateSurfaceEx",
    "_stub_GdiDdSetGammaRamp",
    "_stub_GdiDdSetExclusiveMode",
    "_stub_GdiDdSetColorKey",
    "_stub_GdiDdResetVisrgn",
    "_stub_GdiDdRenderMoComp",
    "_stub_GdiDdReleaseDC",
    "_stub_GdiDdReenableDirectDrawObject",
    "_stub_GdiDdQueryMoCompStatus",
    "_stub_GdiDdQueryDirectDrawObject",
    "_stub_GdiDdLockD3D",
    "_stub_GdiDdLock",
    "_stub_GdiDdGetScanLine",
    "_stub_GdiDdGetMoCompFormats",
    "_stub_GdiDdGetMoCompGuids",
    "_stub_GdiDdGetMoCompBuffInfo",
    "_stub_GdiDdGetInternalMoCompInfo",
    "_stub_GdiDdGetFlipStatus",
    "_stub_GdiDdGetDxHandle",
    "_stub_GdiDdGetDriverInfo",
    "_stub_GdiDdGetDC",
    "_stub_GdiDdGetBltStatus",
    "_stub_GdiDdGetAvailDriverMemory",
    "_stub_GdiDdFlipToGDISurface",
    "_stub_GdiDdFlip",
    "_stub_GdiDdEndMoCompFrame",
    "_stub_GdiDdDestroyD3DBuffer",
    "_stub_GdiDdDestroySurface",
    "_stub_GdiDdDestroyMoComp",
    "_stub_GdiDdDeleteSurfaceObject",
    "_stub_GdiDdDeleteDirectDrawObject",
    "_stub_GdiDdCreateSurfaceObject",
    "_stub_GdiDdCreateMoComp",
    "_stub_GdiDdCreateD3DBuffer",
    "_stub_GdiDdCreateSurface",
    "_stub_GdiDdCreateDirectDrawObject",
    "_stub_GdiDdColorControl",
    "_stub_GdiDdCanCreateD3DBuffer",
    "_stub_GdiDdCanCreateSurface",
    "_stub_GdiDdBlt",
    "_stub_GdiDdBeginMoCompFrame",
    "_stub_GdiDdAttachSurface",
    "_stub_GdiDdAlphaBlt",
    "_stub_GdiDdAddAttachedSurface",
    "_stub_GdiDdGetDriverState",
    "_stub_GdiD3dDrawPrimitives2",
    "_stub_GdiD3dValidateTextureStageState",
    "_stub_GdiD3dContextDestroyAll",
    "_stub_GdiD3dContextDestroy",
    "_stub_GdiD3dContextCreate",
    "NtGdiCreateSolidBrush",
    "_stub_GdiCreateServerMetaFile",
    "NtGdiCreateRoundRectRgn",
    "NtGdiCreateRectRgn",
    "NtGdiCreatePen",
    "NtGdiCreatePatternBrushInternal",
    "NtGdiCreatePaletteInternal",
    "NtGdiCreateOPMProtectedOutputs",
    "NtGdiCreateOPMProtectedOutput",
    "_stub_GdiCreateMetafileDC",
    "_stub_GdiCreateHatchBrushInternal",
    "_stub_GdiCreateHalftonePalette",
    "_stub_GdiCreateEllipticRgn",
    "_stub_GdiCreateSessionMappedDIBSection",
    "NtGdiCreateDIBSection",
    "NtGdiCreateDIBitmapInternal",
    "_stub_GdiCreateDIBBrush",
    "NtGdiCreateCompatibleDC",
    "NtGdiCreateCompatibleBitmap",
    "_stub_GdiCreateColorTransform",
    "_stub_GdiCreateColorSpace",
    "NtGdiCreateClientObj",
    "NtGdiCreateBitmapFromDxSurface2",
    "_stub_GdiCreateBitmapFromDxSurface",
    "NtGdiCreateBitmap",
    "_stub_GdiConvertMetafileRect",
    "NtGdiConfigureOPMProtectedOutput",
    "NtGdiComputeXformCoefficients",
    "_stub_GdiCombineTransform",
    "NtGdiCombineRgn",
    "_stub_GdiColorCorrectPalette",
    "_stub_GdiClearBrushAttributes",
    "_stub_GdiClearBitmapAttributes",
    "_stub_GdiCloseFigure",
    "_stub_GdiCheckBitmapBits",
    "_stub_GdiCancelDC",
    "NtGdiBitBlt",
    "_stub_GdiBeginPath",
    "NtGdiBeginGdiRendering",
    "_stub_GdiArcInternal",
    "NtGdiFontIsLinked",
    "NtGdiAnyLinkedFonts",
    "_stub_GdiAngleArc",
    "NtGdiAlphaBlend",
    "_stub_GdiAddRemoteMMInstanceToDC",
    "_stub_GdiRemoveMergeFont",
    "_stub_GdiAddFontMemResourceEx",
    "_stub_GdiAddRemoteFontToDC",
    "_stub_GdiAddFontResourceW",
    "_stub_GdiAbortPath",
    "_stub_GdiAbortDoc",
    "_stub_UserDefSetText",
    "_stub_UserDeferWindowPosAndBand",
    "_stub_UserDdeInitialize",
    "_stub_UserCanBrokerForceForeground",
    "_stub_UserCreateWindowStation",
    "NtUserCreateWindowEx",
    "_stub_UserCreateLocalMemHandle",
    "NtUserCreateInputContext",
    "_stub_UserCreateDesktopEx",
    "NtUserCreateCaret",
    "NtUserCreateAcceleratorTable",
    "NtUserCountClipboardFormats",
    "_stub_UserCopyAcceleratorTable",
    "_stub_UserConvertMemHandle",
    "_stub_UserConsoleControl",
    "NtUserCloseWindowStation",
    "NtUserCloseDesktop",
    "NtUserCloseClipboard",
    "NtUserClipCursor",
    "NtUserChildWindowFromPointEx",
    "_stub_UserCheckMenuItem",
    "_stub_UserCheckWindowThreadDesktop",
    "_stub_UserDwmValidateWindow",
    "_stub_UserCheckAccessForIntegrityLevel",
    "_stub_UserDisplayConfigSetDeviceInfo",
    "NtUserDisplayConfigGetDeviceInfo",
    "NtUserQueryDisplayConfig",
    "_stub_UserSetDisplayConfig",
    "NtUserGetDisplayConfigBufferSizes",
    "_stub_UserChangeDisplaySettings",
    "NtUserChangeClipboardChain",
    "NtUserCallTwoParam",
    "NtUserCallOneParam",
    "NtUserCallNoParam",
    "NtUserCallNextHookEx",
    "NtUserCallMsgFilter",
    "NtUserCallHwndParamLock",
    "NtUserCallHwndParam",
    "_stub_UserCallHwndOpt",
    "NtUserCallHwndLock",
    "NtUserCallHwnd",
    "_stub_UserBroadcastThemeChangeEvent",
    "_stub_UserBuildPropList",
    "NtUserBuildNameList",
    "NtUserBuildHwndList",
    "NtUserBuildHimcList",
    "_stub_UserBlockInput",
    "NtUserBitBltSysBmp",
    "NtUserBeginPaint",
    "_stub_UserAttachThreadInput",
    "NtUserAssociateInputContext",
    "_stub_UserAlterWindowStyle",
    "_stub_UserAddClipboardFormatListener",
    "NtUserActivateKeyboardLayout",
    "NtUserDelegateCapturePointers",
    "NtUserDelegateInput",
    "NtUserDispatchMessage",
    "_stub_UserDisableProcessWindowFiltering",
    "NtUserDisableThreadIme",
    "NtUserDestroyWindow",
    "NtUserDestroyMenu",
    "NtUserDestroyInputContext",
    "NtUserDestroyCursor",
    "NtUserDestroyAcceleratorTable",
    "NtUserDeleteMenu",
    "_stub_UserDoSoundDisconnect",
    "_stub_UserDoSoundConnect",
    "_stub_UserGhostWindowFromHungWindow",
    "_stub_UserGetWOWClass",
    "NtUserGetWindowPlacement",
    "_stub_UserGetWindowDisplayAffinity",
    "NtUserGetWindowDC",
    "NtUserGetWindowCompositionAttribute",
    "_stub_UserGetWindowCompositionInfo",
    "NtUserGetWindowBand",
    "_stub_UserGetUpdateRgn",
    "NtUserGetUpdateRect",
    "_stub_UserGetUpdatedClipboardFormats",
    "_stub_UserGetTopLevelWindow",
    "NtUserGetTitleBarInfo",
    "NtUserGetThreadState",
    "NtUserGetThreadDesktop",
    "NtUserGetSystemMenu",
    "_stub_UserGetScrollBarInfo",
    "_stub_UserGetRegisteredRawInputDevices",
    "NtUserGetRawInputDeviceList",
    "_stub_UserGetRawInputDeviceInfo",
    "NtUserGetRawInputData",
    "_stub_UserGetRawInputBuffer",
    "NtUserGetProcessDpiAwarenessContext",
    "NtUserGetProcessWindowStation",
    "_stub_UserGetPriorityClipboardFormat",
    "NtUserGetOpenClipboardWindow",
    "NtUserGetObjectInformation",
    "_stub_UserGetMouseMovePointsEx",
    "NtUserGetMessage",
    "_stub_UserGetMenuItemRect",
    "_stub_UserGetMenuIndex",
    "NtUserGetMenuBarInfo",
    "_stub_UserGetListBoxInfo",
    "NtUserGetKeyState",
    "NtUserGetKeyNameText",
    "NtUserGetKeyboardState",
    "NtUserGetKeyboardLayoutName",
    "NtUserGetKeyboardLayoutList",
    "_stub_UserGetInternalWindowPos",
    "_stub_UserGetInputLocaleInfo",
    "NtUserGetImeInfoEx",
    "NtUserGetImeHotKey",
    "NtUserGetIconSize",
    "NtUserGetIconInfo",
    "NtUserGetGUIThreadInfo",
    "_stub_UserGetGuiResources",
    "NtUserGetForegroundWindow",
    "NtUserGetDoubleClickTime",
    "_stub_UserGetDesktopID",
    "NtUserGetDCEx",
    "NtUserGetDC",
    "NtUserGetCursorInfo",
    "NtUserGetCursorFrameInfo",
    "NtUserGetCurrentInputMessageSource",
    "NtUserGetCIMSSM",
    "NtUserGetCPD",
    "NtUserGetControlColor",
    "NtUserGetControlBrush",
    "_stub_UserGetComboBoxInfo",
    "_stub_UserGetClipCursor",
    "_stub_UserGetClipboardViewer",
    "NtUserGetClipboardSequenceNumber",
    "_stub_UserGetClipboardOwner",
    "NtUserGetClipboardFormatName",
    "_stub_UserGetClipboardData",
    "NtUserGetClassName",
    "NtUserGetClassInfoEx",
    "NtUserGetCaretPos",
    "NtUserGetCaretBlinkTime",
    "NtUserGetAtomName",
    "NtUserGetAsyncKeyState",
    "_stub_UserGetAppImeLevel",
    "NtUserGetAncestor",
    "_stub_UserGetAltTabInfo",
    "_stub_UserFrostCrashedWindow",
    "_stub_UserFlashWindowEx",
    "NtUserFindWindowEx",
    "NtUserFindExistingCursorIcon",
    "NtUserFillWindow",
    "_stub_UserExcludeUpdateRgn",
    "_stub_UserEvent",
    "NtUserEnumDisplaySettings",
    "NtUserEnumDisplayMonitors",
    "NtUserEnumDisplayDevices",
    "NtUserEndPaint",
    "NtUserEndMenu",
    "_stub_UserEndDeferWindowPosEx",
    "_stub_UserEnableScrollBar",
    "_stub_UserEnableMenuItem",
    "_stub_UserEmptyClipboard",
    "_stub_UserDrawMenuBarTemp",
    "NtUserDrawIconEx",
    "_stub_UserDrawCaptionTemp",
    "_stub_UserDrawCaption",
    "_stub_UserDrawAnimatedRects",
    "_stub_UserDragObject",
    "_stub_UserDragDetect",
    "NtUserHandleDelegatedInput",
    "_stub_UserInheritWindowMonitor",
    "_stub_UserRealChildWindowFromPoint",
    "NtUserQueryWindow",
    "_stub_UserQuerySendMessage",
    "NtUserQueryInputContext",
    "_stub_UserQueryInformationThread",
    "_stub_UserQueryBSDRWindow",
    "_stub_UserPerMonitorDPIPhysicalToLogicalPoint",
    "_stub_UserProcessConnect",
    "_stub_UserPrintWindow",
    "NtUserPostThreadMessage",
    "NtUserPostMessage",
    "NtUserPhysicalToLogicalPoint",
    "NtUserPeekMessage",
    "_stub_UserPaintMonitor",
    "_stub_UserPaintDesktop",
    "_stub_UserOpenWindowStation",
    "_stub_UserOpenThreadDesktop",
    "NtUserOpenInputDesktop",
    "NtUserOpenDesktop",
    "NtUserOpenClipboard",
    "NtUserNotifyWinEvent",
    "_stub_UserNotifyProcessCreate",
    "NtUserNotifyIMEStatus",
    "NtUserMoveWindow",
    "NtUserModifyUserStartupInfoFlags",
    "_stub_UserMNDragOver",
    "_stub_UserMNDragLeave",
    "_stub_UserMinMaximize",
    "NtUserMessageCall",
    "_stub_UserMenuItemFromPoint",
    "NtUserMapVirtualKeyEx",
    "_stub_UserLayoutCompleted",
    "NtUserLogicalToPerMonitorDPIPhysicalPoint",
    "NtUserLogicalToPhysicalPoint",
    "_stub_UserLockWorkStation",
    "_stub_UserLockWindowUpdate",
    "_stub_UserLockWindowStation",
    "NtUserLoadKeyboardLayoutEx",
    "NtUserKillTimer",
    "NtUserIsTopLevelWindow",
    "NtUserIsClipboardFormatAvailable",
    "_stub_UserInvalidateRgn",
    "NtUserInvalidateRect",
    "_stub_UserInternalGetWindowIcon",
    "NtUserInternalGetWindowText",
    "_stub_UserInitTask",
    "_stub_UserInitializeClientPfnArrays",
    "_stub_UserInitialize",
    "_stub_UserImpersonateDdeClientWindow",
    "_stub_UserHungWindowFromGhostWindow",
    "_stub_UserHiliteMenuItem",
    "_stub_UserHideCaret",
    "_stub_UserHardErrorControl",
    "NtUserRealInternalGetMessage",
    "_stub_UserRealWaitMessageEx",
    "_stub_UserReleaseDwmHitTestWaiters",
    "NtUserTranslateMessage",
    "_stub_UserTranslateAccelerator",
    "_stub_UserPaintMenuBar",
    "NtUserCalcMenuBar",
    "_stub_UserCalculatePopupWindowPosition",
    "NtUserTrackPopupMenuEx",
    "NtUserTrackMouseEvent",
    "NtUserToUnicodeEx",
    "NtUserThunkedMenuItemInfo",
    "NtUserThunkedMenuInfo",
    "_stub_UserTestForInteractiveUser",
    "_stub_UserSendEventMessage",
    "NtUserSystemParametersInfo",
    "_stub_UserSystemParametersInfoForDpi",
    "_stub_UserSwitchDesktop",
    "_stub_UserSoundSentry",
    "_stub_UserShutdownReasonDestroy",
    "_stub_UserShutdownBlockReasonQuery",
    "_stub_UserShutdownBlockReasonCreate",
    "_stub_UserShowWindowAsync",
    "NtUserShowWindow",
    "_stub_UserShowScrollBar",
    "NtUserShowCaret",
    "NtUserSetWinEventHook",
    "_stub_UserSetWindowWord",
    "_stub_UserSetWindowStationUser",
    "NtUserSetWindowsHookEx",
    "_stub_UserSetWindowsHookAW",
    "_stub_UserSetWindowRgnEx",
    "_stub_UserGetWindowRgnEx",
    "NtUserSetWindowRgn",
    "NtUserSetWindowPos",
    "_stub_UserSetWindowPlacement",
    "NtUserSetWindowLong",
    "NtUserSetWindowFNID",
    "_stub_UserSetWindowDisplayAffinity",
    "_stub_UserSetWindowCompositionTransition",
    "_stub_UserUpdateDefaultDesktopThumbnail",
    "NtUserSetWindowCompositionAttribute",
    "_stub_UserSetWindowBand",
    "_stub_UserSetProcessUIAccessZorder",
    "NtUserSetProcessDpiAwarenessContext",
    "_stub_UserEnableChildWindowDpiMessage",
    "NtUserIsChildWindowDpiMessageEnabled",
    "_stub_UserEnableNonClientDpiScaling",
    "NtUserIsNonClientDpiScalingEnabled",
    "NtUserIsWindowBroadcastingDpiToChildren",
    "NtUserSetTimer",
    "_stub_UserSetThreadState",
    "NtUserSetThreadLayoutHandles",
    "NtUserSetThreadDesktop",
    "NtUserSetThreadInputBlocked",
    "_stub_UserSetSystemTimer",
    "_stub_UserSetSystemMenu",
    "_stub_UserSetSystemCursor",
    "_stub_UserSetSysColors",
    "_stub_UserSetShellWindowEx",
    "NtUserSetScrollInfo",
    "NtUserSetProp",
    "NtUserGetProp",
    "_stub_UserSetProcessWindowStation",
    "NtUserSetParent",
    "_stub_UserSetObjectInformation",
    "_stub_UserSetMenuFlagRtoL",
    "_stub_UserSetMenuDefaultItem",
    "_stub_UserSetMenuContextHelpId",
    "_stub_UserSetMenu",
    "NtUserSetKeyboardState",
    "_stub_UserSetInternalWindowPos",
    "_stub_UserSetInformationThread",
    "NtUserSetImeOwnerWindow",
    "NtUserSetImeInfoEx",
    "NtUserSetImeHotKey",
    "NtUserSetFocus",
    "NtUserSetCursorIconData",
    "_stub_UserSetCursorContents",
    "NtUserSetCursor",
    "NtUserSetClipboardViewer",
    "_stub_UserSetClipboardData",
    "_stub_UserSetClassWord",
    "_stub_UserSetClassLong",
    "_stub_UserSetChildWindowNoActivate",
    "NtUserSetCapture",
    "_stub_UserSetAppImeLevel",
    "NtUserSetActiveWindow",
    "NtUserSendInput",
    "NtUserSelectPalette",
    "_stub_UserScrollWindowEx",
    "NtUserScrollDC",
    "_stub_UserSBGetParms",
    "_stub_UserResolveDesktopForWOW",
    "NtUserRemoveProp",
    "NtUserRemoveMenu",
    "_stub_UserRemoveClipboardFormatListener",
    "NtUserRegisterWindowMessage",
    "_stub_UserRegisterTasklist",
    "_stub_UserRegisterServicesProcess",
    "NtUserRegisterRawInputDevices",
    "NtUserRegisterHotKey",
    "_stub_UserRegisterDManipHook",
    "NtUserGetDManipHookInitFunction",
    "_stub_UserRegisterManipulationThread",
    "_stub_UserSetManipulationInputTarget",
    "_stub_UserRegisterUserApiHook",
    "_stub_UserRegisterErrorReportingDialog",
    "NtUserRegisterClassExWOW",
    "_stub_UserRegisterBSDRWindow",
    "NtUserRedrawWindow",
    "NtUserUndelegateInput",
    "_stub_UserGetWindowMinimizeRect",
    "_stub_UserDwmGetRemoteSessionOcclusionEvent",
    "_stub_UserDwmGetRemoteSessionOcclusionState",
    "_stub_UserDwmKernelShutdown",
    "_stub_UserDwmKernelStartup",
    "_stub_UserUpdateWindowTransform",
    "_stub_UserCheckProcessSession",
    "_stub_UserUnregisterSessionPort",
    "_stub_UserRegisterSessionPort",
    "_stub_UserCtxDisplayIOCtl",
    "_stub_UserRemoteStopScreenUpdates",
    "_stub_UserRemoteRedrawScreen",
    "_stub_UserRemoteRedrawRectangle",
    "_stub_UserRemoteConnect",
    "_stub_UserWaitAvailableMessageEx",
    "NtUserWindowFromPoint",
    "_stub_UserWindowFromPhysicalPoint",
    "NtUserWaitMessage",
    "_stub_UserWaitForMsgAndEvent",
    "_stub_UserWaitForInputIdle",
    "NtUserVkKeyScanEx",
    "NtUserValidateTimerCallback",
    "NtUserValidateRect",
    "_stub_UserValidateHandleSecure",
    "_stub_UserUserHandleGrantAccess",
    "_stub_UserUpdatePerUserSystemParameters",
    "NtUserSetLayeredWindowAttributes",
    "NtUserGetLayeredWindowAttributes",
    "NtUserUpdateLayeredWindow",
    "_stub_UserUpdateInstance",
    "NtUserUpdateInputContext",
    "_stub_UserUnregisterHotKey",
    "_stub_UserUnregisterUserApiHook",
    "NtUserUnregisterClass",
    "_stub_UserUnlockWindowStation",
    "_stub_UserUnloadKeyboardLayout",
    "NtUserUnhookWinEvent",
    "NtUserUnhookWindowsHookEx",
    "_stub_UserGetTouchInputInfo",
    "NtUserIsTouchWindow",
    "NtUserModifyWindowTouchCapability",
    "_stub_GdiEngStretchBltROP",
    "_stub_GdiEngTextOut",
    "_stub_GdiEngTransparentBlt",
    "_stub_GdiEngGradientFill",
    "_stub_GdiEngAlphaBlend",
    "_stub_GdiEngLineTo",
    "_stub_GdiEngPaint",
    "_stub_GdiEngStrokeAndFillPath",
    "_stub_GdiEngFillPath",
    "_stub_GdiEngStrokePath",
    "_stub_GdiEngMarkBandingSurface",
    "_stub_GdiEngPlgBlt",
    "_stub_GdiEngStretchBlt",
    "_stub_GdiEngBitBlt",
    "_stub_GdiEngLockSurface",
    "_stub_GdiEngUnlockSurface",
    "_stub_GdiEngEraseSurface",
    "_stub_GdiEngDeleteSurface",
    "_stub_GdiEngDeletePalette",
    "_stub_GdiEngCopyBits",
    "_stub_GdiEngComputeGlyphSet",
    "_stub_GdiEngCreatePalette",
    "_stub_GdiEngCreateDeviceBitmap",
    "_stub_GdiEngCreateDeviceSurface",
    "_stub_GdiEngCreateBitmap",
    "_stub_GdiEngAssociateSurface",
    "NtUserSetWindowFeedbackSetting",
    "_stub_UserRegisterEdgy",
    "_stub_UserRegisterShellPTPListener",
    "NtUserGetWindowFeedbackSetting",
    "NtUserHidePointerContactVisualization",
    "_stub_UserGetTouchValidationStatus",
    "_stub_UserInitializeTouchInjection",
    "_stub_UserInjectTouchInput",
    "NtUserRegisterTouchHitTestingWindow",
    "_stub_UserSetDisplayMapping",
    "_stub_UserSetCalibrationData",
    "NtUserGetPhysicalDeviceRect",
    "_stub_UserRegisterTouchPadCapable",
    "NtUserGetRawPointerDeviceData",
    "_stub_UserGetPointerDeviceCursors",
    "NtUserGetPointerDeviceRects",
    "_stub_UserRegisterPointerDeviceNotifications",
    "NtUserGetPointerDeviceProperties",
    "NtUserGetPointerDevice",
    "NtUserGetPointerDevices",
    "_stub_UserEnableTouchPad",
    "NtUserGetPrecisionTouchPadConfiguration",
    "_stub_UserSetPrecisionTouchPadConfiguration",
    "NtUserPromotePointer",
    "_stub_UserDiscardPointerFrameMessages",
    "_stub_UserRegisterPointerInputTarget",
    "NtUserGetPointerFrameArrivalTimes",
    "NtUserGetPointerInputTransform",
    "NtUserGetPointerInfoList",
    "NtUserGetPointerCursorId",
    "NtUserGetPointerType",
    "NtUserGetGestureConfig",
    "NtUserSetGestureConfig",
    "_stub_UserGetGestureExtArgs",
    "_stub_UserGetGestureInfo",
    "_stub_UserInjectGesture",
    "NtUserChangeWindowMessageFilterEx",
    "_stub_GdiXLATEOBJ_hGetColorTransform",
    "_stub_GdiXLATEOBJ_iXlate",
    "_stub_GdiXLATEOBJ_cGetPalette",
    "_stub_GdiEngDeleteClip",
    "_stub_GdiEngCreateClip",
    "_stub_GdiEngDeletePath",
    "_stub_GdiCLIPOBJ_ppoGetPath",
    "_stub_GdiCLIPOBJ_cEnumStart",
    "_stub_GdiCLIPOBJ_bEnum",
    "_stub_GdiBRUSHOBJ_hGetColorTransform",
    "_stub_GdiBRUSHOBJ_pvGetRbrush",
    "_stub_GdiBRUSHOBJ_pvAllocRbrush",
    "_stub_GdiBRUSHOBJ_ulGetBrushColor",
    "_stub_GdiXFORMOBJ_iGetXform",
    "_stub_GdiXFORMOBJ_bApplyXform",
    "_stub_GdiFONTOBJ_pQueryGlyphAttrs",
    "_stub_GdiFONTOBJ_pfdg",
    "_stub_GdiFONTOBJ_pifi",
    "_stub_GdiFONTOBJ_cGetGlyphs",
    "_stub_GdiFONTOBJ_pxoGetXform",
    "_stub_GdiFONTOBJ_vGetInfo",
    "_stub_GdiFONTOBJ_cGetAllGlyphHandles",
    "_stub_GdiFONTOBJ_pvTrueTypeFontFile",
    "_stub_GdiSTROBJ_dwGetCodePage",
    "_stub_GdiSTROBJ_vEnumStart",
    "_stub_GdiSTROBJ_bGetAdvanceWidths",
    "_stub_GdiSTROBJ_bEnumPositionsOnly",
    "_stub_GdiSTROBJ_bEnum",
    "_stub_GdiPATHOBJ_bEnumClipLines",
    "_stub_GdiPATHOBJ_vEnumStartClipLines",
    "_stub_GdiPATHOBJ_vEnumStart",
    "_stub_GdiPATHOBJ_bEnum",
    "_stub_GdiPATHOBJ_vGetBounds",
    "_stub_GdiEngCheckAbort",
    "_stub_GdiGetDhpdev",
    "_stub_GdiHT_Get8BPPMaskPalette",
    "_stub_GdiHT_Get8BPPFormatPalette",
    "_stub_GdiUpdateTransform",
    "_stub_GdiUMPDEngFreeUserMem",
    "_stub_GdiBRUSHOBJ_DeleteRbrush",
    "_stub_GdiSetPUMPDOBJ",
    "NtGdiSetUMPDSandboxState",
    "NtGdiDrawStream",
    "_stub_GdiHLSurfSetInformation",
    "_stub_GdiHLSurfGetInformation",
    "_stub_GdiDwmCreatedBitmapRemotingOutput",
    "_stub_GdiDdDDIGetScanLine",
    "_stub_GdiDdDDIReleaseProcessVidPnSourceOwners",
    "_stub_GdiDdDDIGetProcessSchedulingPriorityClass",
    "_stub_GdiDdDDISetProcessSchedulingPriorityClass",
    "NtGdiDdDDIGetContextSchedulingPriority",
    "NtGdiDdDDISetContextSchedulingPriority",
    "NtGdiDdDDIDestroyDCFromMemory",
    "NtGdiDdDDICreateDCFromMemory",
    "NtGdiDdDDIGetDeviceState",
    "_stub_GdiDdDDISetGammaRamp",
    "NtGdiDdDDIWaitForVerticalBlankEvent",
    "_stub_GdiDdDDIDestroyOverlay",
    "_stub_GdiDdDDIFlipOverlay",
    "_stub_GdiDdDDIUpdateOverlay",
    "_stub_GdiDdDDICreateOverlay",
    "_stub_GdiDdDDIGetPresentQueueEvent",
    "_stub_GdiDdDDIGetPresentHistory",
    "_stub_GdiDdDDISetVidPnSourceOwner1",
    "_stub_GdiDdDDISetVidPnSourceOwner",
    "_stub_GdiDdDDIQueryStatistics",
    "NtGdiDdDDIEscape",
    "NtGdiDdDDIGetSharedPrimaryHandle",
    "NtGdiDdDDICloseAdapter",
    "NtGdiDdDDIOpenAdapterFromLuid",
    "NtGdiDdDDIEnumAdapters",
    "NtGdiDdDDIEnumAdapters2",
    "NtGdiDdDDIOpenAdapterFromHdc",
    "NtGdiDdDDIOpenAdapterFromDeviceName",
    "NtGdiDdDDIRender",
    "NtGdiDdDDIPresent",
    "_stub_GdiDdDDIGetMultisampleMethodList",
    "_stub_GdiDdDDISetDisplayMode",
    "NtGdiDdDDIGetDisplayModeList",
    "NtGdiDdDDIUnlock",
    "NtGdiDdDDILock",
    "NtGdiDdDDIQueryAdapterInfo",
    "_stub_GdiDdDDIGetRuntimeData",
    "NtGdiDdDDISignalSynchronizationObject",
    "NtGdiDdDDIWaitForSynchronizationObject",
    "NtGdiDdDDIDestroySynchronizationObject",
    "NtGdiDdDDIOpenSynchronizationObject",
    "NtGdiDdDDICreateSynchronizationObject",
    "NtGdiDdDDIDestroyContext",
    "NtGdiDdDDICreateContext",
    "NtGdiDdDDIDestroyDevice",
    "NtGdiDdDDICreateDevice",
    "_stub_GdiDdDDIQueryAllocationResidency",
    "NtGdiDdDDISetAllocationPriority",
    "NtGdiDdDDIDestroyAllocation",
    "NtGdiDdDDIDestroyAllocation2",
    "NtGdiDdDDIOpenResourceFromNtHandle",
    "NtGdiDdDDIOpenSyncObjectFromNtHandle",
    "_stub_GdiDdDDIOpenSyncObjectFromNtHandle2",
    "NtGdiDdDDIOpenResource",
    "_stub_GdiDdDDIOpenNtHandleFromName",
    "_stub_GdiDdDDIOpenSyncObjectNtHandleFromName",
    "NtGdiDdDDIShareObjects",
    "NtGdiDdDDIQueryResourceInfoFromNtHandle",
    "NtGdiDdDDIQueryResourceInfo",
    "NtGdiDdDDICreateAllocation",
    "_stub_GdiDdDDIOutputDuplReleaseFrame",
    "_stub_GdiDdDDIQueryRemoteVidPnSourceFromGdiDisplayName",
    "_stub_GdiDdDDIOutputDuplPresent",
    "NtGdiDdDDIReleaseKeyedMutex2",
    "NtGdiDdDDIAcquireKeyedMutex2",
    "NtGdiDdDDIOpenKeyedMutex2",
    "NtGdiDdDDICreateKeyedMutex2",
    "_stub_GdiDdDDIOutputDuplGetPointerShapeData",
    "_stub_GdiDdDDIOutputDuplGetMetaData",
    "_stub_GdiDdDDIOutputDuplGetFrameInfo",
    "_stub_GdiDdDDIDestroyOutputDupl",
    "_stub_GdiDdDDICreateOutputDupl",
    "NtGdiDdDDIReclaimAllocations",
    "NtGdiDdDDIOfferAllocations",
    "_stub_GdiDdDDICheckSharedResourceAccess",
    "_stub_GdiDdDDICheckVidPnExclusiveOwnership",
    "_stub_GdiDdDDIGetOverlayState",
    "NtGdiDdDDIConfigureSharedResource",
    "_stub_GdiDdDDIReleaseKeyedMutex",
    "_stub_GdiDdDDIAcquireKeyedMutex",
    "NtGdiDdDDIDestroyKeyedMutex",
    "_stub_GdiDdDDIOpenKeyedMutex",
    "_stub_GdiDdDDICreateKeyedMutex",
    "_stub_GdiDdDDISharedPrimaryUnLockNotification",
    "_stub_GdiDdDDISharedPrimaryLockNotification",
    "_stub_GdiDdDDISetDisplayPrivateDriverFormat",
    "_stub_GdiDdDDICheckExclusiveOwnership",
    "_stub_GdiDdDDICheckMonitorPowerState",
    "_stub_GdiDdDDIWaitForIdle",
    "_stub_GdiDdDDICheckOcclusion",
    "_stub_GdiDdDDIInvalidateActiveVidPn",
    "NtGdiDdDDIPollDisplayChildren",
    "NtGdiDdDDISetQueuedLimit",
    "_stub_GdiDdDDIPinDirectFlipResources",
    "_stub_GdiDdDDIUnpinDirectFlipResources",
    "_stub_GdiDdDDIWaitForVerticalBlankEvent2",
    "_stub_GdiDdDDIGetDWMVerticalBlankEvent",
    "_stub_GdiDdDDISetSyncRefreshCountWaitTarget",
    "_stub_GdiDdDDISetContextInProcessSchedulingPriority",
    "_stub_GdiDdDDIGetContextInProcessSchedulingPriority",
    "_stub_GdiDdDDIGetSharedResourceAdapterLuid",
    "_stub_GdiDdDDISetStereoEnabled",
    "_stub_GdiDdDDIPresentMultiPlaneOverlay",
    "_stub_GdiDdDDICheckMultiPlaneOverlaySupport",
    "NtGdiDdDDIMakeResident",
    "NtGdiDdDDIEvict",
    "_stub_GdiDdDDIUpdateAllocationProperty",
    "NtGdiDdDDIWaitForSynchronizationObjectFromCpu",
    "_stub_GdiDdDDISignalSynchronizationObjectFromCpu",
    "NtGdiDdDDIWaitForSynchronizationObjectFromGpu",
    "NtGdiDdDDISignalSynchronizationObjectFromGpu",
    "NtGdiDdDDISignalSynchronizationObjectFromGpu2",
    "NtGdiDdDDICreatePagingQueue",
    "NtGdiDdDDIDestroyPagingQueue",
    "NtGdiDdDDILock2",
    "NtGdiDdDDIUnlock2",
    "_stub_GdiDdDDIInvalidateCache",
    "_stub_GdiDdDDIGetResourcePresentPrivateDriverData",
    "NtGdiDdDDIMapGpuVirtualAddress",
    "NtGdiDdDDIReserveGpuVirtualAddress",
    "NtGdiDdDDIFreeGpuVirtualAddress",
    "_stub_GdiDdDDIUpdateGpuVirtualAddress",
    "NtGdiDdDDICreateContextVirtual",
    "NtGdiDdDDISubmitCommand",
    "NtGdiDdDDIGetCachedHybridQueryValue",
    "NtGdiDdDDICacheHybridQueryValue",
    "_stub_GdiDdDDINetDispGetNextChunkInfo",
    "NtGdiDdDDINetDispQueryMiracastDisplayDeviceSupport",
    "_stub_GdiDdDDINetDispStartMiracastDisplayDevice",
    "_stub_GdiDdDDINetDispStopMiracastDisplayDevice",
    "_stub_GdiDdDDINetDispQueryMiracastDisplayDeviceStatus",
    "_stub_GdiDdDDINetDispStopSessions",
    "_stub_GdiDdDDIQueryVideoMemoryInfo",
    "_stub_GdiDdDDIChangeVideoMemoryReservation",
    "_stub_GdiDdDDICreateSwapChain",
    "_stub_GdiDdDDIOpenSwapChain",
    "_stub_GdiDdDDIGetSetSwapChainMetadata",
    "_stub_GdiDdDDIAcquireSwapChain",
    "_stub_GdiDdDDIReleaseSwapChain",
    "_stub_GdiDdDDIAbandonSwapChain",
    "_stub_GdiDdDDISetDodIndirectSwapchain",
    "_stub_GdiDdDDICheckMultiPlaneOverlaySupport2",
    "_stub_GdiDdDDIPresentMultiPlaneOverlay2",
    "NtGdiDdDDIReclaimAllocations2",
    "_stub_GdiDdDDISetStablePowerState",
    "_stub_GdiDdDDIQueryClockCalibration",
    "_stub_GdiDdDDIQueryVidPnExclusiveOwnership",
    "_stub_GdiDdDDIAdjustFullscreenGamma",
    "_stub_GdiDdDDISetVidPnSourceHwProtection",
    "NtGdiDdDDIMarkDeviceAsError",
    "NtGdiDdDDIFlushHeapTransitions",
    "NtGdiDdDDISetHwProtectionTeardownRecovery",
    "_stub_GdiDdDDIQueryProcessOfferInfo",
    "_stub_GdiDdDDITrimProcessCommitment",
    "_stub_GdiDdDDICheckMultiPlaneOverlaySupport3",
    "_stub_GdiDdDDIPresentMultiPlaneOverlay3",
    "_stub_GdiDdDDISetFSEBlock",
    "_stub_GdiDdDDIQueryFSEBlock",
    "_stub_GdiMakeObjectUnXferable",
    "_stub_GdiMakeObjectXferable",
    "_stub_GdiDestroyPhysicalMonitor",
    "_stub_GdiGetPhysicalMonitorDescription",
    "_stub_GdiGetPhysicalMonitors",
    "NtGdiGetNumberOfPhysicalMonitors",
    "_stub_GdiDDCCIGetTimingReport",
    "_stub_GdiDDCCIGetCapabilitiesString",
    "_stub_GdiDDCCIGetCapabilitiesStringLength",
    "_stub_GdiDDCCISaveCurrentSettings",
    "_stub_GdiDDCCISetVCPFeature",
    "_stub_GdiDDCCIGetVCPFeature",
    "_stub_GdiDdQueryVisRgnUniqueness",
    "_stub_GdiDdDestroyFullscreenSprite",
    "_stub_GdiDdNotifyFullscreenSpriteUpdate",
    "_stub_GdiDdCreateFullscreenSprite",
    "_stub_GdiGetProcessSessionFonts",
    "_stub_GdiGetPublicFontTableChangeCookie",
    "_stub_UserShowSystemCursor",
    "_stub_UserSetMirrorRendering",
    "_stub_UserMagGetContextInformation",
    "_stub_UserMagSetContextInformation",
    "_stub_UserMagControl",
    "_stub_UserSlicerControl",
    "_stub_UserHwndSetRedirectionInfo",
    "_stub_UserHwndQueryRedirectionInfo",
    "NtCreateCompositionSurfaceHandle",
    "_stub_ValidateCompositionSurfaceHandle",
    "NtBindCompositionSurface",
    "NtUnBindCompositionSurface",
    "_stub_QueryCompositionSurfaceBinding",
    "_stub_NotifyPresentToCompositionSurface",
    "NtQueryCompositionSurfaceStatistics",
    "_stub_OpenCompositionSurfaceSectionInfo",
    "_stub_OpenCompositionSurfaceSwapChainHandleInfo",
    "_stub_QueryCompositionSurfaceRenderingRealization",
    "_stub_OpenCompositionSurfaceDirtyRegion",
    "_stub_QueryCompositionSurfaceHDRMetaData",
    "_stub_SetCompositionSurfaceHDRMetaData",
    "_stub_SetCompositionSurfaceDirectFlipState",
    "_stub_SetCompositionSurfaceStatistics",
    "_stub_SetCompositionSurfaceBufferCompositionModeAndOrientation",
    "_stub_SetCompositionSurfaceIndependentFlipInfo",
    "_stub_DesktopCaptureBits",
    "_stub_DCompositionEnableMMCSS",
    "NtVisualCaptureBits",
    "_stub_DCompositionEnableDDASupport",
    "NtCreateCompositionInputSink",
    "_stub_CreateImplicitCompositionInputSink",
    "_stub_DuplicateCompositionInputSink",
    "_stub_QueryCompositionInputSink",
    "_stub_QueryCompositionInputSinkLuid",
    "_stub_QueryCompositionInputSinkViewId",
    "_stub_UpdateInputSinkTransforms",
    "_stub_CompositionInputThread",
    "_stub_QueryCompositionInputQueueAndTransform",
    "_stub_QueryCompositionInputIsImplicit",
    "NtCompositionSetDropTarget",
    "_stub_TokenManagerOpenSectionAndEvents",
    "_stub_TokenManagerThread",
    "NtTokenManagerCreateCompositionTokenHandle",
    "_stub_TokenManagerGetAnalogExclusiveTokenEvent",
    "_stub_TokenManagerGetAnalogExclusiveSurfaceUpdates",
    "_stub_TokenManagerConfirmOutstandingAnalogToken",
    "_stub_SetCompositionSurfaceAnalogExclusive",
    "_stub_DCompositionBeginFrame",
    "_stub_DCompositionConfirmFrame",
    "_stub_DCompositionRetireFrame",
    "_stub_DCompositionDiscardFrame",
    "_stub_DCompositionGetFrameSurfaceUpdates",
    "_stub_DCompositionGetFrameLegacyTokens",
    "_stub_DCompositionDestroyConnection",
    "_stub_DCompositionGetConnectionBatch",
    "NtDCompositionGetFrameStatistics",
    "NtDCompositionGetDeletedResources",
    "_stub_DCompositionCreateConnection",
    "NtDCompositionDestroyChannel",
    "NtDCompositionReleaseAllResources",
    "_stub_DCompositionSubmitDWMBatch",
    "NtDCompositionProcessChannelBatchBuffer",
    "NtDCompositionCommitChannel",
    "NtDCompositionWaitForChannel",
    "NtDCompositionSetChannelCommitCompletionEvent",
    "NtDCompositionTelemetryTouchInteractionBegin",
    "NtDCompositionTelemetryTouchInteractionUpdate",
    "NtDCompositionTelemetryTouchInteractionEnd",
    "NtDCompositionTelemetrySetApplicationId",
    "NtDCompositionTelemetryAnimationScenarioBegin",
    "NtDCompositionTelemetryAnimationScenarioReference",
    "NtDCompositionTelemetryAnimationScenarioUnreference",
    "NtDCompositionCurrentBatchId",
    "NtDCompositionRemoveCrossDeviceVisualChild",
    "NtDCompositionAddCrossDeviceVisualChild",
    "_stub_DCompositionCreateDwmChannel",
    "NtDCompositionCreateChannel",
    "NtDCompositionSynchronize",
    "_stub_DCompositionReferenceSharedResourceOnDwmChannel",
    "NtDCompositionCreateAndBindSharedSection",
    "_stub_DCompositionSetDebugCounter",
    "_stub_DCompositionGetChannels",
    "_stub_DCompositionConnectPipe",
    "_stub_DCompositionRegisterThumbnailVisual",
    "_stub_DCompositionRegisterVirtualDesktopVisual",
    "_stub_DCompositionDuplicateHandleToProcess",
    "_stub_DCompositionUpdatePointerCapture",
    "NtDCompositionSetChannelCallbackId",
    "_stub_DCompositionDuplicateSwapchainHandleToDwm",
    "NtUserDestroyDCompositionHwndTarget",
    "NtUserCreateDCompositionHwndTarget",
    "_stub_UserWaitForRedirectionStartComplete",
    "_stub_UserSignalRedirectionStartComplete",
    "_stub_UserSetActiveProcessForMonitor",
    "_stub_UserGetDisplayAutoRotationPreferencesByProcessId",
    "_stub_UserGetDisplayAutoRotationPreferences",
    "_stub_UserSetDisplayAutoRotationPreferences",
    "_stub_UserSetAutoRotation",
    "_stub_UserGetAutoRotationState",
    "_stub_UserAutoRotateScreen",
    "_stub_UserAcquireIAMKey",
    "_stub_UserSetActivationFilter",
    "_stub_UserSetFallbackForeground",
    "_stub_UserSetBrokeredForeground",
    "_stub_UserDisableImmersiveOwner",
    "_stub_UserClearForeground",
    "_stub_UserEnableIAMAccess",
    "NtUserGetProcessUIContextInformation",
    "_stub_UserSetProcessRestrictionExemption",
    "_stub_UserSetWindowArrangement",
    "_stub_UserSetWindowShowState",
    "_stub_UserUpdateWindowTrackingInfo",
    "NtUserEnableMouseInPointer",
    "_stub_UserIsMouseInPointerEnabled",
    "_stub_UserPromoteMouseInPointer",
    "NtUserAutoPromoteMouseInPointer",
    "_stub_UserEnableMouseInputForCursorSuppression",
    "_stub_UserIsMouseInputEnabled",
    "_stub_UserInternalClipCursor",
    "_stub_UserCheckProcessForClipboardAccess",
    "_stub_UserGetClipboardAccessToken",
    "NtUserGetQueueStatusReadonly",
    "_stub_UserCompositionInputSinkLuidFromPoint",
    "_stub_UserUpdateWindowInputSinkHints",
    "NtUserTransformPoint",
    "NtUserTransformRect",
    "_stub_UserGetHimetricScaleFactorFromPixelLocation",
    "NtUserGetDpiForMonitor",
    "NtUserReportInertia",
    "NtUserLinkDpiCursor",
    "NtUserGetCursorDims",
    "_stub_UserInitializeInputDeviceInjection",
    "_stub_UserInitializePointerDeviceInjection",
    "_stub_UserRemoveInjectionDevice",
    "_stub_UserSetFeatureReportResponse",
    "_stub_UserInjectDeviceInput",
    "_stub_UserInjectMouseInput",
    "_stub_UserInjectKeyboardInput",
    "_stub_UserInjectPointerInput",
    "_stub_RIMAddInputObserver",
    "_stub_RIMRemoveInputObserver",
    "_stub_RIMUpdateInputObserverRegistration",
    "_stub_RIMObserveNextInput",
    "_stub_RIMGetDevicePreparsedDataLockfree",
    "_stub_UserSetCoreWindow",
    "_stub_UserSetCoreWindowPartner",
    "_stub_UserNavigateFocus",
    "_stub_HWCursorUpdatePointer",
    "_stub_UserAcquireInteractiveControlBackgroundAccess",
    "_stub_UserGetInteractiveControlInfo",
    "_stub_UserGetInteractiveControlDeviceInfo",
    "_stub_UserSendInteractiveControlHapticsReport",
    "_stub_UserSetInteractiveControlFocus",
    "_stub_UserInteractiveControlQueryUsage",
    "_stub_UserSetInteractiveCtrlRotationAngle",
    "NtUserSetProcessInteractionFlags"
};

//////////////////////////////////////////////////////////////////////////
// Windows 10 RS2 _W32pServiceTable
//////////////////////////////////////////////////////////////////////////
static const char* W32pServiceTable_Win10Rs2_x86[] = {
    "NtUserGetOwnerTransformedMonitorRect",
    "NtUserYieldTask",
    "NtUserSetSensorPresence",
    "NtGdiWidenPath",
    "NtGdiUpdateColors",
    "NtGdiUnrealizeObject",
    "NtGdiUnmapMemFont",
    "NtGdiUnloadPrinterDriver",
    "NtGdiTransparentBlt",
    "NtGdiTransformPoints",
    "NtGdiScaleRgn",
    "NtGdiScaleValues",
    "NtGdiGetDCDpiScaleValue",
    "NtGdiGetBitmapDpiScaleValue",
    "NtGdiSwapBuffers",
    "NtGdiStrokePath",
    "NtGdiStrokeAndFillPath",
    "NtGdiStretchDIBitsInternal",
    "NtGdiStretchBlt",
    "NtGdiStartPage",
    "NtGdiStartDoc",
    "NtGdiSetSizeDevice",
    "NtGdiSetVirtualResolution",
    "NtGdiSetTextJustification",
    "NtGdiSetSystemPaletteUse",
    "NtGdiSetRectRgn",
    "NtGdiSetPixelFormat",
    "NtGdiSetPixel",
    "NtGdiSetOPMSigningKeyAndSequenceNumbers",
    "NtGdiSetLayout",
    "NtGdiMirrorWindowOrg",
    "NtGdiGetDeviceWidth",
    "NtGdiSetMiterLimit",
    "NtGdiSetMetaRgn",
    "NtGdiSetMagicColors",
    "NtGdiSetLinkedUFIs",
    "NtGdiSetIcmMode",
    "NtGdiSetFontXform",
    "NtGdiSetFontEnumeration",
    "NtGdiSetDIBitsToDeviceInternal",
    "NtGdiSetDeviceGammaRamp",
    "NtGdiGetGammaRampCapability",
    "NtGdiSetPrivateDeviceGammaRamp",
    "NtGdiGetAppliedDeviceGammaRamp",
    "NtGdiSetColorSpace",
    "NtGdiSetColorAdjustment",
    "NtGdiSetBrushOrg",
    "NtGdiSetBrushAttributes",
    "NtGdiSetBoundsRect",
    "NtGdiSetBitmapDimension",
    "NtGdiSetBitmapBits",
    "NtGdiSetBitmapAttributes",
    "NtGdiSelectPen",
    "NtGdiSelectFont",
    "NtGdiSelectClipPath",
    "NtGdiSelectBrush",
    "NtGdiSelectBitmap",
    "NtGdiScaleWindowExtEx",
    "NtGdiScaleViewportExtEx",
    "NtGdiSaveDC",
    "NtGdiRoundRect",
    "NtGdiRestoreDC",
    "NtGdiResizePalette",
    "NtGdiResetDC",
    "NtGdiRemoveFontMemResourceEx",
    "NtGdiRemoveFontResourceW",
    "NtGdiRectVisible",
    "NtGdiRectInRegion",
    "NtGdiRectangle",
    "NtGdiQueryFontAssocInfo",
    "NtGdiQueryFonts",
    "NtGdiPtVisible",
    "NtGdiPtInRegion",
    "NtGdiPolyTextOutW",
    "NtGdiPolyPolyDraw",
    "NtGdiPolyDraw",
    "NtGdiPlgBlt",
    "NtGdiPathToRegion",
    "NtGdiPolyPatBlt",
    "NtGdiPatBlt",
    "NtGdiOpenDCW",
    "NtGdiOffsetRgn",
    "NtGdiOffsetClipRgn",
    "NtGdiMoveTo",
    "NtGdiMonoBitmap",
    "NtGdiModifyWorldTransform",
    "NtGdiMaskBlt",
    "NtGdiMakeInfoDC",
    "NtGdiMakeFontDir",
    "NtGdiLineTo",
    "NtGdiInvertRgn",
    "NtGdiIntersectClipRect",
    "NtGdiInitSpool",
    "NtGdiInit",
    "NtGdiIcmBrushInfo",
    "NtGdiHfontCreate",
    "NtGdiGradientFill",
    "NtGdiGetWidthTable",
    "NtGdiGetFontUnicodeRanges",
    "NtGdiAddEmbFontToDC",
    "NtGdiChangeGhostFont",
    "NtGdiGetEmbedFonts",
    "NtGdiGetUFIPathname",
    "NtGdiGetEmbUFI",
    "NtGdiGetUFI",
    "NtGdiGetTransform",
    "NtGdiGetTextMetricsW",
    "NtGdiGetTextFaceW",
    "NtGdiGetTextExtentExW",
    "NtGdiGetTextExtent",
    "NtGdiGetTextCharsetInfo",
    "NtGdiGetSystemPaletteUse",
    "NtGdiGetSuggestedOPMProtectedOutputArraySize",
    "NtGdiGetStringBitmapW",
    "NtGdiGetStats",
    "NtGdiGetSpoolMessage",
    "NtGdiGetServerMetaFileBits",
    "NtGdiGetRgnBox",
    "NtGdiGetRegionData",
    "NtGdiGetRealizationInfo",
    "NtGdiGetRasterizerCaps",
    "NtGdiGetRandomRgn",
    "NtGdiGetPixel",
    "NtGdiGetPath",
    "NtGdiGetOutlineTextMetricsInternalW",
    "NtGdiGetOPMRandomNumber",
    "NtGdiGetObjectBitmapHandle",
    "NtGdiGetNearestPaletteIndex",
    "NtGdiGetNearestColor",
    "NtGdiGetMonitorID",
    "NtGdiGetMiterLimit",
    "NtGdiGetLinkedUFIs",
    "NtGdiGetKerningPairs",
    "NtGdiGetOPMInformation",
    "NtGdiGetGlyphOutline",
    "NtGdiGetGlyphIndicesWInternal",
    "NtGdiGetGlyphIndicesW",
    "NtGdiGetFontResourceInfoInternalW",
    "NtGdiGetFontFileInfo",
    "NtGdiGetFontFileData",
    "NtGdiGetFontData",
    "NtGdiGetEudcTimeStampEx",
    "NtGdiGetETM",
    "NtGdiGetEntry",
    "NtGdiGetDIBitsInternal",
    "NtGdiGetDeviceCapsAll",
    "NtGdiGetDeviceGammaRamp",
    "NtGdiGetDeviceCaps",
    "NtGdiGetDCPoint",
    "NtGdiGetDCObject",
    "NtGdiGetDCforBitmap",
    "NtGdiGetDCDword",
    "NtGdiGetCurrentDpiInfo",
    "NtGdiGetCOPPCompatibleOPMInformation",
    "NtGdiGetColorSpaceforBitmap",
    "NtGdiGetColorAdjustment",
    "NtGdiGetCharWidthInfo",
    "NtGdiGetCharWidthW",
    "NtGdiGetCharSet",
    "NtGdiGetCharacterPlacementW",
    "NtGdiGetCharABCWidthsW",
    "NtGdiGetCertificateSize",
    "NtGdiGetCertificate",
    "NtGdiGetCertificateSizeByHandle",
    "NtGdiGetCertificateByHandle",
    "NtGdiGetBoundsRect",
    "NtGdiGetBitmapDimension",
    "NtGdiGetBitmapBits",
    "NtGdiGetAppClipBox",
    "NtGdiGetAndSetDCDword",
    "NtGdiFullscreenControl",
    "NtGdiFrameRgn",
    "NtGdiForceUFIMapping",
    "NtGdiFlush",
    "NtGdiFlattenPath",
    "NtGdiFillRgn",
    "NtGdiFillPath",
    "NtGdiExtTextOutW",
    "NtGdiExtSelectClipRgn",
    "NtGdiExtGetObjectW",
    "NtGdiExtFloodFill",
    "NtGdiExtEscape",
    "NtGdiExtCreateRegion",
    "NtGdiExtCreatePen",
    "NtGdiExcludeClipRect",
    "NtGdiEudcLoadUnloadLink",
    "NtGdiEqualRgn",
    "NtGdiEnumObjects",
    "NtGdiEnumFonts",
    "NtGdiEndPath",
    "NtGdiEndPage",
    "NtGdiEndGdiRendering",
    "NtGdiEndDoc",
    "NtGdiEnableEudc",
    "NtGdiEllipse",
    "NtGdiDrawEscape",
    "NtGdiDoPalette",
    "NtGdiDoBanding",
    "NtGdiGetPerBandInfo",
    "NtGdiDestroyOPMProtectedOutput",
    "NtGdiDescribePixelFormat",
    "NtGdiDeleteObjectApp",
    "NtGdiDeleteColorTransform",
    "NtGdiDeleteColorSpace",
    "NtGdiDeleteClientObj",
    "NtGdiCreateSolidBrush",
    "NtGdiCreateServerMetaFile",
    "NtGdiCreateRoundRectRgn",
    "NtGdiCreateRectRgn",
    "NtGdiCreatePen",
    "NtGdiCreatePatternBrushInternal",
    "NtGdiCreatePaletteInternal",
    "NtGdiCreateOPMProtectedOutputs",
    "NtGdiCreateOPMProtectedOutput",
    "NtGdiCreateMetafileDC",
    "NtGdiCreateHatchBrushInternal",
    "NtGdiCreateHalftonePalette",
    "NtGdiCreateEllipticRgn",
    "NtGdiCreateSessionMappedDIBSection",
    "NtGdiCreateDIBSection",
    "NtGdiCreateDIBitmapInternal",
    "NtGdiCreateDIBBrush",
    "NtGdiCreateCompatibleDC",
    "NtGdiCreateCompatibleBitmap",
    "NtGdiCreateColorTransform",
    "NtGdiCreateColorSpace",
    "NtGdiCreateClientObj",
    "NtGdiCreateBitmapFromDxSurface2",
    "NtGdiCreateBitmapFromDxSurface",
    "NtGdiCreateBitmap",
    "NtGdiConvertMetafileRect",
    "NtGdiConfigureOPMProtectedOutput",
    "NtGdiComputeXformCoefficients",
    "NtGdiCombineTransform",
    "NtGdiCombineRgn",
    "NtGdiColorCorrectPalette",
    "NtGdiClearBrushAttributes",
    "NtGdiClearBitmapAttributes",
    "NtGdiCloseFigure",
    "NtGdiCheckBitmapBits",
    "NtGdiCancelDC",
    "NtGdiBitBlt",
    "NtGdiBeginPath",
    "NtGdiBeginGdiRendering",
    "NtGdiArcInternal",
    "NtGdiFontIsLinked",
    "NtGdiAnyLinkedFonts",
    "NtGdiAngleArc",
    "NtGdiAlphaBlend",
    "NtGdiAddRemoteMMInstanceToDC",
    "NtGdiRemoveMergeFont",
    "NtGdiAddFontMemResourceEx",
    "NtGdiAddRemoteFontToDC",
    "NtGdiAddFontResourceW",
    "NtGdiAbortPath",
    "NtGdiAbortDoc",
    "NtUserDefSetText",
    "NtUserDeferWindowPosAndBand",
    "NtUserDdeInitialize",
    "NtUserCanBrokerForceForeground",
    "NtUserCreateWindowStation",
    "NtUserCreateWindowEx",
    "NtUserCreateLocalMemHandle",
    "NtUserCreateInputContext",
    "NtUserCreateDesktopEx",
    "NtUserCreateCaret",
    "NtUserCreateAcceleratorTable",
    "NtUserCountClipboardFormats",
    "NtUserCopyAcceleratorTable",
    "NtUserConvertMemHandle",
    "NtUserConsoleControl",
    "NtUserCloseWindowStation",
    "NtUserCloseDesktop",
    "NtUserCloseClipboard",
    "NtUserClipCursor",
    "NtUserChildWindowFromPointEx",
    "NtUserCheckMenuItem",
    "NtUserCheckWindowThreadDesktop",
    "NtUserDwmValidateWindow",
    "NtUserCheckAccessForIntegrityLevel",
    "NtUserDisplayConfigSetDeviceInfo",
    "NtUserDisplayConfigGetDeviceInfo",
    "NtUserQueryDisplayConfig",
    "NtUserSetDisplayConfig",
    "NtUserFunctionalizeDisplayConfig",
    "NtUserGetDisplayConfigBufferSizes",
    "NtUserChangeDisplaySettings",
    "NtUserChangeClipboardChain",
    "NtUserCallTwoParam",
    "NtUserCallOneParam",
    "NtUserCallNoParam",
    "NtUserCallNextHookEx",
    "NtUserCallMsgFilter",
    "NtUserCallHwndParamLock",
    "NtUserCallHwndParam",
    "NtUserCallHwndOpt",
    "NtUserCallHwndLock",
    "NtUserCallHwnd",
    "NtUserBroadcastThemeChangeEvent",
    "NtUserBuildPropList",
    "NtUserBuildNameList",
    "NtUserBuildHwndList",
    "NtUserBuildHimcList",
    "NtUserBlockInput",
    "NtUserBitBltSysBmp",
    "NtUserBeginPaint",
    "NtUserAttachThreadInput",
    "NtUserAssociateInputContext",
    "NtUserAlterWindowStyle",
    "NtUserAddClipboardFormatListener",
    "NtUserActivateKeyboardLayout",
    "NtUserDelegateCapturePointers",
    "NtUserDelegateInput",
    "NtUserDispatchMessage",
    "NtUserDisableProcessWindowFiltering",
    "NtUserDisableThreadIme",
    "NtUserDestroyWindow",
    "NtUserDestroyMenu",
    "NtUserDestroyInputContext",
    "NtUserDestroyCursor",
    "NtUserDestroyAcceleratorTable",
    "NtUserDeleteMenu",
    "NtUserDoSoundDisconnect",
    "NtUserDoSoundConnect",
    "NtUserGhostWindowFromHungWindow",
    "NtUserGetWOWClass",
    "NtUserGetWindowPlacement",
    "NtUserGetWindowDisplayAffinity",
    "NtUserGetWindowDC",
    "NtUserGetWindowCompositionAttribute",
    "NtUserGetWindowCompositionInfo",
    "NtUserGetWindowBand",
    "NtUserGetUpdateRgn",
    "NtUserGetUpdateRect",
    "NtUserGetUpdatedClipboardFormats",
    "NtUserGetTopLevelWindow",
    "NtUserGetTitleBarInfo",
    "NtUserGetThreadState",
    "NtUserGetThreadDesktop",
    "NtUserGetSystemMenu",
    "NtUserGetScrollBarInfo",
    "NtUserGetRegisteredRawInputDevices",
    "NtUserGetRawInputDeviceList",
    "NtUserGetRawInputDeviceInfo",
    "NtUserGetRawInputData",
    "NtUserGetRawInputBuffer",
    "NtUserGetProcessDpiAwarenessContext",
    "NtUserGetProcessWindowStation",
    "NtUserGetPriorityClipboardFormat",
    "NtUserGetOpenClipboardWindow",
    "NtUserGetObjectInformation",
    "NtUserGetMouseMovePointsEx",
    "NtUserGetMessage",
    "NtUserGetMenuItemRect",
    "NtUserGetMenuIndex",
    "NtUserGetMenuBarInfo",
    "NtUserGetListBoxInfo",
    "NtUserGetKeyState",
    "NtUserGetKeyNameText",
    "NtUserGetKeyboardState",
    "NtUserGetKeyboardLayoutName",
    "NtUserGetKeyboardLayoutList",
    "NtUserGetInternalWindowPos",
    "NtUserGetInputLocaleInfo",
    "NtUserGetImeInfoEx",
    "NtUserGetImeHotKey",
    "NtUserGetIconSize",
    "NtUserGetIconInfo",
    "NtUserGetGUIThreadInfo",
    "NtUserGetGuiResources",
    "NtUserGetForegroundWindow",
    "NtUserGetDoubleClickTime",
    "NtUserGetDesktopID",
    "NtUserGetDCEx",
    "NtUserGetDC",
    "NtUserGetCursorInfo",
    "NtUserGetCursorFrameInfo",
    "NtUserGetCurrentInputMessageSource",
    "NtUserGetCIMSSM",
    "NtUserGetCPD",
    "NtUserGetControlColor",
    "NtUserGetControlBrush",
    "NtUserGetComboBoxInfo",
    "NtUserGetClipCursor",
    "NtUserGetClipboardViewer",
    "NtUserGetClipboardSequenceNumber",
    "NtUserGetClipboardOwner",
    "NtUserGetClipboardFormatName",
    "NtUserGetClipboardData",
    "NtUserGetClassName",
    "NtUserGetClassInfoEx",
    "NtUserGetCaretPos",
    "NtUserGetCaretBlinkTime",
    "NtUserGetAtomName",
    "NtUserGetAsyncKeyState",
    "NtUserGetAppImeLevel",
    "NtUserGetAncestor",
    "NtUserGetAltTabInfo",
    "NtUserFrostCrashedWindow",
    "NtUserFlashWindowEx",
    "NtUserFindWindowEx",
    "NtUserFindExistingCursorIcon",
    "NtUserFillWindow",
    "NtUserExcludeUpdateRgn",
    "NtUserEvent",
    "NtUserEnumDisplaySettings",
    "NtUserEnumDisplayMonitors",
    "NtUserEnumDisplayDevices",
    "NtUserEndPaint",
    "NtUserEndMenu",
    "NtUserEndDeferWindowPosEx",
    "NtUserEnableScrollBar",
    "NtUserEnableMenuItem",
    "NtUserEmptyClipboard",
    "NtUserDrawMenuBarTemp",
    "NtUserDrawIconEx",
    "NtUserDrawCaptionTemp",
    "NtUserDrawCaption",
    "NtUserDrawAnimatedRects",
    "NtUserDragObject",
    "NtUserDragDetect",
    "NtUserHandleDelegatedInput",
    "NtUserInheritWindowMonitor",
    "NtUserRealChildWindowFromPoint",
    "NtUserQueryWindow",
    "NtUserQuerySendMessage",
    "NtUserQueryInputContext",
    "NtUserQueryInformationThread",
    "NtUserQueryBSDRWindow",
    "NtUserPerMonitorDPIPhysicalToLogicalPoint",
    "NtUserProcessConnect",
    "NtUserPrintWindow",
    "NtUserPostThreadMessage",
    "NtUserPostMessage",
    "NtUserPhysicalToLogicalPoint",
    "NtUserPeekMessage",
    "NtUserPaintMonitor",
    "NtUserPaintDesktop",
    "NtUserOpenWindowStation",
    "NtUserOpenThreadDesktop",
    "NtUserOpenInputDesktop",
    "NtUserOpenDesktop",
    "NtUserOpenClipboard",
    "NtUserNotifyWinEvent",
    "NtUserNotifyProcessCreate",
    "NtUserNotifyIMEStatus",
    "NtUserMoveWindow",
    "NtUserModifyUserStartupInfoFlags",
    "NtUserMNDragOver",
    "NtUserMNDragLeave",
    "NtUserMinMaximize",
    "NtUserMessageCall",
    "NtUserMenuItemFromPoint",
    "NtUserMapVirtualKeyEx",
    "NtUserLayoutCompleted",
    "NtUserLogicalToPerMonitorDPIPhysicalPoint",
    "NtUserLogicalToPhysicalPoint",
    "NtUserLockCursor",
    "NtUserLockWorkStation",
    "NtUserLockWindowUpdate",
    "NtUserLockWindowStation",
    "NtUserLoadKeyboardLayoutEx",
    "NtUserKillTimer",
    "NtUserIsTopLevelWindow",
    "NtUserIsClipboardFormatAvailable",
    "NtUserInvalidateRgn",
    "NtUserInvalidateRect",
    "NtUserInternalGetWindowIcon",
    "NtUserInternalGetWindowText",
    "NtUserInitTask",
    "NtUserInitializeClientPfnArrays",
    "NtUserInitialize",
    "NtUserImpersonateDdeClientWindow",
    "NtUserHungWindowFromGhostWindow",
    "NtUserHiliteMenuItem",
    "NtUserHideCaret",
    "NtUserHardErrorControl",
    "NtUserRealInternalGetMessage",
    "NtUserRealWaitMessageEx",
    "NtUserReleaseDwmHitTestWaiters",
    "NtUserTranslateMessage",
    "NtUserTranslateAccelerator",
    "NtUserPaintMenuBar",
    "NtUserCalcMenuBar",
    "NtUserCalculatePopupWindowPosition",
    "NtUserTrackPopupMenuEx",
    "NtUserTrackMouseEvent",
    "NtUserToUnicodeEx",
    "NtUserThunkedMenuItemInfo",
    "NtUserThunkedMenuInfo",
    "NtUserTestForInteractiveUser",
    "NtUserSendEventMessage",
    "NtUserSystemParametersInfo",
    "NtUserSystemParametersInfoForDpi",
    "NtUserSwitchDesktop",
    "NtUserSoundSentry",
    "NtUserShutdownReasonDestroy",
    "NtUserShutdownBlockReasonQuery",
    "NtUserShutdownBlockReasonCreate",
    "NtUserShowWindowAsync",
    "NtUserShowWindow",
    "NtUserShowScrollBar",
    "NtUserShowCaret",
    "NtUserSetWinEventHook",
    "NtUserSetWindowWord",
    "NtUserSetWindowStationUser",
    "NtUserSetWindowsHookEx",
    "NtUserSetWindowsHookAW",
    "NtUserSetWindowRgnEx",
    "NtUserGetWindowRgnEx",
    "NtUserSetWindowRgn",
    "NtUserSetWindowPos",
    "NtUserSetWindowPlacement",
    "NtUserSetWindowLong",
    "NtUserSetWindowFNID",
    "NtUserSetWindowDisplayAffinity",
    "NtUserSetWindowCompositionTransition",
    "NtUserUpdateDefaultDesktopThumbnail",
    "NtUserSetWindowCompositionAttribute",
    "NtUserSetWindowBand",
    "NtUserSetProcessUIAccessZorder",
    "NtUserSetProcessDpiAwarenessContext",
    "NtUserEnableChildWindowDpiMessage",
    "NtUserIsChildWindowDpiMessageEnabled",
    "NtUserEnableNonClientDpiScaling",
    "NtUserIsNonClientDpiScalingEnabled",
    "NtUserSetDialogControlDpiChangeBehavior",
    "NtUserIsWindowBroadcastingDpiToChildren",
    "NtUserEnableWindowGDIScaledDpiMessage",
    "NtUserIsWindowGDIScaledDpiMessageEnabled",
    "NtUserSetTimer",
    "NtUserSetThreadState",
    "NtUserSetThreadLayoutHandles",
    "NtUserSetThreadDesktop",
    "NtUserSetThreadInputBlocked",
    "NtUserSetSystemTimer",
    "NtUserSetSystemMenu",
    "NtUserSetSystemCursor",
    "NtUserSetSysColors",
    "NtUserSetShellWindowEx",
    "NtUserSetScrollInfo",
    "NtUserSetProp",
    "NtUserGetProp",
    "NtUserSetProcessWindowStation",
    "NtUserSetParent",
    "NtUserSetObjectInformation",
    "NtUserSetMenuFlagRtoL",
    "NtUserSetMenuDefaultItem",
    "NtUserSetMenuContextHelpId",
    "NtUserSetMenu",
    "NtUserSetKeyboardState",
    "NtUserSetInternalWindowPos",
    "NtUserSetInformationThread",
    "NtUserSetImeOwnerWindow",
    "NtUserSetImeInfoEx",
    "NtUserSetImeHotKey",
    "NtUserSetFocus",
    "NtUserSetCursorIconData",
    "NtUserSetCursorContents",
    "NtUserSetCursor",
    "NtUserSetClipboardViewer",
    "NtUserSetClipboardData",
    "NtUserSetClassWord",
    "NtUserSetClassLong",
    "NtUserSetChildWindowNoActivate",
    "NtUserSetCapture",
    "NtUserSetAppImeLevel",
    "NtUserSetActiveWindow",
    "NtUserSendInput",
    "NtUserSelectPalette",
    "NtUserScrollWindowEx",
    "NtUserScrollDC",
    "NtUserSBGetParms",
    "NtUserResolveDesktopForWOW",
    "NtUserRemoveProp",
    "NtUserRemoveMenu",
    "NtUserRemoveClipboardFormatListener",
    "NtUserRegisterWindowMessage",
    "NtUserRegisterTasklist",
    "NtUserRegisterServicesProcess",
    "NtUserRegisterRawInputDevices",
    "NtUserRegisterHotKey",
    "NtUserRegisterDManipHook",
    "NtUserGetDManipHookInitFunction",
    "NtUserRegisterManipulationThread",
    "NtUserSetManipulationInputTarget",
    "NtUserRegisterUserApiHook",
    "NtUserRegisterErrorReportingDialog",
    "NtUserRegisterClassExWOW",
    "NtUserRegisterBSDRWindow",
    "NtUserRedrawWindow",
    "NtUserUndelegateInput",
    "NtUserGetWindowMinimizeRect",
    "NtUserDwmGetRemoteSessionOcclusionEvent",
    "NtUserDwmGetRemoteSessionOcclusionState",
    "NtUserDwmKernelShutdown",
    "NtUserDwmKernelStartup",
    "NtUserCheckProcessSession",
    "NtUserUnregisterSessionPort",
    "NtUserRegisterSessionPort",
    "NtUserCtxDisplayIOCtl",
    "NtUserRemoteStopScreenUpdates",
    "NtUserRemoteRedrawScreen",
    "NtUserRemoteRedrawRectangle",
    "NtUserRemoteConnect",
    "NtUserWaitAvailableMessageEx",
    "NtUserWindowFromPoint",
    "NtUserWindowFromPhysicalPoint",
    "NtUserWaitMessage",
    "NtUserWaitForMsgAndEvent",
    "NtUserWaitForInputIdle",
    "NtUserVkKeyScanEx",
    "NtUserValidateTimerCallback",
    "NtUserValidateRect",
    "NtUserValidateHandleSecure",
    "NtUserUserHandleGrantAccess",
    "NtUserUpdatePerUserSystemParameters",
    "NtUserSetLayeredWindowAttributes",
    "NtUserGetLayeredWindowAttributes",
    "NtUserUpdateLayeredWindow",
    "NtUserUpdateInstance",
    "NtUserUpdateInputContext",
    "NtUserUnregisterHotKey",
    "NtUserUnregisterUserApiHook",
    "NtUserUnregisterClass",
    "NtUserUnlockWindowStation",
    "NtUserUnloadKeyboardLayout",
    "NtUserUnhookWinEvent",
    "NtUserUnhookWindowsHookEx",
    "NtUserGetTouchInputInfo",
    "NtUserIsTouchWindow",
    "NtUserModifyWindowTouchCapability",
    "NtGdiEngStretchBltROP",
    "NtGdiEngTextOut",
    "NtGdiEngTransparentBlt",
    "NtGdiEngGradientFill",
    "NtGdiEngAlphaBlend",
    "NtGdiEngLineTo",
    "NtGdiEngPaint",
    "NtGdiEngStrokeAndFillPath",
    "NtGdiEngFillPath",
    "NtGdiEngStrokePath",
    "NtGdiEngMarkBandingSurface",
    "NtGdiEngPlgBlt",
    "NtGdiEngStretchBlt",
    "NtGdiEngBitBlt",
    "NtGdiEngLockSurface",
    "NtGdiEngUnlockSurface",
    "NtGdiEngEraseSurface",
    "NtGdiEngDeleteSurface",
    "NtGdiEngDeletePalette",
    "NtGdiEngCopyBits",
    "NtGdiEngComputeGlyphSet",
    "NtGdiEngCreatePalette",
    "NtGdiEngCreateDeviceBitmap",
    "NtGdiEngCreateDeviceSurface",
    "NtGdiEngCreateBitmap",
    "NtGdiEngAssociateSurface",
    "NtUserSetWindowFeedbackSetting",
    "NtUserRegisterEdgy",
    "NtUserRegisterShellPTPListener",
    "NtUserGetWindowFeedbackSetting",
    "NtUserHidePointerContactVisualization",
    "NtUserGetTouchValidationStatus",
    "NtUserInitializeTouchInjection",
    "NtUserInjectTouchInput",
    "NtUserRegisterTouchHitTestingWindow",
    "NtUserSetDisplayMapping",
    "NtUserSetCalibrationData",
    "NtUserGetPhysicalDeviceRect",
    "NtUserRegisterTouchPadCapable",
    "NtUserGetRawPointerDeviceData",
    "NtUserGetPointerDeviceCursors",
    "NtUserGetPointerDeviceRects",
    "NtUserRegisterPointerDeviceNotifications",
    "NtUserGetPointerDeviceProperties",
    "NtUserGetPointerDevice",
    "NtUserGetPointerDevices",
    "NtUserEnableTouchPad",
    "NtUserGetPrecisionTouchPadConfiguration",
    "NtUserSetPrecisionTouchPadConfiguration",
    "NtUserPromotePointer",
    "NtUserDiscardPointerFrameMessages",
    "NtUserRegisterPointerInputTarget",
    "NtUserGetPointerFrameArrivalTimes",
    "NtUserGetPointerInputTransform",
    "NtUserGetPointerInfoList",
    "NtUserGetPointerCursorId",
    "NtUserGetPointerType",
    "NtUserGetGestureConfig",
    "NtUserSetGestureConfig",
    "NtUserGetGestureExtArgs",
    "NtUserGetGestureInfo",
    "NtUserInjectGesture",
    "NtUserChangeWindowMessageFilterEx",
    "NtGdiXLATEOBJ_hGetColorTransform",
    "NtGdiXLATEOBJ_iXlate",
    "NtGdiXLATEOBJ_cGetPalette",
    "NtGdiEngDeleteClip",
    "NtGdiEngCreateClip",
    "NtGdiEngDeletePath",
    "NtGdiCLIPOBJ_ppoGetPath",
    "NtGdiCLIPOBJ_cEnumStart",
    "NtGdiCLIPOBJ_bEnum",
    "NtGdiBRUSHOBJ_hGetColorTransform",
    "NtGdiBRUSHOBJ_pvGetRbrush",
    "NtGdiBRUSHOBJ_pvAllocRbrush",
    "NtGdiBRUSHOBJ_ulGetBrushColor",
    "NtGdiXFORMOBJ_iGetXform",
    "NtGdiXFORMOBJ_bApplyXform",
    "NtGdiFONTOBJ_pQueryGlyphAttrs",
    "NtGdiFONTOBJ_pfdg",
    "NtGdiFONTOBJ_pifi",
    "NtGdiFONTOBJ_cGetGlyphs",
    "NtGdiFONTOBJ_pxoGetXform",
    "NtGdiFONTOBJ_vGetInfo",
    "NtGdiFONTOBJ_cGetAllGlyphHandles",
    "NtGdiFONTOBJ_pvTrueTypeFontFile",
    "NtGdiSTROBJ_dwGetCodePage",
    "NtGdiSTROBJ_vEnumStart",
    "NtGdiSTROBJ_bGetAdvanceWidths",
    "NtGdiSTROBJ_bEnumPositionsOnly",
    "NtGdiSTROBJ_bEnum",
    "NtGdiPATHOBJ_bEnumClipLines",
    "NtGdiPATHOBJ_vEnumStartClipLines",
    "NtGdiPATHOBJ_vEnumStart",
    "NtGdiPATHOBJ_bEnum",
    "NtGdiPATHOBJ_vGetBounds",
    "NtGdiEngCheckAbort",
    "NtGdiGetDhpdev",
    "NtGdiHT_Get8BPPMaskPalette",
    "NtGdiHT_Get8BPPFormatPalette",
    "NtGdiUpdateTransform",
    "NtGdiUMPDEngFreeUserMem",
    "NtGdiBRUSHOBJ_DeleteRbrush",
    "NtGdiSetPUMPDOBJ",
    "NtGdiSetUMPDSandboxState",
    "NtGdiDrawStream",
    "NtGdiHLSurfSetInformation",
    "NtGdiHLSurfGetInformation",
    "NtGdiDwmCreatedBitmapRemotingOutput",
    "NtGdiDdDDIGetScanLine",
    "NtGdiDdDDIReleaseProcessVidPnSourceOwners",
    "NtGdiDdDDIGetProcessSchedulingPriorityClass",
    "NtGdiDdDDISetProcessSchedulingPriorityClass",
    "NtGdiDdDDIGetContextSchedulingPriority",
    "NtGdiDdDDISetContextSchedulingPriority",
    "NtGdiDdDDIDestroyDCFromMemory",
    "NtGdiDdDDICreateDCFromMemory",
    "NtGdiDdDDIGetDeviceState",
    "NtGdiDdDDISetGammaRamp",
    "NtGdiDdDDIWaitForVerticalBlankEvent",
    "NtGdiDdDDIDestroyOverlay",
    "NtGdiDdDDIFlipOverlay",
    "NtGdiDdDDIUpdateOverlay",
    "NtGdiDdDDICreateOverlay",
    "NtGdiDdDDIGetPresentQueueEvent",
    "NtGdiDdDDIGetPresentHistory",
    "NtGdiDdDDISetVidPnSourceOwner1",
    "NtGdiDdDDISetVidPnSourceOwner",
    "NtGdiDdDDIQueryStatistics",
    "NtGdiDdDDIEscape",
    "NtGdiDdDDIGetSharedPrimaryHandle",
    "NtGdiDdDDICloseAdapter",
    "NtGdiDdDDIOpenAdapterFromLuid",
    "NtGdiDdDDIEnumAdapters",
    "NtGdiDdDDIEnumAdapters2",
    "NtGdiDdDDIOpenAdapterFromHdc",
    "NtGdiDdDDIOpenAdapterFromDeviceName",
    "NtGdiDdDDIRender",
    "NtGdiDdDDIPresent",
    "NtGdiDdDDIGetMultisampleMethodList",
    "NtGdiDdDDISetDisplayMode",
    "NtGdiDdDDIGetDisplayModeList",
    "NtGdiDdDDIUnlock",
    "NtGdiDdDDILock",
    "NtGdiDdDDIQueryAdapterInfo",
    "NtGdiDdDDIGetRuntimeData",
    "NtGdiDdDDISignalSynchronizationObject",
    "NtGdiDdDDIWaitForSynchronizationObject",
    "NtGdiDdDDIDestroySynchronizationObject",
    "NtGdiDdDDIOpenSynchronizationObject",
    "NtGdiDdDDICreateSynchronizationObject",
    "NtGdiDdDDIDestroyContext",
    "NtGdiDdDDICreateContext",
    "NtGdiDdDDIDestroyDevice",
    "NtGdiDdDDICreateDevice",
    "NtGdiDdDDIQueryAllocationResidency",
    "NtGdiDdDDISetAllocationPriority",
    "NtGdiDdDDIDestroyAllocation",
    "NtGdiDdDDIDestroyAllocation2",
    "NtGdiDdDDIOpenResourceFromNtHandle",
    "NtGdiDdDDIOpenSyncObjectFromNtHandle",
    "NtGdiDdDDIOpenSyncObjectFromNtHandle2",
    "NtGdiDdDDIOpenResource",
    "NtGdiDdDDIOpenNtHandleFromName",
    "NtGdiDdDDIOpenSyncObjectNtHandleFromName",
    "NtGdiDdDDIShareObjects",
    "NtGdiDdDDIQueryResourceInfoFromNtHandle",
    "NtGdiDdDDIQueryResourceInfo",
    "NtGdiDdDDICreateAllocation",
    "NtGdiDdDDIOutputDuplReleaseFrame",
    "NtGdiDdDDIQueryRemoteVidPnSourceFromGdiDisplayName",
    "NtGdiDdDDIOutputDuplPresent",
    "NtGdiDdDDIReleaseKeyedMutex2",
    "NtGdiDdDDIAcquireKeyedMutex2",
    "NtGdiDdDDIOpenKeyedMutex2",
    "NtGdiDdDDICreateKeyedMutex2",
    "NtGdiDdDDIOutputDuplGetPointerShapeData",
    "NtGdiDdDDIOutputDuplGetMetaData",
    "NtGdiDdDDIOutputDuplGetFrameInfo",
    "NtGdiDdDDIDestroyOutputDupl",
    "NtGdiDdDDICreateOutputDupl",
    "NtGdiDdDDIReclaimAllocations",
    "NtGdiDdDDIOfferAllocations",
    "NtGdiDdDDICheckSharedResourceAccess",
    "NtGdiDdDDICheckVidPnExclusiveOwnership",
    "NtGdiDdDDIGetOverlayState",
    "NtGdiDdDDIConfigureSharedResource",
    "NtGdiDdDDIReleaseKeyedMutex",
    "NtGdiDdDDIAcquireKeyedMutex",
    "NtGdiDdDDIDestroyKeyedMutex",
    "NtGdiDdDDIOpenKeyedMutex",
    "NtGdiDdDDICreateKeyedMutex",
    "NtGdiDdDDISharedPrimaryUnLockNotification",
    "NtGdiDdDDISharedPrimaryLockNotification",
    "NtGdiDdDDISetDisplayPrivateDriverFormat",
    "NtGdiDdDDICheckExclusiveOwnership",
    "NtGdiDdDDICheckMonitorPowerState",
    "NtGdiDdDDIWaitForIdle",
    "NtGdiDdDDICheckOcclusion",
    "NtGdiDdDDIInvalidateActiveVidPn",
    "NtGdiDdDDIPollDisplayChildren",
    "NtGdiDdDDISetQueuedLimit",
    "NtGdiDdDDIPinDirectFlipResources",
    "NtGdiDdDDIUnpinDirectFlipResources",
    "NtGdiDdDDIWaitForVerticalBlankEvent2",
    "NtGdiDdDDIGetDWMVerticalBlankEvent",
    "NtGdiDdDDISetSyncRefreshCountWaitTarget",
    "NtGdiDdDDISetContextInProcessSchedulingPriority",
    "NtGdiDdDDIGetContextInProcessSchedulingPriority",
    "NtGdiDdDDIGetSharedResourceAdapterLuid",
    "NtGdiDdDDISetStereoEnabled",
    "NtGdiDdDDIPresentMultiPlaneOverlay",
    "NtGdiDdDDICheckMultiPlaneOverlaySupport",
    "NtGdiDdDDIMakeResident",
    "NtGdiDdDDIEvict",
    "NtGdiDdDDIUpdateAllocationProperty",
    "NtGdiDdDDIWaitForSynchronizationObjectFromCpu",
    "NtGdiDdDDISignalSynchronizationObjectFromCpu",
    "NtGdiDdDDIWaitForSynchronizationObjectFromGpu",
    "NtGdiDdDDISignalSynchronizationObjectFromGpu",
    "NtGdiDdDDISignalSynchronizationObjectFromGpu2",
    "NtGdiDdDDICreatePagingQueue",
    "NtGdiDdDDIDestroyPagingQueue",
    "NtGdiDdDDILock2",
    "NtGdiDdDDIUnlock2",
    "NtGdiDdDDIInvalidateCache",
    "NtGdiDdDDIGetResourcePresentPrivateDriverData",
    "NtGdiDdDDIMapGpuVirtualAddress",
    "NtGdiDdDDIReserveGpuVirtualAddress",
    "NtGdiDdDDIFreeGpuVirtualAddress",
    "NtGdiDdDDIUpdateGpuVirtualAddress",
    "NtGdiDdDDICreateContextVirtual",
    "NtGdiDdDDISubmitCommand",
    "NtGdiDdDDIGetCachedHybridQueryValue",
    "NtGdiDdDDICacheHybridQueryValue",
    "NtGdiDdDDINetDispGetNextChunkInfo",
    "NtGdiDdDDINetDispQueryMiracastDisplayDeviceSupport",
    "NtGdiDdDDINetDispStartMiracastDisplayDevice",
    "NtGdiDdDDINetDispStopMiracastDisplayDevice",
    "NtGdiDdDDINetDispQueryMiracastDisplayDeviceStatus",
    "NtGdiDdDDINetDispStopSessions",
    "NtGdiDdDDIQueryVideoMemoryInfo",
    "NtGdiDdDDIChangeVideoMemoryReservation",
    "NtGdiDdDDICreateSwapChain",
    "NtGdiDdDDIOpenSwapChain",
    "NtGdiDdDDIGetSetSwapChainMetadata",
    "NtGdiDdDDIAcquireSwapChain",
    "NtGdiDdDDIReleaseSwapChain",
    "NtGdiDdDDIAbandonSwapChain",
    "NtGdiDdDDISetDodIndirectSwapchain",
    "NtGdiDdDDICheckMultiPlaneOverlaySupport2",
    "NtGdiDdDDIPresentMultiPlaneOverlay2",
    "NtGdiDdDDIReclaimAllocations2",
    "NtGdiDdDDISetStablePowerState",
    "NtGdiDdDDIQueryClockCalibration",
    "NtGdiDdDDIQueryVidPnExclusiveOwnership",
    "NtGdiDdDDIAdjustFullscreenGamma",
    "NtGdiDdDDISetVidPnSourceHwProtection",
    "NtGdiDdDDIMarkDeviceAsError",
    "NtGdiDdDDIFlushHeapTransitions",
    "NtGdiDdDDISetHwProtectionTeardownRecovery",
    "NtGdiDdDDIQueryProcessOfferInfo",
    "NtGdiDdDDITrimProcessCommitment",
    "NtGdiDdDDICheckMultiPlaneOverlaySupport3",
    "NtGdiDdDDIPresentMultiPlaneOverlay3",
    "NtGdiDdDDISetFSEBlock",
    "NtGdiDdDDIQueryFSEBlock",
    "NtGdiDdDDICreateHwContext",
    "NtGdiDdDDIDestroyHwContext",
    "NtGdiDdDDICreateHwQueue",
    "NtGdiDdDDIDestroyHwQueue",
    "NtGdiDdDDISubmitCommandToHwQueue",
    "NtGdiDdDDISubmitWaitForSyncObjectsToHwQueue",
    "NtGdiDdDDISubmitSignalSyncObjectsToHwQueue",
    "NtGdiDdDDIGetAllocationPriority",
    "NtGdiDdDDIGetMultiPlaneOverlayCaps",
    "NtGdiDdDDIGetPostCompositionCaps",
    "NtGdiDdDDISetYieldPercentage",
    "NtGdiDdDDISetProcessSchedulingPriorityBand",
    "NtGdiDdDDISetMemoryBudgetTarget",
    "NtGdiDdDDIGetYieldPercentage",
    "NtGdiDdDDIGetProcessSchedulingPriorityBand",
    "NtGdiDdDDIGetMemoryBudgetTarget",
    "NtGdiMakeObjectUnXferable",
    "NtGdiMakeObjectXferable",
    "NtGdiDestroyPhysicalMonitor",
    "NtGdiGetPhysicalMonitorDescription",
    "NtGdiGetPhysicalMonitors",
    "NtGdiGetNumberOfPhysicalMonitors",
    "NtGdiDDCCIGetTimingReport",
    "NtGdiDDCCIGetCapabilitiesString",
    "NtGdiDDCCIGetCapabilitiesStringLength",
    "NtGdiDDCCISaveCurrentSettings",
    "NtGdiDDCCISetVCPFeature",
    "NtGdiDDCCIGetVCPFeature",
    "NtGdiDdQueryVisRgnUniqueness",
    "NtGdiDdDestroyFullscreenSprite",
    "NtGdiDdNotifyFullscreenSpriteUpdate",
    "NtGdiDdCreateFullscreenSprite",
    "NtGdiGetProcessSessionFonts",
    "NtGdiGetPublicFontTableChangeCookie",
    "NtGdiAddInitialFonts",
    "NtUserShowSystemCursor",
    "NtUserSetMirrorRendering",
    "NtUserMagGetContextInformation",
    "NtUserMagSetContextInformation",
    "NtUserMagControl",
    "NtUserSlicerControl",
    "NtUserHwndSetRedirectionInfo",
    "NtUserHwndQueryRedirectionInfo",
    "NtCreateCompositionSurfaceHandle",
    "NtValidateCompositionSurfaceHandle",
    "NtBindCompositionSurface",
    "NtUnBindCompositionSurface",
    "NtQueryCompositionSurfaceBinding",
    "NtNotifyPresentToCompositionSurface",
    "NtQueryCompositionSurfaceStatistics",
    "NtOpenCompositionSurfaceSectionInfo",
    "NtOpenCompositionSurfaceSwapChainHandleInfo",
    "NtQueryCompositionSurfaceRenderingRealization",
    "NtOpenCompositionSurfaceDirtyRegion",
    "NtQueryCompositionSurfaceHDRMetaData",
    "NtSetCompositionSurfaceHDRMetaData",
    "NtSetCompositionSurfaceDirectFlipState",
    "NtSetCompositionSurfaceStatistics",
    "NtSetCompositionSurfaceBufferUsage",
    "NtSetCompositionSurfaceIndependentFlipInfo",
    "NtDesktopCaptureBits",
    "NtDCompositionEnableMMCSS",
    "NtVisualCaptureBits",
    "NtDCompositionEnableDDASupport",
    "NtDCompositionCreateSharedVisualHandle",
    "NtCreateCompositionInputSink",
    "NtCreateImplicitCompositionInputSink",
    "NtDuplicateCompositionInputSink",
    "NtQueryCompositionInputSink",
    "NtQueryCompositionInputSinkLuid",
    "NtQueryCompositionInputSinkViewId",
    "NtUpdateInputSinkTransforms",
    "NtCompositionInputThread",
    "NtQueryCompositionInputQueueAndTransform",
    "NtQueryCompositionInputIsImplicit",
    "NtCompositionSetDropTarget",
    "NtTokenManagerOpenSectionAndEvents",
    "NtTokenManagerThread",
    "NtTokenManagerCreateCompositionTokenHandle",
    "NtTokenManagerGetAnalogExclusiveTokenEvent",
    "NtTokenManagerGetAnalogExclusiveSurfaceUpdates",
    "NtTokenManagerConfirmOutstandingAnalogToken",
    "NtSetCompositionSurfaceAnalogExclusive",
    "NtDCompositionBeginFrame",
    "NtDCompositionConfirmFrame",
    "NtDCompositionRetireFrame",
    "NtDCompositionDiscardFrame",
    "NtDCompositionGetFrameSurfaceUpdates",
    "NtDCompositionGetFrameLegacyTokens",
    "NtDCompositionDestroyConnection",
    "NtDCompositionGetConnectionBatch",
    "NtDCompositionGetFrameStatistics",
    "NtDCompositionGetDeletedResources",
    "NtDCompositionCreateConnection",
    "NtDCompositionDestroyChannel",
    "NtDCompositionReleaseAllResources",
    "NtDCompositionSubmitDWMBatch",
    "NtDCompositionProcessChannelBatchBuffer",
    "NtDCompositionCommitChannel",
    "NtDCompositionWaitForChannel",
    "NtDCompositionSetChannelCommitCompletionEvent",
    "NtDCompositionTelemetryTouchInteractionBegin",
    "NtDCompositionTelemetryTouchInteractionUpdate",
    "NtDCompositionTelemetryTouchInteractionEnd",
    "NtDCompositionTelemetrySetApplicationId",
    "NtDCompositionTelemetryAnimationScenarioBegin",
    "NtDCompositionTelemetryAnimationScenarioReference",
    "NtDCompositionTelemetryAnimationScenarioUnreference",
    "NtDCompositionCurrentBatchId",
    "NtDCompositionRemoveCrossDeviceVisualChild",
    "NtDCompositionAddCrossDeviceVisualChild",
    "NtDCompositionCreateDwmChannel",
    "NtDCompositionCreateChannel",
    "NtDCompositionSynchronize",
    "NtDCompositionReferenceSharedResourceOnDwmChannel",
    "NtDCompositionCreateAndBindSharedSection",
    "NtDCompositionSetDebugCounter",
    "NtDCompositionGetChannels",
    "NtDCompositionConnectPipe",
    "NtDCompositionRegisterThumbnailVisual",
    "NtDCompositionRegisterVirtualDesktopVisual",
    "NtDCompositionDuplicateHandleToProcess",
    "NtDCompositionUpdatePointerCapture",
    "NtDCompositionSetChannelCallbackId",
    "NtDCompositionDuplicateSwapchainHandleToDwm",
    "NtDCompositionSetChildRootVisual",
    "NtDCompositionCommitSynchronizationObject",
    "NtUserDestroyDCompositionHwndTarget",
    "NtUserCreateDCompositionHwndTarget",
    "NtUserWaitForRedirectionStartComplete",
    "NtUserSignalRedirectionStartComplete",
    "NtUserEnableWindowResizeOptimization",
    "NtUserGetResizeDCompositionSynchronizationObject",
    "NtUserEnableResizeLayoutSynchronization",
    "NtUserBeginLayoutUpdate",
    "NtUserIsResizeLayoutSynchronizationEnabled",
    "NtUserConfirmResizeCommit",
    "NtUserSetActiveProcessForMonitor",
    "NtUserGetDisplayAutoRotationPreferencesByProcessId",
    "NtUserGetDisplayAutoRotationPreferences",
    "NtUserSetDisplayAutoRotationPreferences",
    "NtUserSetAutoRotation",
    "NtUserGetAutoRotationState",
    "NtUserAutoRotateScreen",
    "NtUserAcquireIAMKey",
    "NtUserSetActivationFilter",
    "NtUserSetFallbackForeground",
    "NtUserSetBrokeredForeground",
    "NtUserDisableImmersiveOwner",
    "NtUserClearForeground",
    "NtUserEnableIAMAccess",
    "NtUserGetProcessUIContextInformation",
    "NtUserSetProcessRestrictionExemption",
    "NtUserSetWindowArrangement",
    "NtUserSetWindowShowState",
    "NtUserUpdateWindowTrackingInfo",
    "NtUserEnableMouseInPointer",
    "NtUserIsMouseInPointerEnabled",
    "NtUserPromoteMouseInPointer",
    "NtUserAutoPromoteMouseInPointer",
    "NtUserEnableMouseInputForCursorSuppression",
    "NtUserIsMouseInputEnabled",
    "NtUserCheckProcessForClipboardAccess",
    "NtUserGetClipboardAccessToken",
    "NtUserGetQueueStatusReadonly",
    "NtUserCompositionInputSinkLuidFromPoint",
    "NtUserCompositionInputSinkViewInstanceIdFromPoint",
    "NtUserUpdateWindowInputSinkHints",
    "NtUserTransformPoint",
    "NtUserTransformRect",
    "NtUserGetHimetricScaleFactorFromPixelLocation",
    "NtUserGetDpiForMonitor",
    "NtUserReportInertia",
    "NtUserLinkDpiCursor",
    "NtUserGetCursorDims",
    "NtUserInitializeInputDeviceInjection",
    "NtUserInitializeGenericHidInjection",
    "NtUserInitializePointerDeviceInjection",
    "NtUserRemoveInjectionDevice",
    "NtUserSetFeatureReportResponse",
    "NtUserInjectDeviceInput",
    "NtUserInjectMouseInput",
    "NtUserInjectKeyboardInput",
    "NtUserInjectPointerInput",
    "NtUserInjectGenericHidInput",
    "NtUserInitializePointerDeviceInjectionEx",
    "NtRIMRegisterForInput",
    "NtRIMReadInput",
    "NtRIMGetDevicePreparsedData",
    "NtRIMGetDeviceProperties",
    "NtRIMAreSiblingDevices",
    "NtRIMFreeInputBuffer",
    "NtRIMOnPnpNotification",
    "NtRIMOnTimerNotification",
    "NtRIMDeviceIoControl",
    "NtRIMUnregisterForInput",
    "NtRIMSetTestModeStatus",
    "NtRIMGetPhysicalDeviceRect",
    "NtRIMGetSourceProcessId",
    "NtRIMAddInputObserver",
    "NtRIMRemoveInputObserver",
    "NtRIMUpdateInputObserverRegistration",
    "NtRIMObserveNextInput",
    "NtRIMGetDevicePreparsedDataLockfree",
    "NtRIMGetDevicePropertiesLockfree",
    "NtUserSetCoreWindow",
    "NtUserSetCoreWindowPartner",
    "NtUserNavigateFocus",
    "NtHWCursorUpdatePointer",
    "NtUserAcquireInteractiveControlBackgroundAccess",
    "NtUserGetInteractiveControlInfo",
    "NtUserGetInteractiveControlDeviceInfo",
    "NtUserSendInteractiveControlHapticsReport",
    "NtUserSetInteractiveControlFocus",
    "NtUserInteractiveControlQueryUsage",
    "NtUserSetInteractiveCtrlRotationAngle",
    "NtUserGetInteractiveCtrlSupportedWaveforms",
    "NtUserProcessInkFeedbackCommand",
    "NtUserSetProcessInteractionFlags",
    "NtMITActivateInputProcessing",
    "NtMITWaitForMultipleObjectsEx",
    "NtMITDeactivateInputProcessing",
    "NtMITSetInputCallbacks",
    "NtMITCoreMsgKGetConnectionHandle",
    "NtMITCoreMsgKSend",
    "NtMITCoreMsgKOpenConnectionTo",
    "NtMITUpdateInputGlobals",
    "NtMITBindInputTypeToMonitors",
    "NtMITEnableMouseIntercept",
    "NtMITDisableMouseIntercept",
    "NtMITSynthesizeTouchInput",
    "NtMITSynthesizeMouseInput",
    "NtMITSynthesizeMouseWheel"
};

//////////////////////////////////////////////////////////////////////////
// Windows 10 RS2 _W32pServiceTableFilter
//////////////////////////////////////////////////////////////////////////
static const char* W32pServiceTableFilter_Win10Rs2_x86[] = {
    "_stub_UserGetOwnerTransformedMonitorRect",
    "_stub_UserYieldTask",
    "_stub_UserSetSensorPresence",
    "_stub_GdiWidenPath",
    "_stub_GdiUpdateColors",
    "_stub_GdiUnrealizeObject",
    "_stub_GdiUnmapMemFont",
    "_stub_GdiUnloadPrinterDriver",
    "_stub_GdiTransparentBlt",
    "_stub_GdiTransformPoints",
    "_stub_GdiScaleRgn",
    "_stub_GdiScaleValues",
    "_stub_GdiGetDCDpiScaleValue",
    "_stub_GdiGetBitmapDpiScaleValue",
    "_stub_GdiSwapBuffers",
    "_stub_GdiStrokePath",
    "_stub_GdiStrokeAndFillPath",
    "_stub_GdiStretchDIBitsInternal",
    "_stub_GdiStretchBlt",
    "_stub_GdiStartPage",
    "_stub_GdiStartDoc",
    "_stub_GdiSetSizeDevice",
    "_stub_GdiSetVirtualResolution",
    "_stub_GdiSetTextJustification",
    "_stub_GdiSetSystemPaletteUse",
    "_stub_GdiSetRectRgn",
    "_stub_GdiSetPixelFormat",
    "_stub_GdiSetPixel",
    "_stub_GdiSetOPMSigningKeyAndSequenceNumbers",
    "_stub_GdiSetLayout",
    "_stub_GdiMirrorWindowOrg",
    "_stub_GdiGetDeviceWidth",
    "_stub_GdiSetMiterLimit",
    "_stub_GdiSetMetaRgn",
    "_stub_GdiSetMagicColors",
    "_stub_GdiSetLinkedUFIs",
    "_stub_GdiSetIcmMode",
    "_stub_GdiSetFontXform",
    "_stub_GdiSetFontEnumeration",
    "_stub_GdiSetDIBitsToDeviceInternal",
    "_stub_GdiSetDeviceGammaRamp",
    "_stub_GdiGetGammaRampCapability",
    "_stub_GdiSetPrivateDeviceGammaRamp",
    "_stub_GdiGetAppliedDeviceGammaRamp",
    "_stub_GdiSetColorSpace",
    "_stub_GdiSetColorAdjustment",
    "_stub_GdiSetBrushOrg",
    "_stub_GdiSetBrushAttributes",
    "_stub_GdiSetBoundsRect",
    "_stub_GdiSetBitmapDimension",
    "_stub_GdiSetBitmapBits",
    "_stub_GdiSetBitmapAttributes",
    "_stub_GdiSelectPen",
    "_stub_GdiSelectFont",
    "_stub_GdiSelectClipPath",
    "_stub_GdiSelectBrush",
    "_stub_GdiSelectBitmap",
    "_stub_GdiScaleWindowExtEx",
    "_stub_GdiScaleViewportExtEx",
    "_stub_GdiSaveDC",
    "_stub_GdiRoundRect",
    "_stub_GdiRestoreDC",
    "_stub_GdiResizePalette",
    "_stub_GdiResetDC",
    "_stub_GdiRemoveFontMemResourceEx",
    "_stub_GdiRemoveFontResourceW",
    "_stub_GdiRectVisible",
    "_stub_GdiRectInRegion",
    "_stub_GdiRectangle",
    "_stub_GdiQueryFontAssocInfo",
    "_stub_GdiQueryFonts",
    "_stub_GdiPtVisible",
    "_stub_GdiPtInRegion",
    "_stub_GdiPolyTextOutW",
    "_stub_GdiPolyPolyDraw",
    "_stub_GdiPolyDraw",
    "_stub_GdiPlgBlt",
    "_stub_GdiPathToRegion",
    "_stub_GdiPolyPatBlt",
    "_stub_GdiPatBlt",
    "_stub_GdiOpenDCW",
    "_stub_GdiOffsetRgn",
    "_stub_GdiOffsetClipRgn",
    "_stub_GdiMoveTo",
    "_stub_GdiMonoBitmap",
    "_stub_GdiModifyWorldTransform",
    "_stub_GdiMaskBlt",
    "_stub_GdiMakeInfoDC",
    "_stub_GdiMakeFontDir",
    "_stub_GdiLineTo",
    "_stub_GdiInvertRgn",
    "_stub_GdiIntersectClipRect",
    "_stub_GdiInitSpool",
    "_stub_GdiInit",
    "_stub_GdiIcmBrushInfo",
    "_stub_GdiHfontCreate",
    "_stub_GdiGradientFill",
    "_stub_GdiGetWidthTable",
    "_stub_GdiGetFontUnicodeRanges",
    "_stub_GdiAddEmbFontToDC",
    "_stub_GdiChangeGhostFont",
    "_stub_GdiGetEmbedFonts",
    "_stub_GdiGetUFIPathname",
    "_stub_GdiGetEmbUFI",
    "_stub_GdiGetUFI",
    "_stub_GdiGetTransform",
    "_stub_GdiGetTextMetricsW",
    "_stub_GdiGetTextFaceW",
    "_stub_GdiGetTextExtentExW",
    "_stub_GdiGetTextExtent",
    "_stub_GdiGetTextCharsetInfo",
    "_stub_GdiGetSystemPaletteUse",
    "_stub_GdiGetSuggestedOPMProtectedOutputArraySize",
    "_stub_GdiGetStringBitmapW",
    "_stub_GdiGetStats",
    "_stub_GdiGetSpoolMessage",
    "_stub_GdiGetServerMetaFileBits",
    "_stub_GdiGetRgnBox",
    "_stub_GdiGetRegionData",
    "_stub_GdiGetRealizationInfo",
    "_stub_GdiGetRasterizerCaps",
    "_stub_GdiGetRandomRgn",
    "_stub_GdiGetPixel",
    "_stub_GdiGetPath",
    "_stub_GdiGetOutlineTextMetricsInternalW",
    "_stub_GdiGetOPMRandomNumber",
    "_stub_GdiGetObjectBitmapHandle",
    "_stub_GdiGetNearestPaletteIndex",
    "_stub_GdiGetNearestColor",
    "_stub_GdiGetMonitorID",
    "_stub_GdiGetMiterLimit",
    "_stub_GdiGetLinkedUFIs",
    "_stub_GdiGetKerningPairs",
    "_stub_GdiGetOPMInformation",
    "_stub_GdiGetGlyphOutline",
    "_stub_GdiGetGlyphIndicesWInternal",
    "_stub_GdiGetGlyphIndicesW",
    "_stub_GdiGetFontResourceInfoInternalW",
    "_stub_GdiGetFontFileInfo",
    "_stub_GdiGetFontFileData",
    "_stub_GdiGetFontData",
    "_stub_GdiGetEudcTimeStampEx",
    "_stub_GdiGetETM",
    "_stub_GdiGetEntry",
    "_stub_GdiGetDIBitsInternal",
    "_stub_GdiGetDeviceCapsAll",
    "_stub_GdiGetDeviceGammaRamp",
    "_stub_GdiGetDeviceCaps",
    "_stub_GdiGetDCPoint",
    "_stub_GdiGetDCObject",
    "_stub_GdiGetDCforBitmap",
    "_stub_GdiGetDCDword",
    "_stub_GdiGetCurrentDpiInfo",
    "_stub_GdiGetCOPPCompatibleOPMInformation",
    "_stub_GdiGetColorSpaceforBitmap",
    "_stub_GdiGetColorAdjustment",
    "_stub_GdiGetCharWidthInfo",
    "_stub_GdiGetCharWidthW",
    "_stub_GdiGetCharSet",
    "_stub_GdiGetCharacterPlacementW",
    "_stub_GdiGetCharABCWidthsW",
    "_stub_GdiGetCertificateSize",
    "_stub_GdiGetCertificate",
    "_stub_GdiGetCertificateSizeByHandle",
    "_stub_GdiGetCertificateByHandle",
    "_stub_GdiGetBoundsRect",
    "_stub_GdiGetBitmapDimension",
    "_stub_GdiGetBitmapBits",
    "_stub_GdiGetAppClipBox",
    "_stub_GdiGetAndSetDCDword",
    "_stub_GdiFullscreenControl",
    "_stub_GdiFrameRgn",
    "_stub_GdiForceUFIMapping",
    "_stub_GdiFlush",
    "_stub_GdiFlattenPath",
    "_stub_GdiFillRgn",
    "_stub_GdiFillPath",
    "_stub_GdiExtTextOutW",
    "_stub_GdiExtSelectClipRgn",
    "_stub_GdiExtGetObjectW",
    "_stub_GdiExtFloodFill",
    "_stub_GdiExtEscape",
    "_stub_GdiExtCreateRegion",
    "_stub_GdiExtCreatePen",
    "_stub_GdiExcludeClipRect",
    "_stub_GdiEudcLoadUnloadLink",
    "_stub_GdiEqualRgn",
    "_stub_GdiEnumObjects",
    "_stub_GdiEnumFonts",
    "_stub_GdiEndPath",
    "_stub_GdiEndPage",
    "_stub_GdiEndGdiRendering",
    "_stub_GdiEndDoc",
    "_stub_GdiEnableEudc",
    "_stub_GdiEllipse",
    "_stub_GdiDrawEscape",
    "_stub_GdiDoPalette",
    "_stub_GdiDoBanding",
    "_stub_GdiGetPerBandInfo",
    "_stub_GdiDestroyOPMProtectedOutput",
    "_stub_GdiDescribePixelFormat",
    "_stub_GdiDeleteObjectApp",
    "_stub_GdiDeleteColorTransform",
    "_stub_GdiDeleteColorSpace",
    "_stub_GdiDeleteClientObj",
    "_stub_GdiCreateSolidBrush",
    "_stub_GdiCreateServerMetaFile",
    "_stub_GdiCreateRoundRectRgn",
    "_stub_GdiCreateRectRgn",
    "_stub_GdiCreatePen",
    "_stub_GdiCreatePatternBrushInternal",
    "_stub_GdiCreatePaletteInternal",
    "_stub_GdiCreateOPMProtectedOutputs",
    "_stub_GdiCreateOPMProtectedOutput",
    "_stub_GdiCreateMetafileDC",
    "_stub_GdiCreateHatchBrushInternal",
    "_stub_GdiCreateHalftonePalette",
    "_stub_GdiCreateEllipticRgn",
    "_stub_GdiCreateSessionMappedDIBSection",
    "_stub_GdiCreateDIBSection",
    "_stub_GdiCreateDIBitmapInternal",
    "_stub_GdiCreateDIBBrush",
    "_stub_GdiCreateCompatibleDC",
    "_stub_GdiCreateCompatibleBitmap",
    "_stub_GdiCreateColorTransform",
    "_stub_GdiCreateColorSpace",
    "_stub_GdiCreateClientObj",
    "_stub_GdiCreateBitmapFromDxSurface2",
    "_stub_GdiCreateBitmapFromDxSurface",
    "_stub_GdiCreateBitmap",
    "_stub_GdiConvertMetafileRect",
    "_stub_GdiConfigureOPMProtectedOutput",
    "_stub_GdiComputeXformCoefficients",
    "_stub_GdiCombineTransform",
    "_stub_GdiCombineRgn",
    "_stub_GdiColorCorrectPalette",
    "_stub_GdiClearBrushAttributes",
    "_stub_GdiClearBitmapAttributes",
    "_stub_GdiCloseFigure",
    "_stub_GdiCheckBitmapBits",
    "_stub_GdiCancelDC",
    "_stub_GdiBitBlt",
    "_stub_GdiBeginPath",
    "_stub_GdiBeginGdiRendering",
    "_stub_GdiArcInternal",
    "_stub_GdiFontIsLinked",
    "_stub_GdiAnyLinkedFonts",
    "_stub_GdiAngleArc",
    "_stub_GdiAlphaBlend",
    "_stub_GdiAddRemoteMMInstanceToDC",
    "_stub_GdiRemoveMergeFont",
    "_stub_GdiAddFontMemResourceEx",
    "_stub_GdiAddRemoteFontToDC",
    "_stub_GdiAddFontResourceW",
    "_stub_GdiAbortPath",
    "_stub_GdiAbortDoc",
    "_stub_UserDefSetText",
    "_stub_UserDeferWindowPosAndBand",
    "_stub_UserDdeInitialize",
    "_stub_UserCanBrokerForceForeground",
    "_stub_UserCreateWindowStation",
    "_stub_UserCreateWindowEx",
    "_stub_UserCreateLocalMemHandle",
    "_stub_UserCreateInputContext",
    "_stub_UserCreateDesktopEx",
    "_stub_UserCreateCaret",
    "_stub_UserCreateAcceleratorTable",
    "_stub_UserCountClipboardFormats",
    "_stub_UserCopyAcceleratorTable",
    "_stub_UserConvertMemHandle",
    "_stub_UserConsoleControl",
    "_stub_UserCloseWindowStation",
    "_stub_UserCloseDesktop",
    "_stub_UserCloseClipboard",
    "_stub_UserClipCursor",
    "_stub_UserChildWindowFromPointEx",
    "_stub_UserCheckMenuItem",
    "_stub_UserCheckWindowThreadDesktop",
    "_stub_UserDwmValidateWindow",
    "_stub_UserCheckAccessForIntegrityLevel",
    "_stub_UserDisplayConfigSetDeviceInfo",
    "_stub_UserDisplayConfigGetDeviceInfo",
    "_stub_UserQueryDisplayConfig",
    "_stub_UserSetDisplayConfig",
    "_stub_UserFunctionalizeDisplayConfig",
    "_stub_UserGetDisplayConfigBufferSizes",
    "_stub_UserChangeDisplaySettings",
    "_stub_UserChangeClipboardChain",
    "_stub_UserCallTwoParam",
    "_stub_UserCallOneParam",
    "_stub_UserCallNoParam",
    "_stub_UserCallNextHookEx",
    "_stub_UserCallMsgFilter",
    "_stub_UserCallHwndParamLock",
    "_stub_UserCallHwndParam",
    "_stub_UserCallHwndOpt",
    "_stub_UserCallHwndLock",
    "_stub_UserCallHwnd",
    "_stub_UserBroadcastThemeChangeEvent",
    "_stub_UserBuildPropList",
    "_stub_UserBuildNameList",
    "_stub_UserBuildHwndList",
    "_stub_UserBuildHimcList",
    "_stub_UserBlockInput",
    "_stub_UserBitBltSysBmp",
    "_stub_UserBeginPaint",
    "_stub_UserAttachThreadInput",
    "_stub_UserAssociateInputContext",
    "_stub_UserAlterWindowStyle",
    "_stub_UserAddClipboardFormatListener",
    "_stub_UserActivateKeyboardLayout",
    "_stub_UserDelegateCapturePointers",
    "_stub_UserDelegateInput",
    "_stub_UserDispatchMessage",
    "_stub_UserDisableProcessWindowFiltering",
    "_stub_UserDisableThreadIme",
    "_stub_UserDestroyWindow",
    "_stub_UserDestroyMenu",
    "_stub_UserDestroyInputContext",
    "_stub_UserDestroyCursor",
    "_stub_UserDestroyAcceleratorTable",
    "_stub_UserDeleteMenu",
    "_stub_UserDoSoundDisconnect",
    "_stub_UserDoSoundConnect",
    "_stub_UserGhostWindowFromHungWindow",
    "_stub_UserGetWOWClass",
    "_stub_UserGetWindowPlacement",
    "_stub_UserGetWindowDisplayAffinity",
    "_stub_UserGetWindowDC",
    "_stub_UserGetWindowCompositionAttribute",
    "_stub_UserGetWindowCompositionInfo",
    "_stub_UserGetWindowBand",
    "_stub_UserGetUpdateRgn",
    "_stub_UserGetUpdateRect",
    "_stub_UserGetUpdatedClipboardFormats",
    "_stub_UserGetTopLevelWindow",
    "_stub_UserGetTitleBarInfo",
    "_stub_UserGetThreadState",
    "_stub_UserGetThreadDesktop",
    "_stub_UserGetSystemMenu",
    "_stub_UserGetScrollBarInfo",
    "_stub_UserGetRegisteredRawInputDevices",
    "_stub_UserGetRawInputDeviceList",
    "_stub_UserGetRawInputDeviceInfo",
    "_stub_UserGetRawInputData",
    "_stub_UserGetRawInputBuffer",
    "_stub_UserGetProcessDpiAwarenessContext",
    "_stub_UserGetProcessWindowStation",
    "_stub_UserGetPriorityClipboardFormat",
    "_stub_UserGetOpenClipboardWindow",
    "_stub_UserGetObjectInformation",
    "_stub_UserGetMouseMovePointsEx",
    "_stub_UserGetMessage",
    "_stub_UserGetMenuItemRect",
    "_stub_UserGetMenuIndex",
    "_stub_UserGetMenuBarInfo",
    "_stub_UserGetListBoxInfo",
    "_stub_UserGetKeyState",
    "_stub_UserGetKeyNameText",
    "_stub_UserGetKeyboardState",
    "_stub_UserGetKeyboardLayoutName",
    "_stub_UserGetKeyboardLayoutList",
    "_stub_UserGetInternalWindowPos",
    "_stub_UserGetInputLocaleInfo",
    "_stub_UserGetImeInfoEx",
    "_stub_UserGetImeHotKey",
    "_stub_UserGetIconSize",
    "_stub_UserGetIconInfo",
    "_stub_UserGetGUIThreadInfo",
    "_stub_UserGetGuiResources",
    "_stub_UserGetForegroundWindow",
    "_stub_UserGetDoubleClickTime",
    "_stub_UserGetDesktopID",
    "_stub_UserGetDCEx",
    "_stub_UserGetDC",
    "_stub_UserGetCursorInfo",
    "_stub_UserGetCursorFrameInfo",
    "_stub_UserGetCurrentInputMessageSource",
    "_stub_UserGetCIMSSM",
    "_stub_UserGetCPD",
    "_stub_UserGetControlColor",
    "_stub_UserGetControlBrush",
    "_stub_UserGetComboBoxInfo",
    "_stub_UserGetClipCursor",
    "_stub_UserGetClipboardViewer",
    "_stub_UserGetClipboardSequenceNumber",
    "_stub_UserGetClipboardOwner",
    "_stub_UserGetClipboardFormatName",
    "_stub_UserGetClipboardData",
    "_stub_UserGetClassName",
    "_stub_UserGetClassInfoEx",
    "_stub_UserGetCaretPos",
    "_stub_UserGetCaretBlinkTime",
    "_stub_UserGetAtomName",
    "_stub_UserGetAsyncKeyState",
    "_stub_UserGetAppImeLevel",
    "_stub_UserGetAncestor",
    "_stub_UserGetAltTabInfo",
    "_stub_UserFrostCrashedWindow",
    "_stub_UserFlashWindowEx",
    "_stub_UserFindWindowEx",
    "_stub_UserFindExistingCursorIcon",
    "_stub_UserFillWindow",
    "_stub_UserExcludeUpdateRgn",
    "_stub_UserEvent",
    "_stub_UserEnumDisplaySettings",
    "_stub_UserEnumDisplayMonitors",
    "_stub_UserEnumDisplayDevices",
    "_stub_UserEndPaint",
    "_stub_UserEndMenu",
    "_stub_UserEndDeferWindowPosEx",
    "_stub_UserEnableScrollBar",
    "_stub_UserEnableMenuItem",
    "_stub_UserEmptyClipboard",
    "_stub_UserDrawMenuBarTemp",
    "_stub_UserDrawIconEx",
    "_stub_UserDrawCaptionTemp",
    "_stub_UserDrawCaption",
    "_stub_UserDrawAnimatedRects",
    "_stub_UserDragObject",
    "_stub_UserDragDetect",
    "_stub_UserHandleDelegatedInput",
    "_stub_UserInheritWindowMonitor",
    "_stub_UserRealChildWindowFromPoint",
    "_stub_UserQueryWindow",
    "_stub_UserQuerySendMessage",
    "_stub_UserQueryInputContext",
    "_stub_UserQueryInformationThread",
    "_stub_UserQueryBSDRWindow",
    "_stub_UserPerMonitorDPIPhysicalToLogicalPoint",
    "_stub_UserProcessConnect",
    "_stub_UserPrintWindow",
    "_stub_UserPostThreadMessage",
    "_stub_UserPostMessage",
    "_stub_UserPhysicalToLogicalPoint",
    "_stub_UserPeekMessage",
    "_stub_UserPaintMonitor",
    "_stub_UserPaintDesktop",
    "_stub_UserOpenWindowStation",
    "_stub_UserOpenThreadDesktop",
    "_stub_UserOpenInputDesktop",
    "_stub_UserOpenDesktop",
    "_stub_UserOpenClipboard",
    "_stub_UserNotifyWinEvent",
    "_stub_UserNotifyProcessCreate",
    "_stub_UserNotifyIMEStatus",
    "_stub_UserMoveWindow",
    "_stub_UserModifyUserStartupInfoFlags",
    "_stub_UserMNDragOver",
    "_stub_UserMNDragLeave",
    "_stub_UserMinMaximize",
    "_stub_UserMessageCall",
    "_stub_UserMenuItemFromPoint",
    "_stub_UserMapVirtualKeyEx",
    "_stub_UserLayoutCompleted",
    "_stub_UserLogicalToPerMonitorDPIPhysicalPoint",
    "_stub_UserLogicalToPhysicalPoint",
    "_stub_UserLockCursor",
    "_stub_UserLockWorkStation",
    "_stub_UserLockWindowUpdate",
    "_stub_UserLockWindowStation",
    "_stub_UserLoadKeyboardLayoutEx",
    "_stub_UserKillTimer",
    "_stub_UserIsTopLevelWindow",
    "_stub_UserIsClipboardFormatAvailable",
    "_stub_UserInvalidateRgn",
    "_stub_UserInvalidateRect",
    "_stub_UserInternalGetWindowIcon",
    "_stub_UserInternalGetWindowText",
    "_stub_UserInitTask",
    "_stub_UserInitializeClientPfnArrays",
    "_stub_UserInitialize",
    "_stub_UserImpersonateDdeClientWindow",
    "_stub_UserHungWindowFromGhostWindow",
    "_stub_UserHiliteMenuItem",
    "_stub_UserHideCaret",
    "_stub_UserHardErrorControl",
    "_stub_UserRealInternalGetMessage",
    "_stub_UserRealWaitMessageEx",
    "_stub_UserReleaseDwmHitTestWaiters",
    "_stub_UserTranslateMessage",
    "_stub_UserTranslateAccelerator",
    "_stub_UserPaintMenuBar",
    "_stub_UserCalcMenuBar",
    "_stub_UserCalculatePopupWindowPosition",
    "_stub_UserTrackPopupMenuEx",
    "_stub_UserTrackMouseEvent",
    "_stub_UserToUnicodeEx",
    "_stub_UserThunkedMenuItemInfo",
    "_stub_UserThunkedMenuInfo",
    "_stub_UserTestForInteractiveUser",
    "_stub_UserSendEventMessage",
    "_stub_UserSystemParametersInfo",
    "_stub_UserSystemParametersInfoForDpi",
    "_stub_UserSwitchDesktop",
    "_stub_UserSoundSentry",
    "_stub_UserShutdownReasonDestroy",
    "_stub_UserShutdownBlockReasonQuery",
    "_stub_UserShutdownBlockReasonCreate",
    "_stub_UserShowWindowAsync",
    "_stub_UserShowWindow",
    "_stub_UserShowScrollBar",
    "_stub_UserShowCaret",
    "_stub_UserSetWinEventHook",
    "_stub_UserSetWindowWord",
    "_stub_UserSetWindowStationUser",
    "_stub_UserSetWindowsHookEx",
    "_stub_UserSetWindowsHookAW",
    "_stub_UserSetWindowRgnEx",
    "_stub_UserGetWindowRgnEx",
    "_stub_UserSetWindowRgn",
    "_stub_UserSetWindowPos",
    "_stub_UserSetWindowPlacement",
    "_stub_UserSetWindowLong",
    "_stub_UserSetWindowFNID",
    "_stub_UserSetWindowDisplayAffinity",
    "_stub_UserSetWindowCompositionTransition",
    "_stub_UserUpdateDefaultDesktopThumbnail",
    "_stub_UserSetWindowCompositionAttribute",
    "_stub_UserSetWindowBand",
    "_stub_UserSetProcessUIAccessZorder",
    "_stub_UserSetProcessDpiAwarenessContext",
    "_stub_UserEnableChildWindowDpiMessage",
    "_stub_UserIsChildWindowDpiMessageEnabled",
    "_stub_UserEnableNonClientDpiScaling",
    "_stub_UserIsNonClientDpiScalingEnabled",
    "_stub_UserSetDialogControlDpiChangeBehavior",
    "_stub_UserIsWindowBroadcastingDpiToChildren",
    "_stub_UserEnableWindowGDIScaledDpiMessage",
    "_stub_UserIsWindowGDIScaledDpiMessageEnabled",
    "_stub_UserSetTimer",
    "_stub_UserSetThreadState",
    "_stub_UserSetThreadLayoutHandles",
    "_stub_UserSetThreadDesktop",
    "_stub_UserSetThreadInputBlocked",
    "_stub_UserSetSystemTimer",
    "_stub_UserSetSystemMenu",
    "_stub_UserSetSystemCursor",
    "_stub_UserSetSysColors",
    "_stub_UserSetShellWindowEx",
    "_stub_UserSetScrollInfo",
    "_stub_UserSetProp",
    "_stub_UserGetProp",
    "_stub_UserSetProcessWindowStation",
    "_stub_UserSetParent",
    "_stub_UserSetObjectInformation",
    "_stub_UserSetMenuFlagRtoL",
    "_stub_UserSetMenuDefaultItem",
    "_stub_UserSetMenuContextHelpId",
    "_stub_UserSetMenu",
    "_stub_UserSetKeyboardState",
    "_stub_UserSetInternalWindowPos",
    "_stub_UserSetInformationThread",
    "_stub_UserSetImeOwnerWindow",
    "_stub_UserSetImeInfoEx",
    "_stub_UserSetImeHotKey",
    "_stub_UserSetFocus",
    "_stub_UserSetCursorIconData",
    "_stub_UserSetCursorContents",
    "_stub_UserSetCursor",
    "_stub_UserSetClipboardViewer",
    "_stub_UserSetClipboardData",
    "_stub_UserSetClassWord",
    "_stub_UserSetClassLong",
    "_stub_UserSetChildWindowNoActivate",
    "_stub_UserSetCapture",
    "_stub_UserSetAppImeLevel",
    "_stub_UserSetActiveWindow",
    "_stub_UserSendInput",
    "_stub_UserSelectPalette",
    "_stub_UserScrollWindowEx",
    "_stub_UserScrollDC",
    "_stub_UserSBGetParms",
    "_stub_UserResolveDesktopForWOW",
    "_stub_UserRemoveProp",
    "_stub_UserRemoveMenu",
    "_stub_UserRemoveClipboardFormatListener",
    "_stub_UserRegisterWindowMessage",
    "_stub_UserRegisterTasklist",
    "_stub_UserRegisterServicesProcess",
    "_stub_UserRegisterRawInputDevices",
    "_stub_UserRegisterHotKey",
    "_stub_UserRegisterDManipHook",
    "_stub_UserGetDManipHookInitFunction",
    "_stub_UserRegisterManipulationThread",
    "_stub_UserSetManipulationInputTarget",
    "_stub_UserRegisterUserApiHook",
    "_stub_UserRegisterErrorReportingDialog",
    "_stub_UserRegisterClassExWOW",
    "_stub_UserRegisterBSDRWindow",
    "_stub_UserRedrawWindow",
    "_stub_UserUndelegateInput",
    "_stub_UserGetWindowMinimizeRect",
    "_stub_UserDwmGetRemoteSessionOcclusionEvent",
    "_stub_UserDwmGetRemoteSessionOcclusionState",
    "_stub_UserDwmKernelShutdown",
    "_stub_UserDwmKernelStartup",
    "_stub_UserCheckProcessSession",
    "_stub_UserUnregisterSessionPort",
    "_stub_UserRegisterSessionPort",
    "_stub_UserCtxDisplayIOCtl",
    "_stub_UserRemoteStopScreenUpdates",
    "_stub_UserRemoteRedrawScreen",
    "_stub_UserRemoteRedrawRectangle",
    "_stub_UserRemoteConnect",
    "_stub_UserWaitAvailableMessageEx",
    "_stub_UserWindowFromPoint",
    "_stub_UserWindowFromPhysicalPoint",
    "_stub_UserWaitMessage",
    "_stub_UserWaitForMsgAndEvent",
    "_stub_UserWaitForInputIdle",
    "_stub_UserVkKeyScanEx",
    "_stub_UserValidateTimerCallback",
    "_stub_UserValidateRect",
    "_stub_UserValidateHandleSecure",
    "_stub_UserUserHandleGrantAccess",
    "_stub_UserUpdatePerUserSystemParameters",
    "_stub_UserSetLayeredWindowAttributes",
    "_stub_UserGetLayeredWindowAttributes",
    "_stub_UserUpdateLayeredWindow",
    "_stub_UserUpdateInstance",
    "_stub_UserUpdateInputContext",
    "_stub_UserUnregisterHotKey",
    "_stub_UserUnregisterUserApiHook",
    "_stub_UserUnregisterClass",
    "_stub_UserUnlockWindowStation",
    "_stub_UserUnloadKeyboardLayout",
    "_stub_UserUnhookWinEvent",
    "_stub_UserUnhookWindowsHookEx",
    "_stub_UserGetTouchInputInfo",
    "_stub_UserIsTouchWindow",
    "_stub_UserModifyWindowTouchCapability",
    "_stub_GdiEngStretchBltROP",
    "_stub_GdiEngTextOut",
    "_stub_GdiEngTransparentBlt",
    "_stub_GdiEngGradientFill",
    "_stub_GdiEngAlphaBlend",
    "_stub_GdiEngLineTo",
    "_stub_GdiEngPaint",
    "_stub_GdiEngStrokeAndFillPath",
    "_stub_GdiEngFillPath",
    "_stub_GdiEngStrokePath",
    "_stub_GdiEngMarkBandingSurface",
    "_stub_GdiEngPlgBlt",
    "_stub_GdiEngStretchBlt",
    "_stub_GdiEngBitBlt",
    "_stub_GdiEngLockSurface",
    "_stub_GdiEngUnlockSurface",
    "_stub_GdiEngEraseSurface",
    "_stub_GdiEngDeleteSurface",
    "_stub_GdiEngDeletePalette",
    "_stub_GdiEngCopyBits",
    "_stub_GdiEngComputeGlyphSet",
    "_stub_GdiEngCreatePalette",
    "_stub_GdiEngCreateDeviceBitmap",
    "_stub_GdiEngCreateDeviceSurface",
    "_stub_GdiEngCreateBitmap",
    "_stub_GdiEngAssociateSurface",
    "_stub_UserSetWindowFeedbackSetting",
    "_stub_UserRegisterEdgy",
    "_stub_UserRegisterShellPTPListener",
    "_stub_UserGetWindowFeedbackSetting",
    "_stub_UserHidePointerContactVisualization",
    "_stub_UserGetTouchValidationStatus",
    "_stub_UserInitializeTouchInjection",
    "_stub_UserInjectTouchInput",
    "_stub_UserRegisterTouchHitTestingWindow",
    "_stub_UserSetDisplayMapping",
    "_stub_UserSetCalibrationData",
    "_stub_UserGetPhysicalDeviceRect",
    "_stub_UserRegisterTouchPadCapable",
    "_stub_UserGetRawPointerDeviceData",
    "_stub_UserGetPointerDeviceCursors",
    "_stub_UserGetPointerDeviceRects",
    "_stub_UserRegisterPointerDeviceNotifications",
    "_stub_UserGetPointerDeviceProperties",
    "_stub_UserGetPointerDevice",
    "_stub_UserGetPointerDevices",
    "_stub_UserEnableTouchPad",
    "_stub_UserGetPrecisionTouchPadConfiguration",
    "_stub_UserSetPrecisionTouchPadConfiguration",
    "_stub_UserPromotePointer",
    "_stub_UserDiscardPointerFrameMessages",
    "_stub_UserRegisterPointerInputTarget",
    "_stub_UserGetPointerFrameArrivalTimes",
    "_stub_UserGetPointerInputTransform",
    "_stub_UserGetPointerInfoList",
    "_stub_UserGetPointerCursorId",
    "_stub_UserGetPointerType",
    "_stub_UserGetGestureConfig",
    "_stub_UserSetGestureConfig",
    "_stub_UserGetGestureExtArgs",
    "_stub_UserGetGestureInfo",
    "_stub_UserInjectGesture",
    "_stub_UserChangeWindowMessageFilterEx",
    "_stub_GdiXLATEOBJ_hGetColorTransform",
    "_stub_GdiXLATEOBJ_iXlate",
    "_stub_GdiXLATEOBJ_cGetPalette",
    "_stub_GdiEngDeleteClip",
    "_stub_GdiEngCreateClip",
    "_stub_GdiEngDeletePath",
    "_stub_GdiCLIPOBJ_ppoGetPath",
    "_stub_GdiCLIPOBJ_cEnumStart",
    "_stub_GdiCLIPOBJ_bEnum",
    "_stub_GdiBRUSHOBJ_hGetColorTransform",
    "_stub_GdiBRUSHOBJ_pvGetRbrush",
    "_stub_GdiBRUSHOBJ_pvAllocRbrush",
    "_stub_GdiBRUSHOBJ_ulGetBrushColor",
    "_stub_GdiXFORMOBJ_iGetXform",
    "_stub_GdiXFORMOBJ_bApplyXform",
    "_stub_GdiFONTOBJ_pQueryGlyphAttrs",
    "_stub_GdiFONTOBJ_pfdg",
    "_stub_GdiFONTOBJ_pifi",
    "_stub_GdiFONTOBJ_cGetGlyphs",
    "_stub_GdiFONTOBJ_pxoGetXform",
    "_stub_GdiFONTOBJ_vGetInfo",
    "_stub_GdiFONTOBJ_cGetAllGlyphHandles",
    "_stub_GdiFONTOBJ_pvTrueTypeFontFile",
    "_stub_GdiSTROBJ_dwGetCodePage",
    "_stub_GdiSTROBJ_vEnumStart",
    "_stub_GdiSTROBJ_bGetAdvanceWidths",
    "_stub_GdiSTROBJ_bEnumPositionsOnly",
    "_stub_GdiSTROBJ_bEnum",
    "_stub_GdiPATHOBJ_bEnumClipLines",
    "_stub_GdiPATHOBJ_vEnumStartClipLines",
    "_stub_GdiPATHOBJ_vEnumStart",
    "_stub_GdiPATHOBJ_bEnum",
    "_stub_GdiPATHOBJ_vGetBounds",
    "_stub_GdiEngCheckAbort",
    "_stub_GdiGetDhpdev",
    "_stub_GdiHT_Get8BPPMaskPalette",
    "_stub_GdiHT_Get8BPPFormatPalette",
    "_stub_GdiUpdateTransform",
    "_stub_GdiUMPDEngFreeUserMem",
    "_stub_GdiBRUSHOBJ_DeleteRbrush",
    "_stub_GdiSetPUMPDOBJ",
    "_stub_GdiSetUMPDSandboxState",
    "_stub_GdiDrawStream",
    "_stub_GdiHLSurfSetInformation",
    "_stub_GdiHLSurfGetInformation",
    "_stub_GdiDwmCreatedBitmapRemotingOutput",
    "_stub_GdiDdDDIGetScanLine",
    "_stub_GdiDdDDIReleaseProcessVidPnSourceOwners",
    "_stub_GdiDdDDIGetProcessSchedulingPriorityClass",
    "_stub_GdiDdDDISetProcessSchedulingPriorityClass",
    "_stub_GdiDdDDIGetContextSchedulingPriority",
    "_stub_GdiDdDDISetContextSchedulingPriority",
    "_stub_GdiDdDDIDestroyDCFromMemory",
    "_stub_GdiDdDDICreateDCFromMemory",
    "_stub_GdiDdDDIGetDeviceState",
    "_stub_GdiDdDDISetGammaRamp",
    "_stub_GdiDdDDIWaitForVerticalBlankEvent",
    "_stub_GdiDdDDIDestroyOverlay",
    "_stub_GdiDdDDIFlipOverlay",
    "_stub_GdiDdDDIUpdateOverlay",
    "_stub_GdiDdDDICreateOverlay",
    "_stub_GdiDdDDIGetPresentQueueEvent",
    "_stub_GdiDdDDIGetPresentHistory",
    "_stub_GdiDdDDISetVidPnSourceOwner1",
    "_stub_GdiDdDDISetVidPnSourceOwner",
    "_stub_GdiDdDDIQueryStatistics",
    "_stub_GdiDdDDIEscape",
    "_stub_GdiDdDDIGetSharedPrimaryHandle",
    "_stub_GdiDdDDICloseAdapter",
    "_stub_GdiDdDDIOpenAdapterFromLuid",
    "_stub_GdiDdDDIEnumAdapters",
    "_stub_GdiDdDDIEnumAdapters2",
    "_stub_GdiDdDDIOpenAdapterFromHdc",
    "_stub_GdiDdDDIOpenAdapterFromDeviceName",
    "_stub_GdiDdDDIRender",
    "_stub_GdiDdDDIPresent",
    "_stub_GdiDdDDIGetMultisampleMethodList",
    "_stub_GdiDdDDISetDisplayMode",
    "_stub_GdiDdDDIGetDisplayModeList",
    "_stub_GdiDdDDIUnlock",
    "_stub_GdiDdDDILock",
    "_stub_GdiDdDDIQueryAdapterInfo",
    "_stub_GdiDdDDIGetRuntimeData",
    "_stub_GdiDdDDISignalSynchronizationObject",
    "_stub_GdiDdDDIWaitForSynchronizationObject",
    "_stub_GdiDdDDIDestroySynchronizationObject",
    "_stub_GdiDdDDIOpenSynchronizationObject",
    "_stub_GdiDdDDICreateSynchronizationObject",
    "_stub_GdiDdDDIDestroyContext",
    "_stub_GdiDdDDICreateContext",
    "_stub_GdiDdDDIDestroyDevice",
    "_stub_GdiDdDDICreateDevice",
    "_stub_GdiDdDDIQueryAllocationResidency",
    "_stub_GdiDdDDISetAllocationPriority",
    "_stub_GdiDdDDIDestroyAllocation",
    "_stub_GdiDdDDIDestroyAllocation2",
    "_stub_GdiDdDDIOpenResourceFromNtHandle",
    "_stub_GdiDdDDIOpenSyncObjectFromNtHandle",
    "_stub_GdiDdDDIOpenSyncObjectFromNtHandle2",
    "_stub_GdiDdDDIOpenResource",
    "_stub_GdiDdDDIOpenNtHandleFromName",
    "_stub_GdiDdDDIOpenSyncObjectNtHandleFromName",
    "_stub_GdiDdDDIShareObjects",
    "_stub_GdiDdDDIQueryResourceInfoFromNtHandle",
    "_stub_GdiDdDDIQueryResourceInfo",
    "_stub_GdiDdDDICreateAllocation",
    "_stub_GdiDdDDIOutputDuplReleaseFrame",
    "_stub_GdiDdDDIQueryRemoteVidPnSourceFromGdiDisplayName",
    "_stub_GdiDdDDIOutputDuplPresent",
    "_stub_GdiDdDDIReleaseKeyedMutex2",
    "_stub_GdiDdDDIAcquireKeyedMutex2",
    "_stub_GdiDdDDIOpenKeyedMutex2",
    "_stub_GdiDdDDICreateKeyedMutex2",
    "_stub_GdiDdDDIOutputDuplGetPointerShapeData",
    "_stub_GdiDdDDIOutputDuplGetMetaData",
    "_stub_GdiDdDDIOutputDuplGetFrameInfo",
    "_stub_GdiDdDDIDestroyOutputDupl",
    "_stub_GdiDdDDICreateOutputDupl",
    "_stub_GdiDdDDIReclaimAllocations",
    "_stub_GdiDdDDIOfferAllocations",
    "_stub_GdiDdDDICheckSharedResourceAccess",
    "_stub_GdiDdDDICheckVidPnExclusiveOwnership",
    "_stub_GdiDdDDIGetOverlayState",
    "_stub_GdiDdDDIConfigureSharedResource",
    "_stub_GdiDdDDIReleaseKeyedMutex",
    "_stub_GdiDdDDIAcquireKeyedMutex",
    "_stub_GdiDdDDIDestroyKeyedMutex",
    "_stub_GdiDdDDIOpenKeyedMutex",
    "_stub_GdiDdDDICreateKeyedMutex",
    "_stub_GdiDdDDISharedPrimaryUnLockNotification",
    "_stub_GdiDdDDISharedPrimaryLockNotification",
    "_stub_GdiDdDDISetDisplayPrivateDriverFormat",
    "_stub_GdiDdDDICheckExclusiveOwnership",
    "_stub_GdiDdDDICheckMonitorPowerState",
    "_stub_GdiDdDDIWaitForIdle",
    "_stub_GdiDdDDICheckOcclusion",
    "_stub_GdiDdDDIInvalidateActiveVidPn",
    "_stub_GdiDdDDIPollDisplayChildren",
    "_stub_GdiDdDDISetQueuedLimit",
    "_stub_GdiDdDDIPinDirectFlipResources",
    "_stub_GdiDdDDIUnpinDirectFlipResources",
    "_stub_GdiDdDDIWaitForVerticalBlankEvent2",
    "_stub_GdiDdDDIGetDWMVerticalBlankEvent",
    "_stub_GdiDdDDISetSyncRefreshCountWaitTarget",
    "_stub_GdiDdDDISetContextInProcessSchedulingPriority",
    "_stub_GdiDdDDIGetContextInProcessSchedulingPriority",
    "_stub_GdiDdDDIGetSharedResourceAdapterLuid",
    "_stub_GdiDdDDISetStereoEnabled",
    "_stub_GdiDdDDIPresentMultiPlaneOverlay",
    "_stub_GdiDdDDICheckMultiPlaneOverlaySupport",
    "_stub_GdiDdDDIMakeResident",
    "_stub_GdiDdDDIEvict",
    "_stub_GdiDdDDIUpdateAllocationProperty",
    "_stub_GdiDdDDIWaitForSynchronizationObjectFromCpu",
    "_stub_GdiDdDDISignalSynchronizationObjectFromCpu",
    "_stub_GdiDdDDIWaitForSynchronizationObjectFromGpu",
    "_stub_GdiDdDDISignalSynchronizationObjectFromGpu",
    "_stub_GdiDdDDISignalSynchronizationObjectFromGpu2",
    "_stub_GdiDdDDICreatePagingQueue",
    "_stub_GdiDdDDIDestroyPagingQueue",
    "_stub_GdiDdDDILock2",
    "_stub_GdiDdDDIUnlock2",
    "_stub_GdiDdDDIInvalidateCache",
    "_stub_GdiDdDDIGetResourcePresentPrivateDriverData",
    "_stub_GdiDdDDIMapGpuVirtualAddress",
    "_stub_GdiDdDDIReserveGpuVirtualAddress",
    "_stub_GdiDdDDIFreeGpuVirtualAddress",
    "_stub_GdiDdDDIUpdateGpuVirtualAddress",
    "_stub_GdiDdDDICreateContextVirtual",
    "_stub_GdiDdDDISubmitCommand",
    "_stub_GdiDdDDIGetCachedHybridQueryValue",
    "_stub_GdiDdDDICacheHybridQueryValue",
    "_stub_GdiDdDDINetDispGetNextChunkInfo",
    "_stub_GdiDdDDINetDispQueryMiracastDisplayDeviceSupport",
    "_stub_GdiDdDDINetDispStartMiracastDisplayDevice",
    "_stub_GdiDdDDINetDispStopMiracastDisplayDevice",
    "_stub_GdiDdDDINetDispQueryMiracastDisplayDeviceStatus",
    "_stub_GdiDdDDINetDispStopSessions",
    "_stub_GdiDdDDIQueryVideoMemoryInfo",
    "_stub_GdiDdDDIChangeVideoMemoryReservation",
    "_stub_GdiDdDDICreateSwapChain",
    "_stub_GdiDdDDIOpenSwapChain",
    "_stub_GdiDdDDIGetSetSwapChainMetadata",
    "_stub_GdiDdDDIAcquireSwapChain",
    "_stub_GdiDdDDIReleaseSwapChain",
    "_stub_GdiDdDDIAbandonSwapChain",
    "_stub_GdiDdDDISetDodIndirectSwapchain",
    "_stub_GdiDdDDICheckMultiPlaneOverlaySupport2",
    "_stub_GdiDdDDIPresentMultiPlaneOverlay2",
    "_stub_GdiDdDDIReclaimAllocations2",
    "_stub_GdiDdDDISetStablePowerState",
    "_stub_GdiDdDDIQueryClockCalibration",
    "_stub_GdiDdDDIQueryVidPnExclusiveOwnership",
    "_stub_GdiDdDDIAdjustFullscreenGamma",
    "_stub_GdiDdDDISetVidPnSourceHwProtection",
    "_stub_GdiDdDDIMarkDeviceAsError",
    "_stub_GdiDdDDIFlushHeapTransitions",
    "_stub_GdiDdDDISetHwProtectionTeardownRecovery",
    "_stub_GdiDdDDIQueryProcessOfferInfo",
    "_stub_GdiDdDDITrimProcessCommitment",
    "_stub_GdiDdDDICheckMultiPlaneOverlaySupport3",
    "_stub_GdiDdDDIPresentMultiPlaneOverlay3",
    "_stub_GdiDdDDISetFSEBlock",
    "_stub_GdiDdDDIQueryFSEBlock",
    "_stub_GdiDdDDICreateHwContext",
    "_stub_GdiDdDDIDestroyHwContext",
    "_stub_GdiDdDDICreateHwQueue",
    "_stub_GdiDdDDIDestroyHwQueue",
    "_stub_GdiDdDDISubmitCommandToHwQueue",
    "_stub_GdiDdDDISubmitWaitForSyncObjectsToHwQueue",
    "_stub_GdiDdDDISubmitSignalSyncObjectsToHwQueue",
    "_stub_GdiDdDDIGetAllocationPriority",
    "_stub_GdiDdDDIGetMultiPlaneOverlayCaps",
    "_stub_GdiDdDDIGetPostCompositionCaps",
    "_stub_GdiDdDDISetYieldPercentage",
    "_stub_GdiDdDDISetProcessSchedulingPriorityBand",
    "_stub_GdiDdDDISetMemoryBudgetTarget",
    "_stub_GdiDdDDIGetYieldPercentage",
    "_stub_GdiDdDDIGetProcessSchedulingPriorityBand",
    "_stub_GdiDdDDIGetMemoryBudgetTarget",
    "_stub_GdiMakeObjectUnXferable",
    "_stub_GdiMakeObjectXferable",
    "_stub_GdiDestroyPhysicalMonitor",
    "_stub_GdiGetPhysicalMonitorDescription",
    "_stub_GdiGetPhysicalMonitors",
    "_stub_GdiGetNumberOfPhysicalMonitors",
    "_stub_GdiDDCCIGetTimingReport",
    "_stub_GdiDDCCIGetCapabilitiesString",
    "_stub_GdiDDCCIGetCapabilitiesStringLength",
    "_stub_GdiDDCCISaveCurrentSettings",
    "_stub_GdiDDCCISetVCPFeature",
    "_stub_GdiDDCCIGetVCPFeature",
    "_stub_GdiDdQueryVisRgnUniqueness",
    "_stub_GdiDdDestroyFullscreenSprite",
    "_stub_GdiDdNotifyFullscreenSpriteUpdate",
    "_stub_GdiDdCreateFullscreenSprite",
    "_stub_GdiGetProcessSessionFonts",
    "_stub_GdiGetPublicFontTableChangeCookie",
    "_stub_GdiAddInitialFonts",
    "_stub_UserShowSystemCursor",
    "_stub_UserSetMirrorRendering",
    "_stub_UserMagGetContextInformation",
    "_stub_UserMagSetContextInformation",
    "_stub_UserMagControl",
    "_stub_UserSlicerControl",
    "_stub_UserHwndSetRedirectionInfo",
    "_stub_UserHwndQueryRedirectionInfo",
    "_stub_CreateCompositionSurfaceHandle",
    "_stub_ValidateCompositionSurfaceHandle",
    "_stub_BindCompositionSurface",
    "_stub_UnBindCompositionSurface",
    "_stub_QueryCompositionSurfaceBinding",
    "_stub_NotifyPresentToCompositionSurface",
    "_stub_QueryCompositionSurfaceStatistics",
    "_stub_OpenCompositionSurfaceSectionInfo",
    "_stub_OpenCompositionSurfaceSwapChainHandleInfo",
    "_stub_QueryCompositionSurfaceRenderingRealization",
    "_stub_OpenCompositionSurfaceDirtyRegion",
    "_stub_QueryCompositionSurfaceHDRMetaData",
    "_stub_SetCompositionSurfaceHDRMetaData",
    "_stub_SetCompositionSurfaceDirectFlipState",
    "_stub_SetCompositionSurfaceStatistics",
    "_stub_SetCompositionSurfaceBufferUsage",
    "_stub_SetCompositionSurfaceIndependentFlipInfo",
    "_stub_DesktopCaptureBits",
    "_stub_DCompositionEnableMMCSS",
    "_stub_VisualCaptureBits",
    "_stub_DCompositionEnableDDASupport",
    "_stub_DCompositionCreateSharedVisualHandle",
    "_stub_CreateCompositionInputSink",
    "_stub_CreateImplicitCompositionInputSink",
    "_stub_DuplicateCompositionInputSink",
    "_stub_QueryCompositionInputSink",
    "_stub_QueryCompositionInputSinkLuid",
    "_stub_QueryCompositionInputSinkViewId",
    "_stub_UpdateInputSinkTransforms",
    "_stub_CompositionInputThread",
    "_stub_QueryCompositionInputQueueAndTransform",
    "_stub_QueryCompositionInputIsImplicit",
    "_stub_CompositionSetDropTarget",
    "_stub_TokenManagerOpenSectionAndEvents",
    "_stub_TokenManagerThread",
    "_stub_TokenManagerCreateCompositionTokenHandle",
    "_stub_TokenManagerGetAnalogExclusiveTokenEvent",
    "_stub_TokenManagerGetAnalogExclusiveSurfaceUpdates",
    "_stub_TokenManagerConfirmOutstandingAnalogToken",
    "_stub_SetCompositionSurfaceAnalogExclusive",
    "_stub_DCompositionBeginFrame",
    "_stub_DCompositionConfirmFrame",
    "_stub_DCompositionRetireFrame",
    "_stub_DCompositionDiscardFrame",
    "_stub_DCompositionGetFrameSurfaceUpdates",
    "_stub_DCompositionGetFrameLegacyTokens",
    "_stub_DCompositionDestroyConnection",
    "_stub_DCompositionGetConnectionBatch",
    "_stub_DCompositionGetFrameStatistics",
    "_stub_DCompositionGetDeletedResources",
    "_stub_DCompositionCreateConnection",
    "_stub_DCompositionDestroyChannel",
    "_stub_DCompositionReleaseAllResources",
    "_stub_DCompositionSubmitDWMBatch",
    "_stub_DCompositionProcessChannelBatchBuffer",
    "_stub_DCompositionCommitChannel",
    "_stub_DCompositionWaitForChannel",
    "_stub_DCompositionSetChannelCommitCompletionEvent",
    "_stub_DCompositionTelemetryTouchInteractionBegin",
    "_stub_DCompositionTelemetryTouchInteractionUpdate",
    "_stub_DCompositionTelemetryTouchInteractionEnd",
    "_stub_DCompositionTelemetrySetApplicationId",
    "_stub_DCompositionTelemetryAnimationScenarioBegin",
    "_stub_DCompositionTelemetryAnimationScenarioReference",
    "_stub_DCompositionTelemetryAnimationScenarioUnreference",
    "_stub_DCompositionCurrentBatchId",
    "_stub_DCompositionRemoveCrossDeviceVisualChild",
    "_stub_DCompositionAddCrossDeviceVisualChild",
    "_stub_DCompositionCreateDwmChannel",
    "_stub_DCompositionCreateChannel",
    "_stub_DCompositionSynchronize",
    "_stub_DCompositionReferenceSharedResourceOnDwmChannel",
    "_stub_DCompositionCreateAndBindSharedSection",
    "_stub_DCompositionSetDebugCounter",
    "_stub_DCompositionGetChannels",
    "_stub_DCompositionConnectPipe",
    "_stub_DCompositionRegisterThumbnailVisual",
    "_stub_DCompositionRegisterVirtualDesktopVisual",
    "_stub_DCompositionDuplicateHandleToProcess",
    "_stub_DCompositionUpdatePointerCapture",
    "_stub_DCompositionSetChannelCallbackId",
    "_stub_DCompositionDuplicateSwapchainHandleToDwm",
    "_stub_DCompositionSetChildRootVisual",
    "_stub_DCompositionCommitSynchronizationObject",
    "_stub_UserDestroyDCompositionHwndTarget",
    "_stub_UserCreateDCompositionHwndTarget",
    "_stub_UserWaitForRedirectionStartComplete",
    "_stub_UserSignalRedirectionStartComplete",
    "_stub_UserEnableWindowResizeOptimization",
    "_stub_UserGetResizeDCompositionSynchronizationObject",
    "_stub_UserEnableResizeLayoutSynchronization",
    "_stub_UserBeginLayoutUpdate",
    "_stub_UserIsResizeLayoutSynchronizationEnabled",
    "_stub_UserConfirmResizeCommit",
    "_stub_UserSetActiveProcessForMonitor",
    "_stub_UserGetDisplayAutoRotationPreferencesByProcessId",
    "_stub_UserGetDisplayAutoRotationPreferences",
    "_stub_UserSetDisplayAutoRotationPreferences",
    "_stub_UserSetAutoRotation",
    "_stub_UserGetAutoRotationState",
    "_stub_UserAutoRotateScreen",
    "_stub_UserAcquireIAMKey",
    "_stub_UserSetActivationFilter",
    "_stub_UserSetFallbackForeground",
    "_stub_UserSetBrokeredForeground",
    "_stub_UserDisableImmersiveOwner",
    "_stub_UserClearForeground",
    "_stub_UserEnableIAMAccess",
    "_stub_UserGetProcessUIContextInformation",
    "_stub_UserSetProcessRestrictionExemption",
    "_stub_UserSetWindowArrangement",
    "_stub_UserSetWindowShowState",
    "_stub_UserUpdateWindowTrackingInfo",
    "_stub_UserEnableMouseInPointer",
    "_stub_UserIsMouseInPointerEnabled",
    "_stub_UserPromoteMouseInPointer",
    "_stub_UserAutoPromoteMouseInPointer",
    "_stub_UserEnableMouseInputForCursorSuppression",
    "_stub_UserIsMouseInputEnabled",
    "_stub_UserCheckProcessForClipboardAccess",
    "_stub_UserGetClipboardAccessToken",
    "_stub_UserGetQueueStatusReadonly",
    "_stub_UserCompositionInputSinkLuidFromPoint",
    "_stub_UserCompositionInputSinkViewInstanceIdFromPoint",
    "_stub_UserUpdateWindowInputSinkHints",
    "_stub_UserTransformPoint",
    "_stub_UserTransformRect",
    "_stub_UserGetHimetricScaleFactorFromPixelLocation",
    "_stub_UserGetDpiForMonitor",
    "_stub_UserReportInertia",
    "_stub_UserLinkDpiCursor",
    "_stub_UserGetCursorDims",
    "_stub_UserInitializeInputDeviceInjection",
    "_stub_UserInitializeGenericHidInjection",
    "_stub_UserInitializePointerDeviceInjection",
    "_stub_UserRemoveInjectionDevice",
    "_stub_UserSetFeatureReportResponse",
    "_stub_UserInjectDeviceInput",
    "_stub_UserInjectMouseInput",
    "_stub_UserInjectKeyboardInput",
    "_stub_UserInjectPointerInput",
    "_stub_UserInjectGenericHidInput",
    "_stub_UserInitializePointerDeviceInjectionEx",
    "_stub_RIMRegisterForInput",
    "_stub_RIMReadInput",
    "_stub_RIMGetDevicePreparsedData",
    "_stub_RIMGetDeviceProperties",
    "_stub_RIMAreSiblingDevices",
    "_stub_RIMFreeInputBuffer",
    "_stub_RIMOnPnpNotification",
    "_stub_RIMOnTimerNotification",
    "_stub_RIMDeviceIoControl",
    "_stub_RIMUnregisterForInput",
    "_stub_RIMSetTestModeStatus",
    "_stub_RIMGetPhysicalDeviceRect",
    "_stub_RIMGetSourceProcessId",
    "_stub_RIMAddInputObserver",
    "_stub_RIMRemoveInputObserver",
    "_stub_RIMUpdateInputObserverRegistration",
    "_stub_RIMObserveNextInput",
    "_stub_RIMGetDevicePreparsedDataLockfree",
    "_stub_RIMGetDevicePropertiesLockfree",
    "_stub_UserSetCoreWindow",
    "_stub_UserSetCoreWindowPartner",
    "_stub_UserNavigateFocus",
    "_stub_HWCursorUpdatePointer",
    "_stub_UserAcquireInteractiveControlBackgroundAccess",
    "_stub_UserGetInteractiveControlInfo",
    "_stub_UserGetInteractiveControlDeviceInfo",
    "_stub_UserSendInteractiveControlHapticsReport",
    "_stub_UserSetInteractiveControlFocus",
    "_stub_UserInteractiveControlQueryUsage",
    "_stub_UserSetInteractiveCtrlRotationAngle",
    "_stub_UserGetInteractiveCtrlSupportedWaveforms",
    "_stub_UserProcessInkFeedbackCommand",
    "_stub_UserSetProcessInteractionFlags",
    "_stub_MITActivateInputProcessing",
    "_stub_MITWaitForMultipleObjectsEx",
    "_stub_MITDeactivateInputProcessing",
    "_stub_MITSetInputCallbacks",
    "_stub_MITCoreMsgKGetConnectionHandle",
    "_stub_MITCoreMsgKSend",
    "_stub_MITCoreMsgKOpenConnectionTo",
    "_stub_MITUpdateInputGlobals",
    "_stub_MITBindInputTypeToMonitors",
    "_stub_MITEnableMouseIntercept",
    "_stub_MITDisableMouseIntercept",
    "_stub_MITSynthesizeTouchInput",
    "_stub_MITSynthesizeMouseInput",
    "_stub_MITSynthesizeMouseWheel"
};

//////////////////////////////////////////////////////////////////////////
// Windows 10 RS3 _W32pServiceTable
//////////////////////////////////////////////////////////////////////////
static const char* W32pServiceTable_Win10Rs3_x86[] = {
    "NtUserGetOwnerTransformedMonitorRect",
    "NtUserYieldTask",
    "NtUserSetSensorPresence",
    "NtGdiWidenPath",
    "NtGdiUpdateColors",
    "NtGdiUnrealizeObject",
    "NtGdiUnmapMemFont",
    "NtGdiUnloadPrinterDriver",
    "NtGdiTransparentBlt",
    "NtGdiTransformPoints",
    "NtGdiScaleRgn",
    "NtGdiScaleValues",
    "NtGdiGetDCDpiScaleValue",
    "NtGdiGetBitmapDpiScaleValue",
    "NtGdiEnsureDpiDepDefaultGuiFontForPlateau",
    "NtGdiSwapBuffers",
    "NtGdiStrokePath",
    "NtGdiStrokeAndFillPath",
    "NtGdiStretchDIBitsInternal",
    "NtGdiStretchBlt",
    "NtGdiStartPage",
    "NtGdiStartDoc",
    "NtGdiSetSizeDevice",
    "NtGdiSetVirtualResolution",
    "NtGdiSetTextJustification",
    "NtGdiSetSystemPaletteUse",
    "NtGdiSetRectRgn",
    "NtGdiSetPixelFormat",
    "NtGdiSetPixel",
    "NtGdiSetOPMSigningKeyAndSequenceNumbers",
    "NtGdiSetLayout",
    "NtGdiMirrorWindowOrg",
    "NtGdiGetDeviceWidth",
    "NtGdiSetMiterLimit",
    "NtGdiSetMetaRgn",
    "NtGdiSetMagicColors",
    "NtGdiSetLinkedUFIs",
    "NtGdiSetIcmMode",
    "NtGdiSetFontXform",
    "NtGdiSetFontEnumeration",
    "NtGdiSetDIBitsToDeviceInternal",
    "NtGdiSetDeviceGammaRamp",
    "NtGdiGetGammaRampCapability",
    "NtGdiSetPrivateDeviceGammaRamp",
    "NtGdiGetAppliedDeviceGammaRamp",
    "NtGdiSetColorSpace",
    "NtGdiSetColorAdjustment",
    "NtGdiSetBrushOrg",
    "NtGdiSetBrushAttributes",
    "NtGdiSetBoundsRect",
    "NtGdiSetBitmapDimension",
    "NtGdiSetBitmapBits",
    "NtGdiSetBitmapAttributes",
    "NtGdiSelectPen",
    "NtGdiSelectFont",
    "NtGdiSelectClipPath",
    "NtGdiSelectBrush",
    "NtGdiSelectBitmap",
    "NtGdiScaleWindowExtEx",
    "NtGdiScaleViewportExtEx",
    "NtGdiSaveDC",
    "NtGdiRoundRect",
    "NtGdiRestoreDC",
    "NtGdiResizePalette",
    "NtGdiResetDC",
    "NtGdiRemoveFontMemResourceEx",
    "NtGdiRemoveFontResourceW",
    "NtGdiRectVisible",
    "NtGdiRectInRegion",
    "NtGdiRectangle",
    "NtGdiQueryFontAssocInfo",
    "NtGdiQueryFonts",
    "NtGdiPtVisible",
    "NtGdiPtInRegion",
    "NtGdiPolyTextOutW",
    "NtGdiPolyPolyDraw",
    "NtGdiPolyDraw",
    "NtGdiPlgBlt",
    "NtGdiPathToRegion",
    "NtGdiPolyPatBlt",
    "NtGdiPatBlt",
    "NtGdiOpenDCW",
    "NtGdiOffsetRgn",
    "NtGdiOffsetClipRgn",
    "NtGdiMoveTo",
    "NtGdiMonoBitmap",
    "NtGdiModifyWorldTransform",
    "NtGdiMaskBlt",
    "NtGdiMakeInfoDC",
    "NtGdiMakeFontDir",
    "NtGdiLineTo",
    "NtGdiInvertRgn",
    "NtGdiIntersectClipRect",
    "NtGdiInitSpool",
    "NtGdiInit",
    "NtGdiIcmBrushInfo",
    "NtGdiHfontCreate",
    "NtGdiGradientFill",
    "NtGdiGetWidthTable",
    "NtGdiGetFontUnicodeRanges",
    "NtGdiAddEmbFontToDC",
    "NtGdiChangeGhostFont",
    "NtGdiGetEmbedFonts",
    "NtGdiGetUFIPathname",
    "NtGdiGetEmbUFI",
    "NtGdiGetUFI",
    "NtGdiGetTransform",
    "NtGdiGetTextMetricsW",
    "NtGdiGetTextFaceW",
    "NtGdiGetTextExtentExW",
    "NtGdiGetTextExtent",
    "NtGdiGetTextCharsetInfo",
    "NtGdiGetSystemPaletteUse",
    "NtGdiGetSuggestedOPMProtectedOutputArraySize",
    "NtGdiGetStringBitmapW",
    "NtGdiGetStats",
    "NtGdiGetSpoolMessage",
    "NtGdiGetServerMetaFileBits",
    "NtGdiGetRgnBox",
    "NtGdiGetRegionData",
    "NtGdiGetRealizationInfo",
    "NtGdiGetRasterizerCaps",
    "NtGdiGetRandomRgn",
    "NtGdiGetPixel",
    "NtGdiGetPath",
    "NtGdiGetOutlineTextMetricsInternalW",
    "NtGdiGetOPMRandomNumber",
    "NtGdiGetObjectBitmapHandle",
    "NtGdiGetNearestPaletteIndex",
    "NtGdiGetNearestColor",
    "NtGdiGetMonitorID",
    "NtGdiGetMiterLimit",
    "NtGdiGetLinkedUFIs",
    "NtGdiGetKerningPairs",
    "NtGdiGetOPMInformation",
    "NtGdiGetGlyphOutline",
    "NtGdiGetGlyphIndicesWInternal",
    "NtGdiGetGlyphIndicesW",
    "NtGdiGetFontResourceInfoInternalW",
    "NtGdiGetFontFileInfo",
    "NtGdiGetFontFileData",
    "NtGdiGetFontData",
    "NtGdiGetEudcTimeStampEx",
    "NtGdiGetETM",
    "NtGdiGetEntry",
    "NtGdiGetDIBitsInternal",
    "NtGdiGetDeviceCapsAll",
    "NtGdiGetDeviceGammaRamp",
    "NtGdiGetDeviceCaps",
    "NtGdiGetDCPoint",
    "NtGdiGetDCObject",
    "NtGdiGetDCforBitmap",
    "NtGdiGetDCDword",
    "NtGdiGetCurrentDpiInfo",
    "NtGdiGetCOPPCompatibleOPMInformation",
    "NtGdiGetColorSpaceforBitmap",
    "NtGdiGetColorAdjustment",
    "NtGdiGetCharWidthInfo",
    "NtGdiGetCharWidthW",
    "NtGdiGetCharSet",
    "NtGdiGetCharacterPlacementW",
    "NtGdiGetCharABCWidthsW",
    "NtGdiGetCertificateSize",
    "NtGdiGetCertificate",
    "NtGdiGetCertificateSizeByHandle",
    "NtGdiGetCertificateByHandle",
    "NtGdiGetBoundsRect",
    "NtGdiGetBitmapDimension",
    "NtGdiGetBitmapBits",
    "NtGdiGetAppClipBox",
    "NtGdiGetAndSetDCDword",
    "NtGdiFullscreenControl",
    "NtGdiFrameRgn",
    "NtGdiForceUFIMapping",
    "NtGdiFlush",
    "NtGdiFlattenPath",
    "NtGdiFillRgn",
    "NtGdiFillPath",
    "NtGdiExtTextOutW",
    "NtGdiExtSelectClipRgn",
    "NtGdiExtGetObjectW",
    "NtGdiExtFloodFill",
    "NtGdiExtEscape",
    "NtGdiExtCreateRegion",
    "NtGdiExtCreatePen",
    "NtGdiExcludeClipRect",
    "NtGdiEudcLoadUnloadLink",
    "NtGdiEqualRgn",
    "NtGdiEnumObjects",
    "NtGdiEnumFonts",
    "NtGdiEndPath",
    "NtGdiEndPage",
    "NtGdiEndGdiRendering",
    "NtGdiEndDoc",
    "NtGdiEnableEudc",
    "NtGdiEllipse",
    "NtGdiDrawEscape",
    "NtGdiDoPalette",
    "NtGdiDoBanding",
    "NtGdiGetPerBandInfo",
    "NtGdiDestroyOPMProtectedOutput",
    "NtGdiDescribePixelFormat",
    "NtGdiDeleteObjectApp",
    "NtGdiDeleteColorTransform",
    "NtGdiDeleteColorSpace",
    "NtGdiDeleteClientObj",
    "NtGdiCreateSolidBrush",
    "NtGdiCreateServerMetaFile",
    "NtGdiCreateRoundRectRgn",
    "NtGdiCreateRectRgn",
    "NtGdiCreatePen",
    "NtGdiCreatePatternBrushInternal",
    "NtGdiCreatePaletteInternal",
    "NtGdiCreateOPMProtectedOutputs",
    "NtGdiCreateOPMProtectedOutput",
    "NtGdiCreateMetafileDC",
    "NtGdiCreateHatchBrushInternal",
    "NtGdiCreateHalftonePalette",
    "NtGdiCreateEllipticRgn",
    "NtGdiCreateSessionMappedDIBSection",
    "NtGdiCreateDIBSection",
    "NtGdiCreateDIBitmapInternal",
    "NtGdiCreateDIBBrush",
    "NtGdiCreateCompatibleDC",
    "NtGdiCreateCompatibleBitmap",
    "NtGdiCreateColorTransform",
    "NtGdiCreateColorSpace",
    "NtGdiCreateClientObj",
    "NtGdiCreateBitmapFromDxSurface2",
    "NtGdiCreateBitmapFromDxSurface",
    "NtGdiCreateBitmap",
    "NtGdiConvertMetafileRect",
    "NtGdiConfigureOPMProtectedOutput",
    "NtGdiComputeXformCoefficients",
    "NtGdiCombineTransform",
    "NtGdiCombineRgn",
    "NtGdiColorCorrectPalette",
    "NtGdiClearBrushAttributes",
    "NtGdiClearBitmapAttributes",
    "NtGdiCloseFigure",
    "NtGdiCheckBitmapBits",
    "NtGdiCancelDC",
    "NtGdiBitBlt",
    "NtGdiBeginPath",
    "NtGdiBeginGdiRendering",
    "NtGdiArcInternal",
    "NtGdiFontIsLinked",
    "NtGdiAnyLinkedFonts",
    "NtGdiAngleArc",
    "NtGdiAlphaBlend",
    "NtGdiAddRemoteMMInstanceToDC",
    "NtGdiRemoveMergeFont",
    "NtGdiAddFontMemResourceEx",
    "NtGdiAddRemoteFontToDC",
    "NtGdiAddFontResourceW",
    "NtGdiAbortPath",
    "NtGdiAbortDoc",
    "NtUserDefSetText",
    "NtUserDeferWindowPosAndBand",
    "NtUserDdeInitialize",
    "NtUserCanBrokerForceForeground",
    "NtUserCreateWindowStation",
    "NtUserCreateWindowEx",
    "NtUserCreateLocalMemHandle",
    "NtUserCreateInputContext",
    "NtUserCreateDesktopEx",
    "NtUserCreateCaret",
    "NtUserCreateAcceleratorTable",
    "NtUserCountClipboardFormats",
    "NtUserCopyAcceleratorTable",
    "NtUserConvertMemHandle",
    "NtUserConsoleControl",
    "NtUserCloseWindowStation",
    "NtUserCloseDesktop",
    "NtUserCloseClipboard",
    "NtUserClipCursor",
    "NtUserChildWindowFromPointEx",
    "NtUserCheckMenuItem",
    "NtUserCheckWindowThreadDesktop",
    "NtUserDwmValidateWindow",
    "NtUserCheckAccessForIntegrityLevel",
    "NtUserDisplayConfigSetDeviceInfo",
    "NtUserDisplayConfigGetDeviceInfo",
    "NtUserQueryDisplayConfig",
    "NtUserSetDisplayConfig",
    "NtUserFunctionalizeDisplayConfig",
    "NtUserGetDisplayConfigBufferSizes",
    "NtUserChangeDisplaySettings",
    "NtUserChangeClipboardChain",
    "NtUserCallTwoParam",
    "NtUserCallOneParam",
    "NtUserCallNoParam",
    "NtUserCallNextHookEx",
    "NtUserCallMsgFilter",
    "NtUserCallHwndParamLock",
    "NtUserCallHwndParam",
    "NtUserCallHwndOpt",
    "NtUserCallHwndLock",
    "NtUserCallHwnd",
    "NtUserBroadcastThemeChangeEvent",
    "NtUserBuildPropList",
    "NtUserBuildNameList",
    "NtUserBuildHwndList",
    "NtUserBuildHimcList",
    "NtUserBlockInput",
    "NtUserBitBltSysBmp",
    "NtUserBeginPaint",
    "NtUserAttachThreadInput",
    "NtUserAssociateInputContext",
    "NtUserAlterWindowStyle",
    "NtUserAddClipboardFormatListener",
    "NtUserActivateKeyboardLayout",
    "NtUserDelegateCapturePointers",
    "NtUserDelegateInput",
    "NtUserDispatchMessage",
    "NtUserDisableProcessWindowFiltering",
    "NtUserDisableThreadIme",
    "NtUserDestroyWindow",
    "NtUserDestroyMenu",
    "NtUserDestroyInputContext",
    "NtUserDestroyCursor",
    "NtUserDestroyAcceleratorTable",
    "NtUserDeleteMenu",
    "NtUserDoSoundDisconnect",
    "NtUserDoSoundConnect",
    "NtUserGhostWindowFromHungWindow",
    "NtUserGetWOWClass",
    "NtUserGetWindowPlacement",
    "NtUserGetWindowDisplayAffinity",
    "NtUserGetWindowDC",
    "NtUserGetWindowCompositionAttribute",
    "NtUserGetWindowCompositionInfo",
    "NtUserGetWindowBand",
    "NtUserGetUpdateRgn",
    "NtUserGetUpdateRect",
    "NtUserGetUpdatedClipboardFormats",
    "NtUserGetTopLevelWindow",
    "NtUserGetTitleBarInfo",
    "NtUserGetThreadState",
    "NtUserGetThreadDesktop",
    "NtUserGetSystemMenu",
    "NtUserGetScrollBarInfo",
    "NtUserGetRegisteredRawInputDevices",
    "NtUserGetRawInputDeviceList",
    "NtUserGetRawInputDeviceInfo",
    "NtUserGetRawInputData",
    "NtUserGetRawInputBuffer",
    "NtUserGetActiveProcessesDpis",
    "NtUserGetDpiForCurrentProcess",
    "NtUserGetProcessDpiAwarenessContext",
    "NtUserGetProcessWindowStation",
    "NtUserGetPriorityClipboardFormat",
    "NtUserGetOpenClipboardWindow",
    "NtUserGetObjectInformation",
    "NtUserGetMouseMovePointsEx",
    "NtUserGetMessage",
    "NtUserGetMenuItemRect",
    "NtUserGetMenuIndex",
    "NtUserGetMenuBarInfo",
    "NtUserGetListBoxInfo",
    "NtUserGetKeyState",
    "NtUserGetKeyNameText",
    "NtUserGetKeyboardState",
    "NtUserGetKeyboardLayoutName",
    "NtUserGetKeyboardLayoutList",
    "NtUserGetInternalWindowPos",
    "NtUserGetInputLocaleInfo",
    "NtUserGetImeInfoEx",
    "NtUserGetImeHotKey",
    "NtUserGetIconSize",
    "NtUserGetIconInfo",
    "NtUserGetGUIThreadInfo",
    "NtUserGetGuiResources",
    "NtUserGetForegroundWindow",
    "NtUserGetDoubleClickTime",
    "NtUserGetDesktopID",
    "NtUserGetDCEx",
    "NtUserGetDC",
    "NtUserGetCursorInfo",
    "NtUserGetCursorFrameInfo",
    "NtUserGetCurrentInputMessageSource",
    "NtUserGetCIMSSM",
    "NtUserGetCPD",
    "NtUserGetControlColor",
    "NtUserGetControlBrush",
    "NtUserGetComboBoxInfo",
    "NtUserGetClipCursor",
    "NtUserGetClipboardViewer",
    "NtUserGetClipboardSequenceNumber",
    "NtUserGetClipboardOwner",
    "NtUserGetClipboardFormatName",
    "NtUserGetClipboardData",
    "NtUserGetClassName",
    "NtUserGetClassInfoEx",
    "NtUserGetCaretPos",
    "NtUserGetCaretBlinkTime",
    "NtUserGetAtomName",
    "NtUserGetAsyncKeyState",
    "NtUserGetAppImeLevel",
    "NtUserGetAncestor",
    "NtUserGetAltTabInfo",
    "NtUserFrostCrashedWindow",
    "NtUserFlashWindowEx",
    "NtUserFindWindowEx",
    "NtUserFindExistingCursorIcon",
    "NtUserFillWindow",
    "NtUserExcludeUpdateRgn",
    "NtUserEvent",
    "NtUserEnumDisplaySettings",
    "NtUserEnumDisplayMonitors",
    "NtUserEnumDisplayDevices",
    "NtUserEndPaint",
    "NtUserEndMenu",
    "NtUserEndDeferWindowPosEx",
    "NtUserEnableScrollBar",
    "NtUserEnableMenuItem",
    "NtUserEmptyClipboard",
    "NtUserDrawMenuBarTemp",
    "NtUserDrawIconEx",
    "NtUserDrawCaptionTemp",
    "NtUserDrawCaption",
    "NtUserDrawAnimatedRects",
    "NtUserDragObject",
    "NtUserDragDetect",
    "NtUserHandleDelegatedInput",
    "NtUserInheritWindowMonitor",
    "NtUserRealChildWindowFromPoint",
    "NtUserQueryWindow",
    "NtUserQuerySendMessage",
    "NtUserQueryInputContext",
    "NtUserQueryInformationThread",
    "NtUserQueryBSDRWindow",
    "NtUserPerMonitorDPIPhysicalToLogicalPoint",
    "NtUserProcessConnect",
    "NtUserPrintWindow",
    "NtUserPostThreadMessage",
    "NtUserPostMessage",
    "NtUserPhysicalToLogicalPoint",
    "NtUserPeekMessage",
    "NtUserPaintMonitor",
    "NtUserPaintDesktop",
    "NtUserOpenWindowStation",
    "NtUserOpenThreadDesktop",
    "NtUserOpenInputDesktop",
    "NtUserOpenDesktop",
    "NtUserOpenClipboard",
    "NtUserNotifyWinEvent",
    "NtUserNotifyProcessCreate",
    "NtUserNotifyIMEStatus",
    "NtUserMoveWindow",
    "NtUserModifyUserStartupInfoFlags",
    "NtUserMNDragOver",
    "NtUserMNDragLeave",
    "NtUserMinMaximize",
    "NtUserMessageCall",
    "NtUserMenuItemFromPoint",
    "NtUserMapVirtualKeyEx",
    "NtUserLayoutCompleted",
    "NtUserLogicalToPerMonitorDPIPhysicalPoint",
    "NtUserLogicalToPhysicalPoint",
    "NtUserLockCursor",
    "NtUserLockWorkStation",
    "NtUserLockWindowUpdate",
    "NtUserLockWindowStation",
    "NtUserLoadKeyboardLayoutEx",
    "NtUserKillTimer",
    "NtUserIsTopLevelWindow",
    "NtUserIsClipboardFormatAvailable",
    "NtUserInvalidateRgn",
    "NtUserInvalidateRect",
    "NtUserInternalGetWindowIcon",
    "NtUserInternalGetWindowText",
    "NtUserInitTask",
    "NtUserInitializeClientPfnArrays",
    "NtUserInitialize",
    "NtUserImpersonateDdeClientWindow",
    "NtUserHungWindowFromGhostWindow",
    "NtUserHiliteMenuItem",
    "NtUserHideCaret",
    "NtUserHardErrorControl",
    "NtUserRealInternalGetMessage",
    "NtUserRealWaitMessageEx",
    "NtUserReleaseDwmHitTestWaiters",
    "NtUserReleaseDC",
    "NtUserTranslateMessage",
    "NtUserTranslateAccelerator",
    "NtUserPaintMenuBar",
    "NtUserCalcMenuBar",
    "NtUserCalculatePopupWindowPosition",
    "NtUserTrackPopupMenuEx",
    "NtUserTrackMouseEvent",
    "NtUserToUnicodeEx",
    "NtUserThunkedMenuItemInfo",
    "NtUserThunkedMenuInfo",
    "NtUserTestForInteractiveUser",
    "NtUserSendEventMessage",
    "NtUserSystemParametersInfo",
    "NtUserSystemParametersInfoForDpi",
    "NtUserSwitchDesktop",
    "NtUserSoundSentry",
    "NtUserShutdownReasonDestroy",
    "NtUserShutdownBlockReasonQuery",
    "NtUserShutdownBlockReasonCreate",
    "NtUserShowWindowAsync",
    "NtUserShowWindow",
    "NtUserShowScrollBar",
    "NtUserShowCaret",
    "NtUserShowCursor",
    "NtUserSetWinEventHook",
    "NtUserSetWindowWord",
    "NtUserSetWindowStationUser",
    "NtUserSetWindowsHookEx",
    "NtUserSetWindowsHookAW",
    "NtUserSetWindowRgnEx",
    "NtUserGetWindowRgnEx",
    "NtUserSetWindowRgn",
    "NtUserSetWindowPos",
    "NtUserSetWindowPlacement",
    "NtUserSetWindowLong",
    "NtUserSetWindowFNID",
    "NtUserSetWindowDisplayAffinity",
    "NtUserSetWindowCompositionTransition",
    "NtUserUpdateDefaultDesktopThumbnail",
    "NtUserSetWindowCompositionAttribute",
    "NtUserSetWindowBand",
    "NtUserSetProcessUIAccessZorder",
    "NtUserSetProcessDpiAwarenessContext",
    "NtUserEnableChildWindowDpiMessage",
    "NtUserIsChildWindowDpiMessageEnabled",
    "NtUserEnableNonClientDpiScaling",
    "NtUserIsNonClientDpiScalingEnabled",
    "NtUserSetDialogControlDpiChangeBehavior",
    "NtUserIsWindowBroadcastingDpiToChildren",
    "NtUserEnableWindowGDIScaledDpiMessage",
    "NtUserIsWindowGDIScaledDpiMessageEnabled",
    "NtUserSetTargetForResourceBrokering",
    "NtUserSetTimer",
    "NtUserSetThreadState",
    "NtUserSetThreadLayoutHandles",
    "NtUserSetThreadDesktop",
    "NtUserSetThreadInputBlocked",
    "NtUserSetSystemTimer",
    "NtUserSetSystemMenu",
    "NtUserSetSystemCursor",
    "NtUserSetSysColors",
    "NtUserSetShellWindowEx",
    "NtUserSetScrollInfo",
    "NtUserSetProp",
    "NtUserGetProp",
    "NtUserSetProcessWindowStation",
    "NtUserSetParent",
    "NtUserSetObjectInformation",
    "NtUserSetMenuFlagRtoL",
    "NtUserSetMenuDefaultItem",
    "NtUserSetMenuContextHelpId",
    "NtUserSetMenu",
    "NtUserSetKeyboardState",
    "NtUserSetInternalWindowPos",
    "NtUserSetInformationThread",
    "NtUserSetImeOwnerWindow",
    "NtUserSetImeInfoEx",
    "NtUserSetImeHotKey",
    "NtUserSetFocus",
    "NtUserSetCursorIconData",
    "NtUserSetCursorContents",
    "NtUserSetCursor",
    "NtUserSetCursorPos",
    "NtUserSetClipboardViewer",
    "NtUserSetClipboardData",
    "NtUserSetClassWord",
    "NtUserSetClassLong",
    "NtUserSetChildWindowNoActivate",
    "NtUserSetCapture",
    "NtUserSetAppImeLevel",
    "NtUserSetActiveWindow",
    "NtUserSendInput",
    "NtUserSelectPalette",
    "NtUserScrollWindowEx",
    "NtUserScrollDC",
    "NtUserSBGetParms",
    "NtUserResolveDesktopForWOW",
    "NtUserRemoveProp",
    "NtUserRemoveMenu",
    "NtUserRemoveClipboardFormatListener",
    "NtUserRegisterWindowMessage",
    "NtUserRegisterTasklist",
    "NtUserRegisterServicesProcess",
    "NtUserRegisterRawInputDevices",
    "NtUserRegisterHotKey",
    "NtUserRegisterDManipHook",
    "NtUserGetDManipHookInitFunction",
    "NtUserRegisterManipulationThread",
    "NtUserSetManipulationInputTarget",
    "NtUserStopAndEndInertia",
    "NtUserRegisterUserApiHook",
    "NtUserRegisterErrorReportingDialog",
    "NtUserRegisterClassExWOW",
    "NtUserRegisterBSDRWindow",
    "NtUserRedrawWindow",
    "NtUserUndelegateInput",
    "NtUserGetWindowMinimizeRect",
    "NtUserDwmGetRemoteSessionOcclusionEvent",
    "NtUserDwmGetRemoteSessionOcclusionState",
    "NtUserDwmKernelShutdown",
    "NtUserDwmKernelStartup",
    "NtUserCheckProcessSession",
    "NtUserUnregisterSessionPort",
    "NtUserRegisterSessionPort",
    "NtUserCtxDisplayIOCtl",
    "NtUserRemoteStopScreenUpdates",
    "NtUserRemoteRedrawScreen",
    "NtUserRemoteRedrawRectangle",
    "NtUserRemoteConnect",
    "NtUserWaitAvailableMessageEx",
    "NtUserWindowFromPoint",
    "NtUserWindowFromPhysicalPoint",
    "NtUserWindowFromDC",
    "NtUserWaitMessage",
    "NtUserWaitForMsgAndEvent",
    "NtUserWaitForInputIdle",
    "NtUserVkKeyScanEx",
    "NtUserValidateTimerCallback",
    "NtUserValidateRect",
    "NtUserValidateHandleSecure",
    "NtUserUserHandleGrantAccess",
    "NtUserUpdatePerUserSystemParameters",
    "NtUserSetLayeredWindowAttributes",
    "NtUserGetLayeredWindowAttributes",
    "NtUserUpdateLayeredWindow",
    "NtUserUpdateInstance",
    "NtUserUpdateInputContext",
    "NtUserUnregisterHotKey",
    "NtUserUnregisterUserApiHook",
    "NtUserUnregisterClass",
    "NtUserUnlockWindowStation",
    "NtUserUnloadKeyboardLayout",
    "NtUserUnhookWinEvent",
    "NtUserUnhookWindowsHookEx",
    "NtUserGetTouchInputInfo",
    "NtUserIsTouchWindow",
    "NtUserModifyWindowTouchCapability",
    "NtGdiEngStretchBltROP",
    "NtGdiEngTextOut",
    "NtGdiEngTransparentBlt",
    "NtGdiEngGradientFill",
    "NtGdiEngAlphaBlend",
    "NtGdiEngLineTo",
    "NtGdiEngPaint",
    "NtGdiEngStrokeAndFillPath",
    "NtGdiEngFillPath",
    "NtGdiEngStrokePath",
    "NtGdiEngMarkBandingSurface",
    "NtGdiEngPlgBlt",
    "NtGdiEngStretchBlt",
    "NtGdiEngBitBlt",
    "NtGdiEngLockSurface",
    "NtGdiEngUnlockSurface",
    "NtGdiEngEraseSurface",
    "NtGdiEngDeleteSurface",
    "NtGdiEngDeletePalette",
    "NtGdiEngCopyBits",
    "NtGdiEngComputeGlyphSet",
    "NtGdiEngCreatePalette",
    "NtGdiEngCreateDeviceBitmap",
    "NtGdiEngCreateDeviceSurface",
    "NtGdiEngCreateBitmap",
    "NtGdiEngAssociateSurface",
    "NtUserSetWindowFeedbackSetting",
    "NtUserRegisterEdgy",
    "NtUserRegisterShellPTPListener",
    "NtUserGetWindowFeedbackSetting",
    "NtUserHidePointerContactVisualization",
    "NtUserGetTouchValidationStatus",
    "NtUserInitializeTouchInjection",
    "NtUserInjectTouchInput",
    "NtUserRegisterTouchHitTestingWindow",
    "NtUserSetDisplayMapping",
    "NtUserSetCalibrationData",
    "NtUserGetPhysicalDeviceRect",
    "NtUserRegisterTouchPadCapable",
    "NtUserGetRawPointerDeviceData",
    "NtUserGetPointerDeviceCursors",
    "NtUserGetPointerDeviceRects",
    "NtUserRegisterPointerDeviceNotifications",
    "NtUserGetPointerDeviceProperties",
    "NtUserGetPointerDevice",
    "NtUserGetPointerDevices",
    "NtUserEnableTouchPad",
    "NtUserGetPrecisionTouchPadConfiguration",
    "NtUserSetPrecisionTouchPadConfiguration",
    "NtUserPromotePointer",
    "NtUserDiscardPointerFrameMessages",
    "NtUserRegisterPointerInputTarget",
    "NtUserGetPointerFrameArrivalTimes",
    "NtUserGetPointerInputTransform",
    "NtUserGetPointerInfoList",
    "NtUserGetPointerCursorId",
    "NtUserGetPointerType",
    "NtUserGetGestureConfig",
    "NtUserSetGestureConfig",
    "NtUserGetGestureExtArgs",
    "NtUserGetGestureInfo",
    "NtUserInjectGesture",
    "NtUserChangeWindowMessageFilterEx",
    "NtGdiXLATEOBJ_hGetColorTransform",
    "NtGdiXLATEOBJ_iXlate",
    "NtGdiXLATEOBJ_cGetPalette",
    "NtGdiEngDeleteClip",
    "NtGdiEngCreateClip",
    "NtGdiEngDeletePath",
    "NtGdiCLIPOBJ_ppoGetPath",
    "NtGdiCLIPOBJ_cEnumStart",
    "NtGdiCLIPOBJ_bEnum",
    "NtGdiBRUSHOBJ_hGetColorTransform",
    "NtGdiBRUSHOBJ_pvGetRbrush",
    "NtGdiBRUSHOBJ_pvAllocRbrush",
    "NtGdiBRUSHOBJ_ulGetBrushColor",
    "NtGdiXFORMOBJ_iGetXform",
    "NtGdiXFORMOBJ_bApplyXform",
    "NtGdiFONTOBJ_pQueryGlyphAttrs",
    "NtGdiFONTOBJ_pfdg",
    "NtGdiFONTOBJ_pifi",
    "NtGdiFONTOBJ_cGetGlyphs",
    "NtGdiFONTOBJ_pxoGetXform",
    "NtGdiFONTOBJ_vGetInfo",
    "NtGdiFONTOBJ_cGetAllGlyphHandles",
    "NtGdiFONTOBJ_pvTrueTypeFontFile",
    "NtGdiSTROBJ_dwGetCodePage",
    "NtGdiSTROBJ_vEnumStart",
    "NtGdiSTROBJ_bGetAdvanceWidths",
    "NtGdiSTROBJ_bEnumPositionsOnly",
    "NtGdiSTROBJ_bEnum",
    "NtGdiPATHOBJ_bEnumClipLines",
    "NtGdiPATHOBJ_vEnumStartClipLines",
    "NtGdiPATHOBJ_vEnumStart",
    "NtGdiPATHOBJ_bEnum",
    "NtGdiPATHOBJ_vGetBounds",
    "NtGdiEngCheckAbort",
    "NtGdiGetDhpdev",
    "NtGdiHT_Get8BPPMaskPalette",
    "NtGdiHT_Get8BPPFormatPalette",
    "NtGdiUpdateTransform",
    "NtGdiUMPDEngFreeUserMem",
    "NtGdiBRUSHOBJ_DeleteRbrush",
    "NtGdiSetPUMPDOBJ",
    "NtGdiSetUMPDSandboxState",
    "NtGdiDrawStream",
    "NtGdiHLSurfSetInformation",
    "NtGdiHLSurfGetInformation",
    "NtGdiDwmCreatedBitmapRemotingOutput",
    "NtGdiDdDDIGetScanLine",
    "NtGdiDdDDIReleaseProcessVidPnSourceOwners",
    "NtGdiDdDDIGetProcessSchedulingPriorityClass",
    "NtGdiDdDDISetProcessSchedulingPriorityClass",
    "NtGdiDdDDIGetContextSchedulingPriority",
    "NtGdiDdDDISetContextSchedulingPriority",
    "NtGdiDdDDIDestroyDCFromMemory",
    "NtGdiDdDDICreateDCFromMemory",
    "NtGdiDdDDIGetDeviceState",
    "NtGdiDdDDISetGammaRamp",
    "NtGdiDdDDIWaitForVerticalBlankEvent",
    "NtGdiDdDDIDestroyOverlay",
    "NtGdiDdDDIFlipOverlay",
    "NtGdiDdDDIUpdateOverlay",
    "NtGdiDdDDICreateOverlay",
    "NtGdiDdDDIGetPresentQueueEvent",
    "NtGdiDdDDIGetPresentHistory",
    "NtGdiDdDDISetVidPnSourceOwner",
    "NtGdiDdDDIQueryStatistics",
    "NtGdiDdDDIEscape",
    "NtGdiDdDDIGetSharedPrimaryHandle",
    "NtGdiDdDDICloseAdapter",
    "NtGdiDdDDIOpenAdapterFromLuid",
    "NtGdiDdDDIEnumAdapters",
    "NtGdiDdDDIEnumAdapters2",
    "NtGdiDdDDIOpenAdapterFromHdc",
    "NtGdiDdDDIOpenAdapterFromDeviceName",
    "NtGdiDdDDIRender",
    "NtGdiDdDDIPresent",
    "NtGdiDdDDIGetMultisampleMethodList",
    "NtGdiDdDDISetDisplayMode",
    "NtGdiDdDDIGetDisplayModeList",
    "NtGdiDdDDIUnlock",
    "NtGdiDdDDILock",
    "NtGdiDdDDIQueryAdapterInfo",
    "NtGdiDdDDIGetRuntimeData",
    "NtGdiDdDDISignalSynchronizationObject",
    "NtGdiDdDDIWaitForSynchronizationObject",
    "NtGdiDdDDIDestroySynchronizationObject",
    "NtGdiDdDDIOpenSynchronizationObject",
    "NtGdiDdDDICreateSynchronizationObject",
    "NtGdiDdDDIDestroyContext",
    "NtGdiDdDDICreateContext",
    "NtGdiDdDDIDestroyDevice",
    "NtGdiDdDDICreateDevice",
    "NtGdiDdDDIQueryAllocationResidency",
    "NtGdiDdDDISetAllocationPriority",
    "NtGdiDdDDIDestroyAllocation",
    "NtGdiDdDDIDestroyAllocation2",
    "NtGdiDdDDIOpenResourceFromNtHandle",
    "NtGdiDdDDIOpenSyncObjectFromNtHandle",
    "NtGdiDdDDIOpenSyncObjectFromNtHandle2",
    "NtGdiDdDDIOpenResource",
    "NtGdiDdDDIOpenNtHandleFromName",
    "NtGdiDdDDIOpenSyncObjectNtHandleFromName",
    "NtGdiDdDDIShareObjects",
    "NtGdiDdDDIQueryResourceInfoFromNtHandle",
    "NtGdiDdDDIQueryResourceInfo",
    "NtGdiDdDDICreateAllocation",
    "NtGdiDdDDIOutputDuplReleaseFrame",
    "NtGdiDdDDIQueryRemoteVidPnSourceFromGdiDisplayName",
    "NtGdiDdDDIOutputDuplPresent",
    "NtGdiDdDDIReleaseKeyedMutex2",
    "NtGdiDdDDIAcquireKeyedMutex2",
    "NtGdiDdDDIOpenKeyedMutex2",
    "NtGdiDdDDICreateKeyedMutex2",
    "NtGdiDdDDIOutputDuplGetPointerShapeData",
    "NtGdiDdDDIOutputDuplGetMetaData",
    "NtGdiDdDDIOutputDuplGetFrameInfo",
    "NtGdiDdDDIDestroyOutputDupl",
    "NtGdiDdDDICreateOutputDupl",
    "NtGdiDdDDIReclaimAllocations",
    "NtGdiDdDDIOfferAllocations",
    "NtGdiDdDDICheckSharedResourceAccess",
    "NtGdiDdDDICheckVidPnExclusiveOwnership",
    "NtGdiDdDDIGetOverlayState",
    "NtGdiDdDDIConfigureSharedResource",
    "NtGdiDdDDIReleaseKeyedMutex",
    "NtGdiDdDDIAcquireKeyedMutex",
    "NtGdiDdDDIDestroyKeyedMutex",
    "NtGdiDdDDIOpenKeyedMutex",
    "NtGdiDdDDICreateKeyedMutex",
    "NtGdiDdDDISharedPrimaryUnLockNotification",
    "NtGdiDdDDISharedPrimaryLockNotification",
    "NtGdiDdDDISetDisplayPrivateDriverFormat",
    "NtGdiDdDDICheckExclusiveOwnership",
    "NtGdiDdDDICheckMonitorPowerState",
    "NtGdiDdDDIWaitForIdle",
    "NtGdiDdDDICheckOcclusion",
    "NtGdiDdDDIInvalidateActiveVidPn",
    "NtGdiDdDDIPollDisplayChildren",
    "NtGdiDdDDISetQueuedLimit",
    "NtGdiDdDDIPinDirectFlipResources",
    "NtGdiDdDDIUnpinDirectFlipResources",
    "NtGdiDdDDIWaitForVerticalBlankEvent2",
    "NtGdiDdDDIGetDWMVerticalBlankEvent",
    "NtGdiDdDDISetSyncRefreshCountWaitTarget",
    "NtGdiDdDDISetContextInProcessSchedulingPriority",
    "NtGdiDdDDIGetContextInProcessSchedulingPriority",
    "NtGdiDdDDIGetSharedResourceAdapterLuid",
    "NtGdiDdDDISetStereoEnabled",
    "NtGdiDdDDIPresentMultiPlaneOverlay",
    "NtGdiDdDDICheckMultiPlaneOverlaySupport",
    "NtGdiDdDDIMakeResident",
    "NtGdiDdDDIEvict",
    "NtGdiDdDDIUpdateAllocationProperty",
    "NtGdiDdDDIWaitForSynchronizationObjectFromCpu",
    "NtGdiDdDDISignalSynchronizationObjectFromCpu",
    "NtGdiDdDDIWaitForSynchronizationObjectFromGpu",
    "NtGdiDdDDISignalSynchronizationObjectFromGpu",
    "NtGdiDdDDISignalSynchronizationObjectFromGpu2",
    "NtGdiDdDDICreatePagingQueue",
    "NtGdiDdDDIDestroyPagingQueue",
    "NtGdiDdDDILock2",
    "NtGdiDdDDIUnlock2",
    "NtGdiDdDDIInvalidateCache",
    "NtGdiDdDDIGetResourcePresentPrivateDriverData",
    "NtGdiDdDDIMapGpuVirtualAddress",
    "NtGdiDdDDIReserveGpuVirtualAddress",
    "NtGdiDdDDIFreeGpuVirtualAddress",
    "NtGdiDdDDIUpdateGpuVirtualAddress",
    "NtGdiDdDDICreateContextVirtual",
    "NtGdiDdDDISubmitCommand",
    "NtGdiDdDDIGetCachedHybridQueryValue",
    "NtGdiDdDDICacheHybridQueryValue",
    "NtGdiDdDDINetDispGetNextChunkInfo",
    "NtGdiDdDDINetDispQueryMiracastDisplayDeviceSupport",
    "NtGdiDdDDINetDispStartMiracastDisplayDevice",
    "NtGdiDdDDINetDispStopMiracastDisplayDevice",
    "NtGdiDdDDINetDispQueryMiracastDisplayDeviceStatus",
    "NtGdiDdDDINetDispStopSessions",
    "NtGdiDdDDIQueryVideoMemoryInfo",
    "NtGdiDdDDIChangeVideoMemoryReservation",
    "NtGdiDdDDICreateSwapChain",
    "NtGdiDdDDIOpenSwapChain",
    "NtGdiDdDDIAddSurfaceToSwapChain",
    "NtGdiDdDDIRemoveSurfaceFromSwapChain",
    "NtGdiDdDDIUnOrderedPresentSwapChain",
    "NtGdiDdDDIGetSetSwapChainMetadata",
    "NtGdiDdDDIAcquireSwapChain",
    "NtGdiDdDDIReleaseSwapChain",
    "NtGdiDdDDIAbandonSwapChain",
    "NtGdiDdDDISetDodIndirectSwapchain",
    "NtGdiDdDDICheckMultiPlaneOverlaySupport2",
    "NtGdiDdDDIPresentMultiPlaneOverlay2",
    "NtGdiDdDDIReclaimAllocations2",
    "NtGdiDdDDISetStablePowerState",
    "NtGdiDdDDIQueryClockCalibration",
    "NtGdiDdDDIQueryVidPnExclusiveOwnership",
    "NtGdiDdDDIAdjustFullscreenGamma",
    "NtGdiDdDDISetVidPnSourceHwProtection",
    "NtGdiDdDDIMarkDeviceAsError",
    "NtGdiDdDDIFlushHeapTransitions",
    "NtGdiDdDDISetHwProtectionTeardownRecovery",
    "NtGdiDdDDIQueryProcessOfferInfo",
    "NtGdiDdDDITrimProcessCommitment",
    "NtGdiDdDDICheckMultiPlaneOverlaySupport3",
    "NtGdiDdDDIPresentMultiPlaneOverlay3",
    "NtGdiDdDDISetFSEBlock",
    "NtGdiDdDDIQueryFSEBlock",
    "NtGdiDdDDICreateHwContext",
    "NtGdiDdDDIDestroyHwContext",
    "NtGdiDdDDICreateHwQueue",
    "NtGdiDdDDIDestroyHwQueue",
    "NtGdiDdDDISubmitCommandToHwQueue",
    "NtGdiDdDDISubmitWaitForSyncObjectsToHwQueue",
    "NtGdiDdDDISubmitSignalSyncObjectsToHwQueue",
    "NtGdiDdDDIGetAllocationPriority",
    "NtGdiDdDDIGetMultiPlaneOverlayCaps",
    "NtGdiDdDDIGetPostCompositionCaps",
    "NtGdiDdDDISetYieldPercentage",
    "NtGdiDdDDISetProcessSchedulingPriorityBand",
    "NtGdiDdDDISetMemoryBudgetTarget",
    "NtGdiDdDDIGetYieldPercentage",
    "NtGdiDdDDIGetProcessSchedulingPriorityBand",
    "NtGdiDdDDIGetMemoryBudgetTarget",
    "NtGdiDdDDIDDisplayEnum",
    "NtGdiDdDDIDispMgrCreate",
    "NtGdiDdDDIDispMgrTargetOperation",
    "NtGdiDdDDIDispMgrSourceOperation",
    "NtGdiDdDDICreateProtectedSession",
    "NtGdiDdDDIDestroyProtectedSession",
    "NtGdiDdDDIQueryProtectedSessionStatus",
    "NtGdiDdDDIQueryProtectedSessionInfoFromNtHandle",
    "NtGdiDdDDIOpenProtectedSessionFromNtHandle",
    "NtGdiDdDDISetMonitorColorSpaceTransform",
    "NtGdiDdDDIPresentRedirected",
    "NtGdiDdDDICreateBundleObject",
    "NtGdiDdDDIExtractBundleObject",
    "NtGdiDdDDISetDeviceLostSupport",
    "NtGdiDdDDIGetProcessDeviceLostSupport",
    "NtGdiMakeObjectUnXferable",
    "NtGdiMakeObjectXferable",
    "NtGdiDestroyPhysicalMonitor",
    "NtGdiGetPhysicalMonitorDescription",
    "NtGdiGetPhysicalMonitors",
    "NtGdiGetNumberOfPhysicalMonitors",
    "NtGdiDDCCIGetTimingReport",
    "NtGdiDDCCIGetCapabilitiesString",
    "NtGdiDDCCIGetCapabilitiesStringLength",
    "NtGdiDDCCISaveCurrentSettings",
    "NtGdiDDCCISetVCPFeature",
    "NtGdiDDCCIGetVCPFeature",
    "NtGdiDdQueryVisRgnUniqueness",
    "NtGdiDdDestroyFullscreenSprite",
    "NtGdiDdNotifyFullscreenSpriteUpdate",
    "NtGdiDdCreateFullscreenSprite",
    "NtGdiGetProcessSessionFonts",
    "NtGdiGetPublicFontTableChangeCookie",
    "NtGdiAddInitialFonts",
    "NtUserShowSystemCursor",
    "NtUserSetMirrorRendering",
    "NtUserSetDesktopColorTransform",
    "NtUserMagGetContextInformation",
    "NtUserMagSetContextInformation",
    "NtUserMagControl",
    "NtUserSlicerControl",
    "NtUserHwndSetRedirectionInfo",
    "NtUserHwndQueryRedirectionInfo",
    "NtCreateCompositionSurfaceHandle",
    "NtValidateCompositionSurfaceHandle",
    "NtBindCompositionSurface",
    "NtUnBindCompositionSurface",
    "NtQueryCompositionSurfaceBinding",
    "NtNotifyPresentToCompositionSurface",
    "NtQueryCompositionSurfaceStatistics",
    "NtOpenCompositionSurfaceSectionInfo",
    "NtOpenCompositionSurfaceSwapChainHandleInfo",
    "NtQueryCompositionSurfaceRenderingRealization",
    "NtOpenCompositionSurfaceDirtyRegion",
    "NtQueryCompositionSurfaceHDRMetaData",
    "NtSetCompositionSurfaceHDRMetaData",
    "NtSetCompositionSurfaceDirectFlipState",
    "NtSetCompositionSurfaceStatistics",
    "NtSetCompositionSurfaceBufferUsage",
    "NtSetCompositionSurfaceIndependentFlipInfo",
    "NtDesktopCaptureBits",
    "NtDCompositionEnableMMCSS",
    "NtVisualCaptureBits",
    "NtDCompositionEnableDDASupport",
    "NtDCompositionCreateSharedVisualHandle",
    "NtCreateCompositionInputSink",
    "NtCreateImplicitCompositionInputSink",
    "NtDuplicateCompositionInputSink",
    "NtQueryCompositionInputSink",
    "NtQueryCompositionInputSinkLuid",
    "NtQueryCompositionInputSinkViewId",
    "NtUpdateInputSinkTransforms",
    "NtCompositionInputThread",
    "NtQueryCompositionInputQueueAndTransform",
    "NtQueryCompositionInputIsImplicit",
    "NtCompositionSetDropTarget",
    "NtTokenManagerOpenSectionAndEvents",
    "NtTokenManagerThread",
    "NtTokenManagerCreateCompositionTokenHandle",
    "NtTokenManagerGetAnalogExclusiveTokenEvent",
    "NtTokenManagerGetAnalogExclusiveSurfaceUpdates",
    "NtTokenManagerConfirmOutstandingAnalogToken",
    "NtSetCompositionSurfaceAnalogExclusive",
    "NtDCompositionBeginFrame",
    "NtDCompositionConfirmFrame",
    "NtDCompositionRetireFrame",
    "NtDCompositionDiscardFrame",
    "NtDCompositionGetFrameSurfaceUpdates",
    "NtDCompositionGetFrameLegacyTokens",
    "NtDCompositionDestroyConnection",
    "NtDCompositionGetConnectionBatch",
    "NtDCompositionGetFrameStatistics",
    "NtDCompositionGetDeletedResources",
    "NtDCompositionCreateConnection",
    "NtDCompositionDestroyChannel",
    "NtDCompositionReleaseAllResources",
    "NtDCompositionSubmitDWMBatch",
    "NtDCompositionProcessChannelBatchBuffer",
    "NtDCompositionCommitChannel",
    "NtDCompositionWaitForChannel",
    "NtDCompositionSetChannelCommitCompletionEvent",
    "NtDCompositionTelemetryTouchInteractionBegin",
    "NtDCompositionTelemetryTouchInteractionUpdate",
    "NtDCompositionTelemetryTouchInteractionEnd",
    "NtDCompositionTelemetrySetApplicationId",
    "NtDCompositionTelemetryAnimationScenarioBegin",
    "NtDCompositionTelemetryAnimationScenarioReference",
    "NtDCompositionTelemetryAnimationScenarioUnreference",
    "NtDCompositionCurrentBatchId",
    "NtDCompositionRemoveCrossDeviceVisualChild",
    "NtDCompositionAddCrossDeviceVisualChild",
    "NtDCompositionCreateDwmChannel",
    "NtDCompositionCreateChannel",
    "NtDCompositionSynchronize",
    "NtDCompositionReferenceSharedResourceOnDwmChannel",
    "NtDCompositionCreateAndBindSharedSection",
    "NtDCompositionSetDebugCounter",
    "NtDCompositionGetChannels",
    "NtDCompositionConnectPipe",
    "NtDCompositionRegisterThumbnailVisual",
    "NtDCompositionRegisterVirtualDesktopVisual",
    "NtDCompositionDuplicateHandleToProcess",
    "NtDCompositionUpdatePointerCapture",
    "NtDCompositionSetChannelCallbackId",
    "NtDCompositionDuplicateSwapchainHandleToDwm",
    "NtDCompositionSetChildRootVisual",
    "NtDCompositionCommitSynchronizationObject",
    "NtFlipObjectCreate",
    "NtFlipObjectOpen",
    "NtFlipObjectAddPoolBuffer",
    "NtFlipObjectRemovePoolBuffer",
    "NtUserDestroyDCompositionHwndTarget",
    "NtUserCreateDCompositionHwndTarget",
    "NtUserCreateEmptyCursorObject",
    "NtUserWaitForRedirectionStartComplete",
    "NtUserWOWCleanup",
    "NtUserSignalRedirectionStartComplete",
    "NtUserEnableWindowResizeOptimization",
    "NtUserGetResizeDCompositionSynchronizationObject",
    "NtUserEnableResizeLayoutSynchronization",
    "NtUserBeginLayoutUpdate",
    "NtUserIsResizeLayoutSynchronizationEnabled",
    "NtUserConfirmResizeCommit",
    "NtUserSetActiveProcessForMonitor",
    "NtUserGetDisplayAutoRotationPreferencesByProcessId",
    "NtUserGetDisplayAutoRotationPreferences",
    "NtUserSetDisplayAutoRotationPreferences",
    "NtUserSetAutoRotation",
    "NtUserGetAutoRotationState",
    "NtUserAutoRotateScreen",
    "NtUserAcquireIAMKey",
    "NtUserSetActivationFilter",
    "NtUserSetFallbackForeground",
    "NtUserSetBrokeredForeground",
    "NtUserDisableImmersiveOwner",
    "NtUserClearForeground",
    "NtUserEnableIAMAccess",
    "NtUserGetProcessUIContextInformation",
    "NtUserSetProcessRestrictionExemption",
    "NtUserSetWindowArrangement",
    "NtUserSetWindowShowState",
    "NtUserUpdateWindowTrackingInfo",
    "NtUserEnableMouseInPointer",
    "NtUserIsMouseInPointerEnabled",
    "NtUserPromoteMouseInPointer",
    "NtUserAutoPromoteMouseInPointer",
    "NtUserEnableMouseInputForCursorSuppression",
    "NtUserIsMouseInputEnabled",
    "NtUserCheckProcessForClipboardAccess",
    "NtUserGetClipboardAccessToken",
    "NtUserGetQueueStatusReadonly",
    "NtUserCompositionInputSinkLuidFromPoint",
    "NtUserCompositionInputSinkViewInstanceIdFromPoint",
    "NtUserUpdateWindowInputSinkHints",
    "NtUserTransformPoint",
    "NtUserTransformRect",
    "NtUserGetHimetricScaleFactorFromPixelLocation",
    "NtUserGetHDevName",
    "NtUserGetDpiForMonitor",
    "NtUserReportInertia",
    "NtUserLinkDpiCursor",
    "NtUserGetCursorDims",
    "NtUserGetCursor",
    "NtUserInitializeInputDeviceInjection",
    "NtUserInitializeGenericHidInjection",
    "NtUserInitializePointerDeviceInjection",
    "NtUserRemoveInjectionDevice",
    "NtUserSetFeatureReportResponse",
    "NtUserInjectDeviceInput",
    "NtUserInjectMouseInput",
    "NtUserInjectKeyboardInput",
    "NtUserInjectPointerInput",
    "NtUserInjectGenericHidInput",
    "NtUserInitializePointerDeviceInjectionEx",
    "NtRIMRegisterForInput",
    "NtRIMReadInput",
    "NtRIMGetDevicePreparsedData",
    "NtRIMGetDeviceProperties",
    "NtRIMAreSiblingDevices",
    "NtRIMFreeInputBuffer",
    "NtRIMOnPnpNotification",
    "NtRIMOnTimerNotification",
    "NtRIMDeviceIoControl",
    "NtRIMUnregisterForInput",
    "NtRIMSetTestModeStatus",
    "NtRIMGetPhysicalDeviceRect",
    "NtRIMGetSourceProcessId",
    "NtRIMAddInputObserver",
    "NtRIMRemoveInputObserver",
    "NtRIMUpdateInputObserverRegistration",
    "NtRIMObserveNextInput",
    "NtRIMGetDevicePreparsedDataLockfree",
    "NtRIMGetDevicePropertiesLockfree",
    "NtRIMEnableMonitorMappingForDevice",
    "NtUserSetCoreWindow",
    "NtUserSetCoreWindowPartner",
    "NtUserNavigateFocus",
    "NtHWCursorUpdatePointer",
    "NtUserAcquireInteractiveControlBackgroundAccess",
    "NtUserGetInteractiveControlInfo",
    "NtUserGetInteractiveControlDeviceInfo",
    "NtUserSendInteractiveControlHapticsReport",
    "NtUserSetInteractiveControlFocus",
    "NtUserInteractiveControlQueryUsage",
    "NtUserSetInteractiveCtrlRotationAngle",
    "NtUserGetInteractiveCtrlSupportedWaveforms",
    "NtUserProcessInkFeedbackCommand",
    "NtUserSetProcessInteractionFlags",
    "NtMITActivateInputProcessing",
    "NtMITWaitForMultipleObjectsEx",
    "NtMITDeactivateInputProcessing",
    "NtMITSetInputCallbacks",
    "NtMITCoreMsgKGetConnectionHandle",
    "NtMITCoreMsgKSend",
    "NtMITCoreMsgKOpenConnectionTo",
    "NtMITUpdateInputGlobals",
    "NtMITBindInputTypeToMonitors",
    "NtMITEnableMouseIntercept",
    "NtMITDisableMouseIntercept",
    "NtMITSynthesizeTouchInput",
    "NtMITSynthesizeMouseInput",
    "NtMITSynthesizeMouseWheel",
    "NtMITGetCursorUpdateHandle",
    "NtDWMSetInputSystemOutputConfig",
    "NtDWMCommitInputSystemOutputConfig",
    "NtDWMBindCursorToOutputConfig",
    "NtDWMSetCursorOrientation",
    "NtUserMsgWaitForMultipleObjectsEx"
};

//////////////////////////////////////////////////////////////////////////
// Windows 10 RS3 _W32pServiceTableFilter
//////////////////////////////////////////////////////////////////////////
static const char* W32pServiceTableFilter_Win10Rs3_x86[] = {
    "_stub_UserGetOwnerTransformedMonitorRect",
    "_stub_UserYieldTask",
    "_stub_UserSetSensorPresence",
    "_stub_GdiWidenPath",
    "_stub_GdiUpdateColors",
    "_stub_GdiUnrealizeObject",
    "_stub_GdiUnmapMemFont",
    "_stub_GdiUnloadPrinterDriver",
    "_stub_GdiTransparentBlt",
    "_stub_GdiTransformPoints",
    "_stub_GdiScaleRgn",
    "_stub_GdiScaleValues",
    "_stub_GdiGetDCDpiScaleValue",
    "_stub_GdiGetBitmapDpiScaleValue",
    "_stub_GdiEnsureDpiDepDefaultGuiFontForPlateau",
    "_stub_GdiSwapBuffers",
    "_stub_GdiStrokePath",
    "_stub_GdiStrokeAndFillPath",
    "_stub_GdiStretchDIBitsInternal",
    "_stub_GdiStretchBlt",
    "_stub_GdiStartPage",
    "_stub_GdiStartDoc",
    "_stub_GdiSetSizeDevice",
    "_stub_GdiSetVirtualResolution",
    "_stub_GdiSetTextJustification",
    "_stub_GdiSetSystemPaletteUse",
    "_stub_GdiSetRectRgn",
    "_stub_GdiSetPixelFormat",
    "_stub_GdiSetPixel",
    "_stub_GdiSetOPMSigningKeyAndSequenceNumbers",
    "_stub_GdiSetLayout",
    "_stub_GdiMirrorWindowOrg",
    "_stub_GdiGetDeviceWidth",
    "_stub_GdiSetMiterLimit",
    "_stub_GdiSetMetaRgn",
    "_stub_GdiSetMagicColors",
    "_stub_GdiSetLinkedUFIs",
    "_stub_GdiSetIcmMode",
    "_stub_GdiSetFontXform",
    "_stub_GdiSetFontEnumeration",
    "_stub_GdiSetDIBitsToDeviceInternal",
    "_stub_GdiSetDeviceGammaRamp",
    "_stub_GdiGetGammaRampCapability",
    "_stub_GdiSetPrivateDeviceGammaRamp",
    "_stub_GdiGetAppliedDeviceGammaRamp",
    "_stub_GdiSetColorSpace",
    "_stub_GdiSetColorAdjustment",
    "_stub_GdiSetBrushOrg",
    "_stub_GdiSetBrushAttributes",
    "_stub_GdiSetBoundsRect",
    "_stub_GdiSetBitmapDimension",
    "_stub_GdiSetBitmapBits",
    "_stub_GdiSetBitmapAttributes",
    "_stub_GdiSelectPen",
    "_stub_GdiSelectFont",
    "_stub_GdiSelectClipPath",
    "_stub_GdiSelectBrush",
    "_stub_GdiSelectBitmap",
    "_stub_GdiScaleWindowExtEx",
    "_stub_GdiScaleViewportExtEx",
    "_stub_GdiSaveDC",
    "_stub_GdiRoundRect",
    "_stub_GdiRestoreDC",
    "_stub_GdiResizePalette",
    "_stub_GdiResetDC",
    "_stub_GdiRemoveFontMemResourceEx",
    "_stub_GdiRemoveFontResourceW",
    "_stub_GdiRectVisible",
    "_stub_GdiRectInRegion",
    "_stub_GdiRectangle",
    "_stub_GdiQueryFontAssocInfo",
    "_stub_GdiQueryFonts",
    "_stub_GdiPtVisible",
    "_stub_GdiPtInRegion",
    "_stub_GdiPolyTextOutW",
    "_stub_GdiPolyPolyDraw",
    "_stub_GdiPolyDraw",
    "_stub_GdiPlgBlt",
    "_stub_GdiPathToRegion",
    "_stub_GdiPolyPatBlt",
    "_stub_GdiPatBlt",
    "_stub_GdiOpenDCW",
    "_stub_GdiOffsetRgn",
    "_stub_GdiOffsetClipRgn",
    "_stub_GdiMoveTo",
    "_stub_GdiMonoBitmap",
    "_stub_GdiModifyWorldTransform",
    "_stub_GdiMaskBlt",
    "_stub_GdiMakeInfoDC",
    "_stub_GdiMakeFontDir",
    "_stub_GdiLineTo",
    "_stub_GdiInvertRgn",
    "_stub_GdiIntersectClipRect",
    "_stub_GdiInitSpool",
    "_stub_GdiInit",
    "_stub_GdiIcmBrushInfo",
    "_stub_GdiHfontCreate",
    "_stub_GdiGradientFill",
    "_stub_GdiGetWidthTable",
    "_stub_GdiGetFontUnicodeRanges",
    "_stub_GdiAddEmbFontToDC",
    "_stub_GdiChangeGhostFont",
    "_stub_GdiGetEmbedFonts",
    "_stub_GdiGetUFIPathname",
    "_stub_GdiGetEmbUFI",
    "_stub_GdiGetUFI",
    "_stub_GdiGetTransform",
    "_stub_GdiGetTextMetricsW",
    "_stub_GdiGetTextFaceW",
    "_stub_GdiGetTextExtentExW",
    "_stub_GdiGetTextExtent",
    "_stub_GdiGetTextCharsetInfo",
    "_stub_GdiGetSystemPaletteUse",
    "_stub_GdiGetSuggestedOPMProtectedOutputArraySize",
    "_stub_GdiGetStringBitmapW",
    "_stub_GdiGetStats",
    "_stub_GdiGetSpoolMessage",
    "_stub_GdiGetServerMetaFileBits",
    "_stub_GdiGetRgnBox",
    "_stub_GdiGetRegionData",
    "_stub_GdiGetRealizationInfo",
    "_stub_GdiGetRasterizerCaps",
    "_stub_GdiGetRandomRgn",
    "_stub_GdiGetPixel",
    "_stub_GdiGetPath",
    "_stub_GdiGetOutlineTextMetricsInternalW",
    "_stub_GdiGetOPMRandomNumber",
    "_stub_GdiGetObjectBitmapHandle",
    "_stub_GdiGetNearestPaletteIndex",
    "_stub_GdiGetNearestColor",
    "_stub_GdiGetMonitorID",
    "_stub_GdiGetMiterLimit",
    "_stub_GdiGetLinkedUFIs",
    "_stub_GdiGetKerningPairs",
    "_stub_GdiGetOPMInformation",
    "_stub_GdiGetGlyphOutline",
    "_stub_GdiGetGlyphIndicesWInternal",
    "_stub_GdiGetGlyphIndicesW",
    "_stub_GdiGetFontResourceInfoInternalW",
    "_stub_GdiGetFontFileInfo",
    "_stub_GdiGetFontFileData",
    "_stub_GdiGetFontData",
    "_stub_GdiGetEudcTimeStampEx",
    "_stub_GdiGetETM",
    "_stub_GdiGetEntry",
    "_stub_GdiGetDIBitsInternal",
    "_stub_GdiGetDeviceCapsAll",
    "_stub_GdiGetDeviceGammaRamp",
    "_stub_GdiGetDeviceCaps",
    "_stub_GdiGetDCPoint",
    "_stub_GdiGetDCObject",
    "_stub_GdiGetDCforBitmap",
    "_stub_GdiGetDCDword",
    "_stub_GdiGetCurrentDpiInfo",
    "_stub_GdiGetCOPPCompatibleOPMInformation",
    "_stub_GdiGetColorSpaceforBitmap",
    "_stub_GdiGetColorAdjustment",
    "_stub_GdiGetCharWidthInfo",
    "_stub_GdiGetCharWidthW",
    "_stub_GdiGetCharSet",
    "_stub_GdiGetCharacterPlacementW",
    "_stub_GdiGetCharABCWidthsW",
    "_stub_GdiGetCertificateSize",
    "_stub_GdiGetCertificate",
    "_stub_GdiGetCertificateSizeByHandle",
    "_stub_GdiGetCertificateByHandle",
    "_stub_GdiGetBoundsRect",
    "_stub_GdiGetBitmapDimension",
    "_stub_GdiGetBitmapBits",
    "_stub_GdiGetAppClipBox",
    "_stub_GdiGetAndSetDCDword",
    "_stub_GdiFullscreenControl",
    "_stub_GdiFrameRgn",
    "_stub_GdiForceUFIMapping",
    "_stub_GdiFlush",
    "_stub_GdiFlattenPath",
    "_stub_GdiFillRgn",
    "_stub_GdiFillPath",
    "_stub_GdiExtTextOutW",
    "_stub_GdiExtSelectClipRgn",
    "_stub_GdiExtGetObjectW",
    "_stub_GdiExtFloodFill",
    "_stub_GdiExtEscape",
    "_stub_GdiExtCreateRegion",
    "_stub_GdiExtCreatePen",
    "_stub_GdiExcludeClipRect",
    "_stub_GdiEudcLoadUnloadLink",
    "_stub_GdiEqualRgn",
    "_stub_GdiEnumObjects",
    "_stub_GdiEnumFonts",
    "_stub_GdiEndPath",
    "_stub_GdiEndPage",
    "_stub_GdiEndGdiRendering",
    "_stub_GdiEndDoc",
    "_stub_GdiEnableEudc",
    "_stub_GdiEllipse",
    "_stub_GdiDrawEscape",
    "_stub_GdiDoPalette",
    "_stub_GdiDoBanding",
    "_stub_GdiGetPerBandInfo",
    "_stub_GdiDestroyOPMProtectedOutput",
    "_stub_GdiDescribePixelFormat",
    "_stub_GdiDeleteObjectApp",
    "_stub_GdiDeleteColorTransform",
    "_stub_GdiDeleteColorSpace",
    "_stub_GdiDeleteClientObj",
    "_stub_GdiCreateSolidBrush",
    "_stub_GdiCreateServerMetaFile",
    "_stub_GdiCreateRoundRectRgn",
    "_stub_GdiCreateRectRgn",
    "_stub_GdiCreatePen",
    "_stub_GdiCreatePatternBrushInternal",
    "_stub_GdiCreatePaletteInternal",
    "_stub_GdiCreateOPMProtectedOutputs",
    "_stub_GdiCreateOPMProtectedOutput",
    "_stub_GdiCreateMetafileDC",
    "_stub_GdiCreateHatchBrushInternal",
    "_stub_GdiCreateHalftonePalette",
    "_stub_GdiCreateEllipticRgn",
    "_stub_GdiCreateSessionMappedDIBSection",
    "_stub_GdiCreateDIBSection",
    "_stub_GdiCreateDIBitmapInternal",
    "_stub_GdiCreateDIBBrush",
    "_stub_GdiCreateCompatibleDC",
    "_stub_GdiCreateCompatibleBitmap",
    "_stub_GdiCreateColorTransform",
    "_stub_GdiCreateColorSpace",
    "_stub_GdiCreateClientObj",
    "_stub_GdiCreateBitmapFromDxSurface2",
    "_stub_GdiCreateBitmapFromDxSurface",
    "_stub_GdiCreateBitmap",
    "_stub_GdiConvertMetafileRect",
    "_stub_GdiConfigureOPMProtectedOutput",
    "_stub_GdiComputeXformCoefficients",
    "_stub_GdiCombineTransform",
    "_stub_GdiCombineRgn",
    "_stub_GdiColorCorrectPalette",
    "_stub_GdiClearBrushAttributes",
    "_stub_GdiClearBitmapAttributes",
    "_stub_GdiCloseFigure",
    "_stub_GdiCheckBitmapBits",
    "_stub_GdiCancelDC",
    "_stub_GdiBitBlt",
    "_stub_GdiBeginPath",
    "_stub_GdiBeginGdiRendering",
    "_stub_GdiArcInternal",
    "_stub_GdiFontIsLinked",
    "_stub_GdiAnyLinkedFonts",
    "_stub_GdiAngleArc",
    "_stub_GdiAlphaBlend",
    "_stub_GdiAddRemoteMMInstanceToDC",
    "_stub_GdiRemoveMergeFont",
    "_stub_GdiAddFontMemResourceEx",
    "_stub_GdiAddRemoteFontToDC",
    "_stub_GdiAddFontResourceW",
    "_stub_GdiAbortPath",
    "_stub_GdiAbortDoc",
    "_stub_UserDefSetText",
    "_stub_UserDeferWindowPosAndBand",
    "_stub_UserDdeInitialize",
    "_stub_UserCanBrokerForceForeground",
    "_stub_UserCreateWindowStation",
    "_stub_UserCreateWindowEx",
    "_stub_UserCreateLocalMemHandle",
    "_stub_UserCreateInputContext",
    "_stub_UserCreateDesktopEx",
    "_stub_UserCreateCaret",
    "_stub_UserCreateAcceleratorTable",
    "_stub_UserCountClipboardFormats",
    "_stub_UserCopyAcceleratorTable",
    "_stub_UserConvertMemHandle",
    "_stub_UserConsoleControl",
    "_stub_UserCloseWindowStation",
    "_stub_UserCloseDesktop",
    "_stub_UserCloseClipboard",
    "_stub_UserClipCursor",
    "_stub_UserChildWindowFromPointEx",
    "_stub_UserCheckMenuItem",
    "_stub_UserCheckWindowThreadDesktop",
    "_stub_UserDwmValidateWindow",
    "_stub_UserCheckAccessForIntegrityLevel",
    "_stub_UserDisplayConfigSetDeviceInfo",
    "_stub_UserDisplayConfigGetDeviceInfo",
    "_stub_UserQueryDisplayConfig",
    "_stub_UserSetDisplayConfig",
    "_stub_UserFunctionalizeDisplayConfig",
    "_stub_UserGetDisplayConfigBufferSizes",
    "_stub_UserChangeDisplaySettings",
    "_stub_UserChangeClipboardChain",
    "_stub_UserCallTwoParam",
    "_stub_UserCallOneParam",
    "_stub_UserCallNoParam",
    "_stub_UserCallNextHookEx",
    "_stub_UserCallMsgFilter",
    "_stub_UserCallHwndParamLock",
    "_stub_UserCallHwndParam",
    "_stub_UserCallHwndOpt",
    "_stub_UserCallHwndLock",
    "_stub_UserCallHwnd",
    "_stub_UserBroadcastThemeChangeEvent",
    "_stub_UserBuildPropList",
    "_stub_UserBuildNameList",
    "_stub_UserBuildHwndList",
    "_stub_UserBuildHimcList",
    "_stub_UserBlockInput",
    "_stub_UserBitBltSysBmp",
    "_stub_UserBeginPaint",
    "_stub_UserAttachThreadInput",
    "_stub_UserAssociateInputContext",
    "_stub_UserAlterWindowStyle",
    "_stub_UserAddClipboardFormatListener",
    "_stub_UserActivateKeyboardLayout",
    "_stub_UserDelegateCapturePointers",
    "_stub_UserDelegateInput",
    "_stub_UserDispatchMessage",
    "_stub_UserDisableProcessWindowFiltering",
    "_stub_UserDisableThreadIme",
    "_stub_UserDestroyWindow",
    "_stub_UserDestroyMenu",
    "_stub_UserDestroyInputContext",
    "_stub_UserDestroyCursor",
    "_stub_UserDestroyAcceleratorTable",
    "_stub_UserDeleteMenu",
    "_stub_UserDoSoundDisconnect",
    "_stub_UserDoSoundConnect",
    "_stub_UserGhostWindowFromHungWindow",
    "_stub_UserGetWOWClass",
    "_stub_UserGetWindowPlacement",
    "_stub_UserGetWindowDisplayAffinity",
    "_stub_UserGetWindowDC",
    "_stub_UserGetWindowCompositionAttribute",
    "_stub_UserGetWindowCompositionInfo",
    "_stub_UserGetWindowBand",
    "_stub_UserGetUpdateRgn",
    "_stub_UserGetUpdateRect",
    "_stub_UserGetUpdatedClipboardFormats",
    "_stub_UserGetTopLevelWindow",
    "_stub_UserGetTitleBarInfo",
    "_stub_UserGetThreadState",
    "_stub_UserGetThreadDesktop",
    "_stub_UserGetSystemMenu",
    "_stub_UserGetScrollBarInfo",
    "_stub_UserGetRegisteredRawInputDevices",
    "_stub_UserGetRawInputDeviceList",
    "_stub_UserGetRawInputDeviceInfo",
    "_stub_UserGetRawInputData",
    "_stub_UserGetRawInputBuffer",
    "_stub_UserGetActiveProcessesDpis",
    "_stub_UserGetDpiForCurrentProcess",
    "_stub_UserGetProcessDpiAwarenessContext",
    "_stub_UserGetProcessWindowStation",
    "_stub_UserGetPriorityClipboardFormat",
    "_stub_UserGetOpenClipboardWindow",
    "_stub_UserGetObjectInformation",
    "_stub_UserGetMouseMovePointsEx",
    "_stub_UserGetMessage",
    "_stub_UserGetMenuItemRect",
    "_stub_UserGetMenuIndex",
    "_stub_UserGetMenuBarInfo",
    "_stub_UserGetListBoxInfo",
    "_stub_UserGetKeyState",
    "_stub_UserGetKeyNameText",
    "_stub_UserGetKeyboardState",
    "_stub_UserGetKeyboardLayoutName",
    "_stub_UserGetKeyboardLayoutList",
    "_stub_UserGetInternalWindowPos",
    "_stub_UserGetInputLocaleInfo",
    "_stub_UserGetImeInfoEx",
    "_stub_UserGetImeHotKey",
    "_stub_UserGetIconSize",
    "_stub_UserGetIconInfo",
    "_stub_UserGetGUIThreadInfo",
    "_stub_UserGetGuiResources",
    "_stub_UserGetForegroundWindow",
    "_stub_UserGetDoubleClickTime",
    "_stub_UserGetDesktopID",
    "_stub_UserGetDCEx",
    "_stub_UserGetDC",
    "_stub_UserGetCursorInfo",
    "_stub_UserGetCursorFrameInfo",
    "_stub_UserGetCurrentInputMessageSource",
    "_stub_UserGetCIMSSM",
    "_stub_UserGetCPD",
    "_stub_UserGetControlColor",
    "_stub_UserGetControlBrush",
    "_stub_UserGetComboBoxInfo",
    "_stub_UserGetClipCursor",
    "_stub_UserGetClipboardViewer",
    "_stub_UserGetClipboardSequenceNumber",
    "_stub_UserGetClipboardOwner",
    "_stub_UserGetClipboardFormatName",
    "_stub_UserGetClipboardData",
    "_stub_UserGetClassName",
    "_stub_UserGetClassInfoEx",
    "_stub_UserGetCaretPos",
    "_stub_UserGetCaretBlinkTime",
    "_stub_UserGetAtomName",
    "_stub_UserGetAsyncKeyState",
    "_stub_UserGetAppImeLevel",
    "_stub_UserGetAncestor",
    "_stub_UserGetAltTabInfo",
    "_stub_UserFrostCrashedWindow",
    "_stub_UserFlashWindowEx",
    "_stub_UserFindWindowEx",
    "_stub_UserFindExistingCursorIcon",
    "_stub_UserFillWindow",
    "_stub_UserExcludeUpdateRgn",
    "_stub_UserEvent",
    "_stub_UserEnumDisplaySettings",
    "_stub_UserEnumDisplayMonitors",
    "_stub_UserEnumDisplayDevices",
    "_stub_UserEndPaint",
    "_stub_UserEndMenu",
    "_stub_UserEndDeferWindowPosEx",
    "_stub_UserEnableScrollBar",
    "_stub_UserEnableMenuItem",
    "_stub_UserEmptyClipboard",
    "_stub_UserDrawMenuBarTemp",
    "_stub_UserDrawIconEx",
    "_stub_UserDrawCaptionTemp",
    "_stub_UserDrawCaption",
    "_stub_UserDrawAnimatedRects",
    "_stub_UserDragObject",
    "_stub_UserDragDetect",
    "_stub_UserHandleDelegatedInput",
    "_stub_UserInheritWindowMonitor",
    "_stub_UserRealChildWindowFromPoint",
    "_stub_UserQueryWindow",
    "_stub_UserQuerySendMessage",
    "_stub_UserQueryInputContext",
    "_stub_UserQueryInformationThread",
    "_stub_UserQueryBSDRWindow",
    "_stub_UserPerMonitorDPIPhysicalToLogicalPoint",
    "_stub_UserProcessConnect",
    "_stub_UserPrintWindow",
    "_stub_UserPostThreadMessage",
    "_stub_UserPostMessage",
    "_stub_UserPhysicalToLogicalPoint",
    "_stub_UserPeekMessage",
    "_stub_UserPaintMonitor",
    "_stub_UserPaintDesktop",
    "_stub_UserOpenWindowStation",
    "_stub_UserOpenThreadDesktop",
    "_stub_UserOpenInputDesktop",
    "_stub_UserOpenDesktop",
    "_stub_UserOpenClipboard",
    "_stub_UserNotifyWinEvent",
    "_stub_UserNotifyProcessCreate",
    "_stub_UserNotifyIMEStatus",
    "_stub_UserMoveWindow",
    "_stub_UserModifyUserStartupInfoFlags",
    "_stub_UserMNDragOver",
    "_stub_UserMNDragLeave",
    "_stub_UserMinMaximize",
    "_stub_UserMessageCall",
    "_stub_UserMenuItemFromPoint",
    "_stub_UserMapVirtualKeyEx",
    "_stub_UserLayoutCompleted",
    "_stub_UserLogicalToPerMonitorDPIPhysicalPoint",
    "_stub_UserLogicalToPhysicalPoint",
    "_stub_UserLockCursor",
    "_stub_UserLockWorkStation",
    "_stub_UserLockWindowUpdate",
    "_stub_UserLockWindowStation",
    "_stub_UserLoadKeyboardLayoutEx",
    "_stub_UserKillTimer",
    "_stub_UserIsTopLevelWindow",
    "_stub_UserIsClipboardFormatAvailable",
    "_stub_UserInvalidateRgn",
    "_stub_UserInvalidateRect",
    "_stub_UserInternalGetWindowIcon",
    "_stub_UserInternalGetWindowText",
    "_stub_UserInitTask",
    "_stub_UserInitializeClientPfnArrays",
    "_stub_UserInitialize",
    "_stub_UserImpersonateDdeClientWindow",
    "_stub_UserHungWindowFromGhostWindow",
    "_stub_UserHiliteMenuItem",
    "_stub_UserHideCaret",
    "_stub_UserHardErrorControl",
    "_stub_UserRealInternalGetMessage",
    "_stub_UserRealWaitMessageEx",
    "_stub_UserReleaseDwmHitTestWaiters",
    "_stub_UserReleaseDC",
    "_stub_UserTranslateMessage",
    "_stub_UserTranslateAccelerator",
    "_stub_UserPaintMenuBar",
    "_stub_UserCalcMenuBar",
    "_stub_UserCalculatePopupWindowPosition",
    "_stub_UserTrackPopupMenuEx",
    "_stub_UserTrackMouseEvent",
    "_stub_UserToUnicodeEx",
    "_stub_UserThunkedMenuItemInfo",
    "_stub_UserThunkedMenuInfo",
    "_stub_UserTestForInteractiveUser",
    "_stub_UserSendEventMessage",
    "_stub_UserSystemParametersInfo",
    "_stub_UserSystemParametersInfoForDpi",
    "_stub_UserSwitchDesktop",
    "_stub_UserSoundSentry",
    "_stub_UserShutdownReasonDestroy",
    "_stub_UserShutdownBlockReasonQuery",
    "_stub_UserShutdownBlockReasonCreate",
    "_stub_UserShowWindowAsync",
    "_stub_UserShowWindow",
    "_stub_UserShowScrollBar",
    "_stub_UserShowCaret",
    "_stub_UserShowCursor",
    "_stub_UserSetWinEventHook",
    "_stub_UserSetWindowWord",
    "_stub_UserSetWindowStationUser",
    "_stub_UserSetWindowsHookEx",
    "_stub_UserSetWindowsHookAW",
    "_stub_UserSetWindowRgnEx",
    "_stub_UserGetWindowRgnEx",
    "_stub_UserSetWindowRgn",
    "_stub_UserSetWindowPos",
    "_stub_UserSetWindowPlacement",
    "_stub_UserSetWindowLong",
    "_stub_UserSetWindowFNID",
    "_stub_UserSetWindowDisplayAffinity",
    "_stub_UserSetWindowCompositionTransition",
    "_stub_UserUpdateDefaultDesktopThumbnail",
    "_stub_UserSetWindowCompositionAttribute",
    "_stub_UserSetWindowBand",
    "_stub_UserSetProcessUIAccessZorder",
    "_stub_UserSetProcessDpiAwarenessContext",
    "_stub_UserEnableChildWindowDpiMessage",
    "_stub_UserIsChildWindowDpiMessageEnabled",
    "_stub_UserEnableNonClientDpiScaling",
    "_stub_UserIsNonClientDpiScalingEnabled",
    "_stub_UserSetDialogControlDpiChangeBehavior",
    "_stub_UserIsWindowBroadcastingDpiToChildren",
    "_stub_UserEnableWindowGDIScaledDpiMessage",
    "_stub_UserIsWindowGDIScaledDpiMessageEnabled",
    "_stub_UserSetTargetForResourceBrokering",
    "_stub_UserSetTimer",
    "_stub_UserSetThreadState",
    "_stub_UserSetThreadLayoutHandles",
    "_stub_UserSetThreadDesktop",
    "_stub_UserSetThreadInputBlocked",
    "_stub_UserSetSystemTimer",
    "_stub_UserSetSystemMenu",
    "_stub_UserSetSystemCursor",
    "_stub_UserSetSysColors",
    "_stub_UserSetShellWindowEx",
    "_stub_UserSetScrollInfo",
    "_stub_UserSetProp",
    "_stub_UserGetProp",
    "_stub_UserSetProcessWindowStation",
    "_stub_UserSetParent",
    "_stub_UserSetObjectInformation",
    "_stub_UserSetMenuFlagRtoL",
    "_stub_UserSetMenuDefaultItem",
    "_stub_UserSetMenuContextHelpId",
    "_stub_UserSetMenu",
    "_stub_UserSetKeyboardState",
    "_stub_UserSetInternalWindowPos",
    "_stub_UserSetInformationThread",
    "_stub_UserSetImeOwnerWindow",
    "_stub_UserSetImeInfoEx",
    "_stub_UserSetImeHotKey",
    "_stub_UserSetFocus",
    "_stub_UserSetCursorIconData",
    "_stub_UserSetCursorContents",
    "_stub_UserSetCursor",
    "_stub_UserSetCursorPos",
    "_stub_UserSetClipboardViewer",
    "_stub_UserSetClipboardData",
    "_stub_UserSetClassWord",
    "_stub_UserSetClassLong",
    "_stub_UserSetChildWindowNoActivate",
    "_stub_UserSetCapture",
    "_stub_UserSetAppImeLevel",
    "_stub_UserSetActiveWindow",
    "_stub_UserSendInput",
    "_stub_UserSelectPalette",
    "_stub_UserScrollWindowEx",
    "_stub_UserScrollDC",
    "_stub_UserSBGetParms",
    "_stub_UserResolveDesktopForWOW",
    "_stub_UserRemoveProp",
    "_stub_UserRemoveMenu",
    "_stub_UserRemoveClipboardFormatListener",
    "_stub_UserRegisterWindowMessage",
    "_stub_UserRegisterTasklist",
    "_stub_UserRegisterServicesProcess",
    "_stub_UserRegisterRawInputDevices",
    "_stub_UserRegisterHotKey",
    "_stub_UserRegisterDManipHook",
    "_stub_UserGetDManipHookInitFunction",
    "_stub_UserRegisterManipulationThread",
    "_stub_UserSetManipulationInputTarget",
    "_stub_UserStopAndEndInertia",
    "_stub_UserRegisterUserApiHook",
    "_stub_UserRegisterErrorReportingDialog",
    "_stub_UserRegisterClassExWOW",
    "_stub_UserRegisterBSDRWindow",
    "_stub_UserRedrawWindow",
    "_stub_UserUndelegateInput",
    "_stub_UserGetWindowMinimizeRect",
    "_stub_UserDwmGetRemoteSessionOcclusionEvent",
    "_stub_UserDwmGetRemoteSessionOcclusionState",
    "_stub_UserDwmKernelShutdown",
    "_stub_UserDwmKernelStartup",
    "_stub_UserCheckProcessSession",
    "_stub_UserUnregisterSessionPort",
    "_stub_UserRegisterSessionPort",
    "_stub_UserCtxDisplayIOCtl",
    "_stub_UserRemoteStopScreenUpdates",
    "_stub_UserRemoteRedrawScreen",
    "_stub_UserRemoteRedrawRectangle",
    "_stub_UserRemoteConnect",
    "_stub_UserWaitAvailableMessageEx",
    "_stub_UserWindowFromPoint",
    "_stub_UserWindowFromPhysicalPoint",
    "_stub_UserWindowFromDC",
    "_stub_UserWaitMessage",
    "_stub_UserWaitForMsgAndEvent",
    "_stub_UserWaitForInputIdle",
    "_stub_UserVkKeyScanEx",
    "_stub_UserValidateTimerCallback",
    "_stub_UserValidateRect",
    "_stub_UserValidateHandleSecure",
    "_stub_UserUserHandleGrantAccess",
    "_stub_UserUpdatePerUserSystemParameters",
    "_stub_UserSetLayeredWindowAttributes",
    "_stub_UserGetLayeredWindowAttributes",
    "_stub_UserUpdateLayeredWindow",
    "_stub_UserUpdateInstance",
    "_stub_UserUpdateInputContext",
    "_stub_UserUnregisterHotKey",
    "_stub_UserUnregisterUserApiHook",
    "_stub_UserUnregisterClass",
    "_stub_UserUnlockWindowStation",
    "_stub_UserUnloadKeyboardLayout",
    "_stub_UserUnhookWinEvent",
    "_stub_UserUnhookWindowsHookEx",
    "_stub_UserGetTouchInputInfo",
    "_stub_UserIsTouchWindow",
    "_stub_UserModifyWindowTouchCapability",
    "_stub_GdiEngStretchBltROP",
    "_stub_GdiEngTextOut",
    "_stub_GdiEngTransparentBlt",
    "_stub_GdiEngGradientFill",
    "_stub_GdiEngAlphaBlend",
    "_stub_GdiEngLineTo",
    "_stub_GdiEngPaint",
    "_stub_GdiEngStrokeAndFillPath",
    "_stub_GdiEngFillPath",
    "_stub_GdiEngStrokePath",
    "_stub_GdiEngMarkBandingSurface",
    "_stub_GdiEngPlgBlt",
    "_stub_GdiEngStretchBlt",
    "_stub_GdiEngBitBlt",
    "_stub_GdiEngLockSurface",
    "_stub_GdiEngUnlockSurface",
    "_stub_GdiEngEraseSurface",
    "_stub_GdiEngDeleteSurface",
    "_stub_GdiEngDeletePalette",
    "_stub_GdiEngCopyBits",
    "_stub_GdiEngComputeGlyphSet",
    "_stub_GdiEngCreatePalette",
    "_stub_GdiEngCreateDeviceBitmap",
    "_stub_GdiEngCreateDeviceSurface",
    "_stub_GdiEngCreateBitmap",
    "_stub_GdiEngAssociateSurface",
    "_stub_UserSetWindowFeedbackSetting",
    "_stub_UserRegisterEdgy",
    "_stub_UserRegisterShellPTPListener",
    "_stub_UserGetWindowFeedbackSetting",
    "_stub_UserHidePointerContactVisualization",
    "_stub_UserGetTouchValidationStatus",
    "_stub_UserInitializeTouchInjection",
    "_stub_UserInjectTouchInput",
    "_stub_UserRegisterTouchHitTestingWindow",
    "_stub_UserSetDisplayMapping",
    "_stub_UserSetCalibrationData",
    "_stub_UserGetPhysicalDeviceRect",
    "_stub_UserRegisterTouchPadCapable",
    "_stub_UserGetRawPointerDeviceData",
    "_stub_UserGetPointerDeviceCursors",
    "_stub_UserGetPointerDeviceRects",
    "_stub_UserRegisterPointerDeviceNotifications",
    "_stub_UserGetPointerDeviceProperties",
    "_stub_UserGetPointerDevice",
    "_stub_UserGetPointerDevices",
    "_stub_UserEnableTouchPad",
    "_stub_UserGetPrecisionTouchPadConfiguration",
    "_stub_UserSetPrecisionTouchPadConfiguration",
    "_stub_UserPromotePointer",
    "_stub_UserDiscardPointerFrameMessages",
    "_stub_UserRegisterPointerInputTarget",
    "_stub_UserGetPointerFrameArrivalTimes",
    "_stub_UserGetPointerInputTransform",
    "_stub_UserGetPointerInfoList",
    "_stub_UserGetPointerCursorId",
    "_stub_UserGetPointerType",
    "_stub_UserGetGestureConfig",
    "_stub_UserSetGestureConfig",
    "_stub_UserGetGestureExtArgs",
    "_stub_UserGetGestureInfo",
    "_stub_UserInjectGesture",
    "_stub_UserChangeWindowMessageFilterEx",
    "_stub_GdiXLATEOBJ_hGetColorTransform",
    "_stub_GdiXLATEOBJ_iXlate",
    "_stub_GdiXLATEOBJ_cGetPalette",
    "_stub_GdiEngDeleteClip",
    "_stub_GdiEngCreateClip",
    "_stub_GdiEngDeletePath",
    "_stub_GdiCLIPOBJ_ppoGetPath",
    "_stub_GdiCLIPOBJ_cEnumStart",
    "_stub_GdiCLIPOBJ_bEnum",
    "_stub_GdiBRUSHOBJ_hGetColorTransform",
    "_stub_GdiBRUSHOBJ_pvGetRbrush",
    "_stub_GdiBRUSHOBJ_pvAllocRbrush",
    "_stub_GdiBRUSHOBJ_ulGetBrushColor",
    "_stub_GdiXFORMOBJ_iGetXform",
    "_stub_GdiXFORMOBJ_bApplyXform",
    "_stub_GdiFONTOBJ_pQueryGlyphAttrs",
    "_stub_GdiFONTOBJ_pfdg",
    "_stub_GdiFONTOBJ_pifi",
    "_stub_GdiFONTOBJ_cGetGlyphs",
    "_stub_GdiFONTOBJ_pxoGetXform",
    "_stub_GdiFONTOBJ_vGetInfo",
    "_stub_GdiFONTOBJ_cGetAllGlyphHandles",
    "_stub_GdiFONTOBJ_pvTrueTypeFontFile",
    "_stub_GdiSTROBJ_dwGetCodePage",
    "_stub_GdiSTROBJ_vEnumStart",
    "_stub_GdiSTROBJ_bGetAdvanceWidths",
    "_stub_GdiSTROBJ_bEnumPositionsOnly",
    "_stub_GdiSTROBJ_bEnum",
    "_stub_GdiPATHOBJ_bEnumClipLines",
    "_stub_GdiPATHOBJ_vEnumStartClipLines",
    "_stub_GdiPATHOBJ_vEnumStart",
    "_stub_GdiPATHOBJ_bEnum",
    "_stub_GdiPATHOBJ_vGetBounds",
    "_stub_GdiEngCheckAbort",
    "_stub_GdiGetDhpdev",
    "_stub_GdiHT_Get8BPPMaskPalette",
    "_stub_GdiHT_Get8BPPFormatPalette",
    "_stub_GdiUpdateTransform",
    "_stub_GdiUMPDEngFreeUserMem",
    "_stub_GdiBRUSHOBJ_DeleteRbrush",
    "_stub_GdiSetPUMPDOBJ",
    "_stub_GdiSetUMPDSandboxState",
    "_stub_GdiDrawStream",
    "_stub_GdiHLSurfSetInformation",
    "_stub_GdiHLSurfGetInformation",
    "_stub_GdiDwmCreatedBitmapRemotingOutput",
    "_stub_GdiDdDDIGetScanLine",
    "_stub_GdiDdDDIReleaseProcessVidPnSourceOwners",
    "_stub_GdiDdDDIGetProcessSchedulingPriorityClass",
    "_stub_GdiDdDDISetProcessSchedulingPriorityClass",
    "_stub_GdiDdDDIGetContextSchedulingPriority",
    "_stub_GdiDdDDISetContextSchedulingPriority",
    "_stub_GdiDdDDIDestroyDCFromMemory",
    "_stub_GdiDdDDICreateDCFromMemory",
    "_stub_GdiDdDDIGetDeviceState",
    "_stub_GdiDdDDISetGammaRamp",
    "_stub_GdiDdDDIWaitForVerticalBlankEvent",
    "_stub_GdiDdDDIDestroyOverlay",
    "_stub_GdiDdDDIFlipOverlay",
    "_stub_GdiDdDDIUpdateOverlay",
    "_stub_GdiDdDDICreateOverlay",
    "_stub_GdiDdDDIGetPresentQueueEvent",
    "_stub_GdiDdDDIGetPresentHistory",
    "_stub_GdiDdDDISetVidPnSourceOwner",
    "_stub_GdiDdDDIQueryStatistics",
    "_stub_GdiDdDDIEscape",
    "_stub_GdiDdDDIGetSharedPrimaryHandle",
    "_stub_GdiDdDDICloseAdapter",
    "_stub_GdiDdDDIOpenAdapterFromLuid",
    "_stub_GdiDdDDIEnumAdapters",
    "_stub_GdiDdDDIEnumAdapters2",
    "_stub_GdiDdDDIOpenAdapterFromHdc",
    "_stub_GdiDdDDIOpenAdapterFromDeviceName",
    "_stub_GdiDdDDIRender",
    "_stub_GdiDdDDIPresent",
    "_stub_GdiDdDDIGetMultisampleMethodList",
    "_stub_GdiDdDDISetDisplayMode",
    "_stub_GdiDdDDIGetDisplayModeList",
    "_stub_GdiDdDDIUnlock",
    "_stub_GdiDdDDILock",
    "_stub_GdiDdDDIQueryAdapterInfo",
    "_stub_GdiDdDDIGetRuntimeData",
    "_stub_GdiDdDDISignalSynchronizationObject",
    "_stub_GdiDdDDIWaitForSynchronizationObject",
    "_stub_GdiDdDDIDestroySynchronizationObject",
    "_stub_GdiDdDDIOpenSynchronizationObject",
    "_stub_GdiDdDDICreateSynchronizationObject",
    "_stub_GdiDdDDIDestroyContext",
    "_stub_GdiDdDDICreateContext",
    "_stub_GdiDdDDIDestroyDevice",
    "_stub_GdiDdDDICreateDevice",
    "_stub_GdiDdDDIQueryAllocationResidency",
    "_stub_GdiDdDDISetAllocationPriority",
    "_stub_GdiDdDDIDestroyAllocation",
    "_stub_GdiDdDDIDestroyAllocation2",
    "_stub_GdiDdDDIOpenResourceFromNtHandle",
    "_stub_GdiDdDDIOpenSyncObjectFromNtHandle",
    "_stub_GdiDdDDIOpenSyncObjectFromNtHandle2",
    "_stub_GdiDdDDIOpenResource",
    "_stub_GdiDdDDIOpenNtHandleFromName",
    "_stub_GdiDdDDIOpenSyncObjectNtHandleFromName",
    "_stub_GdiDdDDIShareObjects",
    "_stub_GdiDdDDIQueryResourceInfoFromNtHandle",
    "_stub_GdiDdDDIQueryResourceInfo",
    "_stub_GdiDdDDICreateAllocation",
    "_stub_GdiDdDDIOutputDuplReleaseFrame",
    "_stub_GdiDdDDIQueryRemoteVidPnSourceFromGdiDisplayName",
    "_stub_GdiDdDDIOutputDuplPresent",
    "_stub_GdiDdDDIReleaseKeyedMutex2",
    "_stub_GdiDdDDIAcquireKeyedMutex2",
    "_stub_GdiDdDDIOpenKeyedMutex2",
    "_stub_GdiDdDDICreateKeyedMutex2",
    "_stub_GdiDdDDIOutputDuplGetPointerShapeData",
    "_stub_GdiDdDDIOutputDuplGetMetaData",
    "_stub_GdiDdDDIOutputDuplGetFrameInfo",
    "_stub_GdiDdDDIDestroyOutputDupl",
    "_stub_GdiDdDDICreateOutputDupl",
    "_stub_GdiDdDDIReclaimAllocations",
    "_stub_GdiDdDDIOfferAllocations",
    "_stub_GdiDdDDICheckSharedResourceAccess",
    "_stub_GdiDdDDICheckVidPnExclusiveOwnership",
    "_stub_GdiDdDDIGetOverlayState",
    "_stub_GdiDdDDIConfigureSharedResource",
    "_stub_GdiDdDDIReleaseKeyedMutex",
    "_stub_GdiDdDDIAcquireKeyedMutex",
    "_stub_GdiDdDDIDestroyKeyedMutex",
    "_stub_GdiDdDDIOpenKeyedMutex",
    "_stub_GdiDdDDICreateKeyedMutex",
    "_stub_GdiDdDDISharedPrimaryUnLockNotification",
    "_stub_GdiDdDDISharedPrimaryLockNotification",
    "_stub_GdiDdDDISetDisplayPrivateDriverFormat",
    "_stub_GdiDdDDICheckExclusiveOwnership",
    "_stub_GdiDdDDICheckMonitorPowerState",
    "_stub_GdiDdDDIWaitForIdle",
    "_stub_GdiDdDDICheckOcclusion",
    "_stub_GdiDdDDIInvalidateActiveVidPn",
    "_stub_GdiDdDDIPollDisplayChildren",
    "_stub_GdiDdDDISetQueuedLimit",
    "_stub_GdiDdDDIPinDirectFlipResources",
    "_stub_GdiDdDDIUnpinDirectFlipResources",
    "_stub_GdiDdDDIWaitForVerticalBlankEvent2",
    "_stub_GdiDdDDIGetDWMVerticalBlankEvent",
    "_stub_GdiDdDDISetSyncRefreshCountWaitTarget",
    "_stub_GdiDdDDISetContextInProcessSchedulingPriority",
    "_stub_GdiDdDDIGetContextInProcessSchedulingPriority",
    "_stub_GdiDdDDIGetSharedResourceAdapterLuid",
    "_stub_GdiDdDDISetStereoEnabled",
    "_stub_GdiDdDDIPresentMultiPlaneOverlay",
    "_stub_GdiDdDDICheckMultiPlaneOverlaySupport",
    "_stub_GdiDdDDIMakeResident",
    "_stub_GdiDdDDIEvict",
    "_stub_GdiDdDDIUpdateAllocationProperty",
    "_stub_GdiDdDDIWaitForSynchronizationObjectFromCpu",
    "_stub_GdiDdDDISignalSynchronizationObjectFromCpu",
    "_stub_GdiDdDDIWaitForSynchronizationObjectFromGpu",
    "_stub_GdiDdDDISignalSynchronizationObjectFromGpu",
    "_stub_GdiDdDDISignalSynchronizationObjectFromGpu2",
    "_stub_GdiDdDDICreatePagingQueue",
    "_stub_GdiDdDDIDestroyPagingQueue",
    "_stub_GdiDdDDILock2",
    "_stub_GdiDdDDIUnlock2",
    "_stub_GdiDdDDIInvalidateCache",
    "_stub_GdiDdDDIGetResourcePresentPrivateDriverData",
    "_stub_GdiDdDDIMapGpuVirtualAddress",
    "_stub_GdiDdDDIReserveGpuVirtualAddress",
    "_stub_GdiDdDDIFreeGpuVirtualAddress",
    "_stub_GdiDdDDIUpdateGpuVirtualAddress",
    "_stub_GdiDdDDICreateContextVirtual",
    "_stub_GdiDdDDISubmitCommand",
    "_stub_GdiDdDDIGetCachedHybridQueryValue",
    "_stub_GdiDdDDICacheHybridQueryValue",
    "_stub_GdiDdDDINetDispGetNextChunkInfo",
    "_stub_GdiDdDDINetDispQueryMiracastDisplayDeviceSupport",
    "_stub_GdiDdDDINetDispStartMiracastDisplayDevice",
    "_stub_GdiDdDDINetDispStopMiracastDisplayDevice",
    "_stub_GdiDdDDINetDispQueryMiracastDisplayDeviceStatus",
    "_stub_GdiDdDDINetDispStopSessions",
    "_stub_GdiDdDDIQueryVideoMemoryInfo",
    "_stub_GdiDdDDIChangeVideoMemoryReservation",
    "_stub_GdiDdDDICreateSwapChain",
    "_stub_GdiDdDDIOpenSwapChain",
    "_stub_GdiDdDDIAddSurfaceToSwapChain",
    "_stub_GdiDdDDIRemoveSurfaceFromSwapChain",
    "_stub_GdiDdDDIUnOrderedPresentSwapChain",
    "_stub_GdiDdDDIGetSetSwapChainMetadata",
    "_stub_GdiDdDDIAcquireSwapChain",
    "_stub_GdiDdDDIReleaseSwapChain",
    "_stub_GdiDdDDIAbandonSwapChain",
    "_stub_GdiDdDDISetDodIndirectSwapchain",
    "_stub_GdiDdDDICheckMultiPlaneOverlaySupport2",
    "_stub_GdiDdDDIPresentMultiPlaneOverlay2",
    "_stub_GdiDdDDIReclaimAllocations2",
    "_stub_GdiDdDDISetStablePowerState",
    "_stub_GdiDdDDIQueryClockCalibration",
    "_stub_GdiDdDDIQueryVidPnExclusiveOwnership",
    "_stub_GdiDdDDIAdjustFullscreenGamma",
    "_stub_GdiDdDDISetVidPnSourceHwProtection",
    "_stub_GdiDdDDIMarkDeviceAsError",
    "_stub_GdiDdDDIFlushHeapTransitions",
    "_stub_GdiDdDDISetHwProtectionTeardownRecovery",
    "_stub_GdiDdDDIQueryProcessOfferInfo",
    "_stub_GdiDdDDITrimProcessCommitment",
    "_stub_GdiDdDDICheckMultiPlaneOverlaySupport3",
    "_stub_GdiDdDDIPresentMultiPlaneOverlay3",
    "_stub_GdiDdDDISetFSEBlock",
    "_stub_GdiDdDDIQueryFSEBlock",
    "_stub_GdiDdDDICreateHwContext",
    "_stub_GdiDdDDIDestroyHwContext",
    "_stub_GdiDdDDICreateHwQueue",
    "_stub_GdiDdDDIDestroyHwQueue",
    "_stub_GdiDdDDISubmitCommandToHwQueue",
    "_stub_GdiDdDDISubmitWaitForSyncObjectsToHwQueue",
    "_stub_GdiDdDDISubmitSignalSyncObjectsToHwQueue",
    "_stub_GdiDdDDIGetAllocationPriority",
    "_stub_GdiDdDDIGetMultiPlaneOverlayCaps",
    "_stub_GdiDdDDIGetPostCompositionCaps",
    "_stub_GdiDdDDISetYieldPercentage",
    "_stub_GdiDdDDISetProcessSchedulingPriorityBand",
    "_stub_GdiDdDDISetMemoryBudgetTarget",
    "_stub_GdiDdDDIGetYieldPercentage",
    "_stub_GdiDdDDIGetProcessSchedulingPriorityBand",
    "_stub_GdiDdDDIGetMemoryBudgetTarget",
    "_stub_GdiDdDDIDDisplayEnum",
    "_stub_GdiDdDDIDispMgrCreate",
    "_stub_GdiDdDDIDispMgrTargetOperation",
    "_stub_GdiDdDDIDispMgrSourceOperation",
    "_stub_GdiDdDDICreateProtectedSession",
    "_stub_GdiDdDDIDestroyProtectedSession",
    "_stub_GdiDdDDIQueryProtectedSessionStatus",
    "_stub_GdiDdDDIQueryProtectedSessionInfoFromNtHandle",
    "_stub_GdiDdDDIOpenProtectedSessionFromNtHandle",
    "_stub_GdiDdDDISetMonitorColorSpaceTransform",
    "_stub_GdiDdDDIPresentRedirected",
    "_stub_GdiDdDDICreateBundleObject",
    "_stub_GdiDdDDIExtractBundleObject",
    "_stub_GdiDdDDISetDeviceLostSupport",
    "_stub_GdiDdDDIGetProcessDeviceLostSupport",
    "_stub_GdiMakeObjectUnXferable",
    "_stub_GdiMakeObjectXferable",
    "_stub_GdiDestroyPhysicalMonitor",
    "_stub_GdiGetPhysicalMonitorDescription",
    "_stub_GdiGetPhysicalMonitors",
    "_stub_GdiGetNumberOfPhysicalMonitors",
    "_stub_GdiDDCCIGetTimingReport",
    "_stub_GdiDDCCIGetCapabilitiesString",
    "_stub_GdiDDCCIGetCapabilitiesStringLength",
    "_stub_GdiDDCCISaveCurrentSettings",
    "_stub_GdiDDCCISetVCPFeature",
    "_stub_GdiDDCCIGetVCPFeature",
    "_stub_GdiDdQueryVisRgnUniqueness",
    "_stub_GdiDdDestroyFullscreenSprite",
    "_stub_GdiDdNotifyFullscreenSpriteUpdate",
    "_stub_GdiDdCreateFullscreenSprite",
    "_stub_GdiGetProcessSessionFonts",
    "_stub_GdiGetPublicFontTableChangeCookie",
    "_stub_GdiAddInitialFonts",
    "_stub_UserShowSystemCursor",
    "_stub_UserSetMirrorRendering",
    "_stub_UserSetDesktopColorTransform",
    "_stub_UserMagGetContextInformation",
    "_stub_UserMagSetContextInformation",
    "_stub_UserMagControl",
    "_stub_UserSlicerControl",
    "_stub_UserHwndSetRedirectionInfo",
    "_stub_UserHwndQueryRedirectionInfo",
    "_stub_CreateCompositionSurfaceHandle",
    "_stub_ValidateCompositionSurfaceHandle",
    "_stub_BindCompositionSurface",
    "_stub_UnBindCompositionSurface",
    "_stub_QueryCompositionSurfaceBinding",
    "_stub_NotifyPresentToCompositionSurface",
    "_stub_QueryCompositionSurfaceStatistics",
    "_stub_OpenCompositionSurfaceSectionInfo",
    "_stub_OpenCompositionSurfaceSwapChainHandleInfo",
    "_stub_QueryCompositionSurfaceRenderingRealization",
    "_stub_OpenCompositionSurfaceDirtyRegion",
    "_stub_QueryCompositionSurfaceHDRMetaData",
    "_stub_SetCompositionSurfaceHDRMetaData",
    "_stub_SetCompositionSurfaceDirectFlipState",
    "_stub_SetCompositionSurfaceStatistics",
    "_stub_SetCompositionSurfaceBufferUsage",
    "_stub_SetCompositionSurfaceIndependentFlipInfo",
    "_stub_DesktopCaptureBits",
    "_stub_DCompositionEnableMMCSS",
    "_stub_VisualCaptureBits",
    "_stub_DCompositionEnableDDASupport",
    "_stub_DCompositionCreateSharedVisualHandle",
    "_stub_CreateCompositionInputSink",
    "_stub_CreateImplicitCompositionInputSink",
    "_stub_DuplicateCompositionInputSink",
    "_stub_QueryCompositionInputSink",
    "_stub_QueryCompositionInputSinkLuid",
    "_stub_QueryCompositionInputSinkViewId",
    "_stub_UpdateInputSinkTransforms",
    "_stub_CompositionInputThread",
    "_stub_QueryCompositionInputQueueAndTransform",
    "_stub_QueryCompositionInputIsImplicit",
    "_stub_CompositionSetDropTarget",
    "_stub_TokenManagerOpenSectionAndEvents",
    "_stub_TokenManagerThread",
    "_stub_TokenManagerCreateCompositionTokenHandle",
    "_stub_TokenManagerGetAnalogExclusiveTokenEvent",
    "_stub_TokenManagerGetAnalogExclusiveSurfaceUpdates",
    "_stub_TokenManagerConfirmOutstandingAnalogToken",
    "_stub_SetCompositionSurfaceAnalogExclusive",
    "_stub_DCompositionBeginFrame",
    "_stub_DCompositionConfirmFrame",
    "_stub_DCompositionRetireFrame",
    "_stub_DCompositionDiscardFrame",
    "_stub_DCompositionGetFrameSurfaceUpdates",
    "_stub_DCompositionGetFrameLegacyTokens",
    "_stub_DCompositionDestroyConnection",
    "_stub_DCompositionGetConnectionBatch",
    "_stub_DCompositionGetFrameStatistics",
    "_stub_DCompositionGetDeletedResources",
    "_stub_DCompositionCreateConnection",
    "_stub_DCompositionDestroyChannel",
    "_stub_DCompositionReleaseAllResources",
    "_stub_DCompositionSubmitDWMBatch",
    "_stub_DCompositionProcessChannelBatchBuffer",
    "_stub_DCompositionCommitChannel",
    "_stub_DCompositionWaitForChannel",
    "_stub_DCompositionSetChannelCommitCompletionEvent",
    "_stub_DCompositionTelemetryTouchInteractionBegin",
    "_stub_DCompositionTelemetryTouchInteractionUpdate",
    "_stub_DCompositionTelemetryTouchInteractionEnd",
    "_stub_DCompositionTelemetrySetApplicationId",
    "_stub_DCompositionTelemetryAnimationScenarioBegin",
    "_stub_DCompositionTelemetryAnimationScenarioReference",
    "_stub_DCompositionTelemetryAnimationScenarioUnreference",
    "_stub_DCompositionCurrentBatchId",
    "_stub_DCompositionRemoveCrossDeviceVisualChild",
    "_stub_DCompositionAddCrossDeviceVisualChild",
    "_stub_DCompositionCreateDwmChannel",
    "_stub_DCompositionCreateChannel",
    "_stub_DCompositionSynchronize",
    "_stub_DCompositionReferenceSharedResourceOnDwmChannel",
    "_stub_DCompositionCreateAndBindSharedSection",
    "_stub_DCompositionSetDebugCounter",
    "_stub_DCompositionGetChannels",
    "_stub_DCompositionConnectPipe",
    "_stub_DCompositionRegisterThumbnailVisual",
    "_stub_DCompositionRegisterVirtualDesktopVisual",
    "_stub_DCompositionDuplicateHandleToProcess",
    "_stub_DCompositionUpdatePointerCapture",
    "_stub_DCompositionSetChannelCallbackId",
    "_stub_DCompositionDuplicateSwapchainHandleToDwm",
    "_stub_DCompositionSetChildRootVisual",
    "_stub_DCompositionCommitSynchronizationObject",
    "_stub_FlipObjectCreate",
    "_stub_FlipObjectOpen",
    "_stub_FlipObjectAddPoolBuffer",
    "_stub_FlipObjectRemovePoolBuffer",
    "_stub_UserDestroyDCompositionHwndTarget",
    "_stub_UserCreateDCompositionHwndTarget",
    "_stub_UserCreateEmptyCursorObject",
    "_stub_UserWaitForRedirectionStartComplete",
    "_stub_UserWOWCleanup",
    "_stub_UserSignalRedirectionStartComplete",
    "_stub_UserEnableWindowResizeOptimization",
    "_stub_UserGetResizeDCompositionSynchronizationObject",
    "_stub_UserEnableResizeLayoutSynchronization",
    "_stub_UserBeginLayoutUpdate",
    "_stub_UserIsResizeLayoutSynchronizationEnabled",
    "_stub_UserConfirmResizeCommit",
    "_stub_UserSetActiveProcessForMonitor",
    "_stub_UserGetDisplayAutoRotationPreferencesByProcessId",
    "_stub_UserGetDisplayAutoRotationPreferences",
    "_stub_UserSetDisplayAutoRotationPreferences",
    "_stub_UserSetAutoRotation",
    "_stub_UserGetAutoRotationState",
    "_stub_UserAutoRotateScreen",
    "_stub_UserAcquireIAMKey",
    "_stub_UserSetActivationFilter",
    "_stub_UserSetFallbackForeground",
    "_stub_UserSetBrokeredForeground",
    "_stub_UserDisableImmersiveOwner",
    "_stub_UserClearForeground",
    "_stub_UserEnableIAMAccess",
    "_stub_UserGetProcessUIContextInformation",
    "_stub_UserSetProcessRestrictionExemption",
    "_stub_UserSetWindowArrangement",
    "_stub_UserSetWindowShowState",
    "_stub_UserUpdateWindowTrackingInfo",
    "_stub_UserEnableMouseInPointer",
    "_stub_UserIsMouseInPointerEnabled",
    "_stub_UserPromoteMouseInPointer",
    "_stub_UserAutoPromoteMouseInPointer",
    "_stub_UserEnableMouseInputForCursorSuppression",
    "_stub_UserIsMouseInputEnabled",
    "_stub_UserCheckProcessForClipboardAccess",
    "_stub_UserGetClipboardAccessToken",
    "_stub_UserGetQueueStatusReadonly",
    "_stub_UserCompositionInputSinkLuidFromPoint",
    "_stub_UserCompositionInputSinkViewInstanceIdFromPoint",
    "_stub_UserUpdateWindowInputSinkHints",
    "_stub_UserTransformPoint",
    "_stub_UserTransformRect",
    "_stub_UserGetHimetricScaleFactorFromPixelLocation",
    "_stub_UserGetHDevName",
    "_stub_UserGetDpiForMonitor",
    "_stub_UserReportInertia",
    "_stub_UserLinkDpiCursor",
    "_stub_UserGetCursorDims",
    "_stub_UserGetCursor",
    "_stub_UserInitializeInputDeviceInjection",
    "_stub_UserInitializeGenericHidInjection",
    "_stub_UserInitializePointerDeviceInjection",
    "_stub_UserRemoveInjectionDevice",
    "_stub_UserSetFeatureReportResponse",
    "_stub_UserInjectDeviceInput",
    "_stub_UserInjectMouseInput",
    "_stub_UserInjectKeyboardInput",
    "_stub_UserInjectPointerInput",
    "_stub_UserInjectGenericHidInput",
    "_stub_UserInitializePointerDeviceInjectionEx",
    "_stub_RIMRegisterForInput",
    "_stub_RIMReadInput",
    "_stub_RIMGetDevicePreparsedData",
    "_stub_RIMGetDeviceProperties",
    "_stub_RIMAreSiblingDevices",
    "_stub_RIMFreeInputBuffer",
    "_stub_RIMOnPnpNotification",
    "_stub_RIMOnTimerNotification",
    "_stub_RIMDeviceIoControl",
    "_stub_RIMUnregisterForInput",
    "_stub_RIMSetTestModeStatus",
    "_stub_RIMGetPhysicalDeviceRect",
    "_stub_RIMGetSourceProcessId",
    "_stub_RIMAddInputObserver",
    "_stub_RIMRemoveInputObserver",
    "_stub_RIMUpdateInputObserverRegistration",
    "_stub_RIMObserveNextInput",
    "_stub_RIMGetDevicePreparsedDataLockfree",
    "_stub_RIMGetDevicePropertiesLockfree",
    "_stub_RIMEnableMonitorMappingForDevice",
    "_stub_UserSetCoreWindow",
    "_stub_UserSetCoreWindowPartner",
    "_stub_UserNavigateFocus",
    "_stub_HWCursorUpdatePointer",
    "_stub_UserAcquireInteractiveControlBackgroundAccess",
    "_stub_UserGetInteractiveControlInfo",
    "_stub_UserGetInteractiveControlDeviceInfo",
    "_stub_UserSendInteractiveControlHapticsReport",
    "_stub_UserSetInteractiveControlFocus",
    "_stub_UserInteractiveControlQueryUsage",
    "_stub_UserSetInteractiveCtrlRotationAngle",
    "_stub_UserGetInteractiveCtrlSupportedWaveforms",
    "_stub_UserProcessInkFeedbackCommand",
    "_stub_UserSetProcessInteractionFlags",
    "_stub_MITActivateInputProcessing",
    "_stub_MITWaitForMultipleObjectsEx",
    "_stub_MITDeactivateInputProcessing",
    "_stub_MITSetInputCallbacks",
    "_stub_MITCoreMsgKGetConnectionHandle",
    "_stub_MITCoreMsgKSend",
    "_stub_MITCoreMsgKOpenConnectionTo",
    "_stub_MITUpdateInputGlobals",
    "_stub_MITBindInputTypeToMonitors",
    "_stub_MITEnableMouseIntercept",
    "_stub_MITDisableMouseIntercept",
    "_stub_MITSynthesizeTouchInput",
    "_stub_MITSynthesizeMouseInput",
    "_stub_MITSynthesizeMouseWheel",
    "_stub_MITGetCursorUpdateHandle",
    "_stub_DWMSetInputSystemOutputConfig",
    "_stub_DWMCommitInputSystemOutputConfig",
    "_stub_DWMBindCursorToOutputConfig",
    "_stub_DWMSetCursorOrientation",
    "_stub_UserMsgWaitForMultipleObjectsEx"
};

//////////////////////////////////////////////////////////////////////////
// Windows 2003 SP2 _W32pServiceTable
//////////////////////////////////////////////////////////////////////////
static const char* W32pServiceTable_W2k3Sp2_x64[] = {
    "NtUserGetThreadState",
    "NtUserPeekMessage",
    "NtUserCallOneParam",
    "NtUserGetKeyState",
    "NtUserInvalidateRect",
    "NtUserCallNoParam",
    "NtUserGetMessage",
    "NtUserMessageCall",
    "NtGdiBitBlt",
    "NtGdiGetCharSet",
    "NtUserGetDC",
    "NtGdiSelectBitmap",
    "NtUserWaitMessage",
    "NtUserTranslateMessage",
    "NtUserPostMessage",
    "NtUserQueryWindow",
    "NtUserTranslateAccelerator",
    "NtGdiFlush",
    "NtUserRedrawWindow",
    "NtUserWindowFromPoint",
    "NtUserCallMsgFilter",
    "NtUserValidateTimerCallback",
    "NtUserBeginPaint",
    "NtUserSetTimer",
    "NtUserEndPaint",
    "NtUserSetCursor",
    "NtUserKillTimer",
    "NtUserBuildHwndList",
    "NtUserSelectPalette",
    "NtUserCallNextHookEx",
    "NtUserHideCaret",
    "NtGdiIntersectClipRect",
    "NtUserCallHwndLock",
    "NtUserGetProcessWindowStation",
    "NtGdiDeleteObjectApp",
    "NtUserSetWindowPos",
    "NtUserShowCaret",
    "NtUserEndDeferWindowPosEx",
    "NtUserCallHwndParamLock",
    "NtUserVkKeyScanEx",
    "NtGdiSetDIBitsToDeviceInternal",
    "NtUserCallTwoParam",
    "NtGdiGetRandomRgn",
    "NtUserCopyAcceleratorTable",
    "NtUserNotifyWinEvent",
    "NtGdiExtSelectClipRgn",
    "NtUserIsClipboardFormatAvailable",
    "NtUserSetScrollInfo",
    "NtGdiStretchBlt",
    "NtUserCreateCaret",
    "NtGdiRectVisible",
    "NtGdiCombineRgn",
    "NtGdiGetDCObject",
    "NtUserDispatchMessage",
    "NtUserRegisterWindowMessage",
    "NtGdiExtTextOutW",
    "NtGdiSelectFont",
    "NtGdiRestoreDC",
    "NtGdiSaveDC",
    "NtUserGetForegroundWindow",
    "NtUserShowScrollBar",
    "NtUserFindExistingCursorIcon",
    "NtGdiGetDCDword",
    "NtGdiGetRegionData",
    "NtGdiLineTo",
    "NtUserSystemParametersInfo",
    "NtGdiGetAppClipBox",
    "NtUserGetAsyncKeyState",
    "NtUserGetCPD",
    "NtUserRemoveProp",
    "NtGdiDoPalette",
    "NtGdiPolyPolyDraw",
    "NtUserSetCapture",
    "NtUserEnumDisplayMonitors",
    "NtGdiCreateCompatibleBitmap",
    "NtUserSetProp",
    "NtGdiGetTextCharsetInfo",
    "NtUserSBGetParms",
    "NtUserGetIconInfo",
    "NtUserExcludeUpdateRgn",
    "NtUserSetFocus",
    "NtGdiExtGetObjectW",
    "NtUserDeferWindowPos",
    "NtUserGetUpdateRect",
    "NtGdiCreateCompatibleDC",
    "NtUserGetClipboardSequenceNumber",
    "NtGdiCreatePen",
    "NtUserShowWindow",
    "NtUserGetKeyboardLayoutList",
    "NtGdiPatBlt",
    "NtUserMapVirtualKeyEx",
    "NtUserSetWindowLong",
    "NtGdiHfontCreate",
    "NtUserMoveWindow",
    "NtUserPostThreadMessage",
    "NtUserDrawIconEx",
    "NtUserGetSystemMenu",
    "NtGdiDrawStream",
    "NtUserInternalGetWindowText",
    "NtUserGetWindowDC",
    "NtGdiD3dDrawPrimitives2",
    "NtGdiInvertRgn",
    "NtGdiGetRgnBox",
    "NtGdiGetAndSetDCDword",
    "NtGdiMaskBlt",
    "NtGdiGetWidthTable",
    "NtUserScrollDC",
    "NtUserGetObjectInformation",
    "NtGdiCreateBitmap",
    "NtGdiConsoleTextOut",
    "NtUserFindWindowEx",
    "NtGdiPolyPatBlt",
    "NtUserUnhookWindowsHookEx",
    "NtGdiGetNearestColor",
    "NtGdiTransformPoints",
    "NtGdiGetDCPoint",
    "NtUserCheckImeHotKey",
    "NtGdiCreateDIBBrush",
    "NtGdiGetTextMetricsW",
    "NtUserCreateWindowEx",
    "NtUserSetParent",
    "NtUserGetKeyboardState",
    "NtUserToUnicodeEx",
    "NtUserGetControlBrush",
    "NtUserGetClassName",
    "NtGdiAlphaBlend",
    "NtGdiDdBlt",
    "NtGdiOffsetRgn",
    "NtUserDefSetText",
    "NtGdiGetTextFaceW",
    "NtGdiStretchDIBitsInternal",
    "NtUserSendInput",
    "NtUserGetThreadDesktop",
    "NtGdiCreateRectRgn",
    "NtGdiGetDIBitsInternal",
    "NtUserGetUpdateRgn",
    "NtGdiDeleteClientObj",
    "NtUserGetIconSize",
    "NtUserFillWindow",
    "NtGdiExtCreateRegion",
    "NtGdiComputeXformCoefficients",
    "NtUserSetWindowsHookEx",
    "NtUserNotifyProcessCreate",
    "NtGdiUnrealizeObject",
    "NtUserGetTitleBarInfo",
    "NtGdiRectangle",
    "NtUserSetThreadDesktop",
    "NtUserGetDCEx",
    "NtUserGetScrollBarInfo",
    "NtGdiGetTextExtent",
    "NtUserSetWindowFNID",
    "NtGdiSetLayout",
    "NtUserCalcMenuBar",
    "NtUserThunkedMenuItemInfo",
    "NtGdiExcludeClipRect",
    "NtGdiCreateDIBSection",
    "NtGdiGetDCforBitmap",
    "NtUserDestroyCursor",
    "NtUserDestroyWindow",
    "NtUserCallHwndParam",
    "NtGdiCreateDIBitmapInternal",
    "NtUserOpenWindowStation",
    "NtGdiDdDeleteSurfaceObject",
    "NtGdiEnumFontClose",
    "NtGdiEnumFontOpen",
    "NtGdiEnumFontChunk",
    "NtGdiDdCanCreateSurface",
    "NtGdiDdCreateSurface",
    "NtUserSetCursorIconData",
    "NtGdiDdDestroySurface",
    "NtUserCloseDesktop",
    "NtUserOpenDesktop",
    "NtUserSetProcessWindowStation",
    "NtUserGetAtomName",
    "NtGdiDdResetVisrgn",
    "NtGdiExtCreatePen",
    "NtGdiCreatePaletteInternal",
    "NtGdiSetBrushOrg",
    "NtUserBuildNameList",
    "NtGdiSetPixel",
    "NtUserRegisterClassExWOW",
    "NtGdiCreatePatternBrushInternal",
    "NtUserGetAncestor",
    "NtGdiGetOutlineTextMetricsInternalW",
    "NtGdiSetBitmapBits",
    "NtUserCloseWindowStation",
    "NtUserGetDoubleClickTime",
    "NtUserEnableScrollBar",
    "NtGdiCreateSolidBrush",
    "NtUserGetClassInfoEx",
    "NtGdiCreateClientObj",
    "NtUserUnregisterClass",
    "NtUserDeleteMenu",
    "NtGdiRectInRegion",
    "NtUserScrollWindowEx",
    "NtGdiGetPixel",
    "NtUserSetClassLong",
    "NtUserGetMenuBarInfo",
    "NtGdiDdCreateSurfaceEx",
    "NtGdiDdCreateSurfaceObject",
    "NtGdiGetNearestPaletteIndex",
    "NtGdiDdLockD3D",
    "NtGdiDdUnlockD3D",
    "NtGdiGetCharWidthW",
    "NtUserInvalidateRgn",
    "NtUserGetClipboardOwner",
    "NtUserSetWindowRgn",
    "NtUserBitBltSysBmp",
    "NtGdiGetCharWidthInfo",
    "NtUserValidateRect",
    "NtUserCloseClipboard",
    "NtUserOpenClipboard",
    "NtGdiGetStockObject",
    "NtUserSetClipboardData",
    "NtUserEnableMenuItem",
    "NtUserAlterWindowStyle",
    "NtGdiFillRgn",
    "NtUserGetWindowPlacement",
    "NtGdiModifyWorldTransform",
    "NtGdiGetFontData",
    "NtUserGetOpenClipboardWindow",
    "NtUserSetThreadState",
    "NtGdiOpenDCW",
    "NtUserTrackMouseEvent",
    "NtGdiGetTransform",
    "NtUserDestroyMenu",
    "NtGdiGetBitmapBits",
    "NtUserConsoleControl",
    "NtUserSetActiveWindow",
    "NtUserSetInformationThread",
    "NtUserSetWindowPlacement",
    "NtUserGetControlColor",
    "NtGdiSetMetaRgn",
    "NtGdiSetMiterLimit",
    "NtGdiSetVirtualResolution",
    "NtGdiGetRasterizerCaps",
    "NtUserSetWindowWord",
    "NtUserGetClipboardFormatName",
    "NtUserRealInternalGetMessage",
    "NtUserCreateLocalMemHandle",
    "NtUserAttachThreadInput",
    "NtGdiCreateHalftonePalette",
    "NtUserPaintMenuBar",
    "NtUserSetKeyboardState",
    "NtGdiCombineTransform",
    "NtUserCreateAcceleratorTable",
    "NtUserGetCursorFrameInfo",
    "NtUserGetAltTabInfo",
    "NtUserGetCaretBlinkTime",
    "NtGdiQueryFontAssocInfo",
    "NtUserProcessConnect",
    "NtUserEnumDisplayDevices",
    "NtUserEmptyClipboard",
    "NtUserGetClipboardData",
    "NtUserRemoveMenu",
    "NtGdiSetBoundsRect",
    "NtUserSetInformationProcess",
    "NtGdiGetBitmapDimension",
    "NtUserConvertMemHandle",
    "NtUserDestroyAcceleratorTable",
    "NtUserGetGUIThreadInfo",
    "NtGdiCloseFigure",
    "NtUserSetWindowsHookAW",
    "NtUserSetMenuDefaultItem",
    "NtUserCheckMenuItem",
    "NtUserSetWinEventHook",
    "NtUserUnhookWinEvent",
    "NtGdiSetupPublicCFONT",
    "NtUserLockWindowUpdate",
    "NtUserSetSystemMenu",
    "NtUserThunkedMenuInfo",
    "NtGdiBeginPath",
    "NtGdiEndPath",
    "NtGdiFillPath",
    "NtUserCallHwnd",
    "NtUserDdeInitialize",
    "NtUserModifyUserStartupInfoFlags",
    "NtUserCountClipboardFormats",
    "NtGdiAddFontMemResourceEx",
    "NtGdiEqualRgn",
    "NtGdiGetSystemPaletteUse",
    "NtGdiRemoveFontMemResourceEx",
    "NtUserEnumDisplaySettings",
    "NtUserPaintDesktop",
    "NtGdiExtEscape",
    "NtGdiSetBitmapDimension",
    "GreSetFontEnumeration",
    "NtUserChangeClipboardChain",
    "NtUserResolveDesktop",
    "NtUserSetClipboardViewer",
    "NtUserShowWindowAsync",
    "NtUserSetConsoleReserveKeys",
    "NtGdiCreateColorSpace",
    "NtGdiDeleteColorSpace",
    "NtUserActivateKeyboardLayout",
    "NtGdiAbortDoc",
    "NtGdiAbortPath",
    "NtGdiAddEmbFontToDC",
    "NtGdiAddFontResourceW",
    "NtGdiAddRemoteFontToDC",
    "NtGdiAddRemoteMMInstanceToDC",
    "NtGdiAngleArc",
    "NtGdiAnyLinkedFonts",
    "NtGdiArcInternal",
    "NtGdiBRUSHOBJ_DeleteRbrush",
    "NtGdiBRUSHOBJ_hGetColorTransform",
    "NtGdiBRUSHOBJ_pvAllocRbrush",
    "NtGdiBRUSHOBJ_pvGetRbrush",
    "NtGdiBRUSHOBJ_ulGetBrushColor",
    "NtGdiCLIPOBJ_bEnum",
    "NtGdiCLIPOBJ_cEnumStart",
    "NtGdiCLIPOBJ_ppoGetPath",
    "NtGdiCancelDC",
    "NtGdiChangeGhostFont",
    "NtGdiCheckBitmapBits",
    "NtGdiClearBitmapAttributes",
    "NtGdiClearBrushAttributes",
    "NtGdiColorCorrectPalette",
    "NtGdiConvertMetafileRect",
    "NtGdiCreateColorTransform",
    "NtGdiCreateEllipticRgn",
    "NtGdiCreateHatchBrushInternal",
    "NtGdiCreateMetafileDC",
    "NtGdiCreateRoundRectRgn",
    "NtGdiCreateServerMetaFile",
    "NtGdiD3dContextCreate",
    "NtGdiD3dContextDestroy",
    "NtGdiD3dContextDestroyAll",
    "NtGdiD3dValidateTextureStageState",
    "NtGdiDdAddAttachedSurface",
    "NtGdiDdAlphaBlt",
    "NtGdiDdAttachSurface",
    "NtGdiDdBeginMoCompFrame",
    "NtGdiDdCanCreateD3DBuffer",
    "NtGdiDdColorControl",
    "NtGdiDdCreateD3DBuffer",
    "NtGdiDdCreateDirectDrawObject",
    "NtGdiDdCreateMoComp",
    "NtGdiDdDeleteDirectDrawObject",
    "NtGdiDdDestroyD3DBuffer",
    "NtGdiDdDestroyMoComp",
    "NtGdiDdEndMoCompFrame",
    "NtGdiDdFlip",
    "NtGdiDdFlipToGDISurface",
    "NtGdiDdGetAvailDriverMemory",
    "NtGdiDdGetBltStatus",
    "NtGdiDdGetDC",
    "NtGdiDdGetDriverInfo",
    "NtGdiDdGetDriverState",
    "NtGdiDdGetDxHandle",
    "NtGdiDdGetFlipStatus",
    "NtGdiDdGetInternalMoCompInfo",
    "NtGdiDdGetMoCompBuffInfo",
    "NtGdiDdGetMoCompFormats",
    "NtGdiDdGetMoCompGuids",
    "NtGdiDdGetScanLine",
    "NtGdiDdLock",
    "NtGdiDdQueryDirectDrawObject",
    "NtGdiDdQueryMoCompStatus",
    "NtGdiDdReenableDirectDrawObject",
    "NtGdiDdReleaseDC",
    "NtGdiDdRenderMoComp",
    "NtGdiDdSetColorKey",
    "NtGdiDdSetExclusiveMode",
    "NtGdiDdSetGammaRamp",
    "NtGdiDdSetOverlayPosition",
    "NtGdiDdUnattachSurface",
    "NtGdiDdUnlock",
    "NtGdiDdUpdateOverlay",
    "NtGdiDdWaitForVerticalBlank",
    "NtGdiDeleteColorTransform",
    "NtGdiDescribePixelFormat",
    "NtGdiDoBanding",
    "NtGdiDrawEscape",
    "NtGdiDvpAcquireNotification",
    "NtGdiDvpCanCreateVideoPort",
    "NtGdiDvpColorControl",
    "NtGdiDvpCreateVideoPort",
    "NtGdiDvpDestroyVideoPort",
    "NtGdiDvpFlipVideoPort",
    "NtGdiDvpGetVideoPortBandwidth",
    "NtGdiDvpGetVideoPortConnectInfo",
    "NtGdiDvpGetVideoPortField",
    "NtGdiDvpGetVideoPortFlipStatus",
    "NtGdiDvpGetVideoPortInputFormats",
    "NtGdiDvpGetVideoPortLine",
    "NtGdiDvpGetVideoPortOutputFormats",
    "NtGdiDvpGetVideoSignalStatus",
    "NtGdiDvpReleaseNotification",
    "NtGdiDvpUpdateVideoPort",
    "NtGdiDvpWaitForVideoPortSync",
    "NtGdiDxgGenericThunk",
    "NtGdiEllipse",
    "NtGdiEnableEudc",
    "NtGdiEndDoc",
    "NtGdiEndPage",
    "NtGdiEngAlphaBlend",
    "NtGdiEngAssociateSurface",
    "NtGdiEngBitBlt",
    "NtGdiEngCheckAbort",
    "NtGdiEngComputeGlyphSet",
    "NtGdiEngCopyBits",
    "NtGdiEngCreateBitmap",
    "NtGdiEngCreateClip",
    "NtGdiEngCreateDeviceBitmap",
    "NtGdiEngCreateDeviceSurface",
    "NtGdiEngCreatePalette",
    "NtGdiEngDeleteClip",
    "NtGdiEngDeletePalette",
    "NtGdiEngDeletePath",
    "NtGdiEngDeleteSurface",
    "NtGdiEngEraseSurface",
    "NtGdiEngFillPath",
    "NtGdiEngGradientFill",
    "NtGdiEngLineTo",
    "NtGdiEngLockSurface",
    "NtGdiEngMarkBandingSurface",
    "NtGdiEngPaint",
    "NtGdiEngPlgBlt",
    "NtGdiEngStretchBlt",
    "NtGdiEngStretchBltROP",
    "NtGdiEngStrokeAndFillPath",
    "NtGdiEngStrokePath",
    "NtGdiEngTextOut",
    "NtGdiEngTransparentBlt",
    "NtGdiEngUnlockSurface",
    "NtGdiEnumObjects",
    "NtGdiEudcLoadUnloadLink",
    "NtGdiExtFloodFill",
    "NtGdiFONTOBJ_cGetAllGlyphHandles",
    "NtGdiFONTOBJ_cGetGlyphs",
    "NtGdiFONTOBJ_pQueryGlyphAttrs",
    "NtGdiFONTOBJ_pfdg",
    "NtGdiFONTOBJ_pifi",
    "NtGdiFONTOBJ_pvTrueTypeFontFile",
    "NtGdiFONTOBJ_pxoGetXform",
    "NtGdiFONTOBJ_vGetInfo",
    "NtGdiFlattenPath",
    "NtGdiFontIsLinked",
    "NtGdiForceUFIMapping",
    "NtGdiFrameRgn",
    "NtGdiFullscreenControl",
    "NtGdiGetBoundsRect",
    "NtGdiGetCharABCWidthsW",
    "NtGdiGetCharacterPlacementW",
    "NtGdiGetColorAdjustment",
    "NtGdiGetColorSpaceforBitmap",
    "NtGdiGetDeviceCaps",
    "NtGdiGetDeviceCapsAll",
    "NtGdiGetDeviceGammaRamp",
    "NtGdiGetDeviceWidth",
    "NtGdiGetDhpdev",
    "NtGdiGetETM",
    "NtGdiGetEmbUFI",
    "NtGdiGetEmbedFonts",
    "NtGdiGetEudcTimeStampEx",
    "NtGdiGetFontResourceInfoInternalW",
    "NtGdiGetFontUnicodeRanges",
    "NtGdiGetGlyphIndicesW",
    "NtGdiGetGlyphIndicesWInternal",
    "NtGdiGetGlyphOutline",
    "NtGdiGetKerningPairs",
    "NtGdiGetLinkedUFIs",
    "NtGdiGetMiterLimit",
    "NtGdiGetMonitorID",
    "NtGdiGetObjectBitmapHandle",
    "NtGdiGetPath",
    "NtGdiGetPerBandInfo",
    "NtGdiGetRealizationInfo",
    "NtGdiGetServerMetaFileBits",
    "NtGdiGetSpoolMessage",
    "NtGdiGetStats",
    "NtGdiGetStringBitmapW",
    "NtGdiGetTextExtentExW",
    "NtGdiGetUFI",
    "NtGdiGetUFIPathname",
    "NtGdiGradientFill",
    "NtGdiHT_Get8BPPFormatPalette",
    "NtGdiHT_Get8BPPMaskPalette",
    "NtGdiIcmBrushInfo",
    "EngRestoreFloatingPointState",
    "NtGdiInitSpool",
    "NtGdiMakeFontDir",
    "NtGdiMakeInfoDC",
    "NtGdiMakeObjectUnXferable",
    "NtGdiMakeObjectXferable",
    "NtGdiMirrorWindowOrg",
    "NtGdiMonoBitmap",
    "NtGdiMoveTo",
    "NtGdiOffsetClipRgn",
    "NtGdiPATHOBJ_bEnum",
    "NtGdiPATHOBJ_bEnumClipLines",
    "NtGdiPATHOBJ_vEnumStart",
    "NtGdiPATHOBJ_vEnumStartClipLines",
    "NtGdiPATHOBJ_vGetBounds",
    "NtGdiPathToRegion",
    "NtGdiPlgBlt",
    "NtGdiPolyDraw",
    "NtGdiPolyTextOutW",
    "NtGdiPtInRegion",
    "NtGdiPtVisible",
    "NtGdiQueryFonts",
    "NtGdiRemoveFontResourceW",
    "NtGdiRemoveMergeFont",
    "NtGdiResetDC",
    "NtGdiResizePalette",
    "NtGdiRoundRect",
    "NtGdiSTROBJ_bEnum",
    "NtGdiSTROBJ_bEnumPositionsOnly",
    "NtGdiSTROBJ_bGetAdvanceWidths",
    "NtGdiSTROBJ_dwGetCodePage",
    "NtGdiSTROBJ_vEnumStart",
    "NtGdiScaleViewportExtEx",
    "NtGdiScaleWindowExtEx",
    "GreSelectBrush",
    "NtGdiSelectClipPath",
    "NtGdiSelectPen",
    "NtGdiSetBitmapAttributes",
    "NtGdiSetBrushAttributes",
    "NtGdiSetColorAdjustment",
    "NtGdiSetColorSpace",
    "NtGdiSetDeviceGammaRamp",
    "NtGdiSetFontXform",
    "NtGdiSetIcmMode",
    "NtGdiSetLinkedUFIs",
    "NtGdiSetMagicColors",
    "NtGdiSetPUMPDOBJ",
    "NtGdiSetPixelFormat",
    "NtGdiSetRectRgn",
    "NtGdiSetSizeDevice",
    "NtGdiSetSystemPaletteUse",
    "NtGdiSetTextJustification",
    "NtGdiStartDoc",
    "NtGdiStartPage",
    "NtGdiStrokeAndFillPath",
    "NtGdiStrokePath",
    "NtGdiSwapBuffers",
    "NtGdiTransparentBlt",
    "NtGdiUMPDEngFreeUserMem",
    "NtGdiUnloadPrinterDriver",
    "EngRestoreFloatingPointState",
    "NtGdiUpdateColors",
    "NtGdiUpdateTransform",
    "NtGdiWidenPath",
    "NtGdiXFORMOBJ_bApplyXform",
    "NtGdiXFORMOBJ_iGetXform",
    "NtGdiXLATEOBJ_cGetPalette",
    "NtGdiXLATEOBJ_hGetColorTransform",
    "NtGdiXLATEOBJ_iXlate",
    "NtUserAssociateInputContext",
    "NtUserBlockInput",
    "NtUserBuildHimcList",
    "NtUserBuildPropList",
    "NtUserCallHwndOpt",
    "NtUserChangeDisplaySettings",
    "NtUserChildWindowFromPointEx",
    "NtUserClipCursor",
    "NtUserCreateDesktop",
    "NtUserCreateInputContext",
    "NtUserCreateWindowStation",
    "NtUserCtxDisplayIOCtl",
    "NtUserDdeGetQualityOfService",
    "NtUserDdeSetQualityOfService",
    "NtUserDestroyInputContext",
    "NtUserDisableThreadIme",
    "NtUserDragDetect",
    "NtUserDragObject",
    "NtUserDrawAnimatedRects",
    "NtUserDrawCaption",
    "NtUserDrawCaptionTemp",
    "NtUserDrawMenuBarTemp",
    "NtUserEndMenu",
    "NtUserEvent",
    "NtUserFlashWindowEx",
    "NtUserGetAppImeLevel",
    "NtUserGetCaretPos",
    "NtUserGetClipCursor",
    "NtUserGetClipboardViewer",
    "NtUserGetComboBoxInfo",
    "NtUserGetCursorInfo",
    "NtUserGetGuiResources",
    "NtUserGetImeHotKey",
    "NtUserGetImeInfoEx",
    "NtUserGetInternalWindowPos",
    "NtUserGetKeyNameText",
    "NtUserGetKeyboardLayoutName",
    "NtUserGetLayeredWindowAttributes",
    "NtUserGetListBoxInfo",
    "NtUserGetMenuIndex",
    "NtUserGetMenuItemRect",
    "NtUserGetMouseMovePointsEx",
    "NtUserGetPriorityClipboardFormat",
    "NtUserGetRawInputBuffer",
    "NtUserGetRawInputData",
    "NtUserGetRawInputDeviceInfo",
    "NtUserGetRawInputDeviceList",
    "NtUserGetRegisteredRawInputDevices",
    "NtUserGetWOWClass",
    "NtUserHardErrorControl",
    "NtUserHiliteMenuItem",
    "NtUserImpersonateDdeClientWindow",
    "NtUserInitTask",
    "NtUserInitialize",
    "NtUserInitializeClientPfnArrays",
    "NtUserLoadKeyboardLayoutEx",
    "NtUserLockWindowStation",
    "NtUserLockWorkStation",
    "NtUserMNDragLeave",
    "NtUserMNDragOver",
    "NtUserMenuItemFromPoint",
    "NtUserMinMaximize",
    "NtUserNotifyIMEStatus",
    "NtUserOpenInputDesktop",
    "NtUserPrintWindow",
    "NtUserQueryInformationThread",
    "NtUserQueryInputContext",
    "NtUserQuerySendMessage",
    "NtUserRealChildWindowFromPoint",
    "NtUserRealWaitMessageEx",
    "NtUserRegisterHotKey",
    "NtUserRegisterRawInputDevices",
    "NtUserRegisterTasklist",
    "NtUserRegisterUserApiHook",
    "NtUserRemoteConnect",
    "NtUserRemoteRedrawRectangle",
    "NtUserRemoteRedrawScreen",
    "NtUserRemoteStopScreenUpdates",
    "NtUserResolveDesktopForWOW",
    "NtUserSetAppImeLevel",
    "NtUserSetClassWord",
    "NtUserSetCursorContents",
    "NtUserSetImeHotKey",
    "NtUserSetImeInfoEx",
    "NtUserSetImeOwnerWindow",
    "NtUserSetInternalWindowPos",
    "NtUserSetLayeredWindowAttributes",
    "NtUserSetLogonNotifyWindow",
    "NtUserSetMenu",
    "NtUserSetMenuContextHelpId",
    "NtUserSetMenuFlagRtoL",
    "NtUserSetObjectInformation",
    "NtUserSetShellWindowEx",
    "NtUserSetSysColors",
    "NtUserSetSystemCursor",
    "NtUserSetSystemTimer",
    "NtUserSetThreadLayoutHandles",
    "NtUserSetWindowStationUser",
    "NtUserSoundSentry",
    "NtUserSwitchDesktop",
    "NtUserTestForInteractiveUser",
    "NtUserTrackPopupMenuEx",
    "NtUserUnloadKeyboardLayout",
    "NtUserUnlockWindowStation",
    "NtUserUnregisterHotKey",
    "NtUserUnregisterUserApiHook",
    "NtUserUpdateInputContext",
    "NtUserUpdateInstance",
    "NtUserUpdateLayeredWindow",
    "NtUserUpdatePerUserSystemParameters",
    "NtUserUserHandleGrantAccess",
    "NtUserValidateHandleSecure",
    "NtUserWaitForInputIdle",
    "NtUserWaitForMsgAndEvent",
    "NtUserSetClassLongPtr",
    "NtUserSetWindowLongPtr",
    "UMPDDrvQuerySpoolType",
    "NtUserYieldTask"
};

//////////////////////////////////////////////////////////////////////////
// Windows Vista SP0 _W32pServiceTable
//////////////////////////////////////////////////////////////////////////
static const char* W32pServiceTable_VistaSp0_x64[] = {
    "NtUserGetThreadState",
    "NtUserPeekMessage",
    "NtUserCallOneParam",
    "NtUserGetKeyState",
    "NtUserInvalidateRect",
    "NtUserCallNoParam",
    "NtUserGetMessage",
    "NtUserMessageCall",
    "NtGdiBitBlt",
    "NtGdiGetCharSet",
    "NtUserGetDC",
    "NtGdiSelectBitmap",
    "NtUserWaitMessage",
    "NtUserTranslateMessage",
    "NtUserGetProp",
    "NtUserPostMessage",
    "NtUserQueryWindow",
    "NtUserTranslateAccelerator",
    "NtGdiFlush",
    "NtUserRedrawWindow",
    "NtUserWindowFromPoint",
    "NtUserCallMsgFilter",
    "NtUserValidateTimerCallback",
    "NtUserBeginPaint",
    "NtUserSetTimer",
    "NtUserEndPaint",
    "NtUserSetCursor",
    "NtUserKillTimer",
    "NtUserBuildHwndList",
    "NtUserSelectPalette",
    "NtUserCallNextHookEx",
    "NtUserHideCaret",
    "NtGdiIntersectClipRect",
    "NtUserCallHwndLock",
    "NtUserGetProcessWindowStation",
    "NtGdiDeleteObjectApp",
    "NtUserSetWindowPos",
    "NtUserShowCaret",
    "NtUserEndDeferWindowPosEx",
    "NtUserCallHwndParamLock",
    "NtUserVkKeyScanEx",
    "NtGdiSetDIBitsToDeviceInternal",
    "NtUserCallTwoParam",
    "NtGdiGetRandomRgn",
    "NtUserCopyAcceleratorTable",
    "NtUserNotifyWinEvent",
    "NtGdiExtSelectClipRgn",
    "NtUserIsClipboardFormatAvailable",
    "NtUserSetScrollInfo",
    "NtGdiStretchBlt",
    "NtUserCreateCaret",
    "NtGdiRectVisible",
    "NtGdiCombineRgn",
    "NtGdiGetDCObject",
    "NtUserDispatchMessage",
    "NtUserRegisterWindowMessage",
    "NtGdiExtTextOutW",
    "NtGdiSelectFont",
    "NtGdiRestoreDC",
    "NtGdiSaveDC",
    "NtUserGetForegroundWindow",
    "NtUserShowScrollBar",
    "NtUserFindExistingCursorIcon",
    "NtGdiGetDCDword",
    "NtGdiGetRegionData",
    "NtGdiLineTo",
    "NtUserSystemParametersInfo",
    "NtGdiGetAppClipBox",
    "NtUserGetAsyncKeyState",
    "NtUserGetCPD",
    "NtUserRemoveProp",
    "NtGdiDoPalette",
    "NtGdiPolyPolyDraw",
    "NtUserSetCapture",
    "NtUserEnumDisplayMonitors",
    "NtGdiCreateCompatibleBitmap",
    "NtUserSetProp",
    "NtGdiGetTextCharsetInfo",
    "NtUserSBGetParms",
    "NtUserGetIconInfo",
    "NtUserExcludeUpdateRgn",
    "NtUserSetFocus",
    "NtGdiExtGetObjectW",
    "NtUserDeferWindowPos",
    "NtUserGetUpdateRect",
    "NtGdiCreateCompatibleDC",
    "NtUserGetClipboardSequenceNumber",
    "NtGdiCreatePen",
    "NtUserShowWindow",
    "NtUserGetKeyboardLayoutList",
    "NtGdiPatBlt",
    "NtUserMapVirtualKeyEx",
    "NtUserSetWindowLong",
    "NtGdiHfontCreate",
    "NtUserMoveWindow",
    "NtUserPostThreadMessage",
    "NtUserDrawIconEx",
    "NtUserGetSystemMenu",
    "NtGdiDrawStream",
    "NtUserInternalGetWindowText",
    "NtUserGetWindowDC",
    "NtGdiD3dDrawPrimitives2",
    "NtGdiInvertRgn",
    "NtGdiGetRgnBox",
    "NtGdiGetAndSetDCDword",
    "NtGdiMaskBlt",
    "NtGdiGetWidthTable",
    "NtUserScrollDC",
    "NtUserGetObjectInformation",
    "NtGdiCreateBitmap",
    "NtGdiConsoleTextOut",
    "NtUserFindWindowEx",
    "NtGdiPolyPatBlt",
    "NtUserUnhookWindowsHookEx",
    "NtGdiGetNearestColor",
    "NtGdiTransformPoints",
    "NtGdiGetDCPoint",
    "NtUserCheckImeHotKey",
    "NtGdiCreateDIBBrush",
    "NtGdiGetTextMetricsW",
    "NtUserCreateWindowEx",
    "NtUserSetParent",
    "NtUserGetKeyboardState",
    "NtUserToUnicodeEx",
    "NtUserGetControlBrush",
    "NtUserGetClassName",
    "NtGdiAlphaBlend",
    "NtGdiDdBlt",
    "NtGdiOffsetRgn",
    "NtUserDefSetText",
    "NtGdiGetTextFaceW",
    "NtGdiStretchDIBitsInternal",
    "NtUserSendInput",
    "NtUserGetThreadDesktop",
    "NtGdiCreateRectRgn",
    "NtGdiGetDIBitsInternal",
    "NtUserGetUpdateRgn",
    "NtGdiDeleteClientObj",
    "NtUserGetIconSize",
    "NtUserFillWindow",
    "NtGdiExtCreateRegion",
    "NtGdiComputeXformCoefficients",
    "NtUserSetWindowsHookEx",
    "NtUserNotifyProcessCreate",
    "NtGdiUnrealizeObject",
    "NtUserGetTitleBarInfo",
    "NtGdiRectangle",
    "NtUserSetThreadDesktop",
    "NtUserGetDCEx",
    "NtUserGetScrollBarInfo",
    "NtGdiGetTextExtent",
    "NtUserSetWindowFNID",
    "NtGdiSetLayout",
    "NtUserCalcMenuBar",
    "NtUserThunkedMenuItemInfo",
    "NtGdiExcludeClipRect",
    "NtGdiCreateDIBSection",
    "NtGdiGetDCforBitmap",
    "NtUserDestroyCursor",
    "NtUserDestroyWindow",
    "NtUserCallHwndParam",
    "NtGdiCreateDIBitmapInternal",
    "NtUserOpenWindowStation",
    "NtGdiDdDeleteSurfaceObject",
    "NtGdiEnumFontClose",
    "NtGdiEnumFontOpen",
    "NtGdiEnumFontChunk",
    "NtGdiDdCanCreateSurface",
    "NtGdiDdCreateSurface",
    "NtUserSetCursorIconData",
    "NtGdiDdDestroySurface",
    "NtUserCloseDesktop",
    "NtUserOpenDesktop",
    "NtUserSetProcessWindowStation",
    "NtUserGetAtomName",
    "NtGdiDdResetVisrgn",
    "NtGdiExtCreatePen",
    "NtGdiCreatePaletteInternal",
    "NtGdiSetBrushOrg",
    "NtUserBuildNameList",
    "NtGdiSetPixel",
    "NtUserRegisterClassExWOW",
    "NtGdiCreatePatternBrushInternal",
    "NtUserGetAncestor",
    "NtGdiGetOutlineTextMetricsInternalW",
    "NtGdiSetBitmapBits",
    "NtUserCloseWindowStation",
    "NtUserGetDoubleClickTime",
    "NtUserEnableScrollBar",
    "NtGdiCreateSolidBrush",
    "NtUserGetClassInfoEx",
    "NtGdiCreateClientObj",
    "NtUserUnregisterClass",
    "NtUserDeleteMenu",
    "NtGdiRectInRegion",
    "NtUserScrollWindowEx",
    "NtGdiGetPixel",
    "NtUserSetClassLong",
    "NtUserGetMenuBarInfo",
    "NtGdiDdCreateSurfaceEx",
    "NtGdiDdCreateSurfaceObject",
    "NtGdiGetNearestPaletteIndex",
    "NtGdiDdLockD3D",
    "NtGdiDdUnlockD3D",
    "NtGdiGetCharWidthW",
    "NtUserInvalidateRgn",
    "NtUserGetClipboardOwner",
    "NtUserSetWindowRgn",
    "NtUserBitBltSysBmp",
    "NtGdiGetCharWidthInfo",
    "NtUserValidateRect",
    "NtUserCloseClipboard",
    "NtUserOpenClipboard",
    "NtGdiGetStockObject",
    "NtUserSetClipboardData",
    "NtUserEnableMenuItem",
    "NtUserAlterWindowStyle",
    "NtGdiFillRgn",
    "NtUserGetWindowPlacement",
    "NtGdiModifyWorldTransform",
    "NtGdiGetFontData",
    "NtUserGetOpenClipboardWindow",
    "NtUserSetThreadState",
    "NtGdiOpenDCW",
    "NtUserTrackMouseEvent",
    "NtGdiGetTransform",
    "NtUserDestroyMenu",
    "NtGdiGetBitmapBits",
    "NtUserConsoleControl",
    "NtUserSetActiveWindow",
    "NtUserSetInformationThread",
    "NtUserSetWindowPlacement",
    "NtUserGetControlColor",
    "NtGdiSetMetaRgn",
    "NtGdiSetMiterLimit",
    "NtGdiSetVirtualResolution",
    "NtGdiGetRasterizerCaps",
    "NtUserSetWindowWord",
    "NtUserGetClipboardFormatName",
    "NtUserRealInternalGetMessage",
    "NtUserCreateLocalMemHandle",
    "NtUserAttachThreadInput",
    "NtGdiCreateHalftonePalette",
    "NtUserPaintMenuBar",
    "NtUserSetKeyboardState",
    "NtGdiCombineTransform",
    "NtUserCreateAcceleratorTable",
    "NtUserGetCursorFrameInfo",
    "NtUserGetAltTabInfo",
    "NtUserGetCaretBlinkTime",
    "NtGdiQueryFontAssocInfo",
    "NtUserProcessConnect",
    "NtUserEnumDisplayDevices",
    "NtUserEmptyClipboard",
    "NtUserGetClipboardData",
    "NtUserRemoveMenu",
    "NtGdiSetBoundsRect",
    "NtUserSetInformationProcess",
    "NtGdiGetBitmapDimension",
    "NtUserConvertMemHandle",
    "NtUserDestroyAcceleratorTable",
    "NtUserGetGUIThreadInfo",
    "NtGdiCloseFigure",
    "NtUserSetWindowsHookAW",
    "NtUserSetMenuDefaultItem",
    "NtUserCheckMenuItem",
    "NtUserSetWinEventHook",
    "NtUserUnhookWinEvent",
    "NtGdiSetupPublicCFONT",
    "NtUserLockWindowUpdate",
    "NtUserSetSystemMenu",
    "NtUserThunkedMenuInfo",
    "NtGdiBeginPath",
    "NtGdiEndPath",
    "NtGdiFillPath",
    "NtUserCallHwnd",
    "NtUserDdeInitialize",
    "NtUserModifyUserStartupInfoFlags",
    "NtUserCountClipboardFormats",
    "NtGdiAddFontMemResourceEx",
    "NtGdiEqualRgn",
    "NtGdiGetSystemPaletteUse",
    "NtGdiRemoveFontMemResourceEx",
    "NtUserEnumDisplaySettings",
    "NtUserPaintDesktop",
    "NtGdiExtEscape",
    "NtGdiSetBitmapDimension",
    "NtGdiSetFontEnumeration",
    "NtUserChangeClipboardChain",
    "NtUserResolveDesktop",
    "NtUserSetClipboardViewer",
    "NtUserShowWindowAsync",
    "NtUserSetConsoleReserveKeys",
    "NtGdiCreateColorSpace",
    "NtGdiDeleteColorSpace",
    "NtUserActivateKeyboardLayout",
    "NtGdiAbortDoc",
    "NtGdiAbortPath",
    "NtGdiAddEmbFontToDC",
    "NtGdiAddFontResourceW",
    "NtGdiAddRemoteFontToDC",
    "NtGdiAddRemoteMMInstanceToDC",
    "NtGdiAngleArc",
    "NtGdiAnyLinkedFonts",
    "NtGdiArcInternal",
    "NtGdiBRUSHOBJ_DeleteRbrush",
    "NtGdiBRUSHOBJ_hGetColorTransform",
    "NtGdiBRUSHOBJ_pvAllocRbrush",
    "NtGdiBRUSHOBJ_pvGetRbrush",
    "NtGdiBRUSHOBJ_ulGetBrushColor",
    "NtGdiCLIPOBJ_bEnum",
    "NtGdiCLIPOBJ_cEnumStart",
    "NtGdiCLIPOBJ_ppoGetPath",
    "NtGdiCancelDC",
    "NtGdiChangeGhostFont",
    "NtGdiCheckBitmapBits",
    "NtGdiClearBitmapAttributes",
    "NtGdiClearBrushAttributes",
    "NtGdiColorCorrectPalette",
    "NtGdiConfigureOPMProtectedOutput",
    "NtGdiConvertMetafileRect",
    "NtGdiCreateColorTransform",
    "NtGdiCreateEllipticRgn",
    "NtGdiCreateHatchBrushInternal",
    "NtGdiCreateMetafileDC",
    "NtGdiCreateOPMProtectedOutputs",
    "NtGdiCreateRoundRectRgn",
    "NtGdiCreateServerMetaFile",
    "NtGdiD3dContextCreate",
    "NtGdiD3dContextDestroy",
    "NtGdiD3dContextDestroyAll",
    "NtGdiD3dValidateTextureStageState",
    "NtGdiDDCCIGetCapabilitiesString",
    "NtGdiDDCCIGetCapabilitiesStringLength",
    "NtGdiDDCCIGetTimingReport",
    "NtGdiDDCCIGetVCPFeature",
    "NtGdiDDCCISaveCurrentSettings",
    "NtGdiDDCCISetVCPFeature",
    "NtGdiDdAddAttachedSurface",
    "NtGdiDdAlphaBlt",
    "NtGdiDdAttachSurface",
    "NtGdiDdBeginMoCompFrame",
    "NtGdiDdCanCreateD3DBuffer",
    "NtGdiDdColorControl",
    "NtGdiDdCreateD3DBuffer",
    "NtGdiDdCreateDirectDrawObject",
    "NtGdiDdCreateMoComp",
    "NtGdiDdDDICheckExclusiveOwnership",
    "NtGdiDdDDICheckMonitorPowerState",
    "NtGdiDdDDICheckOcclusion",
    "NtGdiDdDDICloseAdapter",
    "NtGdiDdDDICreateAllocation",
    "NtGdiDdDDICreateContext",
    "NtGdiDdDDICreateDCFromMemory",
    "NtGdiDdDDICreateDevice",
    "NtGdiDdDDICreateOverlay",
    "NtGdiDdDDICreateSynchronizationObject",
    "NtGdiDdDDIDestroyAllocation",
    "NtGdiDdDDIDestroyContext",
    "NtGdiDdDDIDestroyDCFromMemory",
    "NtGdiDdDDIDestroyDevice",
    "NtGdiDdDDIDestroyOverlay",
    "NtGdiDdDDIDestroySynchronizationObject",
    "NtGdiDdDDIEscape",
    "NtGdiDdDDIFlipOverlay",
    "NtGdiDdDDIGetContextSchedulingPriority",
    "NtGdiDdDDIGetDeviceState",
    "NtGdiDdDDIGetDisplayModeList",
    "NtGdiDdDDIGetMultisampleMethodList",
    "NtGdiDdDDIGetPresentHistory",
    "NtGdiDdDDIGetProcessSchedulingPriorityClass",
    "NtGdiDdDDIGetRuntimeData",
    "NtGdiDdDDIGetScanLine",
    "NtGdiDdDDIGetSharedPrimaryHandle",
    "NtGdiDdDDIInvalidateActiveVidPn",
    "NtGdiDdDDILock",
    "NtGdiDdDDIOpenAdapterFromDeviceName",
    "NtGdiDdDDIOpenAdapterFromHdc",
    "NtGdiDdDDIOpenResource",
    "NtGdiDdDDIPollDisplayChildren",
    "NtGdiDdDDIPresent",
    "NtGdiDdDDIQueryAdapterInfo",
    "NtGdiDdDDIQueryAllocationResidency",
    "NtGdiDdDDIQueryResourceInfo",
    "NtGdiDdDDIQueryStatistics",
    "NtGdiDdDDIReleaseProcessVidPnSourceOwners",
    "NtGdiDdDDIRender",
    "NtGdiDdDDISetAllocationPriority",
    "NtGdiDdDDISetContextSchedulingPriority",
    "NtGdiDdDDISetDisplayMode",
    "NtGdiDdDDISetDisplayPrivateDriverFormat",
    "NtGdiDdDDISetGammaRamp",
    "NtGdiDdDDISetProcessSchedulingPriorityClass",
    "NtGdiDdDDISetQueuedLimit",
    "NtGdiDdDDISetVidPnSourceOwner",
    "NtGdiDdDDISharedPrimaryLockNotification",
    "NtGdiDdDDISharedPrimaryUnLockNotification",
    "NtGdiDdDDISignalSynchronizationObject",
    "NtGdiDdDDIUnlock",
    "NtGdiDdDDIUpdateOverlay",
    "NtGdiDdDDIWaitForIdle",
    "NtGdiDdDDIWaitForSynchronizationObject",
    "NtGdiDdDDIWaitForVerticalBlankEvent",
    "NtGdiDdDeleteDirectDrawObject",
    "NtGdiDdDestroyD3DBuffer",
    "NtGdiDdDestroyMoComp",
    "NtGdiDdEndMoCompFrame",
    "NtGdiDdFlip",
    "NtGdiDdFlipToGDISurface",
    "NtGdiDdGetAvailDriverMemory",
    "NtGdiDdGetBltStatus",
    "NtGdiDdGetDC",
    "NtGdiDdGetDriverInfo",
    "NtGdiDdGetDriverState",
    "NtGdiDdGetDxHandle",
    "NtGdiDdGetFlipStatus",
    "NtGdiDdGetInternalMoCompInfo",
    "NtGdiDdGetMoCompBuffInfo",
    "NtGdiDdGetMoCompFormats",
    "NtGdiDdGetMoCompGuids",
    "NtGdiDdGetScanLine",
    "NtGdiDdLock",
    "NtGdiDdQueryDirectDrawObject",
    "NtGdiDdQueryMoCompStatus",
    "NtGdiDdReenableDirectDrawObject",
    "NtGdiDdReleaseDC",
    "NtGdiDdRenderMoComp",
    "NtGdiDdSetColorKey",
    "NtGdiDdSetExclusiveMode",
    "NtGdiDdSetGammaRamp",
    "NtGdiDdSetOverlayPosition",
    "NtGdiDdUnattachSurface",
    "NtGdiDdUnlock",
    "NtGdiDdUpdateOverlay",
    "NtGdiDdWaitForVerticalBlank",
    "NtGdiDeleteColorTransform",
    "NtGdiDescribePixelFormat",
    "NtGdiDestroyOPMProtectedOutput",
    "NtGdiDestroyPhysicalMonitor",
    "NtGdiDoBanding",
    "NtGdiDrawEscape",
    "NtGdiDvpAcquireNotification",
    "NtGdiDvpCanCreateVideoPort",
    "NtGdiDvpColorControl",
    "NtGdiDvpCreateVideoPort",
    "NtGdiDvpDestroyVideoPort",
    "NtGdiDvpFlipVideoPort",
    "NtGdiDvpGetVideoPortBandwidth",
    "NtGdiDvpGetVideoPortConnectInfo",
    "NtGdiDvpGetVideoPortField",
    "NtGdiDvpGetVideoPortFlipStatus",
    "NtGdiDvpGetVideoPortInputFormats",
    "NtGdiDvpGetVideoPortLine",
    "NtGdiDvpGetVideoPortOutputFormats",
    "NtGdiDvpGetVideoSignalStatus",
    "NtGdiDvpReleaseNotification",
    "NtGdiDvpUpdateVideoPort",
    "NtGdiDvpWaitForVideoPortSync",
    "NtGdiDwmGetDirtyRgn",
    "NtGdiDwmGetSurfaceData",
    "NtGdiDxgGenericThunk",
    "NtGdiEllipse",
    "NtGdiEnableEudc",
    "NtGdiEndDoc",
    "NtGdiEndPage",
    "NtGdiEngAlphaBlend",
    "NtGdiEngAssociateSurface",
    "NtGdiEngBitBlt",
    "NtGdiEngCheckAbort",
    "NtGdiEngComputeGlyphSet",
    "NtGdiEngCopyBits",
    "NtGdiEngCreateBitmap",
    "NtGdiEngCreateClip",
    "NtGdiEngCreateDeviceBitmap",
    "NtGdiEngCreateDeviceSurface",
    "NtGdiEngCreatePalette",
    "NtGdiEngDeleteClip",
    "NtGdiEngDeletePalette",
    "NtGdiEngDeletePath",
    "NtGdiEngDeleteSurface",
    "NtGdiEngEraseSurface",
    "NtGdiEngFillPath",
    "NtGdiEngGradientFill",
    "NtGdiEngLineTo",
    "NtGdiEngLockSurface",
    "NtGdiEngMarkBandingSurface",
    "NtGdiEngPaint",
    "NtGdiEngPlgBlt",
    "NtGdiEngStretchBlt",
    "NtGdiEngStretchBltROP",
    "NtGdiEngStrokeAndFillPath",
    "NtGdiEngStrokePath",
    "NtGdiEngTextOut",
    "NtGdiEngTransparentBlt",
    "NtGdiEngUnlockSurface",
    "NtGdiEnumObjects",
    "NtGdiEudcLoadUnloadLink",
    "NtGdiExtFloodFill",
    "NtGdiFONTOBJ_cGetAllGlyphHandles",
    "NtGdiFONTOBJ_cGetGlyphs",
    "NtGdiFONTOBJ_pQueryGlyphAttrs",
    "NtGdiFONTOBJ_pfdg",
    "NtGdiFONTOBJ_pifi",
    "NtGdiFONTOBJ_pvTrueTypeFontFile",
    "NtGdiFONTOBJ_pxoGetXform",
    "NtGdiFONTOBJ_vGetInfo",
    "NtGdiFlattenPath",
    "NtGdiFontIsLinked",
    "NtGdiForceUFIMapping",
    "NtGdiFrameRgn",
    "NtGdiFullscreenControl",
    "NtGdiGetBoundsRect",
    "NtGdiGetCOPPCompatibleOPMInformation",
    "NtGdiGetCertificate",
    "NtGdiGetCertificateSize",
    "NtGdiGetCharABCWidthsW",
    "NtGdiGetCharacterPlacementW",
    "NtGdiGetColorAdjustment",
    "NtGdiGetColorSpaceforBitmap",
    "NtGdiGetDeviceCaps",
    "NtGdiGetDeviceCapsAll",
    "NtGdiGetDeviceGammaRamp",
    "NtGdiGetDeviceWidth",
    "NtGdiGetDhpdev",
    "NtGdiGetETM",
    "NtGdiGetEmbUFI",
    "NtGdiGetEmbedFonts",
    "NtGdiGetEudcTimeStampEx",
    "NtGdiGetFontResourceInfoInternalW",
    "NtGdiGetFontUnicodeRanges",
    "NtGdiGetGlyphIndicesW",
    "NtGdiGetGlyphIndicesWInternal",
    "NtGdiGetGlyphOutline",
    "NtGdiGetKerningPairs",
    "NtGdiGetLinkedUFIs",
    "NtGdiGetMiterLimit",
    "NtGdiGetMonitorID",
    "NtGdiGetNumberOfPhysicalMonitors",
    "NtGdiGetOPMInformation",
    "NtGdiGetOPMRandomNumber",
    "NtGdiGetObjectBitmapHandle",
    "NtGdiGetPath",
    "NtGdiGetPerBandInfo",
    "NtGdiGetPhysicalMonitorDescription",
    "NtGdiGetPhysicalMonitors",
    "NtGdiGetRealizationInfo",
    "NtGdiGetServerMetaFileBits",
    "NtGdiGetSpoolMessage",
    "NtGdiGetStats",
    "NtGdiGetStringBitmapW",
    "NtGdiGetSuggestedOPMProtectedOutputArraySize",
    "NtGdiGetTextExtentExW",
    "NtGdiGetUFI",
    "NtGdiGetUFIPathname",
    "NtGdiGradientFill",
    "NtGdiHT_Get8BPPFormatPalette",
    "NtGdiHT_Get8BPPMaskPalette",
    "NtGdiIcmBrushInfo",
    "EngRestoreFloatingPointState",
    "NtGdiInitSpool",
    "NtGdiMakeFontDir",
    "NtGdiMakeInfoDC",
    "NtGdiMakeObjectUnXferable",
    "NtGdiMakeObjectXferable",
    "NtGdiMirrorWindowOrg",
    "NtGdiMonoBitmap",
    "NtGdiMoveTo",
    "NtGdiOffsetClipRgn",
    "NtGdiPATHOBJ_bEnum",
    "NtGdiPATHOBJ_bEnumClipLines",
    "NtGdiPATHOBJ_vEnumStart",
    "NtGdiPATHOBJ_vEnumStartClipLines",
    "NtGdiPATHOBJ_vGetBounds",
    "NtGdiPathToRegion",
    "NtGdiPlgBlt",
    "NtGdiPolyDraw",
    "NtGdiPolyTextOutW",
    "NtGdiPtInRegion",
    "NtGdiPtVisible",
    "NtGdiQueryFonts",
    "NtGdiRemoveFontResourceW",
    "NtGdiRemoveMergeFont",
    "NtGdiResetDC",
    "NtGdiResizePalette",
    "NtGdiRoundRect",
    "NtGdiSTROBJ_bEnum",
    "NtGdiSTROBJ_bEnumPositionsOnly",
    "NtGdiSTROBJ_bGetAdvanceWidths",
    "NtGdiSTROBJ_dwGetCodePage",
    "NtGdiSTROBJ_vEnumStart",
    "NtGdiScaleViewportExtEx",
    "NtGdiScaleWindowExtEx",
    "NtGdiSelectBrush",
    "NtGdiSelectClipPath",
    "NtGdiSelectPen",
    "NtGdiSetBitmapAttributes",
    "NtGdiSetBrushAttributes",
    "NtGdiSetColorAdjustment",
    "NtGdiSetColorSpace",
    "NtGdiSetDeviceGammaRamp",
    "NtGdiSetFontXform",
    "NtGdiSetIcmMode",
    "NtGdiSetLinkedUFIs",
    "NtGdiSetMagicColors",
    "NtGdiSetOPMSigningKeyAndSequenceNumbers",
    "NtGdiSetPUMPDOBJ",
    "NtGdiSetPixelFormat",
    "NtGdiSetRectRgn",
    "NtGdiSetSizeDevice",
    "NtGdiSetSystemPaletteUse",
    "NtGdiSetTextJustification",
    "NtGdiStartDoc",
    "NtGdiStartPage",
    "NtGdiStrokeAndFillPath",
    "NtGdiStrokePath",
    "NtGdiSwapBuffers",
    "NtGdiTransparentBlt",
    "NtGdiUMPDEngFreeUserMem",
    "DxgStubAlphaBlt",
    "EngRestoreFloatingPointState",
    "NtGdiUpdateColors",
    "NtGdiUpdateTransform",
    "NtGdiWidenPath",
    "NtGdiXFORMOBJ_bApplyXform",
    "NtGdiXFORMOBJ_iGetXform",
    "NtGdiXLATEOBJ_cGetPalette",
    "NtGdiXLATEOBJ_hGetColorTransform",
    "NtGdiXLATEOBJ_iXlate",
    "NtUserAddClipboardFormatListener",
    "NtUserAssociateInputContext",
    "NtUserBlockInput",
    "NtUserBuildHimcList",
    "NtUserBuildPropList",
    "NtUserCallHwndOpt",
    "NtUserChangeDisplaySettings",
    "NtUserCheckAccessForIntegrityLevel",
    "NtUserCheckDesktopByThreadId",
    "NtUserCheckWindowThreadDesktop",
    "NtUserChildWindowFromPointEx",
    "NtUserClipCursor",
    "NtUserCreateDesktopEx",
    "NtUserCreateInputContext",
    "NtUserCreateWindowStation",
    "NtUserCtxDisplayIOCtl",
    "NtUserDestroyInputContext",
    "NtUserDisableThreadIme",
    "NtUserDoSoundConnect",
    "NtUserDoSoundDisconnect",
    "NtUserDragDetect",
    "NtUserDragObject",
    "NtUserDrawAnimatedRects",
    "NtUserDrawCaption",
    "NtUserDrawCaptionTemp",
    "NtUserDrawMenuBarTemp",
    "NtUserDwmGetDxRgn",
    "NtUserDwmHintDxUpdate",
    "NtUserDwmStartRedirection",
    "NtUserDwmStopRedirection",
    "NtUserEndMenu",
    "NtUserEvent",
    "NtUserFlashWindowEx",
    "NtUserFrostCrashedWindow",
    "NtUserGetAppImeLevel",
    "NtUserGetCaretPos",
    "NtUserGetClipCursor",
    "NtUserGetClipboardViewer",
    "NtUserGetComboBoxInfo",
    "NtUserGetCursorInfo",
    "NtUserGetGuiResources",
    "NtUserGetImeHotKey",
    "NtUserGetImeInfoEx",
    "NtUserGetInternalWindowPos",
    "NtUserGetKeyNameText",
    "NtUserGetKeyboardLayoutName",
    "NtUserGetLayeredWindowAttributes",
    "NtUserGetListBoxInfo",
    "NtUserGetMenuIndex",
    "NtUserGetMenuItemRect",
    "NtUserGetMouseMovePointsEx",
    "NtUserGetPriorityClipboardFormat",
    "NtUserGetRawInputBuffer",
    "NtUserGetRawInputData",
    "NtUserGetRawInputDeviceInfo",
    "NtUserGetRawInputDeviceList",
    "NtUserGetRegisteredRawInputDevices",
    "NtUserGetUpdatedClipboardFormats",
    "NtUserGetWOWClass",
    "NtUserGetWindowMinimizeRect",
    "NtUserGetWindowRgnEx",
    "NtUserGhostWindowFromHungWindow",
    "NtUserHardErrorControl",
    "NtUserHiliteMenuItem",
    "NtUserHungWindowFromGhostWindow",
    "NtUserImpersonateDdeClientWindow",
    "NtUserInitTask",
    "NtUserInitialize",
    "NtUserInitializeClientPfnArrays",
    "NtUserInternalGetWindowIcon",
    "NtUserLoadKeyboardLayoutEx",
    "NtUserLockWindowStation",
    "NtUserLockWorkStation",
    "NtUserLogicalToPhysicalPoint",
    "NtUserMNDragLeave",
    "NtUserMNDragOver",
    "NtUserMenuItemFromPoint",
    "NtUserMinMaximize",
    "NtUserNotifyIMEStatus",
    "NtUserOpenInputDesktop",
    "NtUserOpenThreadDesktop",
    "NtUserPaintMonitor",
    "NtUserPhysicalToLogicalPoint",
    "NtUserPrintWindow",
    "NtUserQueryInformationThread",
    "NtUserQueryInputContext",
    "NtUserQuerySendMessage",
    "NtUserRealChildWindowFromPoint",
    "NtUserRealWaitMessageEx",
    "NtUserRegisterErrorReportingDialog",
    "NtUserRegisterHotKey",
    "NtUserRegisterRawInputDevices",
    "NtUserRegisterSessionPort",
    "NtUserRegisterTasklist",
    "NtUserRegisterUserApiHook",
    "NtUserRemoteConnect",
    "NtUserRemoteRedrawRectangle",
    "NtUserRemoteRedrawScreen",
    "NtUserRemoteStopScreenUpdates",
    "NtUserRemoveClipboardFormatListener",
    "NtUserResolveDesktopForWOW",
    "NtUserSetAppImeLevel",
    "NtUserSetClassWord",
    "NtUserSetCursorContents",
    "NtUserSetImeHotKey",
    "NtUserSetImeInfoEx",
    "NtUserSetImeOwnerWindow",
    "NtUserSetInternalWindowPos",
    "NtUserSetLayeredWindowAttributes",
    "NtUserSetMenu",
    "NtUserSetMenuContextHelpId",
    "NtUserSetMenuFlagRtoL",
    "NtUserSetMirrorRendering",
    "NtUserSetObjectInformation",
    "NtUserSetProcessDPIAware",
    "NtUserSetShellWindowEx",
    "NtUserSetSysColors",
    "NtUserSetSystemCursor",
    "NtUserSetSystemTimer",
    "NtUserSetThreadLayoutHandles",
    "NtUserSetWindowRgnEx",
    "NtUserSetWindowStationUser",
    "NtUserShowSystemCursor",
    "NtUserSoundSentry",
    "NtUserSwitchDesktop",
    "NtUserTestForInteractiveUser",
    "NtUserTrackPopupMenuEx",
    "NtUserUnloadKeyboardLayout",
    "NtUserUnlockWindowStation",
    "NtUserUnregisterHotKey",
    "NtUserUnregisterSessionPort",
    "NtUserUnregisterUserApiHook",
    "NtUserUpdateInputContext",
    "NtUserUpdateInstance",
    "NtUserUpdateLayeredWindow",
    "NtUserUpdatePerUserSystemParameters",
    "NtUserUpdateWindowTransform",
    "NtUserUserHandleGrantAccess",
    "NtUserValidateHandleSecure",
    "NtUserWaitForInputIdle",
    "NtUserWaitForMsgAndEvent",
    "DxgStubAlphaBlt",
    "NtUserWindowFromPhysicalPoint",
    "NtUserYieldTask",
    "NtUserSetClassLongPtr",
    "NtUserSetWindowLongPtr"
};

//////////////////////////////////////////////////////////////////////////
// Windows Vista SP1 _W32pServiceTable
//////////////////////////////////////////////////////////////////////////
static const char* W32pServiceTable_VistaSp1_x64[] = {
    "NtUserGetThreadState",
    "NtUserPeekMessage",
    "NtUserCallOneParam",
    "NtUserGetKeyState",
    "NtUserInvalidateRect",
    "NtUserCallNoParam",
    "NtUserGetMessage",
    "NtUserMessageCall",
    "NtGdiBitBlt",
    "NtGdiGetCharSet",
    "NtUserGetDC",
    "NtGdiSelectBitmap",
    "NtUserWaitMessage",
    "NtUserTranslateMessage",
    "NtUserGetProp",
    "NtUserPostMessage",
    "NtUserQueryWindow",
    "NtUserTranslateAccelerator",
    "NtGdiFlush",
    "NtUserRedrawWindow",
    "NtUserWindowFromPoint",
    "NtUserCallMsgFilter",
    "NtUserValidateTimerCallback",
    "NtUserBeginPaint",
    "NtUserSetTimer",
    "NtUserEndPaint",
    "NtUserSetCursor",
    "NtUserKillTimer",
    "NtUserBuildHwndList",
    "NtUserSelectPalette",
    "NtUserCallNextHookEx",
    "NtUserHideCaret",
    "NtGdiIntersectClipRect",
    "NtUserCallHwndLock",
    "NtUserGetProcessWindowStation",
    "NtGdiDeleteObjectApp",
    "NtUserSetWindowPos",
    "NtUserShowCaret",
    "NtUserEndDeferWindowPosEx",
    "NtUserCallHwndParamLock",
    "NtUserVkKeyScanEx",
    "NtGdiSetDIBitsToDeviceInternal",
    "NtUserCallTwoParam",
    "NtGdiGetRandomRgn",
    "NtUserCopyAcceleratorTable",
    "NtUserNotifyWinEvent",
    "NtGdiExtSelectClipRgn",
    "NtUserIsClipboardFormatAvailable",
    "NtUserSetScrollInfo",
    "NtGdiStretchBlt",
    "NtUserCreateCaret",
    "NtGdiRectVisible",
    "NtGdiCombineRgn",
    "NtGdiGetDCObject",
    "NtUserDispatchMessage",
    "NtUserRegisterWindowMessage",
    "NtGdiExtTextOutW",
    "NtGdiSelectFont",
    "NtGdiRestoreDC",
    "NtGdiSaveDC",
    "NtUserGetForegroundWindow",
    "NtUserShowScrollBar",
    "NtUserFindExistingCursorIcon",
    "NtGdiGetDCDword",
    "NtGdiGetRegionData",
    "NtGdiLineTo",
    "NtUserSystemParametersInfo",
    "NtGdiGetAppClipBox",
    "NtUserGetAsyncKeyState",
    "NtUserGetCPD",
    "NtUserRemoveProp",
    "NtGdiDoPalette",
    "NtGdiPolyPolyDraw",
    "NtUserSetCapture",
    "NtUserEnumDisplayMonitors",
    "NtGdiCreateCompatibleBitmap",
    "NtUserSetProp",
    "NtGdiGetTextCharsetInfo",
    "NtUserSBGetParms",
    "NtUserGetIconInfo",
    "NtUserExcludeUpdateRgn",
    "NtUserSetFocus",
    "NtGdiExtGetObjectW",
    "NtUserDeferWindowPos",
    "NtUserGetUpdateRect",
    "NtGdiCreateCompatibleDC",
    "NtUserGetClipboardSequenceNumber",
    "NtGdiCreatePen",
    "NtUserShowWindow",
    "NtUserGetKeyboardLayoutList",
    "NtGdiPatBlt",
    "NtUserMapVirtualKeyEx",
    "NtUserSetWindowLong",
    "NtGdiHfontCreate",
    "NtUserMoveWindow",
    "NtUserPostThreadMessage",
    "NtUserDrawIconEx",
    "NtUserGetSystemMenu",
    "NtGdiDrawStream",
    "NtUserInternalGetWindowText",
    "NtUserGetWindowDC",
    "NtGdiD3dDrawPrimitives2",
    "NtGdiInvertRgn",
    "NtGdiGetRgnBox",
    "NtGdiGetAndSetDCDword",
    "NtGdiMaskBlt",
    "NtGdiGetWidthTable",
    "NtUserScrollDC",
    "NtUserGetObjectInformation",
    "NtGdiCreateBitmap",
    "NtGdiConsoleTextOut",
    "NtUserFindWindowEx",
    "NtGdiPolyPatBlt",
    "NtUserUnhookWindowsHookEx",
    "NtGdiGetNearestColor",
    "NtGdiTransformPoints",
    "NtGdiGetDCPoint",
    "NtUserCheckImeHotKey",
    "NtGdiCreateDIBBrush",
    "NtGdiGetTextMetricsW",
    "NtUserCreateWindowEx",
    "NtUserSetParent",
    "NtUserGetKeyboardState",
    "NtUserToUnicodeEx",
    "NtUserGetControlBrush",
    "NtUserGetClassName",
    "NtGdiAlphaBlend",
    "NtGdiDdBlt",
    "NtGdiOffsetRgn",
    "NtUserDefSetText",
    "NtGdiGetTextFaceW",
    "NtGdiStretchDIBitsInternal",
    "NtUserSendInput",
    "NtUserGetThreadDesktop",
    "NtGdiCreateRectRgn",
    "NtGdiGetDIBitsInternal",
    "NtUserGetUpdateRgn",
    "NtGdiDeleteClientObj",
    "NtUserGetIconSize",
    "NtUserFillWindow",
    "NtGdiExtCreateRegion",
    "NtGdiComputeXformCoefficients",
    "NtUserSetWindowsHookEx",
    "NtUserNotifyProcessCreate",
    "NtGdiUnrealizeObject",
    "NtUserGetTitleBarInfo",
    "NtGdiRectangle",
    "NtUserSetThreadDesktop",
    "NtUserGetDCEx",
    "NtUserGetScrollBarInfo",
    "NtGdiGetTextExtent",
    "NtUserSetWindowFNID",
    "NtGdiSetLayout",
    "NtUserCalcMenuBar",
    "NtUserThunkedMenuItemInfo",
    "NtGdiExcludeClipRect",
    "NtGdiCreateDIBSection",
    "NtGdiGetDCforBitmap",
    "NtUserDestroyCursor",
    "NtUserDestroyWindow",
    "NtUserCallHwndParam",
    "NtGdiCreateDIBitmapInternal",
    "NtUserOpenWindowStation",
    "NtGdiDdDeleteSurfaceObject",
    "NtGdiEnumFontClose",
    "NtGdiEnumFontOpen",
    "NtGdiEnumFontChunk",
    "NtGdiDdCanCreateSurface",
    "NtGdiDdCreateSurface",
    "NtUserSetCursorIconData",
    "NtGdiDdDestroySurface",
    "NtUserCloseDesktop",
    "NtUserOpenDesktop",
    "NtUserSetProcessWindowStation",
    "NtUserGetAtomName",
    "NtGdiDdResetVisrgn",
    "NtGdiExtCreatePen",
    "NtGdiCreatePaletteInternal",
    "NtGdiSetBrushOrg",
    "NtUserBuildNameList",
    "NtGdiSetPixel",
    "NtUserRegisterClassExWOW",
    "NtGdiCreatePatternBrushInternal",
    "NtUserGetAncestor",
    "NtGdiGetOutlineTextMetricsInternalW",
    "NtGdiSetBitmapBits",
    "NtUserCloseWindowStation",
    "NtUserGetDoubleClickTime",
    "NtUserEnableScrollBar",
    "NtGdiCreateSolidBrush",
    "NtUserGetClassInfoEx",
    "NtGdiCreateClientObj",
    "NtUserUnregisterClass",
    "NtUserDeleteMenu",
    "NtGdiRectInRegion",
    "NtUserScrollWindowEx",
    "NtGdiGetPixel",
    "NtUserSetClassLong",
    "NtUserGetMenuBarInfo",
    "NtGdiDdCreateSurfaceEx",
    "NtGdiDdCreateSurfaceObject",
    "NtGdiGetNearestPaletteIndex",
    "NtGdiDdLockD3D",
    "NtGdiDdUnlockD3D",
    "NtGdiGetCharWidthW",
    "NtUserInvalidateRgn",
    "NtUserGetClipboardOwner",
    "NtUserSetWindowRgn",
    "NtUserBitBltSysBmp",
    "NtGdiGetCharWidthInfo",
    "NtUserValidateRect",
    "NtUserCloseClipboard",
    "NtUserOpenClipboard",
    "NtGdiGetStockObject",
    "NtUserSetClipboardData",
    "NtUserEnableMenuItem",
    "NtUserAlterWindowStyle",
    "NtGdiFillRgn",
    "NtUserGetWindowPlacement",
    "NtGdiModifyWorldTransform",
    "NtGdiGetFontData",
    "NtUserGetOpenClipboardWindow",
    "NtUserSetThreadState",
    "NtGdiOpenDCW",
    "NtUserTrackMouseEvent",
    "NtGdiGetTransform",
    "NtUserDestroyMenu",
    "NtGdiGetBitmapBits",
    "NtUserConsoleControl",
    "NtUserSetActiveWindow",
    "NtUserSetInformationThread",
    "NtUserSetWindowPlacement",
    "NtUserGetControlColor",
    "NtGdiSetMetaRgn",
    "NtGdiSetMiterLimit",
    "NtGdiSetVirtualResolution",
    "NtGdiGetRasterizerCaps",
    "NtUserSetWindowWord",
    "NtUserGetClipboardFormatName",
    "NtUserRealInternalGetMessage",
    "NtUserCreateLocalMemHandle",
    "NtUserAttachThreadInput",
    "NtGdiCreateHalftonePalette",
    "NtUserPaintMenuBar",
    "NtUserSetKeyboardState",
    "NtGdiCombineTransform",
    "NtUserCreateAcceleratorTable",
    "NtUserGetCursorFrameInfo",
    "NtUserGetAltTabInfo",
    "NtUserGetCaretBlinkTime",
    "NtGdiQueryFontAssocInfo",
    "NtUserProcessConnect",
    "NtUserEnumDisplayDevices",
    "NtUserEmptyClipboard",
    "NtUserGetClipboardData",
    "NtUserRemoveMenu",
    "NtGdiSetBoundsRect",
    "NtUserSetInformationProcess",
    "NtGdiGetBitmapDimension",
    "NtUserConvertMemHandle",
    "NtUserDestroyAcceleratorTable",
    "NtUserGetGUIThreadInfo",
    "NtGdiCloseFigure",
    "NtUserSetWindowsHookAW",
    "NtUserSetMenuDefaultItem",
    "NtUserCheckMenuItem",
    "NtUserSetWinEventHook",
    "NtUserUnhookWinEvent",
    "NtGdiSetupPublicCFONT",
    "NtUserLockWindowUpdate",
    "NtUserSetSystemMenu",
    "NtUserThunkedMenuInfo",
    "NtGdiBeginPath",
    "NtGdiEndPath",
    "NtGdiFillPath",
    "NtUserCallHwnd",
    "NtUserDdeInitialize",
    "NtUserModifyUserStartupInfoFlags",
    "NtUserCountClipboardFormats",
    "NtGdiAddFontMemResourceEx",
    "NtGdiEqualRgn",
    "NtGdiGetSystemPaletteUse",
    "NtGdiRemoveFontMemResourceEx",
    "NtUserEnumDisplaySettings",
    "NtUserPaintDesktop",
    "NtGdiExtEscape",
    "NtGdiSetBitmapDimension",
    "NtGdiSetFontEnumeration",
    "NtUserChangeClipboardChain",
    "NtUserResolveDesktop",
    "NtUserSetClipboardViewer",
    "NtUserShowWindowAsync",
    "NtUserSetConsoleReserveKeys",
    "NtGdiCreateColorSpace",
    "NtGdiDeleteColorSpace",
    "NtUserActivateKeyboardLayout",
    "NtGdiAbortDoc",
    "NtGdiAbortPath",
    "NtGdiAddEmbFontToDC",
    "NtGdiAddFontResourceW",
    "NtGdiAddRemoteFontToDC",
    "NtGdiAddRemoteMMInstanceToDC",
    "NtGdiAngleArc",
    "NtGdiAnyLinkedFonts",
    "NtGdiArcInternal",
    "NtGdiBRUSHOBJ_DeleteRbrush",
    "NtGdiBRUSHOBJ_hGetColorTransform",
    "NtGdiBRUSHOBJ_pvAllocRbrush",
    "NtGdiBRUSHOBJ_pvGetRbrush",
    "NtGdiBRUSHOBJ_ulGetBrushColor",
    "NtGdiCLIPOBJ_bEnum",
    "NtGdiCLIPOBJ_cEnumStart",
    "NtGdiCLIPOBJ_ppoGetPath",
    "NtGdiCancelDC",
    "NtGdiChangeGhostFont",
    "NtGdiCheckBitmapBits",
    "NtGdiClearBitmapAttributes",
    "NtGdiClearBrushAttributes",
    "NtGdiColorCorrectPalette",
    "NtGdiConfigureOPMProtectedOutput",
    "NtGdiConvertMetafileRect",
    "NtGdiCreateColorTransform",
    "NtGdiCreateEllipticRgn",
    "NtGdiCreateHatchBrushInternal",
    "NtGdiCreateMetafileDC",
    "NtGdiCreateOPMProtectedOutputs",
    "NtGdiCreateRoundRectRgn",
    "NtGdiCreateServerMetaFile",
    "NtGdiD3dContextCreate",
    "NtGdiD3dContextDestroy",
    "NtGdiD3dContextDestroyAll",
    "NtGdiD3dValidateTextureStageState",
    "NtGdiDDCCIGetCapabilitiesString",
    "NtGdiDDCCIGetCapabilitiesStringLength",
    "NtGdiDDCCIGetTimingReport",
    "NtGdiDDCCIGetVCPFeature",
    "NtGdiDDCCISaveCurrentSettings",
    "NtGdiDDCCISetVCPFeature",
    "NtGdiDdAddAttachedSurface",
    "NtGdiDdAlphaBlt",
    "NtGdiDdAttachSurface",
    "NtGdiDdBeginMoCompFrame",
    "NtGdiDdCanCreateD3DBuffer",
    "NtGdiDdColorControl",
    "NtGdiDdCreateD3DBuffer",
    "NtGdiDdCreateDirectDrawObject",
    "NtGdiDdCreateMoComp",
    "NtGdiDdDDICheckExclusiveOwnership",
    "NtGdiDdDDICheckMonitorPowerState",
    "NtGdiDdDDICheckOcclusion",
    "NtGdiDdDDICloseAdapter",
    "NtGdiDdDDICreateAllocation",
    "NtGdiDdDDICreateContext",
    "NtGdiDdDDICreateDCFromMemory",
    "NtGdiDdDDICreateDevice",
    "NtGdiDdDDICreateOverlay",
    "NtGdiDdDDICreateSynchronizationObject",
    "NtGdiDdDDIDestroyAllocation",
    "NtGdiDdDDIDestroyContext",
    "NtGdiDdDDIDestroyDCFromMemory",
    "NtGdiDdDDIDestroyDevice",
    "NtGdiDdDDIDestroyOverlay",
    "NtGdiDdDDIDestroySynchronizationObject",
    "NtGdiDdDDIEscape",
    "NtGdiDdDDIFlipOverlay",
    "NtGdiDdDDIGetContextSchedulingPriority",
    "NtGdiDdDDIGetDeviceState",
    "NtGdiDdDDIGetDisplayModeList",
    "NtGdiDdDDIGetMultisampleMethodList",
    "NtGdiDdDDIGetPresentHistory",
    "NtGdiDdDDIGetProcessSchedulingPriorityClass",
    "NtGdiDdDDIGetRuntimeData",
    "NtGdiDdDDIGetScanLine",
    "NtGdiDdDDIGetSharedPrimaryHandle",
    "NtGdiDdDDIInvalidateActiveVidPn",
    "NtGdiDdDDILock",
    "NtGdiDdDDIOpenAdapterFromDeviceName",
    "NtGdiDdDDIOpenAdapterFromHdc",
    "NtGdiDdDDIOpenResource",
    "NtGdiDdDDIPollDisplayChildren",
    "NtGdiDdDDIPresent",
    "NtGdiDdDDIQueryAdapterInfo",
    "NtGdiDdDDIQueryAllocationResidency",
    "NtGdiDdDDIQueryResourceInfo",
    "NtGdiDdDDIQueryStatistics",
    "NtGdiDdDDIReleaseProcessVidPnSourceOwners",
    "NtGdiDdDDIRender",
    "NtGdiDdDDISetAllocationPriority",
    "NtGdiDdDDISetContextSchedulingPriority",
    "NtGdiDdDDISetDisplayMode",
    "NtGdiDdDDISetDisplayPrivateDriverFormat",
    "NtGdiDdDDISetGammaRamp",
    "NtGdiDdDDISetProcessSchedulingPriorityClass",
    "NtGdiDdDDISetQueuedLimit",
    "NtGdiDdDDISetVidPnSourceOwner",
    "NtGdiDdDDISharedPrimaryLockNotification",
    "NtGdiDdDDISharedPrimaryUnLockNotification",
    "NtGdiDdDDISignalSynchronizationObject",
    "NtGdiDdDDIUnlock",
    "NtGdiDdDDIUpdateOverlay",
    "NtGdiDdDDIWaitForIdle",
    "NtGdiDdDDIWaitForSynchronizationObject",
    "NtGdiDdDDIWaitForVerticalBlankEvent",
    "NtGdiDdDeleteDirectDrawObject",
    "NtGdiDdDestroyD3DBuffer",
    "NtGdiDdDestroyMoComp",
    "NtGdiDdEndMoCompFrame",
    "NtGdiDdFlip",
    "NtGdiDdFlipToGDISurface",
    "NtGdiDdGetAvailDriverMemory",
    "NtGdiDdGetBltStatus",
    "NtGdiDdGetDC",
    "NtGdiDdGetDriverInfo",
    "NtGdiDdGetDriverState",
    "NtGdiDdGetDxHandle",
    "NtGdiDdGetFlipStatus",
    "NtGdiDdGetInternalMoCompInfo",
    "NtGdiDdGetMoCompBuffInfo",
    "NtGdiDdGetMoCompFormats",
    "NtGdiDdGetMoCompGuids",
    "NtGdiDdGetScanLine",
    "NtGdiDdLock",
    "NtGdiDdQueryDirectDrawObject",
    "NtGdiDdQueryMoCompStatus",
    "NtGdiDdReenableDirectDrawObject",
    "NtGdiDdReleaseDC",
    "NtGdiDdRenderMoComp",
    "NtGdiDdSetColorKey",
    "NtGdiDdSetExclusiveMode",
    "NtGdiDdSetGammaRamp",
    "NtGdiDdSetOverlayPosition",
    "NtGdiDdUnattachSurface",
    "NtGdiDdUnlock",
    "NtGdiDdUpdateOverlay",
    "NtGdiDdWaitForVerticalBlank",
    "NtGdiDeleteColorTransform",
    "NtGdiDescribePixelFormat",
    "NtGdiDestroyOPMProtectedOutput",
    "NtGdiDestroyPhysicalMonitor",
    "NtGdiDoBanding",
    "NtGdiDrawEscape",
    "NtGdiDvpAcquireNotification",
    "NtGdiDvpCanCreateVideoPort",
    "NtGdiDvpColorControl",
    "NtGdiDvpCreateVideoPort",
    "NtGdiDvpDestroyVideoPort",
    "NtGdiDvpFlipVideoPort",
    "NtGdiDvpGetVideoPortBandwidth",
    "NtGdiDvpGetVideoPortConnectInfo",
    "NtGdiDvpGetVideoPortField",
    "NtGdiDvpGetVideoPortFlipStatus",
    "NtGdiDvpGetVideoPortInputFormats",
    "NtGdiDvpGetVideoPortLine",
    "NtGdiDvpGetVideoPortOutputFormats",
    "NtGdiDvpGetVideoSignalStatus",
    "NtGdiDvpReleaseNotification",
    "NtGdiDvpUpdateVideoPort",
    "NtGdiDvpWaitForVideoPortSync",
    "NtGdiDwmGetDirtyRgn",
    "NtGdiDwmGetSurfaceData",
    "NtGdiDxgGenericThunk",
    "NtGdiEllipse",
    "NtGdiEnableEudc",
    "NtGdiEndDoc",
    "NtGdiEndPage",
    "NtGdiEngAlphaBlend",
    "NtGdiEngAssociateSurface",
    "NtGdiEngBitBlt",
    "NtGdiEngCheckAbort",
    "NtGdiEngComputeGlyphSet",
    "NtGdiEngCopyBits",
    "NtGdiEngCreateBitmap",
    "NtGdiEngCreateClip",
    "NtGdiEngCreateDeviceBitmap",
    "NtGdiEngCreateDeviceSurface",
    "NtGdiEngCreatePalette",
    "NtGdiEngDeleteClip",
    "NtGdiEngDeletePalette",
    "NtGdiEngDeletePath",
    "NtGdiEngDeleteSurface",
    "NtGdiEngEraseSurface",
    "NtGdiEngFillPath",
    "NtGdiEngGradientFill",
    "NtGdiEngLineTo",
    "NtGdiEngLockSurface",
    "NtGdiEngMarkBandingSurface",
    "NtGdiEngPaint",
    "NtGdiEngPlgBlt",
    "NtGdiEngStretchBlt",
    "NtGdiEngStretchBltROP",
    "NtGdiEngStrokeAndFillPath",
    "NtGdiEngStrokePath",
    "NtGdiEngTextOut",
    "NtGdiEngTransparentBlt",
    "NtGdiEngUnlockSurface",
    "NtGdiEnumObjects",
    "NtGdiEudcLoadUnloadLink",
    "NtGdiExtFloodFill",
    "NtGdiFONTOBJ_cGetAllGlyphHandles",
    "NtGdiFONTOBJ_cGetGlyphs",
    "NtGdiFONTOBJ_pQueryGlyphAttrs",
    "NtGdiFONTOBJ_pfdg",
    "NtGdiFONTOBJ_pifi",
    "NtGdiFONTOBJ_pvTrueTypeFontFile",
    "NtGdiFONTOBJ_pxoGetXform",
    "NtGdiFONTOBJ_vGetInfo",
    "NtGdiFlattenPath",
    "NtGdiFontIsLinked",
    "NtGdiForceUFIMapping",
    "NtGdiFrameRgn",
    "NtGdiFullscreenControl",
    "NtGdiGetBoundsRect",
    "NtGdiGetCOPPCompatibleOPMInformation",
    "NtGdiGetCertificate",
    "NtGdiGetCertificateSize",
    "NtGdiGetCharABCWidthsW",
    "NtGdiGetCharacterPlacementW",
    "NtGdiGetColorAdjustment",
    "NtGdiGetColorSpaceforBitmap",
    "NtGdiGetDeviceCaps",
    "NtGdiGetDeviceCapsAll",
    "NtGdiGetDeviceGammaRamp",
    "NtGdiGetDeviceWidth",
    "NtGdiGetDhpdev",
    "NtGdiGetETM",
    "NtGdiGetEmbUFI",
    "NtGdiGetEmbedFonts",
    "NtGdiGetEudcTimeStampEx",
    "NtGdiGetFontResourceInfoInternalW",
    "NtGdiGetFontUnicodeRanges",
    "NtGdiGetGlyphIndicesW",
    "NtGdiGetGlyphIndicesWInternal",
    "NtGdiGetGlyphOutline",
    "NtGdiGetKerningPairs",
    "NtGdiGetLinkedUFIs",
    "NtGdiGetMiterLimit",
    "NtGdiGetMonitorID",
    "NtGdiGetNumberOfPhysicalMonitors",
    "NtGdiGetOPMInformation",
    "NtGdiGetOPMRandomNumber",
    "NtGdiGetObjectBitmapHandle",
    "NtGdiGetPath",
    "NtGdiGetPerBandInfo",
    "NtGdiGetPhysicalMonitorDescription",
    "NtGdiGetPhysicalMonitors",
    "NtGdiGetRealizationInfo",
    "NtGdiGetServerMetaFileBits",
    "NtGdiGetSpoolMessage",
    "NtGdiGetStats",
    "NtGdiGetStringBitmapW",
    "NtGdiGetSuggestedOPMProtectedOutputArraySize",
    "NtGdiGetTextExtentExW",
    "NtGdiGetUFI",
    "NtGdiGetUFIPathname",
    "NtGdiGradientFill",
    "NtGdiHT_Get8BPPFormatPalette",
    "NtGdiHT_Get8BPPMaskPalette",
    "NtGdiIcmBrushInfo",
    "EngRestoreFloatingPointState",
    "NtGdiInitSpool",
    "NtGdiMakeFontDir",
    "NtGdiMakeInfoDC",
    "NtGdiMakeObjectUnXferable",
    "NtGdiMakeObjectXferable",
    "NtGdiMirrorWindowOrg",
    "NtGdiMonoBitmap",
    "NtGdiMoveTo",
    "NtGdiOffsetClipRgn",
    "NtGdiPATHOBJ_bEnum",
    "NtGdiPATHOBJ_bEnumClipLines",
    "NtGdiPATHOBJ_vEnumStart",
    "NtGdiPATHOBJ_vEnumStartClipLines",
    "NtGdiPATHOBJ_vGetBounds",
    "NtGdiPathToRegion",
    "NtGdiPlgBlt",
    "NtGdiPolyDraw",
    "NtGdiPolyTextOutW",
    "NtGdiPtInRegion",
    "NtGdiPtVisible",
    "NtGdiQueryFonts",
    "NtGdiRemoveFontResourceW",
    "NtGdiRemoveMergeFont",
    "NtGdiResetDC",
    "NtGdiResizePalette",
    "NtGdiRoundRect",
    "NtGdiSTROBJ_bEnum",
    "NtGdiSTROBJ_bEnumPositionsOnly",
    "NtGdiSTROBJ_bGetAdvanceWidths",
    "NtGdiSTROBJ_dwGetCodePage",
    "NtGdiSTROBJ_vEnumStart",
    "NtGdiScaleViewportExtEx",
    "NtGdiScaleWindowExtEx",
    "NtGdiSelectBrush",
    "NtGdiSelectClipPath",
    "NtGdiSelectPen",
    "NtGdiSetBitmapAttributes",
    "NtGdiSetBrushAttributes",
    "NtGdiSetColorAdjustment",
    "NtGdiSetColorSpace",
    "NtGdiSetDeviceGammaRamp",
    "NtGdiSetFontXform",
    "NtGdiSetIcmMode",
    "NtGdiSetLinkedUFIs",
    "NtGdiSetMagicColors",
    "NtGdiSetOPMSigningKeyAndSequenceNumbers",
    "NtGdiSetPUMPDOBJ",
    "NtGdiSetPixelFormat",
    "NtGdiSetRectRgn",
    "NtGdiSetSizeDevice",
    "NtGdiSetSystemPaletteUse",
    "NtGdiSetTextJustification",
    "NtGdiStartDoc",
    "NtGdiStartPage",
    "NtGdiStrokeAndFillPath",
    "NtGdiStrokePath",
    "NtGdiSwapBuffers",
    "NtGdiTransparentBlt",
    "NtGdiUMPDEngFreeUserMem",
    "DxgStubAlphaBlt",
    "EngRestoreFloatingPointState",
    "NtGdiUpdateColors",
    "NtGdiUpdateTransform",
    "NtGdiWidenPath",
    "NtGdiXFORMOBJ_bApplyXform",
    "NtGdiXFORMOBJ_iGetXform",
    "NtGdiXLATEOBJ_cGetPalette",
    "NtGdiXLATEOBJ_hGetColorTransform",
    "NtGdiXLATEOBJ_iXlate",
    "NtUserAddClipboardFormatListener",
    "NtUserAssociateInputContext",
    "NtUserBlockInput",
    "NtUserBuildHimcList",
    "NtUserBuildPropList",
    "NtUserCallHwndOpt",
    "NtUserChangeDisplaySettings",
    "NtUserCheckAccessForIntegrityLevel",
    "NtUserCheckDesktopByThreadId",
    "NtUserCheckWindowThreadDesktop",
    "NtUserChildWindowFromPointEx",
    "NtUserClipCursor",
    "NtUserCreateDesktopEx",
    "NtUserCreateInputContext",
    "NtUserCreateWindowStation",
    "NtUserCtxDisplayIOCtl",
    "NtUserDestroyInputContext",
    "NtUserDisableThreadIme",
    "NtUserDoSoundConnect",
    "NtUserDoSoundDisconnect",
    "NtUserDragDetect",
    "NtUserDragObject",
    "NtUserDrawAnimatedRects",
    "NtUserDrawCaption",
    "NtUserDrawCaptionTemp",
    "NtUserDrawMenuBarTemp",
    "NtUserDwmGetDxRgn",
    "NtUserDwmHintDxUpdate",
    "NtUserDwmStartRedirection",
    "NtUserDwmStopRedirection",
    "NtUserEndMenu",
    "NtUserEvent",
    "NtUserFlashWindowEx",
    "NtUserFrostCrashedWindow",
    "NtUserGetAppImeLevel",
    "NtUserGetCaretPos",
    "NtUserGetClipCursor",
    "NtUserGetClipboardViewer",
    "NtUserGetComboBoxInfo",
    "NtUserGetCursorInfo",
    "NtUserGetGuiResources",
    "NtUserGetImeHotKey",
    "NtUserGetImeInfoEx",
    "NtUserGetInternalWindowPos",
    "NtUserGetKeyNameText",
    "NtUserGetKeyboardLayoutName",
    "NtUserGetLayeredWindowAttributes",
    "NtUserGetListBoxInfo",
    "NtUserGetMenuIndex",
    "NtUserGetMenuItemRect",
    "NtUserGetMouseMovePointsEx",
    "NtUserGetPriorityClipboardFormat",
    "NtUserGetRawInputBuffer",
    "NtUserGetRawInputData",
    "NtUserGetRawInputDeviceInfo",
    "NtUserGetRawInputDeviceList",
    "NtUserGetRegisteredRawInputDevices",
    "NtUserGetUpdatedClipboardFormats",
    "NtUserGetWOWClass",
    "NtUserGetWindowMinimizeRect",
    "NtUserGetWindowRgnEx",
    "NtUserGhostWindowFromHungWindow",
    "NtUserHardErrorControl",
    "NtUserHiliteMenuItem",
    "NtUserHungWindowFromGhostWindow",
    "NtUserImpersonateDdeClientWindow",
    "NtUserInitTask",
    "NtUserInitialize",
    "NtUserInitializeClientPfnArrays",
    "NtUserInternalGetWindowIcon",
    "NtUserLoadKeyboardLayoutEx",
    "NtUserLockWindowStation",
    "NtUserLockWorkStation",
    "NtUserLogicalToPhysicalPoint",
    "NtUserMNDragLeave",
    "NtUserMNDragOver",
    "NtUserMenuItemFromPoint",
    "NtUserMinMaximize",
    "NtUserNotifyIMEStatus",
    "NtUserOpenInputDesktop",
    "NtUserOpenThreadDesktop",
    "NtUserPaintMonitor",
    "NtUserPhysicalToLogicalPoint",
    "NtUserPrintWindow",
    "NtUserQueryInformationThread",
    "NtUserQueryInputContext",
    "NtUserQuerySendMessage",
    "NtUserRealChildWindowFromPoint",
    "NtUserRealWaitMessageEx",
    "NtUserRegisterErrorReportingDialog",
    "NtUserRegisterHotKey",
    "NtUserRegisterRawInputDevices",
    "NtUserRegisterSessionPort",
    "NtUserRegisterTasklist",
    "NtUserRegisterUserApiHook",
    "NtUserRemoteConnect",
    "NtUserRemoteRedrawRectangle",
    "NtUserRemoteRedrawScreen",
    "NtUserRemoteStopScreenUpdates",
    "NtUserRemoveClipboardFormatListener",
    "NtUserResolveDesktopForWOW",
    "NtUserSetAppImeLevel",
    "NtUserSetClassWord",
    "NtUserSetCursorContents",
    "NtUserSetImeHotKey",
    "NtUserSetImeInfoEx",
    "NtUserSetImeOwnerWindow",
    "NtUserSetInternalWindowPos",
    "NtUserSetLayeredWindowAttributes",
    "NtUserSetMenu",
    "NtUserSetMenuContextHelpId",
    "NtUserSetMenuFlagRtoL",
    "NtUserSetMirrorRendering",
    "NtUserSetObjectInformation",
    "NtUserSetProcessDPIAware",
    "NtUserSetShellWindowEx",
    "NtUserSetSysColors",
    "NtUserSetSystemCursor",
    "NtUserSetSystemTimer",
    "NtUserSetThreadLayoutHandles",
    "NtUserSetWindowRgnEx",
    "NtUserSetWindowStationUser",
    "NtUserShowSystemCursor",
    "NtUserSoundSentry",
    "NtUserSwitchDesktop",
    "NtUserTestForInteractiveUser",
    "NtUserTrackPopupMenuEx",
    "NtUserUnloadKeyboardLayout",
    "NtUserUnlockWindowStation",
    "NtUserUnregisterHotKey",
    "NtUserUnregisterSessionPort",
    "NtUserUnregisterUserApiHook",
    "NtUserUpdateInputContext",
    "NtUserUpdateInstance",
    "NtUserUpdateLayeredWindow",
    "NtUserUpdatePerUserSystemParameters",
    "NtUserUpdateWindowTransform",
    "NtUserUserHandleGrantAccess",
    "NtUserValidateHandleSecure",
    "NtUserWaitForInputIdle",
    "NtUserWaitForMsgAndEvent",
    "DxgStubAlphaBlt",
    "NtUserWindowFromPhysicalPoint",
    "NtUserYieldTask",
    "NtUserSetClassLongPtr",
    "NtUserSetWindowLongPtr"
};

//////////////////////////////////////////////////////////////////////////
// Windows 7 SP0 _W32pServiceTable
//////////////////////////////////////////////////////////////////////////
static const char* W32pServiceTable_VistaSp2_x64[] = {
    "NtUserGetThreadState",
    "NtUserPeekMessage",
    "NtUserCallOneParam",
    "NtUserGetKeyState",
    "NtUserInvalidateRect",
    "NtUserCallNoParam",
    "NtUserGetMessage",
    "NtUserMessageCall",
    "NtGdiBitBlt",
    "NtGdiGetCharSet",
    "NtUserGetDC",
    "NtGdiSelectBitmap",
    "NtUserWaitMessage",
    "NtUserTranslateMessage",
    "NtUserGetProp",
    "NtUserPostMessage",
    "NtUserQueryWindow",
    "NtUserTranslateAccelerator",
    "NtGdiFlush",
    "NtUserRedrawWindow",
    "NtUserWindowFromPoint",
    "NtUserCallMsgFilter",
    "NtUserValidateTimerCallback",
    "NtUserBeginPaint",
    "NtUserSetTimer",
    "NtUserEndPaint",
    "NtUserSetCursor",
    "NtUserKillTimer",
    "NtUserBuildHwndList",
    "NtUserSelectPalette",
    "NtUserCallNextHookEx",
    "NtUserHideCaret",
    "NtGdiIntersectClipRect",
    "NtUserCallHwndLock",
    "NtUserGetProcessWindowStation",
    "NtGdiDeleteObjectApp",
    "NtUserSetWindowPos",
    "NtUserShowCaret",
    "NtUserEndDeferWindowPosEx",
    "NtUserCallHwndParamLock",
    "NtUserVkKeyScanEx",
    "NtGdiSetDIBitsToDeviceInternal",
    "NtUserCallTwoParam",
    "NtGdiGetRandomRgn",
    "NtUserCopyAcceleratorTable",
    "NtUserNotifyWinEvent",
    "NtGdiExtSelectClipRgn",
    "NtUserIsClipboardFormatAvailable",
    "NtUserSetScrollInfo",
    "NtGdiStretchBlt",
    "NtUserCreateCaret",
    "NtGdiRectVisible",
    "NtGdiCombineRgn",
    "NtGdiGetDCObject",
    "NtUserDispatchMessage",
    "NtUserRegisterWindowMessage",
    "NtGdiExtTextOutW",
    "NtGdiSelectFont",
    "NtGdiRestoreDC",
    "NtGdiSaveDC",
    "NtUserGetForegroundWindow",
    "NtUserShowScrollBar",
    "NtUserFindExistingCursorIcon",
    "NtGdiGetDCDword",
    "NtGdiGetRegionData",
    "NtGdiLineTo",
    "NtUserSystemParametersInfo",
    "NtGdiGetAppClipBox",
    "NtUserGetAsyncKeyState",
    "NtUserGetCPD",
    "NtUserRemoveProp",
    "NtGdiDoPalette",
    "NtGdiPolyPolyDraw",
    "NtUserSetCapture",
    "NtUserEnumDisplayMonitors",
    "NtGdiCreateCompatibleBitmap",
    "NtUserSetProp",
    "NtGdiGetTextCharsetInfo",
    "NtUserSBGetParms",
    "NtUserGetIconInfo",
    "NtUserExcludeUpdateRgn",
    "NtUserSetFocus",
    "NtGdiExtGetObjectW",
    "NtUserDeferWindowPos",
    "NtUserGetUpdateRect",
    "NtGdiCreateCompatibleDC",
    "NtUserGetClipboardSequenceNumber",
    "NtGdiCreatePen",
    "NtUserShowWindow",
    "NtUserGetKeyboardLayoutList",
    "NtGdiPatBlt",
    "NtUserMapVirtualKeyEx",
    "NtUserSetWindowLong",
    "NtGdiHfontCreate",
    "NtUserMoveWindow",
    "NtUserPostThreadMessage",
    "NtUserDrawIconEx",
    "NtUserGetSystemMenu",
    "NtGdiDrawStream",
    "NtUserInternalGetWindowText",
    "NtUserGetWindowDC",
    "NtGdiD3dDrawPrimitives2",
    "NtGdiInvertRgn",
    "NtGdiGetRgnBox",
    "NtGdiGetAndSetDCDword",
    "NtGdiMaskBlt",
    "NtGdiGetWidthTable",
    "NtUserScrollDC",
    "NtUserGetObjectInformation",
    "NtGdiCreateBitmap",
    "NtGdiConsoleTextOut",
    "NtUserFindWindowEx",
    "NtGdiPolyPatBlt",
    "NtUserUnhookWindowsHookEx",
    "NtGdiGetNearestColor",
    "NtGdiTransformPoints",
    "NtGdiGetDCPoint",
    "NtUserCheckImeHotKey",
    "NtGdiCreateDIBBrush",
    "NtGdiGetTextMetricsW",
    "NtUserCreateWindowEx",
    "NtUserSetParent",
    "NtUserGetKeyboardState",
    "NtUserToUnicodeEx",
    "NtUserGetControlBrush",
    "NtUserGetClassName",
    "NtGdiAlphaBlend",
    "NtGdiDdBlt",
    "NtGdiOffsetRgn",
    "NtUserDefSetText",
    "NtGdiGetTextFaceW",
    "NtGdiStretchDIBitsInternal",
    "NtUserSendInput",
    "NtUserGetThreadDesktop",
    "NtGdiCreateRectRgn",
    "NtGdiGetDIBitsInternal",
    "NtUserGetUpdateRgn",
    "NtGdiDeleteClientObj",
    "NtUserGetIconSize",
    "NtUserFillWindow",
    "NtGdiExtCreateRegion",
    "NtGdiComputeXformCoefficients",
    "NtUserSetWindowsHookEx",
    "NtUserNotifyProcessCreate",
    "NtGdiUnrealizeObject",
    "NtUserGetTitleBarInfo",
    "NtGdiRectangle",
    "NtUserSetThreadDesktop",
    "NtUserGetDCEx",
    "NtUserGetScrollBarInfo",
    "NtGdiGetTextExtent",
    "NtUserSetWindowFNID",
    "NtGdiSetLayout",
    "NtUserCalcMenuBar",
    "NtUserThunkedMenuItemInfo",
    "NtGdiExcludeClipRect",
    "NtGdiCreateDIBSection",
    "NtGdiGetDCforBitmap",
    "NtUserDestroyCursor",
    "NtUserDestroyWindow",
    "NtUserCallHwndParam",
    "NtGdiCreateDIBitmapInternal",
    "NtUserOpenWindowStation",
    "NtGdiDdDeleteSurfaceObject",
    "NtGdiEnumFontClose",
    "NtGdiEnumFontOpen",
    "NtGdiEnumFontChunk",
    "NtGdiDdCanCreateSurface",
    "NtGdiDdCreateSurface",
    "NtUserSetCursorIconData",
    "NtGdiDdDestroySurface",
    "NtUserCloseDesktop",
    "NtUserOpenDesktop",
    "NtUserSetProcessWindowStation",
    "NtUserGetAtomName",
    "NtGdiDdResetVisrgn",
    "NtGdiExtCreatePen",
    "NtGdiCreatePaletteInternal",
    "NtGdiSetBrushOrg",
    "NtUserBuildNameList",
    "NtGdiSetPixel",
    "NtUserRegisterClassExWOW",
    "NtGdiCreatePatternBrushInternal",
    "NtUserGetAncestor",
    "NtGdiGetOutlineTextMetricsInternalW",
    "NtGdiSetBitmapBits",
    "NtUserCloseWindowStation",
    "NtUserGetDoubleClickTime",
    "NtUserEnableScrollBar",
    "NtGdiCreateSolidBrush",
    "NtUserGetClassInfoEx",
    "NtGdiCreateClientObj",
    "NtUserUnregisterClass",
    "NtUserDeleteMenu",
    "NtGdiRectInRegion",
    "NtUserScrollWindowEx",
    "NtGdiGetPixel",
    "NtUserSetClassLong",
    "NtUserGetMenuBarInfo",
    "NtGdiDdCreateSurfaceEx",
    "NtGdiDdCreateSurfaceObject",
    "NtGdiGetNearestPaletteIndex",
    "NtGdiDdLockD3D",
    "NtGdiDdUnlockD3D",
    "NtGdiGetCharWidthW",
    "NtUserInvalidateRgn",
    "NtUserGetClipboardOwner",
    "NtUserSetWindowRgn",
    "NtUserBitBltSysBmp",
    "NtGdiGetCharWidthInfo",
    "NtUserValidateRect",
    "NtUserCloseClipboard",
    "NtUserOpenClipboard",
    "NtGdiGetStockObject",
    "NtUserSetClipboardData",
    "NtUserEnableMenuItem",
    "NtUserAlterWindowStyle",
    "NtGdiFillRgn",
    "NtUserGetWindowPlacement",
    "NtGdiModifyWorldTransform",
    "NtGdiGetFontData",
    "NtUserGetOpenClipboardWindow",
    "NtUserSetThreadState",
    "NtGdiOpenDCW",
    "NtUserTrackMouseEvent",
    "NtGdiGetTransform",
    "NtUserDestroyMenu",
    "NtGdiGetBitmapBits",
    "NtUserConsoleControl",
    "NtUserSetActiveWindow",
    "NtUserSetInformationThread",
    "NtUserSetWindowPlacement",
    "NtUserGetControlColor",
    "NtGdiSetMetaRgn",
    "NtGdiSetMiterLimit",
    "NtGdiSetVirtualResolution",
    "NtGdiGetRasterizerCaps",
    "NtUserSetWindowWord",
    "NtUserGetClipboardFormatName",
    "NtUserRealInternalGetMessage",
    "NtUserCreateLocalMemHandle",
    "NtUserAttachThreadInput",
    "NtGdiCreateHalftonePalette",
    "NtUserPaintMenuBar",
    "NtUserSetKeyboardState",
    "NtGdiCombineTransform",
    "NtUserCreateAcceleratorTable",
    "NtUserGetCursorFrameInfo",
    "NtUserGetAltTabInfo",
    "NtUserGetCaretBlinkTime",
    "NtGdiQueryFontAssocInfo",
    "NtUserProcessConnect",
    "NtUserEnumDisplayDevices",
    "NtUserEmptyClipboard",
    "NtUserGetClipboardData",
    "NtUserRemoveMenu",
    "NtGdiSetBoundsRect",
    "NtUserSetInformationProcess",
    "NtGdiGetBitmapDimension",
    "NtUserConvertMemHandle",
    "NtUserDestroyAcceleratorTable",
    "NtUserGetGUIThreadInfo",
    "NtGdiCloseFigure",
    "NtUserSetWindowsHookAW",
    "NtUserSetMenuDefaultItem",
    "NtUserCheckMenuItem",
    "NtUserSetWinEventHook",
    "NtUserUnhookWinEvent",
    "NtGdiSetupPublicCFONT",
    "NtUserLockWindowUpdate",
    "NtUserSetSystemMenu",
    "NtUserThunkedMenuInfo",
    "NtGdiBeginPath",
    "NtGdiEndPath",
    "NtGdiFillPath",
    "NtUserCallHwnd",
    "NtUserDdeInitialize",
    "NtUserModifyUserStartupInfoFlags",
    "NtUserCountClipboardFormats",
    "NtGdiAddFontMemResourceEx",
    "NtGdiEqualRgn",
    "NtGdiGetSystemPaletteUse",
    "NtGdiRemoveFontMemResourceEx",
    "NtUserEnumDisplaySettings",
    "NtUserPaintDesktop",
    "NtGdiExtEscape",
    "NtGdiSetBitmapDimension",
    "NtGdiSetFontEnumeration",
    "NtUserChangeClipboardChain",
    "NtUserResolveDesktop",
    "NtUserSetClipboardViewer",
    "NtUserShowWindowAsync",
    "NtUserSetConsoleReserveKeys",
    "NtGdiCreateColorSpace",
    "NtGdiDeleteColorSpace",
    "NtUserActivateKeyboardLayout",
    "NtGdiAbortDoc",
    "NtGdiAbortPath",
    "NtGdiAddEmbFontToDC",
    "NtGdiAddFontResourceW",
    "NtGdiAddRemoteFontToDC",
    "NtGdiAddRemoteMMInstanceToDC",
    "NtGdiAngleArc",
    "NtGdiAnyLinkedFonts",
    "NtGdiArcInternal",
    "NtGdiBRUSHOBJ_DeleteRbrush",
    "NtGdiBRUSHOBJ_hGetColorTransform",
    "NtGdiBRUSHOBJ_pvAllocRbrush",
    "NtGdiBRUSHOBJ_pvGetRbrush",
    "NtGdiBRUSHOBJ_ulGetBrushColor",
    "NtGdiCLIPOBJ_bEnum",
    "NtGdiCLIPOBJ_cEnumStart",
    "NtGdiCLIPOBJ_ppoGetPath",
    "NtGdiCancelDC",
    "NtGdiChangeGhostFont",
    "NtGdiCheckBitmapBits",
    "NtGdiClearBitmapAttributes",
    "NtGdiClearBrushAttributes",
    "NtGdiColorCorrectPalette",
    "NtGdiConfigureOPMProtectedOutput",
    "NtGdiConvertMetafileRect",
    "NtGdiCreateColorTransform",
    "NtGdiCreateEllipticRgn",
    "NtGdiCreateHatchBrushInternal",
    "NtGdiCreateMetafileDC",
    "NtGdiCreateOPMProtectedOutputs",
    "NtGdiCreateRoundRectRgn",
    "NtGdiCreateServerMetaFile",
    "NtGdiD3dContextCreate",
    "NtGdiD3dContextDestroy",
    "NtGdiD3dContextDestroyAll",
    "NtGdiD3dValidateTextureStageState",
    "NtGdiDDCCIGetCapabilitiesString",
    "NtGdiDDCCIGetCapabilitiesStringLength",
    "NtGdiDDCCIGetTimingReport",
    "NtGdiDDCCIGetVCPFeature",
    "NtGdiDDCCISaveCurrentSettings",
    "NtGdiDDCCISetVCPFeature",
    "NtGdiDdAddAttachedSurface",
    "NtGdiDdAlphaBlt",
    "NtGdiDdAttachSurface",
    "NtGdiDdBeginMoCompFrame",
    "NtGdiDdCanCreateD3DBuffer",
    "NtGdiDdColorControl",
    "NtGdiDdCreateD3DBuffer",
    "NtGdiDdCreateDirectDrawObject",
    "NtGdiDdCreateMoComp",
    "NtGdiDdDDICheckExclusiveOwnership",
    "NtGdiDdDDICheckMonitorPowerState",
    "NtGdiDdDDICheckOcclusion",
    "NtGdiDdDDICloseAdapter",
    "NtGdiDdDDICreateAllocation",
    "NtGdiDdDDICreateContext",
    "NtGdiDdDDICreateDCFromMemory",
    "NtGdiDdDDICreateDevice",
    "NtGdiDdDDICreateOverlay",
    "NtGdiDdDDICreateSynchronizationObject",
    "NtGdiDdDDIDestroyAllocation",
    "NtGdiDdDDIDestroyContext",
    "NtGdiDdDDIDestroyDCFromMemory",
    "NtGdiDdDDIDestroyDevice",
    "NtGdiDdDDIDestroyOverlay",
    "NtGdiDdDDIDestroySynchronizationObject",
    "NtGdiDdDDIEscape",
    "NtGdiDdDDIFlipOverlay",
    "NtGdiDdDDIGetContextSchedulingPriority",
    "NtGdiDdDDIGetDeviceState",
    "NtGdiDdDDIGetDisplayModeList",
    "NtGdiDdDDIGetMultisampleMethodList",
    "NtGdiDdDDIGetPresentHistory",
    "NtGdiDdDDIGetProcessSchedulingPriorityClass",
    "NtGdiDdDDIGetRuntimeData",
    "NtGdiDdDDIGetScanLine",
    "NtGdiDdDDIGetSharedPrimaryHandle",
    "NtGdiDdDDIInvalidateActiveVidPn",
    "NtGdiDdDDILock",
    "NtGdiDdDDIOpenAdapterFromDeviceName",
    "NtGdiDdDDIOpenAdapterFromHdc",
    "NtGdiDdDDIOpenResource",
    "NtGdiDdDDIPollDisplayChildren",
    "NtGdiDdDDIPresent",
    "NtGdiDdDDIQueryAdapterInfo",
    "NtGdiDdDDIQueryAllocationResidency",
    "NtGdiDdDDIQueryResourceInfo",
    "NtGdiDdDDIQueryStatistics",
    "NtGdiDdDDIReleaseProcessVidPnSourceOwners",
    "NtGdiDdDDIRender",
    "NtGdiDdDDISetAllocationPriority",
    "NtGdiDdDDISetContextSchedulingPriority",
    "NtGdiDdDDISetDisplayMode",
    "NtGdiDdDDISetDisplayPrivateDriverFormat",
    "NtGdiDdDDISetGammaRamp",
    "NtGdiDdDDISetProcessSchedulingPriorityClass",
    "NtGdiDdDDISetQueuedLimit",
    "NtGdiDdDDISetVidPnSourceOwner",
    "NtGdiDdDDISharedPrimaryLockNotification",
    "NtGdiDdDDISharedPrimaryUnLockNotification",
    "NtGdiDdDDISignalSynchronizationObject",
    "NtGdiDdDDIUnlock",
    "NtGdiDdDDIUpdateOverlay",
    "NtGdiDdDDIWaitForIdle",
    "NtGdiDdDDIWaitForSynchronizationObject",
    "NtGdiDdDDIWaitForVerticalBlankEvent",
    "NtGdiDdDeleteDirectDrawObject",
    "NtGdiDdDestroyD3DBuffer",
    "NtGdiDdDestroyMoComp",
    "NtGdiDdEndMoCompFrame",
    "NtGdiDdFlip",
    "NtGdiDdFlipToGDISurface",
    "NtGdiDdGetAvailDriverMemory",
    "NtGdiDdGetBltStatus",
    "NtGdiDdGetDC",
    "NtGdiDdGetDriverInfo",
    "NtGdiDdGetDriverState",
    "NtGdiDdGetDxHandle",
    "NtGdiDdGetFlipStatus",
    "NtGdiDdGetInternalMoCompInfo",
    "NtGdiDdGetMoCompBuffInfo",
    "NtGdiDdGetMoCompFormats",
    "NtGdiDdGetMoCompGuids",
    "NtGdiDdGetScanLine",
    "NtGdiDdLock",
    "NtGdiDdQueryDirectDrawObject",
    "NtGdiDdQueryMoCompStatus",
    "NtGdiDdReenableDirectDrawObject",
    "NtGdiDdReleaseDC",
    "NtGdiDdRenderMoComp",
    "NtGdiDdSetColorKey",
    "NtGdiDdSetExclusiveMode",
    "NtGdiDdSetGammaRamp",
    "NtGdiDdSetOverlayPosition",
    "NtGdiDdUnattachSurface",
    "NtGdiDdUnlock",
    "NtGdiDdUpdateOverlay",
    "NtGdiDdWaitForVerticalBlank",
    "NtGdiDeleteColorTransform",
    "NtGdiDescribePixelFormat",
    "NtGdiDestroyOPMProtectedOutput",
    "NtGdiDestroyPhysicalMonitor",
    "NtGdiDoBanding",
    "NtGdiDrawEscape",
    "NtGdiDvpAcquireNotification",
    "NtGdiDvpCanCreateVideoPort",
    "NtGdiDvpColorControl",
    "NtGdiDvpCreateVideoPort",
    "NtGdiDvpDestroyVideoPort",
    "NtGdiDvpFlipVideoPort",
    "NtGdiDvpGetVideoPortBandwidth",
    "NtGdiDvpGetVideoPortConnectInfo",
    "NtGdiDvpGetVideoPortField",
    "NtGdiDvpGetVideoPortFlipStatus",
    "NtGdiDvpGetVideoPortInputFormats",
    "NtGdiDvpGetVideoPortLine",
    "NtGdiDvpGetVideoPortOutputFormats",
    "NtGdiDvpGetVideoSignalStatus",
    "NtGdiDvpReleaseNotification",
    "NtGdiDvpUpdateVideoPort",
    "NtGdiDvpWaitForVideoPortSync",
    "NtGdiDwmGetDirtyRgn",
    "NtGdiDwmGetSurfaceData",
    "NtGdiDxgGenericThunk",
    "NtGdiEllipse",
    "NtGdiEnableEudc",
    "NtGdiEndDoc",
    "NtGdiEndPage",
    "NtGdiEngAlphaBlend",
    "NtGdiEngAssociateSurface",
    "NtGdiEngBitBlt",
    "NtGdiEngCheckAbort",
    "NtGdiEngComputeGlyphSet",
    "NtGdiEngCopyBits",
    "NtGdiEngCreateBitmap",
    "NtGdiEngCreateClip",
    "NtGdiEngCreateDeviceBitmap",
    "NtGdiEngCreateDeviceSurface",
    "NtGdiEngCreatePalette",
    "NtGdiEngDeleteClip",
    "NtGdiEngDeletePalette",
    "NtGdiEngDeletePath",
    "NtGdiEngDeleteSurface",
    "NtGdiEngEraseSurface",
    "NtGdiEngFillPath",
    "NtGdiEngGradientFill",
    "NtGdiEngLineTo",
    "NtGdiEngLockSurface",
    "NtGdiEngMarkBandingSurface",
    "NtGdiEngPaint",
    "NtGdiEngPlgBlt",
    "NtGdiEngStretchBlt",
    "NtGdiEngStretchBltROP",
    "NtGdiEngStrokeAndFillPath",
    "NtGdiEngStrokePath",
    "NtGdiEngTextOut",
    "NtGdiEngTransparentBlt",
    "NtGdiEngUnlockSurface",
    "NtGdiEnumObjects",
    "NtGdiEudcLoadUnloadLink",
    "NtGdiExtFloodFill",
    "NtGdiFONTOBJ_cGetAllGlyphHandles",
    "NtGdiFONTOBJ_cGetGlyphs",
    "NtGdiFONTOBJ_pQueryGlyphAttrs",
    "NtGdiFONTOBJ_pfdg",
    "NtGdiFONTOBJ_pifi",
    "NtGdiFONTOBJ_pvTrueTypeFontFile",
    "NtGdiFONTOBJ_pxoGetXform",
    "NtGdiFONTOBJ_vGetInfo",
    "NtGdiFlattenPath",
    "NtGdiFontIsLinked",
    "NtGdiForceUFIMapping",
    "NtGdiFrameRgn",
    "NtGdiFullscreenControl",
    "NtGdiGetBoundsRect",
    "NtGdiGetCOPPCompatibleOPMInformation",
    "NtGdiGetCertificate",
    "NtGdiGetCertificateSize",
    "NtGdiGetCharABCWidthsW",
    "NtGdiGetCharacterPlacementW",
    "NtGdiGetColorAdjustment",
    "NtGdiGetColorSpaceforBitmap",
    "NtGdiGetDeviceCaps",
    "NtGdiGetDeviceCapsAll",
    "NtGdiGetDeviceGammaRamp",
    "NtGdiGetDeviceWidth",
    "NtGdiGetDhpdev",
    "NtGdiGetETM",
    "NtGdiGetEmbUFI",
    "NtGdiGetEmbedFonts",
    "NtGdiGetEudcTimeStampEx",
    "NtGdiGetFontResourceInfoInternalW",
    "NtGdiGetFontUnicodeRanges",
    "NtGdiGetGlyphIndicesW",
    "NtGdiGetGlyphIndicesWInternal",
    "NtGdiGetGlyphOutline",
    "NtGdiGetKerningPairs",
    "NtGdiGetLinkedUFIs",
    "NtGdiGetMiterLimit",
    "NtGdiGetMonitorID",
    "NtGdiGetNumberOfPhysicalMonitors",
    "NtGdiGetOPMInformation",
    "NtGdiGetOPMRandomNumber",
    "NtGdiGetObjectBitmapHandle",
    "NtGdiGetPath",
    "NtGdiGetPerBandInfo",
    "NtGdiGetPhysicalMonitorDescription",
    "NtGdiGetPhysicalMonitors",
    "NtGdiGetRealizationInfo",
    "NtGdiGetServerMetaFileBits",
    "NtGdiGetSpoolMessage",
    "NtGdiGetStats",
    "NtGdiGetStringBitmapW",
    "NtGdiGetSuggestedOPMProtectedOutputArraySize",
    "NtGdiGetTextExtentExW",
    "NtGdiGetUFI",
    "NtGdiGetUFIPathname",
    "NtGdiGradientFill",
    "NtGdiHT_Get8BPPFormatPalette",
    "NtGdiHT_Get8BPPMaskPalette",
    "NtGdiIcmBrushInfo",
    "EngRestoreFloatingPointState",
    "NtGdiInitSpool",
    "NtGdiMakeFontDir",
    "NtGdiMakeInfoDC",
    "NtGdiMakeObjectUnXferable",
    "NtGdiMakeObjectXferable",
    "NtGdiMirrorWindowOrg",
    "NtGdiMonoBitmap",
    "NtGdiMoveTo",
    "NtGdiOffsetClipRgn",
    "NtGdiPATHOBJ_bEnum",
    "NtGdiPATHOBJ_bEnumClipLines",
    "NtGdiPATHOBJ_vEnumStart",
    "NtGdiPATHOBJ_vEnumStartClipLines",
    "NtGdiPATHOBJ_vGetBounds",
    "NtGdiPathToRegion",
    "NtGdiPlgBlt",
    "NtGdiPolyDraw",
    "NtGdiPolyTextOutW",
    "NtGdiPtInRegion",
    "NtGdiPtVisible",
    "NtGdiQueryFonts",
    "NtGdiRemoveFontResourceW",
    "NtGdiRemoveMergeFont",
    "NtGdiResetDC",
    "NtGdiResizePalette",
    "NtGdiRoundRect",
    "NtGdiSTROBJ_bEnum",
    "NtGdiSTROBJ_bEnumPositionsOnly",
    "NtGdiSTROBJ_bGetAdvanceWidths",
    "NtGdiSTROBJ_dwGetCodePage",
    "NtGdiSTROBJ_vEnumStart",
    "NtGdiScaleViewportExtEx",
    "NtGdiScaleWindowExtEx",
    "NtGdiSelectBrush",
    "NtGdiSelectClipPath",
    "NtGdiSelectPen",
    "NtGdiSetBitmapAttributes",
    "NtGdiSetBrushAttributes",
    "NtGdiSetColorAdjustment",
    "NtGdiSetColorSpace",
    "NtGdiSetDeviceGammaRamp",
    "NtGdiSetFontXform",
    "NtGdiSetIcmMode",
    "NtGdiSetLinkedUFIs",
    "NtGdiSetMagicColors",
    "NtGdiSetOPMSigningKeyAndSequenceNumbers",
    "NtGdiSetPUMPDOBJ",
    "NtGdiSetPixelFormat",
    "NtGdiSetRectRgn",
    "NtGdiSetSizeDevice",
    "NtGdiSetSystemPaletteUse",
    "NtGdiSetTextJustification",
    "NtGdiStartDoc",
    "NtGdiStartPage",
    "NtGdiStrokeAndFillPath",
    "NtGdiStrokePath",
    "NtGdiSwapBuffers",
    "NtGdiTransparentBlt",
    "NtGdiUMPDEngFreeUserMem",
    "DxgStubAlphaBlt",
    "EngRestoreFloatingPointState",
    "NtGdiUpdateColors",
    "NtGdiUpdateTransform",
    "NtGdiWidenPath",
    "NtGdiXFORMOBJ_bApplyXform",
    "NtGdiXFORMOBJ_iGetXform",
    "NtGdiXLATEOBJ_cGetPalette",
    "NtGdiXLATEOBJ_hGetColorTransform",
    "NtGdiXLATEOBJ_iXlate",
    "NtUserAddClipboardFormatListener",
    "NtUserAssociateInputContext",
    "NtUserBlockInput",
    "NtUserBuildHimcList",
    "NtUserBuildPropList",
    "NtUserCallHwndOpt",
    "NtUserChangeDisplaySettings",
    "NtUserCheckAccessForIntegrityLevel",
    "NtUserCheckDesktopByThreadId",
    "NtUserCheckWindowThreadDesktop",
    "NtUserChildWindowFromPointEx",
    "NtUserClipCursor",
    "NtUserCreateDesktopEx",
    "NtUserCreateInputContext",
    "NtUserCreateWindowStation",
    "NtUserCtxDisplayIOCtl",
    "NtUserDestroyInputContext",
    "NtUserDisableThreadIme",
    "NtUserDoSoundConnect",
    "NtUserDoSoundDisconnect",
    "NtUserDragDetect",
    "NtUserDragObject",
    "NtUserDrawAnimatedRects",
    "NtUserDrawCaption",
    "NtUserDrawCaptionTemp",
    "NtUserDrawMenuBarTemp",
    "NtUserDwmGetDxRgn",
    "NtUserDwmHintDxUpdate",
    "NtUserDwmStartRedirection",
    "NtUserDwmStopRedirection",
    "NtUserEndMenu",
    "NtUserEvent",
    "NtUserFlashWindowEx",
    "NtUserFrostCrashedWindow",
    "NtUserGetAppImeLevel",
    "NtUserGetCaretPos",
    "NtUserGetClipCursor",
    "NtUserGetClipboardViewer",
    "NtUserGetComboBoxInfo",
    "NtUserGetCursorInfo",
    "NtUserGetGuiResources",
    "NtUserGetImeHotKey",
    "NtUserGetImeInfoEx",
    "NtUserGetInternalWindowPos",
    "NtUserGetKeyNameText",
    "NtUserGetKeyboardLayoutName",
    "NtUserGetLayeredWindowAttributes",
    "NtUserGetListBoxInfo",
    "NtUserGetMenuIndex",
    "NtUserGetMenuItemRect",
    "NtUserGetMouseMovePointsEx",
    "NtUserGetPriorityClipboardFormat",
    "NtUserGetRawInputBuffer",
    "NtUserGetRawInputData",
    "NtUserGetRawInputDeviceInfo",
    "NtUserGetRawInputDeviceList",
    "NtUserGetRegisteredRawInputDevices",
    "NtUserGetUpdatedClipboardFormats",
    "NtUserGetWOWClass",
    "NtUserGetWindowMinimizeRect",
    "NtUserGetWindowRgnEx",
    "NtUserGhostWindowFromHungWindow",
    "NtUserHardErrorControl",
    "NtUserHiliteMenuItem",
    "NtUserHungWindowFromGhostWindow",
    "NtUserImpersonateDdeClientWindow",
    "NtUserInitTask",
    "NtUserInitialize",
    "NtUserInitializeClientPfnArrays",
    "NtUserInternalGetWindowIcon",
    "NtUserLoadKeyboardLayoutEx",
    "NtUserLockWindowStation",
    "NtUserLockWorkStation",
    "NtUserLogicalToPhysicalPoint",
    "NtUserMNDragLeave",
    "NtUserMNDragOver",
    "NtUserMenuItemFromPoint",
    "NtUserMinMaximize",
    "NtUserNotifyIMEStatus",
    "NtUserOpenInputDesktop",
    "NtUserOpenThreadDesktop",
    "NtUserPaintMonitor",
    "NtUserPhysicalToLogicalPoint",
    "NtUserPrintWindow",
    "NtUserQueryInformationThread",
    "NtUserQueryInputContext",
    "NtUserQuerySendMessage",
    "NtUserRealChildWindowFromPoint",
    "NtUserRealWaitMessageEx",
    "NtUserRegisterErrorReportingDialog",
    "NtUserRegisterHotKey",
    "NtUserRegisterRawInputDevices",
    "NtUserRegisterSessionPort",
    "NtUserRegisterTasklist",
    "NtUserRegisterUserApiHook",
    "NtUserRemoteConnect",
    "NtUserRemoteRedrawRectangle",
    "NtUserRemoteRedrawScreen",
    "NtUserRemoteStopScreenUpdates",
    "NtUserRemoveClipboardFormatListener",
    "NtUserResolveDesktopForWOW",
    "NtUserSetAppImeLevel",
    "NtUserSetClassWord",
    "NtUserSetCursorContents",
    "NtUserSetImeHotKey",
    "NtUserSetImeInfoEx",
    "NtUserSetImeOwnerWindow",
    "NtUserSetInternalWindowPos",
    "NtUserSetLayeredWindowAttributes",
    "NtUserSetMenu",
    "NtUserSetMenuContextHelpId",
    "NtUserSetMenuFlagRtoL",
    "NtUserSetMirrorRendering",
    "NtUserSetObjectInformation",
    "NtUserSetProcessDPIAware",
    "NtUserSetShellWindowEx",
    "NtUserSetSysColors",
    "NtUserSetSystemCursor",
    "NtUserSetSystemTimer",
    "NtUserSetThreadLayoutHandles",
    "NtUserSetWindowRgnEx",
    "NtUserSetWindowStationUser",
    "NtUserShowSystemCursor",
    "NtUserSoundSentry",
    "NtUserSwitchDesktop",
    "NtUserTestForInteractiveUser",
    "NtUserTrackPopupMenuEx",
    "NtUserUnloadKeyboardLayout",
    "NtUserUnlockWindowStation",
    "NtUserUnregisterHotKey",
    "NtUserUnregisterSessionPort",
    "NtUserUnregisterUserApiHook",
    "NtUserUpdateInputContext",
    "NtUserUpdateInstance",
    "NtUserUpdateLayeredWindow",
    "NtUserUpdatePerUserSystemParameters",
    "NtUserUpdateWindowTransform",
    "NtUserUserHandleGrantAccess",
    "NtUserValidateHandleSecure",
    "NtUserWaitForInputIdle",
    "NtUserWaitForMsgAndEvent",
    "DxgStubAlphaBlt",
    "NtUserWindowFromPhysicalPoint",
    "NtUserYieldTask",
    "NtUserSetClassLongPtr",
    "NtUserSetWindowLongPtr"
};

//////////////////////////////////////////////////////////////////////////
// Windows 7 SP1 _W32pServiceTable
//////////////////////////////////////////////////////////////////////////
static const char* W32pServiceTable_Win7Sp0_x64[] = {
    "NtUserGetThreadState",
    "NtUserPeekMessage",
    "NtUserCallOneParam",
    "NtUserGetKeyState",
    "NtUserInvalidateRect",
    "NtUserCallNoParam",
    "NtUserGetMessage",
    "NtUserMessageCall",
    "NtGdiBitBlt",
    "NtGdiGetCharSet",
    "NtUserGetDC",
    "NtGdiSelectBitmap",
    "NtUserWaitMessage",
    "NtUserTranslateMessage",
    "NtUserGetProp",
    "NtUserPostMessage",
    "NtUserQueryWindow",
    "NtUserTranslateAccelerator",
    "NtGdiFlush",
    "NtUserRedrawWindow",
    "NtUserWindowFromPoint",
    "NtUserCallMsgFilter",
    "NtUserValidateTimerCallback",
    "NtUserBeginPaint",
    "NtUserSetTimer",
    "NtUserEndPaint",
    "NtUserSetCursor",
    "NtUserKillTimer",
    "NtUserBuildHwndList",
    "NtUserSelectPalette",
    "NtUserCallNextHookEx",
    "NtUserHideCaret",
    "NtGdiIntersectClipRect",
    "NtUserCallHwndLock",
    "NtUserGetProcessWindowStation",
    "NtGdiDeleteObjectApp",
    "NtUserSetWindowPos",
    "NtUserShowCaret",
    "NtUserEndDeferWindowPosEx",
    "NtUserCallHwndParamLock",
    "NtUserVkKeyScanEx",
    "NtGdiSetDIBitsToDeviceInternal",
    "NtUserCallTwoParam",
    "NtGdiGetRandomRgn",
    "NtUserCopyAcceleratorTable",
    "NtUserNotifyWinEvent",
    "NtGdiExtSelectClipRgn",
    "NtUserIsClipboardFormatAvailable",
    "NtUserSetScrollInfo",
    "NtGdiStretchBlt",
    "NtUserCreateCaret",
    "NtGdiRectVisible",
    "NtGdiCombineRgn",
    "NtGdiGetDCObject",
    "NtUserDispatchMessage",
    "NtUserRegisterWindowMessage",
    "NtGdiExtTextOutW",
    "NtGdiSelectFont",
    "NtGdiRestoreDC",
    "NtGdiSaveDC",
    "NtUserGetForegroundWindow",
    "NtUserShowScrollBar",
    "NtUserFindExistingCursorIcon",
    "NtGdiGetDCDword",
    "NtGdiGetRegionData",
    "NtGdiLineTo",
    "NtUserSystemParametersInfo",
    "NtGdiGetAppClipBox",
    "NtUserGetAsyncKeyState",
    "NtUserGetCPD",
    "NtUserRemoveProp",
    "NtGdiDoPalette",
    "NtGdiPolyPolyDraw",
    "NtUserSetCapture",
    "NtUserEnumDisplayMonitors",
    "NtGdiCreateCompatibleBitmap",
    "NtUserSetProp",
    "NtGdiGetTextCharsetInfo",
    "NtUserSBGetParms",
    "NtUserGetIconInfo",
    "NtUserExcludeUpdateRgn",
    "NtUserSetFocus",
    "NtGdiExtGetObjectW",
    "NtUserDeferWindowPos",
    "NtUserGetUpdateRect",
    "NtGdiCreateCompatibleDC",
    "NtUserGetClipboardSequenceNumber",
    "NtGdiCreatePen",
    "NtUserShowWindow",
    "NtUserGetKeyboardLayoutList",
    "NtGdiPatBlt",
    "NtUserMapVirtualKeyEx",
    "NtUserSetWindowLong",
    "NtGdiHfontCreate",
    "NtUserMoveWindow",
    "NtUserPostThreadMessage",
    "NtUserDrawIconEx",
    "NtUserGetSystemMenu",
    "NtGdiDrawStream",
    "NtUserInternalGetWindowText",
    "NtUserGetWindowDC",
    "NtGdiD3dDrawPrimitives2",
    "NtGdiInvertRgn",
    "NtGdiGetRgnBox",
    "NtGdiGetAndSetDCDword",
    "NtGdiMaskBlt",
    "NtGdiGetWidthTable",
    "NtUserScrollDC",
    "NtUserGetObjectInformation",
    "NtGdiCreateBitmap",
    "NtUserFindWindowEx",
    "NtGdiPolyPatBlt",
    "NtUserUnhookWindowsHookEx",
    "NtGdiGetNearestColor",
    "NtGdiTransformPoints",
    "NtGdiGetDCPoint",
    "NtGdiCreateDIBBrush",
    "NtGdiGetTextMetricsW",
    "NtUserCreateWindowEx",
    "NtUserSetParent",
    "NtUserGetKeyboardState",
    "NtUserToUnicodeEx",
    "NtUserGetControlBrush",
    "NtUserGetClassName",
    "NtGdiAlphaBlend",
    "NtGdiDdBlt",
    "NtGdiOffsetRgn",
    "NtUserDefSetText",
    "NtGdiGetTextFaceW",
    "NtGdiStretchDIBitsInternal",
    "NtUserSendInput",
    "NtUserGetThreadDesktop",
    "NtGdiCreateRectRgn",
    "NtGdiGetDIBitsInternal",
    "NtUserGetUpdateRgn",
    "NtGdiDeleteClientObj",
    "NtUserGetIconSize",
    "NtUserFillWindow",
    "NtGdiExtCreateRegion",
    "NtGdiComputeXformCoefficients",
    "NtUserSetWindowsHookEx",
    "NtUserNotifyProcessCreate",
    "NtGdiUnrealizeObject",
    "NtUserGetTitleBarInfo",
    "NtGdiRectangle",
    "NtUserSetThreadDesktop",
    "NtUserGetDCEx",
    "NtUserGetScrollBarInfo",
    "NtGdiGetTextExtent",
    "NtUserSetWindowFNID",
    "NtGdiSetLayout",
    "NtUserCalcMenuBar",
    "NtUserThunkedMenuItemInfo",
    "NtGdiExcludeClipRect",
    "NtGdiCreateDIBSection",
    "NtGdiGetDCforBitmap",
    "NtUserDestroyCursor",
    "NtUserDestroyWindow",
    "NtUserCallHwndParam",
    "NtGdiCreateDIBitmapInternal",
    "NtUserOpenWindowStation",
    "NtGdiDdDeleteSurfaceObject",
    "NtGdiDdCanCreateSurface",
    "NtGdiDdCreateSurface",
    "NtUserSetCursorIconData",
    "NtGdiDdDestroySurface",
    "NtUserCloseDesktop",
    "NtUserOpenDesktop",
    "NtUserSetProcessWindowStation",
    "NtUserGetAtomName",
    "NtGdiDdResetVisrgn",
    "NtGdiExtCreatePen",
    "NtGdiCreatePaletteInternal",
    "NtGdiSetBrushOrg",
    "NtUserBuildNameList",
    "NtGdiSetPixel",
    "NtUserRegisterClassExWOW",
    "NtGdiCreatePatternBrushInternal",
    "NtUserGetAncestor",
    "NtGdiGetOutlineTextMetricsInternalW",
    "NtGdiSetBitmapBits",
    "NtUserCloseWindowStation",
    "NtUserGetDoubleClickTime",
    "NtUserEnableScrollBar",
    "NtGdiCreateSolidBrush",
    "NtUserGetClassInfoEx",
    "NtGdiCreateClientObj",
    "NtUserUnregisterClass",
    "NtUserDeleteMenu",
    "NtGdiRectInRegion",
    "NtUserScrollWindowEx",
    "NtGdiGetPixel",
    "NtUserSetClassLong",
    "NtUserGetMenuBarInfo",
    "NtGdiDdCreateSurfaceEx",
    "NtGdiDdCreateSurfaceObject",
    "NtGdiGetNearestPaletteIndex",
    "NtGdiDdLockD3D",
    "NtGdiDdUnlockD3D",
    "NtGdiGetCharWidthW",
    "NtUserInvalidateRgn",
    "NtUserGetClipboardOwner",
    "NtUserSetWindowRgn",
    "NtUserBitBltSysBmp",
    "NtGdiGetCharWidthInfo",
    "NtUserValidateRect",
    "NtUserCloseClipboard",
    "NtUserOpenClipboard",
    "NtGdiGetStockObject",
    "NtUserSetClipboardData",
    "NtUserEnableMenuItem",
    "NtUserAlterWindowStyle",
    "NtGdiFillRgn",
    "NtUserGetWindowPlacement",
    "NtGdiModifyWorldTransform",
    "NtGdiGetFontData",
    "NtUserGetOpenClipboardWindow",
    "NtUserSetThreadState",
    "NtGdiOpenDCW",
    "NtUserTrackMouseEvent",
    "NtGdiGetTransform",
    "NtUserDestroyMenu",
    "NtGdiGetBitmapBits",
    "NtUserConsoleControl",
    "NtUserSetActiveWindow",
    "NtUserSetInformationThread",
    "NtUserSetWindowPlacement",
    "NtUserGetControlColor",
    "NtGdiSetMetaRgn",
    "NtGdiSetMiterLimit",
    "NtGdiSetVirtualResolution",
    "NtGdiGetRasterizerCaps",
    "NtUserSetWindowWord",
    "NtUserGetClipboardFormatName",
    "NtUserRealInternalGetMessage",
    "NtUserCreateLocalMemHandle",
    "NtUserAttachThreadInput",
    "NtGdiCreateHalftonePalette",
    "NtUserPaintMenuBar",
    "NtUserSetKeyboardState",
    "NtGdiCombineTransform",
    "NtUserCreateAcceleratorTable",
    "NtUserGetCursorFrameInfo",
    "NtUserGetAltTabInfo",
    "NtUserGetCaretBlinkTime",
    "NtGdiQueryFontAssocInfo",
    "NtUserProcessConnect",
    "NtUserEnumDisplayDevices",
    "NtUserEmptyClipboard",
    "NtUserGetClipboardData",
    "NtUserRemoveMenu",
    "NtGdiSetBoundsRect",
    "NtGdiGetBitmapDimension",
    "NtUserConvertMemHandle",
    "NtUserDestroyAcceleratorTable",
    "NtUserGetGUIThreadInfo",
    "NtGdiCloseFigure",
    "NtUserSetWindowsHookAW",
    "NtUserSetMenuDefaultItem",
    "NtUserCheckMenuItem",
    "NtUserSetWinEventHook",
    "NtUserUnhookWinEvent",
    "NtUserLockWindowUpdate",
    "NtUserSetSystemMenu",
    "NtUserThunkedMenuInfo",
    "NtGdiBeginPath",
    "NtGdiEndPath",
    "NtGdiFillPath",
    "NtUserCallHwnd",
    "NtUserDdeInitialize",
    "NtUserModifyUserStartupInfoFlags",
    "NtUserCountClipboardFormats",
    "NtGdiAddFontMemResourceEx",
    "NtGdiEqualRgn",
    "NtGdiGetSystemPaletteUse",
    "NtGdiRemoveFontMemResourceEx",
    "NtUserEnumDisplaySettings",
    "NtUserPaintDesktop",
    "NtGdiExtEscape",
    "NtGdiSetBitmapDimension",
    "NtGdiSetFontEnumeration",
    "NtUserChangeClipboardChain",
    "NtUserSetClipboardViewer",
    "NtUserShowWindowAsync",
    "NtGdiCreateColorSpace",
    "NtGdiDeleteColorSpace",
    "NtUserActivateKeyboardLayout",
    "NtGdiAbortDoc",
    "NtGdiAbortPath",
    "NtGdiAddEmbFontToDC",
    "NtGdiAddFontResourceW",
    "NtGdiAddRemoteFontToDC",
    "NtGdiAddRemoteMMInstanceToDC",
    "NtGdiAngleArc",
    "NtGdiAnyLinkedFonts",
    "NtGdiArcInternal",
    "NtGdiBRUSHOBJ_DeleteRbrush",
    "NtGdiBRUSHOBJ_hGetColorTransform",
    "NtGdiBRUSHOBJ_pvAllocRbrush",
    "NtGdiBRUSHOBJ_pvGetRbrush",
    "NtGdiBRUSHOBJ_ulGetBrushColor",
    "NtGdiBeginGdiRendering",
    "NtGdiCLIPOBJ_bEnum",
    "NtGdiCLIPOBJ_cEnumStart",
    "NtGdiCLIPOBJ_ppoGetPath",
    "NtGdiCancelDC",
    "NtGdiChangeGhostFont",
    "NtGdiCheckBitmapBits",
    "NtGdiClearBitmapAttributes",
    "NtGdiClearBrushAttributes",
    "NtGdiColorCorrectPalette",
    "NtGdiConfigureOPMProtectedOutput",
    "NtGdiConvertMetafileRect",
    "NtGdiCreateBitmapFromDxSurface",
    "NtGdiCreateColorTransform",
    "NtGdiCreateEllipticRgn",
    "NtGdiCreateHatchBrushInternal",
    "NtGdiCreateMetafileDC",
    "NtGdiCreateOPMProtectedOutputs",
    "NtGdiCreateRoundRectRgn",
    "NtGdiCreateServerMetaFile",
    "NtGdiD3dContextCreate",
    "NtGdiD3dContextDestroy",
    "NtGdiD3dContextDestroyAll",
    "NtGdiD3dValidateTextureStageState",
    "NtGdiDDCCIGetCapabilitiesString",
    "NtGdiDDCCIGetCapabilitiesStringLength",
    "NtGdiDDCCIGetTimingReport",
    "NtGdiDDCCIGetVCPFeature",
    "NtGdiDDCCISaveCurrentSettings",
    "NtGdiDDCCISetVCPFeature",
    "NtGdiDdAddAttachedSurface",
    "NtGdiDdAlphaBlt",
    "NtGdiDdAttachSurface",
    "NtGdiDdBeginMoCompFrame",
    "NtGdiDdCanCreateD3DBuffer",
    "NtGdiDdColorControl",
    "NtGdiDdCreateD3DBuffer",
    "NtGdiDdCreateDirectDrawObject",
    "NtGdiDdCreateFullscreenSprite",
    "NtGdiDdCreateMoComp",
    "NtGdiDdDDIAcquireKeyedMutex",
    "NtGdiDdDDICheckExclusiveOwnership",
    "NtGdiDdDDICheckMonitorPowerState",
    "NtGdiDdDDICheckOcclusion",
    "NtGdiDdDDICheckSharedResourceAccess",
    "NtGdiDdDDICheckVidPnExclusiveOwnership",
    "NtGdiDdDDICloseAdapter",
    "NtGdiDdDDIConfigureSharedResource",
    "NtGdiDdDDICreateAllocation",
    "NtGdiDdDDICreateContext",
    "NtGdiDdDDICreateDCFromMemory",
    "NtGdiDdDDICreateDevice",
    "NtGdiDdDDICreateKeyedMutex",
    "NtGdiDdDDICreateOverlay",
    "NtGdiDdDDICreateSynchronizationObject",
    "NtGdiDdDDIDestroyAllocation",
    "NtGdiDdDDIDestroyContext",
    "NtGdiDdDDIDestroyDCFromMemory",
    "NtGdiDdDDIDestroyDevice",
    "NtGdiDdDDIDestroyKeyedMutex",
    "NtGdiDdDDIDestroyOverlay",
    "NtGdiDdDDIDestroySynchronizationObject",
    "NtGdiDdDDIEscape",
    "NtGdiDdDDIFlipOverlay",
    "NtGdiDdDDIGetContextSchedulingPriority",
    "NtGdiDdDDIGetDeviceState",
    "NtGdiDdDDIGetDisplayModeList",
    "NtGdiDdDDIGetMultisampleMethodList",
    "NtGdiDdDDIGetOverlayState",
    "NtGdiDdDDIGetPresentHistory",
    "NtGdiDdDDIGetPresentQueueEvent",
    "NtGdiDdDDIGetProcessSchedulingPriorityClass",
    "NtGdiDdDDIGetRuntimeData",
    "NtGdiDdDDIGetScanLine",
    "NtGdiDdDDIGetSharedPrimaryHandle",
    "NtGdiDdDDIInvalidateActiveVidPn",
    "NtGdiDdDDILock",
    "NtGdiDdDDIOpenAdapterFromDeviceName",
    "NtGdiDdDDIOpenAdapterFromHdc",
    "NtGdiDdDDIOpenKeyedMutex",
    "NtGdiDdDDIOpenResource",
    "NtGdiDdDDIOpenSynchronizationObject",
    "NtGdiDdDDIPollDisplayChildren",
    "NtGdiDdDDIPresent",
    "NtGdiDdDDIQueryAdapterInfo",
    "NtGdiDdDDIQueryAllocationResidency",
    "NtGdiDdDDIQueryResourceInfo",
    "NtGdiDdDDIQueryStatistics",
    "NtGdiDdDDIReleaseKeyedMutex",
    "NtGdiDdDDIReleaseProcessVidPnSourceOwners",
    "NtGdiDdDDIRender",
    "NtGdiDdDDISetAllocationPriority",
    "NtGdiDdDDISetContextSchedulingPriority",
    "NtGdiDdDDISetDisplayMode",
    "NtGdiDdDDISetDisplayPrivateDriverFormat",
    "NtGdiDdDDISetGammaRamp",
    "NtGdiDdDDISetProcessSchedulingPriorityClass",
    "NtGdiDdDDISetQueuedLimit",
    "NtGdiDdDDISetVidPnSourceOwner",
    "NtGdiDdDDISharedPrimaryLockNotification",
    "NtGdiDdDDISharedPrimaryUnLockNotification",
    "NtGdiDdDDISignalSynchronizationObject",
    "NtGdiDdDDIUnlock",
    "NtGdiDdDDIUpdateOverlay",
    "NtGdiDdDDIWaitForIdle",
    "NtGdiDdDDIWaitForSynchronizationObject",
    "NtGdiDdDDIWaitForVerticalBlankEvent",
    "NtGdiDdDeleteDirectDrawObject",
    "NtGdiDdDestroyD3DBuffer",
    "NtGdiDdDestroyFullscreenSprite",
    "NtGdiDdDestroyMoComp",
    "NtGdiDdEndMoCompFrame",
    "NtGdiDdFlip",
    "NtGdiDdFlipToGDISurface",
    "NtGdiDdGetAvailDriverMemory",
    "NtGdiDdGetBltStatus",
    "NtGdiDdGetDC",
    "NtGdiDdGetDriverInfo",
    "NtGdiDdGetDriverState",
    "NtGdiDdGetDxHandle",
    "NtGdiDdGetFlipStatus",
    "NtGdiDdGetInternalMoCompInfo",
    "NtGdiDdGetMoCompBuffInfo",
    "NtGdiDdGetMoCompFormats",
    "NtGdiDdGetMoCompGuids",
    "NtGdiDdGetScanLine",
    "NtGdiDdLock",
    "NtGdiDdNotifyFullscreenSpriteUpdate",
    "NtGdiDdQueryDirectDrawObject",
    "NtGdiDdQueryMoCompStatus",
    "NtGdiDdQueryVisRgnUniqueness",
    "NtGdiDdReenableDirectDrawObject",
    "NtGdiDdReleaseDC",
    "NtGdiDdRenderMoComp",
    "NtGdiDdSetColorKey",
    "NtGdiDdSetExclusiveMode",
    "NtGdiDdSetGammaRamp",
    "NtGdiDdSetOverlayPosition",
    "NtGdiDdUnattachSurface",
    "NtGdiDdUnlock",
    "NtGdiDdUpdateOverlay",
    "NtGdiDdWaitForVerticalBlank",
    "NtGdiDeleteColorTransform",
    "NtGdiDescribePixelFormat",
    "NtGdiDestroyOPMProtectedOutput",
    "NtGdiDestroyPhysicalMonitor",
    "NtGdiDoBanding",
    "NtGdiDrawEscape",
    "NtGdiDvpAcquireNotification",
    "NtGdiDvpCanCreateVideoPort",
    "NtGdiDvpColorControl",
    "NtGdiDvpCreateVideoPort",
    "NtGdiDvpDestroyVideoPort",
    "NtGdiDvpFlipVideoPort",
    "NtGdiDvpGetVideoPortBandwidth",
    "NtGdiDvpGetVideoPortConnectInfo",
    "NtGdiDvpGetVideoPortField",
    "NtGdiDvpGetVideoPortFlipStatus",
    "NtGdiDvpGetVideoPortInputFormats",
    "NtGdiDvpGetVideoPortLine",
    "NtGdiDvpGetVideoPortOutputFormats",
    "NtGdiDvpGetVideoSignalStatus",
    "NtGdiDvpReleaseNotification",
    "NtGdiDvpUpdateVideoPort",
    "NtGdiDvpWaitForVideoPortSync",
    "NtGdiDxgGenericThunk",
    "NtGdiEllipse",
    "NtGdiEnableEudc",
    "NtGdiEndDoc",
    "NtGdiEndGdiRendering",
    "NtGdiEndPage",
    "NtGdiEngAlphaBlend",
    "NtGdiEngAssociateSurface",
    "NtGdiEngBitBlt",
    "NtGdiEngCheckAbort",
    "NtGdiEngComputeGlyphSet",
    "NtGdiEngCopyBits",
    "NtGdiEngCreateBitmap",
    "NtGdiEngCreateClip",
    "NtGdiEngCreateDeviceBitmap",
    "NtGdiEngCreateDeviceSurface",
    "NtGdiEngCreatePalette",
    "NtGdiEngDeleteClip",
    "NtGdiEngDeletePalette",
    "NtGdiEngDeletePath",
    "NtGdiEngDeleteSurface",
    "NtGdiEngEraseSurface",
    "NtGdiEngFillPath",
    "NtGdiEngGradientFill",
    "NtGdiEngLineTo",
    "NtGdiEngLockSurface",
    "NtGdiEngMarkBandingSurface",
    "NtGdiEngPaint",
    "NtGdiEngPlgBlt",
    "NtGdiEngStretchBlt",
    "NtGdiEngStretchBltROP",
    "NtGdiEngStrokeAndFillPath",
    "NtGdiEngStrokePath",
    "NtGdiEngTextOut",
    "NtGdiEngTransparentBlt",
    "NtGdiEngUnlockSurface",
    "NtGdiEnumFonts",
    "NtGdiEnumObjects",
    "NtGdiEudcLoadUnloadLink",
    "NtGdiExtFloodFill",
    "NtGdiFONTOBJ_cGetAllGlyphHandles",
    "NtGdiFONTOBJ_cGetGlyphs",
    "NtGdiFONTOBJ_pQueryGlyphAttrs",
    "NtGdiFONTOBJ_pfdg",
    "NtGdiFONTOBJ_pifi",
    "NtGdiFONTOBJ_pvTrueTypeFontFile",
    "NtGdiFONTOBJ_pxoGetXform",
    "NtGdiFONTOBJ_vGetInfo",
    "NtGdiFlattenPath",
    "NtGdiFontIsLinked",
    "NtGdiForceUFIMapping",
    "NtGdiFrameRgn",
    "NtGdiFullscreenControl",
    "NtGdiGetBoundsRect",
    "NtGdiGetCOPPCompatibleOPMInformation",
    "NtGdiGetCertificate",
    "NtGdiGetCertificateSize",
    "NtGdiGetCharABCWidthsW",
    "NtGdiGetCharacterPlacementW",
    "NtGdiGetColorAdjustment",
    "NtGdiGetColorSpaceforBitmap",
    "NtGdiGetDeviceCaps",
    "NtGdiGetDeviceCapsAll",
    "NtGdiGetDeviceGammaRamp",
    "NtGdiGetDeviceWidth",
    "NtGdiGetDhpdev",
    "NtGdiGetETM",
    "NtGdiGetEmbUFI",
    "NtGdiGetEmbedFonts",
    "NtGdiGetEudcTimeStampEx",
    "NtGdiGetFontFileData",
    "NtGdiGetFontFileInfo",
    "NtGdiGetFontResourceInfoInternalW",
    "NtGdiGetFontUnicodeRanges",
    "NtGdiGetGlyphIndicesW",
    "NtGdiGetGlyphIndicesWInternal",
    "NtGdiGetGlyphOutline",
    "NtGdiGetKerningPairs",
    "NtGdiGetLinkedUFIs",
    "NtGdiGetMiterLimit",
    "NtGdiGetMonitorID",
    "NtGdiGetNumberOfPhysicalMonitors",
    "NtGdiGetOPMInformation",
    "NtGdiGetOPMRandomNumber",
    "NtGdiGetObjectBitmapHandle",
    "NtGdiGetPath",
    "NtGdiGetPerBandInfo",
    "NtGdiGetPhysicalMonitorDescription",
    "NtGdiGetPhysicalMonitors",
    "NtGdiGetRealizationInfo",
    "NtGdiGetServerMetaFileBits",
    "UMPDDrvCreateDeviceBitmap",
    "NtGdiGetStats",
    "NtGdiGetStringBitmapW",
    "NtGdiGetSuggestedOPMProtectedOutputArraySize",
    "NtGdiGetTextExtentExW",
    "NtGdiGetUFI",
    "NtGdiGetUFIPathname",
    "NtGdiGradientFill",
    "NtGdiHLSurfGetInformation",
    "NtGdiHLSurfSetInformation",
    "NtGdiHT_Get8BPPFormatPalette",
    "NtGdiHT_Get8BPPMaskPalette",
    "NtGdiIcmBrushInfo",
    "NtGdiUnmapMemFont",
    "EngWritePrinter",
    "NtGdiMakeFontDir",
    "NtGdiMakeInfoDC",
    "NtGdiMakeObjectUnXferable",
    "NtGdiMakeObjectXferable",
    "NtGdiMirrorWindowOrg",
    "NtGdiMonoBitmap",
    "NtGdiMoveTo",
    "NtGdiOffsetClipRgn",
    "NtGdiPATHOBJ_bEnum",
    "NtGdiPATHOBJ_bEnumClipLines",
    "NtGdiPATHOBJ_vEnumStart",
    "NtGdiPATHOBJ_vEnumStartClipLines",
    "NtGdiPATHOBJ_vGetBounds",
    "NtGdiPathToRegion",
    "NtGdiPlgBlt",
    "NtGdiPolyDraw",
    "NtGdiPolyTextOutW",
    "NtGdiPtInRegion",
    "NtGdiPtVisible",
    "NtGdiQueryFonts",
    "NtGdiRemoveFontResourceW",
    "NtGdiRemoveMergeFont",
    "NtGdiResetDC",
    "NtGdiResizePalette",
    "NtGdiRoundRect",
    "NtGdiSTROBJ_bEnum",
    "NtGdiSTROBJ_bEnumPositionsOnly",
    "NtGdiSTROBJ_bGetAdvanceWidths",
    "NtGdiSTROBJ_dwGetCodePage",
    "NtGdiSTROBJ_vEnumStart",
    "NtGdiScaleViewportExtEx",
    "NtGdiScaleWindowExtEx",
    "NtGdiSelectBrush",
    "NtGdiSelectClipPath",
    "NtGdiSelectPen",
    "NtGdiSetBitmapAttributes",
    "NtGdiSetBrushAttributes",
    "NtGdiSetColorAdjustment",
    "NtGdiSetColorSpace",
    "NtGdiSetDeviceGammaRamp",
    "NtGdiSetFontXform",
    "NtGdiSetIcmMode",
    "NtGdiSetLinkedUFIs",
    "NtGdiSetMagicColors",
    "NtGdiSetOPMSigningKeyAndSequenceNumbers",
    "NtGdiSetPUMPDOBJ",
    "NtGdiSetPixelFormat",
    "NtGdiSetRectRgn",
    "NtGdiSetSizeDevice",
    "NtGdiSetSystemPaletteUse",
    "NtGdiSetTextJustification",
    "NtGdiSfmGetNotificationTokens",
    "NtGdiStartDoc",
    "NtGdiStartPage",
    "NtGdiStrokeAndFillPath",
    "NtGdiStrokePath",
    "NtGdiSwapBuffers",
    "NtGdiTransparentBlt",
    "NtGdiUMPDEngFreeUserMem",
    "UMPDDrvCreateDeviceBitmap",
    "NtGdiUnmapMemFont",
    "NtGdiUpdateColors",
    "NtGdiUpdateTransform",
    "NtGdiWidenPath",
    "NtGdiXFORMOBJ_bApplyXform",
    "NtGdiXFORMOBJ_iGetXform",
    "NtGdiXLATEOBJ_cGetPalette",
    "NtGdiXLATEOBJ_hGetColorTransform",
    "NtGdiXLATEOBJ_iXlate",
    "NtUserAddClipboardFormatListener",
    "NtUserAssociateInputContext",
    "NtUserBlockInput",
    "NtUserBuildHimcList",
    "NtUserBuildPropList",
    "NtUserCalculatePopupWindowPosition",
    "NtUserCallHwndOpt",
    "NtUserChangeDisplaySettings",
    "NtUserChangeWindowMessageFilterEx",
    "NtUserCheckAccessForIntegrityLevel",
    "NtUserCheckDesktopByThreadId",
    "NtUserCheckWindowThreadDesktop",
    "NtUserChildWindowFromPointEx",
    "NtUserClipCursor",
    "NtUserCreateDesktopEx",
    "NtUserCreateInputContext",
    "NtUserCreateWindowStation",
    "NtUserCtxDisplayIOCtl",
    "NtUserDestroyInputContext",
    "NtUserDisableThreadIme",
    "NtUserDisplayConfigGetDeviceInfo",
    "NtUserDisplayConfigSetDeviceInfo",
    "NtUserDoSoundConnect",
    "NtUserDoSoundDisconnect",
    "NtUserDragDetect",
    "NtUserDragObject",
    "NtUserDrawAnimatedRects",
    "NtUserDrawCaption",
    "NtUserDrawCaptionTemp",
    "NtUserDrawMenuBarTemp",
    "NtUserDwmStartRedirection",
    "NtUserDwmStopRedirection",
    "NtUserEndMenu",
    "NtUserEndTouchOperation",
    "NtUserEvent",
    "NtUserFlashWindowEx",
    "NtUserFrostCrashedWindow",
    "NtUserGetAppImeLevel",
    "NtUserGetCaretPos",
    "NtUserGetClipCursor",
    "NtUserGetClipboardViewer",
    "NtUserGetComboBoxInfo",
    "NtUserGetCursorInfo",
    "NtUserGetDisplayConfigBufferSizes",
    "NtUserGetGestureConfig",
    "NtUserGetGestureExtArgs",
    "NtUserGetGestureInfo",
    "NtUserGetGuiResources",
    "NtUserGetImeHotKey",
    "NtUserGetImeInfoEx",
    "NtUserGetInputLocaleInfo",
    "NtUserGetInternalWindowPos",
    "NtUserGetKeyNameText",
    "NtUserGetKeyboardLayoutName",
    "NtUserGetLayeredWindowAttributes",
    "NtUserGetListBoxInfo",
    "NtUserGetMenuIndex",
    "NtUserGetMenuItemRect",
    "NtUserGetMouseMovePointsEx",
    "NtUserGetPriorityClipboardFormat",
    "NtUserGetRawInputBuffer",
    "NtUserGetRawInputData",
    "NtUserGetRawInputDeviceInfo",
    "NtUserGetRawInputDeviceList",
    "NtUserGetRegisteredRawInputDevices",
    "NtUserGetTopLevelWindow",
    "NtUserGetTouchInputInfo",
    "NtUserGetUpdatedClipboardFormats",
    "NtUserGetWOWClass",
    "NtUserGetWindowCompositionAttribute",
    "NtUserGetWindowCompositionInfo",
    "NtUserGetWindowDisplayAffinity",
    "NtUserGetWindowMinimizeRect",
    "NtUserGetWindowRgnEx",
    "NtUserGhostWindowFromHungWindow",
    "NtUserHardErrorControl",
    "NtUserHiliteMenuItem",
    "NtUserHungWindowFromGhostWindow",
    "NtUserHwndQueryRedirectionInfo",
    "NtUserHwndSetRedirectionInfo",
    "NtUserImpersonateDdeClientWindow",
    "NtUserInitTask",
    "NtUserInitialize",
    "NtUserInitializeClientPfnArrays",
    "NtUserInjectGesture",
    "NtUserInternalGetWindowIcon",
    "NtUserIsTopLevelWindow",
    "NtUserIsTouchWindow",
    "NtUserLoadKeyboardLayoutEx",
    "NtUserLockWindowStation",
    "NtUserLockWorkStation",
    "NtUserLogicalToPhysicalPoint",
    "NtUserMNDragLeave",
    "NtUserMNDragOver",
    "NtUserMagControl",
    "NtUserMagGetContextInformation",
    "NtUserMagSetContextInformation",
    "NtUserManageGestureHandlerWindow",
    "NtUserMenuItemFromPoint",
    "NtUserMinMaximize",
    "NtUserModifyWindowTouchCapability",
    "NtUserNotifyIMEStatus",
    "NtUserOpenInputDesktop",
    "NtUserOpenThreadDesktop",
    "NtUserPaintMonitor",
    "NtUserPhysicalToLogicalPoint",
    "NtUserPrintWindow",
    "NtUserQueryDisplayConfig",
    "NtUserQueryInformationThread",
    "NtUserQueryInputContext",
    "NtUserQuerySendMessage",
    "NtUserRealChildWindowFromPoint",
    "NtUserRealWaitMessageEx",
    "NtUserRegisterErrorReportingDialog",
    "NtUserRegisterHotKey",
    "NtUserRegisterRawInputDevices",
    "NtUserRegisterServicesProcess",
    "NtUserRegisterSessionPort",
    "NtUserRegisterTasklist",
    "NtUserRegisterUserApiHook",
    "NtUserRemoteConnect",
    "NtUserRemoteRedrawRectangle",
    "NtUserRemoteRedrawScreen",
    "NtUserRemoteStopScreenUpdates",
    "NtUserRemoveClipboardFormatListener",
    "NtUserResolveDesktopForWOW",
    "NtUserSendTouchInput",
    "NtUserSetAppImeLevel",
    "NtUserSetChildWindowNoActivate",
    "NtUserSetClassWord",
    "NtUserSetCursorContents",
    "NtUserSetDisplayConfig",
    "NtUserSetGestureConfig",
    "NtUserSetImeHotKey",
    "NtUserSetImeInfoEx",
    "NtUserSetImeOwnerWindow",
    "NtUserSetInternalWindowPos",
    "NtUserSetLayeredWindowAttributes",
    "NtUserSetMenu",
    "NtUserSetMenuContextHelpId",
    "NtUserSetMenuFlagRtoL",
    "NtUserSetMirrorRendering",
    "NtUserSetObjectInformation",
    "NtUserSetProcessDPIAware",
    "NtUserSetShellWindowEx",
    "NtUserSetSysColors",
    "NtUserSetSystemCursor",
    "NtUserSetSystemTimer",
    "NtUserSetThreadLayoutHandles",
    "NtUserSetWindowCompositionAttribute",
    "NtUserSetWindowDisplayAffinity",
    "NtUserSetWindowRgnEx",
    "NtUserSetWindowStationUser",
    "NtUserSfmDestroyLogicalSurfaceBinding",
    "NtUserSfmDxBindSwapChain",
    "NtUserSfmDxGetSwapChainStats",
    "NtUserSfmDxOpenSwapChain",
    "NtUserSfmDxQuerySwapChainBindingStatus",
    "NtUserSfmDxReleaseSwapChain",
    "NtUserSfmDxReportPendingBindingsToDwm",
    "NtUserSfmDxSetSwapChainBindingStatus",
    "NtUserSfmDxSetSwapChainStats",
    "NtUserSfmGetLogicalSurfaceBinding",
    "NtUserShowSystemCursor",
    "NtUserSoundSentry",
    "NtUserSwitchDesktop",
    "NtUserTestForInteractiveUser",
    "NtUserTrackPopupMenuEx",
    "NtUserUnloadKeyboardLayout",
    "NtUserUnlockWindowStation",
    "NtUserUnregisterHotKey",
    "NtUserUnregisterSessionPort",
    "NtUserUnregisterUserApiHook",
    "NtUserUpdateInputContext",
    "NtUserUpdateInstance",
    "NtUserUpdateLayeredWindow",
    "NtUserUpdatePerUserSystemParameters",
    "NtUserUpdateWindowTransform",
    "NtUserUserHandleGrantAccess",
    "NtUserValidateHandleSecure",
    "NtUserWaitForInputIdle",
    "NtUserWaitForMsgAndEvent",
    "NtUserWindowFromPhysicalPoint",
    "NtUserYieldTask",
    "NtUserSetClassLongPtr",
    "NtUserSetWindowLongPtr"
};

//////////////////////////////////////////////////////////////////////////
// Windows 7 SP1 _W32pServiceTable
//////////////////////////////////////////////////////////////////////////
static const char* W32pServiceTable_Win7Sp1_x64[] = {
    "NtUserGetThreadState",
    "NtUserPeekMessage",
    "NtUserCallOneParam",
    "NtUserGetKeyState",
    "NtUserInvalidateRect",
    "NtUserCallNoParam",
    "NtUserGetMessage",
    "NtUserMessageCall",
    "NtGdiBitBlt",
    "NtGdiGetCharSet",
    "NtUserGetDC",
    "NtGdiSelectBitmap",
    "NtUserWaitMessage",
    "NtUserTranslateMessage",
    "NtUserGetProp",
    "NtUserPostMessage",
    "NtUserQueryWindow",
    "NtUserTranslateAccelerator",
    "NtGdiFlush",
    "NtUserRedrawWindow",
    "NtUserWindowFromPoint",
    "NtUserCallMsgFilter",
    "NtUserValidateTimerCallback",
    "NtUserBeginPaint",
    "NtUserSetTimer",
    "NtUserEndPaint",
    "NtUserSetCursor",
    "NtUserKillTimer",
    "NtUserBuildHwndList",
    "NtUserSelectPalette",
    "NtUserCallNextHookEx",
    "NtUserHideCaret",
    "NtGdiIntersectClipRect",
    "NtUserCallHwndLock",
    "NtUserGetProcessWindowStation",
    "NtGdiDeleteObjectApp",
    "NtUserSetWindowPos",
    "NtUserShowCaret",
    "NtUserEndDeferWindowPosEx",
    "NtUserCallHwndParamLock",
    "NtUserVkKeyScanEx",
    "NtGdiSetDIBitsToDeviceInternal",
    "NtUserCallTwoParam",
    "NtGdiGetRandomRgn",
    "NtUserCopyAcceleratorTable",
    "NtUserNotifyWinEvent",
    "NtGdiExtSelectClipRgn",
    "NtUserIsClipboardFormatAvailable",
    "NtUserSetScrollInfo",
    "NtGdiStretchBlt",
    "NtUserCreateCaret",
    "NtGdiRectVisible",
    "NtGdiCombineRgn",
    "NtGdiGetDCObject",
    "NtUserDispatchMessage",
    "NtUserRegisterWindowMessage",
    "NtGdiExtTextOutW",
    "NtGdiSelectFont",
    "NtGdiRestoreDC",
    "NtGdiSaveDC",
    "NtUserGetForegroundWindow",
    "NtUserShowScrollBar",
    "NtUserFindExistingCursorIcon",
    "NtGdiGetDCDword",
    "NtGdiGetRegionData",
    "NtGdiLineTo",
    "NtUserSystemParametersInfo",
    "NtGdiGetAppClipBox",
    "NtUserGetAsyncKeyState",
    "NtUserGetCPD",
    "NtUserRemoveProp",
    "NtGdiDoPalette",
    "NtGdiPolyPolyDraw",
    "NtUserSetCapture",
    "NtUserEnumDisplayMonitors",
    "NtGdiCreateCompatibleBitmap",
    "NtUserSetProp",
    "NtGdiGetTextCharsetInfo",
    "NtUserSBGetParms",
    "NtUserGetIconInfo",
    "NtUserExcludeUpdateRgn",
    "NtUserSetFocus",
    "NtGdiExtGetObjectW",
    "NtUserDeferWindowPos",
    "NtUserGetUpdateRect",
    "NtGdiCreateCompatibleDC",
    "NtUserGetClipboardSequenceNumber",
    "NtGdiCreatePen",
    "NtUserShowWindow",
    "NtUserGetKeyboardLayoutList",
    "NtGdiPatBlt",
    "NtUserMapVirtualKeyEx",
    "NtUserSetWindowLong",
    "NtGdiHfontCreate",
    "NtUserMoveWindow",
    "NtUserPostThreadMessage",
    "NtUserDrawIconEx",
    "NtUserGetSystemMenu",
    "NtGdiDrawStream",
    "NtUserInternalGetWindowText",
    "NtUserGetWindowDC",
    "NtGdiD3dDrawPrimitives2",
    "NtGdiInvertRgn",
    "NtGdiGetRgnBox",
    "NtGdiGetAndSetDCDword",
    "NtGdiMaskBlt",
    "NtGdiGetWidthTable",
    "NtUserScrollDC",
    "NtUserGetObjectInformation",
    "NtGdiCreateBitmap",
    "NtUserFindWindowEx",
    "NtGdiPolyPatBlt",
    "NtUserUnhookWindowsHookEx",
    "NtGdiGetNearestColor",
    "NtGdiTransformPoints",
    "NtGdiGetDCPoint",
    "NtGdiCreateDIBBrush",
    "NtGdiGetTextMetricsW",
    "NtUserCreateWindowEx",
    "NtUserSetParent",
    "NtUserGetKeyboardState",
    "NtUserToUnicodeEx",
    "NtUserGetControlBrush",
    "NtUserGetClassName",
    "NtGdiAlphaBlend",
    "NtGdiDdBlt",
    "NtGdiOffsetRgn",
    "NtUserDefSetText",
    "NtGdiGetTextFaceW",
    "NtGdiStretchDIBitsInternal",
    "NtUserSendInput",
    "NtUserGetThreadDesktop",
    "NtGdiCreateRectRgn",
    "NtGdiGetDIBitsInternal",
    "NtUserGetUpdateRgn",
    "NtGdiDeleteClientObj",
    "NtUserGetIconSize",
    "NtUserFillWindow",
    "NtGdiExtCreateRegion",
    "NtGdiComputeXformCoefficients",
    "NtUserSetWindowsHookEx",
    "NtUserNotifyProcessCreate",
    "NtGdiUnrealizeObject",
    "NtUserGetTitleBarInfo",
    "NtGdiRectangle",
    "NtUserSetThreadDesktop",
    "NtUserGetDCEx",
    "NtUserGetScrollBarInfo",
    "NtGdiGetTextExtent",
    "NtUserSetWindowFNID",
    "NtGdiSetLayout",
    "NtUserCalcMenuBar",
    "NtUserThunkedMenuItemInfo",
    "NtGdiExcludeClipRect",
    "NtGdiCreateDIBSection",
    "NtGdiGetDCforBitmap",
    "NtUserDestroyCursor",
    "NtUserDestroyWindow",
    "NtUserCallHwndParam",
    "NtGdiCreateDIBitmapInternal",
    "NtUserOpenWindowStation",
    "NtGdiDdDeleteSurfaceObject",
    "NtGdiDdCanCreateSurface",
    "NtGdiDdCreateSurface",
    "NtUserSetCursorIconData",
    "NtGdiDdDestroySurface",
    "NtUserCloseDesktop",
    "NtUserOpenDesktop",
    "NtUserSetProcessWindowStation",
    "NtUserGetAtomName",
    "NtGdiDdResetVisrgn",
    "NtGdiExtCreatePen",
    "NtGdiCreatePaletteInternal",
    "NtGdiSetBrushOrg",
    "NtUserBuildNameList",
    "NtGdiSetPixel",
    "NtUserRegisterClassExWOW",
    "NtGdiCreatePatternBrushInternal",
    "NtUserGetAncestor",
    "NtGdiGetOutlineTextMetricsInternalW",
    "NtGdiSetBitmapBits",
    "NtUserCloseWindowStation",
    "NtUserGetDoubleClickTime",
    "NtUserEnableScrollBar",
    "NtGdiCreateSolidBrush",
    "NtUserGetClassInfoEx",
    "NtGdiCreateClientObj",
    "NtUserUnregisterClass",
    "NtUserDeleteMenu",
    "NtGdiRectInRegion",
    "NtUserScrollWindowEx",
    "NtGdiGetPixel",
    "NtUserSetClassLong",
    "NtUserGetMenuBarInfo",
    "NtGdiDdCreateSurfaceEx",
    "NtGdiDdCreateSurfaceObject",
    "NtGdiGetNearestPaletteIndex",
    "NtGdiDdLockD3D",
    "NtGdiDdUnlockD3D",
    "NtGdiGetCharWidthW",
    "NtUserInvalidateRgn",
    "NtUserGetClipboardOwner",
    "NtUserSetWindowRgn",
    "NtUserBitBltSysBmp",
    "NtGdiGetCharWidthInfo",
    "NtUserValidateRect",
    "NtUserCloseClipboard",
    "NtUserOpenClipboard",
    "NtGdiGetStockObject",
    "NtUserSetClipboardData",
    "NtUserEnableMenuItem",
    "NtUserAlterWindowStyle",
    "NtGdiFillRgn",
    "NtUserGetWindowPlacement",
    "NtGdiModifyWorldTransform",
    "NtGdiGetFontData",
    "NtUserGetOpenClipboardWindow",
    "NtUserSetThreadState",
    "NtGdiOpenDCW",
    "NtUserTrackMouseEvent",
    "NtGdiGetTransform",
    "NtUserDestroyMenu",
    "NtGdiGetBitmapBits",
    "NtUserConsoleControl",
    "NtUserSetActiveWindow",
    "NtUserSetInformationThread",
    "NtUserSetWindowPlacement",
    "NtUserGetControlColor",
    "NtGdiSetMetaRgn",
    "NtGdiSetMiterLimit",
    "NtGdiSetVirtualResolution",
    "NtGdiGetRasterizerCaps",
    "NtUserSetWindowWord",
    "NtUserGetClipboardFormatName",
    "NtUserRealInternalGetMessage",
    "NtUserCreateLocalMemHandle",
    "NtUserAttachThreadInput",
    "NtGdiCreateHalftonePalette",
    "NtUserPaintMenuBar",
    "NtUserSetKeyboardState",
    "NtGdiCombineTransform",
    "NtUserCreateAcceleratorTable",
    "NtUserGetCursorFrameInfo",
    "NtUserGetAltTabInfo",
    "NtUserGetCaretBlinkTime",
    "NtGdiQueryFontAssocInfo",
    "NtUserProcessConnect",
    "NtUserEnumDisplayDevices",
    "NtUserEmptyClipboard",
    "NtUserGetClipboardData",
    "NtUserRemoveMenu",
    "NtGdiSetBoundsRect",
    "NtGdiGetBitmapDimension",
    "NtUserConvertMemHandle",
    "NtUserDestroyAcceleratorTable",
    "NtUserGetGUIThreadInfo",
    "NtGdiCloseFigure",
    "NtUserSetWindowsHookAW",
    "NtUserSetMenuDefaultItem",
    "NtUserCheckMenuItem",
    "NtUserSetWinEventHook",
    "NtUserUnhookWinEvent",
    "NtUserLockWindowUpdate",
    "NtUserSetSystemMenu",
    "NtUserThunkedMenuInfo",
    "NtGdiBeginPath",
    "NtGdiEndPath",
    "NtGdiFillPath",
    "NtUserCallHwnd",
    "NtUserDdeInitialize",
    "NtUserModifyUserStartupInfoFlags",
    "NtUserCountClipboardFormats",
    "NtGdiAddFontMemResourceEx",
    "NtGdiEqualRgn",
    "NtGdiGetSystemPaletteUse",
    "NtGdiRemoveFontMemResourceEx",
    "NtUserEnumDisplaySettings",
    "NtUserPaintDesktop",
    "NtGdiExtEscape",
    "NtGdiSetBitmapDimension",
    "NtGdiSetFontEnumeration",
    "NtUserChangeClipboardChain",
    "NtUserSetClipboardViewer",
    "NtUserShowWindowAsync",
    "NtGdiCreateColorSpace",
    "NtGdiDeleteColorSpace",
    "NtUserActivateKeyboardLayout",
    "NtGdiAbortDoc",
    "NtGdiAbortPath",
    "NtGdiAddEmbFontToDC",
    "NtGdiAddFontResourceW",
    "NtGdiAddRemoteFontToDC",
    "NtGdiAddRemoteMMInstanceToDC",
    "NtGdiAngleArc",
    "NtGdiAnyLinkedFonts",
    "NtGdiArcInternal",
    "NtGdiBRUSHOBJ_DeleteRbrush",
    "NtGdiBRUSHOBJ_hGetColorTransform",
    "NtGdiBRUSHOBJ_pvAllocRbrush",
    "NtGdiBRUSHOBJ_pvGetRbrush",
    "NtGdiBRUSHOBJ_ulGetBrushColor",
    "NtGdiBeginGdiRendering",
    "NtGdiCLIPOBJ_bEnum",
    "NtGdiCLIPOBJ_cEnumStart",
    "NtGdiCLIPOBJ_ppoGetPath",
    "NtGdiCancelDC",
    "NtGdiChangeGhostFont",
    "NtGdiCheckBitmapBits",
    "NtGdiClearBitmapAttributes",
    "NtGdiClearBrushAttributes",
    "NtGdiColorCorrectPalette",
    "NtGdiConfigureOPMProtectedOutput",
    "NtGdiConvertMetafileRect",
    "NtGdiCreateBitmapFromDxSurface",
    "NtGdiCreateColorTransform",
    "NtGdiCreateEllipticRgn",
    "NtGdiCreateHatchBrushInternal",
    "NtGdiCreateMetafileDC",
    "NtGdiCreateOPMProtectedOutputs",
    "NtGdiCreateRoundRectRgn",
    "NtGdiCreateServerMetaFile",
    "NtGdiD3dContextCreate",
    "NtGdiD3dContextDestroy",
    "NtGdiD3dContextDestroyAll",
    "NtGdiD3dValidateTextureStageState",
    "NtGdiDDCCIGetCapabilitiesString",
    "NtGdiDDCCIGetCapabilitiesStringLength",
    "NtGdiDDCCIGetTimingReport",
    "NtGdiDDCCIGetVCPFeature",
    "NtGdiDDCCISaveCurrentSettings",
    "NtGdiDDCCISetVCPFeature",
    "NtGdiDdAddAttachedSurface",
    "NtGdiDdAlphaBlt",
    "NtGdiDdAttachSurface",
    "NtGdiDdBeginMoCompFrame",
    "NtGdiDdCanCreateD3DBuffer",
    "NtGdiDdColorControl",
    "NtGdiDdCreateD3DBuffer",
    "NtGdiDdCreateDirectDrawObject",
    "NtGdiDdCreateFullscreenSprite",
    "NtGdiDdCreateMoComp",
    "NtGdiDdDDIAcquireKeyedMutex",
    "NtGdiDdDDICheckExclusiveOwnership",
    "NtGdiDdDDICheckMonitorPowerState",
    "NtGdiDdDDICheckOcclusion",
    "NtGdiDdDDICheckSharedResourceAccess",
    "NtGdiDdDDICheckVidPnExclusiveOwnership",
    "NtGdiDdDDICloseAdapter",
    "NtGdiDdDDIConfigureSharedResource",
    "NtGdiDdDDICreateAllocation",
    "NtGdiDdDDICreateContext",
    "NtGdiDdDDICreateDCFromMemory",
    "NtGdiDdDDICreateDevice",
    "NtGdiDdDDICreateKeyedMutex",
    "NtGdiDdDDICreateOverlay",
    "NtGdiDdDDICreateSynchronizationObject",
    "NtGdiDdDDIDestroyAllocation",
    "NtGdiDdDDIDestroyContext",
    "NtGdiDdDDIDestroyDCFromMemory",
    "NtGdiDdDDIDestroyDevice",
    "NtGdiDdDDIDestroyKeyedMutex",
    "NtGdiDdDDIDestroyOverlay",
    "NtGdiDdDDIDestroySynchronizationObject",
    "NtGdiDdDDIEscape",
    "NtGdiDdDDIFlipOverlay",
    "NtGdiDdDDIGetContextSchedulingPriority",
    "NtGdiDdDDIGetDeviceState",
    "NtGdiDdDDIGetDisplayModeList",
    "NtGdiDdDDIGetMultisampleMethodList",
    "NtGdiDdDDIGetOverlayState",
    "NtGdiDdDDIGetPresentHistory",
    "NtGdiDdDDIGetPresentQueueEvent",
    "NtGdiDdDDIGetProcessSchedulingPriorityClass",
    "NtGdiDdDDIGetRuntimeData",
    "NtGdiDdDDIGetScanLine",
    "NtGdiDdDDIGetSharedPrimaryHandle",
    "NtGdiDdDDIInvalidateActiveVidPn",
    "NtGdiDdDDILock",
    "NtGdiDdDDIOpenAdapterFromDeviceName",
    "NtGdiDdDDIOpenAdapterFromHdc",
    "NtGdiDdDDIOpenKeyedMutex",
    "NtGdiDdDDIOpenResource",
    "NtGdiDdDDIOpenSynchronizationObject",
    "NtGdiDdDDIPollDisplayChildren",
    "NtGdiDdDDIPresent",
    "NtGdiDdDDIQueryAdapterInfo",
    "NtGdiDdDDIQueryAllocationResidency",
    "NtGdiDdDDIQueryResourceInfo",
    "NtGdiDdDDIQueryStatistics",
    "NtGdiDdDDIReleaseKeyedMutex",
    "NtGdiDdDDIReleaseProcessVidPnSourceOwners",
    "NtGdiDdDDIRender",
    "NtGdiDdDDISetAllocationPriority",
    "NtGdiDdDDISetContextSchedulingPriority",
    "NtGdiDdDDISetDisplayMode",
    "NtGdiDdDDISetDisplayPrivateDriverFormat",
    "NtGdiDdDDISetGammaRamp",
    "NtGdiDdDDISetProcessSchedulingPriorityClass",
    "NtGdiDdDDISetQueuedLimit",
    "NtGdiDdDDISetVidPnSourceOwner",
    "NtGdiDdDDISharedPrimaryLockNotification",
    "NtGdiDdDDISharedPrimaryUnLockNotification",
    "NtGdiDdDDISignalSynchronizationObject",
    "NtGdiDdDDIUnlock",
    "NtGdiDdDDIUpdateOverlay",
    "NtGdiDdDDIWaitForIdle",
    "NtGdiDdDDIWaitForSynchronizationObject",
    "NtGdiDdDDIWaitForVerticalBlankEvent",
    "NtGdiDdDeleteDirectDrawObject",
    "NtGdiDdDestroyD3DBuffer",
    "NtGdiDdDestroyFullscreenSprite",
    "NtGdiDdDestroyMoComp",
    "NtGdiDdEndMoCompFrame",
    "NtGdiDdFlip",
    "NtGdiDdFlipToGDISurface",
    "NtGdiDdGetAvailDriverMemory",
    "NtGdiDdGetBltStatus",
    "NtGdiDdGetDC",
    "NtGdiDdGetDriverInfo",
    "NtGdiDdGetDriverState",
    "NtGdiDdGetDxHandle",
    "NtGdiDdGetFlipStatus",
    "NtGdiDdGetInternalMoCompInfo",
    "NtGdiDdGetMoCompBuffInfo",
    "NtGdiDdGetMoCompFormats",
    "NtGdiDdGetMoCompGuids",
    "NtGdiDdGetScanLine",
    "NtGdiDdLock",
    "NtGdiDdNotifyFullscreenSpriteUpdate",
    "NtGdiDdQueryDirectDrawObject",
    "NtGdiDdQueryMoCompStatus",
    "NtGdiDdQueryVisRgnUniqueness",
    "NtGdiDdReenableDirectDrawObject",
    "NtGdiDdReleaseDC",
    "NtGdiDdRenderMoComp",
    "NtGdiDdSetColorKey",
    "NtGdiDdSetExclusiveMode",
    "NtGdiDdSetGammaRamp",
    "NtGdiDdSetOverlayPosition",
    "NtGdiDdUnattachSurface",
    "NtGdiDdUnlock",
    "NtGdiDdUpdateOverlay",
    "NtGdiDdWaitForVerticalBlank",
    "NtGdiDeleteColorTransform",
    "NtGdiDescribePixelFormat",
    "NtGdiDestroyOPMProtectedOutput",
    "NtGdiDestroyPhysicalMonitor",
    "NtGdiDoBanding",
    "NtGdiDrawEscape",
    "NtGdiDvpAcquireNotification",
    "NtGdiDvpCanCreateVideoPort",
    "NtGdiDvpColorControl",
    "NtGdiDvpCreateVideoPort",
    "NtGdiDvpDestroyVideoPort",
    "NtGdiDvpFlipVideoPort",
    "NtGdiDvpGetVideoPortBandwidth",
    "NtGdiDvpGetVideoPortConnectInfo",
    "NtGdiDvpGetVideoPortField",
    "NtGdiDvpGetVideoPortFlipStatus",
    "NtGdiDvpGetVideoPortInputFormats",
    "NtGdiDvpGetVideoPortLine",
    "NtGdiDvpGetVideoPortOutputFormats",
    "NtGdiDvpGetVideoSignalStatus",
    "NtGdiDvpReleaseNotification",
    "NtGdiDvpUpdateVideoPort",
    "NtGdiDvpWaitForVideoPortSync",
    "NtGdiDxgGenericThunk",
    "NtGdiEllipse",
    "NtGdiEnableEudc",
    "NtGdiEndDoc",
    "NtGdiEndGdiRendering",
    "NtGdiEndPage",
    "NtGdiEngAlphaBlend",
    "NtGdiEngAssociateSurface",
    "NtGdiEngBitBlt",
    "NtGdiEngCheckAbort",
    "NtGdiEngComputeGlyphSet",
    "NtGdiEngCopyBits",
    "NtGdiEngCreateBitmap",
    "NtGdiEngCreateClip",
    "NtGdiEngCreateDeviceBitmap",
    "NtGdiEngCreateDeviceSurface",
    "NtGdiEngCreatePalette",
    "NtGdiEngDeleteClip",
    "NtGdiEngDeletePalette",
    "NtGdiEngDeletePath",
    "NtGdiEngDeleteSurface",
    "NtGdiEngEraseSurface",
    "NtGdiEngFillPath",
    "NtGdiEngGradientFill",
    "NtGdiEngLineTo",
    "NtGdiEngLockSurface",
    "NtGdiEngMarkBandingSurface",
    "NtGdiEngPaint",
    "NtGdiEngPlgBlt",
    "NtGdiEngStretchBlt",
    "NtGdiEngStretchBltROP",
    "NtGdiEngStrokeAndFillPath",
    "NtGdiEngStrokePath",
    "NtGdiEngTextOut",
    "NtGdiEngTransparentBlt",
    "NtGdiEngUnlockSurface",
    "NtGdiEnumFonts",
    "NtGdiEnumObjects",
    "NtGdiEudcLoadUnloadLink",
    "NtGdiExtFloodFill",
    "NtGdiFONTOBJ_cGetAllGlyphHandles",
    "NtGdiFONTOBJ_cGetGlyphs",
    "NtGdiFONTOBJ_pQueryGlyphAttrs",
    "NtGdiFONTOBJ_pfdg",
    "NtGdiFONTOBJ_pifi",
    "NtGdiFONTOBJ_pvTrueTypeFontFile",
    "NtGdiFONTOBJ_pxoGetXform",
    "NtGdiFONTOBJ_vGetInfo",
    "NtGdiFlattenPath",
    "NtGdiFontIsLinked",
    "NtGdiForceUFIMapping",
    "NtGdiFrameRgn",
    "NtGdiFullscreenControl",
    "NtGdiGetBoundsRect",
    "NtGdiGetCOPPCompatibleOPMInformation",
    "NtGdiGetCertificate",
    "NtGdiGetCertificateSize",
    "NtGdiGetCharABCWidthsW",
    "NtGdiGetCharacterPlacementW",
    "NtGdiGetColorAdjustment",
    "NtGdiGetColorSpaceforBitmap",
    "NtGdiGetDeviceCaps",
    "NtGdiGetDeviceCapsAll",
    "NtGdiGetDeviceGammaRamp",
    "NtGdiGetDeviceWidth",
    "NtGdiGetDhpdev",
    "NtGdiGetETM",
    "NtGdiGetEmbUFI",
    "NtGdiGetEmbedFonts",
    "NtGdiGetEudcTimeStampEx",
    "NtGdiGetFontFileData",
    "NtGdiGetFontFileInfo",
    "NtGdiGetFontResourceInfoInternalW",
    "NtGdiGetFontUnicodeRanges",
    "NtGdiGetGlyphIndicesW",
    "NtGdiGetGlyphIndicesWInternal",
    "NtGdiGetGlyphOutline",
    "NtGdiGetKerningPairs",
    "NtGdiGetLinkedUFIs",
    "NtGdiGetMiterLimit",
    "NtGdiGetMonitorID",
    "NtGdiGetNumberOfPhysicalMonitors",
    "NtGdiGetOPMInformation",
    "NtGdiGetOPMRandomNumber",
    "NtGdiGetObjectBitmapHandle",
    "NtGdiGetPath",
    "NtGdiGetPerBandInfo",
    "NtGdiGetPhysicalMonitorDescription",
    "NtGdiGetPhysicalMonitors",
    "NtGdiGetRealizationInfo",
    "NtGdiGetServerMetaFileBits",
    "UMPDDrvCreateDeviceBitmap",
    "NtGdiGetStats",
    "NtGdiGetStringBitmapW",
    "NtGdiGetSuggestedOPMProtectedOutputArraySize",
    "NtGdiGetTextExtentExW",
    "NtGdiGetUFI",
    "NtGdiGetUFIPathname",
    "NtGdiGradientFill",
    "NtGdiHLSurfGetInformation",
    "NtGdiHLSurfSetInformation",
    "NtGdiHT_Get8BPPFormatPalette",
    "NtGdiHT_Get8BPPMaskPalette",
    "NtGdiIcmBrushInfo",
    "NtGdiUnmapMemFont",
    "EngWritePrinter",
    "NtGdiMakeFontDir",
    "NtGdiMakeInfoDC",
    "NtGdiMakeObjectUnXferable",
    "NtGdiMakeObjectXferable",
    "NtGdiMirrorWindowOrg",
    "NtGdiMonoBitmap",
    "NtGdiMoveTo",
    "NtGdiOffsetClipRgn",
    "NtGdiPATHOBJ_bEnum",
    "NtGdiPATHOBJ_bEnumClipLines",
    "NtGdiPATHOBJ_vEnumStart",
    "NtGdiPATHOBJ_vEnumStartClipLines",
    "NtGdiPATHOBJ_vGetBounds",
    "NtGdiPathToRegion",
    "NtGdiPlgBlt",
    "NtGdiPolyDraw",
    "NtGdiPolyTextOutW",
    "NtGdiPtInRegion",
    "NtGdiPtVisible",
    "NtGdiQueryFonts",
    "NtGdiRemoveFontResourceW",
    "NtGdiRemoveMergeFont",
    "NtGdiResetDC",
    "NtGdiResizePalette",
    "NtGdiRoundRect",
    "NtGdiSTROBJ_bEnum",
    "NtGdiSTROBJ_bEnumPositionsOnly",
    "NtGdiSTROBJ_bGetAdvanceWidths",
    "NtGdiSTROBJ_dwGetCodePage",
    "NtGdiSTROBJ_vEnumStart",
    "NtGdiScaleViewportExtEx",
    "NtGdiScaleWindowExtEx",
    "NtGdiSelectBrush",
    "NtGdiSelectClipPath",
    "NtGdiSelectPen",
    "NtGdiSetBitmapAttributes",
    "NtGdiSetBrushAttributes",
    "NtGdiSetColorAdjustment",
    "NtGdiSetColorSpace",
    "NtGdiSetDeviceGammaRamp",
    "NtGdiSetFontXform",
    "NtGdiSetIcmMode",
    "NtGdiSetLinkedUFIs",
    "NtGdiSetMagicColors",
    "NtGdiSetOPMSigningKeyAndSequenceNumbers",
    "NtGdiSetPUMPDOBJ",
    "NtGdiSetPixelFormat",
    "NtGdiSetRectRgn",
    "NtGdiSetSizeDevice",
    "NtGdiSetSystemPaletteUse",
    "NtGdiSetTextJustification",
    "NtGdiSfmGetNotificationTokens",
    "NtGdiStartDoc",
    "NtGdiStartPage",
    "NtGdiStrokeAndFillPath",
    "NtGdiStrokePath",
    "NtGdiSwapBuffers",
    "NtGdiTransparentBlt",
    "NtGdiUMPDEngFreeUserMem",
    "UMPDDrvCreateDeviceBitmap",
    "NtGdiUnmapMemFont",
    "NtGdiUpdateColors",
    "NtGdiUpdateTransform",
    "NtGdiWidenPath",
    "NtGdiXFORMOBJ_bApplyXform",
    "NtGdiXFORMOBJ_iGetXform",
    "NtGdiXLATEOBJ_cGetPalette",
    "NtGdiXLATEOBJ_hGetColorTransform",
    "NtGdiXLATEOBJ_iXlate",
    "NtUserAddClipboardFormatListener",
    "NtUserAssociateInputContext",
    "NtUserBlockInput",
    "NtUserBuildHimcList",
    "NtUserBuildPropList",
    "NtUserCalculatePopupWindowPosition",
    "NtUserCallHwndOpt",
    "NtUserChangeDisplaySettings",
    "NtUserChangeWindowMessageFilterEx",
    "NtUserCheckAccessForIntegrityLevel",
    "NtUserCheckDesktopByThreadId",
    "NtUserCheckWindowThreadDesktop",
    "NtUserChildWindowFromPointEx",
    "NtUserClipCursor",
    "NtUserCreateDesktopEx",
    "NtUserCreateInputContext",
    "NtUserCreateWindowStation",
    "NtUserCtxDisplayIOCtl",
    "NtUserDestroyInputContext",
    "NtUserDisableThreadIme",
    "NtUserDisplayConfigGetDeviceInfo",
    "NtUserDisplayConfigSetDeviceInfo",
    "NtUserDoSoundConnect",
    "NtUserDoSoundDisconnect",
    "NtUserDragDetect",
    "NtUserDragObject",
    "NtUserDrawAnimatedRects",
    "NtUserDrawCaption",
    "NtUserDrawCaptionTemp",
    "NtUserDrawMenuBarTemp",
    "NtUserDwmStartRedirection",
    "NtUserDwmStopRedirection",
    "NtUserEndMenu",
    "NtUserEndTouchOperation",
    "NtUserEvent",
    "NtUserFlashWindowEx",
    "NtUserFrostCrashedWindow",
    "NtUserGetAppImeLevel",
    "NtUserGetCaretPos",
    "NtUserGetClipCursor",
    "NtUserGetClipboardViewer",
    "NtUserGetComboBoxInfo",
    "NtUserGetCursorInfo",
    "NtUserGetDisplayConfigBufferSizes",
    "NtUserGetGestureConfig",
    "NtUserGetGestureExtArgs",
    "NtUserGetGestureInfo",
    "NtUserGetGuiResources",
    "NtUserGetImeHotKey",
    "NtUserGetImeInfoEx",
    "NtUserGetInputLocaleInfo",
    "NtUserGetInternalWindowPos",
    "NtUserGetKeyNameText",
    "NtUserGetKeyboardLayoutName",
    "NtUserGetLayeredWindowAttributes",
    "NtUserGetListBoxInfo",
    "NtUserGetMenuIndex",
    "NtUserGetMenuItemRect",
    "NtUserGetMouseMovePointsEx",
    "NtUserGetPriorityClipboardFormat",
    "NtUserGetRawInputBuffer",
    "NtUserGetRawInputData",
    "NtUserGetRawInputDeviceInfo",
    "NtUserGetRawInputDeviceList",
    "NtUserGetRegisteredRawInputDevices",
    "NtUserGetTopLevelWindow",
    "NtUserGetTouchInputInfo",
    "NtUserGetUpdatedClipboardFormats",
    "NtUserGetWOWClass",
    "NtUserGetWindowCompositionAttribute",
    "NtUserGetWindowCompositionInfo",
    "NtUserGetWindowDisplayAffinity",
    "NtUserGetWindowMinimizeRect",
    "NtUserGetWindowRgnEx",
    "NtUserGhostWindowFromHungWindow",
    "NtUserHardErrorControl",
    "NtUserHiliteMenuItem",
    "NtUserHungWindowFromGhostWindow",
    "NtUserHwndQueryRedirectionInfo",
    "NtUserHwndSetRedirectionInfo",
    "NtUserImpersonateDdeClientWindow",
    "NtUserInitTask",
    "NtUserInitialize",
    "NtUserInitializeClientPfnArrays",
    "NtUserInjectGesture",
    "NtUserInternalGetWindowIcon",
    "NtUserIsTopLevelWindow",
    "NtUserIsTouchWindow",
    "NtUserLoadKeyboardLayoutEx",
    "NtUserLockWindowStation",
    "NtUserLockWorkStation",
    "NtUserLogicalToPhysicalPoint",
    "NtUserMNDragLeave",
    "NtUserMNDragOver",
    "NtUserMagControl",
    "NtUserMagGetContextInformation",
    "NtUserMagSetContextInformation",
    "NtUserManageGestureHandlerWindow",
    "NtUserMenuItemFromPoint",
    "NtUserMinMaximize",
    "NtUserModifyWindowTouchCapability",
    "NtUserNotifyIMEStatus",
    "NtUserOpenInputDesktop",
    "NtUserOpenThreadDesktop",
    "NtUserPaintMonitor",
    "NtUserPhysicalToLogicalPoint",
    "NtUserPrintWindow",
    "NtUserQueryDisplayConfig",
    "NtUserQueryInformationThread",
    "NtUserQueryInputContext",
    "NtUserQuerySendMessage",
    "NtUserRealChildWindowFromPoint",
    "NtUserRealWaitMessageEx",
    "NtUserRegisterErrorReportingDialog",
    "NtUserRegisterHotKey",
    "NtUserRegisterRawInputDevices",
    "NtUserRegisterServicesProcess",
    "NtUserRegisterSessionPort",
    "NtUserRegisterTasklist",
    "NtUserRegisterUserApiHook",
    "NtUserRemoteConnect",
    "NtUserRemoteRedrawRectangle",
    "NtUserRemoteRedrawScreen",
    "NtUserRemoteStopScreenUpdates",
    "NtUserRemoveClipboardFormatListener",
    "NtUserResolveDesktopForWOW",
    "NtUserSendTouchInput",
    "NtUserSetAppImeLevel",
    "NtUserSetChildWindowNoActivate",
    "NtUserSetClassWord",
    "NtUserSetCursorContents",
    "NtUserSetDisplayConfig",
    "NtUserSetGestureConfig",
    "NtUserSetImeHotKey",
    "NtUserSetImeInfoEx",
    "NtUserSetImeOwnerWindow",
    "NtUserSetInternalWindowPos",
    "NtUserSetLayeredWindowAttributes",
    "NtUserSetMenu",
    "NtUserSetMenuContextHelpId",
    "NtUserSetMenuFlagRtoL",
    "NtUserSetMirrorRendering",
    "NtUserSetObjectInformation",
    "NtUserSetProcessDPIAware",
    "NtUserSetShellWindowEx",
    "NtUserSetSysColors",
    "NtUserSetSystemCursor",
    "NtUserSetSystemTimer",
    "NtUserSetThreadLayoutHandles",
    "NtUserSetWindowCompositionAttribute",
    "NtUserSetWindowDisplayAffinity",
    "NtUserSetWindowRgnEx",
    "NtUserSetWindowStationUser",
    "NtUserSfmDestroyLogicalSurfaceBinding",
    "NtUserSfmDxBindSwapChain",
    "NtUserSfmDxGetSwapChainStats",
    "NtUserSfmDxOpenSwapChain",
    "NtUserSfmDxQuerySwapChainBindingStatus",
    "NtUserSfmDxReleaseSwapChain",
    "NtUserSfmDxReportPendingBindingsToDwm",
    "NtUserSfmDxSetSwapChainBindingStatus",
    "NtUserSfmDxSetSwapChainStats",
    "NtUserSfmGetLogicalSurfaceBinding",
    "NtUserShowSystemCursor",
    "NtUserSoundSentry",
    "NtUserSwitchDesktop",
    "NtUserTestForInteractiveUser",
    "NtUserTrackPopupMenuEx",
    "NtUserUnloadKeyboardLayout",
    "NtUserUnlockWindowStation",
    "NtUserUnregisterHotKey",
    "NtUserUnregisterSessionPort",
    "NtUserUnregisterUserApiHook",
    "NtUserUpdateInputContext",
    "NtUserUpdateInstance",
    "NtUserUpdateLayeredWindow",
    "NtUserUpdatePerUserSystemParameters",
    "NtUserUpdateWindowTransform",
    "NtUserUserHandleGrantAccess",
    "NtUserValidateHandleSecure",
    "NtUserWaitForInputIdle",
    "NtUserWaitForMsgAndEvent",
    "NtUserWindowFromPhysicalPoint",
    "NtUserYieldTask",
    "NtUserSetClassLongPtr",
    "NtUserSetWindowLongPtr"
};

//////////////////////////////////////////////////////////////////////////
// Windows 8 SP0 _W32pServiceTable
//////////////////////////////////////////////////////////////////////////
static const char* W32pServiceTable_Win8Sp0_x64[] = {
    "NtUserYieldTask",
    "NtUserGetThreadState",
    "NtUserPeekMessage",
    "NtUserCallOneParam",
    "NtUserGetKeyState",
    "NtUserInvalidateRect",
    "NtUserCallNoParam",
    "NtUserGetMessage",
    "NtUserMessageCall",
    "NtGdiBitBlt",
    "NtGdiGetCharSet",
    "NtUserGetDC",
    "NtGdiSelectBitmap",
    "NtUserWaitMessage",
    "NtUserTranslateMessage",
    "NtUserGetProp",
    "NtUserPostMessage",
    "NtUserQueryWindow",
    "NtUserTranslateAccelerator",
    "NtGdiFlush",
    "NtUserRedrawWindow",
    "NtUserWindowFromPoint",
    "NtUserCallMsgFilter",
    "NtUserValidateTimerCallback",
    "NtUserBeginPaint",
    "NtUserSetTimer",
    "NtUserEndPaint",
    "NtUserSetCursor",
    "NtUserKillTimer",
    "NtUserBuildHwndList",
    "NtUserSelectPalette",
    "NtUserCallNextHookEx",
    "NtUserHideCaret",
    "NtGdiIntersectClipRect",
    "NtUserCallHwndLock",
    "NtUserGetProcessWindowStation",
    "NtGdiDeleteObjectApp",
    "NtUserSetWindowPos",
    "NtUserShowCaret",
    "NtUserEndDeferWindowPosEx",
    "NtUserCallHwndParamLock",
    "NtUserVkKeyScanEx",
    "NtGdiSetDIBitsToDeviceInternal",
    "NtUserCallTwoParam",
    "NtGdiGetRandomRgn",
    "NtUserCopyAcceleratorTable",
    "NtUserNotifyWinEvent",
    "NtGdiExtSelectClipRgn",
    "NtUserIsClipboardFormatAvailable",
    "NtUserSetScrollInfo",
    "GreStretchBlt",
    "NtUserCreateCaret",
    "NtGdiRectVisible",
    "NtGdiCombineRgn",
    "NtGdiGetDCObject",
    "NtUserDispatchMessage",
    "NtUserRegisterWindowMessage",
    "NtGdiExtTextOutW",
    "NtGdiSelectFont",
    "NtGdiRestoreDC",
    "NtGdiSaveDC",
    "NtUserGetForegroundWindow",
    "NtUserShowScrollBar",
    "NtUserFindExistingCursorIcon",
    "NtGdiGetDCDword",
    "NtGdiGetRegionData",
    "NtGdiLineTo",
    "NtUserSystemParametersInfo",
    "NtGdiGetAppClipBox",
    "NtUserGetAsyncKeyState",
    "NtUserGetCPD",
    "NtUserRemoveProp",
    "NtGdiDoPalette",
    "NtGdiPolyPolyDraw",
    "NtUserSetCapture",
    "NtUserEnumDisplayMonitors",
    "NtGdiCreateCompatibleBitmap",
    "NtUserSetProp",
    "NtGdiGetTextCharsetInfo",
    "NtUserSBGetParms",
    "NtUserGetIconInfo",
    "NtUserExcludeUpdateRgn",
    "NtUserSetFocus",
    "NtGdiExtGetObjectW",
    "NtUserGetUpdateRect",
    "NtGdiCreateCompatibleDC",
    "NtUserGetClipboardSequenceNumber",
    "NtGdiCreatePen",
    "NtUserShowWindow",
    "NtUserGetKeyboardLayoutList",
    "NtGdiPatBlt",
    "NtUserMapVirtualKeyEx",
    "NtUserSetWindowLong",
    "NtGdiHfontCreate",
    "NtUserMoveWindow",
    "NtUserPostThreadMessage",
    "NtUserDrawIconEx",
    "NtUserGetSystemMenu",
    "NtGdiDrawStream",
    "NtUserInternalGetWindowText",
    "NtUserGetWindowDC",
    "EngAllocPrivateUserMem",
    "NtGdiInvertRgn",
    "NtGdiGetRgnBox",
    "NtGdiGetAndSetDCDword",
    "NtGdiMaskBlt",
    "NtGdiGetWidthTable",
    "NtUserScrollDC",
    "NtUserGetObjectInformation",
    "NtGdiCreateBitmap",
    "NtUserFindWindowEx",
    "NtGdiPolyPatBlt",
    "NtUserUnhookWindowsHookEx",
    "NtGdiGetNearestColor",
    "NtGdiTransformPoints",
    "NtGdiGetDCPoint",
    "NtGdiCreateDIBBrush",
    "NtGdiGetTextMetricsW",
    "NtUserCreateWindowEx",
    "NtUserSetParent",
    "NtUserGetKeyboardState",
    "NtUserToUnicodeEx",
    "NtUserGetControlBrush",
    "NtUserGetClassName",
    "NtGdiAlphaBlend",
    "EngAllocPrivateUserMem",
    "NtGdiOffsetRgn",
    "NtUserDefSetText",
    "NtGdiGetTextFaceW",
    "NtGdiStretchDIBitsInternal",
    "NtUserSendInput",
    "NtUserGetThreadDesktop",
    "NtGdiCreateRectRgn",
    "NtGdiGetDIBitsInternal",
    "NtUserGetUpdateRgn",
    "NtGdiDeleteClientObj",
    "NtUserGetIconSize",
    "NtUserFillWindow",
    "NtGdiExtCreateRegion",
    "NtGdiComputeXformCoefficients",
    "NtUserSetWindowsHookEx",
    "NtUserNotifyProcessCreate",
    "NtGdiUnrealizeObject",
    "NtUserGetTitleBarInfo",
    "NtGdiRectangle",
    "NtUserSetThreadDesktop",
    "NtUserGetDCEx",
    "NtUserGetScrollBarInfo",
    "NtGdiGetTextExtent",
    "NtUserSetWindowFNID",
    "NtGdiSetLayout",
    "NtUserCalcMenuBar",
    "NtUserThunkedMenuItemInfo",
    "NtGdiExcludeClipRect",
    "NtGdiCreateDIBSection",
    "NtGdiGetDCforBitmap",
    "NtUserDestroyCursor",
    "NtUserDestroyWindow",
    "NtUserCallHwndParam",
    "NtGdiCreateDIBitmapInternal",
    "NtUserOpenWindowStation",
    "EngAllocPrivateUserMem",
    "EngAllocPrivateUserMem",
    "EngAllocPrivateUserMem",
    "NtUserSetCursorIconData",
    "EngAllocPrivateUserMem",
    "NtUserCloseDesktop",
    "NtUserOpenDesktop",
    "NtUserSetProcessWindowStation",
    "NtUserGetAtomName",
    "EngAllocPrivateUserMem",
    "NtGdiExtCreatePen",
    "NtGdiCreatePaletteInternal",
    "NtGdiSetBrushOrg",
    "NtUserBuildNameList",
    "NtGdiSetPixel",
    "NtUserRegisterClassExWOW",
    "NtGdiCreatePatternBrushInternal",
    "NtUserGetAncestor",
    "NtGdiGetOutlineTextMetricsInternalW",
    "NtGdiSetBitmapBits",
    "NtUserCloseWindowStation",
    "NtUserGetDoubleClickTime",
    "NtUserEnableScrollBar",
    "NtGdiCreateSolidBrush",
    "NtUserGetClassInfoEx",
    "NtGdiCreateClientObj",
    "NtUserUnregisterClass",
    "NtUserDeleteMenu",
    "NtGdiRectInRegion",
    "NtUserScrollWindowEx",
    "NtGdiGetPixel",
    "NtUserSetClassLong",
    "NtUserGetMenuBarInfo",
    "EngAllocPrivateUserMem",
    "EngAllocPrivateUserMem",
    "NtGdiGetNearestPaletteIndex",
    "EngAllocPrivateUserMem",
    "EngAllocPrivateUserMem",
    "NtGdiGetCharWidthW",
    "NtUserInvalidateRgn",
    "NtUserGetClipboardOwner",
    "NtUserSetWindowRgn",
    "NtUserBitBltSysBmp",
    "NtGdiGetCharWidthInfo",
    "NtUserValidateRect",
    "NtUserCloseClipboard",
    "NtUserOpenClipboard",
    "NtGdiGetStockObject",
    "NtUserSetClipboardData",
    "NtUserEnableMenuItem",
    "NtUserAlterWindowStyle",
    "NtGdiFillRgn",
    "NtUserGetWindowPlacement",
    "NtGdiModifyWorldTransform",
    "NtGdiGetFontData",
    "NtUserGetOpenClipboardWindow",
    "NtUserSetThreadState",
    "NtGdiOpenDCW",
    "NtUserTrackMouseEvent",
    "NtGdiGetTransform",
    "NtUserDestroyMenu",
    "NtGdiGetBitmapBits",
    "NtUserConsoleControl",
    "NtUserSetActiveWindow",
    "NtUserSetInformationThread",
    "NtUserSetWindowPlacement",
    "NtUserGetControlColor",
    "NtGdiSetMetaRgn",
    "NtGdiSetMiterLimit",
    "NtGdiSetVirtualResolution",
    "NtGdiGetRasterizerCaps",
    "NtUserSetWindowWord",
    "NtUserGetClipboardFormatName",
    "NtUserRealInternalGetMessage",
    "NtUserCreateLocalMemHandle",
    "NtUserAttachThreadInput",
    "NtGdiCreateHalftonePalette",
    "NtUserPaintMenuBar",
    "NtUserSetKeyboardState",
    "NtGdiCombineTransform",
    "NtUserCreateAcceleratorTable",
    "NtUserGetCursorFrameInfo",
    "NtUserGetAltTabInfo",
    "NtUserGetCaretBlinkTime",
    "NtGdiQueryFontAssocInfo",
    "NtUserProcessConnect",
    "NtUserEnumDisplayDevices",
    "NtUserEmptyClipboard",
    "NtUserGetClipboardData",
    "NtUserRemoveMenu",
    "NtGdiSetBoundsRect",
    "NtGdiGetBitmapDimension",
    "NtUserConvertMemHandle",
    "NtUserDestroyAcceleratorTable",
    "NtUserGetGUIThreadInfo",
    "NtGdiCloseFigure",
    "NtUserSetWindowsHookAW",
    "NtUserSetMenuDefaultItem",
    "NtUserCheckMenuItem",
    "NtUserSetWinEventHook",
    "NtUserUnhookWinEvent",
    "NtUserLockWindowUpdate",
    "NtUserSetSystemMenu",
    "NtUserThunkedMenuInfo",
    "NtGdiBeginPath",
    "NtGdiEndPath",
    "NtGdiFillPath",
    "NtUserCallHwnd",
    "NtUserDdeInitialize",
    "NtUserModifyUserStartupInfoFlags",
    "NtUserCountClipboardFormats",
    "NtGdiAddFontMemResourceEx",
    "NtGdiEqualRgn",
    "NtGdiGetSystemPaletteUse",
    "NtGdiRemoveFontMemResourceEx",
    "NtUserEnumDisplaySettings",
    "NtUserPaintDesktop",
    "NtGdiExtEscape",
    "NtGdiSetBitmapDimension",
    "NtGdiSetFontEnumeration",
    "NtUserChangeClipboardChain",
    "NtUserSetClipboardViewer",
    "NtUserShowWindowAsync",
    "NtGdiCreateColorSpace",
    "NtGdiDeleteColorSpace",
    "NtUserActivateKeyboardLayout",
    "NtBindCompositionSurface",
    "NtCreateCompositionSurfaceHandle",
    "NtDCompositionAddCrossDeviceVisualChild",
    "NtDCompositionAddVisualChild",
    "NtDCompositionBeginFrame",
    "NtDCompositionCommitChannel",
    "NtDCompositionConfirmFrame",
    "NtDCompositionConnectPipe",
    "NtDCompositionCreateChannel",
    "NtDCompositionCreateConnectionContext",
    "NtDCompositionCreateDwmChannel",
    "NtDCompositionCreateResource",
    "NtDCompositionCurrentBatchId",
    "NtDCompositionDestroyChannel",
    "NtDCompositionDestroyConnectionContext",
    "NtDCompositionDiscardFrame",
    "NtDCompositionDwmSyncFlush",
    "NtDCompositionConnectPipe",
    "NtDCompositionGetConnectionContextBatch",
    "NtDCompositionGetDeletedResources",
    "NtDCompositionGetFrameLegacyTokens",
    "NtDCompositionGetFrameStatistics",
    "NtDCompositionGetFrameSurfaceUpdates",
    "NtDCompositionReleaseAllResources",
  