<?php
/**
 * This file is part of Swow
 *
 * @link    https://github.com/swow/swow
 * @contact twosee <twosee@php.net>
 *
 * For the full copyright and license information,
 * please view the LICENSE file that was distributed with this source code
 */

declare(strict_types=1);

namespace Swow\Http\Mime;

class MimeType
{
    public const HTML = 'text/html';
    public const CSS = 'text/css';
    public const XML = 'text/xml';
    public const GIF = 'image/gif';
    public const JPEG = 'image/jpeg';
    public const JS = 'application/javascript';
    public const ATOM = 'application/atom+xml';
    public const RSS = 'application/rss+xml';
    public const MML = 'text/mathml';
    public const TXT = 'text/plain';
    public const TEXT = self::TXT;
    public const CONF = self::TXT;
    public const DEF = self::TXT;
    public const LIST = self::TXT;
    public const LOG = self::TXT;
    public const IN = self::TXT;
    public const INI = self::TXT;
    public const JAD = 'text/vnd.sun.j2me.app-descriptor';
    public const WML = 'text/vnd.wap.wml';
    public const HTC = 'text/x-component';
    public const AVIF = 'image/avif';
    public const PNG = 'image/png';
    public const SVG = 'image/svg+xml';
    public const SVGZ = self::SVG;
    public const TIFF = 'image/tiff';
    public const WBMP = 'image/vnd.wap.wbmp';
    public const WEBP = 'image/webp';
    public const ICO = 'image/x-icon';
    public const JNG = 'image/x-jng';
    public const BMP = 'image/x-ms-bmp';
    public const WOFF = 'font/woff';
    public const WOFF2 = 'font/woff2';
    public const JAR = 'application/java-archive';
    public const WAR = self::JAR;
    public const EAR = self::JAR;
    public const JSON = 'application/json';
    public const HQX = 'application/mac-binhex40';
    public const DOC = 'application/msword';
    public const DOT = self::DOC;
    public const PDF = 'application/pdf';
    public const PS = 'application/postscript';
    public const EPS = self::PS;
    public const AI = self::PS;
    public const RTF = 'application/rtf';
    public const M3U8 = 'application/vnd.apple.mpegurl';
    public const KML = 'application/vnd.google-earth.kml+xml';
    public const KMZ = 'application/vnd.google-earth.kmz';
    public const XLS = 'application/vnd.ms-excel';
    public const XLM = self::XLS;
    public const XLA = self::XLS;
    public const XLC = self::XLS;
    public const XLT = self::XLS;
    public const XLW = self::XLS;
    public const EOT = 'application/vnd.ms-fontobject';
    public const PPT = 'application/vnd.ms-powerpoint';
    public const PPS = self::PPT;
    public const POT = self::PPT;
    public const ODG = 'application/vnd.oasis.opendocument.graphics';
    public const ODP = 'application/vnd.oasis.opendocument.presentation';
    public const ODS = 'application/vnd.oasis.opendocument.spreadsheet';
    public const ODT = 'application/vnd.oasis.opendocument.text';
    public const PPTX = 'application/vnd.openxmlformats-officedocument.presentationml.presentation';
    public const XLSX = 'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet';
    public const DOCX = 'application/vnd.openxmlformats-officedocument.wordprocessingml.document';
    public const WMLC = 'application/vnd.wap.wmlc';
    public const WASM = 'application/wasm';
    public const _7Z = 'application/x-7z-compressed';
    public const CCO = 'application/x-cocoa';
    public const JARDIFF = 'application/x-java-archive-diff';
    public const JNLP = 'application/x-java-jnlp-file';
    public const RUN = 'application/x-makeself';
    public const PL = 'application/x-perl';
    public const PM = self::PL;
    public const PRC = 'application/x-pilot';
    public const PDB = self::PRC;
    public const RAR = 'application/x-rar-compressed';
    public const RPM = 'application/x-redhat-package-manager';
    public const SEA = 'application/x-sea';
    public const SWF = 'application/x-shockwave-flash';
    public const SIT = 'application/x-stuffit';
    public const TCL = 'application/x-tcl';
    public const TK = self::TCL;
    public const DER = 'application/x-x509-ca-cert';
    public const PEM = self::DER;
    public const CRT = self::DER;
    public const XPI = 'application/x-xpinstall';
    public const XHTML = 'application/xhtml+xml';
    public const XHT = self::XHTML;
    public const XSPF = 'application/xspf+xml';
    public const ZIP = 'application/zip';
    public const BIN = 'application/octet-stream';
    public const EXE = self::BIN;
    public const DLL = self::BIN;
    public const DEB = self::BIN;
    public const DMG = self::BIN;
    public const ISO = self::BIN;
    public const IMG = self::BIN;
    public const MSI = self::BIN;
    public const MSP = self::BIN;
    public const MSM = self::BIN;
    public const DMS = self::BIN;
    public const LRF = self::BIN;
    public const MAR = self::BIN;
    public const SO = self::BIN;
    public const DIST = self::BIN;
    public const DISTZ = self::BIN;
    public const PKG = self::BIN;
    public const BPK = self::BIN;
    public const DUMP = self::BIN;
    public const ELC = self::BIN;
    public const DEPLOY = self::BIN;
    public const BUFFER = self::BIN;
    public const MIDI = 'audio/midi';
    public const MP3 = 'audio/mpeg';
    public const MPGA = self::MP3;
    public const MP2 = self::MP3;
    public const MP2A = self::MP3;
    public const M2A = self::MP3;
    public const M3A = self::MP3;
    public const OGG = 'audio/ogg';
    public const M4A = 'audio/x-m4a';
    public const RA = 'audio/x-realaudio';
    public const _3GPP = 'video/3gpp';
    public const TS = 'video/mp2t';
    public const MP4 = 'video/mp4';
    public const MPEG = 'video/mpeg';
    public const MOV = 'video/quicktime';
    public const QT = self::MOV;
    public const WEBM = 'video/webm';
    public const FLV = 'video/x-flv';
    public const M4V = 'video/x-m4v';
    public const MNG = 'video/x-mng';
    public const ASX = 'video/x-ms-asf';
    public const ASF = self::ASX;
    public const WMV = 'video/x-ms-wmv';
    public const AVI = 'video/x-msvideo';
    public const _1D_INTERLEAVED_PARITYFEC = 'application/1d-interleaved-parityfec';
    public const _3GPDASH_QOE_REPORT_XML = 'application/3gpdash-qoe-report+xml';
    public const _3GPP_IMS_XML = 'application/3gpp-ims+xml';
    public const _3GPPHAL_JSON = 'application/3gpphal+json';
    public const _3GPPHALFORMS_JSON = 'application/3gpphalforms+json';
    public const A2L = 'application/a2l';
    public const ACE_CBOR = 'application/ace+cbor';
    public const ACE_JSON = 'application/ace+json';
    public const ACTIVEMESSAGE = 'application/activemessage';
    public const ACTIVITY_JSON = 'application/activity+json';
    public const AIF_CBOR = 'application/aif+cbor';
    public const AIF_JSON = 'application/aif+json';
    public const ALTO_CDNI_JSON = 'application/alto-cdni+json';
    public const ALTO_CDNIFILTER_JSON = 'application/alto-cdnifilter+json';
    public const ALTO_COSTMAP_JSON = 'application/alto-costmap+json';
    public const ALTO_COSTMAPFILTER_JSON = 'application/alto-costmapfilter+json';
    public const ALTO_DIRECTORY_JSON = 'application/alto-directory+json';
    public const ALTO_ENDPOINTCOST_JSON = 'application/alto-endpointcost+json';
    public const ALTO_ENDPOINTCOSTPARAMS_JSON = 'application/alto-endpointcostparams+json';
    public const ALTO_ENDPOINTPROP_JSON = 'application/alto-endpointprop+json';
    public const ALTO_ENDPOINTPROPPARAMS_JSON = 'application/alto-endpointpropparams+json';
    public const ALTO_ERROR_JSON = 'application/alto-error+json';
    public const ALTO_NETWORKMAP_JSON = 'application/alto-networkmap+json';
    public const ALTO_NETWORKMAPFILTER_JSON = 'application/alto-networkmapfilter+json';
    public const ALTO_PROPMAP_JSON = 'application/alto-propmap+json';
    public const ALTO_PROPMAPPARAMS_JSON = 'application/alto-propmapparams+json';
    public const ALTO_UPDATESTREAMCONTROL_JSON = 'application/alto-updatestreamcontrol+json';
    public const ALTO_UPDATESTREAMPARAMS_JSON = 'application/alto-updatestreamparams+json';
    public const AML = 'application/aml';
    public const EZ = 'application/andrew-inset';
    public const APPINSTALLER = 'application/appinstaller';
    public const APPLEFILE = 'application/applefile';
    public const AW = 'application/applixware';
    public const APPX = 'application/appx';
    public const APPXBUNDLE = 'application/appxbundle';
    public const AT_JWT = 'application/at+jwt';
    public const ATF = 'application/atf';
    public const ATFX = 'application/atfx';
    public const ATOMCAT = 'application/atomcat+xml';
    public const ATOMDELETED = 'application/atomdeleted+xml';
    public const ATOMICMAIL = 'application/atomicmail';
    public const ATOMSVC = 'application/atomsvc+xml';
    public const DWD = 'application/atsc-dwd+xml';
    public const ATSC_DYNAMIC_EVENT_MESSAGE = 'application/atsc-dynamic-event-message';
    public const HELD = 'application/atsc-held+xml';
    public const ATSC_RDT_JSON = 'application/atsc-rdt+json';
    public const RSAT = 'application/atsc-rsat+xml';
    public const ATXML = 'application/atxml';
    public const AUTH_POLICY_XML = 'application/auth-policy+xml';
    public const AMLX = 'application/automationml-amlx+zip';
    public const BACNET_XDD_ZIP = 'application/bacnet-xdd+zip';
    public const BATCH_SMTP = 'application/batch-smtp';
    public const BDOC = 'application/bdoc';
    public const BEEP_XML = 'application/beep+xml';
    public const CALENDAR_JSON = 'application/calendar+json';
    public const XCS = 'application/calendar+xml';
    public const CALL_COMPLETION = 'application/call-completion';
    public const CALS_1840 = 'application/cals-1840';
    public const CAPTIVE_JSON = 'application/captive+json';
    public const CBOR = 'application/cbor';
    public const CBOR_SEQ = 'application/cbor-seq';
    public const CCCEX = 'application/cccex';
    public const CCMP_XML = 'application/ccmp+xml';
    public const CCXML = 'application/ccxml+xml';
    public const CDA_XML = 'application/cda+xml';
    public const CDFX = 'application/cdfx+xml';
    public const CDMIA = 'application/cdmi-capability';
    public const CDMIC = 'application/cdmi-container';
    public const CDMID = 'application/cdmi-domain';
    public const CDMIO = 'application/cdmi-object';
    public const CDMIQ = 'application/cdmi-queue';
    public const CDNI = 'application/cdni';
    public const CEA = 'application/cea';
    public const CEA_2018_XML = 'application/cea-2018+xml';
    public const CELLML_XML = 'application/cellml+xml';
    public const CFW = 'application/cfw';
    public const CITY_JSON = 'application/city+json';
    public const CLR = 'application/clr';
    public const CLUE_XML = 'application/clue+xml';
    public const CLUE_INFO_XML = 'application/clue_info+xml';
    public const CMS = 'application/cms';
    public const CNRP_XML = 'application/cnrp+xml';
    public const COAP_GROUP_JSON = 'application/coap-group+json';
    public const COAP_PAYLOAD = 'application/coap-payload';
    public const COMMONGROUND = 'application/commonground';
    public const CONCISE_PROBLEM_DETAILS_CBOR = 'application/concise-problem-details+cbor';
    public const CONFERENCE_INFO_XML = 'application/conference-info+xml';
    public const COSE = 'application/cose';
    public const COSE_KEY = 'application/cose-key';
    public const COSE_KEY_SET = 'application/cose-key-set';
    public const COSE_X509 = 'application/cose-x509';
    public const CPL = 'application/cpl+xml';
    public const CSRATTRS = 'application/csrattrs';
    public const CSTA_XML = 'application/csta+xml';
    public const CSTADATA_XML = 'application/cstadata+xml';
    public const CSVM_JSON = 'application/csvm+json';
    public const CU = 'application/cu-seeme';
    public const CWL = 'application/cwl';
    public const CWL_JSON = 'application/cwl+json';
    public const CWT = 'application/cwt';
    public const CYBERCASH = 'application/cybercash';
    public const DART = 'application/dart';
    public const MPD = 'application/dash+xml';
    public const MPP = 'application/dash-patch+xml';
    public const DASHDELTA = 'application/dashdelta';
    public const DAVMOUNT = 'application/davmount+xml';
    public const DCA_RFT = 'application/dca-rft';
    public const DCD = 'application/dcd';
    public const DEC_DX = 'application/dec-dx';
    public const DIALOG_INFO_XML = 'application/dialog-info+xml';
    public const DICOM = 'application/dicom';
    public const DICOM_JSON = 'application/dicom+json';
    public const DICOM_XML = 'application/dicom+xml';
    public const DII = 'application/dii';
    public const DIT = 'application/dit';
    public const DNS = 'application/dns';
    public const DNS_JSON = 'application/dns+json';
    public const DNS_MESSAGE = 'application/dns-message';
    public const DBK = 'application/docbook+xml';
    public const DOTS_CBOR = 'application/dots+cbor';
    public const DSKPP_XML = 'application/dskpp+xml';
    public const DSSC = 'application/dssc+der';
    public const XDSSC = 'application/dssc+xml';
    public const DVCS = 'application/dvcs';
    public const ECMA = 'application/ecmascript';
    public const EDI_CONSENT = 'application/edi-consent';
    public const EDI_X12 = 'application/edi-x12';
    public const EDIFACT = 'application/edifact';
    public const EFI = 'application/efi';
    public const ELM_JSON = 'application/elm+json';
    public const ELM_XML = 'application/elm+xml';
    public const EMERGENCYCALLDATA_CAP_XML = 'application/emergencycalldata.cap+xml';
    public const EMERGENCYCALLDATA_COMMENT_XML = 'application/emergencycalldata.comment+xml';
    public const EMERGENCYCALLDATA_CONTROL_XML = 'application/emergencycalldata.control+xml';
    public const EMERGENCYCALLDATA_DEVICEINFO_XML = 'application/emergencycalldata.deviceinfo+xml';
    public const EMERGENCYCALLDATA_ECALL_MSD = 'application/emergencycalldata.ecall.msd';
    public const EMERGENCYCALLDATA_LEGACYESN_JSON = 'application/emergencycalldata.legacyesn+json';
    public const EMERGENCYCALLDATA_PROVIDERINFO_XML = 'application/emergencycalldata.providerinfo+xml';
    public const EMERGENCYCALLDATA_SERVICEINFO_XML = 'application/emergencycalldata.serviceinfo+xml';
    public const EMERGENCYCALLDATA_SUBSCRIBERINFO_XML = 'application/emergencycalldata.subscriberinfo+xml';
    public const EMERGENCYCALLDATA_VEDS_XML = 'application/emergencycalldata.veds+xml';
    public const EMMA = 'application/emma+xml';
    public const EMOTIONML = 'application/emotionml+xml';
    public const ENCAPRTP = 'application/encaprtp';
    public const EPP_XML = 'application/epp+xml';
    public const EPUB = 'application/epub+zip';
    public const ESHOP = 'application/eshop';
    public const EXI = 'application/exi';
    public const EXPECT_CT_REPORT_JSON = 'application/expect-ct-report+json';
    public const EXP = 'application/express';
    public const FASTINFOSET = 'application/fastinfoset';
    public const FASTSOAP = 'application/fastsoap';
    public const FDF = 'application/fdf';
    public const FDT = 'application/fdt+xml';
    public const FHIR_JSON = 'application/fhir+json';
    public const FHIR_XML = 'application/fhir+xml';
    public const FIDO_TRUSTED_APPS_JSON = 'application/fido.trusted-apps+json';
    public const FITS = 'application/fits';
    public const FLEXFEC = 'application/flexfec';
    public const FONT_SFNT = 'application/font-sfnt';
    public const PFR = 'application/font-tdpfr';
    public const FONT_WOFF = 'application/font-woff';
    public const FRAMEWORK_ATTRIBUTES_XML = 'application/framework-attributes+xml';
    public const GEOJSON = 'application/geo+json';
    public const GEO_JSON_SEQ = 'application/geo+json-seq';
    public const GEOPACKAGE_SQLITE3 = 'application/geopackage+sqlite3';
    public const GEOXACML_XML = 'application/geoxacml+xml';
    public const GLTF_BUFFER = 'application/gltf-buffer';
    public const GML = 'application/gml+xml';
    public const GPX = 'application/gpx+xml';
    public const GXF = 'application/gxf';
    public const GZ = 'application/gzip';
    public const H224 = 'application/h224';
    public const HELD_XML = 'application/held+xml';
    public const HJSON = 'application/hjson';
    public const HL7V2_XML = 'application/hl7v2+xml';
    public const HTTP = 'application/http';
    public const STK = 'application/hyperstudio';
    public const IBE_KEY_REQUEST_XML = 'application/ibe-key-request+xml';
    public const IBE_PKG_REPLY_XML = 'application/ibe-pkg-reply+xml';
    public const IBE_PP_DATA = 'application/ibe-pp-data';
    public const IGES = 'application/iges';
    public const IM_ISCOMPOSING_XML = 'application/im-iscomposing+xml';
    public const INDEX = 'application/index';
    public const INDEX_CMD = 'application/index.cmd';
    public const INDEX_OBJ = 'application/index.obj';
    public const INDEX_RESPONSE = 'application/index.response';
    public const INDEX_VND = 'application/index.vnd';
    public const INK = 'application/inkml+xml';
    public const INKML = self::INK;
    public const IOTP = 'application/iotp';
    public const IPFIX = 'application/ipfix';
    public const IPP = 'application/ipp';
    public const ISUP = 'application/isup';
    public const ITS = 'application/its+xml';
    public const SER = 'application/java-serialized-object';
    public const _CLASS = 'application/java-vm';
    public const JF2FEED_JSON = 'application/jf2feed+json';
    public const JOSE = 'application/jose';
    public const JOSE_JSON = 'application/jose+json';
    public const JRD_JSON = 'application/jrd+json';
    public const JSCALENDAR_JSON = 'application/jscalendar+json';
    public const JSON_PATCH_JSON = 'application/json-patch+json';
    public const JSON_SEQ = 'application/json-seq';
    public const JSON5 = 'application/json5';
    public const JSONML = 'application/jsonml+json';
    public const JWK_JSON = 'application/jwk+json';
    public const JWK_SET_JSON = 'application/jwk-set+json';
    public const JWT = 'application/jwt';
    public const KPML_REQUEST_XML = 'application/kpml-request+xml';
    public const KPML_RESPONSE_XML = 'application/kpml-response+xml';
    public const JSONLD = 'application/ld+json';
    public const LGR = 'application/lgr+xml';
    public const LINK_FORMAT = 'application/link-format';
    public const LINKSET = 'application/linkset';
    public const LINKSET_JSON = 'application/linkset+json';
    public const LOAD_CONTROL_XML = 'application/load-control+xml';
    public const LOGOUT_JWT = 'application/logout+jwt';
    public const LOSTXML = 'application/lost+xml';
    public const LOSTSYNC_XML = 'application/lostsync+xml';
    public const LPF_ZIP = 'application/lpf+zip';
    public const LXF = 'application/lxf';
    public const CPT = 'application/mac-compactpro';
    public const MACWRITEII = 'application/macwriteii';
    public const MADS = 'application/mads+xml';
    public const WEBMANIFEST = 'application/manifest+json';
    public const MRC = 'application/marc';
    public const MRCX = 'application/marcxml+xml';
    public const MA = 'application/mathematica';
    public const NB = self::MA;
    public const MB = self::MA;
    public const MATHML = 'application/mathml+xml';
    public const MATHML_CONTENT_XML = 'application/mathml-content+xml';
    public const MATHML_PRESENTATION_XML = 'application/mathml-presentation+xml';
    public const MBMS_ASSOCIATED_PROCEDURE_DESCRIPTION_XML = 'application/mbms-associated-procedure-description+xml';
    public const MBMS_DEREGISTER_XML = 'application/mbms-deregister+xml';
    public const MBMS_ENVELOPE_XML = 'application/mbms-envelope+xml';
    public const MBMS_MSK_XML = 'application/mbms-msk+xml';
    public const MBMS_MSK_RESPONSE_XML = 'application/mbms-msk-response+xml';
    public const MBMS_PROTECTION_DESCRIPTION_XML = 'application/mbms-protection-description+xml';
    public const MBMS_RECEPTION_REPORT_XML = 'application/mbms-reception-report+xml';
    public const MBMS_REGISTER_XML = 'application/mbms-register+xml';
    public const MBMS_REGISTER_RESPONSE_XML = 'application/mbms-register-response+xml';
    public const MBMS_SCHEDULE_XML = 'application/mbms-schedule+xml';
    public const MBMS_USER_SERVICE_DESCRIPTION_XML = 'application/mbms-user-service-description+xml';
    public const MBOX = 'application/mbox';
    public const MPF = 'application/media-policy-dataset+xml';
    public const MEDIA_CONTROL_XML = 'application/media_control+xml';
    public const MSCML = 'application/mediaservercontrol+xml';
    public const MERGE_PATCH_JSON = 'application/merge-patch+json';
    public const METALINK = 'application/metalink+xml';
    public const META4 = 'application/metalink4+xml';
    public const METS = 'application/mets+xml';
    public const MF4 = 'application/mf4';
    public const MIKEY = 'application/mikey';
    public const MIPC = 'application/mipc';
    public const MISSING_BLOCKS_CBOR_SEQ = 'application/missing-blocks+cbor-seq';
    public const MAEI = 'application/mmt-aei+xml';
    public const MUSD = 'application/mmt-usd+xml';
    public const MODS = 'application/mods+xml';
    public const MOSS_KEYS = 'application/moss-keys';
    public const MOSS_SIGNATURE = 'application/moss-signature';
    public const MOSSKEY_DATA = 'application/mosskey-data';
    public const MOSSKEY_REQUEST = 'application/mosskey-request';
    public const MP21 = 'application/mp21';
    public const MPG4 = 'application/mp4';
    public const MP4S = self::MPG4;
    public const M4P = self::MPG4;
    public const MPEG4_GENERIC = 'application/mpeg4-generic';
    public const MPEG4_IOD = 'application/mpeg4-iod';
    public const MPEG4_IOD_XMT = 'application/mpeg4-iod-xmt';
    public const MRB_CONSUMER_XML = 'application/mrb-consumer+xml';
    public const MRB_PUBLISH_XML = 'application/mrb-publish+xml';
    public const MSC_IVR_XML = 'application/msc-ivr+xml';
    public const MSC_MIXER_XML = 'application/msc-mixer+xml';
    public const MSIX = 'application/msix';
    public const MSIXBUNDLE = 'application/msixbundle';
    public const MUD_JSON = 'application/mud+json';
    public const MULTIPART_CORE = 'application/multipart-core';
    public const MXF = 'application/mxf';
    public const NQ = 'application/n-quads';
    public const NT = 'application/n-triples';
    public const NASDATA = 'application/nasdata';
    public const NEWS_CHECKGROUPS = 'application/news-checkgroups';
    public const NEWS_GROUPINFO = 'application/news-groupinfo';
    public const NEWS_TRANSMISSION = 'application/news-transmission';
    public const NLSML_XML = 'application/nlsml+xml';
    public const CJS = 'application/node';
    public const NSS = 'application/nss';
    public const OAUTH_AUTHZ_REQ_JWT = 'application/oauth-authz-req+jwt';
    public const OBLIVIOUS_DNS_MESSAGE = 'application/oblivious-dns-message';
    public const OCSP_REQUEST = 'application/ocsp-request';
    public const OCSP_RESPONSE = 'application/ocsp-response';
    public const ODA = 'application/oda';
    public const ODM_XML = 'application/odm+xml';
    public const ODX = 'application/odx';
    public const OPF = 'application/oebps-package+xml';
    public const OGX = 'application/ogg';
    public const OMDOC = 'application/omdoc+xml';
    public const ONETOC = 'application/onenote';
    public const ONETOC2 = self::ONETOC;
    public const ONETMP = self::ONETOC;
    public const ONEPKG = self::ONETOC;
    public const OPC_NODESET_XML = 'application/opc-nodeset+xml';
    public const OSCORE = 'application/oscore';
    public const OXPS = 'application/oxps';
    public const P21 = 'application/p21';
    public const P21_ZIP = 'application/p21+zip';
    public const RELO = 'application/p2p-overlay+xml';
    public const PARITYFEC = 'application/parityfec';
    public const PASSPORT = 'application/passport';
    public const XER = 'application/patch-ops-error+xml';
    public const PDX = 'application/pdx';
    public const PEM_CERTIFICATE_CHAIN = 'application/pem-certificate-chain';
    public const PGP = 'application/pgp-encrypted';
    public const ASC = 'application/pgp-keys';
    public const SIG = 'application/pgp-signature';
    public const PRF = 'application/pics-rules';
    public const PIDF_XML = 'application/pidf+xml';
    public const PIDF_DIFF_XML = 'application/pidf-diff+xml';
    public const P10 = 'application/pkcs10';
    public const PKCS12 = 'application/pkcs12';
    public const P7M = 'application/pkcs7-mime';
    public const P7C = self::P7M;
    public const P7S = 'application/pkcs7-signature';
    public const P8 = 'application/pkcs8';
    public const PKCS8_ENCRYPTED = 'application/pkcs8-encrypted';
    public const AC = 'application/pkix-attr-cert';
    public const CER = 'application/pkix-cert';
    public const CRL = 'application/pkix-crl';
    public const PKIPATH = 'application/pkix-pkipath';
    public const PKI = 'application/pkixcmp';
    public const PLS = 'application/pls+xml';
    public const POC_SETTINGS_XML = 'application/poc-settings+xml';
    public const PPSP_TRACKER_JSON = 'application/ppsp-tracker+json';
    public const PROBLEM_JSON = 'application/problem+json';
    public const PROBLEM_XML = 'application/problem+xml';
    public const PROVX = 'application/provenance+xml';
    public const PRS_ALVESTRAND_TITRAX_SHEET = 'application/prs.alvestrand.titrax-sheet';
    public const CWW = 'application/prs.cww';
    public const PRS_CYN = 'application/prs.cyn';
    public const PRS_HPUB_ZIP = 'application/prs.hpub+zip';
    public const PRS_NPREND = 'application/prs.nprend';
    public const PRS_PLUCKER = 'application/prs.plucker';
    public const PRS_RDF_XML_CRYPT = 'application/prs.rdf-xml-crypt';
    public const XSF = 'application/prs.xsf+xml';
    public const PSKCXML = 'application/pskc+xml';
    public const PVD_JSON = 'application/pvd+json';
    public const QSIG = 'application/qsig';
    public const RAML = 'application/raml+yaml';
    public const RAPTORFEC = 'application/raptorfec';
    public const RDAP_JSON = 'application/rdap+json';
    public const RDF = 'application/rdf+xml';
    public const OWL = self::RDF;
    public const RIF = 'application/reginfo+xml';
    public const RNC = 'application/relax-ng-compact-syntax';
    public const REMOTE_PRINTING = 'application/remote-printing';
    public const REPUTON_JSON = 'application/reputon+json';
    public const RL = 'application/resource-lists+xml';
    public const RLD = 'application/resource-lists-diff+xml';
    public const RFC_XML = 'application/rfc+xml';
    public const RISCOS = 'application/riscos';
    public const RLMI_XML = 'application/rlmi+xml';
    public const RS = 'application/rls-services+xml';
    public const RAPD = 'application/route-apd+xml';
    public const SLS = 'application/route-s-tsid+xml';
    public const RUSD = 'application/route-usd+xml';
    public const RPKI_CHECKLIST = 'application/rpki-checklist';
    public const GBR = 'application/rpki-ghostbusters';
    public const MFT = 'application/rpki-manifest';
    public const RPKI_PUBLICATION = 'application/rpki-publication';
    public const ROA = 'application/rpki-roa';
    public const RPKI_UPDOWN = 'application/rpki-updown';
    public const RSD = 'application/rsd+xml';
    public const RTPLOOPBACK = 'application/rtploopback';
    public const RTX = 'application/rtx';
    public const SAMLASSERTION_XML = 'application/samlassertion+xml';
    public const SAMLMETADATA_XML = 'application/samlmetadata+xml';
    public const SARIF_JSON = 'application/sarif+json';
    public const SARIF_EXTERNAL_PROPERTIES_JSON = 'application/sarif-external-properties+json';
    public const SBE = 'application/sbe';
    public const SBML = 'application/sbml+xml';
    public const SCAIP_XML = 'application/scaip+xml';
    public const SCIM_JSON = 'application/scim+json';
    public const SCQ = 'application/scvp-cv-request';
    public const SCS = 'application/scvp-cv-response';
    public const SPQ = 'application/scvp-vp-request';
    public const SPP = 'application/scvp-vp-response';
    public const SDP = 'application/sdp';
    public const SECEVENT_JWT = 'application/secevent+jwt';
    public const SENML_CBOR = 'application/senml+cbor';
    public const SENML_JSON = 'application/senml+json';
    public const SENMLX = 'application/senml+xml';
    public const SENML_ETCH_CBOR = 'application/senml-etch+cbor';
    public const SENML_ETCH_JSON = 'application/senml-etch+json';
    public const SENML_EXI = 'application/senml-exi';
    public const SENSML_CBOR = 'application/sensml+cbor';
    public const SENSML_JSON = 'application/sensml+json';
    public const SENSMLX = 'application/sensml+xml';
    public const SENSML_EXI = 'application/sensml-exi';
    public const SEP_XML = 'application/sep+xml';
    public const SEP_EXI = 'application/sep-exi';
    public const SESSION_INFO = 'application/session-info';
    public const SET_PAYMENT = 'application/set-payment';
    public const SETPAY = 'application/set-payment-initiation';
    public const SET_REGISTRATION = 'application/set-registration';
    public const SETREG = 'application/set-registration-initiation';
    public const SGML = 'application/sgml';
    public const SGML_OPEN_CATALOG = 'application/sgml-open-catalog';
    public const SHF = 'application/shf+xml';
    public const SIEVE = 'application/sieve';
    public const SIMPLE_FILTER_XML = 'application/simple-filter+xml';
    public const SIMPLE_MESSAGE_SUMMARY = 'application/simple-message-summary';
    public const SIMPLESYMBOLCONTAINER = 'application/simplesymbolcontainer';
    public const SIPC = 'application/sipc';
    public const SLATE = 'application/slate';
    public const SMIL = 'application/smil';
    public const SMI = 'application/smil+xml';
    public const SMPTE336M = 'application/smpte336m';
    public const SOAP_FASTINFOSET = 'application/soap+fastinfoset';
    public const SOAP_XML = 'application/soap+xml';
    public const RQ = 'application/sparql-query';
    public const SRX = 'application/sparql-results+xml';
    public const SPDX_JSON = 'application/spdx+json';
    public const SPIRITS_EVENT_XML = 'application/spirits-event+xml';
    public const SQL = 'application/sql';
    public const GRAM = 'application/srgs';
    public const GRXML = 'application/srgs+xml';
    public const SRU = 'application/sru+xml';
    public const SSDL = 'application/ssdl+xml';
    public const SSML = 'application/ssml+xml';
    public const STIX_JSON = 'application/stix+json';
    public const SWID_CBOR = 'application/swid+cbor';
    public const SWIDTAG = 'application/swid+xml';
    public const TAMP_APEX_UPDATE = 'application/tamp-apex-update';
    public const TAMP_APEX_UPDATE_CONFIRM = 'application/tamp-apex-update-confirm';
    public const TAMP_COMMUNITY_UPDATE = 'application/tamp-community-update';
    public const TAMP_COMMUNITY_UPDATE_CONFIRM = 'application/tamp-community-update-confirm';
    public const TAMP_ERROR = 'application/tamp-error';
    public const TAMP_SEQUENCE_ADJUST = 'application/tamp-sequence-adjust';
    public const TAMP_SEQUENCE_ADJUST_CONFIRM = 'application/tamp-sequence-adjust-confirm';
    public const TAMP_STATUS_QUERY = 'application/tamp-status-query';
    public const TAMP_STATUS_RESPONSE = 'application/tamp-status-response';
    public const TAMP_UPDATE = 'application/tamp-update';
    public const TAMP_UPDATE_CONFIRM = 'application/tamp-update-confirm';
    public const TAR = 'application/tar';
    public const TAXII_JSON = 'application/taxii+json';
    public const TD_JSON = 'application/td+json';
    public const TEI = 'application/tei+xml';
    public const TEICORPUS = self::TEI;
    public const TETRA_ISI = 'application/tetra_isi';
    public const TFI = 'application/thraud+xml';
    public const TIMESTAMP_QUERY = 'application/timestamp-query';
    public const TIMESTAMP_REPLY = 'application/timestamp-reply';
    public const TSD = 'application/timestamped-data';
    public const TLSRPT_GZIP = 'application/tlsrpt+gzip';
    public const TLSRPT_JSON = 'application/tlsrpt+json';
    public const TM_JSON = 'application/tm+json';
    public const TNAUTHLIST = 'application/tnauthlist';
    public const TOKEN_INTROSPECTION_JWT = 'application/token-introspection+jwt';
    public const TOML = 'application/toml';
    public const TRICKLE_ICE_SDPFRAG = 'application/trickle-ice-sdpfrag';
    public const TRIG = 'application/trig';
    public const TTML = 'application/ttml+xml';
    public const TVE_TRIGGER = 'application/tve-trigger';
    public const TZIF = 'application/tzif';
    public const TZIF_LEAP = 'application/tzif-leap';
    public const UBJ = 'application/ubjson';
    public const ULPFEC = 'application/ulpfec';
    public const URC_GRPSHEET_XML = 'application/urc-grpsheet+xml';
    public const RSHEET = 'application/urc-ressheet+xml';
    public const TD = 'application/urc-targetdesc+xml';
    public const URC_UISOCKETDESC_XML = 'application/urc-uisocketdesc+xml';
    public const VCARD_JSON = 'application/vcard+json';
    public const VCARD_XML = 'application/vcard+xml';
    public const VEMMI = 'application/vemmi';
    public const VIVIDENCE_SCRIPTFILE = 'application/vividence.scriptfile';
    public const _1KM = 'application/vnd.1000minds.decision-model+xml';
    public const VND_3GPP_PROSE_XML = 'application/vnd.3gpp-prose+xml';
    public const VND_3GPP_PROSE_PC3A_XML = 'application/vnd.3gpp-prose-pc3a+xml';
    public const VND_3GPP_PROSE_PC3ACH_XML = 'application/vnd.3gpp-prose-pc3ach+xml';
    public const VND_3GPP_PROSE_PC3CH_XML = 'application/vnd.3gpp-prose-pc3ch+xml';
    public const VND_3GPP_PROSE_PC8_XML = 'application/vnd.3gpp-prose-pc8+xml';
    public const VND_3GPP_V2X_LOCAL_SERVICE_INFORMATION = 'application/vnd.3gpp-v2x-local-service-information';
    public const VND_3GPP_5GNAS = 'application/vnd.3gpp.5gnas';
    public const VND_3GPP_ACCESS_TRANSFER_EVENTS_XML = 'application/vnd.3gpp.access-transfer-events+xml';
    public const VND_3GPP_BSF_XML = 'application/vnd.3gpp.bsf+xml';
    public const VND_3GPP_GMOP_XML = 'application/vnd.3gpp.gmop+xml';
    public const VND_3GPP_GTPC = 'application/vnd.3gpp.gtpc';
    public const VND_3GPP_INTERWORKING_DATA = 'application/vnd.3gpp.interworking-data';
    public const VND_3GPP_LPP = 'application/vnd.3gpp.lpp';
    public const VND_3GPP_MC_SIGNALLING_EAR = 'application/vnd.3gpp.mc-signalling-ear';
    public const VND_3GPP_MCDATA_AFFILIATION_COMMAND_XML = 'application/vnd.3gpp.mcdata-affiliation-command+xml';
    public const VND_3GPP_MCDATA_INFO_XML = 'application/vnd.3gpp.mcdata-info+xml';
    public const VND_3GPP_MCDATA_MSGSTORE_CTRL_REQUEST_XML = 'application/vnd.3gpp.mcdata-msgstore-ctrl-request+xml';
    public const VND_3GPP_MCDATA_PAYLOAD = 'application/vnd.3gpp.mcdata-payload';
    public const VND_3GPP_MCDATA_REGROUP_XML = 'application/vnd.3gpp.mcdata-regroup+xml';
    public const VND_3GPP_MCDATA_SERVICE_CONFIG_XML = 'application/vnd.3gpp.mcdata-service-config+xml';
    public const VND_3GPP_MCDATA_SIGNALLING = 'application/vnd.3gpp.mcdata-signalling';
    public const VND_3GPP_MCDATA_UE_CONFIG_XML = 'application/vnd.3gpp.mcdata-ue-config+xml';
    public const VND_3GPP_MCDATA_USER_PROFILE_XML = 'application/vnd.3gpp.mcdata-user-profile+xml';
    public const VND_3GPP_MCPTT_AFFILIATION_COMMAND_XML = 'application/vnd.3gpp.mcptt-affiliation-command+xml';
    public const VND_3GPP_MCPTT_FLOOR_REQUEST_XML = 'application/vnd.3gpp.mcptt-floor-request+xml';
    public const VND_3GPP_MCPTT_INFO_XML = 'application/vnd.3gpp.mcptt-info+xml';
    public const VND_3GPP_MCPTT_LOCATION_INFO_XML = 'application/vnd.3gpp.mcptt-location-info+xml';
    public const VND_3GPP_MCPTT_MBMS_USAGE_INFO_XML = 'application/vnd.3gpp.mcptt-mbms-usage-info+xml';
    public const VND_3GPP_MCPTT_SERVICE_CONFIG_XML = 'application/vnd.3gpp.mcptt-service-config+xml';
    public const VND_3GPP_MCPTT_SIGNED_XML = 'application/vnd.3gpp.mcptt-signed+xml';
    public const VND_3GPP_MCPTT_UE_CONFIG_XML = 'application/vnd.3gpp.mcptt-ue-config+xml';
    public const VND_3GPP_MCPTT_UE_INIT_CONFIG_XML = 'application/vnd.3gpp.mcptt-ue-init-config+xml';
    public const VND_3GPP_MCPTT_USER_PROFILE_XML = 'application/vnd.3gpp.mcptt-user-profile+xml';
    public const VND_3GPP_MCVIDEO_AFFILIATION_COMMAND_XML = 'application/vnd.3gpp.mcvideo-affiliation-command+xml';
    public const VND_3GPP_MCVIDEO_INFO_XML = 'application/vnd.3gpp.mcvideo-info+xml';
    public const VND_3GPP_MCVIDEO_LOCATION_INFO_XML = 'application/vnd.3gpp.mcvideo-location-info+xml';
    public const VND_3GPP_MCVIDEO_MBMS_USAGE_INFO_XML = 'application/vnd.3gpp.mcvideo-mbms-usage-info+xml';
    public const VND_3GPP_MCVIDEO_SERVICE_CONFIG_XML = 'application/vnd.3gpp.mcvideo-service-config+xml';
    public const VND_3GPP_MCVIDEO_TRANSMISSION_REQUEST_XML = 'application/vnd.3gpp.mcvideo-transmission-request+xml';
    public const VND_3GPP_MCVIDEO_UE_CONFIG_XML = 'application/vnd.3gpp.mcvideo-ue-config+xml';
    public const VND_3GPP_MCVIDEO_USER_PROFILE_XML = 'application/vnd.3gpp.mcvideo-user-profile+xml';
    public const VND_3GPP_MID_CALL_XML = 'application/vnd.3gpp.mid-call+xml';
    public const VND_3GPP_NGAP = 'application/vnd.3gpp.ngap';
    public const VND_3GPP_PFCP = 'application/vnd.3gpp.pfcp';
    public const PLB = 'application/vnd.3gpp.pic-bw-large';
    public const PSB = 'application/vnd.3gpp.pic-bw-small';
    public const PVB = 'application/vnd.3gpp.pic-bw-var';
    public const VND_3GPP_S1AP = 'application/vnd.3gpp.s1ap';
    public const VND_3GPP_SEAL_INFO_XML = 'application/vnd.3gpp.seal-info+xml';
    public const VND_3GPP_SEAL_LOCATION_INFO_XML = 'application/vnd.3gpp.seal-location-info+xml';
    public const VND_3GPP_SMS = 'application/vnd.3gpp.sms';
    public const VND_3GPP_SMS_XML = 'application/vnd.3gpp.sms+xml';
    public const VND_3GPP_SRVCC_EXT_XML = 'application/vnd.3gpp.srvcc-ext+xml';
    public const VND_3GPP_SRVCC_INFO_XML = 'application/vnd.3gpp.srvcc-info+xml';
    public const VND_3GPP_STATE_AND_EVENT_INFO_XML = 'application/vnd.3gpp.state-and-event-info+xml';
    public const VND_3GPP_USSD_XML = 'application/vnd.3gpp.ussd+xml';
    public const VND_3GPP_VAE_INFO_XML = 'application/vnd.3gpp.vae-info+xml';
    public const VND_3GPP2_BCMCSINFO_XML = 'application/vnd.3gpp2.bcmcsinfo+xml';
    public const VND_3GPP2_SMS = 'application/vnd.3gpp2.sms';
    public const TCAP = 'application/vnd.3gpp2.tcap';
    public const VND_3LIGHTSSOFTWARE_IMAGESCAL = 'application/vnd.3lightssoftware.imagescal';
    public const PWN = 'application/vnd.3m.post-it-notes';
    public const ASO = 'application/vnd.accpac.simply.aso';
    public const IMP = 'application/vnd.accpac.simply.imp';
    public const ACU = 'application/vnd.acucobol';
    public const ATC = 'application/vnd.acucorp';
    public const ACUTC = self::ATC;
    public const AIR = 'application/vnd.adobe.air-application-installer-package+zip';
    public const VND_ADOBE_FLASH_MOVIE = 'application/vnd.adobe.flash.movie';
    public const FCDT = 'application/vnd.adobe.formscentral.fcdt';
    public const FXP = 'application/vnd.adobe.fxp';
    public const FXPL = self::FXP;
    public const VND_ADOBE_PARTIAL_UPLOAD = 'application/vnd.adobe.partial-upload';
    public const XDP = 'application/vnd.adobe.xdp+xml';
    public const XFDF = 'application/vnd.adobe.xfdf';
    public const VND_AETHER_IMP = 'application/vnd.aether.imp';
    public const VND_AFPC_AFPLINEDATA = 'application/vnd.afpc.afplinedata';
    public const VND_AFPC_AFPLINEDATA_PAGEDEF = 'application/vnd.afpc.afplinedata-pagedef';
    public const VND_AFPC_CMOCA_CMRESOURCE = 'application/vnd.afpc.cmoca-cmresource';
    public const VND_AFPC_FOCA_CHARSET = 'application/vnd.afpc.foca-charset';
    public const VND_AFPC_FOCA_CODEDFONT = 'application/vnd.afpc.foca-codedfont';
    public const VND_AFPC_FOCA_CODEPAGE = 'application/vnd.afpc.foca-codepage';
    public const VND_AFPC_MODCA = 'application/vnd.afpc.modca';
    public const VND_AFPC_MODCA_CMTABLE = 'application/vnd.afpc.modca-cmtable';
    public const VND_AFPC_MODCA_FORMDEF = 'application/vnd.afpc.modca-formdef';
    public const VND_AFPC_MODCA_MEDIUMMAP = 'application/vnd.afpc.modca-mediummap';
    public const VND_AFPC_MODCA_OBJECTCONTAINER = 'application/vnd.afpc.modca-objectcontainer';
    public const VND_AFPC_MODCA_OVERLAY = 'application/vnd.afpc.modca-overlay';
    public const VND_AFPC_MODCA_PAGESEGMENT = 'application/vnd.afpc.modca-pagesegment';
    public const AGE = 'application/vnd.age';
    public const VND_AH_BARCODE = 'application/vnd.ah-barcode';
    public const AHEAD = 'application/vnd.ahead.space';
    public const AZF = 'application/vnd.airzip.filesecure.azf';
    public const AZS = 'application/vnd.airzip.filesecure.azs';
    public const VND_AMADEUS_JSON = 'application/vnd.amadeus+json';
    public const AZW = 'application/vnd.amazon.ebook';
    public const VND_AMAZON_MOBI8_EBOOK = 'application/vnd.amazon.mobi8-ebook';
    public const ACC = 'application/vnd.americandynamics.acc';
    public const AMI = 'application/vnd.amiga.ami';
    public const VND_AMUNDSEN_MAZE_XML = 'application/vnd.amundsen.maze+xml';
    public const VND_ANDROID_OTA = 'application/vnd.android.ota';
    public const APK = 'application/vnd.android.package-archive';
    public const VND_ANKI = 'application/vnd.anki';
    public const CII = 'application/vnd.anser-web-certificate-issue-initiation';
    public const FTI = 'application/vnd.anser-web-funds-transfer-initiation';
    public const ATX = 'application/vnd.antix.game-component';
    public const VND_APACHE_ARROW_FILE = 'application/vnd.apache.arrow.file';
    public const VND_APACHE_ARROW_STREAM = 'application/vnd.apache.arrow.stream';
    public const VND_APACHE_THRIFT_BINARY = 'application/vnd.apache.thrift.binary';
    public const VND_APACHE_THRIFT_COMPACT = 'application/vnd.apache.thrift.compact';
    public const VND_APACHE_THRIFT_JSON = 'application/vnd.apache.thrift.json';
    public const VND_APEXLANG = 'application/vnd.apexlang';
    public const VND_API_JSON = 'application/vnd.api+json';
    public const VND_APLEXTOR_WARRP_JSON = 'application/vnd.aplextor.warrp+json';
    public const VND_APOTHEKENDE_RESERVATION_JSON = 'application/vnd.apothekende.reservation+json';
    public const MPKG = 'application/vnd.apple.installer+xml';
    public const KEY = 'application/vnd.apple.keynote';
    public const NUMBERS = 'application/vnd.apple.numbers';
    public const PAGES = 'application/vnd.apple.pages';
    public const PKPASS = 'application/vnd.apple.pkpass';
    public const VND_ARASTRA_SWI = 'application/vnd.arastra.swi';
    public const SWI = 'application/vnd.aristanetworks.swi';
    public const VND_ARTISAN_JSON = 'application/vnd.artisan+json';
    public const VND_ARTSQUARE = 'application/vnd.artsquare';
    public const IOTA = 'application/vnd.astraea-software.iota';
    public const AEP = 'application/vnd.audiograph';
    public const VND_AUTOPACKAGE = 'application/vnd.autopackage';
    public const VND_AVALON_JSON = 'application/vnd.avalon+json';
    public const VND_AVISTAR_XML = 'application/vnd.avistar+xml';
    public const BMML = 'application/vnd.balsamiq.bmml+xml';
    public const VND_BALSAMIQ_BMPR = 'application/vnd.balsamiq.bmpr';
    public const VND_BANANA_ACCOUNTING = 'application/vnd.banana-accounting';
    public const VND_BBF_USP_ERROR = 'application/vnd.bbf.usp.error';
    public const VND_BBF_USP_MSG = 'application/vnd.bbf.usp.msg';
    public const VND_BBF_USP_MSG_JSON = 'application/vnd.bbf.usp.msg+json';
    public const VND_BEKITZUR_STECH_JSON = 'application/vnd.bekitzur-stech+json';
    public const VND_BELIGHTSOFT_LHZD_ZIP = 'application/vnd.belightsoft.lhzd+zip';
    public const VND_BELIGHTSOFT_LHZL_ZIP = 'application/vnd.belightsoft.lhzl+zip';
    public const VND_BINT_MED_CONTENT = 'application/vnd.bint.med-content';
    public const VND_BIOPAX_RDF_XML = 'application/vnd.biopax.rdf+xml';
    public const VND_BLINK_IDB_VALUE_WRAPPER = 'application/vnd.blink-idb-value-wrapper';
    public const MPM = 'application/vnd.blueice.multipass';
    public const VND_BLUETOOTH_EP_OOB = 'application/vnd.bluetooth.ep.oob';
    public const VND_BLUETOOTH_LE_OOB = 'application/vnd.bluetooth.le.oob';
    public const BMI = 'application/vnd.bmi';
    public const VND_BPF = 'application/vnd.bpf';
    public const VND_BPF3 = 'application/vnd.bpf3';
    public const REP = 'application/vnd.businessobjects';
    public const VND_BYU_UAPI_JSON = 'application/vnd.byu.uapi+json';
    public const VND_CAB_JSCRIPT = 'application/vnd.cab-jscript';
    public const VND_CANON_CPDL = 'application/vnd.canon-cpdl';
    public const VND_CANON_LIPS = 'application/vnd.canon-lips';
    public const VND_CAPASYSTEMS_PG_JSON = 'application/vnd.capasystems-pg+json';
    public const VND_CENDIO_THINLINC_CLIENTCONF = 'application/vnd.cendio.thinlinc.clientconf';
    public const VND_CENTURY_SYSTEMS_TCP_STREAM = 'application/vnd.century-systems.tcp_stream';
    public const CDXML = 'application/vnd.chemdraw+xml';
    public const VND_CHESS_PGN = 'application/vnd.chess-pgn';
    public const MMD = 'application/vnd.chipnuts.karaoke-mmd';
    public const VND_CIEDI = 'application/vnd.ciedi';
    public const CDY = 'application/vnd.cinderella';
    public const VND_CIRPACK_ISDN_EXT = 'application/vnd.cirpack.isdn-ext';
    public const CSL = 'application/vnd.citationstyles.style+xml';
    public const CLA = 'application/vnd.claymore';
    public const RP9 = 'application/vnd.cloanto.rp9';
    public const C4G = 'application/vnd.clonk.c4group';
    public const C4D = self::C4G;
    public const C4F = self::C4G;
    public const C4P = self::C4G;
    public const C4U = self::C4G;
    public const C11AMC = 'application/vnd.cluetrust.cartomobile-config';
    public const C11AMZ = 'application/vnd.cluetrust.cartomobile-config-pkg';
    public const VND_CNCF_HELM_CHART_CONTENT_V1_TAR_GZIP = 'application/vnd.cncf.helm.chart.content.v1.tar+gzip';
    public const VND_CNCF_HELM_CHART_PROVENANCE_V1_PROV = 'application/vnd.cncf.helm.chart.provenance.v1.prov';
    public const VND_COFFEESCRIPT = 'application/vnd.coffeescript';
    public const VND_COLLABIO_XODOCUMENTS_DOCUMENT = 'application/vnd.collabio.xodocuments.document';
    public const VND_COLLABIO_XODOCUMENTS_DOCUMENT_TEMPLATE = 'application/vnd.collabio.xodocuments.document-template';
    public const VND_COLLABIO_XODOCUMENTS_PRESENTATION = 'application/vnd.collabio.xodocuments.presentation';
    public const VND_COLLABIO_XODOCUMENTS_PRESENTATION_TEMPLATE = 'application/vnd.collabio.xodocuments.presentation-template';
    public const VND_COLLABIO_XODOCUMENTS_SPREADSHEET = 'application/vnd.collabio.xodocuments.spreadsheet';
    public const VND_COLLABIO_XODOCUMENTS_SPREADSHEET_TEMPLATE = 'application/vnd.collabio.xodocuments.spreadsheet-template';
    public const VND_COLLECTION_JSON = 'application/vnd.collection+json';
    public const VND_COLLECTION_DOC_JSON = 'application/vnd.collection.doc+json';
    public const VND_COLLECTION_NEXT_JSON = 'application/vnd.collection.next+json';
    public const VND_COMICBOOK_ZIP = 'application/vnd.comicbook+zip';
    public const VND_COMICBOOK_RAR = 'application/vnd.comicbook-rar';
    public const VND_COMMERCE_BATTELLE = 'application/vnd.commerce-battelle';
    public const CSP = 'application/vnd.commonspace';
    public const CDBCMSG = 'application/vnd.contact.cmsg';
    public const VND_COREOS_IGNITION_JSON = 'application/vnd.coreos.ignition+json';
    public const CMC = 'application/vnd.cosmocaller';
    public const CLKX = 'application/vnd.crick.clicker';
    public const CLKK = 'application/vnd.crick.clicker.keyboard';
    public const CLKP = 'application/vnd.crick.clicker.palette';
    public const CLKT = 'application/vnd.crick.clicker.template';
    public const CLKW = 'application/vnd.crick.clicker.wordbank';
    public const WBS = 'application/vnd.criticaltools.wbs+xml';
    public const VND_CRYPTII_PIPE_JSON = 'application/vnd.cryptii.pipe+json';
    public const VND_CRYPTO_SHADE_FILE = 'application/vnd.crypto-shade-file';
    public const VND_CRYPTOMATOR_ENCRYPTED = 'application/vnd.cryptomator.encrypted';
    public const VND_CRYPTOMATOR_VAULT = 'application/vnd.cryptomator.vault';
    public const PML = 'application/vnd.ctc-posml';
    public const VND_CTCT_WS_XML = 'application/vnd.ctct.ws+xml';
    public const VND_CUPS_PDF = 'application/vnd.cups-pdf';
    public const VND_CUPS_POSTSCRIPT = 'application/vnd.cups-postscript';
    public const PPD = 'application/vnd.cups-ppd';
    public const VND_CUPS_RASTER = 'application/vnd.cups-raster';
    public const VND_CUPS_RAW = 'application/vnd.cups-raw';
    public const VND_CURL = 'application/vnd.curl';
    public const CAR = 'application/vnd.curl.car';
    public const PCURL = 'application/vnd.curl.pcurl';
    public const VND_CYAN_DEAN_ROOT_XML = 'application/vnd.cyan.dean.root+xml';
    public const VND_CYBANK = 'application/vnd.cybank';
    public const VND_CYCLONEDX_JSON = 'application/vnd.cyclonedx+json';
    public const VND_CYCLONEDX_XML = 'application/vnd.cyclonedx+xml';
    public const VND_D2L_COURSEPACKAGE1P0_ZIP = 'application/vnd.d2l.coursepackage1p0+zip';
    public const VND_D3M_DATASET = 'application/vnd.d3m-dataset';
    public const VND_D3M_PROBLEM = 'application/vnd.d3m-problem';
    public const RDZ = 'application/vnd.data-vision.rdz';
    public const VND_DATALOG = 'application/vnd.datalog';
    public const VND_DATAPACKAGE_JSON = 'application/vnd.datapackage+json';
    public const VND_DATARESOURCE_JSON = 'application/vnd.dataresource+json';
    public const DBF = 'application/vnd.dbf';
    public const VND_DEBIAN_BINARY_PACKAGE = 'application/vnd.debian.binary-package';
    public const UVF = 'application/vnd.dece.data';
    public const UVVF = self::UVF;
    public const UVD = self::UVF;
    public const UVVD = self::UVF;
    public const UVT = 'application/vnd.dece.ttml+xml';
    public const UVVT = self::UVT;
    public const UVX = 'application/vnd.dece.unspecified';
    public const UVVX = self::UVX;
    public const UVZ = 'application/vnd.dece.zip';
    public const UVVZ = self::UVZ;
    public const FE_LAUNCH = 'application/vnd.denovo.fcselayout-link';
    public const VND_DESMUME_MOVIE = 'application/vnd.desmume.movie';
    public const VND_DIR_BI_PLATE_DL_NOSUFFIX = 'application/vnd.dir-bi.plate-dl-nosuffix';
    public const VND_DM_DELEGATION_XML = 'application/vnd.dm.delegation+xml';
    public const DNA = 'application/vnd.dna';
    public const VND_DOCUMENT_JSON = 'application/vnd.document+json';
    public const MLP = 'application/vnd.dolby.mlp';
    public const VND_DOLBY_MOBILE_1 = 'application/vnd.dolby.mobile.1';
    public const VND_DOLBY_MOBILE_2 = 'application/vnd.dolby.mobile.2';
    public const VND_DOREMIR_SCORECLOUD_BINARY_DOCUMENT = 'application/vnd.doremir.scorecloud-binary-document';
    public const DPG = 'application/vnd.dpgraph';
    public const DFAC = 'application/vnd.dreamfactory';
    public const VND_DRIVE_JSON = 'application/vnd.drive+json';
    public const KPXX = 'application/vnd.ds-keypoint';
    public const VND_DTG_LOCAL = 'application/vnd.dtg.local';
    public const VND_DTG_LOCAL_FLASH = 'application/vnd.dtg.local.flash';
    public const VND_DTG_LOCAL_HTML = 'application/vnd.dtg.local.html';
    public const AIT = 'application/vnd.dvb.ait';
    public const VND_DVB_DVBISL_XML = 'application/vnd.dvb.dvbisl+xml';
    public const VND_DVB_DVBJ = 'application/vnd.dvb.dvbj';
    public const VND_DVB_ESGCONTAINER = 'application/vnd.dvb.esgcontainer';
    public const VND_DVB_IPDCDFTNOTIFACCESS = 'application/vnd.dvb.ipdcdftnotifaccess';
    public const VND_DVB_IPDCESGACCESS = 'application/vnd.dvb.ipdcesgaccess';
    public const VND_DVB_IPDCESGACCESS2 = 'application/vnd.dvb.ipdcesgaccess2';
    public const VND_DVB_IPDCESGPDD = 'application/vnd.dvb.ipdcesgpdd';
    public const VND_DVB_IPDCROAMING = 'application/vnd.dvb.ipdcroaming';
    public const VND_DVB_IPTV_ALFEC_BASE = 'application/vnd.dvb.iptv.alfec-base';
    public const VND_DVB_IPTV_ALFEC_ENHANCEMENT = 'application/vnd.dvb.iptv.alfec-enhancement';
    public const VND_DVB_NOTIF_AGGREGATE_ROOT_XML = 'application/vnd.dvb.notif-aggregate-root+xml';
    public const VND_DVB_NOTIF_CONTAINER_XML = 'application/vnd.dvb.notif-container+xml';
    public const VND_DVB_NOTIF_GENERIC_XML = 'application/vnd.dvb.notif-generic+xml';
    public const VND_DVB_NOTIF_IA_MSGLIST_XML = 'application/vnd.dvb.notif-ia-msglist+xml';
    public const VND_DVB_NOTIF_IA_REGISTRATION_REQUEST_XML = 'application/vnd.dvb.notif-ia-registration-request+xml';
    public const VND_DVB_NOTIF_IA_REGISTRATION_RESPONSE_XML = 'application/vnd.dvb.notif-ia-registration-response+xml';
    public const VND_DVB_NOTIF_INIT_XML = 'application/vnd.dvb.notif-init+xml';
    public const VND_DVB_PFR = 'application/vnd.dvb.pfr';
    public const SVC = 'application/vnd.dvb.service';
    public const VND_DXR = 'application/vnd.dxr';
    public const GEO = 'application/vnd.dynageo';
    public const VND_DZR = 'application/vnd.dzr';
    public const VND_EASYKARAOKE_CDGDOWNLOAD = 'application/vnd.easykaraoke.cdgdownload';
    public const VND_ECDIS_UPDATE = 'application/vnd.ecdis-update';
    public const VND_ECIP_RLP = 'application/vnd.ecip.rlp';
    public const VND_ECLIPSE_DITTO_JSON = 'application/vnd.eclipse.ditto+json';
    public const MAG = 'application/vnd.ecowin.chart';
    public const VND_ECOWIN_FILEREQUEST = 'application/vnd.ecowin.filerequest';
    public const VND_ECOWIN_FILEUPDATE = 'application/vnd.ecowin.fileupdate';
    public const VND_ECOWIN_SERIES = 'application/vnd.ecowin.series';
    public const VND_ECOWIN_SERIESREQUEST = 'application/vnd.ecowin.seriesrequest';
    public const VND_ECOWIN_SERIESUPDATE = 'application/vnd.ecowin.seriesupdate';
    public const VND_EFI_IMG = 'application/vnd.efi.img';
    public const VND_EFI_ISO = 'application/vnd.efi.iso';
    public const VND_ELN_ZIP = 'application/vnd.eln+zip';
    public const VND_EMCLIENT_ACCESSREQUEST_XML = 'application/vnd.emclient.accessrequest+xml';
    public const NML = 'application/vnd.enliven';
    public const VND_ENPHASE_ENVOY = 'application/vnd.enphase.envoy';
    public const VND_EPRINTS_DATA_XML = 'application/vnd.eprints.data+xml';
    public const ESF = 'application/vnd.epson.esf';
    public const MSF = 'application/vnd.epson.msf';
    public const QAM = 'application/vnd.epson.quickanime';
    public const SLT = 'application/vnd.epson.salt';
    public const SSF = 'application/vnd.epson.ssf';
    public const VND_ERICSSON_QUICKCALL = 'application/vnd.ericsson.quickcall';
    public const VND_ESPASS_ESPASS_ZIP = 'application/vnd.espass-espass+zip';
    public const ES3 = 'application/vnd.eszigno3+xml';
    public const ET3 = self::ES3;
    public const VND_ETSI_AOC_XML = 'application/vnd.etsi.aoc+xml';
    public const VND_ETSI_ASIC_E_ZIP = 'application/vnd.etsi.asic-e+zip';
    public const VND_ETSI_ASIC_S_ZIP = 'application/vnd.etsi.asic-s+zip';
    public const VND_ETSI_CUG_XML = 'application/vnd.etsi.cug+xml';
    public const VND_ETSI_IPTVCOMMAND_XML = 'application/vnd.etsi.iptvcommand+xml';
    public const VND_ETSI_IPTVDISCOVERY_XML = 'application/vnd.etsi.iptvdiscovery+xml';
    public const VND_ETSI_IPTVPROFILE_XML = 'application/vnd.etsi.iptvprofile+xml';
    public const VND_ETSI_IPTVSAD_BC_XML = 'application/vnd.etsi.iptvsad-bc+xml';
    public const VND_ETSI_IPTVSAD_COD_XML = 'application/vnd.etsi.iptvsad-cod+xml';
    public const VND_ETSI_IPTVSAD_NPVR_XML = 'application/vnd.etsi.iptvsad-npvr+xml';
    public const VND_ETSI_IPTVSERVICE_XML = 'application/vnd.etsi.iptvservice+xml';
    public const VND_ETSI_IPTVSYNC_XML = 'application/vnd.etsi.iptvsync+xml';
    public const VND_ETSI_IPTVUEPROFILE_XML = 'application/vnd.etsi.iptvueprofile+xml';
    public const VND_ETSI_MCID_XML = 'application/vnd.etsi.mcid+xml';
    public const VND_ETSI_MHEG5 = 'application/vnd.etsi.mheg5';
    public const VND_ETSI_OVERLOAD_CONTROL_POLICY_DATASET_XML = 'application/vnd.etsi.overload-control-policy-dataset+xml';
    public const VND_ETSI_PSTN_XML = 'application/vnd.etsi.pstn+xml';
    public const VND_ETSI_SCI_XML = 'application/vnd.etsi.sci+xml';
    public const VND_ETSI_SIMSERVS_XML = 'application/vnd.etsi.simservs+xml';
    public const VND_ETSI_TIMESTAMP_TOKEN = 'application/vnd.etsi.timestamp-token';
    public const VND_ETSI_TSL_XML = 'application/vnd.etsi.tsl+xml';
    public const VND_ETSI_TSL_DER = 'application/vnd.etsi.tsl.der';
    public const VND_EU_KASPARIAN_CAR_JSON = 'application/vnd.eu.kasparian.car+json';
    public const VND_EUDORA_DATA = 'application/vnd.eudora.data';
    public const VND_EVOLV_ECIG_PROFILE = 'application/vnd.evolv.ecig.profile';
    public const VND_EVOLV_ECIG_SETTINGS = 'application/vnd.evolv.ecig.settings';
    public const VND_EVOLV_ECIG_THEME = 'application/vnd.evolv.ecig.theme';
    public const VND_EXSTREAM_EMPOWER_ZIP = 'application/vnd.exstream-empower+zip';
    public const VND_EXSTREAM_PACKAGE = 'application/vnd.exstream-package';
    public const EZ2 = 'application/vnd.ezpix-album';
    public const EZ3 = 'application/vnd.ezpix-package';
    public const VND_F_SECURE_MOBILE = 'application/vnd.f-secure.mobile';
    public const VND_FAMILYSEARCH_GEDCOM_ZIP = 'application/vnd.familysearch.gedcom+zip';
    public const VND_FASTCOPY_DISK_IMAGE = 'application/vnd.fastcopy-disk-image';
    public const MSEED = 'application/vnd.fdsn.mseed';
    public const SEED = 'application/vnd.fdsn.seed';
    public const DATALESS = self::SEED;
    public const VND_FFSNS = 'application/vnd.ffsns';
    public const VND_FICLAB_FLB_ZIP = 'application/vnd.ficlab.flb+zip';
    public const VND_FILMIT_ZFC = 'application/vnd.filmit.zfc';
    public const VND_FINTS = 'application/vnd.fints';
    public const VND_FIREMONKEYS_CLOUDCELL = 'application/vnd.firemonkeys.cloudcell';
    public const GPH = 'application/vnd.flographit';
    public const FTC = 'application/vnd.fluxtime.clip';
    public const VND_FONT_FONTFORGE_SFD = 'application/vnd.font-fontforge-sfd';
    public const FM = 'application/vnd.framemaker';
    public const FRAME = self::FM;
    public const MAKER = self::FM;
    public const BOOK = self::FM;
    public const FNC = 'application/vnd.frogans.fnc';
    public const LTF = 'application/vnd.frogans.ltf';
    public const FSC = 'application/vnd.fsc.weblaunch';
    public const VND_FUJIFILM_FB_DOCUWORKS = 'application/vnd.fujifilm.fb.docuworks';
    public const VND_FUJIFILM_FB_DOCUWORKS_BINDER = 'application/vnd.fujifilm.fb.docuworks.binder';
    public const VND_FUJIFILM_FB_DOCUWORKS_CONTAINER = 'application/vnd.fujifilm.fb.docuworks.container';
    public const VND_FUJIFILM_FB_JFI_XML = 'application/vnd.fujifilm.fb.jfi+xml';
    public const OAS = 'application/vnd.fujitsu.oasys';
    public const OA2 = 'application/vnd.fujitsu.oasys2';
    public const OA3 = 'application/vnd.fujitsu.oasys3';
    public const FG5 = 'application/vnd.fujitsu.oasysgp';
    public const BH2 = 'application/vnd.fujitsu.oasysprs';
    public const VND_FUJIXEROX_ART_EX = 'application/vnd.fujixerox.art-ex';
    public const VND_FUJIXEROX_ART4 = 'application/vnd.fujixerox.art4';
    public const DDD = 'application/vnd.fujixerox.ddd';
    public const XDW = 'application/vnd.fujixerox.docuworks';
    public const XBD = 'application/vnd.fujixerox.docuworks.binder';
    public const VND_FUJIXEROX_DOCUWORKS_CONTAINER = 'application/vnd.fujixerox.docuworks.container';
    public const VND_FUJIXEROX_HBPL = 'application/vnd.fujixerox.hbpl';
    public const VND_FUT_MISNET = 'application/vnd.fut-misnet';
    public const VND_FUTOIN_CBOR = 'application/vnd.futoin+cbor';
    public const VND_FUTOIN_JSON = 'application/vnd.futoin+json';
    public const FZS = 'application/vnd.fuzzysheet';
    public const TXD = 'application/vnd.genomatix.tuxedo';
    public const VND_GENOZIP = 'application/vnd.genozip';
    public const VND_GENTICS_GRD_JSON = 'application/vnd.gentics.grd+json';
    public const VND_GENTOO_CATMETADATA_XML = 'application/vnd.gentoo.catmetadata+xml';
    public const VND_GENTOO_EBUILD = 'application/vnd.gentoo.ebuild';
    public const VND_GENTOO_ECLASS = 'application/vnd.gentoo.eclass';
    public const VND_GENTOO_GPKG = 'application/vnd.gentoo.gpkg';
    public const VND_GENTOO_MANIFEST = 'application/vnd.gentoo.manifest';
    public const VND_GENTOO_PKGMETADATA_XML = 'application/vnd.gentoo.pkgmetadata+xml';
    public const VND_GENTOO_XPAK = 'application/vnd.gentoo.xpak';
    public const VND_GEO_JSON = 'application/vnd.geo+json';
    public const VND_GEOCUBE_XML = 'application/vnd.geocube+xml';
    public const GGB = 'application/vnd.geogebra.file';
    public const VND_GEOGEBRA_SLIDES = 'application/vnd.geogebra.slides';
    public const GGT = 'application/vnd.geogebra.tool';
    public const GEX = 'application/vnd.geometry-explorer';
    public const GRE = self::GEX;
    public const GXT = 'application/vnd.geonext';
    public const G2W = 'application/vnd.geoplan';
    public const G3W = 'application/vnd.geospace';
    public const VND_GERBER = 'application/vnd.gerber';
    public const VND_GLOBALPLATFORM_CARD_CONTENT_MGT = 'application/vnd.globalplatform.card-content-mgt';
    public const VND_GLOBALPLATFORM_CARD_CONTENT_MGT_RESPONSE = 'application/vnd.globalplatform.card-content-mgt-response';
    public const GMX = 'application/vnd.gmx';
    public const VND_GNU_TALER_EXCHANGE_JSON = 'application/vnd.gnu.taler.exchange+json';
    public const VND_GNU_TALER_MERCHANT_JSON = 'application/vnd.gnu.taler.merchant+json';
    public const GDOC = 'application/vnd.google-apps.document';
    public const GSLIDES = 'application/vnd.google-apps.presentation';
    public const GSHEET = 'application/vnd.google-apps.spreadsheet';
    public const VND_GOV_SK_E_FORM_XML = 'application/vnd.gov.sk.e-form+xml';
    public const VND_GOV_SK_E_FORM_ZIP = 'application/vnd.gov.sk.e-form+zip';
    public const VND_GOV_SK_XMLDATACONTAINER_XML = 'application/vnd.gov.sk.xmldatacontainer+xml';
    public const VND_GPXSEE_MAP_XML = 'application/vnd.gpxsee.map+xml';
    public const GQF = 'application/vnd.grafeq';
    public const GQS = self::GQF;
    public const VND_GRIDMP = 'application/vnd.gridmp';
    public const GAC = 'application/vnd.groove-account';
    public const GHF = 'application/vnd.groove-help';
    public const GIM = 'application/vnd.groove-identity-message';
    public const GRV = 'application/vnd.groove-injector';
    public const GTM = 'application/vnd.groove-tool-message';
    public const TPL = 'application/vnd.groove-tool-template';
    public const VCG = 'application/vnd.groove-vcard';
    public const VND_HAL_JSON = 'application/vnd.hal+json';
    public const HAL = 'application/vnd.hal+xml';
    public const ZMM = 'application/vnd.handheld-entertainment+xml';
    public const HBCI = 'application/vnd.hbci';
    public const VND_HC_JSON = 'application/vnd.hc+json';
    public const VND_HCL_BIREPORTS = 'application/vnd.hcl-bireports';
    public const VND_HDT = 'application/vnd.hdt';
    public const VND_HEROKU_JSON = 'application/vnd.heroku+json';
    public const LES = 'application/vnd.hhe.lesson-player';
    public const HPGL = 'application/vnd.hp-hpgl';
    public const HPID = 'application/vnd.hp-hpid';
    public const HPS = 'application/vnd.hp-hps';
    public const JLT = 'application/vnd.hp-jlyt';
    public const PCL = 'application/vnd.hp-pcl';
    public const PCLXL = 'application/vnd.hp-pclxl';
    public const VND_HSL = 'application/vnd.hsl';
    public const VND_HTTPHONE = 'application/vnd.httphone';
    public const SFD_HDSTX = 'application/vnd.hydrostatix.sof-data';
    public const VND_HYPER_JSON = 'application/vnd.hyper+json';
    public const VND_HYPER_ITEM_JSON = 'application/vnd.hyper-item+json';
    public const VND_HYPERDRIVE_JSON = 'application/vnd.hyperdrive+json';
    public const VND_HZN_3D_CROSSWORD = 'application/vnd.hzn-3d-crossword';
    public const VND_IBM_AFPLINEDATA = 'application/vnd.ibm.afplinedata';
    public const VND_IBM_ELECTRONIC_MEDIA = 'application/vnd.ibm.electronic-media';
    public const MPY = 'application/vnd.ibm.minipay';
    public const AFP = 'application/vnd.ibm.modcap';
    public const LISTAFP = self::AFP;
    public const LIST3820 = self::AFP;
    public const IRM = 'application/vnd.ibm.rights-management';
    public const SC = 'application/vnd.ibm.secure-container';
    public const ICC = 'application/vnd.iccprofile';
    public const ICM = self::ICC;
    public const VND_IEEE_1905 = 'application/vnd.ieee.1905';
    public const IGL = 'application/vnd.igloader';
    public const VND_IMAGEMETER_FOLDER_ZIP = 'application/vnd.imagemeter.folder+zip';
    public const VND_IMAGEMETER_IMAGE_ZIP = 'application/vnd.imagemeter.image+zip';
    public const IVP = 'application/vnd.immervision-ivp';
    public const IVU = 'application/vnd.immervision-ivu';
    public const VND_IMS_IMSCCV1P1 = 'application/vnd.ims.imsccv1p1';
    public const VND_IMS_IMSCCV1P2 = 'application/vnd.ims.imsccv1p2';
    public const VND_IMS_IMSCCV1P3 = 'application/vnd.ims.imsccv1p3';
    public const VND_IMS_LIS_V2_RESULT_JSON = 'application/vnd.ims.lis.v2.result+json';
    public const VND_IMS_LTI_V2_TOOLCONSUMERPROFILE_JSON = 'application/vnd.ims.lti.v2.toolconsumerprofile+json';
    public const VND_IMS_LTI_V2_TOOLPROXY_JSON = 'application/vnd.ims.lti.v2.toolproxy+json';
    public const VND_IMS_LTI_V2_TOOLPROXY_ID_JSON = 'application/vnd.ims.lti.v2.toolproxy.id+json';
    public const VND_IMS_LTI_V2_TOOLSETTINGS_JSON = 'application/vnd.ims.lti.v2.toolsettings+json';
    public const VND_IMS_LTI_V2_TOOLSETTINGS_SIMPLE_JSON = 'application/vnd.ims.lti.v2.toolsettings.simple+json';
    public const VND_INFORMEDCONTROL_RMS_XML = 'application/vnd.informedcontrol.rms+xml';
    public const VND_INFORMIX_VISIONARY = 'application/vnd.informix-visionary';
    public const VND_INFOTECH_PROJECT = 'application/vnd.infotech.project';
    public const VND_INFOTECH_PROJECT_XML = 'application/vnd.infotech.project+xml';
    public const VND_INNOPATH_WAMP_NOTIFICATION = 'application/vnd.innopath.wamp.notification';
    public const IGM = 'application/vnd.insors.igm';
    public const XPW = 'application/vnd.intercon.formnet';
    public const XPX = self::XPW;
    public const I2G = 'application/vnd.intergeo';
    public const VND_INTERTRUST_DIGIBOX = 'application/vnd.intertrust.digibox';
    public const VND_INTERTRUST_NNCP = 'application/vnd.intertrust.nncp';
    public const QBO = 'application/vnd.intu.qbo';
    public const QFX = 'application/vnd.intu.qfx';
    public const VND_IPLD_CAR = 'application/vnd.ipld.car';
    public const VND_IPLD_DAG_CBOR = 'application/vnd.ipld.dag-cbor';
    public const VND_IPLD_DAG_JSON = 'application/vnd.ipld.dag-json';
    public const VND_IPLD_RAW = 'application/vnd.ipld.raw';
    public const VND_IPTC_G2_CATALOGITEM_XML = 'application/vnd.iptc.g2.catalogitem+xml';
    public const VND_IPTC_G2_CONCEPTITEM_XML = 'application/vnd.iptc.g2.conceptitem+xml';
    public const VND_IPTC_G2_KNOWLEDGEITEM_XML = 'application/vnd.iptc.g2.knowledgeitem+xml';
    public const VND_IPTC_G2_NEWSITEM_XML = 'application/vnd.iptc.g2.newsitem+xml';
    public const VND_IPTC_G2_NEWSMESSAGE_XML = 'application/vnd.iptc.g2.newsmessage+xml';
    public const VND_IPTC_G2_PACKAGEITEM_XML = 'application/vnd.iptc.g2.packageitem+xml';
    public const VND_IPTC_G2_PLANNINGITEM_XML = 'application/vnd.iptc.g2.planningitem+xml';
    public const RCPROFILE = 'application/vnd.ipunplugged.rcprofile';
    public const IRP = 'application/vnd.irepository.package+xml';
    public const XPR = 'application/vnd.is-xpr';
    public const FCS = 'application/vnd.isac.fcs';
    public const VND_ISO11783_10_ZIP = 'application/vnd.iso11783-10+zip';
    public const JAM = 'application/vnd.jam';
    public const VND_JAPANNET_DIRECTORY_SERVICE = 'application/vnd.japannet-directory-service';
    public const VND_JAPANNET_JPNSTORE_WAKEUP = 'application/vnd.japannet-jpnstore-wakeup';
    public const VND_JAPANNET_PAYMENT_WAKEUP = 'application/vnd.japannet-payment-wakeup';
    public const VND_JAPANNET_REGISTRATION = 'application/vnd.japannet-registration';
    public const VND_JAPANNET_REGISTRATION_WAKEUP = 'application/vnd.japannet-registration-wakeup';
    public const VND_JAPANNET_SETSTORE_WAKEUP = 'application/vnd.japannet-setstore-wakeup';
    public const VND_JAPANNET_VERIFICATION = 'application/vnd.japannet-verification';
    public const VND_JAPANNET_VERIFICATION_WAKEUP = 'application/vnd.japannet-verification-wakeup';
    public const RMS = 'application/vnd.jcp.javame.midlet-rms';
    public const JISP = 'application/vnd.jisp';
    public const JODA = 'application/vnd.joost.joda-archive';
    public const VND_JSK_ISDN_NGN = 'application/vnd.jsk.isdn-ngn';
    public const KTZ = 'application/vnd.kahootz';
    public const KTR = self::KTZ;
    public const KARBON = 'application/vnd.kde.karbon';
    public const CHRT = 'application/vnd.kde.kchart';
    public const KFO = 'application/vnd.kde.kformula';
    public const FLW = 'application/vnd.kde.kivio';
    public const KON = 'application/vnd.kde.kontour';
    public const KPR = 'application/vnd.kde.kpresenter';
    public const KPT = self::KPR;
    public const KSP = 'application/vnd.kde.kspread';
    public const KWD = 'application/vnd.kde.kword';
    public const KWT = self::KWD;
    public const HTKE = 'application/vnd.kenameaapp';
    public const KIA = 'application/vnd.kidspiration';
    public const KNE = 'application/vnd.kinar';
    public const KNP = self::KNE;
    public const SKP = 'application/vnd.koan';
    public const SKD = self::SKP;
    public const SKT = self::SKP;
    public const SKM = self::SKP;
    public const SSE = 'application/vnd.kodak-descriptor';
    public const VND_LAS = 'application/vnd.las';
    public const VND_LAS_LAS_JSON = 'application/vnd.las.las+json';
    public const LASXML = 'application/vnd.las.las+xml';
    public const VND_LASZIP = 'application/vnd.laszip';
    public const VND_LEAP_JSON = 'application/vnd.leap+json';
    public const VND_LIBERTY_REQUEST_XML = 'application/vnd.liberty-request+xml';
    public const LBD = 'application/vnd.llamagraphics.life-balance.desktop';
    public const LBE = 'application/vnd.llamagraphics.life-balance.exchange+xml';
    public const VND_LOGIPIPE_CIRCUIT_ZIP = 'application/vnd.logipipe.circuit+zip';
    public const VND_LOOM = 'application/vnd.loom';
    public const _123 = 'application/vnd.lotus-1-2-3';
    public const APR = 'application/vnd.lotus-approach';
    public const PRE = 'application/vnd.lotus-freelance';
    public const NSF = 'application/vnd.lotus-notes';
    public const ORG = 'application/vnd.lotus-organizer';
    public const SCM = 'application/vnd.lotus-screencam';
    public const LWP = 'application/vnd.lotus-wordpro';
    public const PORTPKG = 'application/vnd.macports.portpkg';
    public const MVT = 'application/vnd.mapbox-vector-tile';
    public const VND_MARLIN_DRM_ACTIONTOKEN_XML = 'application/vnd.marlin.drm.actiontoken+xml';
    public const VND_MARLIN_DRM_CONFTOKEN_XML = 'application/vnd.marlin.drm.conftoken+xml';
    public const VND_MARLIN_DRM_LICENSE_XML = 'application/vnd.marlin.drm.license+xml';
    public const VND_MARLIN_DRM_MDCF = 'application/vnd.marlin.drm.mdcf';
    public const VND_MASON_JSON = 'application/vnd.mason+json';
    public const VND_MAXAR_ARCHIVE_3TZ_ZIP = 'application/vnd.maxar.archive.3tz+zip';
    public const VND_MAXMIND_MAXMIND_DB = 'application/vnd.maxmind.maxmind-db';
    public const MCD = 'application/vnd.mcd';
    public const MC1 = 'application/vnd.medcalcdata';
    public const CDKEY = 'application/vnd.mediastation.cdkey';
    public const VND_MEDICALHOLODECK_RECORDXR = 'application/vnd.medicalholodeck.recordxr';
    public const VND_MERIDIAN_SLINGSHOT = 'application/vnd.meridian-slingshot';
    public const MWF = 'application/vnd.mfer';
    public const MFM = 'application/vnd.mfmp';
    public const VND_MICRO_JSON = 'application/vnd.micro+json';
    public const FLO = 'application/vnd.micrografx.flo';
    public const IGX = 'application/vnd.micrografx.igx';
    public const VND_MICROSOFT_PORTABLE_EXECUTABLE = 'application/vnd.microsoft.portable-executable';
    public const VND_MICROSOFT_WINDOWS_THUMBNAIL_CACHE = 'application/vnd.microsoft.windows.thumbnail-cache';
    public const VND_MIELE_JSON = 'application/vnd.miele+json';
    public const MIF = 'application/vnd.mif';
    public const VND_MINISOFT_HP3000_SAVE = 'application/vnd.minisoft-hp3000-save';
    public const VND_MITSUBISHI_MISTY_GUARD_TRUSTWEB = 'application/vnd.mitsubishi.misty-guard.trustweb';
    public const DAF = 'application/vnd.mobius.daf';
    public const DIS = 'application/vnd.mobius.dis';
    public const MBK = 'application/vnd.mobius.mbk';
    public const MQY = 'application/vnd.mobius.mqy';
    public const MSL = 'application/vnd.mobius.msl';
    public const PLC = 'application/vnd.mobius.plc';
    public const TXF = 'application/vnd.mobius.txf';
    public const MPN = 'application/vnd.mophun.application';
    public const MPC = 'application/vnd.mophun.certificate';
    public const VND_MOTOROLA_FLEXSUITE = 'application/vnd.motorola.flexsuite';
    public const VND_MOTOROLA_FLEXSUITE_ADSI = 'application/vnd.motorola.flexsuite.adsi';
    public const VND_MOTOROLA_FLEXSUITE_FIS = 'application/vnd.motorola.flexsuite.fis';
    public const VND_MOTOROLA_FLEXSUITE_GOTAP = 'application/vnd.motorola.flexsuite.gotap';
    public const VND_MOTOROLA_FLEXSUITE_KMR = 'application/vnd.motorola.flexsuite.kmr';
    public const VND_MOTOROLA_FLEXSUITE_TTC = 'application/vnd.motorola.flexsuite.ttc';
    public const VND_MOTOROLA_FLEXSUITE_WEM = 'application/vnd.motorola.flexsuite.wem';
    public const VND_MOTOROLA_IPRM = 'application/vnd.motorola.iprm';
    public const XUL = 'application/vnd.mozilla.xul+xml';
    public const VND_MS_3MFDOCUMENT = 'application/vnd.ms-3mfdocument';
    public const CIL = 'application/vnd.ms-artgalry';
    public const VND_MS_ASF = 'application/vnd.ms-asf';
    public const CAB = 'application/vnd.ms-cab-compressed';
    public const VND_MS_COLOR_ICCPROFILE = 'application/vnd.ms-color.iccprofile';
    public const XLAM = 'application/vnd.ms-excel.addin.macroenabled.12';
    public const XLSB = 'application/vnd.ms-excel.sheet.binary.macroenabled.12';
    public const XLSM = 'application/vnd.ms-excel.sheet.macroenabled.12';
    public const XLTM = 'application/vnd.ms-excel.template.macroenabled.12';
    public const CHM = 'application/vnd.ms-htmlhelp';
    public const IMS = 'application/vnd.ms-ims';
    public const LRM = 'application/vnd.ms-lrm';
    public const VND_MS_OFFICE_ACTIVEX_XML = 'application/vnd.ms-office.activex+xml';
    public const THMX = 'application/vnd.ms-officetheme';
    public const VND_MS_OPENTYPE = 'application/vnd.ms-opentype';
    public const MSG = 'application/vnd.ms-outlook';
    public const VND_MS_PACKAGE_OBFUSCATED_OPENTYPE = 'application/vnd.ms-package.obfuscated-opentype';
    public const CAT = 'application/vnd.ms-pki.seccat';
    public const STL = 'application/vnd.ms-pki.stl';
    public const VND_MS_PLAYREADY_INITIATOR_XML = 'application/vnd.ms-playready.initiator+xml';
    public const PPAM = 'application/vnd.ms-powerpoint.addin.macroenabled.12';
    public const PPTM = 'application/vnd.ms-powerpoint.presentation.macroenabled.12';
    public const SLDM = 'application/vnd.ms-powerpoint.slide.macroenabled.12';
    public const PPSM = 'application/vnd.ms-powerpoint.slideshow.macroenabled.12';
    public const POTM = 'application/vnd.ms-powerpoint.template.macroenabled.12';
    public const VND_MS_PRINTDEVICECAPABILITIES_XML = 'application/vnd.ms-printdevicecapabilities+xml';
    public const VND_MS_PRINTING_PRINTTICKET_XML = 'application/vnd.ms-printing.printticket+xml';
    public const VND_MS_PRINTSCHEMATICKET_XML = 'application/vnd.ms-printschematicket+xml';
    public const MPT = 'application/vnd.ms-project';
    public const VND_MS_TNEF = 'application/vnd.ms-tnef';
    public const VND_MS_WINDOWS_DEVICEPAIRING = 'application/vnd.ms-windows.devicepairing';
    public const VND_MS_WINDOWS_NWPRINTING_OOB = 'application/vnd.ms-windows.nwprinting.oob';
    public const VND_MS_WINDOWS_PRINTERPAIRING = 'application/vnd.ms-windows.printerpairing';
    public const VND_MS_WINDOWS_WSD_OOB = 'application/vnd.ms-windows.wsd.oob';
    public const VND_MS_WMDRM_LIC_CHLG_REQ = 'application/vnd.ms-wmdrm.lic-chlg-req';
    public const VND_MS_WMDRM_LIC_RESP = 'application/vnd.ms-wmdrm.lic-resp';
    public const VND_MS_WMDRM_METER_CHLG_REQ = 'application/vnd.ms-wmdrm.meter-chlg-req';
    public const VND_MS_WMDRM_METER_RESP = 'application/vnd.ms-wmdrm.meter-resp';
    public const DOCM = 'application/vnd.ms-word.document.macroenabled.12';
    public const DOTM = 'application/vnd.ms-word.template.macroenabled.12';
    public const WPS = 'application/vnd.ms-works';
    public const WKS = self::WPS;
    public const WCM = self::WPS;
    public const WDB = self::WPS;
    public const WPL = 'application/vnd.ms-wpl';
    public const XPS = 'application/vnd.ms-xpsdocument';
    public const VND_MSA_DISK_IMAGE = 'application/vnd.msa-disk-image';
    public const MSEQ = 'application/vnd.mseq';
    public const VND_MSIGN = 'application/vnd.msign';
    public const VND_MULTIAD_CREATOR = 'application/vnd.multiad.creator';
    public const VND_MULTIAD_CREATOR_CIF = 'application/vnd.multiad.creator.cif';
    public const VND_MUSIC_NIFF = 'application/vnd.music-niff';
    public const MUS = 'application/vnd.musician';
    public const MSTY = 'application/vnd.muvee.style';
    public const TAGLET = 'application/vnd.mynfc';
    public const VND_NACAMAR_YBRID_JSON = 'application/vnd.nacamar.ybrid+json';
    public const VND_NCD_CONTROL = 'application/vnd.ncd.control';
    public const VND_NCD_REFERENCE = 'application/vnd.ncd.reference';
    public const VND_NEARST_INV_JSON = 'application/vnd.nearst.inv+json';
    public const VND_NEBUMIND_LINE = 'application/vnd.nebumind.line';
    public const VND_NERVANA = 'application/vnd.nervana';
    public const VND_NETFPX = 'application/vnd.netfpx';
    public const NLU = 'application/vnd.neurolanguage.nlu';
    public const VND_NIMN = 'application/vnd.nimn';
    public const VND_NINTENDO_NITRO_ROM = 'application/vnd.nintendo.nitro.rom';
    public const VND_NINTENDO_SNES_ROM = 'application/vnd.nintendo.snes.rom';
    public const NTF = 'application/vnd.nitf';
    public const NITF = self::NTF;
    public const NND = 'application/vnd.noblenet-directory';
    public const NNS = 'application/vnd.noblenet-sealer';
    public const NNW = 'application/vnd.noblenet-web';
    public const VND_NOKIA_CATALOGS = 'application/vnd.nokia.catalogs';
    public const VND_NOKIA_CONML_WBXML = 'application/vnd.nokia.conml+wbxml';
    public const VND_NOKIA_CONML_XML = 'application/vnd.nokia.conml+xml';
    public const VND_NOKIA_IPTV_CONFIG_XML = 'application/vnd.nokia.iptv.config+xml';
    public const VND_NOKIA_ISDS_RADIO_PRESETS = 'application/vnd.nokia.isds-radio-presets';
    public const VND_NOKIA_LANDMARK_WBXML = 'application/vnd.nokia.landmark+wbxml';
    public const VND_NOKIA_LANDMARK_XML = 'application/vnd.nokia.landmark+xml';
    public const VND_NOKIA_LANDMARKCOLLECTION_XML = 'application/vnd.nokia.landmarkcollection+xml';
    public const NGDAT = 'application/vnd.nokia.n-gage.data';
    public const N_GAGE = 'application/vnd.nokia.n-gage.symbian.install';
    public const VND_NOKIA_NCD = 'application/vnd.nokia.ncd';
    public const VND_NOKIA_PCD_WBXML = 'application/vnd.nokia.pcd+wbxml';
    public const VND_NOKIA_PCD_XML = 'application/vnd.nokia.pcd+xml';
    public const RPST = 'application/vnd.nokia.radio-preset';
    public const RPSS = 'application/vnd.nokia.radio-presets';
    public const EDM = 'application/vnd.novadigm.edm';
    public const EDX = 'application/vnd.novadigm.edx';
    public const EXT = 'application/vnd.novadigm.ext';
    public const VND_NTT_LOCAL_CONTENT_SHARE = 'application/vnd.ntt-local.content-share';
    public const VND_NTT_LOCAL_FILE_TRANSFER = 'application/vnd.ntt-local.file-transfer';
    public const VND_NTT_LOCAL_OGW_REMOTE_ACCESS = 'application/vnd.ntt-local.ogw_remote-access';
    public const VND_NTT_LOCAL_SIP_TA_REMOTE = 'application/vnd.ntt-local.sip-ta_remote';
    public const VND_NTT_LOCAL_SIP_TA_TCP_STREAM = 'application/vnd.ntt-local.sip-ta_tcp_stream';
    public const VND_OASIS_OPENDOCUMENT_BASE = 'application/vnd.oasis.opendocument.base';
    public const ODC = 'application/vnd.oasis.opendocument.chart';
    public const OTC = 'application/vnd.oasis.opendocument.chart-template';
    public const ODB = 'application/vnd.oasis.opendocument.database';
    public const ODF = 'application/vnd.oasis.opendocument.formula';
    public const ODFT = 'application/vnd.oasis.opendocument.formula-template';
    public const OTG = 'application/vnd.oasis.opendocument.graphics-template';
    public const ODI = 'application/vnd.oasis.opendocument.image';
    public const OTI = 'application/vnd.oasis.opendocument.image-template';
    public const OTP = 'application/vnd.oasis.opendocument.presentation-template';
    public const OTS = 'application/vnd.oasis.opendocument.spreadsheet-template';
    public const ODM = 'application/vnd.oasis.opendocument.text-master';
    public const OTT = 'application/vnd.oasis.opendocument.text-template';
    public const OTH = 'application/vnd.oasis.opendocument.text-web';
    public const VND_OBN = 'application/vnd.obn';
    public const VND_OCF_CBOR = 'application/vnd.ocf+cbor';
    public const VND_OCI_IMAGE_MANIFEST_V1_JSON = 'application/vnd.oci.image.manifest.v1+json';
    public const VND_OFTN_L10N_JSON = 'application/vnd.oftn.l10n+json';
    public const VND_OIPF_CONTENTACCESSDOWNLOAD_XML = 'application/vnd.oipf.contentaccessdownload+xml';
    public const VND_OIPF_CONTENTACCESSSTREAMING_XML = 'application/vnd.oipf.contentaccessstreaming+xml';
    public const VND_OIPF_CSPG_HEXBINARY = 'application/vnd.oipf.cspg-hexbinary';
    public const VND_OIPF_DAE_SVG_XML = 'application/vnd.oipf.dae.svg+xml';
    public const VND_OIPF_DAE_XHTML_XML = 'application/vnd.oipf.dae.xhtml+xml';
    public const VND_OIPF_MIPPVCONTROLMESSAGE_XML = 'application/vnd.oipf.mippvcontrolmessage+xml';
    public const VND_OIPF_PAE_GEM = 'application/vnd.oipf.pae.gem';
    public const VND_OIPF_SPDISCOVERY_XML = 'application/vnd.oipf.spdiscovery+xml';
    public const VND_OIPF_SPDLIST_XML = 'application/vnd.oipf.spdlist+xml';
    public const VND_OIPF_UEPROFILE_XML = 'application/vnd.oipf.ueprofile+xml';
    public const VND_OIPF_USERPROFILE_XML = 'application/vnd.oipf.userprofile+xml';
    public const XO = 'application/vnd.olpc-sugar';
    public const VND_OMA_SCWS_CONFIG = 'application/vnd.oma-scws-config';
    public const VND_OMA_SCWS_HTTP_REQUEST = 'application/vnd.oma-scws-http-request';
    public const VND_OMA_SCWS_HTTP_RESPONSE = 'application/vnd.oma-scws-http-response';
    public const VND_OMA_BCAST_ASSOCIATED_PROCEDURE_PARAMETER_XML = 'application/vnd.oma.bcast.associated-procedure-parameter+xml';
    public const VND_OMA_BCAST_DRM_TRIGGER_XML = 'application/vnd.oma.bcast.drm-trigger+xml';
    public const VND_OMA_BCAST_IMD_XML = 'application/vnd.oma.bcast.imd+xml';
    public const VND_OMA_BCAST_LTKM = 'application/vnd.oma.bcast.ltkm';
    public const VND_OMA_BCAST_NOTIFICATION_XML = 'application/vnd.oma.bcast.notification+xml';
    public const VND_OMA_BCAST_PROVISIONINGTRIGGER = 'application/vnd.oma.bcast.provisioningtrigger';
    public const VND_OMA_BCAST_SGBOOT = 'application/vnd.oma.bcast.sgboot';
    public const VND_OMA_BCAST_SGDD_XML = 'application/vnd.oma.bcast.sgdd+xml';
    public const VND_OMA_BCAST_SGDU = 'application/vnd.oma.bcast.sgdu';
    public const VND_OMA_BCAST_SIMPLE_SYMBOL_CONTAINER = 'application/vnd.oma.bcast.simple-symbol-container';
    public const VND_OMA_BCAST_SMARTCARD_TRIGGER_XML = 'application/vnd.oma.bcast.smartcard-trigger+xml';
    public const VND_OMA_BCAST_SPROV_XML = 'application/vnd.oma.bcast.sprov+xml';
    public const VND_OMA_BCAST_STKM = 'application/vnd.oma.bcast.stkm';
    public const VND_OMA_CAB_ADDRESS_BOOK_XML = 'application/vnd.oma.cab-address-book+xml';
    public const VND_OMA_CAB_FEATURE_HANDLER_XML = 'application/vnd.oma.cab-feature-handler+xml';
    public const VND_OMA_CAB_PCC_XML = 'application/vnd.oma.cab-pcc+xml';
    public const VND_OMA_CAB_SUBS_INVITE_XML = 'application/vnd.oma.cab-subs-invite+xml';
    public const VND_OMA_CAB_USER_PREFS_XML = 'application/vnd.oma.cab-user-prefs+xml';
    public const VND_OMA_DCD = 'application/vnd.oma.dcd';
    public const VND_OMA_DCDC = 'application/vnd.oma.dcdc';
    public const DD2 = 'application/vnd.oma.dd2+xml';
    public const VND_OMA_DRM_RISD_XML = 'application/vnd.oma.drm.risd+xml';
    public const VND_OMA_GROUP_USAGE_LIST_XML = 'application/vnd.oma.group-usage-list+xml';
    public const VND_OMA_LWM2M_CBOR = 'application/vnd.oma.lwm2m+cbor';
    public const VND_OMA_LWM2M_JSON = 'application/vnd.oma.lwm2m+json';
    public const VND_OMA_LWM2M_TLV = 'application/vnd.oma.lwm2m+tlv';
    public const VND_OMA_PAL_XML = 'application/vnd.oma.pal+xml';
    public const VND_OMA_POC_DETAILED_PROGRESS_REPORT_XML = 'application/vnd.oma.poc.detailed-progress-report+xml';
    public const VND_OMA_POC_FINAL_REPORT_XML = 'application/vnd.oma.poc.final-report+xml';
    public const VND_OMA_POC_GROUPS_XML = 'application/vnd.oma.poc.groups+xml';
    public const VND_OMA_POC_INVOCATION_DESCRIPTOR_XML = 'application/vnd.oma.poc.invocation-descriptor+xml';
    public const VND_OMA_POC_OPTIMIZED_PROGRESS_REPORT_XML = 'application/vnd.oma.poc.optimized-progress-report+xml';
    public const VND_OMA_PUSH = 'application/vnd.oma.push';
    public const VND_OMA_SCIDM_MESSAGES_XML = 'application/vnd.oma.scidm.messages+xml';
    public const VND_OMA_XCAP_DIRECTORY_XML = 'application/vnd.oma.xcap-directory+xml';
    public const VND_OMADS_EMAIL_XML = 'application/vnd.omads-email+xml';
    public const VND_OMADS_FILE_XML = 'application/vnd.omads-file+xml';
    public const VND_OMADS_FOLDER_XML = 'application/vnd.omads-folder+xml';
    public const VND_OMALOC_SUPL_INIT = 'application/vnd.omaloc-supl-init';
    public const VND_ONEPAGER = 'application/vnd.onepager';
    public const VND_ONEPAGERTAMP = 'application/vnd.onepagertamp';
    public const VND_ONEPAGERTAMX = 'application/vnd.onepagertamx';
    public const VND_ONEPAGERTAT = 'application/vnd.onepagertat';
    public const VND_ONEPAGERTATP = 'application/vnd.onepagertatp';
    public const VND_ONEPAGERTATX = 'application/vnd.onepagertatx';
    public const VND_ONVIF_METADATA = 'application/vnd.onvif.metadata';
    public const OBGX = 'application/vnd.openblox.game+xml';
    public const VND_OPENBLOX_GAME_BINARY = 'application/vnd.openblox.game-binary';
    public const VND_OPENEYE_OEB = 'application/vnd.openeye.oeb';
    public const OXT = 'application/vnd.openofficeorg.extension';
    public const OSM = 'application/vnd.openstreetmap.data+xml';
    public const VND_OPENTIMESTAMPS_OTS = 'application/vnd.opentimestamps.ots';
    public const VND_OPENXMLFORMATS_OFFICEDOCUMENT_CUSTOM_PROPERTIES_XML = 'application/vnd.openxmlformats-officedocument.custom-properties+xml';
    public const VND_OPENXMLFORMATS_OFFICEDOCUMENT_CUSTOMXMLPROPERTIES_XML = 'application/vnd.openxmlformats-officedocument.customxmlproperties+xml';
    public const VND_OPENXMLFORMATS_OFFICEDOCUMENT_DRAWING_XML = 'application/vnd.openxmlformats-officedocument.drawing+xml';
    public const VND_OPENXMLFORMATS_OFFICEDOCUMENT_DRAWINGML_CHART_XML = 'application/vnd.openxmlformats-officedocument.drawingml.chart+xml';
    public const VND_OPENXMLFORMATS_OFFICEDOCUMENT_DRAWINGML_CHARTSHAPES_XML = 'application/vnd.openxmlformats-officedocument.drawingml.chartshapes+xml';
    public const VND_OPENXMLFORMATS_OFFICEDOCUMENT_DRAWINGML_DIAGRAMCOLORS_XML = 'application/vnd.openxmlformats-officedocument.drawingml.diagramcolors+xml';
    public const VND_OPENXMLFORMATS_OFFICEDOCUMENT_DRAWINGML_DIAGRAMDATA_XML = 'application/vnd.openxmlformats-officedocument.drawingml.diagramdata+xml';
    public const VND_OPENXMLFORMATS_OFFICEDOCUMENT_DRAWINGML_DIAGRAMLAYOUT_XML = 'application/vnd.openxmlformats-officedocument.drawingml.diagramlayout+xml';
    public const VND_OPENXMLFORMATS_OFFICEDOCUMENT_DRAWINGML_DIAGRAMSTYLE_XML = 'application/vnd.openxmlformats-officedocument.drawingml.diagramstyle+xml';
    public const VND_OPENXMLFORMATS_OFFICEDOCUMENT_EXTENDED_PROPERTIES_XML = 'application/vnd.openxmlformats-officedocument.extended-properties+xml';
    public const VND_OPENXMLFORMATS_OFFICEDOCUMENT_PRESENTATIONML_COMMENTAUTHORS_XML = 'application/vnd.openxmlformats-officedocument.presentationml.commentauthors+xml';
    public const VND_OPENXMLFORMATS_OFFICEDOCUMENT_PRESENTATIONML_COMMENTS_XML = 'application/vnd.openxmlformats-officedocument.presentationml.comments+xml';
    public const VND_OPENXMLFORMATS_OFFICEDOCUMENT_PRESENTATIONML_HANDOUTMASTER_XML = 'application/vnd.openxmlformats-officedocument.presentationml.handoutmaster+xml';
    public const VND_OPENXMLFORMATS_OFFICEDOCUMENT_PRESENTATIONML_NOTESMASTER_XML = 'application/vnd.openxmlformats-officedocument.presentationml.notesmaster+xml';
    public const VND_OPENXMLFORMATS_OFFICEDOCUMENT_PRESENTATIONML_NOTESSLIDE_XML = 'application/vnd.openxmlformats-officedocument.presentationml.notesslide+xml';
    public const VND_OPENXMLFORMATS_OFFICEDOCUMENT_PRESENTATIONML_PRESENTATION_MAIN_XML = 'application/vnd.openxmlformats-officedocument.presentationml.presentation.main+xml';
    public const VND_OPENXMLFORMATS_OFFICEDOCUMENT_PRESENTATIONML_PRESPROPS_XML = 'application/vnd.openxmlformats-officedocument.presentationml.presprops+xml';
    public const SLDX = 'application/vnd.openxmlformats-officedocument.presentationml.slide';
    public const VND_OPENXMLFORMATS_OFFICEDOCUMENT_PRESENTATIONML_SLIDE_XML = 'application/vnd.openxmlformats-officedocument.presentationml.slide+xml';
    public const VND_OPENXMLFORMATS_OFFICEDOCUMENT_PRESENTATIONML_SLIDELAYOUT_XML = 'application/vnd.openxmlformats-officedocument.presentationml.slidelayout+xml';
    public const VND_OPENXMLFORMATS_OFFICEDOCUMENT_PRESENTATIONML_SLIDEMASTER_XML = 'application/vnd.openxmlformats-officedocument.presentationml.slidemaster+xml';
    public const PPSX = 'application/vnd.openxmlformats-officedocument.presentationml.slideshow';
    public const VND_OPENXMLFORMATS_OFFICEDOCUMENT_PRESENTATIONML_SLIDESHOW_MAIN_XML = 'application/vnd.openxmlformats-officedocument.presentationml.slideshow.main+xml';
    public const VND_OPENXMLFORMATS_OFFICEDOCUMENT_PRESENTATIONML_SLIDEUPDATEINFO_XML = 'application/vnd.openxmlformats-officedocument.presentationml.slideupdateinfo+xml';
    public const VND_OPENXMLFORMATS_OFFICEDOCUMENT_PRESENTATIONML_TABLESTYLES_XML = 'application/vnd.openxmlformats-officedocument.presentationml.tablestyles+xml';
    public const VND_OPENXMLFORMATS_OFFICEDOCUMENT_PRESENTATIONML_TAGS_XML = 'application/vnd.openxmlformats-officedocument.presentationml.tags+xml';
    public const POTX = 'application/vnd.openxmlformats-officedocument.presentationml.template';
    public const VND_OPENXMLFORMATS_OFFICEDOCUMENT_PRESENTATIONML_TEMPLATE_MAIN_XML = 'application/vnd.openxmlformats-officedocument.presentationml.template.main+xml';
    public const VND_OPENXMLFORMATS_OFFICEDOCUMENT_PRESENTATIONML_VIEWPROPS_XML = 'application/vnd.openxmlformats-officedocument.presentationml.viewprops+xml';
    public const VND_OPENXMLFORMATS_OFFICEDOCUMENT_SPREADSHEETML_CALCCHAIN_XML = 'application/vnd.openxmlformats-officedocument.spreadsheetml.calcchain+xml';
    public const VND_OPENXMLFORMATS_OFFICEDOCUMENT_SPREADSHEETML_CHARTSHEET_XML = 'application/vnd.openxmlformats-officedocument.spreadsheetml.chartsheet+xml';
    public const VND_OPENXMLFORMATS_OFFICEDOCUMENT_SPREADSHEETML_COMMENTS_XML = 'application/vnd.openxmlformats-officedocument.spreadsheetml.comments+xml';
    public const VND_OPENXMLFORMATS_OFFICEDOCUMENT_SPREADSHEETML_CONNECTIONS_XML = 'application/vnd.openxmlformats-officedocument.spreadsheetml.connections+xml';
    public const VND_OPENXMLFORMATS_OFFICEDOCUMENT_SPREADSHEETML_DIALOGSHEET_XML = 'application/vnd.openxmlformats-officedocument.spreadsheetml.dialogsheet+xml';
    public const VND_OPENXMLFORMATS_OFFICEDOCUMENT_SPREADSHEETML_EXTERNALLINK_XML = 'application/vnd.openxmlformats-officedocument.spreadsheetml.externallink+xml';
    public const VND_OPENXMLFORMATS_OFFICEDOCUMENT_SPREADSHEETML_PIVOTCACHEDEFINITION_XML = 'application/vnd.openxmlformats-officedocument.spreadsheetml.pivotcachedefinition+xml';
    public const VND_OPENXMLFORMATS_OFFICEDOCUMENT_SPREADSHEETML_PIVOTCACHERECORDS_XML = 'application/vnd.openxmlformats-officedocument.spreadsheetml.pivotcacherecords+xml';
    public const VND_OPENXMLFORMATS_OFFICEDOCUMENT_SPREADSHEETML_PIVOTTABLE_XML = 'application/vnd.openxmlformats-officedocument.spreadsheetml.pivottable+xml';
    public const VND_OPENXMLFORMATS_OFFICEDOCUMENT_SPREADSHEETML_QUERYTABLE_XML = 'application/vnd.openxmlformats-officedocument.spreadsheetml.querytable+xml';
    public const VND_OPENXMLFORMATS_OFFICEDOCUMENT_SPREADSHEETML_REVISIONHEADERS_XML = 'application/vnd.openxmlformats-officedocument.spreadsheetml.revisionheaders+xml';
    public const VND_OPENXMLFORMATS_OFFICEDOCUMENT_SPREADSHEETML_REVISIONLOG_XML = 'application/vnd.openxmlformats-officedocument.spreadsheetml.revisionlog+xml';
    public const VND_OPENXMLFORMATS_OFFICEDOCUMENT_SPREADSHEETML_SHAREDSTRINGS_XML = 'application/vnd.openxmlformats-officedocument.spreadsheetml.sharedstrings+xml';
    public const VND_OPENXMLFORMATS_OFFICEDOCUMENT_SPREADSHEETML_SHEET_MAIN_XML = 'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet.main+xml';
    public const VND_OPENXMLFORMATS_OFFICEDOCUMENT_SPREADSHEETML_SHEETMETADATA_XML = 'application/vnd.openxmlformats-officedocument.spreadsheetml.sheetmetadata+xml';
    public const VND_OPENXMLFORMATS_OFFICEDOCUMENT_SPREADSHEETML_STYLES_XML = 'application/vnd.openxmlformats-officedocument.spreadsheetml.styles+xml';
    public const VND_OPENXMLFORMATS_OFFICEDOCUMENT_SPREADSHEETML_TABLE_XML = 'application/vnd.openxmlformats-officedocument.spreadsheetml.table+xml';
    public const VND_OPENXMLFORMATS_OFFICEDOCUMENT_SPREADSHEETML_TABLESINGLECELLS_XML = 'application/vnd.openxmlformats-officedocument.spreadsheetml.tablesinglecells+xml';
    public const XLTX = 'application/vnd.openxmlformats-officedocument.spreadsheetml.template';
    public const VND_OPENXMLFORMATS_OFFICEDOCUMENT_SPREADSHEETML_TEMPLATE_MAIN_XML = 'application/vnd.openxmlformats-officedocument.spreadsheetml.template.main+xml';
    public const VND_OPENXMLFORMATS_OFFICEDOCUMENT_SPREADSHEETML_USERNAMES_XML = 'application/vnd.openxmlformats-officedocument.spreadsheetml.usernames+xml';
    public const VND_OPENXMLFORMATS_OFFICEDOCUMENT_SPREADSHEETML_VOLATILEDEPENDENCIES_XML = 'application/vnd.openxmlformats-officedocument.spreadsheetml.volatiledependencies+xml';
    public const VND_OPENXMLFORMATS_OFFICEDOCUMENT_SPREADSHEETML_WORKSHEET_XML = 'application/vnd.openxmlformats-officedocument.spreadsheetml.worksheet+xml';
    public const VND_OPENXMLFORMATS_OFFICEDOCUMENT_THEME_XML = 'application/vnd.openxmlformats-officedocument.theme+xml';
    public const VND_OPENXMLFORMATS_OFFICEDOCUMENT_THEMEOVERRIDE_XML = 'application/vnd.openxmlformats-officedocument.themeoverride+xml';
    public const VND_OPENXMLFORMATS_OFFICEDOCUMENT_VMLDRAWING = 'application/vnd.openxmlformats-officedocument.vmldrawing';
    public const VND_OPENXMLFORMATS_OFFICEDOCUMENT_WORDPROCESSINGML_COMMENTS_XML = 'application/vnd.openxmlformats-officedocument.wordprocessingml.comments+xml';
    public const VND_OPENXMLFORMATS_OFFICEDOCUMENT_WORDPROCESSINGML_DOCUMENT_GLOSSARY_XML = 'application/vnd.openxmlformats-officedocument.wordprocessingml.document.glossary+xml';
    public const VND_OPENXMLFORMATS_OFFICEDOCUMENT_WORDPROCESSINGML_DOCUMENT_MAIN_XML = 'application/vnd.openxmlformats-officedocument.wordprocessingml.document.main+xml';
    public const VND_OPENXMLFORMATS_OFFICEDOCUMENT_WORDPROCESSINGML_ENDNOTES_XML = 'application/vnd.openxmlformats-officedocument.wordprocessingml.endnotes+xml';
    public const VND_OPENXMLFORMATS_OFFICEDOCUMENT_WORDPROCESSINGML_FONTTABLE_XML = 'application/vnd.openxmlformats-officedocument.wordprocessingml.fonttable+xml';
    public const VND_OPENXMLFORMATS_OFFICEDOCUMENT_WORDPROCESSINGML_FOOTER_XML = 'application/vnd.openxmlformats-officedocument.wordprocessingml.footer+xml';
    public const VND_OPENXMLFORMATS_OFFICEDOCUMENT_WORDPROCESSINGML_FOOTNOTES_XML = 'application/vnd.openxmlformats-officedocument.wordprocessingml.footnotes+xml';
    public const VND_OPENXMLFORMATS_OFFICEDOCUMENT_WORDPROCESSINGML_NUMBERING_XML = 'application/vnd.openxmlformats-officedocument.wordprocessingml.numbering+xml';
    public const VND_OPENXMLFORMATS_OFFICEDOCUMENT_WORDPROCESSINGML_SETTINGS_XML = 'application/vnd.openxmlformats-officedocument.wordprocessingml.settings+xml';
    public const VND_OPENXMLFORMATS_OFFICEDOCUMENT_WORDPROCESSINGML_STYLES_XML = 'application/vnd.openxmlformats-officedocument.wordprocessingml.styles+xml';
    public const DOTX = 'application/vnd.openxmlformats-officedocument.wordprocessingml.template';
    public const VND_OPENXMLFORMATS_OFFICEDOCUMENT_WORDPROCESSINGML_TEMPLATE_MAIN_XML = 'application/vnd.openxmlformats-officedocument.wordprocessingml.template.main+xml';
    public const VND_OPENXMLFORMATS_OFFICEDOCUMENT_WORDPROCESSINGML_WEBSETTINGS_XML = 'application/vnd.openxmlformats-officedocument.wordprocessingml.websettings+xml';
    public const VND_OPENXMLFORMATS_PACKAGE_CORE_PROPERTIES_XML = 'application/vnd.openxmlformats-package.core-properties+xml';
    public const VND_OPENXMLFORMATS_PACKAGE_DIGITAL_SIGNATURE_XMLSIGNATURE_XML = 'application/vnd.openxmlformats-package.digital-signature-xmlsignature+xml';
    public const VND_OPENXMLFORMATS_PACKAGE_RELATIONSHIPS_XML = 'application/vnd.openxmlformats-package.relationships+xml';
    public const VND_ORACLE_RESOURCE_JSON = 'application/vnd.oracle.resource+json';
    public const VND_ORANGE_INDATA = 'application/vnd.orange.indata';
    public const VND_OSA_NETDEPLOY = 'application/vnd.osa.netdeploy';
    public const MGP = 'application/vnd.osgeo.mapguide.package';
    public const VND_OSGI_BUNDLE = 'application/vnd.osgi.bundle';
    public const DP = 'application/vnd.osgi.dp';
    public const ESA = 'application/vnd.osgi.subsystem';
    public const VND_OTPS_CT_KIP_XML = 'application/vnd.otps.ct-kip+xml';
    public const VND_OXLI_COUNTGRAPH = 'application/vnd.oxli.countgraph';
    public const VND_PAGERDUTY_JSON = 'application/vnd.pagerduty+json';
    public const PQA = 'application/vnd.palm';
    public const OPRC = self::PQA;
    public const VND_PANOPLY = 'application/vnd.panoply';
    public const VND_PAOS_XML = 'application/vnd.paos.xml';
    public const VND_PATENTDIVE = 'application/vnd.patentdive';
    public const VND_PATIENTECOMMSDOC = 'application/vnd.patientecommsdoc';
    public const PAW = 'application/vnd.pawaafile';
    public const VND_PCOS = 'application/vnd.pcos';
    public const STR = 'application/vnd.pg.format';
    public const EI6 = 'application/vnd.pg.osasli';
    public const VND_PIACCESS_APPLICATION_LICENCE = 'application/vnd.piaccess.application-licence';
    public const EFIF = 'application/vnd.picsel';
    public const WG = 'application/vnd.pmi.widget';
    public const VND_POC_GROUP_ADVERTISEMENT_XML = 'application/vnd.poc.group-advertisement+xml';
    public const PLF = 'application/vnd.pocketlearn';
    public const PBD = 'application/vnd.powerbuilder6';
    public const VND_POWERBUILDER6_S = 'application/vnd.powerbuilder6-s';
    public const VND_POWERBUILDER7 = 'application/vnd.powerbuilder7';
    public const VND_POWERBUILDER7_S = 'application/vnd.powerbuilder7-s';
    public const VND_POWERBUILDER75 = 'application/vnd.powerbuilder75';
    public const VND_POWERBUILDER75_S = 'application/vnd.powerbuilder75-s';
    public const VND_PREMINET = 'application/vnd.preminet';
    public const BOX = 'application/vnd.previewsystems.box';
    public const MGZ = 'application/vnd.proteus.magazine';
    public const VND_PSFS = 'application/vnd.psfs';
    public const QPS = 'application/vnd.publishare-delta-tree';
    public const PTID = 'application/vnd.pvi.ptid1';
    public const VND_PWG_MULTIPLEXED = 'application/vnd.pwg-multiplexed';
    public const XHTM = 'application/vnd.pwg-xhtml-print+xml';
    public const VND_QUALCOMM_BREW_APP_RES = 'application/vnd.qualcomm.brew-app-res';
    public const VND_QUARANTAINENET = 'application/vnd.quarantainenet';
    public const QXD = 'application/vnd.quark.quarkxpress';
    public const QXT = self::QXD;
    public const QWD = self::QXD;
    public const QWT = self::QXD;
    public const QXL = self::QXD;
    public const QXB = self::QXD;
    public const VND_QUOBJECT_QUOXDOCUMENT = 'application/vnd.quobject-quoxdocument';
    public const VND_RADISYS_MOML_XML = 'application/vnd.radisys.moml+xml';
    public const VND_RADISYS_MSML_XML = 'application/vnd.radisys.msml+xml';
    public const VND_RADISYS_MSML_AUDIT_XML = 'application/vnd.radisys.msml-audit+xml';
    public const VND_RADISYS_MSML_AUDIT_CONF_XML = 'application/vnd.radisys.msml-audit-conf+xml';
    public const VND_RADISYS_MSML_AUDIT_CONN_XML = 'application/vnd.radisys.msml-audit-conn+xml';
    public const VND_RADISYS_MSML_AUDIT_DIALOG_XML = 'application/vnd.radisys.msml-audit-dialog+xml';
    public const VND_RADISYS_MSML_AUDIT_STREAM_XML = 'application/vnd.radisys.msml-audit-stream+xml';
    public const VND_RADISYS_MSML_CONF_XML = 'application/vnd.radisys.msml-conf+xml';
    public const VND_RADISYS_MSML_DIALOG_XML = 'application/vnd.radisys.msml-dialog+xml';
    public const VND_RADISYS_MSML_DIALOG_BASE_XML = 'application/vnd.radisys.msml-dialog-base+xml';
    public const VND_RADISYS_MSML_DIALOG_FAX_DETECT_XML = 'application/vnd.radisys.msml-dialog-fax-detect+xml';
    public const VND_RADISYS_MSML_DIALOG_FAX_SENDRECV_XML = 'application/vnd.radisys.msml-dialog-fax-sendrecv+xml';
    public const VND_RADISYS_MSML_DIALOG_GROUP_XML = 'application/vnd.radisys.msml-dialog-group+xml';
    public const VND_RADISYS_MSML_DIALOG_SPEECH_XML = 'application/vnd.radisys.msml-dialog-speech+xml';
    public const VND_RADISYS_MSML_DIALOG_TRANSFORM_XML = 'application/vnd.radisys.msml-dialog-transform+xml';
    public const VND_RAINSTOR_DATA = 'application/vnd.rainstor.data';
    public const VND_RAPID = 'application/vnd.rapid';
    public const BED = 'application/vnd.realvnc.bed';
    public const MXL = 'application/vnd.recordare.musicxml';
    public const MUSICXML = 'application/vnd.recordare.musicxml+xml';
    public const VND_RENLEARN_RLPRINT = 'application/vnd.renlearn.rlprint';
    public const VND_RESILIENT_LOGIC = 'application/vnd.resilient.logic';
    public const VND_RESTFUL_JSON = 'application/vnd.restful+json';
    public const CRYPTONOTE = 'application/vnd.rig.cryptonote';
    public const COD = 'application/vnd.rim.cod';
    public const RM = 'application/vnd.rn-realmedia';
    public const RMVB = 'application/vnd.rn-realmedia-vbr';
    public const LINK66 = 'application/vnd.route66.link66+xml';
    public const VND_RS_274X = 'application/vnd.rs-274x';
    public const VND_RUCKUS_DOWNLOAD = 'application/vnd.ruckus.download';
    public const VND_S3SMS = 'application/vnd.s3sms';
    public const ST = 'application/vnd.sailingtracker.track';
    public const VND_SAR = 'application/vnd.sar';
    public const VND_SBM_CID = 'application/vnd.sbm.cid';
    public const VND_SBM_MID2 = 'application/vnd.sbm.mid2';
    public const VND_SCRIBUS = 'application/vnd.scribus';
    public const VND_SEALED_3DF = 'application/vnd.sealed.3df';
    public const VND_SEALED_CSF = 'application/vnd.sealed.csf';
    public const VND_SEALED_DOC = 'application/vnd.sealed.doc';
    public const VND_SEALED_EML = 'application/vnd.sealed.eml';
    public const VND_SEALED_MHT = 'application/vnd.sealed.mht';
    public const VND_SEALED_NET = 'application/vnd.sealed.net';
    public const VND_SEALED_PPT = 'application/vnd.sealed.ppt';
    public const VND_SEALED_TIFF = 'application/vnd.sealed.tiff';
    public const VND_SEALED_XLS = 'application/vnd.sealed.xls';
    public const VND_SEALEDMEDIA_SOFTSEAL_HTML = 'application/vnd.sealedmedia.softseal.html';
    public const VND_SEALEDMEDIA_SOFTSEAL_PDF = 'application/vnd.sealedmedia.softseal.pdf';
    public const SEE = 'application/vnd.seemail';
    public const VND_SEIS_JSON = 'application/vnd.seis+json';
    public const SEMA = 'application/vnd.sema';
    public const SEMD = 'application/vnd.semd';
    public const SEMF = 'application/vnd.semf';
    public const VND_SHADE_SAVE_FILE = 'application/vnd.shade-save-file';
    public const IFM = 'application/vnd.shana.informed.formdata';
    public const ITP = 'application/vnd.shana.informed.formtemplate';
    public const IIF = 'application/vnd.shana.informed.interchange';
    public const IPK = 'application/vnd.shana.informed.package';
    public const VND_SHOOTPROOF_JSON = 'application/vnd.shootproof+json';
    public const VND_SHOPKICK_JSON = 'application/vnd.shopkick+json';
    public const VND_SHP = 'application/vnd.shp';
    public const VND_SHX = 'application/vnd.shx';
    public const VND_SIGROK_SESSION = 'application/vnd.sigrok.session';
    public const TWD = 'application/vnd.simtech-mindmapper';
    public const TWDS = self::TWD;
    public const VND_SIREN_JSON = 'application/vnd.siren+json';
    public const MMF = 'application/vnd.smaf';
    public const VND_SMART_NOTEBOOK = 'application/vnd.smart.notebook';
    public const TEACHER = 'application/vnd.smart.teacher';
    public const VND_SMINTIO_PORTALS_ARCHIVE = 'application/vnd.smintio.portals.archive';
    public const VND_SNESDEV_PAGE_TABLE = 'application/vnd.snesdev-page-table';
    public const FO = 'application/vnd.software602.filler.form+xml';
    public const VND_SOFTWARE602_FILLER_FORM_XML_ZIP = 'application/vnd.software602.filler.form-xml-zip';
    public const SDKM = 'application/vnd.solent.sdkm+xml';
    public const SDKD = self::SDKM;
    public const DXP = 'application/vnd.spotfire.dxp';
    public const SFS = 'application/vnd.spotfire.sfs';
    public const VND_SQLITE3 = 'application/vnd.sqlite3';
    public const VND_SSS_COD = 'application/vnd.sss-cod';
    public const VND_SSS_DTF = 'application/vnd.sss-dtf';
    public const VND_SSS_NTF = 'application/vnd.sss-ntf';
    public const SDC = 'application/vnd.stardivision.calc';
    public const SDA = 'application/vnd.stardivision.draw';
    public const SDD = 'application/vnd.stardivision.impress';
    public const SMF = 'application/vnd.stardivision.math';
    public const SDW = 'application/vnd.stardivision.writer';
    public const VOR = self::SDW;
    public const SGL = 'application/vnd.stardivision.writer-global';
    public const SMZIP = 'application/vnd.stepmania.package';
    public const SM = 'application/vnd.stepmania.stepchart';
    public const VND_STREET_STREAM = 'application/vnd.street-stream';
    public const WADL = 'application/vnd.sun.wadl+xml';
    public const SXC = 'application/vnd.sun.xml.calc';
    public const STC = 'application/vnd.sun.xml.calc.template';
    public const SXD = 'application/vnd.sun.xml.draw';
    public const STD = 'application/vnd.sun.xml.draw.template';
    public const SXI = 'application/vnd.sun.xml.impress';
    public const STI = 'application/vnd.sun.xml.impress.template';
    public const SXM = 'application/vnd.sun.xml.math';
    public const SXW = 'application/vnd.sun.xml.writer';
    public const SXG = 'application/vnd.sun.xml.writer.global';
    public const STW = 'application/vnd.sun.xml.writer.template';
    public const SUS = 'application/vnd.sus-calendar';
    public const SUSP = self::SUS;
    public const SVD = 'application/vnd.svd';
    public const VND_SWIFTVIEW_ICS = 'application/vnd.swiftview-ics';
    public const VND_SYBYL_MOL2 = 'application/vnd.sybyl.mol2';
    public const VND_SYCLE_XML = 'application/vnd.sycle+xml';
    public const VND_SYFT_JSON = 'application/vnd.syft+json';
    public const SIS = 'application/vnd.symbian.install';
    public const SISX = self::SIS;
    public const XSM = 'application/vnd.syncml+xml';
    public const BDM = 'application/vnd.syncml.dm+wbxml';
    public const XDM = 'application/vnd.syncml.dm+xml';
    public const VND_SYNCML_DM_NOTIFICATION = 'application/vnd.syncml.dm.notification';
    public const VND_SYNCML_DMDDF_WBXML = 'application/vnd.syncml.dmddf+wbxml';
    public const DDF = 'application/vnd.syncml.dmddf+xml';
    public const VND_SYNCML_DMTNDS_WBXML = 'application/vnd.syncml.dmtnds+wbxml';
    public const VND_SYNCML_DMTNDS_XML = 'application/vnd.syncml.dmtnds+xml';
    public const VND_SYNCML_DS_NOTIFICATION = 'application/vnd.syncml.ds.notification';
    public const VND_TABLESCHEMA_JSON = 'application/vnd.tableschema+json';
    public const TAO = 'application/vnd.tao.intent-module-archive';
    public const PCAP = 'application/vnd.tcpdump.pcap';
    public const CAP = self::PCAP;
    public const DMP = self::PCAP;
    public const VND_THINK_CELL_PPTTC_JSON = 'application/vnd.think-cell.ppttc+json';
    public const VND_TMD_MEDIAFLEX_API_XML = 'application/vnd.tmd.mediaflex.api+xml';
    public const VND_TML = 'application/vnd.tml';
    public const TMO = 'application/vnd.tmobile-livetv';
    public const VND_TRI_ONESOURCE = 'application/vnd.tri.onesource';
    public const TPT = 'application/vnd.trid.tpt';
    public const MXS = 'application/vnd.triscape.mxs';
    public const TRA = 'application/vnd.trueapp';
    public const VND_TRUEDOC = 'application/vnd.truedoc';
    public const VND_UBISOFT_WEBPLAYER = 'application/vnd.ubisoft.webplayer';
    public const UFD = 'application/vnd.ufdl';
    public const UFDL = self::UFD;
    public const UTZ = 'application/vnd.uiq.theme';
    public const UMJ = 'application/vnd.umajin';
    public const UNITYWEB = 'application/vnd.unity';
    public const UOML = 'application/vnd.uoml+xml';
    public const UO = self::UOML;
    public const VND_UPLANET_ALERT = 'application/vnd.uplanet.alert';
    public const VND_UPLANET_ALERT_WBXML = 'application/vnd.uplanet.alert-wbxml';
    public const VND_UPLANET_BEARER_CHOICE = 'application/vnd.uplanet.bearer-choice';
    public const VND_UPLANET_BEARER_CHOICE_WBXML = 'application/vnd.uplanet.bearer-choice-wbxml';
    public const VND_UPLANET_CACHEOP = 'application/vnd.uplanet.cacheop';
    public const VND_UPLANET_CACHEOP_WBXML = 'application/vnd.uplanet.cacheop-wbxml';
    public const VND_UPLANET_CHANNEL = 'application/vnd.uplanet.channel';
    public const VND_UPLANET_CHANNEL_WBXML = 'application/vnd.uplanet.channel-wbxml';
    public const VND_UPLANET_LIST = 'application/vnd.uplanet.list';
    public const VND_UPLANET_LIST_WBXML = 'application/vnd.uplanet.list-wbxml';
    public const VND_UPLANET_LISTCMD = 'application/vnd.uplanet.listcmd';
    public const VND_UPLANET_LISTCMD_WBXML = 'application/vnd.uplanet.listcmd-wbxml';
    public const VND_UPLANET_SIGNAL = 'application/vnd.uplanet.signal';
    public const VND_URI_MAP = 'application/vnd.uri-map';
    public const VND_VALVE_SOURCE_MATERIAL = 'application/vnd.valve.source.material';
    public const VCX = 'application/vnd.vcx';
    public const VND_VD_STUDY = 'application/vnd.vd-study';
    public const VND_VECTORWORKS = 'application/vnd.vectorworks';
    public const VND_VEL_JSON = 'application/vnd.vel+json';
    public const VND_VERIMATRIX_VCAS = 'application/vnd.verimatrix.vcas';
    public const VND_VERITONE_AION_JSON = 'application/vnd.veritone.aion+json';
    public const VND_VERYANT_THIN = 'application/vnd.veryant.thin';
    public const VND_VES_ENCRYPTED = 'application/vnd.ves.encrypted';
    public const VND_VIDSOFT_VIDCONFERENCE = 'application/vnd.vidsoft.vidconference';
    public const VSD = 'application/vnd.visio';
    public const VST = self::VSD;
    public const VSS = self::VSD;
    public const VSW = self::VSD;
    public const VIS = 'application/vnd.visionary';
    public const VND_VIVIDENCE_SCRIPTFILE = 'application/vnd.vividence.scriptfile';
    public const VSF = 'application/vnd.vsf';
    public const VND_WAP_SIC = 'application/vnd.wap.sic';
    public const VND_WAP_SLC = 'application/vnd.wap.slc';
    public const WBXML = 'application/vnd.wap.wbxml';
    public const WMLSC = 'application/vnd.wap.wmlscriptc';
    public const VND_WASMFLOW_WAFL = 'application/vnd.wasmflow.wafl';
    public const WTB = 'application/vnd.webturbo';
    public const VND_WFA_DPP = 'application/vnd.wfa.dpp';
    public const VND_WFA_P2P = 'application/vnd.wfa.p2p';
    public const VND_WFA_WSC = 'application/vnd.wfa.wsc';
    public const VND_WINDOWS_DEVICEPAIRING = 'application/vnd.windows.devicepairing';
    public const VND_WMC = 'application/vnd.wmc';
    public const VND_WMF_BOOTSTRAP = 'application/vnd.wmf.bootstrap';
    public const VND_WOLFRAM_MATHEMATICA = 'application/vnd.wolfram.mathematica';
    public const VND_WOLFRAM_MATHEMATICA_PACKAGE = 'application/vnd.wolfram.mathematica.package';
    public const NBP = 'application/vnd.wolfram.player';
    public const VND_WORDLIFT = 'application/vnd.wordlift';
    public const WPD = 'application/vnd.wordperfect';
    public const WQD = 'application/vnd.wqd';
    public const VND_WRQ_HP3000_LABELLED = 'application/vnd.wrq-hp3000-labelled';
    public const STF = 'application/vnd.wt.stf';
    public const VND_WV_CSP_WBXML = 'application/vnd.wv.csp+wbxml';
    public const VND_WV_CSP_XML = 'application/vnd.wv.csp+xml';
    public const VND_WV_SSP_XML = 'application/vnd.wv.ssp+xml';
    public const VND_XACML_JSON = 'application/vnd.xacml+json';
    public const XAR = 'application/vnd.xara';
    public const XFDL = 'application/vnd.xfdl';
    public const VND_XFDL_WEBFORM = 'application/vnd.xfdl.webform';
    public const VND_XMI_XML = 'application/vnd.xmi+xml';
    public const VND_XMPIE_CPKG = 'application/vnd.xmpie.cpkg';
    public const VND_XMPIE_DPKG = 'application/vnd.xmpie.dpkg';
    public const VND_XMPIE_PLAN = 'application/vnd.xmpie.plan';
    public const VND_XMPIE_PPKG = 'application/vnd.xmpie.ppkg';
    public const VND_XMPIE_XLIM = 'application/vnd.xmpie.xlim';
    public const HVD = 'application/vnd.yamaha.hv-dic';
    public const HVS = 'application/vnd.yamaha.hv-script';
    public const HVP = 'application/vnd.yamaha.hv-voice';
    public const OSF = 'application/vnd.yamaha.openscoreformat';
    public const OSFPVG = 'application/vnd.yamaha.openscoreformat.osfpvg+xml';
    public const VND_YAMAHA_REMOTE_SETUP = 'application/vnd.yamaha.remote-setup';
    public const SAF = 'application/vnd.yamaha.smaf-audio';
    public const SPF = 'application/vnd.yamaha.smaf-phrase';
    public const VND_YAMAHA_THROUGH_NGN = 'application/vnd.yamaha.through-ngn';
    public const VND_YAMAHA_TUNNEL_UDPENCAP = 'application/vnd.yamaha.tunnel-udpencap';
    public const VND_YAOWEME = 'application/vnd.yaoweme';
    public const CMP = 'application/vnd.yellowriver-custom-menu';
    public const ZIR = 'application/vnd.zul';
    public const ZIRZ = self::ZIR;
    public const ZAZ = 'application/vnd.zzazz.deck+xml';
    public const VXML = 'application/voicexml+xml';
    public const VOUCHER_CMS_JSON = 'application/voucher-cms+json';
    public const VQ_RTCPXR = 'application/vq-rtcpxr';
    public const WIF = 'application/watcherinfo+xml';
    public const WEBPUSH_OPTIONS_JSON = 'application/webpush-options+json';
    public const WHOISPP_QUERY = 'application/whoispp-query';
    public const WHOISPP_RESPONSE = 'application/whoispp-response';
    public const WGT = 'application/widget';
    public const HLP = 'application/winhlp';
    public const WITA = 'application/wita';
    public const WORDPERFECT5_1 = 'application/wordperfect5.1';
    public const WSDL = 'application/wsdl+xml';
    public const WSPOLICY = 'application/wspolicy+xml';
    public const ABW = 'application/x-abiword';
    public const ACE = 'application/x-ace-compressed';
    public const X_AMF = 'application/x-amf';
    public const ARJ = 'application/x-arj';
    public const AAB = 'application/x-authorware-bin';
    public const X32 = self::AAB;
    public const U32 = self::AAB;
    public const VOX = self::AAB;
    public const AAM = 'application/x-authorware-map';
    public const AAS = 'application/x-authorware-seg';
    public const BCPIO = 'application/x-bcpio';
    public const TORRENT = 'application/x-bittorrent';
    public const BLB = 'application/x-blorb';
    public const BLORB = self::BLB;
    public const BZ = 'application/x-bzip';
    public const BZ2 = 'application/x-bzip2';
    public const BOZ = self::BZ2;
    public const CBR = 'application/x-cbr';
    public const CBA = self::CBR;
    public const CBT = self::CBR;
    public const CBZ = self::CBR;
    public const CB7 = self::CBR;
    public const VCD = 'application/x-cdlink';
    public const CFS = 'application/x-cfs-compressed';
    public const CHAT = 'application/x-chat';
    public const PGN = 'application/x-chess-pgn';
    public const CRX = 'application/x-chrome-extension';
    public const X_COMPRESS = 'application/x-compress';
    public const NSC = 'application/x-conference';
    public const CPIO = 'application/x-cpio';
    public const CSH = 'application/x-csh';
    public const X_DEB = 'application/x-deb';
    public const UDEB = 'application/x-debian-package';
    public const DGC = 'application/x-dgc-compressed';
    public const DIR = 'application/x-director';
    public const DCR = self::DIR;
    public const DXR = self::DIR;
    public const CST = self::DIR;
    public const CCT = self::DIR;
    public const CXT = self::DIR;
    public const W3D = self::DIR;
    public const FGD = self::DIR;
    public const SWA = self::DIR;
    public const WAD = 'application/x-doom';
    public const NCX = 'application/x-dtbncx+xml';
    public const DTB = 'application/x-dtbook+xml';
    public const RES = 'application/x-dtbresource+xml';
    public const DVI = 'application/x-dvi';
    public const EVY = 'application/x-envoy';
    public const EVA = 'application/x-eva';
    public const BDF = 'application/x-font-bdf';
    public const X_FONT_DOS = 'application/x-font-dos';
    public const X_FONT_FRAMEMAKER = 'application/x-font-framemaker';
    public const GSF = 'application/x-font-ghostscript';
    public const X_FONT_LIBGRX = 'application/x-font-libgrx';
    public const PSF = 'application/x-font-linux-psf';
    public const PCF = 'application/x-font-pcf';
    public const SNF = 'application/x-font-snf';
    public const X_FONT_SPEEDO = 'application/x-font-speedo';
    public const X_FONT_SUNOS_NEWS = 'application/x-font-sunos-news';
    public const PFA = 'application/x-font-type1';
    public const PFB = self::PFA;
    public const PFM = self::PFA;
    public const AFM = self::PFA;
    public const X_FONT_VFONT = 'application/x-font-vfont';
    public const ARC = 'application/x-freearc';
    public const SPL = 'application/x-futuresplash';
    public const GCA = 'application/x-gca-compressed';
    public const ULX = 'application/x-glulx';
    public const GNUMERIC = 'application/x-gnumeric';
    public const GRAMPS = 'application/x-gramps-xml';
    public const GTAR = 'application/x-gtar';
    public const X_GZIP = 'application/x-gzip';
    public const HDF = 'application/x-hdf';
    public const PHP = 'application/x-httpd-php';
    public const INSTALL = 'application/x-install-instructions';
    public const X_JAVASCRIPT = 'application/x-javascript';
    public const KDBX = 'application/x-keepass2';
    public const LATEX = 'application/x-latex';
    public const LUAC = 'application/x-lua-bytecode';
    public const LZH = 'application/x-lzh-compressed';
    public const LHA = self::LZH;
    public const MIE = 'application/x-mie';
    public const MOBI = 'application/x-mobipocket-ebook';
    public const X_MPEGURL = 'application/x-mpegurl';
    public const APPLICATION = 'application/x-ms-application';
    public const LNK = 'application/x-ms-shortcut';
    public const WMD = 'application/x-ms-wmd';
    public const WMZ = 'application/x-ms-wmz';
    public const XBAP = 'application/x-ms-xbap';
    public const MDB = 'application/x-msaccess';
    public const OBD = 'application/x-msbinder';
    public const CRD = 'application/x-mscardfile';
    public const CLP = 'application/x-msclip';
    public const COM = 'application/x-msdownload';
    public const BAT = self::COM;
    public const MVB = 'application/x-msmediaview';
    public const M13 = self::MVB;
    public const M14 = self::MVB;
    public const WMF = 'application/x-msmetafile';
    public const EMF = self::WMF;
    public const EMZ = self::WMF;
    public const MNY = 'application/x-msmoney';
    public const PUB = 'application/x-mspublisher';
    public const SCD = 'application/x-msschedule';
    public const TRM = 'application/x-msterminal';
    public const WRI = 'application/x-mswrite';
    public const NC = 'application/x-netcdf';
    public const CDF = self::NC;
    public const PAC = 'application/x-ns-proxy-autoconfig';
    public const NZB = 'application/x-nzb';
    public const P12 = 'application/x-pkcs12';
    public const PFX = self::P12;
    public const P7B = 'application/x-pkcs7-certificates';
    public const SPC = self::P7B;
    public const P7R = 'application/x-pkcs7-certreqresp';
    public const X_PKI_MESSAGE = 'application/x-pki-message';
    public const RIS = 'application/x-research-info-systems';
    public const SH = 'application/x-sh';
    public const SHAR = 'application/x-shar';
    public const XAP = 'application/x-silverlight-app';
    public const SITX = 'application/x-stuffitx';
    public const SRT = 'application/x-subrip';
    public const SV4CPIO = 'application/x-sv4cpio';
    public const SV4CRC = 'application/x-sv4crc';
    public const T3 = 'application/x-t3vm-image';
    public const GAM = 'application/x-tads';
    public const TEX = 'application/x-tex';
    public const TFM = 'application/x-tex-tfm';
    public const TEXINFO = 'application/x-texinfo';
    public const TEXI = self::TEXINFO;
    public const OBJ = 'application/x-tgif';
    public const USTAR = 'application/x-ustar';
    public const HDD = 'application/x-virtualbox-hdd';
    public const OVA = 'application/x-virtualbox-ova';
    public const OVF = 'application/x-virtualbox-ovf';
    public const VBOX = 'application/x-virtualbox-vbox';
    public const VBOX_EXTPACK = 'application/x-virtualbox-vbox-extpack';
    public const VDI = 'application/x-virtualbox-vdi';
    public const VHD = 'application/x-virtualbox-vhd';
    public const VMDK = 'application/x-virtualbox-vmdk';
    public const SRC = 'application/x-wais-source';
    public const WEBAPP = 'application/x-web-app-manifest+json';
    public const X_WWW_FORM_URLENCODED = 'application/x-www-form-urlencoded';
    public const X_X509_CA_RA_CERT = 'application/x-x509-ca-ra-cert';
    public const X_X509_NEXT_CA_CERT = 'application/x-x509-next-ca-cert';
    public const FIG = 'application/x-xfig';
    public const XLF = 'application/x-xliff+xml';
    public const XZ = 'application/x-xz';
    public const Z1 = 'application/x-zmachine';
    public const Z2 = self::Z1;
    public const Z3 = self::Z1;
    public const Z4 = self::Z1;
    public const Z5 = self::Z1;
    public const Z6 = self::Z1;
    public const Z7 = self::Z1;
    public const Z8 = self::Z1;
    public const X400_BP = 'application/x400-bp';
    public const XACML_XML = 'application/xacml+xml';
    public const XAML = 'application/xaml+xml';
    public const XAV = 'application/xcap-att+xml';
    public const XCA = 'application/xcap-caps+xml';
    public const XDF = 'application/xcap-diff+xml';
    public const XEL = 'application/xcap-el+xml';
    public const XCAP_ERROR_XML = 'application/xcap-error+xml';
    public const XNS = 'application/xcap-ns+xml';
    public const XCON_CONFERENCE_INFO_XML = 'application/xcon-conference-info+xml';
    public const XCON_CONFERENCE_INFO_DIFF_XML = 'application/xcon-conference-info-diff+xml';
    public const XENC = 'application/xenc+xml';
    public const XHTML_VOICE_XML = 'application/xhtml-voice+xml';
    public const XSL = 'application/xml';
    public const XSD = self::XSL;
    public const RNG = self::XSL;
    public const DTD = 'application/xml-dtd';
    public const XML_EXTERNAL_PARSED_ENTITY = 'application/xml-external-parsed-entity';
    public const XML_PATCH_XML = 'application/xml-patch+xml';
    public const XMPP_XML = 'application/xmpp+xml';
    public const XOP = 'application/xop+xml';
    public const XPL = 'application/xproc+xml';
    public const XSLT = 'application/xslt+xml';
    public const MXML = 'application/xv+xml';
    public const XHVML = self::MXML;
    public const XVML = self::MXML;
    public const XVM = self::MXML;
    public const YANG = 'application/yang';
    public const YANG_DATA_CBOR = 'application/yang-data+cbor';
    public const YANG_DATA_JSON = 'application/yang-data+json';
    public const YANG_DATA_XML = 'application/yang-data+xml';
    public const YANG_PATCH_JSON = 'application/yang-patch+json';
    public const YANG_PATCH_XML = 'application/yang-patch+xml';
    public const YIN = 'application/yin+xml';
    public const ZLIB = 'application/zlib';
    public const ZSTD = 'application/zstd';
    public const _32KADPCM = 'audio/32kadpcm';
    public const _3GPP2 = 'audio/3gpp2';
    public const AAC = 'audio/aac';
    public const AC3 = 'audio/ac3';
    public const ADP = 'audio/adpcm';
    public const AMR = 'audio/amr';
    public const AMR_WB = 'audio/amr-wb';
    public const AMR_WB_ = 'audio/amr-wb+';
    public const APTX = 'audio/aptx';
    public const ATRAC_ADVANCED_LOSSLESS = 'audio/atrac-advanced-lossless';
    public const ATRAC_X = 'audio/atrac-x';
    public const ATRAC3 = 'audio/atrac3';
    public const AU = 'audio/basic';
    public const SND = self::AU;
    public const BV16 = 'audio/bv16';
    public const BV32 = 'audio/bv32';
    public const CLEARMODE = 'audio/clearmode';
    public const CN = 'audio/cn';
    public const DAT12 = 'audio/dat12';
    public const DLS = 'audio/dls';
    public const DSR_ES201108 = 'audio/dsr-es201108';
    public const DSR_ES202050 = 'audio/dsr-es202050';
    public const DSR_ES202211 = 'audio/dsr-es202211';
    public const DSR_ES202212 = 'audio/dsr-es202212';
    public const DV = 'audio/dv';
    public const DVI4 = 'audio/dvi4';
    public const EAC3 = 'audio/eac3';
    public const EVRC = 'audio/evrc';
    public const EVRC_QCP = 'audio/evrc-qcp';
    public const EVRC0 = 'audio/evrc0';
    public const EVRC1 = 'audio/evrc1';
    public const EVRCB = 'audio/evrcb';
    public const EVRCB0 = 'audio/evrcb0';
    public const EVRCB1 = 'audio/evrcb1';
    public const EVRCNW = 'audio/evrcnw';
    public const EVRCNW0 = 'audio/evrcnw0';
    public const EVRCNW1 = 'audio/evrcnw1';
    public const EVRCWB = 'audio/evrcwb';
    public const EVRCWB0 = 'audio/evrcwb0';
    public const EVRCWB1 = 'audio/evrcwb1';
    public const EVS = 'audio/evs';
    public const FWDRED = 'audio/fwdred';
    public const G711_0 = 'audio/g711-0';
    public const G719 = 'audio/g719';
    public const G722 = 'audio/g722';
    public const G7221 = 'audio/g7221';
    public const G723 = 'audio/g723';
    public const G726_16 = 'audio/g726-16';
    public const G726_24 = 'audio/g726-24';
    public const G726_32 = 'audio/g726-32';
    public const G726_40 = 'audio/g726-40';
    public const G728 = 'audio/g728';
    public const G729 = 'audio/g729';
    public const G7291 = 'audio/g7291';
    public const G729D = 'audio/g729d';
    public const G729E = 'audio/g729e';
    public const GSM = 'audio/gsm';
    public const GSM_EFR = 'audio/gsm-efr';
    public const GSM_HR_08 = 'audio/gsm-hr-08';
    public const ILBC = 'audio/ilbc';
    public const IP_MR_V2_5 = 'audio/ip-mr_v2.5';
    public const ISAC = 'audio/isac';
    public const L16 = 'audio/l16';
    public const L20 = 'audio/l20';
    public const L24 = 'audio/l24';
    public const L8 = 'audio/l8';
    public const LPC = 'audio/lpc';
    public const MELP = 'audio/melp';
    public const MELP1200 = 'audio/melp1200';
    public const MELP2400 = 'audio/melp2400';
    public const MELP600 = 'audio/melp600';
    public const MHAS = 'audio/mhas';
    public const MXMF = 'audio/mobile-xmf';
    public const MP4A = 'audio/mp4';
    public const MP4A_LATM = 'audio/mp4a-latm';
    public const MPA = 'audio/mpa';
    public const MPA_ROBUST = 'audio/mpa-robust';
    public const MUSEPACK = 'audio/musepack';
    public const PCMA = 'audio/pcma';
    public const PCMA_WB = 'audio/pcma-wb';
    public const PCMU = 'audio/pcmu';
    public const PCMU_WB = 'audio/pcmu-wb';
    public const PRS_SID = 'audio/prs.sid';
    public const QCELP = 'audio/qcelp';
    public const RED = 'audio/red';
    public const RTP_ENC_AESCM128 = 'audio/rtp-enc-aescm128';
    public const RTP_MIDI = 'audio/rtp-midi';
    public const S3M = 'audio/s3m';
    public const SCIP = 'audio/scip';
    public const SIL = 'audio/silk';
    public const SMV = 'audio/smv';
    public const SMV_QCP = 'audio/smv-qcp';
    public const SMV0 = 'audio/smv0';
    public const SOFA = 'audio/sofa';
    public const SP_MIDI = 'audio/sp-midi';
    public const SPEEX = 'audio/speex';
    public const T140C = 'audio/t140c';
    public const T38 = 'audio/t38';
    public const TELEPHONE_EVENT = 'audio/telephone-event';
    public const TETRA_ACELP = 'audio/tetra_acelp';
    public const TETRA_ACELP_BB = 'audio/tetra_acelp_bb';
    public const TONE = 'audio/tone';
    public const TSVCIS = 'audio/tsvcis';
    public const UEMCLIP = 'audio/uemclip';
    public const USAC = 'audio/usac';
    public const VDVI = 'audio/vdvi';
    public const VMR_WB = 'audio/vmr-wb';
    public const VND_3GPP_IUFP = 'audio/vnd.3gpp.iufp';
    public const VND_4SB = 'audio/vnd.4sb';
    public const VND_AUDIOKOZ = 'audio/vnd.audiokoz';
    public const VND_CELP = 'audio/vnd.celp';
    public const VND_CISCO_NSE = 'audio/vnd.cisco.nse';
    public const VND_CMLES_RADIO_EVENTS = 'audio/vnd.cmles.radio-events';
    public const VND_CNS_ANP1 = 'audio/vnd.cns.anp1';
    public const VND_CNS_INF1 = 'audio/vnd.cns.inf1';
    public const UVA = 'audio/vnd.dece.audio';
    public const UVVA = self::UVA;
    public const EOL = 'audio/vnd.digital-winds';
    public const VND_DLNA_ADTS = 'audio/vnd.dlna.adts';
    public const VND_DOLBY_HEAAC_1 = 'audio/vnd.dolby.heaac.1';
    public const VND_DOLBY_HEAAC_2 = 'audio/vnd.dolby.heaac.2';
    public const VND_DOLBY_MLP = 'audio/vnd.dolby.mlp';
    public const VND_DOLBY_MPS = 'audio/vnd.dolby.mps';
    public const VND_DOLBY_PL2 = 'audio/vnd.dolby.pl2';
    public const VND_DOLBY_PL2X = 'audio/vnd.dolby.pl2x';
    public const VND_DOLBY_PL2Z = 'audio/vnd.dolby.pl2z';
    public const VND_DOLBY_PULSE_1 = 'audio/vnd.dolby.pulse.1';
    public const DRA = 'audio/vnd.dra';
    public const DTS = 'audio/vnd.dts';
    public const DTSHD = 'audio/vnd.dts.hd';
    public const VND_DTS_UHD = 'audio/vnd.dts.uhd';
    public const VND_DVB_FILE = 'audio/vnd.dvb.file';
    public const VND_EVERAD_PLJ = 'audio/vnd.everad.plj';
    public const VND_HNS_AUDIO = 'audio/vnd.hns.audio';
    public const LVP = 'audio/vnd.lucent.voice';
    public const PYA = 'audio/vnd.ms-playready.media.pya';
    public const VND_NOKIA_MOBILE_XMF = 'audio/vnd.nokia.mobile-xmf';
    public const VND_NORTEL_VBK = 'audio/vnd.nortel.vbk';
    public const ECELP4800 = 'audio/vnd.nuera.ecelp4800';
    public const ECELP7470 = 'audio/vnd.nuera.ecelp7470';
    public const ECELP9600 = 'audio/vnd.nuera.ecelp9600';
    public const VND_OCTEL_SBC = 'audio/vnd.octel.sbc';
    public const VND_PRESONUS_MULTITRACK = 'audio/vnd.presonus.multitrack';
    public const VND_QCELP = 'audio/vnd.qcelp';
    public const VND_RHETOREX_32KADPCM = 'audio/vnd.rhetorex.32kadpcm';
    public const RIP = 'audio/vnd.rip';
    public const VND_RN_REALAUDIO = 'audio/vnd.rn-realaudio';
    public const VND_SEALEDMEDIA_SOFTSEAL_MPEG = 'audio/vnd.sealedmedia.softseal.mpeg';
    public const VND_VMX_CVSD = 'audio/vnd.vmx.cvsd';
    public const VND_WAVE = 'audio/vnd.wave';
    public const VORBIS = 'audio/vorbis';
    public const VORBIS_CONFIG = 'audio/vorbis-config';
    public const WAV = 'audio/wav';
    public const WEBA = 'audio/webm';
    public const AIF = 'audio/x-aiff';
    public const AIFF = self::AIF;
    public const AIFC = self::AIF;
    public const CAF = 'audio/x-caf';
    public const FLAC = 'audio/x-flac';
    public const MKA = 'audio/x-matroska';
    public const M3U = 'audio/x-mpegurl';
    public const WAX = 'audio/x-ms-wax';
    public const WMA = 'audio/x-ms-wma';
    public const RAM = 'audio/x-pn-realaudio';
    public const RMP = 'audio/x-pn-realaudio-plugin';
    public const X_TTA = 'audio/x-tta';
    public const XM = 'audio/xm';
    public const CDX = 'chemical/x-cdx';
    public const CIF = 'chemical/x-cif';
    public const CMDF = 'chemical/x-cmdf';
    public const CML = 'chemical/x-cml';
    public const CSML = 'chemical/x-csml';
    public const X_PDB = 'chemical/x-pdb';
    public const XYZ = 'chemical/x-xyz';
    public const TTC = 'font/collection';
    public const OTF = 'font/otf';
    public const SFNT = 'font/sfnt';
    public const TTF = 'font/ttf';
    public const EXR = 'image/aces';
    public const APNG = 'image/apng';
    public const AVCI = 'image/avci';
    public const AVCS = 'image/avcs';
    public const DIB = 'image/bmp';
    public const CGM = 'image/cgm';
    public const DRLE = 'image/dicom-rle';
    public const DPX = 'image/dpx';
    public const G3 = 'image/g3fax';
    public const HEIC = 'image/heic';
    public const HEICS = 'image/heic-sequence';
    public const HEIF = 'image/heif';
    public const HEIFS = 'image/heif-sequence';
    public const HEJ2 = 'image/hej2k';
    public const HSJ2 = 'image/hsj2';
    public const IEF = 'image/ief';
    public const JLS = 'image/jls';
    public const JP2 = 'image/jp2';
    public const JPH = 'image/jph';
    public const JHC = 'image/jphc';
    public const JPM = 'image/jpm';
    public const JPX = 'image/jpx';
    public const JXR = 'image/jxr';
    public const JXRA = 'image/jxra';
    public const JXRS = 'image/jxrs';
    public const JXS = 'image/jxs';
    public const JXSC = 'image/jxsc';
    public const JXSI = 'image/jxsi';
    public const JXSS = 'image/jxss';
    public const KTX = 'image/ktx';
    public const KTX2 = 'image/ktx2';
    public const NAPLPS = 'image/naplps';
    public const PJPEG = 'image/pjpeg';
    public const BTIF = 'image/prs.btif';
    public const BTF = self::BTIF;
    public const PTI = 'image/prs.pti';
    public const PWG_RASTER = 'image/pwg-raster';
    public const SGI = 'image/sgi';
    public const TFX = 'image/tiff-fx';
    public const PSD = 'image/vnd.adobe.photoshop';
    public const AZV = 'image/vnd.airzip.accelerator.azv';
    public const VND_CNS_INF2 = 'image/vnd.cns.inf2';
    public const UVI = 'image/vnd.dece.graphic';
    public const UVVI = self::UVI;
    public const UVG = self::UVI;
    public const UVVG = self::UVI;
    public const DJVU = 'image/vnd.djvu';
    public const DJV = self::DJVU;
    public const SUB = 'image/vnd.dvb.subtitle';
    public const DWG = 'image/vnd.dwg';
    public const DXF = 'image/vnd.dxf';
    public const FBS = 'image/vnd.fastbidsheet';
    public const FPX = 'image/vnd.fpx';
    public const FST = 'image/vnd.fst';
    public const MMR = 'image/vnd.fujixerox.edmics-mmr';
    public const RLC = 'image/vnd.fujixerox.edmics-rlc';
    public const VND_GLOBALGRAPHICS_PGB = 'image/vnd.globalgraphics.pgb';
    public const VND_MIX = 'image/vnd.mix';
    public const VND_MOZILLA_APNG = 'image/vnd.mozilla.apng';
    public const DDS = 'image/vnd.ms-dds';
    public const MDI = 'image/vnd.ms-modi';
    public const WDP = 'image/vnd.ms-photo';
    public const NPX = 'image/vnd.net-fpx';
    public const B16 = 'image/vnd.pco.b16';
    public const VND_RADIANCE = 'image/vnd.radiance';
    public const VND_SEALED_PNG = 'image/vnd.sealed.png';
    public const VND_SEALEDMEDIA_SOFTSEAL_GIF = 'image/vnd.sealedmedia.softseal.gif';
    public const VND_SEALEDMEDIA_SOFTSEAL_JPG = 'image/vnd.sealedmedia.softseal.jpg';
    public const VND_SVF = 'image/vnd.svf';
    public const TAP = 'image/vnd.tencent.tap';
    public const VTF = 'image/vnd.valve.source.texture';
    public const XIF = 'image/vnd.xiff';
    public const PCX = 'image/vnd.zbrush.pcx';
    public const _3DS = 'image/x-3ds';
    public const RAS = 'image/x-cmu-raster';
    public const CMX = 'image/x-cmx';
    public const FH = 'image/x-freehand';
    public const FHC = self::FH;
    public const FH4 = self::FH;
    public const FH5 = self::FH;
    public const FH7 = self::FH;
    public const SID = 'image/x-mrsid-image';
    public const PIC = 'image/x-pict';
    public const PCT = self::PIC;
    public const PNM = 'image/x-portable-anymap';
    public const PBM = 'image/x-portable-bitmap';
    public const PGM = 'image/x-portable-graymap';
    public const PPM = 'image/x-portable-pixmap';
    public const RGB = 'image/x-rgb';
    public const TGA = 'image/x-tga';
    public const XBM = 'image/x-xbitmap';
    public const X_XCF = 'image/x-xcf';
    public const XPM = 'image/x-xpixmap';
    public const XWD = 'image/x-xwindowdump';
    public const BHTTP = 'message/bhttp';
    public const CPIM = 'message/cpim';
    public const DELIVERY_STATUS = 'message/delivery-status';
    public const DISPOSITION_NOTIFICATION = 'message/disposition-notification';
    public const EXTERNAL_BODY = 'message/external-body';
    public const FEEDBACK_REPORT = 'message/feedback-report';
    public const U8MSG = 'message/global';
    public const U8DSN = 'message/global-delivery-status';
    public const U8MDN = 'message/global-disposition-notification';
    public const U8HDR = 'message/global-headers';
    public const IMDN_XML = 'message/imdn+xml';
    public const NEWS = 'message/news';
    public const PARTIAL = 'message/partial';
    public const EML = 'message/rfc822';
    public const MIME = self::EML;
    public const S_HTTP = 'message/s-http';
    public const SIP = 'message/sip';
    public const SIPFRAG = 'message/sipfrag';
    public const TRACKING_STATUS = 'message/tracking-status';
    public const VND_SI_SIMP = 'message/vnd.si.simp';
    public const WSC = 'message/vnd.wfa.wsc';
    public const _3MF = 'model/3mf';
    public const E57 = 'model/e57';
    public const GLTF = 'model/gltf+json';
    public const GLB = 'model/gltf-binary';
    public const IGS = 'model/iges';
    public const JT = 'model/jt';
    public const MESH = 'model/mesh';
    public const MTL = 'model/mtl';
    public const STEP = 'model/step';
    public const STPX = 'model/step+xml';
    public const STPZ = 'model/step+zip';
    public const STPXZ = 'model/step-xml+zip';
    public const U3D = 'model/u3d';
    public const CLD = 'model/vnd.cld';
    public const DAE = 'model/vnd.collada+xml';
    public const DWF = 'model/vnd.dwf';
    public const VND_FLATLAND_3DML = 'model/vnd.flatland.3dml';
    public const GDL = 'model/vnd.gdl';
    public const VND_GS_GDL = 'model/vnd.gs-gdl';
    public const GTW = 'model/vnd.gtw';
    public const VND_MOML_XML = 'model/vnd.moml+xml';
    public const MTS = 'model/vnd.mts';
    public const OGEX = 'model/vnd.opengex';
    public const X_B = 'model/vnd.parasolid.transmit.binary';
    public const X_T = 'model/vnd.parasolid.transmit.text';
    public const PYO = 'model/vnd.pytha.pyox';
    public const PYOX = self::PYO;
    public const VND_ROSETTE_ANNOTATED_DATA_MODEL = 'model/vnd.rosette.annotated-data-model';
    public const VDS = 'model/vnd.sap.vds';
    public const USDA = 'model/vnd.usda';
    public const USDZ = 'model/vnd.usdz+zip';
    public const BSP = 'model/vnd.valve.source.compiled-map';
    public const VTU = 'model/vnd.vtu';
    public const VRML = 'model/vrml';
    public const X3DB = 'model/x3d+binary';
    public const X3DBZ = self::X3DB;
    public const X3DV = 'model/x3d+vrml';
    public const X3DVZ = self::X3DV;
    public const X3D = 'model/x3d+xml';
    public const X3DZ = self::X3D;
    public const ALTERNATIVE = 'multipart/alternative';
    public const APPLEDOUBLE = 'multipart/appledouble';
    public const BYTERANGES = 'multipart/byteranges';
    public const DIGEST = 'multipart/digest';
    public const ENCRYPTED = 'multipart/encrypted';
    public const FORM_DATA = 'multipart/form-data';
    public const HEADER_SET = 'multipart/header-set';
    public const MIXED = 'multipart/mixed';
    public const MULTILINGUAL = 'multipart/multilingual';
    public const PARALLEL = 'multipart/parallel';
    public const RELATED = 'multipart/related';
    public const REPORT = 'multipart/report';
    public const SIGNED = 'multipart/signed';
    public const VND_BINT_MED_PLUS = 'multipart/vnd.bint.med-plus';
    public const VOICE_MESSAGE = 'multipart/voice-message';
    public const X_MIXED_REPLACE = 'multipart/x-mixed-replace';
    public const APPCACHE = 'text/cache-manifest';
    public const MANIFEST = self::APPCACHE;
    public const ICS = 'text/calendar';
    public const IFB = self::ICS;
    public const CALENDER = 'text/calender';
    public const CMD = 'text/cmd';
    public const COFFEE = 'text/coffeescript';
    public const LITCOFFEE = self::COFFEE;
    public const CQL = 'text/cql';
    public const CQL_EXPRESSION = 'text/cql-expression';
    public const CQL_IDENTIFIER = 'text/cql-identifier';
    public const CSV = 'text/csv';
    public const CSV_SCHEMA = 'text/csv-schema';
    public const DIRECTORY = 'text/directory';
    public const ECMASCRIPT = 'text/ecmascript';
    public const ENRICHED = 'text/enriched';
    public const FHIRPATH = 'text/fhirpath';
    public const GFF3 = 'text/gff3';
    public const GRAMMAR_REF_LIST = 'text/grammar-ref-list';
    public const HL7V2 = 'text/hl7v2';
    public const JADE = 'text/jade';
    public const MJS = 'text/javascript';
    public const JCR_CND = 'text/jcr-cnd';
    public const JSX = 'text/jsx';
    public const LESS = 'text/less';
    public const MARKDOWN = 'text/markdown';
    public const MDX = 'text/mdx';
    public const MIZAR = 'text/mizar';
    public const N3 = 'text/n3';
    public const PARAMETERS = 'text/parameters';
    public const PROVENANCE_NOTATION = 'text/provenance-notation';
    public const PRS_FALLENSTEIN_RST = 'text/prs.fallenstein.rst';
    public const DSC = 'text/prs.lines.tag';
    public const PRS_PROP_LOGIC = 'text/prs.prop.logic';
    public const RFC822_HEADERS = 'text/rfc822-headers';
    public const SGM = 'text/sgml';
    public const SHACLC = 'text/shaclc';
    public const SHEX = 'text/shex';
    public const SLIM = 'text/slim';
    public const SPDX = 'text/spdx';
    public const STRINGS = 'text/strings';
    public const STYLUS = 'text/stylus';
    public const T140 = 'text/t140';
    public const TSV = 'text/tab-separated-values';
    public const T = 'text/troff';
    public const TR = self::T;
    public const ROFF = self::T;
    public const MAN = self::T;
    public const ME = self::T;
    public const MS = self::T;
    public const TTL = 'text/turtle';
    public const URI = 'text/uri-list';
    public const URIS = self::URI;
    public const URLS = self::URI;
    public const VCARD = 'text/vcard';
    public const VND_A = 'text/vnd.a';
    public const VND_ABC = 'text/vnd.abc';
    public const VND_ASCII_ART = 'text/vnd.ascii-art';
    public const CURL = 'text/vnd.curl';
    public const DCURL = 'text/vnd.curl.dcurl';
    public const MCURL = 'text/vnd.curl.mcurl';
    public const SCURL = 'text/vnd.curl.scurl';
    public const VND_DEBIAN_COPYRIGHT = 'text/vnd.debian.copyright';
    public const VND_DMCLIENTSCRIPT = 'text/vnd.dmclientscript';
    public const VND_ESMERTEC_THEME_DESCRIPTOR = 'text/vnd.esmertec.theme-descriptor';
    public const VND_EXCHANGEABLE = 'text/vnd.exchangeable';
    public const GED = 'text/vnd.familysearch.gedcom';
    public const VND_FICLAB_FLT = 'text/vnd.ficlab.flt';
    public const FLY = 'text/vnd.fly';
    public const FLX = 'text/vnd.fmi.flexstor';
    public const VND_GML = 'text/vnd.gml';
    public const GV = 'text/vnd.graphviz';
    public const VND_HANS = 'text/vnd.hans';
    public const VND_HGL = 'text/vnd.hgl';
    public const _3DML = 'text/vnd.in3d.3dml';
    public const SPOT = 'text/vnd.in3d.spot';
    public const VND_IPTC_NEWSML = 'text/vnd.iptc.newsml';
    public const VND_IPTC_NITF = 'text/vnd.iptc.nitf';
    public const VND_LATEX_Z = 'text/vnd.latex-z';
    public const VND_MOTOROLA_REFLEX = 'text/vnd.motorola.reflex';
    public const VND_MS_MEDIAPACKAGE = 'text/vnd.ms-mediapackage';
    public const VND_NET2PHONE_COMMCENTER_COMMAND = 'text/vnd.net2phone.commcenter.command';
    public const VND_RADISYS_MSML_BASIC_LAYOUT = 'text/vnd.radisys.msml-basic-layout';
    public const VND_SENX_WARPSCRIPT = 'text/vnd.senx.warpscript';
    public const VND_SI_URICATALOGUE = 'text/vnd.si.uricatalogue';
    public const VND_SOSI = 'text/vnd.sosi';
    public const VND_TROLLTECH_LINGUIST = 'text/vnd.trolltech.linguist';
    public const VND_WAP_SI = 'text/vnd.wap.si';
    public const VND_WAP_SL = 'text/vnd.wap.sl';
    public const WMLS = 'text/vnd.wap.wmlscript';
    public const VTT = 'text/vtt';
    public const WGSL = 'text/wgsl';
    public const S = 'text/x-asm';
    public const ASM = self::S;
    public const C = 'text/x-c';
    public const CC = self::C;
    public const CXX = self::C;
    public const CPP = self::C;
    public const H = self::C;
    public const HH = self::C;
    public const DIC = self::C;
    public const F = 'text/x-fortran';
    public const FOR = self::F;
    public const F77 = self::F;
    public const F90 = self::F;
    public const X_GWT_RPC = 'text/x-gwt-rpc';
    public const HBS = 'text/x-handlebars-template';
    public const JAVA = 'text/x-java-source';
    public const X_JQUERY_TMPL = 'text/x-jquery-tmpl';
    public const LUA = 'text/x-lua';
    public const MKD = 'text/x-markdown';
    public const NFO = 'text/x-nfo';
    public const OPML = 'text/x-opml';
    public const P = 'text/x-pascal';
    public const PAS = self::P;
    public const PDE = 'text/x-processing';
    public const SASS = 'text/x-sass';
    public const SCSS = 'text/x-scss';
    public const ETX = 'text/x-setext';
    public const SFV = 'text/x-sfv';
    public const YMP = 'text/x-suse-ymp';
    public const UU = 'text/x-uuencode';
    public const VCS = 'text/x-vcalendar';
    public const VCF = 'text/x-vcard';
    public const YAML = 'text/yaml';
    public const _3GPP_TT = 'video/3gpp-tt';
    public const _3G2 = 'video/3gpp2';
    public const AV1 = 'video/av1';
    public const BMPEG = 'video/bmpeg';
    public const BT656 = 'video/bt656';
    public const CELB = 'video/celb';
    public const FFV1 = 'video/ffv1';
    public const H261 = 'video/h261';
    public const H263 = 'video/h263';
    public const H263_1998 = 'video/h263-1998';
    public const H263_2000 = 'video/h263-2000';
    public const H264 = 'video/h264';
    public const H264_RCDO = 'video/h264-rcdo';
    public const H264_SVC = 'video/h264-svc';
    public const H265 = 'video/h265';
    public const H266 = 'video/h266';
    public const M4S = 'video/iso.segment';
    public const JPGV = 'video/jpeg';
    public const JPEG2000 = 'video/jpeg2000';
    public const JXSV = 'video/jxsv';
    public const MJ2 = 'video/mj2';
    public const MP1S = 'video/mp1s';
    public const MP2P = 'video/mp2p';
    public const MP4V_ES = 'video/mp4v-es';
    public const MPV = 'video/mpv';
    public const NV = 'video/nv';
    public const OGV = 'video/ogg';
    public const POINTER = 'video/pointer';
    public const RAW = 'video/raw';
    public const SMPTE291 = 'video/smpte291';
    public const SMPTE292M = 'video/smpte292m';
    public const VC1 = 'video/vc1';
    public const VC2 = 'video/vc2';
    public const VND_CCTV = 'video/vnd.cctv';
    public const UVH = 'video/vnd.dece.hd';
    public const UVVH = self::UVH;
    public const UVM = 'video/vnd.dece.mobile';
    public const UVVM = self::UVM;
    public const VND_DECE_MP4 = 'video/vnd.dece.mp4';
    public const UVP = 'video/vnd.dece.pd';
    public const UVVP = self::UVP;
    public const UVS = 'video/vnd.dece.sd';
    public const UVVS = self::UVS;
    public const UVV = 'video/vnd.dece.video';
    public const UVVV = self::UVV;
    public const VND_DIRECTV_MPEG = 'video/vnd.directv.mpeg';
    public const VND_DIRECTV_MPEG_TTS = 'video/vnd.directv.mpeg-tts';
    public const VND_DLNA_MPEG_TTS = 'video/vnd.dlna.mpeg-tts';
    public const DVB = 'video/vnd.dvb.file';
    public const FVT = 'video/vnd.fvt';
    public const VND_HNS_VIDEO = 'video/vnd.hns.video';
    public const VND_IPTVFORUM_1DPARITYFEC_1010 = 'video/vnd.iptvforum.1dparityfec-1010';
    public const VND_IPTVFORUM_1DPARITYFEC_2005 = 'video/vnd.iptvforum.1dparityfec-2005';
    public const VND_IPTVFORUM_2DPARITYFEC_1010 = 'video/vnd.iptvforum.2dparityfec-1010';
    public const VND_IPTVFORUM_2DPARITYFEC_2005 = 'video/vnd.iptvforum.2dparityfec-2005';
    public const VND_IPTVFORUM_TTSAVC = 'video/vnd.iptvforum.ttsavc';
    public const VND_IPTVFORUM_TTSMPEG2 = 'video/vnd.iptvforum.ttsmpeg2';
    public const VND_MOTOROLA_VIDEO = 'video/vnd.motorola.video';
    public const VND_MOTOROLA_VIDEOP = 'video/vnd.motorola.videop';
    public const MXU = 'video/vnd.mpegurl';
    public const M4U = self::MXU;
    public const PYV = 'video/vnd.ms-playready.media.pyv';
    public const VND_NOKIA_INTERLEAVED_MULTIMEDIA = 'video/vnd.nokia.interleaved-multimedia';
    public const VND_NOKIA_MP4VR = 'video/vnd.nokia.mp4vr';
    public const VND_NOKIA_VIDEOVOIP = 'video/vnd.nokia.videovoip';
    public const VND_OBJECTVIDEO = 'video/vnd.objectvideo';
    public const VND_RADGAMETTOOLS_BINK = 'video/vnd.radgamettools.bink';
    public const VND_RADGAMETTOOLS_SMACKER = 'video/vnd.radgamettools.smacker';
    public const VND_SEALED_MPEG1 = 'video/vnd.sealed.mpeg1';
    public const VND_SEALED_MPEG4 = 'video/vnd.sealed.mpeg4';
    public const VND_SEALED_SWF = 'video/vnd.sealed.swf';
    public const VND_SEALEDMEDIA_SOFTSEAL_MOV = 'video/vnd.sealedmedia.softseal.mov';
    public const UVU = 'video/vnd.uvvu.mp4';
    public const UVVU = self::UVU;
    public const VIV = 'video/vnd.vivo';
    public const VND_YOUTUBE_YT = 'video/vnd.youtube.yt';
    public const VP8 = 'video/vp8';
    public const VP9 = 'video/vp9';
    public const F4V = 'video/x-f4v';
    public const FLI = 'video/x-fli';
    public const MKV = 'video/x-matroska';
    public const MK3D = self::MKV;
    public const MKS = self::MKV;
    public const VOB = 'video/x-ms-vob';
    public const WM = 'video/x-ms-wm';
    public const WMX = 'video/x-ms-wmx';
    public const WVX = 'video/x-ms-wvx';
    public const MOVIE = 'video/x-sgi-movie';
    public const ICE = 'x-conference/x-cooltalk';
    public const X_FRAGMENT = 'x-shader/x-fragment';
    public const X_VERTEX = 'x-shader/x-vertex';

    protected const EXTENSION_MAP = [
        'html' => self::HTML,
        'htm' => self::HTML,
        'shtml' => self::HTML,
        'css' => self::CSS,
        'xml' => self::XML,
        'gif' => self::GIF,
        'jpeg' => self::JPEG,
        'jpg' => self::JPEG,
        'js' => self::JS,
        'atom' => self::ATOM,
        'rss' => self::RSS,
        'mml' => self::MML,
        'txt' => self::INI,
        'jad' => self::JAD,
        'wml' => self::WML,
        'htc' => self::HTC,
        'avif' => self::AVIF,
        'png' => self::PNG,
        'svg' => self::SVGZ,
        'svgz' => self::SVGZ,
        'tif' => self::TIFF,
        'tiff' => self::TIFF,
        'wbmp' => self::WBMP,
        'webp' => self::WEBP,
        'ico' => self::ICO,
        'jng' => self::JNG,
        'bmp' => self::BMP,
        'woff' => self::WOFF,
        'woff2' => self::WOFF2,
        'jar' => self::EAR,
        'war' => self::EAR,
        'ear' => self::EAR,
        'json' => self::JSON,
        'hqx' => self::HQX,
        'doc' => self::DOT,
        'pdf' => self::PDF,
        'ps' => self::AI,
        'eps' => self::AI,
        'ai' => self::AI,
        'rtf' => self::RTF,
        'm3u8' => self::M3U8,
        'kml' => self::KML,
        'kmz' => self::KMZ,
        'xls' => self::XLW,
        'eot' => self::EOT,
        'ppt' => self::POT,
        'odg' => self::ODG,
        'odp' => self::ODP,
        'ods' => self::ODS,
        'odt' => self::ODT,
        'pptx' => self::PPTX,
        'xlsx' => self::XLSX,
        'docx' => self::DOCX,
        'wmlc' => self::WMLC,
        'wasm' => self::WASM,
        '7z' => self::_7Z,
        'cco' => self::CCO,
        'jardiff' => self::JARDIFF,
        'jnlp' => self::JNLP,
        'run' => self::RUN,
        'pl' => self::PM,
        'pm' => self::PM,
        'prc' => self::PDB,
        'pdb' => self::PDB,
        'rar' => self::RAR,
        'rpm' => self::RPM,
        'sea' => self::SEA,
        'swf' => self::SWF,
        'sit' => self::SIT,
        'tcl' => self::TK,
        'tk' => self::TK,
        'der' => self::CRT,
        'pem' => self::CRT,
        'crt' => self::CRT,
        'xpi' => self::XPI,
        'xhtml' => self::XHT,
        'xspf' => self::XSPF,
        'zip' => self::ZIP,
        'bin' => self::BUFFER,
        'exe' => self::BUFFER,
        'dll' => self::BUFFER,
        'deb' => self::BUFFER,
        'dmg' => self::BUFFER,
        'iso' => self::BUFFER,
        'img' => self::BUFFER,
        'msi' => self::BUFFER,
        'msp' => self::BUFFER,
        'msm' => self::BUFFER,
        'mid' => self::MIDI,
        'midi' => self::MIDI,
        'kar' => self::MIDI,
        'mp3' => self::M3A,
        'ogg' => self::OGG,
        'm4a' => self::M4A,
        'ra' => self::RA,
        '3gpp' => self::_3GPP,
        '3gp' => self::_3GPP,
        'ts' => self::TS,
        'mp4' => self::MP4,
        'mpeg' => self::MPEG,
        'mpg' => self::MPEG,
        'mov' => self::QT,
        'webm' => self::WEBM,
        'flv' => self::FLV,
        'm4v' => self::M4V,
        'mng' => self::MNG,
        'asx' => self::ASF,
        'asf' => self::ASF,
        'wmv' => self::WMV,
        'avi' => self::AVI,
        'ez' => self::EZ,
        'appinstaller' => self::APPINSTALLER,
        'aw' => self::AW,
        'appx' => self::APPX,
        'appxbundle' => self::APPXBUNDLE,
        'atomcat' => self::ATOMCAT,
        'atomdeleted' => self::ATOMDELETED,
        'atomsvc' => self::ATOMSVC,
        'dwd' => self::DWD,
        'held' => self::HELD,
        'rsat' => self::RSAT,
        'amlx' => self::AMLX,
        'bdoc' => self::BDOC,
        'xcs' => self::XCS,
        'ccxml' => self::CCXML,
        'cdfx' => self::CDFX,
        'cdmia' => self::CDMIA,
        'cdmic' => self::CDMIC,
        'cdmid' => self::CDMID,
        'cdmio' => self::CDMIO,
        'cdmiq' => self::CDMIQ,
        'cpl' => self::CPL,
        'cu' => self::CU,
        'cwl' => self::CWL,
        'mpd' => self::MPD,
        'mpp' => self::MPP,
        'davmount' => self::DAVMOUNT,
        'dbk' => self::DBK,
        'dssc' => self::DSSC,
        'xdssc' => self::XDSSC,
        'ecma' => self::ECMA,
        'emma' => self::EMMA,
        'emotionml' => self::EMOTIONML,
        'epub' => self::EPUB,
        'exi' => self::EXI,
        'exp' => self::EXP,
        'fdf' => self::FDF,
        'fdt' => self::FDT,
        'pfr' => self::PFR,
        'geojson' => self::GEOJSON,
        'gml' => self::GML,
        'gpx' => self::GPX,
        'gxf' => self::GXF,
        'gz' => self::GZ,
        'hjson' => self::HJSON,
        'stk' => self::STK,
        'ink' => self::INKML,
        'inkml' => self::INKML,
        'ipfix' => self::IPFIX,
        'its' => self::ITS,
        'ser' => self::SER,
        'class' => self::_CLASS,
        'map' => self::JSON,
        'json5' => self::JSON5,
        'jsonml' => self::JSONML,
        'jsonld' => self::JSONLD,
        'lgr' => self::LGR,
        'lostxml' => self::LOSTXML,
        'cpt' => self::CPT,
        'mads' => self::MADS,
        'webmanifest' => self::WEBMANIFEST,
        'mrc' => self::MRC,
        'mrcx' => self::MRCX,
        'ma' => self::MB,
        'nb' => self::MB,
        'mb' => self::MB,
        'mathml' => self::MATHML,
        'mbox' => self::MBOX,
        'mpf' => self::MPF,
        'mscml' => self::MSCML,
        'metalink' => self::METALINK,
        'meta4' => self::META4,
        'mets' => self::METS,
        'maei' => self::MAEI,
        'musd' => self::MUSD,
        'mods' => self::MODS,
        'm21' => self::MP21,
        'mp21' => self::MP21,
        'mpg4' => self::M4P,
        'mp4s' => self::M4P,
        'm4p' => self::M4P,
        'msix' => self::MSIX,
        'msixbundle' => self::MSIXBUNDLE,
        'dot' => self::DOT,
        'mxf' => self::MXF,
        'nq' => self::NQ,
        'nt' => self::NT,
        'cjs' => self::CJS,
        'dms' => self::BUFFER,
        'lrf' => self::BUFFER,
        'mar' => self::BUFFER,
        'so' => self::BUFFER,
        'dist' => self::BUFFER,
        'distz' => self::BUFFER,
        'pkg' => self::BUFFER,
        'bpk' => self::BUFFER,
        'dump' => self::BUFFER,
        'elc' => self::BUFFER,
        'deploy' => self::BUFFER,
        'buffer' => self::BUFFER,
        'oda' => self::ODA,
        'opf' => self::OPF,
        'ogx' => self::OGX,
        'omdoc' => self::OMDOC,
        'onetoc' => self::ONEPKG,
        'onetoc2' => self::ONEPKG,
        'onetmp' => self::ONEPKG,
        'onepkg' => self::ONEPKG,
        'oxps' => self::OXPS,
        'relo' => self::RELO,
        'xer' => self::XER,
        'pgp' => self::PGP,
        'sig' => self::SIG,
        'prf' => self::PRF,
        'p10' => self::P10,
        'p7m' => self::P7C,
        'p7c' => self::P7C,
        'p7s' => self::P7S,
        'p8' => self::P8,
        'ac' => self::AC,
        'cer' => self::CER,
        'crl' => self::CRL,
        'pkipath' => self::PKIPATH,
        'pki' => self::PKI,
        'pls' => self::PLS,
        'provx' => self::PROVX,
        'cww' => self::CWW,
        'xsf' => self::XSF,
        'pskcxml' => self::PSKCXML,
        'raml' => self::RAML,
        'rdf' => self::OWL,
        'owl' => self::OWL,
        'rif' => self::RIF,
        'rnc' => self::RNC,
        'rl' => self::RL,
        'rld' => self::RLD,
        'rs' => self::RS,
        'rapd' => self::RAPD,
        'sls' => self::SLS,
        'rusd' => self::RUSD,
        'gbr' => self::GBR,
        'mft' => self::MFT,
        'roa' => self::ROA,
        'rsd' => self::RSD,
        'sbml' => self::SBML,
        'scq' => self::SCQ,
        'scs' => self::SCS,
        'spq' => self::SPQ,
        'spp' => self::SPP,
        'sdp' => self::SDP,
        'senmlx' => self::SENMLX,
        'sensmlx' => self::SENSMLX,
        'setpay' => self::SETPAY,
        'setreg' => self::SETREG,
        'shf' => self::SHF,
        'siv' => self::SIEVE,
        'sieve' => self::SIEVE,
        'smi' => self::SMI,
        'rq' => self::RQ,
        'srx' => self::SRX,
        'sql' => self::SQL,
        'gram' => self::GRAM,
        'grxml' => self::GRXML,
        'sru' => self::SRU,
        'ssdl' => self::SSDL,
        'ssml' => self::SSML,
        'swidtag' => self::SWIDTAG,
        'tei' => self::TEICORPUS,
        'teicorpus' => self::TEICORPUS,
        'tfi' => self::TFI,
        'tsd' => self::TSD,
        'toml' => self::TOML,
        'trig' => self::TRIG,
        'ttml' => self::TTML,
        'ubj' => self::UBJ,
        'rsheet' => self::RSHEET,
        'td' => self::TD,
        '1km' => self::_1KM,
        'plb' => self::PLB,
        'psb' => self::PSB,
        'pvb' => self::PVB,
        'tcap' => self::TCAP,
        'pwn' => self::PWN,
        'aso' => self::ASO,
        'imp' => self::IMP,
        'acu' => self::ACU,
        'atc' => self::ACUTC,
        'acutc' => self::ACUTC,
        'air' => self::AIR,
        'fcdt' => self::FCDT,
        'fxp' => self::FXPL,
        'fxpl' => self::FXPL,
        'xdp' => self::XDP,
        'xfdf' => self::XFDF,
        'age' => self::AGE,
        'ahead' => self::AHEAD,
        'azf' => self::AZF,
        'azs' => self::AZS,
        'azw' => self::AZW,
        'acc' => self::ACC,
        'ami' => self::AMI,
        'apk' => self::APK,
        'cii' => self::CII,
        'fti' => self::FTI,
        'atx' => self::ATX,
        'mpkg' => self::MPKG,
        'key' => self::KEY,
        'numbers' => self::NUMBERS,
        'pages' => self::PAGES,
        'pkpass' => self::PKPASS,
        'swi' => self::SWI,
        'iota' => self::IOTA,
        'aep' => self::AEP,
        'bmml' => self::BMML,
        'mpm' => self::MPM,
        'bmi' => self::BMI,
        'rep' => self::REP,
        'cdxml' => self::CDXML,
        'mmd' => self::MMD,
        'cdy' => self::CDY,
        'csl' => self::CSL,
        'cla' => self::CLA,
        'rp9' => self::RP9,
        'c4g' => self::C4U,
        'c4d' => self::C4U,
        'c4f' => self::C4U,
        'c4p' => self::C4U,
        'c4u' => self::C4U,
        'c11amc' => self::C11AMC,
        'c11amz' => self::C11AMZ,
        'csp' => self::CSP,
        'cdbcmsg' => self::CDBCMSG,
        'cmc' => self::CMC,
        'clkx' => self::CLKX,
        'clkk' => self::CLKK,
        'clkp' => self::CLKP,
        'clkt' => self::CLKT,
        'clkw' => self::CLKW,
        'wbs' => self::WBS,
        'pml' => self::PML,
        'ppd' => self::PPD,
        'car' => self::CAR,
        'pcurl' => self::PCURL,
        'rdz' => self::RDZ,
        'dbf' => self::DBF,
        'uvf' => self::UVVD,
        'uvvf' => self::UVVD,
        'uvd' => self::UVVD,
        'uvvd' => self::UVVD,
        'uvt' => self::UVVT,
        'uvvt' => self::UVVT,
        'uvx' => self::UVVX,
        'uvvx' => self::UVVX,
        'uvz' => self::UVVZ,
        'uvvz' => self::UVVZ,
        'fe_launch' => self::FE_LAUNCH,
        'dna' => self::DNA,
        'mlp' => self::MLP,
        'dpg' => self::DPG,
        'dfac' => self::DFAC,
        'kpxx' => self::KPXX,
        'ait' => self::AIT,
        'svc' => self::SVC,
        'geo' => self::GEO,
        'mag' => self::MAG,
        'nml' => self::NML,
        'esf' => self::ESF,
        'msf' => self::MSF,
        'qam' => self::QAM,
        'slt' => self::SLT,
        'ssf' => self::SSF,
        'es3' => self::ET3,
        'et3' => self::ET3,
        'ez2' => self::EZ2,
        'ez3' => self::EZ3,
        'mseed' => self::MSEED,
        'seed' => self::DATALESS,
        'dataless' => self::DATALESS,
        'gph' => self::GPH,
        'ftc' => self::FTC,
        'fm' => self::BOOK,
        'frame' => self::BOOK,
        'maker' => self::BOOK,
        'book' => self::BOOK,
        'fnc' => self::FNC,
        'ltf' => self::LTF,
        'fsc' => self::FSC,
        'oas' => self::OAS,
        'oa2' => self::OA2,
        'oa3' => self::OA3,
        'fg5' => self::FG5,
        'bh2' => self::BH2,
        'ddd' => self::DDD,
        'xdw' => self::XDW,
        'xbd' => self::XBD,
        'fzs' => self::FZS,
        'txd' => self::TXD,
        'ggb' => self::GGB,
        'ggt' => self::GGT,
        'gex' => self::GRE,
        'gre' => self::GRE,
        'gxt' => self::GXT,
        'g2w' => self::G2W,
        'g3w' => self::G3W,
        'gmx' => self::GMX,
        'gdoc' => self::GDOC,
        'gslides' => self::GSLIDES,
        'gsheet' => self::GSHEET,
        'gqf' => self::GQS,
        'gqs' => self::GQS,
        'gac' => self::GAC,
        'ghf' => self::GHF,
        'gim' => self::GIM,
        'grv' => self::GRV,
        'gtm' => self::GTM,
        'tpl' => self::TPL,
        'vcg' => self::VCG,
        'hal' => self::HAL,
        'zmm' => self::ZMM,
        'hbci' => self::HBCI,
        'les' => self::LES,
        'hpgl' => self::HPGL,
        'hpid' => self::HPID,
        'hps' => self::HPS,
        'jlt' => self::JLT,
        'pcl' => self::PCL,
        'pclxl' => self::PCLXL,
        'sfd-hdstx' => self::SFD_HDSTX,
        'mpy' => self::MPY,
        'afp' => self::LIST3820,
        'listafp' => self::LIST3820,
        'list3820' => self::LIST3820,
        'irm' => self::IRM,
        'sc' => self::SC,
        'icc' => self::ICM,
        'icm' => self::ICM,
        'igl' => self::IGL,
        'ivp' => self::IVP,
        'ivu' => self::IVU,
        'igm' => self::IGM,
        'xpw' => self::XPX,
        'xpx' => self::XPX,
        'i2g' => self::I2G,
        'qbo' => self::QBO,
        'qfx' => self::QFX,
        'rcprofile' => self::RCPROFILE,
        'irp' => self::IRP,
        'xpr' => self::XPR,
        'fcs' => self::FCS,
        'jam' => self::JAM,
        'rms' => self::RMS,
        'jisp' => self::JISP,
        'joda' => self::JODA,
        'ktz' => self::KTR,
        'ktr' => self::KTR,
        'karbon' => self::KARBON,
        'chrt' => self::CHRT,
        'kfo' => self::KFO,
        'flw' => self::FLW,
        'kon' => self::KON,
        'kpr' => self::KPT,
        'kpt' => self::KPT,
        'ksp' => self::KSP,
        'kwd' => self::KWT,
        'kwt' => self::KWT,
        'htke' => self::HTKE,
        'kia' => self::KIA,
        'kne' => self::KNP,
        'knp' => self::KNP,
        'skp' => self::SKM,
        'skd' => self::SKM,
        'skt' => self::SKM,
        'skm' => self::SKM,
        'sse' => self::SSE,
        'lasxml' => self::LASXML,
        'lbd' => self::LBD,
        'lbe' => self::LBE,
        '123' => self::_123,
        'apr' => self::APR,
        'pre' => self::PRE,
        'nsf' => self::NSF,
        'org' => self::ORG,
        'scm' => self::SCM,
        'lwp' => self::LWP,
        'portpkg' => self::PORTPKG,
        'mvt' => self::MVT,
        'mcd' => self::MCD,
        'mc1' => self::MC1,
        'cdkey' => self::CDKEY,
        'mwf' => self::MWF,
        'mfm' => self::MFM,
        'flo' => self::FLO,
        'igx' => self::IGX,
        'mif' => self::MIF,
        'daf' => self::DAF,
        'dis' => self::DIS,
        'mbk' => self::MBK,
        'mqy' => self::MQY,
        'msl' => self::MSL,
        'plc' => self::PLC,
        'txf' => self::TXF,
        'mpn' => self::MPN,
        'mpc' => self::MPC,
        'xul' => self::XUL,
        'cil' => self::CIL,
        'cab' => self::CAB,
        'xlm' => self::XLW,
        'xla' => self::XLW,
        'xlc' => self::XLW,
        'xlt' => self::XLW,
        'xlw' => self::XLW,
        'xlam' => self::XLAM,
        'xlsb' => self::XLSB,
        'xlsm' => self::XLSM,
        'xltm' => self::XLTM,
        'chm' => self::CHM,
        'ims' => self::IMS,
        'lrm' => self::LRM,
        'thmx' => self::THMX,
        'msg' => self::MSG,
        'cat' => self::CAT,
        'stl' => self::STL,
        'pps' => self::POT,
        'pot' => self::POT,
        'ppam' => self::PPAM,
        'pptm' => self::PPTM,
        'sldm' => self::SLDM,
        'ppsm' => self::PPSM,
        'potm' => self::POTM,
        'mpt' => self::MPT,
        'docm' => self::DOCM,
        'dotm' => self::DOTM,
        'wps' => self::WDB,
        'wks' => self::WDB,
        'wcm' => self::WDB,
        'wdb' => self::WDB,
        'wpl' => self::WPL,
        'xps' => self::XPS,
        'mseq' => self::MSEQ,
        'mus' => self::MUS,
        'msty' => self::MSTY,
        'taglet' => self::TAGLET,
        'nlu' => self::NLU,
        'ntf' => self::NITF,
        'nitf' => self::NITF,
        'nnd' => self::NND,
        'nns' => self::NNS,
        'nnw' => self::NNW,
        'ngdat' => self::NGDAT,
        'n-gage' => self::N_GAGE,
        'rpst' => self::RPST,
        'rpss' => self::RPSS,
        'edm' => self::EDM,
        'edx' => self::EDX,
        'ext' => self::EXT,
        'odc' => self::ODC,
        'otc' => self::OTC,
        'odb' => self::ODB,
        'odf' => self::ODF,
        'odft' => self::ODFT,
        'otg' => self::OTG,
        'odi' => self::ODI,
        'oti' => self::OTI,
        'otp' => self::OTP,
        'ots' => self::OTS,
        'odm' => self::ODM,
        'ott' => self::OTT,
        'oth' => self::OTH,
        'xo' => self::XO,
        'dd2' => self::DD2,
        'obgx' => self::OBGX,
        'oxt' => self::OXT,
        'osm' => self::OSM,
        'sldx' => self::SLDX,
        'ppsx' => self::PPSX,
        'potx' => self::POTX,
        'xltx' => self::XLTX,
        'dotx' => self::DOTX,
        'mgp' => self::MGP,
        'dp' => self::DP,
        'esa' => self::ESA,
        'pqa' => self::OPRC,
        'oprc' => self::OPRC,
        'paw' => self::PAW,
        'str' => self::STR,
        'ei6' => self::EI6,
        'efif' => self::EFIF,
        'wg' => self::WG,
        'plf' => self::PLF,
        'pbd' => self::PBD,
        'box' => self::BOX,
        'mgz' => self::MGZ,
        'qps' => self::QPS,
        'ptid' => self::PTID,
        'xhtm' => self::XHTM,
        'qxd' => self::QXB,
        'qxt' => self::QXB,
        'qwd' => self::QXB,
        'qwt' => self::QXB,
        'qxl' => self::QXB,
        'qxb' => self::QXB,
        'bed' => self::BED,
        'mxl' => self::MXL,
        'musicxml' => self::MUSICXML,
        'cryptonote' => self::CRYPTONOTE,
        'cod' => self::COD,
        'rm' => self::RM,
        'rmvb' => self::RMVB,
        'link66' => self::LINK66,
        'st' => self::ST,
        'see' => self::SEE,
        'sema' => self::SEMA,
        'semd' => self::SEMD,
        'semf' => self::SEMF,
        'ifm' => self::IFM,
        'itp' => self::ITP,
        'iif' => self::IIF,
        'ipk' => self::IPK,
        'twd' => self::TWDS,
        'twds' => self::TWDS,
        'mmf' => self::MMF,
        'teacher' => self::TEACHER,
        'fo' => self::FO,
        'sdkm' => self::SDKD,
        'sdkd' => self::SDKD,
        'dxp' => self::DXP,
        'sfs' => self::SFS,
        'sdc' => self::SDC,
        'sda' => self::SDA,
        'sdd' => self::SDD,
        'smf' => self::SMF,
        'sdw' => self::VOR,
        'vor' => self::VOR,
        'sgl' => self::SGL,
        'smzip' => self::SMZIP,
        'sm' => self::SM,
        'wadl' => self::WADL,
        'sxc' => self::SXC,
        'stc' => self::STC,
        'sxd' => self::SXD,
        'std' => self::STD,
        'sxi' => self::SXI,
        'sti' => self::STI,
        'sxm' => self::SXM,
        'sxw' => self::SXW,
        'sxg' => self::SXG,
        'stw' => self::STW,
        'sus' => self::SUSP,
        'susp' => self::SUSP,
        'svd' => self::SVD,
        'sis' => self::SISX,
        'sisx' => self::SISX,
        'xsm' => self::XSM,
        'bdm' => self::BDM,
        'xdm' => self::XDM,
        'ddf' => self::DDF,
        'tao' => self::TAO,
        'pcap' => self::DMP,
        'cap' => self::DMP,
        'dmp' => self::DMP,
        'tmo' => self::TMO,
        'tpt' => self::TPT,
        'mxs' => self::MXS,
        'tra' => self::TRA,
        'ufd' => self::UFDL,
        'ufdl' => self::UFDL,
        'utz' => self::UTZ,
        'umj' => self::UMJ,
        'unityweb' => self::UNITYWEB,
        'uoml' => self::UO,
        'uo' => self::UO,
        'vcx' => self::VCX,
        'vsd' => self::VSW,
        'vst' => self::VSW,
        'vss' => self::VSW,
        'vsw' => self::VSW,
        'vis' => self::VIS,
        'vsf' => self::VSF,
        'wbxml' => self::WBXML,
        'wmlsc' => self::WMLSC,
        'wtb' => self::WTB,
        'nbp' => self::NBP,
        'wpd' => self::WPD,
        'wqd' => self::WQD,
        'stf' => self::STF,
        'xar' => self::XAR,
        'xfdl' => self::XFDL,
        'hvd' => self::HVD,
        'hvs' => self::HVS,
        'hvp' => self::HVP,
        'osf' => self::OSF,
        'osfpvg' => self::OSFPVG,
        'saf' => self::SAF,
        'spf' => self::SPF,
        'cmp' => self::CMP,
        'zir' => self::ZIRZ,
        'zirz' => self::ZIRZ,
        'zaz' => self::ZAZ,
        'vxml' => self::VXML,
        'wif' => self::WIF,
        'wgt' => self::WGT,
        'hlp' => self::HLP,
        'wsdl' => self::WSDL,
        'wspolicy' => self::WSPOLICY,
        'abw' => self::ABW,
        'ace' => self::ACE,
        'arj' => self::ARJ,
        'aab' => self::VOX,
        'x32' => self::VOX,
        'u32' => self::VOX,
        'vox' => self::VOX,
        'aam' => self::AAM,
        'aas' => self::AAS,
        'bcpio' => self::BCPIO,
        'torrent' => self::TORRENT,
        'blb' => self::BLORB,
        'blorb' => self::BLORB,
        'bz' => self::BZ,
        'bz2' => self::BOZ,
        'boz' => self::BOZ,
        'cbr' => self::CB7,
        'cba' => self::CB7,
        'cbt' => self::CB7,
        'cbz' => self::CB7,
        'cb7' => self::CB7,
        'vcd' => self::VCD,
        'cfs' => self::CFS,
        'chat' => self::CHAT,
        'pgn' => self::PGN,
        'crx' => self::CRX,
        'nsc' => self::NSC,
        'cpio' => self::CPIO,
        'csh' => self::CSH,
        'udeb' => self::UDEB,
        'dgc' => self::DGC,
        'dir' => self::SWA,
        'dcr' => self::SWA,
        'dxr' => self::SWA,
        'cst' => self::SWA,
        'cct' => self::SWA,
        'cxt' => self::SWA,
        'w3d' => self::SWA,
        'fgd' => self::SWA,
        'swa' => self::SWA,
        'wad' => self::WAD,
        'ncx' => self::NCX,
        'dtb' => self::DTB,
        'res' => self::RES,
        'dvi' => self::DVI,
        'evy' => self::EVY,
        'eva' => self::EVA,
        'bdf' => self::BDF,
        'gsf' => self::GSF,
        'psf' => self::PSF,
        'pcf' => self::PCF,
        'snf' => self::SNF,
        'pfa' => self::AFM,
        'pfb' => self::AFM,
        'pfm' => self::AFM,
        'afm' => self::AFM,
        'arc' => self::ARC,
        'spl' => self::SPL,
        'gca' => self::GCA,
        'ulx' => self::ULX,
        'gnumeric' => self::GNUMERIC,
        'gramps' => self::GRAMPS,
        'gtar' => self::GTAR,
        'hdf' => self::HDF,
        'php' => self::PHP,
        'install' => self::INSTALL,
        'kdbx' => self::KDBX,
        'latex' => self::LATEX,
        'luac' => self::LUAC,
        'lzh' => self::LHA,
        'lha' => self::LHA,
        'mie' => self::MIE,
        'mobi' => self::MOBI,
        'application' => self::APPLICATION,
        'lnk' => self::LNK,
        'wmd' => self::WMD,
        'wmz' => self::WMZ,
        'xbap' => self::XBAP,
        'mdb' => self::MDB,
        'obd' => self::OBD,
        'crd' => self::CRD,
        'clp' => self::CLP,
        'com' => self::BAT,
        'bat' => self::BAT,
        'mvb' => self::M14,
        'm13' => self::M14,
        'm14' => self::M14,
        'wmf' => self::EMZ,
        'emf' => self::EMZ,
        'emz' => self::EMZ,
        'mny' => self::MNY,
        'pub' => self::PUB,
        'scd' => self::SCD,
        'trm' => self::TRM,
        'wri' => self::WRI,
        'nc' => self::CDF,
        'cdf' => self::CDF,
        'pac' => self::PAC,
        'nzb' => self::NZB,
        'p12' => self::PFX,
        'pfx' => self::PFX,
        'p7b' => self::SPC,
        'spc' => self::SPC,
        'p7r' => self::P7R,
        'ris' => self::RIS,
        'sh' => self::SH,
        'shar' => self::SHAR,
        'xap' => self::XAP,
        'sitx' => self::SITX,
        'srt' => self::SRT,
        'sv4cpio' => self::SV4CPIO,
        'sv4crc' => self::SV4CRC,
        't3' => self::T3,
        'gam' => self::GAM,
        'tex' => self::TEX,
        'tfm' => self::TFM,
        'texinfo' => self::TEXI,
        'texi' => self::TEXI,
        'obj' => self::OBJ,
        'ustar' => self::USTAR,
        'hdd' => self::HDD,
        'ova' => self::OVA,
        'ovf' => self::OVF,
        'vbox' => self::VBOX,
        'vbox-extpack' => self::VBOX_EXTPACK,
        'vdi' => self::VDI,
        'vhd' => self::VHD,
        'vmdk' => self::VMDK,
        'src' => self::SRC,
        'webapp' => self::WEBAPP,
        'fig' => self::FIG,
        'xlf' => self::XLF,
        'xz' => self::XZ,
        'z1' => self::Z8,
        'z2' => self::Z8,
        'z3' => self::Z8,
        'z4' => self::Z8,
        'z5' => self::Z8,
        'z6' => self::Z8,
        'z7' => self::Z8,
        'z8' => self::Z8,
        'xaml' => self::XAML,
        'xav' => self::XAV,
        'xca' => self::XCA,
        'xdf' => self::XDF,
        'xel' => self::XEL,
        'xns' => self::XNS,
        'xenc' => self::XENC,
        'xht' => self::XHT,
        'xsl' => self::RNG,
        'xsd' => self::RNG,
        'rng' => self::RNG,
        'dtd' => self::DTD,
        'xop' => self::XOP,
        'xpl' => self::XPL,
        'xslt' => self::XSLT,
        'mxml' => self::XVM,
        'xhvml' => self::XVM,
        'xvml' => self::XVM,
        'xvm' => self::XVM,
        'yang' => self::YANG,
        'yin' => self::YIN,
        'adts' => self::AAC,
        'aac' => self::AAC,
        'adp' => self::ADP,
        'amr' => self::AMR,
        'au' => self::SND,
        'snd' => self::SND,
        'rmi' => self::MIDI,
        'mxmf' => self::MXMF,
        'mp4a' => self::MP4A,
        'mpga' => self::M3A,
        'mp2' => self::M3A,
        'mp2a' => self::M3A,
        'm2a' => self::M3A,
        'm3a' => self::M3A,
        'oga' => self::OGG,
        'spx' => self::OGG,
        's3m' => self::S3M,
        'sil' => self::SIL,
        'uva' => self::UVVA,
        'uvva' => self::UVVA,
        'eol' => self::EOL,
        'dra' => self::DRA,
        'dts' => self::DTS,
        'dtshd' => self::DTSHD,
        'lvp' => self::LVP,
        'pya' => self::PYA,
        'ecelp4800' => self::ECELP4800,
        'ecelp7470' => self::ECELP7470,
        'ecelp9600' => self::ECELP9600,
        'rip' => self::RIP,
        'wav' => self::WAV,
        'weba' => self::WEBA,
        'aif' => self::AIFC,
        'aiff' => self::AIFC,
        'aifc' => self::AIFC,
        'caf' => self::CAF,
        'flac' => self::FLAC,
        'mka' => self::MKA,
        'm3u' => self::M3U,
        'wax' => self::WAX,
        'wma' => self::WMA,
        'ram' => self::RAM,
        'rmp' => self::RMP,
        'xm' => self::XM,
        'cdx' => self::CDX,
        'cif' => self::CIF,
        'cmdf' => self::CMDF,
        'cml' => self::CML,
        'csml' => self::CSML,
        'xyz' => self::XYZ,
        'ttc' => self::TTC,
        'otf' => self::OTF,
        'ttf' => self::TTF,
        'exr' => self::EXR,
        'apng' => self::APNG,
        'avci' => self::AVCI,
        'avcs' => self::AVCS,
        'dib' => self::DIB,
        'cgm' => self::CGM,
        'drle' => self::DRLE,
        'dpx' => self::DPX,
        'g3' => self::G3,
        'heic' => self::HEIC,
        'heics' => self::HEICS,
        'heif' => self::HEIF,
        'heifs' => self::HEIFS,
        'hej2' => self::HEJ2,
        'hsj2' => self::HSJ2,
        'ief' => self::IEF,
        'jls' => self::JLS,
        'jp2' => self::JP2,
        'jpg2' => self::JP2,
        'jpe' => self::JPEG,
        'jph' => self::JPH,
        'jhc' => self::JHC,
        'jpm' => self::JPM,
        'jpgm' => self::JPM,
        'jpx' => self::JPX,
        'jpf' => self::JPX,
        'jxr' => self::JXR,
        'jxra' => self::JXRA,
        'jxrs' => self::JXRS,
        'jxs' => self::JXS,
        'jxsc' => self::JXSC,
        'jxsi' => self::JXSI,
        'jxss' => self::JXSS,
        'ktx' => self::KTX,
        'ktx2' => self::KTX2,
        'btif' => self::BTF,
        'btf' => self::BTF,
        'pti' => self::PTI,
        'sgi' => self::SGI,
        'tfx' => self::TFX,
        'psd' => self::PSD,
        'azv' => self::AZV,
        'uvi' => self::UVVG,
        'uvvi' => self::UVVG,
        'uvg' => self::UVVG,
        'uvvg' => self::UVVG,
        'djvu' => self::DJV,
        'djv' => self::DJV,
        'sub' => self::SUB,
        'dwg' => self::DWG,
        'dxf' => self::DXF,
        'fbs' => self::FBS,
        'fpx' => self::FPX,
        'fst' => self::FST,
        'mmr' => self::MMR,
        'rlc' => self::RLC,
        'dds' => self::DDS,
        'mdi' => self::MDI,
        'wdp' => self::WDP,
        'npx' => self::NPX,
        'b16' => self::B16,
        'tap' => self::TAP,
        'vtf' => self::VTF,
        'xif' => self::XIF,
        'pcx' => self::PCX,
        '3ds' => self::_3DS,
        'ras' => self::RAS,
        'cmx' => self::CMX,
        'fh' => self::FH7,
        'fhc' => self::FH7,
        'fh4' => self::FH7,
        'fh5' => self::FH7,
        'fh7' => self::FH7,
        'sid' => self::SID,
        'pic' => self::PCT,
        'pct' => self::PCT,
        'pnm' => self::PNM,
        'pbm' => self::PBM,
        'pgm' => self::PGM,
        'ppm' => self::PPM,
        'rgb' => self::RGB,
        'tga' => self::TGA,
        'xbm' => self::XBM,
        'xpm' => self::XPM,
        'xwd' => self::XWD,
        'disposition-notification' => self::DISPOSITION_NOTIFICATION,
        'u8msg' => self::U8MSG,
        'u8dsn' => self::U8DSN,
        'u8mdn' => self::U8MDN,
        'u8hdr' => self::U8HDR,
        'eml' => self::MIME,
        'mime' => self::MIME,
        'wsc' => self::WSC,
        '3mf' => self::_3MF,
        'gltf' => self::GLTF,
        'glb' => self::GLB,
        'igs' => self::IGS,
        'jt' => self::JT,
        'msh' => self::MESH,
        'mesh' => self::MESH,
        'silo' => self::MESH,
        'mtl' => self::MTL,
        'stpx' => self::STPX,
        'stpz' => self::STPZ,
        'stpxz' => self::STPXZ,
        'u3d' => self::U3D,
        'cld' => self::CLD,
        'dae' => self::DAE,
        'dwf' => self::DWF,
        'gdl' => self::GDL,
        'gtw' => self::GTW,
        'mts' => self::MTS,
        'ogex' => self::OGEX,
        'x_b' => self::X_B,
        'x_t' => self::X_T,
        'pyo' => self::PYOX,
        'pyox' => self::PYOX,
        'vds' => self::VDS,
        'usda' => self::USDA,
        'usdz' => self::USDZ,
        'bsp' => self::BSP,
        'vtu' => self::VTU,
        'wrl' => self::VRML,
        'vrml' => self::VRML,
        'x3db' => self::X3DBZ,
        'x3dbz' => self::X3DBZ,
        'x3dv' => self::X3DVZ,
        'x3dvz' => self::X3DVZ,
        'x3d' => self::X3DZ,
        'x3dz' => self::X3DZ,
        'appcache' => self::MANIFEST,
        'manifest' => self::MANIFEST,
        'ics' => self::IFB,
        'ifb' => self::IFB,
        'coffee' => self::LITCOFFEE,
        'litcoffee' => self::LITCOFFEE,
        'csv' => self::CSV,
        'jade' => self::JADE,
        'mjs' => self::MJS,
        'jsx' => self::JSX,
        'less' => self::LESS,
        'md' => self::MARKDOWN,
        'markdown' => self::MARKDOWN,
        'mdx' => self::MDX,
        'n3' => self::N3,
        'text' => self::INI,
        'conf' => self::INI,
        'def' => self::INI,
        'list' => self::INI,
        'log' => self::INI,
        'in' => self::INI,
        'ini' => self::INI,
        'dsc' => self::DSC,
        'sgm' => self::SGM,
        'shex' => self::SHEX,
        'slim' => self::SLIM,
        'slm' => self::SLIM,
        'spdx' => self::SPDX,
        'stylus' => self::STYLUS,
        'styl' => self::STYLUS,
        'tsv' => self::TSV,
        't' => self::MS,
        'tr' => self::MS,
        'roff' => self::MS,
        'man' => self::MS,
        'me' => self::MS,
        'ms' => self::MS,
        'ttl' => self::TTL,
        'uri' => self::URLS,
        'uris' => self::URLS,
        'urls' => self::URLS,
        'vcard' => self::VCARD,
        'curl' => self::CURL,
        'dcurl' => self::DCURL,
        'mcurl' => self::MCURL,
        'scurl' => self::SCURL,
        'ged' => self::GED,
        'fly' => self::FLY,
        'flx' => self::FLX,
        'gv' => self::GV,
        '3dml' => self::_3DML,
        'spot' => self::SPOT,
        'wmls' => self::WMLS,
        'vtt' => self::VTT,
        'wgsl' => self::WGSL,
        's' => self::ASM,
        'asm' => self::ASM,
        'c' => self::DIC,
        'cc' => self::DIC,
        'cxx' => self::DIC,
        'cpp' => self::DIC,
        'h' => self::DIC,
        'hh' => self::DIC,
        'dic' => self::DIC,
        'f' => self::F90,
        'for' => self::F90,
        'f77' => self::F90,
        'f90' => self::F90,
        'hbs' => self::HBS,
        'java' => self::JAVA,
        'lua' => self::LUA,
        'mkd' => self::MKD,
        'nfo' => self::NFO,
        'opml' => self::OPML,
        'p' => self::PAS,
        'pas' => self::PAS,
        'pde' => self::PDE,
        'sass' => self::SASS,
        'scss' => self::SCSS,
        'etx' => self::ETX,
        'sfv' => self::SFV,
        'ymp' => self::YMP,
        'uu' => self::UU,
        'vcs' => self::VCS,
        'vcf' => self::VCF,
        'yaml' => self::YAML,
        'yml' => self::YAML,
        '3g2' => self::_3G2,
        'h261' => self::H261,
        'h263' => self::H263,
        'h264' => self::H264,
        'm4s' => self::M4S,
        'jpgv' => self::JPGV,
        'mj2' => self::MJ2,
        'mjp2' => self::MJ2,
        'mp4v' => self::MP4,
        'mpe' => self::MPEG,
        'm1v' => self::MPEG,
        'm2v' => self::MPEG,
        'ogv' => self::OGV,
        'qt' => self::QT,
        'uvh' => self::UVVH,
        'uvvh' => self::UVVH,
        'uvm' => self::UVVM,
        'uvvm' => self::UVVM,
        'uvp' => self::UVVP,
        'uvvp' => self::UVVP,
        'uvs' => self::UVVS,
        'uvvs' => self::UVVS,
        'uvv' => self::UVVV,
        'uvvv' => self::UVVV,
        'dvb' => self::DVB,
        'fvt' => self::FVT,
        'mxu' => self::M4U,
        'm4u' => self::M4U,
        'pyv' => self::PYV,
        'uvu' => self::UVVU,
        'uvvu' => self::UVVU,
        'viv' => self::VIV,
        'f4v' => self::F4V,
        'fli' => self::FLI,
        'mkv' => self::MKS,
        'mk3d' => self::MKS,
        'mks' => self::MKS,
        'vob' => self::VOB,
        'wm' => self::WM,
        'wmx' => self::WMX,
        'wvx' => self::WVX,
        'movie' => self::MOVIE,
        'ice' => self::ICE,
    ];

    public static function fromExtension(string $extension): string
    {
        return self::EXTENSION_MAP[$extension] ?? static::BIN;
    }
}
