# Features

Out of the box, we wanted to create a low level robust framework on which to build charts. Outside of the following chart types:

### Chart Types

- Horizontal & Vertical Bar Charts \(Standard, Grouped, Stacked, Normalized\)
- Line
- Area \(Standard, Stacked, Normalized\)
- Pie \(Explodable, Grid, Custom legends\)
- Donut
- Gauge
- Linear Gauge
- Force Directed Graph (deprecated - please use [ngx-graph](https://github.com/swimlane/ngx-graph) instead)
- Heatmap
- Treemap
- Number Cards
- Bubble/Scatter
- Vertical Box Chart

### Customization

- Autoscaling
- Timeline Filtering
- Line Interpolation
- Configurable Axis Labels
- Legends \(Labels & Gradient\)
- Advanced Label Positioning
- Real-time data support
- Advanced Tooltips
- Responsive Layout
- Data point Event Handlers
- Works with ngUpgrade
- Enabling/Disabling animations

If you have an idea for a new feature, create a Github issue or even better a PR ;\). Make sure to include the use case, an example image of the chart \(if applicable\) and data formats.

## Alternatives

Chart frameworks are a dime a dozen nowadays. Not many of them existed a few years ago when we started this project internally and many of them still don't really work well with Angular. Here's a recent list we compiled during our effort to open-source this:

- [ng2-nvd3](https://github.com/krispo/ng2-nvd3) - Open-source wrapper for nvd3 using Angular2 Components
- [ng2-charts](http://valor-software.com/ng2-charts/) - Open-source Angular2 wrapper directives for Chart.js
- [angular2-highcharts](https://www.npmjs.com/package/angular2-highcharts) - Open-source Angular2 wrapper for HighCharts
- [recharts](http://recharts.org/) - Open-source composable charting library built on React components
- [Vega](http://vega.github.io/) - Open-source Canvas/SVG viz framework
- [C3](http://c3js.org/) - Open-source D3-based reusable chart library
- [Plotly](https://plot.ly/) - Commercial business intelligence and data science.
- [Highcharts](http://www.highcharts.com/) - Commercial chart framework
- [eCharts](http://echarts.baidu.com/demo.htm) - Open-source JavaScript chart framework
- [dc.js](http://dc-js.github.io/dc.js) - Open-source JavaScript charting library
