import Fish

extension Vault {
    /// The manager to use built binaries instead of targets in CocoaPods project.
    public func useBinariesManager() -> IUseBinariesManager {
        let xcodeProject = xcode.project(projectPath: router.podsProjectPath)
        return internalUseBinariesManager(xcodeProject: xcodeProject,
                                          buildTargetsManager: BuildTargetsManager(xcodeProject: xcodeProject))
    }

    func internalUseBinariesManager(xcodeProject: IInternalXcodeProject,
                                    buildTargetsManager: IBuildTargetsManager) -> IInternalUseBinariesManager {
        UseBinariesManager(
            logger: logger,
            buildTargetsManager: buildTargetsManager,
            librariesPatcher: LibrariesPatcher(logger: logger),
            xcodeProject: xcodeProject,
            rugbyXcodeProject: RugbyXcodeProject(xcodeProject: xcodeProject),
            backupManager: backupManager(),
            binariesStorage: binariesStorage,
            targetsHasher: targetsHasher(),
            supportFilesPatcher: SupportFilesPatcher(),
            fileContentEditor: FileContentEditor(),
            targetsPrinter: targetsPrinter,
            xcframeworksPatcher: XCFrameworksPatcher(
                xcodeProject: xcodeProject,
                xcodePhaseEditor: XcodePhaseEditor(),
                xcodeBuildConfigurationEditor: XcodeBuildConfigurationEditor()
            )
        )
    }
}
