# MedPlant

MedPlant is an open-source project focused on creating awareness of the medicinal properties of various plants. 

It aims to provide a comprehensive resource for individuals interested in alternative medicine, herbal remedies, and the healing potential of plants.

If you have any kind of doubts or queries do not hesitate to contact me. Please place "😎😎😎" emojis in your subject of email, so that I can easily be attentive to your mail or query.

## Features

- Extensive database of plant profiles with detailed information about their medicinal properties.
- Community-driven platform for sharing research findings, experiences, and insights related to plant-based medicine.

### Getting Started

1. Clone this repository.

2. Run the application.

## Contributing

We welcome contributions from the open-source community to improve MedPlant. To contribute, please follow these guidelines:

### Code Contribution

1. Fork the repository and create a new branch for your contribution.
2. Create a new branch in your system through git (command i.e git checkout -b your-branch-name) 
3. Ensure that your code adheres to the project's coding style and guidelines.
4. If you're introducing new features, enhancements, or fixes, please write clean and well-documented code.
5. Test your changes thoroughly to ensure they do not introduce any regressions.
6. Submit a pull request with a clear description of the changes, the problem it solves, and any relevant details.Please have a look at resources on how to get a pull request.

### Adding New Plant Profiles

We encourage contributors to add new plant profiles to expand the knowledge base. To maintain consistency and quality, please consider the following guidelines:

1. Check the existing plant profiles to ensure that the plant you wish to add hasn't been covered already.
2. Use the existing plant profiles as a reference to understand the required information and formatting.
3. Write an informative and well-researched plant profile, including details about its medicinal properties, cultivation methods, traditional uses, and any relevant scientific research.
4. Ensure that the information provided is accurate, reliable, and properly cited if necessary.
5. Include relevant images or diagrams to enhance the understanding of the plant profile.
6. Proofread the plant profile for grammar, spelling, and readability before submitting.

## Issue Reporting

If you encounter any issues or have suggestions for improvements, please follow these steps:

1. Check the existing issues to see if the problem has already been reported.
2. If it hasn't been reported, create a new issue with a clear and descriptive title.
3. Provide detailed steps to reproduce the issue and any relevant information about your environment.
4. If possible, include screenshots or error messages related to the issue.
5. Assign appropriate labels to the issue (e.g., bug, enhancement, documentation).

## Documentation

Improvements to documentation are always welcome! If you find any areas that can be clarified, expanded, or corrected, please feel free to contribute. Here's how you can help:

1. Review the existing documentation and identify areas for improvement.
2. If you're suggesting new documentation, create a new markdown file in the appropriate directory.
3. Make sure your documentation follows the same style and format as the existing documentation.
4. Submit a pull request with the changes and provide a brief explanation of the updates made.

## Video Resources

For a better understanding of the project, we recommend watching the following video:

- [How To Contribute](https://youtu.be/c6b6B9oN4Vg)

This video provides insights into the how to push a change to our repo.

## Branch Guidelines

To make changes to the code, please follow these guidelines:

1. Create a new branch for your changes, preferably named after the specific feature or bug you're working on.
2. Make your changes on the separate branch.
3. Test your changes thoroughly.
4. Once you're confident in your changes, submit a pull request to merge your branch into the main branch.

## Authors

All the contributors for this project can include their name in the [AUTHORS](.github/AUTHORS.md) file.

## License

MedPlant is open-source and released under the [MIT License](LICENSE).

## Contact

If you have any questions, suggestions, or feedback, please reach out to us at: jyothiswarupseethala8086@gmail.com.

---

We would like to express our gratitude to all contributors who have helped shape and improve MedPlant. 

Your contributions are greatly appreciated!
