/*
 * Decompiled with CFR 0.152.
 */
package rx.subjects;

import rx.Observable;
import rx.functions.Action1;
import rx.internal.operators.NotificationLite;
import rx.subjects.Subject;
import rx.subjects.SubjectSubscriptionManager;

public final class PublishSubject<T>
extends Subject<T, T> {
    final SubjectSubscriptionManager<T> state;
    private final NotificationLite<T> nl = NotificationLite.instance();

    public static <T> PublishSubject<T> create() {
        final SubjectSubscriptionManager state = new SubjectSubscriptionManager();
        state.onTerminated = new Action1<SubjectSubscriptionManager.SubjectObserver<T>>(){

            @Override
            public void call(SubjectSubscriptionManager.SubjectObserver<T> o) {
                o.emitFirst(state.get(), state.nl);
            }
        };
        return new PublishSubject(state, state);
    }

    protected PublishSubject(Observable.OnSubscribe<T> onSubscribe, SubjectSubscriptionManager<T> state) {
        super(onSubscribe);
        this.state = state;
    }

    @Override
    public void onCompleted() {
        if (this.state.active) {
            Object n = this.nl.completed();
            for (SubjectSubscriptionManager.SubjectObserver bo : this.state.terminate(n)) {
                bo.emitNext(n, this.state.nl);
            }
        }
    }

    @Override
    public void onError(Throwable e) {
        if (this.state.active) {
            Object n = this.nl.error(e);
            for (SubjectSubscriptionManager.SubjectObserver bo : this.state.terminate(n)) {
                bo.emitNext(n, this.state.nl);
            }
        }
    }

    @Override
    public void onNext(T v) {
        for (SubjectSubscriptionManager.SubjectObserver<T> bo : this.state.observers()) {
            bo.onNext(v);
        }
    }
}

