/*
 * Decompiled with CFR 0.152.
 */
package rx.internal.util;

import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;
import rx.Scheduler;
import rx.functions.Action0;
import rx.internal.util.unsafe.MpmcArrayQueue;
import rx.internal.util.unsafe.UnsafeAccess;
import rx.schedulers.Schedulers;

public abstract class ObjectPool<T> {
    private Queue<T> pool;
    private final int maxSize;
    private Scheduler.Worker schedulerWorker;

    public ObjectPool() {
        this(0, 0, 67L);
    }

    private ObjectPool(final int min2, final int max2, long validationInterval) {
        this.maxSize = max2;
        this.initialize(min2);
        this.schedulerWorker = Schedulers.computation().createWorker();
        this.schedulerWorker.schedulePeriodically(new Action0(){

            @Override
            public void call() {
                block3: {
                    int size;
                    block2: {
                        size = ObjectPool.this.pool.size();
                        if (size >= min2) break block2;
                        int sizeToBeAdded = max2 - size;
                        for (int i = 0; i < sizeToBeAdded; ++i) {
                            ObjectPool.this.pool.add(ObjectPool.this.createObject());
                        }
                        break block3;
                    }
                    if (size <= max2) break block3;
                    int sizeToBeRemoved = size - max2;
                    for (int i = 0; i < sizeToBeRemoved; ++i) {
                        ObjectPool.this.pool.poll();
                    }
                }
            }
        }, validationInterval, validationInterval, TimeUnit.SECONDS);
    }

    public T borrowObject() {
        T object = this.pool.poll();
        if (object == null) {
            object = this.createObject();
        }
        return object;
    }

    public void returnObject(T object) {
        if (object == null) {
            return;
        }
        this.pool.offer(object);
    }

    public void shutdown() {
        this.schedulerWorker.unsubscribe();
    }

    protected abstract T createObject();

    private void initialize(int min2) {
        this.pool = UnsafeAccess.isUnsafeAvailable() ? new MpmcArrayQueue<T>(Math.max(this.maxSize, 1024)) : new ConcurrentLinkedQueue<T>();
        for (int i = 0; i < min2; ++i) {
            this.pool.add(this.createObject());
        }
    }
}

