/*
 * Decompiled with CFR 0.152.
 */
package rx.internal.schedulers;

import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import rx.Scheduler;
import rx.Subscription;
import rx.functions.Action0;
import rx.internal.schedulers.ScheduledAction;
import rx.plugins.RxJavaPlugins;
import rx.plugins.RxJavaSchedulersHook;
import rx.subscriptions.Subscriptions;

public class NewThreadWorker
extends Scheduler.Worker
implements Subscription {
    private final ScheduledExecutorService executor;
    private final RxJavaSchedulersHook schedulersHook;
    volatile boolean isUnsubscribed;

    public NewThreadWorker(ThreadFactory threadFactory) {
        this.executor = Executors.newScheduledThreadPool(1, threadFactory);
        this.schedulersHook = RxJavaPlugins.getInstance().getSchedulersHook();
    }

    @Override
    public Subscription schedule(Action0 action) {
        return this.schedule(action, 0L, null);
    }

    @Override
    public Subscription schedule(Action0 action, long delayTime, TimeUnit unit) {
        if (this.isUnsubscribed) {
            return Subscriptions.empty();
        }
        return this.scheduleActual(action, delayTime, unit);
    }

    public ScheduledAction scheduleActual(Action0 action, long delayTime, TimeUnit unit) {
        Action0 decoratedAction = this.schedulersHook.onSchedule(action);
        ScheduledAction run2 = new ScheduledAction(decoratedAction);
        Future<?> f = delayTime <= 0L ? this.executor.submit(run2) : this.executor.schedule(run2, delayTime, unit);
        run2.add(Subscriptions.from(f));
        return run2;
    }

    @Override
    public void unsubscribe() {
        this.isUnsubscribed = true;
        this.executor.shutdownNow();
    }

    @Override
    public boolean isUnsubscribed() {
        return this.isUnsubscribed;
    }
}

