/*
 * Decompiled with CFR 0.152.
 */
package rx.internal.operators;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import rx.Observable;
import rx.Observer;
import rx.Subscriber;
import rx.internal.operators.BufferUntilSubscriber;

public final class OperatorWindowWithSize<T>
implements Observable.Operator<Observable<T>, T> {
    final int size;
    final int skip;

    public OperatorWindowWithSize(int size, int skip) {
        this.size = size;
        this.skip = skip;
    }

    @Override
    public Subscriber<? super T> call(Subscriber<? super Observable<T>> child) {
        if (this.skip == this.size) {
            return new ExactSubscriber(child);
        }
        return new InexactSubscriber(child);
    }

    static final class CountedSubject<T> {
        final Observer<T> consumer;
        final Observable<T> producer;
        int count;

        public CountedSubject(Observer<T> consumer, Observable<T> producer) {
            this.consumer = consumer;
            this.producer = producer;
        }
    }

    final class InexactSubscriber
    extends Subscriber<T> {
        final Subscriber<? super Observable<T>> child;
        int count;
        final List<CountedSubject<T>> chunks;

        public InexactSubscriber(Subscriber<? super Observable<T>> child) {
            this.child = child;
            this.chunks = new LinkedList();
        }

        @Override
        public void onStart() {
            this.request(Long.MAX_VALUE);
        }

        @Override
        public void onNext(T t) {
            if (this.count++ % OperatorWindowWithSize.this.skip == 0) {
                CountedSubject cs = this.createCountedSubject();
                this.chunks.add(cs);
                this.child.onNext(cs.producer);
            }
            Iterator it = this.chunks.iterator();
            while (it.hasNext()) {
                CountedSubject cs = it.next();
                cs.consumer.onNext(t);
                if (++cs.count != OperatorWindowWithSize.this.size) continue;
                it.remove();
                cs.consumer.onCompleted();
            }
        }

        @Override
        public void onError(Throwable e) {
            ArrayList list = new ArrayList(this.chunks);
            this.chunks.clear();
            for (CountedSubject countedSubject : list) {
                countedSubject.consumer.onError(e);
            }
            this.child.onError(e);
        }

        @Override
        public void onCompleted() {
            ArrayList list = new ArrayList(this.chunks);
            this.chunks.clear();
            for (CountedSubject countedSubject : list) {
                countedSubject.consumer.onCompleted();
            }
            this.child.onCompleted();
        }

        CountedSubject<T> createCountedSubject() {
            BufferUntilSubscriber bus = BufferUntilSubscriber.create();
            return new CountedSubject(bus, bus);
        }
    }

    final class ExactSubscriber
    extends Subscriber<T> {
        final Subscriber<? super Observable<T>> child;
        int count;
        Observer<T> consumer;
        Observable<T> producer;

        public ExactSubscriber(Subscriber<? super Observable<T>> child) {
            super(child);
            this.child = child;
        }

        @Override
        public void onStart() {
            this.request(Long.MAX_VALUE);
        }

        @Override
        public void onNext(T t) {
            if (this.count++ % OperatorWindowWithSize.this.size == 0) {
                if (this.consumer != null) {
                    this.consumer.onCompleted();
                }
                this.createNewWindow();
                this.child.onNext(this.producer);
            }
            this.consumer.onNext(t);
        }

        @Override
        public void onError(Throwable e) {
            if (this.consumer != null) {
                this.consumer.onError(e);
            }
            this.child.onError(e);
        }

        @Override
        public void onCompleted() {
            if (this.consumer != null) {
                this.consumer.onCompleted();
            }
            this.child.onCompleted();
        }

        void createNewWindow() {
            BufferUntilSubscriber bus = BufferUntilSubscriber.create();
            this.consumer = bus;
            this.producer = bus;
        }
    }
}

