/*
 * Decompiled with CFR 0.152.
 */
package rx.internal.operators;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import rx.Observable;
import rx.Subscriber;
import rx.exceptions.OnErrorThrowable;
import rx.functions.Action0;
import rx.functions.Func1;
import rx.internal.operators.BufferUntilSubscriber;
import rx.observables.GroupedObservable;
import rx.subscriptions.Subscriptions;

public final class OperatorGroupBy<T, K, R>
implements Observable.Operator<GroupedObservable<K, R>, T> {
    final Func1<? super T, ? extends K> keySelector;
    final Func1<? super T, ? extends R> elementSelector;
    private static final Func1<Object, Object> IDENTITY = new Func1<Object, Object>(){

        @Override
        public Object call(Object t) {
            return t;
        }
    };

    public OperatorGroupBy(Func1<? super T, ? extends K> keySelector) {
        this(keySelector, IDENTITY);
    }

    public OperatorGroupBy(Func1<? super T, ? extends K> keySelector, Func1<? super T, ? extends R> elementSelector) {
        this.keySelector = keySelector;
        this.elementSelector = elementSelector;
    }

    @Override
    public Subscriber<? super T> call(Subscriber<? super GroupedObservable<K, R>> child) {
        return new GroupBySubscriber<K, T, R>(this.keySelector, this.elementSelector, child);
    }

    static final class GroupBySubscriber<K, T, R>
    extends Subscriber<T> {
        final Func1<? super T, ? extends K> keySelector;
        final Func1<? super T, ? extends R> elementSelector;
        final Subscriber<? super GroupedObservable<K, R>> child;
        private final Map<K, BufferUntilSubscriber<T>> groups = new HashMap<K, BufferUntilSubscriber<T>>();
        volatile int completionCounter;
        volatile int completionEmitted;
        volatile int terminated;
        static final AtomicIntegerFieldUpdater<GroupBySubscriber> COUNTER_UPDATER = AtomicIntegerFieldUpdater.newUpdater(GroupBySubscriber.class, "completionCounter");
        static final AtomicIntegerFieldUpdater<GroupBySubscriber> EMITTED_UPDATER = AtomicIntegerFieldUpdater.newUpdater(GroupBySubscriber.class, "completionEmitted");
        static final AtomicIntegerFieldUpdater<GroupBySubscriber> TERMINATED_UPDATER = AtomicIntegerFieldUpdater.newUpdater(GroupBySubscriber.class, "terminated");

        public GroupBySubscriber(Func1<? super T, ? extends K> keySelector, Func1<? super T, ? extends R> elementSelector, Subscriber<? super GroupedObservable<K, R>> child) {
            this.keySelector = keySelector;
            this.elementSelector = elementSelector;
            this.child = child;
        }

        @Override
        public void onStart() {
            this.request(Long.MAX_VALUE);
        }

        @Override
        public void onCompleted() {
            if (TERMINATED_UPDATER.compareAndSet(this, 0, 1)) {
                for (BufferUntilSubscriber<T> ps : this.groups.values()) {
                    ps.onCompleted();
                }
                if (this.completionCounter == 0 && EMITTED_UPDATER.compareAndSet(this, 0, 1)) {
                    this.child.onCompleted();
                }
            }
        }

        @Override
        public void onError(Throwable e) {
            if (TERMINATED_UPDATER.compareAndSet(this, 0, 1)) {
                this.child.onError(e);
            }
        }

        @Override
        public void onNext(T t) {
            try {
                K key = this.keySelector.call(t);
                BufferUntilSubscriber<T> group = this.groups.get(key);
                if (group == null) {
                    if (this.child.isUnsubscribed()) {
                        return;
                    }
                    final BufferUntilSubscriber<T> _group = group = BufferUntilSubscriber.create();
                    GroupedObservable go = new GroupedObservable(key, new Observable.OnSubscribe<R>(){

                        @Override
                        public void call(final Subscriber<? super R> o) {
                            COUNTER_UPDATER.incrementAndGet(GroupBySubscriber.this);
                            o.add(Subscriptions.create(new Action0(){

                                @Override
                                public void call() {
                                    GroupBySubscriber.this.completeInner();
                                }
                            }));
                            _group.unsafeSubscribe(new Subscriber<T>(o){

                                @Override
                                public void onCompleted() {
                                    o.onCompleted();
                                    GroupBySubscriber.this.completeInner();
                                }

                                @Override
                                public void onError(Throwable e) {
                                    o.onError(e);
                                }

                                @Override
                                public void onNext(T t) {
                                    o.onNext(GroupBySubscriber.this.elementSelector.call(t));
                                }
                            });
                        }
                    });
                    this.groups.put(key, group);
                    this.child.onNext(go);
                }
                group.onNext(t);
            }
            catch (Throwable e) {
                this.onError(OnErrorThrowable.addValueAsLastCause(e, t));
            }
        }

        private void completeInner() {
            if (COUNTER_UPDATER.decrementAndGet(this) <= 0 && (this.terminated == 1 || this.child.isUnsubscribed()) && EMITTED_UPDATER.compareAndSet(this, 0, 1)) {
                if (this.child.isUnsubscribed()) {
                    this.unsubscribe();
                }
                this.child.onCompleted();
            }
        }
    }
}

