/*
 * Decompiled with CFR 0.152.
 */
package org.strategoxt.lang.parallel.stratego_parallel;

import java.util.WeakHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.spoofax.interpreter.terms.IStrategoList;
import org.spoofax.interpreter.terms.IStrategoTerm;
import org.strategoxt.lang.Context;
import org.strategoxt.lang.SRTS_all;
import org.strategoxt.lang.StrategoException;
import org.strategoxt.lang.StrategoExit;
import org.strategoxt.lang.Strategy;
import org.strategoxt.lang.parallel.stratego_parallel.ParallelContext;
import org.strategoxt.lang.parallel.stratego_parallel.ParallelJob;
import org.strategoxt.lang.parallel.stratego_parallel.ParallelJobExecutor;
import org.strategoxt.lang.parallel.stratego_parallel.stratego_parallel;

public class ParallelAll
extends SRTS_all {
    public static ParallelAll instance;
    private static final WeakHashMap<IStrategoTerm, Integer> termSizes;
    private final ParallelJobExecutor executor = new ParallelJobExecutor();
    private int termSizeThreshold = 3200;
    private int subtermCountThreshold = 12;
    private double jobLengthMultiplier = 1.0;
    private AtomicInteger parallelismLevel = new AtomicInteger(0);
    private boolean isForcedParallel;
    private volatile boolean allowUnordered;

    static {
        termSizes = new WeakHashMap();
    }

    @Override
    public IStrategoTerm invoke(Context context, IStrategoTerm current, Strategy s) {
        if (!stratego_parallel.isActive() && this.isForcedParallel) {
            this.isForcedParallel = false;
            context.push("<parallel>");
            IStrategoTerm result = this.invokeParallel(context, current, s);
            if (result == null) {
                context.popOnFailure();
            } else {
                context.popOnSuccess();
            }
            return result;
        }
        current.getAllSubterms();
        return super.invoke(context, current, s);
    }

    public void setForcedParallel(boolean isForcedParallel) {
        this.isForcedParallel = isForcedParallel;
    }

    public boolean isForcedParallel() {
        return this.isForcedParallel;
    }

    public ParallelJobExecutor getExecutor() {
        return this.executor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IStrategoTerm invokeParallel(Context context, IStrategoTerm current, Strategy s) {
        IStrategoTerm[] inputs = current.getAllSubterms();
        if (inputs.length == 0) {
            return context.getFactory().makeList();
        }
        IStrategoTerm[] outputs = new IStrategoTerm[inputs.length];
        AtomicInteger focusIndex = new AtomicInteger(0);
        AtomicInteger jobsCompleted = new AtomicInteger(0);
        AtomicBoolean isAborted = new AtomicBoolean(false);
        AtomicReference<String> lastSynchronousOperation = null;
        AtomicReference<Throwable> lastException = new AtomicReference<Throwable>();
        ParallelJob firstJob = null;
        stratego_parallel.setActive(true);
        boolean allowUnordered = this.allowUnordered;
        try {
            try {
                double jobLengthPrecise = (double)inputs.length / (double)(this.executor.getMaximumPoolSize() + 1) * this.jobLengthMultiplier;
                int jobLength = 1 + (int)jobLengthPrecise;
                int numJobs = (int)Math.ceil((double)inputs.length / (double)jobLength);
                int i = 0;
                while (i < inputs.length) {
                    int index = i;
                    ParallelJob job = new ParallelJob(context, s, inputs, outputs, focusIndex, isAborted, lastSynchronousOperation, lastException, allowUnordered, index, jobLength, this.parallelismLevel.get(), jobsCompleted);
                    if (firstJob == null) {
                        firstJob = job;
                    } else {
                        this.executor.execute(job);
                    }
                    i += jobLength;
                }
                firstJob.run();
                this.executor.join();
                firstJob.waitForCompletedFocusIndex();
                AtomicInteger atomicInteger = jobsCompleted;
                synchronized (atomicInteger) {
                    while (jobsCompleted.get() != numJobs) {
                        jobsCompleted.wait();
                    }
                }
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
        finally {
            stratego_parallel.setActive(false);
        }
        if (isAborted.get()) {
            if (lastException.get() != null) {
                if (lastException.get() instanceof StrategoExit) {
                    throw new StrategoExit((StrategoExit)lastException.get());
                }
                throw new StrategoException("Exception in asynchronous job", lastException.get());
            }
            return null;
        }
        assert (current.getTermType() == 2);
        return context.getFactory().makeList(outputs);
    }

    public void setAllowUnordered(boolean allowUnorderedOnce) {
        this.allowUnordered = allowUnorderedOnce;
    }

    protected boolean isCandidateTerm(Context context, IStrategoTerm term) {
        if (term.getTermType() == 2 && term.getStorageType() != 0 && term.getSubtermCount() >= this.subtermCountThreshold && this.getTermSize(term, 1) >= this.termSizeThreshold) {
            if (this.parallelismLevel.get() > 2) {
                return false;
            }
            if (this.parallelismLevel.get() > 1 && !((ParallelContext)context).getJob().isFocusJob()) {
                return false;
            }
            IStrategoList cons = (IStrategoList)term;
            while (!cons.isEmpty()) {
                if (!cons.getAnnotations().isEmpty()) {
                    return false;
                }
                cons = cons.tail();
            }
            return true;
        }
        return false;
    }

    protected int getTermSize(IStrategoTerm term, int initialSize) {
        int subtermCount = term.getSubtermCount();
        if (subtermCount == 0) {
            return initialSize;
        }
        Integer cached = termSizes.get(term);
        if (cached != null) {
            return initialSize + cached;
        }
        int size = initialSize + subtermCount;
        if (term.getTermType() == 2) {
            IStrategoList cons = (IStrategoList)term;
            while (!cons.isEmpty()) {
                IStrategoTerm subterm = cons.head();
                size = this.getTermSize(subterm, size);
                if (size >= this.termSizeThreshold) {
                    termSizes.put(term, size);
                    return size;
                }
                cons = cons.tail();
            }
        } else {
            int i = 0;
            while (i < subtermCount) {
                IStrategoTerm subterm = term.getSubterm(i);
                size = this.getTermSize(subterm, size);
                if (size >= this.termSizeThreshold) {
                    termSizes.put(term, size);
                    return size;
                }
                ++i;
            }
        }
        termSizes.put(term, size);
        return size;
    }
}

