/*
 * Decompiled with CFR 0.152.
 */
package org.strategoxt.lang.compat;

import java.io.File;
import java.util.Map;
import java.util.WeakHashMap;
import org.spoofax.interpreter.core.Tools;
import org.spoofax.interpreter.terms.IStrategoTerm;
import org.spoofax.interpreter.terms.TermConverter;
import org.strategoxt.lang.Context;
import org.strategoxt.lang.WeakValueHashMap;
import org.strategoxt.stratego_lib.$Read$From$File_0_0;

public class ReadFromFile_cached_0_0
extends $Read$From$File_0_0 {
    private static long FILE_TIME_GRANULARITY = 2001L;
    private static volatile boolean isInited;
    private static Map<File, IStrategoTerm> asyncCache;
    private static Map<IStrategoTerm, FileDate> asyncCacheDates;

    static {
        asyncCache = new WeakValueHashMap<File, IStrategoTerm>();
        asyncCacheDates = new WeakHashMap<IStrategoTerm, FileDate>();
    }

    public static void init() {
        if (!isInited) {
            $Read$From$File_0_0.instance = new ReadFromFile_cached_0_0();
            isInited = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IStrategoTerm invoke(Context context, IStrategoTerm term) {
        if (!Tools.isTermString(term)) {
            return super.invoke(context, term);
        }
        File file = context.getIOAgent().openFile(Tools.asJavaString(term));
        if (!file.exists()) {
            return super.invoke(context, term);
        }
        FileDate cachedDate = null;
        IStrategoTerm cachedTerm = null;
        long now = System.currentTimeMillis();
        long fileDate = file.lastModified();
        Map<File, IStrategoTerm> map = asyncCache;
        synchronized (map) {
            cachedTerm = asyncCache.get(file);
            if (cachedTerm != null) {
                cachedDate = asyncCacheDates.get(cachedTerm);
            }
        }
        if (now < fileDate + FILE_TIME_GRANULARITY) {
            return super.invoke(context, term);
        }
        if (cachedDate != null && cachedDate.accessed > fileDate + FILE_TIME_GRANULARITY && cachedDate.file.equals(file)) {
            if (cachedTerm.getStorageType() == 0) {
                cachedTerm = TermConverter.convert(context.getFactory(), cachedTerm);
                this.putCache(file, now, cachedTerm);
            }
            return cachedTerm;
        }
        IStrategoTerm result = super.invoke(context, term);
        if (result != null) {
            this.putCache(file, now, result);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void putCache(File file, long now, IStrategoTerm result) {
        Map<File, IStrategoTerm> map = asyncCache;
        synchronized (map) {
            asyncCache.put(file, result);
            asyncCacheDates.put(result, new FileDate(file, now));
        }
    }

    private static class FileDate {
        final File file;
        final long accessed;

        FileDate(File file, long accessed) {
            this.file = file;
            this.accessed = accessed;
        }
    }
}

