/*
 * Decompiled with CFR 0.152.
 */
package org.strategoxt.lang;

import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import org.spoofax.interpreter.terms.IStrategoTerm;
import org.strategoxt.lang.Context;
import org.strategoxt.lang.SRTS_all;
import org.strategoxt.lang.StrategoErrorExit;
import org.strategoxt.lang.StrategoException;
import org.strategoxt.lang.StrategoExit;
import org.strategoxt.lang.Strategy;
import org.strategoxt.lang.Term;

public class StackSaver
extends SRTS_all {
    public static int MAX_DEPTH = 1000;
    private static int activeThreadDepth;
    private final Strategy strategy;

    public StackSaver(Strategy s) {
        this.strategy = s;
    }

    public static boolean isNeededFor(Context context) {
        int depth = context.getTraceDepth(true);
        return depth - activeThreadDepth > MAX_DEPTH;
    }

    @Override
    public IStrategoTerm invoke(Context context, IStrategoTerm current) {
        if (StackSaver.isNeededFor(context)) {
            return this.invokeStackFriendly(context, current, Term.NO_STRATEGIES, Term.NO_TERMS);
        }
        return super.invoke(context, current);
    }

    @Override
    public IStrategoTerm invoke(Context context, IStrategoTerm current, Strategy s) {
        if (StackSaver.isNeededFor(context)) {
            return this.invokeStackFriendly(context, current, new Strategy[]{s}, Term.NO_TERMS);
        }
        return super.invoke(context, current, s);
    }

    public IStrategoTerm invokeStackFriendly(final Context context, final IStrategoTerm current, final Strategy[] s, final IStrategoTerm[] t) {
        int startDepth = context.getTraceDepth(true);
        activeThreadDepth += startDepth;
        FutureTask<IStrategoTerm> result = new FutureTask<IStrategoTerm>(new Callable<IStrategoTerm>(){

            @Override
            public IStrategoTerm call() throws Exception {
                return StackSaver.this.strategy.invokeDynamic(context, current, s, t);
            }
        });
        new Thread(result).start();
        try {
            IStrategoTerm iStrategoTerm = result.get();
            return iStrategoTerm;
        }
        catch (ExecutionException e) {
            try {
                throw e.getCause();
            }
            catch (StrategoErrorExit f) {
                throw new StrategoErrorExit(f.getMessage(), f.getTerm(), f.getTrace(), f.getCause());
            }
            catch (StrategoExit f) {
                throw new StrategoExit(f.getValue(), e.getCause());
            }
            catch (StrategoException f) {
                throw new StrategoException(f.getMessage(), e.getCause());
            }
            catch (Throwable throwable) {
                throw new RuntimeException(e.getCause());
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        finally {
            activeThreadDepth -= startDepth;
        }
    }
}

