/*
 * Decompiled with CFR 0.152.
 */
package org.spoofax.terms.visitor;

import java.util.HashSet;
import java.util.Stack;
import org.spoofax.interpreter.terms.IStrategoAppl;
import org.spoofax.interpreter.terms.IStrategoInt;
import org.spoofax.interpreter.terms.IStrategoList;
import org.spoofax.interpreter.terms.IStrategoPlaceholder;
import org.spoofax.interpreter.terms.IStrategoReal;
import org.spoofax.interpreter.terms.IStrategoRef;
import org.spoofax.interpreter.terms.IStrategoString;
import org.spoofax.interpreter.terms.IStrategoTerm;
import org.spoofax.interpreter.terms.IStrategoTuple;
import org.spoofax.terms.visitor.IStrategoTermVisitor;

public class StrategoTermVisitee {
    public static void topdown(IStrategoTermVisitor visitor, IStrategoTerm initialTerm) {
        Stack<IStrategoTerm> stack = new Stack<IStrategoTerm>();
        stack.push(initialTerm);
        while (!stack.empty()) {
            IStrategoTerm term = (IStrategoTerm)stack.pop();
            if (!StrategoTermVisitee.dispatch(visitor, term)) continue;
            int i = term.getSubtermCount() - 1;
            while (i >= 0) {
                stack.push(term.getSubterm(i));
                --i;
            }
        }
    }

    public static void bottomup(IStrategoTermVisitor visitor, IStrategoTerm initialTerm) {
        Stack<IStrategoTerm> stack = new Stack<IStrategoTerm>();
        HashSet<IStrategoTerm> visited = new HashSet<IStrategoTerm>();
        stack.push(initialTerm);
        while (!stack.isEmpty()) {
            IStrategoTerm term = (IStrategoTerm)stack.peek();
            if (term.getSubtermCount() == 0 || visited.contains(term)) {
                StrategoTermVisitee.dispatch(visitor, term);
                stack.pop();
                visited.remove(term);
                continue;
            }
            visited.add(term);
            int i = term.getSubtermCount() - 1;
            while (i >= 0) {
                stack.push(term.getSubterm(i));
                --i;
            }
        }
    }

    private static boolean dispatch(IStrategoTermVisitor visitor, IStrategoTerm term) {
        switch (term.getTermType()) {
            case 1: {
                return visitor.visit((IStrategoAppl)term);
            }
            case 2: {
                return visitor.visit((IStrategoList)term);
            }
            case 7: {
                return visitor.visit((IStrategoTuple)term);
            }
            case 3: {
                visitor.visit((IStrategoInt)term);
                return false;
            }
            case 4: {
                visitor.visit((IStrategoReal)term);
                return false;
            }
            case 5: {
                visitor.visit((IStrategoString)term);
                return false;
            }
            case 8: {
                visitor.visit((IStrategoRef)term);
                return false;
            }
            case 10: {
                return visitor.visit((IStrategoPlaceholder)term);
            }
        }
        return visitor.visit(term);
    }
}

