/*
 * Decompiled with CFR 0.152.
 */
package org.spoofax.terms.skeleton;

import java.io.IOException;
import java.util.Iterator;
import org.spoofax.interpreter.terms.IStrategoAppl;
import org.spoofax.interpreter.terms.IStrategoList;
import org.spoofax.interpreter.terms.IStrategoTerm;
import org.spoofax.interpreter.terms.ITermPrinter;
import org.spoofax.terms.StrategoTerm;
import org.spoofax.terms.util.ArrayIterator;
import org.spoofax.terms.util.NotImplementedException;

public abstract class SkeletonStrategoAppl
extends StrategoTerm
implements IStrategoAppl {
    private static final long serialVersionUID = -2522680523775044390L;

    public SkeletonStrategoAppl(IStrategoList annotations, int storageType) {
        super(annotations, storageType);
    }

    @Deprecated
    public final IStrategoTerm[] getArguments() {
        throw new NotImplementedException();
    }

    @Override
    public final String getName() {
        return this.getConstructor().getName();
    }

    @Override
    public final int getSubtermCount() {
        return this.getConstructor().getArity();
    }

    @Override
    public final int getTermType() {
        return 1;
    }

    @Override
    protected final boolean doSlowMatch(IStrategoTerm second, int commonStorageType) {
        IStrategoList secondAnnotations;
        IStrategoList annotations;
        IStrategoTerm[] secondKids;
        if (second.getTermType() != 1) {
            return false;
        }
        IStrategoAppl o = (IStrategoAppl)second;
        if (this.getConstructor() != o.getConstructor()) {
            return false;
        }
        IStrategoTerm[] kids = this.getAllSubterms();
        if (kids != (secondKids = o.getAllSubterms())) {
            int i = 0;
            int sz = kids.length;
            while (i < sz) {
                IStrategoTerm kid = kids[i];
                IStrategoTerm secondKid = secondKids[i];
                if (kid != secondKid && !kid.match(secondKid)) {
                    if (commonStorageType == 2 && i != 0) {
                        System.arraycopy(secondKids, 0, kids, 0, i);
                    }
                    return false;
                }
                ++i;
            }
        }
        if ((annotations = this.getAnnotations()) == (secondAnnotations = second.getAnnotations())) {
            return true;
        }
        if (annotations.match(secondAnnotations)) {
            if (commonStorageType == 2) {
                this.internalSetAnnotations(secondAnnotations);
            }
            return true;
        }
        return false;
    }

    @Override
    public final void writeAsString(Appendable output, int maxDepth) throws IOException {
        output.append(this.getName());
        IStrategoTerm[] kids = this.getAllSubterms();
        if (kids.length > 0) {
            output.append('(');
            if (maxDepth == 0) {
                output.append("...");
            } else {
                kids[0].writeAsString(output, maxDepth - 1);
                int i = 1;
                while (i < kids.length) {
                    output.append(',');
                    kids[i].writeAsString(output, maxDepth - 1);
                    ++i;
                }
            }
            output.append(')');
        }
        this.appendAnnotations(output, maxDepth);
    }

    @Override
    @Deprecated
    public final void prettyPrint(ITermPrinter pp) {
        new NotImplementedException();
    }

    @Override
    protected final int hashFunction() {
        long r = this.getConstructor().hashCode();
        int accum = 6673;
        IStrategoTerm[] kids = this.getAllSubterms();
        int i = 0;
        while (i < kids.length) {
            r += (long)(kids[i].hashCode() * accum);
            accum *= 7703;
            ++i;
        }
        return (int)(r >> 12);
    }

    @Override
    public Iterator<IStrategoTerm> iterator() {
        return new ArrayIterator<IStrategoTerm>(this.getAllSubterms());
    }
}

