/*
 * Decompiled with CFR 0.152.
 */
package org.spoofax.terms;

import java.util.Iterator;
import org.spoofax.interpreter.terms.IStrategoList;
import org.spoofax.interpreter.terms.IStrategoTerm;
import org.spoofax.terms.ITermVisitor;
import org.spoofax.terms.StrategoListIterator;
import org.spoofax.terms.Term;

public abstract class TermVisitor
implements ITermVisitor {
    public final boolean visit(IStrategoTerm term) {
        this.preVisit(term);
        Iterator<IStrategoTerm> iterator = TermVisitor.tryGetListIterator(term);
        int i = 0;
        int max2 = term.getSubtermCount();
        while (i < max2) {
            IStrategoTerm child = iterator == null ? term.getSubterm(i) : iterator.next();
            boolean isDone = this.visit(child);
            if (isDone || this.isDone(null)) {
                this.postVisit(term);
                return true;
            }
            ++i;
        }
        this.postVisit(term);
        return false;
    }

    public static Iterator<IStrategoTerm> tryGetListIterator(IStrategoTerm term) {
        if (Term.isTermList(term)) {
            return StrategoListIterator.iterable((IStrategoList)term).iterator();
        }
        return null;
    }

    @Override
    public void postVisit(IStrategoTerm term) {
    }

    @Override
    public boolean isDone(IStrategoTerm term) {
        return false;
    }
}

