/*
 * Decompiled with CFR 0.152.
 */
package org.spoofax.terms;

import org.spoofax.interpreter.terms.IStrategoAppl;
import org.spoofax.interpreter.terms.IStrategoConstructor;
import org.spoofax.interpreter.terms.IStrategoInt;
import org.spoofax.interpreter.terms.IStrategoString;
import org.spoofax.interpreter.terms.IStrategoTerm;
import org.spoofax.interpreter.terms.ITermFactory;
import org.spoofax.terms.TermTransformer;

public class Term {
    public static String stringAt(IStrategoTerm t, int i) {
        return ((IStrategoString)t.getSubterm(i)).stringValue();
    }

    public static int intAt(IStrategoTerm t, int i) {
        return ((IStrategoInt)t.getSubterm(i)).intValue();
    }

    public static <T extends IStrategoTerm> T termAt(IStrategoTerm t, int i) {
        return (T)t.getSubterm(i);
    }

    public static IStrategoAppl applAt(IStrategoTerm t, int i) {
        return (IStrategoAppl)t.getSubterm(i);
    }

    public static boolean isTermString(IStrategoTerm t) {
        return t.getTermType() == 5;
    }

    public static String javaString(IStrategoTerm t) {
        return ((IStrategoString)t).stringValue();
    }

    public static boolean isTermList(IStrategoTerm t) {
        return t.getTermType() == 2;
    }

    public static boolean isTermInt(IStrategoTerm t) {
        return t.getTermType() == 3;
    }

    public static boolean isTermReal(IStrategoTerm t) {
        return t.getTermType() == 4;
    }

    public static boolean isTermAppl(IStrategoTerm t) {
        return t.getTermType() == 1;
    }

    public static boolean isTermNamed(IStrategoTerm t) {
        int type = t.getTermType();
        return type == 1 || type == 5;
    }

    public static int javaInt(IStrategoTerm term) {
        return ((IStrategoInt)term).intValue();
    }

    public static boolean hasConstructor(IStrategoAppl t, String ctorName) {
        return t.getConstructor().getName().equals(ctorName);
    }

    public static boolean isTermTuple(IStrategoTerm t) {
        return t.getTermType() == 7;
    }

    public static int asJavaInt(IStrategoTerm term) {
        return ((IStrategoInt)term).intValue();
    }

    public static String asJavaString(IStrategoTerm term) {
        return ((IStrategoString)term).stringValue();
    }

    public static IStrategoConstructor tryGetConstructor(IStrategoTerm term) {
        return term != null && term.getTermType() == 1 ? ((IStrategoAppl)term).getConstructor() : null;
    }

    public static String tryGetName(IStrategoTerm term) {
        return term != null && term.getTermType() == 1 ? ((IStrategoAppl)term).getConstructor().getName() : null;
    }

    public static IStrategoTerm removeAnnotations(IStrategoTerm inTerm, final ITermFactory factory) {
        TermTransformer trans = new TermTransformer(factory, true){

            @Override
            public IStrategoTerm preTransform(IStrategoTerm term) {
                switch (term.getTermType()) {
                    case 1: {
                        return factory.makeAppl(((IStrategoAppl)term).getConstructor(), term.getAllSubterms(), null);
                    }
                    case 2: {
                        return factory.makeList(term.getAllSubterms(), null);
                    }
                    case 5: {
                        return factory.makeString(((IStrategoString)term).stringValue());
                    }
                    case 7: {
                        return factory.makeTuple(term.getAllSubterms(), null);
                    }
                }
                return term;
            }
        };
        return trans.transform(inTerm);
    }
}

