/*
 * Decompiled with CFR 0.152.
 */
package org.spoofax.terms;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.spoofax.interpreter.terms.IStrategoConstructor;
import org.spoofax.interpreter.terms.IStrategoTerm;
import org.spoofax.interpreter.terms.ITermFactory;
import org.spoofax.terms.AbstractTermFactory;
import org.spoofax.terms.ParseError;
import org.spoofax.terms.TermFactory;
import org.spoofax.terms.util.NotImplementedException;
import org.spoofax.terms.util.PushbackStringIterator;

public class StringTermReader {
    protected final ITermFactory factory;

    public StringTermReader(ITermFactory factory) {
        this.factory = factory;
    }

    public ITermFactory getFactory() {
        return this.factory;
    }

    public IStrategoTerm parseFromString(String s) throws ParseError {
        return this.parseFromString(new PushbackStringIterator(s));
    }

    protected IStrategoTerm parseFromString(PushbackStringIterator bis) throws ParseError {
        this.parseSkip(bis);
        int ch = bis.read();
        switch (ch) {
            case 91: {
                return this.parseAnno(bis, this.parseList(bis));
            }
            case 40: {
                return this.parseAnno(bis, this.parseTuple(bis));
            }
            case 34: {
                return this.parseAnno(bis, this.parseString(bis));
            }
            case 60: {
                return this.parsePlaceholder(bis);
            }
        }
        bis.unread(ch);
        if (Character.isLetter((char)ch)) {
            return this.parseAnno(bis, this.parseAppl(bis));
        }
        if (Character.isDigit((char)ch) || ch == 45) {
            return this.parseAnno(bis, this.parseNumber(bis));
        }
        throw new ParseError("Invalid term: '" + (char)ch + "'");
    }

    private IStrategoTerm parseAnno(PushbackStringIterator bis, IStrategoTerm term) throws ParseError {
        this.parseSkip(bis);
        int ch = bis.read();
        if (ch == 123) {
            List<IStrategoTerm> annos = this.parseTermSequence(bis, '}');
            if (annos.size() == 0) {
                return this.factory.annotateTerm(term, TermFactory.EMPTY_LIST);
            }
            return this.factory.annotateTerm(term, this.factory.makeList(annos));
        }
        bis.unread(ch);
        return term;
    }

    private IStrategoTerm parseString(PushbackStringIterator bis) throws ParseError {
        int ch = bis.read();
        if (ch == 34) {
            return this.factory.makeString("");
        }
        StringBuilder sb = new StringBuilder();
        boolean escaped = false;
        do {
            escaped = false;
            if (ch == 92) {
                escaped = true;
                ch = bis.read();
            }
            if (escaped) {
                switch (ch) {
                    case 110: {
                        sb.append('\n');
                        break;
                    }
                    case 116: {
                        sb.append('\t');
                        break;
                    }
                    case 98: {
                        sb.append('\b');
                        break;
                    }
                    case 102: {
                        sb.append('\f');
                        break;
                    }
                    case 114: {
                        sb.append('\r');
                        break;
                    }
                    case 92: {
                        sb.append('\\');
                        break;
                    }
                    case 39: {
                        sb.append('\'');
                        break;
                    }
                    case 34: {
                        sb.append('\"');
                        break;
                    }
                    case 48: 
                    case 49: 
                    case 50: 
                    case 51: 
                    case 52: 
                    case 53: 
                    case 54: 
                    case 55: 
                    case 56: 
                    case 57: {
                        throw new NotImplementedException();
                    }
                    default: {
                        sb.append("\\" + (char)ch);
                    }
                }
                ch = bis.read();
                continue;
            }
            if (ch == 34) continue;
            if (ch == -1) {
                throw new ParseError("Unterminated string: " + sb);
            }
            sb.append((char)ch);
            ch = bis.read();
        } while (escaped || ch != 34);
        return this.factory.makeString(sb.toString());
    }

    private IStrategoTerm parseAppl(PushbackStringIterator bis) throws ParseError {
        StringBuilder sb = new StringBuilder();
        int ch = bis.read();
        do {
            sb.append((char)ch);
        } while (Character.isLetterOrDigit((char)(ch = bis.read())) || ch == 95 || ch == 45 || ch == 43 || ch == 42 || ch == 36);
        bis.unread(ch);
        this.parseSkip(bis);
        ch = bis.read();
        if (ch == 40) {
            List<IStrategoTerm> l = this.parseTermSequence(bis, ')');
            IStrategoConstructor c = this.factory.makeConstructor(sb.toString(), l.size());
            return this.factory.makeAppl(c, l.toArray(new IStrategoTerm[l.size()]));
        }
        bis.unread(ch);
        IStrategoConstructor c = this.factory.makeConstructor(sb.toString(), 0);
        return this.factory.makeAppl(c, AbstractTermFactory.EMPTY);
    }

    private IStrategoTerm parsePlaceholder(PushbackStringIterator bis) throws ParseError {
        IStrategoTerm template = this.parseFromString(bis);
        this.parseSkip(bis);
        if (bis.read() != 62) {
            throw new ParseError("Expected: '>'");
        }
        return this.factory.makePlaceholder(template);
    }

    private IStrategoTerm parseTuple(PushbackStringIterator bis) throws ParseError {
        return this.factory.makeTuple(this.parseTermSequence(bis, ')').toArray(AbstractTermFactory.EMPTY));
    }

    private List<IStrategoTerm> parseTermSequence(PushbackStringIterator bis, char endChar) throws ParseError {
        List<IStrategoTerm> els = Collections.emptyList();
        this.parseSkip(bis);
        int ch = bis.read();
        if (ch == endChar) {
            return els;
        }
        els = new ArrayList<IStrategoTerm>();
        bis.unread(ch);
        do {
            els.add(this.parseFromString(bis));
            this.parseSkip(bis);
        } while ((ch = bis.read()) == 44);
        if (ch != endChar) {
            bis.unread(ch);
            this.parseSkip(bis);
            ch = bis.read();
        }
        if (ch != endChar) {
            throw new ParseError("Sequence must end with '" + endChar + "', saw '" + (char)ch + "'");
        }
        return els;
    }

    private IStrategoTerm parseList(PushbackStringIterator bis) throws ParseError {
        return this.factory.makeList(this.parseTermSequence(bis, ']'));
    }

    private IStrategoTerm parseNumber(PushbackStringIterator bis) throws ParseError {
        String whole = this.parseDigitSequence(bis);
        int ch = bis.read();
        if (ch == 46) {
            String frac = this.parseDigitSequence(bis);
            ch = bis.read();
            if (ch == 101 || ch == 69) {
                String exp = this.parseDigitSequence(bis);
                double d = Double.parseDouble(String.valueOf(whole) + "." + frac + "e" + exp);
                return this.factory.makeReal(d);
            }
            bis.unread(ch);
            double d = Double.parseDouble(String.valueOf(whole) + "." + frac);
            return this.factory.makeReal(d);
        }
        bis.unread(ch);
        return this.factory.makeInt(Integer.parseInt(whole));
    }

    private String parseDigitSequence(PushbackStringIterator bis) throws ParseError {
        StringBuilder sb = new StringBuilder();
        int ch = bis.read();
        do {
            sb.append((char)ch);
        } while (Character.isDigit((char)(ch = bis.read())));
        bis.unread(ch);
        return sb.toString();
    }

    private void parseSkip(PushbackStringIterator input) throws ParseError {
        int b;
        block3: while (true) {
            b = input.read();
            switch (b) {
                case 9: 
                case 10: 
                case 32: {
                    continue block3;
                }
            }
            break;
        }
        input.unread(b);
    }
}

