/*
 * Decompiled with CFR 0.152.
 */
package org.spoofax.terms;

import java.io.IOException;
import java.util.Iterator;
import org.spoofax.interpreter.terms.IStrategoAppl;
import org.spoofax.interpreter.terms.IStrategoConstructor;
import org.spoofax.interpreter.terms.IStrategoList;
import org.spoofax.interpreter.terms.IStrategoTerm;
import org.spoofax.interpreter.terms.ITermPrinter;
import org.spoofax.terms.StrategoTerm;
import org.spoofax.terms.util.ArrayIterator;

public class StrategoAppl
extends StrategoTerm
implements IStrategoAppl {
    private static final long serialVersionUID = -2522680523775044390L;
    private final IStrategoConstructor ctor;
    private IStrategoTerm[] kids;

    public StrategoAppl(IStrategoConstructor ctor, IStrategoTerm[] kids, IStrategoList annotations, int storageType) {
        super(annotations, storageType);
        this.ctor = ctor;
        this.kids = kids;
        if (storageType != 0) {
            this.initImmutableHashCode();
        }
    }

    @Deprecated
    public IStrategoTerm[] getArguments() {
        return this.kids;
    }

    @Override
    public IStrategoConstructor getConstructor() {
        return this.ctor;
    }

    @Override
    public String getName() {
        return this.ctor.getName();
    }

    @Override
    public IStrategoTerm[] getAllSubterms() {
        return this.kids;
    }

    @Override
    public IStrategoTerm getSubterm(int index) {
        if (index < 0 || index >= this.kids.length) {
            throw new IndexOutOfBoundsException("Index out of bounds: " + index);
        }
        return this.kids[index];
    }

    @Override
    public int getSubtermCount() {
        return this.kids.length;
    }

    @Override
    public int getTermType() {
        return 1;
    }

    @Override
    protected boolean doSlowMatch(IStrategoTerm second, int commonStorageType) {
        IStrategoList secondAnnotations;
        IStrategoList annotations;
        IStrategoTerm[] secondKids;
        if (second.getTermType() != 1) {
            return false;
        }
        IStrategoAppl o = (IStrategoAppl)second;
        if (!this.ctor.equals(o.getConstructor())) {
            return false;
        }
        IStrategoTerm[] kids = this.getAllSubterms();
        if (kids != (secondKids = o.getAllSubterms())) {
            int i = 0;
            int sz = kids.length;
            while (i < sz) {
                IStrategoTerm kid = kids[i];
                IStrategoTerm secondKid = secondKids[i];
                if (kid != secondKid && !kid.match(secondKid)) {
                    if (commonStorageType == 2 && i != 0) {
                        System.arraycopy(secondKids, 0, kids, 0, i);
                    }
                    return false;
                }
                ++i;
            }
            if (commonStorageType == 2) {
                this.kids = secondKids;
            }
        }
        if ((annotations = this.getAnnotations()) == (secondAnnotations = second.getAnnotations())) {
            return true;
        }
        if (annotations.match(secondAnnotations)) {
            if (commonStorageType == 2) {
                this.internalSetAnnotations(secondAnnotations);
            }
            return true;
        }
        return false;
    }

    @Override
    @Deprecated
    public void prettyPrint(ITermPrinter pp) {
        pp.print(this.ctor.getName());
        IStrategoTerm[] kids = this.getAllSubterms();
        if (kids.length > 0) {
            pp.println("(");
            pp.indent(this.ctor.getName().length());
            kids[0].prettyPrint(pp);
            int i = 1;
            while (i < kids.length) {
                pp.print(",");
                kids[i].prettyPrint(pp);
                ++i;
            }
            pp.println(")");
            pp.outdent(this.ctor.getName().length());
        }
        this.printAnnotations(pp);
    }

    @Override
    public void writeAsString(Appendable output, int maxDepth) throws IOException {
        output.append(this.ctor.getName());
        IStrategoTerm[] kids = this.getAllSubterms();
        if (kids.length > 0) {
            output.append('(');
            if (maxDepth == 0) {
                output.append("...");
            } else {
                kids[0].writeAsString(output, maxDepth - 1);
                int i = 1;
                while (i < kids.length) {
                    output.append(',');
                    kids[i].writeAsString(output, maxDepth - 1);
                    ++i;
                }
            }
            output.append(')');
        }
        this.appendAnnotations(output, maxDepth);
    }

    @Override
    public int hashFunction() {
        long r = this.ctor.hashCode();
        int accum = 6673;
        IStrategoTerm[] kids = this.getAllSubterms();
        int i = 0;
        while (i < kids.length) {
            r += (long)(kids[i].hashCode() * accum);
            accum *= 7703;
            ++i;
        }
        return (int)(r >> 12);
    }

    @Override
    public Iterator<IStrategoTerm> iterator() {
        return new ArrayIterator<IStrategoTerm>(this.kids);
    }
}

