/*
 * Decompiled with CFR 0.152.
 */
package org.spoofax.terms;

import java.io.IOException;
import org.spoofax.interpreter.terms.IStrategoList;
import org.spoofax.interpreter.terms.IStrategoTerm;
import org.spoofax.interpreter.terms.ITermFactory;
import org.spoofax.interpreter.terms.ITermPrinter;
import org.spoofax.terms.StrategoWrapped;
import org.spoofax.terms.TermFactory;

public class StrategoAnnotation
extends StrategoWrapped {
    private static final long serialVersionUID = 2918341202178665547L;
    private final ITermFactory factory;

    public StrategoAnnotation(ITermFactory factory, IStrategoTerm term, IStrategoList annotations) {
        super(term, annotations);
        if (!term.getAnnotations().isEmpty()) {
            throw new IllegalArgumentException("Annotated term cannot already have annotations");
        }
        this.factory = factory;
    }

    @Override
    protected boolean doSlowMatch(IStrategoTerm second, int commonStorageType) {
        IStrategoList secondAnnotations;
        IStrategoTerm wrapped = this.getWrapped();
        IStrategoList annotations = this.getAnnotations();
        if (annotations != (secondAnnotations = second.getAnnotations())) {
            if (annotations.match(secondAnnotations)) {
                if (commonStorageType == 2) {
                    this.internalSetAnnotations(secondAnnotations);
                }
            } else {
                return false;
            }
        }
        if (annotations.isEmpty()) {
            return wrapped.match(second);
        }
        second = this.factory.annotateTerm(second, TermFactory.EMPTY_LIST);
        return wrapped.match(second);
    }

    @Override
    protected int hashFunction() {
        assert (this.getWrapped().getAnnotations().isEmpty()) : "Constructor contract broken";
        return this.getWrapped().hashCode();
    }

    @Override
    public String toString() {
        StringBuilder result = new StringBuilder();
        try {
            this.getWrapped().writeAsString(result, Integer.MAX_VALUE);
            this.appendAnnotations(result, Integer.MAX_VALUE);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return result.toString();
    }

    @Override
    public void writeAsString(Appendable output, int maxDepth) throws IOException {
        this.getWrapped().writeAsString(output, maxDepth);
        this.appendAnnotations(output, maxDepth);
    }

    @Override
    @Deprecated
    public void prettyPrint(ITermPrinter pp) {
        this.getWrapped().prettyPrint(pp);
        this.printAnnotations(pp);
    }

    @Override
    @Deprecated
    public IStrategoList prepend(IStrategoTerm prefix) {
        throw new UnsupportedOperationException();
    }
}

