/*
 * Decompiled with CFR 0.152.
 */
package org.spoofax.jsglr.io;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;
import org.spoofax.interpreter.terms.IStrategoTerm;
import org.spoofax.interpreter.terms.ITermFactory;
import org.spoofax.jsglr.client.InvalidParseTableException;
import org.spoofax.jsglr.client.ParseTable;
import org.spoofax.jsglr.io.SGLR;
import org.spoofax.jsglr.shared.Tools;
import org.spoofax.terms.ParseError;
import org.spoofax.terms.TermFactory;
import org.spoofax.terms.io.binary.TermReader;

public class ParseTableManager {
    private final Map<String, CachedTable> cache = new HashMap<String, CachedTable>();
    private final ITermFactory factory;
    private boolean useDiskCache;

    public ParseTableManager() {
        this(new TermFactory());
    }

    public ParseTableManager(ITermFactory factory) {
        this(factory, false);
    }

    public ParseTableManager(ITermFactory factory, boolean useDiskCache) {
        this.factory = factory;
        this.useDiskCache = useDiskCache;
    }

    public ParseTable loadFromFile(String filename) throws FileNotFoundException, IOException, InvalidParseTableException {
        CachedTable cached;
        ParseTable pt = null;
        if (this.cache.containsKey(filename) && (pt = (ParseTable)(cached = this.cache.get(filename)).get()) != null && cached.isUpToDate()) {
            return pt;
        }
        if (this.useDiskCache) {
            String cachedTable = this.hashFilename(filename);
            File cached2 = new File(cachedTable);
            File table = new File(filename);
            if (cached2.exists() && cached2.lastModified() >= table.lastModified()) {
                try {
                    pt = this.loadFromDiskCache(cachedTable);
                    pt.initTransientData(this.factory);
                }
                catch (ClassNotFoundException classNotFoundException) {}
            }
        }
        if (pt == null) {
            pt = this.loadFromStream(new FileInputStream(filename));
            if (this.useDiskCache) {
                this.storeInDiskCache(pt, filename);
            }
        }
        this.cache.put(filename, new CachedTable(pt, filename));
        return pt;
    }

    private void storeInDiskCache(ParseTable pt, String filename) throws FileNotFoundException, IOException {
        String storeName = this.hashFilename(filename);
        File dir = new File(String.valueOf(System.getProperty("user.home")) + "/.jsglr/cache/");
        if (!dir.exists()) {
            dir.mkdirs();
        }
        ObjectOutputStream ous = new ObjectOutputStream(new FileOutputStream(storeName));
        ous.writeObject(pt);
        ous.close();
    }

    private ParseTable loadFromDiskCache(String cachedTable) throws FileNotFoundException, IOException, ClassNotFoundException {
        System.out.println("Loading " + cachedTable);
        ObjectInputStream ois = new ObjectInputStream(new FileInputStream(cachedTable));
        ParseTable pt = (ParseTable)ois.readObject();
        return pt;
    }

    private String hashFilename(String filename) {
        return String.valueOf(System.getProperty("user.home")) + "/.jsglr/cache/" + String.format("%x", filename.hashCode());
    }

    public ParseTable loadFromStream(InputStream stream) throws IOException, InvalidParseTableException, ParseError {
        if (stream == null) {
            throw new InvalidParseTableException("stream is null");
        }
        return this.initializeParseTable(this.factory, new TermReader(this.factory).parseFromStream(stream));
    }

    private ParseTable initializeParseTable(ITermFactory factory, IStrategoTerm pt) throws InvalidParseTableException {
        long start2 = System.currentTimeMillis();
        ParseTable parseTable = new ParseTable(pt, factory);
        long elapsed = System.currentTimeMillis() - start2;
        if (SGLR.isLogging()) {
            Tools.logger("Loading parse table took " + (float)elapsed / 1000.0f + "s");
            Tools.logger("No. of states: ", parseTable.getStateCount());
            Tools.logger("No. of productions: ", parseTable.getProductionCount());
            Tools.logger("No. of action entries: ", parseTable.getActionCount());
            Tools.logger("No. of gotos entries: ", parseTable.getGotoCount());
            Tools.logger(parseTable.hasRejects() ? "Includes" : "Excludes", " rejects");
            Tools.logger(parseTable.hasPriorities() ? "Includes" : "Excludes", " priorities");
            Tools.logger(parseTable.hasPrefers() ? "Includes" : "Excludes", " prefer actions");
            Tools.logger(parseTable.hasAvoids() ? "Includes" : "Excludes", " avoid actions");
        }
        return parseTable;
    }

    public ITermFactory getFactory() {
        return this.factory;
    }

    public ParseTable loadFromTerm(IStrategoTerm term) throws InvalidParseTableException {
        return this.initializeParseTable(this.factory, term);
    }

    private class CachedTable
    extends WeakReference<ParseTable> {
        private String path;
        private long lastModified;

        public CachedTable(ParseTable table, String path) {
            super(table);
            this.path = path;
            this.lastModified = new File(path).lastModified();
        }

        public boolean isUpToDate() {
            return new File(this.path).lastModified() == this.lastModified;
        }
    }
}

