/*
 * Decompiled with CFR 0.152.
 */
package org.spoofax.jsglr.client.imploder;

import org.spoofax.interpreter.terms.IStrategoAppl;
import org.spoofax.jsglr.client.AbstractParseNode;
import org.spoofax.jsglr.client.ITreeBuilder;
import org.spoofax.jsglr.client.ParseTable;
import org.spoofax.jsglr.client.imploder.ITokenizer;

public class MemoryRecordingTreeBuilder
implements ITreeBuilder {
    private final ITreeBuilder actualBuilder;
    private long maxTotalMemory = Long.MIN_VALUE;
    private long maxUsedMemory = Long.MIN_VALUE;
    private long minTotalMemory = Long.MAX_VALUE;
    private long minUsedMemory = Long.MAX_VALUE;
    private int measureCount = 0;

    public MemoryRecordingTreeBuilder(ITreeBuilder actualBuilder) {
        this.measure();
        this.actualBuilder = actualBuilder;
    }

    private void measure() {
        long total = Runtime.getRuntime().totalMemory();
        long free = Runtime.getRuntime().freeMemory();
        long used = total - free;
        this.maxTotalMemory = Math.max(this.maxTotalMemory, total);
        this.maxUsedMemory = Math.max(this.maxUsedMemory, used);
        this.minTotalMemory = Math.min(this.minTotalMemory, total);
        this.minUsedMemory = Math.min(this.minUsedMemory, used);
        ++this.measureCount;
    }

    @Override
    public void initializeTable(ParseTable table, int productionCount, int labelStart, int labelCount) {
        this.measure();
        this.actualBuilder.initializeTable(table, productionCount, labelStart, labelCount);
    }

    @Override
    public void initializeLabel(int labelNumber, IStrategoAppl parseTreeProduction) {
        this.measure();
        this.actualBuilder.initializeLabel(labelNumber, parseTreeProduction);
    }

    @Override
    public void initializeInput(String input, String filename) {
        this.measure();
        this.actualBuilder.initializeInput(input, filename);
    }

    @Override
    public Object buildTree(AbstractParseNode node) {
        this.measure();
        return this.actualBuilder.buildTree(node);
    }

    @Override
    public Object buildTreeTop(Object subtree, int ambiguityCount) {
        this.measure();
        return this.actualBuilder.buildTreeTop(subtree, ambiguityCount);
    }

    @Override
    public void reset() {
        this.measure();
        this.actualBuilder.reset();
    }

    @Override
    public void reset(int startOffset) {
    }

    @Override
    public ITokenizer getTokenizer() {
        this.measure();
        return this.actualBuilder.getTokenizer();
    }

    public long getMaxTotal() {
        return this.maxTotalMemory;
    }

    public long getMaxUsed() {
        return this.maxUsedMemory;
    }

    public long getMinTotal() {
        return this.minTotalMemory;
    }

    public long getMinUsed() {
        return this.minUsedMemory;
    }

    public int getMeasureCount() {
        return this.measureCount;
    }
}

