/*
 * Decompiled with CFR 0.152.
 */
package org.spoofax.jsglr.client.editregion.detection;

import java.util.ArrayList;
import org.spoofax.jsglr.client.editregion.detection.DamagedTokenAnalyzer;
import org.spoofax.jsglr.client.editregion.detection.DiscardableRegion;
import org.spoofax.jsglr.client.editregion.detection.HelperFunctions;
import org.spoofax.jsglr.client.imploder.IToken;
import org.spoofax.jsglr.client.imploder.Token;

public class LayoutEditsAnalyzer {
    private final DamagedTokenAnalyzer tokenEdits;
    private final ArrayList<DiscardableRegion> damagedCommentRegions;
    private final ArrayList<Integer> offsetsDeletedLayoutChars = new ArrayList();

    public ArrayList<DiscardableRegion> getDamagedCommentRegions() {
        return this.damagedCommentRegions;
    }

    public void filterNonLayoutOffsets(ArrayList<Integer> deletedOffsets) {
        deletedOffsets.removeAll(this.offsetsDeletedLayoutChars);
    }

    public LayoutEditsAnalyzer(DamagedTokenAnalyzer tokenEdits) {
        this.damagedCommentRegions = new ArrayList();
        this.tokenEdits = tokenEdits;
        this.analyze();
    }

    private void analyze() {
        DiscardableRegion commentRegion;
        String input = this.tokenEdits.getTokens().getInput();
        for (IToken tokenWithDeletions : this.tokenEdits.getTokensDamagedByDeletion()) {
            if (tokenWithDeletions.getKind() != 7) continue;
            if (!this.tokenEdits.isDamagingLayoutDeletion(tokenWithDeletions)) {
                this.offsetsDeletedLayoutChars.addAll(this.tokenEdits.getOffsetsDeletions(tokenWithDeletions));
            }
            if (Token.isWhiteSpace(tokenWithDeletions)) continue;
            commentRegion = new DiscardableRegion(tokenWithDeletions.getStartOffset(), tokenWithDeletions.getEndOffset(), input);
            assert (!HelperFunctions.contains(this.damagedCommentRegions, commentRegion));
            this.damagedCommentRegions.add(commentRegion);
        }
        for (IToken tokenWithInsertions : this.tokenEdits.getTokensDamagedByInsertion()) {
            if (tokenWithInsertions.getKind() != 7 || Token.isWhiteSpace(tokenWithInsertions) || HelperFunctions.contains(this.damagedCommentRegions, commentRegion = new DiscardableRegion(tokenWithInsertions.getStartOffset(), tokenWithInsertions.getEndOffset(), input))) continue;
            this.damagedCommentRegions.add(commentRegion);
        }
    }
}

