/*
 * Decompiled with CFR 0.152.
 */
package org.spoofax.jsglr.client.editregion.detection;

import java.util.ArrayList;
import java.util.Collections;

public class DiscardableRegion {
    private final int startOffset;
    private final int endOffset;
    private final String inputString;

    public DiscardableRegion(int startOffset, int endOffset, String inputString) {
        this.startOffset = startOffset;
        this.endOffset = endOffset;
        this.inputString = inputString;
        assert (inputString != null);
        assert (startOffset <= endOffset);
        assert (startOffset >= 0);
        assert (endOffset <= inputString.length() - 1);
    }

    public int getStartOffset() {
        return this.startOffset;
    }

    public int getEndOffset() {
        return this.endOffset;
    }

    public String getInputString() {
        return this.inputString;
    }

    public static String replaceAllRegionsByWhitespace(ArrayList<DiscardableRegion> regions, String input) {
        String result = input;
        for (DiscardableRegion region : regions) {
            assert (region.getInputString() == input);
            result = DiscardableRegion.replaceRegionByWhitespace(region, result);
        }
        return result;
    }

    public static ArrayList<DiscardableRegion> constructRegionsFromOffsets(ArrayList<Integer> offsets, String inputString) {
        ArrayList<DiscardableRegion> result = new ArrayList<DiscardableRegion>();
        int startOffset = -1;
        int i = 0;
        while (i < offsets.size()) {
            int offset = offsets.get(i);
            if (i == 0) {
                startOffset = offsets.get(i);
            } else if (offset != offsets.get(i - 1) + 1) {
                DiscardableRegion region = new DiscardableRegion(startOffset, offsets.get(i - 1), inputString);
                result.add(region);
                startOffset = offsets.get(i);
            }
            ++i;
        }
        if (startOffset != -1) {
            DiscardableRegion region = new DiscardableRegion(startOffset, offsets.get(offsets.size() - 1), inputString);
            result.add(region);
        }
        return result;
    }

    public static ArrayList<Integer> getOffsets(ArrayList<DiscardableRegion> editRegions) {
        ArrayList<Integer> result = new ArrayList<Integer>();
        for (DiscardableRegion region : editRegions) {
            int startOffset = region.getStartOffset();
            int endOffset = region.getEndOffset();
            int offset = startOffset;
            while (offset <= endOffset) {
                if (!result.contains(offset)) {
                    result.add(offset);
                }
                ++offset;
            }
        }
        Collections.sort(result);
        return result;
    }

    public static ArrayList<DiscardableRegion> mergeSubsequentRegions(ArrayList<DiscardableRegion> regions) {
        ArrayList<DiscardableRegion> merged = new ArrayList<DiscardableRegion>();
        if (!regions.isEmpty()) {
            merged.add(regions.get(0));
        }
        int index = 1;
        while (index < regions.size()) {
            DiscardableRegion r1 = (DiscardableRegion)merged.get(0);
            DiscardableRegion r2 = regions.get(index);
            assert (r2.getEndOffset() > r1.getStartOffset()) : "input regions should be ordered";
            if (r1.getEndOffset() + 1 < r2.getStartOffset()) {
                merged.add(r2);
            } else {
                int startOffset = Math.min(r1.getStartOffset(), r2.getStartOffset());
                int endOffset = Math.max(r1.getEndOffset(), r2.getEndOffset());
                assert (r1.getInputString() == r2.getInputString());
                DiscardableRegion mergedRegion = new DiscardableRegion(startOffset, endOffset, r1.getInputString());
                merged.set(merged.size() - 1, mergedRegion);
            }
            ++index;
        }
        assert (merged.size() <= regions.size());
        return merged;
    }

    public static ArrayList<DiscardableRegion> mergeRegions(ArrayList<DiscardableRegion> regions1, ArrayList<DiscardableRegion> regions2) {
        DiscardableRegion r1;
        ArrayList<DiscardableRegion> merged = new ArrayList<DiscardableRegion>();
        int index_r1 = 0;
        int index_r2 = 0;
        while (index_r1 < regions1.size() && index_r2 < regions2.size()) {
            r1 = regions1.get(index_r1);
            DiscardableRegion r2 = regions2.get(index_r2);
            if (r1.getEndOffset() < r2.getStartOffset()) {
                merged.add(r1);
                ++index_r1;
                continue;
            }
            if (r2.getEndOffset() < r1.getStartOffset()) {
                merged.add(r2);
                ++index_r2;
                continue;
            }
            int startOffset = Math.min(r1.getStartOffset(), r2.getStartOffset());
            int endOffset = Math.max(r1.getEndOffset(), r2.getEndOffset());
            assert (r1.getInputString() == r2.getInputString());
            DiscardableRegion mergedRegion = new DiscardableRegion(startOffset, endOffset, r1.getInputString());
            merged.add(mergedRegion);
            ++index_r1;
            ++index_r2;
        }
        while (index_r1 < regions1.size()) {
            r1 = regions1.get(index_r1);
            merged.add(r1);
            ++index_r1;
        }
        while (index_r2 < regions2.size()) {
            DiscardableRegion r2 = regions2.get(index_r2);
            merged.add(r2);
            ++index_r2;
        }
        return merged;
    }

    public static ArrayList<String> constructFragments(ArrayList<DiscardableRegion> regions) {
        ArrayList<String> result = new ArrayList<String>();
        for (DiscardableRegion region : regions) {
            String fragment = region.constructFragment();
            result.add(fragment);
        }
        return result;
    }

    public String constructFragment() {
        return this.inputString.substring(this.getStartOffset(), this.getEndOffset() + 1);
    }

    public DiscardableRegion extendRegionWithWhitespace() {
        int start2 = this.startOffset;
        while (start2 > 0 && Character.isWhitespace(this.inputString.charAt(start2 - 1))) {
            --start2;
        }
        int end = this.endOffset;
        while (end < this.inputString.length() - 2 && Character.isWhitespace(this.inputString.charAt(end + 1))) {
            ++end;
        }
        return new DiscardableRegion(start2, end, this.inputString);
    }

    public String toString() {
        return this.constructFragment();
    }

    private static String replaceRegionByWhitespace(DiscardableRegion region, String modifiedInput) {
        assert (modifiedInput.length() == region.getInputString().length());
        char[] chars = modifiedInput.toCharArray();
        int offset = region.getStartOffset();
        while (offset <= region.getEndOffset()) {
            char charAtOffset = chars[offset];
            if (!Character.isWhitespace(charAtOffset)) {
                chars[offset] = 32;
            }
            ++offset;
        }
        return String.valueOf(chars);
    }
}

