/*
 * Decompiled with CFR 0.152.
 */
package org.spoofax.jsglr.client;

import java.util.ArrayList;
import org.spoofax.jsglr.client.IndentInfo;
import org.spoofax.jsglr.client.IndentationHandler;
import org.spoofax.jsglr.client.SGLR;
import org.spoofax.jsglr.client.TokenOffset;
import org.spoofax.terms.util.PushbackStringIterator;

public class ParserHistory {
    private IndentationHandler indentHandler;
    private IndentationHandler recoveryIndentHandler;
    private ArrayList<IndentInfo> newLinePoints = new ArrayList();
    private int recoverTokenCount;
    private int tokenIndex;

    public int getTokenIndex() {
        return this.tokenIndex;
    }

    public int getIndexLastToken() {
        return this.recoverTokenCount - 1;
    }

    public void setTokenIndex(int tokenIndex) {
        this.tokenIndex = tokenIndex;
    }

    public ParserHistory() {
        this.clear();
    }

    public void clear() {
        this.newLinePoints.clear();
        this.recoverTokenCount = 0;
        this.tokenIndex = 0;
        this.indentHandler = new IndentationHandler();
        this.recoveryIndentHandler = new IndentationHandler();
    }

    public void resetRecoveryIndentHandler(int indentValue) {
        this.recoveryIndentHandler = new IndentationHandler();
        this.recoveryIndentHandler.setInLeftMargin(true);
        this.recoveryIndentHandler.setIndentValue(indentValue);
    }

    public void readRecoverToken(SGLR myParser, boolean keepStacks) {
        if (this.hasFinishedRecoverTokens()) {
            if (myParser.getCurrentToken().getToken() != 256 && this.getIndexLastToken() >= 0) {
                myParser.readNextToken();
                this.indentHandler.updateIndentation(myParser.getCurrentToken().getToken());
                ++this.recoverTokenCount;
                if (myParser.getCurrentToken().getToken() == 256) {
                    this.keepNewLinePoint(myParser, myParser.getParserLocation(), !keepStacks, this.indentHandler);
                } else if (this.indentHandler.lineMarginEnded()) {
                    this.keepNewLinePoint(myParser, myParser.getParserLocation() - 1, !keepStacks, this.indentHandler);
                }
            }
        } else {
            int ct = this.readCharAt(this.tokenIndex, myParser.currentInputStream);
            myParser.setCurrentToken(new TokenOffset(ct, this.tokenIndex));
            if (myParser.getReadNonLayout() && myParser.getApplyCompletionProd()) {
                myParser.setApplyCompletionProd(false);
            } else if (!myParser.getApplyCompletionProd() && this.tokenIndex < myParser.getCursorLocation()) {
                myParser.setReadNonLayout(false);
                myParser.setApplyCompletionProd(true);
            }
            if (this.tokenIndex > myParser.getCursorLocation() && !myParser.isLayout(ct)) {
                myParser.setReadNonLayout(true);
            }
            if (myParser.getCurrentToken().getToken() == -1) {
                myParser.setCurrentToken(new TokenOffset(256, Integer.MAX_VALUE));
            }
            if (keepStacks) {
                this.addStackNodesToNewLinePoint(myParser);
            }
        }
        ++this.tokenIndex;
    }

    public boolean hasFinishedRecoverTokens() {
        return this.tokenIndex >= this.recoverTokenCount;
    }

    public int getTokensSeenStartLine(int tokPosition, PushbackStringIterator chars) {
        int tokIndexLine = tokPosition;
        while (this.readCharAt(tokIndexLine, chars) != 10 && tokIndexLine > 0) {
            --tokIndexLine;
        }
        return tokIndexLine;
    }

    private int readCharAt(int offset, PushbackStringIterator chars) {
        chars.setOffset(offset);
        return chars.read();
    }

    public void keepTokenAndState(SGLR myParser) {
        this.indentHandler.updateIndentation(myParser.getCurrentToken().getToken());
        ++this.recoverTokenCount;
        ++this.tokenIndex;
        if (this.indentHandler.lineMarginEnded() || myParser.getCurrentToken().getToken() == 256 || this.tokenIndex == 1) {
            this.keepNewLinePoint(myParser, myParser.getParserLocation() - 1, false, this.indentHandler);
        } else if (this.indentHandler.lineMarginEnded() || myParser.getCurrentToken().getToken() == 256 || this.tokenIndex == 1) {
            this.keepNewLinePoint(myParser, myParser.getParserLocation() - 1, false, this.indentHandler);
        }
    }

    public void keepInitialState(SGLR myParser) {
        IndentInfo newLinePoint = new IndentInfo(0, 0, 0);
        newLinePoint.fillStackNodes(myParser.activeStacks);
        this.newLinePoints.add(newLinePoint);
    }

    private void keepNewLinePoint(SGLR myParser, int tokSeen, boolean inRecoverMode, IndentationHandler anIndentHandler) {
        int indent = anIndentHandler.getIndentValue();
        IndentInfo newLinePoint = new IndentInfo(myParser.lineNumber, tokSeen, indent);
        this.newLinePoints.add(newLinePoint);
        if (!inRecoverMode) {
            newLinePoint.fillStackNodes(myParser.activeStacks);
        }
    }

    private void addStackNodesToNewLinePoint(SGLR myParser) {
        int tokensSeen = myParser.getParserLocation() - 1;
        int i = this.newLinePoints.size() - 1;
        while (i >= 0) {
            IndentInfo newLinePoint = this.newLinePoints.get(i);
            if (newLinePoint.getTokensSeen() == tokensSeen) {
                newLinePoint.fillStackNodes(myParser.activeStacks);
                return;
            }
            if (newLinePoint.getTokensSeen() < tokensSeen) {
                return;
            }
            --i;
        }
    }

    public String getFragment(int startTok, int endTok, PushbackStringIterator chars) {
        StringBuilder fragment = new StringBuilder();
        int i = startTok;
        while (i <= endTok) {
            int nextChar = this.readCharAt(i, chars);
            if (i >= this.recoverTokenCount || nextChar == -1) break;
            fragment.append((char)nextChar);
            ++i;
        }
        return fragment.toString();
    }

    public String readLine(int StartTok, PushbackStringIterator chars) {
        StringBuilder fragment = new StringBuilder();
        int pos = StartTok;
        int currentTok = 32;
        while (currentTok != 10 && currentTok != 256 && pos < this.recoverTokenCount) {
            currentTok = this.readCharAt(pos, chars);
            fragment.append((char)currentTok);
            ++pos;
        }
        return fragment.toString();
    }

    public IndentInfo getLine(int index) {
        if (index < 0 || index > this.getIndexLastLine()) {
            return null;
        }
        return this.newLinePoints.get(index);
    }

    public IndentInfo getLastLine() {
        return this.newLinePoints.get(this.newLinePoints.size() - 1);
    }

    public int getIndexLastLine() {
        return this.newLinePoints.size() - 1;
    }

    public ArrayList<IndentInfo> getLinesFromTo(int startIndex, int endLocation) {
        int indexLine = startIndex;
        ArrayList<IndentInfo> result = new ArrayList<IndentInfo>();
        IndentInfo firstLine = this.newLinePoints.get(indexLine);
        while (indexLine < this.newLinePoints.size()) {
            firstLine = this.newLinePoints.get(indexLine);
            if (firstLine.getTokensSeen() < endLocation) {
                result.add(firstLine);
                ++indexLine;
                continue;
            }
            indexLine = this.newLinePoints.size();
        }
        return result;
    }

    public void deleteLinesFrom(int startIndexErrorFragment) {
        if (startIndexErrorFragment >= 0 && startIndexErrorFragment < this.newLinePoints.size() - 1) {
            ArrayList<IndentInfo> shrinkedList = new ArrayList<IndentInfo>();
            shrinkedList.addAll(this.newLinePoints.subList(0, startIndexErrorFragment));
            this.newLinePoints = shrinkedList;
        } else if (startIndexErrorFragment > this.newLinePoints.size() - 1) {
            System.err.println("StartIndex Error Fragment: " + startIndexErrorFragment);
            System.err.println("Numeber Of Lines in History: : " + this.newLinePoints.size());
            System.err.println("Unexpected index of history new-line-points");
        }
    }

    public int getLineOfTokenPosition(int tokPos) {
        int i = 1;
        while (i < this.newLinePoints.size()) {
            IndentInfo line = this.newLinePoints.get(i);
            if (line.getTokensSeen() > tokPos) {
                return i - 1;
            }
            ++i;
        }
        return this.newLinePoints.size() - 1;
    }
}

