/*
 * Decompiled with CFR 0.152.
 */
package org.spoofax.jsglr.client;

import java.util.ArrayList;
import org.spoofax.jsglr.client.FineGrainedSetting;
import org.spoofax.jsglr.client.Frame;
import org.spoofax.jsglr.client.Link;
import org.spoofax.jsglr.client.ParserHistory;
import org.spoofax.jsglr.client.RecoverNode;
import org.spoofax.jsglr.client.RecoveryConnector;
import org.spoofax.jsglr.client.SGLR;

public class FineGrainedRecovery {
    private static final int MAX_NUMBER_OF_RECOVER_BRANCHES = 1000;
    private static final int ACCEPT_DISTANCE_CHARACTERS = 100;
    private final FineGrainedSetting settings;
    private int exploredRegionStartOffset;
    private int exploredRegionEndOffset;
    private int lineIndexRecovery;
    private int failureOffset;
    private long recoverStartTime;
    private final SGLR mySGLR;

    private void checkAssertionsForErrorProperties() {
        assert (this.exploredRegionStartOffset < this.exploredRegionEndOffset);
        assert (this.exploredRegionStartOffset < this.failureOffset);
        assert (this.lineIndexRecovery <= this.getHistory().getIndexLastLine());
        assert (this.getTokensSeenAtLine(this.lineIndexRecovery) <= this.failureOffset);
        assert (this.failureOffset >= this.getTokensSeenAtLine(this.lineIndexRecovery));
    }

    private void checkAssertionsUnexploredBranches(ArrayList<RecoverNode> unexplored_branches, int bwIndex) {
        for (RecoverNode recoverNode : unexplored_branches) {
            assert (this.exploredRegionStartOffset <= recoverNode.tokensSeen);
            assert (this.getTokensSeenAtLine(bwIndex) <= recoverNode.tokensSeen);
            assert (recoverNode.tokensSeen <= this.exploredRegionEndOffset);
        }
    }

    private ParserHistory getHistory() {
        return this.mySGLR.getHistory();
    }

    public FineGrainedRecovery(SGLR parser) {
        this(parser, FineGrainedSetting.createDefaultSetting());
    }

    public FineGrainedRecovery(SGLR parser, FineGrainedSetting fgSettings) {
        this.settings = fgSettings;
        this.mySGLR = parser;
    }

    public boolean recover(int failureOffset, int recoverIndex, int regionStartOffset, int regionEndOffset) throws InterruptedException {
        this.exploredRegionStartOffset = regionStartOffset;
        this.exploredRegionEndOffset = regionEndOffset;
        return this.finegrainedRecover(failureOffset, recoverIndex);
    }

    public boolean recover(int failureOffset, int recoverIndex) throws InterruptedException {
        this.exploredRegionStartOffset = -1;
        this.exploredRegionEndOffset = Integer.MAX_VALUE;
        return this.finegrainedRecover(failureOffset, recoverIndex);
    }

    private boolean finegrainedRecover(int failureOffset, int recoverIndex) throws InterruptedException {
        this.failureOffset = failureOffset;
        this.lineIndexRecovery = recoverIndex;
        this.recoverStartTime = System.currentTimeMillis();
        this.checkAssertionsForErrorProperties();
        this.mySGLR.setFineGrainedRecoverMax(this.settings.getMaxNumberOfRecoverApplicationsLocal());
        return this.recoverFrom(0, new ArrayList<RecoverNode>());
    }

    private boolean recoverFrom(int loopIndex, ArrayList<RecoverNode> unexplored_branches) throws InterruptedException {
        int bwLoopIndex = this.lineIndexRecovery - (int)(this.settings.getBackwardFactor() * (double)loopIndex);
        int backwardIndex = Math.max(0, bwLoopIndex);
        int forwardLinesMax = Math.min(this.settings.getForwardDistanceLines(), (int)(this.settings.getForwardFactor() * (double)loopIndex));
        assert (forwardLinesMax >= 0);
        assert (forwardLinesMax <= this.settings.getForwardDistanceLines());
        unexplored_branches.addAll(this.getBackwardRecoverCandidates(loopIndex));
        this.checkAssertionsUnexploredBranches(unexplored_branches, backwardIndex);
        this.resetSGLR(backwardIndex, false);
        ArrayList<RecoverNode> newCandidates = this.recoverParse(forwardLinesMax, this.exploredRegionEndOffset, unexplored_branches);
        if (!this.acceptParse()) {
            if (this.timelimitExpired()) {
                return false;
            }
            if (this.continueBacktracking(bwLoopIndex)) {
                if (newCandidates.size() > 1000) {
                    newCandidates = new ArrayList();
                }
                return this.recoverFrom(loopIndex + 1, newCandidates);
            }
            int exploreDepth = 1;
            do {
                this.resetSGLR(backwardIndex, false);
                newCandidates = this.recoverParse(forwardLinesMax, this.exploredRegionEndOffset, newCandidates);
                ++exploreDepth;
                if (!this.acceptParse()) continue;
                return true;
            } while (exploreDepth < this.settings.getMaxNumberOfRecoverApplicationsLocal() && !this.timelimitExpired() && newCandidates.size() < 1000 && newCandidates.size() > 0);
            if (this.continueSingleTokenBacktracking(bwLoopIndex)) {
                return this.recoverFrom(loopIndex + 1, new ArrayList<RecoverNode>());
            }
            return false;
        }
        return true;
    }

    private ArrayList<RecoverNode> recoverParse(int fwLineMax, int fwTokensSeenMax, ArrayList<RecoverNode> candidates) throws InterruptedException {
        assert (this.mySGLR.activeStacks.size() == 0 || candidates.size() == 0);
        ArrayList<RecoverNode> newCandidates = new ArrayList<RecoverNode>();
        int exploredLinesForward = 0;
        this.mySGLR.setFineGrainedStartLocation(this.getHistory().getTokenIndex());
        do {
            int curTokIndex = this.getHistory().getTokenIndex();
            this.addCurrentCandidates(candidates, curTokIndex);
            this.getHistory().readRecoverToken(this.mySGLR, false);
            if (this.mySGLR.getCurrentToken().getToken() == 10 && curTokIndex > this.getTokensSeenAtLine(this.lineIndexRecovery)) {
                ++exploredLinesForward;
            }
            this.mySGLR.setFinegrainedRecoverMode(this.exploredRegionStartOffset <= curTokIndex);
            this.mySGLR.doParseStep();
            newCandidates.addAll(this.collectNewRecoverCandidates(curTokIndex));
            this.mySGLR.getRecoverStacks().clear();
        } while (!(exploredLinesForward > fwLineMax && !RecoveryConnector.isLayoutCharacter((char)this.mySGLR.getCurrentToken().getToken()) || exploredLinesForward > this.settings.getForwardDistanceLines() && !RecoveryConnector.isLayoutCharacter((char)this.mySGLR.getCurrentToken().getToken()) || this.getHistory().getTokenIndex() > this.exploredRegionEndOffset || this.getHistory().getTokenIndex() > fwTokensSeenMax || this.mySGLR.acceptingStack != null || this.mySGLR.getCurrentToken().getToken() == 256) && this.getHistory().getTokenIndex() < this.settings.getEndOffsetFragment());
        this.mySGLR.setFinegrainedRecoverMode(false);
        return newCandidates;
    }

    private void addCurrentCandidates(ArrayList<RecoverNode> candidates, int tokenPosition) {
        for (RecoverNode recoverNode : candidates) {
            if (tokenPosition != recoverNode.tokensSeen) continue;
            Frame st = this.mySGLR.findStack(this.mySGLR.activeStacks, recoverNode.recoverStack.state);
            if (st != null) {
                for (Link ln : recoverNode.recoverStack.getAllLinks()) {
                    assert (ln.recoverCount > 0 && ln.recoverWeight > 0);
                    st.addLink(ln);
                }
                continue;
            }
            this.mySGLR.addStack(recoverNode.recoverStack);
        }
    }

    private void resetSGLR(int btIndex, boolean keepStacks) {
        this.mySGLR.activeStacks.clear();
        this.mySGLR.acceptingStack = null;
        if (keepStacks) {
            this.mySGLR.activeStacks.addAll(this.getHistory().getLine(btIndex).getStackNodes());
        }
        this.getHistory().setTokenIndex(this.getHistory().getLine(btIndex).getTokensSeen());
    }

    private ArrayList<RecoverNode> collectNewRecoverCandidates(int tokenIndex) {
        assert (tokenIndex >= this.exploredRegionStartOffset || this.mySGLR.getRecoverStacks().isEmpty());
        assert (tokenIndex <= this.exploredRegionEndOffset || this.mySGLR.getRecoverStacks().isEmpty());
        ArrayList<RecoverNode> results = new ArrayList<RecoverNode>();
        for (Frame recoverStack : this.mySGLR.getRecoverStacks()) {
            RecoverNode rn = new RecoverNode(recoverStack, tokenIndex);
            results.add(rn);
        }
        return results;
    }

    private boolean timelimitExpired() {
        return System.currentTimeMillis() - this.recoverStartTime > (long)this.settings.getTimeLimit();
    }

    private ArrayList<RecoverNode> getBackwardRecoverCandidates(int loopIndex) throws InterruptedException {
        int bwIndexPrev = Math.max(0, this.lineIndexRecovery - (int)(this.settings.getBackwardFactor() * (double)(loopIndex - 1)));
        int bwIndex = Math.max(0, this.lineIndexRecovery - (int)(this.settings.getBackwardFactor() * (double)loopIndex));
        assert (bwIndex >= 0);
        assert (bwIndex <= this.lineIndexRecovery);
        assert (bwIndex <= bwIndexPrev);
        if (loopIndex > 0 && bwIndex == bwIndexPrev || this.preceedsErroneousRegion(bwIndexPrev)) {
            return new ArrayList<RecoverNode>();
        }
        this.resetSGLR(bwIndex, true);
        int fwTokensSeenMax = Integer.MAX_VALUE;
        if (bwIndexPrev <= this.getHistory().getIndexLastLine()) {
            fwTokensSeenMax = this.getTokensSeenAtLine(bwIndexPrev);
        }
        ArrayList<RecoverNode> newBranches = this.recoverParse(0, fwTokensSeenMax, new ArrayList<RecoverNode>());
        return newBranches;
    }

    private boolean preceedsErroneousRegion(int lineIndex) {
        return lineIndex <= this.getHistory().getIndexLastLine() && this.getTokensSeenAtLine(lineIndex) <= this.exploredRegionStartOffset;
    }

    private int getTokensSeenAtLine(int lineIndex) {
        return this.getHistory().getLine(lineIndex).getTokensSeen();
    }

    private boolean continueBacktracking(int backwardIndex) {
        assert (backwardIndex <= this.lineIndexRecovery);
        return this.lineIndexRecovery - backwardIndex < this.settings.getBacktrackDistanceLines();
    }

    private boolean continueSingleTokenBacktracking(int backwardIndex) {
        return this.lineIndexRecovery - backwardIndex < this.settings.getBacktrackDistanceLinesSingleToken();
    }

    private boolean acceptParse() throws InterruptedException {
        String parsedFragment = "";
        while (this.mySGLR.activeStacks.size() > 0 && !this.acceptRecovery(parsedFragment) && this.getHistory().getTokenIndex() < this.settings.getEndOffsetFragment()) {
            this.getHistory().readRecoverToken(this.mySGLR, false);
            if (this.getHistory().getTokenIndex() > this.failureOffset) {
                parsedFragment = String.valueOf(parsedFragment) + (char)this.mySGLR.getCurrentToken().getToken();
            }
            this.mySGLR.doParseStep();
        }
        return this.acceptRecovery(parsedFragment);
    }

    private boolean acceptRecovery(String parsedFragmentSinceLastRecovery) {
        if (this.mySGLR.acceptingStack != null) {
            return true;
        }
        if (this.mySGLR.activeStacks.size() > 0 && this.getHistory().getTokenIndex() == this.settings.getEndOffsetFragment()) {
            return true;
        }
        return this.mySGLR.activeStacks.size() > 0 && parsedFragmentSinceLastRecovery.split("\n").length > this.settings.getAcceptDistanceLines() && parsedFragmentSinceLastRecovery.length() > 100 && this.getHistory().getTokenIndex() > this.exploredRegionEndOffset;
    }
}

