/*
 * Decompiled with CFR 0.152.
 */
package org.spoofax.interpreter.util;

import org.spoofax.interpreter.core.Context;
import org.spoofax.interpreter.stratego.CallT;
import org.spoofax.interpreter.stratego.Let;
import org.spoofax.interpreter.stratego.Scope;
import org.spoofax.interpreter.stratego.Strategy;

public class DebugUtil {
    public static boolean debugging = false;
    public static boolean tracing = false;
    public static final int INDENT_STEP = 2;
    private static final char[] indent = new char[2000];

    static {
        int i = 0;
        while (i < indent.length) {
            DebugUtil.indent[i] = 32;
            ++i;
        }
    }

    public static boolean traceReturn(boolean result, Object current, Strategy strategy) {
        if (debugging) {
            String s;
            boolean doIndent = strategy instanceof CallT || strategy instanceof Let || strategy instanceof Scope;
            String string = s = doIndent ? DebugUtil.buildIndent(2).toString() : "";
            if (!result) {
                Strategy.debug(s, "=> failed: ", current, "\n");
            } else {
                Strategy.debug(s, "=> succeeded: ", current, "\n");
            }
        }
        return result;
    }

    public static void debug(Object ... strings) {
        String toPrint = "";
        if (strings.length > 1) {
            Object[] objectArray = strings;
            int n = strings.length;
            int n2 = 0;
            while (n2 < n) {
                Object s = objectArray[n2];
                if (s.getClass().isArray()) {
                    Object[] ss;
                    Object[] objectArray2 = ss = (Object[])s;
                    int n3 = ss.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        Object o = objectArray2[n4];
                        toPrint = String.valueOf(toPrint) + o;
                        ++n4;
                    }
                } else {
                    toPrint = String.valueOf(toPrint) + s;
                }
                ++n2;
            }
        } else {
            toPrint = strings[0].toString();
        }
        if (toPrint.length() < 20000) {
            System.out.println(toPrint);
        }
    }

    public static void setDebug(boolean b) {
        debugging = b;
    }

    public static void bump() {
        Context.indentation += 2;
    }

    public static void unbump() {
        Context.indentation -= 2;
    }

    public static StringBuilder buildIndent(int indentation) {
        StringBuilder b = new StringBuilder(indentation);
        b.append(indent, 0, indentation);
        return b;
    }

    public static boolean isDebugging() {
        return debugging;
    }

    public static void setTracing(boolean enableTracing) {
        tracing = enableTracing;
    }
}

