/*
 * Decompiled with CFR 0.152.
 */
package org.spoofax.interpreter.stratego;

import org.spoofax.interpreter.core.IConstruct;
import org.spoofax.interpreter.core.IContext;
import org.spoofax.interpreter.core.InterpreterException;
import org.spoofax.interpreter.core.Tools;
import org.spoofax.interpreter.library.AbstractPrimitive;
import org.spoofax.interpreter.stratego.CallT;
import org.spoofax.interpreter.stratego.Strategy;
import org.spoofax.interpreter.stratego.StupidFormatter;
import org.spoofax.interpreter.terms.IStrategoAppl;
import org.spoofax.interpreter.terms.IStrategoTerm;
import org.spoofax.interpreter.util.DebugUtil;

public class PrimT
extends Strategy {
    protected String name;
    protected Strategy[] svars;
    protected IStrategoTerm[] tvars;

    public PrimT(String name, Strategy[] svars, IStrategoTerm[] tvars) {
        this.name = name;
        this.svars = svars;
        this.tvars = tvars;
    }

    @Override
    public IConstruct eval(IContext env) throws InterpreterException {
        boolean r;
        AbstractPrimitive prim;
        if (DebugUtil.isDebugging()) {
            PrimT.debug("PrimT.eval() - ", env.current());
        }
        if ((prim = env.lookupOperator(this.name)) == null) {
            throw new InterpreterException("No such function : '" + this.name + "'");
        }
        IStrategoTerm[] vals = new IStrategoTerm[this.tvars.length];
        int i = 0;
        while (i < this.tvars.length) {
            IStrategoAppl t = (IStrategoAppl)this.tvars[i];
            vals[i] = env.lookupVar(Tools.javaStringAt(t, 0));
            if (vals[i] == null) {
                return this.getHook().pop().onFailure(env);
            }
            ++i;
        }
        if (vals.length != prim.getTArity()) {
            throw new InterpreterException("Wrong term arity when calling '" + this.name + "', expected " + prim.getTArity() + " got " + vals.length);
        }
        if (this.svars.length != prim.getSArity()) {
            throw new InterpreterException("Wrong strategy arity when calling '" + this.name + "', expected " + prim.getSArity() + " got " + this.svars.length);
        }
        if (DebugUtil.isDebugging()) {
            CallT.printStrategyCall(this.name, null, this.svars, null, vals);
        }
        if (r = prim.call(env, this.svars, vals)) {
            return this.getHook().pop().onSuccess(env);
        }
        return this.getHook().pop().onFailure(env);
    }

    @Override
    public void prettyPrint(StupidFormatter sf) {
        sf.append("PrimT(\"" + this.name + "\")");
    }
}

