/*
 * Decompiled with CFR 0.152.
 */
package org.spoofax.interpreter.stratego;

import org.spoofax.interpreter.core.IConstruct;
import org.spoofax.interpreter.core.IContext;
import org.spoofax.interpreter.core.InterpreterException;
import org.spoofax.interpreter.core.VarScope;
import org.spoofax.interpreter.stratego.Hook;
import org.spoofax.interpreter.stratego.SDefT;
import org.spoofax.interpreter.stratego.Strategy;
import org.spoofax.interpreter.stratego.StupidFormatter;
import org.spoofax.interpreter.util.DebugUtil;

public class Let
extends Strategy {
    protected SDefT[] defs;
    protected Strategy body;

    public Let(SDefT[] defs2, Strategy body) {
        assert (defs2 != null);
        this.defs = defs2;
        this.body = body;
    }

    @Override
    public IConstruct eval(IContext env) throws InterpreterException {
        if (DebugUtil.isDebugging()) {
            Let.debug("Let.eval() - ", env.current());
        }
        VarScope newScope = new VarScope(env.getVarScope());
        SDefT[] newDefs = new SDefT[this.defs.length];
        int i = 0;
        while (i < this.defs.length) {
            SDefT newDef;
            SDefT def = this.defs[i];
            newDefs[i] = newDef = new SDefT(def.getName(), def.getStrategyParams(), def.getTermParams(), def.getBody(), newScope);
            ++i;
        }
        newScope.addSVars(newDefs);
        env.setVarScope(newScope);
        final Let th = this;
        this.body.getHook().push(new Hook(){

            @Override
            public IConstruct onFailure(IContext env) throws InterpreterException {
                env.popVarScope();
                return th.getHook().pop().onFailure(env);
            }

            @Override
            public IConstruct onSuccess(IContext env) throws InterpreterException {
                env.popVarScope();
                return th.getHook().pop().onSuccess(env);
            }
        });
        return this.body;
    }

    @Override
    public void prettyPrint(StupidFormatter sf) {
        sf.append("Let(\n");
        sf.bump(4);
        sf.append(", " + this.defs + "\n");
        sf.append(", ");
        this.body.prettyPrint(sf);
        sf.append(")");
        sf.unbump(4);
    }
}

