/*
 * Decompiled with CFR 0.152.
 */
package org.spoofax.interpreter.stratego;

import java.io.IOException;
import java.io.InputStream;
import org.spoofax.interpreter.core.IConstruct;
import org.spoofax.interpreter.core.IContext;
import org.spoofax.interpreter.core.InterpreterException;
import org.spoofax.interpreter.library.IOAgent;
import org.spoofax.interpreter.library.ssl.SSLLibrary;
import org.spoofax.interpreter.stratego.Strategy;
import org.spoofax.interpreter.stratego.StupidFormatter;
import org.spoofax.interpreter.terms.IStrategoTerm;
import org.spoofax.terms.io.binary.TermReader;

public class ImportTerm
extends Strategy {
    private final String path;
    private IStrategoTerm result;

    public ImportTerm(String path) {
        this.path = path;
    }

    @Override
    public IConstruct eval(IContext env) throws InterpreterException {
        if (this.result == null) {
            InputStream input = null;
            try {
                try {
                    SSLLibrary op = (SSLLibrary)env.getOperatorRegistry("SSL");
                    IOAgent io = op.getIOAgent();
                    input = io.openInputStream(this.path, true);
                    this.result = new TermReader(env.getFactory()).parseFromStream(input);
                }
                catch (IOException e) {
                    throw new InterpreterException("import-term failed for " + this.path, e);
                }
                catch (RuntimeException e) {
                    throw new InterpreterException("import-term failed for " + this.path, e);
                }
            }
            catch (Throwable throwable) {
                try {
                    if (input != null) {
                        input.close();
                    }
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                if (input != null) {
                    input.close();
                }
            }
            catch (IOException iOException) {}
        }
        env.setCurrent(this.result);
        return this.getHook().pop().onSuccess(env);
    }

    @Override
    public void prettyPrint(StupidFormatter sf) {
        sf.first("ImportTerm(\"");
        sf.append(this.path);
        sf.line("\")");
    }
}

