/*
 * Decompiled with CFR 0.152.
 */
package org.spoofax.interpreter.stratego;

import org.spoofax.interpreter.core.IConstruct;
import org.spoofax.interpreter.core.IContext;
import org.spoofax.interpreter.core.InterpreterException;
import org.spoofax.interpreter.core.Tools;
import org.spoofax.interpreter.library.ssl.SSLLibrary;
import org.spoofax.interpreter.stratego.Strategy;
import org.spoofax.interpreter.stratego.StupidFormatter;
import org.spoofax.interpreter.terms.IStrategoAppl;
import org.spoofax.interpreter.terms.IStrategoConstructor;
import org.spoofax.interpreter.terms.IStrategoInt;
import org.spoofax.interpreter.terms.IStrategoList;
import org.spoofax.interpreter.terms.IStrategoReal;
import org.spoofax.interpreter.terms.IStrategoString;
import org.spoofax.interpreter.terms.IStrategoTerm;
import org.spoofax.interpreter.terms.ITermFactory;
import org.spoofax.interpreter.util.DebugUtil;

public class Build
extends Strategy {
    private IStrategoAppl term;

    public Build(IStrategoAppl t) {
        this.term = t;
    }

    @Override
    public IConstruct eval(IContext env) throws InterpreterException {
        IStrategoTerm t;
        if (DebugUtil.isDebugging()) {
            Build.debug("Build.eval() - ", env.current(), " -> !", this.term);
        }
        if ((t = this.buildTerm(env, this.term)) == null) {
            return this.getHook().pop().onFailure(env);
        }
        env.setCurrent(t);
        return this.getHook().pop().onSuccess(env);
    }

    public IStrategoTerm buildTerm(IContext env, IStrategoAppl t) throws InterpreterException {
        ITermFactory factory = env.getFactory();
        if (Tools.isAnno(t, env)) {
            return this.buildAnno(env, t);
        }
        if (Tools.isOp(t, env)) {
            return this.buildOp(env, t, factory);
        }
        if (Tools.isInt(t, env)) {
            return this.buildInt(t, factory);
        }
        if (Tools.isReal(t, env)) {
            return this.buildReal(t, factory);
        }
        if (Tools.isStr(t, env)) {
            return this.buildStr(t);
        }
        if (Tools.isVar(t, env)) {
            return this.buildVar(env, t);
        }
        if (Tools.isExplode(t, env)) {
            return this.buildExplode(env, t);
        }
        throw new InterpreterException("Unknown build constituent '" + t.getConstructor() + "'");
    }

    private IStrategoTerm buildExplode(IContext env, IStrategoAppl t) throws InterpreterException {
        if (DebugUtil.isDebugging()) {
            Build.debug("buildExplode() : ", t);
        }
        ITermFactory factory = env.getFactory();
        IStrategoAppl ctor = Tools.applAt(t, 0);
        IStrategoAppl args = Tools.applAt(t, 1);
        if (DebugUtil.isDebugging()) {
            Build.debug(" ctor : ", ctor);
        }
        if (DebugUtil.isDebugging()) {
            Build.debug(" args : ", args);
        }
        IStrategoTerm actualCtor = this.buildTerm(env, ctor);
        IStrategoTerm actualArgs = this.buildTerm(env, args);
        if (actualCtor == null || actualArgs == null) {
            return null;
        }
        if (DebugUtil.isDebugging()) {
            Build.debug(" actualCtor : ", actualCtor);
        }
        if (DebugUtil.isDebugging()) {
            Build.debug(" actualArgs : ", actualArgs);
        }
        if (Tools.isTermInt(actualCtor) || Tools.isTermReal(actualCtor)) {
            return actualCtor;
        }
        if (Tools.isTermString(actualCtor)) {
            return this.doBuildExplode(factory, actualCtor, actualArgs);
        }
        if (Tools.isTermList(actualCtor)) {
            return actualArgs;
        }
        return null;
    }

    private IStrategoTerm doBuildExplode(ITermFactory factory, IStrategoTerm actualCtor, IStrategoTerm actualArgs) throws InterpreterException {
        if (!Tools.isTermList(actualArgs)) {
            throw new InterpreterException("Not a list: " + actualArgs);
        }
        String n = ((IStrategoString)actualCtor).stringValue();
        IStrategoTerm[] realArgs = ((IStrategoList)actualArgs).getAllSubterms();
        if (n.equals("")) {
            return factory.makeTuple(realArgs);
        }
        boolean quoted = false;
        if (n.length() > 1 && n.charAt(0) == '\"') {
            n = n.substring(1, n.length() - 1);
            quoted = true;
        }
        if (quoted && realArgs.length == 0) {
            return factory.makeString(n);
        }
        IStrategoConstructor afun = factory.makeConstructor(n, realArgs.length);
        return factory.makeAppl(afun, realArgs);
    }

    private IStrategoTerm buildVar(IContext env, IStrategoAppl t) throws InterpreterException {
        String n = Tools.javaStringAt(t, 0);
        return env.lookupVar(n);
    }

    private IStrategoString buildStr(IStrategoAppl t) {
        IStrategoString x = Tools.stringAt(t, 0);
        return x;
    }

    private IStrategoReal buildReal(IStrategoAppl t, ITermFactory factory) {
        String x = Tools.javaStringAt(t, 0);
        return factory.makeReal(new Double(x));
    }

    private IStrategoInt buildInt(IStrategoAppl t, ITermFactory factory) {
        String x = Tools.javaStringAt(t, 0);
        return factory.makeInt(new Integer(x));
    }

    private IStrategoTerm buildOp(IContext env, IStrategoAppl t, ITermFactory factory) throws InterpreterException {
        String ctr = Tools.javaStringAt(t, 0);
        IStrategoList children = (IStrategoList)t.getSubterm(1);
        if (ctr.length() == 0) {
            return this.buildTuple(env, t);
        }
        if (children.getSubtermCount() == 0 && ctr.equals("Nil")) {
            return this.buildNil(env);
        }
        if (children.getSubtermCount() == 2 && ctr.equals("Cons")) {
            return this.buildCons(env, t, factory);
        }
        return this.buildOp(ctr, env, t, factory);
    }

    private IStrategoList buildNil(IContext env) {
        return env.getFactory().makeList();
    }

    private IStrategoTerm buildOp(String ctr, IContext env, IStrategoAppl t, ITermFactory factory) throws InterpreterException {
        IStrategoList children = (IStrategoList)t.getSubterm(1);
        IStrategoConstructor ctor = factory.makeConstructor(ctr, children.size());
        IStrategoTerm[] kids = new IStrategoTerm[children.size()];
        int i = children.size() - 1;
        while (i >= 0) {
            IStrategoTerm kid = this.buildTerm(env, (IStrategoAppl)children.getSubterm(i));
            if (kid == null) {
                return null;
            }
            kids[i] = kid;
            --i;
        }
        return factory.makeAppl(ctor, kids);
    }

    private IStrategoList buildCons(IContext env, IStrategoAppl t, ITermFactory factory) throws InterpreterException {
        IStrategoList children = (IStrategoList)t.getSubterm(1);
        IStrategoAppl headPattern = (IStrategoAppl)children.getSubterm(0);
        IStrategoAppl tailPattern = (IStrategoAppl)children.getSubterm(1);
        IStrategoList tail = this.buildList(env, tailPattern, factory);
        IStrategoTerm head = this.buildTerm(env, headPattern);
        if (tail == null || head == null) {
            return null;
        }
        return factory.makeListCons(head, tail);
    }

    private IStrategoList buildList(IContext env, IStrategoAppl t, ITermFactory factory) throws InterpreterException {
        IStrategoTerm r;
        if (Tools.isAnno(t, env)) {
            String c = Tools.javaStringAt(t = Tools.applAt(t, 0), 0);
            if (c.equals("Nil")) {
                return this.buildNil(env);
            }
            if (c.equals("Cons")) {
                return this.buildCons(env, t, factory);
            }
        }
        if (Tools.isVar(t, env)) {
            r = this.buildVar(env, t);
            if (r == null) {
                return null;
            }
            if (r.getTermType() == 2) {
                return (IStrategoList)r;
            }
            SSLLibrary.instance(env).getIOAgent().printError("Warning: trying to build list with illegal tail: " + t.toString());
            return null;
        }
        r = this.buildTerm(env, t);
        SSLLibrary.instance(env).getIOAgent().printError("Warning: trying to build list with illegal tail: " + r.toString());
        return null;
    }

    private IStrategoTerm buildTuple(IContext env, IStrategoAppl t) throws InterpreterException {
        IStrategoList children = (IStrategoList)t.getSubterm(1);
        IStrategoTerm[] kids = new IStrategoTerm[children.size()];
        int i = 0;
        while (i < children.size()) {
            kids[i] = this.buildTerm(env, (IStrategoAppl)children.getSubterm(i));
            IStrategoTerm kid = kids[i];
            if (kid == null) {
                return null;
            }
            ++i;
        }
        return env.getFactory().makeTuple(kids);
    }

    private IStrategoTerm buildAnno(IContext env, IStrategoAppl t) throws InterpreterException {
        IStrategoTerm term = this.buildTerm(env, Tools.applAt(t, 0));
        if (term == null) {
            return null;
        }
        IStrategoAppl annos = Tools.applAt(t, 1);
        if (term.getAnnotations().size() == 0 && "Op".equals(annos.getConstructor().getName()) && "Nil".equals(Tools.javaStringAt(annos, 0))) {
            return term;
        }
        IStrategoTerm annoList = this.buildTerm(env, annos);
        if (annoList == null) {
            return null;
        }
        if (annoList.getTermType() != 2) {
            annoList = env.getFactory().makeList(annoList);
        }
        if (annoList.equals(term.getAnnotations())) {
            return term;
        }
        return env.getFactory().annotateTerm(term, (IStrategoList)annoList);
    }

    @Override
    public void prettyPrint(StupidFormatter sf) {
        sf.first("Build(" + this.term.toString() + ")");
    }

    @Override
    public String toString() {
        return "Build(" + this.term.toString() + ")";
    }

    @Override
    protected String getTraceName() {
        return String.valueOf(super.getTraceName()) + "(" + this.term + ")";
    }
}

