/*
 * Decompiled with CFR 0.152.
 */
package org.spoofax.interpreter.library.xml;

import java.util.ArrayList;
import java.util.Stack;
import org.spoofax.interpreter.library.xml.XMLLibrary;
import org.spoofax.interpreter.terms.IStrategoAppl;
import org.spoofax.interpreter.terms.IStrategoConstructor;
import org.spoofax.interpreter.terms.IStrategoList;
import org.spoofax.interpreter.terms.IStrategoString;
import org.spoofax.interpreter.terms.IStrategoTerm;
import org.spoofax.interpreter.terms.ITermFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class StrategoTermBuilder
extends DefaultHandler {
    private final IStrategoConstructor elementCons;
    private final IStrategoConstructor attributeCons;
    private final IStrategoConstructor textCons;
    private final IStrategoConstructor nameCons;
    private final IStrategoConstructor noneCons;
    private final IStrategoConstructor someCons;
    private final ITermFactory factory;
    private final Stack<Element> stack = new Stack();
    private final StringBuilder textBuilder = new StringBuilder();
    private final ArrayList<SAXParseException> errors = new ArrayList();
    private final boolean allowMixedContent;
    private final boolean allowTextContent;
    private final boolean namespaceAware;

    public StrategoTermBuilder(ITermFactory factory, XMLLibrary library) {
        this.factory = factory;
        this.elementCons = factory.makeConstructor("Element", 3);
        this.attributeCons = factory.makeConstructor("Attribute", 2);
        this.textCons = factory.makeConstructor("Text", 1);
        this.nameCons = factory.makeConstructor("Name", 2);
        this.noneCons = factory.makeConstructor("None", 0);
        this.someCons = factory.makeConstructor("Some", 1);
        this.allowMixedContent = library.getAllowMixedContent();
        this.allowTextContent = library.getAllowCharacterContent();
        this.namespaceAware = library.obtainParser().isNamespaceAware();
        this.stack.push(new Element(null, null, null, null));
    }

    public IStrategoTerm getRootElement() {
        return this.stack.peek().childs.get(0);
    }

    public ArrayList<SAXParseException> getErrors() {
        return this.errors;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) {
        if (this.allowMixedContent && this.textBuilder.length() > 0) {
            Element parent = this.stack.peek();
            IStrategoString contents = this.factory.makeString(this.textBuilder.toString());
            IStrategoAppl textNode = this.factory.makeAppl(this.textCons, contents);
            parent.childs.add(textNode);
        }
        this.textBuilder.setLength(0);
        this.stack.push(new Element(uri, localName, qName, this.attributesToStrategoList(attributes)));
    }

    private IStrategoTerm makeName(String uri, String localName, String qName) {
        if (this.namespaceAware) {
            boolean uriIsEmpty = uri.length() == 0;
            IStrategoAppl uriTerm = uriIsEmpty ? this.factory.makeAppl(this.noneCons, new IStrategoTerm[0]) : this.factory.makeAppl(this.someCons, this.factory.makeString(uri));
            IStrategoString localNameTerm = this.factory.makeString(uriIsEmpty ? qName : localName);
            return this.factory.makeAppl(this.nameCons, uriTerm, localNameTerm);
        }
        return this.factory.makeString(qName);
    }

    private IStrategoTerm makeName(Element element) {
        return this.makeName(element.uri, element.localName, element.qName);
    }

    private IStrategoTerm makeName(Attributes attributes, int index) {
        return this.makeName(attributes.getURI(index), attributes.getLocalName(index), attributes.getQName(index));
    }

    private IStrategoList attributesToStrategoList(Attributes attributes) {
        int sz = attributes.getLength();
        IStrategoTerm[] strategoAttributes = new IStrategoTerm[sz];
        int i = 0;
        while (i < sz) {
            IStrategoTerm name = this.makeName(attributes, i);
            IStrategoString value = this.factory.makeString(attributes.getValue(i));
            strategoAttributes[i] = this.factory.makeAppl(this.attributeCons, name, value);
            ++i;
        }
        return this.factory.makeList(strategoAttributes);
    }

    @Override
    public void endElement(String uri, String localName, String qName) {
        Element element = this.stack.pop();
        Element parent = this.stack.peek();
        if ((this.allowMixedContent || this.allowTextContent && element.childs.isEmpty()) && this.textBuilder.length() > 0) {
            IStrategoString contents = this.factory.makeString(this.textBuilder.toString());
            IStrategoAppl textNode = this.factory.makeAppl(this.textCons, contents);
            element.childs.add(textNode);
        }
        this.textBuilder.setLength(0);
        parent.childs.add(this.elementToStrategoTerm(element));
    }

    private IStrategoTerm elementToStrategoTerm(Element element) {
        IStrategoTerm name = this.makeName(element);
        IStrategoTerm childs = this.childsToStrategoList(element.childs);
        return this.factory.makeAppl(this.elementCons, name, element.attributes, childs);
    }

    private IStrategoTerm childsToStrategoList(ArrayList<IStrategoTerm> childs) {
        IStrategoTerm[] strategoChilds = new IStrategoTerm[childs.size()];
        childs.toArray(strategoChilds);
        return this.factory.makeList(strategoChilds);
    }

    @Override
    public void characters(char[] ch, int start2, int length) {
        if (this.allowMixedContent || this.allowTextContent) {
            this.textBuilder.append(ch, start2, length);
        }
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start2, int length) {
        this.characters(ch, start2, length);
    }

    @Override
    public void warning(SAXParseException pe) {
        this.errors.add(pe);
    }

    @Override
    public void error(SAXParseException pe) {
        this.errors.add(pe);
    }

    private static class Element {
        public final String uri;
        public final String localName;
        public final String qName;
        public final IStrategoList attributes;
        public final ArrayList<IStrategoTerm> childs;

        public Element(String uri, String localName, String qName, IStrategoList attributes) {
            this.uri = uri;
            this.localName = localName;
            this.qName = qName;
            this.attributes = attributes;
            this.childs = new ArrayList();
        }
    }
}

