/*
 * Decompiled with CFR 0.152.
 */
package org.spoofax.interpreter.library.ssl;

import java.io.IOException;
import java.io.InputStream;
import org.spoofax.interpreter.core.IContext;
import org.spoofax.interpreter.core.InterpreterException;
import org.spoofax.interpreter.core.Tools;
import org.spoofax.interpreter.library.AbstractPrimitive;
import org.spoofax.interpreter.library.ssl.SSLLibrary;
import org.spoofax.interpreter.stratego.Strategy;
import org.spoofax.interpreter.terms.IStrategoTerm;
import org.spoofax.terms.ParseError;
import org.spoofax.terms.io.binary.TermReader;

public class SSL_read_term_from_stream
extends AbstractPrimitive {
    SSL_read_term_from_stream() {
        super("SSL_read_term_from_stream", 0, 1);
    }

    @Override
    public boolean call(IContext env, Strategy[] svars, IStrategoTerm[] tvars) throws InterpreterException {
        if (!Tools.isTermInt(tvars[0])) {
            return false;
        }
        SSLLibrary or = (SSLLibrary)env.getOperatorRegistry("SSL");
        InputStream is = or.getIOAgent().internalGetInputStream(Tools.asJavaInt(tvars[0]));
        if (is == null) {
            return false;
        }
        try {
            env.setCurrent(new TermReader(env.getFactory()).parseFromStream(is));
        }
        catch (IOException e) {
            or.getIOAgent().printError("SSL_read_term_from_stream: " + e.getMessage());
            return false;
        }
        catch (ParseError e) {
            or.getIOAgent().printError("SSL_read_term_from_stream: " + e.getMessage());
            return false;
        }
        return true;
    }
}

