/*
 * Decompiled with CFR 0.152.
 */
package org.spoofax.interpreter.library.ssl;

import java.util.HashSet;
import java.util.WeakHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.spoofax.interpreter.core.IContext;
import org.spoofax.interpreter.core.InterpreterException;
import org.spoofax.interpreter.library.AbstractPrimitive;
import org.spoofax.interpreter.library.ssl.SSLLibrary;
import org.spoofax.interpreter.stratego.Strategy;
import org.spoofax.interpreter.terms.IStrategoAppl;
import org.spoofax.interpreter.terms.IStrategoString;
import org.spoofax.interpreter.terms.IStrategoTerm;
import org.spoofax.interpreter.terms.ITermFactory;

public class SSL_newname
extends AbstractPrimitive {
    private static final WeakHashMap<IContext, WeakHashMap<String, AtomicInteger>> countersPerContext = new WeakHashMap();
    private final HashSet<String> prefixes = new HashSet();

    SSL_newname() {
        super("SSL_newname", 0, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean call(IContext env, Strategy[] svars, IStrategoTerm[] tvars) throws InterpreterException {
        String prefix;
        IStrategoTerm prefixTerm = tvars[0];
        if (prefixTerm instanceof IStrategoString) {
            IStrategoString str = (IStrategoString)prefixTerm;
            prefix = str.stringValue();
        } else if (prefixTerm instanceof IStrategoAppl) {
            IStrategoAppl appl = (IStrategoAppl)prefixTerm;
            prefix = appl.getConstructor().getName();
        } else {
            SSLLibrary library = (SSLLibrary)env.getOperatorRegistry("SSL");
            return library.get("SSL_new").call(env, svars, tvars);
        }
        ITermFactory factory = env.getFactory();
        WeakHashMap<IContext, WeakHashMap<String, AtomicInteger>> weakHashMap = countersPerContext;
        synchronized (weakHashMap) {
            int counterValue;
            String result;
            IStrategoString resultTerm;
            WeakHashMap<String, AtomicInteger> counters = countersPerContext.get(env);
            if (counters == null) {
                counters = new WeakHashMap();
                countersPerContext.put(env, counters);
            }
            AtomicInteger counter = counters.get(prefix);
            this.prefixes.add(prefix);
            if (counter == null) {
                counter = new AtomicInteger();
                counters.put(prefix, counter);
            }
            do {
                counterValue = this.getNextValue(counter);
            } while ((resultTerm = factory.tryMakeUniqueString(result = String.valueOf(prefix) + counterValue)) == null);
            env.setCurrent(resultTerm);
            return true;
        }
    }

    private int getNextValue(AtomicInteger counter) {
        int result;
        while ((result = counter.getAndIncrement()) < 0) {
            if (!counter.compareAndSet(result, 0)) continue;
            return 0;
        }
        return result;
    }
}

