/*
 * Decompiled with CFR 0.152.
 */
package org.spoofax.interpreter.library.jsglr.origin;

import java.util.Arrays;
import java.util.List;
import org.spoofax.interpreter.core.IContext;
import org.spoofax.interpreter.library.AbstractPrimitive;
import org.spoofax.interpreter.stratego.Strategy;
import org.spoofax.interpreter.terms.IStrategoList;
import org.spoofax.interpreter.terms.IStrategoTerm;
import org.spoofax.jsglr.client.imploder.ImploderAttachment;
import org.spoofax.jsglr.client.imploder.TermTreeFactory;
import org.spoofax.terms.Term;
import org.spoofax.terms.attachments.OriginAttachment;
import org.spoofax.terms.attachments.ParentAttachment;

public class OriginSublistTermPrimitive
extends AbstractPrimitive {
    private static final String NAME = "SSL_EXT_origin_sublist_term";

    public OriginSublistTermPrimitive() {
        super(NAME, 0, 1);
    }

    @Override
    public final boolean call(IContext env, Strategy[] svars, IStrategoTerm[] tvars) {
        IStrategoTerm result;
        if (!Term.isTermList(tvars[0])) {
            return false;
        }
        if (tvars[0].getTermType() != 2) {
            return false;
        }
        IStrategoList list = (IStrategoList)tvars[0];
        if (list.isEmpty()) {
            return false;
        }
        IStrategoTerm[] iStrategoTermArray = list.getAllSubterms();
        int n = iStrategoTermArray.length;
        int n2 = 0;
        while (n2 < n) {
            IStrategoTerm child = iStrategoTermArray[n2];
            if (!ImploderAttachment.hasImploderOrigin(child)) {
                return false;
            }
            ++n2;
        }
        IStrategoTerm firstChildNode = OriginAttachment.tryGetOrigin(list.getSubterm(0));
        IStrategoTerm commonParentList = ParentAttachment.getParent(firstChildNode);
        if (commonParentList == null || !Term.isTermList(commonParentList)) {
            return false;
        }
        List<IStrategoTerm> childNodes = Arrays.asList(commonParentList.getAllSubterms());
        int startIndex = -1;
        int i = 0;
        while (i < childNodes.size()) {
            if (childNodes.get(i) == firstChildNode) {
                startIndex = i;
                break;
            }
            ++i;
        }
        i = 0;
        while (i < list.size()) {
            if (childNodes.size() <= i + startIndex) {
                return false;
            }
            IStrategoTerm childNode = ImploderAttachment.getImploderOrigin(list.getSubterm(i));
            if (childNodes.get(i + startIndex) != childNode) {
                return false;
            }
            ++i;
        }
        IStrategoTerm lastChildNode = ImploderAttachment.getImploderOrigin(list.getSubterm(list.size() - 1));
        if (ParentAttachment.getParent(commonParentList) == null && ParentAttachment.getParent(list) != null) {
            ParentAttachment.putParent(commonParentList, ParentAttachment.get(list));
        }
        if ((result = new TermTreeFactory(env.getFactory()).createSublist((IStrategoList)commonParentList, firstChildNode, lastChildNode)) == null) {
            return false;
        }
        env.setCurrent(result);
        return true;
    }
}

