/*
 * Decompiled with CFR 0.152.
 */
package org.spoofax.interpreter.library.jsglr.origin;

import org.spoofax.interpreter.core.IContext;
import org.spoofax.interpreter.library.AbstractPrimitive;
import org.spoofax.interpreter.stratego.Strategy;
import org.spoofax.interpreter.terms.IStrategoTerm;
import org.spoofax.interpreter.terms.ITermFactory;
import org.spoofax.jsglr.client.imploder.IToken;
import org.spoofax.jsglr.client.imploder.ImploderAttachment;
import org.spoofax.terms.attachments.OriginAttachment;

public class OriginLocationOffsetPrimitive
extends AbstractPrimitive {
    public OriginLocationOffsetPrimitive() {
        super("SSL_EXT_origin_location_offset", 0, 1);
    }

    @Override
    public final boolean call(IContext env, Strategy[] svars, IStrategoTerm[] tvars) {
        ITermFactory factory = env.getFactory();
        IStrategoTerm term = env.current();
        ImploderAttachment imploder = ImploderAttachment.get(term);
        if (imploder == null) {
            IStrategoTerm originTerm = OriginAttachment.getOrigin(term);
            if (originTerm == null) {
                return false;
            }
            imploder = ImploderAttachment.get(originTerm);
        }
        if (imploder == null) {
            return false;
        }
        IToken left = imploder.getLeftToken();
        IToken right = imploder.getRightToken();
        String filename = left.getTokenizer().getFilename();
        if (filename == null) {
            filename = right.getTokenizer().getFilename();
        }
        if (filename == null) {
            filename = ".";
        }
        env.setCurrent(factory.makeTuple(factory.makeString(filename), factory.makeInt(left.getLine()), factory.makeInt(left.getColumn()), factory.makeInt(left.getStartOffset()), factory.makeInt(right.getEndOffset())));
        return true;
    }
}

